#Sandia National Laboratories (SANDIA)

### Experimental Conditions: TGA, DSC
A Netzsch F3 Jupiter using a DSC sample carrier with S-type thermocouples, and a Silicon Carbide furnace was used to conduct Simultaneous Thermal Analysis (TGA + DSC) experiments. Although tests were conducted simultaneously, TGA and DSC measurement data presented here are separated into two files, for consistency with other datasets.

* Heating Rate: 1, 10, or 50 K/min
* Temperature program
  - Initial Temperature: 303.15 K
  - Initial Isotherm: 20 minutes
  - Maximum Temperature: 873.15 K
  - Final Isotherm: None
* Sample mass: 2-6 mg
* Sample geometry: powdered
* Calibration type: The instrument is calibrated at least once per 6 months, or sooner (as needed), using melting point standards for both temperature and DSC sensitivity.  The calibration standards used are In, Sn, Bi, Zn, Al, Ag, Au, and Ni.
* Crucible
  - Type: Al2O3
  - Volume: 85 µL
  - Diameter: None
  - Mass: None
  - Lid: False
  - Note: None
* Carrier Gas
  - Type: Argon
  - Flow rate: 100 ml/min
  - Note: ultra-high-purity argon  (0% O2)
* Instrument
  - Type: Netzsch F3 Jupiter
  - Note: Simultaneous Thermal Analysis (TGA + DSC), measurement data presented as two separated files, using a DSC sample carrier with S-type thermocouples, Silicon Carbide furnace

| Test Name | Heating Rate (K/min)|  Initial Sample Mass (mg) | 
| --------- | :---------: | :------------------------: |
|SANDIA\_STA\_Ar\_1K\_1 | 1  | 4.903|  
|SANDIA\_STA\_Ar\_10K\_1 | 10 | 4.917|  
|SANDIA\_STA\_Ar\_10K\_2 | 10 | 4.828|  
|SANDIA\_STA\_Ar\_50K\_1 | 50 | 5.376|  
|SANDIA\_STA\_Ar\_50K\_2 | 50 | 4.835| 
|SANDIA\_STA\_Ar\_50K\_3 | 50 | 4.682|  




