# The National Institute of Standards and Technology (NIST)

### Experimental Conditions: TGA
A Netzsch F1 Jupiter was used to conduct Thermogravimetric Analysis (TGA) experiments. 

* Heating Rate: 10 K/min
* Temperature program
  - Initial Temperature: 300 K
  - Initial Isotherm: 1500 s (hold at 300 K for 1500 s)  
  - Maximum Temperature: 1000 K
  - Final Isotherm: None
* Sample mass: 5 to 6.5 mg
* Sample geometry: Powdered
* Calibration type: Before each experiment, a baseline test was performed using an empty crucible. Temperature/Heat flow calibration were performed every 6 months using a set of 5 [6?] reference materials with melting temperatures between 60-820 C
* Crucible
  - Type: Pt-Rh
  - Volume: 85 µL
  - Diameter: 6.8 mm
  - Mass: None
  - Lid: True
  - Note: Pt-Rh crucibles (outer diameter 6.8mm / volume 85µL) with a lid ( a small hole in the lid allowed for gaseous decomposition products to escape).
* Carrier Gas
  - Type: Nitrogen
  - Flow rate: 50 ml/min
  - Note: Ultra High Purity (UHP) Nitrogen
* Instrument
  - Type: Netzsch F1 Jupiter
  - Note: None
| Test Name | O2 volume % |  Initial Sample Mass (mg) | 
| --------- | :---------: | :------------------------: |
|NIST\_STA\_N2\_10K\_1 | 0 | 4.990|  
|NIST\_STA\_N2\_10K\_2 | 0 | 5.863|  
|NIST\_STA\_N2\_10K\_3 | 0 | 6.099|  
|NIST\_STA\_N2\_10K\_4 | 0 | 6.334|  
|NIST\_STA\_N2\_10K\_5 | 0 | 5.560|  


### Experimental Conditions: MCC
An FAA microscale combustion calorimeter was used to conduct MCC experiments.  At the end of each test, the residual solid yield was measured and found to be consistent with the TGA results. 

* Heating Rate: 60 K/min
* Temperature program (Pyrolyzer)
  - Initial temperature 348 K
  - Isotherm: 600s (hold at 348K for 600s)  
  - Maximum Temperature 873 K
* Combustor Temperature: 1173K
* Sample mass: 4-7 mg
* Sample geometry: Powdered
* Calibration type: Before each experiment, a baseline test was performed using a 3-4 mg sample of polystyrene as a reference. O2 sensor/flow calibration was checked at the start of each day of testing, Temperature calibration was performed every 6 months.
* Crucible type: ceramic crucibles (outer diameter 5.74mm / volume 71µL) with no lid
* Pyrolyzer Carrier Gas
  - Ultra High Purity (UHP) Nitrogen 
  - N2 Flow rate = 80 ml/min
* Combustor Carrier Gas
  - Ultra High Purity (UHP) Oxygen + Pyrolyzer Carrier Gas
  - O2 Flow rate = 20 ml/min


### Experimental Conditions, Cone calorimeter
* Extraction flow rate: 24L/s
* Sample Surface Area: 0.01 m2 (nominal)
* Sample holder dimensions:
    - Square pan: 106mm x 106mm x 25mm
    - Retainer frame: None
    - Retaining grid: None
* Backing Insulation: One inch thick (2.54 cm) layer of Kaowool Blanket. Density = 128 kg/m3. Thermal Conductivity 0.06, 0.012, 0.21, 0.3 W/m-K (at 260, 538, 816, 1093 C, respectively)
* Thermocouple location: None

###### Test Heating Conditions  
|Test Name | Heat Flux (kW/m2)| Heater Temperature (K) 
|----------|:------:| :---: |
|NIST\_Cone\_25KW\_1 | 25| 900? |
|NIST\_Cone\_25KW\_2 | 25| 900? |
|NIST\_Cone\_25KW\_2 | 25| 900? |

