# Laboratoire Central de la Préfecture de Police (LCPP)

### Experimental Conditions, TGA
Four repeats were performed but only the best three were selected. 
Pleae note: TGA Measurements received from LCPP from tests conducted at 10 and 20 K/min appear to be identical. LCPP has been contacted in an effort to resolve this issue: when possible, the offending dataset will be edited accordingly.

* Heating Rate: 2.5, 5, 10, or 20 K/min
* Temperature program
  - Initial Temperature: 300 K
  - Initial Isotherm: 300 s
  - Maximum Temperature: 800 K
  - Final Isotherm: 300 s
* Sample mass: ~4 mg
* Sample geometry: powdered
* Calibration type: A full calibration is performed every two years. Last calibration carried out in December 2017 using onset temperatures of Indium and Aluminium and verification of calibration on CaCO3. Periodical verification of the equipment: every 6 months or before any extensive use of the equipment.
* Crucible
  - Type: Alumina
  - Volume: 70 µL
  - Diameter: None
  - Mass: ~170 mg
  - Lid: None
  - Note: None
* Carrier Gas
  - Type: Nitrogen
  - Flow rate: 80 ml/min
  - Note: None
* Instrument
  - Type: None [?]
  - Note: None
 
| Test Name | Heating Rate (K/min) |  Initial Sample Mass (mg) | 
| --------- | :----: | :------------------------:|
|LCPP\_STA\_N2\_2.5K\_1 |  2.5  | 3.00723|  
|LCPP\_STA\_N2\_2.5K\_2 |  2.5  | 3.12678|  
|LCPP\_STA\_N2\_2.5K\_3 |  2.5  | 3.18254|  
|LCPP\_STA\_N2\_5K\_1  |  5  | 3.09388|  
|LCPP\_STA\_N2\_5K\_2  |  5  | 3.0349|  
|LCPP\_STA\_N2\_5K\_3  |  5  | 3.06027|  
|LCPP\_STA\_N2\_10K\_1 |  10  | 3.01186|  
|LCPP\_STA\_N2\_10K\_2 |  10  | 2.94796|  
|LCPP\_STA\_N2\_10K\_3 |  10  | 3.15013|  
|LCPP\_STA\_N2\_15K\_1 |  15  | 3.04276|  
|LCPP\_STA\_N2\_15K\_2 |  15  | 3.12389|  
|LCPP\_STA\_N2\_15K\_3 |  15  | 3.06913|  
|LCPP\_STA\_N2\_20K\_1 |  20  | 3.01186|  
|LCPP\_STA\_N2\_20K\_2 |  20  | 2.94796|  
|LCPP\_STA\_N2\_20K\_3 |  20  | 3.15013|  



### Experimental Conditions, Cone calorimeter
For three out of four samples for each heat flux, no mass information is available. Measurements of temperature and HRR for these 6 samples are however made available for estimation of HRR repeatability. A single thermocouple was used to measure temperature at the center of the sample back surface. Prior to testing, samples were wrapped with aluminum foil. Distance between sample side and the conical heater resistance = 25 mm. 

* Extraction flow rate: 24L/s
* Sample holder dimensions:
    - Square pan: 106mm x 106mm x 25mm [?]
    - Retainer frame: None
    - Retaining grid: None
* Backing Insulation: Monolith substrates (3x, each 12 mm thick) [material type/thermal conductivity / thermophysical properties?]
* Thermocouple location: Central on sample back surface
    
###### Test Heating Conditions  
|Test Name | Heat Flux (kW/m2)| Heater Temperature (K) 
|----------|:------:| :---: |
|LCPP\_Cone\_25kW\_1 | 25| 310?  |
|LCPP\_Cone\_25kW\_2 | 25| 310?|
|LCPP\_Cone\_25kW\_3 | 25| 310?|
|LCPP\_Cone\_25kW\_4 | 25| 310?|
|LCPP\_Cone\_65kW\_1 | 65| 559? | 
|LCPP\_Cone\_65kW\_2 | 65| 559?|
|LCPP\_Cone\_65kW\_3 | 65| 558? | 
|LCPP\_Cone\_65kW\_4 | 65| 558?|



