# GIDAZE+ 
GIDAZE+ is made of three groups working together: Imperial College London, Universidad de Cantabria and Reax Engineering.

### Experimental Conditions: TGA, DSC
A Netzsch F3 Jupiter was used to conduct Simultaneous Thermal Analysis (TGA + DSC) experiments. Although tests were conducted simultaneously, TGA and DSC measurement data presented here are separated into two files, for consistency with other datasets.
Note: DSC heat flow data was rescaled (multiplied by -1)such that endothermic heat flow events are positive (endo up)

* Heating Rate: 10 K/min
* Temperature program
  - Initial Temperature: 303 K
  - Initial Isotherm: None
  - Maximum Temperature: 923 K
  - Final Isotherm: None
* Sample mass: 2-6 mg
* Sample geometry: powdered
* Calibration type: Before each experiment, a baseline test was performed using an empty crucible. Internal mass calibration are performed before each experimental campaigns. [Heat/Temperature calibration?]
* Crucible 
  - Type: Al2O3 [Not Pt or Al for DSC?]
  - Volume: 85 µL
  - Diameter: 6.8 mm
  - Mass: None
  - Lid: None
  - Note: None
* Carrier Gas
  - Type: Air, low oxygen (10.5%), Nitrogen
  - Flow rate: 60  ml/min
  - Note: Air (21% O2), 10.5% O2, or Pure Nitrogen (0% O2)
* Instrument
  - Type: Netzsch F3 Jupiter
  - Note: Simultaneous Thermal Analysis (TGA + DSC), measurement data presented as two separated files

| Test Name | O2 volume % |  Initial Sample Mass (mg) | 
| --------- | :---------: | :------------------------: |
|GIDAZE+\_STA\_N2\_10K\_1 | 0 | 2.015|  
|GIDAZE+\_STA\_N2\_10K\_2 | 0 | 1.978|  
|GIDAZE+\_STA\_O2\-10\_10K\_1 | 10.5 | 1.976|  
|GIDAZE+\_STA\_O2\-10\_10K\_2 | 10.5 | 1.993|  
|GIDAZE+\_STA\_O2\-21\_10K\_1 | 21 | 2.04| 
|GIDAZE+\_STA\_O2\-21\_10K\_2 | 21 | 2.039|  
|GIDAZE+\_STA\_O2\-21\_10K\_3 | 21 | 6.044|  
|GIDAZE+\_STA\_O2\-21\_10K\_4 | 21 | 6.019|   


### Experimental Conditions: Cone Calorimeter
Cone calorimeter tests were conducted using a configuration similar to the Torero et. al. ('Determination of the flammability properties of polymeric materials: A novel method', March 2011, Polymer Degradation and Stability 96(3):314-319).

* Extraction flow rate: 24L/s
* Sample Surface Area: 0.01 m2 (nominal)
* Sample holder dimensions:
    - A block of aluminium (100 mm x 100 mm x 8 mm thick) at the rear face of the PMMA.
    - Retainer frame/grid: [None?]
* Backing Insulation: Ceramic fibre backing pad at the sides of the sample and the aluminum block and at the rear face of the aluminum block [thickness / thermal properties of insulation?]
* Thermocouple location:
    - T_1: central on sample exposed surface
    - T_3: in-depth at 3 mm
    - T_4: central on sample back surface

###### Test Heating Conditions  
|Test Name | Heat Flux (kW/m2)| Heater Temperature (K) 
|----------|:------:| :---: |
|GIDAZE+_Cone_25kW_1| 25 | 589 |
|GIDAZE+_Cone_25kW_2| 25 | 589 |
|GIDAZE+_Cone_65kW_1| 65 | 844 |
|GIDAZE+_Cone_65kW_2| 65 | 844 |

### Experimental Conditions: Fire Propagation Apparatus (FPA)
Although Mass and Temperature were measured simultaneously during experiments, measurement data presented here are separated into two files because they were recorded at different frequencies. These tests were conducted in air, not in an anaerobic environment.

* Extraction flow rate: 150L/s
* Inlet Air Supply 3.3 l/s
* Sample Surface Area: ?
* Sample holder dimensions:
    - Following the standard ISO 12136
    - Retainer frame/grid: [None?]
* Backing Insulation: Calcium silicate board.[thickness / thermal properties of insulation?]
* Thermocouple location:
    - Back Surface Temperature: central on sample back surface

###### Test Heating Conditions  
|Test Name | Heat Flux (kW/m2)| Heater Temperature (K) 
|----------|:------:| :---: |
|GIDAZE+_FPA_25kW_1| 25 | ? |
|GIDAZE+_FPA_25kW_2| 25 | ? |
|GIDAZE+_FPA_65kW_1| 65 | ? |
|GIDAZE+_FPA_65kW_2| 65 | ? |
