# UL's Fire Safety Research Insistute (FSRI)

### Experimental Conditions: TGA and DSC
A Netzsch STA 449 F3 Jupiter was used to conduct Thermogravimetric Analysis (TGA) and Differential Scanning Calorimetry (DSC) experiments. 

* Heating Rate: 3, 10, and 30 K/min
* Temperature program
  - Initial Temperature: 323 K
  - Initial Isotherm: 600 s (hold at 323 K for 600 s)  
  - Maximum Temperature: 823 K
  - Final Isotherm: 300 s (hold at 823 K for 300 s)
* Sample mass: 4.0 +/- 0.1 mg
* Sample geometry: Powdered (Supplied by NIST)
* Calibration type: Before each experiment, a baseline test was performed using an empty crucible. Temperature/Heat flow calibration were performed every 200 temperature cycles using a set of 6 reference materials with melting temperatures between 60-820 C (biphenyl, benzoic acid, KClO4, Ag2SO4, CsCl, BaCO3)
* Crucible
  - Type: Pt-Rh
  - Volume: 85 µL
  - Diameter: 6.6 mm
  - Mass: None
  - Lid: True
  - Note: Pt-Rh crucibles (outer diameter 6.6mm / volume 85µL) with a pierced lid.
* Carrier Gas
  - Type: Nitrogen
  - Flow rate: 70 mL/min (20 mL/min protective, 50 mL/min purge)
  - Note: Ultra High Purity (UHP) Nitrogen
* Instrument
  - Type: Netzsch F3 Jupiter
  - Note: Heat flow rate data provided on an initial mass basis
| Test Name		| O2 volume %	|  Initial Sample Mass (mg)	| 
| ---------		| :---------:	| :------------------------:	|
|FSRI\_STA\_N2\_3K\_1 	| 0 		| 3.98				|  
|FSRI\_STA\_N2\_10K\_1 	| 0 		| 3.97				|  
|FSRI\_STA\_N2\_10K\_2 	| 0 		| 3.98				|  
|FSRI\_STA\_N2\_10K\_3 	| 0 		| 3.94				|  
|FSRI\_STA\_N2\_30K\_1 	| 0 		| 4.06				| 
|FSRI\_STA\_N2\_30K\_2 	| 0 		| 4.09				| 
|FSRI\_STA\_N2\_30K\_3 	| 0 		| 3.95				| 

### Experimental Conditions: Specific Heat Capacity by ASTM E 1269 (Sapphire Method)
A Netzsch STA 449 F3 Jupiter was used to conduct Differential Scanning Calorimetry (DSC) experiments consistent with ASTM E1269.

* Heating Rate: 20 K/min
* Temperature program
  - Initial Temperature: 323 K
  - Initial Isotherm: 600 s (hold at 323 K for 600 s)  
  - Maximum Temperature: 823 K
  - Final Isotherm: 300 s (hold at 823 K for 300 s)
* Sample mass: 4.0 +/- 0.1 mg
* Sample geometry: Powdered (Supplied by NIST)
* Calibration type: Temperature calibration performed with 6 reference materials. Sapphire (Al2O3) standard tested for sensible enthalpy heat flow calibration.
* Crucible
  - Type: Pt-Rh
  - Volume: 85 µL
  - Diameter: 6.6 mm
  - Mass: None
  - Lid: True
  - Note: Pt-Rh crucibles (outer diameter 6.6mm / volume 85µL) with a pierced lid.
* Carrier Gas
  - Type: Nitrogen
  - Flow rate: 70 mL/min (20 mL/min protective, 50 mL/min purge)
  - Note: Ultra High Purity (UHP) Nitrogen
* Instrument
  - Type: Netzsch F3 Jupiter
  - Note: Heat flow rate data on an initial mass basis are provided. To determine heat capacity, the heat flow rate must be divided by the instantaneous heating rate. Heat capacities determined through this method are only accurate in temperature ranges where no mass loss occurs. 
| Test Name			| O2 volume %	|  Initial Sample Mass (mg)	| 
| ---------			| :---------:	| :------------------------:	|
|FSRI\_STA\_N2\_20K\_1 		| 0 		| 3.99				|  
|FSRI\_STA\_N2\_20K\_2 		| 0 		| 3.96				|  
|FSRI\_STA\_N2\_20K\_3 		| 0 		| 4.00				|

