# Aalto University

### Test Summary
Standard cone calorimeter and gasification tests were carried out on 100 x 100 x 6 mm slabs of cast black PMMA  in a controlled atmosphere cone calorimeter manufactured by Concept Equipment (UK). Before each test, the temperature of the conical heater element was calibrated such that All tests were carried out under the heat flux of 65 kW/m2.   

Sample back surface temperature was measured with three K-type thermocouples (locations described below). In the cone experiments 1 and 3, and gasification experiment 1, back surface temperatures 2, 2 and 3, respectively, were abandoned due to poor installation of the thermocouple. In the cone calorimeter test 3, back surface temperature 1 signal was not acquired between 24 and 80 seconds due to a thermocouple failure. The thermocouple however resumed correct operation and gave consistent data for the rest of the test, so back surface temperature 1 is assumed as a linear ramp between the available valid measurement points.  

The sample was observed to be entirely consumed in all of the experiments, leading to a zero final mass. The measured load cell signals during the experiments are not fully consistent with the weighed sample masses. The likely reason is that the thermocouples, connected to the sample, caused slight tension to the sample and affected the load cell signal. In the reported experimental data, the initial mass is assumed as the weighed value. The final value might thus be nonzero for the reasons above.



#### Experimental Conditions
* Sample Surface Area: 0.01 m2 (nominal)
* Sample holder dimensions:
    - Square pan otherwise complying with specifications of standard ISO 5660-1, except for a 1 cm hole drilled in a corner next to the handle to allow for the passage of thermocouples below the sample.
    - Retainer frame: None
* Backing Insulation: two layers (each ~1 cm thick) of ceramic wool with a density of 65 kg/m3 as specified in standard ISO 5660-1 [1]; its other thermal properties are not known.
* Thermocouple locations 
    - Sample back surface temperature was measured with three K-type thermocouples. Thermocouples were run between the wool layers to the measurement locations, where they were punctured through the upper wool layer to its top surface. 
    - Back Surface Temperature 1: 15 mm away from center
    - Back Surface Temperature 2: sample center point 
    - Back Surface Temperature 3: 15 mm away from center (opposite direction of TC1)

##### Cone calorimeter
* Extraction flow rate: 24L/s
* Sample chamber doors were closed
* Air intake grilles on the bottom of the chamber were kept open.
* Note: For consistency with datasets submitted by other institutions, cone calorimeter HRR measurements submitted by Aalto have been normalized by sample surface area (nominal) to provide HRR per unit area [kW/m2]


##### Gasification Tests
* Extraction flow rate: 7.7 L/s
* Sample chamber doors were closed
* Air intake grilles were closed and sealed; only outlet was through the cone heater to the chimney.
* Chamber was purged with nitrogen before the test and during the tests (4 l/s). Oxygen concentration inside the chamber was measured to be < 1 % vol.



###### Sample Mass and Test Heating Conditions  
|Test Name | Initial sample mass (g)| Heat Flux (kW/m2)| Heater Temperature (K) |
|----------|:------:| :---: | :---: |
|Aalto\_Cone\_65kW\_1 | 71.76 | 65 | 734  |
|Aalto\_Cone\_65kW\_2 | 71.67 | 65 | 734  |
|Aalto\_Cone\_65kW\_3 | 72.88 | 65 | 734  |
|Aalto\_Gasification\_65kW\_1 | 71.08 | 65 | 739 |
|Aalto\_Gasification\_65kW\_2 | 73.89 | 65 | 739 |
|Aalto\_Gasification\_65kW\_3 | 69.76 | 65 | 739 |
