# objects ----
data <- read.csv("bilzingsleben-data.csv")

# convert to centimeters:
data[, c("xmin", "ymin", "zmin", "zmax")] <- data[, c("xmin", "ymin", "zmin", "zmax")] * 100

# excavation units ----
units <- read.csv("bilzingsleben-excavation-units.csv")
units <- units[ - which(units$square =="" & units$coord ==""), ]

units$coord.y <- NA

for(x in seq(1, nrow(units), 2)){
  units[x, ]$coord.y <- units[x + 1, 2]
}

units <- units[seq(1, nrow(units), 2), ]

units <- apply(units, 2, function(x) gsub("[xy]:", "", x))
units <- apply(units, 2, function(x) gsub(":", "", x))
units <- apply(units, 2, function(x) gsub(" ", "", x))

units <- data.frame(units)

units$square <- gsub("F\\.", "", units$square)
units$square <- gsub("([0-9]*).*", "\\1", units$square)

units$xmin <-   as.numeric(gsub("(.*)-.*", "\\1", units$coord))
units$xmax <-   as.numeric(gsub(".*-(.*)", "\\1", units$coord))
units$ymin <-   as.numeric(gsub("(.*)-.*", "\\1", units$coord.y))
units$ymax <-   as.numeric(gsub(".*-(.*)", "\\1", units$coord.y))

units$x <- apply(units, 1, function(i) median(as.numeric(c( i[4], i[5]) ), na.rm = F)   )
units$y <- apply(units, 1, function(i) median(as.numeric(c( i[6], i[7]) ), na.rm = F)   )

units <- units[order(units$square),]

# ambiguous duplicated squares are eliminated:
units <- units[ ! units$square %in% unique(units$square[duplicated(units$square)]), ]

# merge objects and location ----
data$square <- gsub("([0-9]*).*","\\1", data$id)
colnames(data)[2:3] <- c("xmin.raw", "ymin.raw")

data <- merge(data[, c("id", "xmin.raw", "ymin.raw", "zmin", "zmax", "layer", "object_type", "object_subpart", "subpart", "object_is.fragment", "object_sheded", "object_side", "object_length", "object_thickness", "object_refits.set", "Origin.of.coordinates", "square")], 
               units[, c("square", "xmin", "xmax", "ymin", "ymax")],
               by="square", all.x = T)

# Vollbrecht (2000.) assigned random coordinates to some objects; we attribute ranges of coordinates to these objects, and random values are attributed each time archeoViz is launched.
# Selection of the objects for which Vollbrecht measured the coordinates OR that are located in ambiguous squares

sel <- data$Origin.of.coordinates == "coordinates measured from square plan" | 
         data$square %in% unique(units$square[duplicated(units$square)])

data[which(sel), ]$xmax <- NA
data[which(sel), ]$ymax <- NA
data[which(sel), ]$xmin <- data[which(sel), ]$xmin.raw 
data[which(sel), ]$ymin <- data[which(sel), ]$ymin.raw 

data <- data[, c("id", "xmin", "xmax", "ymin", "ymax", "zmin", "zmax", "layer", "object_type", "object_subpart", "subpart", "object_is.fragment", "object_sheded", "object_side", "object_length", "object_thickness", "object_refits.set", "square")]

write.csv(data, "bilzingsleben.csv",  row.names = F)


# Map timeline chart ---

library(ggplot2) 
timeline <- read.csv("bilzingsleben-timeline.csv")
timeline <- merge(units, timeline[, c("square", "year")], by="square")

ggplot(timeline, aes(xmin = xmin, xmax=xmax, ymin=ymin, ymax=ymax,
                     label=square, fill = factor(year) )) +
  theme_light() +
  geom_rect(color ="black", linewidth=.1)  + 
  geom_text(aes(x=x, y=y), size= 1) +
  ylab("") + xlab("") +
  scale_fill_viridis_d("Year", begin = .2) +
  scale_x_continuous(breaks = seq(530 +150, 7460 +150, 150) , labels = 1:47 ) + #seq(560, 7460, 150)
  scale_y_continuous(breaks = seq(900, 6300, 150) +75, labels = 1:37 ) +
  coord_fixed()  +
  theme(panel.grid.minor.x = element_blank() ,
        panel.grid.minor.y = element_blank(),
        axis.text = element_text(size = 5),
        legend.text = element_text(size=6) )

ggsave("bilzingsleben-timeline-map.jpg", width = 8, height =6)
