

! CVS:  $Id: gases_ckd.F90,v 1.1 2003/11/07 22:18:38 norm Exp $
! CVS:  $Name:  $

module gases_ckd
!Correlated-k coefficients and routines for calculating gaseous absorption per Fu, 1991
!The hk* variables are the weights for the k-distribution intervals for each band
!The variable fk1o3 is the ozone absorption coefficient in (atm-cm)^-1
!The various c2h2o, c3h2o, c10ch4, c10n2o etc. variables are coefficients
!required to calculate the absorption coefficient in (atm-cm)^-1.

   use kinds, only: int_kind, dbl_kind
   implicit none
   private

   public :: &
    gases          & ! Subroutine for calculation gas transmission
   ,pscale

!This include file contains all the correlated-k coefficient
!values and associated parameters, (including some public ones)
!CVS: $Id: gases_ckd_data.h,v 1.4 2006/11/16 18:43:30 norm Exp $
!CVS: $Name:  $
   
   public ::&
      MB             & ! Total number of spectral intervals
     ,MBS            & ! Number of shortwave spectral intervals
     ,MBIR           & ! Number of longwave spectral intervals
     ,KG             & ! Number of k samples per spectral interval
     ,STANPS         & ! Reference pressures for shortwave correlated-k tabulation
     ,STANPIR          ! Reference pressures for longwave correlated-k tabulation
   
   ! Number of bands
   integer(kind=int_kind), parameter ::  &
      MB =   18      & ! Total number of spectral bands
     ,MBS =   6      & ! Number of shortwave spectral bands 
     ,MBIR = 12        ! Number of longwave spectral bands

   ! Number of k samples per band
   integer(kind=int_kind), parameter, dimension(MB) ::  &
      KG = (/  10,   8,  12,   7,  12,   5,   & ! Number of k samples per shortwave band
                2,   3,   4,   4,   3,   5,   & ! Number of k samples per longwave band
                2,  10,  12,   7,   7,   8  /)

   ! Pressure and temperature resolution for k tabulations
   integer(kind=int_kind), parameter :: &
      NUMPS =  11    & ! Number of pressures in the shortwave k tabulations
     ,NUMTS =   3    & ! Number of temperatures in the shortwave k tabulations
     ,NUMPIR = 19    & ! Number of pressures in the longwave k tabulations
     ,NUMTIR =  3    & ! Number of temperatures in the longwave k tabulations
     ,T_1 = 1        & !
     ,T_2 = 2        & !
     ,T_3 = 3

   ! Reference pressures in hPa for correlated-k tabulations
   real(kind=dbl_kind), parameter, dimension(NUMPS) ::  &
      STANPS = (/ 10.0, 15.8, 25.1, 39.8, 63.1, 100.0,  &
                158.0, 251.0, 398.0, 631.0, 1000.0 /)

   real(kind=dbl_kind), parameter, dimension(NUMPIR) ::       &
      STANPIR = (/ 0.251, 0.398, 0.631, 1.000, 1.58, 2.51,    &
                   3.98, 6.31, 10.0, 15.8, 25.1, 39.8, 63.1,  &
                 100.0, 158.0, 251.0, 398.0, 631.0, 1000.0 /)

 
   integer (kind=int_kind):: &
      i,j,k

   real (kind=dbl_kind), dimension(KG(1))  :: hk1       ! 50000 - 14500 cm^-1
   real (kind=dbl_kind), dimension(KG(2))  :: hk2       ! 14500 -  7700 cm^-1
   real (kind=dbl_kind), dimension(KG(3))  :: hk3       !  7700 -  5250 cm^-1
   real (kind=dbl_kind), dimension(KG(4))  :: hk4       !  5250 -  4000 cm^-1
   real (kind=dbl_kind), dimension(KG(5))  :: hk5       !  4000 -  2850 cm^-1
   real (kind=dbl_kind), dimension(KG(6))  :: hk6       !  2850 -  2500 cm^-1
   real (kind=dbl_kind), dimension(KG(7))  :: hk7       !  2200 -  1900 cm^-1
   real (kind=dbl_kind), dimension(KG(8))  :: hk8       !  1900 -  1700 cm^-1
   real (kind=dbl_kind), dimension(KG(9))  :: hk9       !  1700 -  1400 cm^-1
   real (kind=dbl_kind), dimension(KG(10)) :: hk10      !  1400 -  1250 cm^-1
   real (kind=dbl_kind), dimension(KG(11)) :: hk11      !  1250 -  1100 cm^-1
   real (kind=dbl_kind), dimension(KG(12)) :: hk12      !  1100 -   980 cm^-1
   real (kind=dbl_kind), dimension(KG(13)) :: hk13      !   980 -   800 cm^-1
   real (kind=dbl_kind), dimension(KG(14)) :: hk14      !   800 -   670 cm^-1
   real (kind=dbl_kind), dimension(KG(15)) :: hk15      !   670 -   540 cm^-1
   real (kind=dbl_kind), dimension(KG(16)) :: hk16      !   540 -   400 cm^-1
   real (kind=dbl_kind), dimension(KG(17)) :: hk17      !   400 -   280 cm^-1
   real (kind=dbl_kind), dimension(KG(18)) :: hk18      !   280 -     0 cm^-1


   real (kind=dbl_kind), dimension(KG(1))  :: fk1o3
   real (kind=dbl_kind), dimension(NUMTS, NUMPS, KG(2)) :: c2h2o
   real (kind=dbl_kind), dimension(NUMTS, NUMPS, KG(3)) :: c3h2o
   real (kind=dbl_kind), dimension(NUMTS, NUMPS, KG(4)) :: c4h2o
   real (kind=dbl_kind), dimension(NUMTS, NUMPS, KG(5)) :: c5h2o
   real (kind=dbl_kind), dimension(NUMTS, NUMPS, KG(6)) :: c6h2o
   
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(7)) :: c7h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(8)) :: c8h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(9)) :: c9h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(10)) :: c10h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR)     ::  c10ch4
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR)     ::  c10n2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(11)) :: c11h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR)     ::  c11ch4
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR)     ::  c11n2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(12)) :: c12o3
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR)     ::  c12h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(13)) :: c13h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(14)) :: c14hca
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(14)) :: c14hcb
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(15)) :: c15hca
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(15)) :: c15hcb
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(16)) :: c16h2o     
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(17)) :: c17h2o
   real (kind=dbl_kind), dimension(NUMTIR, NUMPIR, KG(18)) :: c18h2o
   
   data hk1 /.24,.16,.24,.28,.03,.016,.01,.008,.008,.008 /
   data hk2 /.71,.11,.06,.06,.04,.016,.0034,.0006/
   data hk3 /.34,.11,.1  ,.09,.12 ,.1 , .06,.04,.026,.01,.0035,.0005/
   data hk4 /.52,.21,.11,.1,.04,.015,.005/
   data hk5 /.13,.14,.13 ,.16 ,.18 ,.14 , .07,.02,.016,.008,.004,.002 /
   data hk6 /.3,.2,.2,.2,.1/
   data hk7 /0.7,0.3/
   data hk8 /0.2,0.7,0.1 /
   data hk9 /0.22,0.51,0.22,0.05/
   data hk10 /0.28,0.42,0.25,0.05 /
   data hk11 /0.80,0.15,0.05 /
   data hk12 /0.45,0.30,0.2,0.04,0.01/
   data hk13 / 0.95, 0.05 /
   data hk14 / .3,.3,.2,.12,.06,.012,.004,.0025,.0011,.0004 /
   data hk15 /.24,.36,.18,.1,.05,.02,.016,.012,.01,.006,.0039,.0021/
   data hk16 /.12,.24,.24,.20,.12,.06,.02/
   data hk17 /.12,.26,.22,.20,.10,.085,.015/
   data hk18 /.10,.1,.2,.25,.2,.1,.03,.02/
      
   data fk1o3 /.2204e-08,.1207e-01,.4537e-01,.1032e+00,.1740e+00,     &
               .1210e+01,.7367e+01,.2050e+02,.8100e+02,.2410e+03/


   data((c2h2o(T_1,j,i),i=1,KG(2)),j=1,NUMPS) / &
   -0.1735E+02,-0.1407E+02,-0.1268E+02,-0.1131E+02,-0.9261E+01,-0.6666E+01,-0.3937E+01,-0.5448E+00,-0.1690E+02,-0.1365E+02, &
   -0.1232E+02,-0.1101E+02,-0.9058E+01,-0.6574E+01,-0.3914E+01,-0.5529E+00,-0.1643E+02,-0.1323E+02,-0.1195E+02,-0.1068E+02, &
   -0.8840E+01,-0.6475E+01,-0.3889E+01,-0.6143E+00,-0.1598E+02,-0.1282E+02,-0.1157E+02,-0.1035E+02,-0.8598E+01,-0.6339E+01, &
   -0.3848E+01,-0.6636E+00,-0.1551E+02,-0.1241E+02,-0.1119E+02,-0.1001E+02,-0.8342E+01,-0.6178E+01,-0.3788E+01,-0.8181E+00, &
   -0.1506E+02,-0.1201E+02,-0.1082E+02,-0.9692E+01,-0.8073E+01,-0.6017E+01,-0.3703E+01,-0.9003E+00,-0.1446E+02,-0.1154E+02, &
   -0.1042E+02,-0.9332E+01,-0.7810E+01,-0.5846E+01,-0.3576E+01,-0.1083E+01,-0.1394E+02,-0.1112E+02,-0.1005E+02,-0.8992E+01, &
   -0.7548E+01,-0.5674E+01,-0.3477E+01,-0.1266E+01,-0.1351E+02,-0.1076E+02,-0.9722E+01,-0.8702E+01,-0.7334E+01,-0.5531E+01, &
   -0.3401E+01,-0.1524E+01,-0.1311E+02,-0.1044E+02,-0.9422E+01,-0.8423E+01,-0.7117E+01,-0.5383E+01,-0.3410E+01,-0.1785E+01, &
   -0.1274E+02,-0.1015E+02,-0.9162E+01,-0.8190E+01,-0.6949E+01,-0.5236E+01,-0.3477E+01,-0.2082E+01 /
   
   data((c2h2o(T_2,j,i),i=1,KG(2)),j=1,NUMPS) / &
    0.2407E-02, 0.2847E-02, 0.3768E-02, 0.4626E-02, 0.5631E-02, 0.4542E-02, 0.3475E-02,-0.3085E-02, 0.2428E-02, 0.2805E-02, &
    0.3412E-02, 0.3893E-02, 0.4773E-02, 0.3998E-02, 0.2742E-02,-0.2556E-02, 0.2428E-02, 0.2721E-02, 0.3077E-02, 0.3161E-02, &
    0.4019E-02, 0.3224E-02, 0.2512E-02,-0.1884E-02, 0.2449E-02, 0.2617E-02, 0.2763E-02, 0.2658E-02, 0.3286E-02, 0.2617E-02, &
    0.1989E-02,-0.1740E-02, 0.2512E-02, 0.2470E-02, 0.2470E-02, 0.2282E-02, 0.2512E-02, 0.1926E-02, 0.1465E-02,-0.2612E-02, &
    0.2554E-02, 0.2303E-02, 0.2303E-02, 0.1842E-02, 0.2030E-02, 0.1340E-02, 0.1068E-02,-0.1413E-02, 0.2449E-02, 0.2198E-02, &
    0.2030E-02, 0.1465E-02, 0.1528E-02, 0.9838E-03, 0.1005E-02,-0.1099E-02, 0.2868E-02, 0.2198E-02, 0.1968E-02, 0.1382E-02, &
    0.1172E-02, 0.5652E-03, 0.6070E-03,-0.1662E-02, 0.3077E-02, 0.2219E-02, 0.1800E-02, 0.1277E-02, 0.1005E-02, 0.3349E-03, &
    0.2512E-03,-0.1195E-02, 0.3182E-02, 0.2219E-02, 0.1758E-02, 0.1172E-02, 0.7326E-03, 0.4815E-03, 0.6280E-04,-0.1880E-02, &
    0.3265E-02, 0.2114E-02, 0.1696E-02, 0.1298E-02, 0.4187E-03, 0.4187E-03,-0.3768E-03,-0.1467E-02 /
   
   data((c2h2o(T_3,j,i),i=1,KG(2)),j=1,NUMPS) / &
   -0.1180E-04,-0.1294E-04,-0.1142E-04,-0.7232E-05,-0.8754E-05,-0.1484E-04,-0.8373E-05, 0.1028E-04,-0.1218E-04,-0.1142E-04, &
   -0.9515E-05,-0.1522E-05,-0.9134E-05,-0.1484E-04,-0.3425E-05, 0.1142E-06,-0.1294E-04,-0.9895E-05,-0.7231E-05,-0.4187E-05, &
   -0.7612E-05,-0.3806E-05, 0.1522E-05,-0.3882E-05,-0.1256E-04,-0.8754E-05,-0.7612E-05,-0.6470E-05,-0.4948E-05,-0.3425E-05, &
    0.4948E-05,-0.1054E-04,-0.1370E-04,-0.6089E-05,-0.8373E-05,-0.5709E-05,-0.3045E-05,-0.3806E-05, 0.5328E-05, 0.8678E-05, &
   -0.1370E-04,-0.6851E-05,-0.8373E-05,-0.1522E-05,-0.3425E-05, 0.0000E+00, 0.1256E-04,-0.1572E-04,-0.1484E-04,-0.7231E-05, &
   -0.7992E-05,-0.4567E-05,-0.2664E-05,-0.3807E-06,-0.1522E-05, 0.2169E-05,-0.1713E-04,-0.9515E-05,-0.6089E-05,-0.6851E-05, &
   -0.3045E-05,-0.1142E-05, 0.1903E-05, 0.9363E-05,-0.1560E-04,-0.9134E-05,-0.5328E-05,-0.4948E-05, 0.0000E+00, 0.7611E-06, &
   -0.6851E-05, 0.1252E-04,-0.1522E-04,-0.8373E-05,-0.6089E-05,-0.6089E-05,-0.3805E-06,-0.1142E-05,-0.3807E-06, 0.2512E-05, &
   -0.1599E-04,-0.7231E-05,-0.5709E-05,-0.4567E-05, 0.1522E-05,-0.2284E-05,-0.3941E-10, 0.5290E-05 /
   
   
   data((c3h2o(T_1,j,i),i=1,KG(3)),j=1,NUMPS) / &
   -0.1900E+02,-0.1515E+02,-0.1344E+02,-0.1224E+02,-0.1081E+02,-0.9337E+01,-0.7965E+01,-0.6585E+01,-0.4578E+01,-0.2247E+01, &
    0.1747E+00, 0.3083E+01,-0.1854E+02,-0.1471E+02,-0.1300E+02,-0.1181E+02,-0.1039E+02,-0.8927E+01,-0.7576E+01,-0.6238E+01, &
   -0.4317E+01,-0.2119E+01, 0.1888E+00, 0.3033E+01,-0.1808E+02,-0.1426E+02,-0.1257E+02,-0.1137E+02,-0.9966E+01,-0.8513E+01, &
   -0.7177E+01,-0.5885E+01,-0.4053E+01,-0.1977E+01, 0.2245E+00, 0.3005E+01,-0.1763E+02,-0.1381E+02,-0.1213E+02,-0.1094E+02, &
   -0.9542E+01,-0.8094E+01,-0.6779E+01,-0.5524E+01,-0.3788E+01,-0.1796E+01, 0.2961E+00, 0.2828E+01,-0.1716E+02,-0.1337E+02, &
   -0.1170E+02,-0.1051E+02,-0.9116E+01,-0.7677E+01,-0.6381E+01,-0.5153E+01,-0.3493E+01,-0.1607E+01, 0.3850E+00, 0.2660E+01, &
   -0.1670E+02,-0.1295E+02,-0.1127E+02,-0.1008E+02,-0.8690E+01,-0.7265E+01,-0.5991E+01,-0.4799E+01,-0.3212E+01,-0.1438E+01, &
    0.4582E+00, 0.2588E+01,-0.1596E+02,-0.1231E+02,-0.1067E+02,-0.9501E+01,-0.8151E+01,-0.6793E+01,-0.5588E+01,-0.4458E+01, &
   -0.2940E+01,-0.1257E+01, 0.4888E+00, 0.2260E+01,-0.1530E+02,-0.1184E+02,-0.1017E+02,-0.8992E+01,-0.7661E+01,-0.6369E+01, &
   -0.5213E+01,-0.4145E+01,-0.2701E+01,-0.1108E+01, 0.4239E+00, 0.1974E+01,-0.1481E+02,-0.1144E+02,-0.9756E+01,-0.8573E+01, &
   -0.7255E+01,-0.5994E+01,-0.4868E+01,-0.3829E+01,-0.2485E+01,-0.9738E+00, 0.3343E+00, 0.1667E+01,-0.1439E+02,-0.1108E+02, &
   -0.9360E+01,-0.8183E+01,-0.6885E+01,-0.5646E+01,-0.4559E+01,-0.3555E+01,-0.2314E+01,-0.8904E+00, 0.2169E+00, 0.1289E+01, &
   -0.1402E+02,-0.1073E+02,-0.8987E+01,-0.7817E+01,-0.6551E+01,-0.5335E+01,-0.4278E+01,-0.3316E+01,-0.2147E+01,-0.8695E+00, &
    0.1587E-01, 0.8658E+00 /
   
   data((c3h2o(T_2,j,i),i=1,KG(3)),j=1,NUMPS) / &
    0.1132E-01, 0.8855E-02, 0.6698E-02, 0.5296E-02, 0.4396E-02, 0.3370E-02, 0.3245E-02, 0.4145E-02, 0.4731E-02, 0.4756E-02, &
    0.3116E-02,-0.2763E-02, 0.1135E-01, 0.8917E-02, 0.6657E-02, 0.5170E-02, 0.4207E-02, 0.3056E-02, 0.2868E-02, 0.3433E-02, &
    0.3726E-02, 0.4109E-02, 0.2836E-02,-0.3119E-02, 0.1135E-01, 0.8980E-02, 0.6615E-02, 0.5045E-02, 0.4061E-02, 0.2847E-02, &
    0.2491E-02, 0.2847E-02, 0.2910E-02, 0.2671E-02, 0.2396E-02,-0.3245E-02, 0.1135E-01, 0.9043E-02, 0.6594E-02, 0.4940E-02, &
    0.3914E-02, 0.2638E-02, 0.2156E-02, 0.2261E-02, 0.2051E-02, 0.1978E-02, 0.1566E-02,-0.3203E-02, 0.1139E-01, 0.9085E-02, &
    0.6531E-02, 0.4835E-02, 0.3768E-02, 0.2428E-02, 0.1842E-02, 0.1612E-02, 0.1591E-02, 0.1279E-02, 0.7201E-03,-0.2763E-02, &
    0.1143E-01, 0.9085E-02, 0.6447E-02, 0.4752E-02, 0.3684E-02, 0.2261E-02, 0.1570E-02, 0.1235E-02, 0.1151E-02, 0.7243E-03, &
    0.6489E-04,-0.2240E-02, 0.1135E-01, 0.9001E-02, 0.5694E-02, 0.4438E-02, 0.3412E-02, 0.1968E-02, 0.1235E-02, 0.9420E-03, &
    0.8792E-03, 0.5045E-03,-0.1821E-03,-0.1936E-02, 0.1174E-01, 0.9273E-02, 0.5882E-02, 0.4689E-02, 0.3454E-02, 0.1947E-02, &
    0.1151E-02, 0.6070E-03, 0.6698E-03, 0.9420E-04,-0.6740E-03,-0.2707E-02, 0.1218E-01, 0.9336E-02, 0.6050E-02, 0.4731E-02, &
    0.3475E-02, 0.1863E-02, 0.1151E-02, 0.4605E-03, 0.3768E-03,-0.1214E-03,-0.4396E-03,-0.1903E-02, 0.1235E-01, 0.9294E-02, &
    0.6029E-02, 0.4584E-02, 0.3370E-02, 0.1800E-02, 0.1068E-02, 0.2303E-03, 0.1675E-03,-0.4501E-03,-0.7571E-03,-0.1149E-02, &
    0.1233E-01, 0.9315E-02, 0.6029E-02, 0.4438E-02, 0.3203E-02, 0.1842E-02, 0.9629E-03, 0.0000E+00,-0.2198E-03,-0.5338E-03, &
   -0.9721E-03,-0.7661E-03 /
   
   data((c3h2o(T_3,j,i),i=1,KG(3)),j=1,NUMPS) / &
   -0.3692E-04,-0.3844E-04,-0.2588E-04,-0.1180E-04,-0.1066E-04,-0.3426E-05,-0.2664E-05, 0.7611E-06, 0.6089E-05,-0.4568E-06, &
   -0.2077E-04,-0.1142E-04,-0.3730E-04,-0.3806E-04,-0.2360E-04,-0.1256E-04,-0.1180E-04,-0.4567E-05,-0.3425E-05,-0.2284E-05, &
   -0.1522E-05,-0.4225E-05,-0.9940E-05,-0.4187E-05,-0.3501E-04,-0.3844E-04,-0.2131E-04,-0.1256E-04,-0.9896E-05,-0.3806E-05, &
   -0.4186E-05, 0.7612E-06,-0.1903E-05, 0.4110E-05, 0.1789E-05,-0.2169E-04,-0.3425E-04,-0.3882E-04,-0.1941E-04,-0.1294E-04, &
   -0.9515E-05,-0.4567E-05,-0.4186E-05, 0.1522E-05,-0.4187E-10, 0.4605E-05,-0.2588E-05, 0.6470E-05,-0.3501E-04,-0.3730E-04, &
   -0.1751E-04,-0.1332E-04,-0.1066E-04,-0.3806E-05,-0.4567E-05,-0.1142E-05,-0.3045E-05, 0.1104E-05,-0.1058E-04, 0.2816E-04, &
   -0.3578E-04,-0.3501E-04,-0.1751E-04,-0.1332E-04,-0.1218E-04,-0.3806E-05,-0.3425E-05,-0.3806E-06,-0.4187E-05,-0.6090E-06, &
   -0.6965E-05,-0.3463E-04,-0.3578E-04,-0.3349E-04,-0.1675E-04,-0.9895E-05,-0.9515E-05,-0.6090E-05,-0.6470E-05,-0.3807E-06, &
   -0.5328E-05,-0.4186E-06,-0.3996E-05, 0.2074E-04,-0.3540E-04,-0.3083E-04,-0.1789E-04,-0.9896E-05,-0.1104E-04,-0.6470E-05, &
   -0.5709E-05, 0.3425E-05,-0.4567E-05, 0.3463E-05, 0.5633E-05,-0.3159E-05,-0.3730E-04,-0.2740E-04,-0.1484E-04,-0.1066E-04, &
   -0.1142E-04,-0.6470E-05,-0.6470E-05, 0.1522E-05,-0.1522E-05,-0.3045E-05, 0.3197E-05,-0.1039E-04,-0.3425E-04,-0.2284E-04, &
   -0.1370E-04,-0.1028E-04,-0.1104E-04,-0.8373E-05,-0.4948E-05, 0.1903E-05,-0.7612E-06,-0.1104E-05, 0.2455E-05,-0.3805E-07, &
   -0.3235E-04,-0.2093E-04,-0.1294E-04,-0.1142E-04,-0.1180E-04,-0.6851E-05,-0.3045E-05,-0.7611E-06, 0.1256E-05,-0.7231E-06, &
    0.9924E-05, 0.3578E-05 /
   
   
   data((c4h2o(T_1,j,i),i=1,KG(4)),j=1,NUMPS) / &
   -0.1722E+02,-0.1402E+02,-0.1202E+02,-0.1001E+02,-0.7702E+01,-0.5273E+01,-0.6530E+00,-0.1677E+02,-0.1359E+02,-0.1164E+02, &
   -0.9662E+01,-0.7419E+01,-0.5001E+01,-0.6040E+00,-0.1630E+02,-0.1316E+02,-0.1125E+02,-0.9303E+01,-0.7092E+01,-0.4750E+01, &
   -0.5715E+00,-0.1584E+02,-0.1274E+02,-0.1086E+02,-0.8939E+01,-0.6751E+01,-0.4458E+01,-0.4928E+00,-0.1538E+02,-0.1232E+02, &
   -0.1048E+02,-0.8579E+01,-0.6399E+01,-0.4191E+01,-0.4683E+00,-0.1493E+02,-0.1192E+02,-0.1011E+02,-0.8241E+01,-0.6065E+01, &
   -0.3910E+01,-0.4310E+00,-0.1440E+02,-0.1145E+02,-0.9643E+01,-0.7873E+01,-0.5710E+01,-0.3668E+01,-0.3304E+00,-0.1391E+02, &
   -0.1104E+02,-0.9238E+01,-0.7479E+01,-0.5367E+01,-0.3387E+01,-0.3604E+00,-0.1348E+02,-0.1069E+02,-0.8918E+01,-0.7122E+01, &
   -0.5086E+01,-0.3152E+01,-0.3030E+00,-0.1310E+02,-0.1037E+02,-0.8626E+01,-0.6790E+01,-0.4815E+01,-0.2945E+01,-0.4789E+00, &
   -0.1275E+02,-0.1011E+02,-0.8347E+01,-0.6484E+01,-0.4584E+01,-0.2788E+01,-0.5807E+00 /
   
   data((c4h2o(T_2,j,i),i=1,KG(4)),j=1,NUMPS) / &
    0.7934E-02, 0.9231E-02, 0.1005E-01, 0.9043E-02, 0.8164E-02, 0.8980E-02, 0.6403E-02, 0.7954E-02, 0.9169E-02, 0.9797E-02, &
    0.8687E-02, 0.7724E-02, 0.7954E-02, 0.6652E-02, 0.7954E-02, 0.9043E-02, 0.9608E-02, 0.8499E-02, 0.7347E-02, 0.7473E-02, &
    0.6382E-02, 0.7996E-02, 0.8980E-02, 0.9378E-02, 0.8289E-02, 0.7264E-02, 0.6594E-02, 0.6674E-02, 0.8059E-02, 0.8938E-02, &
    0.9294E-02, 0.8227E-02, 0.7201E-02, 0.6678E-02, 0.7032E-02, 0.8122E-02, 0.8896E-02, 0.9189E-02, 0.8038E-02, 0.7033E-02, &
    0.5987E-02, 0.5475E-02, 0.8268E-02, 0.9064E-02, 0.8792E-02, 0.7975E-02, 0.6573E-02, 0.5087E-02, 0.4657E-02, 0.8541E-02, &
    0.8980E-02, 0.9085E-02, 0.7996E-02, 0.6133E-02, 0.4501E-02, 0.3860E-02, 0.8813E-02, 0.9043E-02, 0.9294E-02, 0.8122E-02, &
    0.5861E-02, 0.4354E-02, 0.3964E-02, 0.8875E-02, 0.8834E-02, 0.9797E-02, 0.8164E-02, 0.5463E-02, 0.4417E-02, 0.3270E-02, &
    0.8938E-02, 0.8771E-02, 0.1005E-01, 0.8247E-02, 0.5589E-02, 0.4835E-02, 0.3033E-02 /
   
   data((c4h2o(T_3,j,i),i=1,KG(4)),j=1,NUMPS) / &
   -0.1484E-04,-0.2169E-04,-0.2436E-04,-0.2588E-04,-0.1142E-04,-0.1142E-05,-0.1519E-04,-0.1522E-04,-0.2055E-04,-0.2131E-04, &
   -0.2398E-04,-0.4948E-05,-0.1675E-04,-0.3593E-04,-0.1522E-04,-0.2055E-04,-0.1865E-04,-0.2207E-04,-0.4948E-05,-0.1180E-04, &
   -0.1237E-04,-0.1598E-04,-0.2017E-04,-0.1903E-04,-0.2284E-04,-0.1028E-04,-0.1865E-04,-0.2381E-04,-0.1713E-04,-0.2017E-04, &
   -0.1827E-04,-0.2169E-04,-0.1218E-04,-0.9515E-05,-0.2415E-04,-0.1827E-04,-0.2093E-04,-0.1637E-04,-0.1827E-04,-0.9134E-05, &
   -0.8373E-05,-0.1243E-04,-0.1560E-04,-0.1865E-04,-0.1599E-04,-0.1256E-04,-0.1066E-04,-0.1142E-05,-0.2181E-04,-0.1675E-04, &
   -0.1560E-04,-0.1522E-04,-0.1675E-04,-0.1865E-04,-0.1865E-04,-0.9522E-05,-0.1332E-04,-0.1370E-04,-0.1446E-04,-0.2055E-04, &
   -0.1142E-04,-0.2512E-04,-0.3343E-04,-0.1294E-04,-0.1294E-04,-0.1751E-04,-0.2512E-04,-0.1560E-04,-0.2854E-04,-0.7003E-05, &
   -0.8753E-05,-0.1028E-04,-0.1751E-04,-0.2512E-04,-0.1713E-04,-0.1713E-04,-0.1245E-04 /
   
   
   data((c5h2o(T_1,j,i),i=1,KG(5)),j=1,NUMPS) / &
   -0.1499E+02,-0.1267E+02,-0.1118E+02,-0.9696E+01,-0.7992E+01,-0.6323E+01,-0.4414E+01,-0.2961E+01,-0.1715E+01,-0.1406E+00, &
    0.1612E+01, 0.3689E+01,-0.1454E+02,-0.1223E+02,-0.1075E+02,-0.9277E+01,-0.7576E+01,-0.5915E+01,-0.4043E+01,-0.2630E+01, &
   -0.1449E+01, 0.2314E-01, 0.1708E+01, 0.3744E+01,-0.1408E+02,-0.1178E+02,-0.1031E+02,-0.8851E+01,-0.7154E+01,-0.5503E+01, &
   -0.3666E+01,-0.2288E+01,-0.1141E+01, 0.2772E+00, 0.1819E+01, 0.3788E+01,-0.1363E+02,-0.1134E+02,-0.9876E+01,-0.8423E+01, &
   -0.6733E+01,-0.5091E+01,-0.3286E+01,-0.1938E+01,-0.8649E+00, 0.5349E+00, 0.1969E+01, 0.3795E+01,-0.1318E+02,-0.1091E+02, &
   -0.9452E+01,-0.8004E+01,-0.6309E+01,-0.4677E+01,-0.2904E+01,-0.1595E+01,-0.5641E+00, 0.7592E+00, 0.2109E+01, 0.3783E+01, &
   -0.1275E+02,-0.1048E+02,-0.9028E+01,-0.7585E+01,-0.5892E+01,-0.4267E+01,-0.2524E+01,-0.1274E+01,-0.2782E+00, 0.9376E+00, &
    0.2257E+01, 0.3714E+01,-0.1180E+02,-0.9887E+01,-0.8492E+01,-0.7014E+01,-0.5390E+01,-0.3834E+01,-0.2156E+01,-0.9775E+00, &
   -0.3129E-01, 0.1151E+01, 0.2330E+01, 0.3592E+01,-0.1114E+02,-0.9367E+01,-0.8002E+01,-0.6514E+01,-0.4928E+01,-0.3435E+01, &
   -0.1835E+01,-0.7064E+00, 0.2153E+00, 0.1309E+01, 0.2422E+01, 0.3488E+01,-0.1074E+02,-0.8941E+01,-0.7582E+01,-0.6116E+01, &
   -0.4536E+01,-0.3072E+01,-0.1521E+01,-0.4651E+00, 0.4053E+00, 0.1465E+01, 0.2374E+01, 0.3260E+01,-0.1041E+02,-0.8545E+01, &
   -0.7180E+01,-0.5745E+01,-0.4177E+01,-0.2735E+01,-0.1245E+01,-0.2356E+00, 0.5786E+00, 0.1516E+01, 0.2263E+01, 0.3074E+01, &
   -0.1008E+02,-0.8149E+01,-0.6804E+01,-0.5409E+01,-0.3855E+01,-0.2427E+01,-0.9857E+00,-0.4939E-01, 0.7060E+00, 0.1483E+01, &
    0.2159E+01, 0.2745E+01 /
   
   data((c5h2o(T_2,j,i),i=1,KG(5)),j=1,NUMPS) / &
    0.9985E-02, 0.8373E-02, 0.7431E-02, 0.6866E-02, 0.4584E-02, 0.2952E-02, 0.3098E-02, 0.3768E-02, 0.4013E-02, 0.3960E-02, &
    0.3228E-02, 0.3203E-02, 0.1007E-01, 0.8436E-02, 0.7368E-02, 0.6657E-02, 0.4375E-02, 0.2617E-02, 0.2742E-02, 0.3286E-02, &
    0.3192E-02, 0.2992E-02, 0.2612E-02, 0.1968E-02, 0.1019E-01, 0.8457E-02, 0.7264E-02, 0.6426E-02, 0.4187E-02, 0.2365E-02, &
    0.2324E-02, 0.2614E-02, 0.2736E-02, 0.2068E-02, 0.2085E-02, 0.1005E-02, 0.1028E-01, 0.8478E-02, 0.7138E-02, 0.6259E-02, &
    0.3998E-02, 0.2156E-02, 0.1926E-02, 0.1953E-02, 0.2250E-02, 0.1844E-02, 0.1869E-02,-0.6489E-03, 0.1030E-01, 0.8478E-02, &
    0.7033E-02, 0.6112E-02, 0.3852E-02, 0.1989E-02, 0.1716E-02, 0.1763E-02, 0.1432E-02, 0.1193E-02, 0.1306E-02,-0.5861E-03, &
    0.1042E-01, 0.8499E-02, 0.6887E-02, 0.5987E-02, 0.3768E-02, 0.1800E-02, 0.1549E-02, 0.1712E-02, 0.1287E-02, 0.7389E-03, &
    0.7222E-03,-0.1130E-02, 0.8227E-02, 0.7201E-02, 0.6866E-02, 0.5903E-02, 0.3412E-02, 0.1591E-02, 0.1402E-02, 0.1346E-02, &
    0.1041E-02, 0.8185E-03, 0.3349E-03,-0.4815E-03, 0.8268E-02, 0.6992E-02, 0.7159E-02, 0.6384E-02, 0.3286E-02, 0.1591E-02, &
    0.1271E-02, 0.1202E-02, 0.9187E-03, 0.6531E-03,-0.4187E-03,-0.7954E-03, 0.8478E-02, 0.7159E-02, 0.7117E-02, 0.6447E-02, &
    0.3349E-02, 0.1528E-02, 0.9964E-03, 0.9210E-03, 0.6112E-03, 0.6259E-03,-0.3768E-03,-0.1298E-02, 0.8520E-02, 0.7075E-02, &
    0.7096E-02, 0.6405E-02, 0.3245E-02, 0.1528E-02, 0.1011E-02, 0.7877E-03, 0.7536E-03, 0.9001E-04,-0.6719E-03,-0.1026E-02, &
    0.8561E-02, 0.6950E-02, 0.7033E-02, 0.6280E-02, 0.2993E-02, 0.1528E-02, 0.6698E-03, 0.5847E-03, 0.2847E-03,-0.6280E-04, &
   -0.9420E-03,-0.1444E-02 /
   
   data((c5h2o(T_3,j,i),i=1,KG(5)),j=1,NUMPS) / &
   -0.1408E-04,-0.2664E-04,-0.1180E-04,-0.1903E-04,-0.9515E-05, 0.3806E-06,-0.6851E-05,-0.3806E-05,-0.4834E-05,-0.3239E-05, &
   -0.2284E-05,-0.1028E-04,-0.1484E-04,-0.2550E-04,-0.1142E-04,-0.1827E-04,-0.9515E-05, 0.3805E-06,-0.4948E-05, 0.3806E-06, &
   -0.2664E-06, 0.1058E-04,-0.1012E-04,-0.1142E-04,-0.1560E-04,-0.2512E-04,-0.1256E-04,-0.1865E-04,-0.9134E-05, 0.1142E-05, &
   -0.3425E-05, 0.2474E-05,-0.9781E-05,-0.1519E-05,-0.7916E-05,-0.1294E-04,-0.1560E-04,-0.2474E-04,-0.1180E-04,-0.2017E-04, &
   -0.7992E-05, 0.3805E-06,-0.2283E-05,-0.4453E-05,-0.1180E-05,-0.5138E-05,-0.4453E-05,-0.3425E-05,-0.1522E-04,-0.2550E-04, &
   -0.9896E-05,-0.1903E-04,-0.9134E-05,-0.1142E-05,-0.7611E-06,-0.5252E-05,-0.4567E-06,-0.4643E-05,-0.4567E-06,-0.4567E-05, &
   -0.1294E-04,-0.2512E-04,-0.1028E-04,-0.2055E-04,-0.9896E-05,-0.4567E-05,-0.2284E-05,-0.5100E-05,-0.4339E-06,-0.9515E-06, &
   -0.1252E-04,-0.7612E-06,-0.2246E-04,-0.1370E-04,-0.1066E-04,-0.1598E-04,-0.8754E-05,-0.5328E-05,-0.6622E-05,-0.5138E-05, &
   -0.8754E-07,-0.9515E-06, 0.6090E-05, 0.4187E-05,-0.3463E-04,-0.1599E-04,-0.1218E-04,-0.2093E-04,-0.9515E-05,-0.4567E-05, &
   -0.1104E-05,-0.1903E-05,-0.1488E-05,-0.3730E-05,-0.4567E-05, 0.3045E-05,-0.3463E-04,-0.1675E-04,-0.1294E-04,-0.1979E-04, &
   -0.1066E-04,-0.4187E-05,-0.4034E-05,-0.2893E-05,-0.2588E-05,-0.9401E-05, 0.2284E-05, 0.3045E-05,-0.2778E-04,-0.1522E-04, &
   -0.1560E-04,-0.1751E-04,-0.1256E-04,-0.5709E-05,-0.2474E-05,-0.2577E-05,-0.2284E-05,-0.4187E-06, 0.7650E-05,-0.3425E-05, &
   -0.3083E-04,-0.1827E-04,-0.1370E-04,-0.1751E-04,-0.1104E-04,-0.9515E-05,-0.6318E-05,-0.4358E-05,-0.7613E-07, 0.4643E-05, &
    0.4415E-05, 0.1028E-04 /
   
   
   data((c6h2o(T_1,j,i),i=1,KG(6)),j=1,NUMPS) / &
   -0.1905E+02,-0.1602E+02,-0.1472E+02,-0.1307E+02,-0.1024E+02,-0.1823E+02,-0.1555E+02,-0.1427E+02,-0.1266E+02,-0.9938E+01, &
   -0.1749E+02,-0.1508E+02,-0.1381E+02,-0.1225E+02,-0.9641E+01,-0.1684E+02,-0.1462E+02,-0.1337E+02,-0.1185E+02,-0.9367E+01, &
   -0.1630E+02,-0.1417E+02,-0.1294E+02,-0.1145E+02,-0.9123E+01,-0.1578E+02,-0.1373E+02,-0.1251E+02,-0.1108E+02,-0.8881E+01, &
   -0.1517E+02,-0.1327E+02,-0.1209E+02,-0.1072E+02,-0.8653E+01,-0.1463E+02,-0.1284E+02,-0.1169E+02,-0.1040E+02,-0.8453E+01, &
   -0.1421E+02,-0.1244E+02,-0.1133E+02,-0.1014E+02,-0.8312E+01,-0.1382E+02,-0.1207E+02,-0.1100E+02,-0.9887E+01,-0.8220E+01, &
   -0.1348E+02,-0.1173E+02,-0.1071E+02,-0.9685E+01,-0.8220E+01 /
   
   data((c6h2o(T_2,j,i),i=1,KG(6)),j=1,NUMPS) / &
    0.1024E-01, 0.1842E-02, 0.6908E-03, 0.1737E-02, 0.3517E-02, 0.8394E-02, 0.2072E-02, 0.8164E-03, 0.1716E-02, 0.2805E-02, &
    0.8143E-02, 0.2240E-02, 0.9001E-03, 0.1570E-02, 0.1800E-02, 0.8227E-02, 0.2386E-02, 0.9420E-03, 0.1486E-02, 0.1068E-02, &
    0.8373E-02, 0.2533E-02, 0.9210E-03, 0.1319E-02, 0.9420E-03, 0.8394E-02, 0.2700E-02, 0.9629E-03, 0.1026E-02, 0.5233E-03, &
    0.8917E-02, 0.2575E-02, 0.8792E-03, 0.7536E-03, 0.4187E-03, 0.9378E-02, 0.2617E-02, 0.7955E-03, 0.6070E-03, 0.4815E-03, &
    0.9797E-02, 0.2638E-02, 0.6908E-03, 0.5233E-03, 0.6280E-03, 0.1009E-01, 0.2638E-02, 0.4815E-03, 0.2931E-03, 0.4815E-03, &
    0.1036E-01, 0.2428E-02, 0.3140E-03, 0.3977E-03, 0.2093E-03 /
   
   data((c6h2o(T_3,j,i),i=1,KG(6)),j=1,NUMPS) / &
   -0.5366E-04,-0.1522E-04,-0.5709E-05,-0.2664E-05, 0.3806E-05,-0.4301E-04,-0.1484E-04,-0.4948E-05,-0.7610E-06, 0.7610E-06, &
   -0.3920E-04,-0.1484E-04,-0.4948E-05, 0.3804E-06,-0.3806E-05,-0.3920E-04,-0.1522E-04,-0.4948E-05, 0.3425E-05, 0.1903E-05, &
   -0.3806E-04,-0.1484E-04,-0.3045E-05, 0.2664E-05, 0.7993E-05,-0.4148E-04,-0.1408E-04,-0.3806E-05, 0.4187E-05, 0.7993E-05, &
   -0.5481E-04,-0.1180E-04,-0.3045E-05, 0.3045E-05, 0.2284E-05,-0.5709E-04,-0.1104E-04,-0.2283E-05,-0.2664E-05,-0.1142E-05, &
   -0.6090E-04,-0.1218E-04,-0.2664E-05, 0.3804E-06, 0.3045E-05,-0.6698E-04,-0.1218E-04,-0.2664E-05, 0.1523E-05,-0.1142E-05, &
   -0.6508E-04,-0.1218E-04,-0.3425E-05, 0.1903E-05, 0.7612E-06 /
   
   
   data((c7h2o(T_1,j,i),i=1,KG(7)),j=1,NUMPIR) / &
   -0.2008E+02,-0.1467E+02,-0.2004E+02,-0.1426E+02,-0.2001E+02,-0.1386E+02,-0.1998E+02,-0.1345E+02,-0.1995E+02,-0.1304E+02, &
   -0.1992E+02,-0.1263E+02,-0.1989E+02,-0.1223E+02,-0.1986E+02,-0.1183E+02,-0.1984E+02,-0.1143E+02,-0.1758E+02,-0.1038E+02, &
   -0.1602E+02,-0.9480E+01,-0.1469E+02,-0.8752E+01,-0.1349E+02,-0.8218E+01,-0.1255E+02,-0.7677E+01,-0.1174E+02,-0.7184E+01, &
   -0.1110E+02,-0.6735E+01,-0.1056E+02,-0.6332E+01,-0.1019E+02,-0.5975E+01,-0.9874E+01,-0.5644E+01 /
   
   data((c7h2o(T_2,j,i),i=1,KG(7)),j=1,NUMPIR) / &
    0.2533E-02, 0.2269E-01, 0.2575E-02, 0.2263E-01, 0.2554E-02, 0.2267E-01, 0.2491E-02, 0.2250E-01, 0.2449E-02, 0.2244E-01, &
    0.2344E-02, 0.2234E-01, 0.2219E-02, 0.2208E-01, 0.5694E-02, 0.2190E-01, 0.9650E-02, 0.2162E-01, 0.3286E-01, 0.1848E-01, &
    0.2987E-01, 0.1578E-01, 0.2527E-01, 0.1465E-01, 0.2175E-01, 0.1386E-01, 0.2056E-01, 0.1235E-01, 0.1963E-01, 0.1116E-01, &
    0.1926E-01, 0.1040E-01, 0.2014E-01, 0.1040E-01, 0.2024E-01, 0.1042E-01, 0.1972E-01, 0.1080E-01 /
   
   data((c7h2o(T_3,j,i),i=1,KG(7)),j=1,NUMPIR) / &
   -0.8754E-05,-0.6698E-04,-0.1104E-04,-0.6432E-04,-0.1142E-04,-0.6051E-04,-0.1180E-04,-0.6128E-04,-0.1180E-04,-0.6242E-04, &
   -0.1218E-04,-0.6280E-04,-0.1218E-04,-0.6204E-04, 0.5328E-04,-0.5709E-04, 0.1275E-03,-0.5214E-04,-0.1370E-03,-0.4148E-04, &
   -0.1100E-03,-0.3045E-04,-0.9248E-04,-0.3197E-04,-0.7346E-04,-0.2436E-04,-0.5100E-04,-0.2131E-04,-0.5861E-04,-0.2550E-04, &
   -0.5328E-04,-0.3311E-04,-0.6090E-04,-0.4225E-04,-0.5443E-04,-0.4415E-04,-0.4034E-04,-0.4339E-04 /
   
   
   data((c8h2o(T_1,j,i),i=1,KG(8)),j=1,NUMPIR) / &
   -0.2283E+02,-0.1639E+02,-0.6155E+01,-0.2237E+02,-0.1595E+02,-0.5775E+01,-0.2191E+02,-0.1551E+02,-0.5381E+01,-0.2145E+02, &
   -0.1507E+02,-0.5004E+01,-0.2099E+02,-0.1463E+02,-0.4617E+01,-0.2053E+02,-0.1419E+02,-0.4218E+01,-0.2025E+02,-0.1375E+02, &
   -0.3806E+01,-0.2021E+02,-0.1330E+02,-0.3403E+01,-0.2018E+02,-0.1287E+02,-0.2993E+01,-0.1998E+02,-0.1091E+02,-0.2586E+01, &
   -0.1744E+02,-0.9171E+01,-0.2162E+01,-0.1490E+02,-0.7642E+01,-0.1763E+01,-0.1303E+02,-0.6526E+01,-0.1373E+01,-0.1113E+02, &
   -0.5846E+01,-0.9699E+00,-0.9814E+01,-0.5280E+01,-0.5955E+00,-0.8582E+01,-0.4787E+01,-0.2510E+00,-0.8020E+01,-0.4350E+01, &
    0.2770E-01,-0.7571E+01,-0.3942E+01, 0.2406E+00,-0.7140E+01,-0.3537E+01, 0.3567E+00 /
   
   data((c8h2o(T_2,j,i),i=1,KG(8)),j=1,NUMPIR) / &
    0.3722E-01, 0.1505E-01, 0.6615E-02, 0.3722E-01, 0.1518E-01, 0.5840E-02, 0.3720E-01, 0.1526E-01, 0.5170E-02, 0.3399E-01, &
    0.1530E-01, 0.4773E-02, 0.3012E-01, 0.1551E-01, 0.4333E-02, 0.2625E-01, 0.1553E-01, 0.3956E-02, 0.2240E-01, 0.1562E-01, &
    0.3454E-02, 0.1846E-01, 0.1574E-01, 0.3161E-02, 0.1446E-01, 0.1572E-01, 0.3098E-02, 0.5924E-02, 0.8875E-02, 0.2658E-02, &
    0.2204E-01, 0.7096E-02, 0.2504E-02, 0.1591E-01, 0.5233E-02, 0.2292E-02, 0.8855E-02, 0.4249E-02, 0.2190E-02, 0.5422E-02, &
    0.3496E-02, 0.2041E-02, 0.4919E-02, 0.3621E-02, 0.2200E-02, 0.6657E-02, 0.3663E-02, 0.2248E-02, 0.8645E-02, 0.3852E-02, &
    0.2118E-02, 0.8771E-02, 0.3873E-02, 0.2176E-02, 0.9043E-02, 0.3747E-02, 0.2079E-02 /
   
   data((c8h2o(T_3,j,i),i=1,KG(8)),j=1,NUMPIR) / &
   -0.1568E-03,-0.4681E-04, 0.4567E-05,-0.1568E-03,-0.4605E-04,-0.3425E-05,-0.1572E-03,-0.4605E-04,-0.1104E-04,-0.2154E-03, &
   -0.4453E-04,-0.6851E-05,-0.2843E-03,-0.4225E-04,-0.7231E-05,-0.3562E-03,-0.4110E-04,-0.7231E-05,-0.3692E-03,-0.4110E-04, &
   -0.1028E-04,-0.3007E-03,-0.4263E-04,-0.6470E-05,-0.2325E-03,-0.3996E-04,-0.8373E-05,-0.5290E-04,-0.7612E-05,-0.4948E-05, &
   -0.7422E-04,-0.1256E-04,-0.8449E-05,-0.3501E-04,-0.1446E-04,-0.4834E-05, 0.4529E-04,-0.2246E-04,-0.2893E-05, 0.6470E-05, &
   -0.1789E-04,-0.7498E-05,-0.4948E-05,-0.1713E-04,-0.8183E-05,-0.5481E-04,-0.1713E-04,-0.1447E-04,-0.4986E-04,-0.1903E-04, &
   -0.1353E-04,-0.5138E-04,-0.1484E-04,-0.1147E-04,-0.5328E-04,-0.1560E-04,-0.6588E-05 /
   
   
   data((c9h2o(T_1,j,i),i=1,KG(9)),j=1,NUMPIR) / &
   -0.2066E+02,-0.1464E+02,-0.8301E+01,-0.3548E+01,-0.2025E+02,-0.1419E+02,-0.7905E+01,-0.3260E+01,-0.2019E+02,-0.1374E+02, &
   -0.7495E+01,-0.2927E+01,-0.2013E+02,-0.1329E+02,-0.7078E+01,-0.2584E+01,-0.2007E+02,-0.1284E+02,-0.6675E+01,-0.2247E+01, &
   -0.2001E+02,-0.1239E+02,-0.6268E+01,-0.1890E+01,-0.1996E+02,-0.1194E+02,-0.5853E+01,-0.1530E+01,-0.1991E+02,-0.1150E+02, &
   -0.5441E+01,-0.1133E+01,-0.1987E+02,-0.1105E+02,-0.5022E+01,-0.7447E+00,-0.1575E+02,-0.9657E+01,-0.4191E+01,-0.3728E+00, &
   -0.1329E+02,-0.8133E+01,-0.3638E+01, 0.1616E-01,-0.1181E+02,-0.6675E+01,-0.3178E+01, 0.4083E+00,-0.1036E+02,-0.5655E+01, &
   -0.2731E+01, 0.7953E+00,-0.8628E+01,-0.4990E+01,-0.2303E+01, 0.1153E+01,-0.7223E+01,-0.4453E+01,-0.1877E+01, 0.1454E+01, &
   -0.6567E+01,-0.3974E+01,-0.1461E+01, 0.1663E+01,-0.6077E+01,-0.3551E+01,-0.1071E+01, 0.1800E+01,-0.5651E+01,-0.3136E+01, &
   -0.7005E+00, 0.1809E+01,-0.5241E+01,-0.2726E+01,-0.3859E+00, 0.1781E+01 /
   
   data((c9h2o(T_2,j,i),i=1,KG(9)),j=1,NUMPIR) / &
    0.1315E-01, 0.4542E-02, 0.3496E-02, 0.4877E-02, 0.9650E-02, 0.4542E-02, 0.3098E-02, 0.3956E-02, 0.6154E-02, 0.4626E-02, &
    0.2763E-02, 0.3077E-02, 0.2658E-02, 0.4626E-02, 0.2512E-02, 0.2261E-02, 0.2658E-02, 0.4689E-02, 0.2219E-02, 0.1405E-02, &
    0.2700E-02, 0.4752E-02, 0.1926E-02, 0.7473E-03, 0.2658E-02, 0.4773E-02, 0.1737E-02, 0.5066E-03, 0.4668E-02, 0.4815E-02, &
    0.1507E-02, 0.1842E-03, 0.8541E-02, 0.4794E-02, 0.1382E-02,-0.2156E-03, 0.1022E-01, 0.2198E-02, 0.3977E-03,-0.2910E-03, &
    0.5484E-02, 0.6698E-03, 0.0000E+00,-0.2339E-03, 0.3349E-02, 0.1068E-02,-0.2512E-03,-0.4228E-03, 0.1884E-02, 0.2093E-03, &
   -0.3977E-03,-0.6405E-03,-0.8373E-04,-0.5233E-03,-0.4124E-03,-0.5945E-03, 0.7536E-03,-0.6698E-03,-0.4919E-03,-0.4794E-03, &
    0.3600E-02,-0.4605E-03,-0.4375E-03,-0.3517E-03, 0.3873E-02,-0.5861E-03,-0.3203E-03,-0.4689E-03, 0.3935E-02,-0.7326E-03, &
   -0.2072E-03,-0.4228E-03, 0.4124E-02,-0.8582E-03,-0.4187E-04,-0.5945E-03 /
   
   data((c9h2o(T_3,j,i),i=1,KG(9)),j=1,NUMPIR) / &
   -0.8525E-04, 0.1865E-04,-0.1142E-05, 0.2664E-05,-0.1313E-03, 0.1865E-04, 0.0000E+00, 0.1256E-04,-0.6470E-04, 0.1865E-04, &
   -0.3045E-05, 0.8754E-05, 0.3805E-06, 0.1789E-04,-0.6851E-05, 0.5328E-05, 0.1142E-05, 0.1827E-04,-0.6090E-05, 0.4148E-05, &
    0.1142E-05, 0.1865E-04,-0.3806E-05,-0.3768E-05,-0.1903E-05, 0.1751E-04,-0.4948E-05, 0.3121E-05, 0.3159E-04, 0.1979E-04, &
   -0.3045E-05,-0.9896E-06, 0.1005E-03, 0.1789E-04,-0.6089E-05,-0.1865E-05,-0.2207E-04, 0.1941E-04, 0.1903E-05, 0.2322E-05, &
   -0.1675E-04, 0.6090E-05,-0.7611E-06, 0.4397E-05, 0.3425E-04, 0.3806E-06, 0.1522E-05, 0.3806E-05, 0.4796E-04, 0.1522E-05, &
   -0.3806E-06, 0.3654E-05,-0.6851E-05, 0.2664E-05,-0.3920E-05,-0.6850E-06,-0.1370E-04, 0.5328E-05,-0.6584E-05,-0.8716E-05, &
   -0.8374E-10, 0.1522E-05,-0.6356E-05, 0.1294E-05,-0.9515E-05, 0.7612E-06,-0.3235E-05,-0.1066E-05,-0.7612E-05, 0.1142E-05, &
   -0.4529E-05, 0.3730E-05,-0.2664E-05,-0.3806E-06,-0.3501E-05,-0.5328E-06 /
   
   
   data((c10h2o(T_1,j,i),i=1,KG(10)),j=1,NUMPIR) / &
   -0.2023E+02,-0.1641E+02,-0.1171E+02,-0.6090E+01,-0.2016E+02,-0.1595E+02,-0.1133E+02,-0.5867E+01,-0.2011E+02,-0.1550E+02, &
   -0.1095E+02,-0.5660E+01,-0.2005E+02,-0.1504E+02,-0.1055E+02,-0.5407E+01,-0.2001E+02,-0.1459E+02,-0.1015E+02,-0.5137E+01, &
   -0.1997E+02,-0.1413E+02,-0.9749E+01,-0.4852E+01,-0.1993E+02,-0.1367E+02,-0.9337E+01,-0.4534E+01,-0.1990E+02,-0.1321E+02, &
   -0.8920E+01,-0.4211E+01,-0.1987E+02,-0.1276E+02,-0.8506E+01,-0.3889E+01,-0.1645E+02,-0.1179E+02,-0.7711E+01,-0.3613E+01, &
   -0.1442E+02,-0.1081E+02,-0.6942E+01,-0.3316E+01,-0.1308E+02,-0.9950E+01,-0.6344E+01,-0.2950E+01,-0.1212E+02,-0.9217E+01, &
   -0.5904E+01,-0.2577E+01,-0.1131E+02,-0.8559E+01,-0.5519E+01,-0.2256E+01,-0.1064E+02,-0.7962E+01,-0.5183E+01,-0.1929E+01, &
   -0.1013E+02,-0.7447E+01,-0.4833E+01,-0.1643E+01,-0.9712E+01,-0.7071E+01,-0.4485E+01,-0.1410E+01,-0.9305E+01,-0.6760E+01, &
   -0.4145E+01,-0.1249E+01,-0.8966E+01,-0.6477E+01,-0.3820E+01,-0.1114E+01 /
   
   data((c10h2o(T_2,j,i),i=1,KG(10)),j=1,NUMPIR) / &
    0.7913E-02, 0.8206E-02, 0.1509E-01, 0.1869E-01, 0.4228E-02, 0.8247E-02, 0.1467E-01, 0.1783E-01, 0.2010E-02, 0.8227E-02, &
    0.1442E-01, 0.1687E-01, 0.1947E-02, 0.8289E-02, 0.1394E-01, 0.1568E-01, 0.1863E-02, 0.8289E-02, 0.1346E-01, 0.1484E-01, &
    0.1842E-02, 0.8415E-02, 0.1310E-01, 0.1400E-01, 0.1800E-02, 0.8457E-02, 0.1275E-01, 0.1377E-01, 0.1696E-02, 0.8478E-02, &
    0.1220E-01, 0.1321E-01, 0.1842E-02, 0.8478E-02, 0.1189E-01, 0.1250E-01, 0.1409E-01, 0.8624E-02, 0.1254E-01, 0.1214E-01, &
    0.9043E-02, 0.1045E-01, 0.1225E-01, 0.1260E-01, 0.8561E-02, 0.1202E-01, 0.1181E-01, 0.1296E-01, 0.1114E-01, 0.1235E-01, &
    0.1191E-01, 0.1330E-01, 0.1199E-01, 0.1271E-01, 0.1195E-01, 0.1371E-01, 0.1415E-01, 0.1315E-01, 0.1218E-01, 0.1361E-01, &
    0.1478E-01, 0.1338E-01, 0.1296E-01, 0.1306E-01, 0.1518E-01, 0.1375E-01, 0.1365E-01, 0.1334E-01, 0.1530E-01, 0.1411E-01, &
    0.1392E-01, 0.1327E-01, 0.1547E-01, 0.1507E-01, 0.1390E-01, 0.1264E-01 /
   
   data((c10h2o(T_3,j,i),i=1,KG(10)),j=1,NUMPIR) / &
   -0.1089E-03,-0.2740E-04,-0.2017E-04,-0.5519E-04,-0.4491E-04,-0.2740E-04,-0.1408E-04,-0.5937E-04,-0.6090E-05,-0.2702E-04, &
   -0.6470E-05,-0.4719E-04,-0.7232E-05,-0.2740E-04,-0.6089E-05,-0.4910E-04,-0.7231E-05,-0.2969E-04,-0.4186E-05,-0.5366E-04, &
   -0.6090E-05,-0.3045E-04,-0.2284E-05,-0.4986E-04,-0.4568E-05,-0.3121E-04,-0.4948E-05,-0.5100E-04,-0.3426E-05,-0.3007E-04, &
   -0.7993E-05,-0.4910E-04, 0.1522E-05,-0.2931E-04,-0.9896E-05,-0.5366E-04,-0.5823E-04,-0.1599E-04,-0.1713E-04,-0.4110E-04, &
   -0.3121E-04,-0.1713E-04,-0.3159E-04,-0.3578E-04,-0.3996E-04,-0.1598E-04,-0.3958E-04,-0.4605E-04,-0.3349E-04,-0.1751E-04, &
   -0.3844E-04,-0.5576E-04,-0.2626E-04,-0.2474E-04,-0.3920E-04,-0.4464E-04,-0.1979E-04,-0.3045E-04,-0.3958E-04,-0.5336E-04, &
   -0.2893E-04,-0.3616E-04,-0.3996E-04,-0.4754E-04,-0.2398E-04,-0.3083E-04,-0.4415E-04,-0.5119E-04,-0.2702E-04,-0.2664E-04, &
   -0.4605E-04,-0.4038E-04,-0.2398E-04,-0.2360E-04,-0.4948E-04,-0.5149E-04 /
   
   
   data((c10ch4(k,j),j=1,NUMPIR),k=1,NUMTIR) / &
   -0.8909E+01,-0.8464E+01,-0.8018E+01,-0.7573E+01,-0.7133E+01,-0.6687E+01,-0.6240E+01,-0.5803E+01,-0.5377E+01,-0.4534E+01, &
   -0.3983E+01,-0.3502E+01,-0.3062E+01,-0.2648E+01,-0.2265E+01,-0.1896E+01,-0.1568E+01,-0.1234E+01,-0.9298E+00, 0.9629E-03, &
    0.9838E-03, 0.1088E-02, 0.1172E-02, 0.1256E-02, 0.1402E-02, 0.1528E-02, 0.1633E-02, 0.1716E-02, 0.4815E-03,-0.3977E-03, &
   -0.5652E-03,-0.5024E-03,-0.4605E-03,-0.4563E-03,-0.4438E-03,-0.4521E-03,-0.4312E-03,-0.3789E-03,-0.1294E-04,-0.1408E-04, &
   -0.1522E-04,-0.1675E-04,-0.1751E-04,-0.1941E-04,-0.2246E-04,-0.2207E-04,-0.1827E-04,-0.1256E-04,-0.9515E-05,-0.6470E-05, &
   -0.3045E-05,-0.3806E-05,-0.2055E-05,-0.3730E-05,-0.7612E-06,-0.3806E-05, 0.1256E-05 /
   
   
   data((c10n2o(k,j),j=1,NUMPIR),k=1,NUMTIR) / &
   -0.7863E+01,-0.7412E+01,-0.6963E+01,-0.6514E+01,-0.6065E+01,-0.5611E+01,-0.5167E+01,-0.4720E+01,-0.4283E+01,-0.3454E+01, &
   -0.2858E+01,-0.2404E+01,-0.1922E+01,-0.1491E+01,-0.1097E+01,-0.7177E+00,-0.3548E+00, 0.1218E-01, 0.3088E+00, 0.4459E-02, &
    0.4542E-02, 0.4668E-02, 0.4752E-02, 0.4815E-02, 0.4919E-02, 0.5087E-02, 0.5254E-02, 0.5296E-02, 0.2324E-02, 0.2093E-02, &
    0.2294E-02, 0.2125E-02, 0.2058E-02, 0.1920E-02, 0.1786E-02, 0.1689E-02, 0.1788E-02, 0.2144E-02,-0.7231E-05,-0.7231E-05, &
   -0.7231E-05,-0.6470E-05,-0.6851E-05,-0.7231E-05,-0.5709E-05,-0.6470E-05,-0.4186E-05, 0.8754E-05,-0.7612E-05,-0.9134E-06, &
   -0.8640E-05,-0.8487E-05,-0.8259E-05,-0.9553E-05,-0.8107E-05,-0.1654E-04,-0.1858E-04 /
   
   
   data((c11h2o(T_1,j,i),i=1,KG(11)),j=1,NUMPIR) / &
   -0.2005E+02,-0.1548E+02,-0.1021E+02,-0.2001E+02,-0.1504E+02,-0.1001E+02,-0.1997E+02,-0.1459E+02,-0.9814E+01,-0.1993E+02, &
   -0.1416E+02,-0.9595E+01,-0.1989E+02,-0.1373E+02,-0.9349E+01,-0.1985E+02,-0.1328E+02,-0.9072E+01,-0.1982E+02,-0.1286E+02, &
   -0.8833E+01,-0.1957E+02,-0.1243E+02,-0.8566E+01,-0.1911E+02,-0.1200E+02,-0.8276E+01,-0.1743E+02,-0.1134E+02,-0.7958E+01, &
   -0.1625E+02,-0.1078E+02,-0.7629E+01,-0.1524E+02,-0.1036E+02,-0.7334E+01,-0.1429E+02,-0.9970E+01,-0.7051E+01,-0.1348E+02, &
   -0.9620E+01,-0.6749E+01,-0.1282E+02,-0.9270E+01,-0.6505E+01,-0.1229E+02,-0.8932E+01,-0.6277E+01,-0.1186E+02,-0.8628E+01, &
   -0.6120E+01,-0.1148E+02,-0.8345E+01,-0.6049E+01,-0.1112E+02,-0.8066E+01,-0.5906E+01 /
   
   data((c11h2o(T_2,j,i),i=1,KG(11)),j=1,NUMPIR) / &
    0.1842E-02, 0.2131E-01, 0.3033E-01, 0.1905E-02, 0.2137E-01, 0.2841E-01, 0.1926E-02, 0.2135E-01, 0.2696E-01, 0.1926E-02, &
    0.2133E-01, 0.2514E-01, 0.1884E-02, 0.2154E-01, 0.2401E-01, 0.5589E-02, 0.2156E-01, 0.2321E-01, 0.9483E-02, 0.2156E-01, &
    0.2210E-01, 0.1333E-01, 0.2150E-01, 0.2133E-01, 0.1725E-01, 0.2154E-01, 0.2074E-01, 0.2254E-01, 0.1999E-01, 0.2005E-01, &
    0.2118E-01, 0.1926E-01, 0.1978E-01, 0.1936E-01, 0.1920E-01, 0.1963E-01, 0.1905E-01, 0.1911E-01, 0.1934E-01, 0.1909E-01, &
    0.1903E-01, 0.1920E-01, 0.1922E-01, 0.1901E-01, 0.1899E-01, 0.1934E-01, 0.1930E-01, 0.1974E-01, 0.1966E-01, 0.1909E-01, &
    0.2014E-01, 0.1976E-01, 0.1905E-01, 0.1984E-01, 0.1963E-01, 0.1940E-01, 0.1897E-01 /
   
   data((c11h2o(T_3,j,i),i=1,KG(11)),j=1,NUMPIR) / &
   -0.1522E-05,-0.6013E-04,-0.5062E-04,-0.2665E-05,-0.6204E-04,-0.5519E-04,-0.3806E-05,-0.6394E-04,-0.5633E-04,-0.4567E-05, &
   -0.6280E-04,-0.5214E-04,-0.6090E-05,-0.6128E-04,-0.5290E-04, 0.6051E-04,-0.6242E-04,-0.5823E-04, 0.1313E-03,-0.6013E-04, &
   -0.5176E-04, 0.1336E-03,-0.5747E-04,-0.4072E-04, 0.6318E-04,-0.5671E-04,-0.3996E-04,-0.5595E-04,-0.3996E-04,-0.4263E-04, &
   -0.3958E-04,-0.4719E-04,-0.4453E-04,-0.3387E-04,-0.5138E-04,-0.5100E-04,-0.5252E-04,-0.4986E-04,-0.4491E-04,-0.5100E-04, &
   -0.4453E-04,-0.4529E-04,-0.5176E-04,-0.4795E-04,-0.4453E-04,-0.5557E-04,-0.5176E-04,-0.5062E-04,-0.5747E-04,-0.4795E-04, &
   -0.5633E-04,-0.5709E-04,-0.4643E-04,-0.3806E-04,-0.5481E-04,-0.5671E-04,-0.4948E-04 /
   
   
   data((c11ch4(k,j),j=1,NUMPIR),k=1,NUMTIR) / &
   -0.1207E+02,-0.1162E+02,-0.1116E+02,-0.1070E+02,-0.1024E+02,-0.9777E+01,-0.9319E+01,-0.8858E+01,-0.8398E+01,-0.7384E+01, &
   -0.6643E+01,-0.6081E+01,-0.5602E+01,-0.5188E+01,-0.4822E+01,-0.4479E+01,-0.4184E+01,-0.3884E+01,-0.3627E+01, 0.1036E-01, &
    0.1036E-01, 0.1040E-01, 0.1040E-01, 0.1045E-01, 0.1047E-01, 0.1049E-01, 0.1055E-01, 0.1059E-01, 0.1059E-01, 0.1026E-01, &
    0.1011E-01, 0.1024E-01, 0.1049E-01, 0.1072E-01, 0.1089E-01, 0.1109E-01, 0.1153E-01, 0.1191E-01,-0.4910E-04,-0.4834E-04, &
   -0.4910E-04,-0.4910E-04,-0.4910E-04,-0.4872E-04,-0.4834E-04,-0.4948E-04,-0.5100E-04,-0.5633E-04,-0.6166E-04,-0.5595E-04, &
   -0.5366E-04,-0.5366E-04,-0.5328E-04,-0.5328E-04,-0.4948E-04,-0.5519E-04,-0.5595E-04 /
   
   
   data((c11n2o(k,j),j=1,NUMPIR),k=1,NUMTIR) / &
   -0.9461E+01,-0.9003E+01,-0.8543E+01,-0.8084E+01,-0.7629E+01,-0.7166E+01,-0.6707E+01,-0.6249E+01,-0.5793E+01,-0.5312E+01, &
   -0.4847E+01,-0.4393E+01,-0.3974E+01,-0.3587E+01,-0.3231E+01,-0.2885E+01,-0.2602E+01,-0.2358E+01,-0.2108E+01, 0.4710E-02, &
    0.4752E-02, 0.4773E-02, 0.4773E-02, 0.4815E-02, 0.4877E-02, 0.4898E-02, 0.4982E-02, 0.5066E-02, 0.5296E-02, 0.5149E-02, &
    0.5129E-02, 0.5024E-02, 0.4752E-02, 0.4501E-02, 0.4270E-02, 0.4019E-02, 0.3646E-02, 0.2759E-02,-0.1484E-04,-0.1408E-04, &
   -0.1446E-04,-0.1446E-04,-0.1522E-04,-0.1560E-04,-0.1522E-04,-0.1522E-04,-0.1598E-04,-0.1484E-04,-0.9895E-05,-0.1028E-04, &
   -0.7612E-05,-0.1903E-05, 0.1903E-05, 0.0000E+00, 0.2283E-05, 0.6166E-05,-0.2740E-05 /
   
   
   data((c12h2o(k,j),j=1,NUMPIR),k=1,NUMTIR) / &
   -0.1984E+02,-0.1983E+02,-0.1982E+02,-0.1981E+02,-0.1963E+02,-0.1917E+02,-0.1871E+02,-0.1825E+02,-0.1779E+02,-0.1639E+02, &
   -0.1545E+02,-0.1484E+02,-0.1433E+02,-0.1387E+02,-0.1345E+02,-0.1305E+02,-0.1268E+02,-0.1231E+02,-0.1196E+02, 0.6071E-03, &
    0.2072E-02, 0.6196E-02, 0.1030E-01, 0.1436E-01, 0.1846E-01, 0.2259E-01, 0.2667E-01, 0.2993E-01, 0.2878E-01, 0.2803E-01, &
    0.2851E-01, 0.2864E-01, 0.2874E-01, 0.2862E-01, 0.2859E-01, 0.2853E-01, 0.2868E-01, 0.2887E-01,-0.3808E-06, 0.2474E-04, &
    0.9895E-04, 0.1728E-03, 0.1911E-03, 0.1165E-03, 0.4225E-04,-0.3121E-04,-0.8982E-04,-0.9553E-04,-0.9705E-04,-0.9591E-04, &
   -0.9287E-04,-0.9172E-04,-0.9096E-04,-0.9134E-04,-0.9248E-04,-0.1050E-03,-0.1031E-03 /
   
   
   data((c12o3(T_1,j,i),i=1,KG(12)),j=1,NUMPIR) / &
   -0.6590E+01,-0.3912E+01,-0.8513E+00, 0.2731E+01, 0.5515E+01,-0.6157E+01,-0.3583E+01,-0.7292E+00, 0.2740E+01, 0.5508E+01, &
   -0.5731E+01,-0.3242E+01,-0.5800E+00, 0.2782E+01, 0.5485E+01,-0.5301E+01,-0.2901E+01,-0.4131E+00, 0.2805E+01, 0.5455E+01, &
   -0.4879E+01,-0.2551E+01,-0.2288E+00, 0.2878E+01, 0.5416E+01,-0.4449E+01,-0.2201E+01,-0.2228E-01, 0.3000E+01, 0.5374E+01, &
   -0.4018E+01,-0.1843E+01, 0.2055E+00, 0.3143E+01, 0.5342E+01,-0.3615E+01,-0.1502E+01, 0.4561E+00, 0.3288E+01, 0.5204E+01, &
   -0.3228E+01,-0.1172E+01, 0.7099E+00, 0.3396E+01, 0.5077E+01,-0.2828E+01,-0.8499E+00, 0.9664E+00, 0.3463E+01, 0.4893E+01, &
   -0.2480E+01,-0.5393E+00, 0.1229E+01, 0.3493E+01, 0.4656E+01,-0.2181E+01,-0.2653E+00, 0.1504E+01, 0.3456E+01, 0.4398E+01, &
   -0.1950E+01,-0.1469E-01, 0.1735E+01, 0.3387E+01, 0.4115E+01,-0.1788E+01, 0.2517E+00, 0.1919E+01, 0.3251E+01, 0.3832E+01, &
   -0.1677E+01, 0.5027E+00, 0.2032E+01, 0.3088E+01, 0.3581E+01,-0.1637E+01, 0.7373E+00, 0.2100E+01, 0.2910E+01, 0.3364E+01, &
   -0.1650E+01, 0.9383E+00, 0.2123E+01, 0.2793E+01, 0.3150E+01,-0.1658E+01, 0.1091E+01, 0.2112E+01, 0.2683E+01, 0.3021E+01, &
   -0.1654E+01, 0.1163E+01, 0.2099E+01, 0.2602E+01, 0.2871E+01 /
   
   data((c12o3(T_2,j,i),i=1,KG(12)),j=1,NUMPIR) / &
    0.9498E-02, 0.8894E-02, 0.1161E-01, 0.8828E-02,-0.1669E-02, 0.9613E-02, 0.8347E-02, 0.1053E-01, 0.8462E-02,-0.1612E-02, &
    0.9700E-02, 0.7829E-02, 0.9101E-02, 0.7915E-02,-0.1439E-02, 0.9815E-02, 0.7167E-02, 0.7981E-02, 0.7282E-02,-0.1094E-02, &
    0.9671E-02, 0.6764E-02, 0.6930E-02, 0.5613E-02,-0.8347E-03, 0.9613E-02, 0.6312E-02, 0.6225E-02, 0.4145E-02,-0.1295E-02, &
    0.9728E-02, 0.6099E-02, 0.5293E-02, 0.2965E-02,-0.1756E-02, 0.9844E-02, 0.5915E-02, 0.4496E-02, 0.1871E-02,-0.2044E-02, &
    0.9930E-02, 0.5817E-02, 0.3509E-02, 0.1324E-02,-0.2044E-02, 0.9988E-02, 0.5535E-02, 0.2711E-02, 0.6620E-03,-0.1813E-02, &
    0.1034E-01, 0.5247E-02, 0.1926E-02,-0.2303E-03,-0.1842E-02, 0.1058E-01, 0.4795E-02, 0.1197E-02,-0.9498E-03,-0.2216E-02, &
    0.1084E-01, 0.4414E-02, 0.6188E-03,-0.1123E-02,-0.2303E-02, 0.1079E-01, 0.3926E-02, 0.1756E-03,-0.1497E-02,-0.2274E-02, &
    0.1039E-01, 0.3425E-02,-0.1900E-03,-0.1353E-02,-0.2389E-02, 0.9815E-02, 0.2769E-02,-0.6620E-03,-0.1756E-02,-0.1785E-02, &
    0.9818E-02, 0.2444E-02,-0.1016E-02,-0.1410E-02,-0.1698E-02, 0.1074E-01, 0.3218E-02,-0.1235E-02,-0.1900E-02,-0.2533E-02, &
    0.1145E-01, 0.3684E-02,-0.1364E-02,-0.1353E-02,-0.1957E-02 /
   
   data((c12o3(T_3,j,i),i=1,KG(12)),j=1,NUMPIR) / &
   -0.4030E-04,-0.2375E-04,-0.3814E-05,-0.4943E-04,-0.3166E-04,-0.3742E-04,-0.1871E-04,-0.1137E-04,-0.4317E-04,-0.2878E-04, &
   -0.3526E-04,-0.2015E-04,-0.1295E-04,-0.4821E-04,-0.2303E-04,-0.3382E-04,-0.2087E-04,-0.1519E-04,-0.2231E-04,-0.1871E-04, &
   -0.3454E-04,-0.2087E-04,-0.8109E-05,-0.6476E-05,-0.1511E-04,-0.3454E-04,-0.1820E-04,-0.1269E-05,-0.1439E-04,-0.5037E-05, &
   -0.4173E-04,-0.2598E-04, 0.6645E-05,-0.1943E-04,-0.2087E-04,-0.3454E-04,-0.2267E-04, 0.2159E-05,-0.2231E-04,-0.2159E-05, &
   -0.2950E-04,-0.2080E-04, 0.2159E-06,-0.4317E-05, 0.1799E-04,-0.3670E-04,-0.1590E-04,-0.4461E-05,-0.9354E-05,-0.3598E-05, &
   -0.3216E-04,-0.1475E-04,-0.2231E-05,-0.1295E-04,-0.2878E-05,-0.3576E-04,-0.7347E-05,-0.1022E-04,-0.2159E-05,-0.7915E-05, &
   -0.3015E-04,-0.5230E-05,-0.5109E-05,-0.6476E-05,-0.7196E-05,-0.2331E-04,-0.1079E-04,-0.4102E-05, 0.1439E-05,-0.1223E-04, &
   -0.2216E-04,-0.1094E-04,-0.5325E-05,-0.7196E-06,-0.1655E-04,-0.1036E-04,-0.7627E-05,-0.2878E-05, 0.5037E-05,-0.1295E-04, &
    0.1029E-04,-0.1346E-04,-0.4821E-05,-0.7915E-05, 0.7915E-05, 0.2835E-04,-0.2893E-04,-0.1367E-05,-0.7196E-05,-0.1871E-04, &
    0.3965E-04,-0.3310E-04,-0.3310E-05,-0.7195E-06, 0.2303E-04 /
   
   
   data((c13h2o(T_1,j,i),i=1,KG(13)),j=1,NUMPIR) / &
   -0.1992E+02,-0.1446E+02,-0.1992E+02,-0.1405E+02,-0.1991E+02,-0.1363E+02,-0.1990E+02,-0.1322E+02,-0.1989E+02,-0.1282E+02, &
   -0.1989E+02,-0.1242E+02,-0.1988E+02,-0.1201E+02,-0.1987E+02,-0.1159E+02,-0.1986E+02,-0.1119E+02,-0.1982E+02,-0.1079E+02, &
   -0.1817E+02,-0.1039E+02,-0.1659E+02,-0.1000E+02,-0.1537E+02,-0.9623E+01,-0.1460E+02,-0.9266E+01,-0.1406E+02,-0.8959E+01, &
   -0.1354E+02,-0.8676E+01,-0.1309E+02,-0.8411E+01,-0.1267E+02,-0.8232E+01,-0.1229E+02,-0.8094E+01 /
   
   data((c13h2o(T_2,j,i),i=1,KG(13)),j=1,NUMPIR) / &
    0.5024E-03, 0.3199E-01, 0.5652E-03, 0.3199E-01, 0.6071E-03, 0.3211E-01, 0.6489E-03, 0.3199E-01, 0.6699E-03, 0.3178E-01, &
    0.6908E-03, 0.3157E-01, 0.6908E-03, 0.3109E-01, 0.6698E-03, 0.3075E-01, 0.6698E-03, 0.3054E-01, 0.1474E-01, 0.3000E-01, &
    0.3085E-01, 0.2960E-01, 0.3659E-01, 0.2935E-01, 0.3016E-01, 0.2920E-01, 0.2834E-01, 0.2895E-01, 0.2780E-01, 0.2870E-01, &
    0.2753E-01, 0.2843E-01, 0.2755E-01, 0.2820E-01, 0.2765E-01, 0.2732E-01, 0.2769E-01, 0.2705E-01 /
   
   data((c13h2o(T_3,j,i),i=1,KG(13)),j=1,NUMPIR) / &
    0.6299E-09,-0.7993E-04,-0.3802E-06,-0.7992E-04,-0.3802E-06,-0.8525E-04,-0.3808E-06,-0.8449E-04,-0.7610E-06,-0.7764E-04, &
   -0.1142E-05,-0.7231E-04,-0.1142E-05,-0.7345E-04,-0.2284E-05,-0.8259E-04,-0.2284E-05,-0.8031E-04, 0.2436E-03,-0.7878E-04, &
    0.7612E-05,-0.8525E-04,-0.1248E-03,-0.9439E-04,-0.9477E-04,-0.9172E-04,-0.8982E-04,-0.8640E-04,-0.7916E-04,-0.6813E-04, &
   -0.7574E-04,-0.6090E-04,-0.7612E-04,-0.7117E-04,-0.7498E-04,-0.7041E-04,-0.7269E-04,-0.7992E-04 /
   
   
   data((c14hca(T_1,j,i),i=1,KG(14)),j=1,NUMPIR) / &
   -0.1847E+02,-0.1399E+02,-0.1106E+02,-0.8539E+01,-0.5852E+01,-0.3295E+01,-0.1208E+01,-0.6272E-01, 0.2055E+01, 0.6071E+01, &
   -0.1801E+02,-0.1357E+02,-0.1067E+02,-0.8171E+01,-0.5562E+01,-0.3071E+01,-0.1073E+01, 0.1033E+00, 0.2055E+01, 0.6071E+01, &
   -0.1755E+02,-0.1314E+02,-0.1027E+02,-0.7798E+01,-0.5224E+01,-0.2823E+01,-0.9280E+00, 0.2723E+00, 0.2165E+01, 0.5969E+01, &
   -0.1709E+02,-0.1272E+02,-0.9868E+01,-0.7404E+01,-0.4880E+01,-0.2569E+01,-0.6908E+00, 0.4453E+00, 0.2241E+01, 0.5969E+01, &
   -0.1663E+02,-0.1230E+02,-0.9467E+01,-0.7013E+01,-0.4535E+01,-0.2297E+01,-0.4408E+00, 0.6353E+00, 0.2359E+01, 0.5969E+01, &
   -0.1617E+02,-0.1188E+02,-0.9050E+01,-0.6619E+01,-0.4160E+01,-0.1967E+01,-0.1687E+00, 0.8213E+00, 0.2421E+01, 0.5969E+01, &
   -0.1571E+02,-0.1147E+02,-0.8629E+01,-0.6230E+01,-0.3771E+01,-0.1648E+01, 0.1573E+00, 0.1019E+01, 0.2511E+01, 0.5884E+01, &
   -0.1525E+02,-0.1106E+02,-0.8215E+01,-0.5841E+01,-0.3393E+01,-0.1331E+01, 0.4013E+00, 0.1198E+01, 0.2654E+01, 0.5794E+01, &
   -0.1480E+02,-0.1066E+02,-0.7800E+01,-0.5454E+01,-0.3032E+01,-0.9870E+00, 0.6323E+00, 0.1373E+01, 0.2905E+01, 0.5647E+01, &
   -0.1402E+02,-0.9693E+01,-0.7206E+01,-0.4846E+01,-0.2656E+01,-0.6540E+00, 0.8323E+00, 0.1530E+01, 0.3211E+01, 0.5355E+01, &
   -0.1343E+02,-0.9060E+01,-0.6596E+01,-0.4399E+01,-0.2294E+01,-0.3519E+00, 0.9823E+00, 0.1673E+01, 0.3420E+01, 0.5083E+01, &
   -0.1279E+02,-0.8611E+01,-0.5785E+01,-0.4010E+01,-0.1936E+01,-0.1177E+00, 0.1134E+01, 0.1974E+01, 0.3591E+01, 0.4770E+01, &
   -0.1230E+02,-0.8174E+01,-0.5298E+01,-0.3611E+01,-0.1607E+01, 0.3636E-01, 0.1433E+01, 0.2260E+01, 0.3539E+01, 0.4439E+01, &
   -0.1192E+02,-0.7763E+01,-0.4946E+01,-0.3228E+01,-0.1321E+01, 0.1991E+00, 0.1720E+01, 0.2420E+01, 0.3383E+01, 0.4041E+01, &
   -0.1154E+02,-0.7377E+01,-0.4576E+01,-0.2851E+01,-0.1093E+01, 0.4430E+00, 0.1896E+01, 0.2462E+01, 0.3122E+01, 0.3620E+01, &
   -0.1118E+02,-0.7003E+01,-0.4210E+01,-0.2524E+01,-0.8973E+00, 0.7490E+00, 0.1966E+01, 0.2363E+01, 0.2818E+01, 0.3182E+01, &
   -0.1080E+02,-0.6677E+01,-0.3872E+01,-0.2264E+01,-0.6846E+00, 0.9392E+00, 0.1867E+01, 0.2138E+01, 0.2505E+01, 0.2738E+01, &
   -0.1031E+02,-0.6353E+01,-0.3596E+01,-0.1938E+01,-0.4537E+00, 0.1015E+01, 0.1659E+01, 0.1830E+01, 0.2142E+01, 0.2287E+01, &
   -0.9695E+01,-0.5977E+01,-0.3427E+01,-0.1596E+01,-0.1979E+00, 0.9458E+00, 0.1363E+01, 0.1545E+01, 0.1743E+01, 0.1832E+01 /
   
   data((c14hca(T_2,j,i),i=1,KG(14)),j=1,NUMPIR) / &
    0.3628E-01, 0.2728E-01, 0.2213E-01, 0.1656E-01, 0.1507E-01, 0.1564E-01, 0.1623E-01, 0.1419E-01, 0.1455E-01, 0.1089E-02, &
    0.3632E-01, 0.2740E-01, 0.2164E-01, 0.1606E-01, 0.1369E-01, 0.1418E-01, 0.1444E-01, 0.1275E-01, 0.1331E-01, 0.9210E-03, &
    0.3636E-01, 0.2746E-01, 0.2114E-01, 0.1557E-01, 0.1239E-01, 0.1285E-01, 0.1237E-01, 0.1141E-01, 0.1141E-01, 0.9210E-03, &
    0.3640E-01, 0.2748E-01, 0.2064E-01, 0.1516E-01, 0.1141E-01, 0.1125E-01, 0.1092E-01, 0.1026E-01, 0.1011E-01,-0.5652E-03, &
    0.3646E-01, 0.2746E-01, 0.2024E-01, 0.1478E-01, 0.1036E-01, 0.9688E-02, 0.9610E-02, 0.9305E-02, 0.9399E-02,-0.6489E-03, &
    0.3651E-01, 0.2734E-01, 0.1984E-01, 0.1438E-01, 0.9436E-02, 0.8486E-02, 0.8214E-02, 0.8995E-02, 0.7892E-02,-0.8582E-03, &
    0.3655E-01, 0.2723E-01, 0.1951E-01, 0.1402E-01, 0.8716E-02, 0.7433E-02, 0.7169E-02, 0.8072E-02, 0.5443E-02,-0.1172E-02, &
    0.3659E-01, 0.2709E-01, 0.1911E-01, 0.1379E-01, 0.8107E-02, 0.6818E-02, 0.6818E-02, 0.7033E-02, 0.3056E-02,-0.1047E-02, &
    0.3670E-01, 0.2698E-01, 0.1890E-01, 0.1363E-01, 0.7502E-02, 0.6371E-02, 0.6558E-02, 0.6489E-02,-0.5652E-03,-0.1340E-02, &
    0.3592E-01, 0.2238E-01, 0.1804E-01, 0.1007E-01, 0.6730E-02, 0.5512E-02, 0.6194E-02, 0.4375E-02,-0.1109E-02,-0.3559E-03, &
    0.3609E-01, 0.2242E-01, 0.1526E-01, 0.8582E-02, 0.6284E-02, 0.5809E-02, 0.4501E-02, 0.9420E-03,-0.9001E-03,-0.1005E-02, &
    0.3703E-01, 0.2196E-01, 0.1281E-01, 0.7860E-02, 0.5861E-02, 0.5842E-02, 0.1800E-02,-0.1591E-02,-0.1235E-02,-0.9420E-03, &
    0.3728E-01, 0.2114E-01, 0.1347E-01, 0.6678E-02, 0.5449E-02, 0.4837E-02,-0.1084E-02,-0.1361E-02,-0.6699E-03,-0.1256E-03, &
    0.3683E-01, 0.2061E-01, 0.1350E-01, 0.6133E-02, 0.5449E-02, 0.2111E-02,-0.1386E-02,-0.1235E-02,-0.5652E-03,-0.8373E-04, &
    0.3656E-01, 0.1988E-01, 0.1348E-01, 0.5441E-02, 0.5149E-02,-0.8813E-03,-0.1116E-02,-0.8373E-03,-0.3140E-03,-0.6280E-04, &
    0.3669E-01, 0.1934E-01, 0.1363E-01, 0.5035E-02, 0.3585E-02,-0.1250E-02,-0.9357E-03,-0.8227E-03,-0.3140E-03,-0.4187E-04, &
    0.3618E-01, 0.1856E-01, 0.1390E-01, 0.3836E-02, 0.1470E-02,-0.1096E-02,-0.8080E-03,-0.4480E-03,-0.2093E-03,-0.2093E-04, &
    0.3416E-01, 0.1741E-01, 0.1431E-01, 0.1951E-02,-0.2923E-04,-0.9422E-03,-0.4576E-03,-0.2395E-03,-0.1565E-03,-0.2799E-04, &
    0.3219E-01, 0.1674E-01, 0.1516E-01, 0.6652E-03,-0.5051E-03,-0.7052E-03,-0.2002E-03,-0.2135E-03,-0.7633E-04,-0.7300E-04 /
   
   data((c14hca(T_3,j,i),i=1,KG(14)),j=1,NUMPIR) / &
   -0.1290E-03,-0.9934E-04,-0.5595E-04,-0.3996E-04, 0.1294E-04,-0.9134E-05, 0.1294E-05,-0.3121E-05,-0.4757E-04,-0.1979E-04, &
   -0.1305E-03,-0.9629E-04,-0.5481E-04,-0.4301E-04, 0.1827E-04,-0.9363E-05, 0.1777E-04,-0.2185E-04,-0.1903E-04,-0.1675E-04, &
   -0.1313E-03,-0.9439E-04,-0.5404E-04,-0.4263E-04, 0.9134E-05,-0.1020E-04, 0.3524E-04,-0.2599E-04,-0.2093E-04, 0.1675E-04, &
   -0.1313E-03,-0.9172E-04,-0.5252E-04,-0.4567E-04, 0.4186E-05,-0.3920E-05, 0.2552E-04,-0.2059E-04,-0.2246E-04,-0.1028E-04, &
   -0.1324E-03,-0.9210E-04,-0.5138E-04,-0.4491E-04, 0.6470E-05,-0.2131E-05, 0.1496E-04,-0.1572E-04,-0.3311E-04,-0.8754E-05, &
   -0.1324E-03,-0.9058E-04,-0.5328E-04,-0.4225E-04, 0.1827E-05,-0.8411E-06, 0.4719E-05,-0.6813E-05,-0.2474E-04,-0.1256E-04, &
   -0.1340E-03,-0.8868E-04,-0.5633E-04,-0.4187E-04,-0.4415E-05, 0.6055E-05,-0.1648E-04,-0.1507E-04, 0.1979E-04,-0.2131E-04, &
   -0.1340E-03,-0.8373E-04,-0.5899E-04,-0.3920E-04,-0.4072E-05, 0.1491E-04,-0.9781E-05,-0.5328E-05, 0.3578E-04,-0.1979E-04, &
   -0.1321E-03,-0.7954E-04,-0.5899E-04,-0.4072E-04, 0.1066E-05, 0.5728E-05,-0.5138E-05,-0.8373E-05, 0.2626E-04,-0.2436E-04, &
   -0.1363E-03,-0.6432E-04,-0.5176E-04,-0.3083E-04, 0.2169E-05,-0.8944E-05, 0.3159E-05, 0.6470E-05,-0.4187E-05, 0.4948E-05, &
   -0.1302E-03,-0.7802E-04,-0.3311E-04,-0.1903E-04, 0.5328E-05,-0.1884E-04, 0.1408E-04, 0.3311E-04, 0.1142E-05,-0.7613E-06, &
   -0.1473E-03,-0.6737E-04,-0.7536E-04,-0.1085E-04,-0.1903E-05,-0.1458E-04, 0.4034E-04,-0.3941E-10,-0.7992E-05, 0.2664E-05, &
   -0.1361E-03,-0.5709E-04,-0.8550E-04,-0.5709E-05,-0.8640E-05, 0.6523E-05, 0.1903E-05,-0.8221E-05,-0.3045E-05,-0.9134E-05, &
   -0.1329E-03,-0.5529E-04,-0.7107E-04, 0.2664E-05,-0.9020E-05, 0.3320E-04,-0.2131E-05,-0.4187E-05,-0.7231E-05,-0.3806E-05, &
   -0.1278E-03,-0.5247E-04,-0.6465E-04, 0.3806E-05,-0.6091E-05, 0.1245E-04,-0.3844E-05,-0.6090E-05,-0.8754E-05,-0.2664E-05, &
   -0.1321E-03,-0.5632E-04,-0.5897E-04, 0.1012E-04, 0.1168E-04,-0.4196E-06,-0.8411E-05,-0.8868E-05,-0.1484E-04,-0.1522E-05, &
   -0.1252E-03,-0.4907E-04,-0.5932E-04, 0.3245E-04, 0.1996E-04,-0.3325E-05,-0.5785E-05,-0.6394E-05,-0.6851E-05,-0.1142E-05, &
   -0.1093E-03,-0.4731E-04,-0.6761E-04, 0.1808E-04, 0.1754E-04,-0.5079E-05,-0.5809E-05,-0.5649E-05,-0.3988E-05,-0.5849E-06, &
   -0.1151E-03,-0.4965E-04,-0.7163E-04, 0.7839E-05, 0.5505E-05,-0.6084E-05,-0.3344E-05,-0.3894E-05,-0.1391E-05,-0.1327E-05 /
   
   
   data((c14hcb(T_1,j,i),i=1,KG(14)),j=1,NUMPIR) / &
   -0.9398E+01,-0.5678E+01,-0.3606E+01,-0.2192E+01, 0.2104E+01, 0.3044E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.9094E+01,-0.5422E+01,-0.3448E+01,-0.1650E+01, 0.2046E+01, 0.2749E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.8760E+01,-0.5270E+01,-0.3329E+01,-0.1147E+01, 0.2112E+01, 0.2709E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.8537E+01,-0.5152E+01,-0.3129E+01,-0.9544E+00, 0.2254E+01, 0.2771E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.8176E+01,-0.4936E+01,-0.2680E+01,-0.9259E+00, 0.2247E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.7836E+01,-0.4676E+01,-0.2378E+01,-0.3550E+00, 0.1396E+01, 0.1976E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.7419E+01,-0.4122E+01,-0.2407E+01,-0.1204E-01, 0.1744E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.7124E+01,-0.3727E+01,-0.2160E+01, 0.6158E+00, 0.1953E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.6823E+01,-0.3324E+01,-0.1748E+01,-0.9806E-01, 0.2319E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.5957E+01,-0.3017E+01,-0.1647E+01, 0.1398E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.5115E+01,-0.2290E+01,-0.5273E+00, 0.5662E+00, 0.1459E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.4162E+01,-0.1453E+01, 0.1116E+00,-0.4587E+02, 0.9569E+00,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.3611E+01,-0.9744E+00,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.3075E+01,-0.4176E+00,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.3469E+01,-0.9395E+00, 0.5092E+00, 0.6200E+00,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.3808E+01,-0.1505E+01, 0.3901E+00, 0.6264E+00,-0.1155E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.4058E+01,-0.1818E+01, 0.2693E+00, 0.7087E+00, 0.3820E+00,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.4262E+01,-0.2097E+01,-0.5711E-01, 0.5681E+00, 0.1310E+01, 0.7371E+00,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.3997E+01,-0.1784E+01, 0.4388E-01, 0.5167E+00, 0.6930E+00,-0.6906E+00,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02 /
   
   data((c14hcb(T_2,j,i),i=1,KG(14)),j=1,NUMPIR) / &
    0.2944E-01, 0.2723E-01, 0.1854E-01, 0.2023E-01, 0.2254E-01, 0.3059E-02, 0.4788E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3080E-01, 0.2549E-01, 0.1547E-01, 0.2225E-01, 0.2107E-01, 0.3059E-02, 0.4737E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3269E-01, 0.2656E-01, 0.2125E-01, 0.2179E-01, 0.2162E-01, 0.4589E+00, 0.4643E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3322E-01, 0.2476E-01, 0.2075E-01, 0.2139E-01, 0.1907E-01, 0.4501E+00, 0.4441E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3387E-01, 0.2182E-01, 0.2665E-01, 0.1841E-01, 0.2506E-01, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3532E-01, 0.2091E-01, 0.1995E-01, 0.2067E-01, 0.1949E-01, 0.4491E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3468E-01, 0.2075E-01, 0.2587E-01, 0.1401E-01, 0.8646E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3666E-01, 0.2430E-01, 0.1919E-01, 0.2007E-01, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3613E-01, 0.2147E-01, 0.1892E-01, 0.1361E-01, 0.3059E-02, 0.4506E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3129E-01, 0.1954E-01, 0.2442E-01, 0.1011E-01, 0.4420E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3177E-01, 0.2101E-01, 0.1526E-01, 0.4376E+00, 0.4379E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2887E-01, 0.2044E-01, 0.1285E-01, 0.3059E-02,-0.4862E-03, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2759E-01, 0.2114E-01, 0.4303E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2880E-01, 0.1690E-01,-0.4187E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2852E-01, 0.2255E-01, 0.2184E-01, 0.4334E+00, 0.4217E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2840E-01, 0.2136E-01, 0.1644E-01, 0.2812E-01, 0.4358E+00, 0.4288E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2809E-01, 0.2173E-01, 0.1708E-01, 0.3346E-01, 0.4225E-01, 0.4419E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2702E-01, 0.2260E-01, 0.1607E-01, 0.2720E-01, 0.3982E-01, 0.4452E+00, 0.4365E+00, 0.4345E+00, 0.4432E+00, 0.4623E+00, &
    0.2684E-01, 0.2328E-01, 0.2099E-01, 0.3040E-01, 0.3867E-01, 0.4389E+00, 0.3132E-01, 0.3158E-01, 0.4083E-01, 0.4580E+00 /
   
   data((c14hcb(T_3,j,i),i=1,KG(14)),j=1,NUMPIR) / &
   -0.1581E-03,-0.9707E-04,-0.1250E-03, 0.2580E-03, 0.7378E-04,-0.1617E-01, 0.8646E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1319E-03,-0.9528E-04,-0.1710E-03, 0.7118E-04, 0.2076E-04,-0.1608E-01, 0.8552E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1721E-03,-0.4680E-04,-0.5522E-04,-0.6242E-04, 0.4517E-04,-0.7777E-02, 0.8382E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1482E-03,-0.4208E-04,-0.5216E-04,-0.6514E-04,-0.8378E-04,-0.7956E-02, 0.8013E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1501E-03,-0.4002E-04,-0.1664E-03, 0.2272E-04,-0.1888E-03,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1201E-03,-0.4709E-04,-0.5371E-04,-0.1574E-03, 0.1854E-03,-0.7712E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1333E-03,-0.1062E-03, 0.5785E-04,-0.4150E-04,-0.5717E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1212E-03,-0.8524E-04,-0.5895E-04,-0.2884E-03,-0.1581E-01,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.8148E-04,-0.9361E-04,-0.2873E-03, 0.1883E-03,-0.1594E-01, 0.8133E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1221E-03,-0.1430E-04, 0.6335E-04,-0.2581E-03, 0.7977E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.9257E-04,-0.5008E-04, 0.6389E-04,-0.7455E-02,-0.7745E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1186E-03,-0.9037E-04,-0.7461E-04,-0.4656E-05, 0.1168E-03,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.8513E-04,-0.5708E-04, 0.7763E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1124E-03,-0.1228E-03, 0.7663E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1015E-03,-0.8369E-04,-0.2167E-03,-0.7548E-02, 0.7608E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1049E-03,-0.6414E-04,-0.1384E-03,-0.1644E-03,-0.6919E-02, 0.7736E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1008E-03,-0.7047E-04,-0.1276E-03,-0.2445E-03,-0.1860E-03, 0.7975E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.9629E-04,-0.1007E-03,-0.1127E-03,-0.1527E-03,-0.3238E-03,-0.7373E-02, 0.7877E-02, 0.7840E-02, 0.7997E-02, 0.8345E-02, &
   -0.8800E-04,-0.1072E-03,-0.1046E-03,-0.1777E-03,-0.2146E-03,-0.7016E-02, 0.1516E-01, 0.1532E-01, 0.1509E-01, 0.8268E-02 /
   
   
   data((c15hca(T_1,j,i),i=1,KG(15)),j=1,NUMPIR) / &
   -0.1921E+02,-0.1363E+02,-0.1080E+02,-0.8392E+01,-0.6776E+01,-0.5696E+01,-0.4572E+01,-0.3752E+01,-0.2382E+01,-0.1110E+01, &
    0.6803E+00, 0.3259E+01,-0.1875E+02,-0.1321E+02,-0.1040E+02,-0.8026E+01,-0.6449E+01,-0.5401E+01,-0.4316E+01,-0.3498E+01, &
   -0.2141E+01,-0.9439E+00, 0.8103E+00, 0.3314E+01,-0.1829E+02,-0.1278E+02,-0.1000E+02,-0.7646E+01,-0.6089E+01,-0.5085E+01, &
   -0.4047E+01,-0.3217E+01,-0.1872E+01,-0.7106E+00, 0.9573E+00, 0.3390E+01,-0.1783E+02,-0.1236E+02,-0.9596E+01,-0.7264E+01, &
   -0.5735E+01,-0.4740E+01,-0.3743E+01,-0.2882E+01,-0.1587E+01,-0.4714E+00, 0.1120E+01, 0.3425E+01,-0.1737E+02,-0.1195E+02, &
   -0.9193E+01,-0.6877E+01,-0.5371E+01,-0.4404E+01,-0.3405E+01,-0.2574E+01,-0.1298E+01,-0.1747E+00, 0.1327E+01, 0.3547E+01, &
   -0.1691E+02,-0.1153E+02,-0.8776E+01,-0.6490E+01,-0.4993E+01,-0.4049E+01,-0.3039E+01,-0.2256E+01,-0.1012E+01, 0.1103E+00, &
    0.1530E+01, 0.3651E+01,-0.1644E+02,-0.1112E+02,-0.8360E+01,-0.6105E+01,-0.4623E+01,-0.3688E+01,-0.2694E+01,-0.1915E+01, &
   -0.6855E+00, 0.3993E+00, 0.1714E+01, 0.3950E+01,-0.1598E+02,-0.1073E+02,-0.7943E+01,-0.5723E+01,-0.4236E+01,-0.3314E+01, &
   -0.2338E+01,-0.1596E+01,-0.3583E+00, 0.6963E+00, 0.1868E+01, 0.4127E+01,-0.1553E+02,-0.1034E+02,-0.7542E+01,-0.5357E+01, &
   -0.3856E+01,-0.2942E+01,-0.1986E+01,-0.1299E+01,-0.5472E-01, 0.9443E+00, 0.2149E+01, 0.4261E+01,-0.1485E+02,-0.9661E+01, &
   -0.7008E+01,-0.4830E+01,-0.3458E+01,-0.2566E+01,-0.1658E+01,-0.9639E+00, 0.2083E+00, 0.1182E+01, 0.2458E+01, 0.4452E+01, &
   -0.1427E+02,-0.9166E+01,-0.6373E+01,-0.4404E+01,-0.3073E+01,-0.2209E+01,-0.1349E+01,-0.6648E+00, 0.4023E+00, 0.1452E+01, &
    0.2739E+01, 0.4466E+01,-0.1380E+02,-0.8726E+01,-0.5772E+01,-0.3982E+01,-0.2732E+01,-0.1874E+01,-0.1052E+01,-0.4403E+00, &
    0.5763E+00, 0.1792E+01, 0.2999E+01, 0.4335E+01,-0.1305E+02,-0.8270E+01,-0.5304E+01,-0.3586E+01,-0.2392E+01,-0.1568E+01, &
   -0.8299E+00,-0.2650E+00, 0.8584E+00, 0.2062E+01, 0.3141E+01, 0.4168E+01,-0.1269E+02,-0.7900E+01,-0.4956E+01,-0.3205E+01, &
   -0.2065E+01,-0.1332E+01,-0.6415E+00,-0.7921E-01, 0.1170E+01, 0.2269E+01, 0.3198E+01, 0.4066E+01,-0.1227E+02,-0.7536E+01, &
   -0.4576E+01,-0.2859E+01,-0.1815E+01,-0.1139E+01,-0.4520E+00, 0.2272E+00, 0.1371E+01, 0.2351E+01, 0.3150E+01, 0.3935E+01, &
   -0.1186E+02,-0.7159E+01,-0.4223E+01,-0.2538E+01,-0.1619E+01,-0.9324E+00,-0.1566E+00, 0.5151E+00, 0.1520E+01, 0.2339E+01, &
    0.3132E+01, 0.3880E+01,-0.1120E+02,-0.6777E+01,-0.3919E+01,-0.2330E+01,-0.1387E+01,-0.6737E+00, 0.1108E+00, 0.6991E+00, &
    0.1531E+01, 0.2163E+01, 0.3150E+01, 0.3767E+01,-0.9973E+01,-0.6279E+01,-0.3638E+01,-0.2048E+01,-0.1098E+01,-0.4407E+00, &
    0.3043E+00, 0.7797E+00, 0.1424E+01, 0.2002E+01, 0.3122E+01, 0.3611E+01,-0.8483E+01,-0.5607E+01,-0.3357E+01,-0.1744E+01, &
   -0.8884E+00,-0.2264E+00, 0.3800E+00, 0.7504E+00, 0.1245E+01, 0.2032E+01, 0.3097E+01, 0.3546E+01 /
   
   data((c15hca(T_2,j,i),i=1,KG(15)),j=1,NUMPIR) / &
    0.3762E-01, 0.2372E-01, 0.1643E-01, 0.1208E-01, 0.1170E-01, 0.1164E-01, 0.1214E-01, 0.1161E-01, 0.1028E-01, 0.9185E-02, &
    0.7712E-02, 0.1001E-01, 0.3762E-01, 0.2382E-01, 0.1593E-01, 0.1145E-01, 0.1059E-01, 0.1049E-01, 0.1080E-01, 0.1057E-01, &
    0.8894E-02, 0.7807E-02, 0.7132E-02, 0.1032E-01, 0.3764E-01, 0.2386E-01, 0.1555E-01, 0.1080E-01, 0.9692E-02, 0.9231E-02, &
    0.9585E-02, 0.9644E-02, 0.7711E-02, 0.6443E-02, 0.6223E-02, 0.9922E-02, 0.3764E-01, 0.2395E-01, 0.1516E-01, 0.1028E-01, &
    0.8917E-02, 0.8415E-02, 0.8457E-02, 0.8777E-02, 0.6436E-02, 0.5428E-02, 0.5499E-02, 0.8017E-02, 0.3768E-01, 0.2399E-01, &
    0.1482E-01, 0.9692E-02, 0.8247E-02, 0.7640E-02, 0.7582E-02, 0.7783E-02, 0.5432E-02, 0.4482E-02, 0.4919E-02, 0.5903E-02, &
    0.3770E-01, 0.2401E-01, 0.1449E-01, 0.9252E-02, 0.7620E-02, 0.6678E-02, 0.6845E-02, 0.6925E-02, 0.4939E-02, 0.3471E-02, &
    0.4124E-02, 0.3873E-02, 0.3776E-01, 0.2395E-01, 0.1419E-01, 0.8959E-02, 0.7096E-02, 0.6184E-02, 0.6110E-02, 0.6075E-02, &
    0.4419E-02, 0.2891E-02, 0.3056E-02, 0.1214E-02, 0.3780E-01, 0.2391E-01, 0.1392E-01, 0.8687E-02, 0.6573E-02, 0.5733E-02, &
    0.5359E-02, 0.5009E-02, 0.4034E-02, 0.2755E-02, 0.1968E-02,-0.4187E-04, 0.3791E-01, 0.2382E-01, 0.1373E-01, 0.8561E-02, &
    0.6060E-02, 0.5120E-02, 0.4618E-02, 0.4713E-02, 0.3965E-02, 0.2481E-02, 0.8164E-03,-0.1088E-02, 0.3843E-01, 0.2148E-01, &
    0.1302E-01, 0.6384E-02, 0.5256E-02, 0.4260E-02, 0.4077E-02, 0.4181E-02, 0.4132E-02, 0.2135E-02,-0.2931E-03,-0.1151E-02, &
    0.3896E-01, 0.2081E-01, 0.1097E-01, 0.5568E-02, 0.4475E-02, 0.3795E-02, 0.3828E-02, 0.3996E-02, 0.3766E-02, 0.1193E-02, &
   -0.1089E-02,-0.9420E-03, 0.3973E-01, 0.2024E-01, 0.9943E-02, 0.4815E-02, 0.3820E-02, 0.3663E-02, 0.3568E-02, 0.3881E-02, &
    0.2859E-02, 0.6698E-03,-0.1549E-02,-0.6280E-03, 0.3635E-01, 0.1963E-01, 0.1061E-01, 0.3812E-02, 0.3509E-02, 0.3429E-02, &
    0.3693E-02, 0.3316E-02, 0.1120E-02, 0.6552E-03,-0.1193E-02,-0.1109E-02, 0.3631E-01, 0.1893E-01, 0.1056E-01, 0.3172E-02, &
    0.3378E-02, 0.3164E-02, 0.2751E-02, 0.1722E-02, 0.1112E-02, 0.4354E-03,-0.7327E-03,-0.1319E-02, 0.3500E-01, 0.1828E-01, &
    0.1050E-01, 0.2831E-02, 0.2784E-02, 0.2564E-02, 0.1469E-02, 0.7739E-03, 0.1209E-02, 0.7913E-03,-0.2512E-03,-0.1758E-02, &
    0.3352E-01, 0.1763E-01, 0.1045E-01, 0.2401E-02, 0.1928E-02, 0.1340E-02, 0.3753E-03, 0.5794E-03, 0.9060E-03, 0.1042E-02, &
    0.1465E-03,-0.2533E-02, 0.2880E-01, 0.1729E-01, 0.1077E-01, 0.1347E-02, 0.1194E-02,-0.1191E-03, 0.2828E-03, 0.6606E-03, &
    0.9743E-03, 0.1002E-02, 0.0000E+00,-0.3140E-02, 0.2040E-01, 0.1585E-01, 0.1165E-01, 0.3871E-05, 0.1509E-04,-0.1046E-02, &
    0.2444E-03, 0.4359E-03, 0.1041E-02, 0.2429E-02,-0.1721E-03,-0.2786E-02, 0.1737E-01, 0.1560E-01, 0.1240E-01,-0.2139E-03, &
   -0.1025E-02,-0.1248E-02,-0.6934E-04, 0.1649E-03, 0.4062E-03, 0.1554E-02,-0.4179E-03,-0.7795E-03 /
   
   data((c15hca(T_3,j,i),i=1,KG(15)),j=1,NUMPIR) / &
   -0.1488E-03,-0.9248E-04,-0.2322E-04,-0.4187E-05, 0.1104E-04, 0.9895E-05,-0.2283E-05, 0.2512E-05,-0.9058E-05, 0.8449E-05, &
    0.8297E-05,-0.3882E-04,-0.1488E-03,-0.9058E-04,-0.2398E-04,-0.5709E-05, 0.1218E-04, 0.1180E-04, 0.1522E-05, 0.6927E-05, &
   -0.1161E-04, 0.1714E-04,-0.4948E-06,-0.3540E-04,-0.1500E-03,-0.8830E-04,-0.2474E-04,-0.8373E-05, 0.6470E-05, 0.7992E-05, &
    0.9096E-05, 0.6737E-05,-0.1485E-04, 0.1873E-04,-0.4948E-06,-0.4491E-04,-0.1500E-03,-0.8601E-04,-0.2664E-04,-0.1028E-04, &
    0.6851E-05, 0.6851E-05, 0.1294E-04,-0.2550E-05,-0.1520E-04, 0.2310E-04, 0.4948E-06,-0.2017E-04,-0.1507E-03,-0.8373E-04, &
   -0.2664E-04,-0.1256E-04, 0.4567E-05, 0.1028E-04, 0.9210E-05,-0.2131E-05,-0.6995E-05, 0.7498E-05,-0.1104E-04,-0.2284E-05, &
   -0.1519E-03,-0.8183E-04,-0.2816E-04,-0.1142E-04, 0.7611E-06, 0.7231E-05, 0.1751E-05,-0.7612E-06, 0.8312E-05, 0.2436E-05, &
   -0.7231E-05, 0.2398E-04,-0.1530E-03,-0.7992E-04,-0.2893E-04,-0.9896E-05, 0.3806E-06, 0.8906E-05, 0.3159E-05,-0.5328E-05, &
    0.3692E-05,-0.2093E-05,-0.6851E-05,-0.3045E-05,-0.1538E-03,-0.7536E-04,-0.3007E-04,-0.8754E-05,-0.3045E-05, 0.5138E-05, &
    0.9134E-06,-0.1979E-06, 0.1560E-05,-0.1507E-04, 0.2284E-04, 0.9895E-05,-0.1541E-03,-0.7688E-04,-0.2969E-04,-0.5709E-05, &
   -0.3996E-05, 0.1142E-05,-0.8373E-06, 0.1235E-04,-0.7079E-05,-0.6737E-05, 0.1028E-04, 0.3578E-04,-0.1560E-03,-0.6851E-04, &
   -0.1903E-04,-0.4187E-05,-0.4605E-05,-0.1142E-06, 0.3878E-05, 0.3597E-05,-0.9591E-05, 0.5328E-05, 0.7612E-05,-0.4948E-05, &
   -0.1587E-03,-0.6546E-04,-0.2740E-04,-0.7612E-06,-0.3578E-05, 0.1713E-05, 0.6064E-05,-0.9781E-05, 0.1408E-05, 0.5709E-05, &
    0.8373E-05,-0.1256E-04,-0.1484E-03,-0.5823E-04,-0.4301E-04,-0.1522E-05, 0.7498E-05,-0.5328E-06,-0.7855E-05,-0.1599E-05, &
    0.1964E-04,-0.2284E-05, 0.7882E-10, 0.5328E-05,-0.1238E-03,-0.5700E-04,-0.5266E-04, 0.3286E-05, 0.4910E-05,-0.8602E-05, &
    0.6090E-06, 0.8454E-05, 0.1256E-05,-0.4072E-05,-0.1903E-05, 0.6470E-05,-0.1155E-03,-0.5231E-04,-0.4396E-04, 0.3626E-05, &
   -0.7051E-05,-0.1743E-05, 0.9667E-05, 0.2064E-04,-0.2778E-05,-0.6546E-05,-0.4948E-05, 0.1903E-05,-0.1024E-03,-0.5129E-04, &
   -0.4506E-04, 0.7943E-06, 0.3074E-06, 0.3243E-05, 0.2754E-04,-0.1479E-05, 0.1661E-05,-0.2969E-05,-0.1066E-04, 0.7612E-06, &
   -0.8473E-04,-0.5418E-04,-0.4674E-04,-0.3418E-05, 0.9460E-05, 0.1151E-04, 0.5714E-05,-0.1069E-04,-0.2022E-05,-0.9061E-05, &
   -0.1104E-04,-0.3083E-04,-0.4283E-04,-0.5037E-04,-0.4476E-04, 0.1951E-04, 0.8922E-05, 0.1296E-04,-0.4053E-05,-0.4355E-05, &
   -0.2355E-05,-0.5004E-05,-0.1218E-04,-0.1522E-04, 0.6411E-05,-0.5937E-04,-0.5331E-04, 0.1934E-04, 0.5284E-05, 0.1129E-04, &
   -0.2166E-05,-0.1484E-06,-0.5407E-05,-0.1364E-04,-0.3115E-05, 0.3004E-04,-0.5074E-04,-0.6256E-04,-0.5097E-04, 0.2218E-04, &
    0.1228E-04,-0.1160E-05,-0.1105E-05, 0.1618E-06,-0.6089E-05,-0.4216E-06,-0.5314E-05, 0.7903E-05 /
   
   
   data((c15hcb(T_1,j,i),i=1,KG(15)),j=1,NUMPIR) / &
   -0.9593E+01,-0.4078E+01,-0.2812E+01,-0.6506E+00,-0.4123E+00, 0.2055E+01, 0.4097E+01, 0.4671E+01, 0.4639E+01,-0.4587E+02, &
   -0.4587E+02,-0.4587E+02,-0.9276E+01,-0.3757E+01,-0.2467E+01,-0.5784E+00, 0.8833E-01, 0.2232E+01, 0.3826E+01, 0.4723E+01, &
    0.4942E+01, 0.5135E+01,-0.4587E+02,-0.4587E+02,-0.8968E+01,-0.3508E+01,-0.2116E+01,-0.1363E+00, 0.1662E+00, 0.2424E+01, &
    0.4220E+01, 0.4513E+01, 0.1375E+01, 0.4601E+01,-0.4587E+02,-0.4587E+02,-0.8662E+01,-0.3164E+01,-0.1722E+01, 0.5178E-01, &
    0.7288E+00, 0.2411E+01, 0.3805E+01, 0.4766E+01, 0.4342E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.8292E+01,-0.2799E+01, &
   -0.1359E+01, 0.3271E+00, 0.1650E+01, 0.2395E+01, 0.4192E+01, 0.4758E+01, 0.2470E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.7812E+01,-0.2404E+01,-0.1085E+01, 0.7167E+00, 0.2202E+01, 0.2922E+01, 0.4322E+01, 0.4591E+01, 0.4186E+01,-0.4587E+02, &
   -0.4587E+02,-0.4587E+02,-0.7441E+01,-0.2066E+01,-0.7142E+00, 0.1057E+01, 0.2524E+01, 0.2946E+01, 0.4220E+01, 0.3607E+01, &
   -0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.7191E+01,-0.1745E+01,-0.3487E+00, 0.1453E+01, 0.2739E+01, 0.3660E+01, &
    0.4114E+01, 0.3245E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.6895E+01,-0.1326E+01,-0.3500E+00, 0.1647E+01, &
    0.2899E+01, 0.4023E+01, 0.3361E+01, 0.3360E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.5876E+01,-0.9573E+00, &
    0.2014E+00, 0.2130E+01, 0.3493E+01, 0.4088E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.4429E+01,-0.3417E+00, 0.1204E+01, 0.2780E+01, 0.3843E+01, 0.3099E+01,-0.4587E+02, 0.3605E+01,-0.4587E+02,-0.4587E+02, &
   -0.4587E+02,-0.4587E+02,-0.3122E+01, 0.2697E+00, 0.1866E+01, 0.3526E+01, 0.3569E+01, 0.1025E+01,-0.4587E+02,-0.4587E+02, &
   -0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.2284E+01, 0.8186E+00, 0.2754E+01, 0.3206E+01, 0.3704E+01,-0.4587E+02, &
   -0.4587E+02, 0.4625E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.1711E+01, 0.1220E+01, 0.3248E+01,-0.4587E+02, &
    0.2565E+01, 0.3297E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.1758E+01, 0.7970E+00, &
    0.2758E+01, 0.2926E+01, 0.2613E+01, 0.1974E+01,-0.4587E+02, 0.2310E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.4587E+02, &
   -0.1737E+01, 0.3499E+00, 0.2246E+01, 0.2673E+01, 0.3308E+01, 0.3463E+01, 0.3103E+01, 0.2611E+01, 0.2178E+01,-0.4587E+02, &
   -0.4587E+02,-0.4587E+02,-0.1559E+01, 0.2215E+00, 0.1875E+01, 0.2500E+01, 0.3346E+01, 0.3585E+01, 0.3946E+01, 0.3533E+01, &
    0.3205E+01,-0.4587E+02,-0.4587E+02,-0.4587E+02,-0.1601E+01, 0.5060E-01, 0.1275E+01, 0.2176E+01, 0.3081E+01, 0.3649E+01, &
    0.3940E+01, 0.4106E+01, 0.4112E+01, 0.4349E+01, 0.2292E+01,-0.4587E+02,-0.1222E+01, 0.3199E+00, 0.1642E+01, 0.2380E+01, &
    0.3254E+01, 0.3534E+01, 0.3687E+01, 0.3717E+01, 0.3402E+01, 0.3868E+01,-0.4587E+02,-0.4587E+02 /
   
   data((c15hcb(T_2,j,i),i=1,KG(15)),j=1,NUMPIR) / &
    0.2967E-01, 0.1697E-01, 0.1795E-01, 0.1387E-01, 0.2032E-01, 0.1187E-01, 0.2560E-01, 0.1044E-01,-0.4560E+00, 0.3059E-02, &
    0.3059E-02, 0.3059E-02, 0.2998E-01, 0.1586E-01, 0.1786E-01, 0.1521E-01, 0.1710E-01, 0.1061E-01, 0.2030E-01, 0.1158E-01, &
    0.4452E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.2993E-01, 0.1551E-01, 0.1481E-01, 0.9846E-02, 0.2443E-01, 0.1150E-01, &
    0.1865E-01, 0.1376E-01, 0.4617E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3035E-01, 0.1417E-01, 0.1438E-01, 0.1511E-01, &
    0.1901E-01, 0.8582E-02, 0.1746E-01, 0.1450E-01, 0.4523E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.2970E-01, 0.1347E-01, &
    0.1322E-01, 0.1252E-01, 0.1665E-01, 0.1037E-01, 0.1320E-01, 0.1199E-01, 0.4436E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.2949E-01, 0.1291E-01, 0.1671E-01, 0.1111E-01, 0.1400E-01, 0.1318E-01, 0.1060E-01, 0.1046E-01, 0.3059E-02, 0.3059E-02, &
    0.3059E-02, 0.3059E-02, 0.3004E-01, 0.1300E-01, 0.1413E-01, 0.9085E-02, 0.9764E-02, 0.2260E-01, 0.9778E-02, 0.4671E+00, &
    0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3086E-01, 0.1436E-01, 0.1205E-01, 0.1081E-01, 0.4681E-02, 0.1479E-01, &
    0.1888E-01, 0.3494E-01, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3094E-01, 0.1500E-01, 0.1457E-01, 0.1060E-01, &
    0.8319E-02, 0.8983E-02, 0.3791E-01, 0.2232E-01, 0.4631E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3158E-01, 0.1585E-01, &
    0.1292E-01, 0.6531E-02, 0.1383E-01, 0.4605E+00, 0.4662E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.3182E-01, 0.1586E-01, 0.8724E-02, 0.5798E-02, 0.2454E-01, 0.4607E+00, 0.4560E+00, 0.4511E+00, 0.3059E-02, 0.3059E-02, &
    0.3059E-02, 0.3059E-02, 0.2369E-01, 0.1606E-01, 0.5477E-02, 0.1228E-01, 0.4579E+00, 0.4561E+00, 0.4497E+00, 0.3059E-02, &
    0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.2190E-01, 0.1779E-01, 0.6267E-02, 0.4535E+00, 0.4533E+00, 0.3059E-02, &
    0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.2100E-01, 0.1653E-01, 0.7449E-02, 0.4543E+00, &
    0.4472E+00, 0.4439E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.3059E-02, 0.1864E-01, 0.1771E-01, &
    0.7040E-02, 0.2877E-01, 0.3381E-01, 0.2691E-01, 0.4466E+00, 0.3059E-02, 0.4613E+00, 0.3059E-02, 0.3059E-02, 0.3059E-02, &
    0.1637E-01, 0.1641E-01, 0.8424E-02, 0.1318E-01, 0.2060E-01, 0.3426E-01, 0.4122E-01, 0.4621E+00, 0.4555E+00, 0.4525E+00, &
    0.3059E-02, 0.3059E-02, 0.1607E-01, 0.1452E-01, 0.8013E-02, 0.1213E-01, 0.1482E-01, 0.2125E-01, 0.3379E-01, 0.3562E-01, &
    0.4619E+00, 0.4569E+00, 0.3059E-02, 0.3059E-02, 0.1698E-01, 0.1538E-01, 0.6616E-02, 0.1147E-01, 0.1217E-01, 0.1696E-01, &
    0.1871E-01, 0.2273E-01, 0.4513E-01, 0.4702E+00, 0.4617E+00, 0.4553E+00, 0.1700E-01, 0.1547E-01, 0.6456E-02, 0.1324E-01, &
    0.1502E-01, 0.2095E-01, 0.2547E-01, 0.2823E-01, 0.4107E-01, 0.4676E+00, 0.4583E+00, 0.4498E+00 /
   
   data((c15hcb(T_3,j,i),i=1,KG(15)),j=1,NUMPIR) / &
   -0.6747E-05,-0.2483E-04, 0.6575E-04, 0.1026E-03, 0.3888E-03,-0.8519E-04,-0.1629E-03,-0.1808E-04,-0.8355E-02,-0.4656E-05, &
   -0.4656E-05,-0.4656E-05,-0.2270E-04,-0.3427E-04, 0.5118E-04, 0.1218E-03, 0.1245E-03,-0.1245E-03, 0.3841E-05,-0.4151E-04, &
   -0.8763E-02,-0.1687E-01,-0.4656E-05,-0.4656E-05,-0.4557E-04,-0.3023E-04, 0.2286E-04, 0.5656E-04, 0.4113E-04,-0.1407E-03, &
   -0.1301E-03, 0.8503E-04,-0.7284E-02,-0.1669E-01,-0.4656E-05,-0.4656E-05,-0.5325E-04,-0.5309E-04,-0.1246E-04, 0.2244E-04, &
    0.5136E-04,-0.1272E-03, 0.4217E-04,-0.1749E-04,-0.8435E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.6857E-04,-0.7217E-04, &
    0.1740E-05, 0.3653E-04,-0.1490E-03,-0.4090E-04,-0.2376E-04, 0.2047E-04,-0.7974E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1232E-03,-0.9826E-04,-0.2849E-04, 0.1703E-04,-0.1895E-03,-0.3363E-03, 0.7102E-04,-0.1838E-05,-0.1655E-01,-0.4656E-05, &
   -0.4656E-05,-0.4656E-05,-0.9896E-04,-0.5127E-04,-0.2704E-04,-0.1218E-04,-0.1207E-03,-0.5883E-04, 0.6893E-04,-0.7924E-02, &
   -0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.7837E-04,-0.4980E-04, 0.6902E-05,-0.1072E-03,-0.4051E-04,-0.1991E-05, &
   -0.1173E-03,-0.5195E-04,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.8136E-04,-0.8102E-04, 0.1254E-03,-0.4658E-04, &
    0.3173E-04,-0.4461E-05,-0.1558E-03,-0.2036E-03, 0.8360E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.2232E-04,-0.6411E-04, &
    0.9486E-04,-0.2322E-03,-0.8282E-04,-0.8202E-02, 0.8416E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.1398E-03,-0.7165E-04,-0.4258E-04,-0.3970E-04,-0.2839E-03,-0.7873E-02, 0.8231E-02,-0.8213E-02,-0.4656E-05,-0.4656E-05, &
   -0.4656E-05,-0.4656E-05,-0.6754E-04,-0.7469E-04,-0.6898E-04,-0.1702E-03,-0.8079E-02,-0.7270E-02, 0.8116E-02,-0.4656E-05, &
   -0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.2396E-04,-0.2361E-04,-0.8664E-04,-0.8038E-02,-0.8207E-02,-0.4656E-05, &
   -0.4656E-05,-0.1670E-01,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.5479E-04,-0.7593E-04,-0.1005E-03, 0.8199E-02, &
   -0.7942E-02,-0.8244E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.4656E-05,-0.3806E-04,-0.5825E-04, &
   -0.1003E-03,-0.2925E-03,-0.1506E-03, 0.3148E-04, 0.8060E-02,-0.1593E-01, 0.8327E-02,-0.4656E-05,-0.4656E-05,-0.4656E-05, &
   -0.4706E-04,-0.3630E-04,-0.7811E-04,-0.6881E-04,-0.1822E-03,-0.3091E-03,-0.3033E-03,-0.7684E-02,-0.7663E-02, 0.8167E-02, &
   -0.4656E-05,-0.4656E-05,-0.7669E-04,-0.4610E-04,-0.8063E-04,-0.7250E-04,-0.1094E-03,-0.1241E-03,-0.2944E-03,-0.1736E-03, &
   -0.7886E-02, 0.8248E-02,-0.4656E-05,-0.4656E-05,-0.7138E-04,-0.4545E-04,-0.3653E-04,-0.6075E-04,-0.4528E-04,-0.1077E-03, &
   -0.1119E-03,-0.1657E-03,-0.4695E-03,-0.8112E-02,-0.7587E-02, 0.8217E-02,-0.6812E-04,-0.4558E-04,-0.6739E-04,-0.8861E-04, &
   -0.9386E-04,-0.1334E-03,-0.2007E-03,-0.2179E-03,-0.1650E-03,-0.8001E-02, 0.8273E-02, 0.8118E-02 /
   
   
   data((c16h2o(T_1,j,i),i=1,KG(16)),j=1,NUMPIR) / &
   -0.2344E+02,-0.2016E+02,-0.1986E+02,-0.1655E+02,-0.1243E+02,-0.8437E+01,-0.4858E+01,-0.2298E+02,-0.2014E+02,-0.1984E+02, &
   -0.1609E+02,-0.1198E+02,-0.8020E+01,-0.4548E+01,-0.2252E+02,-0.2012E+02,-0.1981E+02,-0.1564E+02,-0.1153E+02,-0.7596E+01, &
   -0.4239E+01,-0.2206E+02,-0.2009E+02,-0.1957E+02,-0.1517E+02,-0.1111E+02,-0.7161E+01,-0.3871E+01,-0.2160E+02,-0.2007E+02, &
   -0.1911E+02,-0.1472E+02,-0.1065E+02,-0.6721E+01,-0.3479E+01,-0.2113E+02,-0.2005E+02,-0.1865E+02,-0.1426E+02,-0.1021E+02, &
   -0.6302E+01,-0.3081E+01,-0.2067E+02,-0.2003E+02,-0.1819E+02,-0.1379E+02,-0.9765E+01,-0.5883E+01,-0.2678E+01,-0.2026E+02, &
   -0.2001E+02,-0.1773E+02,-0.1333E+02,-0.9332E+01,-0.5443E+01,-0.2253E+01,-0.2024E+02,-0.1999E+02,-0.1727E+02,-0.1288E+02, &
   -0.8897E+01,-0.5029E+01,-0.1858E+01,-0.2026E+02,-0.1959E+02,-0.1481E+02,-0.1147E+02,-0.7477E+01,-0.4555E+01,-0.1464E+01, &
   -0.2022E+02,-0.1632E+02,-0.1305E+02,-0.9885E+01,-0.6689E+01,-0.4108E+01,-0.1068E+01,-0.1936E+02,-0.1438E+02,-0.1163E+02, &
   -0.8499E+01,-0.6146E+01,-0.3673E+01,-0.6816E+00,-0.1675E+02,-0.1281E+02,-0.1020E+02,-0.7716E+01,-0.5678E+01,-0.3256E+01, &
   -0.3125E+00,-0.1510E+02,-0.1124E+02,-0.8821E+01,-0.7140E+01,-0.5243E+01,-0.2851E+01,-0.2560E-01,-0.1334E+02,-0.9708E+01, &
   -0.8061E+01,-0.6611E+01,-0.4842E+01,-0.2459E+01, 0.1711E+00,-0.1155E+02,-0.8798E+01,-0.7440E+01,-0.6123E+01,-0.4439E+01, &
   -0.2089E+01, 0.2480E+00,-0.1020E+02,-0.8154E+01,-0.6945E+01,-0.5681E+01,-0.4055E+01,-0.1737E+01, 0.2390E+00,-0.9464E+01, &
   -0.7677E+01,-0.6512E+01,-0.5284E+01,-0.3707E+01,-0.1453E+01, 0.2015E+00,-0.9033E+01,-0.7246E+01,-0.6093E+01,-0.4882E+01, &
   -0.3346E+01,-0.1264E+01, 0.1033E+00 /
   
   data((c16h2o(T_2,j,i),i=1,KG(16)),j=1,NUMPIR) / &
    0.4658E-01, 0.5840E-02, 0.4626E-02, 0.2688E-01, 0.2395E-01, 0.1804E-01, 0.2074E-01, 0.4660E-01, 0.1884E-02, 0.8561E-02, &
    0.2690E-01, 0.2403E-01, 0.1788E-01, 0.1934E-01, 0.4660E-01, 0.1800E-02, 0.1252E-01, 0.2694E-01, 0.2393E-01, 0.1786E-01, &
    0.1825E-01, 0.4660E-01, 0.1779E-02, 0.1649E-01, 0.2696E-01, 0.2397E-01, 0.1779E-01, 0.1765E-01, 0.4348E-01, 0.1758E-02, &
    0.2043E-01, 0.2696E-01, 0.2393E-01, 0.1748E-01, 0.1675E-01, 0.3944E-01, 0.1737E-02, 0.2445E-01, 0.2698E-01, 0.2384E-01, &
    0.1752E-01, 0.1549E-01, 0.3538E-01, 0.1654E-02, 0.2847E-01, 0.2702E-01, 0.2384E-01, 0.1714E-01, 0.1565E-01, 0.3127E-01, &
    0.1570E-02, 0.3245E-01, 0.2705E-01, 0.2374E-01, 0.1712E-01, 0.1514E-01, 0.2715E-01, 0.1444E-02, 0.3540E-01, 0.2711E-01, &
    0.2363E-01, 0.1702E-01, 0.1446E-01, 0.2960E-01, 0.1760E-01, 0.2977E-01, 0.2397E-01, 0.2087E-01, 0.1618E-01, 0.1445E-01, &
    0.2466E-01, 0.3039E-01, 0.2428E-01, 0.2217E-01, 0.1821E-01, 0.1593E-01, 0.1463E-01, 0.2640E-01, 0.2545E-01, 0.2231E-01, &
    0.2060E-01, 0.1773E-01, 0.1555E-01, 0.1473E-01, 0.3456E-01, 0.2135E-01, 0.2030E-01, 0.1844E-01, 0.1740E-01, 0.1559E-01, &
    0.1428E-01, 0.3203E-01, 0.2047E-01, 0.1809E-01, 0.1760E-01, 0.1725E-01, 0.1545E-01, 0.1541E-01, 0.2137E-01, 0.1857E-01, &
    0.1616E-01, 0.1698E-01, 0.1700E-01, 0.1537E-01, 0.1636E-01, 0.1338E-01, 0.1518E-01, 0.1580E-01, 0.1658E-01, 0.1710E-01, &
    0.1518E-01, 0.1513E-01, 0.1570E-01, 0.1614E-01, 0.1603E-01, 0.1673E-01, 0.1706E-01, 0.1497E-01, 0.1439E-01, 0.1987E-01, &
    0.1731E-01, 0.1601E-01, 0.1675E-01, 0.1681E-01, 0.1535E-01, 0.1425E-01, 0.2018E-01, 0.1723E-01, 0.1597E-01, 0.1691E-01, &
    0.1666E-01, 0.1509E-01, 0.1446E-01 /
   
   data((c16h2o(T_3,j,i),i=1,KG(16)),j=1,NUMPIR) / &
   -0.2873E-03,-0.8031E-04, 0.4225E-04,-0.9287E-04,-0.6013E-04,-0.4339E-04,-0.2474E-04,-0.2862E-03,-0.8372E-05, 0.1146E-03, &
   -0.9248E-04,-0.6166E-04,-0.3882E-04,-0.1827E-04,-0.2870E-03,-0.6851E-05, 0.1865E-03,-0.9172E-04,-0.6128E-04,-0.3616E-04, &
   -0.7612E-05,-0.2877E-03,-0.7231E-05, 0.1880E-03,-0.9287E-04,-0.5671E-04,-0.4110E-04,-0.1104E-04,-0.3429E-03,-0.7612E-05, &
    0.1149E-03,-0.9287E-04,-0.6356E-04,-0.4529E-04,-0.2436E-04,-0.4187E-03,-0.7992E-05, 0.4339E-04,-0.9325E-04,-0.6280E-04, &
   -0.4225E-04,-0.3197E-04,-0.4925E-03,-0.8754E-05,-0.2740E-04,-0.9477E-04,-0.6432E-04,-0.3768E-04,-0.3361E-04,-0.5511E-03, &
   -0.8753E-05,-0.9972E-04,-0.9515E-04,-0.6394E-04,-0.3806E-04,-0.3787E-04,-0.4792E-03,-0.1028E-04,-0.1534E-03,-0.9477E-04, &
   -0.6356E-04,-0.3616E-04,-0.2923E-04,-0.5070E-03, 0.1922E-03,-0.1028E-03,-0.5823E-04,-0.7954E-04,-0.2550E-04,-0.3893E-04, &
   -0.3776E-03,-0.1043E-03,-0.7993E-04,-0.7422E-04,-0.4948E-04,-0.3007E-04,-0.3863E-04, 0.8335E-04,-0.5709E-04,-0.6090E-04, &
   -0.7840E-04,-0.3692E-04,-0.3007E-04,-0.4251E-04,-0.6204E-04,-0.4872E-04,-0.3806E-04,-0.4681E-04,-0.3463E-04,-0.3007E-04, &
   -0.4312E-04,-0.1142E-04,-0.5176E-04,-0.5024E-04,-0.3007E-04,-0.3730E-04,-0.3037E-04,-0.3888E-04, 0.2550E-04,-0.6508E-04, &
   -0.2512E-04,-0.3083E-04,-0.3197E-04,-0.3041E-04,-0.3750E-04, 0.1484E-04,-0.1941E-04,-0.2626E-04,-0.3349E-04,-0.3463E-04, &
   -0.2896E-04,-0.1716E-04,-0.7231E-04,-0.3920E-04,-0.2893E-04,-0.3540E-04,-0.3311E-04,-0.3734E-04,-0.2550E-05,-0.7650E-04, &
   -0.3159E-04,-0.2778E-04,-0.3121E-04,-0.2169E-04,-0.4365E-04,-0.1546E-04,-0.7916E-04,-0.2931E-04,-0.2854E-04,-0.3654E-04, &
   -0.1979E-04,-0.4811E-04,-0.1435E-04 /
   
   
   data((c17h2o(T_1,j,i),i=1,KG(17)),j=1,NUMPIR) / &
   -0.2255E+02,-0.2000E+02,-0.1703E+02,-0.1282E+02,-0.9215E+01,-0.5938E+01,-0.2009E+01,-0.2209E+02,-0.1997E+02,-0.1657E+02, &
   -0.1236E+02,-0.8764E+01,-0.5499E+01,-0.1582E+01,-0.2163E+02,-0.1993E+02,-0.1611E+02,-0.1191E+02,-0.8324E+01,-0.5061E+01, &
   -0.1170E+01,-0.2117E+02,-0.1990E+02,-0.1565E+02,-0.1146E+02,-0.7889E+01,-0.4631E+01,-0.7737E+00,-0.2071E+02,-0.1987E+02, &
   -0.1519E+02,-0.1100E+02,-0.7440E+01,-0.4179E+01,-0.3719E+00,-0.2026E+02,-0.1985E+02,-0.1473E+02,-0.1054E+02,-0.6995E+01, &
   -0.3721E+01, 0.0000E+00,-0.2024E+02,-0.1982E+02,-0.1426E+02,-0.1009E+02,-0.6549E+01,-0.3284E+01, 0.4053E+00,-0.2022E+02, &
   -0.1980E+02,-0.1381E+02,-0.9639E+01,-0.6097E+01,-0.2821E+01, 0.8375E+00,-0.2021E+02,-0.1933E+02,-0.1335E+02,-0.9187E+01, &
   -0.5653E+01,-0.2379E+01, 0.1272E+01,-0.2010E+02,-0.1503E+02,-0.1125E+02,-0.7665E+01,-0.4492E+01,-0.1893E+01, 0.1642E+01, &
   -0.1747E+02,-0.1278E+02,-0.9547E+01,-0.6120E+01,-0.3756E+01,-0.1443E+01, 0.1995E+01,-0.1529E+02,-0.1095E+02,-0.8107E+01, &
   -0.5036E+01,-0.3182E+01,-0.1032E+01, 0.2429E+01,-0.1370E+02,-0.9303E+01,-0.6691E+01,-0.4357E+01,-0.2683E+01,-0.6173E+00, &
    0.2805E+01,-0.1150E+02,-0.7859E+01,-0.5618E+01,-0.3843E+01,-0.2234E+01,-0.2171E+00, 0.2973E+01,-0.9590E+01,-0.6537E+01, &
   -0.4886E+01,-0.3355E+01,-0.1805E+01, 0.1615E+00, 0.3157E+01,-0.7530E+01,-0.5699E+01,-0.4306E+01,-0.2892E+01,-0.1388E+01, &
    0.5448E+00, 0.3155E+01,-0.6758E+01,-0.5112E+01,-0.3809E+01,-0.2464E+01,-0.9947E+00, 0.8713E+00, 0.3203E+01,-0.6245E+01, &
   -0.4610E+01,-0.3376E+01,-0.2058E+01,-0.6166E+00, 0.1073E+01, 0.3109E+01,-0.5777E+01,-0.4175E+01,-0.2963E+01,-0.1671E+01, &
   -0.2556E+00, 0.1241E+01, 0.3014E+01 /
   
   data((c17h2o(T_2,j,i),i=1,KG(17)),j=1,NUMPIR) / &
    0.4264E-01, 0.1968E-02, 0.1863E-01, 0.1436E-01, 0.1101E-01, 0.1055E-01, 0.1281E-01, 0.4264E-01, 0.1989E-02, 0.1861E-01, &
    0.1438E-01, 0.1095E-01, 0.1030E-01, 0.1211E-01, 0.3996E-01, 0.1968E-02, 0.1861E-01, 0.1434E-01, 0.1103E-01, 0.1019E-01, &
    0.1160E-01, 0.3600E-01, 0.1947E-02, 0.1861E-01, 0.1442E-01, 0.1086E-01, 0.1003E-01, 0.1157E-01, 0.3203E-01, 0.5756E-02, &
    0.1861E-01, 0.1444E-01, 0.1080E-01, 0.9922E-02, 0.1151E-01, 0.2801E-01, 0.9713E-02, 0.1859E-01, 0.1446E-01, 0.1070E-01, &
    0.9880E-02, 0.1066E-01, 0.2393E-01, 0.1369E-01, 0.1859E-01, 0.1451E-01, 0.1057E-01, 0.9880E-02, 0.1072E-01, 0.1987E-01, &
    0.1767E-01, 0.1863E-01, 0.1451E-01, 0.1040E-01, 0.9880E-02, 0.1057E-01, 0.1572E-01, 0.2169E-01, 0.1863E-01, 0.1442E-01, &
    0.1022E-01, 0.9742E-02, 0.1036E-01, 0.3391E-02, 0.1884E-01, 0.1566E-01, 0.1105E-01, 0.1011E-01, 0.1001E-01, 0.1017E-01, &
    0.1982E-01, 0.1444E-01, 0.1189E-01, 0.1030E-01, 0.9859E-02, 0.9861E-02, 0.1038E-01, 0.1748E-01, 0.1321E-01, 0.9922E-02, &
    0.1068E-01, 0.1013E-01, 0.9937E-02, 0.9958E-02, 0.1346E-01, 0.9943E-02, 0.9566E-02, 0.1097E-01, 0.9815E-02, 0.9964E-02, &
    0.1059E-01, 0.9817E-02, 0.7159E-02, 0.8687E-02, 0.1114E-01, 0.1007E-01, 0.1014E-01, 0.1058E-01, 0.3370E-02, 0.7264E-02, &
    0.9378E-02, 0.1112E-01, 0.9767E-02, 0.1016E-01, 0.1101E-01, 0.2993E-02, 0.8017E-02, 0.9566E-02, 0.1116E-01, 0.9738E-02, &
    0.1025E-01, 0.1086E-01, 0.8331E-02, 0.8771E-02, 0.1001E-01, 0.1117E-01, 0.9847E-02, 0.1076E-01, 0.1084E-01, 0.7850E-02, &
    0.9378E-02, 0.1001E-01, 0.1105E-01, 0.9964E-02, 0.1113E-01, 0.1168E-01, 0.8038E-02, 0.9336E-02, 0.9817E-02, 0.1096E-01, &
    0.1024E-01, 0.1175E-01, 0.1107E-01 /
   
   data((c17h2o(T_3,j,i),i=1,KG(17)),j=1,NUMPIR) / &
   -0.2188E-03,-0.2283E-05,-0.8069E-04,-0.4415E-04,-0.2284E-04,-0.4491E-04,-0.4518E-04,-0.2196E-03,-0.2665E-05,-0.8107E-04, &
   -0.4301E-04,-0.2398E-04,-0.4795E-04,-0.4693E-04,-0.2683E-03,-0.3045E-05,-0.8107E-04,-0.4301E-04,-0.2246E-04,-0.4757E-04, &
   -0.4152E-04,-0.3403E-03,-0.4187E-05,-0.8031E-04,-0.3996E-04,-0.1865E-04,-0.4301E-04,-0.4350E-04,-0.4118E-03, 0.6584E-04, &
   -0.8107E-04,-0.4034E-04,-0.1903E-04,-0.4643E-04,-0.4834E-04,-0.4803E-03, 0.1378E-03,-0.8069E-04,-0.4072E-04,-0.1713E-04, &
   -0.5176E-04,-0.3460E-04,-0.4099E-03, 0.2101E-03,-0.8069E-04,-0.3920E-04,-0.1713E-04,-0.5024E-04,-0.3524E-04,-0.3391E-03, &
    0.2809E-03,-0.7992E-04,-0.3616E-04,-0.2017E-04,-0.5633E-04,-0.4886E-04,-0.2668E-03, 0.2078E-03,-0.8069E-04,-0.3768E-04, &
   -0.2131E-04,-0.5580E-04,-0.5454E-04,-0.2207E-04,-0.8601E-04,-0.4643E-04,-0.2436E-04,-0.4148E-04,-0.5458E-04,-0.4579E-04, &
   -0.5138E-04,-0.2893E-04,-0.3273E-04,-0.3882E-04,-0.3920E-04,-0.5035E-04,-0.3170E-04,-0.2169E-04,-0.3007E-04,-0.2740E-04, &
   -0.5328E-04,-0.4491E-04,-0.4403E-04,-0.6383E-04, 0.4834E-04,-0.2702E-04,-0.4453E-04,-0.4339E-04,-0.4457E-04,-0.4551E-04, &
   -0.8133E-04, 0.3768E-04,-0.7611E-06,-0.2626E-04,-0.4643E-04,-0.4305E-04,-0.4840E-04,-0.5149E-04, 0.7193E-04,-0.2169E-04, &
   -0.4491E-04,-0.3996E-04,-0.4483E-04,-0.4487E-04,-0.6698E-04,-0.4834E-04,-0.3463E-04,-0.4986E-04,-0.4377E-04,-0.4514E-04, &
   -0.5377E-04,-0.2626E-04,-0.4187E-04,-0.3692E-04,-0.5100E-04,-0.4651E-04,-0.4392E-04,-0.5386E-04,-0.4643E-04,-0.4301E-04, &
   -0.3578E-04,-0.5176E-04,-0.4594E-04,-0.4551E-04,-0.3920E-04,-0.3425E-04,-0.4491E-04,-0.3654E-04,-0.5138E-04,-0.4377E-04, &
   -0.5614E-04,-0.5758E-04,-0.3600E-04 /
   
   
   data((c18h2o(T_1,j,i),i=1,KG(18)),j=1,NUMPIR) / &
   -0.2121E+02,-0.2002E+02,-0.1676E+02,-0.1274E+02,-0.8780E+01,-0.5167E+01,-0.2692E+01,-0.6275E+00,-0.2075E+02,-0.1996E+02, &
   -0.1630E+02,-0.1228E+02,-0.8324E+01,-0.4718E+01,-0.2260E+01,-0.2303E+00,-0.2029E+02,-0.1990E+02,-0.1584E+02,-0.1182E+02, &
   -0.7868E+01,-0.4269E+01,-0.1806E+01, 0.1645E+00,-0.2022E+02,-0.1985E+02,-0.1538E+02,-0.1136E+02,-0.7417E+01,-0.3820E+01, &
   -0.1373E+01, 0.5657E+00,-0.2018E+02,-0.1981E+02,-0.1492E+02,-0.1090E+02,-0.6965E+01,-0.3369E+01,-0.9319E+00, 0.9577E+00, &
   -0.2013E+02,-0.1937E+02,-0.1446E+02,-0.1044E+02,-0.6512E+01,-0.2917E+01,-0.4928E+00, 0.1376E+01,-0.2009E+02,-0.1891E+02, &
   -0.1400E+02,-0.9984E+01,-0.6063E+01,-0.2466E+01,-0.6887E-01, 0.1768E+01,-0.2006E+02,-0.1845E+02,-0.1354E+02,-0.9530E+01, &
   -0.5618E+01,-0.2024E+01, 0.3615E+00, 0.2196E+01,-0.2003E+02,-0.1800E+02,-0.1308E+02,-0.9075E+01,-0.5174E+01,-0.1593E+01, &
    0.7820E+00, 0.2600E+01,-0.1827E+02,-0.1464E+02,-0.1097E+02,-0.7525E+01,-0.3733E+01,-0.1077E+01, 0.1204E+01, 0.3014E+01, &
   -0.1525E+02,-0.1210E+02,-0.9275E+01,-0.5876E+01,-0.2768E+01,-0.6286E+00, 0.1622E+01, 0.3394E+01,-0.1298E+02,-0.1060E+02, &
   -0.7764E+01,-0.4462E+01,-0.2154E+01,-0.2001E+00, 0.2034E+01, 0.3756E+01,-0.1157E+02,-0.8941E+01,-0.5984E+01,-0.3509E+01, &
   -0.1651E+01, 0.2279E+00, 0.2422E+01, 0.4066E+01,-0.9986E+01,-0.7062E+01,-0.4794E+01,-0.2818E+01,-0.1196E+01, 0.6394E+00, &
    0.2791E+01, 0.4283E+01,-0.8064E+01,-0.5512E+01,-0.3933E+01,-0.2274E+01,-0.7559E+00, 0.1036E+01, 0.3085E+01, 0.4444E+01, &
   -0.6440E+01,-0.4863E+01,-0.3219E+01,-0.1791E+01,-0.3279E+00, 0.1427E+01, 0.3304E+01, 0.4527E+01,-0.5902E+01,-0.4207E+01, &
   -0.2756E+01,-0.1350E+01, 0.7686E-01, 0.1776E+01, 0.3475E+01, 0.4550E+01,-0.5439E+01,-0.3739E+01,-0.2330E+01,-0.9233E+00, &
    0.4612E+00, 0.2066E+01, 0.3564E+01, 0.4502E+01,-0.5006E+01,-0.3316E+01,-0.1906E+01,-0.5066E+00, 0.8352E+00, 0.2272E+01, &
    0.3587E+01, 0.4419E+01 /
   
   data((c18h2o(T_2,j,i),i=1,KG(18)),j=1,NUMPIR) / &
    0.2338E-01, 0.1968E-02, 0.9503E-02, 0.3412E-02, 0.6280E-03,-0.1109E-02,-0.1089E-02,-0.1026E-02, 0.1972E-01, 0.2093E-02, &
    0.9503E-02, 0.3391E-02, 0.6489E-03,-0.1172E-02,-0.1164E-02,-0.1158E-02, 0.1603E-01, 0.3328E-02, 0.9524E-02, 0.3391E-02, &
    0.6489E-03,-0.1277E-02,-0.1229E-02,-0.1296E-02, 0.1229E-01, 0.7138E-02, 0.9524E-02, 0.3370E-02, 0.6070E-03,-0.1319E-02, &
   -0.1264E-02,-0.1610E-02, 0.8478E-02, 0.1095E-01, 0.9566E-02, 0.3412E-02, 0.5652E-03,-0.1382E-02,-0.1266E-02,-0.1566E-02, &
    0.4563E-02, 0.1480E-01, 0.9566E-02, 0.3412E-02, 0.5443E-03,-0.1423E-02,-0.1199E-02,-0.1679E-02, 0.2261E-02, 0.1865E-01, &
    0.9608E-02, 0.3454E-02, 0.4815E-03,-0.1423E-02,-0.1296E-02,-0.1555E-02, 0.2198E-02, 0.2250E-01, 0.9671E-02, 0.3412E-02, &
    0.4187E-03,-0.1426E-02,-0.1472E-02,-0.1800E-02, 0.2072E-02, 0.2600E-01, 0.9734E-02, 0.3433E-02, 0.3977E-03,-0.1428E-02, &
   -0.1541E-02,-0.1591E-02, 0.1987E-01, 0.8645E-02, 0.6280E-02, 0.1298E-02,-0.1151E-02,-0.1509E-02,-0.1662E-02,-0.1570E-02, &
    0.4668E-02, 0.8373E-02, 0.3956E-02,-0.4187E-04,-0.1968E-02,-0.1624E-02,-0.1700E-02,-0.1947E-02, 0.9231E-02, 0.5694E-02, &
    0.1444E-02,-0.2512E-03,-0.1827E-02,-0.1662E-02,-0.1576E-02,-0.1633E-02, 0.8666E-02, 0.3077E-02,-0.1737E-02,-0.1277E-02, &
   -0.1507E-02,-0.1757E-02,-0.1612E-02,-0.1612E-02, 0.8164E-03,-0.4375E-02,-0.1884E-02,-0.1277E-02,-0.1564E-02,-0.1853E-02, &
   -0.1591E-02,-0.1486E-02,-0.1486E-02,-0.2596E-02,-0.1633E-02,-0.1539E-02,-0.1662E-02,-0.1846E-02,-0.1423E-02,-0.1277E-02, &
   -0.1423E-02,-0.2617E-02,-0.1005E-02,-0.1379E-02,-0.1687E-02,-0.1905E-02,-0.1528E-02,-0.1298E-02,-0.1675E-03,-0.1947E-02, &
   -0.5024E-03,-0.1325E-02,-0.1696E-02,-0.1698E-02,-0.1486E-02,-0.1277E-02, 0.1047E-03,-0.1109E-02,-0.5861E-03,-0.1363E-02, &
   -0.1620E-02,-0.1666E-02,-0.1507E-02,-0.9210E-03, 0.1047E-03,-0.1047E-02,-0.8394E-03,-0.1342E-02,-0.1591E-02,-0.1323E-02, &
   -0.1340E-02,-0.9420E-03 /
   
   data((c18h2o(T_3,j,i),i=1,KG(18)),j=1,NUMPIR) / &
   -0.1085E-03, 0.2283E-05,-0.4719E-04,-0.3807E-06,-0.1522E-05,-0.3425E-05,-0.7612E-06, 0.1751E-05,-0.1766E-03, 0.1523E-05, &
   -0.4719E-04,-0.7609E-06,-0.3807E-06,-0.3045E-05, 0.1599E-05, 0.8723E-05,-0.2443E-03, 0.1941E-04,-0.4757E-04,-0.1522E-05, &
   -0.3806E-06,-0.1903E-05,-0.2778E-05, 0.1294E-04,-0.1838E-03, 0.8563E-04,-0.4757E-04,-0.1903E-05, 0.1142E-05,-0.2664E-05, &
   -0.6090E-06, 0.1321E-04,-0.1161E-03, 0.1526E-03,-0.4757E-04,-0.2664E-05,-0.3805E-06,-0.3806E-05,-0.2093E-05, 0.2253E-04, &
   -0.4795E-04, 0.9248E-04,-0.4757E-04,-0.1903E-05, 0.0000E+00,-0.3045E-05,-0.7992E-06, 0.1393E-04,-0.9134E-05, 0.2246E-04, &
   -0.4834E-04,-0.2664E-05, 0.3804E-06,-0.5328E-05,-0.1510E-05, 0.1465E-04,-0.1028E-04,-0.4757E-04,-0.4948E-04,-0.1142E-05, &
    0.7614E-06,-0.4910E-05,-0.5709E-06, 0.1477E-04,-0.1256E-04,-0.1066E-03,-0.4910E-04,-0.1523E-05,-0.3805E-06,-0.3121E-05, &
   -0.2512E-05, 0.1142E-04,-0.7878E-04,-0.2664E-05,-0.8373E-05,-0.7612E-06, 0.1104E-04,-0.3311E-05,-0.1979E-05, 0.5709E-05, &
   -0.2626E-04,-0.4872E-04,-0.3808E-06,-0.2283E-05, 0.2284E-05,-0.3349E-05,-0.4034E-05, 0.7231E-05,-0.4910E-04, 0.1599E-04, &
    0.1256E-04,-0.7612E-05, 0.1180E-05,-0.1815E-05,-0.7193E-05, 0.3045E-05, 0.1576E-09, 0.6470E-05,-0.1408E-04,-0.1903E-05, &
    0.1522E-05,-0.4746E-05,-0.4948E-05, 0.3806E-06, 0.9020E-04, 0.5214E-04, 0.6090E-05,-0.1104E-04, 0.1180E-05,-0.2778E-05, &
   -0.6090E-05,-0.2664E-05,-0.6737E-04,-0.1218E-04,-0.3806E-05,-0.5214E-05,-0.1066E-05,-0.1294E-05,-0.3045E-05,-0.2664E-05, &
   -0.4643E-04, 0.1713E-04,-0.1218E-04,-0.6204E-05,-0.2360E-05,-0.1979E-05,-0.1903E-05,-0.3806E-05,-0.3045E-04,-0.1256E-04, &
   -0.9134E-05,-0.6508E-05,-0.1027E-05,-0.7993E-06,-0.1142E-05,-0.7992E-05,-0.3616E-04,-0.1028E-04,-0.1066E-04,-0.6051E-05, &
    0.1066E-05,-0.1751E-05,-0.2284E-05,-0.2284E-05,-0.3920E-04,-0.9895E-05,-0.1321E-04,-0.3844E-05,-0.2055E-05,-0.2512E-05, &
   -0.3806E-05,-0.3425E-05 /


contains
   
subroutine gases  ( ncol ,   nlm ,    ib ,    ig   &
     ,                pp ,    dp ,    tt ,  rmix   &
     ,             o3mix , umco2 , umch4 , umn2o   &
     ,                hk ,    tg ,   pkd ,   ip1   &
     ,               ip2                           &
                  )

!-----------------------------------------------------------------------
! Calculates the non-gray spectral absorption due to H2O, O3, CO2,
! CHA4, and N2O at long and short wavelengths.

   ! INPUT ARGUMENTS:
   integer (kind=int_kind), intent(in)::   &
    ncol        &! Length of sub-domain.
   ,nlm         &! Number of layers.
   ,ib          &! Index of spectral interval.
   ,ig           ! Index of k-distribution.

   integer (kind=int_kind), intent(in), dimension(ncol,nlm):: &
    ip1         &!Used in conjunction with pressure weighting.
   ,ip2          !Used in conjunction with pressure weighting.

   real (kind=dbl_kind), intent(in):: &
    umco2       &!Concentration of CO2                          (ppm).
   ,umch4       &!Concentration of CH4                          (???).
   ,umn2o        !Concentration of N2O                          (???).
  
   real (kind=dbl_kind), intent(in), dimension(ncol,nlm):: &
    dp          &!Layer Thickness                               (hPa).
   ,tt          &!Layer Temperature                               (K).
   ,rmix        &!Layer Water Vapor Mixing Ratio              (kg/kg).
   ,o3mix       &!Layer Ozone Mixing Ratio                    (kg/kg).    
   ,pkd          !Used in conjunction with pressure weighting     (-).
  
   real (kind=dbl_kind), intent(in), dimension(ncol,nlm+1):: &
    pp           !Level Pressure                                (hPa).   
  
   ! OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out):: &
    hk           !Weight                                          (-).
     
   real (kind=dbl_kind), intent(out), dimension(ncol,nlm):: &
    tg           !Transmission                                    (-).
    
   ! LOCAL VARIABLES:

   real (kind=dbl_kind), dimension(ncol,nlm):: &
    fkg , fkga , fkgb , pq &
   ,tg1 ,  tg2 ,  tg3
     
!-----------------------------------------------------------------------
   select case (ib)
   case (1)
      ! (50000-14500 cm^-1 ):  nongray absorption by O3.
      ! 619.618 is the solar energy contained in that band (Wm^-2).
      call qopo3s(fk1o3(ig),dp,o3mix,tg)
      hk = 619.618*hk1(ig)

   case (2)
      ! (14500-7700 cm^-1):  nongray absorption by H2O.
      ! 484.295 is the solar energy contained in the band (Wm^-2).
      call qk(ncol,nlm,c2h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)
      hk = 484.295*hk2(ig)

   case (3)
      ! (7700-5250 cm^-1):  nongray absorption by H2O.
      ! 149.845 is the solar energy contained in the band (Wm^-2).
      call qk(ncol,nlm,c3h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)
      hk = 149.845*hk3(ig)

   case (4)
      ! (5250-4000 cm^-1):  nongray absorption by H2O.
      ! 48.7302 is the solar energy contained in the band (Wm^-2).	
      call qk(ncol,nlm,c4h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)      
      hk = 48.7302*hk4(ig)

   case (5)
      ! (4000-2850 cm^-1):  nongray absorption by H2O.
      ! 31.6576 is the solar energy contained in the band (Wm^-2).
      call qk(ncol,nlm,c5h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)      
      hk = 31.6576*hk5(ig)

   case (6)
      ! (2850-2500 cm^-1):  nongray absorption by H2O.
      ! 5.79927 is the solar energy contained in the band (Wm^-2).	
      call qk(ncol,nlm,c6h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)      
      hk = 5.79927*hk6(ig)

   case (7)
      ! (2200-1900 cm^-1):  nongray absorption by H2O.
      call qk(ncol,nlm,c7h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)
      hk = hk7(ig)

   case (8)      
      ! (1900-1700 cm^-1):  nongray absorption by H2O.
      call qk(ncol,nlm,c8h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)      
      hk = hk8(ig)

   case (9)
      ! (1700-1400 cm^-1):  nongray absorption by H2O.
      call qk(ncol,nlm,c9h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)      
      hk = hk9(ig)     

   case (10)
      ! (1400-1250 cm^-1):  overlapping absorption by H2O, CH4, and N2O
      ! using approach one of Fu(1991).	
      call qk(ncol,nlm,c10h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg1)      
      call qk(ncol,nlm,c10ch4,tt,fkg,pkd,ip1,ip2)
      call qopch4(fkg,dp,tg2)
      call qk(ncol,nlm,c10n2o,tt,fkg,pkd,ip1,ip2)
      call qopn2o(fkg,dp,tg3)

      tg = tg1 + tg2/1.6*umch4 + tg3/0.28*umn2o
      hk = hk10(ig)     

   case (11)
      ! (1250-1100 cm^-1):  overlapping absorption by H2O, CH4, and N2O
      ! using approach one of Fu(1991).      
      call qk(ncol,nlm,c11h2o(:,:,ig),tt,fkg,pkd,ip1,ip2) 
      call qoph2o(fkg,dp,rmix,tg1)        
      call qk(ncol,nlm,c11ch4,tt,fkg,pkd,ip1,ip2)
      call qopch4(fkg,dp,tg2)      
      call qk(ncol,nlm,c11n2o,tt,fkg,pkd,ip1,ip2)
      call qopn2o(fkg,dp,tg3)
      
      tg = tg1 + tg2/1.6*umch4 + tg3/0.28*umn2o
      hk = hk11(ig)

   case(12)
      ! (1100-980 cm^-1):  overlapping absorption by H2O and O3
      ! using approach one of Fu(1991).	
      call qkio3(ncol,nlm,c12o3(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qopo3i(fkg,dp,o3mix,tg1)
      call qk(ncol,nlm,c12h2o,tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg2)      
      
      tg = tg1 + tg2
      hk = hk12(ig)

   case (13)
      ! (980-800 cm^-1 ):  nongray absorption by H2O.
      call qk(ncol,nlm,c13h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)       
      hk = hk13(ig)

   case (14)
      ! (800-670 cm^-1):  overlapping absorption by H2O and CO2
      ! using approach two of Fu(1991).

      where (pp .ge. 63.1)
         pq = rmix
      elsewhere
        pq = 0._dbl_kind
      end where

      call qk(ncol,nlm,c14hca(:,:,ig),tt,fkga,pkd,ip1,ip2)
      call qk(ncol,nlm,c14hcb(:,:,ig),tt,fkgb,pkd,ip1,ip2)
      
      fkg = fkga/330.0*umco2+pq*fkgb
      call qophc(fkg,dp,tg)
      hk = hk14(ig)

   case (15)
      ! (670-540 cm^-1):  overlapping absorption by H2O and CO2
      ! using approach two of Fu(1991).

      where (pp .ge. 63.1)
         pq = rmix
      elsewhere
        pq = 0._dbl_kind
      end where
      call qk(ncol,nlm,c15hca(:,:,ig),tt,fkga,pkd,ip1,ip2)
      call qk(ncol,nlm,c15hcb(:,:,ig),tt,fkgb,pkd,ip1,ip2)
      
      fkg = fkga/330.0*umco2+pq*fkgb
      call qophc(fkg,dp,tg)
      hk = hk15(ig)

   case (16)
      ! (540-400 cm^-1 ):  nongray absorption by H2O.
      call qk(ncol,nlm,c16h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)      
      hk = hk16(ig)

   case (17)
      ! (400-280 cm^-1 ):  nongray absorption by H2O.
      call qk(ncol,nlm,c17h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)         
      hk = hk17(ig)

   case (18)
      ! (280-000 cm^-1 ):  nongray absorption by H2O.
      call qk(ncol,nlm,c18h2o(:,:,ig),tt,fkg,pkd,ip1,ip2)
      call qoph2o(fkg,dp,rmix,tg)       
      hk = hk18(ig)

   case default
      stop
   end select

   return
end subroutine gases


subroutine qopch4 (fkg,   dp,   tg)
!-----------------------------------------------------------------------
! Absorption by CH4 in the 1400-1250cm^-1 and 1250-1100cm^-1
! spectral intervals.
      
   use bugsrad_physconst, only:  molar_volume,gravity,MW_dry_air
   implicit none

! ARGUMENT LIST VARIABLES:
!  INPUT ARGUMENTS:
!  ----------------
   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
     dp      &!Layer Thickness                       (hPa).
    ,fkg      !Gaseous absorption coefficients (cm-atm)^-1.
     
!  OUTPUT ARGUMENTS:
!  -----------------
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
     tg       !Transmission (-).
     
   real (kind=dbl_kind) :: &
     ch4_conc                   !ppv

   ch4_conc = 1.6e-6_dbl_kind
   tg = fkg*dp*molar_volume*10.0/gravity*ch4_conc/MW_dry_air

   return
end subroutine qopch4


subroutine qopn2o (fkg , dp,  tg)
!-----------------------------------------------------------------------
! Absorption by N2O in the 1400-1250cm^-1 and 1250-1100cm^-1
! spectral intervals.

   use bugsrad_physconst, only:  molar_volume, gravity, MW_dry_air
   implicit none

   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
     dp      & !Layer Thickness                       (hPa).
    ,fkg       !Gaseous absorption coefficients (cm-atm)^-1.
     
   !  OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
     tg   !Transmission                             (-).
     
   real (kind = dbl_kind)::  &
     n2o_conc              !ppv

   n2o_conc = 0.28e-6_dbl_kind
   tg = fkg*dp*molar_volume*10.0/gravity*n2o_conc/MW_dry_air

   return
end subroutine qopn2o


subroutine qoph2o (fkg , dp ,  rmix ,  tg)
!-----------------------------------------------------------------------
! Absorption by H2O in each SW and LW spectral interval.

   use bugsrad_physconst, only:  molar_volume, gravity, MW_h2o
   implicit none

   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
     dp          & !Layer Thickness                       (hPa).
    ,rmix        & !Water Vapor Mixing Ratio            (kg/kg).
    ,fkg          !Gaseous absorption coefficients (cm-atm)^-1.
     
   !  OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
     tg   !Transmisssion                           (-).
     
   tg = fkg*rmix*dp*molar_volume/MW_h2o*10.0/gravity

   return
end subroutine qoph2o


subroutine qopo3i (fkg , dp , o3mix ,  tg )
!-----------------------------------------------------------------------
! Absorption by O3 in the infrared band (1100-980 cm^-1).
      
   use bugsrad_physconst, only:  molar_volume, gravity, MW_o3
   implicit none
   
   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
      dp        &  !Layer Thickness                       (hPa).
     ,o3mix     &  !Ozone Mixing Ratio                  (kg/kg).
     ,fkg          !Gaseous absorption coefficients (cm-atm)^-1.
  
   !  OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
      tg    !Transmission                            (-).
  
   tg = fkg*o3mix*dp*molar_volume/MW_o3*10.0/gravity

   return
end subroutine qopo3i


subroutine qopo3s (fk , dp , o3mix ,  tg )
!-----------------------------------------------------------------------      
! Computes non-gray absorption of O3.

   use bugsrad_physconst, only:  molar_volume, gravity, MW_o3
   implicit none

   real (kind=dbl_kind), intent(in):: &
      fk            !
  
   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
     dp           & !Layer Thickness      (hPa).
    ,o3mix          !Ozone Mixing Ratio (kg/kg).

   !  OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
     tg             !Transmission           (-).
  
   tg = o3mix*dp*fk*molar_volume/MW_o3*10.0/gravity

   return
end subroutine qopo3s


subroutine qophc(fkg,dp,tg)
!-----------------------------------------------------------------------
! Overlapping of H2O and CO2 bands.
      
   implicit none

   ! INPUT ARGUMENTS
   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
     dp       & !Layer Thickness                       (hPa).
    ,fkg        !Gaseous absorption coefficients (cm-atm)^-1.
     
   !  OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
     tg   !Transmission                            (-).
     
   tg = fkg*dp
   return
end subroutine qophc

subroutine qk(ncol,nlm,coefk,tt,fkg,pkd,ip1,ip2)
!-----------------------------------------------------------------------
! Interpolates the correlated k coeffients to the temperatures tt
! using the form
!   ln k = a + b * ( t - 245 ) + c * ( t - 245 ) ** 2
! and linearly interpolates in pressure if needed.

   implicit none
      
   ! INPUT ARGUMENTS:
   integer (kind=int_kind), intent(in)::  &
    ncol         & !Length of sub-domain.
   ,nlm            !Number of layers.

   integer (kind=int_kind), intent(in), dimension(:,:)::  &
    ip1          & !Used in conjunction with pressure weigthing.
   ,ip2            !Used in conjunction with pressure weigthing.

   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
    coefk          !Pre-computed coefficients.
     
   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
    tt           & !Layer temperature (K).
   ,pkd            !Scaled pressure (hPa).
     
   ! OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
    fkg    !Gaseous absorption coefficients (cm-atm)^-1.  

   ! LOCAL VARIABLES:
   integer (kind=int_kind)::  &
    i, l, i1, i2

   real (kind=dbl_kind)::  &
    x1,x2,y1
     

   do l = 1, nlm
      do i = 1, ncol
         i1=ip1(i,l)
         i2=ip2(i,l)
         y1 = tt(i,l) - 245.0
         if (y1.lt.-65.) y1 = -65.
         if (y1.gt.75.) y1 = 75.
         x1 = exp(coefk(1,i1)+coefk(2,i1)*y1+coefk(3,i1)*y1**2)
         if(i1.eq.i2) then
            fkg(i,l) = x1 * pkd(i,l)
         else
            x2 = exp(coefk(1,i2)+coefk(2,i2)*y1+coefk(3,i2)*y1**2)
            fkg(i,l) = x1 + ( x2 - x1 ) * pkd(i,l)
         endif
      enddo
   enddo

   return
end subroutine qk

subroutine qkio3 (ncol , nlm , coefk ,  tt , fkg , pkd ,    ip1 , ip2)
! Computes the gaseous absorption coefficients in units of (cm-atm)^-1
! for a given cumulative probability in nlm layers. coefk are
! the coefficients used to calculate the absorption coefficient at the
! temperature t for the 19 pressures by
!   ln k = a + b * ( t - 250 ) + c * ( t - 250 ) ** 2
! and the absorption coefficient at conditions other than those nineteen
! pressures is interpolated linearly with pressure (Fu, 1991).
      
   implicit none

   ! INPUT ARGUMENTS:
   integer (kind=int_kind), intent(in)::  &
    ncol         & !Length of sub-domain.
   ,nlm            !Number of layers.

   integer (kind=int_kind), intent(in), dimension(:,:)::  &
    ip1          & !Used in conjunction with pressure weigthing.
   ,ip2            !Used in conjunction with pressure weigthing.

   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
    coefk          !Pre-computed coefficients.
  
   real (kind=dbl_kind), intent(in), dimension(:,:)::  &
    tt           & !Layer temperature  (K).
   ,pkd            !Scaled pressure  (hPa).
 
 
   ! OUTPUT ARGUMENTS:
   real (kind=dbl_kind), intent(out), dimension(:,:)::  &
    fkg    !Gaseous absorption coefficients (cm-atm)^-1.  


   ! LOCAL VARIABLES:
   integer (kind=int_kind)::  &
    i, l, i1, i2     

   real (kind=dbl_kind)::  &
    x1,x2,y1
      
   do l = 1, nlm
      do i = 1, ncol
         i1 = ip1(i,l)
         i2 =ip2(i,l)
         y1 = tt(i,l) - 250.0
         if (y1.lt.-70.) y1 = -70.
         if (y1.gt.75.) y1 = 70.
         x1 = exp(coefk(1,i1)+coefk(2,i1)*y1+coefk(3,i1)*y1**2)
         if(i1.eq.i2) then
            fkg(i,l) = x1 * pkd(i,l)
         else
            x2 = exp(coefk(1,i2)+coefk(2,i2)*y1+coefk(3,i2)*y1**2)
            fkg(i,l) = x1 + ( x2 - x1 ) * pkd(i,l)
         endif
      enddo
   enddo

   return
end subroutine qkio3

subroutine pscale (ncol , nlm , ppl, stanp, pkd , ip1 , ip2 )
!-----------------------------------------------------------------------
! pscale is used to scale pressure for use in the k-distribu
! tion routine.
 
   implicit none

   ! INPUT ARGUMENTS:
   integer (kind=int_kind), intent(in)::  &
    ncol         & !Length of sub-domain.
   ,nlm            !Number of layers.
     
   real (kind=dbl_kind), dimension(:,:)::  &
    ppl            !Pressure          (hPa).

   real (kind=dbl_kind), dimension(:):: &
    stanp

   ! OUTPUT ARGUMENTS:
   integer (kind=int_kind), dimension(:,:)::  &
    ip1            & !pointer.
   ,ip2              !pointer.
     
   real (kind=dbl_kind), dimension(:,:)::  &
    pkd              !Weighted pressure (hPa).

   ! LOCAL VARIABLES:
   integer (kind=int_kind)::  &
    n_stanp

   integer (kind=int_kind)::  &
    i1, icol, l

   n_stanp = size(stanp)

   do icol = 1, ncol
      i1 = 1
      do l = 1, nlm
         if( ppl(icol,l) .lt. stanp(1) ) then
            pkd(icol,l) = ppl(icol,l) / stanp(1)
            ip1(icol,l) = 1
            ip2(icol,l) = 1
         elseif ( ppl(icol,l) .ge. stanp(n_stanp) ) then
            pkd(icol,l) = (ppl(icol,l) - stanp(n_stanp-1))  &
                        / (stanp(n_stanp) - stanp(n_stanp-1))
            ip1(icol,l) = n_stanp - 1
            ip2(icol,l) = n_stanp
         else
30          continue
            if ( ppl(icol,l) .ge. stanp(i1) ) goto 20
            pkd(icol,l) = (ppl(icol,l)-stanp(i1-1))  &
                        / (stanp(i1)-stanp(i1-1))
            ip1(icol,l) = i1-1
            ip2(icol,l) = i1
            goto 5
20          i1 = i1 + 1
            goto 30
         endif
5     enddo
   enddo

   return
end subroutine pscale


!-----------------------------------------------------------------------
end module gases_ckd
