!
! Copyright (C) 1991-2004  ; All Rights Reserved ; Colorado State University
! Colorado State University Research Foundation ; ATMET, LLC
!
! This file is free software; you can redistribute it and/or modify it under the
! terms of the GNU General Public License as published by the Free Software
! Foundation; either version 2 of the License, or (at your option) any later version.
!
! This software is distributed in the hope that it will be useful, but WITHOUT ANY
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
! PARTICULAR PURPOSE.  See the GNU General Public License for more details.
!
! You should have received a copy of the GNU General Public License along with this
! code; if not, write to the Free Software Foundation, Inc.,
! 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
!======================================================================================

Subroutine aero_nuc_tab_nh42so4 (rrv,rrvlsair,eps1,eps2,wtw1,wtw2,wtcon1,wtcon2 &
                    ,jrg1,jrg2,epstab,jw,jconcen,jtemp,rgccn1,tabvalue)

implicit none

integer :: iw,iconc
integer :: epstab,jw,jconcen,jtemp,rgccn1,ss
real :: eps1,eps2,wtw1,wtw2,wtcon1,wtcon2,jrg1,jrg2
real :: tabvalue,nucvalue,nucvalue1,nucvalue2,ssvalue1,ssvalue2
real, dimension(9,9,7,7,7) :: cldnuctab,supersat
real :: supsatpcnt,ssvalue11,ssvalue12,ssvalue21,ssvalue22
real :: mult1,mult2,nucss1,nucss2,nucss,rrv,rrvlsair

!Saleeby (6/3/02)
!The following tables are percent of prescibed CCN to activate.
!Table dimensions are:
! (median radius,updraft,concentration,temperature,solubility).
!Large aerosols or GCCN number are prescibed by the user and these
!automatically nucleate and they have no lookup tables.
!Small aerosols or CCN with median radius from 0.01 - 0.96 microns
!are user prescribed in concentration from 1 - 10,000 /mg.
!Median radius is in centimeters as is the parcel model.

!cldnuctab(a,b,c,d,e) as produced in parcel model
!a = 1-9 median radius of aerosol dist (.01,.02,.04,.08,.16,.32,.48,.64,.96 microns)
!b = 1-9 vertical velocity (1 - 10,000 cm/s)
!c = 1-7 aerosol concentration (10 - 10,000 /mg)
!d = 1-7 air temperature (-30 to 30 C)
!e = 1-7 epsilon solubility fraction (0.05, 0.1, 0.2, 0.4, 0.6, 0.8, 1.0)

!Input W (m/s), rg (m), concentration (/mg), T (C)

data ((cldnuctab( 1,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.0167, 0.0467, 0.1256, 0.2824, 0.5471, 0.8354, 0.9846, 0.9970, 0.9970,  &
0.0088, 0.0272, 0.0759, 0.1944, 0.4175, 0.7147, 0.9391, 0.9970, 0.9970,  &
0.0050, 0.0167, 0.0508, 0.1342, 0.2963, 0.5792, 0.8548, 0.9861, 0.9970,  &
0.0031, 0.0099, 0.0328, 0.0883, 0.2177, 0.4496, 0.7548, 0.9483, 0.9970,  &
0.0018, 0.0063, 0.0204, 0.0599, 0.1625, 0.3551, 0.6418, 0.8809, 0.9899,  &
0.0011, 0.0039, 0.0136, 0.0428, 0.1174, 0.2687, 0.5146, 0.7675, 0.9483,  &
0.0006, 0.0024, 0.0088, 0.0299, 0.0819, 0.2059, 0.3551, 0.4983, 0.7007 /
data ((cldnuctab( 1,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.0110, 0.0328, 0.0883, 0.2059, 0.4335, 0.7418, 0.9525, 0.9970, 0.9970,  &
0.0063, 0.0185, 0.0508, 0.1342, 0.3106, 0.5792, 0.8639, 0.9875, 0.9970,  &
0.0035, 0.0110, 0.0328, 0.0883, 0.2177, 0.4496, 0.7418, 0.9483, 0.9970,  &
0.0018, 0.0063, 0.0204, 0.0552, 0.1527, 0.3400, 0.6108, 0.8726, 0.9887,  &
0.0011, 0.0035, 0.0122, 0.0359, 0.1021, 0.2425, 0.4983, 0.7798, 0.9600,  &
0.0006, 0.0021, 0.0079, 0.0248, 0.0702, 0.1834, 0.3859, 0.6718, 0.8964,  &
0.0003, 0.0012, 0.0050, 0.0167, 0.0508, 0.1342, 0.2963, 0.5308, 0.7418 /
data ((cldnuctab( 1,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.0088, 0.0248, 0.0649, 0.1625, 0.3551, 0.6418, 0.9036, 0.9942, 0.9970,  &
0.0044, 0.0136, 0.0392, 0.1021, 0.2425, 0.4820, 0.7675, 0.9634, 0.9970,  &
0.0024, 0.0071, 0.0225, 0.0649, 0.1625, 0.3400, 0.6264, 0.8889, 0.9919,  &
0.0012, 0.0039, 0.0136, 0.0392, 0.1021, 0.2425, 0.4983, 0.7798, 0.9600,  &
0.0007, 0.0024, 0.0079, 0.0248, 0.0702, 0.1728, 0.3704, 0.6569, 0.9036,  &
0.0003, 0.0014, 0.0044, 0.0151, 0.0467, 0.1256, 0.2824, 0.5471, 0.8143,  &
0.0002, 0.0008, 0.0031, 0.0099, 0.0299, 0.0883, 0.2177, 0.4335, 0.6864 /
data ((cldnuctab( 1,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.0071, 0.0204, 0.0552, 0.1342, 0.2963, 0.5632, 0.8453, 0.9846, 0.9970,  &
0.0035, 0.0110, 0.0299, 0.0819, 0.1944, 0.4016, 0.6864, 0.9286, 0.9968,  &
0.0018, 0.0056, 0.0167, 0.0467, 0.1174, 0.2824, 0.5308, 0.8143, 0.9747,  &
0.0009, 0.0031, 0.0099, 0.0272, 0.0759, 0.1834, 0.4016, 0.6864, 0.9168,  &
0.0005, 0.0016, 0.0056, 0.0167, 0.0467, 0.1256, 0.2824, 0.5471, 0.8250,  &
0.0003, 0.0009, 0.0031, 0.0099, 0.0299, 0.0883, 0.2059, 0.4335, 0.7147,  &
0.0001, 0.0005, 0.0018, 0.0063, 0.0204, 0.0599, 0.1527, 0.3251, 0.5951 /
data ((cldnuctab( 1,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.0056, 0.0167, 0.0467, 0.1174, 0.2554, 0.4983, 0.7917, 0.9695, 0.9970,  &
0.0031, 0.0088, 0.0248, 0.0649, 0.1625, 0.3551, 0.6264, 0.8889, 0.9909,  &
0.0014, 0.0044, 0.0136, 0.0392, 0.1021, 0.2299, 0.4658, 0.7548, 0.9525,  &
0.0007, 0.0024, 0.0071, 0.0225, 0.0599, 0.1527, 0.3251, 0.5951, 0.8639,  &
0.0004, 0.0012, 0.0039, 0.0122, 0.0359, 0.0950, 0.2299, 0.4496, 0.7418,  &
0.0002, 0.0006, 0.0024, 0.0071, 0.0225, 0.0599, 0.1527, 0.3400, 0.6108,  &
0.0001, 0.0003, 0.0012, 0.0044, 0.0136, 0.0392, 0.1095, 0.2554, 0.4983 /
data ((cldnuctab( 1,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.0050, 0.0151, 0.0428, 0.1021, 0.2299, 0.4658, 0.7548, 0.9564, 0.9970,  &
0.0027, 0.0079, 0.0225, 0.0599, 0.1433, 0.3106, 0.5792, 0.8548, 0.9846,  &
0.0012, 0.0039, 0.0122, 0.0328, 0.0883, 0.2059, 0.4175, 0.7007, 0.9286,  &
0.0006, 0.0021, 0.0063, 0.0185, 0.0508, 0.1256, 0.2824, 0.5308, 0.8143,  &
0.0003, 0.0011, 0.0035, 0.0099, 0.0299, 0.0759, 0.1834, 0.3859, 0.6718,  &
0.0002, 0.0005, 0.0018, 0.0056, 0.0167, 0.0467, 0.1256, 0.2824, 0.5308,  &
0.0001, 0.0003, 0.0009, 0.0031, 0.0099, 0.0299, 0.0819, 0.1944, 0.4016 /
data ((cldnuctab( 1,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.0050, 0.0136, 0.0392, 0.0950, 0.2177, 0.4335, 0.7284, 0.9438, 0.9970,  &
0.0024, 0.0071, 0.0204, 0.0552, 0.1342, 0.2824, 0.5471, 0.8250, 0.9770,  &
0.0012, 0.0035, 0.0110, 0.0299, 0.0759, 0.1834, 0.3704, 0.6569, 0.9036,  &
0.0005, 0.0018, 0.0056, 0.0167, 0.0428, 0.1095, 0.2554, 0.4820, 0.7675,  &
0.0003, 0.0009, 0.0031, 0.0088, 0.0248, 0.0649, 0.1625, 0.3400, 0.6108,  &
0.0001, 0.0005, 0.0016, 0.0050, 0.0151, 0.0392, 0.1021, 0.2425, 0.4658,  &
0.0001, 0.0002, 0.0008, 0.0027, 0.0079, 0.0248, 0.0649, 0.1625, 0.3400 /
data ((cldnuctab( 1,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.0248, 0.0649, 0.1527, 0.3400, 0.6108, 0.8726, 0.9887, 0.9970, 0.9970,  &
0.0136, 0.0392, 0.1021, 0.2425, 0.4658, 0.7548, 0.9483, 0.9970, 0.9970,  &
0.0088, 0.0248, 0.0702, 0.1728, 0.3551, 0.6264, 0.8809, 0.9887, 0.9970,  &
0.0050, 0.0167, 0.0467, 0.1174, 0.2687, 0.5146, 0.7917, 0.9600, 0.9970,  &
0.0031, 0.0110, 0.0328, 0.0883, 0.2059, 0.4175, 0.6864, 0.9036, 0.9919,  &
0.0018, 0.0071, 0.0225, 0.0599, 0.1527, 0.3251, 0.5792, 0.7917, 0.9600,  &
0.0012, 0.0044, 0.0151, 0.0428, 0.1174, 0.2425, 0.4016, 0.5308, 0.7284 /
data ((cldnuctab( 1,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.0167, 0.0467, 0.1174, 0.2554, 0.4983, 0.7798, 0.9600, 0.9970, 0.9970,  &
0.0099, 0.0272, 0.0702, 0.1728, 0.3704, 0.6418, 0.8889, 0.9909, 0.9970,  &
0.0056, 0.0167, 0.0467, 0.1174, 0.2687, 0.5146, 0.7798, 0.9600, 0.9970,  &
0.0031, 0.0099, 0.0299, 0.0819, 0.1944, 0.4016, 0.6718, 0.9036, 0.9919,  &
0.0018, 0.0063, 0.0185, 0.0552, 0.1433, 0.3106, 0.5632, 0.8143, 0.9695,  &
0.0011, 0.0039, 0.0122, 0.0392, 0.1021, 0.2299, 0.4496, 0.7147, 0.9168,  &
0.0006, 0.0024, 0.0079, 0.0248, 0.0702, 0.1728, 0.3551, 0.5792, 0.7798 /
data ((cldnuctab( 1,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.0122, 0.0359, 0.0883, 0.2059, 0.4016, 0.6864, 0.9229, 0.9959, 0.9970,  &
0.0071, 0.0204, 0.0552, 0.1342, 0.2963, 0.5471, 0.8143, 0.9722, 0.9970,  &
0.0039, 0.0110, 0.0328, 0.0883, 0.2059, 0.4016, 0.6864, 0.9103, 0.9935,  &
0.0021, 0.0071, 0.0204, 0.0552, 0.1342, 0.2963, 0.5471, 0.8143, 0.9695,  &
0.0012, 0.0039, 0.0122, 0.0359, 0.0950, 0.2177, 0.4335, 0.7147, 0.9229,  &
0.0007, 0.0024, 0.0079, 0.0248, 0.0649, 0.1625, 0.3400, 0.6108, 0.8453,  &
0.0004, 0.0014, 0.0050, 0.0167, 0.0467, 0.1174, 0.2687, 0.4983, 0.7284 /
data ((cldnuctab( 1,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.0099, 0.0272, 0.0702, 0.1728, 0.3551, 0.6264, 0.8726, 0.9875, 0.9970,  &
0.0056, 0.0151, 0.0428, 0.1095, 0.2425, 0.4658, 0.7418, 0.9438, 0.9970,  &
0.0027, 0.0088, 0.0248, 0.0649, 0.1625, 0.3400, 0.5951, 0.8548, 0.9811,  &
0.0016, 0.0050, 0.0151, 0.0428, 0.1021, 0.2299, 0.4658, 0.7284, 0.9340,  &
0.0008, 0.0027, 0.0088, 0.0248, 0.0702, 0.1625, 0.3551, 0.6108, 0.8548,  &
0.0005, 0.0016, 0.0050, 0.0167, 0.0467, 0.1174, 0.2687, 0.4983, 0.7675,  &
0.0003, 0.0009, 0.0031, 0.0110, 0.0299, 0.0819, 0.1944, 0.4016, 0.6569 /
data ((cldnuctab( 1,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.0088, 0.0248, 0.0599, 0.1433, 0.3106, 0.5632, 0.8354, 0.9770, 0.9970,  &
0.0044, 0.0136, 0.0359, 0.0883, 0.2059, 0.4016, 0.6864, 0.9103, 0.9935,  &
0.0024, 0.0071, 0.0204, 0.0552, 0.1342, 0.2824, 0.5308, 0.7917, 0.9634,  &
0.0012, 0.0039, 0.0110, 0.0328, 0.0819, 0.1944, 0.3859, 0.6569, 0.8889,  &
0.0006, 0.0021, 0.0063, 0.0185, 0.0508, 0.1256, 0.2824, 0.5146, 0.7917,  &
0.0003, 0.0012, 0.0039, 0.0122, 0.0359, 0.0883, 0.2059, 0.4016, 0.6718,  &
0.0002, 0.0006, 0.0024, 0.0071, 0.0225, 0.0599, 0.1433, 0.3106, 0.5632 /
data ((cldnuctab( 1,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.0079, 0.0225, 0.0552, 0.1342, 0.2824, 0.5308, 0.8032, 0.9666, 0.9970,  &
0.0039, 0.0110, 0.0328, 0.0819, 0.1834, 0.3704, 0.6418, 0.8809, 0.9887,  &
0.0021, 0.0063, 0.0167, 0.0467, 0.1095, 0.2425, 0.4820, 0.7548, 0.9438,  &
0.0011, 0.0035, 0.0099, 0.0272, 0.0702, 0.1625, 0.3400, 0.5951, 0.8548,  &
0.0005, 0.0016, 0.0056, 0.0151, 0.0428, 0.1095, 0.2425, 0.4496, 0.7284,  &
0.0003, 0.0009, 0.0031, 0.0088, 0.0272, 0.0702, 0.1625, 0.3400, 0.5951,  &
0.0002, 0.0005, 0.0016, 0.0056, 0.0167, 0.0467, 0.1174, 0.2554, 0.4820 /
data ((cldnuctab( 1,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.0071, 0.0204, 0.0508, 0.1256, 0.2687, 0.4983, 0.7798, 0.9564, 0.9970,  &
0.0035, 0.0110, 0.0299, 0.0702, 0.1728, 0.3400, 0.6108, 0.8639, 0.9829,  &
0.0018, 0.0056, 0.0151, 0.0428, 0.1021, 0.2299, 0.4335, 0.7147, 0.9286,  &
0.0009, 0.0027, 0.0088, 0.0248, 0.0599, 0.1433, 0.3106, 0.5471, 0.8143,  &
0.0005, 0.0014, 0.0044, 0.0136, 0.0359, 0.0950, 0.2059, 0.4016, 0.6718,  &
0.0002, 0.0008, 0.0024, 0.0079, 0.0225, 0.0599, 0.1433, 0.2963, 0.5308,  &
0.0001, 0.0004, 0.0014, 0.0044, 0.0136, 0.0359, 0.0950, 0.2177, 0.4175 /
data ((cldnuctab( 1,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.0359, 0.0950, 0.2059, 0.4175, 0.6718, 0.9036, 0.9919, 0.9970, 0.9970,  &
0.0225, 0.0599, 0.1433, 0.3106, 0.5471, 0.8032, 0.9634, 0.9970, 0.9970,  &
0.0136, 0.0392, 0.1021, 0.2299, 0.4335, 0.7007, 0.9103, 0.9919, 0.9970,  &
0.0088, 0.0272, 0.0702, 0.1728, 0.3400, 0.5951, 0.8354, 0.9722, 0.9970,  &
0.0056, 0.0185, 0.0508, 0.1256, 0.2687, 0.4983, 0.7548, 0.9286, 0.9942,  &
0.0039, 0.0122, 0.0359, 0.0950, 0.2059, 0.4016, 0.6418, 0.8354, 0.9695,  &
0.0024, 0.0079, 0.0248, 0.0649, 0.1527, 0.2963, 0.4496, 0.5308, 0.7548 /
data ((cldnuctab( 1,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.0248, 0.0649, 0.1527, 0.3251, 0.5792, 0.8250, 0.9722, 0.9970, 0.9970,  &
0.0151, 0.0428, 0.1021, 0.2299, 0.4496, 0.7007, 0.9168, 0.9935, 0.9970,  &
0.0088, 0.0272, 0.0702, 0.1625, 0.3400, 0.5792, 0.8354, 0.9722, 0.9970,  &
0.0056, 0.0167, 0.0467, 0.1174, 0.2554, 0.4820, 0.7284, 0.9286, 0.9942,  &
0.0035, 0.0110, 0.0328, 0.0819, 0.1944, 0.3859, 0.6264, 0.8639, 0.9770,  &
0.0021, 0.0071, 0.0225, 0.0599, 0.1433, 0.3106, 0.5308, 0.7798, 0.9391,  &
0.0012, 0.0044, 0.0151, 0.0428, 0.1095, 0.2425, 0.4335, 0.6418, 0.8143 /
data ((cldnuctab( 1,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.0185, 0.0508, 0.1256, 0.2687, 0.4820, 0.7548, 0.9438, 0.9970, 0.9970,  &
0.0110, 0.0299, 0.0759, 0.1834, 0.3551, 0.6108, 0.8548, 0.9811, 0.9970,  &
0.0063, 0.0185, 0.0508, 0.1256, 0.2687, 0.4820, 0.7418, 0.9340, 0.9959,  &
0.0035, 0.0110, 0.0328, 0.0819, 0.1944, 0.3859, 0.6264, 0.8639, 0.9791,  &
0.0021, 0.0071, 0.0204, 0.0552, 0.1342, 0.2963, 0.5308, 0.7798, 0.9438,  &
0.0012, 0.0044, 0.0136, 0.0392, 0.1021, 0.2299, 0.4335, 0.6864, 0.8889,  &
0.0008, 0.0027, 0.0088, 0.0272, 0.0702, 0.1728, 0.3400, 0.5792, 0.7798 /
data ((cldnuctab( 1,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.0151, 0.0428, 0.1021, 0.2177, 0.4335, 0.6864, 0.9103, 0.9919, 0.9970,  &
0.0088, 0.0248, 0.0599, 0.1433, 0.2963, 0.5471, 0.8032, 0.9600, 0.9970,  &
0.0050, 0.0136, 0.0392, 0.0950, 0.2059, 0.4016, 0.6718, 0.8889, 0.9875,  &
0.0027, 0.0079, 0.0225, 0.0599, 0.1433, 0.3106, 0.5471, 0.7917, 0.9525,  &
0.0014, 0.0050, 0.0151, 0.0392, 0.1021, 0.2299, 0.4335, 0.6864, 0.8964,  &
0.0008, 0.0031, 0.0088, 0.0272, 0.0702, 0.1625, 0.3400, 0.5792, 0.8143,  &
0.0005, 0.0018, 0.0056, 0.0185, 0.0508, 0.1256, 0.2687, 0.4820, 0.7147 /
data ((cldnuctab( 1,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.0136, 0.0359, 0.0883, 0.1944, 0.3859, 0.6418, 0.8809, 0.9846, 0.9970,  &
0.0071, 0.0204, 0.0508, 0.1256, 0.2687, 0.4820, 0.7418, 0.9391, 0.9959,  &
0.0039, 0.0110, 0.0299, 0.0759, 0.1728, 0.3551, 0.5951, 0.8453, 0.9747,  &
0.0021, 0.0063, 0.0185, 0.0508, 0.1174, 0.2554, 0.4658, 0.7284, 0.9229,  &
0.0011, 0.0035, 0.0110, 0.0299, 0.0819, 0.1834, 0.3551, 0.5951, 0.8354,  &
0.0006, 0.0021, 0.0071, 0.0204, 0.0552, 0.1256, 0.2687, 0.4983, 0.7418,  &
0.0003, 0.0012, 0.0044, 0.0122, 0.0359, 0.0950, 0.2059, 0.4016, 0.6418 /
data ((cldnuctab( 1,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.0122, 0.0328, 0.0759, 0.1728, 0.3551, 0.6108, 0.8548, 0.9770, 0.9970,  &
0.0063, 0.0167, 0.0467, 0.1095, 0.2425, 0.4496, 0.7147, 0.9168, 0.9927,  &
0.0035, 0.0099, 0.0272, 0.0649, 0.1527, 0.3106, 0.5471, 0.8032, 0.9600,  &
0.0016, 0.0056, 0.0151, 0.0428, 0.1021, 0.2177, 0.4175, 0.6718, 0.8889,  &
0.0009, 0.0031, 0.0088, 0.0248, 0.0649, 0.1527, 0.3106, 0.5308, 0.7917,  &
0.0005, 0.0016, 0.0050, 0.0151, 0.0428, 0.1021, 0.2299, 0.4175, 0.6718,  &
0.0003, 0.0009, 0.0031, 0.0099, 0.0272, 0.0702, 0.1625, 0.3251, 0.5632 /
data ((cldnuctab( 1,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.0110, 0.0299, 0.0759, 0.1625, 0.3400, 0.5792, 0.8354, 0.9722, 0.9970,  &
0.0056, 0.0167, 0.0428, 0.1021, 0.2177, 0.4175, 0.6864, 0.8964, 0.9887,  &
0.0031, 0.0088, 0.0248, 0.0599, 0.1433, 0.2963, 0.5146, 0.7798, 0.9483,  &
0.0016, 0.0044, 0.0136, 0.0359, 0.0883, 0.1944, 0.3859, 0.6264, 0.8639,  &
0.0008, 0.0027, 0.0079, 0.0204, 0.0552, 0.1342, 0.2687, 0.4983, 0.7418,  &
0.0005, 0.0014, 0.0044, 0.0136, 0.0359, 0.0883, 0.1944, 0.3704, 0.6108,  &
0.0002, 0.0008, 0.0027, 0.0079, 0.0225, 0.0599, 0.1342, 0.2824, 0.4983 /
data ((cldnuctab( 1,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.0552, 0.1342, 0.2824, 0.4983, 0.7548, 0.9340, 0.9954, 0.9970, 0.9970,  &
0.0359, 0.0950, 0.2059, 0.4016, 0.6418, 0.8639, 0.9770, 0.9970, 0.9970,  &
0.0248, 0.0649, 0.1527, 0.3106, 0.5308, 0.7798, 0.9391, 0.9954, 0.9970,  &
0.0167, 0.0428, 0.1095, 0.2425, 0.4335, 0.6864, 0.8889, 0.9829, 0.9970,  &
0.0110, 0.0299, 0.0819, 0.1834, 0.3551, 0.5951, 0.8143, 0.9525, 0.9968,  &
0.0063, 0.0204, 0.0552, 0.1433, 0.2824, 0.4983, 0.7147, 0.8809, 0.9811,  &
0.0035, 0.0122, 0.0359, 0.0950, 0.2059, 0.3400, 0.4820, 0.5471, 0.7675 /
data ((cldnuctab( 1,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.0392, 0.0950, 0.2177, 0.4175, 0.6569, 0.8809, 0.9829, 0.9970, 0.9970,  &
0.0248, 0.0649, 0.1527, 0.3106, 0.5308, 0.7798, 0.9438, 0.9964, 0.9970,  &
0.0151, 0.0428, 0.1095, 0.2299, 0.4335, 0.6718, 0.8809, 0.9829, 0.9970,  &
0.0099, 0.0299, 0.0759, 0.1728, 0.3400, 0.5792, 0.8032, 0.9525, 0.9968,  &
0.0063, 0.0185, 0.0552, 0.1256, 0.2687, 0.4820, 0.7147, 0.9036, 0.9875,  &
0.0039, 0.0122, 0.0359, 0.0950, 0.2059, 0.4016, 0.6264, 0.8354, 0.9600,  &
0.0024, 0.0079, 0.0248, 0.0649, 0.1625, 0.3106, 0.5146, 0.6864, 0.8639 /
data ((cldnuctab( 1,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.0299, 0.0759, 0.1728, 0.3400, 0.5792, 0.8250, 0.9634, 0.9970, 0.9970,  &
0.0185, 0.0467, 0.1174, 0.2425, 0.4496, 0.7007, 0.9036, 0.9887, 0.9970,  &
0.0110, 0.0299, 0.0759, 0.1728, 0.3400, 0.5792, 0.8143, 0.9600, 0.9970,  &
0.0063, 0.0185, 0.0508, 0.1256, 0.2687, 0.4820, 0.7147, 0.9103, 0.9875,  &
0.0039, 0.0122, 0.0359, 0.0883, 0.2059, 0.3859, 0.6264, 0.8354, 0.9666,  &
0.0024, 0.0079, 0.0248, 0.0649, 0.1527, 0.3106, 0.5308, 0.7675, 0.9229,  &
0.0014, 0.0050, 0.0167, 0.0467, 0.1095, 0.2425, 0.4335, 0.6569, 0.8453 /
data ((cldnuctab( 1,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.0248, 0.0599, 0.1433, 0.2963, 0.5146, 0.7675, 0.9391, 0.9954, 0.9970,  &
0.0136, 0.0359, 0.0950, 0.2059, 0.3859, 0.6264, 0.8548, 0.9747, 0.9970,  &
0.0079, 0.0225, 0.0599, 0.1342, 0.2824, 0.4983, 0.7548, 0.9286, 0.9927,  &
0.0044, 0.0136, 0.0392, 0.0950, 0.2059, 0.4016, 0.6418, 0.8548, 0.9722,  &
0.0027, 0.0088, 0.0248, 0.0649, 0.1527, 0.3106, 0.5308, 0.7675, 0.9340,  &
0.0016, 0.0056, 0.0167, 0.0467, 0.1095, 0.2425, 0.4335, 0.6718, 0.8726,  &
0.0009, 0.0035, 0.0110, 0.0299, 0.0819, 0.1834, 0.3551, 0.5792, 0.7917 /
data ((cldnuctab( 1,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.0204, 0.0508, 0.1256, 0.2554, 0.4658, 0.7284, 0.9168, 0.9919, 0.9970,  &
0.0110, 0.0299, 0.0759, 0.1728, 0.3400, 0.5792, 0.8143, 0.9600, 0.9970,  &
0.0063, 0.0185, 0.0467, 0.1174, 0.2425, 0.4496, 0.6864, 0.8964, 0.9861,  &
0.0035, 0.0110, 0.0299, 0.0759, 0.1728, 0.3400, 0.5632, 0.8032, 0.9525,  &
0.0021, 0.0063, 0.0185, 0.0508, 0.1174, 0.2554, 0.4496, 0.7007, 0.8889,  &
0.0012, 0.0039, 0.0122, 0.0328, 0.0819, 0.1834, 0.3551, 0.5951, 0.8143,  &
0.0007, 0.0024, 0.0079, 0.0225, 0.0599, 0.1433, 0.2824, 0.4983, 0.7284 /
data ((cldnuctab( 1,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.0185, 0.0467, 0.1095, 0.2425, 0.4335, 0.6864, 0.9036, 0.9875, 0.9970,  &
0.0099, 0.0272, 0.0702, 0.1527, 0.3106, 0.5471, 0.7917, 0.9483, 0.9959,  &
0.0056, 0.0151, 0.0392, 0.0950, 0.2177, 0.4016, 0.6418, 0.8639, 0.9770,  &
0.0031, 0.0088, 0.0248, 0.0649, 0.1433, 0.2963, 0.5146, 0.7548, 0.9286,  &
0.0016, 0.0050, 0.0151, 0.0392, 0.0950, 0.2059, 0.4016, 0.6418, 0.8548,  &
0.0009, 0.0031, 0.0088, 0.0272, 0.0649, 0.1527, 0.3106, 0.5308, 0.7548,  &
0.0005, 0.0018, 0.0056, 0.0167, 0.0467, 0.1095, 0.2299, 0.4335, 0.6569 /
data ((cldnuctab( 1,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.0167, 0.0428, 0.1021, 0.2177, 0.4175, 0.6718, 0.8889, 0.9829, 0.9970,  &
0.0088, 0.0248, 0.0599, 0.1433, 0.2963, 0.5146, 0.7675, 0.9340, 0.9942,  &
0.0050, 0.0136, 0.0359, 0.0883, 0.1944, 0.3704, 0.6108, 0.8453, 0.9695,  &
0.0027, 0.0079, 0.0204, 0.0552, 0.1256, 0.2687, 0.4820, 0.7147, 0.9103,  &
0.0014, 0.0044, 0.0122, 0.0359, 0.0819, 0.1834, 0.3551, 0.5951, 0.8143,  &
0.0008, 0.0024, 0.0079, 0.0225, 0.0552, 0.1256, 0.2687, 0.4658, 0.7147,  &
0.0005, 0.0014, 0.0044, 0.0136, 0.0359, 0.0883, 0.1944, 0.3704, 0.5951 /
data ((cldnuctab( 1,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.0702, 0.1625, 0.3251, 0.5632, 0.8032, 0.9525, 0.9968, 0.9970, 0.9970,  &
0.0508, 0.1174, 0.2554, 0.4496, 0.7007, 0.8964, 0.9846, 0.9970, 0.9970,  &
0.0328, 0.0819, 0.1834, 0.3704, 0.5951, 0.8250, 0.9564, 0.9968, 0.9970,  &
0.0225, 0.0599, 0.1433, 0.2824, 0.4983, 0.7418, 0.9168, 0.9875, 0.9970,  &
0.0151, 0.0428, 0.1021, 0.2299, 0.4175, 0.6569, 0.8548, 0.9666, 0.9970,  &
0.0088, 0.0272, 0.0759, 0.1728, 0.3400, 0.5632, 0.7675, 0.9036, 0.9875,  &
0.0044, 0.0151, 0.0467, 0.1174, 0.2299, 0.3704, 0.4983, 0.5308, 0.8143 /
data ((cldnuctab( 1,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.0508, 0.1256, 0.2554, 0.4658, 0.7147, 0.9103, 0.9887, 0.9970, 0.9970,  &
0.0328, 0.0819, 0.1834, 0.3704, 0.5951, 0.8250, 0.9600, 0.9970, 0.9970,  &
0.0225, 0.0599, 0.1342, 0.2824, 0.4983, 0.7284, 0.9103, 0.9875, 0.9970,  &
0.0136, 0.0392, 0.0950, 0.2177, 0.4016, 0.6418, 0.8453, 0.9666, 0.9970,  &
0.0088, 0.0272, 0.0702, 0.1625, 0.3251, 0.5471, 0.7675, 0.9286, 0.9909,  &
0.0056, 0.0167, 0.0508, 0.1174, 0.2554, 0.4658, 0.6864, 0.8726, 0.9722,  &
0.0031, 0.0099, 0.0299, 0.0819, 0.1944, 0.3551, 0.5632, 0.7418, 0.8889 /
data ((cldnuctab( 1,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.0392, 0.0950, 0.2059, 0.4016, 0.6418, 0.8639, 0.9747, 0.9970, 0.9970,  &
0.0248, 0.0599, 0.1433, 0.2963, 0.5146, 0.7548, 0.9286, 0.9919, 0.9970,  &
0.0151, 0.0392, 0.1021, 0.2177, 0.4016, 0.6418, 0.8548, 0.9722, 0.9970,  &
0.0099, 0.0272, 0.0702, 0.1625, 0.3106, 0.5308, 0.7675, 0.9340, 0.9919,  &
0.0056, 0.0185, 0.0467, 0.1174, 0.2425, 0.4496, 0.6864, 0.8726, 0.9747,  &
0.0035, 0.0110, 0.0328, 0.0819, 0.1944, 0.3704, 0.5951, 0.8032, 0.9438,  &
0.0021, 0.0071, 0.0204, 0.0599, 0.1433, 0.2963, 0.4983, 0.7147, 0.8726 /
data ((cldnuctab( 1,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.0299, 0.0759, 0.1728, 0.3400, 0.5792, 0.8143, 0.9564, 0.9970, 0.9970,  &
0.0185, 0.0467, 0.1174, 0.2425, 0.4496, 0.6864, 0.8889, 0.9829, 0.9970,  &
0.0110, 0.0299, 0.0759, 0.1728, 0.3400, 0.5632, 0.8032, 0.9483, 0.9954,  &
0.0063, 0.0185, 0.0508, 0.1174, 0.2554, 0.4496, 0.7007, 0.8889, 0.9811,  &
0.0039, 0.0122, 0.0328, 0.0883, 0.1944, 0.3704, 0.5951, 0.8143, 0.9525,  &
0.0024, 0.0079, 0.0225, 0.0599, 0.1433, 0.2824, 0.4983, 0.7284, 0.9036,  &
0.0014, 0.0044, 0.0151, 0.0428, 0.1021, 0.2299, 0.4175, 0.6418, 0.8354 /
data ((cldnuctab( 1,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.0272, 0.0649, 0.1527, 0.3106, 0.5308, 0.7798, 0.9391, 0.9942, 0.9970,  &
0.0151, 0.0392, 0.0950, 0.2059, 0.4016, 0.6418, 0.8548, 0.9722, 0.9970,  &
0.0088, 0.0248, 0.0599, 0.1433, 0.2824, 0.4983, 0.7418, 0.9229, 0.9899,  &
0.0050, 0.0151, 0.0392, 0.0950, 0.2059, 0.3859, 0.6264, 0.8453, 0.9666,  &
0.0031, 0.0088, 0.0248, 0.0649, 0.1527, 0.2963, 0.5146, 0.7548, 0.9168,  &
0.0018, 0.0056, 0.0167, 0.0467, 0.1095, 0.2299, 0.4175, 0.6569, 0.8548,  &
0.0011, 0.0035, 0.0110, 0.0299, 0.0759, 0.1728, 0.3400, 0.5632, 0.7798 /
data ((cldnuctab( 1,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.0225, 0.0599, 0.1342, 0.2824, 0.4983, 0.7418, 0.9286, 0.9919, 0.9970,  &
0.0136, 0.0359, 0.0819, 0.1834, 0.3551, 0.5951, 0.8354, 0.9634, 0.9970,  &
0.0071, 0.0204, 0.0508, 0.1256, 0.2554, 0.4658, 0.7007, 0.8964, 0.9846,  &
0.0039, 0.0122, 0.0328, 0.0819, 0.1834, 0.3400, 0.5792, 0.8032, 0.9483,  &
0.0024, 0.0071, 0.0204, 0.0552, 0.1256, 0.2554, 0.4658, 0.7007, 0.8889,  &
0.0014, 0.0044, 0.0122, 0.0359, 0.0883, 0.1944, 0.3551, 0.5951, 0.8032,  &
0.0008, 0.0027, 0.0079, 0.0225, 0.0599, 0.1433, 0.2824, 0.4820, 0.7147 /
data ((cldnuctab( 1,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.0204, 0.0552, 0.1256, 0.2687, 0.4820, 0.7284, 0.9168, 0.9887, 0.9970,  &
0.0122, 0.0328, 0.0759, 0.1728, 0.3400, 0.5792, 0.8143, 0.9564, 0.9959,  &
0.0063, 0.0185, 0.0467, 0.1095, 0.2299, 0.4335, 0.6718, 0.8809, 0.9791,  &
0.0035, 0.0099, 0.0272, 0.0702, 0.1625, 0.3106, 0.5308, 0.7675, 0.9340,  &
0.0021, 0.0063, 0.0167, 0.0428, 0.1095, 0.2299, 0.4175, 0.6569, 0.8639,  &
0.0012, 0.0035, 0.0110, 0.0299, 0.0702, 0.1625, 0.3251, 0.5308, 0.7675,  &
0.0006, 0.0021, 0.0063, 0.0185, 0.0508, 0.1174, 0.2425, 0.4335, 0.6718 /
data ((cldnuctab( 1,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.0883, 0.1944, 0.3704, 0.6108, 0.8354, 0.9634, 0.9970, 0.9970, 0.9970,  &
0.0599, 0.1433, 0.2824, 0.4983, 0.7418, 0.9168, 0.9887, 0.9970, 0.9970,  &
0.0392, 0.1021, 0.2177, 0.4016, 0.6418, 0.8548, 0.9666, 0.9970, 0.9970,  &
0.0272, 0.0702, 0.1625, 0.3251, 0.5471, 0.7798, 0.9340, 0.9909, 0.9970,  &
0.0185, 0.0508, 0.1256, 0.2687, 0.4658, 0.7007, 0.8809, 0.9747, 0.9970,  &
0.0110, 0.0328, 0.0883, 0.2059, 0.3859, 0.5951, 0.7917, 0.9229, 0.9899,  &
0.0050, 0.0167, 0.0508, 0.1342, 0.2425, 0.3704, 0.5146, 0.5632, 0.8032 /
data ((cldnuctab( 1,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.0649, 0.1433, 0.2963, 0.5146, 0.7548, 0.9286, 0.9919, 0.9970, 0.9970,  &
0.0392, 0.1021, 0.2177, 0.4016, 0.6418, 0.8548, 0.9695, 0.9970, 0.9970,  &
0.0272, 0.0702, 0.1625, 0.3106, 0.5308, 0.7675, 0.9286, 0.9909, 0.9970,  &
0.0185, 0.0467, 0.1174, 0.2425, 0.4496, 0.6864, 0.8726, 0.9747, 0.9970,  &
0.0110, 0.0328, 0.0883, 0.1944, 0.3704, 0.5951, 0.8032, 0.9438, 0.9935,  &
0.0071, 0.0204, 0.0599, 0.1433, 0.2963, 0.4983, 0.7284, 0.8964, 0.9791,  &
0.0035, 0.0110, 0.0359, 0.0950, 0.2177, 0.3859, 0.5951, 0.7548, 0.9103 /
data ((cldnuctab( 1,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.0467, 0.1095, 0.2425, 0.4335, 0.6864, 0.8889, 0.9811, 0.9970, 0.9970,  &
0.0299, 0.0759, 0.1728, 0.3251, 0.5632, 0.7917, 0.9438, 0.9942, 0.9970,  &
0.0185, 0.0508, 0.1174, 0.2554, 0.4496, 0.6864, 0.8809, 0.9791, 0.9970,  &
0.0122, 0.0328, 0.0819, 0.1834, 0.3551, 0.5792, 0.8032, 0.9483, 0.9942,  &
0.0071, 0.0225, 0.0599, 0.1433, 0.2824, 0.4983, 0.7284, 0.8964, 0.9811,  &
0.0044, 0.0136, 0.0392, 0.1021, 0.2177, 0.4016, 0.6418, 0.8354, 0.9564,  &
0.0024, 0.0079, 0.0248, 0.0702, 0.1625, 0.3251, 0.5471, 0.7548, 0.8964 /
data ((cldnuctab( 1,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.0359, 0.0883, 0.1944, 0.3859, 0.6264, 0.8453, 0.9666, 0.9970, 0.9970,  &
0.0225, 0.0599, 0.1342, 0.2824, 0.4820, 0.7284, 0.9103, 0.9875, 0.9970,  &
0.0136, 0.0359, 0.0883, 0.2059, 0.3859, 0.6108, 0.8354, 0.9600, 0.9964,  &
0.0079, 0.0248, 0.0599, 0.1433, 0.2963, 0.4983, 0.7418, 0.9103, 0.9861,  &
0.0050, 0.0151, 0.0428, 0.1021, 0.2177, 0.4016, 0.6418, 0.8453, 0.9634,  &
0.0031, 0.0099, 0.0272, 0.0759, 0.1625, 0.3251, 0.5471, 0.7675, 0.9229,  &
0.0018, 0.0056, 0.0185, 0.0508, 0.1256, 0.2554, 0.4658, 0.6864, 0.8548 /
data ((cldnuctab( 1,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.0328, 0.0759, 0.1728, 0.3400, 0.5792, 0.8143, 0.9525, 0.9959, 0.9970,  &
0.0185, 0.0467, 0.1095, 0.2425, 0.4335, 0.6864, 0.8809, 0.9791, 0.9970,  &
0.0110, 0.0299, 0.0759, 0.1625, 0.3251, 0.5471, 0.7798, 0.9391, 0.9927,  &
0.0063, 0.0185, 0.0467, 0.1174, 0.2425, 0.4335, 0.6718, 0.8726, 0.9747,  &
0.0039, 0.0110, 0.0328, 0.0819, 0.1728, 0.3400, 0.5632, 0.7917, 0.9391,  &
0.0024, 0.0071, 0.0204, 0.0552, 0.1256, 0.2687, 0.4658, 0.7007, 0.8809,  &
0.0014, 0.0044, 0.0136, 0.0359, 0.0950, 0.2059, 0.3859, 0.6108, 0.8143 /
data ((cldnuctab( 1,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.0272, 0.0702, 0.1527, 0.3106, 0.5471, 0.7798, 0.9438, 0.9942, 0.9970,  &
0.0151, 0.0428, 0.1021, 0.2177, 0.4016, 0.6418, 0.8639, 0.9722, 0.9970,  &
0.0088, 0.0248, 0.0649, 0.1433, 0.2963, 0.4983, 0.7418, 0.9229, 0.9887,  &
0.0050, 0.0151, 0.0392, 0.0950, 0.2059, 0.3859, 0.6264, 0.8354, 0.9600,  &
0.0031, 0.0088, 0.0248, 0.0649, 0.1433, 0.2963, 0.4983, 0.7418, 0.9103,  &
0.0018, 0.0056, 0.0167, 0.0428, 0.1021, 0.2177, 0.4016, 0.6264, 0.8354,  &
0.0009, 0.0035, 0.0099, 0.0272, 0.0702, 0.1625, 0.3251, 0.5308, 0.7548 /
data ((cldnuctab( 1,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.0248, 0.0649, 0.1433, 0.2963, 0.5146, 0.7675, 0.9340, 0.9919, 0.9970,  &
0.0136, 0.0359, 0.0883, 0.1944, 0.3704, 0.6108, 0.8453, 0.9666, 0.9970,  &
0.0079, 0.0225, 0.0552, 0.1256, 0.2687, 0.4658, 0.7147, 0.9036, 0.9846,  &
0.0044, 0.0122, 0.0328, 0.0819, 0.1834, 0.3551, 0.5792, 0.8032, 0.9483,  &
0.0027, 0.0079, 0.0225, 0.0552, 0.1256, 0.2554, 0.4658, 0.7007, 0.8889,  &
0.0014, 0.0044, 0.0136, 0.0359, 0.0883, 0.1944, 0.3551, 0.5792, 0.8032,  &
0.0008, 0.0027, 0.0079, 0.0225, 0.0599, 0.1342, 0.2824, 0.4820, 0.7147 /
data ((cldnuctab( 1,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.1021, 0.2177, 0.4016, 0.6418, 0.8548, 0.9695, 0.9970, 0.9970, 0.9970,  &
0.0702, 0.1625, 0.3106, 0.5308, 0.7675, 0.9286, 0.9909, 0.9970, 0.9970,  &
0.0467, 0.1174, 0.2425, 0.4496, 0.6718, 0.8726, 0.9722, 0.9970, 0.9970,  &
0.0328, 0.0819, 0.1944, 0.3704, 0.5951, 0.8032, 0.9438, 0.9927, 0.9970,  &
0.0225, 0.0599, 0.1433, 0.2963, 0.4983, 0.7284, 0.8964, 0.9791, 0.9970,  &
0.0122, 0.0359, 0.1021, 0.2177, 0.4175, 0.6264, 0.8143, 0.9391, 0.9919,  &
0.0056, 0.0185, 0.0552, 0.1433, 0.2554, 0.3859, 0.4820, 0.5792, 0.8250 /
data ((cldnuctab( 1,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.0702, 0.1625, 0.3251, 0.5471, 0.7798, 0.9391, 0.9935, 0.9970, 0.9970,  &
0.0467, 0.1174, 0.2425, 0.4335, 0.6718, 0.8726, 0.9770, 0.9970, 0.9970,  &
0.0328, 0.0819, 0.1834, 0.3551, 0.5792, 0.8032, 0.9438, 0.9935, 0.9970,  &
0.0204, 0.0552, 0.1342, 0.2824, 0.4820, 0.7147, 0.8964, 0.9791, 0.9970,  &
0.0136, 0.0392, 0.0950, 0.2177, 0.4016, 0.6264, 0.8354, 0.9564, 0.9948,  &
0.0079, 0.0248, 0.0702, 0.1625, 0.3251, 0.5471, 0.7675, 0.9103, 0.9829,  &
0.0039, 0.0122, 0.0392, 0.1095, 0.2425, 0.4175, 0.6264, 0.7917, 0.9229 /
data ((cldnuctab( 1,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.0552, 0.1256, 0.2687, 0.4658, 0.7147, 0.9036, 0.9846, 0.9970, 0.9970,  &
0.0328, 0.0883, 0.1944, 0.3704, 0.5951, 0.8143, 0.9525, 0.9954, 0.9970,  &
0.0225, 0.0599, 0.1342, 0.2824, 0.4820, 0.7147, 0.9036, 0.9829, 0.9970,  &
0.0136, 0.0392, 0.0950, 0.2059, 0.3859, 0.6264, 0.8354, 0.9564, 0.9954,  &
0.0088, 0.0272, 0.0702, 0.1625, 0.3106, 0.5308, 0.7548, 0.9168, 0.9861,  &
0.0056, 0.0167, 0.0467, 0.1174, 0.2425, 0.4496, 0.6718, 0.8639, 0.9634,  &
0.0027, 0.0088, 0.0272, 0.0759, 0.1834, 0.3551, 0.5792, 0.7675, 0.9103 /
data ((cldnuctab( 1,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.0428, 0.1021, 0.2177, 0.4175, 0.6569, 0.8639, 0.9747, 0.9970, 0.9970,  &
0.0272, 0.0649, 0.1527, 0.3106, 0.5308, 0.7675, 0.9286, 0.9909, 0.9970,  &
0.0167, 0.0428, 0.1021, 0.2177, 0.4175, 0.6418, 0.8548, 0.9666, 0.9970,  &
0.0099, 0.0272, 0.0702, 0.1625, 0.3251, 0.5471, 0.7675, 0.9229, 0.9887,  &
0.0063, 0.0185, 0.0508, 0.1174, 0.2425, 0.4496, 0.6718, 0.8639, 0.9695,  &
0.0039, 0.0122, 0.0328, 0.0819, 0.1944, 0.3551, 0.5792, 0.8032, 0.9391,  &
0.0021, 0.0063, 0.0204, 0.0552, 0.1342, 0.2824, 0.4983, 0.7147, 0.8809 /
data ((cldnuctab( 1,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.0359, 0.0883, 0.1944, 0.3704, 0.6108, 0.8354, 0.9634, 0.9970, 0.9970,  &
0.0204, 0.0552, 0.1256, 0.2687, 0.4658, 0.7147, 0.9036, 0.9846, 0.9970,  &
0.0122, 0.0328, 0.0819, 0.1834, 0.3551, 0.5792, 0.8143, 0.9483, 0.9948,  &
0.0079, 0.0225, 0.0552, 0.1342, 0.2687, 0.4658, 0.7007, 0.8889, 0.9791,  &
0.0044, 0.0136, 0.0359, 0.0950, 0.1944, 0.3704, 0.5951, 0.8143, 0.9483,  &
0.0027, 0.0088, 0.0248, 0.0649, 0.1433, 0.2963, 0.4983, 0.7284, 0.9036,  &
0.0016, 0.0050, 0.0151, 0.0428, 0.1021, 0.2299, 0.4175, 0.6418, 0.8354 /
data ((cldnuctab( 1,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.0328, 0.0759, 0.1728, 0.3400, 0.5792, 0.8143, 0.9525, 0.9954, 0.9970,  &
0.0185, 0.0467, 0.1095, 0.2425, 0.4335, 0.6718, 0.8809, 0.9770, 0.9970,  &
0.0110, 0.0299, 0.0702, 0.1625, 0.3251, 0.5471, 0.7798, 0.9340, 0.9919,  &
0.0063, 0.0185, 0.0467, 0.1095, 0.2299, 0.4175, 0.6569, 0.8639, 0.9695,  &
0.0035, 0.0110, 0.0299, 0.0759, 0.1625, 0.3251, 0.5471, 0.7675, 0.9229,  &
0.0021, 0.0063, 0.0185, 0.0508, 0.1174, 0.2425, 0.4335, 0.6718, 0.8639,  &
0.0012, 0.0039, 0.0122, 0.0328, 0.0819, 0.1834, 0.3551, 0.5792, 0.7917 /
data ((cldnuctab( 1,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.0299, 0.0702, 0.1625, 0.3251, 0.5471, 0.7917, 0.9438, 0.9942, 0.9970,  &
0.0167, 0.0428, 0.1021, 0.2177, 0.4016, 0.6569, 0.8639, 0.9722, 0.9970,  &
0.0088, 0.0248, 0.0649, 0.1433, 0.2963, 0.5146, 0.7418, 0.9229, 0.9887,  &
0.0056, 0.0151, 0.0392, 0.0950, 0.2059, 0.3859, 0.6108, 0.8354, 0.9600,  &
0.0031, 0.0088, 0.0248, 0.0649, 0.1433, 0.2824, 0.4983, 0.7284, 0.9036,  &
0.0018, 0.0056, 0.0167, 0.0428, 0.1021, 0.2177, 0.3859, 0.6264, 0.8250,  &
0.0011, 0.0031, 0.0099, 0.0272, 0.0702, 0.1527, 0.3106, 0.5146, 0.7418 /
data ((cldnuctab( 2,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.0643, 0.1516, 0.3234, 0.5773, 0.8441, 0.9767, 0.9994, 0.9999, 0.9999,  &
0.0424, 0.1086, 0.2410, 0.4639, 0.7403, 0.9334, 0.9953, 0.9999, 0.9999,  &
0.0269, 0.0752, 0.1715, 0.3686, 0.6246, 0.8629, 0.9809, 0.9995, 0.9999,  &
0.0182, 0.0503, 0.1246, 0.2808, 0.5290, 0.7784, 0.9520, 0.9967, 0.9999,  &
0.0121, 0.0355, 0.0942, 0.2163, 0.4316, 0.6847, 0.9027, 0.9859, 0.9996,  &
0.0070, 0.0222, 0.0643, 0.1614, 0.3382, 0.5773, 0.8019, 0.9433, 0.9959,  &
0.0039, 0.0134, 0.0424, 0.1086, 0.2285, 0.3686, 0.4964, 0.5290, 0.8130 /
data ((cldnuctab( 2,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.0424, 0.1086, 0.2539, 0.4801, 0.7533, 0.9433, 0.9967, 0.9999, 0.9999,  &
0.0269, 0.0752, 0.1715, 0.3533, 0.6246, 0.8629, 0.9827, 0.9996, 0.9999,  &
0.0165, 0.0462, 0.1246, 0.2672, 0.4964, 0.7660, 0.9478, 0.9963, 0.9999,  &
0.0108, 0.0324, 0.0875, 0.2045, 0.3998, 0.6701, 0.8879, 0.9859, 0.9996,  &
0.0070, 0.0201, 0.0593, 0.1516, 0.3089, 0.5613, 0.8130, 0.9596, 0.9974,  &
0.0044, 0.0134, 0.0424, 0.1086, 0.2410, 0.4639, 0.7269, 0.9096, 0.9873,  &
0.0023, 0.0087, 0.0269, 0.0752, 0.1821, 0.3686, 0.5773, 0.7784, 0.9222 /
data ((cldnuctab( 2,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.0324, 0.0812, 0.1931, 0.3841, 0.6551, 0.8955, 0.9897, 0.9998, 0.9999,  &
0.0182, 0.0503, 0.1246, 0.2808, 0.5127, 0.7903, 0.9559, 0.9980, 0.9999,  &
0.0108, 0.0324, 0.0875, 0.2045, 0.3998, 0.6701, 0.8955, 0.9873, 0.9997,  &
0.0070, 0.0201, 0.0593, 0.1422, 0.3089, 0.5452, 0.8019, 0.9596, 0.9977,  &
0.0044, 0.0134, 0.0388, 0.1012, 0.2285, 0.4477, 0.7131, 0.9096, 0.9897,  &
0.0027, 0.0087, 0.0269, 0.0752, 0.1715, 0.3533, 0.6090, 0.8441, 0.9691,  &
0.0016, 0.0055, 0.0165, 0.0503, 0.1246, 0.2808, 0.5127, 0.7403, 0.9096 /
data ((cldnuctab( 2,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.0245, 0.0643, 0.1614, 0.3234, 0.5933, 0.8441, 0.9789, 0.9994, 0.9999,  &
0.0149, 0.0388, 0.1012, 0.2285, 0.4477, 0.7131, 0.9222, 0.9941, 0.9999,  &
0.0087, 0.0245, 0.0643, 0.1516, 0.3234, 0.5773, 0.8342, 0.9719, 0.9988,  &
0.0049, 0.0149, 0.0424, 0.1086, 0.2410, 0.4477, 0.7131, 0.9222, 0.9926,  &
0.0030, 0.0097, 0.0269, 0.0752, 0.1715, 0.3533, 0.6090, 0.8441, 0.9744,  &
0.0018, 0.0055, 0.0182, 0.0503, 0.1246, 0.2672, 0.4964, 0.7533, 0.9334,  &
0.0011, 0.0034, 0.0108, 0.0324, 0.0875, 0.2045, 0.4156, 0.6551, 0.8716 /
data ((cldnuctab( 2,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.0222, 0.0546, 0.1332, 0.2947, 0.5290, 0.8019, 0.9630, 0.9985, 0.9999,  &
0.0121, 0.0324, 0.0812, 0.1931, 0.3841, 0.6551, 0.8879, 0.9873, 0.9997,  &
0.0062, 0.0182, 0.0503, 0.1246, 0.2672, 0.4964, 0.7660, 0.9478, 0.9967,  &
0.0039, 0.0108, 0.0324, 0.0812, 0.1931, 0.3841, 0.6400, 0.8716, 0.9827,  &
0.0021, 0.0070, 0.0201, 0.0546, 0.1332, 0.2808, 0.5127, 0.7784, 0.9478,  &
0.0012, 0.0039, 0.0121, 0.0355, 0.0942, 0.2163, 0.4156, 0.6701, 0.8879,  &
0.0007, 0.0023, 0.0078, 0.0245, 0.0643, 0.1516, 0.3234, 0.5613, 0.8019 /
data ((cldnuctab( 2,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.0182, 0.0503, 0.1246, 0.2672, 0.4964, 0.7660, 0.9520, 0.9974, 0.9999,  &
0.0097, 0.0296, 0.0752, 0.1715, 0.3382, 0.6090, 0.8537, 0.9809, 0.9994,  &
0.0055, 0.0165, 0.0424, 0.1086, 0.2410, 0.4477, 0.7131, 0.9279, 0.9941,  &
0.0030, 0.0087, 0.0269, 0.0696, 0.1614, 0.3234, 0.5773, 0.8238, 0.9691,  &
0.0018, 0.0055, 0.0165, 0.0424, 0.1086, 0.2410, 0.4477, 0.7131, 0.9160,  &
0.0009, 0.0030, 0.0097, 0.0269, 0.0752, 0.1715, 0.3382, 0.5933, 0.8342,  &
0.0006, 0.0018, 0.0062, 0.0182, 0.0503, 0.1246, 0.2672, 0.4801, 0.7403 /
data ((cldnuctab( 2,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.0165, 0.0462, 0.1086, 0.2410, 0.4639, 0.7403, 0.9385, 0.9959, 0.9999,  &
0.0087, 0.0245, 0.0643, 0.1516, 0.3234, 0.5613, 0.8342, 0.9719, 0.9990,  &
0.0049, 0.0134, 0.0388, 0.0942, 0.2163, 0.4156, 0.6847, 0.9027, 0.9908,  &
0.0027, 0.0078, 0.0222, 0.0593, 0.1422, 0.2947, 0.5290, 0.7903, 0.9559,  &
0.0014, 0.0044, 0.0134, 0.0355, 0.0875, 0.2045, 0.3998, 0.6551, 0.8800,  &
0.0008, 0.0027, 0.0078, 0.0222, 0.0593, 0.1422, 0.2947, 0.5290, 0.7784,  &
0.0004, 0.0016, 0.0049, 0.0149, 0.0388, 0.1012, 0.2163, 0.4156, 0.6701 /
data ((cldnuctab( 2,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.0942, 0.2045, 0.3998, 0.6551, 0.8800, 0.9844, 0.9996, 0.9999, 0.9999,  &
0.0643, 0.1516, 0.3089, 0.5452, 0.7903, 0.9520, 0.9967, 0.9999, 0.9999,  &
0.0424, 0.1086, 0.2410, 0.4477, 0.6991, 0.9027, 0.9873, 0.9996, 0.9999,  &
0.0296, 0.0752, 0.1821, 0.3533, 0.6090, 0.8342, 0.9662, 0.9977, 0.9999,  &
0.0182, 0.0546, 0.1332, 0.2808, 0.5127, 0.7533, 0.9279, 0.9908, 0.9997,  &
0.0108, 0.0324, 0.0942, 0.2163, 0.4156, 0.6400, 0.8441, 0.9559, 0.9971,  &
0.0049, 0.0182, 0.0546, 0.1332, 0.2539, 0.3841, 0.4801, 0.5773, 0.8537 /
data ((cldnuctab( 2,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.0643, 0.1516, 0.3234, 0.5613, 0.8019, 0.9596, 0.9977, 0.9999, 0.9999,  &
0.0424, 0.1086, 0.2285, 0.4316, 0.6991, 0.9027, 0.9873, 0.9997, 0.9999,  &
0.0269, 0.0752, 0.1715, 0.3382, 0.5773, 0.8238, 0.9630, 0.9977, 0.9999,  &
0.0182, 0.0503, 0.1246, 0.2672, 0.4801, 0.7269, 0.9160, 0.9897, 0.9997,  &
0.0121, 0.0355, 0.0875, 0.2045, 0.3998, 0.6400, 0.8629, 0.9719, 0.9982,  &
0.0070, 0.0222, 0.0643, 0.1516, 0.3234, 0.5452, 0.7903, 0.9334, 0.9917,  &
0.0034, 0.0121, 0.0388, 0.1012, 0.2285, 0.4156, 0.6246, 0.8130, 0.9385 /
data ((cldnuctab( 2,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.0503, 0.1164, 0.2539, 0.4639, 0.7269, 0.9279, 0.9934, 0.9999, 0.9999,  &
0.0296, 0.0752, 0.1821, 0.3533, 0.5933, 0.8441, 0.9719, 0.9986, 0.9999,  &
0.0182, 0.0503, 0.1246, 0.2672, 0.4801, 0.7403, 0.9222, 0.9917, 0.9998,  &
0.0121, 0.0355, 0.0875, 0.1931, 0.3841, 0.6246, 0.8537, 0.9719, 0.9985,  &
0.0078, 0.0222, 0.0593, 0.1422, 0.3089, 0.5290, 0.7784, 0.9385, 0.9934,  &
0.0049, 0.0149, 0.0424, 0.1086, 0.2410, 0.4477, 0.6847, 0.8879, 0.9789,  &
0.0023, 0.0078, 0.0245, 0.0696, 0.1715, 0.3533, 0.5773, 0.7903, 0.9334 /
data ((cldnuctab( 2,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.0388, 0.0942, 0.2045, 0.3998, 0.6551, 0.8879, 0.9859, 0.9996, 0.9999,  &
0.0222, 0.0593, 0.1422, 0.2947, 0.5290, 0.7784, 0.9478, 0.9959, 0.9999,  &
0.0134, 0.0388, 0.0942, 0.2163, 0.3998, 0.6551, 0.8716, 0.9809, 0.9993,  &
0.0087, 0.0245, 0.0643, 0.1516, 0.3089, 0.5452, 0.7784, 0.9433, 0.9953,  &
0.0055, 0.0165, 0.0424, 0.1086, 0.2410, 0.4316, 0.6847, 0.8879, 0.9827,  &
0.0034, 0.0097, 0.0296, 0.0752, 0.1715, 0.3533, 0.5933, 0.8130, 0.9559,  &
0.0018, 0.0062, 0.0182, 0.0503, 0.1246, 0.2808, 0.4964, 0.7269, 0.9027 /
data ((cldnuctab( 2,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.0324, 0.0812, 0.1821, 0.3533, 0.6090, 0.8537, 0.9767, 0.9991, 0.9999,  &
0.0182, 0.0503, 0.1164, 0.2539, 0.4639, 0.7269, 0.9222, 0.9917, 0.9998,  &
0.0108, 0.0296, 0.0752, 0.1715, 0.3382, 0.5933, 0.8238, 0.9662, 0.9980,  &
0.0062, 0.0182, 0.0503, 0.1164, 0.2539, 0.4639, 0.7131, 0.9096, 0.9886,  &
0.0039, 0.0121, 0.0324, 0.0812, 0.1821, 0.3686, 0.6090, 0.8342, 0.9630,  &
0.0023, 0.0070, 0.0222, 0.0546, 0.1332, 0.2808, 0.4964, 0.7403, 0.9222,  &
0.0014, 0.0044, 0.0134, 0.0388, 0.0942, 0.2163, 0.3998, 0.6551, 0.8537 /
data ((cldnuctab( 2,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.0269, 0.0696, 0.1614, 0.3234, 0.5773, 0.8238, 0.9662, 0.9982, 0.9999,  &
0.0165, 0.0424, 0.1012, 0.2285, 0.4316, 0.6847, 0.8955, 0.9873, 0.9996,  &
0.0087, 0.0245, 0.0643, 0.1516, 0.3089, 0.5290, 0.7903, 0.9478, 0.9963,  &
0.0055, 0.0149, 0.0388, 0.1012, 0.2163, 0.4156, 0.6551, 0.8800, 0.9809,  &
0.0030, 0.0097, 0.0269, 0.0643, 0.1516, 0.3089, 0.5290, 0.7784, 0.9433,  &
0.0018, 0.0055, 0.0165, 0.0462, 0.1086, 0.2285, 0.4316, 0.6701, 0.8800,  &
0.0011, 0.0034, 0.0097, 0.0296, 0.0752, 0.1715, 0.3382, 0.5773, 0.8019 /
data ((cldnuctab( 2,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.0269, 0.0643, 0.1516, 0.3089, 0.5452, 0.8019, 0.9596, 0.9974, 0.9999,  &
0.0149, 0.0388, 0.0942, 0.2045, 0.3998, 0.6551, 0.8800, 0.9827, 0.9994,  &
0.0078, 0.0222, 0.0593, 0.1332, 0.2808, 0.4964, 0.7533, 0.9334, 0.9941,  &
0.0044, 0.0134, 0.0355, 0.0875, 0.1931, 0.3686, 0.6090, 0.8441, 0.9719,  &
0.0027, 0.0078, 0.0222, 0.0546, 0.1332, 0.2672, 0.4801, 0.7269, 0.9222,  &
0.0016, 0.0049, 0.0134, 0.0355, 0.0875, 0.1931, 0.3841, 0.6090, 0.8441,  &
0.0009, 0.0030, 0.0087, 0.0245, 0.0593, 0.1422, 0.2947, 0.5127, 0.7533 /
data ((cldnuctab( 2,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.1332, 0.2808, 0.4964, 0.7403, 0.9222, 0.9908, 0.9997, 0.9999, 0.9999,  &
0.0942, 0.2163, 0.3998, 0.6400, 0.8537, 0.9691, 0.9980, 0.9999, 0.9999,  &
0.0696, 0.1614, 0.3234, 0.5452, 0.7784, 0.9334, 0.9917, 0.9997, 0.9999,  &
0.0462, 0.1164, 0.2539, 0.4477, 0.6991, 0.8879, 0.9789, 0.9986, 0.9999,  &
0.0296, 0.0812, 0.1931, 0.3686, 0.6090, 0.8238, 0.9520, 0.9941, 0.9998,  &
0.0149, 0.0462, 0.1246, 0.2808, 0.4964, 0.7131, 0.8800, 0.9719, 0.9985,  &
0.0062, 0.0222, 0.0696, 0.1614, 0.2947, 0.3998, 0.5127, 0.5127, 0.8537 /
data ((cldnuctab( 2,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.1012, 0.2163, 0.3998, 0.6551, 0.8629, 0.9767, 0.9988, 0.9999, 0.9999,  &
0.0696, 0.1516, 0.3089, 0.5452, 0.7784, 0.9385, 0.9926, 0.9998, 0.9999,  &
0.0462, 0.1086, 0.2410, 0.4316, 0.6847, 0.8800, 0.9767, 0.9986, 0.9999,  &
0.0296, 0.0812, 0.1821, 0.3533, 0.5773, 0.8130, 0.9478, 0.9941, 0.9998,  &
0.0201, 0.0546, 0.1332, 0.2808, 0.4964, 0.7269, 0.9027, 0.9844, 0.9991,  &
0.0097, 0.0324, 0.0875, 0.2163, 0.3998, 0.6400, 0.8441, 0.9559, 0.9953,  &
0.0044, 0.0149, 0.0503, 0.1332, 0.2947, 0.4801, 0.6991, 0.8441, 0.9596 /
data ((cldnuctab( 2,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.0752, 0.1715, 0.3382, 0.5613, 0.8019, 0.9520, 0.9963, 0.9999, 0.9999,  &
0.0503, 0.1164, 0.2410, 0.4477, 0.6991, 0.8955, 0.9827, 0.9992, 0.9999,  &
0.0324, 0.0812, 0.1821, 0.3533, 0.5773, 0.8130, 0.9520, 0.9953, 0.9999,  &
0.0201, 0.0546, 0.1332, 0.2808, 0.4801, 0.7269, 0.9027, 0.9844, 0.9992,  &
0.0134, 0.0388, 0.0942, 0.2163, 0.3998, 0.6246, 0.8441, 0.9630, 0.9963,  &
0.0070, 0.0222, 0.0643, 0.1516, 0.3234, 0.5452, 0.7660, 0.9279, 0.9873,  &
0.0034, 0.0108, 0.0355, 0.1012, 0.2285, 0.4316, 0.6701, 0.8537, 0.9520 /
data ((cldnuctab( 2,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.0593, 0.1332, 0.2808, 0.4964, 0.7533, 0.9279, 0.9917, 0.9998, 0.9999,  &
0.0355, 0.0875, 0.2045, 0.3841, 0.6246, 0.8441, 0.9691, 0.9977, 0.9999,  &
0.0222, 0.0593, 0.1422, 0.2808, 0.4964, 0.7403, 0.9222, 0.9886, 0.9996,  &
0.0149, 0.0388, 0.1012, 0.2163, 0.3998, 0.6400, 0.8537, 0.9662, 0.9974,  &
0.0097, 0.0269, 0.0696, 0.1614, 0.3234, 0.5452, 0.7660, 0.9279, 0.9897,  &
0.0055, 0.0165, 0.0462, 0.1164, 0.2410, 0.4477, 0.6847, 0.8716, 0.9744,  &
0.0027, 0.0087, 0.0245, 0.0752, 0.1821, 0.3533, 0.5933, 0.8019, 0.9334 /
data ((cldnuctab( 2,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.0503, 0.1164, 0.2410, 0.4477, 0.6991, 0.9027, 0.9859, 0.9995, 0.9999,  &
0.0296, 0.0752, 0.1715, 0.3382, 0.5613, 0.8019, 0.9520, 0.9959, 0.9999,  &
0.0182, 0.0462, 0.1164, 0.2410, 0.4316, 0.6847, 0.8879, 0.9809, 0.9990,  &
0.0108, 0.0296, 0.0752, 0.1715, 0.3382, 0.5613, 0.7903, 0.9433, 0.9941,  &
0.0070, 0.0201, 0.0546, 0.1246, 0.2539, 0.4639, 0.6991, 0.8879, 0.9789,  &
0.0039, 0.0121, 0.0355, 0.0875, 0.1931, 0.3686, 0.5933, 0.8130, 0.9520,  &
0.0023, 0.0062, 0.0201, 0.0546, 0.1422, 0.2947, 0.5127, 0.7403, 0.9027 /
data ((cldnuctab( 2,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.0424, 0.1012, 0.2163, 0.4156, 0.6701, 0.8800, 0.9809, 0.9991, 0.9999,  &
0.0245, 0.0643, 0.1422, 0.2947, 0.5127, 0.7660, 0.9334, 0.9934, 0.9998,  &
0.0149, 0.0388, 0.0942, 0.2045, 0.3998, 0.6400, 0.8537, 0.9691, 0.9980,  &
0.0087, 0.0245, 0.0643, 0.1422, 0.2947, 0.5127, 0.7403, 0.9222, 0.9897,  &
0.0055, 0.0149, 0.0424, 0.1012, 0.2163, 0.3998, 0.6400, 0.8441, 0.9662,  &
0.0034, 0.0097, 0.0269, 0.0696, 0.1614, 0.3089, 0.5290, 0.7660, 0.9222,  &
0.0016, 0.0055, 0.0165, 0.0424, 0.1086, 0.2410, 0.4316, 0.6701, 0.8629 /
data ((cldnuctab( 2,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.0388, 0.0942, 0.2045, 0.3998, 0.6400, 0.8629, 0.9767, 0.9986, 0.9999,  &
0.0222, 0.0593, 0.1332, 0.2672, 0.4964, 0.7403, 0.9222, 0.9908, 0.9996,  &
0.0134, 0.0355, 0.0875, 0.1821, 0.3533, 0.5933, 0.8238, 0.9630, 0.9967,  &
0.0078, 0.0222, 0.0546, 0.1246, 0.2672, 0.4639, 0.7131, 0.9027, 0.9844,  &
0.0049, 0.0134, 0.0355, 0.0875, 0.1931, 0.3533, 0.5933, 0.8130, 0.9520,  &
0.0027, 0.0078, 0.0222, 0.0593, 0.1332, 0.2672, 0.4801, 0.7131, 0.8955,  &
0.0014, 0.0044, 0.0134, 0.0355, 0.0942, 0.2045, 0.3841, 0.6090, 0.8238 /
data ((cldnuctab( 2,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.2045, 0.3841, 0.6090, 0.8238, 0.9559, 0.9953, 0.9998, 0.9999, 0.9999,  &
0.1516, 0.2947, 0.5127, 0.7403, 0.9096, 0.9844, 0.9991, 0.9999, 0.9999,  &
0.1086, 0.2285, 0.4156, 0.6551, 0.8537, 0.9630, 0.9959, 0.9998, 0.9999,  &
0.0696, 0.1715, 0.3382, 0.5613, 0.7784, 0.9279, 0.9886, 0.9993, 0.9999,  &
0.0388, 0.1086, 0.2539, 0.4639, 0.6991, 0.8879, 0.9719, 0.9971, 0.9999,  &
0.0182, 0.0593, 0.1614, 0.3533, 0.5773, 0.7784, 0.9279, 0.9844, 0.9992,  &
0.0070, 0.0245, 0.0812, 0.1821, 0.2947, 0.3686, 0.4316, 0.4316, 0.8955 /
data ((cldnuctab( 2,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.1422, 0.2947, 0.5127, 0.7403, 0.9160, 0.9873, 0.9994, 0.9999, 0.9999,  &
0.1012, 0.2285, 0.4156, 0.6400, 0.8537, 0.9630, 0.9967, 0.9999, 0.9999,  &
0.0752, 0.1715, 0.3234, 0.5452, 0.7784, 0.9279, 0.9886, 0.9994, 0.9999,  &
0.0503, 0.1246, 0.2539, 0.4639, 0.6847, 0.8716, 0.9719, 0.9971, 0.9999,  &
0.0269, 0.0812, 0.1931, 0.3686, 0.6090, 0.8130, 0.9433, 0.9917, 0.9995,  &
0.0134, 0.0424, 0.1164, 0.2808, 0.4964, 0.7403, 0.9027, 0.9767, 0.9974,  &
0.0049, 0.0182, 0.0593, 0.1614, 0.3382, 0.5452, 0.7403, 0.8955, 0.9744 /
data ((cldnuctab( 2,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.1086, 0.2410, 0.4316, 0.6701, 0.8716, 0.9744, 0.9982, 0.9999, 0.9999,  &
0.0752, 0.1715, 0.3382, 0.5613, 0.7903, 0.9385, 0.9917, 0.9996, 0.9999,  &
0.0503, 0.1246, 0.2539, 0.4639, 0.6847, 0.8800, 0.9744, 0.9977, 0.9999,  &
0.0355, 0.0875, 0.1931, 0.3686, 0.5933, 0.8130, 0.9433, 0.9917, 0.9996,  &
0.0201, 0.0593, 0.1422, 0.2947, 0.5127, 0.7269, 0.9027, 0.9789, 0.9982,  &
0.0097, 0.0296, 0.0875, 0.2163, 0.4156, 0.6400, 0.8441, 0.9559, 0.9934,  &
0.0039, 0.0134, 0.0424, 0.1246, 0.2947, 0.5127, 0.7403, 0.8955, 0.9744 /
data ((cldnuctab( 2,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.0875, 0.1931, 0.3686, 0.6090, 0.8342, 0.9596, 0.9963, 0.9999, 0.9999,  &
0.0593, 0.1332, 0.2808, 0.4801, 0.7269, 0.9027, 0.9827, 0.9990, 0.9999,  &
0.0388, 0.0942, 0.2045, 0.3841, 0.6090, 0.8238, 0.9559, 0.9948, 0.9998,  &
0.0245, 0.0643, 0.1516, 0.2947, 0.5127, 0.7403, 0.9096, 0.9827, 0.9988,  &
0.0149, 0.0424, 0.1086, 0.2285, 0.4156, 0.6551, 0.8441, 0.9596, 0.9953,  &
0.0078, 0.0222, 0.0643, 0.1614, 0.3382, 0.5613, 0.7784, 0.9279, 0.9859,  &
0.0030, 0.0097, 0.0324, 0.0942, 0.2285, 0.4477, 0.6847, 0.8629, 0.9630 /
data ((cldnuctab( 2,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.0752, 0.1614, 0.3234, 0.5613, 0.7903, 0.9433, 0.9934, 0.9997, 0.9999,  &
0.0462, 0.1086, 0.2410, 0.4316, 0.6701, 0.8716, 0.9744, 0.9980, 0.9999,  &
0.0296, 0.0752, 0.1715, 0.3234, 0.5452, 0.7784, 0.9334, 0.9897, 0.9995,  &
0.0201, 0.0503, 0.1164, 0.2410, 0.4477, 0.6701, 0.8716, 0.9691, 0.9971,  &
0.0121, 0.0324, 0.0812, 0.1821, 0.3533, 0.5773, 0.7903, 0.9334, 0.9897,  &
0.0062, 0.0182, 0.0503, 0.1246, 0.2672, 0.4801, 0.6991, 0.8879, 0.9744,  &
0.0027, 0.0078, 0.0245, 0.0752, 0.1821, 0.3686, 0.6090, 0.8130, 0.9433 /
data ((cldnuctab( 2,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.0643, 0.1516, 0.2947, 0.5127, 0.7660, 0.9279, 0.9908, 0.9996, 0.9999,  &
0.0388, 0.0942, 0.2045, 0.3841, 0.6246, 0.8441, 0.9662, 0.9967, 0.9999,  &
0.0245, 0.0643, 0.1422, 0.2808, 0.4964, 0.7269, 0.9096, 0.9859, 0.9991,  &
0.0165, 0.0424, 0.1012, 0.2045, 0.3841, 0.6246, 0.8342, 0.9559, 0.9948,  &
0.0097, 0.0269, 0.0643, 0.1516, 0.2947, 0.5127, 0.7403, 0.9096, 0.9827,  &
0.0049, 0.0149, 0.0424, 0.1012, 0.2285, 0.4156, 0.6400, 0.8441, 0.9559,  &
0.0021, 0.0070, 0.0201, 0.0593, 0.1516, 0.3234, 0.5452, 0.7660, 0.9160 /
data ((cldnuctab( 2,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.0593, 0.1332, 0.2808, 0.4964, 0.7403, 0.9160, 0.9886, 0.9994, 0.9999,  &
0.0355, 0.0875, 0.1931, 0.3686, 0.5933, 0.8238, 0.9559, 0.9959, 0.9998,  &
0.0222, 0.0546, 0.1246, 0.2539, 0.4639, 0.6991, 0.8955, 0.9809, 0.9986,  &
0.0134, 0.0355, 0.0875, 0.1821, 0.3533, 0.5773, 0.8019, 0.9433, 0.9926,  &
0.0078, 0.0222, 0.0546, 0.1332, 0.2672, 0.4639, 0.6991, 0.8800, 0.9744,  &
0.0044, 0.0134, 0.0355, 0.0875, 0.1931, 0.3686, 0.5933, 0.8019, 0.9385,  &
0.0018, 0.0062, 0.0182, 0.0503, 0.1246, 0.2672, 0.4801, 0.7131, 0.8879 /
data ((cldnuctab( 2,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.2410, 0.4477, 0.6701, 0.8716, 0.9691, 0.9971, 0.9999, 0.9999, 0.9999,  &
0.1821, 0.3533, 0.5773, 0.7903, 0.9385, 0.9897, 0.9995, 0.9999, 0.9999,  &
0.1332, 0.2808, 0.4801, 0.7131, 0.8879, 0.9744, 0.9974, 0.9999, 0.9999,  &
0.0875, 0.2045, 0.3998, 0.6246, 0.8342, 0.9520, 0.9926, 0.9996, 0.9999,  &
0.0462, 0.1332, 0.2947, 0.5290, 0.7660, 0.9160, 0.9827, 0.9982, 0.9999,  &
0.0182, 0.0643, 0.1821, 0.3841, 0.6246, 0.8238, 0.9385, 0.9897, 0.9995,  &
0.0070, 0.0269, 0.0812, 0.1931, 0.2947, 0.3533, 0.4316, 0.4477, 0.8716 /
data ((cldnuctab( 2,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.1821, 0.3533, 0.5773, 0.8019, 0.9433, 0.9917, 0.9996, 0.9999, 0.9999,  &
0.1332, 0.2672, 0.4801, 0.7131, 0.8879, 0.9767, 0.9980, 0.9999, 0.9999,  &
0.0942, 0.2045, 0.3841, 0.6090, 0.8238, 0.9478, 0.9926, 0.9996, 0.9999,  &
0.0643, 0.1516, 0.3089, 0.5290, 0.7533, 0.9096, 0.9809, 0.9982, 0.9999,  &
0.0324, 0.0942, 0.2285, 0.4316, 0.6701, 0.8537, 0.9630, 0.9948, 0.9997,  &
0.0134, 0.0462, 0.1332, 0.3234, 0.5613, 0.7903, 0.9279, 0.9844, 0.9985,  &
0.0055, 0.0201, 0.0643, 0.1821, 0.3686, 0.5773, 0.7784, 0.9027, 0.9827 /
data ((cldnuctab( 2,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.1422, 0.2808, 0.4964, 0.7269, 0.9096, 0.9844, 0.9990, 0.9999, 0.9999,  &
0.1012, 0.2163, 0.3998, 0.6246, 0.8342, 0.9559, 0.9948, 0.9998, 0.9999,  &
0.0696, 0.1516, 0.3089, 0.5290, 0.7533, 0.9096, 0.9827, 0.9986, 0.9999,  &
0.0462, 0.1086, 0.2410, 0.4316, 0.6551, 0.8537, 0.9630, 0.9953, 0.9997,  &
0.0245, 0.0696, 0.1715, 0.3533, 0.5773, 0.7903, 0.9279, 0.9873, 0.9990,  &
0.0108, 0.0355, 0.1012, 0.2539, 0.4639, 0.7131, 0.8879, 0.9719, 0.9963,  &
0.0044, 0.0149, 0.0503, 0.1422, 0.3234, 0.5613, 0.7784, 0.9222, 0.9827 /
data ((cldnuctab( 2,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.1164, 0.2410, 0.4316, 0.6701, 0.8716, 0.9744, 0.9977, 0.9999, 0.9999,  &
0.0752, 0.1715, 0.3234, 0.5452, 0.7784, 0.9334, 0.9897, 0.9994, 0.9999,  &
0.0503, 0.1164, 0.2539, 0.4477, 0.6847, 0.8716, 0.9691, 0.9967, 0.9998,  &
0.0324, 0.0812, 0.1821, 0.3533, 0.5773, 0.7903, 0.9334, 0.9886, 0.9993,  &
0.0182, 0.0546, 0.1332, 0.2808, 0.4801, 0.7131, 0.8879, 0.9744, 0.9971,  &
0.0087, 0.0269, 0.0752, 0.1931, 0.3841, 0.6246, 0.8238, 0.9478, 0.9908,  &
0.0034, 0.0108, 0.0355, 0.1086, 0.2672, 0.4964, 0.7269, 0.8955, 0.9744 /
data ((cldnuctab( 2,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.0942, 0.2045, 0.3841, 0.6246, 0.8342, 0.9630, 0.9963, 0.9998, 0.9999,  &
0.0593, 0.1422, 0.2808, 0.4964, 0.7269, 0.9096, 0.9827, 0.9988, 0.9999,  &
0.0388, 0.0942, 0.2045, 0.3841, 0.6090, 0.8238, 0.9520, 0.9941, 0.9997,  &
0.0269, 0.0643, 0.1516, 0.2947, 0.5127, 0.7403, 0.9027, 0.9809, 0.9982,  &
0.0149, 0.0424, 0.1012, 0.2285, 0.4156, 0.6400, 0.8342, 0.9559, 0.9934,  &
0.0070, 0.0222, 0.0593, 0.1516, 0.3234, 0.5452, 0.7660, 0.9160, 0.9827,  &
0.0027, 0.0087, 0.0296, 0.0812, 0.2163, 0.4316, 0.6701, 0.8629, 0.9596 /
data ((cldnuctab( 2,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.0812, 0.1821, 0.3533, 0.5773, 0.8130, 0.9520, 0.9948, 0.9997, 0.9999,  &
0.0546, 0.1246, 0.2539, 0.4477, 0.6847, 0.8800, 0.9767, 0.9982, 0.9999,  &
0.0324, 0.0812, 0.1821, 0.3382, 0.5613, 0.7903, 0.9385, 0.9908, 0.9995,  &
0.0222, 0.0546, 0.1246, 0.2539, 0.4477, 0.6847, 0.8716, 0.9719, 0.9971,  &
0.0121, 0.0355, 0.0875, 0.1821, 0.3533, 0.5773, 0.7903, 0.9334, 0.9886,  &
0.0062, 0.0182, 0.0503, 0.1246, 0.2672, 0.4801, 0.6991, 0.8800, 0.9719,  &
0.0023, 0.0078, 0.0245, 0.0696, 0.1715, 0.3686, 0.6090, 0.8130, 0.9433 /
data ((cldnuctab( 2,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.0752, 0.1715, 0.3234, 0.5613, 0.7903, 0.9433, 0.9934, 0.9997, 0.9999,  &
0.0462, 0.1086, 0.2285, 0.4156, 0.6551, 0.8629, 0.9719, 0.9974, 0.9999,  &
0.0296, 0.0696, 0.1614, 0.3089, 0.5290, 0.7533, 0.9222, 0.9873, 0.9992,  &
0.0182, 0.0462, 0.1086, 0.2285, 0.4156, 0.6400, 0.8441, 0.9630, 0.9953,  &
0.0108, 0.0296, 0.0752, 0.1614, 0.3234, 0.5290, 0.7533, 0.9160, 0.9844,  &
0.0055, 0.0149, 0.0424, 0.1086, 0.2285, 0.4316, 0.6551, 0.8441, 0.9596,  &
0.0021, 0.0070, 0.0201, 0.0593, 0.1516, 0.3234, 0.5452, 0.7660, 0.9160 /
data ((cldnuctab( 2,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.2808, 0.4964, 0.7131, 0.8955, 0.9767, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.2163, 0.3998, 0.6246, 0.8342, 0.9520, 0.9926, 0.9996, 0.9999, 0.9999,  &
0.1614, 0.3234, 0.5290, 0.7533, 0.9096, 0.9827, 0.9985, 0.9999, 0.9999,  &
0.1012, 0.2285, 0.4477, 0.6701, 0.8629, 0.9630, 0.9948, 0.9997, 0.9999,  &
0.0503, 0.1422, 0.3234, 0.5773, 0.8019, 0.9334, 0.9873, 0.9988, 0.9999,  &
0.0201, 0.0696, 0.1931, 0.3998, 0.6551, 0.8441, 0.9520, 0.9926, 0.9996,  &
0.0078, 0.0269, 0.0875, 0.1931, 0.2808, 0.3382, 0.3382, 0.4639, 0.8879 /
data ((cldnuctab( 2,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.2163, 0.3998, 0.6246, 0.8342, 0.9559, 0.9948, 0.9997, 0.9999, 0.9999,  &
0.1614, 0.3089, 0.5290, 0.7533, 0.9096, 0.9827, 0.9986, 0.9999, 0.9999,  &
0.1164, 0.2410, 0.4316, 0.6701, 0.8537, 0.9630, 0.9948, 0.9997, 0.9999,  &
0.0696, 0.1715, 0.3533, 0.5773, 0.7903, 0.9279, 0.9873, 0.9988, 0.9999,  &
0.0355, 0.1086, 0.2539, 0.4801, 0.7131, 0.8879, 0.9719, 0.9963, 0.9998,  &
0.0149, 0.0503, 0.1516, 0.3382, 0.5933, 0.8130, 0.9433, 0.9886, 0.9990,  &
0.0055, 0.0201, 0.0696, 0.1931, 0.3841, 0.5933, 0.7784, 0.9222, 0.9873 /
data ((cldnuctab( 2,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.1614, 0.3234, 0.5452, 0.7784, 0.9279, 0.9886, 0.9993, 0.9999, 0.9999,  &
0.1164, 0.2410, 0.4477, 0.6701, 0.8629, 0.9662, 0.9963, 0.9998, 0.9999,  &
0.0812, 0.1821, 0.3533, 0.5773, 0.7903, 0.9334, 0.9886, 0.9991, 0.9999,  &
0.0546, 0.1332, 0.2672, 0.4801, 0.7131, 0.8800, 0.9719, 0.9967, 0.9998,  &
0.0269, 0.0812, 0.1931, 0.3841, 0.6246, 0.8238, 0.9478, 0.9908, 0.9993,  &
0.0121, 0.0388, 0.1086, 0.2672, 0.5127, 0.7403, 0.9096, 0.9789, 0.9974,  &
0.0044, 0.0149, 0.0503, 0.1516, 0.3533, 0.5933, 0.8130, 0.9334, 0.9859 /
data ((cldnuctab( 2,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.1332, 0.2672, 0.4801, 0.7131, 0.8955, 0.9809, 0.9985, 0.9999, 0.9999,  &
0.0942, 0.1931, 0.3686, 0.5933, 0.8130, 0.9478, 0.9926, 0.9996, 0.9999,  &
0.0593, 0.1422, 0.2808, 0.4964, 0.7269, 0.8955, 0.9789, 0.9980, 0.9999,  &
0.0388, 0.1012, 0.2163, 0.3998, 0.6246, 0.8342, 0.9520, 0.9926, 0.9995,  &
0.0222, 0.0593, 0.1516, 0.3089, 0.5290, 0.7533, 0.9096, 0.9809, 0.9980,  &
0.0087, 0.0296, 0.0875, 0.2163, 0.4316, 0.6701, 0.8537, 0.9596, 0.9941,  &
0.0034, 0.0121, 0.0388, 0.1164, 0.2808, 0.5290, 0.7660, 0.9160, 0.9809 /
data ((cldnuctab( 2,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.1086, 0.2285, 0.4316, 0.6701, 0.8716, 0.9719, 0.9974, 0.9999, 0.9999,  &
0.0752, 0.1614, 0.3234, 0.5452, 0.7660, 0.9279, 0.9886, 0.9992, 0.9999,  &
0.0503, 0.1164, 0.2410, 0.4316, 0.6551, 0.8629, 0.9662, 0.9959, 0.9998,  &
0.0324, 0.0812, 0.1715, 0.3382, 0.5613, 0.7784, 0.9222, 0.9859, 0.9990,  &
0.0182, 0.0503, 0.1164, 0.2539, 0.4639, 0.6847, 0.8716, 0.9662, 0.9959,  &
0.0078, 0.0245, 0.0696, 0.1715, 0.3533, 0.5933, 0.8019, 0.9334, 0.9873,  &
0.0030, 0.0097, 0.0296, 0.0875, 0.2285, 0.4639, 0.7131, 0.8879, 0.9691 /
data ((cldnuctab( 2,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.0942, 0.2045, 0.3998, 0.6246, 0.8441, 0.9630, 0.9963, 0.9998, 0.9999,  &
0.0643, 0.1422, 0.2808, 0.4964, 0.7269, 0.9096, 0.9844, 0.9988, 0.9999,  &
0.0424, 0.0942, 0.2045, 0.3841, 0.6090, 0.8238, 0.9520, 0.9941, 0.9996,  &
0.0269, 0.0643, 0.1422, 0.2947, 0.4964, 0.7269, 0.8955, 0.9789, 0.9980,  &
0.0149, 0.0388, 0.1012, 0.2163, 0.3998, 0.6246, 0.8238, 0.9520, 0.9926,  &
0.0062, 0.0201, 0.0546, 0.1422, 0.2947, 0.5290, 0.7403, 0.9027, 0.9789,  &
0.0023, 0.0078, 0.0245, 0.0752, 0.1931, 0.3998, 0.6400, 0.8441, 0.9559 /
data ((cldnuctab( 2,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.0875, 0.1931, 0.3686, 0.6090, 0.8238, 0.9596, 0.9953, 0.9998, 0.9999,  &
0.0546, 0.1246, 0.2672, 0.4639, 0.6991, 0.8955, 0.9809, 0.9985, 0.9999,  &
0.0355, 0.0875, 0.1821, 0.3533, 0.5773, 0.8019, 0.9433, 0.9917, 0.9995,  &
0.0222, 0.0546, 0.1246, 0.2672, 0.4639, 0.6847, 0.8716, 0.9719, 0.9971,  &
0.0134, 0.0355, 0.0875, 0.1931, 0.3533, 0.5773, 0.7903, 0.9334, 0.9886,  &
0.0055, 0.0165, 0.0503, 0.1246, 0.2672, 0.4639, 0.6991, 0.8800, 0.9691,  &
0.0021, 0.0070, 0.0222, 0.0643, 0.1614, 0.3533, 0.5933, 0.8019, 0.9385 /
data ((cldnuctab( 2,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.3089, 0.5290, 0.7533, 0.9096, 0.9827, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.2410, 0.4316, 0.6701, 0.8537, 0.9596, 0.9948, 0.9997, 0.9999, 0.9999,  &
0.1715, 0.3533, 0.5773, 0.7903, 0.9279, 0.9859, 0.9988, 0.9999, 0.9999,  &
0.1086, 0.2539, 0.4801, 0.7131, 0.8800, 0.9719, 0.9963, 0.9998, 0.9999,  &
0.0503, 0.1516, 0.3533, 0.6090, 0.8238, 0.9478, 0.9897, 0.9991, 0.9999,  &
0.0201, 0.0696, 0.2045, 0.4316, 0.6701, 0.8629, 0.9630, 0.9941, 0.9997,  &
0.0078, 0.0269, 0.0875, 0.2045, 0.2808, 0.3234, 0.3382, 0.3533, 0.8955 /
data ((cldnuctab( 2,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.2410, 0.4316, 0.6701, 0.8629, 0.9662, 0.9959, 0.9998, 0.9999, 0.9999,  &
0.1821, 0.3382, 0.5613, 0.7784, 0.9279, 0.9873, 0.9990, 0.9999, 0.9999,  &
0.1246, 0.2672, 0.4801, 0.6991, 0.8800, 0.9691, 0.9963, 0.9998, 0.9999,  &
0.0812, 0.1931, 0.3841, 0.6090, 0.8130, 0.9433, 0.9897, 0.9992, 0.9999,  &
0.0388, 0.1164, 0.2672, 0.5127, 0.7403, 0.9027, 0.9789, 0.9974, 0.9998,  &
0.0149, 0.0503, 0.1516, 0.3686, 0.6246, 0.8342, 0.9520, 0.9908, 0.9993,  &
0.0055, 0.0201, 0.0696, 0.1931, 0.3998, 0.6090, 0.7903, 0.9334, 0.9908 /
data ((cldnuctab( 2,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.1821, 0.3533, 0.5773, 0.8019, 0.9433, 0.9917, 0.9995, 0.9999, 0.9999,  &
0.1332, 0.2672, 0.4801, 0.7131, 0.8879, 0.9744, 0.9974, 0.9999, 0.9999,  &
0.0942, 0.2045, 0.3841, 0.6090, 0.8130, 0.9433, 0.9908, 0.9994, 0.9999,  &
0.0593, 0.1422, 0.2947, 0.5127, 0.7403, 0.9027, 0.9789, 0.9974, 0.9998,  &
0.0296, 0.0875, 0.2163, 0.4156, 0.6551, 0.8441, 0.9559, 0.9934, 0.9995,  &
0.0121, 0.0388, 0.1164, 0.2947, 0.5452, 0.7784, 0.9222, 0.9827, 0.9980,  &
0.0044, 0.0149, 0.0546, 0.1614, 0.3686, 0.6246, 0.8238, 0.9433, 0.9897 /
data ((cldnuctab( 2,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.1516, 0.2947, 0.5127, 0.7533, 0.9160, 0.9859, 0.9990, 0.9999, 0.9999,  &
0.1012, 0.2163, 0.3998, 0.6400, 0.8441, 0.9596, 0.9948, 0.9997, 0.9999,  &
0.0696, 0.1614, 0.3234, 0.5290, 0.7533, 0.9160, 0.9827, 0.9985, 0.9999,  &
0.0462, 0.1086, 0.2410, 0.4316, 0.6701, 0.8537, 0.9596, 0.9948, 0.9996,  &
0.0222, 0.0643, 0.1614, 0.3382, 0.5613, 0.7784, 0.9279, 0.9859, 0.9986,  &
0.0097, 0.0296, 0.0942, 0.2285, 0.4639, 0.6991, 0.8800, 0.9691, 0.9953,  &
0.0034, 0.0121, 0.0388, 0.1246, 0.3089, 0.5613, 0.7903, 0.9334, 0.9844 /
data ((cldnuctab( 2,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.1246, 0.2539, 0.4639, 0.6991, 0.8879, 0.9789, 0.9982, 0.9999, 0.9999,  &
0.0875, 0.1821, 0.3533, 0.5773, 0.8019, 0.9433, 0.9917, 0.9995, 0.9999,  &
0.0546, 0.1332, 0.2672, 0.4639, 0.6991, 0.8800, 0.9719, 0.9971, 0.9998,  &
0.0355, 0.0875, 0.1931, 0.3686, 0.5933, 0.8019, 0.9385, 0.9897, 0.9992,  &
0.0182, 0.0546, 0.1332, 0.2808, 0.4964, 0.7131, 0.8879, 0.9744, 0.9967,  &
0.0078, 0.0245, 0.0752, 0.1821, 0.3841, 0.6246, 0.8238, 0.9478, 0.9908,  &
0.0030, 0.0097, 0.0324, 0.0942, 0.2410, 0.4801, 0.7403, 0.9027, 0.9767 /
data ((cldnuctab( 2,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.1086, 0.2285, 0.4316, 0.6701, 0.8716, 0.9719, 0.9974, 0.9999, 0.9999,  &
0.0752, 0.1614, 0.3089, 0.5290, 0.7660, 0.9279, 0.9886, 0.9992, 0.9999,  &
0.0462, 0.1086, 0.2285, 0.4156, 0.6400, 0.8537, 0.9630, 0.9953, 0.9997,  &
0.0296, 0.0752, 0.1614, 0.3234, 0.5290, 0.7533, 0.9160, 0.9844, 0.9986,  &
0.0165, 0.0462, 0.1086, 0.2410, 0.4316, 0.6551, 0.8537, 0.9596, 0.9941,  &
0.0070, 0.0201, 0.0593, 0.1516, 0.3234, 0.5613, 0.7784, 0.9222, 0.9844,  &
0.0027, 0.0078, 0.0269, 0.0752, 0.2045, 0.4156, 0.6701, 0.8629, 0.9630 /
data ((cldnuctab( 2,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.1012, 0.2163, 0.3998, 0.6400, 0.8537, 0.9662, 0.9967, 0.9998, 0.9999,  &
0.0643, 0.1422, 0.2947, 0.4964, 0.7403, 0.9096, 0.9844, 0.9988, 0.9999,  &
0.0424, 0.1012, 0.2045, 0.3841, 0.6090, 0.8238, 0.9520, 0.9941, 0.9996,  &
0.0269, 0.0643, 0.1422, 0.2808, 0.4964, 0.7269, 0.8955, 0.9789, 0.9980,  &
0.0149, 0.0388, 0.0942, 0.2045, 0.3841, 0.6090, 0.8238, 0.9478, 0.9917,  &
0.0062, 0.0182, 0.0546, 0.1332, 0.2808, 0.4964, 0.7269, 0.8955, 0.9767,  &
0.0021, 0.0070, 0.0222, 0.0643, 0.1715, 0.3686, 0.6246, 0.8342, 0.9478 /
data ((cldnuctab( 3,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.2107, 0.4002, 0.6519, 0.8697, 0.9795, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.1616, 0.3148, 0.5457, 0.7892, 0.9485, 0.9952, 0.9998, 0.9999, 0.9999,  &
0.1117, 0.2527, 0.4542, 0.7013, 0.8967, 0.9836, 0.9992, 0.9999, 0.9999,  &
0.0739, 0.1852, 0.3652, 0.6173, 0.8383, 0.9614, 0.9968, 0.9999, 0.9999,  &
0.0385, 0.1117, 0.2676, 0.5091, 0.7617, 0.9260, 0.9898, 0.9994, 0.9999,  &
0.0183, 0.0619, 0.1732, 0.3652, 0.6173, 0.8268, 0.9531, 0.9945, 0.9998,  &
0.0070, 0.0254, 0.0806, 0.1852, 0.2986, 0.3481, 0.4181, 0.4361, 0.8882 /
data ((cldnuctab( 3,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.1507, 0.3148, 0.5457, 0.7892, 0.9531, 0.9958, 0.9999, 0.9999, 0.9999,  &
0.1117, 0.2382, 0.4361, 0.6852, 0.8967, 0.9836, 0.9993, 0.9999, 0.9999,  &
0.0739, 0.1732, 0.3481, 0.5997, 0.8268, 0.9575, 0.9963, 0.9999, 0.9999,  &
0.0515, 0.1302, 0.2676, 0.4908, 0.7324, 0.9193, 0.9884, 0.9994, 0.9999,  &
0.0283, 0.0806, 0.1977, 0.4002, 0.6519, 0.8598, 0.9716, 0.9976, 0.9999,  &
0.0129, 0.0425, 0.1207, 0.2986, 0.5457, 0.7757, 0.9380, 0.9909, 0.9996,  &
0.0054, 0.0183, 0.0619, 0.1732, 0.3481, 0.5638, 0.7757, 0.9122, 0.9898 /
data ((cldnuctab( 3,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.1207, 0.2527, 0.4542, 0.7170, 0.9122, 0.9898, 0.9997, 0.9999, 0.9999,  &
0.0806, 0.1852, 0.3652, 0.5997, 0.8268, 0.9651, 0.9976, 0.9999, 0.9999,  &
0.0515, 0.1302, 0.2676, 0.4908, 0.7324, 0.9193, 0.9898, 0.9996, 0.9999,  &
0.0348, 0.0952, 0.2107, 0.4002, 0.6347, 0.8493, 0.9685, 0.9979, 0.9999,  &
0.0205, 0.0619, 0.1507, 0.3148, 0.5457, 0.7757, 0.9380, 0.9920, 0.9997,  &
0.0102, 0.0314, 0.0877, 0.2242, 0.4361, 0.6852, 0.8882, 0.9795, 0.9984,  &
0.0041, 0.0129, 0.0425, 0.1302, 0.3148, 0.5457, 0.7757, 0.9322, 0.9898 /
data ((cldnuctab( 3,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.0952, 0.1977, 0.4002, 0.6519, 0.8697, 0.9795, 0.9991, 0.9999, 0.9999,  &
0.0619, 0.1402, 0.2986, 0.5091, 0.7617, 0.9380, 0.9938, 0.9998, 0.9999,  &
0.0385, 0.0952, 0.2107, 0.4002, 0.6519, 0.8697, 0.9771, 0.9986, 0.9999,  &
0.0254, 0.0677, 0.1616, 0.3148, 0.5457, 0.7892, 0.9380, 0.9938, 0.9997,  &
0.0163, 0.0425, 0.1117, 0.2382, 0.4542, 0.6852, 0.8882, 0.9795, 0.9988,  &
0.0079, 0.0228, 0.0677, 0.1732, 0.3481, 0.5997, 0.8148, 0.9531, 0.9952,  &
0.0031, 0.0102, 0.0348, 0.0952, 0.2382, 0.4725, 0.7170, 0.9047, 0.9795 /
data ((cldnuctab( 3,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.0739, 0.1732, 0.3481, 0.5818, 0.8268, 0.9685, 0.9982, 0.9999, 0.9999,  &
0.0468, 0.1117, 0.2527, 0.4542, 0.7013, 0.9047, 0.9884, 0.9996, 0.9999,  &
0.0314, 0.0806, 0.1732, 0.3481, 0.5818, 0.8148, 0.9575, 0.9968, 0.9999,  &
0.0205, 0.0515, 0.1207, 0.2527, 0.4725, 0.7170, 0.9047, 0.9854, 0.9993,  &
0.0115, 0.0348, 0.0877, 0.1852, 0.3652, 0.5997, 0.8268, 0.9614, 0.9963,  &
0.0061, 0.0183, 0.0515, 0.1302, 0.2829, 0.5091, 0.7473, 0.9193, 0.9884,  &
0.0027, 0.0079, 0.0254, 0.0739, 0.1977, 0.4002, 0.6519, 0.8598, 0.9651 /
data ((cldnuctab( 3,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.0677, 0.1507, 0.3148, 0.5457, 0.8022, 0.9575, 0.9968, 0.9999, 0.9999,  &
0.0425, 0.0952, 0.2107, 0.4002, 0.6519, 0.8792, 0.9816, 0.9992, 0.9999,  &
0.0254, 0.0677, 0.1507, 0.2986, 0.5274, 0.7757, 0.9380, 0.9938, 0.9998,  &
0.0163, 0.0425, 0.1032, 0.2242, 0.4181, 0.6519, 0.8697, 0.9745, 0.9986,  &
0.0102, 0.0283, 0.0677, 0.1616, 0.3148, 0.5457, 0.7757, 0.9380, 0.9929,  &
0.0054, 0.0145, 0.0425, 0.1032, 0.2382, 0.4361, 0.6852, 0.8792, 0.9771,  &
0.0020, 0.0070, 0.0205, 0.0619, 0.1616, 0.3312, 0.5638, 0.8022, 0.9434 /
data ((cldnuctab( 3,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.0619, 0.1402, 0.2829, 0.5091, 0.7757, 0.9434, 0.9958, 0.9999, 0.9999,  &
0.0348, 0.0877, 0.1977, 0.3826, 0.6173, 0.8598, 0.9745, 0.9988, 0.9999,  &
0.0228, 0.0565, 0.1302, 0.2676, 0.4908, 0.7324, 0.9193, 0.9909, 0.9997,  &
0.0129, 0.0348, 0.0877, 0.1977, 0.3652, 0.5997, 0.8383, 0.9651, 0.9976,  &
0.0079, 0.0228, 0.0565, 0.1302, 0.2829, 0.4908, 0.7324, 0.9122, 0.9870,  &
0.0047, 0.0129, 0.0348, 0.0877, 0.1977, 0.3826, 0.6173, 0.8383, 0.9614,  &
0.0020, 0.0061, 0.0183, 0.0515, 0.1302, 0.2829, 0.5091, 0.7473, 0.9193 /
data ((cldnuctab( 3,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.2829, 0.5091, 0.7473, 0.9193, 0.9870, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2242, 0.4181, 0.6519, 0.8598, 0.9685, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.1616, 0.3312, 0.5638, 0.7757, 0.9322, 0.9909, 0.9995, 0.9999, 0.9999,  &
0.1032, 0.2382, 0.4542, 0.7013, 0.8882, 0.9771, 0.9982, 0.9999, 0.9999,  &
0.0468, 0.1402, 0.3312, 0.5997, 0.8268, 0.9531, 0.9938, 0.9997, 0.9999,  &
0.0205, 0.0677, 0.1977, 0.4181, 0.6687, 0.8697, 0.9685, 0.9968, 0.9999,  &
0.0070, 0.0283, 0.0877, 0.1977, 0.2829, 0.3312, 0.3312, 0.4542, 0.9047 /
data ((cldnuctab( 3,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.2242, 0.4181, 0.6519, 0.8598, 0.9716, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.1616, 0.3148, 0.5457, 0.7757, 0.9322, 0.9909, 0.9996, 0.9999, 0.9999,  &
0.1117, 0.2527, 0.4542, 0.6852, 0.8792, 0.9745, 0.9979, 0.9999, 0.9999,  &
0.0739, 0.1732, 0.3652, 0.5997, 0.8148, 0.9485, 0.9929, 0.9997, 0.9999,  &
0.0348, 0.1032, 0.2527, 0.4908, 0.7324, 0.9047, 0.9836, 0.9986, 0.9999,  &
0.0145, 0.0515, 0.1507, 0.3481, 0.6173, 0.8383, 0.9575, 0.9945, 0.9997,  &
0.0054, 0.0205, 0.0677, 0.1977, 0.3826, 0.5997, 0.7892, 0.9380, 0.9938 /
data ((cldnuctab( 3,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.1732, 0.3312, 0.5638, 0.7892, 0.9434, 0.9945, 0.9998, 0.9999, 0.9999,  &
0.1207, 0.2527, 0.4542, 0.6852, 0.8882, 0.9795, 0.9986, 0.9999, 0.9999,  &
0.0806, 0.1852, 0.3652, 0.5997, 0.8148, 0.9485, 0.9938, 0.9997, 0.9999,  &
0.0515, 0.1302, 0.2829, 0.4908, 0.7324, 0.9047, 0.9816, 0.9988, 0.9999,  &
0.0283, 0.0806, 0.1977, 0.4002, 0.6347, 0.8493, 0.9614, 0.9958, 0.9998,  &
0.0115, 0.0385, 0.1117, 0.2829, 0.5274, 0.7617, 0.9260, 0.9870, 0.9991,  &
0.0041, 0.0145, 0.0515, 0.1507, 0.3481, 0.6173, 0.8268, 0.9485, 0.9929 /
data ((cldnuctab( 3,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.1302, 0.2829, 0.4908, 0.7324, 0.9193, 0.9884, 0.9995, 0.9999, 0.9999,  &
0.0952, 0.1977, 0.3826, 0.6173, 0.8383, 0.9614, 0.9968, 0.9999, 0.9999,  &
0.0619, 0.1402, 0.2986, 0.5091, 0.7473, 0.9122, 0.9870, 0.9992, 0.9999,  &
0.0385, 0.1032, 0.2242, 0.4181, 0.6519, 0.8493, 0.9651, 0.9963, 0.9998,  &
0.0205, 0.0619, 0.1507, 0.3148, 0.5457, 0.7757, 0.9260, 0.9884, 0.9993,  &
0.0090, 0.0283, 0.0877, 0.2242, 0.4361, 0.6852, 0.8792, 0.9716, 0.9972,  &
0.0036, 0.0115, 0.0385, 0.1207, 0.2986, 0.5457, 0.7892, 0.9380, 0.9884 /
data ((cldnuctab( 3,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.1117, 0.2382, 0.4361, 0.6852, 0.8882, 0.9816, 0.9990, 0.9999, 0.9999,  &
0.0739, 0.1616, 0.3312, 0.5457, 0.7892, 0.9434, 0.9938, 0.9997, 0.9999,  &
0.0515, 0.1207, 0.2382, 0.4361, 0.6852, 0.8792, 0.9771, 0.9984, 0.9999,  &
0.0314, 0.0806, 0.1732, 0.3481, 0.5638, 0.7892, 0.9380, 0.9920, 0.9996,  &
0.0183, 0.0468, 0.1207, 0.2676, 0.4725, 0.7013, 0.8882, 0.9771, 0.9982,  &
0.0079, 0.0228, 0.0677, 0.1732, 0.3652, 0.5997, 0.8148, 0.9485, 0.9929,  &
0.0027, 0.0090, 0.0314, 0.0877, 0.2382, 0.4725, 0.7170, 0.9047, 0.9795 /
data ((cldnuctab( 3,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.0952, 0.2107, 0.4002, 0.6347, 0.8598, 0.9745, 0.9984, 0.9999, 0.9999,  &
0.0619, 0.1402, 0.2986, 0.5091, 0.7473, 0.9260, 0.9898, 0.9996, 0.9999,  &
0.0425, 0.0952, 0.2107, 0.4002, 0.6173, 0.8383, 0.9651, 0.9968, 0.9999,  &
0.0254, 0.0677, 0.1507, 0.2986, 0.5091, 0.7473, 0.9122, 0.9870, 0.9992,  &
0.0145, 0.0425, 0.1032, 0.2242, 0.4002, 0.6347, 0.8493, 0.9614, 0.9963,  &
0.0061, 0.0205, 0.0565, 0.1402, 0.3148, 0.5274, 0.7617, 0.9193, 0.9870,  &
0.0024, 0.0079, 0.0254, 0.0739, 0.1977, 0.4002, 0.6519, 0.8598, 0.9651 /
data ((cldnuctab( 3,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.0877, 0.1977, 0.3652, 0.6173, 0.8383, 0.9685, 0.9979, 0.9999, 0.9999,  &
0.0565, 0.1302, 0.2676, 0.4725, 0.7170, 0.9047, 0.9870, 0.9993, 0.9999,  &
0.0348, 0.0877, 0.1852, 0.3481, 0.5818, 0.8148, 0.9531, 0.9952, 0.9998,  &
0.0228, 0.0565, 0.1302, 0.2676, 0.4725, 0.7013, 0.8882, 0.9795, 0.9988,  &
0.0129, 0.0348, 0.0877, 0.1852, 0.3652, 0.5818, 0.8022, 0.9485, 0.9938,  &
0.0061, 0.0183, 0.0468, 0.1207, 0.2676, 0.4725, 0.7170, 0.8967, 0.9795,  &
0.0024, 0.0070, 0.0205, 0.0619, 0.1616, 0.3481, 0.5997, 0.8268, 0.9485 /
data ((cldnuctab( 3,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.3826, 0.6173, 0.8268, 0.9531, 0.9938, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2986, 0.5274, 0.7473, 0.9122, 0.9836, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.2107, 0.4181, 0.6519, 0.8598, 0.9614, 0.9952, 0.9997, 0.9999, 0.9999,  &
0.1207, 0.2986, 0.5457, 0.7892, 0.9322, 0.9884, 0.9991, 0.9999, 0.9999,  &
0.0565, 0.1732, 0.4002, 0.6852, 0.8792, 0.9716, 0.9968, 0.9998, 0.9999,  &
0.0205, 0.0739, 0.2107, 0.4542, 0.7013, 0.8967, 0.9816, 0.9982, 0.9999,  &
0.0079, 0.0283, 0.0952, 0.1977, 0.2382, 0.2527, 0.3148, 0.3652, 0.9193 /
data ((cldnuctab( 3,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.2986, 0.5091, 0.7473, 0.9122, 0.9854, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2242, 0.4181, 0.6519, 0.8493, 0.9614, 0.9958, 0.9998, 0.9999, 0.9999,  &
0.1616, 0.3312, 0.5638, 0.7757, 0.9260, 0.9870, 0.9991, 0.9999, 0.9999,  &
0.0952, 0.2382, 0.4542, 0.7013, 0.8792, 0.9716, 0.9968, 0.9998, 0.9999,  &
0.0425, 0.1302, 0.3148, 0.5818, 0.8148, 0.9434, 0.9909, 0.9993, 0.9999,  &
0.0163, 0.0565, 0.1732, 0.4002, 0.6852, 0.8882, 0.9745, 0.9972, 0.9998,  &
0.0061, 0.0228, 0.0739, 0.2107, 0.4181, 0.5997, 0.8148, 0.9575, 0.9958 /
data ((cldnuctab( 3,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.2382, 0.4361, 0.6687, 0.8697, 0.9716, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.1732, 0.3481, 0.5638, 0.7892, 0.9322, 0.9898, 0.9993, 0.9999, 0.9999,  &
0.1207, 0.2676, 0.4725, 0.7013, 0.8792, 0.9716, 0.9972, 0.9998, 0.9999,  &
0.0739, 0.1852, 0.3652, 0.5997, 0.8148, 0.9434, 0.9909, 0.9994, 0.9999,  &
0.0314, 0.0952, 0.2527, 0.4908, 0.7324, 0.9047, 0.9795, 0.9979, 0.9999,  &
0.0129, 0.0425, 0.1302, 0.3312, 0.6173, 0.8383, 0.9575, 0.9938, 0.9996,  &
0.0047, 0.0163, 0.0565, 0.1732, 0.4002, 0.6519, 0.8598, 0.9685, 0.9963 /
data ((cldnuctab( 3,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.1977, 0.3652, 0.5997, 0.8148, 0.9531, 0.9945, 0.9997, 0.9999, 0.9999,  &
0.1402, 0.2829, 0.4908, 0.7170, 0.8967, 0.9795, 0.9984, 0.9999, 0.9999,  &
0.0952, 0.2107, 0.3826, 0.6173, 0.8268, 0.9531, 0.9938, 0.9996, 0.9999,  &
0.0565, 0.1402, 0.2986, 0.5091, 0.7473, 0.9047, 0.9816, 0.9984, 0.9999,  &
0.0254, 0.0806, 0.1977, 0.4002, 0.6519, 0.8493, 0.9614, 0.9945, 0.9997,  &
0.0102, 0.0348, 0.1032, 0.2676, 0.5274, 0.7757, 0.9260, 0.9854, 0.9986,  &
0.0036, 0.0129, 0.0425, 0.1302, 0.3312, 0.6173, 0.8383, 0.9575, 0.9938 /
data ((cldnuctab( 3,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.1616, 0.3148, 0.5457, 0.7757, 0.9322, 0.9909, 0.9996, 0.9999, 0.9999,  &
0.1117, 0.2382, 0.4361, 0.6687, 0.8598, 0.9685, 0.9972, 0.9999, 0.9999,  &
0.0806, 0.1732, 0.3312, 0.5457, 0.7757, 0.9260, 0.9884, 0.9992, 0.9999,  &
0.0468, 0.1117, 0.2527, 0.4542, 0.6687, 0.8697, 0.9685, 0.9963, 0.9998,  &
0.0228, 0.0619, 0.1616, 0.3481, 0.5638, 0.7892, 0.9322, 0.9884, 0.9991,  &
0.0090, 0.0283, 0.0806, 0.2107, 0.4361, 0.7013, 0.8882, 0.9716, 0.9968,  &
0.0031, 0.0102, 0.0348, 0.1032, 0.2676, 0.5457, 0.7892, 0.9380, 0.9884 /
data ((cldnuctab( 3,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.1402, 0.2829, 0.5091, 0.7473, 0.9193, 0.9884, 0.9993, 0.9999, 0.9999,  &
0.0952, 0.2107, 0.3826, 0.6173, 0.8268, 0.9575, 0.9958, 0.9998, 0.9999,  &
0.0677, 0.1507, 0.2829, 0.4908, 0.7324, 0.9047, 0.9816, 0.9986, 0.9999,  &
0.0385, 0.0952, 0.2107, 0.4002, 0.6173, 0.8268, 0.9531, 0.9938, 0.9997,  &
0.0183, 0.0515, 0.1402, 0.2986, 0.5091, 0.7324, 0.9047, 0.9816, 0.9982,  &
0.0079, 0.0228, 0.0677, 0.1852, 0.3826, 0.6347, 0.8383, 0.9575, 0.9938,  &
0.0036, 0.0090, 0.0283, 0.0877, 0.2242, 0.4725, 0.7324, 0.9122, 0.9816 /
data ((cldnuctab( 3,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.1302, 0.2676, 0.4725, 0.7170, 0.9047, 0.9854, 0.9991, 0.9999, 0.9999,  &
0.0877, 0.1852, 0.3481, 0.5818, 0.8022, 0.9485, 0.9938, 0.9997, 0.9999,  &
0.0565, 0.1302, 0.2676, 0.4542, 0.6852, 0.8792, 0.9771, 0.9982, 0.9999,  &
0.0348, 0.0877, 0.1852, 0.3481, 0.5818, 0.7892, 0.9380, 0.9909, 0.9994,  &
0.0163, 0.0468, 0.1207, 0.2527, 0.4542, 0.6852, 0.8792, 0.9716, 0.9972,  &
0.0070, 0.0205, 0.0619, 0.1616, 0.3312, 0.5818, 0.8022, 0.9380, 0.9898,  &
0.0036, 0.0079, 0.0254, 0.0739, 0.1977, 0.4181, 0.6852, 0.8792, 0.9716 /
data ((cldnuctab( 3,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.4908, 0.7170, 0.8967, 0.9771, 0.9976, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.4002, 0.6347, 0.8383, 0.9531, 0.9920, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2676, 0.5274, 0.7617, 0.9122, 0.9816, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.1402, 0.3652, 0.6519, 0.8598, 0.9614, 0.9945, 0.9996, 0.9999, 0.9999,  &
0.0619, 0.1852, 0.4542, 0.7473, 0.9260, 0.9870, 0.9986, 0.9999, 0.9999,  &
0.0228, 0.0806, 0.2242, 0.4908, 0.7473, 0.9260, 0.9884, 0.9991, 0.9999,  &
0.0115, 0.0348, 0.0952, 0.1852, 0.2242, 0.2382, 0.3148, 0.4002, 0.8792 /
data ((cldnuctab( 3,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.4002, 0.6347, 0.8383, 0.9531, 0.9938, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.3148, 0.5274, 0.7617, 0.9122, 0.9816, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.2107, 0.4181, 0.6687, 0.8598, 0.9614, 0.9945, 0.9996, 0.9999, 0.9999,  &
0.1117, 0.2829, 0.5457, 0.7892, 0.9322, 0.9870, 0.9986, 0.9999, 0.9999,  &
0.0468, 0.1507, 0.3652, 0.6687, 0.8792, 0.9716, 0.9963, 0.9997, 0.9999,  &
0.0183, 0.0619, 0.1852, 0.4542, 0.7473, 0.9260, 0.9870, 0.9988, 0.9999,  &
0.0090, 0.0254, 0.0806, 0.2107, 0.4002, 0.5997, 0.8383, 0.9575, 0.9979 /
data ((cldnuctab( 3,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.3312, 0.5457, 0.7757, 0.9260, 0.9870, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2527, 0.4542, 0.6687, 0.8697, 0.9651, 0.9958, 0.9997, 0.9999, 0.9999,  &
0.1732, 0.3481, 0.5818, 0.7892, 0.9322, 0.9870, 0.9988, 0.9999, 0.9999,  &
0.0877, 0.2242, 0.4542, 0.7013, 0.8882, 0.9716, 0.9963, 0.9997, 0.9999,  &
0.0348, 0.1117, 0.2986, 0.5818, 0.8148, 0.9434, 0.9909, 0.9991, 0.9999,  &
0.0129, 0.0468, 0.1507, 0.3826, 0.6852, 0.8967, 0.9771, 0.9972, 0.9998,  &
0.0090, 0.0183, 0.0619, 0.1852, 0.4181, 0.6852, 0.8967, 0.9836, 0.9984 /
data ((cldnuctab( 3,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.2676, 0.4725, 0.7013, 0.8882, 0.9771, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.1977, 0.3826, 0.5997, 0.8148, 0.9434, 0.9920, 0.9994, 0.9999, 0.9999,  &
0.1302, 0.2829, 0.4908, 0.7170, 0.8967, 0.9771, 0.9976, 0.9998, 0.9999,  &
0.0739, 0.1852, 0.3826, 0.6173, 0.8268, 0.9485, 0.9920, 0.9993, 0.9999,  &
0.0283, 0.0877, 0.2382, 0.4908, 0.7473, 0.9122, 0.9795, 0.9979, 0.9998,  &
0.0115, 0.0348, 0.1117, 0.2986, 0.5997, 0.8383, 0.9575, 0.9938, 0.9995,  &
0.0090, 0.0145, 0.0468, 0.1402, 0.3652, 0.6687, 0.8882, 0.9771, 0.9976 /
data ((cldnuctab( 3,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.2382, 0.4181, 0.6519, 0.8598, 0.9685, 0.9963, 0.9998, 0.9999, 0.9999,  &
0.1616, 0.3312, 0.5457, 0.7617, 0.9193, 0.9870, 0.9990, 0.9999, 0.9999,  &
0.1117, 0.2382, 0.4361, 0.6687, 0.8598, 0.9614, 0.9952, 0.9997, 0.9999,  &
0.0619, 0.1507, 0.3312, 0.5457, 0.7757, 0.9260, 0.9854, 0.9986, 0.9999,  &
0.0254, 0.0739, 0.1977, 0.4181, 0.6687, 0.8697, 0.9651, 0.9952, 0.9997,  &
0.0102, 0.0283, 0.0877, 0.2527, 0.5274, 0.7892, 0.9322, 0.9870, 0.9988,  &
0.0102, 0.0115, 0.0348, 0.1117, 0.2986, 0.5997, 0.8493, 0.9651, 0.9952 /
data ((cldnuctab( 3,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.2107, 0.3826, 0.6173, 0.8268, 0.9575, 0.9952, 0.9997, 0.9999, 0.9999,  &
0.1402, 0.2829, 0.4908, 0.7170, 0.8967, 0.9816, 0.9984, 0.9999, 0.9999,  &
0.0952, 0.2107, 0.3826, 0.6173, 0.8148, 0.9485, 0.9929, 0.9995, 0.9999,  &
0.0515, 0.1302, 0.2829, 0.4908, 0.7170, 0.8967, 0.9771, 0.9976, 0.9998,  &
0.0228, 0.0619, 0.1732, 0.3652, 0.6173, 0.8268, 0.9485, 0.9920, 0.9993,  &
0.0102, 0.0254, 0.0739, 0.2107, 0.4542, 0.7170, 0.9047, 0.9795, 0.9976,  &
0.0102, 0.0115, 0.0314, 0.0952, 0.2527, 0.5274, 0.8022, 0.9485, 0.9920 /
data ((cldnuctab( 3,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.1852, 0.3652, 0.5818, 0.8148, 0.9485, 0.9938, 0.9996, 0.9999, 0.9999,  &
0.1302, 0.2676, 0.4542, 0.6852, 0.8792, 0.9745, 0.9979, 0.9999, 0.9999,  &
0.0877, 0.1852, 0.3481, 0.5638, 0.7892, 0.9322, 0.9898, 0.9992, 0.9999,  &
0.0468, 0.1207, 0.2527, 0.4542, 0.6852, 0.8697, 0.9685, 0.9963, 0.9998,  &
0.0205, 0.0565, 0.1507, 0.3312, 0.5638, 0.7892, 0.9322, 0.9870, 0.9990,  &
0.0115, 0.0228, 0.0677, 0.1852, 0.4002, 0.6687, 0.8697, 0.9685, 0.9958,  &
0.0115, 0.0129, 0.0254, 0.0806, 0.2107, 0.4725, 0.7617, 0.9322, 0.9870 /
data ((cldnuctab( 3,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.5638, 0.7757, 0.9260, 0.9854, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4542, 0.6852, 0.8792, 0.9685, 0.9958, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2986, 0.5818, 0.8022, 0.9380, 0.9884, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.1507, 0.4002, 0.7013, 0.8967, 0.9745, 0.9968, 0.9997, 0.9999, 0.9999,  &
0.0619, 0.1977, 0.4725, 0.7892, 0.9434, 0.9909, 0.9992, 0.9999, 0.9999,  &
0.0254, 0.0877, 0.2382, 0.4908, 0.7617, 0.9380, 0.9920, 0.9995, 0.9999,  &
0.0183, 0.0385, 0.0952, 0.1852, 0.2107, 0.2242, 0.2527, 0.3312, 0.8792 /
data ((cldnuctab( 3,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.4725, 0.7013, 0.8792, 0.9716, 0.9963, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3652, 0.5997, 0.8148, 0.9380, 0.9898, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2382, 0.4725, 0.7170, 0.8967, 0.9745, 0.9968, 0.9998, 0.9999, 0.9999,  &
0.1207, 0.3148, 0.5997, 0.8268, 0.9531, 0.9920, 0.9992, 0.9999, 0.9999,  &
0.0468, 0.1507, 0.4002, 0.7170, 0.9122, 0.9816, 0.9979, 0.9998, 0.9999,  &
0.0183, 0.0619, 0.1977, 0.4725, 0.7757, 0.9485, 0.9920, 0.9993, 0.9999,  &
0.0163, 0.0283, 0.0806, 0.2107, 0.4002, 0.5818, 0.8022, 0.9651, 0.9986 /
data ((cldnuctab( 3,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.3826, 0.6173, 0.8268, 0.9485, 0.9920, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2986, 0.5091, 0.7324, 0.9047, 0.9795, 0.9976, 0.9998, 0.9999, 0.9999,  &
0.1977, 0.4002, 0.6347, 0.8383, 0.9531, 0.9929, 0.9994, 0.9999, 0.9999,  &
0.0952, 0.2527, 0.5091, 0.7617, 0.9193, 0.9816, 0.9979, 0.9998, 0.9999,  &
0.0385, 0.1207, 0.3148, 0.6173, 0.8598, 0.9614, 0.9945, 0.9995, 0.9999,  &
0.0163, 0.0468, 0.1507, 0.4002, 0.7170, 0.9193, 0.9854, 0.9984, 0.9999,  &
0.0163, 0.0205, 0.0619, 0.1852, 0.4181, 0.7013, 0.9122, 0.9854, 0.9988 /
data ((cldnuctab( 3,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.3312, 0.5457, 0.7617, 0.9260, 0.9870, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.2382, 0.4361, 0.6687, 0.8598, 0.9651, 0.9952, 0.9997, 0.9999, 0.9999,  &
0.1616, 0.3312, 0.5638, 0.7757, 0.9260, 0.9854, 0.9986, 0.9999, 0.9999,  &
0.0806, 0.2107, 0.4361, 0.6852, 0.8697, 0.9685, 0.9952, 0.9996, 0.9999,  &
0.0314, 0.0952, 0.2676, 0.5457, 0.7892, 0.9380, 0.9884, 0.9988, 0.9999,  &
0.0163, 0.0385, 0.1207, 0.3312, 0.6347, 0.8792, 0.9716, 0.9963, 0.9997,  &
0.0163, 0.0205, 0.0515, 0.1507, 0.3826, 0.6852, 0.9047, 0.9854, 0.9984 /
data ((cldnuctab( 3,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.2829, 0.4908, 0.7170, 0.8967, 0.9795, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.1977, 0.3826, 0.5997, 0.8148, 0.9485, 0.9920, 0.9994, 0.9999, 0.9999,  &
0.1302, 0.2829, 0.4908, 0.7170, 0.8967, 0.9771, 0.9972, 0.9998, 0.9999,  &
0.0677, 0.1732, 0.3652, 0.6173, 0.8268, 0.9485, 0.9909, 0.9992, 0.9999,  &
0.0254, 0.0806, 0.2107, 0.4725, 0.7324, 0.9047, 0.9771, 0.9972, 0.9998,  &
0.0183, 0.0314, 0.0952, 0.2676, 0.5638, 0.8268, 0.9531, 0.9920, 0.9993,  &
0.0183, 0.0205, 0.0385, 0.1207, 0.3148, 0.6347, 0.8792, 0.9745, 0.9972 /
data ((cldnuctab( 3,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.2527, 0.4542, 0.6852, 0.8792, 0.9745, 0.9972, 0.9998, 0.9999, 0.9999,  &
0.1732, 0.3481, 0.5638, 0.7757, 0.9322, 0.9884, 0.9991, 0.9999, 0.9999,  &
0.1117, 0.2527, 0.4361, 0.6687, 0.8598, 0.9651, 0.9958, 0.9997, 0.9999,  &
0.0565, 0.1507, 0.3312, 0.5638, 0.7757, 0.9260, 0.9854, 0.9986, 0.9999,  &
0.0228, 0.0677, 0.1852, 0.4002, 0.6687, 0.8697, 0.9651, 0.9952, 0.9996,  &
0.0183, 0.0254, 0.0806, 0.2242, 0.4908, 0.7757, 0.9322, 0.9870, 0.9986,  &
0.0183, 0.0205, 0.0314, 0.0952, 0.2676, 0.5638, 0.8383, 0.9651, 0.9952 /
data ((cldnuctab( 3,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.2242, 0.4181, 0.6519, 0.8598, 0.9685, 0.9968, 0.9998, 0.9999, 0.9999,  &
0.1616, 0.3148, 0.5274, 0.7473, 0.9193, 0.9854, 0.9988, 0.9999, 0.9999,  &
0.1032, 0.2242, 0.4002, 0.6347, 0.8383, 0.9575, 0.9945, 0.9996, 0.9999,  &
0.0515, 0.1402, 0.2986, 0.5091, 0.7473, 0.9047, 0.9816, 0.9982, 0.9999,  &
0.0205, 0.0619, 0.1616, 0.3652, 0.6173, 0.8383, 0.9531, 0.9929, 0.9994,  &
0.0205, 0.0228, 0.0677, 0.1977, 0.4361, 0.7170, 0.9047, 0.9795, 0.9976,  &
0.0205, 0.0228, 0.0283, 0.0806, 0.2242, 0.5091, 0.8022, 0.9485, 0.9920 /
data ((cldnuctab( 3,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.5997, 0.8148, 0.9434, 0.9898, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4908, 0.7324, 0.8967, 0.9771, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3312, 0.6173, 0.8383, 0.9531, 0.9920, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.1616, 0.4181, 0.7324, 0.9122, 0.9816, 0.9979, 0.9998, 0.9999, 0.9999,  &
0.0619, 0.1977, 0.4908, 0.8022, 0.9575, 0.9938, 0.9995, 0.9999, 0.9999,  &
0.0314, 0.0877, 0.2382, 0.4908, 0.7617, 0.9434, 0.9938, 0.9996, 0.9999,  &
0.0254, 0.0468, 0.1032, 0.1852, 0.2107, 0.2242, 0.2527, 0.3481, 0.8148 /
data ((cldnuctab( 3,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.5091, 0.7324, 0.9047, 0.9795, 0.9976, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.4002, 0.6347, 0.8383, 0.9531, 0.9929, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2527, 0.5091, 0.7617, 0.9193, 0.9816, 0.9979, 0.9998, 0.9999, 0.9999,  &
0.1207, 0.3312, 0.6347, 0.8598, 0.9651, 0.9945, 0.9995, 0.9999, 0.9999,  &
0.0515, 0.1616, 0.4181, 0.7473, 0.9260, 0.9870, 0.9986, 0.9999, 0.9999,  &
0.0254, 0.0677, 0.1977, 0.4725, 0.7892, 0.9575, 0.9945, 0.9995, 0.9999,  &
0.0254, 0.0348, 0.0877, 0.2107, 0.3826, 0.5818, 0.7892, 0.9685, 0.9986 /
data ((cldnuctab( 3,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.4361, 0.6687, 0.8598, 0.9614, 0.9945, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.3312, 0.5638, 0.7757, 0.9260, 0.9854, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.2107, 0.4361, 0.6852, 0.8697, 0.9651, 0.9952, 0.9996, 0.9999, 0.9999,  &
0.1032, 0.2676, 0.5457, 0.7892, 0.9322, 0.9870, 0.9986, 0.9999, 0.9999,  &
0.0385, 0.1207, 0.3312, 0.6519, 0.8792, 0.9716, 0.9963, 0.9997, 0.9999,  &
0.0254, 0.0515, 0.1507, 0.4002, 0.7473, 0.9322, 0.9898, 0.9990, 0.9999,  &
0.0228, 0.0283, 0.0677, 0.1852, 0.4181, 0.7013, 0.9193, 0.9884, 0.9992 /
data ((cldnuctab( 3,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.3652, 0.5818, 0.8022, 0.9434, 0.9909, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.2676, 0.4725, 0.7170, 0.8882, 0.9745, 0.9968, 0.9998, 0.9999, 0.9999,  &
0.1732, 0.3652, 0.5997, 0.8148, 0.9434, 0.9898, 0.9991, 0.9999, 0.9999,  &
0.0806, 0.2242, 0.4725, 0.7170, 0.8967, 0.9771, 0.9968, 0.9997, 0.9999,  &
0.0314, 0.1032, 0.2676, 0.5638, 0.8268, 0.9485, 0.9920, 0.9992, 0.9999,  &
0.0254, 0.0385, 0.1207, 0.3312, 0.6687, 0.8967, 0.9795, 0.9976, 0.9998,  &
0.0254, 0.0283, 0.0515, 0.1507, 0.3826, 0.6852, 0.9122, 0.9884, 0.9988 /
data ((cldnuctab( 3,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.3148, 0.5274, 0.7617, 0.9193, 0.9854, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.2382, 0.4181, 0.6519, 0.8493, 0.9614, 0.9945, 0.9996, 0.9999, 0.9999,  &
0.1507, 0.3148, 0.5457, 0.7617, 0.9193, 0.9836, 0.9984, 0.9999, 0.9999,  &
0.0677, 0.1852, 0.4002, 0.6519, 0.8598, 0.9614, 0.9945, 0.9995, 0.9999,  &
0.0283, 0.0806, 0.2242, 0.4908, 0.7617, 0.9260, 0.9836, 0.9984, 0.9999,  &
0.0254, 0.0314, 0.0952, 0.2676, 0.5818, 0.8493, 0.9651, 0.9945, 0.9996,  &
0.0254, 0.0283, 0.0425, 0.1207, 0.3148, 0.6347, 0.8882, 0.9816, 0.9982 /
data ((cldnuctab( 3,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.2829, 0.4908, 0.7170, 0.9047, 0.9816, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.2107, 0.3826, 0.5997, 0.8148, 0.9485, 0.9920, 0.9994, 0.9999, 0.9999,  &
0.1302, 0.2829, 0.4908, 0.7170, 0.8882, 0.9771, 0.9972, 0.9998, 0.9999,  &
0.0619, 0.1616, 0.3481, 0.5997, 0.8148, 0.9434, 0.9909, 0.9992, 0.9999,  &
0.0283, 0.0739, 0.1977, 0.4361, 0.7013, 0.8882, 0.9745, 0.9968, 0.9997,  &
0.0283, 0.0314, 0.0806, 0.2382, 0.5091, 0.8022, 0.9434, 0.9909, 0.9991,  &
0.0283, 0.0314, 0.0348, 0.1032, 0.2676, 0.5818, 0.8598, 0.9716, 0.9968 /
data ((cldnuctab( 3,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.2676, 0.4542, 0.6852, 0.8882, 0.9771, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.1852, 0.3481, 0.5638, 0.7892, 0.9380, 0.9898, 0.9992, 0.9999, 0.9999,  &
0.1207, 0.2527, 0.4542, 0.6852, 0.8697, 0.9685, 0.9963, 0.9997, 0.9999,  &
0.0565, 0.1507, 0.3148, 0.5638, 0.7757, 0.9260, 0.9870, 0.9988, 0.9999,  &
0.0283, 0.0619, 0.1732, 0.4002, 0.6519, 0.8598, 0.9651, 0.9952, 0.9996,  &
0.0283, 0.0314, 0.0739, 0.1977, 0.4542, 0.7473, 0.9260, 0.9854, 0.9984,  &
0.0283, 0.0314, 0.0385, 0.0877, 0.2382, 0.5274, 0.8268, 0.9614, 0.9945 /
data ((cldnuctab( 3,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.6347, 0.8383, 0.9531, 0.9929, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5274, 0.7617, 0.9193, 0.9816, 0.9979, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3312, 0.6347, 0.8598, 0.9651, 0.9945, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1616, 0.4181, 0.7473, 0.9260, 0.9870, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.0677, 0.2107, 0.5091, 0.8268, 0.9651, 0.9952, 0.9996, 0.9999, 0.9999,  &
0.0348, 0.0952, 0.2382, 0.4908, 0.7617, 0.9485, 0.9952, 0.9997, 0.9999,  &
0.0314, 0.0515, 0.1032, 0.1732, 0.2107, 0.2242, 0.2676, 0.3652, 0.8148 /
data ((cldnuctab( 3,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.5457, 0.7757, 0.9193, 0.9836, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4361, 0.6687, 0.8697, 0.9651, 0.9945, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2676, 0.5457, 0.7892, 0.9322, 0.9870, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.1302, 0.3481, 0.6519, 0.8792, 0.9716, 0.9958, 0.9997, 0.9999, 0.9999,  &
0.0515, 0.1616, 0.4181, 0.7617, 0.9380, 0.9898, 0.9990, 0.9999, 0.9999,  &
0.0348, 0.0677, 0.1977, 0.4908, 0.8022, 0.9614, 0.9958, 0.9996, 0.9999,  &
0.0314, 0.0425, 0.0952, 0.2107, 0.3826, 0.5638, 0.7892, 0.9685, 0.9988 /
data ((cldnuctab( 3,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.4725, 0.7013, 0.8792, 0.9716, 0.9963, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3481, 0.5818, 0.8022, 0.9380, 0.9884, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2242, 0.4542, 0.7170, 0.8882, 0.9745, 0.9963, 0.9997, 0.9999, 0.9999,  &
0.1032, 0.2829, 0.5638, 0.8148, 0.9485, 0.9909, 0.9991, 0.9999, 0.9999,  &
0.0385, 0.1302, 0.3481, 0.6687, 0.8967, 0.9795, 0.9972, 0.9998, 0.9999,  &
0.0314, 0.0515, 0.1616, 0.4181, 0.7617, 0.9434, 0.9920, 0.9992, 0.9999,  &
0.0314, 0.0385, 0.0739, 0.1977, 0.4181, 0.7013, 0.9260, 0.9909, 0.9994 /
data ((cldnuctab( 3,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.4002, 0.6347, 0.8383, 0.9531, 0.9929, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2986, 0.5091, 0.7473, 0.9047, 0.9795, 0.9979, 0.9998, 0.9999, 0.9999,  &
0.1852, 0.3826, 0.6347, 0.8383, 0.9531, 0.9929, 0.9994, 0.9999, 0.9999,  &
0.0877, 0.2242, 0.4908, 0.7473, 0.9122, 0.9816, 0.9979, 0.9998, 0.9999,  &
0.0314, 0.1032, 0.2829, 0.5818, 0.8493, 0.9614, 0.9938, 0.9994, 0.9999,  &
0.0314, 0.0425, 0.1207, 0.3481, 0.6852, 0.9122, 0.9836, 0.9982, 0.9998,  &
0.0314, 0.0385, 0.0565, 0.1616, 0.3826, 0.7013, 0.9193, 0.9909, 0.9992 /
data ((cldnuctab( 3,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.3481, 0.5638, 0.7892, 0.9380, 0.9898, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.2527, 0.4542, 0.6852, 0.8697, 0.9685, 0.9963, 0.9997, 0.9999, 0.9999,  &
0.1616, 0.3312, 0.5638, 0.7892, 0.9322, 0.9870, 0.9988, 0.9999, 0.9999,  &
0.0739, 0.1977, 0.4181, 0.6852, 0.8792, 0.9685, 0.9958, 0.9997, 0.9999,  &
0.0348, 0.0877, 0.2382, 0.5091, 0.7892, 0.9380, 0.9884, 0.9988, 0.9999,  &
0.0348, 0.0385, 0.1032, 0.2829, 0.5997, 0.8697, 0.9716, 0.9963, 0.9997,  &
0.0348, 0.0385, 0.0468, 0.1302, 0.3148, 0.6519, 0.8967, 0.9854, 0.9986 /
data ((cldnuctab( 3,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.3148, 0.5274, 0.7473, 0.9193, 0.9854, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.2242, 0.4181, 0.6347, 0.8383, 0.9575, 0.9945, 0.9996, 0.9999, 0.9999,  &
0.1402, 0.2986, 0.5274, 0.7473, 0.9122, 0.9816, 0.9982, 0.9999, 0.9999,  &
0.0619, 0.1732, 0.3826, 0.6347, 0.8383, 0.9531, 0.9929, 0.9994, 0.9999,  &
0.0348, 0.0739, 0.1977, 0.4542, 0.7324, 0.9122, 0.9816, 0.9979, 0.9998,  &
0.0348, 0.0385, 0.0877, 0.2382, 0.5274, 0.8148, 0.9531, 0.9929, 0.9994,  &
0.0348, 0.0385, 0.0468, 0.1032, 0.2676, 0.5818, 0.8697, 0.9771, 0.9976 /
data ((cldnuctab( 3,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.2986, 0.4908, 0.7324, 0.9047, 0.9816, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.2107, 0.3826, 0.5997, 0.8148, 0.9485, 0.9929, 0.9995, 0.9999, 0.9999,  &
0.1302, 0.2676, 0.4908, 0.7170, 0.8882, 0.9745, 0.9972, 0.9998, 0.9999,  &
0.0565, 0.1507, 0.3481, 0.5818, 0.8022, 0.9434, 0.9898, 0.9991, 0.9999,  &
0.0385, 0.0677, 0.1852, 0.4181, 0.6852, 0.8792, 0.9716, 0.9963, 0.9997,  &
0.0385, 0.0425, 0.0739, 0.2107, 0.4725, 0.7757, 0.9380, 0.9884, 0.9990,  &
0.0385, 0.0425, 0.0468, 0.0952, 0.2382, 0.5274, 0.8383, 0.9685, 0.9963 /
data ((cldnuctab( 4,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.5136, 0.7509, 0.9140, 0.9858, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4046, 0.6560, 0.8519, 0.9660, 0.9965, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2867, 0.5319, 0.7791, 0.9337, 0.9901, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.1427, 0.3694, 0.6728, 0.8815, 0.9751, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.0578, 0.1882, 0.4587, 0.7652, 0.9447, 0.9922, 0.9996, 0.9999, 0.9999,  &
0.0235, 0.0823, 0.2276, 0.4953, 0.7509, 0.9394, 0.9932, 0.9997, 0.9999,  &
0.0118, 0.0357, 0.0971, 0.1882, 0.2276, 0.2276, 0.2417, 0.4046, 0.8987 /
data ((cldnuctab( 4,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.4046, 0.6560, 0.8519, 0.9660, 0.9969, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3188, 0.5501, 0.7791, 0.9276, 0.9901, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.4405, 0.6892, 0.8815, 0.9724, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.1139, 0.2867, 0.5683, 0.8053, 0.9447, 0.9922, 0.9996, 0.9999, 0.9999,  &
0.0479, 0.1427, 0.3869, 0.6892, 0.8987, 0.9800, 0.9985, 0.9999, 0.9999,  &
0.0168, 0.0633, 0.1882, 0.4587, 0.7652, 0.9447, 0.9932, 0.9996, 0.9999,  &
0.0093, 0.0261, 0.0823, 0.2140, 0.4046, 0.6040, 0.8519, 0.9693, 0.9991 /
data ((cldnuctab( 4,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.3353, 0.5683, 0.7925, 0.9394, 0.9922, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.4587, 0.6892, 0.8815, 0.9751, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.3522, 0.5862, 0.8053, 0.9447, 0.9932, 0.9996, 0.9999, 0.9999,  &
0.0895, 0.2276, 0.4770, 0.7208, 0.8987, 0.9800, 0.9985, 0.9999, 0.9999,  &
0.0357, 0.1139, 0.3025, 0.5862, 0.8296, 0.9585, 0.9947, 0.9997, 0.9999,  &
0.0133, 0.0479, 0.1427, 0.3869, 0.7052, 0.9140, 0.9858, 0.9989, 0.9999,  &
0.0093, 0.0188, 0.0578, 0.1761, 0.4225, 0.7052, 0.9140, 0.9901, 0.9994 /
data ((cldnuctab( 4,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.2713, 0.4953, 0.7208, 0.9066, 0.9858, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.2008, 0.3869, 0.6216, 0.8296, 0.9585, 0.9954, 0.9998, 0.9999, 0.9999,  &
0.1326, 0.2867, 0.5136, 0.7361, 0.9140, 0.9841, 0.9990, 0.9999, 0.9999,  &
0.0692, 0.1882, 0.3869, 0.6390, 0.8519, 0.9624, 0.9959, 0.9998, 0.9999,  &
0.0290, 0.0895, 0.2417, 0.4953, 0.7652, 0.9276, 0.9874, 0.9991, 0.9999,  &
0.0105, 0.0357, 0.1139, 0.3025, 0.6216, 0.8623, 0.9693, 0.9969, 0.9998,  &
0.0093, 0.0133, 0.0479, 0.1427, 0.3694, 0.6728, 0.9066, 0.9858, 0.9989 /
data ((cldnuctab( 4,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.2417, 0.4225, 0.6728, 0.8721, 0.9751, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.1644, 0.3353, 0.5501, 0.7791, 0.9337, 0.9912, 0.9996, 0.9999, 0.9999,  &
0.1139, 0.2417, 0.4405, 0.6728, 0.8721, 0.9724, 0.9977, 0.9999, 0.9999,  &
0.0633, 0.1533, 0.3353, 0.5683, 0.7925, 0.9394, 0.9912, 0.9994, 0.9999,  &
0.0261, 0.0755, 0.2008, 0.4225, 0.6892, 0.8815, 0.9751, 0.9977, 0.9999,  &
0.0105, 0.0290, 0.0895, 0.2563, 0.5319, 0.7925, 0.9447, 0.9922, 0.9995,  &
0.0105, 0.0118, 0.0357, 0.1139, 0.3025, 0.6040, 0.8721, 0.9751, 0.9977 /
data ((cldnuctab( 4,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.2140, 0.3869, 0.6216, 0.8410, 0.9660, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.1427, 0.2867, 0.4953, 0.7361, 0.9140, 0.9874, 0.9994, 0.9999, 0.9999,  &
0.0971, 0.2140, 0.3869, 0.6216, 0.8296, 0.9585, 0.9959, 0.9998, 0.9999,  &
0.0527, 0.1326, 0.2867, 0.5136, 0.7361, 0.9066, 0.9841, 0.9990, 0.9999,  &
0.0210, 0.0633, 0.1761, 0.3694, 0.6216, 0.8410, 0.9585, 0.9954, 0.9998,  &
0.0105, 0.0261, 0.0755, 0.2140, 0.4587, 0.7361, 0.9140, 0.9858, 0.9989,  &
0.0105, 0.0118, 0.0290, 0.0895, 0.2563, 0.5501, 0.8177, 0.9585, 0.9954 /
data ((cldnuctab( 4,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.1882, 0.3694, 0.5862, 0.8177, 0.9585, 0.9965, 0.9999, 0.9999, 0.9999,  &
0.1326, 0.2713, 0.4587, 0.7052, 0.8987, 0.9821, 0.9990, 0.9999, 0.9999,  &
0.0895, 0.1882, 0.3522, 0.5862, 0.8053, 0.9447, 0.9940, 0.9997, 0.9999,  &
0.0479, 0.1230, 0.2563, 0.4587, 0.6892, 0.8815, 0.9777, 0.9982, 0.9999,  &
0.0188, 0.0578, 0.1533, 0.3353, 0.5683, 0.8053, 0.9447, 0.9922, 0.9996,  &
0.0118, 0.0235, 0.0692, 0.1882, 0.4046, 0.6892, 0.8815, 0.9751, 0.9980,  &
0.0118, 0.0133, 0.0261, 0.0823, 0.2140, 0.4953, 0.7791, 0.9394, 0.9922 /
data ((cldnuctab( 4,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.6216, 0.8296, 0.9496, 0.9932, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4953, 0.7361, 0.9066, 0.9821, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3188, 0.6216, 0.8519, 0.9624, 0.9947, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1533, 0.4046, 0.7361, 0.9210, 0.9858, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.0633, 0.2008, 0.4953, 0.8177, 0.9624, 0.9959, 0.9998, 0.9999, 0.9999,  &
0.0290, 0.0895, 0.2417, 0.4953, 0.7652, 0.9496, 0.9959, 0.9998, 0.9999,  &
0.0261, 0.0435, 0.0971, 0.1882, 0.2140, 0.2276, 0.2563, 0.3522, 0.8296 /
data ((cldnuctab( 4,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.5136, 0.7509, 0.9140, 0.9841, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4046, 0.6560, 0.8519, 0.9624, 0.9947, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.5136, 0.7652, 0.9276, 0.9858, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.1230, 0.3353, 0.6390, 0.8721, 0.9693, 0.9965, 0.9998, 0.9999, 0.9999,  &
0.0479, 0.1533, 0.4225, 0.7509, 0.9337, 0.9901, 0.9993, 0.9999, 0.9999,  &
0.0261, 0.0692, 0.2008, 0.4770, 0.8053, 0.9585, 0.9959, 0.9998, 0.9999,  &
0.0235, 0.0357, 0.0895, 0.2140, 0.3869, 0.5683, 0.7925, 0.9724, 0.9993 /
data ((cldnuctab( 4,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.4405, 0.6728, 0.8623, 0.9660, 0.9965, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3353, 0.5683, 0.7791, 0.9337, 0.9888, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.4405, 0.6892, 0.8815, 0.9724, 0.9969, 0.9998, 0.9999, 0.9999,  &
0.0971, 0.2713, 0.5501, 0.8053, 0.9394, 0.9901, 0.9993, 0.9999, 0.9999,  &
0.0394, 0.1230, 0.3353, 0.6560, 0.8903, 0.9777, 0.9977, 0.9998, 0.9999,  &
0.0235, 0.0527, 0.1533, 0.4046, 0.7509, 0.9394, 0.9922, 0.9994, 0.9999,  &
0.0235, 0.0290, 0.0692, 0.1882, 0.4225, 0.7052, 0.9276, 0.9912, 0.9996 /
data ((cldnuctab( 4,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.3694, 0.6040, 0.8177, 0.9496, 0.9932, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.4770, 0.7208, 0.8903, 0.9777, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.3694, 0.6040, 0.8177, 0.9496, 0.9922, 0.9995, 0.9999, 0.9999,  &
0.0823, 0.2276, 0.4770, 0.7208, 0.9066, 0.9800, 0.9980, 0.9999, 0.9999,  &
0.0322, 0.0971, 0.2713, 0.5683, 0.8296, 0.9542, 0.9940, 0.9996, 0.9999,  &
0.0261, 0.0394, 0.1230, 0.3353, 0.6728, 0.9066, 0.9841, 0.9985, 0.9999,  &
0.0261, 0.0290, 0.0527, 0.1533, 0.3869, 0.6892, 0.9210, 0.9912, 0.9994 /
data ((cldnuctab( 4,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.3188, 0.5319, 0.7652, 0.9276, 0.9888, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.4225, 0.6560, 0.8519, 0.9660, 0.9965, 0.9998, 0.9999, 0.9999,  &
0.1533, 0.3188, 0.5501, 0.7652, 0.9210, 0.9858, 0.9990, 0.9999, 0.9999,  &
0.0692, 0.1882, 0.4046, 0.6560, 0.8623, 0.9660, 0.9959, 0.9998, 0.9999,  &
0.0261, 0.0823, 0.2276, 0.4953, 0.7652, 0.9276, 0.9874, 0.9990, 0.9999,  &
0.0261, 0.0322, 0.0971, 0.2713, 0.5862, 0.8519, 0.9693, 0.9965, 0.9998,  &
0.0261, 0.0290, 0.0435, 0.1230, 0.3188, 0.6390, 0.8987, 0.9841, 0.9989 /
data ((cldnuctab( 4,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.2867, 0.4953, 0.7208, 0.9066, 0.9841, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2008, 0.3869, 0.6040, 0.8177, 0.9542, 0.9940, 0.9997, 0.9999, 0.9999,  &
0.1326, 0.2713, 0.4953, 0.7208, 0.8987, 0.9800, 0.9982, 0.9999, 0.9999,  &
0.0633, 0.1644, 0.3522, 0.6040, 0.8177, 0.9496, 0.9922, 0.9995, 0.9999,  &
0.0290, 0.0692, 0.2008, 0.4405, 0.7052, 0.8987, 0.9777, 0.9980, 0.9999,  &
0.0290, 0.0322, 0.0823, 0.2276, 0.5136, 0.8053, 0.9496, 0.9932, 0.9995,  &
0.0261, 0.0290, 0.0357, 0.0971, 0.2713, 0.5862, 0.8623, 0.9751, 0.9977 /
data ((cldnuctab( 4,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.2713, 0.4587, 0.7052, 0.8903, 0.9800, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.1882, 0.3522, 0.5683, 0.7925, 0.9394, 0.9922, 0.9996, 0.9999, 0.9999,  &
0.1139, 0.2563, 0.4587, 0.6892, 0.8721, 0.9724, 0.9973, 0.9998, 0.9999,  &
0.0578, 0.1427, 0.3188, 0.5501, 0.7791, 0.9337, 0.9888, 0.9993, 0.9999,  &
0.0290, 0.0633, 0.1761, 0.3869, 0.6560, 0.8721, 0.9693, 0.9965, 0.9998,  &
0.0290, 0.0322, 0.0755, 0.2008, 0.4587, 0.7652, 0.9276, 0.9874, 0.9990,  &
0.0290, 0.0322, 0.0394, 0.0895, 0.2276, 0.5136, 0.8296, 0.9624, 0.9959 /
data ((cldnuctab( 4,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.7208, 0.8903, 0.9751, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5862, 0.8177, 0.9496, 0.9912, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3694, 0.6892, 0.8987, 0.9800, 0.9977, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1644, 0.4405, 0.7925, 0.9542, 0.9940, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.0755, 0.2140, 0.5136, 0.8519, 0.9777, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.0578, 0.1053, 0.2417, 0.4770, 0.7509, 0.9542, 0.9973, 0.9999, 0.9999,  &
0.0527, 0.0692, 0.1139, 0.1761, 0.2008, 0.2008, 0.2713, 0.3869, 0.8177 /
data ((cldnuctab( 4,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.6216, 0.8296, 0.9542, 0.9922, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4953, 0.7361, 0.9066, 0.9800, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3025, 0.6040, 0.8410, 0.9585, 0.9940, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1326, 0.3694, 0.7052, 0.9140, 0.9841, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.0578, 0.1644, 0.4405, 0.7925, 0.9624, 0.9954, 0.9996, 0.9999, 0.9999,  &
0.0578, 0.0823, 0.2140, 0.4953, 0.8177, 0.9724, 0.9982, 0.9999, 0.9999,  &
0.0527, 0.0633, 0.1053, 0.2140, 0.3694, 0.5319, 0.7652, 0.9447, 0.9995 /
data ((cldnuctab( 4,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.5501, 0.7652, 0.9210, 0.9858, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4225, 0.6560, 0.8623, 0.9624, 0.9954, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.5136, 0.7791, 0.9276, 0.9858, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.1053, 0.3025, 0.6216, 0.8623, 0.9693, 0.9959, 0.9997, 0.9999, 0.9999,  &
0.0578, 0.1326, 0.3694, 0.7208, 0.9276, 0.9888, 0.9990, 0.9999, 0.9999,  &
0.0578, 0.0692, 0.1644, 0.4225, 0.7791, 0.9624, 0.9965, 0.9998, 0.9999,  &
0.0527, 0.0633, 0.0895, 0.2008, 0.4225, 0.6892, 0.9276, 0.9947, 0.9998 /
data ((cldnuctab( 4,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.4770, 0.7052, 0.8815, 0.9751, 0.9973, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3522, 0.5862, 0.8053, 0.9394, 0.9901, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.2008, 0.4405, 0.7052, 0.8903, 0.9751, 0.9969, 0.9998, 0.9999, 0.9999,  &
0.0895, 0.2417, 0.5319, 0.8053, 0.9447, 0.9912, 0.9993, 0.9999, 0.9999,  &
0.0578, 0.1053, 0.3025, 0.6390, 0.8903, 0.9777, 0.9973, 0.9998, 0.9999,  &
0.0578, 0.0692, 0.1326, 0.3522, 0.7052, 0.9394, 0.9922, 0.9994, 0.9999,  &
0.0578, 0.0633, 0.0823, 0.1644, 0.3869, 0.7052, 0.9337, 0.9940, 0.9997 /
data ((cldnuctab( 4,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.4225, 0.6560, 0.8519, 0.9624, 0.9954, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3025, 0.5319, 0.7509, 0.9140, 0.9841, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.3869, 0.6390, 0.8519, 0.9585, 0.9947, 0.9996, 0.9999, 0.9999,  &
0.0755, 0.2140, 0.4770, 0.7509, 0.9140, 0.9841, 0.9985, 0.9999, 0.9999,  &
0.0578, 0.0895, 0.2417, 0.5501, 0.8410, 0.9624, 0.9947, 0.9996, 0.9999,  &
0.0578, 0.0692, 0.1053, 0.2867, 0.6216, 0.8987, 0.9841, 0.9985, 0.9999,  &
0.0578, 0.0633, 0.0755, 0.1427, 0.3353, 0.6560, 0.9210, 0.9912, 0.9994 /
data ((cldnuctab( 4,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.3869, 0.6040, 0.8177, 0.9496, 0.9932, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.4770, 0.7052, 0.8903, 0.9777, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.1533, 0.3522, 0.5862, 0.8053, 0.9447, 0.9912, 0.9994, 0.9999, 0.9999,  &
0.0692, 0.1882, 0.4225, 0.6892, 0.8903, 0.9751, 0.9969, 0.9998, 0.9999,  &
0.0633, 0.0755, 0.2140, 0.4953, 0.7791, 0.9394, 0.9901, 0.9991, 0.9999,  &
0.0633, 0.0692, 0.0895, 0.2417, 0.5501, 0.8623, 0.9724, 0.9969, 0.9998,  &
0.0633, 0.0692, 0.0755, 0.1230, 0.2867, 0.6040, 0.8903, 0.9874, 0.9990 /
data ((cldnuctab( 4,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.3522, 0.5683, 0.7925, 0.9394, 0.9912, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.4587, 0.6728, 0.8721, 0.9693, 0.9969, 0.9998, 0.9999, 0.9999,  &
0.1427, 0.3188, 0.5501, 0.7791, 0.9276, 0.9874, 0.9990, 0.9999, 0.9999,  &
0.0692, 0.1644, 0.3869, 0.6560, 0.8623, 0.9660, 0.9954, 0.9997, 0.9999,  &
0.0692, 0.0755, 0.1882, 0.4405, 0.7361, 0.9210, 0.9858, 0.9987, 0.9999,  &
0.0692, 0.0692, 0.0823, 0.2140, 0.4953, 0.8177, 0.9585, 0.9947, 0.9996,  &
0.0633, 0.0692, 0.0823, 0.1053, 0.2563, 0.5501, 0.8623, 0.9800, 0.9982 /
data ((cldnuctab( 4,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.8053, 0.9394, 0.9888, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6560, 0.8815, 0.9751, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3869, 0.7509, 0.9394, 0.9912, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.4587, 0.8296, 0.9751, 0.9973, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1230, 0.2276, 0.5136, 0.8623, 0.9874, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.1139, 0.1427, 0.2563, 0.4587, 0.7052, 0.9337, 0.9973, 0.9999, 0.9999,  &
0.0971, 0.1139, 0.1533, 0.2008, 0.2140, 0.2140, 0.2867, 0.3694, 0.7509 /
data ((cldnuctab( 4,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.7208, 0.8987, 0.9777, 0.9973, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5683, 0.8177, 0.9496, 0.9922, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3188, 0.6728, 0.8987, 0.9800, 0.9977, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1427, 0.3869, 0.7509, 0.9496, 0.9932, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.1139, 0.1882, 0.4587, 0.8296, 0.9777, 0.9980, 0.9998, 0.9999, 0.9999,  &
0.1139, 0.1326, 0.2417, 0.4770, 0.8177, 0.9800, 0.9990, 0.9999, 0.9999,  &
0.1053, 0.1139, 0.1427, 0.2276, 0.3522, 0.4953, 0.7052, 0.9276, 0.9996 /
data ((cldnuctab( 4,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.6390, 0.8519, 0.9585, 0.9940, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4953, 0.7509, 0.9210, 0.9841, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.5862, 0.8410, 0.9624, 0.9947, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1139, 0.3188, 0.6728, 0.9140, 0.9858, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.1139, 0.1427, 0.3694, 0.7509, 0.9585, 0.9954, 0.9996, 0.9999, 0.9999,  &
0.1139, 0.1326, 0.2008, 0.4405, 0.7925, 0.9751, 0.9982, 0.9999, 0.9999,  &
0.1053, 0.1139, 0.1427, 0.2276, 0.4046, 0.6560, 0.9210, 0.9959, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.5862, 0.7925, 0.9394, 0.9888, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4225, 0.6892, 0.8815, 0.9724, 0.9965, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.5136, 0.7925, 0.9394, 0.9888, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.1230, 0.2713, 0.5862, 0.8721, 0.9724, 0.9965, 0.9997, 0.9999, 0.9999,  &
0.1230, 0.1326, 0.3188, 0.6728, 0.9276, 0.9888, 0.9990, 0.9999, 0.9999,  &
0.1139, 0.1326, 0.1644, 0.3694, 0.7361, 0.9585, 0.9965, 0.9998, 0.9999,  &
0.1139, 0.1230, 0.1427, 0.2008, 0.3869, 0.6728, 0.9337, 0.9965, 0.9998 /
data ((cldnuctab( 4,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.5136, 0.7509, 0.9140, 0.9841, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3869, 0.6216, 0.8410, 0.9585, 0.9940, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2008, 0.4587, 0.7361, 0.9066, 0.9821, 0.9980, 0.9998, 0.9999, 0.9999,  &
0.1230, 0.2276, 0.5136, 0.8177, 0.9542, 0.9932, 0.9994, 0.9999, 0.9999,  &
0.1230, 0.1326, 0.2563, 0.5862, 0.8815, 0.9800, 0.9980, 0.9998, 0.9999,  &
0.1230, 0.1326, 0.1533, 0.3025, 0.6560, 0.9337, 0.9922, 0.9994, 0.9999,  &
0.1139, 0.1230, 0.1427, 0.1882, 0.3522, 0.6390, 0.9276, 0.9954, 0.9998 /
data ((cldnuctab( 4,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.4770, 0.7052, 0.8903, 0.9777, 0.9977, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3353, 0.5862, 0.8053, 0.9394, 0.9901, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.4046, 0.6892, 0.8815, 0.9724, 0.9969, 0.9998, 0.9999, 0.9999,  &
0.1230, 0.2008, 0.4770, 0.7652, 0.9337, 0.9888, 0.9990, 0.9999, 0.9999,  &
0.1230, 0.1427, 0.2276, 0.5319, 0.8410, 0.9693, 0.9959, 0.9997, 0.9999,  &
0.1230, 0.1326, 0.1533, 0.2713, 0.5862, 0.8987, 0.9858, 0.9989, 0.9999,  &
0.1230, 0.1326, 0.1427, 0.1761, 0.3025, 0.5862, 0.9066, 0.9922, 0.9996 /
data ((cldnuctab( 4,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.4587, 0.6728, 0.8721, 0.9724, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3188, 0.5501, 0.7791, 0.9276, 0.9874, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.1644, 0.3694, 0.6390, 0.8519, 0.9624, 0.9954, 0.9997, 0.9999, 0.9999,  &
0.1326, 0.1761, 0.4225, 0.7361, 0.9140, 0.9841, 0.9985, 0.9999, 0.9999,  &
0.1326, 0.1427, 0.2008, 0.4770, 0.8053, 0.9542, 0.9940, 0.9995, 0.9999,  &
0.1326, 0.1427, 0.1533, 0.2417, 0.5319, 0.8623, 0.9777, 0.9980, 0.9998,  &
0.1326, 0.1326, 0.1427, 0.1761, 0.2867, 0.5501, 0.8721, 0.9888, 0.9993 /
data ((cldnuctab( 4,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.8410, 0.9585, 0.9940, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6892, 0.9140, 0.9841, 0.9982, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4046, 0.7791, 0.9585, 0.9947, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2008, 0.4770, 0.8519, 0.9821, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1644, 0.2563, 0.5136, 0.8721, 0.9901, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1533, 0.1761, 0.2713, 0.4405, 0.6728, 0.9140, 0.9969, 0.9999, 0.9999,  &
0.1326, 0.1533, 0.1882, 0.2417, 0.2140, 0.2140, 0.2713, 0.3869, 0.7509 /
data ((cldnuctab( 4,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.7791, 0.9276, 0.9858, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6040, 0.8623, 0.9660, 0.9954, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3353, 0.6892, 0.9210, 0.9874, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.3869, 0.7791, 0.9624, 0.9959, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1644, 0.2140, 0.4587, 0.8410, 0.9841, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.1533, 0.1761, 0.2563, 0.4770, 0.8053, 0.9800, 0.9993, 0.9999, 0.9999,  &
0.1427, 0.1533, 0.1882, 0.2563, 0.3353, 0.4587, 0.6728, 0.9066, 0.9991 /
data ((cldnuctab( 4,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.7052, 0.8903, 0.9751, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5319, 0.8053, 0.9447, 0.9901, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.6216, 0.8815, 0.9751, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1644, 0.3188, 0.6892, 0.9337, 0.9912, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.1644, 0.1882, 0.3869, 0.7652, 0.9660, 0.9969, 0.9998, 0.9999, 0.9999,  &
0.1644, 0.1761, 0.2276, 0.4405, 0.7925, 0.9800, 0.9990, 0.9999, 0.9999,  &
0.1533, 0.1644, 0.1882, 0.2563, 0.4046, 0.6216, 0.8987, 0.9954, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.6390, 0.8410, 0.9585, 0.9940, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4587, 0.7361, 0.9140, 0.9821, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.5319, 0.8296, 0.9585, 0.9940, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.2713, 0.6216, 0.8903, 0.9821, 0.9980, 0.9998, 0.9999, 0.9999,  &
0.1644, 0.1882, 0.3188, 0.6892, 0.9394, 0.9932, 0.9994, 0.9999, 0.9999,  &
0.1644, 0.1761, 0.2140, 0.3869, 0.7361, 0.9660, 0.9977, 0.9998, 0.9999,  &
0.1644, 0.1644, 0.1882, 0.2417, 0.3869, 0.6728, 0.9276, 0.9969, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.5862, 0.8053, 0.9394, 0.9901, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4225, 0.6892, 0.8815, 0.9724, 0.9965, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.4770, 0.7791, 0.9337, 0.9888, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.2276, 0.5501, 0.8519, 0.9693, 0.9959, 0.9997, 0.9999, 0.9999,  &
0.1761, 0.1882, 0.2713, 0.6040, 0.9066, 0.9874, 0.9989, 0.9999, 0.9999,  &
0.1761, 0.1882, 0.2140, 0.3353, 0.6560, 0.9394, 0.9954, 0.9997, 0.9999,  &
0.1644, 0.1761, 0.1882, 0.2276, 0.3694, 0.6390, 0.9210, 0.9965, 0.9998 /
data ((cldnuctab( 4,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.5501, 0.7652, 0.9210, 0.9858, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3869, 0.6390, 0.8519, 0.9624, 0.9947, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.1882, 0.4405, 0.7361, 0.9140, 0.9821, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.1761, 0.2008, 0.4953, 0.8053, 0.9542, 0.9932, 0.9994, 0.9999, 0.9999,  &
0.1761, 0.1882, 0.2417, 0.5501, 0.8623, 0.9777, 0.9980, 0.9998, 0.9999,  &
0.1761, 0.1882, 0.2140, 0.2867, 0.5862, 0.9066, 0.9912, 0.9994, 0.9999,  &
0.1761, 0.1761, 0.1882, 0.2276, 0.3353, 0.5862, 0.8987, 0.9947, 0.9997 /
data ((cldnuctab( 4,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.5136, 0.7361, 0.9066, 0.9821, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3522, 0.6040, 0.8177, 0.9496, 0.9932, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1882, 0.4046, 0.6892, 0.8903, 0.9777, 0.9973, 0.9998, 0.9999, 0.9999,  &
0.1882, 0.2008, 0.4405, 0.7652, 0.9394, 0.9901, 0.9991, 0.9999, 0.9999,  &
0.1882, 0.2008, 0.2276, 0.4953, 0.8296, 0.9693, 0.9965, 0.9998, 0.9999,  &
0.1882, 0.2008, 0.2140, 0.2713, 0.5319, 0.8721, 0.9858, 0.9989, 0.9999,  &
0.1761, 0.1882, 0.2008, 0.2276, 0.3188, 0.5501, 0.8721, 0.9912, 0.9996 /
data ((cldnuctab( 4,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.8721, 0.9693, 0.9959, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7052, 0.9276, 0.9888, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4046, 0.7925, 0.9660, 0.9965, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.4770, 0.8519, 0.9858, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2008, 0.2713, 0.5136, 0.8623, 0.9912, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.1882, 0.2140, 0.2867, 0.4405, 0.6560, 0.8987, 0.9965, 0.9999, 0.9999,  &
0.1644, 0.1761, 0.2140, 0.2867, 0.2417, 0.2417, 0.2713, 0.4046, 0.7052 /
data ((cldnuctab( 4,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.8053, 0.9447, 0.9901, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6216, 0.8815, 0.9751, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3353, 0.7052, 0.9394, 0.9912, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.4046, 0.7925, 0.9693, 0.9973, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2008, 0.2417, 0.4770, 0.8410, 0.9858, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.1882, 0.2140, 0.2867, 0.4770, 0.7925, 0.9800, 0.9994, 0.9999, 0.9999,  &
0.1761, 0.1882, 0.2140, 0.2867, 0.3522, 0.4405, 0.6560, 0.8903, 0.9989 /
data ((cldnuctab( 4,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.7361, 0.9066, 0.9821, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5501, 0.8296, 0.9542, 0.9932, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2867, 0.6390, 0.8987, 0.9821, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.3353, 0.7052, 0.9447, 0.9932, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.2417, 0.4046, 0.7791, 0.9724, 0.9980, 0.9998, 0.9999, 0.9999,  &
0.2008, 0.2140, 0.2713, 0.4405, 0.7925, 0.9821, 0.9993, 0.9999, 0.9999,  &
0.1882, 0.2008, 0.2140, 0.2713, 0.4046, 0.6040, 0.8815, 0.9947, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.6728, 0.8721, 0.9693, 0.9959, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4953, 0.7652, 0.9276, 0.9874, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.5501, 0.8519, 0.9660, 0.9959, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.2713, 0.6216, 0.9066, 0.9858, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.2276, 0.3353, 0.6892, 0.9496, 0.9954, 0.9996, 0.9999, 0.9999,  &
0.2008, 0.2140, 0.2563, 0.4046, 0.7361, 0.9693, 0.9985, 0.9999, 0.9999,  &
0.2008, 0.2140, 0.2276, 0.2713, 0.4046, 0.6390, 0.9140, 0.9973, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.6216, 0.8296, 0.9542, 0.9932, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4405, 0.7208, 0.8987, 0.9800, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.4953, 0.8053, 0.9496, 0.9922, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.2417, 0.5501, 0.8721, 0.9751, 0.9973, 0.9998, 0.9999, 0.9999,  &
0.2140, 0.2417, 0.2867, 0.6216, 0.9210, 0.9901, 0.9993, 0.9999, 0.9999,  &
0.2140, 0.2276, 0.2563, 0.3522, 0.6560, 0.9496, 0.9965, 0.9998, 0.9999,  &
0.2140, 0.2140, 0.2276, 0.2563, 0.3869, 0.6216, 0.9140, 0.9969, 0.9999 /
data ((cldnuctab( 4,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.5862, 0.8053, 0.9394, 0.9912, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4046, 0.6728, 0.8721, 0.9724, 0.9965, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.4587, 0.7652, 0.9276, 0.9874, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.2417, 0.4953, 0.8296, 0.9624, 0.9954, 0.9997, 0.9999, 0.9999,  &
0.2276, 0.2417, 0.2713, 0.5501, 0.8815, 0.9841, 0.9987, 0.9999, 0.9999,  &
0.2276, 0.2276, 0.2563, 0.3188, 0.6040, 0.9140, 0.9932, 0.9996, 0.9999,  &
0.2140, 0.2276, 0.2417, 0.2713, 0.3522, 0.5862, 0.8903, 0.9954, 0.9998 /
data ((cldnuctab( 4,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.5501, 0.7791, 0.9276, 0.9888, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3694, 0.6390, 0.8519, 0.9624, 0.9954, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.4225, 0.7208, 0.9140, 0.9841, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.2563, 0.4587, 0.7925, 0.9496, 0.9932, 0.9995, 0.9999, 0.9999,  &
0.2276, 0.2417, 0.2713, 0.4953, 0.8410, 0.9751, 0.9977, 0.9998, 0.9999,  &
0.2276, 0.2417, 0.2563, 0.3025, 0.5501, 0.8815, 0.9888, 0.9993, 0.9999,  &
0.2276, 0.2276, 0.2417, 0.2713, 0.3353, 0.5501, 0.8623, 0.9922, 0.9997 /
data ((cldnuctab( 4,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.8815, 0.9751, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7208, 0.9394, 0.9912, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4046, 0.8053, 0.9724, 0.9973, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.4770, 0.8623, 0.9888, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.3025, 0.5136, 0.8519, 0.9922, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2140, 0.2417, 0.3188, 0.4405, 0.6390, 0.8815, 0.9959, 0.9999, 0.9999,  &
0.1882, 0.2008, 0.2276, 0.3025, 0.2713, 0.2417, 0.2867, 0.3869, 0.7052 /
data ((cldnuctab( 4,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.8296, 0.9542, 0.9932, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6390, 0.8987, 0.9800, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3353, 0.7208, 0.9447, 0.9932, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.4046, 0.7925, 0.9751, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.2867, 0.4770, 0.8410, 0.9888, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.2417, 0.3025, 0.4770, 0.7652, 0.9777, 0.9995, 0.9999, 0.9999,  &
0.2140, 0.2276, 0.2417, 0.3025, 0.3694, 0.4405, 0.6216, 0.8721, 0.9985 /
data ((cldnuctab( 4,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.7652, 0.9276, 0.9858, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5683, 0.8519, 0.9660, 0.9954, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2867, 0.6390, 0.9140, 0.9858, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.3353, 0.7208, 0.9542, 0.9947, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2417, 0.2713, 0.4046, 0.7791, 0.9777, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.2276, 0.2563, 0.2867, 0.4587, 0.7791, 0.9821, 0.9994, 0.9999, 0.9999,  &
0.2276, 0.2276, 0.2563, 0.3025, 0.4225, 0.6040, 0.8623, 0.9940, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.7052, 0.8903, 0.9751, 0.9973, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4953, 0.7925, 0.9447, 0.9912, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.5683, 0.8623, 0.9724, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.2867, 0.6390, 0.9210, 0.9901, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.2713, 0.3522, 0.6892, 0.9542, 0.9965, 0.9998, 0.9999, 0.9999,  &
0.2417, 0.2563, 0.2867, 0.4046, 0.7208, 0.9724, 0.9989, 0.9999, 0.9999,  &
0.2276, 0.2417, 0.2563, 0.3025, 0.4225, 0.6216, 0.9066, 0.9973, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.6560, 0.8623, 0.9660, 0.9954, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4587, 0.7509, 0.9210, 0.9841, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.5136, 0.8177, 0.9585, 0.9940, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2563, 0.2867, 0.5683, 0.8815, 0.9821, 0.9982, 0.9998, 0.9999, 0.9999,  &
0.2563, 0.2713, 0.3025, 0.6216, 0.9276, 0.9922, 0.9994, 0.9999, 0.9999,  &
0.2563, 0.2563, 0.2867, 0.3694, 0.6560, 0.9496, 0.9973, 0.9998, 0.9999,  &
0.2417, 0.2563, 0.2713, 0.3025, 0.4046, 0.6216, 0.9140, 0.9969, 0.9999 /
data ((cldnuctab( 4,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.6040, 0.8296, 0.9542, 0.9932, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4225, 0.7052, 0.8903, 0.9777, 0.9977, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.4587, 0.7791, 0.9394, 0.9912, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.2867, 0.5136, 0.8410, 0.9693, 0.9969, 0.9998, 0.9999, 0.9999,  &
0.2713, 0.2867, 0.3188, 0.5501, 0.8903, 0.9874, 0.9990, 0.9999, 0.9999,  &
0.2563, 0.2713, 0.2867, 0.3522, 0.6040, 0.9210, 0.9947, 0.9997, 0.9999,  &
0.2563, 0.2563, 0.2713, 0.3025, 0.3694, 0.5862, 0.8815, 0.9959, 0.9998 /
data ((cldnuctab( 4,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.5862, 0.8053, 0.9394, 0.9912, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3869, 0.6728, 0.8721, 0.9724, 0.9969, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.4225, 0.7509, 0.9276, 0.9874, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.2713, 0.2867, 0.4587, 0.8053, 0.9585, 0.9954, 0.9996, 0.9999, 0.9999,  &
0.2713, 0.2867, 0.3188, 0.5136, 0.8519, 0.9800, 0.9982, 0.9999, 0.9999,  &
0.2713, 0.2713, 0.3025, 0.3522, 0.5501, 0.8903, 0.9912, 0.9994, 0.9999,  &
0.2563, 0.2713, 0.2867, 0.3025, 0.3694, 0.5501, 0.8519, 0.9932, 0.9998 /
data ((cldnuctab( 5,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.8084, 0.9459, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.8924, 0.9783, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3912, 0.7544, 0.9459, 0.9934, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1790, 0.4632, 0.8437, 0.9783, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1253, 0.2310, 0.5181, 0.8744, 0.9904, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1161, 0.1452, 0.2599, 0.4632, 0.7246, 0.9407, 0.9980, 0.9999, 0.9999,  &
0.0991, 0.1161, 0.1560, 0.2040, 0.2173, 0.2173, 0.2906, 0.3737, 0.7686 /
data ((cldnuctab( 5,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.7246, 0.9085, 0.9806, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.8325, 0.9553, 0.9942, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3228, 0.6768, 0.9085, 0.9845, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1452, 0.3912, 0.7686, 0.9553, 0.9949, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1253, 0.1912, 0.4632, 0.8325, 0.9806, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.1161, 0.1350, 0.2310, 0.4815, 0.8207, 0.9826, 0.9994, 0.9999, 0.9999,  &
0.1073, 0.1161, 0.1452, 0.2310, 0.3564, 0.4998, 0.7091, 0.9351, 0.9995 /
data ((cldnuctab( 5,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.6432, 0.8545, 0.9633, 0.9955, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.7544, 0.9227, 0.9862, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2750, 0.5906, 0.8545, 0.9668, 0.9961, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1253, 0.3228, 0.6768, 0.9227, 0.9877, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.1161, 0.1452, 0.3737, 0.7544, 0.9633, 0.9966, 0.9998, 0.9999, 0.9999,  &
0.1161, 0.1350, 0.1912, 0.4450, 0.7957, 0.9783, 0.9990, 0.9999, 0.9999,  &
0.1073, 0.1253, 0.1452, 0.2310, 0.4090, 0.6601, 0.9227, 0.9970, 0.9999 /
data ((cldnuctab( 5,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.5906, 0.8084, 0.9407, 0.9915, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4269, 0.6931, 0.8837, 0.9758, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2310, 0.5181, 0.7957, 0.9407, 0.9915, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.1253, 0.2599, 0.5906, 0.8744, 0.9758, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.1253, 0.1350, 0.3065, 0.6768, 0.9291, 0.9915, 0.9995, 0.9999, 0.9999,  &
0.1161, 0.1350, 0.1672, 0.3737, 0.7397, 0.9633, 0.9974, 0.9999, 0.9999,  &
0.1161, 0.1253, 0.1452, 0.2040, 0.3912, 0.6768, 0.9407, 0.9974, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.5181, 0.7544, 0.9158, 0.9862, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3737, 0.6432, 0.8437, 0.9595, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2040, 0.4450, 0.7397, 0.9158, 0.9845, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.1253, 0.2310, 0.5181, 0.8207, 0.9595, 0.9949, 0.9997, 0.9999, 0.9999,  &
0.1253, 0.1350, 0.2599, 0.5906, 0.8924, 0.9826, 0.9985, 0.9999, 0.9999,  &
0.1253, 0.1350, 0.1560, 0.3065, 0.6601, 0.9351, 0.9942, 0.9997, 0.9999,  &
0.1253, 0.1253, 0.1452, 0.1912, 0.3564, 0.6432, 0.9291, 0.9966, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.4815, 0.7091, 0.8924, 0.9806, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.5906, 0.8084, 0.9459, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1790, 0.4090, 0.6931, 0.8837, 0.9758, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.1350, 0.2040, 0.4632, 0.7686, 0.9407, 0.9904, 0.9994, 0.9999, 0.9999,  &
0.1350, 0.1452, 0.2310, 0.5364, 0.8437, 0.9701, 0.9970, 0.9998, 0.9999,  &
0.1253, 0.1350, 0.1560, 0.2750, 0.5906, 0.9007, 0.9891, 0.9993, 0.9999,  &
0.1253, 0.1350, 0.1452, 0.1790, 0.3065, 0.5906, 0.9085, 0.9942, 0.9997 /
data ((cldnuctab( 5,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.4632, 0.6931, 0.8744, 0.9758, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3228, 0.5546, 0.7824, 0.9291, 0.9891, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.1672, 0.3737, 0.6432, 0.8545, 0.9668, 0.9966, 0.9998, 0.9999, 0.9999,  &
0.1350, 0.1790, 0.4269, 0.7397, 0.9158, 0.9862, 0.9989, 0.9999, 0.9999,  &
0.1350, 0.1452, 0.2040, 0.4815, 0.8084, 0.9595, 0.9949, 0.9997, 0.9999,  &
0.1350, 0.1452, 0.1560, 0.2452, 0.5364, 0.8647, 0.9806, 0.9985, 0.9999,  &
0.1350, 0.1350, 0.1560, 0.1790, 0.2906, 0.5546, 0.8837, 0.9904, 0.9995 /
data ((cldnuctab( 5,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.8744, 0.9731, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.9291, 0.9891, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4090, 0.7957, 0.9701, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2310, 0.4815, 0.8545, 0.9877, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2040, 0.2750, 0.5181, 0.8647, 0.9925, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1912, 0.2173, 0.2906, 0.4269, 0.6601, 0.9007, 0.9974, 0.9999, 0.9999,  &
0.1672, 0.1790, 0.2173, 0.2906, 0.2452, 0.2452, 0.2750, 0.4090, 0.7091 /
data ((cldnuctab( 5,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.8084, 0.9459, 0.9915, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.8837, 0.9783, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.7091, 0.9407, 0.9925, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.4090, 0.7957, 0.9731, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2040, 0.2452, 0.4632, 0.8437, 0.9877, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.1912, 0.2173, 0.2906, 0.4815, 0.7957, 0.9826, 0.9996, 0.9999, 0.9999,  &
0.1790, 0.1912, 0.2173, 0.2906, 0.3564, 0.4450, 0.6601, 0.8924, 0.9992 /
data ((cldnuctab( 5,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.7397, 0.9158, 0.9826, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.8325, 0.9595, 0.9942, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2906, 0.6259, 0.9007, 0.9826, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.3395, 0.7091, 0.9459, 0.9942, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2040, 0.2452, 0.3912, 0.7824, 0.9758, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.2040, 0.2173, 0.2599, 0.4450, 0.7957, 0.9826, 0.9995, 0.9999, 0.9999,  &
0.1912, 0.2040, 0.2173, 0.2750, 0.4090, 0.6084, 0.8837, 0.9955, 0.9999 /
data ((cldnuctab( 5,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.6768, 0.8744, 0.9701, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4815, 0.7686, 0.9351, 0.9891, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2452, 0.5546, 0.8545, 0.9701, 0.9961, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.2750, 0.6259, 0.9158, 0.9877, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.2310, 0.3395, 0.6931, 0.9508, 0.9961, 0.9997, 0.9999, 0.9999,  &
0.2040, 0.2173, 0.2599, 0.3912, 0.7397, 0.9701, 0.9987, 0.9999, 0.9999,  &
0.2040, 0.2040, 0.2310, 0.2750, 0.4090, 0.6432, 0.9227, 0.9977, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.6259, 0.8325, 0.9553, 0.9942, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4450, 0.7246, 0.9007, 0.9806, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.4998, 0.8084, 0.9508, 0.9934, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.2452, 0.5546, 0.8744, 0.9783, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.2310, 0.2906, 0.6084, 0.9227, 0.9915, 0.9994, 0.9999, 0.9999,  &
0.2173, 0.2310, 0.2599, 0.3564, 0.6601, 0.9508, 0.9970, 0.9998, 0.9999,  &
0.2040, 0.2173, 0.2310, 0.2599, 0.3737, 0.6259, 0.9158, 0.9974, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.5906, 0.8084, 0.9407, 0.9915, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4090, 0.6768, 0.8744, 0.9731, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2310, 0.4450, 0.7544, 0.9291, 0.9891, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.2310, 0.2452, 0.4998, 0.8325, 0.9668, 0.9961, 0.9997, 0.9999, 0.9999,  &
0.2310, 0.2452, 0.2750, 0.5546, 0.8837, 0.9845, 0.9989, 0.9999, 0.9999,  &
0.2173, 0.2310, 0.2599, 0.3228, 0.5906, 0.9158, 0.9942, 0.9997, 0.9999,  &
0.2173, 0.2310, 0.2310, 0.2599, 0.3564, 0.5906, 0.8924, 0.9961, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.5546, 0.7824, 0.9291, 0.9891, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3737, 0.6432, 0.8545, 0.9633, 0.9961, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2452, 0.4269, 0.7246, 0.9158, 0.9845, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.2310, 0.2452, 0.4632, 0.7957, 0.9508, 0.9942, 0.9996, 0.9999, 0.9999,  &
0.2310, 0.2452, 0.2750, 0.4998, 0.8437, 0.9758, 0.9980, 0.9999, 0.9999,  &
0.2310, 0.2452, 0.2599, 0.3065, 0.5546, 0.8837, 0.9891, 0.9994, 0.9999,  &
0.2310, 0.2310, 0.2452, 0.2750, 0.3395, 0.5546, 0.8647, 0.9934, 0.9998 /
data ((cldnuctab( 5,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9158, 0.9862, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7397, 0.9595, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4269, 0.8084, 0.9806, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.4998, 0.8545, 0.9925, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3065, 0.3564, 0.5364, 0.8325, 0.9925, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2906, 0.3065, 0.3737, 0.4632, 0.5906, 0.8437, 0.9925, 0.9999, 0.9999,  &
0.2750, 0.2750, 0.3065, 0.3737, 0.4090, 0.2599, 0.3065, 0.4090, 0.6768 /
data ((cldnuctab( 5,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.8647, 0.9731, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.9227, 0.9891, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3564, 0.7397, 0.9633, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.4269, 0.7957, 0.9826, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3228, 0.3564, 0.4998, 0.8325, 0.9915, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3065, 0.3228, 0.3737, 0.4998, 0.7544, 0.9701, 0.9997, 0.9999, 0.9999,  &
0.2750, 0.2906, 0.3065, 0.3737, 0.4632, 0.4450, 0.5906, 0.7957, 0.9915 /
data ((cldnuctab( 5,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.8084, 0.9508, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.8837, 0.9783, 0.9977, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.6601, 0.9351, 0.9925, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.3737, 0.7246, 0.9668, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3228, 0.3564, 0.4450, 0.7824, 0.9826, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.3228, 0.3228, 0.3564, 0.4815, 0.7544, 0.9806, 0.9997, 0.9999, 0.9999,  &
0.3065, 0.3065, 0.3228, 0.3737, 0.4632, 0.5546, 0.8207, 0.9806, 0.9999 /
data ((cldnuctab( 5,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.7544, 0.9291, 0.9862, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5364, 0.8325, 0.9633, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3564, 0.5906, 0.8924, 0.9845, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.3737, 0.6432, 0.9351, 0.9942, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.3564, 0.4090, 0.6931, 0.9633, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.3228, 0.3395, 0.3737, 0.4632, 0.7246, 0.9731, 0.9993, 0.9999, 0.9999,  &
0.3228, 0.3228, 0.3395, 0.3737, 0.4632, 0.6259, 0.8647, 0.9966, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.7091, 0.9007, 0.9806, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4815, 0.7957, 0.9459, 0.9915, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3564, 0.5181, 0.8545, 0.9731, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3564, 0.3737, 0.5727, 0.9007, 0.9891, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.3564, 0.4090, 0.6259, 0.9351, 0.9955, 0.9998, 0.9999, 0.9999,  &
0.3395, 0.3564, 0.3737, 0.4269, 0.6601, 0.9508, 0.9985, 0.9999, 0.9999,  &
0.3228, 0.3395, 0.3564, 0.3737, 0.4450, 0.6259, 0.8837, 0.9970, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.6768, 0.8744, 0.9731, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4450, 0.7544, 0.9291, 0.9877, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3564, 0.4815, 0.8207, 0.9633, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3564, 0.3737, 0.5181, 0.8647, 0.9826, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.3564, 0.3737, 0.4090, 0.5727, 0.9007, 0.9925, 0.9995, 0.9999, 0.9999,  &
0.3564, 0.3564, 0.3737, 0.4269, 0.6259, 0.9227, 0.9966, 0.9999, 0.9999,  &
0.3395, 0.3395, 0.3564, 0.3737, 0.4269, 0.6084, 0.8647, 0.9961, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.6432, 0.8545, 0.9633, 0.9961, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4090, 0.7246, 0.9085, 0.9845, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3737, 0.4450, 0.7824, 0.9508, 0.9934, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.3737, 0.3912, 0.4815, 0.8325, 0.9731, 0.9977, 0.9998, 0.9999, 0.9999,  &
0.3737, 0.3737, 0.4090, 0.5181, 0.8744, 0.9877, 0.9992, 0.9999, 0.9999,  &
0.3564, 0.3737, 0.3912, 0.4269, 0.5727, 0.8924, 0.9942, 0.9997, 0.9999,  &
0.3564, 0.3564, 0.3737, 0.3912, 0.4269, 0.5727, 0.8325, 0.9934, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9459, 0.9942, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7544, 0.9731, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.8084, 0.9877, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4632, 0.5546, 0.8437, 0.9942, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4450, 0.4815, 0.5727, 0.7957, 0.9877, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4090, 0.4269, 0.4632, 0.5727, 0.5727, 0.7686, 0.9553, 0.9999, 0.9999,  &
0.3912, 0.3912, 0.4090, 0.4632, 0.5906, 0.3395, 0.3395, 0.4269, 0.6601 /
data ((cldnuctab( 5,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9085, 0.9862, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.9508, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.7397, 0.9758, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4815, 0.5364, 0.7957, 0.9877, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4632, 0.4815, 0.5546, 0.8084, 0.9915, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.4269, 0.4450, 0.4815, 0.5727, 0.6931, 0.9351, 0.9995, 0.9999, 0.9999,  &
0.4090, 0.4269, 0.4450, 0.4815, 0.5727, 0.4998, 0.5546, 0.7397, 0.9731 /
data ((cldnuctab( 5,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.8647, 0.9758, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.9158, 0.9904, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.6768, 0.9553, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4815, 0.5181, 0.7246, 0.9758, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4632, 0.4815, 0.5364, 0.7686, 0.9845, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.4450, 0.4632, 0.4815, 0.5546, 0.7397, 0.9668, 0.9998, 0.9999, 0.9999,  &
0.4269, 0.4450, 0.4632, 0.4815, 0.5546, 0.6084, 0.7397, 0.9459, 0.9999 /
data ((cldnuctab( 5,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.8207, 0.9595, 0.9949, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.8837, 0.9806, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.6084, 0.9227, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.5181, 0.6601, 0.9508, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.4815, 0.4998, 0.5364, 0.7091, 0.9701, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.4632, 0.4815, 0.4998, 0.5546, 0.7246, 0.9633, 0.9996, 0.9999, 0.9999,  &
0.4450, 0.4632, 0.4632, 0.4998, 0.5546, 0.6601, 0.8084, 0.9891, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.7824, 0.9407, 0.9915, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.8437, 0.9701, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.5364, 0.8837, 0.9862, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.5181, 0.5906, 0.9227, 0.9942, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.4815, 0.4998, 0.5364, 0.6601, 0.9459, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.4815, 0.4815, 0.4998, 0.5364, 0.6931, 0.9407, 0.9990, 0.9999, 0.9999,  &
0.4632, 0.4815, 0.4815, 0.4998, 0.5546, 0.6768, 0.8325, 0.9934, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.7397, 0.9227, 0.9877, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.8084, 0.9595, 0.9949, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.5364, 0.8545, 0.9783, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.5364, 0.5727, 0.8837, 0.9904, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.5181, 0.5364, 0.6259, 0.9085, 0.9961, 0.9998, 0.9999, 0.9999,  &
0.4998, 0.4998, 0.5181, 0.5546, 0.6601, 0.9158, 0.9980, 0.9999, 0.9999,  &
0.4815, 0.4815, 0.4998, 0.5181, 0.5546, 0.6601, 0.8325, 0.9915, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.7246, 0.9085, 0.9845, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5364, 0.7824, 0.9459, 0.9934, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.5546, 0.8207, 0.9731, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.5364, 0.5727, 0.8545, 0.9862, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.5181, 0.5546, 0.6084, 0.8744, 0.9934, 0.9997, 0.9999, 0.9999,  &
0.4998, 0.5181, 0.5181, 0.5546, 0.6432, 0.8837, 0.9961, 0.9999, 0.9999,  &
0.4998, 0.4998, 0.5181, 0.5181, 0.5546, 0.6432, 0.8084, 0.9891, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9595, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7544, 0.9783, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.8084, 0.9904, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.6084, 0.8325, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.5364, 0.6259, 0.7824, 0.9783, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.5181, 0.5364, 0.6259, 0.6259, 0.7246, 0.9291, 0.9998, 0.9999,  &
0.4450, 0.4632, 0.4815, 0.5181, 0.6259, 0.5546, 0.3737, 0.4632, 0.6601 /
data ((cldnuctab( 5,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9291, 0.9915, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.9595, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.7397, 0.9783, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.6084, 0.7957, 0.9891, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5364, 0.5546, 0.6084, 0.7957, 0.9891, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5181, 0.5181, 0.5364, 0.6084, 0.7246, 0.9158, 0.9990, 0.9999, 0.9999,  &
0.4998, 0.4998, 0.5181, 0.5546, 0.6259, 0.6601, 0.5546, 0.7246, 0.9407 /
data ((cldnuctab( 5,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.8924, 0.9845, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.9351, 0.9934, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6768, 0.9595, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.6084, 0.7397, 0.9758, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.5727, 0.6084, 0.7824, 0.9826, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.5364, 0.5364, 0.5546, 0.6084, 0.7544, 0.9553, 0.9997, 0.9999, 0.9999,  &
0.5181, 0.5181, 0.5364, 0.5546, 0.6084, 0.7091, 0.7246, 0.9158, 0.9995 /
data ((cldnuctab( 5,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.8545, 0.9731, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.9007, 0.9877, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6259, 0.9351, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.6084, 0.6768, 0.9553, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.5727, 0.6084, 0.7397, 0.9668, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.5546, 0.5727, 0.6084, 0.7397, 0.9508, 0.9996, 0.9999, 0.9999,  &
0.5364, 0.5364, 0.5546, 0.5727, 0.6084, 0.7246, 0.7824, 0.9758, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.8084, 0.9595, 0.9949, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.8647, 0.9806, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6259, 0.9007, 0.9915, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6084, 0.6601, 0.9227, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.5906, 0.6084, 0.6931, 0.9407, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.5727, 0.5906, 0.6084, 0.7091, 0.9291, 0.9992, 0.9999, 0.9999,  &
0.5546, 0.5546, 0.5727, 0.5906, 0.6084, 0.7091, 0.8207, 0.9891, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.7824, 0.9459, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.8325, 0.9701, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6259, 0.8647, 0.9862, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6084, 0.6601, 0.8924, 0.9934, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.5906, 0.6259, 0.6768, 0.9085, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.5906, 0.5906, 0.6259, 0.6931, 0.9007, 0.9983, 0.9999, 0.9999,  &
0.5727, 0.5727, 0.5727, 0.5906, 0.6259, 0.6931, 0.8325, 0.9877, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.7544, 0.9351, 0.9904, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.7957, 0.9633, 0.9961, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6259, 0.8325, 0.9806, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6259, 0.6601, 0.8647, 0.9891, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6084, 0.6259, 0.6768, 0.8837, 0.9949, 0.9998, 0.9999, 0.9999,  &
0.5906, 0.5906, 0.6084, 0.6259, 0.6931, 0.8744, 0.9966, 0.9999, 0.9999,  &
0.5906, 0.5906, 0.5906, 0.6084, 0.6259, 0.6931, 0.8207, 0.9826, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9633, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7544, 0.9826, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.8084, 0.9915, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6601, 0.8325, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.5906, 0.6601, 0.7824, 0.9668, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.5546, 0.5906, 0.6601, 0.7246, 0.7246, 0.9085, 0.9994, 0.9999,  &
0.4998, 0.4998, 0.5181, 0.5546, 0.6432, 0.8325, 0.3912, 0.4815, 0.6768 /
data ((cldnuctab( 5,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9407, 0.9942, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.9668, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.7544, 0.9806, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6601, 0.8084, 0.9891, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6084, 0.6601, 0.7957, 0.9845, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5727, 0.5906, 0.6084, 0.6432, 0.7686, 0.8837, 0.9980, 0.9999, 0.9999,  &
0.5546, 0.5546, 0.5727, 0.5906, 0.6601, 0.7686, 0.5727, 0.7091, 0.9227 /
data ((cldnuctab( 5,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9085, 0.9877, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.9407, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6931, 0.9633, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.6601, 0.7544, 0.9783, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6259, 0.6601, 0.7824, 0.9806, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.5906, 0.6084, 0.6601, 0.7686, 0.9351, 0.9997, 0.9999, 0.9999,  &
0.5727, 0.5906, 0.5906, 0.6084, 0.6601, 0.7686, 0.7091, 0.8924, 0.9985 /
data ((cldnuctab( 5,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.8647, 0.9783, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.9085, 0.9915, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6768, 0.9351, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6601, 0.7246, 0.9553, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.6432, 0.6601, 0.7544, 0.9633, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6259, 0.6259, 0.6601, 0.7544, 0.9407, 0.9996, 0.9999, 0.9999,  &
0.6084, 0.6084, 0.6084, 0.6259, 0.6601, 0.7544, 0.7824, 0.9595, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.8325, 0.9701, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.8744, 0.9845, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6768, 0.9085, 0.9934, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6601, 0.7091, 0.9291, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6432, 0.6601, 0.7397, 0.9407, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.6259, 0.6432, 0.6601, 0.7397, 0.9227, 0.9992, 0.9999, 0.9999,  &
0.6259, 0.6259, 0.6259, 0.6432, 0.6601, 0.7397, 0.8207, 0.9806, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.7957, 0.9595, 0.9949, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.8437, 0.9783, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6768, 0.8744, 0.9891, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6768, 0.7091, 0.8924, 0.9949, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6601, 0.6768, 0.7246, 0.9085, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6432, 0.6601, 0.6768, 0.7246, 0.9007, 0.9983, 0.9999, 0.9999,  &
0.6259, 0.6432, 0.6432, 0.6432, 0.6768, 0.7246, 0.8437, 0.9758, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.7686, 0.9459, 0.9934, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.8084, 0.9701, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.6931, 0.8437, 0.9845, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6768, 0.7091, 0.8647, 0.9915, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6601, 0.6768, 0.7246, 0.8837, 0.9955, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6601, 0.6601, 0.6768, 0.7246, 0.8744, 0.9966, 0.9999, 0.9999,  &
0.6432, 0.6432, 0.6601, 0.6601, 0.6768, 0.7246, 0.8545, 0.9758, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9668, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7686, 0.9826, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.8207, 0.9915, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6931, 0.8325, 0.9925, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.6259, 0.6768, 0.7957, 0.9633, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5906, 0.6084, 0.6259, 0.6931, 0.7824, 0.7091, 0.8924, 0.9985, 0.9999,  &
0.5181, 0.5364, 0.5364, 0.5727, 0.6432, 0.8207, 0.4090, 0.4815, 0.6601 /
data ((cldnuctab( 5,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9459, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.9668, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.7686, 0.9826, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6931, 0.8084, 0.9891, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.6432, 0.6931, 0.8084, 0.9826, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6259, 0.6259, 0.6432, 0.6931, 0.7957, 0.8647, 0.9961, 0.9999, 0.9999,  &
0.5906, 0.5906, 0.6084, 0.6259, 0.6931, 0.8437, 0.5727, 0.7091, 0.9158 /
data ((cldnuctab( 5,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9158, 0.9904, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.9459, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.7246, 0.9633, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.6931, 0.7686, 0.9758, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6601, 0.6931, 0.7957, 0.9783, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6432, 0.6432, 0.6601, 0.6931, 0.7957, 0.9291, 0.9995, 0.9999, 0.9999,  &
0.6259, 0.6259, 0.6259, 0.6601, 0.6931, 0.8084, 0.7091, 0.8744, 0.9966 /
data ((cldnuctab( 5,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.8744, 0.9826, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.9158, 0.9925, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.7246, 0.9407, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.6931, 0.7544, 0.9553, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6768, 0.6931, 0.7686, 0.9633, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6601, 0.6768, 0.6931, 0.7824, 0.9291, 0.9995, 0.9999, 0.9999,  &
0.6432, 0.6432, 0.6601, 0.6601, 0.6931, 0.7824, 0.7957, 0.9553, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.8437, 0.9758, 0.9977, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.8837, 0.9877, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.7246, 0.9085, 0.9949, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.7091, 0.7397, 0.9291, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.6931, 0.7091, 0.7544, 0.9351, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.6601, 0.6768, 0.6931, 0.7091, 0.7686, 0.9158, 0.9992, 0.9999, 0.9999,  &
0.6601, 0.6601, 0.6768, 0.6768, 0.7091, 0.7686, 0.8437, 0.9668, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.8084, 0.9668, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.8545, 0.9826, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.7246, 0.8744, 0.9915, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.7091, 0.7397, 0.8924, 0.9955, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.6931, 0.7091, 0.7544, 0.9085, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.6768, 0.6931, 0.6931, 0.7091, 0.7544, 0.9007, 0.9980, 0.9999, 0.9999,  &
0.6768, 0.6768, 0.6768, 0.6931, 0.7091, 0.7544, 0.8647, 0.9701, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.7824, 0.9553, 0.9949, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7246, 0.8207, 0.9758, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.7397, 0.8437, 0.9862, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.7246, 0.7544, 0.8647, 0.9925, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.7091, 0.7091, 0.7246, 0.7544, 0.8837, 0.9961, 0.9999, 0.9999, 0.9999,  &
0.6931, 0.6931, 0.7091, 0.7246, 0.7544, 0.8837, 0.9966, 0.9999, 0.9999,  &
0.6931, 0.6931, 0.6931, 0.7091, 0.7246, 0.7544, 0.8647, 0.9633, 0.9999 /
data ((cldnuctab( 6,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9579, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7631, 0.9797, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.8160, 0.9910, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5475, 0.6190, 0.8394, 0.9953, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5109, 0.5475, 0.6190, 0.7770, 0.9818, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4926, 0.5109, 0.5475, 0.6190, 0.6190, 0.7338, 0.9328, 0.9999, 0.9999,  &
0.4560, 0.4560, 0.4743, 0.5292, 0.6190, 0.5292, 0.3843, 0.4743, 0.6868 /
data ((cldnuctab( 6,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9266, 0.9921, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6868, 0.9618, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.7487, 0.9797, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5475, 0.6014, 0.8035, 0.9899, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5292, 0.5475, 0.6190, 0.8035, 0.9910, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5109, 0.5292, 0.5475, 0.6190, 0.7186, 0.9266, 0.9993, 0.9999, 0.9999,  &
0.4926, 0.5109, 0.5109, 0.5475, 0.6190, 0.6364, 0.5656, 0.7338, 0.9618 /
data ((cldnuctab( 6,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.8891, 0.9838, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6190, 0.9328, 0.9939, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.6703, 0.9618, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5656, 0.6014, 0.7487, 0.9773, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5475, 0.5656, 0.6014, 0.7770, 0.9855, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.5292, 0.5475, 0.5656, 0.6190, 0.7487, 0.9536, 0.9998, 0.9999, 0.9999,  &
0.5109, 0.5292, 0.5292, 0.5656, 0.6014, 0.7029, 0.7338, 0.9266, 0.9996 /
data ((cldnuctab( 6,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.8503, 0.9719, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.8975, 0.9886, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.6190, 0.9328, 0.9953, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5656, 0.6014, 0.6703, 0.9579, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5656, 0.5836, 0.6014, 0.7338, 0.9688, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.5475, 0.5656, 0.5656, 0.6190, 0.7338, 0.9536, 0.9997, 0.9999, 0.9999,  &
0.5292, 0.5475, 0.5475, 0.5656, 0.6190, 0.7186, 0.8035, 0.9818, 0.9999 /
data ((cldnuctab( 6,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.8160, 0.9579, 0.9953, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6014, 0.8608, 0.9797, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.6190, 0.8975, 0.9910, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.6014, 0.6535, 0.9266, 0.9964, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.5656, 0.5836, 0.6190, 0.7028, 0.9439, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.5656, 0.5656, 0.5836, 0.6190, 0.7186, 0.9328, 0.9993, 0.9999, 0.9999,  &
0.5475, 0.5656, 0.5656, 0.5836, 0.6190, 0.7186, 0.8160, 0.9921, 0.9999 /
data ((cldnuctab( 6,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.7770, 0.9439, 0.9930, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6014, 0.8279, 0.9719, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6014, 0.6190, 0.8707, 0.9855, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.6014, 0.6535, 0.8975, 0.9939, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.6014, 0.6190, 0.6703, 0.9130, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.5836, 0.5836, 0.6014, 0.6190, 0.7028, 0.9055, 0.9986, 0.9999, 0.9999,  &
0.5656, 0.5656, 0.5836, 0.5836, 0.6190, 0.7028, 0.8279, 0.9910, 0.9999 /
data ((cldnuctab( 6,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.7487, 0.9328, 0.9899, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6190, 0.8035, 0.9618, 0.9964, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6014, 0.6364, 0.8394, 0.9797, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6014, 0.6190, 0.6535, 0.8608, 0.9899, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.6014, 0.6014, 0.6190, 0.6703, 0.8801, 0.9953, 0.9998, 0.9999, 0.9999,  &
0.5836, 0.6014, 0.6014, 0.6190, 0.6868, 0.8801, 0.9972, 0.9999, 0.9999,  &
0.5836, 0.5836, 0.5836, 0.6014, 0.6190, 0.6868, 0.8279, 0.9871, 0.9999 /
data ((cldnuctab( 6,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9719, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7631, 0.9838, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7029, 0.8279, 0.9921, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6703, 0.7028, 0.8394, 0.9921, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6535, 0.6703, 0.7029, 0.8160, 0.9536, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6190, 0.6364, 0.6535, 0.7186, 0.8160, 0.7186, 0.8801, 0.9979, 0.9999,  &
0.5475, 0.5475, 0.5656, 0.5836, 0.6535, 0.8160, 0.4560, 0.5109, 0.6868 /
data ((cldnuctab( 6,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9489, 0.9964, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.9688, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7028, 0.7770, 0.9818, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6868, 0.7186, 0.8160, 0.9886, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6535, 0.6703, 0.7186, 0.8160, 0.9797, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6535, 0.6535, 0.6703, 0.7029, 0.8160, 0.8707, 0.9953, 0.9999, 0.9999,  &
0.6190, 0.6190, 0.6190, 0.6535, 0.7028, 0.8394, 0.6014, 0.7186, 0.9130 /
data ((cldnuctab( 6,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9200, 0.9921, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.9489, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.7487, 0.9655, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7029, 0.7186, 0.7905, 0.9773, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6868, 0.6868, 0.7186, 0.8035, 0.9748, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6703, 0.6703, 0.6868, 0.7029, 0.8035, 0.9200, 0.9994, 0.9999, 0.9999,  &
0.6535, 0.6535, 0.6535, 0.6703, 0.7186, 0.8279, 0.7338, 0.8707, 0.9959 /
data ((cldnuctab( 6,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.8891, 0.9855, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.9200, 0.9939, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.7487, 0.9386, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7029, 0.7186, 0.7631, 0.9579, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7029, 0.7029, 0.7186, 0.7905, 0.9618, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.6868, 0.6868, 0.7029, 0.7186, 0.7905, 0.9266, 0.9995, 0.9999, 0.9999,  &
0.6703, 0.6703, 0.6868, 0.6868, 0.7186, 0.7905, 0.8160, 0.9536, 0.9999 /
data ((cldnuctab( 6,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.8503, 0.9773, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.8891, 0.9899, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.7487, 0.9055, 0.9953, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.7338, 0.7631, 0.9266, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7029, 0.7186, 0.7338, 0.7770, 0.9386, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.7029, 0.7029, 0.7029, 0.7338, 0.7770, 0.9130, 0.9992, 0.9999, 0.9999,  &
0.6868, 0.6868, 0.7028, 0.7029, 0.7338, 0.7770, 0.8707, 0.9618, 0.9999 /
data ((cldnuctab( 6,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.8160, 0.9688, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.8503, 0.9838, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.7487, 0.8801, 0.9921, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.7338, 0.7631, 0.8975, 0.9964, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.7186, 0.7338, 0.7770, 0.9130, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.7028, 0.7186, 0.7186, 0.7338, 0.7770, 0.8975, 0.9979, 0.9999, 0.9999,  &
0.7029, 0.7029, 0.7029, 0.7186, 0.7338, 0.7770, 0.8801, 0.9655, 0.9999 /
data ((cldnuctab( 6,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.7905, 0.9618, 0.9959, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7487, 0.8279, 0.9797, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7487, 0.7631, 0.8503, 0.9886, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.7487, 0.7770, 0.8707, 0.9939, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7338, 0.7338, 0.7487, 0.7770, 0.8891, 0.9964, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.7186, 0.7338, 0.7487, 0.7770, 0.8891, 0.9964, 0.9999, 0.9999,  &
0.7186, 0.7186, 0.7186, 0.7338, 0.7487, 0.7770, 0.8801, 0.9655, 0.9999 /
data ((cldnuctab( 6,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9748, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.9855, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8035, 0.8608, 0.9899, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7770, 0.7905, 0.8608, 0.9818, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7631, 0.7770, 0.8035, 0.8707, 0.9200, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.7186, 0.7186, 0.7338, 0.7770, 0.8707, 0.7631, 0.8503, 0.9797, 0.9999,  &
0.6190, 0.6190, 0.6364, 0.6535, 0.6868, 0.7905, 0.9655, 0.5656, 0.7029 /
data ((cldnuctab( 6,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9579, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.9719, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8160, 0.8503, 0.9797, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7905, 0.8160, 0.8608, 0.9818, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7770, 0.7905, 0.8035, 0.8608, 0.9536, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7631, 0.7631, 0.7770, 0.8035, 0.8707, 0.8707, 0.9719, 0.9999, 0.9999,  &
0.7029, 0.7029, 0.7029, 0.7186, 0.7631, 0.8503, 0.8503, 0.7186, 0.8801 /
data ((cldnuctab( 6,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9328, 0.9964, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.9489, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8160, 0.8503, 0.9618, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8035, 0.8160, 0.8503, 0.9719, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7905, 0.8035, 0.8160, 0.8608, 0.9579, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7905, 0.7905, 0.7905, 0.8160, 0.8608, 0.9266, 0.9964, 0.9999, 0.9999,  &
0.7487, 0.7487, 0.7631, 0.7631, 0.7905, 0.8608, 0.9200, 0.8394, 0.9773 /
data ((cldnuctab( 6,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9055, 0.9930, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.9200, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8279, 0.8503, 0.9386, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8160, 0.8279, 0.8503, 0.9489, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8035, 0.8160, 0.8279, 0.8503, 0.9489, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.8035, 0.8035, 0.8035, 0.8279, 0.8503, 0.9328, 0.9976, 0.9999, 0.9999,  &
0.7770, 0.7770, 0.7905, 0.7905, 0.8160, 0.8608, 0.9328, 0.9130, 0.9979 /
data ((cldnuctab( 6,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.8707, 0.9886, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.8891, 0.9946, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.8503, 0.9055, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8279, 0.8394, 0.8503, 0.9266, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8160, 0.8160, 0.8279, 0.8503, 0.9328, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8160, 0.8160, 0.8160, 0.8279, 0.8503, 0.9328, 0.9972, 0.9999, 0.9999,  &
0.7905, 0.8035, 0.8035, 0.8035, 0.8279, 0.8608, 0.9328, 0.9386, 0.9997 /
data ((cldnuctab( 6,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.8503, 0.9838, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8503, 0.8608, 0.9910, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.8503, 0.8801, 0.9953, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.8394, 0.8608, 0.9055, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8279, 0.8279, 0.8394, 0.8608, 0.9200, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.8279, 0.8279, 0.8279, 0.8394, 0.8608, 0.9200, 0.9953, 0.9999, 0.9999,  &
0.8035, 0.8160, 0.8160, 0.8160, 0.8279, 0.8608, 0.9200, 0.9489, 0.9999 /
data ((cldnuctab( 6,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.8608, 0.9773, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8503, 0.8707, 0.9871, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8503, 0.8608, 0.8801, 0.9921, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.8503, 0.8608, 0.8975, 0.9953, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.8394, 0.8503, 0.8608, 0.9130, 0.9964, 0.9999, 0.9999, 0.9999,  &
0.8279, 0.8394, 0.8394, 0.8394, 0.8608, 0.9130, 0.9910, 0.9999, 0.9999,  &
0.8160, 0.8160, 0.8279, 0.8279, 0.8394, 0.8608, 0.9130, 0.9618, 0.9998 /
data ((cldnuctab( 6,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9748, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9818, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8801, 0.9130, 0.9818, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8707, 0.8801, 0.9055, 0.9719, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8503, 0.8503, 0.8707, 0.9130, 0.9618, 0.9886, 0.9999, 0.9999, 0.9999,  &
0.7905, 0.7905, 0.8035, 0.8279, 0.8891, 0.9818, 0.8394, 0.9489, 0.9999,  &
0.6868, 0.6868, 0.6868, 0.7028, 0.7338, 0.7905, 0.9200, 0.6535, 0.7487 /
data ((cldnuctab( 6,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9579, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9688, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.9130, 0.9748, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8801, 0.8891, 0.9130, 0.9719, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8707, 0.8707, 0.8891, 0.9130, 0.9655, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8394, 0.8394, 0.8503, 0.8707, 0.9055, 0.9838, 0.9439, 0.9991, 0.9999,  &
0.7631, 0.7631, 0.7631, 0.7770, 0.8035, 0.8608, 0.9618, 0.7487, 0.8608 /
data ((cldnuctab( 6,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9328, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9489, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.9130, 0.9618, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8891, 0.8975, 0.9130, 0.9655, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8801, 0.8891, 0.8975, 0.9130, 0.9655, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.8707, 0.8707, 0.8707, 0.8891, 0.9130, 0.9688, 0.9818, 0.9999, 0.9999,  &
0.8160, 0.8160, 0.8279, 0.8279, 0.8503, 0.8891, 0.9719, 0.8503, 0.9489 /
data ((cldnuctab( 6,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9200, 0.9964, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9328, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9130, 0.9439, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.9055, 0.9130, 0.9536, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8891, 0.8975, 0.8975, 0.9130, 0.9579, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8801, 0.8801, 0.8891, 0.8975, 0.9130, 0.9579, 0.9899, 0.9999, 0.9999,  &
0.8503, 0.8503, 0.8503, 0.8608, 0.8707, 0.9055, 0.9655, 0.9130, 0.9855 /
data ((cldnuctab( 6,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9200, 0.9939, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9266, 0.9964, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9200, 0.9386, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9055, 0.9200, 0.9489, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.9055, 0.9055, 0.9200, 0.9489, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.8891, 0.8975, 0.8975, 0.9055, 0.9200, 0.9489, 0.9910, 0.9999, 0.9999,  &
0.8707, 0.8707, 0.8707, 0.8707, 0.8891, 0.9055, 0.9536, 0.9719, 0.9953 /
data ((cldnuctab( 6,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9266, 0.9899, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9200, 0.9328, 0.9946, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9200, 0.9386, 0.9964, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9130, 0.9200, 0.9439, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9055, 0.9130, 0.9200, 0.9439, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.9055, 0.9055, 0.9130, 0.9200, 0.9439, 0.9910, 0.9999, 0.9999,  &
0.8801, 0.8801, 0.8801, 0.8891, 0.8891, 0.9130, 0.9489, 0.9871, 0.9982 /
data ((cldnuctab( 6,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9266, 0.9871, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9266, 0.9328, 0.9921, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9200, 0.9266, 0.9386, 0.9939, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9200, 0.9266, 0.9439, 0.9953, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9130, 0.9200, 0.9266, 0.9439, 0.9939, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9055, 0.9130, 0.9130, 0.9200, 0.9439, 0.9910, 0.9999, 0.9999,  &
0.8891, 0.8891, 0.8891, 0.8891, 0.8975, 0.9130, 0.9439, 0.9886, 0.9986 /
data ((cldnuctab( 6,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9719, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9328, 0.9797, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9200, 0.9328, 0.9797, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9200, 0.9328, 0.9773, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8801, 0.8891, 0.8975, 0.9328, 0.9871, 0.9797, 0.9999, 0.9999, 0.9999,  &
0.8160, 0.8160, 0.8279, 0.8503, 0.8891, 0.9719, 0.8503, 0.9386, 0.9997,  &
0.7186, 0.7186, 0.7186, 0.7338, 0.7487, 0.8035, 0.9055, 0.7186, 0.7770 /
data ((cldnuctab( 6,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9536, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9688, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9200, 0.9386, 0.9748, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9200, 0.9200, 0.9328, 0.9748, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9055, 0.9130, 0.9200, 0.9386, 0.9773, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.8707, 0.8707, 0.8801, 0.8891, 0.9200, 0.9797, 0.9328, 0.9964, 0.9999,  &
0.7905, 0.7905, 0.8035, 0.8035, 0.8279, 0.8608, 0.9489, 0.8035, 0.8608 /
data ((cldnuctab( 6,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9489, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9579, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9328, 0.9386, 0.9655, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9266, 0.9266, 0.9386, 0.9688, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9200, 0.9200, 0.9266, 0.9386, 0.9719, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.8975, 0.9055, 0.9130, 0.9328, 0.9773, 0.9748, 0.9999, 0.9999,  &
0.8503, 0.8503, 0.8503, 0.8608, 0.8707, 0.8975, 0.9655, 0.8975, 0.9386 /
data ((cldnuctab( 6,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9489, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9536, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9439, 0.9618, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9328, 0.9328, 0.9439, 0.9655, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9266, 0.9266, 0.9328, 0.9386, 0.9655, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9130, 0.9200, 0.9266, 0.9386, 0.9688, 0.9886, 0.9999, 0.9999,  &
0.8801, 0.8801, 0.8801, 0.8891, 0.8975, 0.9200, 0.9655, 0.9818, 0.9748 /
data ((cldnuctab( 6,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9489, 0.9953, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9536, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9439, 0.9579, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9386, 0.9439, 0.9618, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9328, 0.9328, 0.9386, 0.9439, 0.9618, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.9266, 0.9266, 0.9266, 0.9328, 0.9439, 0.9618, 0.9939, 0.9999, 0.9999,  &
0.8975, 0.8975, 0.8975, 0.9055, 0.9055, 0.9266, 0.9618, 0.9939, 0.9899 /
data ((cldnuctab( 6,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9536, 0.9921, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9536, 0.9953, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9489, 0.9579, 0.9964, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9439, 0.9489, 0.9618, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9386, 0.9439, 0.9489, 0.9618, 0.9959, 0.9999, 0.9999, 0.9999,  &
0.9328, 0.9328, 0.9328, 0.9386, 0.9439, 0.9618, 0.9939, 0.9999, 0.9999,  &
0.9055, 0.9055, 0.9055, 0.9130, 0.9200, 0.9328, 0.9579, 0.9946, 0.9939 /
data ((cldnuctab( 6,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9536, 0.9899, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9579, 0.9930, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9489, 0.9579, 0.9939, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9439, 0.9489, 0.9618, 0.9946, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9439, 0.9439, 0.9489, 0.9618, 0.9930, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9386, 0.9386, 0.9386, 0.9489, 0.9618, 0.9921, 0.9999, 0.9999,  &
0.9130, 0.9130, 0.9130, 0.9200, 0.9200, 0.9328, 0.9579, 0.9930, 0.9959 /
data ((cldnuctab( 6,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9719, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9797, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9489, 0.9797, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9266, 0.9328, 0.9489, 0.9818, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.9055, 0.9130, 0.9386, 0.9855, 0.9748, 0.9998, 0.9999, 0.9999,  &
0.8394, 0.8394, 0.8503, 0.8608, 0.8975, 0.9655, 0.8608, 0.9328, 0.9990,  &
0.7487, 0.7487, 0.7487, 0.7631, 0.7770, 0.8160, 0.8975, 0.9838, 0.8035 /
data ((cldnuctab( 6,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9655, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9719, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9536, 0.9773, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9439, 0.9489, 0.9773, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9266, 0.9266, 0.9328, 0.9489, 0.9818, 0.9939, 0.9999, 0.9999, 0.9999,  &
0.8891, 0.8891, 0.8975, 0.9055, 0.9328, 0.9797, 0.9386, 0.9921, 0.9999,  &
0.8160, 0.8160, 0.8160, 0.8279, 0.8394, 0.8707, 0.9439, 0.9995, 0.8707 /
data ((cldnuctab( 6,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9618, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9688, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9536, 0.9719, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9489, 0.9536, 0.9748, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9386, 0.9439, 0.9536, 0.9748, 0.9976, 0.9999, 0.9999, 0.9999,  &
0.9200, 0.9200, 0.9200, 0.9266, 0.9439, 0.9797, 0.9818, 0.9997, 0.9999,  &
0.8707, 0.8707, 0.8707, 0.8707, 0.8801, 0.9055, 0.9618, 0.9998, 0.9386 /
data ((cldnuctab( 6,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9618, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9655, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9579, 0.9688, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9489, 0.9579, 0.9719, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9489, 0.9489, 0.9579, 0.9719, 0.9976, 0.9999, 0.9999, 0.9999,  &
0.9328, 0.9328, 0.9328, 0.9386, 0.9536, 0.9748, 0.9946, 0.9999, 0.9999,  &
0.8975, 0.8975, 0.8975, 0.8975, 0.9055, 0.9266, 0.9655, 0.9995, 0.9719 /
data ((cldnuctab( 6,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9655, 0.9959, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9688, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9618, 0.9688, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9536, 0.9579, 0.9688, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9536, 0.9536, 0.9579, 0.9688, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9439, 0.9439, 0.9489, 0.9536, 0.9719, 0.9959, 0.9999, 0.9999,  &
0.9130, 0.9130, 0.9130, 0.9200, 0.9200, 0.9386, 0.9655, 0.9986, 0.9855 /
data ((cldnuctab( 6,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9655, 0.9939, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9688, 0.9953, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9618, 0.9688, 0.9964, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9579, 0.9618, 0.9688, 0.9964, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9536, 0.9579, 0.9618, 0.9688, 0.9953, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9489, 0.9489, 0.9536, 0.9579, 0.9719, 0.9946, 0.9999, 0.9999,  &
0.9200, 0.9200, 0.9266, 0.9266, 0.9328, 0.9386, 0.9618, 0.9968, 0.9921 /
data ((cldnuctab( 6,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9688, 0.9910, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9655, 0.9688, 0.9930, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9655, 0.9719, 0.9939, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9618, 0.9655, 0.9719, 0.9939, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9579, 0.9618, 0.9618, 0.9719, 0.9939, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9536, 0.9536, 0.9536, 0.9618, 0.9719, 0.9930, 0.9999, 0.9999,  &
0.9266, 0.9266, 0.9266, 0.9328, 0.9328, 0.9439, 0.9618, 0.9946, 0.9959 /
data ((cldnuctab( 6,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9748, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9818, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9579, 0.9818, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9489, 0.9579, 0.9838, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9130, 0.9130, 0.9266, 0.9439, 0.9855, 0.9719, 0.9996, 0.9999, 0.9999,  &
0.8503, 0.8503, 0.8608, 0.8707, 0.8975, 0.9618, 0.8975, 0.9328, 0.9972,  &
0.7770, 0.7770, 0.7770, 0.7770, 0.7905, 0.8279, 0.8975, 0.9748, 0.8160 /
data ((cldnuctab( 6,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9719, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9773, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9618, 0.9797, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9536, 0.9618, 0.9797, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9386, 0.9386, 0.9439, 0.9579, 0.9838, 0.9939, 0.9999, 0.9999, 0.9999,  &
0.8975, 0.9055, 0.9055, 0.9130, 0.9386, 0.9773, 0.9719, 0.9871, 0.9999,  &
0.8279, 0.8279, 0.8279, 0.8394, 0.8503, 0.8801, 0.9386, 0.9984, 0.8801 /
data ((cldnuctab( 6,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9719, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9655, 0.9748, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9655, 0.9773, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9579, 0.9618, 0.9773, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9489, 0.9489, 0.9536, 0.9618, 0.9797, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.9266, 0.9266, 0.9328, 0.9386, 0.9536, 0.9797, 0.9946, 0.9992, 0.9999,  &
0.8801, 0.8801, 0.8801, 0.8801, 0.8891, 0.9130, 0.9579, 0.9995, 0.9386 /
data ((cldnuctab( 6,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9719, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9688, 0.9748, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9655, 0.9748, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9618, 0.9655, 0.9773, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9579, 0.9618, 0.9655, 0.9748, 0.9976, 0.9999, 0.9999, 0.9999,  &
0.9439, 0.9439, 0.9439, 0.9489, 0.9579, 0.9797, 0.9976, 0.9999, 0.9999,  &
0.9055, 0.9055, 0.9055, 0.9130, 0.9200, 0.9328, 0.9655, 0.9991, 0.9688 /
data ((cldnuctab( 6,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9719, 0.9964, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9688, 0.9748, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9655, 0.9688, 0.9748, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9655, 0.9655, 0.9688, 0.9773, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9618, 0.9655, 0.9688, 0.9773, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.9536, 0.9536, 0.9536, 0.9579, 0.9618, 0.9773, 0.9968, 0.9999, 0.9999,  &
0.9200, 0.9266, 0.9266, 0.9266, 0.9328, 0.9439, 0.9655, 0.9979, 0.9838 /
data ((cldnuctab( 6,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9748, 0.9939, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9719, 0.9748, 0.9953, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9688, 0.9719, 0.9773, 0.9959, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9655, 0.9688, 0.9719, 0.9773, 0.9959, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9655, 0.9655, 0.9655, 0.9688, 0.9773, 0.9953, 0.9999, 0.9999, 0.9999,  &
0.9579, 0.9579, 0.9579, 0.9618, 0.9655, 0.9773, 0.9959, 0.9999, 0.9999,  &
0.9328, 0.9328, 0.9328, 0.9328, 0.9386, 0.9489, 0.9655, 0.9959, 0.9921 /
data ((cldnuctab( 6,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9748, 0.9910, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9719, 0.9773, 0.9930, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9719, 0.9719, 0.9773, 0.9939, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9688, 0.9688, 0.9719, 0.9773, 0.9939, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9688, 0.9688, 0.9688, 0.9719, 0.9773, 0.9939, 0.9999, 0.9999, 0.9999,  &
0.9618, 0.9618, 0.9618, 0.9618, 0.9688, 0.9773, 0.9939, 0.9999, 0.9999,  &
0.9386, 0.9386, 0.9386, 0.9386, 0.9439, 0.9489, 0.9655, 0.9939, 0.9979 /
data ((cldnuctab( 7,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9742, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7741, 0.9852, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7306, 0.8370, 0.9919, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6994, 0.7306, 0.8480, 0.9919, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6833, 0.6994, 0.7306, 0.8370, 0.9479, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6499, 0.6667, 0.6833, 0.7306, 0.8686, 0.7306, 0.8781, 0.9963, 0.9999,  &
0.5797, 0.5797, 0.5976, 0.6153, 0.6667, 0.8133, 0.4887, 0.5617, 0.6994 /
data ((cldnuctab( 7,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9526, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.9713, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.8007, 0.9834, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7152, 0.7455, 0.8254, 0.9883, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6994, 0.7152, 0.7455, 0.8254, 0.9742, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6833, 0.6994, 0.6994, 0.7455, 0.8370, 0.8586, 0.9919, 0.9999, 0.9999,  &
0.6499, 0.6499, 0.6499, 0.6833, 0.7306, 0.8480, 0.6327, 0.7306, 0.9114 /
data ((cldnuctab( 7,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.9252, 0.9937, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.9479, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7741, 0.9681, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7306, 0.7455, 0.8007, 0.9768, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7152, 0.7306, 0.7455, 0.8133, 0.9713, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6994, 0.7152, 0.7152, 0.7455, 0.8254, 0.9185, 0.9992, 0.9999, 0.9999,  &
0.6833, 0.6833, 0.6994, 0.6994, 0.7455, 0.8370, 0.7600, 0.8781, 0.9928 /
data ((cldnuctab( 7,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.8957, 0.9883, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.9185, 0.9951, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7741, 0.9428, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7600, 0.7877, 0.9570, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7306, 0.7306, 0.7600, 0.8007, 0.9570, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.7152, 0.7306, 0.7306, 0.7455, 0.8133, 0.9252, 0.9996, 0.9999, 0.9999,  &
0.6994, 0.7152, 0.7152, 0.7306, 0.7455, 0.8133, 0.8480, 0.9428, 0.9998 /
data ((cldnuctab( 7,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.8586, 0.9814, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.8872, 0.9908, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.7741, 0.9114, 0.9963, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7600, 0.7877, 0.9252, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7455, 0.7600, 0.8007, 0.9374, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.7306, 0.7306, 0.7455, 0.7600, 0.8007, 0.9185, 0.9991, 0.9999, 0.9999,  &
0.7306, 0.7306, 0.7306, 0.7455, 0.7600, 0.8007, 0.8872, 0.9647, 0.9999 /
data ((cldnuctab( 7,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.8254, 0.9742, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7741, 0.8586, 0.9868, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.7877, 0.8781, 0.9937, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.7741, 0.7877, 0.8957, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7600, 0.7741, 0.8007, 0.9114, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7455, 0.7600, 0.7600, 0.8007, 0.9038, 0.9981, 0.9999, 0.9999,  &
0.7306, 0.7455, 0.7455, 0.7455, 0.7600, 0.8007, 0.8957, 0.9647, 0.9999 /
data ((cldnuctab( 7,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.8007, 0.9681, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7741, 0.8254, 0.9814, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7741, 0.7877, 0.8480, 0.9896, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7741, 0.7741, 0.8007, 0.8686, 0.9945, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.7600, 0.7741, 0.8007, 0.8957, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.7600, 0.7600, 0.7600, 0.7741, 0.8007, 0.8957, 0.9957, 0.9999, 0.9999,  &
0.7455, 0.7455, 0.7455, 0.7600, 0.7741, 0.8007, 0.8872, 0.9610, 0.9999 /
data ((cldnuctab( 7,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9768, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.9852, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8370, 0.8686, 0.9883, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8133, 0.8254, 0.8781, 0.9792, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7877, 0.8007, 0.8254, 0.8781, 0.9185, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.7455, 0.7455, 0.7600, 0.8007, 0.8781, 0.8133, 0.8480, 0.9742, 0.9999,  &
0.6499, 0.6499, 0.6499, 0.6667, 0.6994, 0.8007, 0.9526, 0.5976, 0.7306 /
data ((cldnuctab( 7,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9570, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.9713, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8370, 0.8686, 0.9792, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8133, 0.8370, 0.8686, 0.9792, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8133, 0.8133, 0.8254, 0.8781, 0.9526, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7877, 0.7877, 0.8007, 0.8254, 0.8872, 0.9114, 0.9647, 0.9999, 0.9999,  &
0.7152, 0.7306, 0.7306, 0.7455, 0.7741, 0.8586, 0.9814, 0.7306, 0.8781 /
data ((cldnuctab( 7,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9315, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.9526, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8480, 0.8686, 0.9610, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8370, 0.8480, 0.8686, 0.9681, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8254, 0.8254, 0.8370, 0.8686, 0.9570, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.8133, 0.8133, 0.8254, 0.8370, 0.8781, 0.9374, 0.9945, 0.9999, 0.9999,  &
0.7741, 0.7741, 0.7741, 0.7877, 0.8133, 0.8686, 0.9792, 0.8480, 0.9742 /
data ((cldnuctab( 7,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.9038, 0.9937, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.9252, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8480, 0.8686, 0.9374, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8370, 0.8480, 0.8686, 0.9526, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8370, 0.8370, 0.8480, 0.8686, 0.9526, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.8254, 0.8254, 0.8370, 0.8480, 0.8686, 0.9428, 0.9972, 0.9999, 0.9999,  &
0.8007, 0.8007, 0.8007, 0.8133, 0.8370, 0.8686, 0.9526, 0.9038, 0.9968 /
data ((cldnuctab( 7,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.8781, 0.9896, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8686, 0.8957, 0.9951, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.8686, 0.9114, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8480, 0.8586, 0.8686, 0.9315, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8370, 0.8480, 0.8586, 0.8686, 0.9374, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8370, 0.8370, 0.8480, 0.8480, 0.8686, 0.9374, 0.9963, 0.9999, 0.9999,  &
0.8254, 0.8254, 0.8254, 0.8254, 0.8370, 0.8686, 0.9428, 0.9374, 0.9995 /
data ((cldnuctab( 7,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.8781, 0.9852, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8686, 0.8872, 0.9919, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.8781, 0.9038, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.8586, 0.8781, 0.9185, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8480, 0.8586, 0.8586, 0.8781, 0.9252, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.8480, 0.8480, 0.8480, 0.8586, 0.8781, 0.9252, 0.9928, 0.9999, 0.9999,  &
0.8370, 0.8370, 0.8370, 0.8370, 0.8480, 0.8781, 0.9315, 0.9526, 0.9998 /
data ((cldnuctab( 7,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.8781, 0.9814, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8781, 0.8872, 0.9883, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8686, 0.8781, 0.9038, 0.9928, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8686, 0.8686, 0.8781, 0.9114, 0.9951, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.8586, 0.8686, 0.8781, 0.9185, 0.9957, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.8586, 0.8586, 0.8686, 0.8781, 0.9185, 0.9908, 0.9999, 0.9999,  &
0.8370, 0.8370, 0.8480, 0.8480, 0.8586, 0.8781, 0.9185, 0.9713, 0.9998 /
data ((cldnuctab( 7,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9742, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9185, 0.9814, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8957, 0.9185, 0.9814, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8872, 0.8957, 0.9185, 0.9742, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8686, 0.8686, 0.8872, 0.9252, 0.9742, 0.9868, 0.9999, 0.9999, 0.9999,  &
0.8007, 0.8007, 0.8133, 0.8370, 0.8872, 0.9792, 0.8370, 0.9479, 0.9999,  &
0.6994, 0.6994, 0.7152, 0.7152, 0.7455, 0.8007, 0.9114, 0.6833, 0.7600 /
data ((cldnuctab( 7,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9570, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9681, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9114, 0.9252, 0.9742, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8957, 0.9038, 0.9185, 0.9742, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8872, 0.8957, 0.9038, 0.9252, 0.9713, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.8586, 0.8586, 0.8586, 0.8781, 0.9185, 0.9834, 0.9374, 0.9984, 0.9999,  &
0.7741, 0.7877, 0.7877, 0.7877, 0.8133, 0.8586, 0.9570, 0.7741, 0.8586 /
data ((cldnuctab( 7,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9315, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9479, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9114, 0.9252, 0.9647, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9038, 0.9114, 0.9252, 0.9681, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9038, 0.9038, 0.9114, 0.9252, 0.9681, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.8781, 0.8872, 0.8872, 0.8957, 0.9252, 0.9768, 0.9792, 0.9999, 0.9999,  &
0.8370, 0.8370, 0.8370, 0.8480, 0.8586, 0.8957, 0.9681, 0.8586, 0.9428 /
data ((cldnuctab( 7,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9315, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9428, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9185, 0.9252, 0.9526, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9114, 0.9185, 0.9252, 0.9610, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9114, 0.9114, 0.9185, 0.9252, 0.9610, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.8957, 0.8957, 0.9038, 0.9114, 0.9252, 0.9647, 0.9868, 0.9999, 0.9999,  &
0.8686, 0.8686, 0.8686, 0.8686, 0.8872, 0.9114, 0.9647, 0.9374, 0.9834 /
data ((cldnuctab( 7,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.9374, 0.9945, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9315, 0.9428, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9315, 0.9479, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9185, 0.9252, 0.9315, 0.9526, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9185, 0.9185, 0.9185, 0.9315, 0.9526, 0.9981, 0.9999, 0.9999, 0.9999,  &
0.9114, 0.9114, 0.9114, 0.9185, 0.9315, 0.9570, 0.9919, 0.9999, 0.9999,  &
0.8872, 0.8872, 0.8872, 0.8872, 0.8957, 0.9185, 0.9570, 0.9834, 0.9945 /
data ((cldnuctab( 7,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.9374, 0.9919, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9315, 0.9428, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9315, 0.9315, 0.9479, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9252, 0.9315, 0.9526, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9252, 0.9252, 0.9315, 0.9526, 0.9963, 0.9999, 0.9999, 0.9999,  &
0.9185, 0.9185, 0.9185, 0.9252, 0.9315, 0.9526, 0.9919, 0.9999, 0.9999,  &
0.8957, 0.8957, 0.8957, 0.8957, 0.9038, 0.9185, 0.9526, 0.9908, 0.9968 /
data ((cldnuctab( 7,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.9374, 0.9883, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9374, 0.9428, 0.9919, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9315, 0.9374, 0.9479, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9315, 0.9315, 0.9374, 0.9526, 0.9951, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9252, 0.9315, 0.9374, 0.9526, 0.9937, 0.9999, 0.9999, 0.9999,  &
0.9185, 0.9185, 0.9252, 0.9252, 0.9374, 0.9526, 0.9919, 0.9999, 0.9999,  &
0.9038, 0.9038, 0.9038, 0.9038, 0.9114, 0.9252, 0.9479, 0.9908, 0.9972 /
data ((cldnuctab( 7,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9742, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9570, 0.9814, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9479, 0.9570, 0.9814, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9374, 0.9428, 0.9570, 0.9834, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9114, 0.9114, 0.9252, 0.9428, 0.9852, 0.9713, 0.9997, 0.9999, 0.9999,  &
0.8480, 0.8480, 0.8586, 0.8686, 0.9038, 0.9610, 0.8872, 0.9374, 0.9979,  &
0.7741, 0.7741, 0.7741, 0.7741, 0.7877, 0.8254, 0.8957, 0.9768, 0.8254 /
data ((cldnuctab( 7,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9713, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9610, 0.9768, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9526, 0.9570, 0.9792, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9479, 0.9526, 0.9610, 0.9792, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9374, 0.9374, 0.9428, 0.9570, 0.9834, 0.9937, 0.9999, 0.9999, 0.9999,  &
0.8957, 0.9038, 0.9038, 0.9114, 0.9374, 0.9768, 0.9570, 0.9883, 0.9999,  &
0.8254, 0.8254, 0.8370, 0.8370, 0.8480, 0.8781, 0.9374, 0.9988, 0.8872 /
data ((cldnuctab( 7,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9713, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9742, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9570, 0.9647, 0.9768, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9526, 0.9570, 0.9610, 0.9768, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9479, 0.9479, 0.9526, 0.9610, 0.9792, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9252, 0.9315, 0.9374, 0.9526, 0.9792, 0.9928, 0.9994, 0.9999,  &
0.8781, 0.8781, 0.8781, 0.8781, 0.8872, 0.9114, 0.9610, 0.9996, 0.9374 /
data ((cldnuctab( 7,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9713, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9742, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9610, 0.9647, 0.9742, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9570, 0.9610, 0.9647, 0.9742, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9526, 0.9570, 0.9570, 0.9647, 0.9742, 0.9975, 0.9999, 0.9999, 0.9999,  &
0.9428, 0.9428, 0.9428, 0.9479, 0.9570, 0.9768, 0.9968, 0.9999, 0.9999,  &
0.9038, 0.9038, 0.9038, 0.9114, 0.9185, 0.9315, 0.9647, 0.9992, 0.9713 /
data ((cldnuctab( 7,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9713, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9742, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9681, 0.9742, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9610, 0.9647, 0.9681, 0.9742, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9610, 0.9610, 0.9610, 0.9647, 0.9742, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.9479, 0.9479, 0.9526, 0.9526, 0.9610, 0.9768, 0.9968, 0.9999, 0.9999,  &
0.9185, 0.9185, 0.9252, 0.9252, 0.9315, 0.9428, 0.9647, 0.9981, 0.9852 /
data ((cldnuctab( 7,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9713, 0.9937, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9742, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9681, 0.9742, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9647, 0.9681, 0.9742, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9610, 0.9647, 0.9647, 0.9681, 0.9742, 0.9957, 0.9999, 0.9999, 0.9999,  &
0.9526, 0.9570, 0.9570, 0.9570, 0.9647, 0.9742, 0.9957, 0.9999, 0.9999,  &
0.9315, 0.9315, 0.9315, 0.9315, 0.9374, 0.9479, 0.9647, 0.9963, 0.9919 /
data ((cldnuctab( 7,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9742, 0.9919, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9742, 0.9928, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9713, 0.9768, 0.9937, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9681, 0.9713, 0.9768, 0.9937, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9647, 0.9681, 0.9713, 0.9768, 0.9937, 0.9999, 0.9999, 0.9999,  &
0.9570, 0.9570, 0.9610, 0.9610, 0.9647, 0.9742, 0.9937, 0.9999, 0.9999,  &
0.9374, 0.9374, 0.9374, 0.9374, 0.9428, 0.9479, 0.9647, 0.9937, 0.9972 /
data ((cldnuctab( 7,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9834, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9852, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9713, 0.9852, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9570, 0.9610, 0.9713, 0.9883, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9315, 0.9315, 0.9374, 0.9526, 0.9834, 0.9883, 0.9984, 0.9999, 0.9999,  &
0.8781, 0.8781, 0.8781, 0.8872, 0.9114, 0.9570, 0.9994, 0.9374, 0.9945,  &
0.8133, 0.8133, 0.8133, 0.8133, 0.8254, 0.8480, 0.9038, 0.9681, 0.8586 /
data ((cldnuctab( 7,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9814, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9834, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9742, 0.9852, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9681, 0.9742, 0.9852, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9526, 0.9526, 0.9570, 0.9681, 0.9868, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.9185, 0.9185, 0.9185, 0.9252, 0.9428, 0.9742, 0.9998, 0.9852, 0.9999,  &
0.8586, 0.8586, 0.8586, 0.8586, 0.8686, 0.8872, 0.9374, 0.9945, 0.8957 /
data ((cldnuctab( 7,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9814, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9834, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9742, 0.9742, 0.9834, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9713, 0.9768, 0.9834, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9647, 0.9681, 0.9742, 0.9852, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.9428, 0.9428, 0.9479, 0.9479, 0.9610, 0.9814, 0.9997, 0.9981, 0.9999,  &
0.8957, 0.8957, 0.8957, 0.8957, 0.9038, 0.9252, 0.9570, 0.9981, 0.9428 /
data ((cldnuctab( 7,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9814, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9834, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9792, 0.9834, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9742, 0.9742, 0.9768, 0.9834, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9713, 0.9713, 0.9768, 0.9834, 0.9981, 0.9999, 0.9999, 0.9999,  &
0.9570, 0.9570, 0.9570, 0.9610, 0.9681, 0.9834, 0.9993, 0.9997, 0.9999,  &
0.9252, 0.9252, 0.9252, 0.9252, 0.9315, 0.9428, 0.9647, 0.9979, 0.9681 /
data ((cldnuctab( 7,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9834, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9834, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9792, 0.9834, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9768, 0.9792, 0.9834, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9742, 0.9742, 0.9768, 0.9792, 0.9834, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9647, 0.9647, 0.9681, 0.9713, 0.9834, 0.9984, 0.9999, 0.9999,  &
0.9374, 0.9374, 0.9374, 0.9374, 0.9428, 0.9526, 0.9681, 0.9968, 0.9852 /
data ((cldnuctab( 7,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9834, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9852, 0.9951, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9814, 0.9852, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9792, 0.9814, 0.9852, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9768, 0.9768, 0.9792, 0.9852, 0.9957, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9681, 0.9681, 0.9713, 0.9742, 0.9834, 0.9968, 0.9999, 0.9999,  &
0.9428, 0.9428, 0.9428, 0.9479, 0.9479, 0.9570, 0.9713, 0.9945, 0.9975 /
data ((cldnuctab( 7,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9852, 0.9919, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9852, 0.9928, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9834, 0.9852, 0.9937, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9814, 0.9814, 0.9852, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9792, 0.9792, 0.9814, 0.9852, 0.9945, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9713, 0.9713, 0.9742, 0.9768, 0.9834, 0.9951, 0.9999, 0.9999,  &
0.9479, 0.9479, 0.9479, 0.9526, 0.9526, 0.9570, 0.9713, 0.9928, 0.9998 /
data ((cldnuctab( 7,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9883, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9883, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9792, 0.9883, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9681, 0.9768, 0.9896, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9374, 0.9428, 0.9479, 0.9570, 0.9834, 0.9999, 0.9968, 0.9999, 0.9999,  &
0.8872, 0.8872, 0.8957, 0.9038, 0.9185, 0.9570, 0.9979, 0.9428, 0.9919,  &
0.8370, 0.8370, 0.8370, 0.8480, 0.8480, 0.8686, 0.9114, 0.9647, 0.9908 /
data ((cldnuctab( 7,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9868, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9883, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9814, 0.9883, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9742, 0.9768, 0.9814, 0.9883, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9610, 0.9610, 0.9647, 0.9742, 0.9883, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.9252, 0.9315, 0.9315, 0.9374, 0.9479, 0.9742, 0.9995, 0.9814, 0.9999,  &
0.8781, 0.8781, 0.8781, 0.8781, 0.8872, 0.9038, 0.9374, 0.9896, 0.9185 /
data ((cldnuctab( 7,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9868, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9883, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9834, 0.9883, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9814, 0.9834, 0.9883, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9742, 0.9742, 0.9792, 0.9883, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9526, 0.9526, 0.9526, 0.9570, 0.9647, 0.9834, 0.9995, 0.9963, 0.9999,  &
0.9114, 0.9114, 0.9114, 0.9114, 0.9185, 0.9315, 0.9570, 0.9957, 0.9479 /
data ((cldnuctab( 7,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9883, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9852, 0.9883, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9852, 0.9883, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9834, 0.9852, 0.9883, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9792, 0.9792, 0.9834, 0.9883, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.9647, 0.9647, 0.9647, 0.9681, 0.9742, 0.9852, 0.9991, 0.9991, 0.9999,  &
0.9315, 0.9315, 0.9315, 0.9315, 0.9374, 0.9479, 0.9681, 0.9963, 0.9742 /
data ((cldnuctab( 7,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9883, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9883, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9852, 0.9868, 0.9883, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9852, 0.9852, 0.9883, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9814, 0.9834, 0.9852, 0.9883, 0.9975, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9713, 0.9713, 0.9742, 0.9768, 0.9852, 0.9981, 0.9997, 0.9999,  &
0.9428, 0.9428, 0.9479, 0.9479, 0.9479, 0.9570, 0.9713, 0.9951, 0.9945 /
data ((cldnuctab( 7,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9896, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9883, 0.9896, 0.9951, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9868, 0.9896, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9852, 0.9868, 0.9868, 0.9896, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9834, 0.9834, 0.9852, 0.9896, 0.9963, 0.9999, 0.9999, 0.9999,  &
0.9742, 0.9742, 0.9768, 0.9768, 0.9792, 0.9868, 0.9972, 0.9999, 0.9999,  &
0.9526, 0.9526, 0.9526, 0.9526, 0.9570, 0.9610, 0.9713, 0.9928, 0.9999 /
data ((cldnuctab( 7,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9896, 0.9928, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9883, 0.9896, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9883, 0.9896, 0.9951, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9868, 0.9883, 0.9896, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9852, 0.9852, 0.9852, 0.9868, 0.9896, 0.9957, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9768, 0.9792, 0.9792, 0.9814, 0.9868, 0.9957, 0.9999, 0.9999,  &
0.9570, 0.9570, 0.9570, 0.9570, 0.9610, 0.9647, 0.9742, 0.9919, 0.9999 /
data ((cldnuctab( 7,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9908, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9852, 0.9908, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9852, 0.9908, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9742, 0.9792, 0.9908, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9479, 0.9479, 0.9526, 0.9610, 0.9834, 0.9998, 0.9951, 0.9999, 0.9999,  &
0.9038, 0.9038, 0.9038, 0.9114, 0.9252, 0.9570, 0.9963, 0.9479, 0.9908,  &
0.8586, 0.8586, 0.8586, 0.8686, 0.8686, 0.8872, 0.9185, 0.9610, 0.9868 /
data ((cldnuctab( 7,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9908, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9908, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9852, 0.9868, 0.9896, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9814, 0.9852, 0.9908, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9681, 0.9681, 0.9713, 0.9768, 0.9896, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.9374, 0.9374, 0.9374, 0.9428, 0.9526, 0.9742, 0.9990, 0.9792, 0.9997,  &
0.8872, 0.8872, 0.8872, 0.8957, 0.8957, 0.9114, 0.9428, 0.9868, 0.9374 /
data ((cldnuctab( 7,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9908, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9883, 0.9908, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9868, 0.9908, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9852, 0.9868, 0.9908, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9768, 0.9792, 0.9834, 0.9908, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.9570, 0.9570, 0.9610, 0.9610, 0.9681, 0.9834, 0.9992, 0.9951, 0.9999,  &
0.9185, 0.9185, 0.9185, 0.9185, 0.9252, 0.9374, 0.9570, 0.9937, 0.9570 /
data ((cldnuctab( 7,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9908, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9896, 0.9908, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9883, 0.9883, 0.9908, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9868, 0.9883, 0.9908, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9834, 0.9834, 0.9834, 0.9868, 0.9908, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.9713, 0.9713, 0.9713, 0.9742, 0.9768, 0.9868, 0.9990, 0.9988, 0.9999,  &
0.9374, 0.9374, 0.9374, 0.9428, 0.9428, 0.9526, 0.9681, 0.9945, 0.9852 /
data ((cldnuctab( 7,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9919, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9896, 0.9919, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9896, 0.9896, 0.9919, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9883, 0.9883, 0.9896, 0.9908, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9852, 0.9852, 0.9868, 0.9883, 0.9908, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.9768, 0.9768, 0.9768, 0.9792, 0.9814, 0.9883, 0.9981, 0.9997, 0.9999,  &
0.9526, 0.9526, 0.9526, 0.9526, 0.9526, 0.9610, 0.9713, 0.9937, 0.9999 /
data ((cldnuctab( 7,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9919, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9908, 0.9919, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9896, 0.9908, 0.9919, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9896, 0.9896, 0.9908, 0.9919, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9868, 0.9868, 0.9883, 0.9896, 0.9919, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.9792, 0.9792, 0.9792, 0.9814, 0.9834, 0.9883, 0.9972, 0.9999, 0.9999,  &
0.9570, 0.9570, 0.9570, 0.9570, 0.9610, 0.9647, 0.9742, 0.9919, 0.9999 /
data ((cldnuctab( 7,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9928, 0.9951, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9919, 0.9928, 0.9957, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9908, 0.9919, 0.9928, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9908, 0.9908, 0.9908, 0.9928, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9883, 0.9883, 0.9883, 0.9896, 0.9919, 0.9963, 0.9999, 0.9999, 0.9999,  &
0.9814, 0.9814, 0.9814, 0.9834, 0.9852, 0.9883, 0.9963, 0.9999, 0.9999,  &
0.9610, 0.9610, 0.9610, 0.9610, 0.9647, 0.9681, 0.9742, 0.9908, 0.9999 /
data ((cldnuctab( 8,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9759, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.9846, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8550, 0.8841, 0.9878, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8330, 0.8443, 0.8928, 0.9759, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8213, 0.8213, 0.8443, 0.8928, 0.9294, 0.9966, 0.9999, 0.9999, 0.9999,  &
0.7693, 0.7693, 0.7830, 0.8090, 0.8841, 0.9011, 0.8443, 0.9702, 0.9999,  &
0.6776, 0.6776, 0.6776, 0.6939, 0.7253, 0.7963, 0.9462, 0.6609, 0.7551 /
data ((cldnuctab( 8,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9596, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8749, 0.9702, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8652, 0.8841, 0.9784, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8443, 0.8550, 0.8841, 0.9784, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8330, 0.8443, 0.8550, 0.8841, 0.9555, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.8090, 0.8090, 0.8213, 0.8443, 0.8928, 0.9410, 0.9596, 0.9999, 0.9999,  &
0.7404, 0.7551, 0.7551, 0.7693, 0.7963, 0.8550, 0.9784, 0.7551, 0.8841 /
data ((cldnuctab( 8,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.9354, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.9510, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8652, 0.8841, 0.9635, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8550, 0.8652, 0.8841, 0.9670, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8443, 0.8550, 0.8652, 0.8841, 0.9596, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.8330, 0.8330, 0.8443, 0.8550, 0.8928, 0.9510, 0.9915, 0.9999, 0.9999,  &
0.7963, 0.7963, 0.7963, 0.8090, 0.8330, 0.8841, 0.9759, 0.8550, 0.9702 /
data ((cldnuctab( 8,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.9088, 0.9949, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.9230, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8749, 0.8841, 0.9410, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8652, 0.8749, 0.8928, 0.9510, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8550, 0.8652, 0.8652, 0.8928, 0.9510, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.8550, 0.8550, 0.8550, 0.8652, 0.8841, 0.9510, 0.9955, 0.9999, 0.9999,  &
0.8213, 0.8213, 0.8330, 0.8330, 0.8550, 0.8841, 0.9670, 0.9088, 0.9949 /
data ((cldnuctab( 8,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.8928, 0.9915, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.9011, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8749, 0.8928, 0.9161, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8749, 0.8749, 0.8928, 0.9354, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8652, 0.8652, 0.8749, 0.8928, 0.9410, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.8652, 0.8652, 0.8652, 0.8749, 0.8928, 0.9410, 0.9949, 0.9999, 0.9999,  &
0.8443, 0.8443, 0.8443, 0.8550, 0.8652, 0.8841, 0.9510, 0.9410, 0.9990 /
data ((cldnuctab( 8,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.8928, 0.9878, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8928, 0.9011, 0.9934, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.8928, 0.9161, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8749, 0.8841, 0.8928, 0.9294, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8749, 0.8749, 0.8841, 0.8928, 0.9354, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.8652, 0.8749, 0.8749, 0.8841, 0.8928, 0.9354, 0.9925, 0.9999, 0.9999,  &
0.8550, 0.8550, 0.8550, 0.8550, 0.8652, 0.8928, 0.9354, 0.9635, 0.9996 /
data ((cldnuctab( 8,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.9011, 0.9827, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8928, 0.9088, 0.9904, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8928, 0.9011, 0.9161, 0.9934, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.8928, 0.9011, 0.9230, 0.9955, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.8841, 0.8841, 0.9011, 0.9294, 0.9955, 0.9999, 0.9999, 0.9999,  &
0.8749, 0.8749, 0.8841, 0.8841, 0.8928, 0.9294, 0.9904, 0.9999, 0.9999,  &
0.8652, 0.8652, 0.8652, 0.8652, 0.8749, 0.8928, 0.9294, 0.9807, 0.9996 /
data ((cldnuctab( 8,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9732, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9807, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9161, 0.9354, 0.9807, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9088, 0.9161, 0.9294, 0.9759, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8841, 0.8841, 0.9011, 0.9294, 0.9878, 0.9827, 0.9999, 0.9999, 0.9999,  &
0.8213, 0.8213, 0.8330, 0.8550, 0.8928, 0.9759, 0.8550, 0.9462, 0.9999,  &
0.7253, 0.7253, 0.7404, 0.7404, 0.7693, 0.8090, 0.9088, 0.7253, 0.7830 /
data ((cldnuctab( 8,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9555, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9670, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9230, 0.9354, 0.9759, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9161, 0.9230, 0.9294, 0.9759, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9011, 0.9088, 0.9161, 0.9354, 0.9759, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.8652, 0.8749, 0.8749, 0.8928, 0.9230, 0.9807, 0.9410, 0.9974, 0.9999,  &
0.7963, 0.7963, 0.7963, 0.8090, 0.8213, 0.8652, 0.9510, 0.7963, 0.8749 /
data ((cldnuctab( 8,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9462, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9555, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9294, 0.9354, 0.9670, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9230, 0.9230, 0.9354, 0.9702, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9161, 0.9161, 0.9230, 0.9354, 0.9702, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9011, 0.9011, 0.9011, 0.9088, 0.9354, 0.9759, 0.9784, 0.9999, 0.9999,  &
0.8443, 0.8550, 0.8550, 0.8550, 0.8749, 0.9011, 0.9670, 0.8841, 0.9462 /
data ((cldnuctab( 8,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.9462, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9410, 0.9510, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9410, 0.9596, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9294, 0.9294, 0.9410, 0.9635, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9230, 0.9230, 0.9294, 0.9354, 0.9635, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.9088, 0.9161, 0.9161, 0.9230, 0.9354, 0.9670, 0.9878, 0.9999, 0.9999,  &
0.8749, 0.8841, 0.8841, 0.8841, 0.8928, 0.9161, 0.9670, 0.9670, 0.9784 /
data ((cldnuctab( 8,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.9462, 0.9949, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9410, 0.9510, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9410, 0.9555, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9294, 0.9354, 0.9410, 0.9596, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9294, 0.9294, 0.9354, 0.9410, 0.9596, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9230, 0.9230, 0.9230, 0.9294, 0.9410, 0.9596, 0.9934, 0.9999, 0.9999,  &
0.8928, 0.8928, 0.9011, 0.9011, 0.9088, 0.9230, 0.9596, 0.9915, 0.9925 /
data ((cldnuctab( 8,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.9462, 0.9925, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9462, 0.9510, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9410, 0.9462, 0.9555, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9410, 0.9462, 0.9596, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9354, 0.9410, 0.9462, 0.9596, 0.9961, 0.9999, 0.9999, 0.9999,  &
0.9294, 0.9294, 0.9294, 0.9354, 0.9410, 0.9596, 0.9934, 0.9999, 0.9999,  &
0.9088, 0.9088, 0.9088, 0.9088, 0.9161, 0.9294, 0.9555, 0.9934, 0.9961 /
data ((cldnuctab( 8,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.9510, 0.9892, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9462, 0.9555, 0.9925, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9462, 0.9462, 0.9555, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9410, 0.9410, 0.9462, 0.9596, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9410, 0.9410, 0.9410, 0.9462, 0.9596, 0.9934, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9354, 0.9354, 0.9410, 0.9462, 0.9596, 0.9925, 0.9999, 0.9999,  &
0.9161, 0.9161, 0.9161, 0.9161, 0.9230, 0.9294, 0.9555, 0.9925, 0.9966 /
data ((cldnuctab( 8,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9784, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9670, 0.9827, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9596, 0.9635, 0.9827, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9462, 0.9510, 0.9635, 0.9863, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9230, 0.9230, 0.9294, 0.9510, 0.9846, 0.9732, 0.9994, 0.9999, 0.9999,  &
0.8652, 0.8652, 0.8652, 0.8841, 0.9088, 0.9596, 0.9998, 0.9354, 0.9966,  &
0.7963, 0.7963, 0.7963, 0.7963, 0.8090, 0.8443, 0.9011, 0.9732, 0.8443 /
data ((cldnuctab( 8,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9759, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9670, 0.9807, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9807, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9555, 0.9596, 0.9670, 0.9827, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9410, 0.9462, 0.9510, 0.9635, 0.9846, 0.9934, 0.9999, 0.9999, 0.9999,  &
0.9088, 0.9088, 0.9161, 0.9230, 0.9410, 0.9759, 0.9904, 0.9863, 0.9999,  &
0.8443, 0.8443, 0.8443, 0.8550, 0.8652, 0.8841, 0.9410, 0.9977, 0.8928 /
data ((cldnuctab( 8,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9759, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9784, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9635, 0.9702, 0.9807, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9670, 0.9807, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9555, 0.9555, 0.9596, 0.9670, 0.9827, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9354, 0.9354, 0.9410, 0.9555, 0.9807, 0.9974, 0.9989, 0.9999,  &
0.8841, 0.8841, 0.8841, 0.8928, 0.9011, 0.9161, 0.9596, 0.9993, 0.9410 /
data ((cldnuctab( 8,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9759, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9732, 0.9784, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9702, 0.9784, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9670, 0.9670, 0.9702, 0.9784, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9635, 0.9702, 0.9784, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9510, 0.9510, 0.9510, 0.9555, 0.9635, 0.9807, 0.9980, 0.9999, 0.9999,  &
0.9161, 0.9161, 0.9161, 0.9161, 0.9230, 0.9354, 0.9670, 0.9989, 0.9702 /
data ((cldnuctab( 8,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.9759, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9732, 0.9784, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9732, 0.9784, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9702, 0.9732, 0.9784, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9670, 0.9670, 0.9702, 0.9732, 0.9784, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.9555, 0.9555, 0.9596, 0.9596, 0.9670, 0.9784, 0.9974, 0.9999, 0.9999,  &
0.9294, 0.9294, 0.9294, 0.9294, 0.9354, 0.9462, 0.9670, 0.9977, 0.9827 /
data ((cldnuctab( 8,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.9784, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9759, 0.9784, 0.9955, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9732, 0.9759, 0.9807, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9732, 0.9732, 0.9732, 0.9807, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9702, 0.9702, 0.9732, 0.9784, 0.9955, 0.9999, 0.9999, 0.9999,  &
0.9596, 0.9635, 0.9635, 0.9635, 0.9702, 0.9784, 0.9961, 0.9999, 0.9999,  &
0.9354, 0.9354, 0.9410, 0.9410, 0.9410, 0.9510, 0.9670, 0.9955, 0.9915 /
data ((cldnuctab( 8,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.9784, 0.9915, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9759, 0.9807, 0.9925, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9759, 0.9759, 0.9807, 0.9934, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9732, 0.9759, 0.9759, 0.9807, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9732, 0.9732, 0.9732, 0.9759, 0.9807, 0.9942, 0.9999, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9670, 0.9670, 0.9702, 0.9784, 0.9942, 0.9999, 0.9999,  &
0.9410, 0.9410, 0.9410, 0.9462, 0.9462, 0.9555, 0.9670, 0.9934, 0.9987 /
data ((cldnuctab( 8,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9904, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9846, 0.9904, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9807, 0.9846, 0.9904, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9732, 0.9784, 0.9915, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9462, 0.9462, 0.9510, 0.9635, 0.9827, 0.9998, 0.9955, 0.9999, 0.9999,  &
0.9011, 0.9011, 0.9011, 0.9088, 0.9230, 0.9555, 0.9966, 0.9462, 0.9915,  &
0.8550, 0.8550, 0.8652, 0.8652, 0.8652, 0.8841, 0.9161, 0.9635, 0.9878 /
data ((cldnuctab( 8,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9904, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9846, 0.9904, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9827, 0.9846, 0.9892, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9784, 0.9807, 0.9846, 0.9904, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9670, 0.9670, 0.9702, 0.9759, 0.9892, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.9354, 0.9354, 0.9354, 0.9410, 0.9510, 0.9759, 0.9992, 0.9807, 0.9998,  &
0.8928, 0.8928, 0.8928, 0.8928, 0.9011, 0.9088, 0.9410, 0.9878, 0.9294 /
data ((cldnuctab( 8,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9904, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9878, 0.9904, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9863, 0.9904, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9827, 0.9846, 0.9863, 0.9904, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9759, 0.9759, 0.9784, 0.9827, 0.9904, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9555, 0.9555, 0.9596, 0.9596, 0.9670, 0.9827, 0.9993, 0.9955, 0.9999,  &
0.9161, 0.9161, 0.9161, 0.9230, 0.9230, 0.9354, 0.9596, 0.9942, 0.9555 /
data ((cldnuctab( 8,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9904, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9904, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9878, 0.9904, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9863, 0.9878, 0.9904, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9807, 0.9827, 0.9827, 0.9863, 0.9904, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9702, 0.9702, 0.9732, 0.9759, 0.9863, 0.9989, 0.9987, 0.9999,  &
0.9410, 0.9410, 0.9410, 0.9410, 0.9410, 0.9510, 0.9670, 0.9949, 0.9807 /
data ((cldnuctab( 8,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9904, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9915, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9878, 0.9892, 0.9915, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9878, 0.9878, 0.9892, 0.9904, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9846, 0.9846, 0.9863, 0.9878, 0.9904, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9759, 0.9759, 0.9759, 0.9784, 0.9807, 0.9878, 0.9980, 0.9997, 0.9999,  &
0.9510, 0.9510, 0.9510, 0.9510, 0.9555, 0.9596, 0.9732, 0.9942, 0.9997 /
data ((cldnuctab( 8,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9915, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9904, 0.9915, 0.9955, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9904, 0.9915, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9892, 0.9892, 0.9915, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9863, 0.9878, 0.9892, 0.9915, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.9784, 0.9784, 0.9784, 0.9807, 0.9827, 0.9878, 0.9970, 0.9999, 0.9999,  &
0.9555, 0.9555, 0.9555, 0.9596, 0.9596, 0.9635, 0.9732, 0.9925, 0.9999 /
data ((cldnuctab( 8,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9915, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9915, 0.9925, 0.9955, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9904, 0.9904, 0.9925, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9904, 0.9904, 0.9915, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9878, 0.9878, 0.9878, 0.9892, 0.9915, 0.9961, 0.9999, 0.9999, 0.9999,  &
0.9807, 0.9807, 0.9807, 0.9827, 0.9846, 0.9892, 0.9961, 0.9999, 0.9999,  &
0.9596, 0.9596, 0.9596, 0.9596, 0.9635, 0.9670, 0.9759, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9942, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9904, 0.9934, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9878, 0.9904, 0.9942, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9784, 0.9807, 0.9846, 0.9925, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9555, 0.9555, 0.9596, 0.9670, 0.9827, 0.9994, 0.9942, 0.9999, 0.9999,  &
0.9230, 0.9230, 0.9230, 0.9294, 0.9410, 0.9596, 0.9925, 0.9635, 0.9892,  &
0.8928, 0.8928, 0.8928, 0.8928, 0.9011, 0.9088, 0.9354, 0.9670, 0.9846 /
data ((cldnuctab( 8,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9942, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9915, 0.9942, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9904, 0.9915, 0.9942, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9878, 0.9892, 0.9942, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9732, 0.9759, 0.9759, 0.9807, 0.9904, 0.9996, 0.9995, 0.9999, 0.9999,  &
0.9462, 0.9462, 0.9510, 0.9510, 0.9596, 0.9759, 0.9974, 0.9827, 0.9990,  &
0.9161, 0.9161, 0.9161, 0.9161, 0.9161, 0.9294, 0.9510, 0.9846, 0.9997 /
data ((cldnuctab( 8,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9942, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9942, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9915, 0.9925, 0.9942, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9904, 0.9915, 0.9942, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9827, 0.9846, 0.9846, 0.9878, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9670, 0.9670, 0.9670, 0.9702, 0.9732, 0.9846, 0.9985, 0.9955, 0.9999,  &
0.9354, 0.9354, 0.9354, 0.9354, 0.9410, 0.9462, 0.9635, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9949, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9934, 0.9949, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9934, 0.9949, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9915, 0.9915, 0.9925, 0.9942, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9878, 0.9878, 0.9892, 0.9904, 0.9934, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9759, 0.9759, 0.9759, 0.9784, 0.9807, 0.9878, 0.9983, 0.9995, 0.9999,  &
0.9510, 0.9510, 0.9510, 0.9510, 0.9555, 0.9596, 0.9702, 0.9925, 0.9999 /
data ((cldnuctab( 8,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9949, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9949, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9934, 0.9942, 0.9949, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9934, 0.9934, 0.9949, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9904, 0.9904, 0.9904, 0.9915, 0.9942, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.9807, 0.9807, 0.9827, 0.9827, 0.9846, 0.9904, 0.9977, 0.9999, 0.9999,  &
0.9596, 0.9596, 0.9596, 0.9596, 0.9635, 0.9670, 0.9759, 0.9915, 0.9999 /
data ((cldnuctab( 8,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9955, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9955, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9942, 0.9955, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9934, 0.9934, 0.9942, 0.9949, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9915, 0.9915, 0.9915, 0.9925, 0.9949, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9846, 0.9846, 0.9846, 0.9846, 0.9878, 0.9904, 0.9970, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9670, 0.9670, 0.9670, 0.9702, 0.9784, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9955, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9955, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9949, 0.9955, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9942, 0.9949, 0.9955, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9925, 0.9925, 0.9934, 0.9949, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9863, 0.9863, 0.9863, 0.9878, 0.9915, 0.9966, 0.9999, 0.9999,  &
0.9670, 0.9670, 0.9670, 0.9702, 0.9702, 0.9732, 0.9784, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9955, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9955, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9915, 0.9925, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9827, 0.9846, 0.9878, 0.9934, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9670, 0.9732, 0.9827, 0.9987, 0.9934, 0.9999, 0.9999,  &
0.9354, 0.9354, 0.9354, 0.9410, 0.9462, 0.9635, 0.9904, 0.9999, 0.9904,  &
0.9161, 0.9161, 0.9161, 0.9161, 0.9230, 0.9294, 0.9462, 0.9702, 0.9846 /
data ((cldnuctab( 8,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9961, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9955, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9934, 0.9942, 0.9961, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9904, 0.9925, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9784, 0.9784, 0.9807, 0.9846, 0.9904, 0.9994, 0.9992, 0.9999, 0.9999,  &
0.9555, 0.9555, 0.9555, 0.9596, 0.9635, 0.9759, 0.9961, 0.9999, 0.9985,  &
0.9294, 0.9294, 0.9294, 0.9294, 0.9354, 0.9410, 0.9555, 0.9827, 0.9992 /
data ((cldnuctab( 8,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9961, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9961, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9949, 0.9961, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9934, 0.9942, 0.9961, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9878, 0.9878, 0.9904, 0.9942, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9702, 0.9702, 0.9732, 0.9732, 0.9784, 0.9846, 0.9977, 0.9999, 0.9999,  &
0.9462, 0.9462, 0.9462, 0.9462, 0.9510, 0.9555, 0.9670, 0.9892, 0.9999 /
data ((cldnuctab( 8,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9966, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9966, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9955, 0.9961, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9942, 0.9949, 0.9961, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9904, 0.9904, 0.9915, 0.9925, 0.9949, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9807, 0.9807, 0.9807, 0.9827, 0.9846, 0.9892, 0.9980, 0.9999, 0.9999,  &
0.9596, 0.9596, 0.9596, 0.9596, 0.9596, 0.9635, 0.9732, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9966, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9961, 0.9966, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9961, 0.9961, 0.9966, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9955, 0.9955, 0.9966, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9925, 0.9934, 0.9942, 0.9955, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.9846, 0.9846, 0.9846, 0.9863, 0.9878, 0.9915, 0.9977, 0.9999, 0.9999,  &
0.9670, 0.9670, 0.9670, 0.9670, 0.9670, 0.9702, 0.9784, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9970, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9966, 0.9970, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9961, 0.9966, 0.9970, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9961, 0.9961, 0.9970, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9934, 0.9942, 0.9942, 0.9949, 0.9961, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.9878, 0.9878, 0.9878, 0.9878, 0.9892, 0.9925, 0.9974, 0.9999, 0.9999,  &
0.9702, 0.9702, 0.9702, 0.9702, 0.9702, 0.9732, 0.9784, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9974, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9974, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9966, 0.9970, 0.9970, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9961, 0.9961, 0.9966, 0.9970, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9942, 0.9949, 0.9955, 0.9966, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9892, 0.9892, 0.9892, 0.9904, 0.9925, 0.9970, 0.9999, 0.9999,  &
0.9732, 0.9732, 0.9732, 0.9732, 0.9732, 0.9759, 0.9807, 0.9904, 0.9998 /
data ((cldnuctab( 8,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9970, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9966, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9942, 0.9966, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9846, 0.9863, 0.9892, 0.9942, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9670, 0.9702, 0.9702, 0.9759, 0.9846, 0.9980, 0.9942, 0.9999, 0.9999,  &
0.9462, 0.9462, 0.9462, 0.9510, 0.9555, 0.9670, 0.9904, 0.9999, 0.9925,  &
0.9294, 0.9294, 0.9294, 0.9354, 0.9354, 0.9410, 0.9510, 0.9732, 0.9846 /
data ((cldnuctab( 8,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9970, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9961, 0.9970, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9955, 0.9970, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9915, 0.9925, 0.9934, 0.9961, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9807, 0.9827, 0.9827, 0.9863, 0.9915, 0.9992, 0.9993, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9635, 0.9635, 0.9702, 0.9784, 0.9949, 0.9999, 0.9983,  &
0.9410, 0.9410, 0.9410, 0.9410, 0.9462, 0.9510, 0.9635, 0.9827, 0.9985 /
data ((cldnuctab( 8,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9974, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9966, 0.9974, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9961, 0.9966, 0.9970, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9949, 0.9955, 0.9970, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9892, 0.9904, 0.9915, 0.9949, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9759, 0.9759, 0.9759, 0.9759, 0.9807, 0.9863, 0.9970, 0.9999, 0.9999,  &
0.9555, 0.9555, 0.9555, 0.9555, 0.9555, 0.9596, 0.9702, 0.9878, 0.9999 /
data ((cldnuctab( 8,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9974, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9974, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9966, 0.9970, 0.9974, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9961, 0.9966, 0.9974, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9925, 0.9925, 0.9934, 0.9942, 0.9961, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9827, 0.9827, 0.9827, 0.9846, 0.9863, 0.9904, 0.9974, 0.9999, 0.9999,  &
0.9635, 0.9635, 0.9635, 0.9635, 0.9670, 0.9702, 0.9759, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9977, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9977, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9974, 0.9977, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9966, 0.9966, 0.9970, 0.9974, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9942, 0.9942, 0.9942, 0.9949, 0.9966, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.9863, 0.9863, 0.9878, 0.9878, 0.9892, 0.9925, 0.9974, 0.9999, 0.9999,  &
0.9702, 0.9702, 0.9702, 0.9702, 0.9702, 0.9732, 0.9807, 0.9904, 0.9999 /
data ((cldnuctab( 8,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9980, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9980, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9974, 0.9977, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9970, 0.9974, 0.9977, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9949, 0.9949, 0.9955, 0.9961, 0.9970, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9892, 0.9892, 0.9892, 0.9904, 0.9934, 0.9974, 0.9999, 0.9999,  &
0.9732, 0.9732, 0.9732, 0.9732, 0.9759, 0.9759, 0.9807, 0.9904, 0.9998 /
data ((cldnuctab( 8,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9980, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9980, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9977, 0.9980, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9974, 0.9974, 0.9980, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9955, 0.9961, 0.9961, 0.9970, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.9904, 0.9904, 0.9904, 0.9904, 0.9915, 0.9934, 0.9970, 0.9999, 0.9999,  &
0.9759, 0.9759, 0.9759, 0.9759, 0.9759, 0.9784, 0.9827, 0.9904, 0.9995 /
data ((cldnuctab( 9,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9756, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9592, 0.9804, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9505, 0.9592, 0.9825, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9404, 0.9457, 0.9592, 0.9844, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9154, 0.9223, 0.9287, 0.9505, 0.9861, 0.9756, 0.9997, 0.9999, 0.9999,  &
0.8642, 0.8642, 0.8739, 0.8832, 0.9080, 0.9666, 0.9080, 0.9457, 0.9985,  &
0.8077, 0.8077, 0.8077, 0.8077, 0.8200, 0.8539, 0.9080, 0.9804, 0.8539 /
data ((cldnuctab( 9,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9729, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9631, 0.9782, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9551, 0.9631, 0.9804, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9505, 0.9551, 0.9592, 0.9804, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9404, 0.9404, 0.9457, 0.9592, 0.9844, 0.9941, 0.9999, 0.9999, 0.9999,  &
0.9080, 0.9080, 0.9080, 0.9223, 0.9404, 0.9782, 0.9592, 0.9914, 0.9999,  &
0.8539, 0.8539, 0.8539, 0.8539, 0.8642, 0.8919, 0.9457, 0.9992, 0.9002 /
data ((cldnuctab( 9,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.9699, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9631, 0.9756, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9592, 0.9631, 0.9756, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9551, 0.9592, 0.9631, 0.9782, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9505, 0.9505, 0.9551, 0.9631, 0.9782, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9287, 0.9348, 0.9348, 0.9404, 0.9551, 0.9804, 0.9903, 0.9996, 0.9999,  &
0.8919, 0.8919, 0.8919, 0.8919, 0.9002, 0.9223, 0.9631, 0.9997, 0.9457 /
data ((cldnuctab( 9,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.9699, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9666, 0.9729, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9631, 0.9666, 0.9756, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9592, 0.9631, 0.9631, 0.9756, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9551, 0.9592, 0.9592, 0.9666, 0.9756, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9457, 0.9457, 0.9457, 0.9505, 0.9592, 0.9782, 0.9965, 0.9999, 0.9999,  &
0.9154, 0.9154, 0.9154, 0.9154, 0.9223, 0.9348, 0.9666, 0.9994, 0.9756 /
data ((cldnuctab( 9,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.9729, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9699, 0.9729, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9666, 0.9699, 0.9756, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9631, 0.9631, 0.9666, 0.9756, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9592, 0.9631, 0.9631, 0.9666, 0.9756, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.9505, 0.9505, 0.9551, 0.9551, 0.9631, 0.9756, 0.9965, 0.9999, 0.9999,  &
0.9287, 0.9287, 0.9287, 0.9287, 0.9348, 0.9457, 0.9666, 0.9985, 0.9861 /
data ((cldnuctab( 9,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.9729, 0.9941, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9699, 0.9756, 0.9955, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9666, 0.9699, 0.9756, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9666, 0.9666, 0.9699, 0.9756, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9631, 0.9631, 0.9666, 0.9699, 0.9756, 0.9955, 0.9999, 0.9999, 0.9999,  &
0.9551, 0.9592, 0.9592, 0.9592, 0.9666, 0.9756, 0.9955, 0.9999, 0.9999,  &
0.9348, 0.9348, 0.9348, 0.9348, 0.9404, 0.9505, 0.9666, 0.9965, 0.9933 /
data ((cldnuctab( 9,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.9756, 0.9914, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9729, 0.9756, 0.9933, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9699, 0.9729, 0.9756, 0.9941, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9699, 0.9699, 0.9729, 0.9756, 0.9941, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9666, 0.9666, 0.9699, 0.9699, 0.9756, 0.9941, 0.9999, 0.9999, 0.9999,  &
0.9592, 0.9592, 0.9631, 0.9631, 0.9666, 0.9756, 0.9941, 0.9999, 0.9999,  &
0.9404, 0.9404, 0.9404, 0.9404, 0.9457, 0.9505, 0.9666, 0.9941, 0.9965 /
data ((cldnuctab( 9,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9876, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9804, 0.9890, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9782, 0.9804, 0.9876, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9666, 0.9699, 0.9782, 0.9903, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9404, 0.9457, 0.9505, 0.9592, 0.9844, 0.9999, 0.9970, 0.9999, 0.9999,  &
0.9002, 0.9002, 0.9002, 0.9080, 0.9223, 0.9592, 0.9983, 0.9505, 0.9924,  &
0.8539, 0.8539, 0.8642, 0.8642, 0.8642, 0.8832, 0.9154, 0.9666, 0.9914 /
data ((cldnuctab( 9,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9876, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9825, 0.9876, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9804, 0.9825, 0.9890, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9756, 0.9782, 0.9804, 0.9890, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9631, 0.9631, 0.9666, 0.9756, 0.9890, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9348, 0.9348, 0.9348, 0.9404, 0.9505, 0.9756, 0.9996, 0.9844, 0.9999,  &
0.8832, 0.8919, 0.8919, 0.8919, 0.9002, 0.9080, 0.9404, 0.9914, 0.9287 /
data ((cldnuctab( 9,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9876, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9876, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9825, 0.9825, 0.9890, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9804, 0.9804, 0.9825, 0.9876, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9729, 0.9729, 0.9756, 0.9804, 0.9890, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9551, 0.9551, 0.9551, 0.9592, 0.9666, 0.9825, 0.9995, 0.9965, 0.9999,  &
0.9154, 0.9154, 0.9154, 0.9154, 0.9223, 0.9348, 0.9592, 0.9965, 0.9551 /
data ((cldnuctab( 9,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.9876, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9890, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9844, 0.9890, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9825, 0.9825, 0.9844, 0.9890, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9782, 0.9782, 0.9804, 0.9825, 0.9890, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.9666, 0.9666, 0.9666, 0.9699, 0.9756, 0.9861, 0.9992, 0.9994, 0.9999,  &
0.9348, 0.9348, 0.9348, 0.9404, 0.9404, 0.9505, 0.9699, 0.9965, 0.9729 /
data ((cldnuctab( 9,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.9890, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9890, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9861, 0.9890, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9844, 0.9861, 0.9890, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9825, 0.9825, 0.9825, 0.9844, 0.9890, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9729, 0.9729, 0.9729, 0.9756, 0.9782, 0.9861, 0.9983, 0.9997, 0.9999,  &
0.9457, 0.9505, 0.9505, 0.9505, 0.9505, 0.9592, 0.9729, 0.9955, 0.9914 /
data ((cldnuctab( 9,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.9890, 0.9948, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9890, 0.9948, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9876, 0.9890, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9861, 0.9876, 0.9890, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9844, 0.9844, 0.9861, 0.9890, 0.9965, 0.9999, 0.9999, 0.9999,  &
0.9756, 0.9756, 0.9756, 0.9782, 0.9804, 0.9861, 0.9970, 0.9999, 0.9999,  &
0.9551, 0.9551, 0.9551, 0.9551, 0.9592, 0.9631, 0.9729, 0.9933, 0.9998 /
data ((cldnuctab( 9,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.9903, 0.9924, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9903, 0.9941, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9890, 0.9903, 0.9955, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9876, 0.9876, 0.9903, 0.9955, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9861, 0.9861, 0.9876, 0.9903, 0.9955, 0.9999, 0.9999, 0.9999,  &
0.9782, 0.9782, 0.9782, 0.9804, 0.9825, 0.9876, 0.9960, 0.9999, 0.9999,  &
0.9592, 0.9592, 0.9592, 0.9592, 0.9592, 0.9666, 0.9756, 0.9914, 0.9999 /
data ((cldnuctab( 9,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9948, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9941, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9914, 0.9948, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9804, 0.9825, 0.9861, 0.9933, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9592, 0.9631, 0.9631, 0.9699, 0.9844, 0.9992, 0.9933, 0.9999, 0.9999,  &
0.9348, 0.9348, 0.9348, 0.9348, 0.9457, 0.9631, 0.9924, 0.9999, 0.9903,  &
0.9080, 0.9080, 0.9080, 0.9154, 0.9154, 0.9223, 0.9404, 0.9699, 0.9861 /
data ((cldnuctab( 9,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9948, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9948, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9924, 0.9948, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9890, 0.9903, 0.9948, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9756, 0.9782, 0.9782, 0.9825, 0.9903, 0.9995, 0.9995, 0.9999, 0.9999,  &
0.9551, 0.9551, 0.9551, 0.9551, 0.9631, 0.9756, 0.9970, 0.9861, 0.9989,  &
0.9223, 0.9223, 0.9287, 0.9287, 0.9287, 0.9348, 0.9551, 0.9844, 0.9996 /
data ((cldnuctab( 9,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9955, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9955, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9948, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9924, 0.9948, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9861, 0.9861, 0.9890, 0.9933, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9699, 0.9699, 0.9699, 0.9729, 0.9756, 0.9844, 0.9983, 0.9960, 0.9999,  &
0.9404, 0.9404, 0.9404, 0.9457, 0.9457, 0.9505, 0.9666, 0.9903, 0.9999 /
data ((cldnuctab( 9,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9955, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9955, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9955, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9933, 0.9941, 0.9955, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9903, 0.9914, 0.9941, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9782, 0.9782, 0.9782, 0.9804, 0.9825, 0.9890, 0.9983, 0.9999, 0.9999,  &
0.9551, 0.9551, 0.9551, 0.9551, 0.9592, 0.9631, 0.9729, 0.9914, 0.9999 /
data ((cldnuctab( 9,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.9960, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9960, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9960, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9948, 0.9955, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9924, 0.9933, 0.9948, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.9825, 0.9825, 0.9844, 0.9844, 0.9861, 0.9903, 0.9977, 0.9999, 0.9999,  &
0.9631, 0.9631, 0.9631, 0.9631, 0.9666, 0.9699, 0.9756, 0.9914, 0.9999 /
data ((cldnuctab( 9,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.9960, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9960, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9955, 0.9960, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9955, 0.9960, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9924, 0.9933, 0.9941, 0.9955, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9861, 0.9861, 0.9861, 0.9876, 0.9914, 0.9974, 0.9999, 0.9999,  &
0.9699, 0.9699, 0.9699, 0.9699, 0.9699, 0.9729, 0.9782, 0.9914, 0.9999 /
data ((cldnuctab( 9,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.9965, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9965, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9960, 0.9965, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9955, 0.9955, 0.9960, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9933, 0.9941, 0.9955, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9876, 0.9876, 0.9876, 0.9890, 0.9924, 0.9970, 0.9999, 0.9999,  &
0.9699, 0.9699, 0.9699, 0.9729, 0.9729, 0.9756, 0.9804, 0.9903, 0.9999 /
data ((cldnuctab( 9,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9977, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9980, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9955, 0.9974, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9890, 0.9914, 0.9948, 0.9995, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.9756, 0.9756, 0.9756, 0.9804, 0.9861, 0.9974, 0.9999, 0.9997, 0.9999,  &
0.9592, 0.9592, 0.9592, 0.9631, 0.9666, 0.9756, 0.9903, 0.9996, 0.9999,  &
0.9505, 0.9505, 0.9505, 0.9505, 0.9551, 0.9592, 0.9666, 0.9782, 0.9876 /
data ((cldnuctab( 9,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9983, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9980, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9970, 0.9980, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9941, 0.9948, 0.9970, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9861, 0.9861, 0.9876, 0.9924, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.9699, 0.9699, 0.9699, 0.9729, 0.9756, 0.9825, 0.9941, 0.9999, 0.9980,  &
0.9592, 0.9592, 0.9592, 0.9592, 0.9592, 0.9631, 0.9699, 0.9861, 0.9977 /
data ((cldnuctab( 9,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9983, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9980, 0.9983, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9977, 0.9983, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9960, 0.9965, 0.9977, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9924, 0.9933, 0.9955, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9804, 0.9804, 0.9804, 0.9804, 0.9825, 0.9876, 0.9965, 0.9999, 0.9998,  &
0.9666, 0.9666, 0.9666, 0.9666, 0.9666, 0.9699, 0.9756, 0.9890, 0.9997 /
data ((cldnuctab( 9,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9985, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9985, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9980, 0.9980, 0.9985, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9974, 0.9974, 0.9983, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9948, 0.9955, 0.9970, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9861, 0.9861, 0.9876, 0.9890, 0.9914, 0.9974, 0.9999, 0.9999,  &
0.9729, 0.9729, 0.9729, 0.9729, 0.9729, 0.9756, 0.9804, 0.9903, 0.9999 /
data ((cldnuctab( 9,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9987, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9985, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9983, 0.9985, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9977, 0.9980, 0.9985, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9955, 0.9960, 0.9965, 0.9974, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9903, 0.9914, 0.9933, 0.9974, 0.9999, 0.9999,  &
0.9756, 0.9756, 0.9756, 0.9756, 0.9782, 0.9782, 0.9825, 0.9914, 0.9998 /
data ((cldnuctab( 9,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9987, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9985, 0.9987, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9985, 0.9985, 0.9987, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9980, 0.9980, 0.9983, 0.9985, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9965, 0.9965, 0.9970, 0.9977, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9914, 0.9914, 0.9924, 0.9941, 0.9974, 0.9999, 0.9999,  &
0.9782, 0.9782, 0.9782, 0.9804, 0.9804, 0.9804, 0.9844, 0.9914, 0.9995 /
data ((cldnuctab( 9,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9989, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9987, 0.9989, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9985, 0.9987, 0.9989, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9983, 0.9985, 0.9987, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9970, 0.9970, 0.9974, 0.9980, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9924, 0.9924, 0.9924, 0.9933, 0.9948, 0.9974, 0.9999, 0.9999,  &
0.9804, 0.9804, 0.9804, 0.9804, 0.9804, 0.9825, 0.9861, 0.9914, 0.9990 /
data ((cldnuctab( 9,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9989, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9989, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9970, 0.9983, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9933, 0.9955, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9825, 0.9825, 0.9825, 0.9844, 0.9890, 0.9965, 0.9999, 0.9995, 0.9999,  &
0.9729, 0.9729, 0.9729, 0.9756, 0.9756, 0.9825, 0.9914, 0.9992, 0.9999,  &
0.9699, 0.9699, 0.9699, 0.9699, 0.9699, 0.9729, 0.9756, 0.9844, 0.9903 /
data ((cldnuctab( 9,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9990, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9987, 0.9990, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9980, 0.9983, 0.9989, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9955, 0.9965, 0.9977, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9914, 0.9933, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.9782, 0.9804, 0.9804, 0.9804, 0.9825, 0.9861, 0.9941, 0.9999, 0.9999,  &
0.9729, 0.9729, 0.9729, 0.9729, 0.9729, 0.9756, 0.9804, 0.9876, 0.9970 /
data ((cldnuctab( 9,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9992, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9989, 0.9990, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9985, 0.9987, 0.9990, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9974, 0.9977, 0.9985, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9941, 0.9948, 0.9965, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9861, 0.9861, 0.9861, 0.9876, 0.9903, 0.9960, 0.9999, 0.9996,  &
0.9756, 0.9756, 0.9756, 0.9756, 0.9782, 0.9782, 0.9825, 0.9903, 0.9993 /
data ((cldnuctab( 9,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9993, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9992, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9989, 0.9990, 0.9992, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9983, 0.9985, 0.9989, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9960, 0.9960, 0.9965, 0.9974, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9903, 0.9903, 0.9914, 0.9933, 0.9970, 0.9999, 0.9999,  &
0.9804, 0.9804, 0.9804, 0.9804, 0.9804, 0.9825, 0.9844, 0.9914, 0.9995 /
data ((cldnuctab( 9,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9993, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9993, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9992, 0.9993, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9985, 0.9987, 0.9987, 0.9990, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9970, 0.9970, 0.9974, 0.9980, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9924, 0.9924, 0.9924, 0.9933, 0.9948, 0.9974, 0.9999, 0.9999,  &
0.9825, 0.9825, 0.9825, 0.9825, 0.9844, 0.9844, 0.9876, 0.9924, 0.9993 /
data ((cldnuctab( 9,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9994, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9993, 0.9994, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9989, 0.9989, 0.9990, 0.9992, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9977, 0.9977, 0.9980, 0.9983, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9933, 0.9933, 0.9941, 0.9955, 0.9974, 0.9999, 0.9999,  &
0.9844, 0.9844, 0.9844, 0.9844, 0.9844, 0.9861, 0.9876, 0.9924, 0.9989 /
data ((cldnuctab( 9,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9995, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9994, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9993, 0.9994, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9990, 0.9993, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9977, 0.9980, 0.9980, 0.9985, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9941, 0.9941, 0.9948, 0.9955, 0.9974, 0.9998, 0.9999,  &
0.9861, 0.9861, 0.9861, 0.9861, 0.9861, 0.9876, 0.9890, 0.9924, 0.9983 /
data ((cldnuctab( 9,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9993, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9989, 0.9992, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9977, 0.9985, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9941, 0.9960, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9861, 0.9861, 0.9861, 0.9876, 0.9914, 0.9965, 0.9999, 0.9995, 0.9999,  &
0.9804, 0.9804, 0.9804, 0.9804, 0.9825, 0.9861, 0.9924, 0.9989, 0.9999,  &
0.9782, 0.9782, 0.9782, 0.9782, 0.9782, 0.9804, 0.9825, 0.9876, 0.9914 /
data ((cldnuctab( 9,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9985, 0.9987, 0.9992, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9965, 0.9970, 0.9980, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9914, 0.9924, 0.9948, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9844, 0.9844, 0.9844, 0.9861, 0.9890, 0.9948, 0.9998, 0.9999,  &
0.9804, 0.9804, 0.9804, 0.9804, 0.9804, 0.9825, 0.9844, 0.9903, 0.9970 /
data ((cldnuctab( 9,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9995, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9992, 0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9980, 0.9980, 0.9983, 0.9989, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9948, 0.9955, 0.9970, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9890, 0.9903, 0.9924, 0.9960, 0.9999, 0.9998,  &
0.9825, 0.9825, 0.9825, 0.9825, 0.9825, 0.9844, 0.9861, 0.9924, 0.9989 /
data ((cldnuctab( 9,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9987, 0.9987, 0.9989, 0.9992, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9965, 0.9970, 0.9974, 0.9980, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9914, 0.9924, 0.9924, 0.9941, 0.9970, 0.9999, 0.9999,  &
0.9844, 0.9844, 0.9844, 0.9844, 0.9861, 0.9861, 0.9890, 0.9933, 0.9992 /
data ((cldnuctab( 9,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9995, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9992, 0.9994, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9977, 0.9977, 0.9980, 0.9985, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9933, 0.9941, 0.9941, 0.9955, 0.9974, 0.9999, 0.9999,  &
0.9876, 0.9876, 0.9876, 0.9876, 0.9876, 0.9876, 0.9903, 0.9933, 0.9989 /
data ((cldnuctab( 9,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9992, 0.9993, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9980, 0.9980, 0.9983, 0.9983, 0.9987, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9948, 0.9948, 0.9948, 0.9960, 0.9977, 0.9998, 0.9999,  &
0.9876, 0.9876, 0.9876, 0.9876, 0.9890, 0.9890, 0.9903, 0.9933, 0.9985 /
data ((cldnuctab( 9,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9993, 0.9994, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9983, 0.9983, 0.9985, 0.9989, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9955, 0.9955, 0.9955, 0.9960, 0.9977, 0.9996, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9890, 0.9890, 0.9903, 0.9914, 0.9933, 0.9980 /
data ((cldnuctab( 9,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9994, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9977, 0.9980, 0.9987, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9948, 0.9965, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9903, 0.9924, 0.9965, 0.9999, 0.9999, 0.9999,  &
0.9844, 0.9844, 0.9861, 0.9861, 0.9861, 0.9890, 0.9941, 0.9987, 0.9998,  &
0.9825, 0.9825, 0.9825, 0.9844, 0.9844, 0.9844, 0.9876, 0.9903, 0.9933 /
data ((cldnuctab( 9,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9995, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9989, 0.9990, 0.9993, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9970, 0.9974, 0.9983, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9924, 0.9933, 0.9941, 0.9955, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9876, 0.9876, 0.9876, 0.9890, 0.9914, 0.9955, 0.9997, 0.9999,  &
0.9825, 0.9825, 0.9844, 0.9844, 0.9844, 0.9861, 0.9876, 0.9924, 0.9974 /
data ((cldnuctab( 9,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9995, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9985, 0.9987, 0.9990, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9955, 0.9960, 0.9960, 0.9974, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.9903, 0.9903, 0.9903, 0.9914, 0.9914, 0.9933, 0.9965, 0.9998, 0.9999,  &
0.9861, 0.9861, 0.9861, 0.9861, 0.9861, 0.9876, 0.9890, 0.9933, 0.9987 /
data ((cldnuctab( 9,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9995, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9992, 0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9974, 0.9974, 0.9977, 0.9983, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9933, 0.9933, 0.9941, 0.9948, 0.9974, 0.9998, 0.9999,  &
0.9876, 0.9876, 0.9876, 0.9876, 0.9890, 0.9890, 0.9903, 0.9941, 0.9990 /
data ((cldnuctab( 9,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9993, 0.9994, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9980, 0.9980, 0.9980, 0.9983, 0.9987, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9948, 0.9948, 0.9948, 0.9960, 0.9977, 0.9998, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9903, 0.9903, 0.9903, 0.9914, 0.9941, 0.9987 /
data ((cldnuctab( 9,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9994, 0.9995, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9983, 0.9985, 0.9985, 0.9985, 0.9989, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9955, 0.9955, 0.9955, 0.9955, 0.9960, 0.9965, 0.9977, 0.9997, 0.9999,  &
0.9903, 0.9903, 0.9903, 0.9903, 0.9903, 0.9914, 0.9924, 0.9941, 0.9983 /
data ((cldnuctab( 9,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9985, 0.9987, 0.9987, 0.9987, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9960, 0.9960, 0.9960, 0.9960, 0.9970, 0.9980, 0.9996, 0.9999,  &
0.9914, 0.9914, 0.9914, 0.9914, 0.9914, 0.9914, 0.9924, 0.9948, 0.9980 /

data ((supersat( 1,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0171, 1.0249, 1.0378, 1.0598, 1.1011, 1.1902, 1.4374, 2.7352, 5.0027,  &
1.0142, 1.0206, 1.0308, 1.0478, 1.0780, 1.1379, 1.2786, 1.7430, 4.0530,  &
1.0120, 1.0172, 1.0255, 1.0392, 1.0625, 1.1060, 1.1982, 1.4418, 2.5803,  &
1.0099, 1.0147, 1.0217, 1.0327, 1.0514, 1.0848, 1.1507, 1.3035, 1.7889,  &
1.0088, 1.0125, 1.0186, 1.0278, 1.0433, 1.0699, 1.1197, 1.2257, 1.5066,  &
1.0077, 1.0109, 1.0161, 1.0238, 1.0370, 1.0586, 1.0980, 1.1763, 1.3613,  &
1.0056, 1.0093, 1.0138, 1.0207, 1.0320, 1.0502, 1.0820, 1.1423, 1.2736 /
data ((supersat( 1,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0139, 1.0201, 1.0298, 1.0463, 1.0760, 1.1361, 1.2844, 1.8220, 3.7340,  &
1.0115, 1.0163, 1.0242, 1.0367, 1.0587, 1.0999, 1.1892, 1.4354, 2.6145,  &
1.0097, 1.0135, 1.0198, 1.0300, 1.0468, 1.0772, 1.1373, 1.2793, 1.7414,  &
1.0078, 1.0114, 1.0166, 1.0250, 1.0384, 1.0618, 1.1057, 1.1990, 1.4465,  &
1.0070, 1.0100, 1.0140, 1.0211, 1.0322, 1.0509, 1.0846, 1.1515, 1.3076,  &
1.0061, 1.0082, 1.0124, 1.0181, 1.0275, 1.0429, 1.0697, 1.1203, 1.2287,  &
1.0044, 1.0073, 1.0106, 1.0159, 1.0236, 1.0365, 1.0585, 1.0984, 1.1784 /
data ((supersat( 1,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0117, 1.0166, 1.0245, 1.0373, 1.0598, 1.1036, 1.2038, 1.5019, 2.7537,  &
1.0097, 1.0135, 1.0197, 1.0294, 1.0461, 1.0763, 1.1382, 1.2917, 1.8312,  &
1.0080, 1.0111, 1.0162, 1.0239, 1.0366, 1.0588, 1.1011, 1.1937, 1.4490,  &
1.0066, 1.0093, 1.0135, 1.0196, 1.0299, 1.0469, 1.0780, 1.1403, 1.2886,  &
1.0056, 1.0081, 1.0114, 1.0166, 1.0249, 1.0386, 1.0625, 1.1077, 1.2052,  &
1.0050, 1.0066, 1.0096, 1.0142, 1.0211, 1.0324, 1.0515, 1.0862, 1.1557,  &
1.0040, 1.0058, 1.0085, 1.0119, 1.0180, 1.0277, 1.0433, 1.0709, 1.1234 /
data ((supersat( 1,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0101, 1.0142, 1.0206, 1.0311, 1.0491, 1.0830, 1.1565, 1.3541, 2.1048,  &
1.0083, 1.0115, 1.0165, 1.0245, 1.0376, 1.0610, 1.1072, 1.2143, 1.5329,  &
1.0067, 1.0093, 1.0135, 1.0197, 1.0297, 1.0468, 1.0784, 1.1442, 1.3096,  &
1.0058, 1.0079, 1.0112, 1.0162, 1.0240, 1.0371, 1.0602, 1.1048, 1.2041,  &
1.0044, 1.0067, 1.0094, 1.0135, 1.0197, 1.0303, 1.0480, 1.0805, 1.1468,  &
1.0042, 1.0056, 1.0078, 1.0115, 1.0168, 1.0252, 1.0394, 1.0644, 1.1122,  &
1.0036, 1.0045, 1.0069, 1.0098, 1.0144, 1.0215, 1.0331, 1.0530, 1.0895 /
data ((supersat( 1,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0089, 1.0125, 1.0179, 1.0268, 1.0417, 1.0694, 1.1273, 1.2738, 1.7469,  &
1.0072, 1.0100, 1.0143, 1.0210, 1.0319, 1.0509, 1.0874, 1.1688, 1.3906,  &
1.0059, 1.0082, 1.0116, 1.0167, 1.0249, 1.0388, 1.0637, 1.1140, 1.2333,  &
1.0050, 1.0069, 1.0096, 1.0137, 1.0201, 1.0305, 1.0486, 1.0826, 1.1549,  &
1.0041, 1.0055, 1.0079, 1.0114, 1.0164, 1.0247, 1.0384, 1.0630, 1.1114,  &
1.0031, 1.0049, 1.0067, 1.0096, 1.0137, 1.0204, 1.0313, 1.0501, 1.0851,  &
1.0031, 1.0039, 1.0056, 1.0081, 1.0117, 1.0172, 1.0262, 1.0411, 1.0677 /
data ((supersat( 1,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0078, 1.0111, 1.0159, 1.0235, 1.0365, 1.0599, 1.1079, 1.2247, 1.5716,  &
1.0064, 1.0090, 1.0126, 1.0184, 1.0277, 1.0438, 1.0742, 1.1399, 1.3105,  &
1.0054, 1.0073, 1.0101, 1.0146, 1.0216, 1.0332, 1.0538, 1.0944, 1.1877,  &
1.0042, 1.0060, 1.0083, 1.0118, 1.0172, 1.0259, 1.0407, 1.0680, 1.1245,  &
1.0035, 1.0050, 1.0068, 1.0098, 1.0140, 1.0207, 1.0319, 1.0515, 1.0891,  &
1.0031, 1.0042, 1.0059, 1.0082, 1.0116, 1.0170, 1.0258, 1.0406, 1.0675,  &
1.0022, 1.0037, 1.0046, 1.0067, 1.0098, 1.0143, 1.0213, 1.0331, 1.0535 /
data ((supersat( 1,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0071, 1.0099, 1.0142, 1.0209, 1.0323, 1.0528, 1.0940, 1.1919, 1.4692,  &
1.0058, 1.0080, 1.0113, 1.0164, 1.0245, 1.0385, 1.0646, 1.1200, 1.2596,  &
1.0047, 1.0065, 1.0091, 1.0130, 1.0190, 1.0291, 1.0467, 1.0810, 1.1577,  &
1.0040, 1.0053, 1.0074, 1.0104, 1.0151, 1.0225, 1.0351, 1.0580, 1.1045,  &
1.0031, 1.0045, 1.0062, 1.0086, 1.0122, 1.0179, 1.0273, 1.0435, 1.0743,  &
1.0028, 1.0036, 1.0051, 1.0070, 1.0101, 1.0146, 1.0219, 1.0341, 1.0558,  &
1.0024, 1.0031, 1.0043, 1.0059, 1.0085, 1.0122, 1.0180, 1.0275, 1.0439 /
data ((supersat( 1,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0147, 1.0218, 1.0340, 1.0552, 1.0957, 1.1844, 1.4324, 2.7307, 5.0001,  &
1.0121, 1.0181, 1.0276, 1.0438, 1.0732, 1.1323, 1.2730, 1.7384, 4.0482,  &
1.0101, 1.0151, 1.0227, 1.0356, 1.0582, 1.1009, 1.1926, 1.4365, 2.5746,  &
1.0088, 1.0126, 1.0192, 1.0297, 1.0476, 1.0802, 1.1453, 1.2979, 1.7835,  &
1.0076, 1.0111, 1.0163, 1.0253, 1.0399, 1.0657, 1.1147, 1.2201, 1.5009,  &
1.0055, 1.0092, 1.0142, 1.0218, 1.0338, 1.0548, 1.0932, 1.1708, 1.3554,  &
1.0055, 1.0086, 1.0125, 1.0190, 1.0293, 1.0467, 1.0775, 1.1370, 1.2676 /
data ((supersat( 1,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0119, 1.0174, 1.0265, 1.0421, 1.0709, 1.1305, 1.2793, 1.8185, 3.7311,  &
1.0098, 1.0142, 1.0213, 1.0332, 1.0542, 1.0947, 1.1837, 1.4309, 2.6107,  &
1.0079, 1.0118, 1.0175, 1.0270, 1.0430, 1.0725, 1.1321, 1.2742, 1.7372,  &
1.0069, 1.0100, 1.0146, 1.0224, 1.0350, 1.0577, 1.1008, 1.1938, 1.4416,  &
1.0059, 1.0082, 1.0126, 1.0190, 1.0293, 1.0473, 1.0802, 1.1463, 1.3024,  &
1.0041, 1.0073, 1.0106, 1.0163, 1.0251, 1.0396, 1.0657, 1.1154, 1.2234,  &
1.0040, 1.0066, 1.0096, 1.0139, 1.0215, 1.0337, 1.0548, 1.0938, 1.1731 /
data ((supersat( 1,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0099, 1.0143, 1.0214, 1.0334, 1.0544, 1.0983, 1.1984, 1.4984, 2.7508,  &
1.0080, 1.0115, 1.0171, 1.0262, 1.0420, 1.0714, 1.1329, 1.2872, 1.8286,  &
1.0066, 1.0095, 1.0139, 1.0212, 1.0332, 1.0546, 1.0962, 1.1886, 1.4451,  &
1.0056, 1.0081, 1.0114, 1.0173, 1.0269, 1.0433, 1.0735, 1.1353, 1.2839,  &
1.0049, 1.0065, 1.0098, 1.0145, 1.0224, 1.0354, 1.0585, 1.1031, 1.2003,  &
1.0036, 1.0057, 1.0085, 1.0123, 1.0190, 1.0296, 1.0479, 1.0819, 1.1509,  &
1.0027, 1.0052, 1.0073, 1.0109, 1.0165, 1.0253, 1.0401, 1.0670, 1.1187 /
data ((supersat( 1,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0084, 1.0121, 1.0179, 1.0276, 1.0448, 1.0780, 1.1515, 1.3505, 2.1027,  &
1.0067, 1.0097, 1.0142, 1.0215, 1.0339, 1.0565, 1.1022, 1.2097, 1.5297,  &
1.0057, 1.0080, 1.0115, 1.0172, 1.0266, 1.0429, 1.0738, 1.1393, 1.3055,  &
1.0044, 1.0066, 1.0094, 1.0141, 1.0214, 1.0337, 1.0561, 1.1001, 1.1994,  &
1.0041, 1.0055, 1.0079, 1.0117, 1.0175, 1.0274, 1.0444, 1.0762, 1.1421,  &
1.0034, 1.0045, 1.0068, 1.0097, 1.0148, 1.0227, 1.0363, 1.0605, 1.1077,  &
1.0024, 1.0043, 1.0058, 1.0086, 1.0125, 1.0194, 1.0303, 1.0496, 1.0853 /
data ((supersat( 1,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0073, 1.0105, 1.0154, 1.0235, 1.0378, 1.0647, 1.1225, 1.2702, 1.7451,  &
1.0059, 1.0084, 1.0122, 1.0182, 1.0284, 1.0467, 1.0827, 1.1642, 1.3876,  &
1.0050, 1.0069, 1.0097, 1.0144, 1.0221, 1.0351, 1.0594, 1.1092, 1.2293,  &
1.0040, 1.0055, 1.0079, 1.0117, 1.0176, 1.0274, 1.0448, 1.0781, 1.1503,  &
1.0032, 1.0048, 1.0067, 1.0097, 1.0144, 1.0220, 1.0351, 1.0590, 1.1069,  &
1.0030, 1.0037, 1.0056, 1.0080, 1.0121, 1.0182, 1.0284, 1.0466, 1.0809,  &
1.0026, 1.0032, 1.0049, 1.0070, 1.0102, 1.0152, 1.0237, 1.0380, 1.0640 /
data ((supersat( 1,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0065, 1.0093, 1.0135, 1.0206, 1.0327, 1.0555, 1.1032, 1.2212, 1.5698,  &
1.0053, 1.0075, 1.0107, 1.0159, 1.0245, 1.0398, 1.0696, 1.1354, 1.3075,  &
1.0042, 1.0060, 1.0085, 1.0125, 1.0189, 1.0298, 1.0497, 1.0899, 1.1836,  &
1.0037, 1.0049, 1.0069, 1.0101, 1.0150, 1.0230, 1.0371, 1.0638, 1.1201,  &
1.0029, 1.0041, 1.0059, 1.0082, 1.0121, 1.0183, 1.0289, 1.0478, 1.0848,  &
1.0021, 1.0035, 1.0045, 1.0066, 1.0101, 1.0149, 1.0231, 1.0374, 1.0636,  &
1.0021, 1.0026, 1.0042, 1.0059, 1.0085, 1.0126, 1.0191, 1.0303, 1.0500 /
data ((supersat( 1,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0059, 1.0083, 1.0121, 1.0182, 1.0289, 1.0486, 1.0895, 1.1882, 1.4673,  &
1.0047, 1.0066, 1.0095, 1.0141, 1.0216, 1.0348, 1.0603, 1.1157, 1.2566,  &
1.0039, 1.0053, 1.0076, 1.0111, 1.0166, 1.0259, 1.0428, 1.0766, 1.1538,  &
1.0031, 1.0045, 1.0062, 1.0088, 1.0130, 1.0199, 1.0318, 1.0540, 1.1002,  &
1.0028, 1.0035, 1.0050, 1.0071, 1.0105, 1.0157, 1.0245, 1.0400, 1.0702,  &
1.0022, 1.0031, 1.0043, 1.0060, 1.0086, 1.0127, 1.0195, 1.0310, 1.0522,  &
1.0016, 1.0027, 1.0033, 1.0050, 1.0072, 1.0106, 1.0160, 1.0250, 1.0407 /
data ((supersat( 1,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0123, 1.0191, 1.0304, 1.0505, 1.0900, 1.1782, 1.4271, 2.7259, 4.9977,  &
1.0104, 1.0156, 1.0245, 1.0398, 1.0682, 1.1265, 1.2671, 1.7335, 4.0428,  &
1.0088, 1.0128, 1.0202, 1.0323, 1.0539, 1.0956, 1.1866, 1.4309, 2.5689,  &
1.0075, 1.0113, 1.0169, 1.0267, 1.0439, 1.0754, 1.1397, 1.2919, 1.7776,  &
1.0055, 1.0093, 1.0147, 1.0228, 1.0366, 1.0614, 1.1094, 1.2141, 1.4946,  &
1.0054, 1.0086, 1.0126, 1.0195, 1.0309, 1.0510, 1.0883, 1.1649, 1.3489,  &
1.0052, 1.0071, 1.0110, 1.0165, 1.0265, 1.0431, 1.0729, 1.1312, 1.2610 /
data ((supersat( 1,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0099, 1.0150, 1.0234, 1.0380, 1.0658, 1.1247, 1.2740, 1.8151, 3.7276,  &
1.0081, 1.0123, 1.0187, 1.0298, 1.0498, 1.0893, 1.1780, 1.4261, 2.6064,  &
1.0069, 1.0101, 1.0154, 1.0241, 1.0393, 1.0678, 1.1266, 1.2687, 1.7325,  &
1.0058, 1.0084, 1.0130, 1.0198, 1.0319, 1.0536, 1.0958, 1.1883, 1.4364,  &
1.0041, 1.0072, 1.0107, 1.0168, 1.0265, 1.0437, 1.0756, 1.1410, 1.2968,  &
1.0040, 1.0065, 1.0096, 1.0141, 1.0226, 1.0365, 1.0615, 1.1104, 1.2177,  &
1.0039, 1.0050, 1.0075, 1.0126, 1.0195, 1.0309, 1.0511, 1.0890, 1.1674 /
data ((supersat( 1,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0081, 1.0122, 1.0185, 1.0298, 1.0505, 1.0928, 1.1930, 1.4948, 2.7479,  &
1.0066, 1.0099, 1.0148, 1.0232, 1.0381, 1.0666, 1.1275, 1.2824, 1.8252,  &
1.0055, 1.0081, 1.0120, 1.0186, 1.0298, 1.0503, 1.0911, 1.1834, 1.4409,  &
1.0048, 1.0066, 1.0101, 1.0153, 1.0242, 1.0397, 1.0690, 1.1302, 1.2789,  &
1.0035, 1.0057, 1.0085, 1.0129, 1.0199, 1.0323, 1.0545, 1.0983, 1.1951,  &
1.0028, 1.0051, 1.0073, 1.0111, 1.0170, 1.0270, 1.0445, 1.0774, 1.1458,  &
1.0027, 1.0040, 1.0058, 1.0090, 1.0145, 1.0228, 1.0370, 1.0629, 1.1138 /
data ((supersat( 1,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0068, 1.0102, 1.0154, 1.0243, 1.0406, 1.0729, 1.1463, 1.3470, 2.1002,  &
1.0057, 1.0082, 1.0122, 1.0188, 1.0304, 1.0521, 1.0970, 1.2050, 1.5267,  &
1.0043, 1.0066, 1.0097, 1.0149, 1.0235, 1.0391, 1.0691, 1.1343, 1.3014,  &
1.0040, 1.0055, 1.0081, 1.0121, 1.0189, 1.0306, 1.0520, 1.0953, 1.1946,  &
1.0033, 1.0044, 1.0068, 1.0100, 1.0156, 1.0246, 1.0409, 1.0719, 1.1372,  &
1.0022, 1.0041, 1.0058, 1.0087, 1.0131, 1.0205, 1.0333, 1.0566, 1.1031,  &
1.0016, 1.0035, 1.0045, 1.0072, 1.0113, 1.0173, 1.0277, 1.0461, 1.0810 /
data ((supersat( 1,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0060, 1.0088, 1.0132, 1.0206, 1.0339, 1.0599, 1.1175, 1.2665, 1.7433,  &
1.0049, 1.0070, 1.0103, 1.0157, 1.0252, 1.0425, 1.0778, 1.1596, 1.3846,  &
1.0039, 1.0055, 1.0082, 1.0124, 1.0194, 1.0316, 1.0550, 1.1044, 1.2252,  &
1.0031, 1.0048, 1.0068, 1.0100, 1.0154, 1.0245, 1.0410, 1.0736, 1.1457,  &
1.0029, 1.0037, 1.0056, 1.0080, 1.0125, 1.0196, 1.0319, 1.0550, 1.1024,  &
1.0024, 1.0032, 1.0049, 1.0071, 1.0104, 1.0162, 1.0258, 1.0432, 1.0766,  &
1.0017, 1.0030, 1.0037, 1.0057, 1.0088, 1.0136, 1.0215, 1.0350, 1.0601 /
data ((supersat( 1,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0054, 1.0077, 1.0115, 1.0178, 1.0291, 1.0510, 1.0985, 1.2176, 1.5680,  &
1.0042, 1.0061, 1.0090, 1.0136, 1.0215, 1.0360, 1.0651, 1.1309, 1.3045,  &
1.0036, 1.0049, 1.0072, 1.0107, 1.0164, 1.0265, 1.0456, 1.0853, 1.1796,  &
1.0027, 1.0041, 1.0059, 1.0084, 1.0129, 1.0204, 1.0337, 1.0595, 1.1156,  &
1.0021, 1.0034, 1.0046, 1.0069, 1.0104, 1.0162, 1.0260, 1.0441, 1.0805,  &
1.0020, 1.0024, 1.0041, 1.0060, 1.0086, 1.0131, 1.0208, 1.0342, 1.0597,  &
1.0019, 1.0021, 1.0035, 1.0046, 1.0072, 1.0109, 1.0171, 1.0276, 1.0466 /
data ((supersat( 1,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0047, 1.0068, 1.0102, 1.0157, 1.0256, 1.0445, 1.0850, 1.1847, 1.4655,  &
1.0038, 1.0054, 1.0080, 1.0119, 1.0188, 1.0313, 1.0560, 1.1114, 1.2537,  &
1.0031, 1.0045, 1.0064, 1.0094, 1.0143, 1.0229, 1.0390, 1.0722, 1.1499,  &
1.0027, 1.0034, 1.0050, 1.0074, 1.0112, 1.0174, 1.0286, 1.0500, 1.0959,  &
1.0021, 1.0030, 1.0042, 1.0061, 1.0089, 1.0137, 1.0218, 1.0366, 1.0661,  &
1.0013, 1.0026, 1.0032, 1.0051, 1.0072, 1.0110, 1.0173, 1.0282, 1.0485,  &
1.0011, 1.0019, 1.0031, 1.0043, 1.0062, 1.0092, 1.0142, 1.0225, 1.0376 /
data ((supersat( 1,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0109, 1.0168, 1.0272, 1.0462, 1.0846, 1.1723, 1.4222, 2.7212, 4.9952,  &
1.0088, 1.0137, 1.0218, 1.0362, 1.0635, 1.1209, 1.2614, 1.7287, 4.0375,  &
1.0076, 1.0116, 1.0181, 1.0292, 1.0499, 1.0905, 1.1808, 1.4254, 2.5629,  &
1.0055, 1.0092, 1.0153, 1.0243, 1.0404, 1.0709, 1.1342, 1.2861, 1.7716,  &
1.0054, 1.0086, 1.0127, 1.0204, 1.0334, 1.0573, 1.1042, 1.2081, 1.4883,  &
1.0051, 1.0072, 1.0113, 1.0176, 1.0283, 1.0472, 1.0835, 1.1590, 1.3423,  &
1.0043, 1.0055, 1.0091, 1.0152, 1.0239, 1.0396, 1.0683, 1.1255, 1.2542 /
data ((supersat( 1,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0085, 1.0128, 1.0206, 1.0343, 1.0610, 1.1192, 1.2690, 1.8118, 3.7245,  &
1.0069, 1.0104, 1.0163, 1.0267, 1.0458, 1.0843, 1.1726, 1.4216, 2.6020,  &
1.0058, 1.0089, 1.0134, 1.0216, 1.0359, 1.0634, 1.1214, 1.2636, 1.7284,  &
1.0041, 1.0069, 1.0111, 1.0178, 1.0290, 1.0498, 1.0910, 1.1829, 1.4314,  &
1.0040, 1.0065, 1.0098, 1.0151, 1.0242, 1.0404, 1.0713, 1.1358, 1.2913,  &
1.0038, 1.0055, 1.0077, 1.0130, 1.0202, 1.0335, 1.0576, 1.1054, 1.2120,  &
1.0034, 1.0040, 1.0072, 1.0107, 1.0171, 1.0283, 1.0475, 1.0843, 1.1618 /
data ((supersat( 1,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0069, 1.0104, 1.0161, 1.0265, 1.0462, 1.0877, 1.1882, 1.4915, 2.7449,  &
1.0055, 1.0083, 1.0129, 1.0206, 1.0345, 1.0620, 1.1224, 1.2780, 1.8225,  &
1.0048, 1.0068, 1.0105, 1.0164, 1.0269, 1.0465, 1.0864, 1.1785, 1.4369,  &
1.0034, 1.0057, 1.0086, 1.0136, 1.0217, 1.0364, 1.0648, 1.1253, 1.2742,  &
1.0028, 1.0051, 1.0075, 1.0114, 1.0180, 1.0296, 1.0509, 1.0937, 1.1901,  &
1.0027, 1.0039, 1.0058, 1.0095, 1.0151, 1.0246, 1.0412, 1.0733, 1.1409,  &
1.0027, 1.0028, 1.0056, 1.0084, 1.0130, 1.0206, 1.0341, 1.0590, 1.1090 /
data ((supersat( 1,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0058, 1.0086, 1.0132, 1.0214, 1.0367, 1.0682, 1.1416, 1.3436, 2.0980,  &
1.0043, 1.0067, 1.0105, 1.0164, 1.0272, 1.0479, 1.0923, 1.2007, 1.5239,  &
1.0039, 1.0056, 1.0085, 1.0131, 1.0210, 1.0357, 1.0648, 1.1296, 1.2976,  &
1.0032, 1.0044, 1.0069, 1.0107, 1.0168, 1.0277, 1.0483, 1.0908, 1.1901,  &
1.0021, 1.0041, 1.0059, 1.0090, 1.0139, 1.0223, 1.0378, 1.0678, 1.1327,  &
1.0016, 1.0034, 1.0045, 1.0072, 1.0117, 1.0186, 1.0306, 1.0531, 1.0987,  &
1.0016, 1.0023, 1.0043, 1.0066, 1.0098, 1.0155, 1.0252, 1.0428, 1.0768 /
data ((supersat( 1,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0050, 1.0073, 1.0112, 1.0179, 1.0303, 1.0556, 1.1130, 1.2632, 1.7415,  &
1.0039, 1.0057, 1.0088, 1.0136, 1.0223, 1.0387, 1.0733, 1.1554, 1.3818,  &
1.0031, 1.0048, 1.0071, 1.0107, 1.0171, 1.0285, 1.0510, 1.1000, 1.2215,  &
1.0028, 1.0036, 1.0056, 1.0087, 1.0136, 1.0220, 1.0376, 1.0694, 1.1414,  &
1.0023, 1.0032, 1.0049, 1.0073, 1.0110, 1.0175, 1.0292, 1.0514, 1.0981,  &
1.0015, 1.0029, 1.0037, 1.0057, 1.0093, 1.0145, 1.0235, 1.0400, 1.0727,  &
1.0009, 1.0025, 1.0032, 1.0053, 1.0079, 1.0122, 1.0194, 1.0323, 1.0566 /
data ((supersat( 1,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0042, 1.0064, 1.0097, 1.0154, 1.0259, 1.0470, 1.0942, 1.2144, 1.5665,  &
1.0036, 1.0051, 1.0076, 1.0116, 1.0189, 1.0325, 1.0609, 1.1269, 1.3019,  &
1.0027, 1.0041, 1.0060, 1.0091, 1.0143, 1.0237, 1.0419, 1.0811, 1.1760,  &
1.0021, 1.0034, 1.0047, 1.0073, 1.0113, 1.0180, 1.0306, 1.0557, 1.1115,  &
1.0020, 1.0024, 1.0041, 1.0061, 1.0091, 1.0143, 1.0235, 1.0407, 1.0765,  &
1.0018, 1.0021, 1.0034, 1.0048, 1.0076, 1.0117, 1.0187, 1.0314, 1.0561,  &
1.0015, 1.0021, 1.0024, 1.0043, 1.0064, 1.0098, 1.0153, 1.0252, 1.0434 /
data ((supersat( 1,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0039, 1.0057, 1.0086, 1.0136, 1.0226, 1.0407, 1.0810, 1.1816, 1.4640,  &
1.0030, 1.0045, 1.0066, 1.0102, 1.0164, 1.0281, 1.0521, 1.1075, 1.2512,  &
1.0026, 1.0035, 1.0052, 1.0080, 1.0124, 1.0203, 1.0356, 1.0683, 1.1464,  &
1.0020, 1.0030, 1.0043, 1.0064, 1.0097, 1.0153, 1.0257, 1.0464, 1.0920,  &
1.0013, 1.0025, 1.0033, 1.0051, 1.0077, 1.0120, 1.0195, 1.0336, 1.0624,  &
1.0011, 1.0018, 1.0030, 1.0043, 1.0065, 1.0098, 1.0155, 1.0257, 1.0452,  &
1.0011, 1.0011, 1.0026, 1.0033, 1.0052, 1.0081, 1.0126, 1.0204, 1.0347 /
data ((supersat( 1,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0098, 1.0154, 1.0254, 1.0440, 1.0817, 1.1692, 1.4196, 2.7187, 4.9938,  &
1.0083, 1.0124, 1.0205, 1.0343, 1.0610, 1.1179, 1.2585, 1.7263, 4.0342,  &
1.0066, 1.0107, 1.0168, 1.0278, 1.0477, 1.0878, 1.1778, 1.4225, 2.5599,  &
1.0055, 1.0090, 1.0143, 1.0228, 1.0386, 1.0684, 1.1312, 1.2829, 1.7684,  &
1.0052, 1.0080, 1.0122, 1.0193, 1.0320, 1.0551, 1.1014, 1.2049, 1.4848,  &
1.0047, 1.0061, 1.0102, 1.0162, 1.0266, 1.0454, 1.0808, 1.1558, 1.3386,  &
1.0036, 1.0054, 1.0088, 1.0140, 1.0226, 1.0378, 1.0658, 1.1222, 1.2503 /
data ((supersat( 1,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0074, 1.0120, 1.0191, 1.0323, 1.0585, 1.1163, 1.2665, 1.8102, 3.7233,  &
1.0065, 1.0098, 1.0154, 1.0251, 1.0437, 1.0816, 1.1698, 1.4193, 2.6000,  &
1.0050, 1.0077, 1.0127, 1.0202, 1.0341, 1.0611, 1.1186, 1.2609, 1.7262,  &
1.0041, 1.0069, 1.0104, 1.0166, 1.0277, 1.0478, 1.0884, 1.1801, 1.4287,  &
1.0039, 1.0058, 1.0090, 1.0138, 1.0228, 1.0386, 1.0690, 1.1330, 1.2884,  &
1.0036, 1.0041, 1.0074, 1.0121, 1.0193, 1.0319, 1.0555, 1.1028, 1.2090,  &
1.0029, 1.0040, 1.0068, 1.0103, 1.0164, 1.0267, 1.0455, 1.0818, 1.1587 /
data ((supersat( 1,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0060, 1.0095, 1.0150, 1.0249, 1.0440, 1.0851, 1.1857, 1.4899, 2.7433,  &
1.0052, 1.0077, 1.0118, 1.0191, 1.0327, 1.0596, 1.1198, 1.2758, 1.8210,  &
1.0041, 1.0058, 1.0097, 1.0154, 1.0254, 1.0444, 1.0839, 1.1760, 1.4348,  &
1.0028, 1.0054, 1.0082, 1.0127, 1.0205, 1.0347, 1.0626, 1.1227, 1.2719,  &
1.0027, 1.0045, 1.0066, 1.0107, 1.0169, 1.0280, 1.0489, 1.0913, 1.1876,  &
1.0027, 1.0031, 1.0057, 1.0088, 1.0142, 1.0232, 1.0395, 1.0710, 1.1382,  &
1.0025, 1.0028, 1.0053, 1.0079, 1.0118, 1.0196, 1.0326, 1.0570, 1.1064 /
data ((supersat( 1,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0051, 1.0078, 1.0122, 1.0199, 1.0347, 1.0658, 1.1392, 1.3420, 2.0970,  &
1.0042, 1.0063, 1.0094, 1.0153, 1.0256, 1.0458, 1.0898, 1.1985, 1.5227,  &
1.0036, 1.0048, 1.0077, 1.0120, 1.0197, 1.0338, 1.0625, 1.1272, 1.2957,  &
1.0026, 1.0043, 1.0065, 1.0096, 1.0158, 1.0262, 1.0463, 1.0885, 1.1879,  &
1.0016, 1.0038, 1.0051, 1.0083, 1.0129, 1.0212, 1.0361, 1.0657, 1.1303,  &
1.0016, 1.0028, 1.0044, 1.0070, 1.0109, 1.0173, 1.0291, 1.0511, 1.0964,  &
1.0016, 1.0018, 1.0041, 1.0061, 1.0093, 1.0146, 1.0241, 1.0412, 1.0747 /
data ((supersat( 1,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0045, 1.0067, 1.0103, 1.0166, 1.0285, 1.0533, 1.1107, 1.2617, 1.7409,  &
1.0033, 1.0052, 1.0079, 1.0126, 1.0208, 1.0368, 1.0711, 1.1534, 1.3806,  &
1.0030, 1.0043, 1.0064, 1.0098, 1.0159, 1.0269, 1.0489, 1.0977, 1.2196,  &
1.0025, 1.0032, 1.0053, 1.0079, 1.0125, 1.0206, 1.0359, 1.0673, 1.1393,  &
1.0018, 1.0030, 1.0043, 1.0066, 1.0102, 1.0165, 1.0277, 1.0495, 1.0959,  &
1.0011, 1.0027, 1.0032, 1.0056, 1.0084, 1.0136, 1.0223, 1.0383, 1.0706,  &
1.0007, 1.0020, 1.0031, 1.0049, 1.0074, 1.0114, 1.0184, 1.0308, 1.0546 /
data ((supersat( 1,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0039, 1.0058, 1.0089, 1.0142, 1.0243, 1.0449, 1.0921, 1.2129, 1.5658,  &
1.0031, 1.0044, 1.0069, 1.0107, 1.0176, 1.0308, 1.0587, 1.1249, 1.3007,  &
1.0022, 1.0038, 1.0055, 1.0082, 1.0133, 1.0223, 1.0400, 1.0790, 1.1742,  &
1.0020, 1.0029, 1.0043, 1.0065, 1.0103, 1.0169, 1.0290, 1.0537, 1.1095,  &
1.0019, 1.0021, 1.0038, 1.0056, 1.0084, 1.0134, 1.0221, 1.0390, 1.0744,  &
1.0016, 1.0021, 1.0029, 1.0044, 1.0068, 1.0108, 1.0177, 1.0300, 1.0543,  &
1.0011, 1.0020, 1.0021, 1.0041, 1.0060, 1.0089, 1.0145, 1.0240, 1.0418 /
data ((supersat( 1,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0034, 1.0050, 1.0078, 1.0125, 1.0211, 1.0388, 1.0790, 1.1802, 1.4633,  &
1.0029, 1.0041, 1.0061, 1.0094, 1.0152, 1.0265, 1.0501, 1.1057, 1.2500,  &
1.0023, 1.0031, 1.0048, 1.0072, 1.0114, 1.0190, 1.0339, 1.0663, 1.1447,  &
1.0016, 1.0027, 1.0038, 1.0057, 1.0088, 1.0143, 1.0243, 1.0446, 1.0901,  &
1.0011, 1.0021, 1.0031, 1.0048, 1.0070, 1.0112, 1.0184, 1.0320, 1.0605,  &
1.0011, 1.0013, 1.0028, 1.0037, 1.0058, 1.0090, 1.0145, 1.0244, 1.0436,  &
1.0011, 1.0011, 1.0021, 1.0032, 1.0051, 1.0073, 1.0119, 1.0194, 1.0333 /
data ((supersat( 1,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0089, 1.0148, 1.0244, 1.0425, 1.0799, 1.1672, 1.4180, 2.7173, 4.9930,  &
1.0079, 1.0121, 1.0195, 1.0331, 1.0594, 1.1160, 1.2566, 1.7249, 4.0324,  &
1.0059, 1.0099, 1.0159, 1.0267, 1.0464, 1.0860, 1.1759, 1.4206, 2.5576,  &
1.0054, 1.0087, 1.0134, 1.0221, 1.0374, 1.0669, 1.1293, 1.2809, 1.7663,  &
1.0050, 1.0074, 1.0117, 1.0187, 1.0309, 1.0536, 1.0996, 1.2028, 1.4823,  &
1.0043, 1.0055, 1.0093, 1.0157, 1.0258, 1.0440, 1.0791, 1.1536, 1.3361,  &
1.0031, 1.0053, 1.0085, 1.0131, 1.0218, 1.0363, 1.0641, 1.1201, 1.2477 /
data ((supersat( 1,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0070, 1.0113, 1.0182, 1.0311, 1.0569, 1.1145, 1.2650, 1.8093, 3.7223,  &
1.0061, 1.0093, 1.0146, 1.0241, 1.0423, 1.0800, 1.1680, 1.4179, 2.5985,  &
1.0043, 1.0073, 1.0120, 1.0193, 1.0330, 1.0595, 1.1169, 1.2592, 1.7248,  &
1.0040, 1.0066, 1.0101, 1.0161, 1.0266, 1.0464, 1.0868, 1.1783, 1.4269,  &
1.0038, 1.0052, 1.0083, 1.0134, 1.0221, 1.0374, 1.0674, 1.1312, 1.2866,  &
1.0033, 1.0040, 1.0072, 1.0113, 1.0186, 1.0309, 1.0541, 1.1010, 1.2070,  &
1.0026, 1.0039, 1.0065, 1.0099, 1.0157, 1.0257, 1.0441, 1.0800, 1.1566 /
data ((supersat( 1,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0056, 1.0088, 1.0142, 1.0238, 1.0426, 1.0834, 1.1842, 1.4889, 2.7425,  &
1.0049, 1.0072, 1.0111, 1.0183, 1.0315, 1.0581, 1.1181, 1.2744, 1.8204,  &
1.0036, 1.0057, 1.0090, 1.0146, 1.0244, 1.0432, 1.0823, 1.1744, 1.4335,  &
1.0028, 1.0052, 1.0078, 1.0119, 1.0195, 1.0336, 1.0612, 1.1211, 1.2703,  &
1.0027, 1.0040, 1.0059, 1.0102, 1.0163, 1.0271, 1.0477, 1.0897, 1.1859,  &
1.0026, 1.0028, 1.0056, 1.0085, 1.0138, 1.0224, 1.0384, 1.0696, 1.1365,  &
1.0023, 1.0027, 1.0049, 1.0074, 1.0114, 1.0188, 1.0315, 1.0555, 1.1047 /
data ((supersat( 1,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0046, 1.0072, 1.0114, 1.0190, 1.0335, 1.0642, 1.1377, 1.3410, 2.0967,  &
1.0040, 1.0059, 1.0090, 1.0145, 1.0245, 1.0444, 1.0883, 1.1972, 1.5218,  &
1.0032, 1.0044, 1.0070, 1.0116, 1.0188, 1.0327, 1.0611, 1.1257, 1.2945,  &
1.0021, 1.0041, 1.0061, 1.0094, 1.0150, 1.0253, 1.0451, 1.0870, 1.1865,  &
1.0016, 1.0034, 1.0045, 1.0076, 1.0122, 1.0203, 1.0350, 1.0643, 1.1288,  &
1.0016, 1.0024, 1.0043, 1.0067, 1.0103, 1.0168, 1.0282, 1.0499, 1.0949,  &
1.0016, 1.0016, 1.0039, 1.0056, 1.0089, 1.0141, 1.0232, 1.0400, 1.0732 /
data ((supersat( 1,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0041, 1.0062, 1.0095, 1.0157, 1.0274, 1.0519, 1.1093, 1.2607, 1.7405,  &
1.0031, 1.0050, 1.0074, 1.0118, 1.0199, 1.0356, 1.0696, 1.1521, 1.3798,  &
1.0028, 1.0038, 1.0058, 1.0094, 1.0152, 1.0259, 1.0477, 1.0963, 1.2185,  &
1.0022, 1.0032, 1.0050, 1.0076, 1.0120, 1.0199, 1.0347, 1.0659, 1.1380,  &
1.0015, 1.0029, 1.0039, 1.0060, 1.0098, 1.0159, 1.0268, 1.0483, 1.0945,  &
1.0009, 1.0024, 1.0032, 1.0054, 1.0080, 1.0129, 1.0214, 1.0373, 1.0693,  &
1.0006, 1.0017, 1.0031, 1.0045, 1.0070, 1.0107, 1.0176, 1.0299, 1.0534 /
data ((supersat( 1,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0037, 1.0054, 1.0083, 1.0134, 1.0232, 1.0436, 1.0909, 1.2120, 1.5654,  &
1.0028, 1.0041, 1.0063, 1.0100, 1.0167, 1.0296, 1.0574, 1.1237, 1.2999,  &
1.0021, 1.0035, 1.0051, 1.0079, 1.0126, 1.0213, 1.0388, 1.0776, 1.1731,  &
1.0020, 1.0025, 1.0041, 1.0063, 1.0099, 1.0161, 1.0280, 1.0524, 1.1082,  &
1.0018, 1.0021, 1.0035, 1.0051, 1.0081, 1.0127, 1.0213, 1.0379, 1.0732,  &
1.0014, 1.0020, 1.0025, 1.0043, 1.0065, 1.0104, 1.0169, 1.0290, 1.0531,  &
1.0009, 1.0019, 1.0021, 1.0038, 1.0057, 1.0086, 1.0139, 1.0231, 1.0407 /
data ((supersat( 1,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0030, 1.0047, 1.0073, 1.0118, 1.0201, 1.0376, 1.0777, 1.1793, 1.4630,  &
1.0026, 1.0037, 1.0056, 1.0088, 1.0144, 1.0254, 1.0489, 1.1045, 1.2492,  &
1.0020, 1.0030, 1.0045, 1.0067, 1.0108, 1.0181, 1.0328, 1.0650, 1.1437,  &
1.0013, 1.0025, 1.0034, 1.0053, 1.0084, 1.0136, 1.0234, 1.0434, 1.0889,  &
1.0011, 1.0018, 1.0030, 1.0045, 1.0068, 1.0106, 1.0176, 1.0310, 1.0593,  &
1.0011, 1.0011, 1.0026, 1.0033, 1.0053, 1.0087, 1.0139, 1.0235, 1.0425,  &
1.0010, 1.0011, 1.0018, 1.0031, 1.0048, 1.0071, 1.0113, 1.0186, 1.0323 /
data ((supersat( 1,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0088, 1.0143, 1.0237, 1.0415, 1.0786, 1.1659, 1.4168, 2.7165, 4.9924,  &
1.0075, 1.0117, 1.0188, 1.0322, 1.0583, 1.1146, 1.2553, 1.7239, 4.0311,  &
1.0055, 1.0092, 1.0156, 1.0258, 1.0453, 1.0848, 1.1745, 1.4193, 2.5563,  &
1.0053, 1.0085, 1.0127, 1.0215, 1.0364, 1.0657, 1.1279, 1.2795, 1.7648,  &
1.0049, 1.0069, 1.0113, 1.0181, 1.0299, 1.0525, 1.0982, 1.2012, 1.4806,  &
1.0039, 1.0054, 1.0090, 1.0153, 1.0251, 1.0429, 1.0778, 1.1520, 1.3343,  &
1.0028, 1.0052, 1.0082, 1.0124, 1.0211, 1.0355, 1.0628, 1.1184, 1.2457 /
data ((supersat( 1,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0069, 1.0107, 1.0176, 1.0302, 1.0557, 1.1132, 1.2639, 1.8086, 3.7216,  &
1.0057, 1.0088, 1.0140, 1.0235, 1.0413, 1.0787, 1.1668, 1.4169, 2.5977,  &
1.0041, 1.0072, 1.0115, 1.0188, 1.0322, 1.0584, 1.1156, 1.2581, 1.7238,  &
1.0039, 1.0063, 1.0098, 1.0156, 1.0258, 1.0455, 1.0856, 1.1771, 1.4257,  &
1.0037, 1.0047, 1.0077, 1.0131, 1.0215, 1.0367, 1.0663, 1.1299, 1.2852,  &
1.0031, 1.0040, 1.0070, 1.0106, 1.0180, 1.0301, 1.0530, 1.0997, 1.2055,  &
1.0023, 1.0038, 1.0061, 1.0095, 1.0152, 1.0251, 1.0432, 1.0788, 1.1550 /
data ((supersat( 1,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0054, 1.0083, 1.0135, 1.0229, 1.0415, 1.0822, 1.1831, 1.4884, 2.7420,  &
1.0046, 1.0068, 1.0108, 1.0177, 1.0306, 1.0571, 1.1170, 1.2735, 1.8195,  &
1.0031, 1.0056, 1.0086, 1.0140, 1.0237, 1.0422, 1.0812, 1.1733, 1.4328,  &
1.0028, 1.0049, 1.0074, 1.0114, 1.0191, 1.0328, 1.0601, 1.1200, 1.2693,  &
1.0027, 1.0036, 1.0058, 1.0097, 1.0158, 1.0265, 1.0467, 1.0886, 1.1847,  &
1.0025, 1.0028, 1.0054, 1.0083, 1.0133, 1.0218, 1.0375, 1.0685, 1.1352,  &
1.0022, 1.0027, 1.0046, 1.0070, 1.0112, 1.0182, 1.0307, 1.0546, 1.1034 /
data ((supersat( 1,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0043, 1.0067, 1.0110, 1.0183, 1.0325, 1.0631, 1.1367, 1.3403, 2.0962,  &
1.0038, 1.0056, 1.0087, 1.0138, 1.0238, 1.0435, 1.0872, 1.1963, 1.5213,  &
1.0029, 1.0043, 1.0069, 1.0111, 1.0182, 1.0319, 1.0601, 1.1247, 1.2937,  &
1.0018, 1.0040, 1.0058, 1.0091, 1.0144, 1.0246, 1.0442, 1.0860, 1.1855,  &
1.0016, 1.0031, 1.0044, 1.0071, 1.0119, 1.0197, 1.0342, 1.0633, 1.1277,  &
1.0016, 1.0020, 1.0042, 1.0065, 1.0098, 1.0163, 1.0275, 1.0490, 1.0938,  &
1.0016, 1.0016, 1.0037, 1.0052, 1.0086, 1.0137, 1.0225, 1.0391, 1.0721 /
data ((supersat( 1,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0038, 1.0058, 1.0092, 1.0151, 1.0266, 1.0509, 1.1083, 1.2601, 1.7402,  &
1.0030, 1.0047, 1.0072, 1.0114, 1.0192, 1.0347, 1.0686, 1.1512, 1.3793,  &
1.0027, 1.0035, 1.0055, 1.0090, 1.0146, 1.0252, 1.0467, 1.0953, 1.2178,  &
1.0020, 1.0031, 1.0048, 1.0073, 1.0116, 1.0192, 1.0340, 1.0650, 1.1370,  &
1.0013, 1.0028, 1.0035, 1.0057, 1.0095, 1.0153, 1.0261, 1.0474, 1.0935,  &
1.0007, 1.0022, 1.0032, 1.0052, 1.0078, 1.0125, 1.0209, 1.0365, 1.0683,  &
1.0006, 1.0015, 1.0030, 1.0042, 1.0066, 1.0103, 1.0171, 1.0292, 1.0525 /
data ((supersat( 1,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0035, 1.0051, 1.0078, 1.0129, 1.0225, 1.0426, 1.0898, 1.2114, 1.5651,  &
1.0025, 1.0040, 1.0060, 1.0096, 1.0161, 1.0288, 1.0564, 1.1229, 1.2994,  &
1.0021, 1.0032, 1.0048, 1.0076, 1.0121, 1.0206, 1.0380, 1.0767, 1.1724,  &
1.0019, 1.0022, 1.0040, 1.0061, 1.0095, 1.0156, 1.0273, 1.0516, 1.1074,  &
1.0016, 1.0021, 1.0032, 1.0047, 1.0077, 1.0123, 1.0207, 1.0372, 1.0723,  &
1.0012, 1.0020, 1.0022, 1.0042, 1.0064, 1.0101, 1.0164, 1.0283, 1.0522,  &
1.0008, 1.0018, 1.0021, 1.0036, 1.0053, 1.0084, 1.0134, 1.0225, 1.0399 /
data ((supersat( 1,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0030, 1.0045, 1.0069, 1.0112, 1.0195, 1.0368, 1.0769, 1.1787, 1.4627,  &
1.0025, 1.0034, 1.0053, 1.0083, 1.0139, 1.0247, 1.0480, 1.1038, 1.2487,  &
1.0018, 1.0029, 1.0043, 1.0065, 1.0103, 1.0175, 1.0320, 1.0642, 1.1430,  &
1.0011, 1.0023, 1.0032, 1.0051, 1.0081, 1.0131, 1.0227, 1.0426, 1.0881,  &
1.0011, 1.0016, 1.0029, 1.0042, 1.0065, 1.0103, 1.0171, 1.0303, 1.0584,  &
1.0011, 1.0011, 1.0024, 1.0032, 1.0052, 1.0084, 1.0135, 1.0229, 1.0417,  &
1.0011, 1.0011, 1.0016, 1.0030, 1.0046, 1.0069, 1.0109, 1.0181, 1.0316 /
data ((supersat( 2,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0106, 1.0161, 1.0261, 1.0441, 1.0808, 1.1669, 1.4170, 2.7133, 4.9906,  &
1.0087, 1.0132, 1.0212, 1.0347, 1.0608, 1.1164, 1.2559, 1.7237, 4.0288,  &
1.0074, 1.0114, 1.0175, 1.0283, 1.0479, 1.0870, 1.1758, 1.4200, 2.5549,  &
1.0055, 1.0092, 1.0150, 1.0235, 1.0390, 1.0683, 1.1299, 1.2807, 1.7658,  &
1.0054, 1.0085, 1.0126, 1.0198, 1.0326, 1.0554, 1.1008, 1.2031, 1.4825,  &
1.0050, 1.0070, 1.0111, 1.0169, 1.0274, 1.0459, 1.0807, 1.1545, 1.3364,  &
1.0043, 1.0055, 1.0091, 1.0149, 1.0232, 1.0385, 1.0661, 1.1216, 1.2485 /
data ((supersat( 2,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0082, 1.0126, 1.0198, 1.0327, 1.0582, 1.1147, 1.2642, 1.8075, 3.7194,  &
1.0069, 1.0102, 1.0159, 1.0257, 1.0438, 1.0809, 1.1678, 1.4173, 2.5959,  &
1.0057, 1.0085, 1.0132, 1.0209, 1.0345, 1.0609, 1.1173, 1.2588, 1.7239,  &
1.0041, 1.0072, 1.0107, 1.0172, 1.0282, 1.0480, 1.0878, 1.1785, 1.4267,  &
1.0040, 1.0064, 1.0096, 1.0146, 1.0234, 1.0391, 1.0689, 1.1319, 1.2865,  &
1.0038, 1.0049, 1.0075, 1.0128, 1.0199, 1.0324, 1.0557, 1.1022, 1.2075,  &
1.0034, 1.0040, 1.0071, 1.0106, 1.0169, 1.0275, 1.0461, 1.0817, 1.1576 /
data ((supersat( 2,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0067, 1.0101, 1.0157, 1.0254, 1.0441, 1.0840, 1.1837, 1.4882, 2.7399,  &
1.0055, 1.0082, 1.0125, 1.0198, 1.0331, 1.0594, 1.1183, 1.2739, 1.8188,  &
1.0047, 1.0066, 1.0103, 1.0160, 1.0261, 1.0446, 1.0832, 1.1742, 1.4332,  &
1.0033, 1.0056, 1.0086, 1.0133, 1.0211, 1.0351, 1.0625, 1.1216, 1.2700,  &
1.0028, 1.0050, 1.0073, 1.0112, 1.0174, 1.0286, 1.0491, 1.0907, 1.1861,  &
1.0027, 1.0038, 1.0059, 1.0092, 1.0146, 1.0239, 1.0400, 1.0710, 1.1372,  &
1.0026, 1.0028, 1.0056, 1.0084, 1.0127, 1.0201, 1.0332, 1.0573, 1.1060 /
data ((supersat( 2,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0057, 1.0084, 1.0129, 1.0205, 1.0350, 1.0652, 1.1376, 1.3405, 2.0945,  &
1.0044, 1.0067, 1.0102, 1.0159, 1.0261, 1.0458, 1.0888, 1.1968, 1.5214,  &
1.0039, 1.0055, 1.0083, 1.0127, 1.0203, 1.0342, 1.0622, 1.1259, 1.2942,  &
1.0031, 1.0044, 1.0068, 1.0104, 1.0164, 1.0268, 1.0465, 1.0878, 1.1864,  &
1.0022, 1.0041, 1.0058, 1.0088, 1.0136, 1.0217, 1.0365, 1.0656, 1.1293,  &
1.0016, 1.0034, 1.0045, 1.0072, 1.0115, 1.0180, 1.0296, 1.0513, 1.0959,  &
1.0016, 1.0023, 1.0043, 1.0066, 1.0097, 1.0151, 1.0247, 1.0417, 1.0746 /
data ((supersat( 2,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0049, 1.0071, 1.0109, 1.0172, 1.0290, 1.0531, 1.1094, 1.2603, 1.7391,  &
1.0039, 1.0055, 1.0086, 1.0132, 1.0214, 1.0371, 1.0704, 1.1519, 1.3794,  &
1.0031, 1.0047, 1.0070, 1.0104, 1.0165, 1.0274, 1.0489, 1.0968, 1.2182,  &
1.0028, 1.0035, 1.0055, 1.0084, 1.0132, 1.0212, 1.0363, 1.0670, 1.1381,  &
1.0023, 1.0031, 1.0048, 1.0072, 1.0108, 1.0170, 1.0282, 1.0497, 1.0952,  &
1.0016, 1.0029, 1.0036, 1.0057, 1.0091, 1.0142, 1.0229, 1.0387, 1.0705,  &
1.0009, 1.0025, 1.0032, 1.0053, 1.0078, 1.0120, 1.0190, 1.0314, 1.0549 /
data ((supersat( 2,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0042, 1.0062, 1.0095, 1.0149, 1.0248, 1.0448, 1.0911, 1.2116, 1.5646,  &
1.0035, 1.0050, 1.0074, 1.0113, 1.0182, 1.0311, 1.0584, 1.1237, 1.2997,  &
1.0027, 1.0041, 1.0059, 1.0089, 1.0138, 1.0228, 1.0402, 1.0783, 1.1730,  &
1.0020, 1.0034, 1.0046, 1.0072, 1.0110, 1.0175, 1.0295, 1.0536, 1.1085,  &
1.0019, 1.0023, 1.0041, 1.0060, 1.0088, 1.0140, 1.0227, 1.0393, 1.0741,  &
1.0018, 1.0021, 1.0034, 1.0047, 1.0074, 1.0114, 1.0183, 1.0305, 1.0544,  &
1.0015, 1.0020, 1.0024, 1.0042, 1.0064, 1.0096, 1.0150, 1.0246, 1.0422 /
data ((supersat( 2,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0039, 1.0056, 1.0083, 1.0131, 1.0217, 1.0389, 1.0781, 1.1790, 1.4626,  &
1.0029, 1.0045, 1.0065, 1.0099, 1.0159, 1.0269, 1.0500, 1.1047, 1.2490,  &
1.0026, 1.0035, 1.0050, 1.0078, 1.0120, 1.0196, 1.0342, 1.0658, 1.1436,  &
1.0020, 1.0030, 1.0043, 1.0063, 1.0094, 1.0149, 1.0248, 1.0447, 1.0894,  &
1.0014, 1.0025, 1.0033, 1.0051, 1.0076, 1.0118, 1.0190, 1.0324, 1.0603,  &
1.0009, 1.0018, 1.0030, 1.0043, 1.0063, 1.0095, 1.0151, 1.0249, 1.0438,  &
1.0009, 1.0011, 1.0025, 1.0033, 1.0052, 1.0080, 1.0124, 1.0200, 1.0338 /
data ((supersat( 2,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0089, 1.0146, 1.0240, 1.0417, 1.0780, 1.1645, 1.4154, 2.7117, 4.9895,  &
1.0079, 1.0120, 1.0191, 1.0324, 1.0581, 1.1137, 1.2538, 1.7219, 4.0268,  &
1.0057, 1.0097, 1.0158, 1.0261, 1.0454, 1.0843, 1.1733, 1.4179, 2.5518,  &
1.0054, 1.0087, 1.0132, 1.0219, 1.0367, 1.0655, 1.1271, 1.2781, 1.7632,  &
1.0050, 1.0073, 1.0116, 1.0185, 1.0303, 1.0527, 1.0978, 1.2002, 1.4795,  &
1.0043, 1.0055, 1.0092, 1.0156, 1.0255, 1.0432, 1.0777, 1.1513, 1.3330,  &
1.0031, 1.0052, 1.0085, 1.0129, 1.0215, 1.0359, 1.0629, 1.1180, 1.2447 /
data ((supersat( 2,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0070, 1.0111, 1.0179, 1.0304, 1.0555, 1.1122, 1.2625, 1.8066, 3.7184,  &
1.0060, 1.0092, 1.0144, 1.0237, 1.0414, 1.0782, 1.1656, 1.4158, 2.5939,  &
1.0042, 1.0073, 1.0119, 1.0191, 1.0324, 1.0583, 1.1149, 1.2569, 1.7221,  &
1.0040, 1.0066, 1.0100, 1.0159, 1.0262, 1.0456, 1.0852, 1.1761, 1.4247,  &
1.0038, 1.0052, 1.0082, 1.0134, 1.0218, 1.0369, 1.0663, 1.1292, 1.2841,  &
1.0033, 1.0040, 1.0072, 1.0111, 1.0184, 1.0305, 1.0531, 1.0994, 1.2046,  &
1.0026, 1.0040, 1.0064, 1.0098, 1.0156, 1.0255, 1.0435, 1.0787, 1.1544 /
data ((supersat( 2,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0055, 1.0086, 1.0139, 1.0232, 1.0415, 1.0815, 1.1819, 1.4874, 2.7394,  &
1.0048, 1.0072, 1.0110, 1.0181, 1.0308, 1.0568, 1.1161, 1.2725, 1.8175,  &
1.0035, 1.0057, 1.0088, 1.0144, 1.0240, 1.0423, 1.0807, 1.1723, 1.4319,  &
1.0028, 1.0051, 1.0077, 1.0117, 1.0194, 1.0330, 1.0600, 1.1193, 1.2683,  &
1.0027, 1.0040, 1.0059, 1.0100, 1.0162, 1.0268, 1.0468, 1.0882, 1.1839,  &
1.0026, 1.0027, 1.0056, 1.0085, 1.0136, 1.0222, 1.0378, 1.0684, 1.1347,  &
1.0023, 1.0027, 1.0049, 1.0074, 1.0114, 1.0186, 1.0310, 1.0547, 1.1032 /
data ((supersat( 2,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0045, 1.0071, 1.0112, 1.0186, 1.0327, 1.0627, 1.1357, 1.3395, 2.0938,  &
1.0040, 1.0059, 1.0089, 1.0142, 1.0241, 1.0434, 1.0866, 1.1953, 1.5205,  &
1.0032, 1.0044, 1.0070, 1.0114, 1.0185, 1.0320, 1.0598, 1.1239, 1.2929,  &
1.0021, 1.0041, 1.0061, 1.0093, 1.0148, 1.0249, 1.0442, 1.0855, 1.1846,  &
1.0016, 1.0034, 1.0045, 1.0075, 1.0121, 1.0200, 1.0345, 1.0632, 1.1271,  &
1.0016, 1.0024, 1.0043, 1.0067, 1.0101, 1.0166, 1.0278, 1.0491, 1.0935,  &
1.0015, 1.0016, 1.0039, 1.0055, 1.0089, 1.0140, 1.0229, 1.0394, 1.0721 /
data ((supersat( 2,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0041, 1.0061, 1.0094, 1.0154, 1.0266, 1.0507, 1.1076, 1.2594, 1.7385,  &
1.0031, 1.0049, 1.0074, 1.0117, 1.0195, 1.0348, 1.0682, 1.1504, 1.3787,  &
1.0028, 1.0038, 1.0058, 1.0093, 1.0149, 1.0254, 1.0467, 1.0947, 1.2170,  &
1.0022, 1.0031, 1.0050, 1.0075, 1.0119, 1.0196, 1.0342, 1.0648, 1.1363,  &
1.0015, 1.0029, 1.0038, 1.0060, 1.0097, 1.0157, 1.0264, 1.0475, 1.0931,  &
1.0009, 1.0024, 1.0032, 1.0053, 1.0080, 1.0127, 1.0212, 1.0367, 1.0682,  &
1.0006, 1.0017, 1.0031, 1.0045, 1.0069, 1.0106, 1.0173, 1.0295, 1.0526 /
data ((supersat( 2,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0036, 1.0054, 1.0082, 1.0132, 1.0227, 1.0426, 1.0892, 1.2107, 1.5642,  &
1.0028, 1.0041, 1.0062, 1.0099, 1.0164, 1.0290, 1.0562, 1.1222, 1.2989,  &
1.0021, 1.0035, 1.0051, 1.0078, 1.0124, 1.0209, 1.0380, 1.0763, 1.1718,  &
1.0020, 1.0025, 1.0041, 1.0062, 1.0098, 1.0159, 1.0275, 1.0515, 1.1068,  &
1.0018, 1.0021, 1.0035, 1.0051, 1.0080, 1.0125, 1.0210, 1.0373, 1.0720,  &
1.0014, 1.0020, 1.0025, 1.0043, 1.0065, 1.0104, 1.0167, 1.0286, 1.0522,  &
1.0009, 1.0019, 1.0021, 1.0038, 1.0056, 1.0086, 1.0138, 1.0228, 1.0401 /
data ((supersat( 2,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0030, 1.0047, 1.0072, 1.0116, 1.0198, 1.0368, 1.0764, 1.1781, 1.4621,  &
1.0026, 1.0037, 1.0056, 1.0087, 1.0142, 1.0249, 1.0479, 1.1032, 1.2483,  &
1.0020, 1.0030, 1.0045, 1.0067, 1.0107, 1.0178, 1.0321, 1.0639, 1.1424,  &
1.0013, 1.0025, 1.0033, 1.0052, 1.0083, 1.0134, 1.0230, 1.0426, 1.0876,  &
1.0011, 1.0018, 1.0030, 1.0045, 1.0067, 1.0105, 1.0174, 1.0305, 1.0583,  &
1.0011, 1.0011, 1.0026, 1.0033, 1.0053, 1.0086, 1.0138, 1.0232, 1.0418,  &
1.0011, 1.0011, 1.0018, 1.0031, 1.0047, 1.0071, 1.0111, 1.0184, 1.0319 /
data ((supersat( 2,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0083, 1.0130, 1.0219, 1.0391, 1.0753, 1.1622, 1.4139, 2.7103, 4.9885,  &
1.0065, 1.0108, 1.0177, 1.0303, 1.0555, 1.1111, 1.2518, 1.7203, 4.0242,  &
1.0054, 1.0089, 1.0146, 1.0244, 1.0431, 1.0816, 1.1708, 1.4158, 2.5489,  &
1.0051, 1.0078, 1.0122, 1.0200, 1.0346, 1.0629, 1.1244, 1.2755, 1.7601,  &
1.0043, 1.0057, 1.0101, 1.0166, 1.0283, 1.0501, 1.0948, 1.1972, 1.4763,  &
1.0032, 1.0053, 1.0086, 1.0141, 1.0234, 1.0407, 1.0746, 1.1479, 1.3294,  &
1.0023, 1.0047, 1.0074, 1.0117, 1.0192, 1.0333, 1.0597, 1.1143, 1.2404 /
data ((supersat( 2,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0063, 1.0098, 1.0162, 1.0283, 1.0530, 1.1099, 1.2611, 1.8055, 3.7170,  &
1.0047, 1.0078, 1.0129, 1.0217, 1.0391, 1.0758, 1.1636, 1.4144, 2.5925,  &
1.0040, 1.0068, 1.0104, 1.0176, 1.0303, 1.0559, 1.1125, 1.2550, 1.7205,  &
1.0038, 1.0055, 1.0090, 1.0144, 1.0244, 1.0433, 1.0827, 1.1737, 1.4227,  &
1.0033, 1.0040, 1.0073, 1.0122, 1.0199, 1.0346, 1.0637, 1.1266, 1.2816,  &
1.0025, 1.0039, 1.0066, 1.0102, 1.0166, 1.0284, 1.0506, 1.0965, 1.2017,  &
1.0018, 1.0036, 1.0053, 1.0086, 1.0137, 1.0234, 1.0409, 1.0757, 1.1511 /
data ((supersat( 2,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0050, 1.0078, 1.0125, 1.0214, 1.0392, 1.0793, 1.1804, 1.4865, 2.7381,  &
1.0038, 1.0058, 1.0100, 1.0163, 1.0288, 1.0545, 1.1141, 1.2712, 1.8169,  &
1.0027, 1.0053, 1.0081, 1.0132, 1.0222, 1.0401, 1.0785, 1.1704, 1.4306,  &
1.0027, 1.0042, 1.0065, 1.0109, 1.0179, 1.0311, 1.0577, 1.1171, 1.2665,  &
1.0026, 1.0028, 1.0057, 1.0087, 1.0145, 1.0249, 1.0446, 1.0859, 1.1817,  &
1.0023, 1.0027, 1.0050, 1.0078, 1.0122, 1.0204, 1.0356, 1.0659, 1.1321,  &
1.0018, 1.0026, 1.0038, 1.0060, 1.0104, 1.0168, 1.0291, 1.0521, 1.1003 /
data ((supersat( 2,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0040, 1.0063, 1.0100, 1.0169, 1.0305, 1.0605, 1.1342, 1.3388, 2.0929,  &
1.0033, 1.0048, 1.0079, 1.0129, 1.0222, 1.0413, 1.0845, 1.1941, 1.5197,  &
1.0023, 1.0042, 1.0065, 1.0102, 1.0170, 1.0301, 1.0577, 1.1221, 1.2917,  &
1.0016, 1.0035, 1.0050, 1.0084, 1.0136, 1.0232, 1.0422, 1.0834, 1.1830,  &
1.0016, 1.0025, 1.0043, 1.0069, 1.0112, 1.0186, 1.0325, 1.0610, 1.1251,  &
1.0016, 1.0016, 1.0039, 1.0059, 1.0093, 1.0151, 1.0260, 1.0469, 1.0912,  &
1.0015, 1.0016, 1.0032, 1.0044, 1.0076, 1.0125, 1.0213, 1.0373, 1.0696 /
data ((supersat( 2,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0031, 1.0052, 1.0083, 1.0139, 1.0248, 1.0485, 1.1060, 1.2586, 1.7381,  &
1.0028, 1.0041, 1.0065, 1.0105, 1.0178, 1.0328, 1.0662, 1.1491, 1.3780,  &
1.0023, 1.0031, 1.0052, 1.0081, 1.0135, 1.0236, 1.0446, 1.0930, 1.2159,  &
1.0015, 1.0029, 1.0042, 1.0067, 1.0106, 1.0180, 1.0322, 1.0627, 1.1348,  &
1.0009, 1.0024, 1.0032, 1.0055, 1.0087, 1.0143, 1.0247, 1.0454, 1.0912,  &
1.0006, 1.0017, 1.0031, 1.0047, 1.0073, 1.0118, 1.0196, 1.0348, 1.0661,  &
1.0006, 1.0011, 1.0027, 1.0034, 1.0057, 1.0098, 1.0161, 1.0276, 1.0504 /
data ((supersat( 2,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0030, 1.0044, 1.0071, 1.0118, 1.0209, 1.0405, 1.0877, 1.2099, 1.5637,  &
1.0021, 1.0037, 1.0055, 1.0088, 1.0148, 1.0271, 1.0543, 1.1209, 1.2982,  &
1.0020, 1.0027, 1.0042, 1.0068, 1.0112, 1.0193, 1.0361, 1.0745, 1.1707,  &
1.0017, 1.0021, 1.0037, 1.0055, 1.0086, 1.0145, 1.0257, 1.0495, 1.1053,  &
1.0013, 1.0020, 1.0027, 1.0043, 1.0070, 1.0115, 1.0195, 1.0354, 1.0702,  &
1.0009, 1.0018, 1.0021, 1.0039, 1.0059, 1.0093, 1.0154, 1.0269, 1.0503,  &
1.0006, 1.0015, 1.0020, 1.0031, 1.0046, 1.0078, 1.0125, 1.0213, 1.0381 /
data ((supersat( 2,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0027, 1.0040, 1.0062, 1.0103, 1.0181, 1.0349, 1.0749, 1.1773, 1.4616,  &
1.0021, 1.0030, 1.0048, 1.0076, 1.0127, 1.0231, 1.0460, 1.1019, 1.2477,  &
1.0013, 1.0026, 1.0037, 1.0059, 1.0095, 1.0163, 1.0303, 1.0622, 1.1414,  &
1.0011, 1.0019, 1.0031, 1.0047, 1.0073, 1.0121, 1.0213, 1.0408, 1.0861,  &
1.0011, 1.0011, 1.0026, 1.0036, 1.0059, 1.0095, 1.0159, 1.0288, 1.0565,  &
1.0011, 1.0011, 1.0019, 1.0031, 1.0049, 1.0076, 1.0125, 1.0216, 1.0400,  &
1.0010, 1.0011, 1.0012, 1.0028, 1.0040, 1.0064, 1.0102, 1.0170, 1.0301 /
data ((supersat( 2,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0073, 1.0118, 1.0204, 1.0370, 1.0731, 1.1604, 1.4126, 2.7080, 4.9873,  &
1.0054, 1.0093, 1.0161, 1.0283, 1.0533, 1.1089, 1.2500, 1.7186, 4.0215,  &
1.0051, 1.0082, 1.0131, 1.0226, 1.0409, 1.0793, 1.1686, 1.4138, 2.5462,  &
1.0044, 1.0064, 1.0112, 1.0185, 1.0324, 1.0605, 1.1218, 1.2731, 1.7572,  &
1.0033, 1.0053, 1.0088, 1.0153, 1.0263, 1.0477, 1.0921, 1.1942, 1.4729,  &
1.0023, 1.0048, 1.0078, 1.0122, 1.0215, 1.0382, 1.0716, 1.1445, 1.3255,  &
1.0018, 1.0039, 1.0060, 1.0103, 1.0175, 1.0308, 1.0565, 1.1104, 1.2358 /
data ((supersat( 2,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0054, 1.0089, 1.0149, 1.0263, 1.0509, 1.1081, 1.2598, 1.8046, 3.7161,  &
1.0040, 1.0067, 1.0119, 1.0203, 1.0371, 1.0737, 1.1619, 1.4132, 2.5909,  &
1.0038, 1.0061, 1.0097, 1.0161, 1.0286, 1.0538, 1.1104, 1.2533, 1.7189,  &
1.0034, 1.0048, 1.0076, 1.0132, 1.0227, 1.0413, 1.0805, 1.1717, 1.4207,  &
1.0026, 1.0034, 1.0068, 1.0107, 1.0186, 1.0328, 1.0614, 1.1242, 1.2792,  &
1.0018, 1.0033, 1.0056, 1.0092, 1.0153, 1.0265, 1.0482, 1.0937, 1.1988,  &
1.0014, 1.0029, 1.0041, 1.0071, 1.0125, 1.0215, 1.0385, 1.0726, 1.1477 /
data ((supersat( 2,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0043, 1.0068, 1.0112, 1.0197, 1.0373, 1.0774, 1.1792, 1.4855, 2.7372,  &
1.0028, 1.0055, 1.0087, 1.0151, 1.0271, 1.0526, 1.1124, 1.2701, 1.8159,  &
1.0027, 1.0046, 1.0073, 1.0119, 1.0207, 1.0382, 1.0765, 1.1689, 1.4294,  &
1.0026, 1.0032, 1.0057, 1.0098, 1.0164, 1.0293, 1.0557, 1.1152, 1.2649,  &
1.0023, 1.0027, 1.0052, 1.0082, 1.0135, 1.0234, 1.0426, 1.0837, 1.1797,  &
1.0018, 1.0026, 1.0042, 1.0067, 1.0111, 1.0189, 1.0337, 1.0636, 1.1297,  &
1.0013, 1.0023, 1.0029, 1.0054, 1.0090, 1.0155, 1.0270, 1.0498, 1.0975 /
data ((supersat( 2,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0036, 1.0055, 1.0088, 1.0153, 1.0287, 1.0587, 1.1330, 1.3381, 2.0927,  &
1.0025, 1.0042, 1.0068, 1.0115, 1.0206, 1.0394, 1.0829, 1.1930, 1.5189,  &
1.0016, 1.0037, 1.0057, 1.0091, 1.0157, 1.0284, 1.0559, 1.1206, 1.2908,  &
1.0016, 1.0027, 1.0044, 1.0072, 1.0123, 1.0216, 1.0404, 1.0817, 1.1816,  &
1.0016, 1.0016, 1.0040, 1.0063, 1.0100, 1.0171, 1.0307, 1.0591, 1.1233,  &
1.0015, 1.0016, 1.0033, 1.0048, 1.0084, 1.0140, 1.0243, 1.0449, 1.0891,  &
1.0013, 1.0016, 1.0024, 1.0041, 1.0067, 1.0114, 1.0196, 1.0353, 1.0673 /
data ((supersat( 2,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0029, 1.0046, 1.0073, 1.0125, 1.0231, 1.0468, 1.1048, 1.2579, 1.7377,  &
1.0024, 1.0032, 1.0055, 1.0093, 1.0164, 1.0310, 1.0646, 1.1481, 1.3774,  &
1.0017, 1.0030, 1.0046, 1.0073, 1.0123, 1.0221, 1.0429, 1.0916, 1.2151,  &
1.0009, 1.0025, 1.0032, 1.0056, 1.0097, 1.0166, 1.0306, 1.0611, 1.1335,  &
1.0006, 1.0018, 1.0031, 1.0050, 1.0078, 1.0132, 1.0231, 1.0437, 1.0896,  &
1.0006, 1.0012, 1.0028, 1.0038, 1.0064, 1.0106, 1.0183, 1.0331, 1.0642,  &
1.0006, 1.0008, 1.0022, 1.0031, 1.0053, 1.0087, 1.0146, 1.0259, 1.0484 /
data ((supersat( 2,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0022, 1.0039, 1.0061, 1.0106, 1.0193, 1.0389, 1.0865, 1.2093, 1.5633,  &
1.0020, 1.0030, 1.0047, 1.0078, 1.0135, 1.0255, 1.0527, 1.1199, 1.2978,  &
1.0018, 1.0021, 1.0039, 1.0060, 1.0100, 1.0179, 1.0345, 1.0732, 1.1699,  &
1.0014, 1.0020, 1.0030, 1.0047, 1.0079, 1.0134, 1.0242, 1.0480, 1.1040,  &
1.0009, 1.0018, 1.0021, 1.0040, 1.0063, 1.0104, 1.0181, 1.0338, 1.0686,  &
1.0007, 1.0015, 1.0020, 1.0033, 1.0052, 1.0084, 1.0142, 1.0254, 1.0486,  &
1.0005, 1.0011, 1.0019, 1.0024, 1.0042, 1.0068, 1.0115, 1.0198, 1.0364 /
data ((supersat( 2,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0022, 1.0033, 1.0054, 1.0091, 1.0166, 1.0333, 1.0737, 1.1768, 1.4613,  &
1.0015, 1.0027, 1.0042, 1.0066, 1.0116, 1.0216, 1.0446, 1.1010, 1.2473,  &
1.0011, 1.0020, 1.0031, 1.0050, 1.0084, 1.0150, 1.0288, 1.0609, 1.1406,  &
1.0011, 1.0013, 1.0027, 1.0041, 1.0066, 1.0111, 1.0200, 1.0393, 1.0850,  &
1.0011, 1.0011, 1.0021, 1.0032, 1.0051, 1.0086, 1.0148, 1.0273, 1.0551,  &
1.0010, 1.0011, 1.0013, 1.0029, 1.0044, 1.0069, 1.0115, 1.0203, 1.0384,  &
1.0008, 1.0010, 1.0011, 1.0023, 1.0032, 1.0055, 1.0092, 1.0158, 1.0285 /
data ((supersat( 2,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0066, 1.0113, 1.0195, 1.0359, 1.0720, 1.1595, 1.4120, 2.7073, 4.9867,  &
1.0053, 1.0089, 1.0153, 1.0274, 1.0521, 1.1078, 1.2491, 1.7178, 4.0198,  &
1.0049, 1.0077, 1.0123, 1.0217, 1.0398, 1.0780, 1.1675, 1.4128, 2.5441,  &
1.0040, 1.0056, 1.0104, 1.0178, 1.0314, 1.0593, 1.1205, 1.2718, 1.7553,  &
1.0028, 1.0051, 1.0085, 1.0146, 1.0252, 1.0464, 1.0906, 1.1926, 1.4708,  &
1.0020, 1.0044, 1.0071, 1.0117, 1.0205, 1.0369, 1.0699, 1.1426, 1.3231,  &
1.0017, 1.0034, 1.0052, 1.0094, 1.0164, 1.0293, 1.0547, 1.1082, 1.2330 /
data ((supersat( 2,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0047, 1.0082, 1.0141, 1.0255, 1.0499, 1.1072, 1.2593, 1.8043, 3.7155,  &
1.0039, 1.0068, 1.0111, 1.0195, 1.0361, 1.0727, 1.1611, 1.4126, 2.5900,  &
1.0037, 1.0055, 1.0092, 1.0155, 1.0275, 1.0528, 1.1094, 1.2525, 1.7181,  &
1.0030, 1.0040, 1.0072, 1.0127, 1.0218, 1.0403, 1.0793, 1.1706, 1.4196,  &
1.0022, 1.0038, 1.0064, 1.0102, 1.0178, 1.0317, 1.0601, 1.1229, 1.2779,  &
1.0016, 1.0034, 1.0050, 1.0086, 1.0145, 1.0253, 1.0469, 1.0922, 1.1972,  &
1.0013, 1.0027, 1.0036, 1.0066, 1.0117, 1.0204, 1.0371, 1.0710, 1.1457 /
data ((supersat( 2,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0037, 1.0062, 1.0106, 1.0189, 1.0363, 1.0766, 1.1786, 1.4852, 2.7370,  &
1.0028, 1.0052, 1.0083, 1.0144, 1.0262, 1.0516, 1.1116, 1.2695, 1.8153,  &
1.0027, 1.0041, 1.0067, 1.0112, 1.0200, 1.0373, 1.0756, 1.1682, 1.4288,  &
1.0024, 1.0027, 1.0056, 1.0091, 1.0159, 1.0285, 1.0547, 1.1142, 1.2641,  &
1.0020, 1.0027, 1.0048, 1.0078, 1.0129, 1.0224, 1.0416, 1.0826, 1.1786,  &
1.0015, 1.0025, 1.0036, 1.0059, 1.0106, 1.0182, 1.0326, 1.0624, 1.1284,  &
1.0012, 1.0021, 1.0025, 1.0051, 1.0082, 1.0146, 1.0260, 1.0484, 1.0960 /
data ((supersat( 2,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0032, 1.0049, 1.0084, 1.0147, 1.0278, 1.0579, 1.1324, 1.3378, 2.0924,  &
1.0021, 1.0041, 1.0065, 1.0110, 1.0198, 1.0386, 1.0822, 1.1925, 1.5185,  &
1.0016, 1.0034, 1.0051, 1.0087, 1.0150, 1.0276, 1.0550, 1.1200, 1.2903,  &
1.0016, 1.0022, 1.0042, 1.0069, 1.0117, 1.0208, 1.0395, 1.0808, 1.1810,  &
1.0015, 1.0016, 1.0038, 1.0059, 1.0094, 1.0164, 1.0299, 1.0581, 1.1224,  &
1.0014, 1.0016, 1.0029, 1.0043, 1.0078, 1.0134, 1.0235, 1.0439, 1.0880,  &
1.0012, 1.0014, 1.0021, 1.0039, 1.0064, 1.0108, 1.0187, 1.0342, 1.0660 /
data ((supersat( 2,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0027, 1.0042, 1.0069, 1.0119, 1.0223, 1.0460, 1.1042, 1.2577, 1.7376,  &
1.0021, 1.0031, 1.0052, 1.0089, 1.0157, 1.0302, 1.0639, 1.1476, 1.3771,  &
1.0013, 1.0028, 1.0042, 1.0070, 1.0117, 1.0213, 1.0421, 1.0909, 1.2147,  &
1.0008, 1.0022, 1.0032, 1.0054, 1.0092, 1.0160, 1.0298, 1.0603, 1.1329,  &
1.0006, 1.0015, 1.0029, 1.0046, 1.0075, 1.0125, 1.0224, 1.0428, 1.0888,  &
1.0006, 1.0010, 1.0025, 1.0033, 1.0059, 1.0100, 1.0176, 1.0322, 1.0633,  &
1.0005, 1.0008, 1.0019, 1.0029, 1.0050, 1.0081, 1.0140, 1.0250, 1.0473 /
data ((supersat( 2,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0021, 1.0036, 1.0058, 1.0100, 1.0186, 1.0382, 1.0860, 1.2091, 1.5631,  &
1.0019, 1.0026, 1.0042, 1.0074, 1.0129, 1.0247, 1.0521, 1.1195, 1.2976,  &
1.0016, 1.0021, 1.0036, 1.0057, 1.0096, 1.0172, 1.0337, 1.0726, 1.1695,  &
1.0011, 1.0019, 1.0026, 1.0043, 1.0075, 1.0128, 1.0235, 1.0472, 1.1035,  &
1.0007, 1.0017, 1.0021, 1.0038, 1.0060, 1.0100, 1.0175, 1.0330, 1.0679,  &
1.0005, 1.0013, 1.0020, 1.0029, 1.0047, 1.0080, 1.0136, 1.0246, 1.0477,  &
1.0005, 1.0010, 1.0017, 1.0020, 1.0039, 1.0062, 1.0108, 1.0191, 1.0354 /
data ((supersat( 2,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0019, 1.0030, 1.0049, 1.0086, 1.0159, 1.0326, 1.0732, 1.1766, 1.4611,  &
1.0012, 1.0025, 1.0038, 1.0063, 1.0110, 1.0209, 1.0439, 1.1006, 1.2471,  &
1.0011, 1.0017, 1.0030, 1.0048, 1.0080, 1.0143, 1.0281, 1.0603, 1.1403,  &
1.0011, 1.0011, 1.0025, 1.0037, 1.0062, 1.0105, 1.0193, 1.0386, 1.0845,  &
1.0010, 1.0011, 1.0017, 1.0031, 1.0049, 1.0082, 1.0142, 1.0266, 1.0544,  &
1.0009, 1.0011, 1.0011, 1.0026, 1.0040, 1.0065, 1.0110, 1.0196, 1.0377,  &
1.0007, 1.0009, 1.0010, 1.0020, 1.0030, 1.0050, 1.0086, 1.0151, 1.0277 /
data ((supersat( 2,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0061, 1.0109, 1.0189, 1.0353, 1.0713, 1.1589, 1.4115, 2.7068, 4.9861,  &
1.0052, 1.0087, 1.0150, 1.0269, 1.0514, 1.1072, 1.2486, 1.7171, 4.0183,  &
1.0047, 1.0073, 1.0121, 1.0212, 1.0391, 1.0773, 1.1668, 1.4120, 2.5431,  &
1.0036, 1.0054, 1.0099, 1.0172, 1.0308, 1.0584, 1.1196, 1.2709, 1.7540,  &
1.0025, 1.0049, 1.0082, 1.0140, 1.0246, 1.0455, 1.0895, 1.1915, 1.4692,  &
1.0019, 1.0041, 1.0066, 1.0112, 1.0197, 1.0359, 1.0688, 1.1413, 1.3214,  &
1.0016, 1.0031, 1.0048, 1.0087, 1.0155, 1.0282, 1.0533, 1.1066, 1.2310 /
data ((supersat( 2,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0043, 1.0078, 1.0136, 1.0249, 1.0492, 1.1067, 1.2589, 1.8039, 3.7151,  &
1.0039, 1.0066, 1.0106, 1.0189, 1.0355, 1.0721, 1.1606, 1.4121, 2.5894,  &
1.0035, 1.0051, 1.0088, 1.0151, 1.0270, 1.0521, 1.1088, 1.2519, 1.7174,  &
1.0028, 1.0039, 1.0071, 1.0123, 1.0214, 1.0395, 1.0786, 1.1699, 1.4188,  &
1.0019, 1.0037, 1.0061, 1.0099, 1.0172, 1.0309, 1.0593, 1.1220, 1.2770,  &
1.0014, 1.0031, 1.0046, 1.0081, 1.0138, 1.0246, 1.0460, 1.0912, 1.1960,  &
1.0012, 1.0024, 1.0034, 1.0063, 1.0111, 1.0197, 1.0360, 1.0698, 1.1443 /
data ((supersat( 2,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0034, 1.0057, 1.0103, 1.0184, 1.0357, 1.0761, 1.1783, 1.4850, 2.7369,  &
1.0027, 1.0050, 1.0081, 1.0139, 1.0256, 1.0511, 1.1112, 1.2692, 1.8151,  &
1.0026, 1.0037, 1.0064, 1.0109, 1.0194, 1.0367, 1.0751, 1.1678, 1.4283,  &
1.0023, 1.0027, 1.0054, 1.0086, 1.0154, 1.0279, 1.0541, 1.1137, 1.2637,  &
1.0018, 1.0026, 1.0045, 1.0074, 1.0124, 1.0218, 1.0409, 1.0819, 1.1779,  &
1.0013, 1.0024, 1.0033, 1.0055, 1.0102, 1.0176, 1.0319, 1.0616, 1.1276,  &
1.0011, 1.0019, 1.0024, 1.0048, 1.0079, 1.0139, 1.0252, 1.0475, 1.0949 /
data ((supersat( 2,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0029, 1.0046, 1.0081, 1.0142, 1.0273, 1.0574, 1.1321, 1.3376, 2.0924,  &
1.0018, 1.0039, 1.0063, 1.0107, 1.0193, 1.0380, 1.0817, 1.1923, 1.5182,  &
1.0016, 1.0031, 1.0047, 1.0084, 1.0146, 1.0270, 1.0545, 1.1196, 1.2900,  &
1.0016, 1.0019, 1.0042, 1.0067, 1.0114, 1.0204, 1.0389, 1.0803, 1.1805,  &
1.0015, 1.0016, 1.0035, 1.0055, 1.0092, 1.0160, 1.0294, 1.0575, 1.1218,  &
1.0013, 1.0015, 1.0026, 1.0042, 1.0074, 1.0129, 1.0229, 1.0432, 1.0873,  &
1.0010, 1.0014, 1.0019, 1.0037, 1.0061, 1.0103, 1.0182, 1.0334, 1.0652 /
data ((supersat( 2,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0026, 1.0039, 1.0066, 1.0115, 1.0218, 1.0456, 1.1040, 1.2576, 1.7374,  &
1.0019, 1.0031, 1.0051, 1.0085, 1.0152, 1.0297, 1.0635, 1.1474, 1.3769,  &
1.0011, 1.0027, 1.0039, 1.0067, 1.0113, 1.0208, 1.0416, 1.0905, 1.2144,  &
1.0006, 1.0020, 1.0031, 1.0053, 1.0089, 1.0156, 1.0293, 1.0598, 1.1325,  &
1.0006, 1.0013, 1.0028, 1.0043, 1.0072, 1.0121, 1.0219, 1.0423, 1.0883,  &
1.0006, 1.0009, 1.0023, 1.0031, 1.0055, 1.0097, 1.0170, 1.0316, 1.0626,  &
1.0005, 1.0008, 1.0017, 1.0028, 1.0047, 1.0076, 1.0135, 1.0244, 1.0466 /
data ((supersat( 2,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0020, 1.0034, 1.0055, 1.0096, 1.0181, 1.0377, 1.0857, 1.2089, 1.5631,  &
1.0018, 1.0023, 1.0041, 1.0071, 1.0125, 1.0243, 1.0517, 1.1193, 1.2974,  &
1.0014, 1.0021, 1.0034, 1.0055, 1.0092, 1.0167, 1.0333, 1.0722, 1.1693,  &
1.0009, 1.0019, 1.0023, 1.0042, 1.0071, 1.0124, 1.0231, 1.0468, 1.1032,  &
1.0006, 1.0015, 1.0020, 1.0036, 1.0058, 1.0096, 1.0171, 1.0326, 1.0674,  &
1.0005, 1.0011, 1.0019, 1.0027, 1.0043, 1.0077, 1.0132, 1.0241, 1.0472,  &
1.0005, 1.0009, 1.0016, 1.0020, 1.0037, 1.0060, 1.0103, 1.0185, 1.0348 /
data ((supersat( 2,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0017, 1.0029, 1.0047, 1.0083, 1.0155, 1.0322, 1.0730, 1.1764, 1.4610,  &
1.0011, 1.0023, 1.0035, 1.0060, 1.0106, 1.0205, 1.0436, 1.1004, 1.2469,  &
1.0011, 1.0015, 1.0029, 1.0046, 1.0078, 1.0140, 1.0277, 1.0600, 1.1401,  &
1.0010, 1.0011, 1.0023, 1.0034, 1.0060, 1.0101, 1.0189, 1.0382, 1.0842,  &
1.0009, 1.0011, 1.0015, 1.0030, 1.0048, 1.0079, 1.0138, 1.0261, 1.0540,  &
1.0008, 1.0010, 1.0011, 1.0025, 1.0037, 1.0063, 1.0105, 1.0191, 1.0372,  &
1.0006, 1.0009, 1.0010, 1.0018, 1.0029, 1.0048, 1.0083, 1.0147, 1.0272 /
data ((supersat( 2,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0057, 1.0106, 1.0184, 1.0348, 1.0708, 1.1586, 1.4112, 2.7065, 4.9856,  &
1.0052, 1.0085, 1.0147, 1.0264, 1.0509, 1.1067, 1.2482, 1.7166, 4.0174,  &
1.0045, 1.0070, 1.0118, 1.0208, 1.0386, 1.0767, 1.1662, 1.4114, 2.5420,  &
1.0033, 1.0053, 1.0094, 1.0168, 1.0302, 1.0578, 1.1190, 1.2702, 1.7530,  &
1.0023, 1.0048, 1.0080, 1.0136, 1.0241, 1.0448, 1.0888, 1.1907, 1.4680,  &
1.0018, 1.0038, 1.0062, 1.0108, 1.0191, 1.0351, 1.0679, 1.1402, 1.3200,  &
1.0015, 1.0028, 1.0044, 1.0081, 1.0148, 1.0273, 1.0524, 1.1054, 1.2294 /
data ((supersat( 2,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0040, 1.0074, 1.0132, 1.0245, 1.0488, 1.1063, 1.2587, 1.8037, 3.7149,  &
1.0038, 1.0064, 1.0102, 1.0185, 1.0351, 1.0717, 1.1603, 1.4118, 2.5889,  &
1.0034, 1.0047, 1.0085, 1.0147, 1.0266, 1.0516, 1.1084, 1.2516, 1.7169,  &
1.0025, 1.0039, 1.0069, 1.0119, 1.0210, 1.0390, 1.0781, 1.1694, 1.4182,  &
1.0017, 1.0036, 1.0058, 1.0097, 1.0167, 1.0304, 1.0587, 1.1214, 1.2763,  &
1.0014, 1.0029, 1.0042, 1.0076, 1.0133, 1.0241, 1.0453, 1.0905, 1.1952,  &
1.0012, 1.0022, 1.0033, 1.0060, 1.0106, 1.0190, 1.0353, 1.0689, 1.1432 /
data ((supersat( 2,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0031, 1.0056, 1.0100, 1.0180, 1.0353, 1.0757, 1.1781, 1.4848, 2.7368,  &
1.0027, 1.0048, 1.0079, 1.0135, 1.0252, 1.0507, 1.1109, 1.2690, 1.8149,  &
1.0025, 1.0035, 1.0060, 1.0107, 1.0190, 1.0363, 1.0747, 1.1674, 1.4280,  &
1.0022, 1.0027, 1.0053, 1.0084, 1.0151, 1.0275, 1.0536, 1.1132, 1.2632,  &
1.0017, 1.0026, 1.0043, 1.0071, 1.0121, 1.0214, 1.0405, 1.0814, 1.1774,  &
1.0012, 1.0023, 1.0030, 1.0054, 1.0098, 1.0171, 1.0314, 1.0610, 1.1269,  &
1.0010, 1.0018, 1.0023, 1.0046, 1.0076, 1.0134, 1.0246, 1.0468, 1.0942 /
data ((supersat( 2,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0027, 1.0043, 1.0078, 1.0139, 1.0269, 1.0571, 1.1319, 1.3374, 2.0923,  &
1.0016, 1.0038, 1.0061, 1.0104, 1.0190, 1.0376, 1.0815, 1.1921, 1.5182,  &
1.0016, 1.0029, 1.0044, 1.0082, 1.0142, 1.0266, 1.0541, 1.1193, 1.2898,  &
1.0016, 1.0017, 1.0041, 1.0066, 1.0112, 1.0201, 1.0385, 1.0799, 1.1802,  &
1.0014, 1.0016, 1.0034, 1.0053, 1.0090, 1.0157, 1.0289, 1.0571, 1.1214,  &
1.0012, 1.0015, 1.0024, 1.0041, 1.0070, 1.0125, 1.0225, 1.0427, 1.0867,  &
1.0010, 1.0013, 1.0018, 1.0035, 1.0058, 1.0100, 1.0177, 1.0328, 1.0645 /
data ((supersat( 2,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0025, 1.0037, 1.0064, 1.0111, 1.0214, 1.0453, 1.1038, 1.2574, 1.7375,  &
1.0017, 1.0030, 1.0049, 1.0083, 1.0149, 1.0294, 1.0632, 1.1472, 1.3767,  &
1.0010, 1.0025, 1.0036, 1.0064, 1.0111, 1.0205, 1.0413, 1.0903, 1.2142,  &
1.0006, 1.0018, 1.0031, 1.0052, 1.0086, 1.0153, 1.0289, 1.0595, 1.1323,  &
1.0006, 1.0012, 1.0027, 1.0041, 1.0070, 1.0118, 1.0216, 1.0419, 1.0879,  &
1.0005, 1.0009, 1.0022, 1.0030, 1.0054, 1.0095, 1.0166, 1.0311, 1.0622,  &
1.0005, 1.0008, 1.0016, 1.0027, 1.0045, 1.0074, 1.0132, 1.0240, 1.0461 /
data ((supersat( 2,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0020, 1.0033, 1.0054, 1.0093, 1.0178, 1.0375, 1.0855, 1.2089, 1.5630,  &
1.0017, 1.0021, 1.0040, 1.0068, 1.0122, 1.0239, 1.0514, 1.1192, 1.2972,  &
1.0013, 1.0020, 1.0032, 1.0053, 1.0090, 1.0164, 1.0330, 1.0720, 1.1692,  &
1.0008, 1.0018, 1.0021, 1.0041, 1.0069, 1.0120, 1.0227, 1.0465, 1.1029,  &
1.0006, 1.0014, 1.0020, 1.0034, 1.0056, 1.0094, 1.0168, 1.0322, 1.0671,  &
1.0005, 1.0011, 1.0018, 1.0025, 1.0042, 1.0075, 1.0129, 1.0237, 1.0468,  &
1.0005, 1.0008, 1.0015, 1.0019, 1.0036, 1.0058, 1.0100, 1.0181, 1.0344 /
data ((supersat( 2,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0015, 1.0028, 1.0046, 1.0080, 1.0152, 1.0319, 1.0728, 1.1764, 1.4610,  &
1.0011, 1.0022, 1.0034, 1.0058, 1.0104, 1.0202, 1.0433, 1.1002, 1.2468,  &
1.0011, 1.0013, 1.0028, 1.0045, 1.0075, 1.0137, 1.0274, 1.0598, 1.1400,  &
1.0010, 1.0011, 1.0022, 1.0032, 1.0058, 1.0099, 1.0186, 1.0379, 1.0840,  &
1.0009, 1.0011, 1.0014, 1.0029, 1.0046, 1.0077, 1.0135, 1.0258, 1.0537,  &
1.0007, 1.0010, 1.0011, 1.0023, 1.0035, 1.0061, 1.0103, 1.0188, 1.0368,  &
1.0006, 1.0008, 1.0009, 1.0017, 1.0028, 1.0047, 1.0081, 1.0143, 1.0268 /
data ((supersat( 3,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0071, 1.0117, 1.0200, 1.0362, 1.0720, 1.1593, 1.4119, 2.7073, 4.9866,  &
1.0054, 1.0091, 1.0157, 1.0278, 1.0523, 1.1078, 1.2490, 1.7178, 4.0203,  &
1.0051, 1.0081, 1.0128, 1.0222, 1.0402, 1.0782, 1.1675, 1.4129, 2.5447,  &
1.0044, 1.0063, 1.0110, 1.0183, 1.0319, 1.0596, 1.1206, 1.2719, 1.7557,  &
1.0032, 1.0053, 1.0088, 1.0151, 1.0257, 1.0469, 1.0909, 1.1929, 1.4713,  &
1.0023, 1.0048, 1.0077, 1.0121, 1.0212, 1.0376, 1.0705, 1.1430, 1.3236,  &
1.0018, 1.0039, 1.0059, 1.0101, 1.0172, 1.0302, 1.0555, 1.1089, 1.2337 /
data ((supersat( 3,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0053, 1.0087, 1.0146, 1.0259, 1.0500, 1.1071, 1.2591, 1.8042, 3.7156,  &
1.0040, 1.0069, 1.0116, 1.0199, 1.0365, 1.0727, 1.1610, 1.4126, 2.5898,  &
1.0038, 1.0060, 1.0096, 1.0159, 1.0280, 1.0530, 1.1095, 1.2525, 1.7182,  &
1.0034, 1.0042, 1.0074, 1.0131, 1.0223, 1.0407, 1.0795, 1.1707, 1.4198,  &
1.0026, 1.0039, 1.0067, 1.0105, 1.0184, 1.0323, 1.0605, 1.1231, 1.2781,  &
1.0018, 1.0036, 1.0056, 1.0091, 1.0151, 1.0260, 1.0475, 1.0926, 1.1975,  &
1.0014, 1.0030, 1.0040, 1.0069, 1.0123, 1.0212, 1.0379, 1.0716, 1.1463 /
data ((supersat( 3,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0042, 1.0067, 1.0109, 1.0194, 1.0366, 1.0765, 1.1785, 1.4853, 2.7366,  &
1.0027, 1.0054, 1.0085, 1.0148, 1.0266, 1.0518, 1.1116, 1.2695, 1.8156,  &
1.0027, 1.0045, 1.0072, 1.0117, 1.0204, 1.0376, 1.0757, 1.1682, 1.4289,  &
1.0026, 1.0031, 1.0057, 1.0096, 1.0163, 1.0289, 1.0550, 1.1143, 1.2642,  &
1.0022, 1.0027, 1.0052, 1.0081, 1.0134, 1.0230, 1.0420, 1.0828, 1.1788,  &
1.0018, 1.0026, 1.0041, 1.0065, 1.0110, 1.0187, 1.0332, 1.0628, 1.1287,  &
1.0013, 1.0023, 1.0029, 1.0054, 1.0089, 1.0153, 1.0267, 1.0490, 1.0965 /
data ((supersat( 3,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0035, 1.0054, 1.0087, 1.0151, 1.0281, 1.0579, 1.1323, 1.3378, 2.0925,  &
1.0025, 1.0042, 1.0067, 1.0114, 1.0202, 1.0388, 1.0821, 1.1925, 1.5186,  &
1.0016, 1.0037, 1.0056, 1.0091, 1.0154, 1.0279, 1.0552, 1.1199, 1.2903,  &
1.0016, 1.0027, 1.0044, 1.0071, 1.0121, 1.0213, 1.0398, 1.0809, 1.1810,  &
1.0016, 1.0017, 1.0040, 1.0063, 1.0098, 1.0168, 1.0303, 1.0584, 1.1225,  &
1.0015, 1.0016, 1.0033, 1.0048, 1.0083, 1.0138, 1.0239, 1.0444, 1.0883,  &
1.0013, 1.0015, 1.0024, 1.0041, 1.0067, 1.0113, 1.0192, 1.0348, 1.0665 /
data ((supersat( 3,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0029, 1.0045, 1.0072, 1.0123, 1.0226, 1.0461, 1.1042, 1.2577, 1.7375,  &
1.0024, 1.0032, 1.0054, 1.0092, 1.0161, 1.0305, 1.0639, 1.1476, 1.3772,  &
1.0016, 1.0030, 1.0046, 1.0073, 1.0121, 1.0217, 1.0423, 1.0909, 1.2147,  &
1.0009, 1.0025, 1.0032, 1.0056, 1.0096, 1.0163, 1.0301, 1.0604, 1.1329,  &
1.0006, 1.0018, 1.0031, 1.0050, 1.0077, 1.0130, 1.0228, 1.0431, 1.0889,  &
1.0006, 1.0012, 1.0027, 1.0038, 1.0064, 1.0104, 1.0181, 1.0326, 1.0636,  &
1.0005, 1.0009, 1.0022, 1.0031, 1.0053, 1.0086, 1.0144, 1.0255, 1.0478 /
data ((supersat( 3,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0022, 1.0039, 1.0060, 1.0104, 1.0189, 1.0383, 1.0859, 1.2091, 1.5633,  &
1.0020, 1.0030, 1.0046, 1.0077, 1.0133, 1.0250, 1.0521, 1.1195, 1.2975,  &
1.0017, 1.0021, 1.0038, 1.0060, 1.0099, 1.0176, 1.0340, 1.0726, 1.1695,  &
1.0014, 1.0020, 1.0029, 1.0046, 1.0078, 1.0132, 1.0239, 1.0474, 1.1035,  &
1.0009, 1.0018, 1.0021, 1.0040, 1.0062, 1.0103, 1.0179, 1.0334, 1.0680,  &
1.0006, 1.0015, 1.0020, 1.0033, 1.0051, 1.0083, 1.0141, 1.0250, 1.0480,  &
1.0005, 1.0011, 1.0018, 1.0023, 1.0041, 1.0067, 1.0113, 1.0196, 1.0359 /
data ((supersat( 3,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0022, 1.0032, 1.0054, 1.0090, 1.0163, 1.0328, 1.0732, 1.1765, 1.4612,  &
1.0015, 1.0027, 1.0041, 1.0065, 1.0113, 1.0212, 1.0440, 1.1005, 1.2471,  &
1.0010, 1.0020, 1.0031, 1.0050, 1.0083, 1.0147, 1.0283, 1.0604, 1.1403,  &
1.0010, 1.0013, 1.0027, 1.0041, 1.0065, 1.0109, 1.0196, 1.0388, 1.0845,  &
1.0010, 1.0011, 1.0021, 1.0031, 1.0051, 1.0085, 1.0146, 1.0269, 1.0546,  &
1.0009, 1.0011, 1.0013, 1.0029, 1.0043, 1.0068, 1.0114, 1.0200, 1.0380,  &
1.0008, 1.0010, 1.0011, 1.0023, 1.0032, 1.0054, 1.0090, 1.0156, 1.0282 /
data ((supersat( 3,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0060, 1.0108, 1.0187, 1.0349, 1.0708, 1.1585, 1.4113, 2.7062, 4.9854,  &
1.0052, 1.0087, 1.0149, 1.0267, 1.0511, 1.1067, 1.2482, 1.7168, 4.0178,  &
1.0046, 1.0073, 1.0120, 1.0211, 1.0388, 1.0768, 1.1663, 1.4116, 2.5423,  &
1.0036, 1.0053, 1.0098, 1.0171, 1.0305, 1.0580, 1.1191, 1.2703, 1.7534,  &
1.0025, 1.0049, 1.0082, 1.0139, 1.0244, 1.0451, 1.0890, 1.1909, 1.4686,  &
1.0019, 1.0041, 1.0066, 1.0112, 1.0196, 1.0356, 1.0683, 1.1406, 1.3204,  &
1.0016, 1.0031, 1.0047, 1.0086, 1.0153, 1.0279, 1.0529, 1.1058, 1.2299 /
data ((supersat( 3,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0042, 1.0077, 1.0135, 1.0247, 1.0488, 1.1063, 1.2587, 1.8037, 3.7147,  &
1.0039, 1.0065, 1.0105, 1.0187, 1.0352, 1.0717, 1.1603, 1.4119, 2.5893,  &
1.0035, 1.0050, 1.0088, 1.0150, 1.0268, 1.0517, 1.1084, 1.2516, 1.7172,  &
1.0028, 1.0040, 1.0070, 1.0122, 1.0212, 1.0392, 1.0782, 1.1695, 1.4185,  &
1.0019, 1.0037, 1.0061, 1.0099, 1.0170, 1.0307, 1.0589, 1.1215, 1.2764,  &
1.0014, 1.0031, 1.0045, 1.0080, 1.0137, 1.0245, 1.0457, 1.0907, 1.1954,  &
1.0012, 1.0024, 1.0034, 1.0062, 1.0110, 1.0195, 1.0358, 1.0693, 1.1436 /
data ((supersat( 3,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0033, 1.0057, 1.0102, 1.0182, 1.0354, 1.0757, 1.1780, 1.4850, 2.7367,  &
1.0027, 1.0050, 1.0080, 1.0137, 1.0254, 1.0507, 1.1109, 1.2690, 1.8150,  &
1.0026, 1.0037, 1.0062, 1.0109, 1.0193, 1.0365, 1.0747, 1.1674, 1.4282,  &
1.0023, 1.0027, 1.0054, 1.0085, 1.0153, 1.0277, 1.0538, 1.1133, 1.2634,  &
1.0018, 1.0026, 1.0045, 1.0074, 1.0124, 1.0217, 1.0407, 1.0815, 1.1776,  &
1.0013, 1.0024, 1.0032, 1.0055, 1.0101, 1.0174, 1.0317, 1.0612, 1.1271,  &
1.0011, 1.0019, 1.0024, 1.0048, 1.0079, 1.0138, 1.0251, 1.0472, 1.0945 /
data ((supersat( 3,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0029, 1.0045, 1.0080, 1.0141, 1.0270, 1.0571, 1.1319, 1.3375, 2.0919,  &
1.0017, 1.0039, 1.0063, 1.0106, 1.0192, 1.0377, 1.0814, 1.1921, 1.5182,  &
1.0016, 1.0031, 1.0047, 1.0084, 1.0144, 1.0268, 1.0542, 1.1193, 1.2898,  &
1.0016, 1.0019, 1.0041, 1.0067, 1.0114, 1.0203, 1.0387, 1.0800, 1.1803,  &
1.0015, 1.0016, 1.0035, 1.0055, 1.0091, 1.0159, 1.0292, 1.0572, 1.1215,  &
1.0013, 1.0015, 1.0026, 1.0042, 1.0073, 1.0128, 1.0228, 1.0430, 1.0869,  &
1.0010, 1.0013, 1.0019, 1.0037, 1.0061, 1.0103, 1.0181, 1.0332, 1.0648 /
data ((supersat( 3,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0026, 1.0039, 1.0065, 1.0113, 1.0216, 1.0453, 1.1037, 1.2574, 1.7374,  &
1.0019, 1.0030, 1.0051, 1.0085, 1.0151, 1.0295, 1.0632, 1.1472, 1.3769,  &
1.0011, 1.0027, 1.0039, 1.0066, 1.0113, 1.0207, 1.0413, 1.0903, 1.2143,  &
1.0006, 1.0020, 1.0031, 1.0053, 1.0089, 1.0155, 1.0291, 1.0595, 1.1323,  &
1.0006, 1.0013, 1.0028, 1.0043, 1.0072, 1.0120, 1.0218, 1.0420, 1.0880,  &
1.0006, 1.0009, 1.0023, 1.0031, 1.0055, 1.0097, 1.0169, 1.0314, 1.0624,  &
1.0005, 1.0008, 1.0017, 1.0028, 1.0047, 1.0075, 1.0135, 1.0243, 1.0464 /
data ((supersat( 3,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0020, 1.0034, 1.0055, 1.0095, 1.0180, 1.0375, 1.0855, 1.2089, 1.5630,  &
1.0018, 1.0023, 1.0041, 1.0070, 1.0124, 1.0241, 1.0514, 1.1191, 1.2974,  &
1.0014, 1.0020, 1.0034, 1.0054, 1.0092, 1.0166, 1.0331, 1.0720, 1.1692,  &
1.0009, 1.0019, 1.0023, 1.0042, 1.0071, 1.0123, 1.0229, 1.0465, 1.1030,  &
1.0006, 1.0015, 1.0020, 1.0036, 1.0057, 1.0096, 1.0170, 1.0324, 1.0672,  &
1.0005, 1.0011, 1.0019, 1.0026, 1.0043, 1.0077, 1.0131, 1.0239, 1.0469,  &
1.0005, 1.0009, 1.0016, 1.0019, 1.0037, 1.0060, 1.0102, 1.0184, 1.0346 /
data ((supersat( 3,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0017, 1.0029, 1.0047, 1.0082, 1.0154, 1.0320, 1.0728, 1.1764, 1.4611,  &
1.0011, 1.0023, 1.0035, 1.0060, 1.0105, 1.0203, 1.0434, 1.1002, 1.2469,  &
1.0011, 1.0015, 1.0029, 1.0046, 1.0077, 1.0139, 1.0275, 1.0598, 1.1400,  &
1.0010, 1.0011, 1.0023, 1.0034, 1.0059, 1.0101, 1.0188, 1.0380, 1.0840,  &
1.0009, 1.0011, 1.0015, 1.0030, 1.0047, 1.0079, 1.0137, 1.0260, 1.0538,  &
1.0008, 1.0010, 1.0011, 1.0025, 1.0037, 1.0063, 1.0105, 1.0190, 1.0370,  &
1.0006, 1.0009, 1.0010, 1.0018, 1.0029, 1.0048, 1.0083, 1.0146, 1.0270 /
data ((supersat( 3,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0054, 1.0099, 1.0177, 1.0338, 1.0698, 1.1578, 1.4107, 2.7050, 4.9841,  &
1.0049, 1.0081, 1.0140, 1.0255, 1.0499, 1.1057, 1.2473, 1.7157, 4.0149,  &
1.0040, 1.0062, 1.0113, 1.0199, 1.0374, 1.0755, 1.1651, 1.4102, 2.5398,  &
1.0028, 1.0051, 1.0086, 1.0157, 1.0291, 1.0564, 1.1175, 1.2686, 1.7505,  &
1.0020, 1.0043, 1.0073, 1.0125, 1.0229, 1.0433, 1.0871, 1.1886, 1.4654,  &
1.0016, 1.0033, 1.0054, 1.0099, 1.0177, 1.0335, 1.0659, 1.1377, 1.3166,  &
1.0013, 1.0023, 1.0037, 1.0070, 1.0133, 1.0256, 1.0501, 1.1024, 1.2252 /
data ((supersat( 3,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0039, 1.0070, 1.0125, 1.0236, 1.0479, 1.1056, 1.2582, 1.8032, 3.7138,  &
1.0036, 1.0059, 1.0098, 1.0178, 1.0341, 1.0708, 1.1596, 1.4113, 2.5879,  &
1.0030, 1.0040, 1.0078, 1.0139, 1.0257, 1.0506, 1.1074, 1.2507, 1.7159,  &
1.0021, 1.0038, 1.0066, 1.0112, 1.0201, 1.0380, 1.0769, 1.1683, 1.4170,  &
1.0015, 1.0033, 1.0052, 1.0091, 1.0157, 1.0294, 1.0574, 1.1199, 1.2746,  &
1.0012, 1.0025, 1.0036, 1.0067, 1.0124, 1.0230, 1.0438, 1.0887, 1.1930,  &
1.0011, 1.0018, 1.0028, 1.0053, 1.0095, 1.0176, 1.0337, 1.0668, 1.1406 /
data ((supersat( 3,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0027, 1.0054, 1.0095, 1.0173, 1.0345, 1.0751, 1.1777, 1.4845, 2.7359,  &
1.0026, 1.0044, 1.0074, 1.0130, 1.0244, 1.0498, 1.1102, 1.2685, 1.8145,  &
1.0024, 1.0029, 1.0056, 1.0102, 1.0183, 1.0354, 1.0738, 1.1667, 1.4275,  &
1.0019, 1.0026, 1.0049, 1.0081, 1.0143, 1.0265, 1.0527, 1.1123, 1.2624,  &
1.0014, 1.0024, 1.0038, 1.0065, 1.0112, 1.0206, 1.0394, 1.0802, 1.1762,  &
1.0011, 1.0020, 1.0026, 1.0051, 1.0090, 1.0160, 1.0303, 1.0596, 1.1254,  &
1.0009, 1.0015, 1.0021, 1.0040, 1.0070, 1.0125, 1.0233, 1.0452, 1.0923 /
data ((supersat( 3,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0022, 1.0042, 1.0073, 1.0132, 1.0262, 1.0564, 1.1315, 1.3373, 2.0918,  &
1.0016, 1.0035, 1.0057, 1.0099, 1.0183, 1.0369, 1.0809, 1.1917, 1.5179,  &
1.0016, 1.0024, 1.0043, 1.0076, 1.0135, 1.0259, 1.0534, 1.1187, 1.2894,  &
1.0015, 1.0016, 1.0038, 1.0062, 1.0107, 1.0193, 1.0377, 1.0791, 1.1795,  &
1.0013, 1.0015, 1.0029, 1.0047, 1.0085, 1.0150, 1.0280, 1.0561, 1.1205,  &
1.0010, 1.0014, 1.0021, 1.0039, 1.0065, 1.0116, 1.0216, 1.0416, 1.0856,  &
1.0008, 1.0011, 1.0016, 1.0031, 1.0053, 1.0091, 1.0167, 1.0316, 1.0631 /
data ((supersat( 3,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0022, 1.0032, 1.0059, 1.0106, 1.0208, 1.0447, 1.1034, 1.2573, 1.7372,  &
1.0013, 1.0028, 1.0046, 1.0077, 1.0143, 1.0287, 1.0627, 1.1469, 1.3767,  &
1.0007, 1.0023, 1.0032, 1.0059, 1.0106, 1.0198, 1.0406, 1.0898, 1.2139,  &
1.0006, 1.0015, 1.0029, 1.0049, 1.0081, 1.0146, 1.0282, 1.0588, 1.1317,  &
1.0006, 1.0010, 1.0025, 1.0036, 1.0065, 1.0113, 1.0208, 1.0411, 1.0871,  &
1.0005, 1.0008, 1.0019, 1.0029, 1.0051, 1.0089, 1.0159, 1.0302, 1.0612,  &
1.0004, 1.0007, 1.0014, 1.0024, 1.0040, 1.0069, 1.0123, 1.0229, 1.0449 /
data ((supersat( 3,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0019, 1.0029, 1.0050, 1.0088, 1.0172, 1.0369, 1.0852, 1.2087, 1.5629,  &
1.0015, 1.0020, 1.0038, 1.0063, 1.0117, 1.0233, 1.0509, 1.1189, 1.2972,  &
1.0011, 1.0019, 1.0028, 1.0048, 1.0085, 1.0159, 1.0323, 1.0715, 1.1689,  &
1.0007, 1.0016, 1.0020, 1.0039, 1.0064, 1.0115, 1.0221, 1.0459, 1.1025,  &
1.0005, 1.0012, 1.0019, 1.0031, 1.0052, 1.0088, 1.0161, 1.0315, 1.0665,  &
1.0005, 1.0009, 1.0016, 1.0021, 1.0040, 1.0069, 1.0122, 1.0229, 1.0459,  &
1.0004, 1.0007, 1.0012, 1.0017, 1.0032, 1.0054, 1.0094, 1.0173, 1.0334 /
data ((supersat( 3,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0012, 1.0026, 1.0043, 1.0075, 1.0146, 1.0314, 1.0725, 1.1762, 1.4609,  &
1.0011, 1.0018, 1.0031, 1.0054, 1.0099, 1.0196, 1.0429, 1.0999, 1.2467,  &
1.0010, 1.0011, 1.0026, 1.0042, 1.0071, 1.0132, 1.0268, 1.0594, 1.1397,  &
1.0010, 1.0011, 1.0018, 1.0031, 1.0053, 1.0095, 1.0180, 1.0374, 1.0836,  &
1.0008, 1.0010, 1.0012, 1.0027, 1.0043, 1.0072, 1.0130, 1.0252, 1.0531,  &
1.0006, 1.0009, 1.0010, 1.0020, 1.0031, 1.0056, 1.0098, 1.0181, 1.0361,  &
1.0005, 1.0007, 1.0008, 1.0015, 1.0026, 1.0043, 1.0076, 1.0135, 1.0259 /
data ((supersat( 3,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0052, 1.0089, 1.0169, 1.0329, 1.0690, 1.1572, 1.4100, 2.7041, 4.9828,  &
1.0045, 1.0075, 1.0131, 1.0244, 1.0489, 1.1048, 1.2464, 1.7145, 4.0118,  &
1.0033, 1.0053, 1.0104, 1.0188, 1.0362, 1.0744, 1.1639, 1.4086, 2.5364,  &
1.0022, 1.0047, 1.0081, 1.0146, 1.0276, 1.0549, 1.1159, 1.2666, 1.7470,  &
1.0017, 1.0036, 1.0063, 1.0112, 1.0213, 1.0416, 1.0851, 1.1862, 1.4613,  &
1.0013, 1.0025, 1.0043, 1.0085, 1.0162, 1.0315, 1.0634, 1.1346, 1.3119,  &
1.0009, 1.0015, 1.0028, 1.0056, 1.0115, 1.0232, 1.0469, 1.0985, 1.2196 /
data ((supersat( 3,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0038, 1.0066, 1.0119, 1.0228, 1.0471, 1.1051, 1.2578, 1.8028, 3.7130,  &
1.0033, 1.0052, 1.0093, 1.0170, 1.0333, 1.0700, 1.1590, 1.4105, 2.5866,  &
1.0025, 1.0039, 1.0070, 1.0129, 1.0247, 1.0496, 1.1065, 1.2498, 1.7145,  &
1.0017, 1.0035, 1.0060, 1.0101, 1.0190, 1.0368, 1.0757, 1.1670, 1.4152,  &
1.0013, 1.0027, 1.0044, 1.0081, 1.0148, 1.0280, 1.0559, 1.1183, 1.2724,  &
1.0011, 1.0020, 1.0031, 1.0059, 1.0113, 1.0214, 1.0421, 1.0866, 1.1903,  &
1.0008, 1.0012, 1.0021, 1.0043, 1.0080, 1.0159, 1.0315, 1.0642, 1.1372 /
data ((supersat( 3,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0027, 1.0050, 1.0087, 1.0166, 1.0339, 1.0746, 1.1774, 1.4842, 2.7352,  &
1.0025, 1.0038, 1.0068, 1.0123, 1.0237, 1.0492, 1.1097, 1.2681, 1.8138,  &
1.0021, 1.0027, 1.0053, 1.0095, 1.0175, 1.0346, 1.0731, 1.1661, 1.4267,  &
1.0015, 1.0025, 1.0044, 1.0076, 1.0133, 1.0256, 1.0517, 1.1114, 1.2614,  &
1.0011, 1.0021, 1.0031, 1.0056, 1.0104, 1.0196, 1.0381, 1.0790, 1.1749,  &
1.0009, 1.0016, 1.0022, 1.0045, 1.0079, 1.0150, 1.0288, 1.0580, 1.1235,  &
1.0006, 1.0010, 1.0016, 1.0032, 1.0060, 1.0113, 1.0217, 1.0432, 1.0899 /
data ((supersat( 3,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0017, 1.0039, 1.0066, 1.0125, 1.0255, 1.0560, 1.1312, 1.3369, 2.0916,  &
1.0016, 1.0030, 1.0051, 1.0091, 1.0176, 1.0363, 1.0804, 1.1914, 1.5175,  &
1.0015, 1.0019, 1.0041, 1.0069, 1.0129, 1.0252, 1.0527, 1.1182, 1.2889,  &
1.0013, 1.0015, 1.0034, 1.0057, 1.0099, 1.0185, 1.0368, 1.0784, 1.1789,  &
1.0011, 1.0014, 1.0024, 1.0041, 1.0078, 1.0140, 1.0270, 1.0551, 1.1195,  &
1.0008, 1.0011, 1.0017, 1.0034, 1.0059, 1.0108, 1.0203, 1.0403, 1.0842,  &
1.0005, 1.0008, 1.0013, 1.0024, 1.0044, 1.0080, 1.0153, 1.0301, 1.0612 /
data ((supersat( 3,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0017, 1.0030, 1.0052, 1.0100, 1.0202, 1.0442, 1.1032, 1.2571, 1.7372,  &
1.0010, 1.0026, 1.0041, 1.0072, 1.0137, 1.0281, 1.0623, 1.1467, 1.3763,  &
1.0006, 1.0018, 1.0030, 1.0053, 1.0099, 1.0191, 1.0400, 1.0894, 1.2136,  &
1.0006, 1.0011, 1.0027, 1.0044, 1.0074, 1.0139, 1.0275, 1.0581, 1.1312,  &
1.0005, 1.0008, 1.0021, 1.0030, 1.0058, 1.0106, 1.0199, 1.0402, 1.0863,  &
1.0004, 1.0007, 1.0015, 1.0026, 1.0046, 1.0081, 1.0150, 1.0292, 1.0601,  &
1.0004, 1.0007, 1.0011, 1.0019, 1.0033, 1.0061, 1.0112, 1.0216, 1.0434 /
data ((supersat( 3,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0017, 1.0024, 1.0044, 1.0083, 1.0166, 1.0365, 1.0850, 1.2086, 1.5628,  &
1.0012, 1.0020, 1.0035, 1.0058, 1.0111, 1.0228, 1.0506, 1.1187, 1.2969,  &
1.0008, 1.0017, 1.0023, 1.0042, 1.0078, 1.0152, 1.0318, 1.0712, 1.1687,  &
1.0005, 1.0013, 1.0020, 1.0036, 1.0059, 1.0109, 1.0214, 1.0453, 1.1021,  &
1.0005, 1.0010, 1.0017, 1.0026, 1.0045, 1.0081, 1.0153, 1.0307, 1.0658,  &
1.0004, 1.0008, 1.0013, 1.0018, 1.0036, 1.0062, 1.0114, 1.0220, 1.0450,  &
1.0004, 1.0006, 1.0009, 1.0014, 1.0026, 1.0047, 1.0086, 1.0162, 1.0322 /
data ((supersat( 3,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0011, 1.0023, 1.0039, 1.0070, 1.0141, 1.0310, 1.0723, 1.1761, 1.4609,  &
1.0011, 1.0014, 1.0029, 1.0049, 1.0093, 1.0191, 1.0425, 1.0998, 1.2466,  &
1.0010, 1.0011, 1.0022, 1.0037, 1.0065, 1.0126, 1.0263, 1.0590, 1.1395,  &
1.0008, 1.0010, 1.0014, 1.0029, 1.0048, 1.0089, 1.0174, 1.0369, 1.0832,  &
1.0006, 1.0009, 1.0010, 1.0023, 1.0038, 1.0066, 1.0123, 1.0245, 1.0526,  &
1.0005, 1.0007, 1.0009, 1.0017, 1.0028, 1.0049, 1.0091, 1.0173, 1.0353,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0021, 1.0038, 1.0068, 1.0127, 1.0249 /
data ((supersat( 3,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0050, 1.0086, 1.0165, 1.0324, 1.0686, 1.1568, 1.4095, 2.7030, 4.9815,  &
1.0042, 1.0071, 1.0125, 1.0238, 1.0484, 1.1043, 1.2459, 1.7137, 4.0094,  &
1.0029, 1.0051, 1.0099, 1.0181, 1.0356, 1.0737, 1.1632, 1.4076, 2.5341,  &
1.0020, 1.0043, 1.0077, 1.0141, 1.0269, 1.0541, 1.1150, 1.2654, 1.7447,  &
1.0015, 1.0032, 1.0057, 1.0106, 1.0204, 1.0405, 1.0838, 1.1846, 1.4586,  &
1.0011, 1.0021, 1.0038, 1.0077, 1.0152, 1.0302, 1.0619, 1.1326, 1.3088,  &
1.0007, 1.0012, 1.0023, 1.0047, 1.0103, 1.0216, 1.0450, 1.0959, 1.2158 /
data ((supersat( 3,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0037, 1.0064, 1.0116, 1.0224, 1.0468, 1.1048, 1.2575, 1.8024, 3.7122,  &
1.0031, 1.0048, 1.0090, 1.0166, 1.0328, 1.0696, 1.1586, 1.4101, 2.5855,  &
1.0022, 1.0037, 1.0068, 1.0126, 1.0242, 1.0491, 1.1060, 1.2493, 1.7137,  &
1.0015, 1.0032, 1.0056, 1.0097, 1.0183, 1.0362, 1.0750, 1.1662, 1.4141,  &
1.0012, 1.0024, 1.0039, 1.0076, 1.0142, 1.0272, 1.0550, 1.1173, 1.2711,  &
1.0009, 1.0016, 1.0027, 1.0054, 1.0106, 1.0204, 1.0410, 1.0853, 1.1886,  &
1.0006, 1.0010, 1.0018, 1.0036, 1.0072, 1.0149, 1.0301, 1.0625, 1.1349 /
data ((supersat( 3,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0026, 1.0048, 1.0084, 1.0162, 1.0335, 1.0743, 1.1772, 1.4840, 2.7350,  &
1.0024, 1.0034, 1.0065, 1.0120, 1.0233, 1.0488, 1.1095, 1.2678, 1.8135,  &
1.0019, 1.0026, 1.0051, 1.0091, 1.0171, 1.0342, 1.0727, 1.1657, 1.4261,  &
1.0013, 1.0024, 1.0040, 1.0072, 1.0130, 1.0251, 1.0512, 1.1108, 1.2607,  &
1.0010, 1.0019, 1.0027, 1.0052, 1.0100, 1.0189, 1.0375, 1.0783, 1.1740,  &
1.0008, 1.0013, 1.0019, 1.0041, 1.0073, 1.0143, 1.0279, 1.0571, 1.1224,  &
1.0005, 1.0008, 1.0014, 1.0027, 1.0053, 1.0104, 1.0207, 1.0420, 1.0884 /
data ((supersat( 3,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0016, 1.0037, 1.0064, 1.0123, 1.0252, 1.0558, 1.1311, 1.3368, 2.0912,  &
1.0016, 1.0027, 1.0048, 1.0088, 1.0172, 1.0360, 1.0802, 1.1913, 1.5174,  &
1.0015, 1.0016, 1.0039, 1.0066, 1.0126, 1.0248, 1.0524, 1.1179, 1.2885,  &
1.0012, 1.0015, 1.0031, 1.0053, 1.0095, 1.0180, 1.0364, 1.0780, 1.1785,  &
1.0009, 1.0013, 1.0021, 1.0039, 1.0073, 1.0135, 1.0265, 1.0545, 1.1189,  &
1.0006, 1.0009, 1.0015, 1.0031, 1.0055, 1.0103, 1.0197, 1.0396, 1.0833,  &
1.0004, 1.0007, 1.0011, 1.0021, 1.0039, 1.0074, 1.0145, 1.0291, 1.0602 /
data ((supersat( 3,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0015, 1.0029, 1.0051, 1.0097, 1.0199, 1.0441, 1.1031, 1.2570, 1.7370,  &
1.0008, 1.0024, 1.0038, 1.0070, 1.0134, 1.0279, 1.0621, 1.1465, 1.3762,  &
1.0006, 1.0016, 1.0030, 1.0052, 1.0095, 1.0188, 1.0397, 1.0892, 1.2134,  &
1.0006, 1.0010, 1.0025, 1.0041, 1.0072, 1.0135, 1.0271, 1.0578, 1.1309,  &
1.0005, 1.0008, 1.0018, 1.0029, 1.0054, 1.0101, 1.0194, 1.0398, 1.0859,  &
1.0004, 1.0007, 1.0013, 1.0023, 1.0042, 1.0076, 1.0145, 1.0286, 1.0595,  &
1.0004, 1.0006, 1.0009, 1.0016, 1.0029, 1.0056, 1.0105, 1.0209, 1.0426 /
data ((supersat( 3,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0016, 1.0021, 1.0041, 1.0080, 1.0163, 1.0363, 1.0849, 1.2085, 1.5627,  &
1.0011, 1.0019, 1.0032, 1.0056, 1.0108, 1.0225, 1.0504, 1.1186, 1.2968,  &
1.0007, 1.0016, 1.0020, 1.0041, 1.0076, 1.0149, 1.0316, 1.0710, 1.1685,  &
1.0005, 1.0012, 1.0019, 1.0033, 1.0057, 1.0106, 1.0211, 1.0450, 1.1019,  &
1.0005, 1.0009, 1.0016, 1.0023, 1.0042, 1.0078, 1.0149, 1.0303, 1.0655,  &
1.0004, 1.0007, 1.0011, 1.0016, 1.0033, 1.0057, 1.0110, 1.0215, 1.0445,  &
1.0003, 1.0005, 1.0007, 1.0012, 1.0023, 1.0043, 1.0080, 1.0156, 1.0315 /
data ((supersat( 3,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0011, 1.0021, 1.0037, 1.0068, 1.0139, 1.0309, 1.0722, 1.1761, 1.4608,  &
1.0010, 1.0012, 1.0028, 1.0047, 1.0090, 1.0189, 1.0424, 1.0997, 1.2465,  &
1.0009, 1.0011, 1.0020, 1.0034, 1.0063, 1.0123, 1.0261, 1.0589, 1.1394,  &
1.0007, 1.0010, 1.0013, 1.0028, 1.0047, 1.0086, 1.0171, 1.0366, 1.0831,  &
1.0006, 1.0008, 1.0010, 1.0021, 1.0035, 1.0063, 1.0120, 1.0242, 1.0523,  &
1.0004, 1.0006, 1.0008, 1.0015, 1.0026, 1.0046, 1.0087, 1.0169, 1.0348,  &
1.0003, 1.0004, 1.0006, 1.0011, 1.0018, 1.0034, 1.0063, 1.0121, 1.0243 /
data ((supersat( 3,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0049, 1.0084, 1.0162, 1.0321, 1.0684, 1.1566, 1.4093, 2.7028, 4.9808,  &
1.0039, 1.0068, 1.0122, 1.0235, 1.0480, 1.1040, 1.2456, 1.7132, 4.0079,  &
1.0027, 1.0050, 1.0095, 1.0178, 1.0352, 1.0733, 1.1627, 1.4069, 2.5323,  &
1.0018, 1.0041, 1.0074, 1.0137, 1.0264, 1.0536, 1.1143, 1.2645, 1.7430,  &
1.0014, 1.0029, 1.0053, 1.0102, 1.0198, 1.0398, 1.0829, 1.1834, 1.4565,  &
1.0009, 1.0017, 1.0034, 1.0071, 1.0144, 1.0293, 1.0607, 1.1311, 1.3064,  &
1.0006, 1.0010, 1.0018, 1.0042, 1.0094, 1.0204, 1.0436, 1.0940, 1.2128 /
data ((supersat( 3,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0036, 1.0062, 1.0114, 1.0222, 1.0466, 1.1047, 1.2574, 1.8022, 3.7116,  &
1.0029, 1.0045, 1.0087, 1.0163, 1.0326, 1.0694, 1.1584, 1.4098, 2.5849,  &
1.0020, 1.0037, 1.0066, 1.0123, 1.0239, 1.0488, 1.1057, 1.2489, 1.7130,  &
1.0014, 1.0030, 1.0053, 1.0094, 1.0179, 1.0358, 1.0746, 1.1657, 1.4132,  &
1.0011, 1.0022, 1.0036, 1.0072, 1.0137, 1.0267, 1.0544, 1.1165, 1.2700,  &
1.0008, 1.0014, 1.0024, 1.0050, 1.0101, 1.0197, 1.0402, 1.0843, 1.1872,  &
1.0005, 1.0008, 1.0015, 1.0031, 1.0066, 1.0141, 1.0291, 1.0612, 1.1332 /
data ((supersat( 3,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0026, 1.0047, 1.0081, 1.0160, 1.0334, 1.0742, 1.1771, 1.4838, 2.7346,  &
1.0023, 1.0032, 1.0062, 1.0117, 1.0231, 1.0486, 1.1093, 1.2677, 1.8134,  &
1.0017, 1.0026, 1.0050, 1.0088, 1.0169, 1.0339, 1.0725, 1.1655, 1.4258,  &
1.0012, 1.0022, 1.0038, 1.0069, 1.0127, 1.0247, 1.0508, 1.1105, 1.2603,  &
1.0009, 1.0017, 1.0025, 1.0050, 1.0097, 1.0185, 1.0370, 1.0777, 1.1733,  &
1.0007, 1.0011, 1.0018, 1.0038, 1.0070, 1.0138, 1.0273, 1.0564, 1.1215,  &
1.0004, 1.0007, 1.0012, 1.0024, 1.0048, 1.0098, 1.0200, 1.0411, 1.0873 /
data ((supersat( 3,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0016, 1.0036, 1.0062, 1.0121, 1.0251, 1.0557, 1.1310, 1.3367, 2.0914,  &
1.0015, 1.0025, 1.0046, 1.0086, 1.0170, 1.0358, 1.0801, 1.1911, 1.5171,  &
1.0014, 1.0016, 1.0038, 1.0065, 1.0124, 1.0246, 1.0522, 1.1178, 1.2883,  &
1.0011, 1.0014, 1.0029, 1.0051, 1.0092, 1.0177, 1.0361, 1.0777, 1.1782,  &
1.0008, 1.0012, 1.0020, 1.0037, 1.0070, 1.0132, 1.0261, 1.0542, 1.1184,  &
1.0005, 1.0008, 1.0014, 1.0028, 1.0052, 1.0099, 1.0193, 1.0391, 1.0827,  &
1.0004, 1.0006, 1.0010, 1.0018, 1.0035, 1.0070, 1.0140, 1.0284, 1.0594 /
data ((supersat( 3,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0014, 1.0028, 1.0050, 1.0095, 1.0197, 1.0440, 1.1030, 1.2569, 1.7369,  &
1.0007, 1.0022, 1.0036, 1.0068, 1.0132, 1.0277, 1.0620, 1.1465, 1.3761,  &
1.0006, 1.0015, 1.0029, 1.0051, 1.0093, 1.0186, 1.0396, 1.0890, 1.2133,  &
1.0005, 1.0009, 1.0024, 1.0039, 1.0070, 1.0132, 1.0269, 1.0576, 1.1307,  &
1.0004, 1.0008, 1.0017, 1.0028, 1.0051, 1.0098, 1.0191, 1.0394, 1.0856,  &
1.0004, 1.0007, 1.0012, 1.0021, 1.0040, 1.0073, 1.0141, 1.0281, 1.0590,  &
1.0003, 1.0005, 1.0008, 1.0013, 1.0027, 1.0052, 1.0101, 1.0203, 1.0420 /
data ((supersat( 3,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0015, 1.0020, 1.0040, 1.0078, 1.0162, 1.0362, 1.0848, 1.2085, 1.5627,  &
1.0010, 1.0019, 1.0031, 1.0055, 1.0106, 1.0224, 1.0503, 1.1185, 1.2967,  &
1.0006, 1.0015, 1.0020, 1.0040, 1.0075, 1.0148, 1.0314, 1.0709, 1.1684,  &
1.0005, 1.0011, 1.0018, 1.0032, 1.0056, 1.0104, 1.0209, 1.0449, 1.1017,  &
1.0004, 1.0008, 1.0015, 1.0021, 1.0040, 1.0076, 1.0147, 1.0301, 1.0652,  &
1.0004, 1.0006, 1.0010, 1.0015, 1.0031, 1.0055, 1.0107, 1.0212, 1.0441,  &
1.0003, 1.0004, 1.0006, 1.0011, 1.0021, 1.0040, 1.0077, 1.0151, 1.0309 /
data ((supersat( 3,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0011, 1.0020, 1.0035, 1.0067, 1.0138, 1.0308, 1.0722, 1.1760, 1.4608,  &
1.0010, 1.0011, 1.0027, 1.0046, 1.0089, 1.0187, 1.0423, 1.0996, 1.2464,  &
1.0009, 1.0010, 1.0019, 1.0033, 1.0062, 1.0121, 1.0260, 1.0588, 1.1394,  &
1.0007, 1.0009, 1.0012, 1.0027, 1.0045, 1.0084, 1.0169, 1.0365, 1.0829,  &
1.0005, 1.0007, 1.0009, 1.0020, 1.0033, 1.0061, 1.0117, 1.0240, 1.0521,  &
1.0003, 1.0005, 1.0007, 1.0014, 1.0024, 1.0044, 1.0084, 1.0166, 1.0345,  &
1.0002, 1.0004, 1.0006, 1.0009, 1.0016, 1.0031, 1.0060, 1.0118, 1.0238 /
data ((supersat( 3,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0048, 1.0083, 1.0160, 1.0319, 1.0682, 1.1564, 1.4090, 2.7022, 4.9802,  &
1.0037, 1.0065, 1.0119, 1.0233, 1.0478, 1.1037, 1.2453, 1.7126, 4.0065,  &
1.0025, 1.0048, 1.0092, 1.0175, 1.0349, 1.0729, 1.1623, 1.4063, 2.5309,  &
1.0018, 1.0039, 1.0071, 1.0134, 1.0261, 1.0531, 1.1138, 1.2637, 1.7415,  &
1.0013, 1.0026, 1.0050, 1.0098, 1.0193, 1.0392, 1.0822, 1.1824, 1.4548,  &
1.0008, 1.0015, 1.0031, 1.0066, 1.0138, 1.0285, 1.0598, 1.1298, 1.3043,  &
1.0005, 1.0008, 1.0016, 1.0037, 1.0087, 1.0195, 1.0424, 1.0923, 1.2103 /
data ((supersat( 3,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0035, 1.0061, 1.0112, 1.0220, 1.0465, 1.1045, 1.2572, 1.8021, 3.7113,  &
1.0027, 1.0043, 1.0086, 1.0161, 1.0324, 1.0692, 1.1582, 1.4095, 2.5844,  &
1.0019, 1.0036, 1.0065, 1.0121, 1.0236, 1.0485, 1.1054, 1.2485, 1.7124,  &
1.0013, 1.0029, 1.0050, 1.0092, 1.0177, 1.0354, 1.0742, 1.1652, 1.4125,  &
1.0010, 1.0020, 1.0034, 1.0068, 1.0133, 1.0263, 1.0539, 1.1159, 1.2691,  &
1.0007, 1.0012, 1.0022, 1.0047, 1.0096, 1.0192, 1.0395, 1.0835, 1.1861,  &
1.0004, 1.0007, 1.0013, 1.0027, 1.0061, 1.0134, 1.0283, 1.0602, 1.1318 /
data ((supersat( 3,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0025, 1.0045, 1.0079, 1.0159, 1.0332, 1.0741, 1.1770, 1.4838, 2.7346,  &
1.0022, 1.0030, 1.0060, 1.0115, 1.0229, 1.0485, 1.1091, 1.2675, 1.8131,  &
1.0016, 1.0025, 1.0049, 1.0086, 1.0167, 1.0337, 1.0723, 1.1653, 1.4255,  &
1.0011, 1.0021, 1.0036, 1.0067, 1.0125, 1.0245, 1.0506, 1.1102, 1.2599,  &
1.0009, 1.0016, 1.0024, 1.0048, 1.0094, 1.0182, 1.0367, 1.0773, 1.1728,  &
1.0006, 1.0010, 1.0017, 1.0035, 1.0067, 1.0134, 1.0269, 1.0558, 1.1208,  &
1.0004, 1.0006, 1.0010, 1.0021, 1.0045, 1.0094, 1.0194, 1.0404, 1.0864 /
data ((supersat( 3,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0016, 1.0035, 1.0061, 1.0119, 1.0250, 1.0556, 1.1310, 1.3367, 2.0912,  &
1.0015, 1.0024, 1.0044, 1.0085, 1.0168, 1.0357, 1.0800, 1.1911, 1.5170,  &
1.0013, 1.0015, 1.0037, 1.0064, 1.0122, 1.0244, 1.0521, 1.1176, 1.2881,  &
1.0010, 1.0014, 1.0027, 1.0049, 1.0090, 1.0175, 1.0359, 1.0775, 1.1779,  &
1.0007, 1.0011, 1.0018, 1.0036, 1.0068, 1.0129, 1.0258, 1.0538, 1.1181,  &
1.0004, 1.0007, 1.0013, 1.0026, 1.0050, 1.0096, 1.0189, 1.0387, 1.0822,  &
1.0003, 1.0005, 1.0008, 1.0016, 1.0033, 1.0066, 1.0136, 1.0279, 1.0587 /
data ((supersat( 3,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0012, 1.0028, 1.0049, 1.0094, 1.0197, 1.0439, 1.1030, 1.2568, 1.7369,  &
1.0007, 1.0021, 1.0035, 1.0067, 1.0130, 1.0276, 1.0619, 1.1464, 1.3760,  &
1.0006, 1.0014, 1.0028, 1.0050, 1.0092, 1.0185, 1.0394, 1.0889, 1.2131,  &
1.0005, 1.0009, 1.0022, 1.0037, 1.0069, 1.0131, 1.0267, 1.0574, 1.1305,  &
1.0004, 1.0007, 1.0016, 1.0027, 1.0049, 1.0096, 1.0189, 1.0392, 1.0853,  &
1.0004, 1.0006, 1.0011, 1.0020, 1.0038, 1.0070, 1.0138, 1.0278, 1.0586,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0024, 1.0049, 1.0098, 1.0199, 1.0415 /
data ((supersat( 3,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0014, 1.0020, 1.0039, 1.0077, 1.0161, 1.0361, 1.0848, 1.2084, 1.5626,  &
1.0009, 1.0018, 1.0030, 1.0054, 1.0105, 1.0223, 1.0502, 1.1185, 1.2967,  &
1.0006, 1.0014, 1.0020, 1.0039, 1.0074, 1.0146, 1.0313, 1.0708, 1.1684,  &
1.0005, 1.0010, 1.0018, 1.0031, 1.0054, 1.0103, 1.0207, 1.0447, 1.1016,  &
1.0004, 1.0008, 1.0014, 1.0020, 1.0038, 1.0074, 1.0145, 1.0299, 1.0650,  &
1.0004, 1.0006, 1.0009, 1.0014, 1.0029, 1.0053, 1.0104, 1.0209, 1.0438,  &
1.0003, 1.0004, 1.0006, 1.0010, 1.0019, 1.0037, 1.0074, 1.0148, 1.0305 /
data ((supersat( 3,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0011, 1.0019, 1.0034, 1.0065, 1.0137, 1.0307, 1.0721, 1.1760, 1.4607,  &
1.0010, 1.0011, 1.0026, 1.0045, 1.0088, 1.0187, 1.0423, 1.0996, 1.2463,  &
1.0008, 1.0010, 1.0018, 1.0031, 1.0061, 1.0120, 1.0259, 1.0588, 1.1393,  &
1.0006, 1.0009, 1.0011, 1.0026, 1.0044, 1.0083, 1.0168, 1.0364, 1.0828,  &
1.0005, 1.0007, 1.0009, 1.0019, 1.0032, 1.0060, 1.0116, 1.0238, 1.0519,  &
1.0003, 1.0004, 1.0007, 1.0013, 1.0023, 1.0042, 1.0082, 1.0164, 1.0343,  &
1.0002, 1.0003, 1.0005, 1.0008, 1.0015, 1.0029, 1.0057, 1.0115, 1.0235 /
data ((supersat( 4,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0051, 1.0088, 1.0168, 1.0327, 1.0688, 1.1570, 1.4097, 2.7037, 4.9826,  &
1.0044, 1.0074, 1.0129, 1.0242, 1.0487, 1.1046, 1.2462, 1.7141, 4.0109,  &
1.0032, 1.0052, 1.0103, 1.0186, 1.0361, 1.0741, 1.1636, 1.4081, 2.5354,  &
1.0022, 1.0046, 1.0080, 1.0146, 1.0274, 1.0547, 1.1156, 1.2661, 1.7462,  &
1.0017, 1.0036, 1.0063, 1.0111, 1.0211, 1.0413, 1.0847, 1.1856, 1.4602,  &
1.0013, 1.0025, 1.0043, 1.0084, 1.0160, 1.0312, 1.0630, 1.1340, 1.3106,  &
1.0009, 1.0015, 1.0028, 1.0055, 1.0114, 1.0229, 1.0464, 1.0977, 1.2183 /
data ((supersat( 4,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0038, 1.0066, 1.0119, 1.0226, 1.0470, 1.1050, 1.2576, 1.8027, 3.7127,  &
1.0033, 1.0051, 1.0093, 1.0169, 1.0331, 1.0698, 1.1588, 1.4103, 2.5863,  &
1.0025, 1.0039, 1.0070, 1.0129, 1.0246, 1.0494, 1.1063, 1.2495, 1.7142,  &
1.0017, 1.0034, 1.0059, 1.0100, 1.0188, 1.0366, 1.0755, 1.1667, 1.4147,  &
1.0013, 1.0027, 1.0043, 1.0081, 1.0147, 1.0279, 1.0557, 1.1180, 1.2718,  &
1.0011, 1.0019, 1.0030, 1.0059, 1.0112, 1.0212, 1.0418, 1.0862, 1.1898,  &
1.0008, 1.0012, 1.0021, 1.0042, 1.0079, 1.0158, 1.0312, 1.0637, 1.1365 /
data ((supersat( 4,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0027, 1.0050, 1.0087, 1.0165, 1.0337, 1.0745, 1.1773, 1.4841, 2.7355,  &
1.0025, 1.0037, 1.0068, 1.0122, 1.0235, 1.0490, 1.1096, 1.2680, 1.8138,  &
1.0021, 1.0027, 1.0053, 1.0095, 1.0174, 1.0344, 1.0730, 1.1660, 1.4264,  &
1.0015, 1.0025, 1.0044, 1.0075, 1.0133, 1.0254, 1.0515, 1.1112, 1.2611,  &
1.0011, 1.0021, 1.0030, 1.0055, 1.0104, 1.0194, 1.0380, 1.0788, 1.1746,  &
1.0009, 1.0015, 1.0022, 1.0045, 1.0078, 1.0149, 1.0286, 1.0578, 1.1232,  &
1.0006, 1.0010, 1.0016, 1.0032, 1.0059, 1.0112, 1.0216, 1.0429, 1.0895 /
data ((supersat( 4,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0039, 1.0065, 1.0125, 1.0254, 1.0559, 1.1312, 1.3369, 2.0915,  &
1.0016, 1.0030, 1.0051, 1.0091, 1.0175, 1.0362, 1.0803, 1.1913, 1.5174,  &
1.0015, 1.0018, 1.0041, 1.0068, 1.0129, 1.0251, 1.0526, 1.1181, 1.2887,  &
1.0013, 1.0015, 1.0033, 1.0056, 1.0098, 1.0184, 1.0367, 1.0783, 1.1787,  &
1.0011, 1.0014, 1.0024, 1.0041, 1.0077, 1.0139, 1.0269, 1.0549, 1.1193,  &
1.0008, 1.0011, 1.0017, 1.0034, 1.0059, 1.0107, 1.0202, 1.0401, 1.0840,  &
1.0005, 1.0007, 1.0013, 1.0024, 1.0044, 1.0080, 1.0152, 1.0299, 1.0610 /
data ((supersat( 4,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0030, 1.0052, 1.0099, 1.0201, 1.0441, 1.1031, 1.2569, 1.7370,  &
1.0010, 1.0025, 1.0041, 1.0071, 1.0136, 1.0280, 1.0622, 1.1466, 1.3762,  &
1.0006, 1.0018, 1.0030, 1.0053, 1.0098, 1.0190, 1.0399, 1.0893, 1.2135,  &
1.0006, 1.0012, 1.0027, 1.0044, 1.0074, 1.0138, 1.0274, 1.0580, 1.1311,  &
1.0005, 1.0008, 1.0021, 1.0030, 1.0057, 1.0105, 1.0198, 1.0401, 1.0862,  &
1.0004, 1.0007, 1.0015, 1.0025, 1.0045, 1.0080, 1.0149, 1.0290, 1.0599,  &
1.0004, 1.0007, 1.0011, 1.0019, 1.0033, 1.0060, 1.0111, 1.0215, 1.0433 /
data ((supersat( 4,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0024, 1.0044, 1.0082, 1.0165, 1.0364, 1.0849, 1.2085, 1.5628,  &
1.0012, 1.0020, 1.0034, 1.0058, 1.0110, 1.0227, 1.0505, 1.1186, 1.2968,  &
1.0008, 1.0017, 1.0023, 1.0042, 1.0078, 1.0152, 1.0317, 1.0711, 1.1686,  &
1.0005, 1.0013, 1.0020, 1.0035, 1.0059, 1.0109, 1.0213, 1.0452, 1.1020,  &
1.0005, 1.0010, 1.0017, 1.0026, 1.0045, 1.0080, 1.0152, 1.0306, 1.0657,  &
1.0004, 1.0008, 1.0013, 1.0018, 1.0036, 1.0061, 1.0114, 1.0219, 1.0449,  &
1.0004, 1.0006, 1.0009, 1.0013, 1.0026, 1.0047, 1.0085, 1.0161, 1.0320 /
data ((supersat( 4,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0011, 1.0023, 1.0038, 1.0070, 1.0140, 1.0309, 1.0722, 1.1760, 1.4608,  &
1.0011, 1.0014, 1.0029, 1.0049, 1.0092, 1.0190, 1.0425, 1.0997, 1.2464,  &
1.0010, 1.0011, 1.0022, 1.0037, 1.0065, 1.0125, 1.0262, 1.0590, 1.1395,  &
1.0008, 1.0010, 1.0014, 1.0029, 1.0048, 1.0089, 1.0173, 1.0368, 1.0832,  &
1.0006, 1.0009, 1.0010, 1.0023, 1.0038, 1.0065, 1.0123, 1.0245, 1.0525,  &
1.0005, 1.0007, 1.0008, 1.0017, 1.0028, 1.0049, 1.0091, 1.0173, 1.0352,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0021, 1.0037, 1.0067, 1.0126, 1.0248 /
data ((supersat( 4,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0049, 1.0084, 1.0161, 1.0320, 1.0683, 1.1566, 1.4092, 2.7024, 4.9808,  &
1.0039, 1.0067, 1.0121, 1.0235, 1.0479, 1.1039, 1.2454, 1.7129, 4.0075,  &
1.0027, 1.0050, 1.0095, 1.0177, 1.0352, 1.0732, 1.1626, 1.4066, 2.5319,  &
1.0018, 1.0041, 1.0073, 1.0137, 1.0264, 1.0535, 1.1142, 1.2642, 1.7426,  &
1.0014, 1.0029, 1.0053, 1.0101, 1.0197, 1.0397, 1.0828, 1.1832, 1.4560,  &
1.0009, 1.0017, 1.0034, 1.0070, 1.0144, 1.0292, 1.0605, 1.1308, 1.3055,  &
1.0006, 1.0010, 1.0018, 1.0041, 1.0094, 1.0203, 1.0434, 1.0936, 1.2121 /
data ((supersat( 4,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0036, 1.0062, 1.0113, 1.0221, 1.0465, 1.1046, 1.2573, 1.8022, 3.7116,  &
1.0029, 1.0045, 1.0087, 1.0163, 1.0325, 1.0693, 1.1583, 1.4097, 2.5848,  &
1.0020, 1.0036, 1.0066, 1.0123, 1.0238, 1.0487, 1.1056, 1.2487, 1.7128,  &
1.0014, 1.0030, 1.0053, 1.0094, 1.0179, 1.0357, 1.0745, 1.1656, 1.4129,  &
1.0011, 1.0022, 1.0036, 1.0071, 1.0137, 1.0266, 1.0543, 1.1164, 1.2696,  &
1.0008, 1.0014, 1.0024, 1.0050, 1.0100, 1.0197, 1.0400, 1.0841, 1.1869,  &
1.0005, 1.0008, 1.0015, 1.0031, 1.0066, 1.0140, 1.0290, 1.0610, 1.1329 /
data ((supersat( 4,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0026, 1.0047, 1.0081, 1.0160, 1.0333, 1.0742, 1.1770, 1.4839, 2.7348,  &
1.0023, 1.0032, 1.0062, 1.0117, 1.0230, 1.0486, 1.1093, 1.2675, 1.8133,  &
1.0017, 1.0026, 1.0050, 1.0088, 1.0168, 1.0338, 1.0724, 1.1655, 1.4256,  &
1.0012, 1.0022, 1.0038, 1.0069, 1.0127, 1.0247, 1.0508, 1.1104, 1.2600,  &
1.0009, 1.0017, 1.0025, 1.0050, 1.0097, 1.0184, 1.0370, 1.0777, 1.1732,  &
1.0007, 1.0011, 1.0018, 1.0038, 1.0070, 1.0138, 1.0273, 1.0563, 1.1214,  &
1.0004, 1.0007, 1.0012, 1.0024, 1.0048, 1.0098, 1.0199, 1.0410, 1.0871 /
data ((supersat( 4,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0016, 1.0036, 1.0062, 1.0120, 1.0250, 1.0556, 1.1310, 1.3367, 2.0912,  &
1.0015, 1.0025, 1.0045, 1.0086, 1.0170, 1.0358, 1.0801, 1.1911, 1.5171,  &
1.0014, 1.0016, 1.0038, 1.0065, 1.0123, 1.0245, 1.0522, 1.1177, 1.2882,  &
1.0011, 1.0014, 1.0029, 1.0050, 1.0092, 1.0177, 1.0361, 1.0777, 1.1781,  &
1.0008, 1.0012, 1.0020, 1.0037, 1.0070, 1.0132, 1.0261, 1.0541, 1.1184,  &
1.0005, 1.0008, 1.0014, 1.0028, 1.0052, 1.0099, 1.0192, 1.0390, 1.0826,  &
1.0004, 1.0006, 1.0010, 1.0018, 1.0035, 1.0070, 1.0140, 1.0284, 1.0593 /
data ((supersat( 4,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0013, 1.0028, 1.0049, 1.0095, 1.0197, 1.0439, 1.1030, 1.2568, 1.7370,  &
1.0007, 1.0022, 1.0036, 1.0068, 1.0132, 1.0277, 1.0620, 1.1464, 1.3760,  &
1.0006, 1.0014, 1.0029, 1.0050, 1.0093, 1.0186, 1.0395, 1.0890, 1.2132,  &
1.0005, 1.0010, 1.0024, 1.0039, 1.0070, 1.0132, 1.0268, 1.0576, 1.1307,  &
1.0004, 1.0008, 1.0017, 1.0027, 1.0051, 1.0098, 1.0191, 1.0394, 1.0855,  &
1.0004, 1.0007, 1.0012, 1.0021, 1.0040, 1.0072, 1.0140, 1.0281, 1.0589,  &
1.0003, 1.0005, 1.0008, 1.0013, 1.0026, 1.0052, 1.0101, 1.0203, 1.0419 /
data ((supersat( 4,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0015, 1.0020, 1.0040, 1.0078, 1.0162, 1.0362, 1.0848, 1.2084, 1.5627,  &
1.0010, 1.0019, 1.0031, 1.0055, 1.0106, 1.0224, 1.0503, 1.1185, 1.2967,  &
1.0006, 1.0015, 1.0020, 1.0040, 1.0075, 1.0147, 1.0314, 1.0709, 1.1684,  &
1.0005, 1.0011, 1.0018, 1.0032, 1.0056, 1.0104, 1.0208, 1.0448, 1.1017,  &
1.0004, 1.0008, 1.0014, 1.0021, 1.0040, 1.0076, 1.0146, 1.0300, 1.0652,  &
1.0004, 1.0006, 1.0010, 1.0015, 1.0031, 1.0055, 1.0107, 1.0211, 1.0441,  &
1.0003, 1.0004, 1.0006, 1.0011, 1.0021, 1.0040, 1.0076, 1.0151, 1.0309 /
data ((supersat( 4,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0011, 1.0020, 1.0035, 1.0066, 1.0137, 1.0308, 1.0721, 1.1760, 1.4607,  &
1.0010, 1.0011, 1.0027, 1.0046, 1.0089, 1.0187, 1.0423, 1.0996, 1.2464,  &
1.0009, 1.0010, 1.0019, 1.0033, 1.0061, 1.0121, 1.0259, 1.0588, 1.1393,  &
1.0007, 1.0009, 1.0012, 1.0026, 1.0045, 1.0084, 1.0169, 1.0365, 1.0829,  &
1.0005, 1.0007, 1.0009, 1.0020, 1.0033, 1.0061, 1.0117, 1.0240, 1.0521,  &
1.0003, 1.0005, 1.0007, 1.0014, 1.0024, 1.0044, 1.0084, 1.0166, 1.0345,  &
1.0002, 1.0004, 1.0006, 1.0009, 1.0016, 1.0031, 1.0059, 1.0117, 1.0238 /
data ((supersat( 4,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0046, 1.0080, 1.0155, 1.0315, 1.0678, 1.1561, 1.4085, 2.7010, 4.9786,  &
1.0034, 1.0061, 1.0114, 1.0228, 1.0472, 1.1032, 1.2445, 1.7115, 4.0030,  &
1.0022, 1.0046, 1.0086, 1.0170, 1.0342, 1.0722, 1.1613, 1.4048, 2.5274,  &
1.0016, 1.0034, 1.0065, 1.0127, 1.0252, 1.0521, 1.1125, 1.2617, 1.7379,  &
1.0011, 1.0021, 1.0043, 1.0090, 1.0183, 1.0379, 1.0806, 1.1800, 1.4506,  &
1.0006, 1.0011, 1.0024, 1.0056, 1.0125, 1.0268, 1.0576, 1.1268, 1.2991,  &
1.0004, 1.0006, 1.0011, 1.0027, 1.0072, 1.0174, 1.0397, 1.0885, 1.2040 /
data ((supersat( 4,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0033, 1.0058, 1.0109, 1.0217, 1.0462, 1.1043, 1.2569, 1.8017, 3.7103,  &
1.0025, 1.0039, 1.0082, 1.0157, 1.0320, 1.0688, 1.1578, 1.4089, 2.5831,  &
1.0016, 1.0034, 1.0062, 1.0117, 1.0230, 1.0480, 1.1048, 1.2476, 1.7111,  &
1.0012, 1.0025, 1.0046, 1.0087, 1.0171, 1.0347, 1.0734, 1.1642, 1.4108,  &
1.0009, 1.0017, 1.0030, 1.0062, 1.0126, 1.0253, 1.0528, 1.1145, 1.2668,  &
1.0005, 1.0009, 1.0019, 1.0040, 1.0087, 1.0181, 1.0381, 1.0817, 1.1833,  &
1.0003, 1.0005, 1.0009, 1.0021, 1.0051, 1.0120, 1.0266, 1.0578, 1.1284 /
data ((supersat( 4,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0024, 1.0043, 1.0077, 1.0156, 1.0330, 1.0739, 1.1768, 1.4836, 2.7339,  &
1.0020, 1.0027, 1.0057, 1.0112, 1.0226, 1.0482, 1.1089, 1.2671, 1.8126,  &
1.0014, 1.0024, 1.0046, 1.0082, 1.0162, 1.0333, 1.0719, 1.1648, 1.4248,  &
1.0010, 1.0019, 1.0032, 1.0063, 1.0120, 1.0239, 1.0500, 1.1095, 1.2588,  &
1.0007, 1.0013, 1.0021, 1.0044, 1.0089, 1.0174, 1.0359, 1.0764, 1.1716,  &
1.0004, 1.0007, 1.0014, 1.0030, 1.0061, 1.0126, 1.0259, 1.0546, 1.1192,  &
1.0003, 1.0004, 1.0008, 1.0016, 1.0037, 1.0083, 1.0181, 1.0388, 1.0842 /
data ((supersat( 4,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0016, 1.0033, 1.0059, 1.0117, 1.0247, 1.0554, 1.1309, 1.3365, 2.0909,  &
1.0014, 1.0021, 1.0041, 1.0083, 1.0166, 1.0355, 1.0798, 1.1908, 1.5168,  &
1.0012, 1.0015, 1.0035, 1.0061, 1.0118, 1.0241, 1.0518, 1.1173, 1.2877,  &
1.0009, 1.0013, 1.0025, 1.0045, 1.0086, 1.0171, 1.0355, 1.0771, 1.1773,  &
1.0006, 1.0009, 1.0016, 1.0033, 1.0063, 1.0124, 1.0252, 1.0532, 1.1173,  &
1.0004, 1.0006, 1.0011, 1.0022, 1.0045, 1.0089, 1.0181, 1.0377, 1.0811,  &
1.0003, 1.0004, 1.0006, 1.0012, 1.0027, 1.0059, 1.0126, 1.0267, 1.0572 /
data ((supersat( 4,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0011, 1.0027, 1.0047, 1.0092, 1.0195, 1.0438, 1.1029, 1.2567, 1.7368,  &
1.0006, 1.0019, 1.0032, 1.0065, 1.0128, 1.0274, 1.0618, 1.1462, 1.3758,  &
1.0005, 1.0012, 1.0027, 1.0047, 1.0089, 1.0182, 1.0392, 1.0887, 1.2128,  &
1.0004, 1.0008, 1.0020, 1.0034, 1.0066, 1.0127, 1.0263, 1.0571, 1.1302,  &
1.0004, 1.0007, 1.0014, 1.0024, 1.0047, 1.0091, 1.0184, 1.0387, 1.0848,  &
1.0003, 1.0005, 1.0009, 1.0017, 1.0033, 1.0064, 1.0131, 1.0271, 1.0578,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0020, 1.0043, 1.0090, 1.0190, 1.0403 /
data ((supersat( 4,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0012, 1.0020, 1.0038, 1.0075, 1.0159, 1.0360, 1.0847, 1.2083, 1.5625,  &
1.0008, 1.0017, 1.0028, 1.0052, 1.0103, 1.0221, 1.0501, 1.1183, 1.2965,  &
1.0005, 1.0013, 1.0019, 1.0038, 1.0071, 1.0144, 1.0311, 1.0707, 1.1681,  &
1.0005, 1.0009, 1.0016, 1.0028, 1.0052, 1.0099, 1.0204, 1.0445, 1.1013,  &
1.0004, 1.0007, 1.0012, 1.0018, 1.0036, 1.0071, 1.0141, 1.0295, 1.0646,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0026, 1.0049, 1.0099, 1.0203, 1.0432,  &
1.0002, 1.0003, 1.0004, 1.0008, 1.0015, 1.0032, 1.0067, 1.0140, 1.0296 /
data ((supersat( 4,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0010, 1.0017, 1.0032, 1.0064, 1.0135, 1.0306, 1.0721, 1.1759, 1.4606,  &
1.0009, 1.0010, 1.0024, 1.0043, 1.0086, 1.0185, 1.0422, 1.0995, 1.2462,  &
1.0007, 1.0010, 1.0016, 1.0029, 1.0059, 1.0118, 1.0257, 1.0586, 1.1392,  &
1.0005, 1.0008, 1.0010, 1.0024, 1.0042, 1.0080, 1.0165, 1.0362, 1.0827,  &
1.0004, 1.0005, 1.0008, 1.0017, 1.0029, 1.0057, 1.0112, 1.0235, 1.0516,  &
1.0002, 1.0004, 1.0006, 1.0011, 1.0020, 1.0039, 1.0078, 1.0159, 1.0338,  &
1.0002, 1.0002, 1.0004, 1.0006, 1.0012, 1.0025, 1.0052, 1.0108, 1.0228 /
data ((supersat( 4,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0042, 1.0077, 1.0150, 1.0310, 1.0673, 1.1555, 1.4078, 2.6992, 4.9761,  &
1.0029, 1.0054, 1.0109, 1.0222, 1.0465, 1.1024, 1.2435, 1.7097, 3.9971,  &
1.0019, 1.0041, 1.0078, 1.0161, 1.0333, 1.0710, 1.1599, 1.4025, 2.5217,  &
1.0013, 1.0027, 1.0056, 1.0116, 1.0240, 1.0506, 1.1106, 1.2588, 1.7319,  &
1.0007, 1.0014, 1.0034, 1.0077, 1.0167, 1.0358, 1.0780, 1.1762, 1.4438,  &
1.0004, 1.0007, 1.0015, 1.0041, 1.0105, 1.0243, 1.0542, 1.1219, 1.2908,  &
1.0003, 1.0004, 1.0007, 1.0015, 1.0050, 1.0143, 1.0353, 1.0823, 1.1940 /
data ((supersat( 4,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0030, 1.0054, 1.0104, 1.0213, 1.0458, 1.1039, 1.2565, 1.8011, 3.7086,  &
1.0021, 1.0036, 1.0077, 1.0151, 1.0315, 1.0683, 1.1572, 1.4081, 2.5810,  &
1.0014, 1.0030, 1.0057, 1.0111, 1.0224, 1.0472, 1.1040, 1.2465, 1.7090,  &
1.0010, 1.0020, 1.0039, 1.0080, 1.0162, 1.0336, 1.0722, 1.1625, 1.4081,  &
1.0006, 1.0011, 1.0024, 1.0052, 1.0114, 1.0239, 1.0511, 1.1123, 1.2634,  &
1.0003, 1.0006, 1.0012, 1.0029, 1.0073, 1.0164, 1.0359, 1.0788, 1.1789,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0036, 1.0098, 1.0237, 1.0540, 1.1227 /
data ((supersat( 4,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0023, 1.0039, 1.0074, 1.0152, 1.0327, 1.0737, 1.1765, 1.4832, 2.7333,  &
1.0017, 1.0025, 1.0052, 1.0107, 1.0221, 1.0478, 1.1085, 1.2666, 1.8119,  &
1.0012, 1.0022, 1.0042, 1.0076, 1.0157, 1.0327, 1.0713, 1.1641, 1.4238,  &
1.0008, 1.0015, 1.0028, 1.0056, 1.0113, 1.0232, 1.0491, 1.1085, 1.2574,  &
1.0005, 1.0008, 1.0017, 1.0038, 1.0080, 1.0164, 1.0347, 1.0750, 1.1695,  &
1.0003, 1.0005, 1.0009, 1.0022, 1.0050, 1.0113, 1.0243, 1.0526, 1.1165,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0025, 1.0067, 1.0160, 1.0362, 1.0807 /
data ((supersat( 4,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0015, 1.0030, 1.0057, 1.0114, 1.0245, 1.0553, 1.1307, 1.3363, 2.0907,  &
1.0013, 1.0018, 1.0039, 1.0080, 1.0162, 1.0352, 1.0795, 1.1905, 1.5163,  &
1.0010, 1.0014, 1.0031, 1.0058, 1.0114, 1.0236, 1.0513, 1.1169, 1.2871,  &
1.0007, 1.0010, 1.0021, 1.0040, 1.0081, 1.0165, 1.0348, 1.0764, 1.1764,  &
1.0004, 1.0007, 1.0013, 1.0028, 1.0056, 1.0117, 1.0244, 1.0522, 1.1160,  &
1.0003, 1.0004, 1.0007, 1.0016, 1.0037, 1.0079, 1.0170, 1.0363, 1.0794,  &
1.0002, 1.0003, 1.0004, 1.0008, 1.0018, 1.0046, 1.0111, 1.0248, 1.0548 /
data ((supersat( 4,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0009, 1.0025, 1.0045, 1.0089, 1.0193, 1.0436, 1.1027, 1.2566, 1.7366,  &
1.0006, 1.0017, 1.0029, 1.0062, 1.0125, 1.0272, 1.0616, 1.1460, 1.3756,  &
1.0005, 1.0010, 1.0024, 1.0044, 1.0086, 1.0178, 1.0389, 1.0884, 1.2124,  &
1.0004, 1.0008, 1.0017, 1.0030, 1.0061, 1.0123, 1.0258, 1.0566, 1.1296,  &
1.0003, 1.0006, 1.0011, 1.0020, 1.0042, 1.0085, 1.0177, 1.0379, 1.0839,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0027, 1.0056, 1.0122, 1.0260, 1.0566,  &
1.0002, 1.0002, 1.0003, 1.0006, 1.0013, 1.0033, 1.0078, 1.0175, 1.0385 /
data ((supersat( 4,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0010, 1.0019, 1.0036, 1.0073, 1.0158, 1.0359, 1.0846, 1.2082, 1.5625,  &
1.0006, 1.0015, 1.0025, 1.0050, 1.0100, 1.0219, 1.0500, 1.1182, 1.2964,  &
1.0005, 1.0011, 1.0018, 1.0035, 1.0068, 1.0141, 1.0309, 1.0704, 1.1679,  &
1.0004, 1.0007, 1.0014, 1.0025, 1.0048, 1.0095, 1.0200, 1.0441, 1.1009,  &
1.0003, 1.0005, 1.0009, 1.0016, 1.0032, 1.0066, 1.0135, 1.0289, 1.0640,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0020, 1.0043, 1.0091, 1.0194, 1.0422,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0024, 1.0057, 1.0128, 1.0283 /
data ((supersat( 4,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0010, 1.0015, 1.0029, 1.0061, 1.0133, 1.0305, 1.0720, 1.1758, 1.4606,  &
1.0008, 1.0010, 1.0022, 1.0041, 1.0084, 1.0183, 1.0420, 1.0994, 1.2461,  &
1.0006, 1.0009, 1.0014, 1.0028, 1.0056, 1.0115, 1.0255, 1.0585, 1.1390,  &
1.0004, 1.0006, 1.0009, 1.0021, 1.0039, 1.0076, 1.0162, 1.0359, 1.0824,  &
1.0003, 1.0004, 1.0007, 1.0014, 1.0025, 1.0052, 1.0107, 1.0230, 1.0511,  &
1.0002, 1.0003, 1.0004, 1.0008, 1.0016, 1.0033, 1.0071, 1.0152, 1.0330,  &
1.0001, 1.0002, 1.0003, 1.0004, 1.0008, 1.0018, 1.0044, 1.0098, 1.0216 /
data ((supersat( 4,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0040, 1.0074, 1.0147, 1.0307, 1.0671, 1.1552, 1.4073, 2.6979, 4.9739,  &
1.0026, 1.0051, 1.0106, 1.0218, 1.0461, 1.1019, 1.2428, 1.7085, 3.9931,  &
1.0017, 1.0037, 1.0074, 1.0156, 1.0327, 1.0703, 1.1589, 1.4009, 2.5176,  &
1.0010, 1.0023, 1.0051, 1.0109, 1.0232, 1.0496, 1.1093, 1.2567, 1.7278,  &
1.0005, 1.0011, 1.0028, 1.0068, 1.0157, 1.0346, 1.0763, 1.1736, 1.4390,  &
1.0003, 1.0005, 1.0011, 1.0032, 1.0092, 1.0226, 1.0520, 1.1186, 1.2851,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0036, 1.0123, 1.0325, 1.0780, 1.1870 /
data ((supersat( 4,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0029, 1.0052, 1.0102, 1.0211, 1.0456, 1.1037, 1.2562, 1.8006, 3.7074,  &
1.0019, 1.0035, 1.0074, 1.0148, 1.0312, 1.0680, 1.1568, 1.4075, 2.5795,  &
1.0013, 1.0027, 1.0054, 1.0107, 1.0220, 1.0468, 1.1034, 1.2456, 1.7075,  &
1.0008, 1.0017, 1.0035, 1.0075, 1.0156, 1.0330, 1.0714, 1.1614, 1.4063,  &
1.0004, 1.0009, 1.0020, 1.0047, 1.0106, 1.0231, 1.0501, 1.1108, 1.2611,  &
1.0003, 1.0004, 1.0009, 1.0024, 1.0064, 1.0153, 1.0344, 1.0768, 1.1759,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0027, 1.0084, 1.0218, 1.0514, 1.1188 /
data ((supersat( 4,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0021, 1.0037, 1.0073, 1.0151, 1.0326, 1.0736, 1.1764, 1.4830, 2.7327,  &
1.0015, 1.0025, 1.0051, 1.0105, 1.0219, 1.0476, 1.1083, 1.2663, 1.8114,  &
1.0010, 1.0020, 1.0039, 1.0074, 1.0154, 1.0324, 1.0709, 1.1636, 1.4231,  &
1.0007, 1.0013, 1.0025, 1.0053, 1.0109, 1.0227, 1.0486, 1.1078, 1.2564,  &
1.0004, 1.0007, 1.0015, 1.0034, 1.0075, 1.0158, 1.0340, 1.0740, 1.1682,  &
1.0002, 1.0004, 1.0007, 1.0017, 1.0044, 1.0104, 1.0233, 1.0513, 1.1147,  &
1.0002, 1.0002, 1.0004, 1.0007, 1.0019, 1.0058, 1.0147, 1.0345, 1.0783 /
data ((supersat( 4,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0015, 1.0029, 1.0055, 1.0113, 1.0244, 1.0552, 1.1306, 1.3362, 2.0905,  &
1.0012, 1.0017, 1.0038, 1.0078, 1.0161, 1.0350, 1.0794, 1.1903, 1.5161,  &
1.0009, 1.0013, 1.0029, 1.0056, 1.0111, 1.0234, 1.0511, 1.1166, 1.2867,  &
1.0005, 1.0009, 1.0019, 1.0037, 1.0078, 1.0161, 1.0345, 1.0759, 1.1758,  &
1.0003, 1.0006, 1.0012, 1.0025, 1.0052, 1.0112, 1.0238, 1.0515, 1.1151,  &
1.0002, 1.0003, 1.0006, 1.0013, 1.0032, 1.0073, 1.0162, 1.0354, 1.0782,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0014, 1.0039, 1.0101, 1.0236, 1.0532 /
data ((supersat( 4,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0008, 1.0023, 1.0044, 1.0088, 1.0192, 1.0436, 1.1027, 1.2565, 1.7365,  &
1.0005, 1.0015, 1.0028, 1.0060, 1.0124, 1.0270, 1.0615, 1.1459, 1.3754,  &
1.0005, 1.0010, 1.0023, 1.0043, 1.0084, 1.0176, 1.0387, 1.0882, 1.2122,  &
1.0004, 1.0007, 1.0015, 1.0028, 1.0059, 1.0120, 1.0255, 1.0563, 1.1292,  &
1.0003, 1.0005, 1.0009, 1.0018, 1.0039, 1.0081, 1.0173, 1.0375, 1.0833,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0023, 1.0052, 1.0116, 1.0253, 1.0557,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0027, 1.0070, 1.0166, 1.0374 /
data ((supersat( 4,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0010, 1.0018, 1.0035, 1.0071, 1.0157, 1.0359, 1.0846, 1.2081, 1.5624,  &
1.0006, 1.0014, 1.0023, 1.0048, 1.0099, 1.0218, 1.0499, 1.1181, 1.2963,  &
1.0005, 1.0010, 1.0017, 1.0034, 1.0066, 1.0139, 1.0307, 1.0703, 1.1677,  &
1.0004, 1.0007, 1.0012, 1.0023, 1.0046, 1.0093, 1.0198, 1.0439, 1.1006,  &
1.0002, 1.0004, 1.0007, 1.0014, 1.0029, 1.0063, 1.0132, 1.0285, 1.0636,  &
1.0002, 1.0002, 1.0004, 1.0008, 1.0017, 1.0039, 1.0087, 1.0189, 1.0416,  &
1.0001, 1.0002, 1.0002, 1.0004, 1.0008, 1.0020, 1.0051, 1.0121, 1.0273 /
data ((supersat( 4,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0009, 1.0014, 1.0028, 1.0060, 1.0133, 1.0305, 1.0720, 1.1758, 1.4605,  &
1.0007, 1.0010, 1.0021, 1.0040, 1.0083, 1.0183, 1.0420, 1.0993, 1.2460,  &
1.0005, 1.0008, 1.0013, 1.0027, 1.0054, 1.0114, 1.0254, 1.0583, 1.1388,  &
1.0003, 1.0005, 1.0008, 1.0019, 1.0037, 1.0074, 1.0160, 1.0357, 1.0822,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0023, 1.0050, 1.0104, 1.0227, 1.0508,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0014, 1.0030, 1.0067, 1.0147, 1.0325,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0015, 1.0039, 1.0092, 1.0209 /
data ((supersat( 4,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0038, 1.0073, 1.0145, 1.0305, 1.0668, 1.1549, 1.4069, 2.6969, 4.9721,  &
1.0025, 1.0049, 1.0104, 1.0215, 1.0458, 1.1015, 1.2422, 1.7075, 3.9899,  &
1.0016, 1.0035, 1.0071, 1.0153, 1.0322, 1.0698, 1.1581, 1.3997, 2.5144,  &
1.0008, 1.0020, 1.0047, 1.0104, 1.0226, 1.0489, 1.1082, 1.2552, 1.7245,  &
1.0004, 1.0009, 1.0023, 1.0062, 1.0149, 1.0336, 1.0749, 1.1715, 1.4353,  &
1.0003, 1.0004, 1.0009, 1.0026, 1.0083, 1.0213, 1.0502, 1.1159, 1.2806,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0028, 1.0108, 1.0303, 1.0747, 1.1815 /
data ((supersat( 4,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0027, 1.0051, 1.0101, 1.0209, 1.0455, 1.1036, 1.2560, 1.8003, 3.7066,  &
1.0018, 1.0034, 1.0072, 1.0146, 1.0309, 1.0677, 1.1565, 1.4071, 2.5783,  &
1.0012, 1.0026, 1.0052, 1.0105, 1.0217, 1.0464, 1.1030, 1.2450, 1.7063,  &
1.0007, 1.0015, 1.0033, 1.0072, 1.0152, 1.0325, 1.0708, 1.1605, 1.4049,  &
1.0004, 1.0007, 1.0018, 1.0043, 1.0101, 1.0224, 1.0492, 1.1097, 1.2592,  &
1.0002, 1.0004, 1.0007, 1.0019, 1.0057, 1.0144, 1.0333, 1.0752, 1.1735,  &
1.0002, 1.0002, 1.0004, 1.0007, 1.0021, 1.0074, 1.0204, 1.0494, 1.1158 /
data ((supersat( 4,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0021, 1.0036, 1.0072, 1.0150, 1.0325, 1.0735, 1.1763, 1.4829, 2.7323,  &
1.0014, 1.0024, 1.0050, 1.0103, 1.0218, 1.0474, 1.1081, 1.2661, 1.8110,  &
1.0010, 1.0019, 1.0037, 1.0072, 1.0151, 1.0321, 1.0706, 1.1632, 1.4225,  &
1.0006, 1.0011, 1.0023, 1.0050, 1.0106, 1.0224, 1.0482, 1.1073, 1.2556,  &
1.0003, 1.0006, 1.0013, 1.0030, 1.0071, 1.0154, 1.0334, 1.0733, 1.1672,  &
1.0002, 1.0003, 1.0006, 1.0014, 1.0039, 1.0098, 1.0226, 1.0503, 1.1133,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0015, 1.0050, 1.0137, 1.0332, 1.0764 /
data ((supersat( 4,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0014, 1.0028, 1.0054, 1.0112, 1.0243, 1.0551, 1.1305, 1.3361, 2.0903,  &
1.0012, 1.0016, 1.0037, 1.0077, 1.0159, 1.0349, 1.0792, 1.1901, 1.5159,  &
1.0008, 1.0012, 1.0028, 1.0054, 1.0110, 1.0232, 1.0509, 1.1163, 1.2864,  &
1.0004, 1.0008, 1.0018, 1.0035, 1.0075, 1.0159, 1.0342, 1.0756, 1.1754,  &
1.0003, 1.0005, 1.0010, 1.0022, 1.0049, 1.0108, 1.0234, 1.0510, 1.1145,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0028, 1.0069, 1.0156, 1.0347, 1.0773,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0034, 1.0094, 1.0226, 1.0519 /
data ((supersat( 4,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0008, 1.0023, 1.0043, 1.0087, 1.0191, 1.0435, 1.1026, 1.2564, 1.7364,  &
1.0005, 1.0014, 1.0028, 1.0059, 1.0123, 1.0270, 1.0614, 1.1458, 1.3753,  &
1.0004, 1.0009, 1.0022, 1.0041, 1.0082, 1.0175, 1.0386, 1.0880, 1.2120,  &
1.0004, 1.0007, 1.0014, 1.0026, 1.0057, 1.0118, 1.0253, 1.0560, 1.1289,  &
1.0002, 1.0004, 1.0008, 1.0016, 1.0036, 1.0078, 1.0170, 1.0371, 1.0829,  &
1.0002, 1.0002, 1.0004, 1.0008, 1.0020, 1.0048, 1.0111, 1.0248, 1.0551,  &
1.0001, 1.0002, 1.0002, 1.0004, 1.0008, 1.0023, 1.0065, 1.0159, 1.0365 /
data ((supersat( 4,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0009, 1.0018, 1.0034, 1.0071, 1.0156, 1.0358, 1.0845, 1.2081, 1.5623,  &
1.0006, 1.0014, 1.0022, 1.0047, 1.0098, 1.0218, 1.0498, 1.1180, 1.2962,  &
1.0004, 1.0009, 1.0016, 1.0033, 1.0065, 1.0138, 1.0306, 1.0702, 1.1676,  &
1.0003, 1.0006, 1.0011, 1.0022, 1.0044, 1.0091, 1.0196, 1.0437, 1.1004,  &
1.0002, 1.0003, 1.0006, 1.0013, 1.0027, 1.0060, 1.0129, 1.0282, 1.0632,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0015, 1.0036, 1.0083, 1.0185, 1.0411,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0017, 1.0047, 1.0115, 1.0267 /
data ((supersat( 4,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0009, 1.0013, 1.0028, 1.0060, 1.0132, 1.0305, 1.0719, 1.1757, 1.4605,  &
1.0007, 1.0009, 1.0020, 1.0039, 1.0082, 1.0182, 1.0419, 1.0993, 1.2460,  &
1.0005, 1.0007, 1.0012, 1.0026, 1.0053, 1.0113, 1.0253, 1.0583, 1.1388,  &
1.0003, 1.0004, 1.0008, 1.0018, 1.0036, 1.0073, 1.0158, 1.0355, 1.0820,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0022, 1.0048, 1.0102, 1.0225, 1.0506,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0012, 1.0028, 1.0064, 1.0144, 1.0321,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0013, 1.0035, 1.0087, 1.0203 /
data ((supersat( 4,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0037, 1.0071, 1.0144, 1.0303, 1.0667, 1.1547, 1.4066, 2.6960, 4.9707,  &
1.0024, 1.0047, 1.0102, 1.0213, 1.0455, 1.1012, 1.2418, 1.7066, 3.9872,  &
1.0015, 1.0033, 1.0069, 1.0150, 1.0319, 1.0693, 1.1575, 1.3987, 2.5116,  &
1.0007, 1.0017, 1.0044, 1.0100, 1.0221, 1.0483, 1.1074, 1.2539, 1.7217,  &
1.0004, 1.0007, 1.0020, 1.0057, 1.0143, 1.0328, 1.0738, 1.1698, 1.4320,  &
1.0002, 1.0004, 1.0007, 1.0022, 1.0075, 1.0203, 1.0488, 1.1136, 1.2767,  &
1.0002, 1.0003, 1.0005, 1.0008, 1.0022, 1.0097, 1.0286, 1.0720, 1.1769 /
data ((supersat( 4,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0026, 1.0050, 1.0099, 1.0208, 1.0454, 1.1034, 1.2559, 1.8000, 3.7058,  &
1.0017, 1.0033, 1.0070, 1.0144, 1.0308, 1.0675, 1.1562, 1.4067, 2.5773,  &
1.0011, 1.0024, 1.0050, 1.0102, 1.0214, 1.0461, 1.1026, 1.2445, 1.7054,  &
1.0006, 1.0013, 1.0031, 1.0069, 1.0149, 1.0321, 1.0703, 1.1598, 1.4036,  &
1.0003, 1.0006, 1.0015, 1.0040, 1.0097, 1.0219, 1.0485, 1.1087, 1.2577,  &
1.0002, 1.0003, 1.0006, 1.0016, 1.0052, 1.0137, 1.0324, 1.0739, 1.1715,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0017, 1.0066, 1.0193, 1.0478, 1.1132 /
data ((supersat( 4,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0020, 1.0035, 1.0071, 1.0149, 1.0324, 1.0734, 1.1762, 1.4827, 2.7319,  &
1.0014, 1.0023, 1.0049, 1.0102, 1.0216, 1.0473, 1.1079, 1.2659, 1.8106,  &
1.0009, 1.0017, 1.0036, 1.0071, 1.0149, 1.0319, 1.0704, 1.1630, 1.4220,  &
1.0005, 1.0010, 1.0022, 1.0048, 1.0104, 1.0221, 1.0479, 1.1068, 1.2550,  &
1.0003, 1.0005, 1.0012, 1.0028, 1.0067, 1.0150, 1.0329, 1.0727, 1.1663,  &
1.0002, 1.0003, 1.0005, 1.0012, 1.0036, 1.0093, 1.0219, 1.0495, 1.1121,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0012, 1.0044, 1.0129, 1.0321, 1.0749 /
data ((supersat( 4,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0014, 1.0027, 1.0054, 1.0111, 1.0243, 1.0550, 1.1304, 1.3360, 2.0901,  &
1.0011, 1.0015, 1.0037, 1.0076, 1.0159, 1.0348, 1.0791, 1.1900, 1.5157,  &
1.0007, 1.0011, 1.0027, 1.0053, 1.0108, 1.0231, 1.0507, 1.1161, 1.2861,  &
1.0004, 1.0007, 1.0017, 1.0034, 1.0074, 1.0157, 1.0339, 1.0753, 1.1750,  &
1.0002, 1.0004, 1.0009, 1.0020, 1.0047, 1.0106, 1.0230, 1.0506, 1.1139,  &
1.0002, 1.0002, 1.0004, 1.0009, 1.0025, 1.0065, 1.0152, 1.0341, 1.0765,  &
1.0001, 1.0002, 1.0002, 1.0004, 1.0009, 1.0030, 1.0088, 1.0219, 1.0509 /
data ((supersat( 4,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0007, 1.0022, 1.0042, 1.0087, 1.0191, 1.0435, 1.1026, 1.2564, 1.7363,  &
1.0005, 1.0014, 1.0027, 1.0058, 1.0122, 1.0269, 1.0613, 1.1457, 1.3752,  &
1.0004, 1.0009, 1.0021, 1.0040, 1.0081, 1.0174, 1.0384, 1.0879, 1.2119,  &
1.0003, 1.0006, 1.0013, 1.0025, 1.0055, 1.0116, 1.0251, 1.0558, 1.1287,  &
1.0002, 1.0003, 1.0007, 1.0015, 1.0034, 1.0076, 1.0167, 1.0368, 1.0825,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0018, 1.0046, 1.0108, 1.0244, 1.0545,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0007, 1.0020, 1.0060, 1.0153, 1.0357 /
data ((supersat( 4,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0008, 1.0017, 1.0034, 1.0070, 1.0156, 1.0358, 1.0845, 1.2081, 1.5623,  &
1.0005, 1.0013, 1.0022, 1.0047, 1.0098, 1.0217, 1.0498, 1.1180, 1.2961,  &
1.0004, 1.0009, 1.0015, 1.0032, 1.0064, 1.0137, 1.0305, 1.0701, 1.1675,  &
1.0003, 1.0005, 1.0010, 1.0021, 1.0043, 1.0090, 1.0195, 1.0435, 1.1003,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0026, 1.0058, 1.0127, 1.0280, 1.0630,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0013, 1.0034, 1.0080, 1.0181, 1.0407,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0014, 1.0043, 1.0110, 1.0261 /
data ((supersat( 4,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0009, 1.0012, 1.0027, 1.0059, 1.0132, 1.0304, 1.0719, 1.1757, 1.4605,  &
1.0006, 1.0009, 1.0020, 1.0039, 1.0081, 1.0182, 1.0419, 1.0992, 1.2459,  &
1.0004, 1.0007, 1.0012, 1.0025, 1.0053, 1.0112, 1.0252, 1.0582, 1.1387,  &
1.0002, 1.0004, 1.0008, 1.0017, 1.0035, 1.0072, 1.0157, 1.0354, 1.0819,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0021, 1.0046, 1.0100, 1.0223, 1.0504,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0026, 1.0062, 1.0141, 1.0318,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0032, 1.0083, 1.0199 /
data ((supersat( 5,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0042, 1.0076, 1.0150, 1.0309, 1.0673, 1.1554, 1.4077, 2.6990, 4.9755,  &
1.0029, 1.0054, 1.0109, 1.0221, 1.0465, 1.1023, 1.2434, 1.7095, 3.9965,  &
1.0019, 1.0041, 1.0078, 1.0161, 1.0332, 1.0710, 1.1597, 1.4023, 2.5209,  &
1.0013, 1.0027, 1.0056, 1.0115, 1.0239, 1.0505, 1.1104, 1.2585, 1.7312,  &
1.0007, 1.0014, 1.0033, 1.0076, 1.0166, 1.0357, 1.0778, 1.1758, 1.4431,  &
1.0004, 1.0007, 1.0015, 1.0041, 1.0104, 1.0241, 1.0540, 1.1214, 1.2899,  &
1.0003, 1.0004, 1.0007, 1.0015, 1.0049, 1.0142, 1.0350, 1.0817, 1.1928 /
data ((supersat( 5,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0030, 1.0054, 1.0104, 1.0212, 1.0458, 1.1039, 1.2565, 1.8010, 3.7084,  &
1.0021, 1.0036, 1.0076, 1.0151, 1.0314, 1.0682, 1.1571, 1.4080, 2.5808,  &
1.0014, 1.0030, 1.0057, 1.0111, 1.0223, 1.0472, 1.1039, 1.2463, 1.7088,  &
1.0010, 1.0020, 1.0039, 1.0080, 1.0162, 1.0336, 1.0721, 1.1624, 1.4079,  &
1.0006, 1.0011, 1.0024, 1.0052, 1.0113, 1.0239, 1.0510, 1.1121, 1.2631,  &
1.0003, 1.0006, 1.0012, 1.0029, 1.0072, 1.0163, 1.0358, 1.0786, 1.1785,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0035, 1.0097, 1.0236, 1.0537, 1.1221 /
data ((supersat( 5,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0023, 1.0039, 1.0074, 1.0152, 1.0327, 1.0737, 1.1765, 1.4832, 2.7332,  &
1.0017, 1.0025, 1.0052, 1.0107, 1.0221, 1.0478, 1.1085, 1.2666, 1.8118,  &
1.0012, 1.0021, 1.0041, 1.0076, 1.0157, 1.0327, 1.0713, 1.1640, 1.4237,  &
1.0008, 1.0015, 1.0027, 1.0056, 1.0113, 1.0231, 1.0491, 1.1084, 1.2573,  &
1.0005, 1.0008, 1.0017, 1.0038, 1.0080, 1.0164, 1.0347, 1.0749, 1.1694,  &
1.0003, 1.0005, 1.0009, 1.0021, 1.0050, 1.0112, 1.0243, 1.0525, 1.1163,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0025, 1.0067, 1.0160, 1.0361, 1.0804 /
data ((supersat( 5,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0015, 1.0030, 1.0057, 1.0114, 1.0245, 1.0552, 1.1307, 1.3363, 2.0906,  &
1.0013, 1.0018, 1.0039, 1.0079, 1.0162, 1.0352, 1.0795, 1.1905, 1.5163,  &
1.0010, 1.0014, 1.0031, 1.0058, 1.0114, 1.0236, 1.0513, 1.1168, 1.2871,  &
1.0007, 1.0010, 1.0021, 1.0040, 1.0081, 1.0165, 1.0348, 1.0763, 1.1764,  &
1.0004, 1.0007, 1.0013, 1.0028, 1.0055, 1.0117, 1.0243, 1.0521, 1.1159,  &
1.0003, 1.0004, 1.0007, 1.0016, 1.0036, 1.0079, 1.0169, 1.0363, 1.0793,  &
1.0002, 1.0003, 1.0004, 1.0008, 1.0018, 1.0046, 1.0110, 1.0248, 1.0547 /
data ((supersat( 5,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0009, 1.0025, 1.0045, 1.0089, 1.0192, 1.0436, 1.1027, 1.2566, 1.7365,  &
1.0006, 1.0016, 1.0029, 1.0062, 1.0125, 1.0272, 1.0616, 1.1460, 1.3756,  &
1.0005, 1.0010, 1.0024, 1.0044, 1.0086, 1.0178, 1.0389, 1.0884, 1.2124,  &
1.0004, 1.0008, 1.0017, 1.0030, 1.0061, 1.0122, 1.0258, 1.0566, 1.1296,  &
1.0003, 1.0006, 1.0011, 1.0020, 1.0042, 1.0085, 1.0177, 1.0379, 1.0839,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0027, 1.0056, 1.0122, 1.0260, 1.0565,  &
1.0002, 1.0002, 1.0003, 1.0006, 1.0013, 1.0033, 1.0078, 1.0175, 1.0385 /
data ((supersat( 5,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0010, 1.0019, 1.0036, 1.0072, 1.0157, 1.0359, 1.0846, 1.2082, 1.5624,  &
1.0006, 1.0015, 1.0025, 1.0049, 1.0100, 1.0219, 1.0500, 1.1182, 1.2964,  &
1.0005, 1.0011, 1.0018, 1.0035, 1.0068, 1.0141, 1.0309, 1.0704, 1.1679,  &
1.0004, 1.0007, 1.0014, 1.0025, 1.0048, 1.0095, 1.0200, 1.0441, 1.1009,  &
1.0003, 1.0005, 1.0009, 1.0016, 1.0032, 1.0066, 1.0135, 1.0289, 1.0640,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0020, 1.0043, 1.0091, 1.0194, 1.0422,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0024, 1.0057, 1.0128, 1.0282 /
data ((supersat( 5,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0010, 1.0015, 1.0029, 1.0061, 1.0133, 1.0305, 1.0720, 1.1758, 1.4606,  &
1.0008, 1.0010, 1.0022, 1.0041, 1.0084, 1.0183, 1.0420, 1.0994, 1.2461,  &
1.0006, 1.0009, 1.0014, 1.0028, 1.0056, 1.0115, 1.0255, 1.0584, 1.1390,  &
1.0004, 1.0006, 1.0009, 1.0021, 1.0039, 1.0076, 1.0162, 1.0359, 1.0823,  &
1.0003, 1.0004, 1.0007, 1.0014, 1.0025, 1.0052, 1.0107, 1.0230, 1.0511,  &
1.0002, 1.0003, 1.0004, 1.0008, 1.0016, 1.0033, 1.0071, 1.0151, 1.0330,  &
1.0001, 1.0002, 1.0003, 1.0004, 1.0008, 1.0018, 1.0044, 1.0098, 1.0217 /
data ((supersat( 5,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0038, 1.0072, 1.0145, 1.0305, 1.0668, 1.1549, 1.4069, 2.6969, 4.9722,  &
1.0025, 1.0049, 1.0104, 1.0215, 1.0458, 1.1015, 1.2422, 1.7074, 3.9896,  &
1.0016, 1.0035, 1.0071, 1.0153, 1.0322, 1.0698, 1.1581, 1.3996, 2.5141,  &
1.0008, 1.0020, 1.0047, 1.0104, 1.0225, 1.0488, 1.1082, 1.2550, 1.7242,  &
1.0004, 1.0009, 1.0023, 1.0062, 1.0149, 1.0336, 1.0748, 1.1713, 1.4349,  &
1.0003, 1.0004, 1.0009, 1.0026, 1.0083, 1.0213, 1.0501, 1.1156, 1.2802,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0028, 1.0108, 1.0302, 1.0745, 1.1810 /
data ((supersat( 5,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0027, 1.0051, 1.0100, 1.0209, 1.0455, 1.1036, 1.2560, 1.8003, 3.7065,  &
1.0018, 1.0034, 1.0072, 1.0146, 1.0309, 1.0677, 1.1564, 1.4071, 2.5783,  &
1.0012, 1.0026, 1.0052, 1.0104, 1.0216, 1.0464, 1.1029, 1.2450, 1.7063,  &
1.0007, 1.0015, 1.0033, 1.0072, 1.0152, 1.0325, 1.0707, 1.1605, 1.4047,  &
1.0004, 1.0007, 1.0018, 1.0043, 1.0101, 1.0224, 1.0492, 1.1096, 1.2591,  &
1.0002, 1.0004, 1.0007, 1.0019, 1.0057, 1.0144, 1.0333, 1.0751, 1.1733,  &
1.0002, 1.0002, 1.0004, 1.0007, 1.0021, 1.0074, 1.0204, 1.0494, 1.1156 /
data ((supersat( 5,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0021, 1.0036, 1.0072, 1.0150, 1.0325, 1.0735, 1.1763, 1.4828, 2.7323,  &
1.0014, 1.0024, 1.0050, 1.0103, 1.0218, 1.0474, 1.1081, 1.2661, 1.8110,  &
1.0010, 1.0019, 1.0037, 1.0072, 1.0151, 1.0321, 1.0706, 1.1632, 1.4225,  &
1.0006, 1.0011, 1.0023, 1.0050, 1.0106, 1.0224, 1.0482, 1.1073, 1.2556,  &
1.0003, 1.0006, 1.0013, 1.0030, 1.0071, 1.0153, 1.0334, 1.0733, 1.1671,  &
1.0002, 1.0003, 1.0006, 1.0014, 1.0039, 1.0098, 1.0226, 1.0503, 1.1132,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0015, 1.0050, 1.0137, 1.0331, 1.0763 /
data ((supersat( 5,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0014, 1.0028, 1.0054, 1.0112, 1.0243, 1.0551, 1.1305, 1.3361, 2.0902,  &
1.0012, 1.0016, 1.0037, 1.0077, 1.0159, 1.0349, 1.0792, 1.1901, 1.5159,  &
1.0008, 1.0012, 1.0028, 1.0054, 1.0110, 1.0232, 1.0509, 1.1163, 1.2864,  &
1.0004, 1.0008, 1.0018, 1.0035, 1.0075, 1.0159, 1.0342, 1.0756, 1.1754,  &
1.0003, 1.0005, 1.0010, 1.0022, 1.0049, 1.0108, 1.0234, 1.0510, 1.1145,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0028, 1.0069, 1.0156, 1.0347, 1.0772,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0034, 1.0094, 1.0226, 1.0519 /
data ((supersat( 5,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0008, 1.0023, 1.0043, 1.0087, 1.0191, 1.0435, 1.1026, 1.2564, 1.7364,  &
1.0005, 1.0014, 1.0028, 1.0059, 1.0123, 1.0270, 1.0614, 1.1458, 1.3753,  &
1.0004, 1.0009, 1.0022, 1.0041, 1.0082, 1.0175, 1.0386, 1.0880, 1.2120,  &
1.0004, 1.0007, 1.0014, 1.0026, 1.0057, 1.0118, 1.0253, 1.0560, 1.1289,  &
1.0002, 1.0004, 1.0008, 1.0016, 1.0036, 1.0078, 1.0170, 1.0371, 1.0829,  &
1.0002, 1.0002, 1.0004, 1.0008, 1.0020, 1.0048, 1.0111, 1.0248, 1.0551,  &
1.0001, 1.0002, 1.0002, 1.0004, 1.0008, 1.0023, 1.0065, 1.0159, 1.0365 /
data ((supersat( 5,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0009, 1.0018, 1.0034, 1.0071, 1.0156, 1.0358, 1.0845, 1.2081, 1.5623,  &
1.0006, 1.0014, 1.0022, 1.0047, 1.0098, 1.0218, 1.0498, 1.1180, 1.2962,  &
1.0004, 1.0009, 1.0016, 1.0033, 1.0065, 1.0138, 1.0306, 1.0702, 1.1676,  &
1.0003, 1.0006, 1.0011, 1.0022, 1.0044, 1.0091, 1.0196, 1.0437, 1.1004,  &
1.0002, 1.0003, 1.0006, 1.0013, 1.0027, 1.0060, 1.0129, 1.0282, 1.0632,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0015, 1.0036, 1.0083, 1.0185, 1.0412,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0017, 1.0047, 1.0115, 1.0267 /
data ((supersat( 5,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0009, 1.0013, 1.0028, 1.0060, 1.0132, 1.0305, 1.0719, 1.1757, 1.4605,  &
1.0007, 1.0009, 1.0020, 1.0039, 1.0082, 1.0182, 1.0419, 1.0993, 1.2460,  &
1.0005, 1.0007, 1.0012, 1.0026, 1.0053, 1.0113, 1.0253, 1.0583, 1.1388,  &
1.0003, 1.0004, 1.0008, 1.0018, 1.0036, 1.0073, 1.0158, 1.0355, 1.0820,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0022, 1.0048, 1.0102, 1.0225, 1.0506,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0012, 1.0028, 1.0064, 1.0144, 1.0322,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0013, 1.0035, 1.0087, 1.0204 /
data ((supersat( 5,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0034, 1.0068, 1.0140, 1.0300, 1.0663, 1.1542, 1.4059, 2.6940, 4.9676,  &
1.0021, 1.0044, 1.0098, 1.0208, 1.0450, 1.1005, 1.2407, 1.7047, 3.9805,  &
1.0012, 1.0028, 1.0063, 1.0143, 1.0311, 1.0683, 1.1561, 1.3962, 2.5051,  &
1.0005, 1.0013, 1.0037, 1.0091, 1.0210, 1.0469, 1.1054, 1.2507, 1.7150,  &
1.0003, 1.0005, 1.0014, 1.0046, 1.0129, 1.0309, 1.0711, 1.1657, 1.4244,  &
1.0002, 1.0003, 1.0006, 1.0014, 1.0059, 1.0180, 1.0454, 1.1085, 1.2676,  &
1.0002, 1.0002, 1.0004, 1.0007, 1.0015, 1.0072, 1.0247, 1.0658, 1.1660 /
data ((supersat( 5,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0024, 1.0047, 1.0097, 1.0206, 1.0451, 1.1031, 1.2555, 1.7994, 3.7039,  &
1.0015, 1.0031, 1.0067, 1.0141, 1.0304, 1.0671, 1.1557, 1.4058, 2.5750,  &
1.0009, 1.0021, 1.0046, 1.0098, 1.0209, 1.0455, 1.1018, 1.2433, 1.7031,  &
1.0004, 1.0010, 1.0026, 1.0063, 1.0142, 1.0312, 1.0691, 1.1582, 1.4007,  &
1.0002, 1.0004, 1.0011, 1.0033, 1.0087, 1.0207, 1.0470, 1.1064, 1.2540,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0040, 1.0122, 1.0303, 1.0709, 1.1668,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0049, 1.0167, 1.0440, 1.1073 /
data ((supersat( 5,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0019, 1.0033, 1.0069, 1.0147, 1.0322, 1.0732, 1.1759, 1.4824, 2.7311,  &
1.0012, 1.0022, 1.0047, 1.0100, 1.0214, 1.0470, 1.1076, 1.2654, 1.8098,  &
1.0007, 1.0015, 1.0033, 1.0068, 1.0146, 1.0315, 1.0699, 1.1623, 1.4209,  &
1.0004, 1.0008, 1.0019, 1.0044, 1.0098, 1.0215, 1.0471, 1.1059, 1.2535,  &
1.0002, 1.0004, 1.0008, 1.0023, 1.0061, 1.0141, 1.0319, 1.0713, 1.1642,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0028, 1.0082, 1.0205, 1.0476, 1.1093,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0009, 1.0032, 1.0112, 1.0296, 1.0712 /
data ((supersat( 5,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0013, 1.0025, 1.0052, 1.0110, 1.0241, 1.0549, 1.1303, 1.3358, 2.0898,  &
1.0010, 1.0014, 1.0035, 1.0074, 1.0157, 1.0346, 1.0789, 1.1897, 1.5153,  &
1.0006, 1.0010, 1.0024, 1.0050, 1.0105, 1.0227, 1.0504, 1.1157, 1.2855,  &
1.0003, 1.0006, 1.0014, 1.0031, 1.0070, 1.0152, 1.0334, 1.0746, 1.1741,  &
1.0002, 1.0003, 1.0006, 1.0017, 1.0042, 1.0099, 1.0223, 1.0497, 1.1127,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0019, 1.0057, 1.0141, 1.0328, 1.0747,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0021, 1.0074, 1.0201, 1.0485 /
data ((supersat( 5,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0021, 1.0041, 1.0085, 1.0190, 1.0434, 1.1025, 1.2563, 1.7362,  &
1.0005, 1.0013, 1.0026, 1.0057, 1.0120, 1.0267, 1.0612, 1.1456, 1.3750,  &
1.0004, 1.0008, 1.0019, 1.0038, 1.0079, 1.0171, 1.0382, 1.0876, 1.2115,  &
1.0003, 1.0005, 1.0011, 1.0023, 1.0052, 1.0112, 1.0247, 1.0554, 1.1281,  &
1.0002, 1.0003, 1.0005, 1.0012, 1.0030, 1.0071, 1.0162, 1.0361, 1.0816,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0014, 1.0040, 1.0100, 1.0234, 1.0533,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0014, 1.0050, 1.0140, 1.0340 /
data ((supersat( 5,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0008, 1.0017, 1.0033, 1.0069, 1.0155, 1.0357, 1.0844, 1.2080, 1.5622,  &
1.0005, 1.0012, 1.0021, 1.0045, 1.0096, 1.0216, 1.0497, 1.1178, 1.2960,  &
1.0004, 1.0008, 1.0014, 1.0030, 1.0062, 1.0135, 1.0304, 1.0699, 1.1672,  &
1.0002, 1.0004, 1.0008, 1.0019, 1.0040, 1.0087, 1.0192, 1.0432, 1.0999,  &
1.0001, 1.0002, 1.0004, 1.0010, 1.0023, 1.0054, 1.0122, 1.0275, 1.0624,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0029, 1.0074, 1.0174, 1.0398,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0035, 1.0100, 1.0248 /
data ((supersat( 5,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0008, 1.0012, 1.0027, 1.0059, 1.0131, 1.0304, 1.0718, 1.1757, 1.4604,  &
1.0006, 1.0008, 1.0019, 1.0038, 1.0080, 1.0181, 1.0418, 1.0992, 1.2458,  &
1.0003, 1.0006, 1.0011, 1.0024, 1.0051, 1.0111, 1.0251, 1.0580, 1.1385,  &
1.0002, 1.0003, 1.0007, 1.0015, 1.0032, 1.0070, 1.0155, 1.0352, 1.0816,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0018, 1.0043, 1.0097, 1.0219, 1.0499,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0022, 1.0057, 1.0135, 1.0311,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0026, 1.0075, 1.0189 /
data ((supersat( 5,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0030, 1.0064, 1.0135, 1.0295, 1.0656, 1.1534, 1.4046, 2.6905, 4.9617,  &
1.0017, 1.0039, 1.0091, 1.0200, 1.0440, 1.0992, 1.2389, 1.7012, 3.9687,  &
1.0008, 1.0021, 1.0054, 1.0132, 1.0297, 1.0665, 1.1535, 1.3919, 2.4937,  &
1.0003, 1.0008, 1.0026, 1.0077, 1.0192, 1.0444, 1.1020, 1.2451, 1.7033,  &
1.0002, 1.0003, 1.0008, 1.0031, 1.0105, 1.0278, 1.0666, 1.1585, 1.4110,  &
1.0002, 1.0002, 1.0004, 1.0008, 1.0035, 1.0142, 1.0397, 1.0995, 1.2518,  &
1.0000, 1.0000, 1.0002, 1.0005, 1.0011, 1.0037, 1.0185, 1.0555, 1.1480 /
data ((supersat( 5,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0022, 1.0044, 1.0093, 1.0202, 1.0447, 1.1027, 1.2548, 1.7983, 3.7006,  &
1.0013, 1.0027, 1.0062, 1.0135, 1.0298, 1.0663, 1.1547, 1.4043, 2.5708,  &
1.0006, 1.0015, 1.0039, 1.0090, 1.0200, 1.0444, 1.1003, 1.2412, 1.6990,  &
1.0003, 1.0006, 1.0019, 1.0053, 1.0130, 1.0297, 1.0671, 1.1552, 1.3956,  &
1.0002, 1.0003, 1.0006, 1.0022, 1.0072, 1.0187, 1.0442, 1.1024, 1.2475,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0024, 1.0096, 1.0268, 1.0658, 1.1585,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0025, 1.0126, 1.0378, 1.0972 /
data ((supersat( 5,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0016, 1.0031, 1.0067, 1.0144, 1.0319, 1.0729, 1.1756, 1.4819, 2.7295,  &
1.0010, 1.0019, 1.0044, 1.0096, 1.0209, 1.0465, 1.1070, 1.2646, 1.8084,  &
1.0005, 1.0011, 1.0028, 1.0062, 1.0139, 1.0308, 1.0690, 1.1611, 1.4190,  &
1.0002, 1.0005, 1.0014, 1.0037, 1.0090, 1.0204, 1.0458, 1.1041, 1.2509,  &
1.0001, 1.0002, 1.0005, 1.0016, 1.0049, 1.0127, 1.0301, 1.0689, 1.1606,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0017, 1.0065, 1.0181, 1.0444, 1.1045,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0017, 1.0084, 1.0255, 1.0650 /
data ((supersat( 5,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0012, 1.0024, 1.0050, 1.0108, 1.0239, 1.0547, 1.1301, 1.3356, 2.0892,  &
1.0008, 1.0013, 1.0032, 1.0071, 1.0153, 1.0343, 1.0785, 1.1893, 1.5146,  &
1.0004, 1.0008, 1.0021, 1.0046, 1.0101, 1.0222, 1.0498, 1.1150, 1.2845,  &
1.0002, 1.0004, 1.0010, 1.0026, 1.0063, 1.0145, 1.0325, 1.0735, 1.1726,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0034, 1.0089, 1.0210, 1.0480, 1.1104,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0043, 1.0124, 1.0306, 1.0716,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0054, 1.0172, 1.0443 /
data ((supersat( 5,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0006, 1.0019, 1.0039, 1.0084, 1.0188, 1.0432, 1.1023, 1.2561, 1.7359,  &
1.0005, 1.0011, 1.0024, 1.0054, 1.0118, 1.0265, 1.0609, 1.1452, 1.3746,  &
1.0003, 1.0007, 1.0016, 1.0035, 1.0075, 1.0167, 1.0378, 1.0871, 1.2109,  &
1.0002, 1.0003, 1.0007, 1.0020, 1.0047, 1.0107, 1.0241, 1.0546, 1.1271,  &
1.0001, 1.0002, 1.0003, 1.0008, 1.0024, 1.0063, 1.0152, 1.0350, 1.0801,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0029, 1.0087, 1.0217, 1.0511,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0035, 1.0118, 1.0310 /
data ((supersat( 5,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0007, 1.0015, 1.0032, 1.0068, 1.0154, 1.0356, 1.0843, 1.2079, 1.5620,  &
1.0005, 1.0010, 1.0019, 1.0043, 1.0095, 1.0214, 1.0495, 1.1176, 1.2957,  &
1.0003, 1.0006, 1.0011, 1.0027, 1.0059, 1.0132, 1.0300, 1.0695, 1.1668,  &
1.0002, 1.0003, 1.0006, 1.0015, 1.0036, 1.0082, 1.0187, 1.0426, 1.0992,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0018, 1.0047, 1.0115, 1.0266, 1.0613,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0021, 1.0063, 1.0161, 1.0382,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0023, 1.0083, 1.0225 /
data ((supersat( 5,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0007, 1.0011, 1.0025, 1.0058, 1.0131, 1.0303, 1.0718, 1.1756, 1.4603,  &
1.0004, 1.0007, 1.0017, 1.0036, 1.0079, 1.0179, 1.0416, 1.0990, 1.2456,  &
1.0002, 1.0004, 1.0010, 1.0021, 1.0048, 1.0108, 1.0248, 1.0578, 1.1382,  &
1.0001, 1.0002, 1.0005, 1.0012, 1.0029, 1.0066, 1.0151, 1.0347, 1.0811,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0014, 1.0037, 1.0090, 1.0212, 1.0491,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0016, 1.0048, 1.0124, 1.0299,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0016, 1.0061, 1.0171 /
data ((supersat( 5,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0028, 1.0061, 1.0132, 1.0291, 1.0652, 1.1528, 1.4037, 2.6879, 4.9574,  &
1.0015, 1.0036, 1.0086, 1.0195, 1.0434, 1.0984, 1.2377, 1.6988, 3.9603,  &
1.0006, 1.0017, 1.0049, 1.0125, 1.0288, 1.0654, 1.1518, 1.3888, 2.4856,  &
1.0003, 1.0006, 1.0020, 1.0068, 1.0179, 1.0428, 1.0996, 1.2413, 1.6951,  &
1.0002, 1.0003, 1.0006, 1.0022, 1.0090, 1.0257, 1.0635, 1.1536, 1.4016,  &
1.0001, 1.0002, 1.0004, 1.0007, 1.0022, 1.0118, 1.0361, 1.0935, 1.2409,  &
0.9998, 0.9998, 1.0000, 1.0003, 1.0009, 1.0024, 1.0148, 1.0490, 1.1360 /
data ((supersat( 5,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0020, 1.0042, 1.0091, 1.0200, 1.0444, 1.1023, 1.2544, 1.7975, 3.6982,  &
1.0011, 1.0025, 1.0059, 1.0132, 1.0294, 1.0658, 1.1540, 1.4032, 2.5679,  &
1.0005, 1.0013, 1.0035, 1.0085, 1.0194, 1.0437, 1.0994, 1.2397, 1.6961,  &
1.0002, 1.0005, 1.0015, 1.0047, 1.0121, 1.0286, 1.0657, 1.1532, 1.3921,  &
1.0001, 1.0002, 1.0005, 1.0016, 1.0062, 1.0173, 1.0424, 1.0997, 1.2429,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0016, 1.0080, 1.0245, 1.0623, 1.1528,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0007, 1.0017, 1.0101, 1.0337, 1.0904 /
data ((supersat( 5,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0015, 1.0030, 1.0065, 1.0143, 1.0318, 1.0727, 1.1753, 1.4815, 2.7284,  &
1.0009, 1.0017, 1.0042, 1.0093, 1.0207, 1.0462, 1.1066, 1.2641, 1.8074,  &
1.0004, 1.0009, 1.0025, 1.0059, 1.0135, 1.0303, 1.0684, 1.1603, 1.4176,  &
1.0002, 1.0004, 1.0011, 1.0033, 1.0084, 1.0197, 1.0449, 1.1029, 1.2490,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0042, 1.0118, 1.0288, 1.0672, 1.1580,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0053, 1.0165, 1.0421, 1.1011,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0005, 1.0012, 1.0066, 1.0228, 1.0608 /
data ((supersat( 5,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0011, 1.0022, 1.0049, 1.0107, 1.0238, 1.0546, 1.1299, 1.3353, 2.0887,  &
1.0006, 1.0012, 1.0031, 1.0069, 1.0151, 1.0341, 1.0783, 1.1890, 1.5141,  &
1.0003, 1.0007, 1.0019, 1.0043, 1.0098, 1.0219, 1.0494, 1.1145, 1.2838,  &
1.0002, 1.0003, 1.0008, 1.0023, 1.0059, 1.0140, 1.0319, 1.0728, 1.1715,  &
1.0001, 1.0002, 1.0003, 1.0008, 1.0029, 1.0082, 1.0201, 1.0469, 1.1089,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0035, 1.0113, 1.0290, 1.0694,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0009, 1.0041, 1.0153, 1.0416 /
data ((supersat( 5,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0006, 1.0018, 1.0038, 1.0083, 1.0187, 1.0431, 1.1022, 1.2560, 1.7357,  &
1.0004, 1.0011, 1.0023, 1.0053, 1.0117, 1.0263, 1.0607, 1.1450, 1.3743,  &
1.0003, 1.0006, 1.0014, 1.0033, 1.0073, 1.0165, 1.0375, 1.0868, 1.2104,  &
1.0001, 1.0003, 1.0006, 1.0017, 1.0044, 1.0103, 1.0236, 1.0541, 1.1264,  &
1.0001, 1.0001, 1.0003, 1.0006, 1.0020, 1.0058, 1.0145, 1.0342, 1.0791,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0006, 1.0023, 1.0078, 1.0206, 1.0496,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0026, 1.0103, 1.0291 /
data ((supersat( 5,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0007, 1.0015, 1.0031, 1.0067, 1.0153, 1.0356, 1.0842, 1.2078, 1.5619,  &
1.0004, 1.0009, 1.0018, 1.0042, 1.0093, 1.0213, 1.0494, 1.1175, 1.2955,  &
1.0002, 1.0005, 1.0010, 1.0025, 1.0057, 1.0130, 1.0298, 1.0693, 1.1665,  &
1.0001, 1.0002, 1.0005, 1.0013, 1.0033, 1.0079, 1.0183, 1.0422, 1.0987,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0015, 1.0043, 1.0109, 1.0260, 1.0605,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0016, 1.0056, 1.0152, 1.0371,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0017, 1.0072, 1.0210 /
data ((supersat( 5,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0006, 1.0010, 1.0025, 1.0057, 1.0130, 1.0302, 1.0717, 1.1755, 1.4602,  &
1.0004, 1.0006, 1.0016, 1.0035, 1.0078, 1.0178, 1.0415, 1.0989, 1.2455,  &
1.0002, 1.0004, 1.0009, 1.0020, 1.0047, 1.0107, 1.0247, 1.0576, 1.1380,  &
1.0001, 1.0002, 1.0004, 1.0010, 1.0026, 1.0063, 1.0148, 1.0344, 1.0807,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0034, 1.0086, 1.0207, 1.0485,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0042, 1.0117, 1.0290,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0052, 1.0158 /
data ((supersat( 5,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0026, 1.0059, 1.0130, 1.0288, 1.0649, 1.1523, 1.4029, 2.6858, 4.9540,  &
1.0013, 1.0034, 1.0083, 1.0191, 1.0429, 1.0977, 1.2367, 1.6969, 3.9536,  &
1.0005, 1.0015, 1.0046, 1.0119, 1.0281, 1.0644, 1.1504, 1.3864, 2.4791,  &
1.0002, 1.0005, 1.0016, 1.0061, 1.0170, 1.0415, 1.0977, 1.2382, 1.6885,  &
1.0002, 1.0003, 1.0005, 1.0016, 1.0079, 1.0241, 1.0611, 1.1497, 1.3942,  &
1.0000, 1.0001, 1.0003, 1.0007, 1.0017, 1.0101, 1.0333, 1.0889, 1.2324,  &
0.9996, 0.9996, 0.9998, 1.0001, 1.0007, 1.0022, 1.0123, 1.0442, 1.1269 /
data ((supersat( 5,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0019, 1.0041, 1.0090, 1.0198, 1.0442, 1.1021, 1.2540, 1.7969, 3.6963,  &
1.0010, 1.0023, 1.0057, 1.0129, 1.0291, 1.0655, 1.1535, 1.4024, 2.5655,  &
1.0004, 1.0011, 1.0032, 1.0082, 1.0190, 1.0431, 1.0986, 1.2385, 1.6937,  &
1.0002, 1.0004, 1.0012, 1.0042, 1.0115, 1.0279, 1.0646, 1.1516, 1.3892,  &
1.0001, 1.0002, 1.0004, 1.0012, 1.0054, 1.0163, 1.0409, 1.0975, 1.2393,  &
1.0001, 1.0001, 1.0003, 1.0005, 1.0012, 1.0068, 1.0227, 1.0595, 1.1482,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0014, 1.0083, 1.0307, 1.0852 /
data ((supersat( 5,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0014, 1.0029, 1.0064, 1.0142, 1.0316, 1.0725, 1.1751, 1.4812, 2.7276,  &
1.0008, 1.0016, 1.0040, 1.0091, 1.0205, 1.0460, 1.1063, 1.2636, 1.8065,  &
1.0003, 1.0008, 1.0023, 1.0056, 1.0132, 1.0299, 1.0679, 1.1596, 1.4166,  &
1.0002, 1.0003, 1.0009, 1.0029, 1.0080, 1.0192, 1.0442, 1.1020, 1.2475,  &
1.0001, 1.0002, 1.0003, 1.0009, 1.0037, 1.0110, 1.0279, 1.0659, 1.1560,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0045, 1.0153, 1.0404, 1.0984,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0010, 1.0053, 1.0208, 1.0576 /
data ((supersat( 5,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0010, 1.0022, 1.0048, 1.0106, 1.0237, 1.0545, 1.1298, 1.3352, 2.0884,  &
1.0005, 1.0012, 1.0030, 1.0067, 1.0150, 1.0339, 1.0781, 1.1887, 1.5137,  &
1.0003, 1.0006, 1.0017, 1.0041, 1.0095, 1.0216, 1.0491, 1.1141, 1.2832,  &
1.0001, 1.0003, 1.0007, 1.0021, 1.0055, 1.0136, 1.0314, 1.0721, 1.1706,  &
1.0001, 1.0001, 1.0003, 1.0007, 1.0025, 1.0076, 1.0195, 1.0461, 1.1076,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0029, 1.0104, 1.0279, 1.0677,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0033, 1.0139, 1.0394 /
data ((supersat( 5,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0006, 1.0018, 1.0037, 1.0082, 1.0187, 1.0431, 1.1021, 1.2559, 1.7355,  &
1.0004, 1.0010, 1.0022, 1.0052, 1.0115, 1.0262, 1.0606, 1.1449, 1.3740,  &
1.0002, 1.0005, 1.0012, 1.0031, 1.0071, 1.0163, 1.0373, 1.0865, 1.2101,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0041, 1.0100, 1.0233, 1.0537, 1.1258,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0017, 1.0054, 1.0140, 1.0335, 1.0783,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0019, 1.0071, 1.0198, 1.0484,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0003, 1.0005, 1.0020, 1.0093, 1.0275 /
data ((supersat( 5,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0006, 1.0014, 1.0030, 1.0067, 1.0153, 1.0355, 1.0842, 1.2077, 1.5618,  &
1.0004, 1.0009, 1.0018, 1.0041, 1.0092, 1.0212, 1.0493, 1.1174, 1.2954,  &
1.0002, 1.0004, 1.0009, 1.0024, 1.0056, 1.0129, 1.0297, 1.0691, 1.1663,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0031, 1.0077, 1.0180, 1.0419, 1.0983,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0040, 1.0105, 1.0255, 1.0599,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0051, 1.0145, 1.0362,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0063, 1.0199 /
data ((supersat( 5,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0006, 1.0010, 1.0024, 1.0056, 1.0129, 1.0302, 1.0717, 1.1754, 1.4601,  &
1.0003, 1.0006, 1.0015, 1.0034, 1.0077, 1.0178, 1.0415, 1.0988, 1.2454,  &
1.0002, 1.0003, 1.0008, 1.0019, 1.0046, 1.0106, 1.0245, 1.0574, 1.1378,  &
1.0001, 1.0002, 1.0003, 1.0009, 1.0024, 1.0061, 1.0146, 1.0342, 1.0804,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0031, 1.0083, 1.0203, 1.0480,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0038, 1.0111, 1.0283,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0045, 1.0149 /
data ((supersat( 5,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0025, 1.0057, 1.0128, 1.0286, 1.0646, 1.1519, 1.4023, 2.6841, 4.9511,  &
1.0011, 1.0032, 1.0080, 1.0188, 1.0425, 1.0972, 1.2358, 1.6952, 3.9477,  &
1.0004, 1.0012, 1.0042, 1.0115, 1.0275, 1.0636, 1.1492, 1.3844, 2.4735,  &
1.0002, 1.0004, 1.0013, 1.0055, 1.0163, 1.0405, 1.0962, 1.2356, 1.6829,  &
1.0001, 1.0003, 1.0005, 1.0013, 1.0071, 1.0228, 1.0591, 1.1464, 1.3879,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0014, 1.0087, 1.0310, 1.0850, 1.2253,  &
0.9994, 0.9995, 0.9996, 0.9999, 1.0005, 1.0021, 1.0103, 1.0405, 1.1196 /
data ((supersat( 5,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0018, 1.0040, 1.0088, 1.0196, 1.0441, 1.1019, 1.2537, 1.7964, 3.6947,  &
1.0009, 1.0021, 1.0055, 1.0127, 1.0288, 1.0651, 1.1530, 1.4017, 2.5635,  &
1.0003, 1.0010, 1.0030, 1.0078, 1.0186, 1.0426, 1.0980, 1.2375, 1.6917,  &
1.0002, 1.0003, 1.0010, 1.0038, 1.0110, 1.0272, 1.0637, 1.1502, 1.3867,  &
1.0001, 1.0002, 1.0003, 1.0010, 1.0048, 1.0154, 1.0397, 1.0957, 1.2362,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0059, 1.0212, 1.0573, 1.1445,  &
0.9998, 0.9999, 0.9999, 1.0001, 1.0005, 1.0013, 1.0070, 1.0283, 1.0809 /
data ((supersat( 5,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0013, 1.0028, 1.0063, 1.0140, 1.0315, 1.0724, 1.1750, 1.4809, 2.7268,  &
1.0007, 1.0015, 1.0039, 1.0090, 1.0203, 1.0458, 1.1060, 1.2633, 1.8058,  &
1.0003, 1.0007, 1.0021, 1.0054, 1.0130, 1.0296, 1.0675, 1.1590, 1.4156,  &
1.0001, 1.0003, 1.0007, 1.0027, 1.0076, 1.0187, 1.0437, 1.1012, 1.2462,  &
1.0001, 1.0002, 1.0003, 1.0008, 1.0033, 1.0105, 1.0271, 1.0648, 1.1543,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0039, 1.0144, 1.0390, 1.0962,  &
1.0000, 1.0000, 1.0000, 1.0002, 1.0004, 1.0009, 1.0044, 1.0192, 1.0550 /
data ((supersat( 5,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0009, 1.0021, 1.0047, 1.0105, 1.0237, 1.0544, 1.1297, 1.3350, 2.0881,  &
1.0005, 1.0011, 1.0028, 1.0066, 1.0149, 1.0337, 1.0779, 1.1885, 1.5133,  &
1.0002, 1.0006, 1.0016, 1.0040, 1.0093, 1.0214, 1.0488, 1.1137, 1.2827,  &
1.0001, 1.0002, 1.0006, 1.0019, 1.0053, 1.0133, 1.0310, 1.0716, 1.1699,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0022, 1.0072, 1.0189, 1.0453, 1.1066,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0006, 1.0025, 1.0097, 1.0269, 1.0663,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0006, 1.0026, 1.0127, 1.0376 /
data ((supersat( 5,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0006, 1.0017, 1.0037, 1.0082, 1.0186, 1.0430, 1.1021, 1.2558, 1.7354,  &
1.0004, 1.0010, 1.0021, 1.0051, 1.0114, 1.0261, 1.0605, 1.1447, 1.3738,  &
1.0002, 1.0004, 1.0011, 1.0030, 1.0070, 1.0161, 1.0371, 1.0863, 1.2098,  &
1.0001, 1.0002, 1.0004, 1.0014, 1.0039, 1.0097, 1.0230, 1.0533, 1.1254,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0015, 1.0051, 1.0136, 1.0330, 1.0776,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0016, 1.0066, 1.0190, 1.0475,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0016, 1.0084, 1.0263 /
data ((supersat( 5,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0006, 1.0014, 1.0030, 1.0067, 1.0152, 1.0355, 1.0841, 1.2076, 1.5617,  &
1.0004, 1.0008, 1.0017, 1.0040, 1.0092, 1.0211, 1.0492, 1.1173, 1.2952,  &
1.0002, 1.0004, 1.0009, 1.0023, 1.0055, 1.0128, 1.0295, 1.0689, 1.1661,  &
1.0001, 1.0002, 1.0004, 1.0010, 1.0029, 1.0075, 1.0178, 1.0417, 1.0980,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0011, 1.0038, 1.0102, 1.0251, 1.0594,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0011, 1.0047, 1.0140, 1.0355,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0011, 1.0057, 1.0189 /
data ((supersat( 5,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0006, 1.0010, 1.0024, 1.0056, 1.0129, 1.0302, 1.0716, 1.1754, 1.4601,  &
1.0003, 1.0006, 1.0015, 1.0033, 1.0076, 1.0177, 1.0414, 1.0987, 1.2453,  &
1.0001, 1.0003, 1.0008, 1.0018, 1.0044, 1.0105, 1.0244, 1.0573, 1.1376,  &
1.0001, 1.0001, 1.0003, 1.0008, 1.0023, 1.0060, 1.0144, 1.0340, 1.0802,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0008, 1.0029, 1.0080, 1.0200, 1.0476,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0034, 1.0107, 1.0277,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0003, 1.0009, 1.0040, 1.0141 /
data ((supersat( 6,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0028, 1.0061, 1.0133, 1.0292, 1.0653, 1.1529, 1.4038, 2.6882, 4.9580,  &
1.0015, 1.0036, 1.0087, 1.0196, 1.0435, 1.0985, 1.2379, 1.6992, 3.9613,  &
1.0006, 1.0018, 1.0050, 1.0126, 1.0290, 1.0655, 1.1520, 1.3892, 2.4866,  &
1.0003, 1.0006, 1.0021, 1.0069, 1.0181, 1.0430, 1.0999, 1.2417, 1.6960,  &
1.0002, 1.0003, 1.0006, 1.0023, 1.0093, 1.0260, 1.0638, 1.1541, 1.4025,  &
1.0001, 1.0002, 1.0004, 1.0007, 1.0024, 1.0121, 1.0364, 1.0940, 1.2418,  &
0.9998, 0.9999, 1.0000, 1.0003, 1.0009, 1.0025, 1.0151, 1.0493, 1.1365 /
data ((supersat( 6,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0020, 1.0042, 1.0092, 1.0200, 1.0445, 1.1024, 1.2545, 1.7977, 3.6985,  &
1.0011, 1.0025, 1.0060, 1.0133, 1.0294, 1.0659, 1.1541, 1.4034, 2.5683,  &
1.0005, 1.0013, 1.0036, 1.0086, 1.0195, 1.0438, 1.0995, 1.2399, 1.6965,  &
1.0002, 1.0005, 1.0015, 1.0048, 1.0123, 1.0288, 1.0659, 1.1535, 1.3925,  &
1.0001, 1.0002, 1.0005, 1.0017, 1.0063, 1.0175, 1.0426, 1.1001, 1.2435,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0017, 1.0082, 1.0248, 1.0627, 1.1534,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0007, 1.0018, 1.0104, 1.0341, 1.0909 /
data ((supersat( 6,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0015, 1.0030, 1.0065, 1.0143, 1.0318, 1.0727, 1.1754, 1.4816, 2.7286,  &
1.0009, 1.0018, 1.0042, 1.0094, 1.0207, 1.0463, 1.1067, 1.2642, 1.8075,  &
1.0004, 1.0009, 1.0026, 1.0059, 1.0136, 1.0304, 1.0685, 1.1604, 1.4179,  &
1.0002, 1.0004, 1.0011, 1.0033, 1.0085, 1.0198, 1.0451, 1.1031, 1.2493,  &
1.0001, 1.0002, 1.0004, 1.0012, 1.0043, 1.0119, 1.0291, 1.0675, 1.1585,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0055, 1.0168, 1.0424, 1.1016,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0005, 1.0013, 1.0068, 1.0232, 1.0613 /
data ((supersat( 6,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0011, 1.0023, 1.0049, 1.0107, 1.0238, 1.0546, 1.1300, 1.3354, 2.0888,  &
1.0006, 1.0012, 1.0031, 1.0069, 1.0152, 1.0341, 1.0784, 1.1890, 1.5142,  &
1.0003, 1.0007, 1.0019, 1.0044, 1.0098, 1.0220, 1.0495, 1.1146, 1.2839,  &
1.0002, 1.0003, 1.0008, 1.0024, 1.0060, 1.0141, 1.0320, 1.0729, 1.1717,  &
1.0001, 1.0002, 1.0003, 1.0009, 1.0030, 1.0083, 1.0203, 1.0472, 1.1092,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0036, 1.0115, 1.0293, 1.0698,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0009, 1.0043, 1.0156, 1.0420 /
data ((supersat( 6,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0018, 1.0038, 1.0083, 1.0188, 1.0432, 1.1022, 1.2560, 1.7357,  &
1.0004, 1.0011, 1.0023, 1.0053, 1.0117, 1.0264, 1.0608, 1.1451, 1.3743,  &
1.0003, 1.0006, 1.0014, 1.0033, 1.0073, 1.0165, 1.0376, 1.0869, 1.2105,  &
1.0001, 1.0003, 1.0006, 1.0018, 1.0044, 1.0103, 1.0237, 1.0542, 1.1266,  &
1.0001, 1.0001, 1.0003, 1.0006, 1.0021, 1.0059, 1.0147, 1.0343, 1.0794,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0024, 1.0080, 1.0209, 1.0499,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0027, 1.0106, 1.0294 /
data ((supersat( 6,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0007, 1.0015, 1.0031, 1.0068, 1.0153, 1.0356, 1.0842, 1.2078, 1.5620,  &
1.0004, 1.0009, 1.0018, 1.0042, 1.0093, 1.0213, 1.0494, 1.1175, 1.2956,  &
1.0002, 1.0005, 1.0010, 1.0026, 1.0058, 1.0131, 1.0299, 1.0694, 1.1666,  &
1.0001, 1.0002, 1.0005, 1.0014, 1.0034, 1.0080, 1.0184, 1.0423, 1.0989,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0015, 1.0044, 1.0110, 1.0261, 1.0607,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0017, 1.0057, 1.0154, 1.0374,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0018, 1.0074, 1.0214 /
data ((supersat( 6,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0010, 1.0025, 1.0057, 1.0130, 1.0303, 1.0717, 1.1755, 1.4602,  &
1.0004, 1.0006, 1.0016, 1.0035, 1.0078, 1.0179, 1.0416, 1.0989, 1.2456,  &
1.0002, 1.0004, 1.0009, 1.0020, 1.0047, 1.0107, 1.0247, 1.0576, 1.1381,  &
1.0001, 1.0002, 1.0004, 1.0010, 1.0027, 1.0064, 1.0149, 1.0345, 1.0808,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0034, 1.0087, 1.0208, 1.0487,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0043, 1.0119, 1.0292,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0053, 1.0162 /
data ((supersat( 6,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0024, 1.0056, 1.0127, 1.0285, 1.0644, 1.1518, 1.4020, 2.6832, 4.9495,  &
1.0010, 1.0031, 1.0079, 1.0186, 1.0422, 1.0969, 1.2354, 1.6943, 3.9445,  &
1.0004, 1.0011, 1.0041, 1.0112, 1.0272, 1.0632, 1.1486, 1.3832, 2.4703,  &
1.0002, 1.0004, 1.0012, 1.0052, 1.0158, 1.0399, 1.0953, 1.2340, 1.6796,  &
1.0001, 1.0002, 1.0004, 1.0012, 1.0066, 1.0220, 1.0580, 1.1445, 1.3842,  &
0.9999, 1.0000, 1.0002, 1.0006, 1.0013, 1.0080, 1.0297, 1.0827, 1.2210,  &
0.9993, 0.9993, 0.9994, 0.9997, 1.0004, 1.0020, 1.0093, 1.0383, 1.1152 /
data ((supersat( 6,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0017, 1.0039, 1.0088, 1.0196, 1.0440, 1.1018, 1.2536, 1.7961, 3.6938,  &
1.0008, 1.0021, 1.0054, 1.0126, 1.0287, 1.0650, 1.1528, 1.4013, 2.5624,  &
1.0003, 1.0009, 1.0028, 1.0077, 1.0184, 1.0424, 1.0976, 1.2370, 1.6907,  &
1.0002, 1.0003, 1.0009, 1.0036, 1.0107, 1.0269, 1.0632, 1.1494, 1.3854,  &
1.0001, 1.0002, 1.0003, 1.0009, 1.0045, 1.0150, 1.0391, 1.0947, 1.2345,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0009, 1.0054, 1.0204, 1.0560, 1.1423,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0004, 1.0013, 1.0063, 1.0269, 1.0784 /
data ((supersat( 6,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0013, 1.0028, 1.0063, 1.0140, 1.0315, 1.0723, 1.1749, 1.4808, 2.7264,  &
1.0006, 1.0015, 1.0038, 1.0089, 1.0202, 1.0457, 1.1059, 1.2631, 1.8055,  &
1.0003, 1.0007, 1.0020, 1.0053, 1.0128, 1.0295, 1.0673, 1.1588, 1.4152,  &
1.0001, 1.0003, 1.0007, 1.0025, 1.0074, 1.0185, 1.0434, 1.1008, 1.2456,  &
1.0001, 1.0001, 1.0003, 1.0007, 1.0030, 1.0101, 1.0267, 1.0642, 1.1534,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0035, 1.0138, 1.0382, 1.0950,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0004, 1.0009, 1.0039, 1.0183, 1.0535 /
data ((supersat( 6,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0009, 1.0021, 1.0047, 1.0105, 1.0236, 1.0544, 1.1296, 1.3350, 2.0880,  &
1.0004, 1.0011, 1.0028, 1.0066, 1.0148, 1.0337, 1.0779, 1.1884, 1.5132,  &
1.0002, 1.0005, 1.0015, 1.0039, 1.0092, 1.0213, 1.0487, 1.1136, 1.2824,  &
1.0001, 1.0002, 1.0005, 1.0018, 1.0052, 1.0131, 1.0308, 1.0714, 1.1695,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0020, 1.0070, 1.0186, 1.0450, 1.1060,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0022, 1.0093, 1.0264, 1.0656,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0006, 1.0023, 1.0121, 1.0367 /
data ((supersat( 6,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0006, 1.0017, 1.0037, 1.0082, 1.0186, 1.0430, 1.1020, 1.2557, 1.7353,  &
1.0004, 1.0009, 1.0020, 1.0050, 1.0114, 1.0261, 1.0604, 1.1447, 1.3738,  &
1.0002, 1.0004, 1.0011, 1.0029, 1.0069, 1.0161, 1.0370, 1.0862, 1.2096,  &
1.0001, 1.0002, 1.0004, 1.0013, 1.0038, 1.0096, 1.0229, 1.0532, 1.1252,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0014, 1.0049, 1.0134, 1.0328, 1.0772,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0015, 1.0063, 1.0187, 1.0470,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0015, 1.0080, 1.0257 /
data ((supersat( 6,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0006, 1.0013, 1.0029, 1.0066, 1.0152, 1.0354, 1.0841, 1.2076, 1.5617,  &
1.0003, 1.0008, 1.0017, 1.0040, 1.0091, 1.0211, 1.0491, 1.1172, 1.2952,  &
1.0002, 1.0003, 1.0009, 1.0022, 1.0054, 1.0127, 1.0295, 1.0689, 1.1660,  &
1.0001, 1.0002, 1.0003, 1.0010, 1.0028, 1.0074, 1.0177, 1.0415, 1.0979,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0036, 1.0101, 1.0249, 1.0592,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0044, 1.0137, 1.0352,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0010, 1.0054, 1.0185 /
data ((supersat( 6,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0010, 1.0024, 1.0056, 1.0129, 1.0301, 1.0716, 1.1754, 1.4601,  &
1.0003, 1.0005, 1.0015, 1.0033, 1.0076, 1.0177, 1.0414, 1.0987, 1.2453,  &
1.0001, 1.0003, 1.0007, 1.0018, 1.0044, 1.0104, 1.0244, 1.0572, 1.1376,  &
1.0001, 1.0001, 1.0003, 1.0008, 1.0022, 1.0059, 1.0143, 1.0339, 1.0801,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0008, 1.0028, 1.0079, 1.0198, 1.0475,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0003, 1.0008, 1.0033, 1.0105, 1.0275,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0037, 1.0138 /
data ((supersat( 6,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0019, 1.0050, 1.0120, 1.0276, 1.0634, 1.1503, 1.3997, 2.6765, 4.9384,  &
1.0006, 1.0024, 1.0069, 1.0174, 1.0407, 1.0948, 1.2321, 1.6880, 3.9223,  &
1.0002, 1.0006, 1.0029, 1.0096, 1.0251, 1.0603, 1.1442, 1.3754, 2.4492,  &
1.0002, 1.0003, 1.0007, 1.0034, 1.0131, 1.0361, 1.0894, 1.2242, 1.6586,  &
1.0000, 1.0001, 1.0003, 1.0008, 1.0038, 1.0175, 1.0509, 1.1326, 1.3609,  &
0.9996, 0.9996, 0.9998, 1.0002, 1.0011, 1.0041, 1.0224, 1.0697, 1.1959,  &
0.9983, 0.9984, 0.9985, 0.9988, 0.9994, 1.0011, 1.0052, 1.0272, 1.0918 /
data ((supersat( 6,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0014, 1.0035, 1.0083, 1.0190, 1.0433, 1.1010, 1.2524, 1.7940, 3.6874,  &
1.0005, 1.0017, 1.0048, 1.0118, 1.0277, 1.0638, 1.1511, 1.3985, 2.5546,  &
1.0002, 1.0005, 1.0021, 1.0066, 1.0170, 1.0406, 1.0952, 1.2331, 1.6831,  &
1.0001, 1.0002, 1.0005, 1.0024, 1.0089, 1.0245, 1.0598, 1.1443, 1.3761,  &
1.0001, 1.0001, 1.0003, 1.0005, 1.0026, 1.0120, 1.0347, 1.0880, 1.2230,  &
0.9999, 0.9999, 1.0000, 1.0003, 1.0007, 1.0028, 1.0156, 1.0481, 1.1287,  &
0.9993, 0.9993, 0.9994, 0.9995, 0.9999, 1.0009, 1.0030, 1.0193, 1.0643 /
data ((supersat( 6,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0010, 1.0025, 1.0059, 1.0136, 1.0310, 1.0719, 1.1743, 1.4798, 2.7235,  &
1.0004, 1.0012, 1.0033, 1.0084, 1.0196, 1.0449, 1.1049, 1.2616, 1.8028,  &
1.0002, 1.0004, 1.0015, 1.0046, 1.0119, 1.0283, 1.0658, 1.1566, 1.4116,  &
1.0001, 1.0002, 1.0004, 1.0017, 1.0061, 1.0169, 1.0412, 1.0977, 1.2407,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0018, 1.0081, 1.0238, 1.0601, 1.1470,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0018, 1.0105, 1.0331, 1.0869,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0001, 1.0006, 1.0019, 1.0131, 1.0445 /
data ((supersat( 6,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0019, 1.0045, 1.0102, 1.0233, 1.0540, 1.1293, 1.3344, 2.0868,  &
1.0003, 1.0009, 1.0024, 1.0061, 1.0143, 1.0332, 1.0772, 1.1875, 1.5118,  &
1.0001, 1.0003, 1.0011, 1.0032, 1.0086, 1.0205, 1.0477, 1.1123, 1.2804,  &
1.0001, 1.0001, 1.0003, 1.0012, 1.0043, 1.0119, 1.0294, 1.0694, 1.1667,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0012, 1.0055, 1.0166, 1.0422, 1.1021,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0012, 1.0069, 1.0229, 1.0603,  &
0.9998, 0.9998, 0.9999, 0.9999, 1.0001, 1.0005, 1.0013, 1.0084, 1.0306 /
data ((supersat( 6,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0005, 1.0015, 1.0035, 1.0080, 1.0184, 1.0427, 1.1018, 1.2554, 1.7347,  &
1.0003, 1.0007, 1.0018, 1.0047, 1.0111, 1.0257, 1.0600, 1.1441, 1.3730,  &
1.0001, 1.0003, 1.0008, 1.0024, 1.0064, 1.0155, 1.0363, 1.0853, 1.2084,  &
1.0001, 1.0001, 1.0003, 1.0008, 1.0031, 1.0087, 1.0218, 1.0518, 1.1233,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0038, 1.0119, 1.0308, 1.0746,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0045, 1.0161, 1.0433,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0009, 1.0052, 1.0213 /
data ((supersat( 6,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0005, 1.0012, 1.0028, 1.0065, 1.0151, 1.0353, 1.0839, 1.2074, 1.5613,  &
1.0002, 1.0005, 1.0015, 1.0037, 1.0089, 1.0208, 1.0488, 1.1169, 1.2947,  &
1.0001, 1.0002, 1.0006, 1.0019, 1.0050, 1.0122, 1.0289, 1.0682, 1.1652,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0023, 1.0067, 1.0169, 1.0405, 1.0966,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0027, 1.0089, 1.0235, 1.0573,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0031, 1.0117, 1.0324,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0007, 1.0033, 1.0151 /
data ((supersat( 6,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0004, 1.0009, 1.0023, 1.0055, 1.0127, 1.0300, 1.0714, 1.1752, 1.4598,  &
1.0002, 1.0005, 1.0013, 1.0031, 1.0073, 1.0174, 1.0411, 1.0984, 1.2449,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0040, 1.0100, 1.0239, 1.0568, 1.1370,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0018, 1.0053, 1.0136, 1.0331, 1.0791,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0020, 1.0069, 1.0186, 1.0460,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0022, 1.0088, 1.0253,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0002, 1.0005, 1.0022, 1.0111 /
data ((supersat( 6,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0013, 1.0043, 1.0112, 1.0266, 1.0621, 1.1485, 1.3967, 2.6677, 4.9235,  &
1.0004, 1.0016, 1.0058, 1.0159, 1.0388, 1.0922, 1.2280, 1.6798, 3.8932,  &
1.0002, 1.0004, 1.0017, 1.0077, 1.0226, 1.0567, 1.1386, 1.3654, 2.4219,  &
1.0001, 1.0002, 1.0005, 1.0018, 1.0101, 1.0315, 1.0823, 1.2119, 1.6318,  &
0.9998, 0.9999, 1.0001, 1.0006, 1.0019, 1.0127, 1.0427, 1.1182, 1.3323,  &
0.9989, 0.9990, 0.9991, 0.9995, 1.0005, 1.0027, 1.0152, 1.0555, 1.1671,  &
0.9969, 0.9969, 0.9970, 0.9973, 0.9980, 0.9996, 1.0037, 1.0172, 1.0686 /
data ((supersat( 6,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0010, 1.0031, 1.0078, 1.0184, 1.0425, 1.1000, 1.2510, 1.7913, 3.6792,  &
1.0003, 1.0012, 1.0041, 1.0109, 1.0265, 1.0622, 1.1490, 1.3949, 2.5444,  &
1.0001, 1.0003, 1.0013, 1.0053, 1.0154, 1.0385, 1.0921, 1.2283, 1.6733,  &
1.0001, 1.0002, 1.0003, 1.0013, 1.0069, 1.0216, 1.0557, 1.1377, 1.3643,  &
1.0000, 1.0000, 1.0002, 1.0004, 1.0013, 1.0087, 1.0296, 1.0799, 1.2087,  &
0.9995, 0.9996, 0.9997, 0.9999, 1.0005, 1.0017, 1.0106, 1.0392, 1.1127,  &
0.9984, 0.9984, 0.9985, 0.9986, 0.9991, 1.0001, 1.0025, 1.0122, 1.0496 /
data ((supersat( 6,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0007, 1.0022, 1.0055, 1.0132, 1.0305, 1.0712, 1.1735, 1.4785, 2.7197,  &
1.0003, 1.0009, 1.0029, 1.0077, 1.0188, 1.0439, 1.1037, 1.2598, 1.7993,  &
1.0001, 1.0003, 1.0009, 1.0037, 1.0108, 1.0269, 1.0640, 1.1539, 1.4070,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0047, 1.0150, 1.0386, 1.0939, 1.2345,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0010, 1.0058, 1.0205, 1.0550, 1.1389,  &
0.9998, 0.9998, 0.9999, 1.0001, 1.0004, 1.0011, 1.0070, 1.0273, 1.0772,  &
0.9992, 0.9992, 0.9992, 0.9993, 0.9996, 1.0002, 1.0016, 1.0079, 1.0348 /
data ((supersat( 6,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0006, 1.0017, 1.0042, 1.0099, 1.0230, 1.0536, 1.1288, 1.3337, 2.0853,  &
1.0002, 1.0006, 1.0021, 1.0056, 1.0138, 1.0325, 1.0764, 1.1865, 1.5100,  &
1.0001, 1.0002, 1.0007, 1.0027, 1.0077, 1.0195, 1.0465, 1.1106, 1.2779,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0032, 1.0105, 1.0276, 1.0670, 1.1631,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0007, 1.0038, 1.0142, 1.0389, 1.0971,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0007, 1.0044, 1.0188, 1.0540,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9998, 1.0002, 1.0010, 1.0047, 1.0240 /
data ((supersat( 6,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0005, 1.0013, 1.0032, 1.0077, 1.0181, 1.0425, 1.1014, 1.2550, 1.7340,  &
1.0002, 1.0005, 1.0016, 1.0043, 1.0106, 1.0252, 1.0594, 1.1434, 1.3719,  &
1.0001, 1.0002, 1.0005, 1.0020, 1.0058, 1.0147, 1.0354, 1.0842, 1.2068,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0023, 1.0077, 1.0205, 1.0501, 1.1210,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0026, 1.0101, 1.0284, 1.0712,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0027, 1.0131, 1.0389,  &
0.9996, 0.9997, 0.9997, 0.9997, 0.9998, 1.0001, 1.0007, 1.0028, 1.0164 /
data ((supersat( 6,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0004, 1.0010, 1.0026, 1.0063, 1.0148, 1.0350, 1.0837, 1.2071, 1.5609,  &
1.0002, 1.0004, 1.0013, 1.0034, 1.0085, 1.0204, 1.0484, 1.1164, 1.2940,  &
1.0001, 1.0002, 1.0004, 1.0015, 1.0045, 1.0116, 1.0282, 1.0674, 1.1641,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0017, 1.0058, 1.0159, 1.0393, 1.0949,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0018, 1.0075, 1.0216, 1.0548,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0018, 1.0094, 1.0291,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 1.0001, 1.0005, 1.0019, 1.0114 /
data ((supersat( 6,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0021, 1.0053, 1.0126, 1.0298, 1.0712, 1.1750, 1.4595,  &
1.0001, 1.0003, 1.0010, 1.0028, 1.0071, 1.0171, 1.0408, 1.0980, 1.2444,  &
1.0001, 1.0001, 1.0003, 1.0012, 1.0036, 1.0095, 1.0234, 1.0561, 1.1362,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0046, 1.0128, 1.0321, 1.0778,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0057, 1.0171, 1.0441,  &
1.0000, 1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0013, 1.0069, 1.0227,  &
0.9997, 0.9997, 0.9998, 0.9998, 0.9999, 1.0000, 1.0004, 1.0014, 1.0082 /
data ((supersat( 6,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0011, 1.0038, 1.0106, 1.0259, 1.0612, 1.1472, 1.3945, 2.6614, 4.9128,  &
1.0003, 1.0012, 1.0051, 1.0150, 1.0375, 1.0903, 1.2251, 1.6740, 3.8722,  &
1.0002, 1.0003, 1.0012, 1.0065, 1.0209, 1.0542, 1.1347, 1.3583, 2.4023,  &
1.0000, 1.0001, 1.0004, 1.0012, 1.0082, 1.0285, 1.0774, 1.2034, 1.6131,  &
0.9995, 0.9996, 0.9999, 1.0004, 1.0017, 1.0098, 1.0375, 1.1087, 1.3130,  &
0.9983, 0.9984, 0.9985, 0.9989, 0.9999, 1.0023, 1.0112, 1.0471, 1.1491,  &
0.9959, 0.9959, 0.9960, 0.9963, 0.9969, 0.9985, 1.0025, 1.0123, 1.0561 /
data ((supersat( 6,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0008, 1.0028, 1.0074, 1.0179, 1.0420, 1.0992, 1.2499, 1.7894, 3.6731,  &
1.0002, 1.0009, 1.0036, 1.0103, 1.0257, 1.0612, 1.1474, 1.3923, 2.5370,  &
1.0001, 1.0003, 1.0009, 1.0045, 1.0143, 1.0370, 1.0899, 1.2248, 1.6663,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0056, 1.0197, 1.0528, 1.1332, 1.3560,  &
0.9998, 0.9999, 1.0001, 1.0004, 1.0010, 1.0067, 1.0264, 1.0744, 1.1990,  &
0.9992, 0.9993, 0.9994, 0.9996, 1.0002, 1.0015, 1.0077, 1.0338, 1.1023,  &
0.9977, 0.9977, 0.9978, 0.9979, 0.9983, 0.9994, 1.0018, 1.0085, 1.0412 /
data ((supersat( 6,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0006, 1.0020, 1.0052, 1.0129, 1.0302, 1.0708, 1.1729, 1.4776, 2.7170,  &
1.0002, 1.0007, 1.0026, 1.0073, 1.0182, 1.0432, 1.1028, 1.2584, 1.7968,  &
1.0001, 1.0002, 1.0007, 1.0032, 1.0100, 1.0259, 1.0627, 1.1520, 1.4036,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0038, 1.0136, 1.0368, 1.0912, 1.2302,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0007, 1.0044, 1.0183, 1.0516, 1.1334,  &
0.9996, 0.9997, 0.9997, 0.9999, 1.0002, 1.0010, 1.0049, 1.0236, 1.0709,  &
0.9987, 0.9987, 0.9987, 0.9989, 0.9991, 0.9998, 1.0012, 1.0053, 1.0291 /
data ((supersat( 6,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0005, 1.0015, 1.0040, 1.0096, 1.0227, 1.0533, 1.1284, 1.3332, 2.0842,  &
1.0002, 1.0005, 1.0019, 1.0053, 1.0134, 1.0320, 1.0759, 1.1857, 1.5087,  &
1.0001, 1.0002, 1.0005, 1.0022, 1.0072, 1.0188, 1.0456, 1.1094, 1.2761,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0026, 1.0096, 1.0263, 1.0653, 1.1605,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0029, 1.0127, 1.0366, 1.0936,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0007, 1.0030, 1.0163, 1.0499,  &
0.9992, 0.9992, 0.9992, 0.9993, 0.9995, 0.9999, 1.0008, 1.0032, 1.0200 /
data ((supersat( 6,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0004, 1.0012, 1.0031, 1.0076, 1.0179, 1.0422, 1.1012, 1.2546, 1.7335,  &
1.0001, 1.0004, 1.0014, 1.0040, 1.0103, 1.0249, 1.0590, 1.1429, 1.3711,  &
1.0001, 1.0001, 1.0004, 1.0016, 1.0054, 1.0142, 1.0348, 1.0834, 1.2057,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0018, 1.0070, 1.0196, 1.0489, 1.1193,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0019, 1.0089, 1.0268, 1.0688,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0019, 1.0112, 1.0360,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9996, 0.9999, 1.0005, 1.0020, 1.0135 /
data ((supersat( 6,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0024, 1.0061, 1.0147, 1.0349, 1.0835, 1.2068, 1.5605,  &
1.0001, 1.0003, 1.0011, 1.0032, 1.0083, 1.0201, 1.0481, 1.1160, 1.2935,  &
1.0001, 1.0001, 1.0003, 1.0012, 1.0042, 1.0112, 1.0278, 1.0668, 1.1633,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0053, 1.0151, 1.0384, 1.0937,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0065, 1.0203, 1.0531,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0013, 1.0079, 1.0269,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 1.0003, 1.0014, 1.0092 /
data ((supersat( 6,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0020, 1.0052, 1.0124, 1.0297, 1.0711, 1.1748, 1.4592,  &
1.0001, 1.0003, 1.0009, 1.0026, 1.0069, 1.0169, 1.0405, 1.0977, 1.2440,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0033, 1.0092, 1.0230, 1.0556, 1.1356,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0010, 1.0041, 1.0122, 1.0313, 1.0769,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0010, 1.0049, 1.0161, 1.0427,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0010, 1.0057, 1.0209,  &
0.9995, 0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0002, 1.0011, 1.0064 /
data ((supersat( 6,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0009, 1.0035, 1.0102, 1.0254, 1.0605, 1.1462, 1.3928, 2.6561, 4.9039,  &
1.0002, 1.0009, 1.0046, 1.0142, 1.0365, 1.0888, 1.2227, 1.6692, 3.8552,  &
1.0001, 1.0003, 1.0009, 1.0057, 1.0195, 1.0522, 1.1316, 1.3527, 2.3866,  &
0.9999, 1.0001, 1.0004, 1.0010, 1.0068, 1.0262, 1.0737, 1.1967, 1.5983,  &
0.9993, 0.9994, 0.9997, 1.0002, 1.0015, 1.0079, 1.0338, 1.1017, 1.2982,  &
0.9978, 0.9978, 0.9980, 0.9984, 0.9994, 1.0018, 1.0087, 1.0414, 1.1361,  &
0.9951, 0.9952, 0.9953, 0.9955, 0.9961, 0.9977, 1.0015, 1.0124, 1.0480 /
data ((supersat( 6,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0007, 1.0025, 1.0071, 1.0175, 1.0416, 1.0987, 1.2491, 1.7878, 3.6682,  &
1.0002, 1.0007, 1.0032, 1.0098, 1.0251, 1.0603, 1.1462, 1.3902, 2.5309,  &
1.0001, 1.0002, 1.0007, 1.0039, 1.0135, 1.0358, 1.0882, 1.2220, 1.6606,  &
1.0000, 1.0001, 1.0003, 1.0007, 1.0047, 1.0182, 1.0506, 1.1296, 1.3494,  &
0.9997, 0.9998, 0.9999, 1.0003, 1.0010, 1.0054, 1.0239, 1.0702, 1.1913,  &
0.9989, 0.9990, 0.9991, 0.9993, 0.9999, 1.0013, 1.0059, 1.0300, 1.0947,  &
0.9971, 0.9971, 0.9971, 0.9973, 0.9977, 0.9987, 1.0012, 1.0077, 1.0356 /
data ((supersat( 6,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0005, 1.0019, 1.0050, 1.0126, 1.0299, 1.0705, 1.1724, 1.4769, 2.7147,  &
1.0002, 1.0005, 1.0023, 1.0070, 1.0178, 1.0428, 1.1021, 1.2573, 1.7946,  &
1.0001, 1.0002, 1.0005, 1.0028, 1.0094, 1.0252, 1.0616, 1.1504, 1.4009,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0032, 1.0126, 1.0354, 1.0891, 1.2267,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0035, 1.0166, 1.0490, 1.1290,  &
0.9995, 0.9995, 0.9996, 0.9997, 1.0001, 1.0009, 1.0037, 1.0210, 1.0662,  &
0.9983, 0.9983, 0.9983, 0.9984, 0.9987, 0.9993, 1.0009, 1.0046, 1.0252 /
data ((supersat( 6,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0004, 1.0014, 1.0038, 1.0095, 1.0225, 1.0531, 1.1281, 1.3328, 2.0832,  &
1.0001, 1.0004, 1.0017, 1.0051, 1.0131, 1.0317, 1.0754, 1.1850, 1.5076,  &
1.0001, 1.0001, 1.0004, 1.0019, 1.0067, 1.0183, 1.0449, 1.1085, 1.2746,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0021, 1.0089, 1.0254, 1.0639, 1.1584,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0022, 1.0115, 1.0348, 1.0908,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0001, 1.0006, 1.0023, 1.0144, 1.0467,  &
0.9989, 0.9989, 0.9989, 0.9990, 0.9992, 0.9996, 1.0005, 1.0028, 1.0172 /
data ((supersat( 6,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0003, 1.0010, 1.0029, 1.0074, 1.0178, 1.0421, 1.1010, 1.2544, 1.7330,  &
1.0001, 1.0003, 1.0013, 1.0038, 1.0101, 1.0246, 1.0587, 1.1425, 1.3705,  &
1.0001, 1.0001, 1.0003, 1.0014, 1.0050, 1.0138, 1.0343, 1.0828, 1.2047,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0015, 1.0064, 1.0188, 1.0480, 1.1179,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0004, 1.0015, 1.0081, 1.0255, 1.0669,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0001, 1.0004, 1.0016, 1.0098, 1.0337,  &
0.9992, 0.9992, 0.9992, 0.9993, 0.9994, 0.9997, 1.0003, 1.0018, 1.0115 /
data ((supersat( 6,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0023, 1.0060, 1.0146, 1.0347, 1.0833, 1.2067, 1.5602,  &
1.0001, 1.0003, 1.0010, 1.0030, 1.0081, 1.0199, 1.0478, 1.1157, 1.2930,  &
1.0001, 1.0001, 1.0003, 1.0011, 1.0039, 1.0109, 1.0274, 1.0664, 1.1626,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0011, 1.0048, 1.0146, 1.0376, 1.0927,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0011, 1.0058, 1.0194, 1.0517,  &
0.9998, 0.9998, 0.9999, 0.9999, 1.0001, 1.0003, 1.0011, 1.0068, 1.0252,  &
0.9993, 0.9993, 0.9993, 0.9994, 0.9995, 0.9997, 1.0002, 1.0013, 1.0077 /
data ((supersat( 6,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0020, 1.0051, 1.0123, 1.0296, 1.0710, 1.1746, 1.4590,  &
1.0001, 1.0002, 1.0008, 1.0025, 1.0067, 1.0167, 1.0403, 1.0975, 1.2437,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0031, 1.0089, 1.0226, 1.0553, 1.1351,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0008, 1.0038, 1.0117, 1.0307, 1.0761,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0044, 1.0153, 1.0416,  &
0.9998, 0.9998, 0.9999, 0.9999, 1.0000, 1.0003, 1.0009, 1.0049, 1.0196,  &
0.9994, 0.9994, 0.9994, 0.9994, 0.9995, 0.9997, 1.0001, 1.0009, 1.0052 /
data ((supersat( 6,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0008, 1.0033, 1.0098, 1.0249, 1.0598, 1.1453, 1.3913, 2.6517, 4.8965,  &
1.0002, 1.0008, 1.0041, 1.0135, 1.0356, 1.0876, 1.2207, 1.6652, 3.8407,  &
1.0001, 1.0003, 1.0008, 1.0049, 1.0185, 1.0506, 1.1290, 1.3479, 2.3731,  &
0.9998, 1.0000, 1.0003, 1.0010, 1.0058, 1.0244, 1.0706, 1.1911, 1.5859,  &
0.9991, 0.9992, 0.9994, 1.0000, 1.0014, 1.0064, 1.0309, 1.0960, 1.2860,  &
0.9973, 0.9974, 0.9975, 0.9980, 0.9990, 1.0014, 1.0069, 1.0370, 1.1260,  &
0.9946, 0.9946, 0.9947, 0.9949, 0.9955, 0.9970, 1.0007, 1.0111, 1.0422 /
data ((supersat( 6,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0006, 1.0023, 1.0069, 1.0173, 1.0412, 1.0982, 1.2484, 1.7865, 3.6641,  &
1.0002, 1.0006, 1.0029, 1.0094, 1.0246, 1.0596, 1.1451, 1.3884, 2.5258,  &
1.0001, 1.0002, 1.0006, 1.0035, 1.0128, 1.0348, 1.0868, 1.2196, 1.6558,  &
1.0000, 1.0001, 1.0003, 1.0006, 1.0040, 1.0171, 1.0488, 1.1266, 1.3438,  &
0.9996, 0.9997, 0.9998, 1.0002, 1.0009, 1.0043, 1.0220, 1.0669, 1.1851,  &
0.9987, 0.9987, 0.9988, 0.9990, 0.9997, 1.0011, 1.0046, 1.0270, 1.0887,  &
0.9965, 0.9966, 0.9966, 0.9968, 0.9972, 0.9982, 1.0007, 1.0071, 1.0314 /
data ((supersat( 6,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0005, 1.0017, 1.0049, 1.0124, 1.0297, 1.0702, 1.1720, 1.4762, 2.7127,  &
1.0002, 1.0005, 1.0021, 1.0067, 1.0175, 1.0423, 1.1014, 1.2564, 1.7928,  &
1.0001, 1.0002, 1.0005, 1.0024, 1.0089, 1.0245, 1.0607, 1.1491, 1.3986,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0027, 1.0118, 1.0342, 1.0874, 1.2237,  &
0.9998, 0.9999, 1.0000, 1.0002, 1.0006, 1.0028, 1.0153, 1.0469, 1.1254,  &
0.9993, 0.9993, 0.9994, 0.9996, 0.9999, 1.0008, 1.0030, 1.0190, 1.0623,  &
0.9979, 0.9979, 0.9979, 0.9980, 0.9983, 0.9990, 1.0005, 1.0043, 1.0223 /
data ((supersat( 6,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0004, 1.0013, 1.0037, 1.0093, 1.0223, 1.0529, 1.1279, 1.3324, 2.0825,  &
1.0001, 1.0004, 1.0015, 1.0049, 1.0129, 1.0314, 1.0750, 1.1845, 1.5067,  &
1.0001, 1.0001, 1.0004, 1.0017, 1.0064, 1.0178, 1.0443, 1.1076, 1.2733,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0018, 1.0083, 1.0246, 1.0628, 1.1566,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0004, 1.0018, 1.0105, 1.0334, 1.0886,  &
0.9996, 0.9996, 0.9996, 0.9998, 1.0000, 1.0005, 1.0019, 1.0129, 1.0442,  &
0.9986, 0.9986, 0.9987, 0.9987, 0.9989, 0.9993, 1.0003, 1.0026, 1.0151 /
data ((supersat( 6,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0028, 1.0073, 1.0176, 1.0419, 1.1008, 1.2541, 1.7326,  &
1.0001, 1.0003, 1.0011, 1.0037, 1.0099, 1.0244, 1.0584, 1.1421, 1.3700,  &
1.0001, 1.0001, 1.0003, 1.0012, 1.0047, 1.0135, 1.0339, 1.0822, 1.2039,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0060, 1.0182, 1.0471, 1.1167,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0013, 1.0073, 1.0244, 1.0654,  &
0.9997, 0.9997, 0.9998, 0.9998, 1.0000, 1.0004, 1.0013, 1.0087, 1.0319,  &
0.9990, 0.9990, 0.9990, 0.9990, 0.9992, 0.9995, 1.0001, 1.0017, 1.0100 /
data ((supersat( 6,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0023, 1.0060, 1.0145, 1.0346, 1.0832, 1.2065, 1.5600,  &
1.0001, 1.0002, 1.0009, 1.0029, 1.0080, 1.0198, 1.0476, 1.1154, 1.2927,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0037, 1.0106, 1.0270, 1.0659, 1.1621,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0009, 1.0045, 1.0141, 1.0370, 1.0919,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0009, 1.0053, 1.0185, 1.0505,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0010, 1.0060, 1.0239,  &
0.9991, 0.9991, 0.9991, 0.9992, 0.9993, 0.9995, 1.0000, 1.0011, 1.0065 /
data ((supersat( 6,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0019, 1.0050, 1.0123, 1.0295, 1.0709, 1.1745, 1.4588,  &
1.0001, 1.0002, 1.0007, 1.0024, 1.0066, 1.0166, 1.0402, 1.0973, 1.2434,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0029, 1.0087, 1.0224, 1.0549, 1.1347,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0035, 1.0113, 1.0302, 1.0755,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0039, 1.0146, 1.0407,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0042, 1.0185,  &
0.9992, 0.9992, 0.9992, 0.9992, 0.9993, 0.9995, 1.0000, 1.0008, 1.0044 /
data ((supersat( 7,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0023, 1.0055, 1.0125, 1.0283, 1.0642, 1.1515, 1.4015, 2.6817, 4.9472,  &
1.0009, 1.0029, 1.0077, 1.0183, 1.0419, 1.0964, 1.2347, 1.6930, 3.9396,  &
1.0003, 1.0010, 1.0038, 1.0109, 1.0268, 1.0626, 1.1476, 1.3815, 2.4659,  &
1.0002, 1.0003, 1.0010, 1.0048, 1.0152, 1.0390, 1.0940, 1.2318, 1.6749,  &
1.0001, 1.0002, 1.0004, 1.0010, 1.0059, 1.0210, 1.0563, 1.1417, 1.3788,  &
0.9999, 0.9999, 1.0001, 1.0005, 1.0013, 1.0070, 1.0278, 1.0794, 1.2147,  &
0.9991, 0.9991, 0.9992, 0.9995, 1.0002, 1.0018, 1.0079, 1.0351, 1.1086 /
data ((supersat( 7,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0038, 1.0087, 1.0194, 1.0438, 1.1016, 1.2534, 1.7957, 3.6925,  &
1.0007, 1.0020, 1.0053, 1.0124, 1.0285, 1.0647, 1.1525, 1.4007, 2.5608,  &
1.0003, 1.0008, 1.0026, 1.0074, 1.0181, 1.0420, 1.0971, 1.2362, 1.6891,  &
1.0001, 1.0003, 1.0008, 1.0033, 1.0104, 1.0263, 1.0625, 1.1483, 1.3834,  &
1.0001, 1.0002, 1.0003, 1.0008, 1.0041, 1.0143, 1.0381, 1.0932, 1.2319,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0008, 1.0047, 1.0193, 1.0540, 1.1390,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0003, 1.0012, 1.0053, 1.0249, 1.0747 /
data ((supersat( 7,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0012, 1.0027, 1.0062, 1.0139, 1.0314, 1.0722, 1.1748, 1.4806, 2.7259,  &
1.0005, 1.0014, 1.0037, 1.0088, 1.0201, 1.0455, 1.1057, 1.2628, 1.8050,  &
1.0002, 1.0006, 1.0019, 1.0051, 1.0126, 1.0292, 1.0670, 1.1583, 1.4145,  &
1.0001, 1.0002, 1.0006, 1.0023, 1.0071, 1.0182, 1.0429, 1.1001, 1.2446,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0027, 1.0097, 1.0261, 1.0633, 1.1520,  &
1.0000, 1.0001, 1.0002, 1.0003, 1.0006, 1.0031, 1.0131, 1.0370, 1.0932,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0008, 1.0033, 1.0170, 1.0513 /
data ((supersat( 7,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0009, 1.0020, 1.0046, 1.0104, 1.0235, 1.0543, 1.1296, 1.3349, 2.0878,  &
1.0004, 1.0011, 1.0027, 1.0065, 1.0147, 1.0336, 1.0777, 1.1882, 1.5129,  &
1.0002, 1.0005, 1.0014, 1.0037, 1.0091, 1.0211, 1.0485, 1.1133, 1.2821,  &
1.0001, 1.0002, 1.0005, 1.0016, 1.0050, 1.0128, 1.0306, 1.0710, 1.1690,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0018, 1.0067, 1.0182, 1.0444, 1.1052,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0019, 1.0088, 1.0256, 1.0645,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0020, 1.0113, 1.0353 /
data ((supersat( 7,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0016, 1.0036, 1.0081, 1.0185, 1.0429, 1.1020, 1.2557, 1.7352,  &
1.0004, 1.0009, 1.0020, 1.0050, 1.0113, 1.0260, 1.0603, 1.1446, 1.3736,  &
1.0002, 1.0004, 1.0010, 1.0028, 1.0068, 1.0159, 1.0369, 1.0861, 1.2094,  &
1.0001, 1.0002, 1.0004, 1.0012, 1.0036, 1.0094, 1.0227, 1.0529, 1.1248,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0047, 1.0131, 1.0324, 1.0767,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0060, 1.0182, 1.0463,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0013, 1.0074, 1.0247 /
data ((supersat( 7,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0013, 1.0029, 1.0066, 1.0152, 1.0354, 1.0841, 1.2076, 1.5616,  &
1.0003, 1.0007, 1.0016, 1.0039, 1.0091, 1.0210, 1.0491, 1.1172, 1.2951,  &
1.0001, 1.0003, 1.0008, 1.0021, 1.0053, 1.0126, 1.0294, 1.0688, 1.1659,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0027, 1.0072, 1.0176, 1.0414, 1.0977,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0009, 1.0034, 1.0098, 1.0247, 1.0589,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0042, 1.0133, 1.0346,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0003, 1.0009, 1.0049, 1.0178 /
data ((supersat( 7,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0010, 1.0023, 1.0056, 1.0129, 1.0301, 1.0716, 1.1754, 1.4600,  &
1.0002, 1.0005, 1.0014, 1.0032, 1.0075, 1.0176, 1.0413, 1.0986, 1.2452,  &
1.0001, 1.0003, 1.0007, 1.0017, 1.0043, 1.0103, 1.0243, 1.0572, 1.1375,  &
1.0001, 1.0001, 1.0003, 1.0007, 1.0022, 1.0058, 1.0142, 1.0337, 1.0799,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0007, 1.0026, 1.0077, 1.0196, 1.0473,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0003, 1.0007, 1.0030, 1.0102, 1.0271,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0007, 1.0034, 1.0133 /
data ((supersat( 7,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0018, 1.0049, 1.0118, 1.0274, 1.0631, 1.1499, 1.3991, 2.6747, 4.9352,  &
1.0006, 1.0022, 1.0066, 1.0171, 1.0403, 1.0942, 1.2313, 1.6863, 3.9162,  &
1.0002, 1.0006, 1.0026, 1.0092, 1.0246, 1.0595, 1.1430, 1.3733, 2.4436,  &
1.0001, 1.0003, 1.0006, 1.0030, 1.0125, 1.0351, 1.0879, 1.2216, 1.6529,  &
1.0000, 1.0001, 1.0003, 1.0008, 1.0032, 1.0164, 1.0490, 1.1293, 1.3546,  &
0.9994, 0.9995, 0.9997, 1.0001, 1.0010, 1.0034, 1.0207, 1.0663, 1.1892,  &
0.9980, 0.9981, 0.9982, 0.9984, 0.9991, 1.0008, 1.0049, 1.0246, 1.0859 /
data ((supersat( 7,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0013, 1.0034, 1.0082, 1.0189, 1.0432, 1.1008, 1.2522, 1.7935, 3.6858,  &
1.0005, 1.0016, 1.0047, 1.0116, 1.0275, 1.0634, 1.1507, 1.3978, 2.5525,  &
1.0002, 1.0005, 1.0019, 1.0063, 1.0167, 1.0402, 1.0945, 1.2321, 1.6811,  &
1.0001, 1.0002, 1.0005, 1.0021, 1.0085, 1.0238, 1.0589, 1.1429, 1.3737,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0022, 1.0113, 1.0336, 1.0863, 1.2199,  &
0.9998, 0.9999, 1.0000, 1.0002, 1.0007, 1.0023, 1.0144, 1.0461, 1.1251,  &
0.9991, 0.9991, 0.9992, 0.9994, 0.9998, 1.0007, 1.0030, 1.0176, 1.0607 /
data ((supersat( 7,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0010, 1.0024, 1.0058, 1.0135, 1.0309, 1.0717, 1.1741, 1.4796, 2.7229,  &
1.0004, 1.0012, 1.0032, 1.0082, 1.0194, 1.0447, 1.1047, 1.2613, 1.8021,  &
1.0002, 1.0004, 1.0013, 1.0044, 1.0117, 1.0280, 1.0655, 1.1561, 1.4107,  &
1.0001, 1.0002, 1.0004, 1.0015, 1.0058, 1.0165, 1.0407, 1.0970, 1.2395,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0015, 1.0076, 1.0231, 1.0590, 1.1453,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0005, 1.0015, 1.0097, 1.0318, 1.0848,  &
0.9996, 0.9996, 0.9996, 0.9997, 1.0000, 1.0006, 1.0018, 1.0118, 1.0422 /
data ((supersat( 7,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0006, 1.0018, 1.0044, 1.0101, 1.0232, 1.0540, 1.1292, 1.3343, 2.0865,  &
1.0003, 1.0009, 1.0023, 1.0060, 1.0142, 1.0330, 1.0771, 1.1873, 1.5115,  &
1.0001, 1.0003, 1.0010, 1.0031, 1.0084, 1.0203, 1.0475, 1.1120, 1.2800,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0041, 1.0116, 1.0290, 1.0690, 1.1660,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0010, 1.0051, 1.0160, 1.0415, 1.1011,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0011, 1.0063, 1.0220, 1.0590,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0004, 1.0012, 1.0075, 1.0291 /
data ((supersat( 7,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0015, 1.0034, 1.0079, 1.0183, 1.0427, 1.1017, 1.2553, 1.7346,  &
1.0002, 1.0007, 1.0018, 1.0046, 1.0110, 1.0256, 1.0599, 1.1440, 1.3728,  &
1.0001, 1.0002, 1.0007, 1.0023, 1.0062, 1.0153, 1.0361, 1.0851, 1.2082,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0029, 1.0085, 1.0215, 1.0515, 1.1229,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0007, 1.0035, 1.0115, 1.0303, 1.0739,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0041, 1.0155, 1.0424,  &
0.9998, 0.9999, 0.9999, 0.9999, 1.0000, 1.0003, 1.0008, 1.0046, 1.0202 /
data ((supersat( 7,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0011, 1.0027, 1.0064, 1.0150, 1.0352, 1.0839, 1.2073, 1.5613,  &
1.0002, 1.0005, 1.0015, 1.0037, 1.0088, 1.0207, 1.0487, 1.1168, 1.2946,  &
1.0001, 1.0002, 1.0006, 1.0018, 1.0048, 1.0121, 1.0288, 1.0681, 1.1650,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0022, 1.0065, 1.0167, 1.0403, 1.0963,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0025, 1.0086, 1.0231, 1.0568,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0027, 1.0112, 1.0318,  &
0.9999, 0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0029, 1.0143 /
data ((supersat( 7,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0022, 1.0054, 1.0127, 1.0300, 1.0714, 1.1752, 1.4598,  &
1.0002, 1.0004, 1.0012, 1.0030, 1.0073, 1.0174, 1.0410, 1.0983, 1.2448,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0039, 1.0099, 1.0238, 1.0566, 1.1369,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0017, 1.0051, 1.0135, 1.0329, 1.0789,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0019, 1.0066, 1.0183, 1.0456,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0019, 1.0084, 1.0248,  &
0.9999, 0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0019, 1.0105 /
data ((supersat( 7,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0013, 1.0041, 1.0110, 1.0263, 1.0617, 1.1480, 1.3959, 2.6654, 4.9197,  &
1.0003, 1.0014, 1.0055, 1.0155, 1.0383, 1.0914, 1.2269, 1.6776, 3.8853,  &
1.0002, 1.0004, 1.0015, 1.0073, 1.0219, 1.0557, 1.1371, 1.3627, 2.4145,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0093, 1.0303, 1.0804, 1.2086, 1.6246,  &
0.9997, 0.9998, 1.0000, 1.0005, 1.0016, 1.0115, 1.0406, 1.1145, 1.3248,  &
0.9987, 0.9987, 0.9989, 0.9993, 1.0003, 1.0026, 1.0135, 1.0521, 1.1598,  &
0.9965, 0.9965, 0.9966, 0.9969, 0.9976, 0.9992, 1.0033, 1.0151, 1.0634 /
data ((supersat( 7,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0009, 1.0030, 1.0076, 1.0182, 1.0423, 1.0997, 1.2506, 1.7906, 3.6770,  &
1.0003, 1.0011, 1.0039, 1.0106, 1.0262, 1.0618, 1.1484, 1.3939, 2.5416,  &
1.0001, 1.0003, 1.0011, 1.0050, 1.0150, 1.0379, 1.0913, 1.2269, 1.6707,  &
1.0001, 1.0002, 1.0003, 1.0011, 1.0064, 1.0208, 1.0546, 1.1360, 1.3611,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0012, 1.0079, 1.0283, 1.0777, 1.2050,  &
0.9994, 0.9995, 0.9996, 0.9998, 1.0004, 1.0016, 1.0094, 1.0371, 1.1086,  &
0.9981, 0.9981, 0.9982, 0.9984, 0.9988, 0.9998, 1.0022, 1.0107, 1.0461 /
data ((supersat( 7,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0021, 1.0054, 1.0131, 1.0304, 1.0711, 1.1732, 1.4782, 2.7187,  &
1.0002, 1.0008, 1.0028, 1.0076, 1.0186, 1.0437, 1.1033, 1.2593, 1.7983,  &
1.0001, 1.0002, 1.0008, 1.0035, 1.0105, 1.0265, 1.0635, 1.1532, 1.4057,  &
1.0001, 1.0001, 1.0002, 1.0008, 1.0044, 1.0145, 1.0379, 1.0929, 1.2329,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0008, 1.0053, 1.0196, 1.0537, 1.1368,  &
0.9997, 0.9998, 0.9998, 1.0000, 1.0003, 1.0011, 1.0061, 1.0258, 1.0748,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9994, 1.0000, 1.0014, 1.0068, 1.0325 /
data ((supersat( 7,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0005, 1.0016, 1.0041, 1.0098, 1.0229, 1.0535, 1.1286, 1.3335, 2.0849,  &
1.0002, 1.0006, 1.0020, 1.0055, 1.0137, 1.0323, 1.0762, 1.1862, 1.5096,  &
1.0001, 1.0002, 1.0006, 1.0025, 1.0075, 1.0192, 1.0462, 1.1102, 1.2772,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0030, 1.0102, 1.0271, 1.0664, 1.1621,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0034, 1.0136, 1.0380, 1.0958,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0038, 1.0178, 1.0524,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9997, 1.0001, 1.0009, 1.0040, 1.0224 /
data ((supersat( 7,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0004, 1.0012, 1.0032, 1.0077, 1.0180, 1.0424, 1.1014, 1.2549, 1.7338,  &
1.0002, 1.0005, 1.0015, 1.0042, 1.0105, 1.0251, 1.0593, 1.1433, 1.3716,  &
1.0001, 1.0002, 1.0005, 1.0018, 1.0056, 1.0145, 1.0352, 1.0839, 1.2064,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0021, 1.0074, 1.0201, 1.0497, 1.1204,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0023, 1.0097, 1.0278, 1.0703,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0002, 1.0005, 1.0024, 1.0124, 1.0378,  &
0.9996, 0.9996, 0.9996, 0.9996, 0.9998, 1.0000, 1.0006, 1.0024, 1.0153 /
data ((supersat( 7,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0025, 1.0062, 1.0148, 1.0350, 1.0836, 1.2070, 1.5608,  &
1.0001, 1.0004, 1.0012, 1.0033, 1.0084, 1.0203, 1.0483, 1.1162, 1.2938,  &
1.0001, 1.0001, 1.0004, 1.0014, 1.0044, 1.0115, 1.0281, 1.0672, 1.1638,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0015, 1.0056, 1.0156, 1.0390, 1.0945,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0004, 1.0016, 1.0071, 1.0211, 1.0542,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0001, 1.0004, 1.0016, 1.0088, 1.0283,  &
0.9996, 0.9996, 0.9997, 0.9997, 0.9998, 1.0000, 1.0004, 1.0017, 1.0106 /
data ((supersat( 7,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0021, 1.0052, 1.0125, 1.0298, 1.0712, 1.1749, 1.4594,  &
1.0001, 1.0003, 1.0009, 1.0027, 1.0070, 1.0170, 1.0407, 1.0979, 1.2443,  &
1.0001, 1.0001, 1.0003, 1.0011, 1.0035, 1.0094, 1.0232, 1.0560, 1.1360,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0012, 1.0044, 1.0126, 1.0318, 1.0775,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0012, 1.0054, 1.0167, 1.0436,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0001, 1.0003, 1.0012, 1.0065, 1.0220,  &
0.9997, 0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0003, 1.0012, 1.0075 /
data ((supersat( 7,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0008, 1.0033, 1.0099, 1.0250, 1.0600, 1.1455, 1.3917, 2.6530, 4.8988,  &
1.0002, 1.0008, 1.0042, 1.0137, 1.0359, 1.0879, 1.2213, 1.6663, 3.8447,  &
1.0001, 1.0003, 1.0008, 1.0051, 1.0188, 1.0510, 1.1297, 1.3492, 2.3768,  &
0.9999, 1.0000, 1.0003, 1.0010, 1.0060, 1.0249, 1.0714, 1.1926, 1.5893,  &
0.9991, 0.9992, 0.9995, 1.0001, 1.0014, 1.0068, 1.0317, 1.0975, 1.2892,  &
0.9974, 0.9975, 0.9977, 0.9981, 0.9991, 1.0015, 1.0073, 1.0382, 1.1286,  &
0.9947, 0.9947, 0.9948, 0.9950, 0.9956, 0.9971, 1.0009, 1.0115, 1.0437 /
data ((supersat( 7,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0006, 1.0024, 1.0069, 1.0173, 1.0413, 1.0983, 1.2486, 1.7869, 3.6653,  &
1.0002, 1.0006, 1.0030, 1.0095, 1.0247, 1.0598, 1.1454, 1.3889, 2.5273,  &
1.0001, 1.0002, 1.0006, 1.0036, 1.0130, 1.0351, 1.0872, 1.2203, 1.6572,  &
1.0000, 1.0001, 1.0003, 1.0007, 1.0042, 1.0174, 1.0493, 1.1275, 1.3453,  &
0.9997, 0.9997, 0.9999, 1.0002, 1.0009, 1.0046, 1.0225, 1.0678, 1.1867,  &
0.9987, 0.9988, 0.9989, 0.9991, 0.9997, 1.0011, 1.0049, 1.0278, 1.0903,  &
0.9967, 0.9967, 0.9967, 0.9969, 0.9973, 0.9983, 1.0008, 1.0072, 1.0325 /
data ((supersat( 7,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0005, 1.0018, 1.0049, 1.0125, 1.0297, 1.0703, 1.1721, 1.4764, 2.7133,  &
1.0002, 1.0005, 1.0021, 1.0068, 1.0176, 1.0424, 1.1016, 1.2567, 1.7933,  &
1.0001, 1.0002, 1.0005, 1.0025, 1.0091, 1.0247, 1.0610, 1.1495, 1.3993,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0028, 1.0121, 1.0345, 1.0878, 1.2245,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0030, 1.0157, 1.0475, 1.1264,  &
0.9993, 0.9994, 0.9994, 0.9996, 1.0000, 1.0008, 1.0031, 1.0195, 1.0634,  &
0.9980, 0.9980, 0.9980, 0.9981, 0.9984, 0.9991, 1.0006, 1.0044, 1.0231 /
data ((supersat( 7,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0004, 1.0013, 1.0037, 1.0093, 1.0224, 1.0530, 1.1279, 1.3325, 2.0827,  &
1.0001, 1.0004, 1.0016, 1.0049, 1.0129, 1.0315, 1.0751, 1.1846, 1.5070,  &
1.0001, 1.0001, 1.0004, 1.0018, 1.0065, 1.0179, 1.0445, 1.1079, 1.2737,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0019, 1.0085, 1.0248, 1.0631, 1.1571,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0004, 1.0019, 1.0108, 1.0338, 1.0892,  &
0.9996, 0.9996, 0.9997, 0.9998, 1.0000, 1.0005, 1.0020, 1.0133, 1.0449,  &
0.9987, 0.9987, 0.9987, 0.9988, 0.9990, 0.9994, 1.0004, 1.0027, 1.0157 /
data ((supersat( 7,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0010, 1.0028, 1.0073, 1.0177, 1.0420, 1.1009, 1.2542, 1.7327,  &
1.0001, 1.0003, 1.0012, 1.0037, 1.0100, 1.0244, 1.0585, 1.1422, 1.3701,  &
1.0001, 1.0001, 1.0003, 1.0013, 1.0048, 1.0136, 1.0340, 1.0824, 1.2042,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0061, 1.0184, 1.0474, 1.1171,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0013, 1.0075, 1.0247, 1.0658,  &
0.9997, 0.9997, 0.9998, 0.9998, 1.0000, 1.0004, 1.0014, 1.0090, 1.0324,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9992, 0.9995, 1.0002, 1.0017, 1.0104 /
data ((supersat( 7,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0023, 1.0060, 1.0145, 1.0347, 1.0832, 1.2065, 1.5601,  &
1.0001, 1.0002, 1.0009, 1.0029, 1.0080, 1.0198, 1.0477, 1.1155, 1.2928,  &
1.0001, 1.0001, 1.0002, 1.0010, 1.0037, 1.0107, 1.0271, 1.0661, 1.1623,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0010, 1.0045, 1.0142, 1.0372, 1.0921,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0010, 1.0054, 1.0188, 1.0509,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0010, 1.0062, 1.0243,  &
0.9992, 0.9992, 0.9992, 0.9992, 0.9993, 0.9996, 1.0001, 1.0012, 1.0068 /
data ((supersat( 7,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0019, 1.0050, 1.0123, 1.0295, 1.0709, 1.1746, 1.4589,  &
1.0001, 1.0002, 1.0007, 1.0024, 1.0066, 1.0166, 1.0402, 1.0973, 1.2435,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0030, 1.0087, 1.0225, 1.0550, 1.1348,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0035, 1.0114, 1.0304, 1.0757,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0040, 1.0148, 1.0410,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0044, 1.0188,  &
0.9992, 0.9992, 0.9993, 0.9993, 0.9994, 0.9996, 1.0000, 1.0009, 1.0046 /
data ((supersat( 7,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0006, 1.0028, 1.0092, 1.0241, 1.0588, 1.1438, 1.3887, 2.6440, 4.8835,  &
1.0002, 1.0006, 1.0034, 1.0125, 1.0342, 1.0854, 1.2173, 1.6582, 3.8154,  &
1.0001, 1.0002, 1.0006, 1.0038, 1.0167, 1.0479, 1.1246, 1.3397, 2.3499,  &
0.9997, 0.9998, 1.0002, 1.0009, 1.0042, 1.0215, 1.0656, 1.1818, 1.5648,  &
0.9987, 0.9988, 0.9990, 0.9996, 1.0010, 1.0044, 1.0264, 1.0869, 1.2661,  &
0.9965, 0.9966, 0.9967, 0.9971, 0.9981, 1.0006, 1.0068, 1.0307, 1.1105,  &
0.9937, 0.9937, 0.9938, 0.9940, 0.9945, 0.9959, 0.9994, 1.0090, 1.0341 /
data ((supersat( 7,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0005, 1.0020, 1.0065, 1.0168, 1.0406, 1.0974, 1.2471, 1.7841, 3.6567,  &
1.0002, 1.0005, 1.0024, 1.0087, 1.0237, 1.0584, 1.1433, 1.3853, 2.5168,  &
1.0001, 1.0002, 1.0005, 1.0027, 1.0116, 1.0332, 1.0843, 1.2156, 1.6475,  &
0.9999, 1.0000, 1.0002, 1.0006, 1.0029, 1.0151, 1.0457, 1.1216, 1.3342,  &
0.9994, 0.9995, 0.9996, 1.0000, 1.0008, 1.0030, 1.0189, 1.0614, 1.1746,  &
0.9981, 0.9981, 0.9982, 0.9985, 0.9991, 1.0006, 1.0043, 1.0225, 1.0792,  &
0.9957, 0.9957, 0.9957, 0.9959, 0.9963, 0.9973, 0.9997, 1.0059, 1.0255 /
data ((supersat( 7,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0004, 1.0015, 1.0046, 1.0121, 1.0292, 1.0697, 1.1713, 1.4750, 2.7093,  &
1.0001, 1.0004, 1.0017, 1.0062, 1.0168, 1.0415, 1.1004, 1.2548, 1.7897,  &
1.0001, 1.0001, 1.0004, 1.0019, 1.0081, 1.0234, 1.0592, 1.1468, 1.3946,  &
1.0000, 1.0000, 1.0002, 1.0004, 1.0020, 1.0105, 1.0323, 1.0843, 1.2186,  &
0.9997, 0.9998, 0.9999, 1.0001, 1.0005, 1.0020, 1.0132, 1.0434, 1.1193,  &
0.9990, 0.9990, 0.9991, 0.9992, 0.9996, 1.0005, 1.0026, 1.0158, 1.0563,  &
0.9972, 0.9972, 0.9972, 0.9973, 0.9976, 0.9983, 0.9999, 1.0037, 1.0180 /
data ((supersat( 7,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0011, 1.0034, 1.0090, 1.0220, 1.0526, 1.1274, 1.3318, 2.0810,  &
1.0001, 1.0003, 1.0013, 1.0045, 1.0124, 1.0308, 1.0743, 1.1835, 1.5051,  &
1.0001, 1.0001, 1.0003, 1.0013, 1.0058, 1.0170, 1.0433, 1.1062, 1.2711,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0014, 1.0073, 1.0232, 1.0608, 1.1536,  &
0.9998, 0.9999, 0.9999, 1.0001, 1.0004, 1.0014, 1.0090, 1.0310, 1.0847,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9998, 1.0004, 1.0017, 1.0107, 1.0401,  &
0.9981, 0.9981, 0.9981, 0.9982, 0.9984, 0.9988, 0.9998, 1.0022, 1.0120 /
data ((supersat( 7,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0026, 1.0071, 1.0174, 1.0417, 1.1005, 1.2537, 1.7319,  &
1.0001, 1.0002, 1.0010, 1.0034, 1.0096, 1.0240, 1.0580, 1.1415, 1.3690,  &
1.0000, 1.0001, 1.0002, 1.0010, 1.0043, 1.0129, 1.0331, 1.0813, 1.2025,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0010, 1.0052, 1.0172, 1.0458, 1.1147,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0010, 1.0062, 1.0227, 1.0627,  &
0.9995, 0.9996, 0.9996, 0.9997, 0.9998, 1.0002, 1.0011, 1.0070, 1.0290,  &
0.9985, 0.9985, 0.9986, 0.9986, 0.9987, 0.9991, 0.9998, 1.0014, 1.0077 /
data ((supersat( 7,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0021, 1.0058, 1.0143, 1.0344, 1.0830, 1.2062, 1.5595,  &
1.0001, 1.0002, 1.0007, 1.0027, 1.0077, 1.0194, 1.0473, 1.1150, 1.2920,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0033, 1.0101, 1.0265, 1.0652, 1.1611,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0039, 1.0133, 1.0360, 1.0904,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0002, 1.0008, 1.0044, 1.0172, 1.0486,  &
0.9996, 0.9996, 0.9997, 0.9997, 0.9999, 1.0002, 1.0008, 1.0047, 1.0216,  &
0.9987, 0.9987, 0.9988, 0.9988, 0.9989, 0.9992, 0.9997, 1.0009, 1.0049 /
data ((supersat( 7,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0018, 1.0049, 1.0121, 1.0293, 1.0707, 1.1743, 1.4585,  &
1.0001, 1.0002, 1.0006, 1.0022, 1.0064, 1.0163, 1.0398, 1.0969, 1.2429,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0026, 1.0083, 1.0219, 1.0544, 1.1339,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0030, 1.0106, 1.0294, 1.0743,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0002, 1.0006, 1.0032, 1.0135, 1.0391,  &
0.9997, 0.9997, 0.9997, 0.9997, 0.9999, 1.0001, 1.0006, 1.0033, 1.0167,  &
0.9989, 0.9989, 0.9989, 0.9989, 0.9990, 0.9992, 0.9996, 1.0006, 1.0034 /
data ((supersat( 7,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0005, 1.0024, 1.0087, 1.0234, 1.0578, 1.1423, 1.3862, 2.6366, 4.8711,  &
1.0002, 1.0005, 1.0028, 1.0116, 1.0329, 1.0835, 1.2140, 1.6516, 3.7916,  &
1.0000, 1.0002, 1.0006, 1.0030, 1.0151, 1.0454, 1.1205, 1.3321, 2.3282,  &
0.9995, 0.9997, 1.0000, 1.0008, 1.0031, 1.0190, 1.0612, 1.1735, 1.5457,  &
0.9982, 0.9983, 0.9986, 0.9992, 1.0007, 1.0042, 1.0228, 1.0792, 1.2488,  &
0.9958, 0.9958, 0.9960, 0.9964, 0.9974, 0.9998, 1.0059, 1.0258, 1.0981,  &
0.9930, 0.9930, 0.9931, 0.9933, 0.9938, 0.9950, 0.9982, 1.0072, 1.0353 /
data ((supersat( 7,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0004, 1.0018, 1.0061, 1.0163, 1.0400, 1.0966, 1.2459, 1.7819, 3.6497,  &
1.0001, 1.0004, 1.0020, 1.0081, 1.0228, 1.0573, 1.1417, 1.3824, 2.5083,  &
1.0001, 1.0002, 1.0004, 1.0021, 1.0106, 1.0317, 1.0820, 1.2118, 1.6397,  &
0.9998, 0.9999, 1.0001, 1.0006, 1.0022, 1.0135, 1.0430, 1.1170, 1.3254,  &
0.9992, 0.9992, 0.9994, 0.9998, 1.0006, 1.0024, 1.0164, 1.0566, 1.1653,  &
0.9976, 0.9976, 0.9977, 0.9980, 0.9986, 1.0001, 1.0038, 1.0190, 1.0713,  &
0.9949, 0.9949, 0.9950, 0.9951, 0.9955, 0.9964, 0.9988, 1.0048, 1.0210 /
data ((supersat( 7,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0003, 1.0013, 1.0044, 1.0118, 1.0289, 1.0692, 1.1706, 1.4739, 2.7061,  &
1.0001, 1.0003, 1.0014, 1.0057, 1.0163, 1.0408, 1.0994, 1.2532, 1.7867,  &
1.0001, 1.0001, 1.0003, 1.0015, 1.0074, 1.0224, 1.0578, 1.1447, 1.3909,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0015, 1.0094, 1.0305, 1.0816, 1.2139,  &
0.9996, 0.9996, 0.9997, 1.0000, 1.0005, 1.0017, 1.0114, 1.0403, 1.1139,  &
0.9986, 0.9986, 0.9987, 0.9989, 0.9993, 1.0002, 1.0024, 1.0133, 1.0511,  &
0.9965, 0.9965, 0.9966, 0.9967, 0.9969, 0.9976, 0.9992, 1.0031, 1.0147 /
data ((supersat( 7,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0010, 1.0032, 1.0088, 1.0218, 1.0523, 1.1270, 1.3312, 2.0797,  &
1.0001, 1.0002, 1.0011, 1.0042, 1.0120, 1.0304, 1.0737, 1.1826, 1.5035,  &
1.0001, 1.0001, 1.0002, 1.0011, 1.0053, 1.0163, 1.0424, 1.1049, 1.2689,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0011, 1.0065, 1.0220, 1.0590, 1.1507,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0012, 1.0077, 1.0289, 1.0812,  &
0.9991, 0.9991, 0.9992, 0.9993, 0.9996, 1.0002, 1.0015, 1.0088, 1.0366,  &
0.9976, 0.9976, 0.9976, 0.9977, 0.9978, 0.9983, 0.9994, 1.0018, 1.0096 /
data ((supersat( 7,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0025, 1.0069, 1.0172, 1.0415, 1.1003, 1.2533, 1.7312,  &
1.0001, 1.0002, 1.0008, 1.0032, 1.0093, 1.0236, 1.0575, 1.1409, 1.3681,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0039, 1.0123, 1.0325, 1.0803, 1.2012,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0046, 1.0163, 1.0445, 1.1128,  &
0.9998, 0.9999, 0.9999, 1.0000, 1.0002, 1.0008, 1.0052, 1.0211, 1.0603,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9997, 1.0001, 1.0010, 1.0057, 1.0265,  &
0.9981, 0.9981, 0.9981, 0.9982, 0.9983, 0.9986, 0.9994, 1.0011, 1.0060 /
data ((supersat( 7,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0020, 1.0056, 1.0141, 1.0343, 1.0828, 1.2059, 1.5591,  &
1.0001, 1.0002, 1.0006, 1.0025, 1.0074, 1.0191, 1.0469, 1.1145, 1.2914,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0030, 1.0097, 1.0259, 1.0645, 1.1601,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0034, 1.0126, 1.0350, 1.0890,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0036, 1.0160, 1.0468,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0007, 1.0037, 1.0197,  &
0.9984, 0.9984, 0.9984, 0.9984, 0.9985, 0.9988, 0.9994, 1.0006, 1.0039 /
data ((supersat( 7,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0017, 1.0047, 1.0120, 1.0292, 1.0705, 1.1741, 1.4582,  &
1.0001, 1.0001, 1.0005, 1.0020, 1.0061, 1.0160, 1.0396, 1.0966, 1.2424,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0023, 1.0079, 1.0215, 1.0538, 1.1332,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0005, 1.0026, 1.0100, 1.0286, 1.0733,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0026, 1.0125, 1.0377,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0006, 1.0027, 1.0151,  &
0.9985, 0.9985, 0.9985, 0.9985, 0.9986, 0.9988, 0.9993, 1.0004, 1.0028 /
data ((supersat( 7,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0004, 1.0021, 1.0082, 1.0228, 1.0570, 1.1411, 1.3841, 2.6302, 4.8603,  &
1.0002, 1.0004, 1.0023, 1.0108, 1.0318, 1.0818, 1.2113, 1.6460, 3.7712,  &
0.9999, 1.0001, 1.0006, 1.0024, 1.0139, 1.0435, 1.1172, 1.3257, 2.3098,  &
0.9993, 0.9995, 0.9999, 1.0007, 1.0025, 1.0171, 1.0576, 1.1667, 1.5299,  &
0.9978, 0.9979, 0.9982, 0.9988, 1.0003, 1.0039, 1.0201, 1.0733, 1.2350,  &
0.9952, 0.9953, 0.9954, 0.9958, 0.9968, 0.9991, 1.0051, 1.0223, 1.0889,  &
0.9926, 0.9926, 0.9926, 0.9928, 0.9933, 0.9944, 0.9974, 1.0058, 1.0320 /
data ((supersat( 7,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0003, 1.0016, 1.0058, 1.0159, 1.0395, 1.0959, 1.2449, 1.7799, 3.6436,  &
1.0001, 1.0003, 1.0017, 1.0076, 1.0221, 1.0563, 1.1402, 1.3799, 2.5009,  &
1.0000, 1.0001, 1.0004, 1.0017, 1.0097, 1.0304, 1.0801, 1.2086, 1.6331,  &
0.9997, 0.9998, 1.0000, 1.0005, 1.0018, 1.0122, 1.0408, 1.1132, 1.3181,  &
0.9989, 0.9990, 0.9992, 0.9996, 1.0004, 1.0025, 1.0145, 1.0529, 1.1578,  &
0.9971, 0.9972, 0.9972, 0.9975, 0.9982, 0.9997, 1.0034, 1.0164, 1.0653,  &
0.9943, 0.9944, 0.9944, 0.9945, 0.9949, 0.9958, 0.9981, 1.0039, 1.0179 /
data ((supersat( 7,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0042, 1.0115, 1.0285, 1.0688, 1.1701, 1.4730, 2.7032,  &
1.0001, 1.0003, 1.0012, 1.0054, 1.0158, 1.0402, 1.0986, 1.2519, 1.7841,  &
1.0000, 1.0001, 1.0003, 1.0013, 1.0068, 1.0216, 1.0566, 1.1429, 1.3877,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0013, 1.0084, 1.0290, 1.0793, 1.2099,  &
0.9995, 0.9995, 0.9996, 0.9998, 1.0004, 1.0016, 1.0100, 1.0378, 1.1094,  &
0.9983, 0.9983, 0.9984, 0.9986, 0.9990, 0.9999, 1.0022, 1.0114, 1.0472,  &
0.9960, 0.9960, 0.9960, 0.9961, 0.9964, 0.9970, 0.9986, 1.0025, 1.0124 /
data ((supersat( 7,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0031, 1.0086, 1.0216, 1.0520, 1.1267, 1.3306, 2.0785,  &
1.0001, 1.0002, 1.0009, 1.0039, 1.0117, 1.0299, 1.0731, 1.1818, 1.5022,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0048, 1.0158, 1.0416, 1.1038, 1.2671,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0009, 1.0058, 1.0210, 1.0575, 1.1483,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0003, 1.0010, 1.0067, 1.0272, 1.0784,  &
0.9989, 0.9989, 0.9990, 0.9991, 0.9994, 1.0000, 1.0014, 1.0074, 1.0338,  &
0.9971, 0.9971, 0.9971, 0.9972, 0.9974, 0.9978, 0.9989, 1.0014, 1.0079 /
data ((supersat( 7,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0024, 1.0068, 1.0170, 1.0413, 1.1000, 1.2530, 1.7307,  &
1.0001, 1.0002, 1.0007, 1.0030, 1.0090, 1.0233, 1.0571, 1.1404, 1.3672,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0035, 1.0119, 1.0319, 1.0795, 1.2000,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0041, 1.0156, 1.0434, 1.1112,  &
0.9998, 0.9998, 0.9998, 1.0000, 1.0002, 1.0007, 1.0045, 1.0199, 1.0583,  &
0.9992, 0.9992, 0.9992, 0.9993, 0.9995, 1.0000, 1.0009, 1.0047, 1.0245,  &
0.9977, 0.9977, 0.9977, 0.9978, 0.9979, 0.9982, 0.9990, 1.0007, 1.0050 /
data ((supersat( 7,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0019, 1.0055, 1.0140, 1.0341, 1.0826, 1.2057, 1.5587,  &
1.0001, 1.0001, 1.0005, 1.0023, 1.0072, 1.0189, 1.0466, 1.1141, 1.2908,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0027, 1.0093, 1.0255, 1.0640, 1.1593,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0030, 1.0120, 1.0342, 1.0879,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0006, 1.0031, 1.0150, 1.0453,  &
0.9993, 0.9993, 0.9993, 0.9994, 0.9996, 0.9999, 1.0006, 1.0032, 1.0182,  &
0.9980, 0.9980, 0.9980, 0.9981, 0.9982, 0.9984, 0.9990, 1.0004, 1.0035 /
data ((supersat( 7,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0016, 1.0046, 1.0119, 1.0290, 1.0704, 1.1739, 1.4579,  &
1.0001, 1.0001, 1.0004, 1.0019, 1.0060, 1.0158, 1.0393, 1.0963, 1.2420,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0021, 1.0076, 1.0211, 1.0533, 1.1325,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0004, 1.0022, 1.0095, 1.0279, 1.0723,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0001, 1.0005, 1.0023, 1.0117, 1.0365,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9996, 0.9999, 1.0005, 1.0023, 1.0139,  &
0.9982, 0.9982, 0.9982, 0.9982, 0.9983, 0.9985, 0.9990, 1.0001, 1.0026 /
data ((supersat( 8,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0047, 1.0116, 1.0272, 1.0629, 1.1496, 1.3985, 2.6729, 4.9320,  &
1.0005, 1.0020, 1.0064, 1.0168, 1.0399, 1.0937, 1.2304, 1.6847, 3.9100,  &
1.0002, 1.0005, 1.0023, 1.0088, 1.0240, 1.0587, 1.1418, 1.3712, 2.4379,  &
1.0001, 1.0003, 1.0005, 1.0026, 1.0118, 1.0340, 1.0862, 1.2188, 1.6470,  &
0.9999, 1.0000, 1.0002, 1.0007, 1.0027, 1.0152, 1.0470, 1.1258, 1.3479,  &
0.9993, 0.9993, 0.9995, 0.9999, 1.0008, 1.0029, 1.0188, 1.0626, 1.1818,  &
0.9977, 0.9977, 0.9978, 0.9981, 0.9988, 1.0005, 1.0046, 1.0218, 1.0795 /
data ((supersat( 8,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0012, 1.0033, 1.0081, 1.0187, 1.0430, 1.1006, 1.2519, 1.7930, 3.6841,  &
1.0004, 1.0015, 1.0045, 1.0114, 1.0272, 1.0631, 1.1503, 1.3971, 2.5505,  &
1.0002, 1.0004, 1.0017, 1.0060, 1.0163, 1.0397, 1.0939, 1.2311, 1.6791,  &
1.0001, 1.0002, 1.0004, 1.0018, 1.0080, 1.0232, 1.0580, 1.1415, 1.3712,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0019, 1.0105, 1.0324, 1.0844, 1.2167,  &
0.9997, 0.9998, 0.9999, 1.0001, 1.0006, 1.0020, 1.0132, 1.0439, 1.1212,  &
0.9989, 0.9989, 0.9990, 0.9992, 0.9996, 1.0005, 1.0029, 1.0157, 1.0568 /
data ((supersat( 8,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0009, 1.0024, 1.0057, 1.0134, 1.0308, 1.0716, 1.1740, 1.4793, 2.7221,  &
1.0003, 1.0011, 1.0031, 1.0081, 1.0192, 1.0445, 1.1044, 1.2609, 1.8015,  &
1.0001, 1.0003, 1.0012, 1.0042, 1.0114, 1.0277, 1.0651, 1.1556, 1.4098,  &
1.0001, 1.0001, 1.0003, 1.0013, 1.0055, 1.0161, 1.0401, 1.0962, 1.2382,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0013, 1.0071, 1.0224, 1.0579, 1.1436,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0014, 1.0089, 1.0304, 1.0826,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9999, 1.0005, 1.0018, 1.0106, 1.0398 /
data ((supersat( 8,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0018, 1.0043, 1.0100, 1.0232, 1.0539, 1.1291, 1.3342, 2.0863,  &
1.0003, 1.0008, 1.0023, 1.0059, 1.0141, 1.0329, 1.0769, 1.1872, 1.5112,  &
1.0001, 1.0003, 1.0009, 1.0030, 1.0082, 1.0201, 1.0472, 1.1117, 1.2795,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0038, 1.0113, 1.0287, 1.0685, 1.1653,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0009, 1.0047, 1.0156, 1.0408, 1.1001,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0009, 1.0058, 1.0211, 1.0576,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0003, 1.0011, 1.0067, 1.0276 /
data ((supersat( 8,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0014, 1.0034, 1.0079, 1.0183, 1.0426, 1.1017, 1.2553, 1.7345,  &
1.0002, 1.0006, 1.0017, 1.0045, 1.0109, 1.0255, 1.0598, 1.1439, 1.3726,  &
1.0001, 1.0002, 1.0006, 1.0022, 1.0061, 1.0152, 1.0360, 1.0850, 1.2079,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0027, 1.0083, 1.0213, 1.0512, 1.1225,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0007, 1.0032, 1.0112, 1.0299, 1.0733,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0007, 1.0037, 1.0148, 1.0416,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0040, 1.0192 /
data ((supersat( 8,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0011, 1.0027, 1.0064, 1.0150, 1.0352, 1.0838, 1.2073, 1.5612,  &
1.0002, 1.0005, 1.0014, 1.0036, 1.0087, 1.0206, 1.0487, 1.1167, 1.2945,  &
1.0001, 1.0002, 1.0005, 1.0017, 1.0047, 1.0120, 1.0287, 1.0680, 1.1648,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0020, 1.0063, 1.0165, 1.0401, 1.0960,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0023, 1.0083, 1.0228, 1.0564,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0024, 1.0108, 1.0312,  &
0.9998, 0.9998, 0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0025, 1.0136 /
data ((supersat( 8,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0022, 1.0054, 1.0127, 1.0299, 1.0714, 1.1751, 1.4597,  &
1.0002, 1.0004, 1.0011, 1.0029, 1.0072, 1.0173, 1.0410, 1.0983, 1.2448,  &
1.0001, 1.0002, 1.0004, 1.0014, 1.0039, 1.0098, 1.0237, 1.0565, 1.1368,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0016, 1.0050, 1.0133, 1.0327, 1.0787,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0017, 1.0064, 1.0181, 1.0453,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0017, 1.0081, 1.0244,  &
0.9998, 0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0017, 1.0099 /
data ((supersat( 8,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0012, 1.0039, 1.0108, 1.0261, 1.0614, 1.1475, 1.3951, 2.6630, 4.9154,  &
1.0003, 1.0012, 1.0052, 1.0152, 1.0378, 1.0907, 1.2258, 1.6754, 3.8772,  &
1.0002, 1.0003, 1.0013, 1.0068, 1.0212, 1.0548, 1.1356, 1.3600, 2.4072,  &
1.0000, 1.0002, 1.0004, 1.0013, 1.0086, 1.0291, 1.0785, 1.2053, 1.6174,  &
0.9996, 0.9997, 0.9999, 1.0005, 1.0017, 1.0104, 1.0386, 1.1107, 1.3171,  &
0.9984, 0.9985, 0.9986, 0.9991, 1.0000, 1.0024, 1.0120, 1.0487, 1.1525,  &
0.9961, 0.9961, 0.9962, 0.9965, 0.9971, 0.9987, 1.0028, 1.0132, 1.0583 /
data ((supersat( 8,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0008, 1.0028, 1.0075, 1.0180, 1.0421, 1.0994, 1.2502, 1.7899, 3.6747,  &
1.0003, 1.0009, 1.0037, 1.0104, 1.0259, 1.0615, 1.1478, 1.3930, 2.5389,  &
1.0001, 1.0003, 1.0010, 1.0047, 1.0145, 1.0373, 1.0904, 1.2256, 1.6681,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0059, 1.0201, 1.0535, 1.1343, 1.3580,  &
0.9999, 0.9999, 1.0001, 1.0004, 1.0010, 1.0072, 1.0271, 1.0756, 1.2011,  &
0.9993, 0.9993, 0.9994, 0.9997, 1.0002, 1.0016, 1.0083, 1.0349, 1.1044,  &
0.9978, 0.9978, 0.9979, 0.9981, 0.9985, 0.9995, 1.0019, 1.0092, 1.0428 /
data ((supersat( 8,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0006, 1.0021, 1.0053, 1.0129, 1.0303, 1.0709, 1.1730, 1.4779, 2.7177,  &
1.0002, 1.0007, 1.0026, 1.0074, 1.0184, 1.0434, 1.1030, 1.2588, 1.7975,  &
1.0001, 1.0002, 1.0007, 1.0033, 1.0102, 1.0262, 1.0630, 1.1525, 1.4045,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0040, 1.0140, 1.0372, 1.0919, 1.2313,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0008, 1.0047, 1.0188, 1.0524, 1.1347,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0003, 1.0010, 1.0054, 1.0244, 1.0723,  &
0.9988, 0.9988, 0.9988, 0.9989, 0.9992, 0.9998, 1.0013, 1.0058, 1.0303 /
data ((supersat( 8,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0015, 1.0040, 1.0097, 1.0228, 1.0534, 1.1285, 1.3334, 2.0845,  &
1.0002, 1.0005, 1.0019, 1.0054, 1.0135, 1.0322, 1.0760, 1.1859, 1.5091,  &
1.0001, 1.0002, 1.0005, 1.0023, 1.0073, 1.0190, 1.0458, 1.1098, 1.2766,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0027, 1.0098, 1.0267, 1.0657, 1.1612,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0031, 1.0130, 1.0372, 1.0945,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0007, 1.0033, 1.0169, 1.0509,  &
0.9992, 0.9993, 0.9993, 0.9994, 0.9995, 0.9999, 1.0008, 1.0034, 1.0209 /
data ((supersat( 8,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0004, 1.0012, 1.0031, 1.0076, 1.0180, 1.0423, 1.1013, 1.2547, 1.7337,  &
1.0001, 1.0004, 1.0015, 1.0041, 1.0104, 1.0250, 1.0592, 1.1431, 1.3714,  &
1.0001, 1.0001, 1.0004, 1.0017, 1.0054, 1.0143, 1.0350, 1.0837, 1.2061,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0019, 1.0071, 1.0198, 1.0493, 1.1198,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0020, 1.0092, 1.0272, 1.0695,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0020, 1.0117, 1.0368,  &
0.9995, 0.9995, 0.9995, 0.9995, 0.9997, 0.9999, 1.0005, 1.0022, 1.0142 /
data ((supersat( 8,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0024, 1.0062, 1.0147, 1.0349, 1.0835, 1.2069, 1.5607,  &
1.0001, 1.0003, 1.0011, 1.0032, 1.0083, 1.0202, 1.0482, 1.1161, 1.2937,  &
1.0001, 1.0001, 1.0003, 1.0013, 1.0042, 1.0113, 1.0279, 1.0670, 1.1636,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0014, 1.0054, 1.0153, 1.0386, 1.0941,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0014, 1.0068, 1.0207, 1.0536,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0014, 1.0083, 1.0275,  &
0.9995, 0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0004, 1.0015, 1.0098 /
data ((supersat( 8,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0021, 1.0052, 1.0125, 1.0297, 1.0711, 1.1749, 1.4593,  &
1.0001, 1.0003, 1.0009, 1.0027, 1.0069, 1.0169, 1.0406, 1.0978, 1.2442,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0034, 1.0093, 1.0231, 1.0558, 1.1358,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0011, 1.0042, 1.0123, 1.0316, 1.0772,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0010, 1.0051, 1.0164, 1.0431,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0011, 1.0061, 1.0214,  &
0.9996, 0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0003, 1.0011, 1.0069 /
data ((supersat( 8,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0031, 1.0097, 1.0247, 1.0596, 1.1449, 1.3906, 2.6497, 4.8930,  &
1.0002, 1.0007, 1.0039, 1.0132, 1.0353, 1.0870, 1.2198, 1.6633, 3.8339,  &
1.0001, 1.0003, 1.0007, 1.0046, 1.0180, 1.0499, 1.1278, 1.3457, 2.3670,  &
0.9998, 0.9999, 1.0003, 1.0010, 1.0053, 1.0236, 1.0692, 1.1885, 1.5801,  &
0.9990, 0.9991, 0.9993, 0.9999, 1.0013, 1.0058, 1.0296, 1.0933, 1.2803,  &
0.9971, 0.9971, 0.9973, 0.9977, 0.9987, 1.0011, 1.0075, 1.0351, 1.1213,  &
0.9943, 0.9943, 0.9944, 0.9946, 0.9952, 0.9966, 1.0003, 1.0105, 1.0396 /
data ((supersat( 8,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0005, 1.0022, 1.0068, 1.0171, 1.0410, 1.0980, 1.2480, 1.7859, 3.6621,  &
1.0002, 1.0005, 1.0027, 1.0092, 1.0243, 1.0593, 1.1447, 1.3876, 2.5235,  &
1.0001, 1.0002, 1.0006, 1.0032, 1.0125, 1.0344, 1.0861, 1.2186, 1.6537,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0036, 1.0165, 1.0479, 1.1253, 1.3412,  &
0.9996, 0.9996, 0.9998, 1.0001, 1.0009, 1.0039, 1.0211, 1.0653, 1.1821,  &
0.9985, 0.9985, 0.9986, 0.9989, 0.9995, 1.0009, 1.0042, 1.0257, 1.0859,  &
0.9963, 0.9963, 0.9963, 0.9965, 0.9969, 0.9979, 1.0004, 1.0067, 1.0296 /
data ((supersat( 8,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0004, 1.0016, 1.0048, 1.0123, 1.0295, 1.0700, 1.1718, 1.4759, 2.7119,  &
1.0001, 1.0004, 1.0019, 1.0065, 1.0173, 1.0421, 1.1012, 1.2560, 1.7921,  &
1.0001, 1.0001, 1.0004, 1.0022, 1.0087, 1.0242, 1.0603, 1.1485, 1.3976,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0024, 1.0115, 1.0337, 1.0866, 1.2224,  &
0.9998, 0.9999, 0.9999, 1.0002, 1.0006, 1.0025, 1.0147, 1.0459, 1.1238,  &
0.9992, 0.9992, 0.9993, 0.9995, 0.9998, 1.0007, 1.0027, 1.0181, 1.0606,  &
0.9977, 0.9977, 0.9977, 0.9978, 0.9981, 0.9988, 1.0003, 1.0041, 1.0210 /
data ((supersat( 8,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0036, 1.0092, 1.0223, 1.0528, 1.1278, 1.3323, 2.0821,  &
1.0001, 1.0003, 1.0014, 1.0048, 1.0128, 1.0312, 1.0748, 1.1843, 1.5063,  &
1.0001, 1.0001, 1.0003, 1.0016, 1.0062, 1.0176, 1.0441, 1.1073, 1.2728,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0016, 1.0080, 1.0242, 1.0623, 1.1558,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0017, 1.0101, 1.0327, 1.0876,  &
0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 1.0005, 1.0018, 1.0123, 1.0430,  &
0.9985, 0.9985, 0.9985, 0.9986, 0.9987, 0.9992, 1.0002, 1.0025, 1.0143 /
data ((supersat( 8,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0028, 1.0072, 1.0176, 1.0419, 1.1008, 1.2540, 1.7325,  &
1.0001, 1.0003, 1.0011, 1.0036, 1.0098, 1.0243, 1.0583, 1.1420, 1.3697,  &
1.0001, 1.0001, 1.0003, 1.0011, 1.0046, 1.0133, 1.0337, 1.0820, 1.2036,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0012, 1.0058, 1.0180, 1.0468, 1.1163,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0003, 1.0012, 1.0070, 1.0240, 1.0647,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0003, 1.0012, 1.0083, 1.0312,  &
0.9988, 0.9988, 0.9989, 0.9989, 0.9990, 0.9993, 1.0000, 1.0016, 1.0093 /
data ((supersat( 8,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0022, 1.0059, 1.0144, 1.0346, 1.0831, 1.2064, 1.5599,  &
1.0001, 1.0002, 1.0008, 1.0029, 1.0079, 1.0197, 1.0475, 1.1153, 1.2926,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0035, 1.0105, 1.0269, 1.0658, 1.1619,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0009, 1.0043, 1.0139, 1.0368, 1.0916,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0002, 1.0009, 1.0050, 1.0182, 1.0501,  &
0.9997, 0.9997, 0.9998, 0.9998, 1.0000, 1.0002, 1.0009, 1.0056, 1.0233,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9992, 0.9994, 0.9999, 1.0011, 1.0060 /
data ((supersat( 8,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0019, 1.0050, 1.0122, 1.0294, 1.0708, 1.1745, 1.4588,  &
1.0001, 1.0002, 1.0007, 1.0023, 1.0065, 1.0165, 1.0401, 1.0972, 1.2433,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0028, 1.0085, 1.0223, 1.0548, 1.1345,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0033, 1.0111, 1.0301, 1.0752,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0037, 1.0143, 1.0403,  &
0.9997, 0.9997, 0.9998, 0.9998, 0.9999, 1.0002, 1.0007, 1.0039, 1.0180,  &
0.9991, 0.9991, 0.9991, 0.9991, 0.9992, 0.9994, 0.9999, 1.0008, 1.0041 /
data ((supersat( 8,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0004, 1.0022, 1.0083, 1.0230, 1.0572, 1.1414, 1.3847, 2.6321, 4.8631,  &
1.0002, 1.0004, 1.0024, 1.0110, 1.0321, 1.0823, 1.2121, 1.6476, 3.7770,  &
1.0000, 1.0002, 1.0006, 1.0025, 1.0142, 1.0440, 1.1181, 1.3276, 2.3151,  &
0.9994, 0.9995, 0.9999, 1.0007, 1.0027, 1.0177, 1.0586, 1.1685, 1.5343,  &
0.9979, 0.9980, 0.9983, 0.9989, 1.0004, 1.0040, 1.0208, 1.0749, 1.2388,  &
0.9954, 0.9954, 0.9956, 0.9960, 0.9969, 0.9993, 1.0053, 1.0232, 1.0914,  &
0.9927, 0.9927, 0.9928, 0.9929, 0.9934, 0.9946, 0.9976, 1.0061, 1.0328 /
data ((supersat( 8,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0016, 1.0059, 1.0160, 1.0397, 1.0961, 1.2452, 1.7805, 3.6454,  &
1.0001, 1.0003, 1.0018, 1.0077, 1.0223, 1.0566, 1.1406, 1.3806, 2.5030,  &
1.0000, 1.0002, 1.0004, 1.0018, 1.0100, 1.0308, 1.0807, 1.2095, 1.6350,  &
0.9998, 0.9999, 1.0001, 1.0005, 1.0019, 1.0125, 1.0415, 1.1143, 1.3202,  &
0.9990, 0.9991, 0.9992, 0.9996, 1.0005, 1.0025, 1.0150, 1.0539, 1.1599,  &
0.9972, 0.9973, 0.9974, 0.9976, 0.9983, 0.9998, 1.0035, 1.0171, 1.0669,  &
0.9945, 0.9945, 0.9946, 0.9947, 0.9951, 0.9960, 0.9983, 1.0042, 1.0187 /
data ((supersat( 8,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0042, 1.0116, 1.0286, 1.0689, 1.1703, 1.4733, 2.7040,  &
1.0001, 1.0003, 1.0013, 1.0055, 1.0160, 1.0404, 1.0988, 1.2523, 1.7849,  &
1.0000, 1.0001, 1.0003, 1.0013, 1.0070, 1.0219, 1.0570, 1.1434, 1.3886,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0013, 1.0087, 1.0295, 1.0799, 1.2111,  &
0.9995, 0.9995, 0.9996, 0.9999, 1.0004, 1.0016, 1.0104, 1.0385, 1.1107,  &
0.9984, 0.9984, 0.9985, 0.9986, 0.9991, 1.0000, 1.0022, 1.0119, 1.0483,  &
0.9961, 0.9961, 0.9962, 0.9963, 0.9965, 0.9972, 0.9988, 1.0026, 1.0130 /
data ((supersat( 8,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0031, 1.0087, 1.0216, 1.0521, 1.1268, 1.3308, 2.0788,  &
1.0001, 1.0002, 1.0009, 1.0040, 1.0118, 1.0301, 1.0733, 1.1821, 1.5026,  &
1.0000, 1.0001, 1.0002, 1.0010, 1.0050, 1.0159, 1.0418, 1.1041, 1.2676,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0010, 1.0060, 1.0213, 1.0579, 1.1490,  &
0.9997, 0.9997, 0.9998, 1.0000, 1.0003, 1.0011, 1.0070, 1.0276, 1.0792,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9994, 1.0000, 1.0014, 1.0078, 1.0346,  &
0.9972, 0.9972, 0.9973, 0.9973, 0.9975, 0.9980, 0.9990, 1.0015, 1.0084 /
data ((supersat( 8,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0024, 1.0068, 1.0171, 1.0413, 1.1001, 1.2531, 1.7308,  &
1.0001, 1.0002, 1.0007, 1.0030, 1.0091, 1.0234, 1.0572, 1.1405, 1.3675,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0036, 1.0120, 1.0320, 1.0798, 1.2004,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0042, 1.0158, 1.0437, 1.1117,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0047, 1.0202, 1.0589,  &
0.9992, 0.9992, 0.9993, 0.9994, 0.9996, 1.0000, 1.0009, 1.0050, 1.0251,  &
0.9978, 0.9978, 0.9978, 0.9979, 0.9980, 0.9983, 0.9991, 1.0008, 1.0052 /
data ((supersat( 8,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0005, 1.0020, 1.0055, 1.0140, 1.0341, 1.0826, 1.2058, 1.5588,  &
1.0001, 1.0002, 1.0006, 1.0024, 1.0073, 1.0190, 1.0467, 1.1143, 1.2910,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0028, 1.0095, 1.0256, 1.0641, 1.1596,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0031, 1.0121, 1.0344, 1.0882,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0006, 1.0032, 1.0153, 1.0457,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9996, 1.0000, 1.0007, 1.0033, 1.0186,  &
0.9981, 0.9981, 0.9981, 0.9982, 0.9983, 0.9985, 0.9991, 1.0004, 1.0036 /
data ((supersat( 8,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0016, 1.0046, 1.0119, 1.0291, 1.0704, 1.1739, 1.4580,  &
1.0001, 1.0001, 1.0004, 1.0019, 1.0060, 1.0159, 1.0394, 1.0964, 1.2422,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0022, 1.0077, 1.0212, 1.0535, 1.1327,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0005, 1.0023, 1.0097, 1.0281, 1.0726,  &
0.9998, 0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0024, 1.0119, 1.0369,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9996, 0.9999, 1.0005, 1.0024, 1.0143,  &
0.9982, 0.9983, 0.9983, 0.9983, 0.9984, 0.9986, 0.9991, 1.0002, 1.0026 /
data ((supersat( 8,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0017, 1.0074, 1.0218, 1.0556, 1.1390, 1.3805, 2.6191, 4.8415,  &
1.0001, 1.0004, 1.0017, 1.0096, 1.0300, 1.0790, 1.2066, 1.6363, 3.7360,  &
0.9998, 1.0000, 1.0005, 1.0018, 1.0119, 1.0402, 1.1116, 1.3150, 2.2781,  &
0.9990, 0.9992, 0.9995, 1.0004, 1.0025, 1.0142, 1.0520, 1.1555, 1.5034,  &
0.9971, 0.9972, 0.9975, 0.9981, 0.9996, 1.0033, 1.0161, 1.0642, 1.2132,  &
0.9943, 0.9944, 0.9945, 0.9949, 0.9958, 0.9980, 1.0037, 1.0175, 1.0756,  &
0.9919, 0.9920, 0.9920, 0.9922, 0.9926, 0.9936, 0.9962, 1.0036, 1.0268 /
data ((supersat( 8,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0013, 1.0052, 1.0152, 1.0387, 1.0948, 1.2431, 1.7765, 3.6330,  &
1.0001, 1.0003, 1.0013, 1.0067, 1.0210, 1.0547, 1.1378, 1.3756, 2.4882,  &
1.0000, 1.0001, 1.0004, 1.0013, 1.0084, 1.0284, 1.0769, 1.2032, 1.6217,  &
0.9996, 0.9997, 0.9999, 1.0004, 1.0016, 1.0101, 1.0373, 1.1069, 1.3057,  &
0.9985, 0.9986, 0.9987, 0.9991, 1.0001, 1.0022, 1.0116, 1.0470, 1.1457,  &
0.9963, 0.9963, 0.9964, 0.9967, 0.9973, 0.9989, 1.0026, 1.0128, 1.0564,  &
0.9935, 0.9935, 0.9936, 0.9937, 0.9940, 0.9948, 0.9969, 1.0024, 1.0185 /
data ((supersat( 8,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0038, 1.0110, 1.0280, 1.0681, 1.1691, 1.4714, 2.6982,  &
1.0001, 1.0002, 1.0009, 1.0048, 1.0150, 1.0392, 1.0971, 1.2496, 1.7796,  &
1.0000, 1.0001, 1.0003, 1.0010, 1.0059, 1.0203, 1.0546, 1.1398, 1.3821,  &
0.9998, 0.9999, 1.0000, 1.0003, 1.0010, 1.0070, 1.0267, 1.0755, 1.2032,  &
0.9992, 0.9992, 0.9993, 0.9996, 1.0002, 1.0014, 1.0079, 1.0339, 1.1021,  &
0.9977, 0.9977, 0.9978, 0.9980, 0.9984, 0.9994, 1.0017, 1.0087, 1.0411,  &
0.9951, 0.9951, 0.9952, 0.9952, 0.9955, 0.9961, 0.9977, 1.0014, 1.0118 /
data ((supersat( 8,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0029, 1.0083, 1.0212, 1.0515, 1.1261, 1.3297, 2.0764,  &
1.0001, 1.0002, 1.0007, 1.0035, 1.0111, 1.0292, 1.0722, 1.1805, 1.4998,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0042, 1.0148, 1.0403, 1.1018, 1.2639,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0008, 1.0048, 1.0193, 1.0550, 1.1442,  &
0.9995, 0.9995, 0.9996, 0.9998, 1.0001, 1.0009, 1.0052, 1.0244, 1.0736,  &
0.9985, 0.9985, 0.9985, 0.9987, 0.9989, 0.9996, 1.0011, 1.0055, 1.0296,  &
0.9963, 0.9963, 0.9963, 0.9964, 0.9966, 0.9970, 0.9981, 1.0006, 1.0072 /
data ((supersat( 8,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0022, 1.0065, 1.0167, 1.0409, 1.0996, 1.2524, 1.7296,  &
1.0001, 1.0001, 1.0005, 1.0026, 1.0086, 1.0228, 1.0565, 1.1395, 1.3658,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0030, 1.0112, 1.0309, 1.0782, 1.1980,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0006, 1.0033, 1.0143, 1.0416, 1.1085,  &
0.9996, 0.9997, 0.9997, 0.9998, 1.0001, 1.0007, 1.0034, 1.0179, 1.0550,  &
0.9988, 0.9989, 0.9989, 0.9990, 0.9992, 0.9997, 1.0007, 1.0036, 1.0214,  &
0.9970, 0.9970, 0.9970, 0.9971, 0.9972, 0.9975, 0.9983, 1.0001, 1.0045 /
data ((supersat( 8,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0018, 1.0053, 1.0138, 1.0338, 1.0822, 1.2053, 1.5580,  &
1.0001, 1.0001, 1.0004, 1.0021, 1.0068, 1.0185, 1.0461, 1.1135, 1.2898,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0023, 1.0087, 1.0247, 1.0629, 1.1579,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0004, 1.0024, 1.0110, 1.0328, 1.0859,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0001, 1.0005, 1.0024, 1.0134, 1.0428,  &
0.9990, 0.9990, 0.9991, 0.9991, 0.9993, 0.9997, 1.0005, 1.0025, 1.0158,  &
0.9974, 0.9974, 0.9974, 0.9974, 0.9975, 0.9978, 0.9984, 0.9998, 1.0030 /
data ((supersat( 8,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0014, 1.0044, 1.0116, 1.0288, 1.0701, 1.1736, 1.4574,  &
1.0000, 1.0001, 1.0004, 1.0016, 1.0056, 1.0155, 1.0389, 1.0957, 1.2413,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0018, 1.0071, 1.0205, 1.0525, 1.1314,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0004, 1.0018, 1.0087, 1.0268, 1.0708,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0000, 1.0004, 1.0018, 1.0104, 1.0345,  &
0.9991, 0.9991, 0.9991, 0.9992, 0.9993, 0.9996, 1.0003, 1.0020, 1.0120,  &
0.9976, 0.9976, 0.9976, 0.9976, 0.9977, 0.9979, 0.9984, 0.9996, 1.0021 /
data ((supersat( 8,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0003, 1.0013, 1.0068, 1.0209, 1.0543, 1.1370, 1.3771, 2.6086, 4.8234,  &
1.0001, 1.0004, 1.0013, 1.0085, 1.0283, 1.0765, 1.2023, 1.6272, 3.7027,  &
0.9997, 0.9999, 1.0004, 1.0014, 1.0103, 1.0373, 1.1065, 1.3051, 2.2485,  &
0.9986, 0.9988, 0.9992, 1.0001, 1.0022, 1.0118, 1.0472, 1.1457, 1.4798,  &
0.9965, 0.9966, 0.9968, 0.9974, 0.9990, 1.0027, 1.0131, 1.0569, 1.1950,  &
0.9936, 0.9937, 0.9938, 0.9941, 0.9950, 0.9971, 1.0025, 1.0185, 1.0654,  &
0.9915, 0.9915, 0.9916, 0.9917, 0.9921, 0.9930, 0.9953, 1.0019, 1.0227 /
data ((supersat( 8,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0010, 1.0048, 1.0147, 1.0379, 1.0937, 1.2414, 1.7733, 3.6230,  &
1.0001, 1.0002, 1.0010, 1.0060, 1.0199, 1.0532, 1.1354, 1.3715, 2.4760,  &
0.9999, 1.0000, 1.0003, 1.0011, 1.0072, 1.0266, 1.0740, 1.1981, 1.6110,  &
0.9994, 0.9995, 0.9997, 1.0002, 1.0015, 1.0084, 1.0342, 1.1013, 1.2945,  &
0.9981, 0.9981, 0.9983, 0.9987, 0.9997, 1.0019, 1.0093, 1.0421, 1.1353,  &
0.9956, 0.9956, 0.9957, 0.9960, 0.9966, 0.9981, 1.0018, 1.0120, 1.0493,  &
0.9929, 0.9929, 0.9929, 0.9930, 0.9933, 0.9941, 0.9960, 1.0011, 1.0160 /
data ((supersat( 8,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0035, 1.0106, 1.0275, 1.0674, 1.1682, 1.4698, 2.6933,  &
1.0001, 1.0002, 1.0008, 1.0043, 1.0143, 1.0382, 1.0957, 1.2475, 1.7753,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0051, 1.0190, 1.0528, 1.1369, 1.3769,  &
0.9997, 0.9998, 0.9999, 1.0002, 1.0010, 1.0058, 1.0246, 1.0720, 1.1970,  &
0.9989, 0.9990, 0.9991, 0.9993, 0.9999, 1.0013, 1.0063, 1.0306, 1.0957,  &
0.9971, 0.9972, 0.9972, 0.9974, 0.9978, 0.9988, 1.0012, 1.0075, 1.0362,  &
0.9944, 0.9944, 0.9944, 0.9945, 0.9947, 0.9953, 0.9968, 1.0004, 1.0104 /
data ((supersat( 8,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0006, 1.0026, 1.0080, 1.0208, 1.0511, 1.1255, 1.3288, 2.0744,  &
1.0001, 1.0002, 1.0006, 1.0031, 1.0106, 1.0286, 1.0713, 1.1792, 1.4975,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0036, 1.0139, 1.0390, 1.1000, 1.2609,  &
0.9998, 0.9999, 1.0000, 1.0002, 1.0006, 1.0039, 1.0178, 1.0527, 1.1404,  &
0.9993, 0.9994, 0.9994, 0.9996, 1.0000, 1.0008, 1.0041, 1.0221, 1.0694,  &
0.9980, 0.9980, 0.9981, 0.9982, 0.9985, 0.9992, 1.0008, 1.0046, 1.0261,  &
0.9956, 0.9956, 0.9956, 0.9957, 0.9959, 0.9963, 0.9974, 0.9999, 1.0063 /
data ((supersat( 8,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0020, 1.0062, 1.0165, 1.0406, 1.0992, 1.2518, 1.7286,  &
1.0001, 1.0001, 1.0005, 1.0023, 1.0082, 1.0223, 1.0558, 1.1386, 1.3644,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0026, 1.0105, 1.0300, 1.0769, 1.1960,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0027, 1.0132, 1.0400, 1.1059,  &
0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0006, 1.0027, 1.0161, 1.0521,  &
0.9985, 0.9985, 0.9985, 0.9986, 0.9988, 0.9993, 1.0004, 1.0030, 1.0188,  &
0.9963, 0.9963, 0.9964, 0.9964, 0.9965, 0.9969, 0.9977, 0.9995, 1.0039 /
data ((supersat( 8,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0016, 1.0051, 1.0135, 1.0336, 1.0819, 1.2048, 1.5573,  &
1.0000, 1.0001, 1.0004, 1.0018, 1.0065, 1.0181, 1.0456, 1.1128, 1.2889,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0019, 1.0082, 1.0240, 1.0620, 1.1565,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0019, 1.0101, 1.0315, 1.0840,  &
0.9996, 0.9996, 0.9997, 0.9998, 1.0000, 1.0004, 1.0020, 1.0120, 1.0406,  &
0.9987, 0.9987, 0.9987, 0.9988, 0.9990, 0.9994, 1.0002, 1.0022, 1.0138,  &
0.9967, 0.9967, 0.9968, 0.9968, 0.9969, 0.9972, 0.9978, 0.9992, 1.0025 /
data ((supersat( 8,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0013, 1.0043, 1.0114, 1.0286, 1.0698, 1.1732, 1.4569,  &
1.0000, 1.0001, 1.0003, 1.0015, 1.0054, 1.0151, 1.0385, 1.0952, 1.2406,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0015, 1.0066, 1.0198, 1.0517, 1.1303,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0015, 1.0079, 1.0258, 1.0693,  &
0.9996, 0.9996, 0.9997, 0.9998, 1.0000, 1.0003, 1.0015, 1.0092, 1.0327,  &
0.9988, 0.9988, 0.9988, 0.9989, 0.9990, 0.9994, 1.0001, 1.0017, 1.0103,  &
0.9969, 0.9970, 0.9970, 0.9970, 0.9971, 0.9973, 0.9979, 0.9991, 1.0017 /
data ((supersat( 8,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0011, 1.0062, 1.0201, 1.0532, 1.1354, 1.3741, 2.5994, 4.8081,  &
1.0001, 1.0003, 1.0011, 1.0076, 1.0270, 1.0743, 1.1986, 1.6194, 3.6744,  &
0.9996, 0.9998, 1.0003, 1.0015, 1.0090, 1.0350, 1.1024, 1.2968, 2.2234,  &
0.9983, 0.9985, 0.9989, 0.9998, 1.0020, 1.0101, 1.0435, 1.1379, 1.4604,  &
0.9959, 0.9960, 0.9963, 0.9969, 0.9984, 1.0021, 1.0109, 1.0514, 1.1809,  &
0.9931, 0.9932, 0.9933, 0.9936, 0.9944, 0.9963, 1.0015, 1.0166, 1.0582,  &
0.9912, 0.9913, 0.9913, 0.9914, 0.9917, 0.9925, 0.9947, 1.0007, 1.0196 /
data ((supersat( 8,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0045, 1.0142, 1.0373, 1.0927, 1.2400, 1.7704, 3.6143,  &
1.0001, 1.0002, 1.0009, 1.0054, 1.0191, 1.0519, 1.1335, 1.3680, 2.4655,  &
0.9999, 1.0000, 1.0003, 1.0009, 1.0063, 1.0251, 1.0716, 1.1939, 1.6019,  &
0.9992, 0.9993, 0.9996, 1.0001, 1.0014, 1.0071, 1.0318, 1.0967, 1.2852,  &
0.9977, 0.9977, 0.9979, 0.9983, 0.9993, 1.0015, 1.0077, 1.0384, 1.1270,  &
0.9950, 0.9951, 0.9951, 0.9954, 0.9960, 0.9975, 1.0011, 1.0110, 1.0441,  &
0.9924, 0.9924, 0.9925, 0.9926, 0.9928, 0.9936, 0.9953, 1.0001, 1.0140 /
data ((supersat( 8,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0032, 1.0103, 1.0271, 1.0669, 1.1673, 1.4684, 2.6892,  &
1.0001, 1.0002, 1.0007, 1.0039, 1.0137, 1.0374, 1.0946, 1.2456, 1.7716,  &
1.0000, 1.0000, 1.0002, 1.0007, 1.0044, 1.0180, 1.0513, 1.1345, 1.3724,  &
0.9996, 0.9997, 0.9998, 1.0002, 1.0009, 1.0048, 1.0230, 1.0692, 1.1919,  &
0.9987, 0.9987, 0.9988, 0.9991, 0.9997, 1.0011, 1.0051, 1.0280, 1.0906,  &
0.9966, 0.9967, 0.9967, 0.9969, 0.9973, 0.9983, 1.0007, 1.0070, 1.0325,  &
0.9938, 0.9938, 0.9939, 0.9939, 0.9942, 0.9947, 0.9961, 0.9996, 1.0092 /
data ((supersat( 8,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0024, 1.0078, 1.0205, 1.0507, 1.1249, 1.3280, 2.0726,  &
1.0001, 1.0001, 1.0005, 1.0028, 1.0102, 1.0280, 1.0705, 1.1780, 1.4956,  &
1.0000, 1.0000, 1.0002, 1.0005, 1.0031, 1.0132, 1.0380, 1.0984, 1.2584,  &
0.9998, 0.9998, 0.9999, 1.0001, 1.0006, 1.0032, 1.0166, 1.0508, 1.1372,  &
0.9992, 0.9992, 0.9993, 0.9994, 0.9998, 1.0007, 1.0034, 1.0202, 1.0661,  &
0.9976, 0.9977, 0.9977, 0.9978, 0.9981, 0.9988, 1.0004, 1.0043, 1.0235,  &
0.9950, 0.9950, 0.9951, 0.9951, 0.9953, 0.9957, 0.9968, 0.9993, 1.0056 /
data ((supersat( 8,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0019, 1.0061, 1.0162, 1.0403, 1.0988, 1.2513, 1.7277,  &
1.0000, 1.0001, 1.0004, 1.0021, 1.0078, 1.0218, 1.0553, 1.1378, 1.3632,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0022, 1.0099, 1.0292, 1.0759, 1.1944,  &
0.9998, 0.9999, 0.9999, 1.0001, 1.0004, 1.0023, 1.0123, 1.0386, 1.1037,  &
0.9994, 0.9994, 0.9995, 0.9996, 0.9999, 1.0005, 1.0023, 1.0147, 1.0497,  &
0.9982, 0.9982, 0.9982, 0.9983, 0.9985, 0.9990, 1.0002, 1.0028, 1.0169,  &
0.9958, 0.9958, 0.9958, 0.9959, 0.9960, 0.9963, 0.9971, 0.9990, 1.0033 /
data ((supersat( 8,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0015, 1.0049, 1.0133, 1.0333, 1.0817, 1.2045, 1.5567,  &
1.0000, 1.0001, 1.0003, 1.0016, 1.0062, 1.0177, 1.0452, 1.1123, 1.2880,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0017, 1.0077, 1.0234, 1.0612, 1.1553,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0017, 1.0093, 1.0305, 1.0824,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9999, 1.0004, 1.0017, 1.0109, 1.0387,  &
0.9984, 0.9984, 0.9984, 0.9985, 0.9987, 0.9991, 1.0000, 1.0020, 1.0123,  &
0.9962, 0.9962, 0.9962, 0.9963, 0.9964, 0.9966, 0.9973, 0.9987, 1.0020 /
data ((supersat( 8,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0012, 1.0041, 1.0113, 1.0284, 1.0696, 1.1729, 1.4565,  &
1.0000, 1.0001, 1.0003, 1.0013, 1.0051, 1.0148, 1.0381, 1.0947, 1.2399,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0013, 1.0062, 1.0193, 1.0511, 1.1294,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0013, 1.0073, 1.0249, 1.0680,  &
0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 1.0003, 1.0013, 1.0083, 1.0312,  &
0.9985, 0.9985, 0.9986, 0.9986, 0.9988, 0.9991, 0.9999, 1.0015, 1.0091,  &
0.9964, 0.9965, 0.9965, 0.9965, 0.9966, 0.9968, 0.9973, 0.9986, 1.0013 /
data ((supersat( 9,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0008, 1.0034, 1.0100, 1.0251, 1.0602, 1.1458, 1.3922, 2.6544, 4.9005,  &
1.0002, 1.0008, 1.0043, 1.0138, 1.0361, 1.0882, 1.2218, 1.6675, 3.8483,  &
1.0001, 1.0003, 1.0008, 1.0052, 1.0189, 1.0513, 1.1302, 1.3503, 2.3806,  &
0.9999, 1.0000, 1.0003, 1.0010, 1.0062, 1.0251, 1.0718, 1.1934, 1.5916,  &
0.9991, 0.9992, 0.9995, 1.0001, 1.0014, 1.0070, 1.0318, 1.0978, 1.2904,  &
0.9975, 0.9975, 0.9977, 0.9981, 0.9991, 1.0015, 1.0075, 1.0382, 1.1286,  &
0.9948, 0.9948, 0.9949, 0.9951, 0.9957, 0.9972, 1.0010, 1.0116, 1.0434 /
data ((supersat( 9,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0024, 1.0070, 1.0174, 1.0414, 1.0985, 1.2488, 1.7874, 3.6665,  &
1.0002, 1.0006, 1.0030, 1.0096, 1.0248, 1.0600, 1.1457, 1.3895, 2.5289,  &
1.0001, 1.0002, 1.0006, 1.0036, 1.0131, 1.0353, 1.0875, 1.2209, 1.6586,  &
1.0000, 1.0001, 1.0003, 1.0007, 1.0043, 1.0176, 1.0496, 1.1280, 1.3465,  &
0.9997, 0.9997, 0.9999, 1.0002, 1.0009, 1.0047, 1.0227, 1.0682, 1.1876,  &
0.9987, 0.9988, 0.9989, 0.9991, 0.9997, 1.0011, 1.0051, 1.0280, 1.0906,  &
0.9967, 0.9967, 0.9968, 0.9969, 0.9974, 0.9984, 1.0009, 1.0073, 1.0325 /
data ((supersat( 9,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0018, 1.0049, 1.0125, 1.0298, 1.0704, 1.1723, 1.4766, 2.7141,  &
1.0002, 1.0005, 1.0021, 1.0068, 1.0176, 1.0426, 1.1018, 1.2570, 1.7941,  &
1.0001, 1.0002, 1.0005, 1.0025, 1.0092, 1.0248, 1.0612, 1.1499, 1.4001,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0029, 1.0122, 1.0348, 1.0883, 1.2253,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0031, 1.0159, 1.0478, 1.1271,  &
0.9993, 0.9994, 0.9994, 0.9996, 1.0000, 1.0008, 1.0032, 1.0198, 1.0638,  &
0.9980, 0.9980, 0.9980, 0.9982, 0.9984, 0.9991, 1.0006, 1.0044, 1.0233 /
data ((supersat( 9,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0004, 1.0013, 1.0037, 1.0094, 1.0224, 1.0530, 1.1280, 1.3327, 2.0831,  &
1.0001, 1.0004, 1.0016, 1.0049, 1.0130, 1.0316, 1.0753, 1.1849, 1.5074,  &
1.0001, 1.0001, 1.0004, 1.0018, 1.0065, 1.0181, 1.0447, 1.1082, 1.2742,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0019, 1.0086, 1.0250, 1.0634, 1.1577,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0004, 1.0020, 1.0110, 1.0341, 1.0898,  &
0.9996, 0.9996, 0.9997, 0.9998, 1.0000, 1.0005, 1.0021, 1.0136, 1.0453,  &
0.9987, 0.9987, 0.9987, 0.9988, 0.9990, 0.9994, 1.0004, 1.0027, 1.0160 /
data ((supersat( 9,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0003, 1.0010, 1.0029, 1.0074, 1.0177, 1.0420, 1.1010, 1.2544, 1.7330,  &
1.0001, 1.0003, 1.0012, 1.0037, 1.0100, 1.0245, 1.0586, 1.1424, 1.3704,  &
1.0001, 1.0001, 1.0003, 1.0013, 1.0049, 1.0137, 1.0342, 1.0826, 1.2046,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0062, 1.0186, 1.0477, 1.1176,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0013, 1.0077, 1.0251, 1.0664,  &
0.9997, 0.9997, 0.9998, 0.9998, 1.0000, 1.0004, 1.0014, 1.0093, 1.0329,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9992, 0.9995, 1.0002, 1.0017, 1.0107 /
data ((supersat( 9,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0023, 1.0060, 1.0145, 1.0347, 1.0833, 1.2067, 1.5602,  &
1.0001, 1.0002, 1.0009, 1.0030, 1.0080, 1.0199, 1.0478, 1.1157, 1.2931,  &
1.0001, 1.0001, 1.0002, 1.0010, 1.0038, 1.0107, 1.0273, 1.0663, 1.1626,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0010, 1.0046, 1.0144, 1.0375, 1.0926,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0010, 1.0056, 1.0191, 1.0514,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0010, 1.0064, 1.0247,  &
0.9992, 0.9992, 0.9992, 0.9992, 0.9993, 0.9996, 1.0001, 1.0012, 1.0072 /
data ((supersat( 9,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0019, 1.0050, 1.0123, 1.0295, 1.0710, 1.1747, 1.4590,  &
1.0001, 1.0002, 1.0007, 1.0024, 1.0067, 1.0166, 1.0403, 1.0975, 1.2437,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0030, 1.0088, 1.0226, 1.0552, 1.1351,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0036, 1.0116, 1.0306, 1.0761,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0041, 1.0151, 1.0414,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0046, 1.0192,  &
0.9992, 0.9992, 0.9993, 0.9993, 0.9994, 0.9996, 1.0000, 1.0009, 1.0049 /
data ((supersat( 9,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0025, 1.0087, 1.0235, 1.0580, 1.1425, 1.3867, 2.6380, 4.8731,  &
1.0002, 1.0005, 1.0028, 1.0117, 1.0331, 1.0838, 1.2145, 1.6527, 3.7952,  &
1.0000, 1.0002, 1.0006, 1.0030, 1.0153, 1.0457, 1.1211, 1.3332, 2.3318,  &
0.9995, 0.9997, 1.0000, 1.0008, 1.0032, 1.0193, 1.0616, 1.1744, 1.5482,  &
0.9982, 0.9983, 0.9986, 0.9992, 1.0007, 1.0043, 1.0231, 1.0798, 1.2504,  &
0.9958, 0.9959, 0.9960, 0.9964, 0.9974, 0.9998, 1.0060, 1.0262, 1.0989,  &
0.9931, 0.9931, 0.9932, 0.9934, 0.9939, 0.9952, 0.9984, 1.0073, 1.0356 /
data ((supersat( 9,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0004, 1.0018, 1.0061, 1.0163, 1.0401, 1.0967, 1.2462, 1.7823, 3.6509,  &
1.0001, 1.0004, 1.0020, 1.0081, 1.0229, 1.0574, 1.1419, 1.3829, 2.5099,  &
1.0001, 1.0002, 1.0004, 1.0022, 1.0107, 1.0319, 1.0823, 1.2124, 1.6410,  &
0.9998, 0.9999, 1.0001, 1.0006, 1.0022, 1.0137, 1.0434, 1.1176, 1.3266,  &
0.9992, 0.9992, 0.9994, 0.9998, 1.0006, 1.0024, 1.0167, 1.0571, 1.1663,  &
0.9976, 0.9976, 0.9977, 0.9980, 0.9986, 1.0002, 1.0038, 1.0194, 1.0719,  &
0.9950, 0.9950, 0.9950, 0.9952, 0.9956, 0.9965, 0.9989, 1.0049, 1.0214 /
data ((supersat( 9,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0013, 1.0044, 1.0118, 1.0289, 1.0693, 1.1708, 1.4742, 2.7067,  &
1.0001, 1.0003, 1.0015, 1.0058, 1.0164, 1.0409, 1.0996, 1.2536, 1.7873,  &
1.0001, 1.0001, 1.0003, 1.0015, 1.0075, 1.0226, 1.0580, 1.1451, 1.3916,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0016, 1.0095, 1.0307, 1.0820, 1.2147,  &
0.9996, 0.9996, 0.9997, 1.0000, 1.0005, 1.0017, 1.0116, 1.0407, 1.1146,  &
0.9986, 0.9987, 0.9987, 0.9989, 0.9993, 1.0002, 1.0024, 1.0136, 1.0517,  &
0.9966, 0.9966, 0.9966, 0.9967, 0.9970, 0.9976, 0.9992, 1.0031, 1.0151 /
data ((supersat( 9,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0002, 1.0010, 1.0033, 1.0088, 1.0218, 1.0523, 1.1271, 1.3313, 2.0801,  &
1.0001, 1.0002, 1.0011, 1.0042, 1.0121, 1.0304, 1.0738, 1.1828, 1.5039,  &
1.0001, 1.0001, 1.0002, 1.0011, 1.0053, 1.0164, 1.0426, 1.1052, 1.2694,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0011, 1.0066, 1.0222, 1.0593, 1.1513,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0012, 1.0079, 1.0292, 1.0818,  &
0.9991, 0.9991, 0.9992, 0.9993, 0.9996, 1.0002, 1.0015, 1.0091, 1.0371,  &
0.9976, 0.9976, 0.9976, 0.9977, 0.9979, 0.9983, 0.9994, 1.0018, 1.0100 /
data ((supersat( 9,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0025, 1.0069, 1.0172, 1.0415, 1.1003, 1.2535, 1.7315,  &
1.0001, 1.0002, 1.0008, 1.0032, 1.0093, 1.0237, 1.0576, 1.1411, 1.3683,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0039, 1.0124, 1.0326, 1.0806, 1.2016,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0047, 1.0165, 1.0447, 1.1133,  &
0.9998, 0.9999, 0.9999, 1.0000, 1.0002, 1.0008, 1.0053, 1.0214, 1.0608,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9997, 1.0001, 1.0010, 1.0059, 1.0269,  &
0.9981, 0.9981, 0.9981, 0.9982, 0.9983, 0.9986, 0.9994, 1.0011, 1.0062 /
data ((supersat( 9,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0020, 1.0056, 1.0142, 1.0343, 1.0828, 1.2060, 1.5592,  &
1.0001, 1.0002, 1.0006, 1.0025, 1.0074, 1.0192, 1.0470, 1.1147, 1.2916,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0030, 1.0098, 1.0260, 1.0647, 1.1604,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0034, 1.0127, 1.0352, 1.0894,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0037, 1.0162, 1.0472,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0007, 1.0039, 1.0201,  &
0.9984, 0.9984, 0.9984, 0.9984, 0.9985, 0.9988, 0.9994, 1.0006, 1.0040 /
data ((supersat( 9,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0017, 1.0047, 1.0120, 1.0292, 1.0706, 1.1742, 1.4583,  &
1.0001, 1.0001, 1.0005, 1.0020, 1.0062, 1.0161, 1.0396, 1.0967, 1.2426,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0024, 1.0080, 1.0216, 1.0540, 1.1334,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0005, 1.0026, 1.0101, 1.0288, 1.0736,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0027, 1.0127, 1.0381,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0006, 1.0027, 1.0155,  &
0.9985, 0.9985, 0.9985, 0.9985, 0.9986, 0.9988, 0.9993, 1.0004, 1.0029 /
data ((supersat( 9,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0015, 1.0072, 1.0215, 1.0552, 1.1384, 1.3794, 2.6159, 4.8358,  &
1.0001, 1.0004, 1.0015, 1.0092, 1.0294, 1.0782, 1.2052, 1.6334, 3.7253,  &
0.9998, 1.0000, 1.0005, 1.0016, 1.0113, 1.0392, 1.1099, 1.3117, 2.2686,  &
0.9989, 0.9990, 0.9994, 1.0003, 1.0024, 1.0134, 1.0503, 1.1521, 1.4954,  &
0.9969, 0.9970, 0.9972, 0.9979, 0.9994, 1.0031, 1.0150, 1.0615, 1.2067,  &
0.9941, 0.9941, 0.9942, 0.9946, 0.9955, 0.9976, 1.0033, 1.0199, 1.0718,  &
0.9918, 0.9918, 0.9919, 0.9920, 0.9924, 0.9934, 0.9959, 1.0030, 1.0253 /
data ((supersat( 9,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0012, 1.0051, 1.0151, 1.0384, 1.0944, 1.2426, 1.7755, 3.6300,  &
1.0001, 1.0003, 1.0012, 1.0065, 1.0206, 1.0542, 1.1370, 1.3743, 2.4844,  &
1.0000, 1.0001, 1.0003, 1.0012, 1.0080, 1.0278, 1.0759, 1.2015, 1.6183,  &
0.9995, 0.9996, 0.9998, 1.0003, 1.0015, 1.0095, 1.0362, 1.1050, 1.3020,  &
0.9983, 0.9984, 0.9986, 0.9990, 0.9999, 1.0021, 1.0108, 1.0453, 1.1421,  &
0.9960, 0.9961, 0.9962, 0.9964, 0.9970, 0.9986, 1.0023, 1.0118, 1.0538,  &
0.9933, 0.9933, 0.9933, 0.9934, 0.9938, 0.9946, 0.9966, 1.0019, 1.0176 /
data ((supersat( 9,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0037, 1.0109, 1.0278, 1.0679, 1.1688, 1.4709, 2.6968,  &
1.0001, 1.0002, 1.0009, 1.0046, 1.0148, 1.0389, 1.0967, 1.2490, 1.7783,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0056, 1.0198, 1.0541, 1.1389, 1.3805,  &
0.9998, 0.9998, 1.0000, 1.0003, 1.0010, 1.0065, 1.0260, 1.0743, 1.2012,  &
0.9991, 0.9991, 0.9992, 0.9995, 1.0001, 1.0014, 1.0074, 1.0328, 1.1000,  &
0.9975, 0.9975, 0.9976, 0.9977, 0.9982, 0.9992, 1.0015, 1.0079, 1.0394,  &
0.9948, 0.9948, 0.9949, 0.9950, 0.9952, 0.9958, 0.9973, 1.0010, 1.0113 /
data ((supersat( 9,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0028, 1.0082, 1.0211, 1.0514, 1.1259, 1.3295, 2.0758,  &
1.0001, 1.0002, 1.0007, 1.0034, 1.0109, 1.0290, 1.0719, 1.1801, 1.4992,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0039, 1.0145, 1.0399, 1.1013, 1.2631,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0044, 1.0188, 1.0542, 1.1431,  &
0.9994, 0.9995, 0.9995, 0.9997, 1.0001, 1.0009, 1.0048, 1.0237, 1.0723,  &
0.9983, 0.9983, 0.9984, 0.9985, 0.9988, 0.9995, 1.0010, 1.0050, 1.0284,  &
0.9960, 0.9960, 0.9961, 0.9961, 0.9963, 0.9967, 0.9978, 1.0004, 1.0069 /
data ((supersat( 9,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0021, 1.0064, 1.0166, 1.0408, 1.0995, 1.2522, 1.7293,  &
1.0001, 1.0001, 1.0005, 1.0025, 1.0084, 1.0226, 1.0563, 1.1392, 1.3654,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0029, 1.0109, 1.0306, 1.0779, 1.1975,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0031, 1.0139, 1.0411, 1.1077,  &
0.9996, 0.9996, 0.9997, 0.9998, 1.0001, 1.0006, 1.0031, 1.0173, 1.0541,  &
0.9987, 0.9987, 0.9987, 0.9988, 0.9991, 0.9995, 1.0006, 1.0033, 1.0206,  &
0.9967, 0.9967, 0.9968, 0.9968, 0.9969, 0.9973, 0.9981, 0.9999, 1.0043 /
data ((supersat( 9,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0017, 1.0052, 1.0137, 1.0337, 1.0822, 1.2051, 1.5579,  &
1.0000, 1.0001, 1.0004, 1.0020, 1.0067, 1.0183, 1.0460, 1.1133, 1.2896,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0021, 1.0085, 1.0245, 1.0627, 1.1575,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0004, 1.0022, 1.0107, 1.0324, 1.0853,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0005, 1.0022, 1.0130, 1.0421,  &
0.9989, 0.9989, 0.9989, 0.9990, 0.9992, 0.9996, 1.0004, 1.0024, 1.0152,  &
0.9971, 0.9971, 0.9971, 0.9972, 0.9973, 0.9975, 0.9982, 0.9996, 1.0028 /
data ((supersat( 9,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0014, 1.0044, 1.0116, 1.0287, 1.0700, 1.1735, 1.4573,  &
1.0000, 1.0001, 1.0003, 1.0016, 1.0055, 1.0154, 1.0388, 1.0956, 1.2411,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0017, 1.0069, 1.0203, 1.0523, 1.1311,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0003, 1.0017, 1.0084, 1.0265, 1.0704,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0004, 1.0017, 1.0100, 1.0340,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9992, 0.9995, 1.0002, 1.0018, 1.0115,  &
0.9973, 0.9973, 0.9973, 0.9974, 0.9974, 0.9977, 0.9982, 0.9994, 1.0020 /
data ((supersat( 9,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0055, 1.0190, 1.0517, 1.1330, 1.3699, 2.5864, 4.7866,  &
1.0000, 1.0003, 1.0009, 1.0065, 1.0251, 1.0714, 1.1935, 1.6085, 3.6342,  &
0.9993, 0.9996, 1.0001, 1.0014, 1.0073, 1.0319, 1.0967, 1.2854, 2.1883,  &
0.9978, 0.9980, 0.9984, 0.9994, 1.0016, 1.0080, 1.0388, 1.1276, 1.4343,  &
0.9952, 0.9952, 0.9955, 0.9961, 0.9976, 1.0012, 1.0111, 1.0447, 1.1630,  &
0.9925, 0.9926, 0.9927, 0.9929, 0.9937, 0.9955, 1.0002, 1.0142, 1.0598,  &
0.9910, 0.9910, 0.9910, 0.9911, 0.9914, 0.9921, 0.9940, 0.9993, 1.0160 /
data ((supersat( 9,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0039, 1.0135, 1.0363, 1.0914, 1.2379, 1.7664, 3.6019,  &
1.0001, 1.0002, 1.0007, 1.0046, 1.0179, 1.0501, 1.1307, 1.3630, 2.4506,  &
0.9997, 0.9999, 1.0002, 1.0009, 1.0052, 1.0231, 1.0683, 1.1880, 1.5892,  &
0.9989, 0.9990, 0.9993, 0.9999, 1.0012, 1.0056, 1.0286, 1.0906, 1.2725,  &
0.9971, 0.9971, 0.9973, 0.9977, 0.9987, 1.0010, 1.0070, 1.0337, 1.1163,  &
0.9943, 0.9943, 0.9944, 0.9946, 0.9952, 0.9966, 1.0001, 1.0096, 1.0379,  &
0.9919, 0.9919, 0.9920, 0.9921, 0.9923, 0.9930, 0.9946, 0.9988, 1.0115 /
data ((supersat( 9,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0029, 1.0098, 1.0264, 1.0660, 1.1662, 1.4664, 2.6833,  &
1.0001, 1.0002, 1.0005, 1.0033, 1.0129, 1.0363, 1.0929, 1.2430, 1.7663,  &
0.9999, 1.0000, 1.0002, 1.0006, 1.0036, 1.0166, 1.0492, 1.1311, 1.3661,  &
0.9994, 0.9995, 0.9997, 1.0000, 1.0008, 1.0038, 1.0208, 1.0653, 1.1848,  &
0.9982, 0.9983, 0.9984, 0.9987, 0.9993, 1.0008, 1.0044, 1.0247, 1.0839,  &
0.9959, 0.9959, 0.9960, 0.9962, 0.9966, 0.9976, 1.0000, 1.0062, 1.0281,  &
0.9931, 0.9932, 0.9932, 0.9933, 0.9935, 0.9940, 0.9953, 0.9986, 1.0076 /
data ((supersat( 9,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0022, 1.0074, 1.0201, 1.0501, 1.1242, 1.3269, 2.0700,  &
1.0000, 1.0001, 1.0004, 1.0024, 1.0096, 1.0272, 1.0695, 1.1764, 1.4928,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0025, 1.0122, 1.0365, 1.0963, 1.2547,  &
0.9997, 0.9997, 0.9998, 1.0001, 1.0006, 1.0026, 1.0150, 1.0482, 1.1328,  &
0.9989, 0.9989, 0.9990, 0.9992, 0.9996, 1.0005, 1.0028, 1.0179, 1.0616,  &
0.9970, 0.9970, 0.9971, 0.9972, 0.9975, 0.9982, 0.9999, 1.0039, 1.0202,  &
0.9943, 0.9943, 0.9943, 0.9944, 0.9945, 0.9949, 0.9960, 0.9984, 1.0045 /
data ((supersat( 9,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0017, 1.0058, 1.0159, 1.0399, 1.0983, 1.2506, 1.7264,  &
1.0000, 1.0001, 1.0003, 1.0018, 1.0073, 1.0212, 1.0545, 1.1368, 1.3615,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0018, 1.0091, 1.0282, 1.0744, 1.1920,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0004, 1.0018, 1.0111, 1.0367, 1.1008,  &
0.9991, 0.9992, 0.9992, 0.9994, 0.9997, 1.0004, 1.0020, 1.0129, 1.0465,  &
0.9976, 0.9977, 0.9977, 0.9978, 0.9980, 0.9985, 0.9997, 1.0025, 1.0145,  &
0.9950, 0.9951, 0.9951, 0.9951, 0.9952, 0.9956, 0.9963, 0.9982, 1.0025 /
data ((supersat( 9,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0013, 1.0047, 1.0130, 1.0330, 1.0813, 1.2039, 1.5559,  &
1.0000, 1.0001, 1.0003, 1.0014, 1.0058, 1.0172, 1.0446, 1.1115, 1.2868,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0014, 1.0071, 1.0225, 1.0600, 1.1536,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0014, 1.0084, 1.0290, 1.0802,  &
0.9993, 0.9993, 0.9993, 0.9995, 0.9997, 1.0002, 1.0015, 1.0095, 1.0363,  &
0.9979, 0.9980, 0.9980, 0.9981, 0.9982, 0.9987, 0.9996, 1.0017, 1.0104,  &
0.9955, 0.9955, 0.9955, 0.9955, 0.9956, 0.9959, 0.9965, 0.9980, 1.0013 /
data ((supersat( 9,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0011, 1.0039, 1.0110, 1.0281, 1.0693, 1.1725, 1.4558,  &
1.0000, 1.0001, 1.0002, 1.0011, 1.0048, 1.0144, 1.0376, 1.0941, 1.2390,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0011, 1.0057, 1.0186, 1.0501, 1.1281,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0011, 1.0065, 1.0237, 1.0662,  &
0.9993, 0.9994, 0.9994, 0.9995, 0.9997, 1.0002, 1.0012, 1.0072, 1.0293,  &
0.9981, 0.9981, 0.9981, 0.9982, 0.9983, 0.9987, 0.9995, 1.0012, 1.0076,  &
0.9957, 0.9957, 0.9957, 0.9958, 0.9959, 0.9961, 0.9966, 0.9979, 1.0006 /
data ((supersat( 9,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0044, 1.0174, 1.0492, 1.1292, 1.3631, 2.5647, 4.7504,  &
0.9999, 1.0002, 1.0009, 1.0049, 1.0223, 1.0668, 1.1854, 1.5909, 3.5691,  &
0.9989, 0.9992, 0.9998, 1.0011, 1.0052, 1.0275, 1.0883, 1.2679, 2.1322,  &
0.9970, 0.9971, 0.9975, 0.9986, 1.0009, 1.0069, 1.0323, 1.1128, 1.3956,  &
0.9941, 0.9942, 0.9944, 0.9950, 0.9964, 0.9998, 1.0092, 1.0361, 1.1390,  &
0.9918, 0.9918, 0.9919, 0.9922, 0.9928, 0.9944, 0.9985, 1.0107, 1.0505,  &
0.9907, 0.9907, 0.9907, 0.9908, 0.9910, 0.9916, 0.9931, 0.9975, 1.0115 /
data ((supersat( 9,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0005, 1.0032, 1.0124, 1.0348, 1.0893, 1.2345, 1.7597, 3.5813,  &
1.0000, 1.0002, 1.0006, 1.0035, 1.0161, 1.0474, 1.1263, 1.3549, 2.4259,  &
0.9995, 0.9997, 1.0000, 1.0008, 1.0037, 1.0201, 1.0632, 1.1787, 1.5688,  &
0.9984, 0.9985, 0.9988, 0.9994, 1.0008, 1.0044, 1.0241, 1.0816, 1.2531,  &
0.9961, 0.9962, 0.9963, 0.9967, 0.9978, 1.0001, 1.0061, 1.0275, 1.1013,  &
0.9933, 0.9933, 0.9934, 0.9936, 0.9941, 0.9954, 0.9987, 1.0075, 1.0350,  &
0.9913, 0.9914, 0.9914, 0.9915, 0.9917, 0.9922, 0.9936, 0.9972, 1.0082 /
data ((supersat( 9,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0024, 1.0091, 1.0255, 1.0647, 1.1643, 1.4631, 2.6733,  &
1.0000, 1.0001, 1.0004, 1.0025, 1.0116, 1.0345, 1.0903, 1.2386, 1.7574,  &
0.9998, 0.9999, 1.0001, 1.0006, 1.0026, 1.0146, 1.0459, 1.1257, 1.3559,  &
0.9991, 0.9992, 0.9994, 0.9998, 1.0006, 1.0028, 1.0176, 1.0595, 1.1738,  &
0.9975, 0.9976, 0.9977, 0.9980, 0.9987, 1.0002, 1.0039, 1.0202, 1.0742,  &
0.9949, 0.9949, 0.9950, 0.9951, 0.9955, 0.9965, 0.9989, 1.0049, 1.0223,  &
0.9923, 0.9923, 0.9924, 0.9924, 0.9926, 0.9931, 0.9942, 0.9971, 1.0052 /
data ((supersat( 9,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0018, 1.0068, 1.0194, 1.0493, 1.1230, 1.3250, 2.0656,  &
1.0000, 1.0001, 1.0003, 1.0018, 1.0086, 1.0259, 1.0677, 1.1738, 1.4880,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0019, 1.0106, 1.0343, 1.0928, 1.2488,  &
0.9995, 0.9995, 0.9996, 0.9999, 1.0004, 1.0020, 1.0127, 1.0442, 1.1259,  &
0.9983, 0.9984, 0.9985, 0.9986, 0.9991, 1.0001, 1.0025, 1.0145, 1.0550,  &
0.9961, 0.9961, 0.9962, 0.9963, 0.9966, 0.9973, 0.9990, 1.0030, 1.0159,  &
0.9933, 0.9933, 0.9933, 0.9934, 0.9935, 0.9939, 0.9948, 0.9971, 1.0028 /
data ((supersat( 9,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0014, 1.0053, 1.0153, 1.0392, 1.0974, 1.2493, 1.7241,  &
1.0000, 1.0001, 1.0003, 1.0014, 1.0066, 1.0203, 1.0532, 1.1349, 1.3585,  &
0.9999, 1.0000, 1.0001, 1.0003, 1.0014, 1.0080, 1.0265, 1.0719, 1.1881,  &
0.9996, 0.9996, 0.9997, 0.9999, 1.0003, 1.0014, 1.0093, 1.0338, 1.0959,  &
0.9987, 0.9988, 0.9988, 0.9990, 0.9993, 1.0001, 1.0017, 1.0104, 1.0417,  &
0.9968, 0.9968, 0.9968, 0.9969, 0.9972, 0.9977, 0.9990, 1.0018, 1.0112,  &
0.9940, 0.9940, 0.9940, 0.9941, 0.9942, 0.9945, 0.9953, 0.9970, 1.0012 /
data ((supersat( 9,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0011, 1.0043, 1.0126, 1.0325, 1.0806, 1.2030, 1.5544,  &
1.0000, 1.0001, 1.0002, 1.0011, 1.0052, 1.0164, 1.0436, 1.1101, 1.2847,  &
0.9999, 1.0000, 1.0001, 1.0002, 1.0011, 1.0061, 1.0212, 1.0581, 1.1507,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0002, 1.0011, 1.0069, 1.0267, 1.0765,  &
0.9989, 0.9989, 0.9990, 0.9991, 0.9994, 1.0000, 1.0013, 1.0075, 1.0326,  &
0.9972, 0.9972, 0.9972, 0.9973, 0.9975, 0.9979, 0.9989, 1.0011, 1.0078,  &
0.9944, 0.9945, 0.9945, 0.9945, 0.9946, 0.9949, 0.9955, 0.9969, 1.0002 /
data ((supersat( 9,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0009, 1.0036, 1.0106, 1.0276, 1.0687, 1.1718, 1.4547,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0043, 1.0137, 1.0368, 1.0930, 1.2374,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0009, 1.0049, 1.0175, 1.0486, 1.1258,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0002, 1.0009, 1.0053, 1.0218, 1.0633,  &
0.9990, 0.9990, 0.9991, 0.9992, 0.9994, 0.9999, 1.0010, 1.0055, 1.0263,  &
0.9974, 0.9974, 0.9974, 0.9975, 0.9976, 0.9980, 0.9989, 1.0007, 1.0057,  &
0.9947, 0.9947, 0.9947, 0.9947, 0.9948, 0.9950, 0.9956, 0.9968, 0.9996 /
data ((supersat( 9,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0036, 1.0161, 1.0473, 1.1261, 1.3575, 2.5468, 4.7211,  &
0.9997, 1.0001, 1.0008, 1.0038, 1.0203, 1.0633, 1.1790, 1.5768, 3.5169,  &
0.9986, 0.9988, 0.9995, 1.0009, 1.0040, 1.0244, 1.0821, 1.2545, 2.0882,  &
0.9963, 0.9964, 0.9969, 0.9979, 1.0002, 1.0062, 1.0280, 1.1024, 1.3674,  &
0.9934, 0.9935, 0.9937, 0.9943, 0.9956, 0.9988, 1.0077, 1.0307, 1.1232,  &
0.9914, 0.9914, 0.9915, 0.9917, 0.9923, 0.9937, 0.9974, 1.0084, 1.0441,  &
0.9900, 0.9900, 0.9905, 0.9906, 0.9908, 0.9913, 0.9926, 0.9965, 1.0087 /
data ((supersat( 9,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0027, 1.0116, 1.0337, 1.0876, 1.2318, 1.7542, 3.5643,  &
0.9999, 1.0001, 1.0006, 1.0028, 1.0147, 1.0453, 1.1228, 1.3484, 2.4058,  &
0.9993, 0.9995, 0.9999, 1.0007, 1.0029, 1.0180, 1.0593, 1.1716, 1.5527,  &
0.9979, 0.9980, 0.9983, 0.9990, 1.0004, 1.0040, 1.0210, 1.0751, 1.2385,  &
0.9954, 0.9954, 0.9956, 0.9960, 0.9970, 0.9993, 1.0052, 1.0234, 1.0910,  &
0.9927, 0.9927, 0.9928, 0.9930, 0.9935, 0.9947, 0.9976, 1.0059, 1.0314,  &
0.9910, 0.9910, 0.9911, 0.9911, 0.9913, 0.9918, 0.9930, 0.9962, 1.0060 /
data ((supersat( 9,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0020, 1.0085, 1.0247, 1.0637, 1.1627, 1.4603, 2.6649,  &
1.0000, 1.0001, 1.0004, 1.0020, 1.0107, 1.0331, 1.0882, 1.2351, 1.7501,  &
0.9997, 0.9998, 1.0000, 1.0005, 1.0021, 1.0131, 1.0434, 1.1214, 1.3477,  &
0.9988, 0.9989, 0.9991, 0.9995, 1.0004, 1.0026, 1.0153, 1.0552, 1.1653,  &
0.9969, 0.9970, 0.9971, 0.9974, 0.9981, 0.9997, 1.0034, 1.0172, 1.0674,  &
0.9942, 0.9942, 0.9942, 0.9944, 0.9948, 0.9957, 0.9980, 1.0038, 1.0186,  &
0.9918, 0.9918, 0.9919, 0.9919, 0.9921, 0.9925, 0.9936, 0.9962, 1.0036 /
data ((supersat( 9,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0015, 1.0064, 1.0188, 1.0485, 1.1220, 1.3234, 2.0619,  &
1.0000, 1.0001, 1.0003, 1.0015, 1.0079, 1.0249, 1.0663, 1.1716, 1.4840,  &
0.9998, 0.9999, 1.0000, 1.0004, 1.0015, 1.0095, 1.0325, 1.0900, 1.2440,  &
0.9993, 0.9993, 0.9994, 0.9997, 1.0003, 1.0018, 1.0110, 1.0412, 1.1205,  &
0.9979, 0.9979, 0.9980, 0.9982, 0.9987, 0.9998, 1.0022, 1.0123, 1.0502,  &
0.9954, 0.9954, 0.9954, 0.9955, 0.9958, 0.9966, 0.9983, 1.0022, 1.0132,  &
0.9927, 0.9927, 0.9927, 0.9928, 0.9929, 0.9933, 0.9941, 0.9962, 1.0016 /
data ((supersat( 9,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0011, 1.0050, 1.0149, 1.0387, 1.0967, 1.2483, 1.7222,  &
1.0000, 1.0001, 1.0002, 1.0011, 1.0060, 1.0195, 1.0522, 1.1334, 1.3560,  &
0.9999, 0.9999, 1.0000, 1.0003, 1.0012, 1.0071, 1.0252, 1.0699, 1.1849,  &
0.9995, 0.9995, 0.9996, 0.9998, 1.0002, 1.0013, 1.0080, 1.0316, 1.0922,  &
0.9984, 0.9984, 0.9984, 0.9986, 0.9990, 0.9998, 1.0015, 1.0086, 1.0382,  &
0.9961, 0.9962, 0.9962, 0.9963, 0.9965, 0.9971, 0.9983, 1.0012, 1.0091,  &
0.9933, 0.9934, 0.9934, 0.9934, 0.9935, 0.9938, 0.9945, 0.9962, 1.0002 /
data ((supersat( 9,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0009, 1.0040, 1.0122, 1.0320, 1.0801, 1.2022, 1.5531,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0048, 1.0158, 1.0428, 1.1090, 1.2830,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0009, 1.0054, 1.0201, 1.0566, 1.1483,  &
0.9995, 0.9996, 0.9996, 0.9998, 1.0002, 1.0010, 1.0059, 1.0250, 1.0737,  &
0.9986, 0.9986, 0.9987, 0.9988, 0.9991, 0.9997, 1.0011, 1.0061, 1.0299,  &
0.9966, 0.9966, 0.9966, 0.9967, 0.9968, 0.9973, 0.9983, 1.0006, 1.0064,  &
0.9938, 0.9938, 0.9938, 0.9938, 0.9939, 0.9941, 0.9947, 0.9961, 0.9993 /
data ((supersat( 9,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0000, 1.0002, 1.0007, 1.0033, 1.0103, 1.0273, 1.0683, 1.1712, 1.4537,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0039, 1.0132, 1.0361, 1.0921, 1.2360,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0043, 1.0166, 1.0473, 1.1239,  &
0.9996, 0.9996, 0.9997, 0.9998, 1.0001, 1.0008, 1.0045, 1.0203, 1.0611,  &
0.9987, 0.9987, 0.9988, 0.9989, 0.9991, 0.9997, 1.0008, 1.0046, 1.0241,  &
0.9968, 0.9968, 0.9968, 0.9969, 0.9970, 0.9974, 0.9983, 1.0002, 1.0049,  &
0.9940, 0.9940, 0.9940, 0.9940, 0.9941, 0.9943, 0.9948, 0.9960, 0.9987 /
data ((supersat( 9,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0030, 1.0151, 1.0458, 1.1236, 1.3528, 2.5314, 4.6960,  &
0.9996, 1.0000, 1.0008, 1.0031, 1.0187, 1.0604, 1.1737, 1.5649, 3.4727,  &
0.9982, 0.9985, 0.9992, 1.0006, 1.0042, 1.0221, 1.0771, 1.2436, 2.0516,  &
0.9957, 0.9959, 0.9963, 0.9973, 0.9997, 1.0056, 1.0248, 1.0945, 1.3454,  &
0.9929, 0.9930, 0.9932, 0.9937, 0.9950, 0.9980, 1.0065, 1.0327, 1.1238,  &
0.9912, 0.9912, 0.9913, 0.9915, 0.9920, 0.9932, 0.9966, 1.0067, 1.0394,  &
0.9900, 0.9900, 0.9900, 0.9905, 0.9907, 0.9911, 0.9923, 0.9958, 1.0068 /
data ((supersat( 9,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0023, 1.0109, 1.0327, 1.0861, 1.2294, 1.7494, 3.5497,  &
0.9999, 1.0001, 1.0005, 1.0023, 1.0136, 1.0435, 1.1199, 1.3429, 2.3886,  &
0.9992, 0.9993, 0.9997, 1.0006, 1.0025, 1.0163, 1.0563, 1.1656, 1.5392,  &
0.9975, 0.9976, 0.9979, 0.9986, 1.0001, 1.0037, 1.0187, 1.0700, 1.2268,  &
0.9948, 0.9949, 0.9950, 0.9954, 0.9964, 0.9987, 1.0045, 1.0205, 1.0833,  &
0.9923, 0.9923, 0.9923, 0.9925, 0.9930, 0.9941, 0.9969, 1.0046, 1.0286,  &
0.9900, 0.9900, 0.9909, 0.9909, 0.9911, 0.9915, 0.9926, 0.9956, 1.0044 /
data ((supersat( 9,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0017, 1.0080, 1.0240, 1.0628, 1.1613, 1.4580, 2.6577,  &
1.0000, 1.0001, 1.0004, 1.0017, 1.0099, 1.0319, 1.0864, 1.2321, 1.7438,  &
0.9996, 0.9997, 0.9999, 1.0004, 1.0018, 1.0119, 1.0414, 1.1179, 1.3409,  &
0.9986, 0.9986, 0.9988, 0.9993, 1.0002, 1.0025, 1.0136, 1.0518, 1.1585,  &
0.9964, 0.9965, 0.9966, 0.9969, 0.9976, 0.9992, 1.0030, 1.0150, 1.0621,  &
0.9936, 0.9936, 0.9937, 0.9938, 0.9942, 0.9951, 0.9973, 1.0029, 1.0193,  &
0.9915, 0.9915, 0.9915, 0.9916, 0.9917, 0.9921, 0.9931, 0.9955, 1.0024 /
data ((supersat( 9,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0013, 1.0060, 1.0183, 1.0479, 1.1211, 1.3220, 2.0586,  &
1.0000, 1.0001, 1.0003, 1.0013, 1.0073, 1.0241, 1.0651, 1.1697, 1.4806,  &
0.9998, 0.9998, 1.0000, 1.0003, 1.0013, 1.0086, 1.0311, 1.0877, 1.2399,  &
0.9991, 0.9991, 0.9993, 0.9996, 1.0002, 1.0017, 1.0098, 1.0389, 1.1161,  &
0.9975, 0.9975, 0.9976, 0.9978, 0.9983, 0.9994, 1.0019, 1.0106, 1.0466,  &
0.9948, 0.9948, 0.9949, 0.9950, 0.9953, 0.9960, 0.9976, 1.0016, 1.0125,  &
0.9923, 0.9923, 0.9923, 0.9923, 0.9925, 0.9928, 0.9936, 0.9956, 1.0006 /
data ((supersat( 9,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0010, 1.0047, 1.0145, 1.0382, 1.0961, 1.2474, 1.7205,  &
1.0000, 1.0001, 1.0002, 1.0010, 1.0056, 1.0189, 1.0513, 1.1322, 1.3538,  &
0.9998, 0.9999, 1.0000, 1.0002, 1.0010, 1.0064, 1.0241, 1.0682, 1.1821,  &
0.9993, 0.9994, 0.9994, 0.9997, 1.0001, 1.0012, 1.0070, 1.0298, 1.0891,  &
0.9980, 0.9980, 0.9981, 0.9983, 0.9986, 0.9995, 1.0013, 1.0074, 1.0355,  &
0.9956, 0.9956, 0.9956, 0.9957, 0.9959, 0.9965, 0.9978, 1.0007, 1.0083,  &
0.9929, 0.9929, 0.9929, 0.9929, 0.9930, 0.9933, 0.9940, 0.9955, 0.9994 /
data ((supersat( 9,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0008, 1.0038, 1.0119, 1.0317, 1.0796, 1.2016, 1.5519,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0044, 1.0153, 1.0421, 1.1080, 1.2814,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0008, 1.0048, 1.0193, 1.0553, 1.1463,  &
0.9994, 0.9995, 0.9995, 0.9997, 1.0001, 1.0009, 1.0051, 1.0236, 1.0714,  &
0.9983, 0.9983, 0.9984, 0.9985, 0.9988, 0.9995, 1.0009, 1.0053, 1.0278,  &
0.9960, 0.9960, 0.9961, 0.9961, 0.9963, 0.9968, 0.9978, 1.0002, 1.0059,  &
0.9933, 0.9932, 0.9933, 0.9933, 0.9934, 0.9936, 0.9942, 0.9955, 0.9986 /
data ((supersat( 9,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0000, 1.0001, 1.0006, 1.0031, 1.0101, 1.0270, 1.0679, 1.1706, 1.4528,  &
1.0000, 1.0000, 1.0001, 1.0006, 1.0035, 1.0127, 1.0355, 1.0913, 1.2348,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0038, 1.0159, 1.0463, 1.1223,  &
0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0007, 1.0039, 1.0192, 1.0592,  &
0.9984, 0.9984, 0.9985, 0.9986, 0.9988, 0.9994, 1.0006, 1.0040, 1.0223,  &
0.9963, 0.9963, 0.9963, 0.9963, 0.9965, 0.9969, 0.9978, 0.9998, 1.0044,  &
0.9935, 0.9935, 0.9935, 0.9935, 0.9936, 0.9938, 0.9943, 0.9954, 0.9981 /

nucvalue1 = wtw1*(wtcon1*(jrg1*cldnuctab(rgccn1  ,jw  ,jconcen  ,jtemp,epstab )   &
                        + jrg2*cldnuctab(rgccn1+1,jw  ,jconcen  ,jtemp,epstab))   &
                + wtcon2*(jrg1*cldnuctab(rgccn1  ,jw  ,jconcen+1,jtemp,epstab )   &
                        + jrg2*cldnuctab(rgccn1+1,jw  ,jconcen+1,jtemp,epstab)))  &
           +wtw2*(wtcon1*(jrg1*cldnuctab(rgccn1  ,jw+1,jconcen  ,jtemp,epstab )   &
                        + jrg2*cldnuctab(rgccn1+1,jw+1,jconcen  ,jtemp,epstab))   &
                + wtcon2*(jrg1*cldnuctab(rgccn1  ,jw+1,jconcen+1,jtemp,epstab )   &
                        + jrg2*cldnuctab(rgccn1+1,jw+1,jconcen+1,jtemp,epstab)))

nucvalue2 = wtw1*(wtcon1*(jrg1*cldnuctab(rgccn1  ,jw  ,jconcen  ,jtemp,epstab+1 )   &
                        + jrg2*cldnuctab(rgccn1+1,jw  ,jconcen  ,jtemp,epstab+1))   &
                + wtcon2*(jrg1*cldnuctab(rgccn1  ,jw  ,jconcen+1,jtemp,epstab+1 )   &
                        + jrg2*cldnuctab(rgccn1+1,jw  ,jconcen+1,jtemp,epstab+1)))  &
           +wtw2*(wtcon1*(jrg1*cldnuctab(rgccn1  ,jw+1,jconcen  ,jtemp,epstab+1 )   &
                        + jrg2*cldnuctab(rgccn1+1,jw+1,jconcen  ,jtemp,epstab+1))   &
                + wtcon2*(jrg1*cldnuctab(rgccn1  ,jw+1,jconcen+1,jtemp,epstab+1 )   &
                        + jrg2*cldnuctab(rgccn1+1,jw+1,jconcen+1,jtemp,epstab+1)))

nucvalue = eps1 * nucvalue1 + eps2 * nucvalue2

supsatpcnt = rrv / (1.0001 * rrvlsair)
nucss=0.0
!Saleeby(2011): Supersaturation tables are essentially the inverse of the W
!tables above. These could be used in situations where W is small but super-
!saturation still exists. These should be further tested in regions of non-W
!super-saturation to be sure how viable they are.
!TURNED OFF FOR NOW
do ss=1,8
  !print*,'TEST FOR SUPER-SATURATION TABLES - THEY ARE TURNED ON',ss
  ssvalue11 = wtcon1*(jrg1*supersat(rgccn1  ,ss,jconcen  ,jtemp,epstab ) &
                    + jrg2*supersat(rgccn1+1,ss,jconcen  ,jtemp,epstab)) &
            + wtcon2*(jrg1*supersat(rgccn1  ,ss,jconcen+1,jtemp,epstab ) &
                    + jrg2*supersat(rgccn1+1,ss,jconcen+1,jtemp,epstab))
  ssvalue12 = wtcon1*(jrg1*supersat(rgccn1  ,ss,jconcen  ,jtemp,epstab+1 ) &
                    + jrg2*supersat(rgccn1+1,ss,jconcen  ,jtemp,epstab+1)) &
            + wtcon2*(jrg1*supersat(rgccn1  ,ss,jconcen+1,jtemp,epstab+1 ) &
                    + jrg2*supersat(rgccn1+1,ss,jconcen+1,jtemp,epstab+1))
  ssvalue1  = eps1 * ssvalue11 + eps2 * ssvalue12

  ssvalue21 = wtcon1*(jrg1*supersat(rgccn1  ,ss+1,jconcen  ,jtemp,epstab ) &
                    + jrg2*supersat(rgccn1+1,ss+1,jconcen  ,jtemp,epstab)) &
            + wtcon2*(jrg1*supersat(rgccn1  ,ss+1,jconcen+1,jtemp,epstab ) &
                    + jrg2*supersat(rgccn1+1,ss+1,jconcen+1,jtemp,epstab))
  ssvalue22 = wtcon1*(jrg1*supersat(rgccn1  ,ss+1,jconcen  ,jtemp,epstab+1 ) &
                    + jrg2*supersat(rgccn1+1,ss+1,jconcen  ,jtemp,epstab+1)) &
            + wtcon2*(jrg1*supersat(rgccn1  ,ss+1,jconcen+1,jtemp,epstab+1 ) &
                    + jrg2*supersat(rgccn1+1,ss+1,jconcen+1,jtemp,epstab+1))
  ssvalue2  = eps1 * ssvalue21 + eps2 * ssvalue22

  if((supsatpcnt>=ssvalue1.and.supsatpcnt<=ssvalue2).or. &
     (supsatpcnt>ssvalue2).and.ss==8) then
     mult1=(ssvalue2-supsatpcnt)/(ssvalue2-ssvalue1)
     mult2=(supsatpcnt-ssvalue1)/(ssvalue2-ssvalue1)

     if(ssvalue1==ssvalue2 .or. ssvalue1>ssvalue2 .or. supsatpcnt>ssvalue2) then
        mult1=0.0
        mult2=1.0
     endif

     nucss1 =mult1*(wtcon1*(jrg1*cldnuctab(rgccn1  ,ss  ,jconcen  ,jtemp,epstab ) &
                          + jrg2*cldnuctab(rgccn1+1,ss  ,jconcen  ,jtemp,epstab))   &
                  + wtcon2*(jrg1*cldnuctab(rgccn1  ,ss  ,jconcen+1,jtemp,epstab )   &
                          + jrg2*cldnuctab(rgccn1+1,ss  ,jconcen+1,jtemp,epstab)))  &
            +mult2*(wtcon1*(jrg1*cldnuctab(rgccn1  ,ss+1,jconcen  ,jtemp,epstab )   &
                          + jrg2*cldnuctab(rgccn1+1,ss+1,jconcen  ,jtemp,epstab))   &
                  + wtcon2*(jrg1*cldnuctab(rgccn1  ,ss+1,jconcen+1,jtemp,epstab )   &
                          + jrg2*cldnuctab(rgccn1+1,ss+1,jconcen+1,jtemp,epstab)))
     nucss2 =mult1*(wtcon1*(jrg1*cldnuctab(rgccn1  ,ss  ,jconcen  ,jtemp,epstab+1 ) &
                          + jrg2*cldnuctab(rgccn1+1,ss  ,jconcen  ,jtemp,epstab+1))   &
                  + wtcon2*(jrg1*cldnuctab(rgccn1  ,ss  ,jconcen+1,jtemp,epstab+1 )   &
                          + jrg2*cldnuctab(rgccn1+1,ss  ,jconcen+1,jtemp,epstab+1)))  &
            +mult2*(wtcon1*(jrg1*cldnuctab(rgccn1  ,ss+1,jconcen  ,jtemp,epstab+1 )   &
                          + jrg2*cldnuctab(rgccn1+1,ss+1,jconcen  ,jtemp,epstab+1))   &
                  + wtcon2*(jrg1*cldnuctab(rgccn1  ,ss+1,jconcen+1,jtemp,epstab+1 )   &
                          + jrg2*cldnuctab(rgccn1+1,ss+1,jconcen+1,jtemp,epstab+1)))
     nucss = eps1 * nucss1 + eps2 * nucss2
     go to 102
  endif
enddo
102  continue
tabvalue=min(nucvalue,nucss)
if(tabvalue < 0.0 .or. tabvalue > 1.0)then
  print*,'Nucleation fraction unreal',tabvalue
  stop
endif

return
END SUBROUTINE aero_nuc_tab_nh42so4

!##############################################################################
Subroutine aero_nuc_tab_nacl (rrv,rrvlsair,eps1,eps2,wtw1,wtw2,wtcon1,wtcon2 &
                    ,jrg1,jrg2,epstab,jw,jconcen,jtemp,rgccn1,tabvalue)

implicit none

integer :: iw,iconc
integer :: epstab,jw,jconcen,jtemp,rgccn1,ss
real :: eps1,eps2,wtw1,wtw2,wtcon1,wtcon2,jrg1,jrg2
real :: tabvalue,nucvalue,nucvalue1,nucvalue2,ssvalue1,ssvalue2
real, dimension(9,9,7,7,7) :: cldnuctab,supersat
real :: supsatpcnt,ssvalue11,ssvalue12,ssvalue21,ssvalue22
real :: mult1,mult2,nucss1,nucss2,nucss,rrv,rrvlsair

!Saleeby (6/3/02)
!The following tables are percent of prescibed CCN to activate.
!Table dimensions are:
! (median radius,updraft,concentration,temperature,solubility).
!Large aerosols or GCCN number are prescibed by the user and these
!automatically nucleate and they have no lookup tables.
!Small aerosols or CCN with median radius from 0.01 - 0.96 microns
!are user prescribed in concentration from 1 - 10,000 /mg.
!Median radius is in centimeters as is the parcel model.

!cldnuctab(a,b,c,d,e) as produced in parcel model
!a = 1-9 median radius of aerosol dist (.01,.02,.04,.08,.16,.32,.48,.64,.96 microns)
!b = 1-9 vertical velocity (1 - 10,000 cm/s)
!c = 1-7 aerosol concentration (10 - 10,000 /mg)
!d = 1-7 air temperature (-30 to 30 C)
!e = 1-7 epsilon solubility fraction (0.05, 0.1, 0.2, 0.4, 0.6, 0.8, 1.0)

!Input W (m/s), rg (m), concentration (/mg), T (C)

data ((cldnuctab( 1,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.0267, 0.0692, 0.1707, 0.3674, 0.6388, 0.8873, 0.9907, 0.9979, 0.9979,  &
0.0148, 0.0421, 0.1158, 0.2661, 0.4951, 0.7774, 0.9593, 0.9979, 0.9979,  &
0.0097, 0.0267, 0.0748, 0.1813, 0.3829, 0.6540, 0.8950, 0.9907, 0.9979,  &
0.0055, 0.0181, 0.0500, 0.1325, 0.2936, 0.5439, 0.8122, 0.9660, 0.9979,  &
0.0034, 0.0120, 0.0353, 0.0936, 0.2275, 0.4464, 0.7120, 0.9156, 0.9934,  &
0.0021, 0.0077, 0.0243, 0.0692, 0.1707, 0.3521, 0.5920, 0.8122, 0.9660,  &
0.0014, 0.0049, 0.0164, 0.0459, 0.1240, 0.2661, 0.4144, 0.5114, 0.7258 /
data ((cldnuctab( 1,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.0181, 0.0500, 0.1240, 0.2797, 0.5277, 0.8010, 0.9689, 0.9979, 0.9979,  &
0.0108, 0.0294, 0.0807, 0.1923, 0.3985, 0.6689, 0.9022, 0.9926, 0.9979,  &
0.0062, 0.0181, 0.0500, 0.1325, 0.2936, 0.5439, 0.8010, 0.9660, 0.9979,  &
0.0034, 0.0108, 0.0322, 0.0870, 0.2154, 0.4303, 0.6980, 0.9156, 0.9934,  &
0.0021, 0.0069, 0.0221, 0.0589, 0.1508, 0.3223, 0.5920, 0.8434, 0.9742,  &
0.0012, 0.0043, 0.0148, 0.0421, 0.1080, 0.2529, 0.4789, 0.7392, 0.9275,  &
0.0007, 0.0026, 0.0097, 0.0294, 0.0807, 0.1923, 0.3829, 0.5920, 0.7894 /
data ((cldnuctab( 1,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.0133, 0.0385, 0.0936, 0.2154, 0.4303, 0.7120, 0.9330, 0.9967, 0.9979,  &
0.0077, 0.0221, 0.0589, 0.1415, 0.3078, 0.5601, 0.8334, 0.9766, 0.9979,  &
0.0038, 0.0120, 0.0353, 0.0936, 0.2154, 0.4303, 0.7120, 0.9217, 0.9947,  &
0.0023, 0.0069, 0.0221, 0.0589, 0.1508, 0.3223, 0.5761, 0.8434, 0.9766,  &
0.0014, 0.0043, 0.0133, 0.0385, 0.1080, 0.2400, 0.4626, 0.7392, 0.9330,  &
0.0007, 0.0026, 0.0087, 0.0267, 0.0748, 0.1813, 0.3674, 0.6388, 0.8709,  &
0.0004, 0.0016, 0.0055, 0.0181, 0.0500, 0.1325, 0.2936, 0.5277, 0.7523 /
data ((cldnuctab( 1,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.0108, 0.0294, 0.0807, 0.1813, 0.3674, 0.6388, 0.8950, 0.9907, 0.9979,  &
0.0055, 0.0164, 0.0459, 0.1158, 0.2529, 0.4951, 0.7651, 0.9517, 0.9979,  &
0.0030, 0.0097, 0.0267, 0.0692, 0.1707, 0.3521, 0.6234, 0.8709, 0.9842,  &
0.0016, 0.0055, 0.0164, 0.0459, 0.1158, 0.2529, 0.4789, 0.7523, 0.9474,  &
0.0009, 0.0030, 0.0097, 0.0294, 0.0748, 0.1813, 0.3674, 0.6388, 0.8793,  &
0.0005, 0.0018, 0.0055, 0.0181, 0.0500, 0.1325, 0.2797, 0.5277, 0.7894,  &
0.0003, 0.0011, 0.0034, 0.0120, 0.0353, 0.0936, 0.2154, 0.4303, 0.6836 /
data ((cldnuctab( 1,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.0097, 0.0267, 0.0692, 0.1606, 0.3371, 0.5920, 0.8530, 0.9826, 0.9979,  &
0.0049, 0.0133, 0.0385, 0.0936, 0.2154, 0.4303, 0.7120, 0.9217, 0.9947,  &
0.0026, 0.0077, 0.0221, 0.0589, 0.1415, 0.3078, 0.5439, 0.8122, 0.9689,  &
0.0014, 0.0043, 0.0120, 0.0353, 0.0870, 0.2036, 0.4144, 0.6836, 0.9091,  &
0.0007, 0.0023, 0.0069, 0.0200, 0.0589, 0.1415, 0.3078, 0.5439, 0.8122,  &
0.0004, 0.0012, 0.0043, 0.0133, 0.0385, 0.0936, 0.2154, 0.4303, 0.6980,  &
0.0002, 0.0007, 0.0023, 0.0077, 0.0243, 0.0639, 0.1606, 0.3371, 0.5920 /
data ((cldnuctab( 1,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.0087, 0.0221, 0.0589, 0.1415, 0.3078, 0.5601, 0.8230, 0.9717, 0.9979,  &
0.0043, 0.0120, 0.0322, 0.0870, 0.1923, 0.3985, 0.6689, 0.9022, 0.9907,  &
0.0021, 0.0069, 0.0181, 0.0500, 0.1240, 0.2661, 0.4951, 0.7774, 0.9517,  &
0.0011, 0.0034, 0.0108, 0.0294, 0.0748, 0.1707, 0.3674, 0.6234, 0.8709,  &
0.0006, 0.0018, 0.0055, 0.0164, 0.0459, 0.1158, 0.2529, 0.4789, 0.7523,  &
0.0003, 0.0011, 0.0030, 0.0097, 0.0294, 0.0748, 0.1813, 0.3674, 0.6234,  &
0.0002, 0.0005, 0.0018, 0.0062, 0.0181, 0.0500, 0.1240, 0.2661, 0.5114 /
data ((cldnuctab( 1,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.0077, 0.0221, 0.0543, 0.1325, 0.2797, 0.5277, 0.8010, 0.9628, 0.9979,  &
0.0038, 0.0108, 0.0294, 0.0748, 0.1813, 0.3674, 0.6234, 0.8793, 0.9858,  &
0.0021, 0.0062, 0.0164, 0.0459, 0.1080, 0.2400, 0.4626, 0.7392, 0.9381,  &
0.0009, 0.0030, 0.0087, 0.0243, 0.0639, 0.1508, 0.3223, 0.5761, 0.8334,  &
0.0005, 0.0016, 0.0049, 0.0148, 0.0385, 0.1006, 0.2275, 0.4303, 0.6980,  &
0.0002, 0.0009, 0.0026, 0.0077, 0.0243, 0.0639, 0.1508, 0.3223, 0.5601,  &
0.0001, 0.0005, 0.0016, 0.0049, 0.0148, 0.0421, 0.1006, 0.2275, 0.4464 /
data ((cldnuctab( 1,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.0385, 0.1006, 0.2275, 0.4464, 0.7120, 0.9217, 0.9941, 0.9979, 0.9979,  &
0.0243, 0.0639, 0.1606, 0.3371, 0.5920, 0.8334, 0.9717, 0.9979, 0.9979,  &
0.0148, 0.0459, 0.1158, 0.2529, 0.4789, 0.7392, 0.9275, 0.9941, 0.9979,  &
0.0097, 0.0294, 0.0807, 0.1923, 0.3829, 0.6388, 0.8622, 0.9787, 0.9979,  &
0.0062, 0.0200, 0.0543, 0.1415, 0.2936, 0.5277, 0.7894, 0.9429, 0.9958,  &
0.0043, 0.0133, 0.0385, 0.1006, 0.2275, 0.4464, 0.6689, 0.8622, 0.9766,  &
0.0023, 0.0087, 0.0267, 0.0748, 0.1707, 0.3078, 0.4464, 0.5601, 0.7651 /
data ((cldnuctab( 1,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.0267, 0.0748, 0.1707, 0.3521, 0.6078, 0.8530, 0.9787, 0.9979, 0.9979,  &
0.0164, 0.0459, 0.1158, 0.2529, 0.4789, 0.7392, 0.9330, 0.9953, 0.9979,  &
0.0097, 0.0294, 0.0748, 0.1813, 0.3674, 0.6234, 0.8622, 0.9787, 0.9979,  &
0.0062, 0.0181, 0.0500, 0.1325, 0.2797, 0.5114, 0.7651, 0.9429, 0.9958,  &
0.0038, 0.0133, 0.0353, 0.0936, 0.2154, 0.4144, 0.6689, 0.8873, 0.9842,  &
0.0023, 0.0077, 0.0243, 0.0692, 0.1606, 0.3371, 0.5761, 0.8010, 0.9517,  &
0.0014, 0.0049, 0.0164, 0.0459, 0.1158, 0.2661, 0.4626, 0.6540, 0.8434 /
data ((cldnuctab( 1,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.0200, 0.0543, 0.1325, 0.2797, 0.5277, 0.7894, 0.9556, 0.9979, 0.9979,  &
0.0120, 0.0322, 0.0870, 0.1923, 0.3829, 0.6540, 0.8793, 0.9858, 0.9979,  &
0.0069, 0.0200, 0.0543, 0.1325, 0.2797, 0.5277, 0.7774, 0.9474, 0.9971,  &
0.0038, 0.0120, 0.0353, 0.0936, 0.2036, 0.4144, 0.6689, 0.8873, 0.9842,  &
0.0023, 0.0077, 0.0221, 0.0639, 0.1508, 0.3223, 0.5601, 0.8010, 0.9556,  &
0.0014, 0.0049, 0.0148, 0.0421, 0.1080, 0.2400, 0.4626, 0.7120, 0.9091,  &
0.0008, 0.0030, 0.0097, 0.0294, 0.0807, 0.1923, 0.3674, 0.6078, 0.8122 /
data ((cldnuctab( 1,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.0164, 0.0459, 0.1080, 0.2400, 0.4626, 0.7258, 0.9275, 0.9941, 0.9979,  &
0.0087, 0.0267, 0.0692, 0.1606, 0.3223, 0.5761, 0.8230, 0.9689, 0.9979,  &
0.0049, 0.0148, 0.0421, 0.1006, 0.2275, 0.4464, 0.6980, 0.9091, 0.9907,  &
0.0030, 0.0087, 0.0243, 0.0692, 0.1606, 0.3371, 0.5761, 0.8230, 0.9660,  &
0.0016, 0.0055, 0.0164, 0.0459, 0.1158, 0.2400, 0.4626, 0.7120, 0.9156,  &
0.0009, 0.0034, 0.0097, 0.0294, 0.0807, 0.1813, 0.3674, 0.6078, 0.8434,  &
0.0005, 0.0021, 0.0062, 0.0200, 0.0543, 0.1325, 0.2936, 0.5114, 0.7523 /
data ((cldnuctab( 1,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.0148, 0.0385, 0.0936, 0.2036, 0.4144, 0.6689, 0.8950, 0.9896, 0.9979,  &
0.0077, 0.0221, 0.0543, 0.1325, 0.2797, 0.5114, 0.7774, 0.9517, 0.9971,  &
0.0038, 0.0120, 0.0322, 0.0870, 0.1923, 0.3829, 0.6388, 0.8709, 0.9807,  &
0.0023, 0.0069, 0.0200, 0.0543, 0.1240, 0.2797, 0.4951, 0.7523, 0.9381,  &
0.0012, 0.0038, 0.0120, 0.0322, 0.0870, 0.1923, 0.3829, 0.6388, 0.8622,  &
0.0007, 0.0023, 0.0069, 0.0221, 0.0589, 0.1415, 0.2936, 0.5277, 0.7774,  &
0.0004, 0.0014, 0.0043, 0.0133, 0.0385, 0.1006, 0.2275, 0.4303, 0.6689 /
data ((cldnuctab( 1,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.0120, 0.0353, 0.0870, 0.1923, 0.3829, 0.6388, 0.8709, 0.9842, 0.9979,  &
0.0069, 0.0181, 0.0500, 0.1158, 0.2529, 0.4789, 0.7392, 0.9330, 0.9947,  &
0.0034, 0.0108, 0.0294, 0.0748, 0.1707, 0.3371, 0.5920, 0.8334, 0.9717,  &
0.0018, 0.0055, 0.0164, 0.0459, 0.1080, 0.2400, 0.4464, 0.6980, 0.9091,  &
0.0011, 0.0030, 0.0097, 0.0267, 0.0692, 0.1606, 0.3371, 0.5761, 0.8122,  &
0.0005, 0.0018, 0.0055, 0.0164, 0.0459, 0.1158, 0.2400, 0.4464, 0.7120,  &
0.0003, 0.0011, 0.0034, 0.0108, 0.0294, 0.0748, 0.1813, 0.3521, 0.5920 /
data ((cldnuctab( 1,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.0120, 0.0322, 0.0807, 0.1813, 0.3521, 0.6078, 0.8530, 0.9787, 0.9979,  &
0.0062, 0.0164, 0.0459, 0.1080, 0.2400, 0.4464, 0.7120, 0.9156, 0.9926,  &
0.0030, 0.0097, 0.0243, 0.0639, 0.1508, 0.3078, 0.5439, 0.8010, 0.9593,  &
0.0016, 0.0049, 0.0148, 0.0385, 0.0936, 0.2154, 0.3985, 0.6689, 0.8873,  &
0.0008, 0.0026, 0.0077, 0.0221, 0.0589, 0.1415, 0.2936, 0.5277, 0.7774,  &
0.0005, 0.0016, 0.0049, 0.0133, 0.0385, 0.0936, 0.2036, 0.3985, 0.6540,  &
0.0002, 0.0008, 0.0026, 0.0087, 0.0243, 0.0639, 0.1508, 0.3078, 0.5277 /
data ((cldnuctab( 1,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.0639, 0.1508, 0.3078, 0.5439, 0.7894, 0.9517, 0.9971, 0.9979, 0.9979,  &
0.0385, 0.1006, 0.2275, 0.4303, 0.6836, 0.8873, 0.9842, 0.9979, 0.9979,  &
0.0267, 0.0692, 0.1707, 0.3371, 0.5761, 0.8122, 0.9556, 0.9971, 0.9979,  &
0.0181, 0.0500, 0.1240, 0.2661, 0.4789, 0.7258, 0.9156, 0.9885, 0.9979,  &
0.0120, 0.0353, 0.0870, 0.2036, 0.3985, 0.6388, 0.8530, 0.9660, 0.9979,  &
0.0069, 0.0221, 0.0639, 0.1508, 0.3223, 0.5439, 0.7523, 0.9091, 0.9872,  &
0.0038, 0.0133, 0.0385, 0.1006, 0.2154, 0.3521, 0.4789, 0.5761, 0.8010 /
data ((cldnuctab( 1,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.0421, 0.1080, 0.2400, 0.4464, 0.6980, 0.9022, 0.9885, 0.9979, 0.9979,  &
0.0267, 0.0692, 0.1606, 0.3371, 0.5761, 0.8122, 0.9593, 0.9977, 0.9979,  &
0.0164, 0.0459, 0.1158, 0.2529, 0.4626, 0.7120, 0.9091, 0.9885, 0.9979,  &
0.0108, 0.0322, 0.0807, 0.1923, 0.3674, 0.6078, 0.8434, 0.9660, 0.9979,  &
0.0069, 0.0221, 0.0589, 0.1415, 0.2936, 0.5114, 0.7651, 0.9275, 0.9907,  &
0.0043, 0.0133, 0.0385, 0.1006, 0.2275, 0.4303, 0.6689, 0.8709, 0.9717,  &
0.0023, 0.0087, 0.0267, 0.0748, 0.1707, 0.3371, 0.5439, 0.7258, 0.8873 /
data ((cldnuctab( 1,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.0322, 0.0807, 0.1813, 0.3674, 0.6234, 0.8530, 0.9742, 0.9979, 0.9979,  &
0.0200, 0.0500, 0.1240, 0.2661, 0.4789, 0.7392, 0.9275, 0.9926, 0.9979,  &
0.0120, 0.0322, 0.0870, 0.1923, 0.3829, 0.6234, 0.8530, 0.9717, 0.9979,  &
0.0069, 0.0200, 0.0543, 0.1415, 0.2936, 0.5114, 0.7523, 0.9275, 0.9917,  &
0.0043, 0.0133, 0.0385, 0.1006, 0.2154, 0.4144, 0.6540, 0.8709, 0.9766,  &
0.0026, 0.0087, 0.0267, 0.0692, 0.1606, 0.3371, 0.5601, 0.8010, 0.9429,  &
0.0016, 0.0055, 0.0164, 0.0500, 0.1240, 0.2661, 0.4789, 0.6980, 0.8709 /
data ((cldnuctab( 1,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.0243, 0.0639, 0.1508, 0.3078, 0.5601, 0.8010, 0.9556, 0.9971, 0.9979,  &
0.0148, 0.0385, 0.1006, 0.2154, 0.4144, 0.6689, 0.8873, 0.9842, 0.9979,  &
0.0087, 0.0243, 0.0639, 0.1508, 0.3078, 0.5439, 0.7894, 0.9474, 0.9953,  &
0.0049, 0.0148, 0.0421, 0.1006, 0.2275, 0.4303, 0.6689, 0.8793, 0.9807,  &
0.0030, 0.0097, 0.0267, 0.0692, 0.1707, 0.3371, 0.5601, 0.8010, 0.9475,  &
0.0018, 0.0055, 0.0181, 0.0500, 0.1240, 0.2529, 0.4626, 0.7120, 0.9022,  &
0.0011, 0.0038, 0.0120, 0.0322, 0.0870, 0.1923, 0.3829, 0.6234, 0.8230 /
data ((cldnuctab( 1,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.0221, 0.0543, 0.1325, 0.2797, 0.4951, 0.7651, 0.9381, 0.9947, 0.9979,  &
0.0120, 0.0322, 0.0807, 0.1813, 0.3674, 0.6078, 0.8530, 0.9717, 0.9979,  &
0.0069, 0.0200, 0.0500, 0.1240, 0.2661, 0.4789, 0.7258, 0.9156, 0.9907,  &
0.0038, 0.0120, 0.0322, 0.0807, 0.1813, 0.3674, 0.6078, 0.8334, 0.9660,  &
0.0023, 0.0069, 0.0200, 0.0543, 0.1325, 0.2661, 0.4951, 0.7258, 0.9156,  &
0.0014, 0.0043, 0.0133, 0.0353, 0.0936, 0.2036, 0.3829, 0.6234, 0.8434,  &
0.0008, 0.0026, 0.0077, 0.0243, 0.0639, 0.1508, 0.3078, 0.5277, 0.7651 /
data ((cldnuctab( 1,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.0200, 0.0500, 0.1158, 0.2529, 0.4626, 0.7258, 0.9217, 0.9917, 0.9979,  &
0.0108, 0.0294, 0.0748, 0.1606, 0.3371, 0.5761, 0.8230, 0.9628, 0.9974,  &
0.0055, 0.0164, 0.0421, 0.1080, 0.2275, 0.4303, 0.6836, 0.8950, 0.9842,  &
0.0030, 0.0097, 0.0267, 0.0692, 0.1508, 0.3078, 0.5439, 0.7894, 0.9474,  &
0.0018, 0.0055, 0.0164, 0.0421, 0.1080, 0.2275, 0.4303, 0.6689, 0.8793,  &
0.0011, 0.0034, 0.0097, 0.0294, 0.0748, 0.1606, 0.3223, 0.5601, 0.7894,  &
0.0006, 0.0021, 0.0055, 0.0181, 0.0500, 0.1158, 0.2529, 0.4626, 0.6980 /
data ((cldnuctab( 1,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.0181, 0.0459, 0.1080, 0.2400, 0.4464, 0.6980, 0.9091, 0.9885, 0.9979,  &
0.0097, 0.0267, 0.0639, 0.1508, 0.3078, 0.5439, 0.7894, 0.9517, 0.9963,  &
0.0049, 0.0148, 0.0385, 0.0936, 0.2036, 0.3985, 0.6540, 0.8709, 0.9787,  &
0.0026, 0.0077, 0.0221, 0.0589, 0.1325, 0.2797, 0.5114, 0.7523, 0.9330,  &
0.0016, 0.0049, 0.0133, 0.0353, 0.0870, 0.2036, 0.3829, 0.6234, 0.8530,  &
0.0008, 0.0026, 0.0087, 0.0221, 0.0589, 0.1415, 0.2797, 0.4951, 0.7392,  &
0.0005, 0.0016, 0.0049, 0.0148, 0.0385, 0.1006, 0.2154, 0.3985, 0.6388 /
data ((cldnuctab( 1,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.0936, 0.2154, 0.3985, 0.6540, 0.8622, 0.9742, 0.9979, 0.9979, 0.9979,  &
0.0639, 0.1508, 0.3078, 0.5439, 0.7774, 0.9381, 0.9926, 0.9979, 0.9979,  &
0.0459, 0.1080, 0.2400, 0.4464, 0.6836, 0.8793, 0.9787, 0.9979, 0.9979,  &
0.0294, 0.0807, 0.1813, 0.3521, 0.5920, 0.8122, 0.9517, 0.9947, 0.9979,  &
0.0200, 0.0543, 0.1325, 0.2797, 0.5114, 0.7392, 0.9091, 0.9826, 0.9979,  &
0.0108, 0.0353, 0.0936, 0.2154, 0.4144, 0.6388, 0.8230, 0.9429, 0.9941,  &
0.0049, 0.0181, 0.0543, 0.1415, 0.2529, 0.3829, 0.4789, 0.5761, 0.8334 /
data ((cldnuctab( 1,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.0692, 0.1606, 0.3223, 0.5439, 0.7894, 0.9474, 0.9953, 0.9979, 0.9979,  &
0.0459, 0.1080, 0.2400, 0.4303, 0.6836, 0.8873, 0.9807, 0.9979, 0.9979,  &
0.0294, 0.0748, 0.1707, 0.3371, 0.5761, 0.8122, 0.9475, 0.9947, 0.9979,  &
0.0181, 0.0543, 0.1240, 0.2661, 0.4789, 0.7258, 0.9022, 0.9826, 0.9979,  &
0.0120, 0.0353, 0.0936, 0.2036, 0.3985, 0.6388, 0.8434, 0.9628, 0.9958,  &
0.0069, 0.0221, 0.0639, 0.1508, 0.3223, 0.5439, 0.7651, 0.9217, 0.9858,  &
0.0034, 0.0120, 0.0385, 0.1006, 0.2275, 0.4144, 0.6234, 0.7894, 0.9330 /
data ((cldnuctab( 1,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.0500, 0.1240, 0.2529, 0.4626, 0.7258, 0.9091, 0.9885, 0.9979, 0.9979,  &
0.0322, 0.0807, 0.1813, 0.3521, 0.5920, 0.8230, 0.9593, 0.9967, 0.9979,  &
0.0200, 0.0543, 0.1240, 0.2661, 0.4789, 0.7258, 0.9091, 0.9858, 0.9979,  &
0.0120, 0.0353, 0.0936, 0.2036, 0.3829, 0.6234, 0.8434, 0.9628, 0.9967,  &
0.0077, 0.0243, 0.0639, 0.1508, 0.3078, 0.5277, 0.7651, 0.9217, 0.9885,  &
0.0049, 0.0148, 0.0421, 0.1080, 0.2400, 0.4464, 0.6836, 0.8709, 0.9689,  &
0.0026, 0.0087, 0.0267, 0.0748, 0.1813, 0.3521, 0.5761, 0.7774, 0.9156 /
data ((cldnuctab( 1,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.0385, 0.0936, 0.2154, 0.4144, 0.6540, 0.8709, 0.9787, 0.9979, 0.9979,  &
0.0243, 0.0639, 0.1415, 0.2936, 0.5277, 0.7651, 0.9330, 0.9926, 0.9979,  &
0.0148, 0.0385, 0.1006, 0.2154, 0.3985, 0.6540, 0.8622, 0.9717, 0.9979,  &
0.0087, 0.0243, 0.0692, 0.1508, 0.3078, 0.5439, 0.7774, 0.9330, 0.9907,  &
0.0055, 0.0164, 0.0459, 0.1080, 0.2400, 0.4303, 0.6836, 0.8709, 0.9742,  &
0.0034, 0.0108, 0.0294, 0.0807, 0.1813, 0.3521, 0.5761, 0.8010, 0.9429,  &
0.0018, 0.0062, 0.0181, 0.0543, 0.1325, 0.2797, 0.4951, 0.7258, 0.8873 /
data ((cldnuctab( 1,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.0322, 0.0807, 0.1813, 0.3674, 0.6078, 0.8434, 0.9689, 0.9977, 0.9979,  &
0.0200, 0.0500, 0.1240, 0.2529, 0.4626, 0.7120, 0.9091, 0.9872, 0.9979,  &
0.0120, 0.0322, 0.0807, 0.1813, 0.3521, 0.5920, 0.8122, 0.9556, 0.9958,  &
0.0069, 0.0200, 0.0500, 0.1240, 0.2529, 0.4626, 0.7120, 0.8950, 0.9826,  &
0.0038, 0.0120, 0.0353, 0.0870, 0.1923, 0.3674, 0.5920, 0.8230, 0.9556,  &
0.0026, 0.0077, 0.0221, 0.0589, 0.1415, 0.2797, 0.4951, 0.7392, 0.9091,  &
0.0014, 0.0043, 0.0133, 0.0385, 0.1006, 0.2154, 0.4144, 0.6388, 0.8434 /
data ((cldnuctab( 1,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.0294, 0.0748, 0.1707, 0.3371, 0.5761, 0.8122, 0.9593, 0.9967, 0.9979,  &
0.0164, 0.0421, 0.1080, 0.2275, 0.4303, 0.6836, 0.8873, 0.9807, 0.9979,  &
0.0097, 0.0267, 0.0692, 0.1508, 0.3078, 0.5277, 0.7774, 0.9381, 0.9934,  &
0.0055, 0.0164, 0.0421, 0.1006, 0.2154, 0.4144, 0.6540, 0.8622, 0.9742,  &
0.0034, 0.0097, 0.0267, 0.0692, 0.1606, 0.3078, 0.5277, 0.7651, 0.9330,  &
0.0021, 0.0062, 0.0164, 0.0459, 0.1080, 0.2400, 0.4303, 0.6689, 0.8709,  &
0.0011, 0.0034, 0.0108, 0.0294, 0.0748, 0.1707, 0.3371, 0.5761, 0.7894 /
data ((cldnuctab( 1,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.0267, 0.0692, 0.1508, 0.3078, 0.5439, 0.7894, 0.9517, 0.9953, 0.9979,  &
0.0148, 0.0385, 0.0936, 0.2036, 0.3985, 0.6540, 0.8709, 0.9766, 0.9979,  &
0.0087, 0.0221, 0.0589, 0.1325, 0.2797, 0.4951, 0.7523, 0.9275, 0.9907,  &
0.0049, 0.0133, 0.0353, 0.0870, 0.1923, 0.3674, 0.6078, 0.8334, 0.9628,  &
0.0026, 0.0087, 0.0221, 0.0589, 0.1325, 0.2797, 0.4951, 0.7258, 0.9091,  &
0.0016, 0.0049, 0.0148, 0.0385, 0.0936, 0.2036, 0.3829, 0.6078, 0.8334,  &
0.0009, 0.0030, 0.0087, 0.0243, 0.0639, 0.1508, 0.2936, 0.5114, 0.7392 /
data ((cldnuctab( 1,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.1240, 0.2529, 0.4626, 0.7120, 0.9022, 0.9842, 0.9979, 0.9979, 0.9979,  &
0.0870, 0.1923, 0.3674, 0.6078, 0.8230, 0.9556, 0.9958, 0.9979, 0.9979,  &
0.0589, 0.1415, 0.2936, 0.5114, 0.7392, 0.9156, 0.9858, 0.9979, 0.9979,  &
0.0421, 0.1006, 0.2275, 0.4144, 0.6540, 0.8622, 0.9689, 0.9967, 0.9979,  &
0.0267, 0.0692, 0.1707, 0.3371, 0.5761, 0.7894, 0.9381, 0.9896, 0.9979,  &
0.0133, 0.0421, 0.1158, 0.2529, 0.4626, 0.6836, 0.8622, 0.9593, 0.9963,  &
0.0055, 0.0200, 0.0639, 0.1508, 0.2797, 0.3985, 0.4951, 0.5114, 0.8709 /
data ((cldnuctab( 1,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.0870, 0.1923, 0.3829, 0.6234, 0.8434, 0.9660, 0.9971, 0.9979, 0.9979,  &
0.0589, 0.1415, 0.2797, 0.5114, 0.7392, 0.9156, 0.9872, 0.9979, 0.9979,  &
0.0385, 0.1006, 0.2154, 0.3985, 0.6388, 0.8530, 0.9660, 0.9971, 0.9979,  &
0.0267, 0.0692, 0.1606, 0.3223, 0.5439, 0.7774, 0.9330, 0.9896, 0.9979,  &
0.0164, 0.0459, 0.1158, 0.2529, 0.4626, 0.6980, 0.8873, 0.9742, 0.9977,  &
0.0097, 0.0294, 0.0807, 0.1923, 0.3829, 0.6078, 0.8230, 0.9429, 0.9917,  &
0.0043, 0.0148, 0.0459, 0.1240, 0.2661, 0.4626, 0.6689, 0.8230, 0.9474 /
data ((cldnuctab( 1,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.0639, 0.1508, 0.3078, 0.5277, 0.7774, 0.9381, 0.9926, 0.9979, 0.9979,  &
0.0421, 0.1006, 0.2275, 0.4144, 0.6540, 0.8709, 0.9742, 0.9979, 0.9979,  &
0.0267, 0.0692, 0.1606, 0.3223, 0.5439, 0.7774, 0.9381, 0.9917, 0.9979,  &
0.0181, 0.0500, 0.1158, 0.2529, 0.4464, 0.6836, 0.8793, 0.9766, 0.9979,  &
0.0108, 0.0322, 0.0807, 0.1923, 0.3674, 0.5920, 0.8122, 0.9475, 0.9934,  &
0.0062, 0.0200, 0.0543, 0.1415, 0.2936, 0.5114, 0.7392, 0.9091, 0.9807,  &
0.0030, 0.0097, 0.0322, 0.0936, 0.2154, 0.4144, 0.6388, 0.8230, 0.9429 /
data ((cldnuctab( 1,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.0500, 0.1240, 0.2529, 0.4626, 0.7120, 0.9091, 0.9872, 0.9979, 0.9979,  &
0.0322, 0.0807, 0.1813, 0.3521, 0.5920, 0.8230, 0.9556, 0.9958, 0.9979,  &
0.0200, 0.0543, 0.1240, 0.2661, 0.4626, 0.7120, 0.9022, 0.9826, 0.9979,  &
0.0120, 0.0353, 0.0870, 0.1923, 0.3674, 0.6078, 0.8230, 0.9556, 0.9947,  &
0.0077, 0.0221, 0.0589, 0.1415, 0.2936, 0.5114, 0.7392, 0.9091, 0.9842,  &
0.0049, 0.0148, 0.0385, 0.1006, 0.2275, 0.4144, 0.6540, 0.8530, 0.9628,  &
0.0023, 0.0077, 0.0243, 0.0639, 0.1606, 0.3371, 0.5601, 0.7774, 0.9217 /
data ((cldnuctab( 1,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.0421, 0.1006, 0.2275, 0.4144, 0.6689, 0.8793, 0.9787, 0.9979, 0.9979,  &
0.0267, 0.0639, 0.1508, 0.3078, 0.5277, 0.7774, 0.9381, 0.9926, 0.9979,  &
0.0164, 0.0421, 0.1006, 0.2154, 0.4144, 0.6540, 0.8622, 0.9717, 0.9977,  &
0.0097, 0.0267, 0.0692, 0.1508, 0.3078, 0.5277, 0.7651, 0.9275, 0.9896,  &
0.0055, 0.0164, 0.0459, 0.1080, 0.2400, 0.4303, 0.6689, 0.8622, 0.9689,  &
0.0034, 0.0108, 0.0294, 0.0748, 0.1707, 0.3371, 0.5601, 0.7894, 0.9381,  &
0.0018, 0.0055, 0.0181, 0.0500, 0.1240, 0.2661, 0.4789, 0.7120, 0.8793 /
data ((cldnuctab( 1,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.0385, 0.0936, 0.2036, 0.3829, 0.6388, 0.8622, 0.9742, 0.9979, 0.9979,  &
0.0221, 0.0543, 0.1325, 0.2661, 0.4951, 0.7392, 0.9217, 0.9885, 0.9979,  &
0.0133, 0.0353, 0.0870, 0.1923, 0.3674, 0.6078, 0.8230, 0.9593, 0.9963,  &
0.0077, 0.0221, 0.0543, 0.1325, 0.2661, 0.4789, 0.7120, 0.9022, 0.9842,  &
0.0043, 0.0133, 0.0353, 0.0870, 0.1923, 0.3674, 0.6078, 0.8230, 0.9517,  &
0.0026, 0.0087, 0.0243, 0.0589, 0.1415, 0.2936, 0.4951, 0.7258, 0.9022,  &
0.0016, 0.0049, 0.0133, 0.0385, 0.1006, 0.2154, 0.3985, 0.6388, 0.8434 /
data ((cldnuctab( 1,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.0353, 0.0870, 0.1923, 0.3674, 0.6078, 0.8434, 0.9660, 0.9974, 0.9979,  &
0.0200, 0.0500, 0.1158, 0.2529, 0.4626, 0.7120, 0.9022, 0.9858, 0.9979,  &
0.0108, 0.0294, 0.0748, 0.1707, 0.3371, 0.5601, 0.8010, 0.9474, 0.9947,  &
0.0069, 0.0181, 0.0459, 0.1158, 0.2400, 0.4303, 0.6689, 0.8793, 0.9766,  &
0.0038, 0.0120, 0.0294, 0.0748, 0.1707, 0.3371, 0.5601, 0.7894, 0.9381,  &
0.0023, 0.0069, 0.0200, 0.0500, 0.1158, 0.2529, 0.4464, 0.6836, 0.8709,  &
0.0012, 0.0038, 0.0120, 0.0322, 0.0807, 0.1813, 0.3521, 0.5761, 0.8010 /
data ((cldnuctab( 1,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.1415, 0.2936, 0.5114, 0.7523, 0.9217, 0.9885, 0.9979, 0.9979, 0.9979,  &
0.1006, 0.2275, 0.4144, 0.6540, 0.8622, 0.9689, 0.9971, 0.9979, 0.9979,  &
0.0748, 0.1707, 0.3371, 0.5601, 0.7894, 0.9330, 0.9907, 0.9979, 0.9979,  &
0.0500, 0.1240, 0.2661, 0.4626, 0.6980, 0.8873, 0.9766, 0.9979, 0.9979,  &
0.0294, 0.0807, 0.1923, 0.3829, 0.6234, 0.8334, 0.9517, 0.9926, 0.9979,  &
0.0148, 0.0459, 0.1325, 0.2936, 0.5114, 0.7258, 0.8873, 0.9717, 0.9977,  &
0.0062, 0.0221, 0.0692, 0.1707, 0.2797, 0.4144, 0.5114, 0.5277, 0.8530 /
data ((cldnuctab( 1,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.1006, 0.2275, 0.4144, 0.6689, 0.8709, 0.9742, 0.9979, 0.9979, 0.9979,  &
0.0692, 0.1606, 0.3223, 0.5439, 0.7894, 0.9381, 0.9917, 0.9979, 0.9979,  &
0.0500, 0.1158, 0.2529, 0.4464, 0.6836, 0.8793, 0.9766, 0.9979, 0.9979,  &
0.0322, 0.0870, 0.1923, 0.3674, 0.5920, 0.8122, 0.9474, 0.9934, 0.9979,  &
0.0200, 0.0589, 0.1415, 0.2936, 0.5114, 0.7392, 0.9091, 0.9826, 0.9979,  &
0.0108, 0.0322, 0.0936, 0.2154, 0.4144, 0.6540, 0.8530, 0.9556, 0.9941,  &
0.0043, 0.0148, 0.0500, 0.1415, 0.2936, 0.4951, 0.6836, 0.8530, 0.9593 /
data ((cldnuctab( 1,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.0748, 0.1707, 0.3521, 0.5761, 0.8122, 0.9517, 0.9953, 0.9979, 0.9979,  &
0.0500, 0.1240, 0.2529, 0.4626, 0.7120, 0.8950, 0.9807, 0.9979, 0.9979,  &
0.0322, 0.0870, 0.1923, 0.3674, 0.5920, 0.8230, 0.9517, 0.9941, 0.9979,  &
0.0221, 0.0589, 0.1415, 0.2797, 0.4951, 0.7392, 0.9091, 0.9826, 0.9979,  &
0.0133, 0.0385, 0.1006, 0.2154, 0.4144, 0.6388, 0.8434, 0.9628, 0.9953,  &
0.0077, 0.0243, 0.0639, 0.1606, 0.3223, 0.5601, 0.7774, 0.9275, 0.9872,  &
0.0034, 0.0108, 0.0353, 0.1006, 0.2400, 0.4464, 0.6689, 0.8530, 0.9517 /
data ((cldnuctab( 1,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.0589, 0.1415, 0.2936, 0.5114, 0.7523, 0.9275, 0.9907, 0.9979, 0.9979,  &
0.0385, 0.0936, 0.2036, 0.3985, 0.6388, 0.8530, 0.9689, 0.9971, 0.9979,  &
0.0243, 0.0639, 0.1508, 0.2936, 0.5114, 0.7523, 0.9217, 0.9885, 0.9979,  &
0.0164, 0.0421, 0.1006, 0.2275, 0.4144, 0.6540, 0.8530, 0.9660, 0.9967,  &
0.0097, 0.0267, 0.0748, 0.1707, 0.3371, 0.5601, 0.7774, 0.9330, 0.9885,  &
0.0055, 0.0164, 0.0500, 0.1158, 0.2529, 0.4626, 0.6980, 0.8793, 0.9717,  &
0.0026, 0.0087, 0.0267, 0.0748, 0.1813, 0.3674, 0.6078, 0.8122, 0.9381 /
data ((cldnuctab( 1,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.0500, 0.1240, 0.2529, 0.4626, 0.7120, 0.9091, 0.9858, 0.9979, 0.9979,  &
0.0322, 0.0807, 0.1707, 0.3371, 0.5761, 0.8122, 0.9517, 0.9947, 0.9979,  &
0.0200, 0.0500, 0.1158, 0.2529, 0.4464, 0.6980, 0.8873, 0.9787, 0.9979,  &
0.0120, 0.0322, 0.0807, 0.1813, 0.3521, 0.5761, 0.8010, 0.9474, 0.9934,  &
0.0077, 0.0200, 0.0543, 0.1325, 0.2661, 0.4789, 0.7120, 0.8950, 0.9787,  &
0.0043, 0.0133, 0.0353, 0.0936, 0.2036, 0.3829, 0.6078, 0.8230, 0.9517,  &
0.0021, 0.0069, 0.0200, 0.0589, 0.1415, 0.2936, 0.5114, 0.7523, 0.9091 /
data ((cldnuctab( 1,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.0459, 0.1080, 0.2275, 0.4303, 0.6836, 0.8873, 0.9807, 0.9979, 0.9979,  &
0.0267, 0.0692, 0.1508, 0.3078, 0.5277, 0.7774, 0.9381, 0.9926, 0.9979,  &
0.0164, 0.0421, 0.1006, 0.2154, 0.3985, 0.6388, 0.8622, 0.9717, 0.9974,  &
0.0097, 0.0267, 0.0639, 0.1508, 0.3078, 0.5277, 0.7523, 0.9217, 0.9885,  &
0.0062, 0.0181, 0.0421, 0.1080, 0.2275, 0.4144, 0.6540, 0.8530, 0.9660,  &
0.0034, 0.0108, 0.0294, 0.0748, 0.1606, 0.3223, 0.5439, 0.7774, 0.9275,  &
0.0018, 0.0055, 0.0164, 0.0459, 0.1158, 0.2529, 0.4464, 0.6836, 0.8709 /
data ((cldnuctab( 1,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.0421, 0.1006, 0.2154, 0.3985, 0.6540, 0.8709, 0.9766, 0.9979, 0.9979,  &
0.0243, 0.0589, 0.1415, 0.2797, 0.4951, 0.7523, 0.9275, 0.9896, 0.9979,  &
0.0133, 0.0353, 0.0870, 0.1923, 0.3674, 0.6078, 0.8334, 0.9628, 0.9963,  &
0.0087, 0.0221, 0.0589, 0.1325, 0.2661, 0.4789, 0.7258, 0.9022, 0.9842,  &
0.0049, 0.0148, 0.0385, 0.0936, 0.1923, 0.3674, 0.6078, 0.8230, 0.9517,  &
0.0030, 0.0087, 0.0243, 0.0589, 0.1415, 0.2797, 0.4951, 0.7258, 0.9022,  &
0.0016, 0.0043, 0.0133, 0.0385, 0.0936, 0.2154, 0.3985, 0.6234, 0.8334 /
data ((cldnuctab( 1,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.1606, 0.3223, 0.5439, 0.7894, 0.9381, 0.9917, 0.9979, 0.9979, 0.9979,  &
0.1158, 0.2529, 0.4464, 0.6836, 0.8793, 0.9766, 0.9979, 0.9979, 0.9979,  &
0.0807, 0.1923, 0.3674, 0.5920, 0.8122, 0.9475, 0.9934, 0.9979, 0.9979,  &
0.0589, 0.1415, 0.2936, 0.5114, 0.7392, 0.9091, 0.9826, 0.9979, 0.9979,  &
0.0322, 0.0936, 0.2154, 0.4144, 0.6540, 0.8530, 0.9593, 0.9947, 0.9979,  &
0.0164, 0.0500, 0.1415, 0.3078, 0.5277, 0.7523, 0.9022, 0.9766, 0.9979,  &
0.0062, 0.0221, 0.0748, 0.1707, 0.2797, 0.3829, 0.4464, 0.5439, 0.8709 /
data ((cldnuctab( 1,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.1158, 0.2529, 0.4626, 0.6980, 0.8950, 0.9807, 0.9979, 0.9979, 0.9979,  &
0.0807, 0.1813, 0.3521, 0.5920, 0.8122, 0.9474, 0.9941, 0.9979, 0.9979,  &
0.0543, 0.1325, 0.2797, 0.4951, 0.7258, 0.9022, 0.9807, 0.9979, 0.9979,  &
0.0385, 0.0936, 0.2154, 0.3985, 0.6388, 0.8434, 0.9593, 0.9947, 0.9979,  &
0.0221, 0.0639, 0.1606, 0.3223, 0.5439, 0.7774, 0.9275, 0.9858, 0.9979,  &
0.0120, 0.0353, 0.1006, 0.2400, 0.4464, 0.6836, 0.8709, 0.9660, 0.9958,  &
0.0049, 0.0164, 0.0543, 0.1508, 0.3078, 0.5114, 0.7120, 0.8709, 0.9689 /
data ((cldnuctab( 1,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.0870, 0.1923, 0.3829, 0.6234, 0.8434, 0.9628, 0.9967, 0.9979, 0.9979,  &
0.0589, 0.1415, 0.2797, 0.4951, 0.7392, 0.9156, 0.9858, 0.9979, 0.9979,  &
0.0385, 0.1006, 0.2154, 0.3985, 0.6388, 0.8434, 0.9628, 0.9958, 0.9979,  &
0.0267, 0.0692, 0.1606, 0.3223, 0.5439, 0.7651, 0.9217, 0.9872, 0.9979,  &
0.0164, 0.0459, 0.1158, 0.2400, 0.4464, 0.6836, 0.8709, 0.9689, 0.9967,  &
0.0087, 0.0267, 0.0748, 0.1813, 0.3674, 0.5920, 0.8122, 0.9429, 0.9896,  &
0.0034, 0.0120, 0.0385, 0.1080, 0.2661, 0.4789, 0.6980, 0.8709, 0.9628 /
data ((cldnuctab( 1,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.0692, 0.1606, 0.3223, 0.5439, 0.7894, 0.9429, 0.9934, 0.9979, 0.9979,  &
0.0459, 0.1080, 0.2275, 0.4303, 0.6689, 0.8709, 0.9742, 0.9979, 0.9979,  &
0.0294, 0.0748, 0.1707, 0.3223, 0.5601, 0.7894, 0.9381, 0.9907, 0.9979,  &
0.0181, 0.0500, 0.1158, 0.2529, 0.4464, 0.6836, 0.8793, 0.9742, 0.9977,  &
0.0120, 0.0322, 0.0870, 0.1923, 0.3674, 0.5920, 0.8122, 0.9429, 0.9917,  &
0.0062, 0.0200, 0.0543, 0.1325, 0.2797, 0.4951, 0.7258, 0.9022, 0.9787,  &
0.0026, 0.0087, 0.0294, 0.0807, 0.2036, 0.3985, 0.6388, 0.8334, 0.9474 /
data ((cldnuctab( 1,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.0589, 0.1325, 0.2797, 0.4951, 0.7392, 0.9217, 0.9896, 0.9979, 0.9979,  &
0.0353, 0.0870, 0.1923, 0.3674, 0.6078, 0.8334, 0.9628, 0.9963, 0.9979,  &
0.0221, 0.0589, 0.1325, 0.2797, 0.4951, 0.7258, 0.9091, 0.9842, 0.9979,  &
0.0133, 0.0385, 0.0936, 0.2036, 0.3829, 0.6234, 0.8334, 0.9556, 0.9947,  &
0.0087, 0.0243, 0.0639, 0.1508, 0.2936, 0.5114, 0.7392, 0.9091, 0.9842,  &
0.0049, 0.0148, 0.0421, 0.1006, 0.2275, 0.4144, 0.6540, 0.8530, 0.9628,  &
0.0023, 0.0069, 0.0221, 0.0639, 0.1606, 0.3223, 0.5601, 0.7774, 0.9217 /
data ((cldnuctab( 1,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.0500, 0.1240, 0.2529, 0.4626, 0.7120, 0.9091, 0.9858, 0.9979, 0.9979,  &
0.0322, 0.0748, 0.1707, 0.3371, 0.5761, 0.8010, 0.9517, 0.9947, 0.9979,  &
0.0181, 0.0500, 0.1158, 0.2400, 0.4464, 0.6836, 0.8793, 0.9766, 0.9979,  &
0.0120, 0.0322, 0.0748, 0.1707, 0.3371, 0.5601, 0.7894, 0.9381, 0.9917,  &
0.0069, 0.0200, 0.0500, 0.1240, 0.2529, 0.4464, 0.6836, 0.8793, 0.9742,  &
0.0038, 0.0120, 0.0322, 0.0870, 0.1813, 0.3521, 0.5761, 0.8010, 0.9381,  &
0.0018, 0.0062, 0.0181, 0.0500, 0.1240, 0.2661, 0.4789, 0.7120, 0.8873 /
data ((cldnuctab( 1,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.0459, 0.1080, 0.2400, 0.4303, 0.6836, 0.8950, 0.9826, 0.9979, 0.9979,  &
0.0267, 0.0692, 0.1508, 0.3078, 0.5439, 0.7774, 0.9381, 0.9926, 0.9979,  &
0.0164, 0.0421, 0.1006, 0.2154, 0.3985, 0.6388, 0.8622, 0.9717, 0.9974,  &
0.0097, 0.0267, 0.0692, 0.1508, 0.2936, 0.5114, 0.7523, 0.9217, 0.9885,  &
0.0062, 0.0164, 0.0421, 0.1006, 0.2154, 0.3985, 0.6388, 0.8434, 0.9628,  &
0.0034, 0.0097, 0.0267, 0.0692, 0.1606, 0.3078, 0.5277, 0.7523, 0.9156,  &
0.0016, 0.0049, 0.0148, 0.0421, 0.1080, 0.2275, 0.4303, 0.6540, 0.8530 /
data ((cldnuctab( 2,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.0998, 0.2261, 0.4285, 0.6819, 0.9014, 0.9870, 0.9997, 0.9999, 0.9999,  &
0.0685, 0.1594, 0.3353, 0.5742, 0.8217, 0.9624, 0.9974, 0.9999, 0.9999,  &
0.0454, 0.1149, 0.2514, 0.4770, 0.7242, 0.9148, 0.9895, 0.9997, 0.9999,  &
0.0318, 0.0800, 0.1910, 0.3810, 0.6370, 0.8519, 0.9714, 0.9982, 0.9999,  &
0.0198, 0.0584, 0.1404, 0.3061, 0.5420, 0.7760, 0.9375, 0.9924, 0.9998,  &
0.0118, 0.0349, 0.0998, 0.2261, 0.4285, 0.6672, 0.8611, 0.9624, 0.9980,  &
0.0054, 0.0179, 0.0584, 0.1404, 0.2645, 0.3967, 0.4932, 0.4932, 0.8611 /
data ((cldnuctab( 2,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.0685, 0.1594, 0.3353, 0.5742, 0.8322, 0.9686, 0.9984, 0.9999, 0.9999,  &
0.0454, 0.1149, 0.2514, 0.4607, 0.7242, 0.9148, 0.9906, 0.9998, 0.9999,  &
0.0290, 0.0800, 0.1800, 0.3656, 0.6060, 0.8422, 0.9686, 0.9982, 0.9999,  &
0.0198, 0.0538, 0.1315, 0.2781, 0.5095, 0.7636, 0.9323, 0.9924, 0.9998,  &
0.0131, 0.0381, 0.0998, 0.2140, 0.4125, 0.6672, 0.8784, 0.9785, 0.9988,  &
0.0076, 0.0240, 0.0685, 0.1594, 0.3353, 0.5742, 0.8109, 0.9469, 0.9940,  &
0.0038, 0.0118, 0.0381, 0.1071, 0.2385, 0.4445, 0.6522, 0.8322, 0.9469 /
data ((cldnuctab( 2,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.0494, 0.1230, 0.2645, 0.4932, 0.7508, 0.9375, 0.9946, 0.9999, 0.9999,  &
0.0318, 0.0800, 0.1910, 0.3810, 0.6216, 0.8611, 0.9763, 0.9989, 0.9999,  &
0.0198, 0.0538, 0.1315, 0.2781, 0.5095, 0.7636, 0.9375, 0.9940, 0.9998,  &
0.0131, 0.0381, 0.0928, 0.2140, 0.4125, 0.6522, 0.8699, 0.9785, 0.9989,  &
0.0085, 0.0240, 0.0633, 0.1594, 0.3206, 0.5582, 0.7996, 0.9469, 0.9952,  &
0.0048, 0.0162, 0.0454, 0.1149, 0.2514, 0.4607, 0.7104, 0.9014, 0.9840,  &
0.0026, 0.0085, 0.0264, 0.0741, 0.1800, 0.3656, 0.6060, 0.8109, 0.9424 /
data ((cldnuctab( 2,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.0416, 0.0998, 0.2261, 0.4285, 0.6819, 0.9014, 0.9883, 0.9997, 0.9999,  &
0.0240, 0.0633, 0.1497, 0.3061, 0.5420, 0.7996, 0.9552, 0.9970, 0.9999,  &
0.0146, 0.0416, 0.0998, 0.2261, 0.4285, 0.6819, 0.8941, 0.9840, 0.9994,  &
0.0095, 0.0264, 0.0685, 0.1594, 0.3206, 0.5582, 0.8109, 0.9552, 0.9962,  &
0.0054, 0.0162, 0.0454, 0.1149, 0.2514, 0.4607, 0.7104, 0.9014, 0.9856,  &
0.0033, 0.0106, 0.0318, 0.0800, 0.1910, 0.3656, 0.6060, 0.8422, 0.9624,  &
0.0020, 0.0061, 0.0198, 0.0538, 0.1404, 0.2919, 0.5095, 0.7508, 0.9148 /
data ((cldnuctab( 2,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.0349, 0.0862, 0.1910, 0.3810, 0.6370, 0.8699, 0.9805, 0.9993, 0.9999,  &
0.0198, 0.0538, 0.1230, 0.2645, 0.4932, 0.7508, 0.9323, 0.9940, 0.9998,  &
0.0118, 0.0318, 0.0800, 0.1800, 0.3656, 0.6060, 0.8422, 0.9714, 0.9986,  &
0.0068, 0.0198, 0.0538, 0.1230, 0.2645, 0.4932, 0.7377, 0.9210, 0.9916,  &
0.0042, 0.0118, 0.0349, 0.0862, 0.2023, 0.3810, 0.6216, 0.8519, 0.9714,  &
0.0026, 0.0076, 0.0218, 0.0584, 0.1404, 0.2919, 0.5258, 0.7636, 0.9323,  &
0.0015, 0.0048, 0.0146, 0.0416, 0.0998, 0.2261, 0.4285, 0.6672, 0.8699 /
data ((cldnuctab( 2,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.0290, 0.0741, 0.1695, 0.3503, 0.5902, 0.8422, 0.9739, 0.9988, 0.9999,  &
0.0162, 0.0454, 0.1071, 0.2385, 0.4445, 0.7104, 0.9083, 0.9906, 0.9997,  &
0.0095, 0.0264, 0.0685, 0.1594, 0.3206, 0.5582, 0.8109, 0.9589, 0.9970,  &
0.0054, 0.0162, 0.0416, 0.1071, 0.2261, 0.4285, 0.6819, 0.8941, 0.9840,  &
0.0033, 0.0095, 0.0264, 0.0685, 0.1594, 0.3206, 0.5582, 0.7996, 0.9512,  &
0.0020, 0.0061, 0.0179, 0.0454, 0.1149, 0.2514, 0.4445, 0.6963, 0.8941,  &
0.0012, 0.0038, 0.0106, 0.0318, 0.0800, 0.1800, 0.3656, 0.5902, 0.8217 /
data ((cldnuctab( 2,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.0264, 0.0685, 0.1594, 0.3206, 0.5742, 0.8217, 0.9656, 0.9982, 0.9999,  &
0.0146, 0.0416, 0.0998, 0.2140, 0.4125, 0.6672, 0.8941, 0.9870, 0.9995,  &
0.0085, 0.0240, 0.0584, 0.1404, 0.2919, 0.5258, 0.7760, 0.9469, 0.9957,  &
0.0048, 0.0146, 0.0381, 0.0928, 0.2023, 0.3810, 0.6370, 0.8611, 0.9763,  &
0.0029, 0.0085, 0.0240, 0.0584, 0.1404, 0.2919, 0.5095, 0.7508, 0.9323,  &
0.0015, 0.0048, 0.0146, 0.0381, 0.0928, 0.2140, 0.3967, 0.6370, 0.8611,  &
0.0010, 0.0029, 0.0085, 0.0240, 0.0633, 0.1497, 0.3061, 0.5258, 0.7636 /
data ((cldnuctab( 2,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.1497, 0.3061, 0.5258, 0.7760, 0.9375, 0.9932, 0.9998, 0.9999, 0.9999,  &
0.1071, 0.2261, 0.4285, 0.6672, 0.8784, 0.9785, 0.9988, 0.9999, 0.9999,  &
0.0741, 0.1695, 0.3353, 0.5742, 0.7996, 0.9469, 0.9946, 0.9998, 0.9999,  &
0.0494, 0.1230, 0.2645, 0.4770, 0.7242, 0.9083, 0.9840, 0.9990, 0.9999,  &
0.0290, 0.0862, 0.2023, 0.3967, 0.6370, 0.8519, 0.9624, 0.9962, 0.9999,  &
0.0146, 0.0494, 0.1315, 0.2919, 0.5258, 0.7377, 0.9014, 0.9785, 0.9988,  &
0.0061, 0.0218, 0.0685, 0.1695, 0.2781, 0.4125, 0.4445, 0.5258, 0.8699 /
data ((cldnuctab( 2,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.1071, 0.2261, 0.4285, 0.6819, 0.8864, 0.9823, 0.9992, 0.9999, 0.9999,  &
0.0741, 0.1695, 0.3353, 0.5582, 0.7996, 0.9512, 0.9952, 0.9999, 0.9999,  &
0.0494, 0.1230, 0.2514, 0.4607, 0.7104, 0.9014, 0.9823, 0.9990, 0.9999,  &
0.0318, 0.0862, 0.1910, 0.3810, 0.6060, 0.8322, 0.9589, 0.9962, 0.9999,  &
0.0198, 0.0584, 0.1404, 0.2919, 0.5258, 0.7508, 0.9210, 0.9883, 0.9994,  &
0.0106, 0.0349, 0.0928, 0.2261, 0.4285, 0.6672, 0.8699, 0.9656, 0.9967,  &
0.0048, 0.0162, 0.0494, 0.1404, 0.2919, 0.5095, 0.6963, 0.8611, 0.9686 /
data ((cldnuctab( 2,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.0800, 0.1800, 0.3503, 0.5902, 0.8322, 0.9624, 0.9974, 0.9999, 0.9999,  &
0.0494, 0.1230, 0.2645, 0.4770, 0.7242, 0.9083, 0.9870, 0.9995, 0.9999,  &
0.0349, 0.0862, 0.1910, 0.3810, 0.6060, 0.8322, 0.9624, 0.9967, 0.9999,  &
0.0218, 0.0584, 0.1404, 0.2919, 0.5095, 0.7508, 0.9210, 0.9883, 0.9994,  &
0.0146, 0.0381, 0.0998, 0.2261, 0.4125, 0.6522, 0.8611, 0.9714, 0.9974,  &
0.0076, 0.0240, 0.0685, 0.1594, 0.3353, 0.5742, 0.7996, 0.9375, 0.9916,  &
0.0033, 0.0118, 0.0349, 0.1071, 0.2385, 0.4607, 0.6819, 0.8611, 0.9624 /
data ((cldnuctab( 2,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.0633, 0.1404, 0.2919, 0.5258, 0.7760, 0.9424, 0.9940, 0.9998, 0.9999,  &
0.0381, 0.0928, 0.2140, 0.3967, 0.6522, 0.8611, 0.9763, 0.9986, 0.9999,  &
0.0240, 0.0633, 0.1497, 0.3061, 0.5258, 0.7636, 0.9323, 0.9924, 0.9997,  &
0.0162, 0.0416, 0.1071, 0.2261, 0.4285, 0.6672, 0.8699, 0.9739, 0.9982,  &
0.0095, 0.0290, 0.0741, 0.1695, 0.3353, 0.5582, 0.7996, 0.9424, 0.9924,  &
0.0054, 0.0179, 0.0494, 0.1230, 0.2645, 0.4770, 0.7104, 0.8941, 0.9805,  &
0.0026, 0.0085, 0.0264, 0.0741, 0.1910, 0.3810, 0.6060, 0.8217, 0.9469 /
data ((cldnuctab( 2,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.0494, 0.1230, 0.2645, 0.4770, 0.7242, 0.9210, 0.9906, 0.9997, 0.9999,  &
0.0318, 0.0800, 0.1800, 0.3503, 0.5902, 0.8217, 0.9624, 0.9970, 0.9999,  &
0.0198, 0.0494, 0.1230, 0.2514, 0.4607, 0.7104, 0.9014, 0.9856, 0.9993,  &
0.0118, 0.0318, 0.0800, 0.1800, 0.3503, 0.5902, 0.8217, 0.9552, 0.9957,  &
0.0076, 0.0218, 0.0538, 0.1315, 0.2781, 0.4932, 0.7242, 0.9083, 0.9840,  &
0.0042, 0.0131, 0.0349, 0.0928, 0.2023, 0.3967, 0.6216, 0.8422, 0.9624,  &
0.0020, 0.0068, 0.0198, 0.0584, 0.1404, 0.3061, 0.5258, 0.7636, 0.9210 /
data ((cldnuctab( 2,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.0454, 0.1071, 0.2261, 0.4285, 0.6963, 0.9014, 0.9856, 0.9994, 0.9999,  &
0.0264, 0.0685, 0.1497, 0.3061, 0.5420, 0.7880, 0.9469, 0.9952, 0.9998,  &
0.0162, 0.0416, 0.0998, 0.2140, 0.4125, 0.6522, 0.8699, 0.9785, 0.9986,  &
0.0095, 0.0264, 0.0685, 0.1497, 0.3061, 0.5258, 0.7760, 0.9323, 0.9924,  &
0.0061, 0.0162, 0.0454, 0.1071, 0.2261, 0.4285, 0.6672, 0.8699, 0.9739,  &
0.0038, 0.0106, 0.0290, 0.0741, 0.1695, 0.3353, 0.5582, 0.7880, 0.9375,  &
0.0018, 0.0054, 0.0162, 0.0454, 0.1149, 0.2514, 0.4607, 0.6963, 0.8784 /
data ((cldnuctab( 2,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.0416, 0.0998, 0.2140, 0.4125, 0.6672, 0.8864, 0.9823, 0.9992, 0.9999,  &
0.0240, 0.0584, 0.1404, 0.2919, 0.5095, 0.7636, 0.9375, 0.9932, 0.9998,  &
0.0146, 0.0381, 0.0928, 0.2023, 0.3810, 0.6216, 0.8519, 0.9686, 0.9980,  &
0.0085, 0.0240, 0.0584, 0.1315, 0.2781, 0.4932, 0.7377, 0.9148, 0.9883,  &
0.0048, 0.0146, 0.0381, 0.0928, 0.2023, 0.3810, 0.6060, 0.8322, 0.9624,  &
0.0029, 0.0085, 0.0240, 0.0633, 0.1404, 0.2919, 0.4932, 0.7377, 0.9083,  &
0.0015, 0.0048, 0.0131, 0.0381, 0.0998, 0.2140, 0.3967, 0.6370, 0.8422 /
data ((cldnuctab( 2,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.2140, 0.3967, 0.6370, 0.8519, 0.9656, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.1594, 0.3206, 0.5420, 0.7636, 0.9268, 0.9895, 0.9994, 0.9999, 0.9999,  &
0.1149, 0.2385, 0.4445, 0.6819, 0.8784, 0.9739, 0.9977, 0.9999, 0.9999,  &
0.0741, 0.1800, 0.3656, 0.5902, 0.8109, 0.9469, 0.9924, 0.9996, 0.9999,  &
0.0416, 0.1149, 0.2645, 0.4932, 0.7377, 0.9083, 0.9805, 0.9982, 0.9999,  &
0.0179, 0.0584, 0.1695, 0.3656, 0.5902, 0.8109, 0.9323, 0.9883, 0.9995,  &
0.0068, 0.0240, 0.0800, 0.1910, 0.2919, 0.3656, 0.4285, 0.4445, 0.9083 /
data ((cldnuctab( 2,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.1594, 0.3061, 0.5420, 0.7760, 0.9323, 0.9916, 0.9997, 0.9999, 0.9999,  &
0.1071, 0.2385, 0.4285, 0.6672, 0.8699, 0.9739, 0.9980, 0.9999, 0.9999,  &
0.0800, 0.1800, 0.3503, 0.5742, 0.7996, 0.9424, 0.9924, 0.9996, 0.9999,  &
0.0538, 0.1315, 0.2781, 0.4770, 0.7242, 0.8941, 0.9785, 0.9982, 0.9999,  &
0.0290, 0.0800, 0.2023, 0.3967, 0.6370, 0.8422, 0.9589, 0.9946, 0.9997,  &
0.0131, 0.0416, 0.1230, 0.2919, 0.5258, 0.7636, 0.9148, 0.9823, 0.9986,  &
0.0054, 0.0179, 0.0633, 0.1695, 0.3503, 0.5582, 0.7636, 0.8941, 0.9805 /
data ((cldnuctab( 2,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.1149, 0.2514, 0.4607, 0.6963, 0.8941, 0.9823, 0.9989, 0.9999, 0.9999,  &
0.0800, 0.1800, 0.3503, 0.5902, 0.8109, 0.9512, 0.9946, 0.9998, 0.9999,  &
0.0538, 0.1315, 0.2781, 0.4770, 0.7104, 0.9014, 0.9805, 0.9986, 0.9999,  &
0.0381, 0.0928, 0.2023, 0.3967, 0.6216, 0.8322, 0.9552, 0.9946, 0.9998,  &
0.0218, 0.0584, 0.1497, 0.3061, 0.5258, 0.7636, 0.9210, 0.9856, 0.9989,  &
0.0095, 0.0318, 0.0928, 0.2261, 0.4285, 0.6672, 0.8699, 0.9686, 0.9957,  &
0.0038, 0.0131, 0.0454, 0.1315, 0.3061, 0.5420, 0.7636, 0.9148, 0.9805 /
data ((cldnuctab( 2,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.0928, 0.2023, 0.3967, 0.6370, 0.8519, 0.9686, 0.9977, 0.9999, 0.9999,  &
0.0633, 0.1404, 0.2919, 0.5095, 0.7508, 0.9210, 0.9883, 0.9994, 0.9999,  &
0.0416, 0.0998, 0.2140, 0.3967, 0.6370, 0.8519, 0.9656, 0.9967, 0.9999,  &
0.0264, 0.0685, 0.1594, 0.3206, 0.5420, 0.7636, 0.9268, 0.9883, 0.9993,  &
0.0162, 0.0454, 0.1149, 0.2385, 0.4445, 0.6819, 0.8699, 0.9686, 0.9970,  &
0.0076, 0.0240, 0.0685, 0.1695, 0.3503, 0.5742, 0.7996, 0.9424, 0.9906,  &
0.0033, 0.0106, 0.0349, 0.0998, 0.2385, 0.4607, 0.7104, 0.8864, 0.9714 /
data ((cldnuctab( 2,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.0800, 0.1695, 0.3503, 0.5742, 0.8109, 0.9552, 0.9957, 0.9998, 0.9999,  &
0.0494, 0.1149, 0.2514, 0.4445, 0.6963, 0.8941, 0.9805, 0.9988, 0.9999,  &
0.0318, 0.0800, 0.1800, 0.3353, 0.5742, 0.7996, 0.9469, 0.9932, 0.9997,  &
0.0198, 0.0538, 0.1230, 0.2645, 0.4607, 0.6963, 0.8864, 0.9785, 0.9982,  &
0.0118, 0.0349, 0.0862, 0.1910, 0.3656, 0.5902, 0.8109, 0.9469, 0.9932,  &
0.0061, 0.0179, 0.0538, 0.1315, 0.2781, 0.4932, 0.7242, 0.9014, 0.9805,  &
0.0026, 0.0085, 0.0264, 0.0741, 0.1910, 0.3967, 0.6370, 0.8422, 0.9552 /
data ((cldnuctab( 2,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.0685, 0.1594, 0.3061, 0.5420, 0.7880, 0.9424, 0.9940, 0.9997, 0.9999,  &
0.0416, 0.0998, 0.2140, 0.4125, 0.6522, 0.8611, 0.9739, 0.9980, 0.9999,  &
0.0264, 0.0685, 0.1497, 0.3061, 0.5258, 0.7508, 0.9268, 0.9895, 0.9994,  &
0.0162, 0.0416, 0.1071, 0.2261, 0.4125, 0.6370, 0.8519, 0.9656, 0.9967,  &
0.0095, 0.0290, 0.0685, 0.1594, 0.3206, 0.5258, 0.7636, 0.9210, 0.9870,  &
0.0048, 0.0162, 0.0416, 0.1071, 0.2385, 0.4285, 0.6672, 0.8611, 0.9656,  &
0.0023, 0.0068, 0.0218, 0.0633, 0.1594, 0.3353, 0.5582, 0.7880, 0.9323 /
data ((cldnuctab( 2,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.0633, 0.1404, 0.2919, 0.5095, 0.7636, 0.9323, 0.9924, 0.9997, 0.9999,  &
0.0381, 0.0928, 0.2023, 0.3810, 0.6216, 0.8422, 0.9656, 0.9974, 0.9999,  &
0.0240, 0.0584, 0.1315, 0.2645, 0.4770, 0.7242, 0.9083, 0.9856, 0.9992,  &
0.0146, 0.0381, 0.0928, 0.1910, 0.3656, 0.5902, 0.8217, 0.9552, 0.9952,  &
0.0085, 0.0240, 0.0584, 0.1404, 0.2781, 0.4770, 0.7104, 0.9014, 0.9805,  &
0.0048, 0.0131, 0.0381, 0.0928, 0.2023, 0.3810, 0.6060, 0.8217, 0.9512,  &
0.0020, 0.0061, 0.0179, 0.0538, 0.1315, 0.2781, 0.5095, 0.7377, 0.9083 /
data ((cldnuctab( 2,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.2919, 0.5095, 0.7377, 0.9148, 0.9840, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.2261, 0.4125, 0.6522, 0.8519, 0.9624, 0.9957, 0.9998, 0.9999, 0.9999,  &
0.1594, 0.3353, 0.5582, 0.7760, 0.9323, 0.9883, 0.9990, 0.9999, 0.9999,  &
0.0998, 0.2385, 0.4607, 0.6963, 0.8864, 0.9739, 0.9970, 0.9998, 0.9999,  &
0.0494, 0.1497, 0.3353, 0.5902, 0.8217, 0.9469, 0.9916, 0.9994, 0.9999,  &
0.0198, 0.0685, 0.2023, 0.4125, 0.6672, 0.8611, 0.9624, 0.9952, 0.9998,  &
0.0076, 0.0264, 0.0862, 0.2023, 0.2781, 0.3353, 0.3353, 0.3503, 0.9014 /
data ((cldnuctab( 2,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.2261, 0.4125, 0.6522, 0.8611, 0.9686, 0.9967, 0.9998, 0.9999, 0.9999,  &
0.1695, 0.3206, 0.5582, 0.7760, 0.9268, 0.9883, 0.9993, 0.9999, 0.9999,  &
0.1149, 0.2514, 0.4607, 0.6819, 0.8784, 0.9714, 0.9970, 0.9998, 0.9999,  &
0.0741, 0.1800, 0.3656, 0.5902, 0.8109, 0.9424, 0.9916, 0.9994, 0.9999,  &
0.0381, 0.1071, 0.2645, 0.4932, 0.7377, 0.9014, 0.9805, 0.9980, 0.9999,  &
0.0146, 0.0494, 0.1497, 0.3503, 0.6216, 0.8322, 0.9552, 0.9924, 0.9994,  &
0.0054, 0.0198, 0.0685, 0.1910, 0.3967, 0.6060, 0.7880, 0.9323, 0.9916 /
data ((cldnuctab( 2,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.1695, 0.3353, 0.5742, 0.7996, 0.9424, 0.9924, 0.9996, 0.9999, 0.9999,  &
0.1230, 0.2514, 0.4607, 0.6963, 0.8864, 0.9763, 0.9980, 0.9999, 0.9999,  &
0.0862, 0.1910, 0.3656, 0.5902, 0.8109, 0.9469, 0.9924, 0.9995, 0.9999,  &
0.0538, 0.1404, 0.2919, 0.4932, 0.7242, 0.9014, 0.9805, 0.9980, 0.9999,  &
0.0290, 0.0800, 0.2023, 0.3967, 0.6370, 0.8422, 0.9589, 0.9940, 0.9996,  &
0.0118, 0.0381, 0.1149, 0.2781, 0.5258, 0.7636, 0.9210, 0.9856, 0.9984,  &
0.0042, 0.0146, 0.0538, 0.1497, 0.3503, 0.6060, 0.8217, 0.9469, 0.9906 /
data ((cldnuctab( 2,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.1404, 0.2781, 0.4932, 0.7377, 0.9148, 0.9870, 0.9992, 0.9999, 0.9999,  &
0.0928, 0.2023, 0.3810, 0.6216, 0.8322, 0.9589, 0.9952, 0.9998, 0.9999,  &
0.0633, 0.1497, 0.3061, 0.5095, 0.7508, 0.9148, 0.9840, 0.9988, 0.9999,  &
0.0416, 0.1071, 0.2261, 0.4125, 0.6522, 0.8519, 0.9624, 0.9952, 0.9997,  &
0.0218, 0.0633, 0.1594, 0.3206, 0.5582, 0.7760, 0.9268, 0.9870, 0.9989,  &
0.0095, 0.0290, 0.0862, 0.2261, 0.4445, 0.6819, 0.8784, 0.9714, 0.9962,  &
0.0033, 0.0118, 0.0381, 0.1149, 0.2919, 0.5420, 0.7880, 0.9323, 0.9856 /
data ((cldnuctab( 2,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.1149, 0.2385, 0.4445, 0.6819, 0.8864, 0.9805, 0.9984, 0.9999, 0.9999,  &
0.0800, 0.1695, 0.3353, 0.5582, 0.7880, 0.9424, 0.9924, 0.9996, 0.9999,  &
0.0494, 0.1230, 0.2514, 0.4445, 0.6819, 0.8784, 0.9739, 0.9977, 0.9999,  &
0.0318, 0.0800, 0.1800, 0.3503, 0.5742, 0.7996, 0.9375, 0.9906, 0.9994,  &
0.0179, 0.0494, 0.1230, 0.2645, 0.4770, 0.7104, 0.8864, 0.9739, 0.9974,  &
0.0076, 0.0240, 0.0685, 0.1800, 0.3656, 0.6060, 0.8217, 0.9469, 0.9916,  &
0.0029, 0.0095, 0.0318, 0.0928, 0.2385, 0.4770, 0.7242, 0.9014, 0.9785 /
data ((cldnuctab( 2,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.0998, 0.2140, 0.4125, 0.6522, 0.8611, 0.9739, 0.9977, 0.9999, 0.9999,  &
0.0685, 0.1497, 0.2919, 0.5095, 0.7508, 0.9210, 0.9883, 0.9994, 0.9999,  &
0.0454, 0.0998, 0.2140, 0.3967, 0.6370, 0.8422, 0.9624, 0.9962, 0.9998,  &
0.0264, 0.0685, 0.1497, 0.3061, 0.5095, 0.7508, 0.9148, 0.9856, 0.9989,  &
0.0146, 0.0416, 0.1071, 0.2261, 0.4125, 0.6522, 0.8422, 0.9589, 0.9952,  &
0.0068, 0.0198, 0.0584, 0.1497, 0.3061, 0.5420, 0.7636, 0.9210, 0.9856,  &
0.0026, 0.0076, 0.0264, 0.0741, 0.1910, 0.4125, 0.6672, 0.8611, 0.9656 /
data ((cldnuctab( 2,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.0928, 0.2023, 0.3810, 0.6216, 0.8422, 0.9656, 0.9970, 0.9999, 0.9999,  &
0.0584, 0.1315, 0.2781, 0.4770, 0.7242, 0.9083, 0.9856, 0.9990, 0.9999,  &
0.0381, 0.0928, 0.1910, 0.3656, 0.5902, 0.8109, 0.9512, 0.9946, 0.9997,  &
0.0240, 0.0584, 0.1315, 0.2645, 0.4770, 0.7104, 0.8941, 0.9785, 0.9982,  &
0.0131, 0.0349, 0.0862, 0.1910, 0.3656, 0.5902, 0.8109, 0.9469, 0.9924,  &
0.0061, 0.0179, 0.0494, 0.1230, 0.2781, 0.4932, 0.7104, 0.8941, 0.9763,  &
0.0023, 0.0068, 0.0218, 0.0633, 0.1695, 0.3656, 0.6060, 0.8217, 0.9469 /
data ((cldnuctab( 2,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.3503, 0.5742, 0.7996, 0.9424, 0.9906, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2781, 0.4770, 0.7104, 0.8941, 0.9763, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.2023, 0.3967, 0.6216, 0.8322, 0.9512, 0.9932, 0.9995, 0.9999, 0.9999,  &
0.1149, 0.2781, 0.5258, 0.7636, 0.9148, 0.9840, 0.9984, 0.9999, 0.9999,  &
0.0538, 0.1594, 0.3810, 0.6522, 0.8611, 0.9656, 0.9946, 0.9996, 0.9999,  &
0.0218, 0.0741, 0.2140, 0.4445, 0.6963, 0.8941, 0.9763, 0.9974, 0.9999,  &
0.0076, 0.0290, 0.0928, 0.2023, 0.2781, 0.2645, 0.3206, 0.3656, 0.9148 /
data ((cldnuctab( 2,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.2781, 0.4770, 0.7104, 0.8941, 0.9805, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.2023, 0.3810, 0.6216, 0.8322, 0.9512, 0.9932, 0.9996, 0.9999, 0.9999,  &
0.1497, 0.3061, 0.5258, 0.7508, 0.9148, 0.9823, 0.9984, 0.9999, 0.9999,  &
0.0862, 0.2140, 0.4285, 0.6672, 0.8611, 0.9624, 0.9952, 0.9997, 0.9999,  &
0.0416, 0.1230, 0.3061, 0.5582, 0.7880, 0.9323, 0.9870, 0.9989, 0.9999,  &
0.0162, 0.0538, 0.1695, 0.3967, 0.6672, 0.8699, 0.9686, 0.9957, 0.9997,  &
0.0061, 0.0218, 0.0741, 0.2023, 0.4125, 0.6216, 0.8109, 0.9469, 0.9932 /
data ((cldnuctab( 2,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.2140, 0.3967, 0.6370, 0.8422, 0.9624, 0.9957, 0.9998, 0.9999, 0.9999,  &
0.1594, 0.3061, 0.5258, 0.7508, 0.9210, 0.9856, 0.9989, 0.9999, 0.9999,  &
0.1071, 0.2385, 0.4285, 0.6672, 0.8611, 0.9656, 0.9957, 0.9997, 0.9999,  &
0.0685, 0.1695, 0.3353, 0.5742, 0.7880, 0.9323, 0.9883, 0.9989, 0.9999,  &
0.0318, 0.0928, 0.2385, 0.4607, 0.6963, 0.8864, 0.9739, 0.9967, 0.9998,  &
0.0118, 0.0416, 0.1230, 0.3206, 0.5902, 0.8217, 0.9469, 0.9906, 0.9992,  &
0.0042, 0.0162, 0.0538, 0.1695, 0.3810, 0.6370, 0.8611, 0.9624, 0.9946 /
data ((cldnuctab( 2,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.1695, 0.3353, 0.5582, 0.7880, 0.9424, 0.9924, 0.9996, 0.9999, 0.9999,  &
0.1230, 0.2514, 0.4607, 0.6819, 0.8784, 0.9739, 0.9977, 0.9999, 0.9999,  &
0.0862, 0.1910, 0.3503, 0.5902, 0.7996, 0.9424, 0.9906, 0.9994, 0.9999,  &
0.0538, 0.1315, 0.2781, 0.4770, 0.7104, 0.8941, 0.9763, 0.9974, 0.9998,  &
0.0240, 0.0741, 0.1800, 0.3810, 0.6216, 0.8217, 0.9512, 0.9924, 0.9994,  &
0.0095, 0.0318, 0.0998, 0.2514, 0.4932, 0.7377, 0.9083, 0.9805, 0.9980,  &
0.0038, 0.0118, 0.0416, 0.1315, 0.3206, 0.5902, 0.8217, 0.9512, 0.9916 /
data ((cldnuctab( 2,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.1497, 0.2919, 0.5095, 0.7508, 0.9210, 0.9883, 0.9993, 0.9999, 0.9999,  &
0.0998, 0.2140, 0.3967, 0.6216, 0.8422, 0.9624, 0.9957, 0.9998, 0.9999,  &
0.0685, 0.1497, 0.3061, 0.5095, 0.7377, 0.9148, 0.9840, 0.9988, 0.9999,  &
0.0416, 0.0998, 0.2261, 0.4125, 0.6370, 0.8422, 0.9589, 0.9946, 0.9997,  &
0.0198, 0.0584, 0.1497, 0.3206, 0.5420, 0.7636, 0.9210, 0.9840, 0.9986,  &
0.0085, 0.0264, 0.0800, 0.2023, 0.4125, 0.6672, 0.8611, 0.9656, 0.9952,  &
0.0029, 0.0095, 0.0318, 0.0998, 0.2645, 0.5258, 0.7760, 0.9268, 0.9856 /
data ((cldnuctab( 2,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.1315, 0.2645, 0.4607, 0.7104, 0.9014, 0.9840, 0.9989, 0.9999, 0.9999,  &
0.0862, 0.1800, 0.3503, 0.5742, 0.8109, 0.9469, 0.9940, 0.9997, 0.9999,  &
0.0584, 0.1315, 0.2645, 0.4607, 0.6963, 0.8864, 0.9763, 0.9980, 0.9999,  &
0.0349, 0.0862, 0.1910, 0.3656, 0.5902, 0.7996, 0.9424, 0.9916, 0.9994,  &
0.0179, 0.0494, 0.1230, 0.2645, 0.4770, 0.7104, 0.8864, 0.9739, 0.9974,  &
0.0076, 0.0218, 0.0633, 0.1695, 0.3656, 0.6060, 0.8217, 0.9469, 0.9916,  &
0.0026, 0.0085, 0.0264, 0.0800, 0.2140, 0.4607, 0.7104, 0.8941, 0.9763 /
data ((cldnuctab( 2,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.1149, 0.2385, 0.4445, 0.6819, 0.8864, 0.9805, 0.9984, 0.9999, 0.9999,  &
0.0741, 0.1695, 0.3206, 0.5420, 0.7760, 0.9375, 0.9916, 0.9995, 0.9999,  &
0.0494, 0.1149, 0.2385, 0.4285, 0.6522, 0.8611, 0.9686, 0.9970, 0.9998,  &
0.0318, 0.0741, 0.1695, 0.3206, 0.5420, 0.7636, 0.9268, 0.9870, 0.9990,  &
0.0162, 0.0454, 0.1071, 0.2385, 0.4285, 0.6672, 0.8611, 0.9656, 0.9957,  &
0.0068, 0.0198, 0.0584, 0.1497, 0.3206, 0.5420, 0.7760, 0.9268, 0.9856,  &
0.0026, 0.0076, 0.0240, 0.0685, 0.1910, 0.3967, 0.6672, 0.8611, 0.9656 /
data ((cldnuctab( 2,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.3967, 0.6216, 0.8322, 0.9552, 0.9940, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3061, 0.5258, 0.7636, 0.9148, 0.9840, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.2261, 0.4285, 0.6672, 0.8611, 0.9656, 0.9952, 0.9997, 0.9999, 0.9999,  &
0.1230, 0.3061, 0.5582, 0.7996, 0.9375, 0.9883, 0.9989, 0.9999, 0.9999,  &
0.0538, 0.1695, 0.4125, 0.6819, 0.8864, 0.9739, 0.9967, 0.9998, 0.9999,  &
0.0218, 0.0741, 0.2140, 0.4607, 0.7104, 0.9014, 0.9823, 0.9980, 0.9999,  &
0.0085, 0.0290, 0.0928, 0.2023, 0.2385, 0.2514, 0.3206, 0.3810, 0.8699 /
data ((cldnuctab( 2,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.3061, 0.5258, 0.7636, 0.9210, 0.9856, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.2385, 0.4285, 0.6672, 0.8611, 0.9656, 0.9957, 0.9997, 0.9999, 0.9999,  &
0.1695, 0.3353, 0.5742, 0.7880, 0.9323, 0.9883, 0.9989, 0.9999, 0.9999,  &
0.0928, 0.2385, 0.4607, 0.7104, 0.8864, 0.9739, 0.9967, 0.9998, 0.9999,  &
0.0416, 0.1315, 0.3206, 0.5902, 0.8217, 0.9469, 0.9916, 0.9993, 0.9999,  &
0.0162, 0.0584, 0.1695, 0.4125, 0.6963, 0.8941, 0.9763, 0.9970, 0.9998,  &
0.0061, 0.0218, 0.0741, 0.2023, 0.4125, 0.5902, 0.8217, 0.9424, 0.9957 /
data ((cldnuctab( 2,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.2514, 0.4445, 0.6819, 0.8784, 0.9739, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.1800, 0.3503, 0.5742, 0.7996, 0.9375, 0.9906, 0.9993, 0.9999, 0.9999,  &
0.1230, 0.2645, 0.4770, 0.7104, 0.8864, 0.9739, 0.9970, 0.9998, 0.9999,  &
0.0741, 0.1800, 0.3810, 0.6060, 0.8217, 0.9469, 0.9916, 0.9994, 0.9999,  &
0.0349, 0.0998, 0.2514, 0.4932, 0.7377, 0.9083, 0.9805, 0.9980, 0.9998,  &
0.0131, 0.0416, 0.1315, 0.3353, 0.6216, 0.8422, 0.9589, 0.9940, 0.9995,  &
0.0048, 0.0162, 0.0584, 0.1695, 0.3967, 0.6522, 0.8699, 0.9714, 0.9962 /
data ((cldnuctab( 2,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.2023, 0.3810, 0.6060, 0.8322, 0.9552, 0.9952, 0.9997, 0.9999, 0.9999,  &
0.1404, 0.2919, 0.4932, 0.7377, 0.9083, 0.9823, 0.9984, 0.9999, 0.9999,  &
0.0998, 0.2140, 0.3967, 0.6370, 0.8322, 0.9552, 0.9940, 0.9996, 0.9999,  &
0.0584, 0.1497, 0.3061, 0.5258, 0.7508, 0.9148, 0.9823, 0.9984, 0.9999,  &
0.0264, 0.0800, 0.2023, 0.4125, 0.6672, 0.8611, 0.9624, 0.9946, 0.9996,  &
0.0106, 0.0349, 0.0998, 0.2645, 0.5258, 0.7760, 0.9323, 0.9870, 0.9988,  &
0.0038, 0.0131, 0.0416, 0.1315, 0.3353, 0.6216, 0.8519, 0.9624, 0.9946 /
data ((cldnuctab( 2,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.1695, 0.3353, 0.5582, 0.7880, 0.9375, 0.9916, 0.9995, 0.9999, 0.9999,  &
0.1149, 0.2385, 0.4445, 0.6672, 0.8699, 0.9714, 0.9974, 0.9998, 0.9999,  &
0.0800, 0.1800, 0.3353, 0.5582, 0.7880, 0.9323, 0.9895, 0.9993, 0.9999,  &
0.0494, 0.1230, 0.2514, 0.4607, 0.6819, 0.8784, 0.9714, 0.9967, 0.9998,  &
0.0218, 0.0633, 0.1695, 0.3503, 0.5902, 0.7996, 0.9375, 0.9895, 0.9992,  &
0.0085, 0.0264, 0.0800, 0.2140, 0.4607, 0.7104, 0.8941, 0.9739, 0.9970,  &
0.0033, 0.0106, 0.0349, 0.1071, 0.2781, 0.5420, 0.7996, 0.9424, 0.9895 /
data ((cldnuctab( 2,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.1497, 0.2919, 0.5095, 0.7508, 0.9268, 0.9883, 0.9993, 0.9999, 0.9999,  &
0.0998, 0.2140, 0.3967, 0.6216, 0.8422, 0.9624, 0.9957, 0.9998, 0.9999,  &
0.0685, 0.1497, 0.2919, 0.5095, 0.7377, 0.9083, 0.9840, 0.9988, 0.9999,  &
0.0416, 0.0998, 0.2140, 0.3967, 0.6370, 0.8322, 0.9552, 0.9940, 0.9996,  &
0.0198, 0.0538, 0.1404, 0.2919, 0.5258, 0.7508, 0.9148, 0.9823, 0.9984,  &
0.0076, 0.0240, 0.0685, 0.1800, 0.3967, 0.6370, 0.8519, 0.9589, 0.9940,  &
0.0038, 0.0085, 0.0290, 0.0862, 0.2261, 0.4770, 0.7508, 0.9148, 0.9840 /
data ((cldnuctab( 2,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.1404, 0.2781, 0.4770, 0.7242, 0.9083, 0.9856, 0.9990, 0.9999, 0.9999,  &
0.0928, 0.1910, 0.3656, 0.5902, 0.8109, 0.9512, 0.9946, 0.9997, 0.9999,  &
0.0584, 0.1315, 0.2645, 0.4770, 0.6963, 0.8864, 0.9785, 0.9982, 0.9999,  &
0.0349, 0.0862, 0.1910, 0.3656, 0.5902, 0.7996, 0.9424, 0.9916, 0.9994,  &
0.0179, 0.0494, 0.1230, 0.2645, 0.4770, 0.7104, 0.8864, 0.9739, 0.9974,  &
0.0068, 0.0198, 0.0584, 0.1594, 0.3503, 0.5902, 0.8109, 0.9424, 0.9906,  &
0.0042, 0.0076, 0.0240, 0.0741, 0.2023, 0.4285, 0.6963, 0.8864, 0.9763 /
data ((cldnuctab( 2,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.4285, 0.6672, 0.8611, 0.9656, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3353, 0.5742, 0.7880, 0.9323, 0.9883, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.2385, 0.4607, 0.7104, 0.8864, 0.9739, 0.9967, 0.9998, 0.9999, 0.9999,  &
0.1315, 0.3353, 0.5902, 0.8217, 0.9469, 0.9916, 0.9993, 0.9999, 0.9999,  &
0.0584, 0.1800, 0.4285, 0.7104, 0.9014, 0.9805, 0.9977, 0.9998, 0.9999,  &
0.0218, 0.0741, 0.2261, 0.4770, 0.7242, 0.9148, 0.9823, 0.9984, 0.9999,  &
0.0095, 0.0318, 0.0928, 0.2023, 0.2385, 0.2514, 0.3061, 0.3810, 0.8784 /
data ((cldnuctab( 2,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.3503, 0.5742, 0.7880, 0.9375, 0.9895, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.2645, 0.4770, 0.6963, 0.8864, 0.9739, 0.9970, 0.9998, 0.9999, 0.9999,  &
0.1800, 0.3656, 0.6060, 0.8217, 0.9469, 0.9916, 0.9993, 0.9999, 0.9999,  &
0.0998, 0.2514, 0.4932, 0.7377, 0.9014, 0.9785, 0.9977, 0.9998, 0.9999,  &
0.0454, 0.1404, 0.3353, 0.6216, 0.8422, 0.9589, 0.9940, 0.9995, 0.9999,  &
0.0162, 0.0584, 0.1800, 0.4285, 0.7104, 0.9083, 0.9823, 0.9980, 0.9998,  &
0.0061, 0.0218, 0.0741, 0.2140, 0.4125, 0.6060, 0.8322, 0.9512, 0.9967 /
data ((cldnuctab( 2,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.2781, 0.4770, 0.7104, 0.8941, 0.9805, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.2023, 0.3810, 0.6060, 0.8217, 0.9512, 0.9932, 0.9995, 0.9999, 0.9999,  &
0.1404, 0.2919, 0.5095, 0.7377, 0.9083, 0.9805, 0.9980, 0.9999, 0.9999,  &
0.0800, 0.2023, 0.4125, 0.6522, 0.8519, 0.9589, 0.9940, 0.9996, 0.9999,  &
0.0349, 0.1071, 0.2781, 0.5258, 0.7760, 0.9268, 0.9856, 0.9986, 0.9999,  &
0.0131, 0.0454, 0.1404, 0.3503, 0.6522, 0.8699, 0.9686, 0.9952, 0.9997,  &
0.0048, 0.0162, 0.0584, 0.1695, 0.4125, 0.6672, 0.8784, 0.9763, 0.9974 /
data ((cldnuctab( 2,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.2261, 0.4125, 0.6522, 0.8519, 0.9656, 0.9962, 0.9998, 0.9999, 0.9999,  &
0.1594, 0.3206, 0.5420, 0.7636, 0.9210, 0.9870, 0.9989, 0.9999, 0.9999,  &
0.1149, 0.2385, 0.4285, 0.6672, 0.8611, 0.9656, 0.9957, 0.9997, 0.9999,  &
0.0633, 0.1594, 0.3353, 0.5582, 0.7880, 0.9323, 0.9870, 0.9989, 0.9999,  &
0.0290, 0.0862, 0.2140, 0.4445, 0.6963, 0.8784, 0.9714, 0.9962, 0.9997,  &
0.0106, 0.0349, 0.1071, 0.2781, 0.5582, 0.7996, 0.9424, 0.9906, 0.9990,  &
0.0048, 0.0131, 0.0454, 0.1404, 0.3503, 0.6370, 0.8699, 0.9686, 0.9957 /
data ((cldnuctab( 2,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.1910, 0.3656, 0.5902, 0.8109, 0.9512, 0.9940, 0.9997, 0.9999, 0.9999,  &
0.1315, 0.2645, 0.4770, 0.7104, 0.8941, 0.9785, 0.9982, 0.9999, 0.9999,  &
0.0928, 0.2023, 0.3656, 0.6060, 0.8109, 0.9469, 0.9924, 0.9994, 0.9999,  &
0.0538, 0.1315, 0.2781, 0.4932, 0.7242, 0.8941, 0.9785, 0.9977, 0.9998,  &
0.0240, 0.0685, 0.1800, 0.3810, 0.6216, 0.8322, 0.9512, 0.9924, 0.9994,  &
0.0085, 0.0290, 0.0862, 0.2261, 0.4770, 0.7377, 0.9083, 0.9805, 0.9980,  &
0.0054, 0.0106, 0.0349, 0.1071, 0.2919, 0.5742, 0.8217, 0.9552, 0.9924 /
data ((cldnuctab( 2,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.1695, 0.3206, 0.5582, 0.7880, 0.9375, 0.9916, 0.9995, 0.9999, 0.9999,  &
0.1149, 0.2385, 0.4285, 0.6672, 0.8611, 0.9714, 0.9970, 0.9998, 0.9999,  &
0.0741, 0.1695, 0.3206, 0.5420, 0.7760, 0.9268, 0.9883, 0.9992, 0.9999,  &
0.0454, 0.1149, 0.2385, 0.4285, 0.6672, 0.8611, 0.9656, 0.9957, 0.9997,  &
0.0198, 0.0584, 0.1497, 0.3206, 0.5582, 0.7760, 0.9268, 0.9870, 0.9988,  &
0.0076, 0.0240, 0.0741, 0.1910, 0.4125, 0.6672, 0.8699, 0.9686, 0.9957,  &
0.0054, 0.0085, 0.0290, 0.0862, 0.2385, 0.5095, 0.7760, 0.9323, 0.9870 /
data ((cldnuctab( 2,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.1497, 0.3061, 0.5258, 0.7636, 0.9268, 0.9895, 0.9994, 0.9999, 0.9999,  &
0.1071, 0.2140, 0.3967, 0.6216, 0.8422, 0.9624, 0.9962, 0.9998, 0.9999,  &
0.0685, 0.1497, 0.2919, 0.5095, 0.7377, 0.9083, 0.9840, 0.9988, 0.9999,  &
0.0416, 0.0998, 0.2140, 0.3967, 0.6216, 0.8322, 0.9552, 0.9940, 0.9996,  &
0.0179, 0.0538, 0.1315, 0.2919, 0.5095, 0.7377, 0.9014, 0.9805, 0.9982,  &
0.0068, 0.0218, 0.0633, 0.1695, 0.3656, 0.6216, 0.8322, 0.9552, 0.9932,  &
0.0061, 0.0076, 0.0240, 0.0741, 0.2023, 0.4445, 0.7242, 0.9083, 0.9805 /
data ((cldnuctab( 3,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.3065, 0.5182, 0.7687, 0.9291, 0.9903, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2311, 0.4270, 0.6769, 0.8745, 0.9731, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.1673, 0.3395, 0.5727, 0.7957, 0.9460, 0.9925, 0.9996, 0.9999, 0.9999,  &
0.0991, 0.2453, 0.4815, 0.7247, 0.9007, 0.9806, 0.9985, 0.9999, 0.9999,  &
0.0490, 0.1453, 0.3565, 0.6084, 0.8438, 0.9595, 0.9949, 0.9997, 0.9999,  &
0.0193, 0.0707, 0.2041, 0.4270, 0.6769, 0.8837, 0.9731, 0.9974, 0.9999,  &
0.0074, 0.0268, 0.0913, 0.2041, 0.2751, 0.3229, 0.3229, 0.3395, 0.9158 /
data ((cldnuctab( 3,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.2311, 0.4270, 0.6602, 0.8745, 0.9758, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.1673, 0.3395, 0.5727, 0.7957, 0.9407, 0.9934, 0.9997, 0.9999, 0.9999,  &
0.1161, 0.2600, 0.4632, 0.7091, 0.8924, 0.9806, 0.9985, 0.9999, 0.9999,  &
0.0772, 0.1790, 0.3738, 0.6084, 0.8325, 0.9553, 0.9949, 0.9998, 0.9999,  &
0.0366, 0.1074, 0.2751, 0.4998, 0.7545, 0.9158, 0.9862, 0.9990, 0.9999,  &
0.0154, 0.0490, 0.1560, 0.3565, 0.6259, 0.8545, 0.9668, 0.9955, 0.9998,  &
0.0057, 0.0193, 0.0707, 0.1913, 0.3913, 0.6084, 0.8085, 0.9460, 0.9949 /
data ((cldnuctab( 3,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.1790, 0.3395, 0.5727, 0.8085, 0.9553, 0.9955, 0.9998, 0.9999, 0.9999,  &
0.1253, 0.2600, 0.4632, 0.7091, 0.9007, 0.9826, 0.9990, 0.9999, 0.9999,  &
0.0913, 0.1913, 0.3738, 0.6084, 0.8325, 0.9553, 0.9955, 0.9998, 0.9999,  &
0.0539, 0.1350, 0.2906, 0.5182, 0.7545, 0.9158, 0.9862, 0.9990, 0.9999,  &
0.0298, 0.0840, 0.2041, 0.4090, 0.6602, 0.8647, 0.9668, 0.9966, 0.9998,  &
0.0122, 0.0366, 0.1161, 0.2906, 0.5364, 0.7824, 0.9351, 0.9903, 0.9993,  &
0.0044, 0.0154, 0.0539, 0.1560, 0.3565, 0.6259, 0.8438, 0.9553, 0.9942 /
data ((cldnuctab( 3,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.1453, 0.2906, 0.4998, 0.7545, 0.9291, 0.9915, 0.9996, 0.9999, 0.9999,  &
0.0991, 0.2041, 0.3913, 0.6432, 0.8545, 0.9668, 0.9974, 0.9999, 0.9999,  &
0.0647, 0.1560, 0.3065, 0.5182, 0.7545, 0.9227, 0.9891, 0.9995, 0.9999,  &
0.0404, 0.1074, 0.2311, 0.4270, 0.6602, 0.8647, 0.9701, 0.9974, 0.9999,  &
0.0216, 0.0647, 0.1560, 0.3395, 0.5546, 0.7957, 0.9351, 0.9915, 0.9995,  &
0.0096, 0.0298, 0.0913, 0.2311, 0.4450, 0.7091, 0.8924, 0.9783, 0.9980,  &
0.0033, 0.0122, 0.0404, 0.1161, 0.2906, 0.5546, 0.7957, 0.9460, 0.9903 /
data ((cldnuctab( 3,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.1161, 0.2453, 0.4450, 0.6932, 0.9007, 0.9845, 0.9993, 0.9999, 0.9999,  &
0.0772, 0.1790, 0.3395, 0.5727, 0.8085, 0.9508, 0.9949, 0.9998, 0.9999,  &
0.0539, 0.1253, 0.2600, 0.4632, 0.6932, 0.8924, 0.9806, 0.9987, 0.9999,  &
0.0330, 0.0840, 0.1913, 0.3565, 0.5907, 0.8085, 0.9508, 0.9942, 0.9997,  &
0.0173, 0.0490, 0.1253, 0.2751, 0.4815, 0.7247, 0.9007, 0.9806, 0.9985,  &
0.0074, 0.0241, 0.0707, 0.1790, 0.3738, 0.6259, 0.8325, 0.9553, 0.9949,  &
0.0029, 0.0096, 0.0298, 0.0913, 0.2453, 0.4815, 0.7398, 0.9158, 0.9826 /
data ((cldnuctab( 3,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.0991, 0.2173, 0.4090, 0.6602, 0.8745, 0.9783, 0.9989, 0.9999, 0.9999,  &
0.0647, 0.1560, 0.3065, 0.5182, 0.7687, 0.9351, 0.9925, 0.9997, 0.9999,  &
0.0446, 0.1074, 0.2173, 0.4090, 0.6432, 0.8545, 0.9701, 0.9977, 0.9999,  &
0.0268, 0.0707, 0.1560, 0.3065, 0.5364, 0.7545, 0.9227, 0.9891, 0.9995,  &
0.0154, 0.0404, 0.1074, 0.2311, 0.4270, 0.6602, 0.8647, 0.9668, 0.9970,  &
0.0065, 0.0193, 0.0591, 0.1453, 0.3229, 0.5546, 0.7824, 0.9291, 0.9891,  &
0.0025, 0.0084, 0.0241, 0.0772, 0.2041, 0.4090, 0.6769, 0.8745, 0.9701 /
data ((cldnuctab( 3,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.0913, 0.2041, 0.3913, 0.6259, 0.8545, 0.9731, 0.9983, 0.9999, 0.9999,  &
0.0591, 0.1350, 0.2751, 0.4815, 0.7398, 0.9158, 0.9891, 0.9995, 0.9999,  &
0.0366, 0.0913, 0.1913, 0.3738, 0.6084, 0.8325, 0.9595, 0.9966, 0.9998,  &
0.0241, 0.0591, 0.1350, 0.2751, 0.4815, 0.7247, 0.9007, 0.9845, 0.9990,  &
0.0137, 0.0366, 0.0913, 0.2041, 0.3738, 0.6084, 0.8207, 0.9553, 0.9949,  &
0.0057, 0.0173, 0.0490, 0.1253, 0.2751, 0.4998, 0.7247, 0.9085, 0.9826,  &
0.0022, 0.0074, 0.0216, 0.0647, 0.1673, 0.3738, 0.6084, 0.8325, 0.9553 /
data ((cldnuctab( 3,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.4090, 0.6432, 0.8438, 0.9595, 0.9955, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3065, 0.5364, 0.7687, 0.9227, 0.9862, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2311, 0.4450, 0.6769, 0.8745, 0.9701, 0.9966, 0.9998, 0.9999, 0.9999,  &
0.1253, 0.3065, 0.5727, 0.8085, 0.9407, 0.9915, 0.9994, 0.9999, 0.9999,  &
0.0539, 0.1673, 0.4090, 0.6932, 0.8924, 0.9783, 0.9977, 0.9998, 0.9999,  &
0.0216, 0.0772, 0.2173, 0.4632, 0.7091, 0.9085, 0.9826, 0.9987, 0.9999,  &
0.0084, 0.0298, 0.0913, 0.2041, 0.2453, 0.2453, 0.3065, 0.3738, 0.8745 /
data ((cldnuctab( 3,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.3229, 0.5364, 0.7687, 0.9291, 0.9891, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.2453, 0.4450, 0.6769, 0.8647, 0.9701, 0.9970, 0.9998, 0.9999, 0.9999,  &
0.1673, 0.3395, 0.5727, 0.7957, 0.9407, 0.9903, 0.9994, 0.9999, 0.9999,  &
0.0991, 0.2453, 0.4632, 0.7091, 0.8924, 0.9758, 0.9977, 0.9999, 0.9999,  &
0.0446, 0.1350, 0.3229, 0.6084, 0.8325, 0.9553, 0.9934, 0.9995, 0.9999,  &
0.0173, 0.0591, 0.1790, 0.4090, 0.6932, 0.9007, 0.9806, 0.9980, 0.9999,  &
0.0057, 0.0216, 0.0772, 0.2041, 0.4090, 0.6084, 0.8325, 0.9508, 0.9966 /
data ((cldnuctab( 3,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.2453, 0.4450, 0.6932, 0.8837, 0.9758, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.1790, 0.3565, 0.5907, 0.8085, 0.9407, 0.9925, 0.9996, 0.9999, 0.9999,  &
0.1253, 0.2751, 0.4815, 0.7091, 0.8924, 0.9783, 0.9980, 0.9999, 0.9999,  &
0.0772, 0.1913, 0.3738, 0.6259, 0.8325, 0.9553, 0.9934, 0.9996, 0.9999,  &
0.0330, 0.0991, 0.2600, 0.4998, 0.7545, 0.9158, 0.9845, 0.9985, 0.9999,  &
0.0122, 0.0446, 0.1350, 0.3395, 0.6259, 0.8545, 0.9633, 0.9955, 0.9997,  &
0.0044, 0.0173, 0.0591, 0.1673, 0.3913, 0.6602, 0.8745, 0.9758, 0.9974 /
data ((cldnuctab( 3,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.2041, 0.3913, 0.6084, 0.8325, 0.9595, 0.9961, 0.9998, 0.9999, 0.9999,  &
0.1453, 0.2906, 0.4998, 0.7398, 0.9085, 0.9845, 0.9990, 0.9999, 0.9999,  &
0.0991, 0.2173, 0.4090, 0.6432, 0.8438, 0.9595, 0.9955, 0.9998, 0.9999,  &
0.0591, 0.1453, 0.3065, 0.5364, 0.7545, 0.9227, 0.9862, 0.9989, 0.9999,  &
0.0268, 0.0772, 0.2041, 0.4270, 0.6602, 0.8647, 0.9668, 0.9961, 0.9998,  &
0.0108, 0.0330, 0.1074, 0.2751, 0.5364, 0.7824, 0.9351, 0.9891, 0.9992,  &
0.0038, 0.0122, 0.0446, 0.1350, 0.3395, 0.6259, 0.8545, 0.9668, 0.9955 /
data ((cldnuctab( 3,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.1673, 0.3395, 0.5546, 0.7957, 0.9460, 0.9934, 0.9997, 0.9999, 0.9999,  &
0.1161, 0.2453, 0.4450, 0.6769, 0.8745, 0.9758, 0.9980, 0.9999, 0.9999,  &
0.0772, 0.1790, 0.3395, 0.5727, 0.7957, 0.9351, 0.9915, 0.9995, 0.9999,  &
0.0490, 0.1161, 0.2600, 0.4632, 0.6932, 0.8837, 0.9731, 0.9974, 0.9999,  &
0.0216, 0.0647, 0.1673, 0.3565, 0.5907, 0.8085, 0.9407, 0.9915, 0.9995,  &
0.0084, 0.0268, 0.0840, 0.2173, 0.4632, 0.7091, 0.8924, 0.9783, 0.9977,  &
0.0033, 0.0108, 0.0330, 0.1074, 0.2751, 0.5546, 0.8085, 0.9460, 0.9915 /
data ((cldnuctab( 3,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.1560, 0.3065, 0.5182, 0.7545, 0.9291, 0.9903, 0.9995, 0.9999, 0.9999,  &
0.0991, 0.2173, 0.3913, 0.6259, 0.8438, 0.9668, 0.9970, 0.9998, 0.9999,  &
0.0707, 0.1560, 0.3065, 0.5182, 0.7398, 0.9158, 0.9862, 0.9990, 0.9999,  &
0.0404, 0.0991, 0.2173, 0.4090, 0.6432, 0.8438, 0.9595, 0.9955, 0.9998,  &
0.0193, 0.0539, 0.1453, 0.3065, 0.5182, 0.7545, 0.9158, 0.9845, 0.9987,  &
0.0074, 0.0241, 0.0707, 0.1790, 0.3913, 0.6432, 0.8545, 0.9633, 0.9955,  &
0.0038, 0.0084, 0.0268, 0.0840, 0.2311, 0.4815, 0.7545, 0.9227, 0.9862 /
data ((cldnuctab( 3,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.1350, 0.2751, 0.4815, 0.7247, 0.9158, 0.9877, 0.9994, 0.9999, 0.9999,  &
0.0913, 0.1913, 0.3738, 0.5907, 0.8207, 0.9553, 0.9955, 0.9998, 0.9999,  &
0.0591, 0.1350, 0.2751, 0.4815, 0.7091, 0.8924, 0.9806, 0.9987, 0.9999,  &
0.0366, 0.0913, 0.1913, 0.3738, 0.5907, 0.8085, 0.9460, 0.9934, 0.9996,  &
0.0173, 0.0490, 0.1253, 0.2600, 0.4815, 0.7091, 0.8924, 0.9783, 0.9980,  &
0.0065, 0.0216, 0.0591, 0.1560, 0.3565, 0.5907, 0.8085, 0.9460, 0.9925,  &
0.0044, 0.0074, 0.0241, 0.0707, 0.2041, 0.4270, 0.7091, 0.8924, 0.9783 /
data ((cldnuctab( 3,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.5182, 0.7398, 0.9085, 0.9826, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4090, 0.6432, 0.8438, 0.9595, 0.9949, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2751, 0.5364, 0.7687, 0.9227, 0.9862, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.1453, 0.3738, 0.6602, 0.8745, 0.9701, 0.9961, 0.9997, 0.9999, 0.9999,  &
0.0591, 0.1913, 0.4632, 0.7687, 0.9351, 0.9891, 0.9990, 0.9999, 0.9999,  &
0.0241, 0.0840, 0.2311, 0.4998, 0.7545, 0.9351, 0.9903, 0.9995, 0.9999,  &
0.0122, 0.0330, 0.0991, 0.1913, 0.2173, 0.2311, 0.2453, 0.4090, 0.8837 /
data ((cldnuctab( 3,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.4090, 0.6432, 0.8545, 0.9633, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3229, 0.5546, 0.7687, 0.9227, 0.9862, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.4450, 0.6769, 0.8745, 0.9701, 0.9961, 0.9998, 0.9999, 0.9999,  &
0.1161, 0.2906, 0.5546, 0.7957, 0.9407, 0.9891, 0.9992, 0.9999, 0.9999,  &
0.0446, 0.1453, 0.3738, 0.6769, 0.8924, 0.9758, 0.9974, 0.9998, 0.9999,  &
0.0173, 0.0591, 0.1913, 0.4632, 0.7545, 0.9351, 0.9903, 0.9992, 0.9999,  &
0.0108, 0.0268, 0.0772, 0.2173, 0.3913, 0.5907, 0.8438, 0.9633, 0.9985 /
data ((cldnuctab( 3,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.3395, 0.5546, 0.7824, 0.9351, 0.9903, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2600, 0.4632, 0.6932, 0.8745, 0.9731, 0.9970, 0.9998, 0.9999, 0.9999,  &
0.1673, 0.3565, 0.5907, 0.8085, 0.9407, 0.9903, 0.9993, 0.9999, 0.9999,  &
0.0913, 0.2311, 0.4632, 0.7247, 0.8924, 0.9783, 0.9974, 0.9998, 0.9999,  &
0.0366, 0.1161, 0.3065, 0.5907, 0.8325, 0.9553, 0.9925, 0.9995, 0.9999,  &
0.0137, 0.0446, 0.1453, 0.3738, 0.6932, 0.9085, 0.9826, 0.9980, 0.9998,  &
0.0096, 0.0193, 0.0591, 0.1790, 0.4270, 0.6932, 0.9085, 0.9862, 0.9989 /
data ((cldnuctab( 3,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.2906, 0.4998, 0.7247, 0.9007, 0.9826, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.2041, 0.3913, 0.6259, 0.8325, 0.9553, 0.9942, 0.9996, 0.9999, 0.9999,  &
0.1350, 0.2906, 0.5182, 0.7398, 0.9085, 0.9806, 0.9983, 0.9999, 0.9999,  &
0.0707, 0.1913, 0.3913, 0.6432, 0.8438, 0.9595, 0.9942, 0.9996, 0.9999,  &
0.0298, 0.0913, 0.2453, 0.4998, 0.7545, 0.9227, 0.9845, 0.9985, 0.9999,  &
0.0108, 0.0366, 0.1161, 0.3065, 0.6084, 0.8545, 0.9668, 0.9955, 0.9996,  &
0.0108, 0.0137, 0.0446, 0.1453, 0.3738, 0.6602, 0.8924, 0.9826, 0.9980 /
data ((cldnuctab( 3,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.2453, 0.4270, 0.6769, 0.8745, 0.9731, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.1790, 0.3395, 0.5546, 0.7824, 0.9291, 0.9891, 0.9993, 0.9999, 0.9999,  &
0.1161, 0.2453, 0.4450, 0.6769, 0.8647, 0.9701, 0.9966, 0.9998, 0.9999,  &
0.0591, 0.1560, 0.3395, 0.5727, 0.7957, 0.9351, 0.9891, 0.9990, 0.9999,  &
0.0241, 0.0772, 0.2041, 0.4270, 0.6932, 0.8837, 0.9731, 0.9966, 0.9998,  &
0.0108, 0.0298, 0.0913, 0.2600, 0.5364, 0.7957, 0.9407, 0.9903, 0.9992,  &
0.0108, 0.0122, 0.0366, 0.1161, 0.3065, 0.6084, 0.8647, 0.9701, 0.9966 /
data ((cldnuctab( 3,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.2173, 0.3913, 0.6259, 0.8438, 0.9633, 0.9966, 0.9998, 0.9999, 0.9999,  &
0.1560, 0.2906, 0.4998, 0.7398, 0.9085, 0.9845, 0.9989, 0.9999, 0.9999,  &
0.0991, 0.2173, 0.3913, 0.6259, 0.8325, 0.9553, 0.9942, 0.9997, 0.9999,  &
0.0539, 0.1350, 0.2906, 0.4998, 0.7398, 0.9085, 0.9826, 0.9983, 0.9999,  &
0.0216, 0.0647, 0.1790, 0.3738, 0.6259, 0.8325, 0.9553, 0.9934, 0.9996,  &
0.0122, 0.0268, 0.0772, 0.2173, 0.4632, 0.7398, 0.9085, 0.9826, 0.9983,  &
0.0108, 0.0137, 0.0298, 0.0913, 0.2600, 0.5364, 0.8207, 0.9553, 0.9942 /
data ((cldnuctab( 3,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.1913, 0.3738, 0.5907, 0.8207, 0.9553, 0.9955, 0.9998, 0.9999, 0.9999,  &
0.1350, 0.2751, 0.4632, 0.7091, 0.8924, 0.9806, 0.9985, 0.9999, 0.9999,  &
0.0913, 0.1913, 0.3565, 0.5907, 0.7957, 0.9407, 0.9925, 0.9995, 0.9999,  &
0.0490, 0.1253, 0.2600, 0.4632, 0.6932, 0.8837, 0.9731, 0.9974, 0.9998,  &
0.0193, 0.0591, 0.1560, 0.3395, 0.5727, 0.7957, 0.9407, 0.9903, 0.9993,  &
0.0122, 0.0216, 0.0707, 0.1913, 0.4090, 0.6932, 0.8837, 0.9731, 0.9970,  &
0.0122, 0.0137, 0.0268, 0.0772, 0.2173, 0.4815, 0.7687, 0.9351, 0.9903 /
data ((cldnuctab( 3,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.6259, 0.8325, 0.9508, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.7545, 0.9085, 0.9826, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3229, 0.6259, 0.8545, 0.9595, 0.9942, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.1560, 0.4090, 0.7398, 0.9227, 0.9862, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.0647, 0.2041, 0.4998, 0.8207, 0.9633, 0.9955, 0.9996, 0.9999, 0.9999,  &
0.0330, 0.0913, 0.2311, 0.4998, 0.7545, 0.9508, 0.9955, 0.9998, 0.9999,  &
0.0268, 0.0490, 0.0991, 0.1790, 0.2041, 0.2311, 0.2600, 0.3565, 0.8207 /
data ((cldnuctab( 3,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.5182, 0.7545, 0.9158, 0.9826, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4090, 0.6602, 0.8545, 0.9633, 0.9949, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2600, 0.5364, 0.7687, 0.9291, 0.9862, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.1253, 0.3395, 0.6432, 0.8745, 0.9701, 0.9961, 0.9997, 0.9999, 0.9999,  &
0.0490, 0.1560, 0.4090, 0.7545, 0.9351, 0.9891, 0.9990, 0.9999, 0.9999,  &
0.0268, 0.0647, 0.2041, 0.4815, 0.7957, 0.9595, 0.9961, 0.9996, 0.9999,  &
0.0268, 0.0366, 0.0913, 0.2173, 0.3738, 0.5727, 0.7824, 0.9701, 0.9990 /
data ((cldnuctab( 3,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.4450, 0.6769, 0.8647, 0.9668, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.5727, 0.7957, 0.9351, 0.9877, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.4450, 0.6932, 0.8837, 0.9731, 0.9966, 0.9998, 0.9999, 0.9999,  &
0.0991, 0.2751, 0.5546, 0.8085, 0.9407, 0.9903, 0.9992, 0.9999, 0.9999,  &
0.0404, 0.1253, 0.3395, 0.6602, 0.8924, 0.9783, 0.9974, 0.9998, 0.9999,  &
0.0268, 0.0490, 0.1560, 0.4090, 0.7545, 0.9407, 0.9915, 0.9993, 0.9999,  &
0.0268, 0.0330, 0.0707, 0.1913, 0.4270, 0.7091, 0.9227, 0.9903, 0.9995 /
data ((cldnuctab( 3,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.3738, 0.6084, 0.8207, 0.9508, 0.9934, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2751, 0.4998, 0.7247, 0.9007, 0.9783, 0.9977, 0.9998, 0.9999, 0.9999,  &
0.1790, 0.3738, 0.6259, 0.8325, 0.9508, 0.9925, 0.9995, 0.9999, 0.9999,  &
0.0840, 0.2311, 0.4815, 0.7398, 0.9085, 0.9806, 0.9980, 0.9998, 0.9999,  &
0.0330, 0.0991, 0.2751, 0.5727, 0.8325, 0.9553, 0.9934, 0.9995, 0.9999,  &
0.0268, 0.0404, 0.1253, 0.3395, 0.6769, 0.9085, 0.9826, 0.9983, 0.9998,  &
0.0268, 0.0330, 0.0539, 0.1560, 0.3738, 0.6932, 0.9227, 0.9903, 0.9993 /
data ((cldnuctab( 3,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.3229, 0.5546, 0.7687, 0.9291, 0.9891, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.2453, 0.4270, 0.6602, 0.8647, 0.9668, 0.9961, 0.9998, 0.9999, 0.9999,  &
0.1560, 0.3229, 0.5546, 0.7687, 0.9291, 0.9862, 0.9989, 0.9999, 0.9999,  &
0.0707, 0.1913, 0.4090, 0.6602, 0.8647, 0.9668, 0.9955, 0.9997, 0.9999,  &
0.0298, 0.0840, 0.2311, 0.4998, 0.7687, 0.9291, 0.9877, 0.9989, 0.9999,  &
0.0268, 0.0330, 0.0991, 0.2751, 0.5907, 0.8647, 0.9701, 0.9961, 0.9997,  &
0.0268, 0.0330, 0.0446, 0.1253, 0.3229, 0.6432, 0.9007, 0.9845, 0.9987 /
data ((cldnuctab( 3,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.2906, 0.4998, 0.7398, 0.9085, 0.9845, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.3913, 0.6259, 0.8325, 0.9553, 0.9942, 0.9996, 0.9999, 0.9999,  &
0.1350, 0.2906, 0.4998, 0.7247, 0.9007, 0.9806, 0.9980, 0.9999, 0.9999,  &
0.0647, 0.1673, 0.3565, 0.6084, 0.8207, 0.9508, 0.9925, 0.9995, 0.9999,  &
0.0298, 0.0707, 0.2041, 0.4450, 0.7247, 0.9007, 0.9783, 0.9977, 0.9998,  &
0.0298, 0.0330, 0.0840, 0.2311, 0.5182, 0.8085, 0.9508, 0.9925, 0.9995,  &
0.0298, 0.0330, 0.0404, 0.0991, 0.2751, 0.5727, 0.8647, 0.9758, 0.9977 /
data ((cldnuctab( 3,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.2751, 0.4815, 0.7091, 0.8924, 0.9806, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.1913, 0.3565, 0.5907, 0.7957, 0.9407, 0.9925, 0.9995, 0.9999, 0.9999,  &
0.1161, 0.2600, 0.4632, 0.6932, 0.8745, 0.9731, 0.9974, 0.9998, 0.9999,  &
0.0539, 0.1453, 0.3229, 0.5727, 0.7957, 0.9351, 0.9891, 0.9992, 0.9999,  &
0.0330, 0.0647, 0.1790, 0.3913, 0.6769, 0.8745, 0.9701, 0.9966, 0.9998,  &
0.0330, 0.0366, 0.0707, 0.2041, 0.4632, 0.7687, 0.9291, 0.9877, 0.9990,  &
0.0330, 0.0366, 0.0404, 0.0913, 0.2311, 0.5182, 0.8325, 0.9633, 0.9961 /
data ((cldnuctab( 3,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.6769, 0.8745, 0.9701, 0.9961, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5546, 0.7957, 0.9407, 0.9891, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3565, 0.6769, 0.8837, 0.9758, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1673, 0.4450, 0.7687, 0.9460, 0.9915, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.0707, 0.2041, 0.5182, 0.8438, 0.9731, 0.9974, 0.9998, 0.9999, 0.9999,  &
0.0490, 0.0991, 0.2453, 0.4815, 0.7545, 0.9553, 0.9966, 0.9998, 0.9999,  &
0.0446, 0.0591, 0.1074, 0.1673, 0.2041, 0.2311, 0.2600, 0.3738, 0.8207 /
data ((cldnuctab( 3,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.5907, 0.8085, 0.9407, 0.9903, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4632, 0.7091, 0.8924, 0.9758, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2906, 0.5727, 0.8207, 0.9508, 0.9915, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.1350, 0.3565, 0.6932, 0.9007, 0.9806, 0.9977, 0.9998, 0.9999, 0.9999,  &
0.0539, 0.1673, 0.4270, 0.7824, 0.9553, 0.9942, 0.9995, 0.9999, 0.9999,  &
0.0446, 0.0707, 0.2041, 0.4815, 0.8207, 0.9668, 0.9974, 0.9998, 0.9999,  &
0.0446, 0.0539, 0.0991, 0.2173, 0.3738, 0.5364, 0.7687, 0.9701, 0.9993 /
data ((cldnuctab( 3,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.4998, 0.7398, 0.9085, 0.9806, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3913, 0.6259, 0.8438, 0.9553, 0.9934, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2311, 0.4998, 0.7545, 0.9158, 0.9826, 0.9980, 0.9998, 0.9999, 0.9999,  &
0.1074, 0.2906, 0.5907, 0.8438, 0.9633, 0.9942, 0.9995, 0.9999, 0.9999,  &
0.0446, 0.1253, 0.3565, 0.6932, 0.9158, 0.9862, 0.9985, 0.9999, 0.9999,  &
0.0446, 0.0539, 0.1673, 0.4270, 0.7687, 0.9553, 0.9949, 0.9996, 0.9999,  &
0.0446, 0.0490, 0.0840, 0.1913, 0.4270, 0.6932, 0.9291, 0.9934, 0.9997 /
data ((cldnuctab( 3,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.4450, 0.6769, 0.8647, 0.9668, 0.9961, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3229, 0.5546, 0.7824, 0.9291, 0.9877, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.1913, 0.4270, 0.6769, 0.8745, 0.9668, 0.9961, 0.9997, 0.9999, 0.9999,  &
0.0840, 0.2453, 0.5182, 0.7824, 0.9351, 0.9877, 0.9989, 0.9999, 0.9999,  &
0.0446, 0.1074, 0.2906, 0.6084, 0.8745, 0.9731, 0.9966, 0.9997, 0.9999,  &
0.0446, 0.0539, 0.1253, 0.3395, 0.6932, 0.9291, 0.9891, 0.9990, 0.9999,  &
0.0446, 0.0490, 0.0647, 0.1673, 0.3913, 0.6932, 0.9291, 0.9925, 0.9996 /
data ((cldnuctab( 3,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.3913, 0.6084, 0.8207, 0.9508, 0.9942, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2906, 0.4998, 0.7247, 0.9007, 0.9783, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.1673, 0.3738, 0.6084, 0.8207, 0.9508, 0.9925, 0.9995, 0.9999, 0.9999,  &
0.0772, 0.2041, 0.4450, 0.7247, 0.9007, 0.9783, 0.9977, 0.9998, 0.9999,  &
0.0490, 0.0840, 0.2453, 0.5364, 0.8207, 0.9508, 0.9925, 0.9994, 0.9999,  &
0.0490, 0.0539, 0.1074, 0.2906, 0.6259, 0.8924, 0.9806, 0.9980, 0.9998,  &
0.0446, 0.0490, 0.0647, 0.1350, 0.3229, 0.6602, 0.9085, 0.9891, 0.9993 /
data ((cldnuctab( 3,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.3565, 0.5727, 0.7957, 0.9407, 0.9915, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2453, 0.4450, 0.6769, 0.8745, 0.9701, 0.9970, 0.9998, 0.9999, 0.9999,  &
0.1453, 0.3229, 0.5546, 0.7824, 0.9291, 0.9877, 0.9990, 0.9999, 0.9999,  &
0.0647, 0.1790, 0.4090, 0.6602, 0.8647, 0.9668, 0.9961, 0.9997, 0.9999,  &
0.0490, 0.0772, 0.2041, 0.4815, 0.7687, 0.9291, 0.9877, 0.9989, 0.9999,  &
0.0490, 0.0539, 0.0913, 0.2453, 0.5546, 0.8438, 0.9668, 0.9961, 0.9997,  &
0.0490, 0.0539, 0.0647, 0.1161, 0.2751, 0.5907, 0.8837, 0.9845, 0.9987 /
data ((cldnuctab( 3,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.3229, 0.5364, 0.7687, 0.9291, 0.9891, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.2311, 0.4270, 0.6432, 0.8438, 0.9633, 0.9955, 0.9997, 0.9999, 0.9999,  &
0.1350, 0.2906, 0.5182, 0.7545, 0.9158, 0.9845, 0.9985, 0.9999, 0.9999,  &
0.0591, 0.1673, 0.3565, 0.6259, 0.8325, 0.9553, 0.9942, 0.9996, 0.9999,  &
0.0539, 0.0647, 0.1913, 0.4270, 0.7247, 0.9085, 0.9806, 0.9980, 0.9998,  &
0.0539, 0.0591, 0.0772, 0.2173, 0.4998, 0.7957, 0.9508, 0.9934, 0.9995,  &
0.0490, 0.0539, 0.0647, 0.0991, 0.2453, 0.5364, 0.8545, 0.9758, 0.9977 /
data ((cldnuctab( 3,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.7247, 0.9007, 0.9783, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5907, 0.8325, 0.9553, 0.9925, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3738, 0.6932, 0.9085, 0.9826, 0.9980, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1673, 0.4450, 0.7957, 0.9553, 0.9942, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.0772, 0.2173, 0.5182, 0.8545, 0.9783, 0.9983, 0.9998, 0.9999, 0.9999,  &
0.0647, 0.1074, 0.2453, 0.4815, 0.7398, 0.9553, 0.9974, 0.9999, 0.9999,  &
0.0539, 0.0707, 0.1161, 0.1790, 0.2041, 0.2041, 0.2751, 0.3913, 0.8207 /
data ((cldnuctab( 3,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.6432, 0.8438, 0.9553, 0.9934, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4998, 0.7545, 0.9158, 0.9826, 0.9983, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3065, 0.6084, 0.8545, 0.9633, 0.9949, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.1350, 0.3738, 0.7091, 0.9227, 0.9862, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.0647, 0.1673, 0.4450, 0.7957, 0.9633, 0.9955, 0.9997, 0.9999, 0.9999,  &
0.0591, 0.0840, 0.2173, 0.4815, 0.8207, 0.9731, 0.9983, 0.9999, 0.9999,  &
0.0591, 0.0707, 0.1161, 0.2173, 0.3738, 0.5364, 0.7545, 0.9407, 0.9995 /
data ((cldnuctab( 3,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.5546, 0.7824, 0.9291, 0.9862, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4270, 0.6769, 0.8647, 0.9668, 0.9955, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2453, 0.5182, 0.7824, 0.9351, 0.9877, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.1074, 0.3065, 0.6259, 0.8745, 0.9701, 0.9966, 0.9997, 0.9999, 0.9999,  &
0.0647, 0.1350, 0.3565, 0.7247, 0.9351, 0.9903, 0.9990, 0.9999, 0.9999,  &
0.0591, 0.0707, 0.1673, 0.4270, 0.7824, 0.9633, 0.9966, 0.9998, 0.9999,  &
0.0591, 0.0707, 0.0991, 0.2041, 0.4090, 0.6932, 0.9291, 0.9942, 0.9998 /
data ((cldnuctab( 3,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.4815, 0.7091, 0.8924, 0.9758, 0.9977, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3565, 0.6084, 0.8207, 0.9460, 0.9915, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2041, 0.4450, 0.7091, 0.8924, 0.9783, 0.9974, 0.9998, 0.9999, 0.9999,  &
0.0913, 0.2453, 0.5364, 0.8085, 0.9508, 0.9925, 0.9993, 0.9999, 0.9999,  &
0.0647, 0.1074, 0.2906, 0.6432, 0.8924, 0.9783, 0.9977, 0.9998, 0.9999,  &
0.0647, 0.0707, 0.1350, 0.3565, 0.7091, 0.9407, 0.9925, 0.9995, 0.9999,  &
0.0591, 0.0707, 0.0840, 0.1673, 0.3913, 0.6932, 0.9351, 0.9942, 0.9997 /
data ((cldnuctab( 3,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.4270, 0.6602, 0.8545, 0.9668, 0.9961, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3065, 0.5364, 0.7687, 0.9227, 0.9862, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.1790, 0.3913, 0.6432, 0.8545, 0.9633, 0.9949, 0.9996, 0.9999, 0.9999,  &
0.0772, 0.2173, 0.4815, 0.7545, 0.9227, 0.9845, 0.9985, 0.9999, 0.9999,  &
0.0647, 0.0913, 0.2453, 0.5546, 0.8438, 0.9633, 0.9949, 0.9996, 0.9999,  &
0.0647, 0.0707, 0.1074, 0.2906, 0.6259, 0.9085, 0.9845, 0.9987, 0.9999,  &
0.0647, 0.0707, 0.0840, 0.1453, 0.3395, 0.6602, 0.9158, 0.9925, 0.9995 /
data ((cldnuctab( 3,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.3913, 0.6084, 0.8325, 0.9553, 0.9942, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2751, 0.4998, 0.7247, 0.9007, 0.9783, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.1560, 0.3565, 0.6084, 0.8207, 0.9460, 0.9925, 0.9994, 0.9999, 0.9999,  &
0.0707, 0.1913, 0.4270, 0.7091, 0.8924, 0.9758, 0.9974, 0.9998, 0.9999,  &
0.0707, 0.0772, 0.2173, 0.4998, 0.7957, 0.9460, 0.9915, 0.9993, 0.9999,  &
0.0647, 0.0772, 0.0913, 0.2453, 0.5546, 0.8647, 0.9758, 0.9974, 0.9998,  &
0.0647, 0.0707, 0.0840, 0.1253, 0.2906, 0.5907, 0.8924, 0.9877, 0.9990 /
data ((cldnuctab( 3,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.3565, 0.5907, 0.8085, 0.9460, 0.9925, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2600, 0.4632, 0.6932, 0.8745, 0.9731, 0.9974, 0.9998, 0.9999, 0.9999,  &
0.1453, 0.3229, 0.5546, 0.7824, 0.9351, 0.9891, 0.9992, 0.9999, 0.9999,  &
0.0707, 0.1673, 0.3913, 0.6602, 0.8647, 0.9668, 0.9961, 0.9997, 0.9999,  &
0.0707, 0.0772, 0.1913, 0.4450, 0.7545, 0.9227, 0.9862, 0.9989, 0.9999,  &
0.0707, 0.0772, 0.0913, 0.2173, 0.4998, 0.8207, 0.9633, 0.9955, 0.9996,  &
0.0707, 0.0772, 0.0840, 0.1161, 0.2600, 0.5364, 0.8647, 0.9806, 0.9985 /
data ((cldnuctab( 3,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.7545, 0.9158, 0.9826, 0.9983, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6084, 0.8545, 0.9633, 0.9949, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3738, 0.7247, 0.9227, 0.9862, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1673, 0.4632, 0.8085, 0.9633, 0.9961, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.0913, 0.2173, 0.5182, 0.8647, 0.9826, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.0772, 0.1161, 0.2453, 0.4632, 0.7398, 0.9407, 0.9966, 0.9999, 0.9999,  &
0.0707, 0.0840, 0.1253, 0.1790, 0.2041, 0.2041, 0.2751, 0.3565, 0.7545 /
data ((cldnuctab( 3,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.6602, 0.8647, 0.9668, 0.9955, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5182, 0.7824, 0.9291, 0.9877, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3065, 0.6259, 0.8745, 0.9701, 0.9961, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1350, 0.3738, 0.7247, 0.9351, 0.9891, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.0772, 0.1790, 0.4450, 0.8085, 0.9701, 0.9970, 0.9998, 0.9999, 0.9999,  &
0.0772, 0.0991, 0.2173, 0.4815, 0.8207, 0.9758, 0.9985, 0.9999, 0.9999,  &
0.0707, 0.0840, 0.1253, 0.2173, 0.3565, 0.5182, 0.7398, 0.9351, 0.9995 /
data ((cldnuctab( 3,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.5907, 0.8085, 0.9407, 0.9903, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4450, 0.7091, 0.8924, 0.9758, 0.9970, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2600, 0.5546, 0.8085, 0.9460, 0.9915, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.1074, 0.3065, 0.6432, 0.8924, 0.9783, 0.9974, 0.9998, 0.9999, 0.9999,  &
0.0772, 0.1350, 0.3738, 0.7398, 0.9460, 0.9925, 0.9994, 0.9999, 0.9999,  &
0.0772, 0.0913, 0.1790, 0.4270, 0.7957, 0.9701, 0.9974, 0.9998, 0.9999,  &
0.0772, 0.0840, 0.1074, 0.2041, 0.4090, 0.6769, 0.9227, 0.9949, 0.9998 /
data ((cldnuctab( 3,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.5182, 0.7398, 0.9085, 0.9826, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3913, 0.6259, 0.8438, 0.9553, 0.9942, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2173, 0.4815, 0.7398, 0.9158, 0.9826, 0.9983, 0.9998, 0.9999, 0.9999,  &
0.0913, 0.2600, 0.5546, 0.8325, 0.9595, 0.9942, 0.9995, 0.9999, 0.9999,  &
0.0772, 0.1074, 0.3065, 0.6432, 0.9085, 0.9845, 0.9983, 0.9999, 0.9999,  &
0.0772, 0.0913, 0.1453, 0.3565, 0.7247, 0.9460, 0.9942, 0.9996, 0.9999,  &
0.0772, 0.0840, 0.1074, 0.1790, 0.3913, 0.6932, 0.9351, 0.9955, 0.9998 /
data ((cldnuctab( 3,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.4632, 0.6932, 0.8837, 0.9731, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3395, 0.5727, 0.7957, 0.9351, 0.9891, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.1913, 0.4090, 0.6769, 0.8745, 0.9701, 0.9966, 0.9998, 0.9999, 0.9999,  &
0.0840, 0.2173, 0.4998, 0.7824, 0.9351, 0.9891, 0.9990, 0.9999, 0.9999,  &
0.0840, 0.0913, 0.2600, 0.5727, 0.8545, 0.9701, 0.9966, 0.9997, 0.9999,  &
0.0840, 0.0913, 0.1161, 0.3065, 0.6432, 0.9158, 0.9891, 0.9990, 0.9999,  &
0.0840, 0.0840, 0.0991, 0.1560, 0.3395, 0.6602, 0.9227, 0.9934, 0.9996 /
data ((cldnuctab( 3,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.4270, 0.6432, 0.8545, 0.9633, 0.9961, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3065, 0.5182, 0.7545, 0.9158, 0.9845, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.1673, 0.3738, 0.6259, 0.8438, 0.9595, 0.9942, 0.9996, 0.9999, 0.9999,  &
0.0840, 0.1913, 0.4450, 0.7247, 0.9085, 0.9826, 0.9983, 0.9999, 0.9999,  &
0.0840, 0.0913, 0.2173, 0.4998, 0.8085, 0.9553, 0.9934, 0.9995, 0.9999,  &
0.0840, 0.0913, 0.1074, 0.2600, 0.5727, 0.8745, 0.9806, 0.9980, 0.9998,  &
0.0840, 0.0913, 0.0991, 0.1350, 0.2906, 0.5907, 0.9007, 0.9903, 0.9993 /
data ((cldnuctab( 3,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.3913, 0.6259, 0.8325, 0.9553, 0.9949, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2751, 0.4998, 0.7247, 0.9007, 0.9806, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.1560, 0.3395, 0.5907, 0.8085, 0.9460, 0.9915, 0.9994, 0.9999, 0.9999,  &
0.0913, 0.1790, 0.4090, 0.6932, 0.8837, 0.9758, 0.9974, 0.9998, 0.9999,  &
0.0913, 0.0991, 0.1913, 0.4632, 0.7687, 0.9351, 0.9903, 0.9992, 0.9999,  &
0.0913, 0.0991, 0.1074, 0.2311, 0.5182, 0.8325, 0.9701, 0.9966, 0.9998,  &
0.0913, 0.0913, 0.1074, 0.1350, 0.2600, 0.5364, 0.8647, 0.9845, 0.9989 /
data ((cldnuctab( 4,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.6302, 0.8353, 0.9564, 0.9943, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5043, 0.7580, 0.9175, 0.9849, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.6302, 0.8571, 0.9677, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1587, 0.4134, 0.7434, 0.9306, 0.9894, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.0662, 0.2073, 0.5043, 0.8237, 0.9677, 0.9967, 0.9998, 0.9999, 0.9999,  &
0.0339, 0.0932, 0.2345, 0.5043, 0.7721, 0.9564, 0.9967, 0.9999, 0.9999,  &
0.0275, 0.0456, 0.1011, 0.1820, 0.2073, 0.2206, 0.2636, 0.3607, 0.8237 /
data ((cldnuctab( 4,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.5227, 0.7580, 0.9175, 0.9866, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.6643, 0.8571, 0.9677, 0.9962, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2636, 0.5409, 0.7857, 0.9306, 0.9881, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.1277, 0.3436, 0.6474, 0.8768, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999,  &
0.0502, 0.1587, 0.4134, 0.7580, 0.9421, 0.9917, 0.9994, 0.9999, 0.9999,  &
0.0275, 0.0662, 0.1944, 0.4860, 0.8115, 0.9642, 0.9971, 0.9998, 0.9999,  &
0.0275, 0.0375, 0.0932, 0.2206, 0.3780, 0.5772, 0.7989, 0.9738, 0.9994 /
data ((cldnuctab( 4,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.4495, 0.6809, 0.8768, 0.9708, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3436, 0.5772, 0.7989, 0.9365, 0.9906, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2206, 0.4495, 0.6971, 0.8859, 0.9764, 0.9975, 0.9998, 0.9999, 0.9999,  &
0.1011, 0.2788, 0.5591, 0.8115, 0.9472, 0.9927, 0.9995, 0.9999, 0.9999,  &
0.0375, 0.1277, 0.3436, 0.6643, 0.8945, 0.9811, 0.9981, 0.9999, 0.9999,  &
0.0275, 0.0502, 0.1587, 0.4134, 0.7580, 0.9472, 0.9936, 0.9995, 0.9999,  &
0.0275, 0.0339, 0.0723, 0.1944, 0.4314, 0.7130, 0.9306, 0.9927, 0.9997 /
data ((cldnuctab( 4,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.3780, 0.6127, 0.8237, 0.9519, 0.9943, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2788, 0.5043, 0.7284, 0.9027, 0.9811, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.1820, 0.3780, 0.6302, 0.8353, 0.9564, 0.9943, 0.9997, 0.9999, 0.9999,  &
0.0858, 0.2206, 0.4860, 0.7434, 0.9103, 0.9831, 0.9986, 0.9999, 0.9999,  &
0.0339, 0.1011, 0.2788, 0.5772, 0.8353, 0.9604, 0.9950, 0.9997, 0.9999,  &
0.0275, 0.0375, 0.1183, 0.3436, 0.6809, 0.9103, 0.9866, 0.9988, 0.9999,  &
0.0275, 0.0306, 0.0551, 0.1587, 0.3780, 0.6971, 0.9243, 0.9927, 0.9995 /
data ((cldnuctab( 4,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.3269, 0.5591, 0.7721, 0.9306, 0.9906, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.4314, 0.6643, 0.8672, 0.9708, 0.9971, 0.9998, 0.9999, 0.9999,  &
0.1479, 0.3269, 0.5591, 0.7857, 0.9306, 0.9894, 0.9992, 0.9999, 0.9999,  &
0.0723, 0.1944, 0.4134, 0.6643, 0.8672, 0.9708, 0.9967, 0.9998, 0.9999,  &
0.0275, 0.0858, 0.2345, 0.5043, 0.7857, 0.9365, 0.9894, 0.9992, 0.9999,  &
0.0275, 0.0339, 0.1011, 0.2788, 0.5950, 0.8672, 0.9738, 0.9971, 0.9998,  &
0.0275, 0.0339, 0.0456, 0.1277, 0.3269, 0.6474, 0.9027, 0.9866, 0.9991 /
data ((cldnuctab( 4,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.2945, 0.5043, 0.7434, 0.9175, 0.9866, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.2206, 0.3956, 0.6302, 0.8353, 0.9564, 0.9950, 0.9998, 0.9999, 0.9999,  &
0.1375, 0.2788, 0.5043, 0.7284, 0.9027, 0.9831, 0.9986, 0.9999, 0.9999,  &
0.0605, 0.1701, 0.3607, 0.6127, 0.8353, 0.9564, 0.9943, 0.9997, 0.9999,  &
0.0306, 0.0723, 0.1944, 0.4495, 0.7284, 0.9027, 0.9811, 0.9983, 0.9999,  &
0.0306, 0.0339, 0.0858, 0.2345, 0.5227, 0.8115, 0.9564, 0.9943, 0.9996,  &
0.0306, 0.0339, 0.0414, 0.1011, 0.2788, 0.5772, 0.8672, 0.9789, 0.9981 /
data ((cldnuctab( 4,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.2788, 0.4677, 0.7130, 0.9027, 0.9831, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.1944, 0.3607, 0.5772, 0.7989, 0.9472, 0.9936, 0.9997, 0.9999, 0.9999,  &
0.1183, 0.2636, 0.4677, 0.6971, 0.8859, 0.9764, 0.9978, 0.9999, 0.9999,  &
0.0551, 0.1479, 0.3269, 0.5772, 0.7989, 0.9365, 0.9906, 0.9994, 0.9999,  &
0.0339, 0.0662, 0.1820, 0.3956, 0.6809, 0.8768, 0.9738, 0.9971, 0.9998,  &
0.0339, 0.0375, 0.0723, 0.2073, 0.4677, 0.7721, 0.9365, 0.9894, 0.9993,  &
0.0306, 0.0339, 0.0414, 0.0858, 0.2345, 0.5227, 0.8353, 0.9677, 0.9967 /
data ((cldnuctab( 4,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.7284, 0.9027, 0.9789, 0.9978, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5950, 0.8353, 0.9564, 0.9936, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.6971, 0.9103, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1701, 0.4495, 0.7989, 0.9604, 0.9950, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.0788, 0.2206, 0.5227, 0.8571, 0.9811, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.0662, 0.1095, 0.2488, 0.4860, 0.7434, 0.9564, 0.9978, 0.9999, 0.9999,  &
0.0551, 0.0723, 0.1183, 0.1820, 0.1944, 0.2073, 0.2788, 0.3956, 0.8115 /
data ((cldnuctab( 4,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.6302, 0.8465, 0.9564, 0.9943, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5043, 0.7580, 0.9175, 0.9849, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.6127, 0.8571, 0.9642, 0.9950, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1375, 0.3607, 0.7130, 0.9243, 0.9866, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.0662, 0.1701, 0.4495, 0.7989, 0.9642, 0.9962, 0.9997, 0.9999, 0.9999,  &
0.0605, 0.0858, 0.2073, 0.4860, 0.8237, 0.9738, 0.9986, 0.9999, 0.9999,  &
0.0605, 0.0723, 0.1095, 0.2206, 0.3780, 0.5227, 0.7580, 0.9472, 0.9996 /
data ((cldnuctab( 4,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.5591, 0.7721, 0.9306, 0.9881, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.6809, 0.8672, 0.9677, 0.9962, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2488, 0.5227, 0.7857, 0.9365, 0.9894, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.1095, 0.2945, 0.6302, 0.8768, 0.9738, 0.9967, 0.9998, 0.9999, 0.9999,  &
0.0605, 0.1375, 0.3607, 0.7284, 0.9365, 0.9906, 0.9993, 0.9999, 0.9999,  &
0.0605, 0.0723, 0.1701, 0.4314, 0.7857, 0.9642, 0.9971, 0.9998, 0.9999,  &
0.0605, 0.0662, 0.0932, 0.2073, 0.4134, 0.6971, 0.9306, 0.9950, 0.9998 /
data ((cldnuctab( 4,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.4860, 0.7130, 0.8945, 0.9789, 0.9978, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.5950, 0.8237, 0.9472, 0.9917, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2073, 0.4495, 0.7130, 0.8945, 0.9789, 0.9978, 0.9998, 0.9999, 0.9999,  &
0.0932, 0.2488, 0.5409, 0.8115, 0.9519, 0.9927, 0.9995, 0.9999, 0.9999,  &
0.0662, 0.1095, 0.2945, 0.6302, 0.8945, 0.9811, 0.9981, 0.9999, 0.9999,  &
0.0605, 0.0723, 0.1375, 0.3607, 0.7130, 0.9421, 0.9936, 0.9995, 0.9999,  &
0.0605, 0.0662, 0.0858, 0.1701, 0.3780, 0.6971, 0.9365, 0.9950, 0.9998 /
data ((cldnuctab( 4,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.4314, 0.6643, 0.8571, 0.9677, 0.9967, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.5409, 0.7721, 0.9243, 0.9866, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.1820, 0.3956, 0.6474, 0.8571, 0.9642, 0.9957, 0.9997, 0.9999, 0.9999,  &
0.0788, 0.2073, 0.4860, 0.7580, 0.9243, 0.9866, 0.9988, 0.9999, 0.9999,  &
0.0662, 0.0858, 0.2488, 0.5591, 0.8465, 0.9642, 0.9957, 0.9997, 0.9999,  &
0.0662, 0.0723, 0.1095, 0.2945, 0.6302, 0.9103, 0.9866, 0.9989, 0.9999,  &
0.0662, 0.0723, 0.0858, 0.1479, 0.3269, 0.6643, 0.9175, 0.9927, 0.9996 /
data ((cldnuctab( 4,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.3956, 0.6127, 0.8237, 0.9564, 0.9950, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2788, 0.4860, 0.7284, 0.9027, 0.9811, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.1587, 0.3607, 0.5950, 0.8237, 0.9472, 0.9927, 0.9995, 0.9999, 0.9999,  &
0.0662, 0.1820, 0.4314, 0.6971, 0.8945, 0.9789, 0.9978, 0.9999, 0.9999,  &
0.0662, 0.0788, 0.2206, 0.4860, 0.7989, 0.9472, 0.9917, 0.9994, 0.9999,  &
0.0662, 0.0723, 0.0932, 0.2488, 0.5591, 0.8672, 0.9764, 0.9975, 0.9998,  &
0.0662, 0.0723, 0.0858, 0.1277, 0.2945, 0.5950, 0.8945, 0.9881, 0.9992 /
data ((cldnuctab( 4,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.3607, 0.5772, 0.7989, 0.9472, 0.9927, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2636, 0.4677, 0.6971, 0.8768, 0.9738, 0.9975, 0.9999, 0.9999, 0.9999,  &
0.1479, 0.3269, 0.5591, 0.7857, 0.9365, 0.9894, 0.9993, 0.9999, 0.9999,  &
0.0723, 0.1701, 0.3956, 0.6643, 0.8672, 0.9677, 0.9962, 0.9998, 0.9999,  &
0.0723, 0.0788, 0.1944, 0.4495, 0.7580, 0.9243, 0.9881, 0.9989, 0.9999,  &
0.0723, 0.0788, 0.0932, 0.2206, 0.5043, 0.8237, 0.9642, 0.9957, 0.9997,  &
0.0723, 0.0788, 0.0858, 0.1095, 0.2488, 0.5409, 0.8672, 0.9811, 0.9986 /
data ((cldnuctab( 4,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.8115, 0.9472, 0.9917, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6643, 0.8945, 0.9789, 0.9975, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.7580, 0.9472, 0.9927, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1820, 0.4677, 0.8353, 0.9764, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1277, 0.2345, 0.5227, 0.8672, 0.9881, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.1183, 0.1479, 0.2636, 0.4495, 0.6971, 0.9306, 0.9975, 0.9999, 0.9999,  &
0.1095, 0.1183, 0.1587, 0.2073, 0.2073, 0.2073, 0.2636, 0.3780, 0.7580 /
data ((cldnuctab( 4,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.7284, 0.9027, 0.9811, 0.9978, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5772, 0.8353, 0.9564, 0.9936, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.6809, 0.9027, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.1375, 0.3956, 0.7580, 0.9564, 0.9943, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.1277, 0.1944, 0.4495, 0.8353, 0.9789, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.1183, 0.1375, 0.2345, 0.4860, 0.8115, 0.9811, 0.9992, 0.9999, 0.9999,  &
0.1095, 0.1183, 0.1479, 0.2345, 0.3436, 0.4860, 0.6971, 0.9243, 0.9993 /
data ((cldnuctab( 4,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.6643, 0.8571, 0.9642, 0.9950, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5043, 0.7580, 0.9243, 0.9866, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2788, 0.5950, 0.8571, 0.9677, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1277, 0.3269, 0.6809, 0.9175, 0.9866, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.1277, 0.1479, 0.3780, 0.7580, 0.9604, 0.9962, 0.9997, 0.9999, 0.9999,  &
0.1183, 0.1375, 0.1944, 0.4314, 0.7989, 0.9764, 0.9988, 0.9999, 0.9999,  &
0.1183, 0.1277, 0.1479, 0.2345, 0.3956, 0.6474, 0.9175, 0.9962, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.5950, 0.8115, 0.9421, 0.9906, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.6971, 0.8859, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.5227, 0.7989, 0.9421, 0.9906, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.1277, 0.2636, 0.5950, 0.8768, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999,  &
0.1277, 0.1375, 0.3105, 0.6809, 0.9306, 0.9906, 0.9993, 0.9999, 0.9999,  &
0.1277, 0.1375, 0.1701, 0.3780, 0.7284, 0.9604, 0.9971, 0.9998, 0.9999,  &
0.1183, 0.1277, 0.1479, 0.2073, 0.3956, 0.6643, 0.9365, 0.9971, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.5409, 0.7580, 0.9175, 0.9849, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.6474, 0.8465, 0.9604, 0.9950, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2073, 0.4495, 0.7434, 0.9175, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.1277, 0.2345, 0.5227, 0.8237, 0.9564, 0.9943, 0.9996, 0.9999, 0.9999,  &
0.1277, 0.1479, 0.2636, 0.5950, 0.8945, 0.9831, 0.9983, 0.9999, 0.9999,  &
0.1277, 0.1375, 0.1587, 0.3105, 0.6474, 0.9365, 0.9936, 0.9995, 0.9999,  &
0.1277, 0.1375, 0.1479, 0.1944, 0.3436, 0.6474, 0.9243, 0.9957, 0.9998 /
data ((cldnuctab( 4,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.4860, 0.7284, 0.8945, 0.9789, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3436, 0.5950, 0.8115, 0.9472, 0.9917, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.1820, 0.4134, 0.6971, 0.8859, 0.9764, 0.9975, 0.9998, 0.9999, 0.9999,  &
0.1375, 0.2073, 0.4677, 0.7721, 0.9365, 0.9906, 0.9992, 0.9999, 0.9999,  &
0.1375, 0.1479, 0.2345, 0.5227, 0.8465, 0.9708, 0.9967, 0.9998, 0.9999,  &
0.1375, 0.1479, 0.1587, 0.2636, 0.5772, 0.9027, 0.9881, 0.9991, 0.9999,  &
0.1277, 0.1375, 0.1479, 0.1820, 0.3105, 0.5950, 0.9027, 0.9936, 0.9997 /
data ((cldnuctab( 4,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.4677, 0.6971, 0.8768, 0.9738, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.5591, 0.7857, 0.9306, 0.9894, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.1701, 0.3780, 0.6474, 0.8672, 0.9677, 0.9962, 0.9997, 0.9999, 0.9999,  &
0.1479, 0.1820, 0.4314, 0.7434, 0.9175, 0.9866, 0.9988, 0.9999, 0.9999,  &
0.1375, 0.1479, 0.2073, 0.4860, 0.8115, 0.9564, 0.9950, 0.9997, 0.9999,  &
0.1375, 0.1479, 0.1701, 0.2488, 0.5227, 0.8672, 0.9811, 0.9983, 0.9999,  &
0.1375, 0.1479, 0.1587, 0.1820, 0.2788, 0.5409, 0.8768, 0.9894, 0.9995 /
data ((cldnuctab( 4,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.8768, 0.9738, 0.9967, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7130, 0.9365, 0.9906, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.7989, 0.9708, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.4860, 0.8571, 0.9881, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2206, 0.2945, 0.5227, 0.8571, 0.9917, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.1944, 0.2206, 0.2945, 0.4314, 0.6474, 0.8859, 0.9962, 0.9999, 0.9999,  &
0.1701, 0.1820, 0.2206, 0.2945, 0.2488, 0.2488, 0.2788, 0.4134, 0.7130 /
data ((cldnuctab( 4,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.8115, 0.9472, 0.9917, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6302, 0.8859, 0.9789, 0.9975, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3436, 0.7130, 0.9421, 0.9927, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.3956, 0.7857, 0.9738, 0.9978, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2206, 0.2636, 0.4677, 0.8353, 0.9881, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.2073, 0.2206, 0.2945, 0.4860, 0.7857, 0.9789, 0.9995, 0.9999, 0.9999,  &
0.1944, 0.2073, 0.2206, 0.2945, 0.3607, 0.4495, 0.6302, 0.8768, 0.9988 /
data ((cldnuctab( 4,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.7434, 0.9175, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5591, 0.8353, 0.9604, 0.9943, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2788, 0.6302, 0.9027, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2206, 0.3269, 0.7130, 0.9472, 0.9943, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2206, 0.2488, 0.3956, 0.7721, 0.9764, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.2073, 0.2345, 0.2788, 0.4495, 0.7857, 0.9831, 0.9994, 0.9999, 0.9999,  &
0.2073, 0.2073, 0.2345, 0.2788, 0.4134, 0.5950, 0.8672, 0.9943, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.6809, 0.8768, 0.9708, 0.9967, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4860, 0.7857, 0.9365, 0.9894, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2488, 0.5591, 0.8571, 0.9708, 0.9967, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.2788, 0.6302, 0.9175, 0.9881, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.2206, 0.2488, 0.3436, 0.6971, 0.9519, 0.9962, 0.9997, 0.9999, 0.9999,  &
0.2206, 0.2345, 0.2636, 0.3956, 0.7284, 0.9708, 0.9988, 0.9999, 0.9999,  &
0.2073, 0.2206, 0.2345, 0.2788, 0.4134, 0.6302, 0.9103, 0.9975, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.6302, 0.8465, 0.9604, 0.9943, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4495, 0.7284, 0.9103, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.5043, 0.8115, 0.9519, 0.9936, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.2488, 0.5591, 0.8768, 0.9789, 0.9978, 0.9998, 0.9999, 0.9999,  &
0.2345, 0.2488, 0.2945, 0.6127, 0.9243, 0.9917, 0.9994, 0.9999, 0.9999,  &
0.2206, 0.2345, 0.2636, 0.3607, 0.6643, 0.9472, 0.9971, 0.9998, 0.9999,  &
0.2206, 0.2206, 0.2345, 0.2788, 0.3780, 0.6127, 0.9103, 0.9971, 0.9999 /
data ((cldnuctab( 4,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.5950, 0.8115, 0.9472, 0.9917, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.6809, 0.8859, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.4495, 0.7721, 0.9365, 0.9894, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.2345, 0.2636, 0.5043, 0.8353, 0.9677, 0.9962, 0.9997, 0.9999, 0.9999,  &
0.2345, 0.2488, 0.2788, 0.5591, 0.8859, 0.9849, 0.9989, 0.9999, 0.9999,  &
0.2345, 0.2488, 0.2636, 0.3269, 0.5950, 0.9175, 0.9943, 0.9997, 0.9999,  &
0.2345, 0.2345, 0.2488, 0.2788, 0.3607, 0.5950, 0.8859, 0.9957, 0.9998 /
data ((cldnuctab( 4,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.5591, 0.7857, 0.9365, 0.9894, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.6474, 0.8571, 0.9677, 0.9962, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2488, 0.4314, 0.7284, 0.9175, 0.9849, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.2488, 0.2636, 0.4677, 0.7989, 0.9564, 0.9943, 0.9996, 0.9999, 0.9999,  &
0.2488, 0.2636, 0.2945, 0.5043, 0.8465, 0.9789, 0.9981, 0.9999, 0.9999,  &
0.2488, 0.2488, 0.2788, 0.3269, 0.5409, 0.8859, 0.9894, 0.9994, 0.9999,  &
0.2345, 0.2488, 0.2488, 0.2788, 0.3436, 0.5591, 0.8571, 0.9927, 0.9998 /
data ((cldnuctab( 4,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9027, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7284, 0.9519, 0.9943, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.8115, 0.9789, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.4860, 0.8571, 0.9906, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2788, 0.3269, 0.5227, 0.8465, 0.9927, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2636, 0.2788, 0.3436, 0.4495, 0.5950, 0.8571, 0.9936, 0.9999, 0.9999,  &
0.2345, 0.2488, 0.2636, 0.3269, 0.3436, 0.2488, 0.2945, 0.3956, 0.6809 /
data ((cldnuctab( 4,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.8465, 0.9642, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6643, 0.9175, 0.9866, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3436, 0.7284, 0.9564, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.4134, 0.7989, 0.9811, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2788, 0.3269, 0.4860, 0.8353, 0.9906, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2636, 0.2788, 0.3269, 0.4860, 0.7434, 0.9738, 0.9996, 0.9999, 0.9999,  &
0.2488, 0.2636, 0.2788, 0.3436, 0.4134, 0.4495, 0.6127, 0.8465, 0.9971 /
data ((cldnuctab( 4,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.7989, 0.9421, 0.9906, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5772, 0.8672, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.6474, 0.9243, 0.9894, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.3436, 0.7130, 0.9604, 0.9967, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.3105, 0.4314, 0.7721, 0.9811, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.2788, 0.2945, 0.3269, 0.4677, 0.7721, 0.9811, 0.9996, 0.9999, 0.9999,  &
0.2636, 0.2788, 0.2945, 0.3269, 0.4495, 0.5772, 0.8353, 0.9831, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.7284, 0.9103, 0.9831, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5227, 0.8237, 0.9564, 0.9936, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.5772, 0.8859, 0.9811, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.3269, 0.6474, 0.9306, 0.9927, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.3105, 0.3780, 0.6971, 0.9604, 0.9975, 0.9998, 0.9999, 0.9999,  &
0.2945, 0.2945, 0.3269, 0.4314, 0.7284, 0.9708, 0.9992, 0.9999, 0.9999,  &
0.2788, 0.2788, 0.2945, 0.3269, 0.4314, 0.6302, 0.8859, 0.9967, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.6809, 0.8859, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4677, 0.7721, 0.9365, 0.9894, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.5227, 0.8353, 0.9677, 0.9962, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.3269, 0.5772, 0.8945, 0.9866, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.3269, 0.3607, 0.6302, 0.9306, 0.9943, 0.9997, 0.9999, 0.9999,  &
0.2945, 0.3105, 0.3269, 0.3956, 0.6643, 0.9519, 0.9981, 0.9999, 0.9999,  &
0.2945, 0.2945, 0.3105, 0.3436, 0.4134, 0.6127, 0.8945, 0.9971, 0.9999 /
data ((cldnuctab( 4,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.6474, 0.8571, 0.9642, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.7284, 0.9103, 0.9849, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.4677, 0.7989, 0.9519, 0.9936, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.3436, 0.5227, 0.8571, 0.9764, 0.9978, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.3269, 0.3607, 0.5591, 0.8945, 0.9906, 0.9994, 0.9999, 0.9999,  &
0.3105, 0.3105, 0.3436, 0.3956, 0.6127, 0.9243, 0.9962, 0.9998, 0.9999,  &
0.2945, 0.3105, 0.3105, 0.3436, 0.4134, 0.5950, 0.8768, 0.9957, 0.9999 /
data ((cldnuctab( 4,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.6127, 0.8353, 0.9564, 0.9943, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.6971, 0.8945, 0.9789, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.4314, 0.7721, 0.9421, 0.9906, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.3436, 0.4677, 0.8237, 0.9677, 0.9967, 0.9998, 0.9999, 0.9999,  &
0.3269, 0.3436, 0.3607, 0.5227, 0.8672, 0.9849, 0.9989, 0.9999, 0.9999,  &
0.3105, 0.3269, 0.3436, 0.3956, 0.5591, 0.8859, 0.9927, 0.9997, 0.9999,  &
0.3105, 0.3105, 0.3269, 0.3436, 0.3956, 0.5772, 0.8465, 0.9927, 0.9998 /
data ((cldnuctab( 4,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9175, 0.9881, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7434, 0.9604, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.8115, 0.9831, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.5043, 0.8571, 0.9927, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.3780, 0.5409, 0.8353, 0.9917, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2945, 0.3269, 0.3780, 0.4860, 0.5950, 0.8237, 0.9894, 0.9999, 0.9999,  &
0.2788, 0.2945, 0.3105, 0.3780, 0.4314, 0.2788, 0.3105, 0.4134, 0.6809 /
data ((cldnuctab( 4,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.8768, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6643, 0.9306, 0.9906, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.7434, 0.9642, 0.9967, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.4314, 0.7989, 0.9831, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.3607, 0.5043, 0.8237, 0.9917, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3105, 0.3269, 0.3780, 0.5043, 0.7434, 0.9677, 0.9997, 0.9999, 0.9999,  &
0.2945, 0.3105, 0.3269, 0.3780, 0.4677, 0.4314, 0.5772, 0.7721, 0.9881 /
data ((cldnuctab( 4,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.8237, 0.9564, 0.9936, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5950, 0.8859, 0.9811, 0.9981, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.6643, 0.9365, 0.9927, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.3956, 0.7284, 0.9677, 0.9978, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3436, 0.3780, 0.4495, 0.7721, 0.9831, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.3436, 0.3780, 0.4860, 0.7580, 0.9789, 0.9997, 0.9999, 0.9999,  &
0.3105, 0.3269, 0.3436, 0.3780, 0.4860, 0.5772, 0.7989, 0.9764, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.7721, 0.9306, 0.9881, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5409, 0.8465, 0.9642, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.5950, 0.9027, 0.9849, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.3956, 0.6474, 0.9421, 0.9943, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3436, 0.3780, 0.4314, 0.6971, 0.9642, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.3436, 0.3607, 0.3780, 0.4677, 0.7130, 0.9708, 0.9994, 0.9999, 0.9999,  &
0.3269, 0.3436, 0.3436, 0.3780, 0.4677, 0.6127, 0.8768, 0.9957, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.7130, 0.9027, 0.9811, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4860, 0.7989, 0.9472, 0.9927, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.5227, 0.8571, 0.9764, 0.9975, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.3956, 0.5772, 0.9027, 0.9894, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.3780, 0.4134, 0.6302, 0.9365, 0.9962, 0.9998, 0.9999, 0.9999,  &
0.3436, 0.3607, 0.3780, 0.4495, 0.6643, 0.9519, 0.9986, 0.9999, 0.9999,  &
0.3436, 0.3436, 0.3607, 0.3780, 0.4495, 0.6127, 0.8768, 0.9967, 0.9999 /
data ((cldnuctab( 4,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.6809, 0.8768, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4495, 0.7580, 0.9306, 0.9894, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.4860, 0.8237, 0.9642, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.3956, 0.5227, 0.8672, 0.9831, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.3780, 0.4134, 0.5772, 0.9027, 0.9927, 0.9996, 0.9999, 0.9999,  &
0.3607, 0.3780, 0.3956, 0.4314, 0.6127, 0.9243, 0.9971, 0.9999, 0.9999,  &
0.3607, 0.3607, 0.3780, 0.3956, 0.4495, 0.6127, 0.8571, 0.9957, 0.9999 /
data ((cldnuctab( 4,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.6474, 0.8571, 0.9677, 0.9962, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.7284, 0.9175, 0.9849, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.4495, 0.7857, 0.9519, 0.9943, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.3956, 0.4860, 0.8353, 0.9764, 0.9978, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.3956, 0.4314, 0.5227, 0.8672, 0.9881, 0.9993, 0.9999, 0.9999,  &
0.3780, 0.3780, 0.3956, 0.4314, 0.5772, 0.8859, 0.9943, 0.9998, 0.9999,  &
0.3607, 0.3780, 0.3780, 0.3956, 0.4495, 0.5772, 0.8237, 0.9936, 0.9999 /
data ((cldnuctab( 4,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9306, 0.9906, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7580, 0.9642, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4495, 0.8115, 0.9849, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.5227, 0.8571, 0.9936, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.4134, 0.5409, 0.8237, 0.9906, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3269, 0.3436, 0.4134, 0.5043, 0.5772, 0.7989, 0.9849, 0.9999, 0.9999,  &
0.3269, 0.3269, 0.3607, 0.4134, 0.5043, 0.2945, 0.3269, 0.4314, 0.6809 /
data ((cldnuctab( 4,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.8859, 0.9789, 0.9978, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6809, 0.9365, 0.9927, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.7434, 0.9677, 0.9978, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.4677, 0.7989, 0.9849, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.4134, 0.5227, 0.8237, 0.9917, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3607, 0.3780, 0.4134, 0.5227, 0.7130, 0.9564, 0.9996, 0.9999, 0.9999,  &
0.3436, 0.3436, 0.3607, 0.3956, 0.5043, 0.4495, 0.5772, 0.7580, 0.9831 /
data ((cldnuctab( 4,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.8353, 0.9642, 0.9950, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6127, 0.9027, 0.9849, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.6643, 0.9421, 0.9943, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.4314, 0.7284, 0.9708, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.4134, 0.4860, 0.7721, 0.9831, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.3780, 0.4134, 0.5043, 0.7434, 0.9764, 0.9997, 0.9999, 0.9999,  &
0.3607, 0.3607, 0.3780, 0.4134, 0.5043, 0.5772, 0.7721, 0.9642, 0.9999 /
data ((cldnuctab( 4,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.7857, 0.9421, 0.9906, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5409, 0.8571, 0.9738, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.5950, 0.9103, 0.9881, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.4314, 0.6474, 0.9472, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3956, 0.4134, 0.4677, 0.6971, 0.9677, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.3780, 0.3956, 0.4134, 0.4860, 0.7130, 0.9677, 0.9995, 0.9999, 0.9999,  &
0.3780, 0.3780, 0.3956, 0.4134, 0.5043, 0.6302, 0.8571, 0.9943, 0.9999 /
data ((cldnuctab( 4,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.7434, 0.9175, 0.9849, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4860, 0.8115, 0.9564, 0.9943, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.5409, 0.8672, 0.9811, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.4314, 0.5772, 0.9103, 0.9917, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.4314, 0.4677, 0.6302, 0.9421, 0.9971, 0.9998, 0.9999, 0.9999,  &
0.3956, 0.4134, 0.4314, 0.4860, 0.6643, 0.9472, 0.9988, 0.9999, 0.9999,  &
0.3956, 0.3956, 0.4134, 0.4314, 0.4860, 0.6302, 0.8571, 0.9957, 0.9999 /
data ((cldnuctab( 4,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.7130, 0.9027, 0.9789, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4495, 0.7721, 0.9421, 0.9917, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.4860, 0.8353, 0.9708, 0.9971, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.4495, 0.5227, 0.8768, 0.9866, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.4134, 0.4314, 0.4677, 0.5772, 0.9103, 0.9943, 0.9997, 0.9999, 0.9999,  &
0.4134, 0.4134, 0.4314, 0.4677, 0.6302, 0.9175, 0.9975, 0.9999, 0.9999,  &
0.3956, 0.4134, 0.4134, 0.4314, 0.4860, 0.6127, 0.8353, 0.9943, 0.9999 /
data ((cldnuctab( 4,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.6809, 0.8768, 0.9738, 0.9975, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.7434, 0.9306, 0.9881, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.4495, 0.7989, 0.9604, 0.9957, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.4495, 0.4860, 0.8465, 0.9789, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.4314, 0.4495, 0.4677, 0.5409, 0.8768, 0.9906, 0.9995, 0.9999, 0.9999,  &
0.4134, 0.4314, 0.4495, 0.4860, 0.5950, 0.8859, 0.9950, 0.9998, 0.9999,  &
0.4134, 0.4134, 0.4314, 0.4495, 0.4860, 0.6127, 0.8237, 0.9927, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.8791, 0.9744, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.9379, 0.9909, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4000, 0.8020, 0.9716, 0.9976, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2380, 0.4722, 0.8596, 0.9884, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2240, 0.2826, 0.5271, 0.8696, 0.9929, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.1975, 0.2240, 0.2984, 0.4358, 0.6516, 0.8966, 0.9972, 0.9999, 0.9999,  &
0.1850, 0.1850, 0.2240, 0.2984, 0.2524, 0.2524, 0.2826, 0.4178, 0.7168 /
data ((cldnuctab( 5,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.8146, 0.9531, 0.9929, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6345, 0.8881, 0.9794, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3310, 0.7168, 0.9434, 0.9929, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2240, 0.4000, 0.7890, 0.9744, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2240, 0.2673, 0.4722, 0.8381, 0.9884, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.2105, 0.2240, 0.2984, 0.4905, 0.7890, 0.9816, 0.9997, 0.9999, 0.9999,  &
0.1975, 0.2105, 0.2240, 0.2984, 0.3649, 0.4540, 0.6516, 0.8881, 0.9991 /
data ((cldnuctab( 5,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.7470, 0.9192, 0.9854, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5635, 0.8381, 0.9614, 0.9952, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2826, 0.6345, 0.9046, 0.9854, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2240, 0.3310, 0.7168, 0.9531, 0.9952, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.2240, 0.2524, 0.4000, 0.7755, 0.9771, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.2105, 0.2240, 0.2826, 0.4540, 0.7890, 0.9836, 0.9995, 0.9999, 0.9999,  &
0.2105, 0.2105, 0.2380, 0.2826, 0.4178, 0.5994, 0.8791, 0.9958, 0.9999 /
data ((cldnuctab( 5,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.6849, 0.8791, 0.9744, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.7755, 0.9379, 0.9897, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2380, 0.5635, 0.8596, 0.9716, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2240, 0.2826, 0.6345, 0.9192, 0.9884, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.2240, 0.2524, 0.3310, 0.7010, 0.9531, 0.9963, 0.9998, 0.9999, 0.9999,  &
0.2240, 0.2380, 0.2673, 0.4000, 0.7321, 0.9716, 0.9990, 0.9999, 0.9999,  &
0.2105, 0.2240, 0.2380, 0.2826, 0.4178, 0.6516, 0.9192, 0.9979, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.6345, 0.8491, 0.9614, 0.9952, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4358, 0.7321, 0.9121, 0.9836, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2380, 0.5088, 0.8146, 0.9531, 0.9938, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.2380, 0.2524, 0.5635, 0.8791, 0.9794, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.2380, 0.2524, 0.2984, 0.6170, 0.9259, 0.9920, 0.9995, 0.9999, 0.9999,  &
0.2240, 0.2380, 0.2673, 0.3649, 0.6684, 0.9531, 0.9976, 0.9999, 0.9999,  &
0.2240, 0.2240, 0.2380, 0.2826, 0.3823, 0.6170, 0.9121, 0.9976, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.5994, 0.8146, 0.9484, 0.9929, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4000, 0.6849, 0.8881, 0.9744, 0.9976, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2380, 0.4540, 0.7615, 0.9379, 0.9897, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.2380, 0.2524, 0.5088, 0.8381, 0.9685, 0.9968, 0.9998, 0.9999, 0.9999,  &
0.2380, 0.2524, 0.2826, 0.5454, 0.8881, 0.9854, 0.9990, 0.9999, 0.9999,  &
0.2380, 0.2524, 0.2673, 0.3310, 0.5994, 0.9192, 0.9945, 0.9997, 0.9999,  &
0.2240, 0.2380, 0.2524, 0.2826, 0.3649, 0.5994, 0.8966, 0.9963, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.5635, 0.7890, 0.9379, 0.9897, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3823, 0.6516, 0.8596, 0.9685, 0.9963, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.2524, 0.4178, 0.7321, 0.9192, 0.9854, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.2524, 0.2673, 0.4540, 0.8020, 0.9574, 0.9945, 0.9997, 0.9999, 0.9999,  &
0.2524, 0.2673, 0.2826, 0.5088, 0.8491, 0.9794, 0.9984, 0.9999, 0.9999,  &
0.2380, 0.2524, 0.2673, 0.3145, 0.5454, 0.8881, 0.9909, 0.9995, 0.9999,  &
0.2380, 0.2524, 0.2524, 0.2826, 0.3478, 0.5454, 0.8596, 0.9938, 0.9998 /
data ((cldnuctab( 5,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9192, 0.9884, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.9614, 0.9963, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4178, 0.8146, 0.9836, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.5088, 0.8596, 0.9929, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3310, 0.3649, 0.5271, 0.8381, 0.9929, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.2984, 0.3310, 0.3823, 0.4722, 0.5994, 0.8266, 0.9909, 0.9999, 0.9999,  &
0.2826, 0.2984, 0.3145, 0.3823, 0.4358, 0.2826, 0.3145, 0.4178, 0.6849 /
data ((cldnuctab( 5,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.8791, 0.9744, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.9321, 0.9909, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.7470, 0.9651, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3478, 0.4358, 0.8020, 0.9836, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3310, 0.3649, 0.5088, 0.8266, 0.9920, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3145, 0.3310, 0.3823, 0.5088, 0.7470, 0.9685, 0.9997, 0.9999, 0.9999,  &
0.2984, 0.3145, 0.3310, 0.3823, 0.4722, 0.4358, 0.5994, 0.7890, 0.9897 /
data ((cldnuctab( 5,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.8266, 0.9574, 0.9938, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5994, 0.8881, 0.9816, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.6684, 0.9379, 0.9929, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3478, 0.4000, 0.7168, 0.9685, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3478, 0.3649, 0.4540, 0.7755, 0.9836, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.3310, 0.3478, 0.3823, 0.4905, 0.7615, 0.9816, 0.9997, 0.9999, 0.9999,  &
0.3145, 0.3310, 0.3478, 0.3823, 0.4722, 0.5816, 0.8020, 0.9771, 0.9999 /
data ((cldnuctab( 5,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.7615, 0.9321, 0.9884, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.8381, 0.9651, 0.9958, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.5816, 0.8966, 0.9854, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.3823, 0.6516, 0.9379, 0.9945, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3478, 0.3649, 0.4358, 0.7010, 0.9651, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.3478, 0.3478, 0.3823, 0.4722, 0.7168, 0.9716, 0.9994, 0.9999, 0.9999,  &
0.3310, 0.3478, 0.3478, 0.3823, 0.4722, 0.6170, 0.8791, 0.9963, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.7168, 0.9046, 0.9816, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.8020, 0.9484, 0.9929, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.5271, 0.8596, 0.9771, 0.9976, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.4000, 0.5816, 0.9046, 0.9897, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.3823, 0.4178, 0.6345, 0.9379, 0.9963, 0.9998, 0.9999, 0.9999,  &
0.3478, 0.3649, 0.3823, 0.4358, 0.6684, 0.9531, 0.9986, 0.9999, 0.9999,  &
0.3478, 0.3478, 0.3649, 0.3823, 0.4540, 0.6170, 0.8791, 0.9968, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.6849, 0.8791, 0.9744, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4540, 0.7615, 0.9321, 0.9897, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3823, 0.4905, 0.8266, 0.9651, 0.9958, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.3823, 0.4000, 0.5271, 0.8696, 0.9836, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.3649, 0.3823, 0.4178, 0.5816, 0.9046, 0.9929, 0.9996, 0.9999, 0.9999,  &
0.3649, 0.3649, 0.4000, 0.4358, 0.6170, 0.9259, 0.9972, 0.9999, 0.9999,  &
0.3649, 0.3649, 0.3649, 0.4000, 0.4540, 0.5994, 0.8596, 0.9958, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.6516, 0.8596, 0.9685, 0.9963, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4178, 0.7321, 0.9192, 0.9854, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.3823, 0.4540, 0.7890, 0.9531, 0.9945, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.3823, 0.4000, 0.4722, 0.8381, 0.9744, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.3823, 0.4000, 0.4178, 0.5271, 0.8696, 0.9884, 0.9993, 0.9999, 0.9999,  &
0.3823, 0.3823, 0.4000, 0.4358, 0.5816, 0.8881, 0.9945, 0.9998, 0.9999,  &
0.3649, 0.3823, 0.3823, 0.4000, 0.4540, 0.5816, 0.8266, 0.9945, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9484, 0.9945, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.9744, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.8146, 0.9884, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.5635, 0.8491, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4540, 0.4905, 0.5816, 0.7890, 0.9870, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4358, 0.4540, 0.4722, 0.5816, 0.5816, 0.7470, 0.9484, 0.9999, 0.9999,  &
0.4000, 0.4178, 0.4358, 0.4722, 0.5994, 0.3823, 0.3478, 0.4358, 0.6684 /
data ((cldnuctab( 5,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9121, 0.9884, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.9531, 0.9958, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5088, 0.7470, 0.9771, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.5454, 0.8020, 0.9884, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4722, 0.4905, 0.5635, 0.8020, 0.9909, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4358, 0.4540, 0.4905, 0.5816, 0.7010, 0.9259, 0.9995, 0.9999, 0.9999,  &
0.4358, 0.4358, 0.4540, 0.4905, 0.5816, 0.5271, 0.5635, 0.7321, 0.9685 /
data ((cldnuctab( 5,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.8696, 0.9771, 0.9976, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6170, 0.9192, 0.9909, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5088, 0.6684, 0.9531, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5088, 0.5454, 0.7321, 0.9744, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.5088, 0.5635, 0.7755, 0.9854, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.4722, 0.4722, 0.5088, 0.5635, 0.7321, 0.9651, 0.9997, 0.9999, 0.9999,  &
0.4540, 0.4540, 0.4722, 0.4905, 0.5635, 0.6345, 0.7321, 0.9379, 0.9999 /
data ((cldnuctab( 5,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.8266, 0.9614, 0.9952, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5635, 0.8881, 0.9836, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5088, 0.5994, 0.9259, 0.9929, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5088, 0.5271, 0.6684, 0.9531, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.5088, 0.5454, 0.7168, 0.9685, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.4905, 0.5088, 0.5635, 0.7168, 0.9614, 0.9996, 0.9999, 0.9999,  &
0.4722, 0.4722, 0.4905, 0.5088, 0.5635, 0.6684, 0.8020, 0.9870, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.7890, 0.9434, 0.9920, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.8491, 0.9716, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.5454, 0.8881, 0.9884, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5088, 0.5454, 0.5994, 0.9192, 0.9952, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.5088, 0.5271, 0.5454, 0.6684, 0.9434, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.4905, 0.5088, 0.5271, 0.5635, 0.6849, 0.9433, 0.9991, 0.9999, 0.9999,  &
0.4905, 0.4905, 0.5088, 0.5271, 0.5635, 0.6849, 0.8266, 0.9909, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.7470, 0.9321, 0.9884, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.8146, 0.9614, 0.9958, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.5635, 0.8596, 0.9816, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.5454, 0.5816, 0.8881, 0.9909, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.5271, 0.5635, 0.6345, 0.9121, 0.9963, 0.9998, 0.9999, 0.9999,  &
0.5088, 0.5088, 0.5271, 0.5635, 0.6684, 0.9121, 0.9982, 0.9999, 0.9999,  &
0.5088, 0.5088, 0.5088, 0.5271, 0.5635, 0.6684, 0.8146, 0.9929, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.7321, 0.9192, 0.9854, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5454, 0.7755, 0.9531, 0.9938, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5454, 0.5635, 0.8266, 0.9744, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5454, 0.5635, 0.5994, 0.8596, 0.9870, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.5271, 0.5454, 0.5635, 0.6170, 0.8791, 0.9938, 0.9997, 0.9999, 0.9999,  &
0.5271, 0.5271, 0.5454, 0.5635, 0.6516, 0.8791, 0.9963, 0.9999, 0.9999,  &
0.5088, 0.5271, 0.5271, 0.5454, 0.5635, 0.6516, 0.8146, 0.9870, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9651, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.9836, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6516, 0.8146, 0.9909, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6170, 0.6684, 0.8381, 0.9938, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5816, 0.5994, 0.6684, 0.7890, 0.9685, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5635, 0.5816, 0.5994, 0.6684, 0.7470, 0.7168, 0.8966, 0.9990, 0.9999,  &
0.5088, 0.5088, 0.5271, 0.5635, 0.6345, 0.8266, 0.4178, 0.4905, 0.6849 /
data ((cldnuctab( 5,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9434, 0.9945, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.9651, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6516, 0.7615, 0.9816, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6345, 0.6684, 0.8020, 0.9897, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6170, 0.6345, 0.6684, 0.8020, 0.9836, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.5994, 0.5994, 0.6170, 0.6516, 0.7755, 0.8791, 0.9972, 0.9999, 0.9999,  &
0.5635, 0.5635, 0.5816, 0.5994, 0.6684, 0.8381, 0.5635, 0.7168, 0.9192 /
data ((cldnuctab( 5,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9121, 0.9884, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.9434, 0.9958, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6516, 0.7010, 0.9651, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6345, 0.6684, 0.7615, 0.9771, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6170, 0.6345, 0.6684, 0.7890, 0.9794, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.5994, 0.6170, 0.6345, 0.6684, 0.7755, 0.9259, 0.9996, 0.9999, 0.9999,  &
0.5994, 0.5994, 0.6170, 0.6345, 0.6684, 0.7755, 0.7010, 0.8791, 0.9976 /
data ((cldnuctab( 5,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.8696, 0.9816, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.9121, 0.9920, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.7010, 0.9379, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6516, 0.6684, 0.7321, 0.9574, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6345, 0.6516, 0.6684, 0.7615, 0.9651, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.6170, 0.6345, 0.6516, 0.6684, 0.7615, 0.9321, 0.9996, 0.9999, 0.9999,  &
0.6170, 0.6170, 0.6345, 0.6345, 0.6684, 0.7615, 0.7890, 0.9614, 0.9999 /
data ((cldnuctab( 5,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.8381, 0.9716, 0.9972, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.8791, 0.9854, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.7010, 0.9046, 0.9938, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.6849, 0.7168, 0.9259, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6516, 0.6684, 0.6849, 0.7470, 0.9379, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.6345, 0.6516, 0.6516, 0.6849, 0.7470, 0.9192, 0.9991, 0.9999, 0.9999,  &
0.6345, 0.6345, 0.6345, 0.6516, 0.6684, 0.7470, 0.8381, 0.9744, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.8020, 0.9614, 0.9958, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.8491, 0.9794, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.7010, 0.8696, 0.9897, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.6849, 0.7168, 0.8966, 0.9952, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.6684, 0.6849, 0.7321, 0.9121, 0.9976, 0.9999, 0.9999, 0.9999,  &
0.6516, 0.6516, 0.6684, 0.6849, 0.7321, 0.8966, 0.9982, 0.9999, 0.9999,  &
0.6516, 0.6516, 0.6516, 0.6684, 0.6849, 0.7470, 0.8596, 0.9771, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.7755, 0.9531, 0.9938, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.8146, 0.9716, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.7010, 0.8381, 0.9854, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.7010, 0.7168, 0.8596, 0.9920, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.6849, 0.7010, 0.7321, 0.8791, 0.9958, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.6684, 0.6849, 0.7010, 0.7321, 0.8791, 0.9963, 0.9999, 0.9999,  &
0.6684, 0.6684, 0.6684, 0.6684, 0.6849, 0.7321, 0.8596, 0.9716, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9716, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.9854, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.8266, 0.9909, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.7321, 0.8381, 0.9909, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.6849, 0.7168, 0.8266, 0.9379, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.6345, 0.6516, 0.6684, 0.7168, 0.8596, 0.7168, 0.8696, 0.9920, 0.9999,  &
0.5635, 0.5635, 0.5635, 0.5994, 0.6684, 0.8020, 0.4722, 0.5271, 0.6849 /
data ((cldnuctab( 5,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9484, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.9685, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7890, 0.9816, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7010, 0.7321, 0.8266, 0.9870, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.6849, 0.7321, 0.8266, 0.9716, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6684, 0.6684, 0.6849, 0.7321, 0.8266, 0.8596, 0.9897, 0.9999, 0.9999,  &
0.6345, 0.6345, 0.6345, 0.6684, 0.7168, 0.8491, 0.6170, 0.7010, 0.8881 /
data ((cldnuctab( 5,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9192, 0.9929, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.9484, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7615, 0.9651, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.7321, 0.8020, 0.9744, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7010, 0.7168, 0.7321, 0.8146, 0.9716, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.7010, 0.7010, 0.7321, 0.8146, 0.9121, 0.9990, 0.9999, 0.9999,  &
0.6684, 0.6684, 0.6849, 0.7010, 0.7321, 0.8266, 0.7615, 0.8696, 0.9909 /
data ((cldnuctab( 5,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.8881, 0.9870, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.9192, 0.9945, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7615, 0.9379, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7470, 0.7890, 0.9531, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.7168, 0.7470, 0.8020, 0.9574, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.7010, 0.7168, 0.7168, 0.7321, 0.8020, 0.9192, 0.9994, 0.9999, 0.9999,  &
0.6849, 0.7010, 0.7010, 0.7168, 0.7321, 0.8020, 0.8491, 0.9321, 0.9997 /
data ((cldnuctab( 5,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.8596, 0.9794, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.8881, 0.9909, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7615, 0.9046, 0.9958, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7470, 0.7755, 0.9259, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7321, 0.7470, 0.7890, 0.9321, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.7168, 0.7321, 0.7470, 0.7890, 0.9121, 0.9988, 0.9999, 0.9999,  &
0.7168, 0.7168, 0.7168, 0.7321, 0.7470, 0.7890, 0.8881, 0.9574, 0.9999 /
data ((cldnuctab( 5,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.8266, 0.9716, 0.9976, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.8596, 0.9854, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7755, 0.8791, 0.9929, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7615, 0.7890, 0.8966, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7470, 0.7615, 0.7890, 0.9121, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7321, 0.7470, 0.7615, 0.7890, 0.9046, 0.9976, 0.9999, 0.9999,  &
0.7168, 0.7321, 0.7321, 0.7321, 0.7470, 0.7890, 0.8881, 0.9574, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.8020, 0.9651, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.8266, 0.9794, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.7755, 0.8491, 0.9897, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.7615, 0.7890, 0.8696, 0.9938, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7470, 0.7615, 0.7890, 0.8881, 0.9963, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7470, 0.7470, 0.7615, 0.7890, 0.8881, 0.9952, 0.9999, 0.9999,  &
0.7321, 0.7321, 0.7470, 0.7470, 0.7615, 0.7890, 0.8791, 0.9574, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9744, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.9854, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.8381, 0.9909, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7615, 0.8491, 0.9870, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.7321, 0.7615, 0.8491, 0.9259, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.6849, 0.6849, 0.7010, 0.7615, 0.8696, 0.7321, 0.8491, 0.9836, 0.9999,  &
0.5994, 0.5994, 0.5994, 0.6170, 0.6684, 0.8020, 0.5454, 0.5454, 0.6849 /
data ((cldnuctab( 5,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9531, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.9716, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.8146, 0.9816, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.7755, 0.8381, 0.9836, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7321, 0.7470, 0.7615, 0.8381, 0.9651, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.7168, 0.7321, 0.7755, 0.8491, 0.8596, 0.9794, 0.9999, 0.9999,  &
0.6684, 0.6684, 0.6849, 0.7010, 0.7470, 0.8491, 0.7168, 0.7168, 0.8791 /
data ((cldnuctab( 5,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9259, 0.9945, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.9484, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.8146, 0.9651, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.7755, 0.8266, 0.9744, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7615, 0.7755, 0.8266, 0.9651, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7470, 0.7615, 0.7755, 0.8381, 0.9046, 0.9972, 0.9999, 0.9999,  &
0.7168, 0.7168, 0.7168, 0.7321, 0.7615, 0.8491, 0.8491, 0.8491, 0.9836 /
data ((cldnuctab( 5,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.8966, 0.9909, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.9192, 0.9958, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.8146, 0.9379, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.7890, 0.8266, 0.9531, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.7755, 0.7890, 0.8266, 0.9531, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.7615, 0.7615, 0.7755, 0.8266, 0.9259, 0.9988, 0.9999, 0.9999,  &
0.7321, 0.7470, 0.7470, 0.7615, 0.7755, 0.8381, 0.8966, 0.9259, 0.9990 /
data ((cldnuctab( 5,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.8696, 0.9854, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8881, 0.9929, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.8146, 0.9046, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.7890, 0.8146, 0.9259, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.7755, 0.7890, 0.8266, 0.9321, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.7755, 0.7755, 0.7890, 0.8266, 0.9192, 0.9979, 0.9999, 0.9999,  &
0.7615, 0.7615, 0.7615, 0.7755, 0.7890, 0.8266, 0.9121, 0.9434, 0.9998 /
data ((cldnuctab( 5,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.8381, 0.9794, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8596, 0.9884, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8146, 0.8791, 0.9938, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.8020, 0.8266, 0.8966, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.7890, 0.8020, 0.8266, 0.9121, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.7890, 0.7890, 0.8020, 0.8266, 0.9121, 0.9968, 0.9999, 0.9999,  &
0.7755, 0.7755, 0.7755, 0.7755, 0.7890, 0.8266, 0.9046, 0.9531, 0.9999 /
data ((cldnuctab( 5,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.8146, 0.9716, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8266, 0.9836, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8266, 0.8491, 0.9909, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8146, 0.8266, 0.8791, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.8020, 0.8146, 0.8266, 0.8966, 0.9963, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.7890, 0.8020, 0.8020, 0.8266, 0.8966, 0.9929, 0.9999, 0.9999,  &
0.7755, 0.7755, 0.7890, 0.7890, 0.8020, 0.8266, 0.8966, 0.9574, 0.9999 /
data ((cldnuctab( 5,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9744, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8381, 0.9854, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8596, 0.9897, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.7890, 0.8596, 0.9836, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7615, 0.7615, 0.7890, 0.8596, 0.9192, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.7168, 0.7168, 0.7321, 0.7755, 0.8696, 0.7755, 0.8381, 0.9771, 0.9999,  &
0.6170, 0.6170, 0.6170, 0.6345, 0.6849, 0.7890, 0.9614, 0.5635, 0.7010 /
data ((cldnuctab( 5,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9574, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8266, 0.9716, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8491, 0.9794, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.8020, 0.8491, 0.9816, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.7755, 0.8020, 0.8596, 0.9574, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7470, 0.7615, 0.7755, 0.8020, 0.8696, 0.8791, 0.9685, 0.9999, 0.9999,  &
0.7010, 0.7010, 0.7010, 0.7168, 0.7615, 0.8491, 0.8491, 0.7168, 0.8696 /
data ((cldnuctab( 5,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9321, 0.9958, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8266, 0.9484, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8381, 0.9651, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8146, 0.8491, 0.9716, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.8020, 0.8020, 0.8491, 0.9614, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7755, 0.7755, 0.7890, 0.8020, 0.8491, 0.9192, 0.9963, 0.9999, 0.9999,  &
0.7470, 0.7470, 0.7470, 0.7615, 0.7890, 0.8596, 0.9121, 0.8381, 0.9771 /
data ((cldnuctab( 5,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9046, 0.9920, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8266, 0.9192, 0.9968, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8381, 0.9379, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8146, 0.8491, 0.9531, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8020, 0.8146, 0.8491, 0.9484, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.7890, 0.7890, 0.8020, 0.8146, 0.8491, 0.9321, 0.9976, 0.9999, 0.9999,  &
0.7755, 0.7755, 0.7755, 0.7890, 0.8020, 0.8491, 0.9259, 0.9046, 0.9976 /
data ((cldnuctab( 5,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.8696, 0.9870, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8381, 0.8881, 0.9938, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8266, 0.8381, 0.9046, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8266, 0.8491, 0.9259, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8146, 0.8266, 0.8491, 0.9321, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8020, 0.8020, 0.8146, 0.8266, 0.8491, 0.9259, 0.9972, 0.9999, 0.9999,  &
0.7890, 0.7890, 0.7890, 0.8020, 0.8146, 0.8491, 0.9259, 0.9379, 0.9996 /
data ((cldnuctab( 5,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.8491, 0.9816, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8381, 0.8596, 0.9909, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8381, 0.8491, 0.8791, 0.9952, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8266, 0.8381, 0.8491, 0.9046, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8266, 0.8266, 0.8491, 0.9192, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.8146, 0.8146, 0.8266, 0.8266, 0.8491, 0.9192, 0.9952, 0.9999, 0.9999,  &
0.8020, 0.8020, 0.8020, 0.8146, 0.8266, 0.8491, 0.9192, 0.9531, 0.9998 /
data ((cldnuctab( 5,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.8491, 0.9771, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8491, 0.8596, 0.9870, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8381, 0.8491, 0.8791, 0.9920, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8381, 0.8381, 0.8491, 0.8966, 0.9952, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8266, 0.8266, 0.8381, 0.8596, 0.9046, 0.9958, 0.9999, 0.9999, 0.9999,  &
0.8266, 0.8266, 0.8266, 0.8381, 0.8491, 0.9121, 0.9920, 0.9999, 0.9999,  &
0.8146, 0.8146, 0.8146, 0.8146, 0.8266, 0.8491, 0.9121, 0.9614, 0.9998 /
data ((cldnuctab( 6,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9704, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7701, 0.9847, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.8219, 0.9916, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6785, 0.7262, 0.8448, 0.9916, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6618, 0.6785, 0.7107, 0.8219, 0.9513, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.6277, 0.6449, 0.6618, 0.7262, 0.8657, 0.7107, 0.8846, 0.9974, 0.9999,  &
0.5564, 0.5564, 0.5745, 0.5924, 0.6618, 0.8097, 0.4650, 0.5382, 0.6948 /
data ((cldnuctab( 6,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9513, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.9704, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7838, 0.9828, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6948, 0.7262, 0.8219, 0.9879, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6785, 0.6785, 0.7262, 0.8219, 0.9785, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6618, 0.6785, 0.6948, 0.7262, 0.8219, 0.8657, 0.9942, 0.9999, 0.9999,  &
0.6277, 0.6277, 0.6449, 0.6618, 0.7107, 0.8448, 0.6102, 0.7262, 0.9092 /
data ((cldnuctab( 6,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.9233, 0.9926, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.9465, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7701, 0.9672, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7107, 0.7262, 0.7970, 0.9761, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6948, 0.7107, 0.7262, 0.8097, 0.9734, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.6785, 0.6948, 0.6948, 0.7262, 0.8097, 0.9165, 0.9994, 0.9999, 0.9999,  &
0.6618, 0.6618, 0.6785, 0.6948, 0.7262, 0.8336, 0.7412, 0.8657, 0.9949 /
data ((cldnuctab( 6,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.8846, 0.9864, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.9165, 0.9942, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7559, 0.9413, 0.9978, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7412, 0.7838, 0.9557, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7107, 0.7262, 0.7412, 0.7970, 0.9599, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.6948, 0.7107, 0.7107, 0.7262, 0.7970, 0.9233, 0.9996, 0.9999, 0.9999,  &
0.6948, 0.6948, 0.6948, 0.7107, 0.7412, 0.7970, 0.8336, 0.9465, 0.9999 /
data ((cldnuctab( 6,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.8555, 0.9785, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.8846, 0.9905, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.7559, 0.9092, 0.9956, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7412, 0.7701, 0.9297, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7262, 0.7412, 0.7838, 0.9357, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.7107, 0.7107, 0.7262, 0.7412, 0.7838, 0.9165, 0.9992, 0.9999, 0.9999,  &
0.7107, 0.7107, 0.7107, 0.7262, 0.7412, 0.7838, 0.8754, 0.9672, 0.9999 /
data ((cldnuctab( 6,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.8219, 0.9704, 0.9974, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7559, 0.8555, 0.9847, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.7701, 0.8754, 0.9926, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.7559, 0.7838, 0.8933, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7412, 0.7559, 0.7838, 0.9092, 0.9981, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7262, 0.7412, 0.7559, 0.7838, 0.9015, 0.9981, 0.9999, 0.9999,  &
0.7107, 0.7262, 0.7262, 0.7262, 0.7412, 0.7838, 0.8846, 0.9637, 0.9999 /
data ((cldnuctab( 6,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.7970, 0.9637, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7559, 0.8219, 0.9808, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7559, 0.7701, 0.8448, 0.9892, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.7559, 0.7838, 0.8657, 0.9942, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.7412, 0.7559, 0.7838, 0.8933, 0.9966, 0.9999, 0.9999, 0.9999,  &
0.7412, 0.7412, 0.7412, 0.7559, 0.7838, 0.8846, 0.9961, 0.9999, 0.9999,  &
0.7262, 0.7262, 0.7412, 0.7412, 0.7559, 0.7838, 0.8846, 0.9599, 0.9999 /
data ((cldnuctab( 6,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9761, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8555, 0.9847, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8219, 0.8657, 0.9892, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7970, 0.8097, 0.8657, 0.9808, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7701, 0.7838, 0.8097, 0.8754, 0.9165, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.7262, 0.7412, 0.7559, 0.7838, 0.8754, 0.7970, 0.8448, 0.9761, 0.9999,  &
0.6277, 0.6277, 0.6449, 0.6618, 0.6948, 0.7970, 0.9557, 0.5924, 0.7107 /
data ((cldnuctab( 6,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9599, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.9704, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8219, 0.8555, 0.9808, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7970, 0.8219, 0.8657, 0.9808, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7970, 0.7970, 0.8219, 0.8657, 0.9557, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.7701, 0.7838, 0.7838, 0.8097, 0.8754, 0.8933, 0.9672, 0.9999, 0.9999,  &
0.7107, 0.7107, 0.7262, 0.7262, 0.7701, 0.8555, 0.9828, 0.7262, 0.8754 /
data ((cldnuctab( 6,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9357, 0.9966, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.9513, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8336, 0.8555, 0.9637, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8219, 0.8336, 0.8657, 0.9704, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8097, 0.8097, 0.8219, 0.8657, 0.9599, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7970, 0.7970, 0.8097, 0.8219, 0.8657, 0.9357, 0.9949, 0.9999, 0.9999,  &
0.7559, 0.7559, 0.7701, 0.7838, 0.8097, 0.8657, 0.9357, 0.8448, 0.9761 /
data ((cldnuctab( 6,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.9015, 0.9935, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.9233, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8336, 0.8555, 0.9357, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8336, 0.8336, 0.8555, 0.9513, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8219, 0.8219, 0.8336, 0.8657, 0.9513, 0.9997, 0.9999, 0.9999, 0.9999,  &
0.8097, 0.8097, 0.8219, 0.8336, 0.8555, 0.9413, 0.9978, 0.9999, 0.9999,  &
0.7838, 0.7970, 0.7970, 0.7970, 0.8219, 0.8657, 0.9413, 0.9015, 0.9970 /
data ((cldnuctab( 6,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.8754, 0.9892, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8555, 0.8933, 0.9949, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.8555, 0.9092, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8336, 0.8448, 0.8657, 0.9297, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8336, 0.8336, 0.8448, 0.8657, 0.9357, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8219, 0.8219, 0.8336, 0.8448, 0.8657, 0.9297, 0.9961, 0.9999, 0.9999,  &
0.8097, 0.8097, 0.8097, 0.8219, 0.8336, 0.8657, 0.9357, 0.9413, 0.9995 /
data ((cldnuctab( 6,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.8657, 0.9847, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8555, 0.8754, 0.9916, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8555, 0.8657, 0.8933, 0.9956, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.8555, 0.8657, 0.9092, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8336, 0.8448, 0.8448, 0.8657, 0.9233, 0.9981, 0.9999, 0.9999, 0.9999,  &
0.8336, 0.8336, 0.8448, 0.8448, 0.8657, 0.9233, 0.9942, 0.9999, 0.9999,  &
0.8219, 0.8219, 0.8219, 0.8336, 0.8448, 0.8657, 0.9233, 0.9513, 0.9998 /
data ((cldnuctab( 6,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.8657, 0.9785, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8657, 0.8754, 0.9879, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8555, 0.8657, 0.8933, 0.9926, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8555, 0.8555, 0.8657, 0.9092, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.8448, 0.8555, 0.8657, 0.9165, 0.9961, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.8448, 0.8448, 0.8555, 0.8657, 0.9165, 0.9916, 0.9999, 0.9999,  &
0.8336, 0.8336, 0.8336, 0.8336, 0.8448, 0.8657, 0.9165, 0.9672, 0.9998 /
data ((cldnuctab( 6,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9734, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9808, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8846, 0.9165, 0.9828, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8754, 0.8933, 0.9092, 0.9734, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8555, 0.8657, 0.8754, 0.9165, 0.9672, 0.9879, 0.9999, 0.9999, 0.9999,  &
0.7970, 0.7970, 0.8097, 0.8336, 0.8846, 0.9808, 0.8448, 0.9465, 0.9999,  &
0.6948, 0.6948, 0.7107, 0.7107, 0.7412, 0.7970, 0.9165, 0.6785, 0.7559 /
data ((cldnuctab( 6,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9557, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9672, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9015, 0.9165, 0.9761, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8933, 0.8933, 0.9165, 0.9734, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8754, 0.8846, 0.8933, 0.9165, 0.9672, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.8448, 0.8448, 0.8555, 0.8754, 0.9092, 0.9828, 0.9357, 0.9985, 0.9999,  &
0.7701, 0.7701, 0.7838, 0.7838, 0.8097, 0.8657, 0.9599, 0.7701, 0.8657 /
data ((cldnuctab( 6,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9357, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9465, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9092, 0.9165, 0.9599, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8933, 0.9015, 0.9165, 0.9672, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8933, 0.8933, 0.9015, 0.9165, 0.9637, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.8754, 0.8754, 0.8846, 0.8933, 0.9165, 0.9761, 0.9808, 0.9999, 0.9999,  &
0.8336, 0.8336, 0.8336, 0.8336, 0.8555, 0.8933, 0.9704, 0.8555, 0.9465 /
data ((cldnuctab( 6,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9233, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9357, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9092, 0.9233, 0.9465, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9015, 0.9092, 0.9233, 0.9557, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9015, 0.9015, 0.9092, 0.9165, 0.9599, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8933, 0.8933, 0.8933, 0.9015, 0.9233, 0.9599, 0.9892, 0.9999, 0.9999,  &
0.8555, 0.8555, 0.8657, 0.8657, 0.8754, 0.9092, 0.9637, 0.9297, 0.9828 /
data ((cldnuctab( 6,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.9297, 0.9935, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9233, 0.9357, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9233, 0.9413, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9092, 0.9165, 0.9233, 0.9513, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9092, 0.9092, 0.9165, 0.9233, 0.9513, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.9015, 0.9015, 0.9015, 0.9092, 0.9233, 0.9513, 0.9905, 0.9999, 0.9999,  &
0.8754, 0.8754, 0.8754, 0.8846, 0.8933, 0.9092, 0.9557, 0.9808, 0.9949 /
data ((cldnuctab( 6,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.9297, 0.9905, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9233, 0.9357, 0.9942, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9233, 0.9297, 0.9413, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9233, 0.9297, 0.9465, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9165, 0.9165, 0.9233, 0.9465, 0.9966, 0.9999, 0.9999, 0.9999,  &
0.9092, 0.9092, 0.9092, 0.9165, 0.9233, 0.9465, 0.9916, 0.9999, 0.9999,  &
0.8846, 0.8846, 0.8846, 0.8933, 0.9015, 0.9165, 0.9513, 0.9892, 0.9970 /
data ((cldnuctab( 6,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.9357, 0.9879, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9297, 0.9357, 0.9916, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9233, 0.9297, 0.9413, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9233, 0.9233, 0.9297, 0.9465, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9233, 0.9233, 0.9297, 0.9465, 0.9942, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9165, 0.9165, 0.9233, 0.9297, 0.9465, 0.9905, 0.9999, 0.9999,  &
0.8933, 0.8933, 0.8933, 0.9015, 0.9015, 0.9165, 0.9465, 0.9892, 0.9974 /
data ((cldnuctab( 6,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9734, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9808, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9465, 0.9513, 0.9808, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9357, 0.9413, 0.9513, 0.9828, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9092, 0.9092, 0.9233, 0.9413, 0.9847, 0.9734, 0.9997, 0.9999, 0.9999,  &
0.8448, 0.8448, 0.8555, 0.8657, 0.9015, 0.9637, 0.8933, 0.9357, 0.9978,  &
0.7701, 0.7701, 0.7701, 0.7701, 0.7838, 0.8219, 0.8933, 0.9785, 0.8219 /
data ((cldnuctab( 6,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9672, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9734, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9465, 0.9557, 0.9785, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9413, 0.9465, 0.9557, 0.9785, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9297, 0.9357, 0.9413, 0.9513, 0.9828, 0.9942, 0.9999, 0.9999, 0.9999,  &
0.8933, 0.8933, 0.9015, 0.9092, 0.9357, 0.9785, 0.9637, 0.9905, 0.9999,  &
0.8219, 0.8219, 0.8336, 0.8336, 0.8448, 0.8754, 0.9413, 0.9991, 0.8846 /
data ((cldnuctab( 6,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9672, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9704, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9513, 0.9599, 0.9734, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9513, 0.9513, 0.9557, 0.9761, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9413, 0.9465, 0.9465, 0.9557, 0.9761, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.9233, 0.9233, 0.9233, 0.9357, 0.9465, 0.9785, 0.9905, 0.9995, 0.9999,  &
0.8754, 0.8754, 0.8754, 0.8754, 0.8846, 0.9092, 0.9599, 0.9997, 0.9357 /
data ((cldnuctab( 6,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9672, 0.9978, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9704, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9599, 0.9734, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9557, 0.9599, 0.9734, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9513, 0.9513, 0.9557, 0.9599, 0.9734, 0.9978, 0.9999, 0.9999, 0.9999,  &
0.9357, 0.9357, 0.9413, 0.9465, 0.9557, 0.9761, 0.9961, 0.9999, 0.9999,  &
0.9015, 0.9015, 0.9015, 0.9092, 0.9165, 0.9297, 0.9672, 0.9994, 0.9704 /
data ((cldnuctab( 6,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9672, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9704, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9637, 0.9704, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9599, 0.9637, 0.9734, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9557, 0.9599, 0.9637, 0.9734, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.9465, 0.9465, 0.9465, 0.9513, 0.9599, 0.9734, 0.9961, 0.9999, 0.9999,  &
0.9165, 0.9165, 0.9165, 0.9233, 0.9297, 0.9413, 0.9637, 0.9983, 0.9847 /
data ((cldnuctab( 6,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9672, 0.9935, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9704, 0.9956, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9672, 0.9734, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9637, 0.9637, 0.9734, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9599, 0.9599, 0.9637, 0.9734, 0.9956, 0.9999, 0.9999, 0.9999,  &
0.9513, 0.9513, 0.9513, 0.9557, 0.9599, 0.9734, 0.9949, 0.9999, 0.9999,  &
0.9297, 0.9297, 0.9297, 0.9297, 0.9357, 0.9413, 0.9637, 0.9966, 0.9916 /
data ((cldnuctab( 6,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9704, 0.9916, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9734, 0.9926, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9672, 0.9734, 0.9935, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9637, 0.9672, 0.9734, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9637, 0.9637, 0.9672, 0.9734, 0.9935, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9557, 0.9557, 0.9599, 0.9637, 0.9734, 0.9935, 0.9999, 0.9999,  &
0.9357, 0.9357, 0.9357, 0.9357, 0.9357, 0.9465, 0.9637, 0.9942, 0.9974 /
data ((cldnuctab( 6,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9808, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9847, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9704, 0.9847, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9599, 0.9672, 0.9879, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9297, 0.9297, 0.9357, 0.9513, 0.9847, 0.9879, 0.9983, 0.9999, 0.9999,  &
0.8754, 0.8754, 0.8754, 0.8846, 0.9092, 0.9557, 0.9995, 0.9357, 0.9949,  &
0.8097, 0.8097, 0.8097, 0.8097, 0.8219, 0.8448, 0.9015, 0.9672, 0.8657 /
data ((cldnuctab( 6,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9808, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9828, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9704, 0.9828, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9637, 0.9704, 0.9828, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9513, 0.9513, 0.9557, 0.9672, 0.9864, 0.9966, 0.9999, 0.9999, 0.9999,  &
0.9165, 0.9165, 0.9165, 0.9233, 0.9413, 0.9761, 0.9998, 0.9847, 0.9999,  &
0.8555, 0.8555, 0.8555, 0.8555, 0.8657, 0.8933, 0.9357, 0.9949, 0.9015 /
data ((cldnuctab( 6,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9785, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9733, 0.9808, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9734, 0.9828, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9704, 0.9734, 0.9828, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9637, 0.9637, 0.9704, 0.9847, 0.9981, 0.9999, 0.9999, 0.9999,  &
0.9413, 0.9413, 0.9413, 0.9465, 0.9599, 0.9808, 0.9997, 0.9981, 0.9999,  &
0.8933, 0.8933, 0.8933, 0.9015, 0.9015, 0.9233, 0.9557, 0.9983, 0.9413 /
data ((cldnuctab( 6,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9808, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9808, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9761, 0.9828, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9734, 0.9761, 0.9828, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9672, 0.9704, 0.9734, 0.9828, 0.9981, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9557, 0.9557, 0.9599, 0.9672, 0.9828, 0.9989, 0.9997, 0.9999,  &
0.9233, 0.9233, 0.9233, 0.9233, 0.9297, 0.9413, 0.9672, 0.9983, 0.9704 /
data ((cldnuctab( 6,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9808, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9808, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9785, 0.9828, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9761, 0.9761, 0.9828, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9704, 0.9734, 0.9761, 0.9828, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9637, 0.9637, 0.9637, 0.9704, 0.9808, 0.9978, 0.9999, 0.9999,  &
0.9357, 0.9357, 0.9357, 0.9357, 0.9413, 0.9513, 0.9672, 0.9970, 0.9864 /
data ((cldnuctab( 6,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9808, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9828, 0.9956, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9785, 0.9828, 0.9956, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9761, 0.9785, 0.9828, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9734, 0.9761, 0.9785, 0.9828, 0.9956, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9672, 0.9672, 0.9704, 0.9734, 0.9808, 0.9961, 0.9999, 0.9999,  &
0.9413, 0.9413, 0.9413, 0.9465, 0.9465, 0.9557, 0.9704, 0.9949, 0.9978 /
data ((cldnuctab( 6,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9828, 0.9916, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9828, 0.9926, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9808, 0.9828, 0.9935, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9785, 0.9808, 0.9828, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9761, 0.9785, 0.9785, 0.9828, 0.9942, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9704, 0.9704, 0.9704, 0.9734, 0.9808, 0.9949, 0.9999, 0.9999,  &
0.9465, 0.9465, 0.9465, 0.9465, 0.9513, 0.9557, 0.9704, 0.9926, 0.9998 /
data ((cldnuctab( 6,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9864, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9879, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9785, 0.9864, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9672, 0.9734, 0.9892, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9357, 0.9413, 0.9465, 0.9599, 0.9828, 0.9999, 0.9966, 0.9999, 0.9999,  &
0.8933, 0.8933, 0.8933, 0.9015, 0.9165, 0.9557, 0.9981, 0.9413, 0.9916,  &
0.8336, 0.8448, 0.8448, 0.8448, 0.8555, 0.8657, 0.9092, 0.9637, 0.9905 /
data ((cldnuctab( 6,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9864, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9864, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9785, 0.9864, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9734, 0.9785, 0.9879, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9599, 0.9599, 0.9637, 0.9734, 0.9879, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9297, 0.9297, 0.9297, 0.9357, 0.9465, 0.9761, 0.9996, 0.9808, 0.9999,  &
0.8754, 0.8754, 0.8754, 0.8754, 0.8846, 0.9015, 0.9357, 0.9905, 0.9165 /
data ((cldnuctab( 6,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9864, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9864, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9808, 0.9864, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9785, 0.9808, 0.9864, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9704, 0.9734, 0.9785, 0.9879, 0.9989, 0.9999, 0.9999, 0.9999,  &
0.9513, 0.9513, 0.9513, 0.9557, 0.9637, 0.9828, 0.9995, 0.9966, 0.9999,  &
0.9092, 0.9092, 0.9092, 0.9092, 0.9165, 0.9297, 0.9557, 0.9961, 0.9513 /
data ((cldnuctab( 6,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9864, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9864, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9828, 0.9864, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9808, 0.9828, 0.9864, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9761, 0.9785, 0.9808, 0.9879, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.9637, 0.9637, 0.9637, 0.9672, 0.9734, 0.9847, 0.9992, 0.9994, 0.9999,  &
0.9297, 0.9297, 0.9297, 0.9357, 0.9357, 0.9465, 0.9672, 0.9966, 0.9734 /
data ((cldnuctab( 6,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9864, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9847, 0.9879, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9847, 0.9879, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9828, 0.9847, 0.9879, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9785, 0.9808, 0.9828, 0.9879, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9704, 0.9704, 0.9734, 0.9761, 0.9847, 0.9983, 0.9997, 0.9999,  &
0.9465, 0.9465, 0.9465, 0.9465, 0.9465, 0.9557, 0.9704, 0.9956, 0.9956 /
data ((cldnuctab( 6,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9879, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9879, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9847, 0.9864, 0.9879, 0.9956, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9847, 0.9847, 0.9879, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9808, 0.9828, 0.9847, 0.9879, 0.9961, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9734, 0.9734, 0.9761, 0.9785, 0.9847, 0.9970, 0.9999, 0.9999,  &
0.9513, 0.9513, 0.9513, 0.9513, 0.9557, 0.9599, 0.9734, 0.9935, 0.9999 /
data ((cldnuctab( 6,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9879, 0.9916, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9879, 0.9935, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9864, 0.9879, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9847, 0.9847, 0.9864, 0.9879, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9828, 0.9847, 0.9847, 0.9879, 0.9956, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9761, 0.9761, 0.9785, 0.9808, 0.9864, 0.9956, 0.9999, 0.9999,  &
0.9557, 0.9557, 0.9557, 0.9557, 0.9599, 0.9637, 0.9734, 0.9916, 0.9999 /
data ((cldnuctab( 6,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9892, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9892, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9828, 0.9892, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9704, 0.9734, 0.9785, 0.9905, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9465, 0.9465, 0.9513, 0.9599, 0.9828, 0.9998, 0.9956, 0.9999, 0.9999,  &
0.9015, 0.9015, 0.9015, 0.9092, 0.9233, 0.9557, 0.9961, 0.9513, 0.9905,  &
0.8657, 0.8657, 0.8657, 0.8657, 0.8657, 0.8846, 0.9165, 0.9637, 0.9879 /
data ((cldnuctab( 6,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9892, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9847, 0.9892, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9847, 0.9892, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9808, 0.9828, 0.9905, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9672, 0.9704, 0.9761, 0.9892, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.9357, 0.9357, 0.9357, 0.9413, 0.9513, 0.9734, 0.9992, 0.9808, 0.9997,  &
0.8933, 0.8933, 0.8933, 0.8933, 0.9015, 0.9092, 0.9413, 0.9864, 0.9999 /
data ((cldnuctab( 6,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9892, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9892, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9847, 0.9864, 0.9905, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9828, 0.9828, 0.9864, 0.9892, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9761, 0.9761, 0.9785, 0.9828, 0.9905, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9557, 0.9557, 0.9599, 0.9599, 0.9672, 0.9828, 0.9993, 0.9956, 0.9999,  &
0.9165, 0.9165, 0.9165, 0.9233, 0.9233, 0.9357, 0.9599, 0.9942, 0.9599 /
data ((cldnuctab( 6,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9892, 0.9981, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9879, 0.9905, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9879, 0.9905, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9847, 0.9864, 0.9864, 0.9892, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9808, 0.9828, 0.9847, 0.9905, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.9672, 0.9704, 0.9704, 0.9704, 0.9761, 0.9864, 0.9989, 0.9991, 0.9999,  &
0.9413, 0.9413, 0.9413, 0.9413, 0.9413, 0.9513, 0.9672, 0.9949, 0.9905 /
data ((cldnuctab( 6,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9905, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9905, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9879, 0.9879, 0.9905, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9879, 0.9879, 0.9905, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9847, 0.9847, 0.9847, 0.9864, 0.9905, 0.9978, 0.9999, 0.9999, 0.9999,  &
0.9734, 0.9761, 0.9761, 0.9761, 0.9808, 0.9879, 0.9981, 0.9998, 0.9999,  &
0.9513, 0.9513, 0.9513, 0.9513, 0.9557, 0.9599, 0.9734, 0.9942, 0.9999 /
data ((cldnuctab( 6,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9905, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9916, 0.9956, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9892, 0.9916, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9879, 0.9879, 0.9892, 0.9905, 0.9966, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9864, 0.9864, 0.9879, 0.9905, 0.9966, 0.9999, 0.9999, 0.9999,  &
0.9785, 0.9785, 0.9785, 0.9808, 0.9828, 0.9879, 0.9970, 0.9999, 0.9999,  &
0.9557, 0.9557, 0.9557, 0.9557, 0.9599, 0.9637, 0.9734, 0.9926, 0.9999 /
data ((cldnuctab( 6,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9916, 0.9942, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9905, 0.9916, 0.9949, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9905, 0.9916, 0.9956, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9892, 0.9892, 0.9905, 0.9916, 0.9961, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9864, 0.9879, 0.9879, 0.9892, 0.9916, 0.9961, 0.9999, 0.9999, 0.9999,  &
0.9808, 0.9808, 0.9808, 0.9808, 0.9828, 0.9879, 0.9961, 0.9999, 0.9999,  &
0.9599, 0.9599, 0.9599, 0.9599, 0.9637, 0.9672, 0.9761, 0.9905, 0.9999 /
data ((cldnuctab( 7,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9755, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8734, 0.9843, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8425, 0.8827, 0.9876, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8193, 0.8312, 0.8827, 0.9755, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8070, 0.8070, 0.8312, 0.8915, 0.9219, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.7528, 0.7528, 0.7670, 0.8070, 0.8827, 0.8636, 0.8425, 0.9727, 0.9999,  &
0.6582, 0.6582, 0.6582, 0.6749, 0.7073, 0.7942, 0.9503, 0.6239, 0.7380 /
data ((cldnuctab( 7,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9590, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.9697, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8533, 0.8734, 0.9780, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8312, 0.8425, 0.8827, 0.9780, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8193, 0.8312, 0.8425, 0.8734, 0.9548, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.7942, 0.7942, 0.8070, 0.8312, 0.8915, 0.9219, 0.9629, 0.9999, 0.9999,  &
0.7380, 0.7380, 0.7380, 0.7528, 0.7809, 0.8533, 0.9803, 0.7380, 0.8827 /
data ((cldnuctab( 7,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.9344, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.9503, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8533, 0.8734, 0.9629, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8425, 0.8533, 0.8734, 0.9697, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8312, 0.8425, 0.8425, 0.8827, 0.9590, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.8193, 0.8193, 0.8312, 0.8425, 0.8827, 0.9454, 0.9933, 0.9999, 0.9999,  &
0.7809, 0.7809, 0.7942, 0.7942, 0.8193, 0.8734, 0.9780, 0.8425, 0.9727 /
data ((cldnuctab( 7,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.9076, 0.9941, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8734, 0.9219, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8734, 0.9401, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8533, 0.8636, 0.8734, 0.9503, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8425, 0.8533, 0.8533, 0.8827, 0.9503, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.8312, 0.8425, 0.8425, 0.8533, 0.8734, 0.9454, 0.9965, 0.9999, 0.9999,  &
0.8070, 0.8070, 0.8193, 0.8193, 0.8425, 0.8827, 0.9664, 0.9076, 0.9960 /
data ((cldnuctab( 7,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.8827, 0.9902, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8734, 0.8915, 0.9954, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8827, 0.9150, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8636, 0.8827, 0.9344, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8533, 0.8533, 0.8636, 0.8827, 0.9401, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.8425, 0.8533, 0.8533, 0.8636, 0.8734, 0.9401, 0.9954, 0.9999, 0.9999,  &
0.8312, 0.8312, 0.8312, 0.8425, 0.8533, 0.8827, 0.9454, 0.9401, 0.9993 /
data ((cldnuctab( 7,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.8827, 0.9860, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8827, 0.8915, 0.9924, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8734, 0.8827, 0.9076, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8734, 0.8827, 0.9219, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8636, 0.8734, 0.8827, 0.9284, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.8533, 0.8533, 0.8636, 0.8636, 0.8827, 0.9284, 0.9933, 0.9999, 0.9999,  &
0.8425, 0.8425, 0.8425, 0.8533, 0.8533, 0.8827, 0.9344, 0.9590, 0.9997 /
data ((cldnuctab( 7,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.8827, 0.9824, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8827, 0.8998, 0.9890, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8734, 0.8827, 0.9076, 0.9933, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8734, 0.8734, 0.8915, 0.9150, 0.9954, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8734, 0.8734, 0.8915, 0.9219, 0.9960, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8636, 0.8734, 0.8734, 0.8827, 0.9219, 0.9902, 0.9999, 0.9999,  &
0.8533, 0.8533, 0.8533, 0.8533, 0.8636, 0.8827, 0.9219, 0.9755, 0.9997 /
data ((cldnuctab( 7,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9727, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9803, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9076, 0.9284, 0.9803, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8998, 0.9076, 0.9219, 0.9755, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8734, 0.8734, 0.8915, 0.9284, 0.9876, 0.9843, 0.9999, 0.9999, 0.9999,  &
0.8070, 0.8193, 0.8193, 0.8425, 0.8915, 0.9755, 0.8533, 0.9454, 0.9999,  &
0.7229, 0.7229, 0.7229, 0.7380, 0.7528, 0.8070, 0.9076, 0.7073, 0.7809 /
data ((cldnuctab( 7,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9548, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9664, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9150, 0.9284, 0.9755, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9076, 0.9150, 0.9219, 0.9727, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8915, 0.8998, 0.9076, 0.9284, 0.9727, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.8636, 0.8636, 0.8734, 0.8827, 0.9219, 0.9824, 0.9401, 0.9977, 0.9999,  &
0.7942, 0.7942, 0.7942, 0.8070, 0.8193, 0.8636, 0.9548, 0.7942, 0.8636 /
data ((cldnuctab( 7,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9401, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9503, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9219, 0.9284, 0.9629, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9150, 0.9150, 0.9284, 0.9664, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9076, 0.9076, 0.9150, 0.9284, 0.9697, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.8915, 0.8915, 0.8915, 0.9076, 0.9284, 0.9755, 0.9780, 0.9999, 0.9999,  &
0.8425, 0.8425, 0.8425, 0.8533, 0.8636, 0.8998, 0.9664, 0.8734, 0.9454 /
data ((cldnuctab( 7,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.9401, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9344, 0.9454, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9344, 0.9548, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9219, 0.9219, 0.9344, 0.9590, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9150, 0.9150, 0.9219, 0.9284, 0.9629, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9076, 0.9076, 0.9076, 0.9150, 0.9284, 0.9664, 0.9876, 0.9999, 0.9999,  &
0.8734, 0.8734, 0.8734, 0.8827, 0.8915, 0.9150, 0.9664, 0.9629, 0.9803 /
data ((cldnuctab( 7,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.9401, 0.9948, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9344, 0.9454, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9344, 0.9503, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9219, 0.9284, 0.9344, 0.9548, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9219, 0.9219, 0.9284, 0.9344, 0.9590, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9150, 0.9150, 0.9150, 0.9219, 0.9344, 0.9590, 0.9924, 0.9999, 0.9999,  &
0.8915, 0.8915, 0.8915, 0.8915, 0.8998, 0.9219, 0.9590, 0.9890, 0.9933 /
data ((cldnuctab( 7,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.9401, 0.9914, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9401, 0.9454, 0.9948, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9344, 0.9401, 0.9503, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9344, 0.9401, 0.9548, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9284, 0.9344, 0.9401, 0.9548, 0.9960, 0.9999, 0.9999, 0.9999,  &
0.9219, 0.9219, 0.9219, 0.9284, 0.9344, 0.9548, 0.9933, 0.9999, 0.9999,  &
0.8998, 0.8998, 0.8998, 0.8998, 0.9076, 0.9219, 0.9548, 0.9924, 0.9965 /
data ((cldnuctab( 7,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.9454, 0.9890, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9401, 0.9503, 0.9924, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9401, 0.9401, 0.9548, 0.9941, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9344, 0.9344, 0.9401, 0.9548, 0.9948, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9344, 0.9344, 0.9344, 0.9401, 0.9548, 0.9933, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9284, 0.9284, 0.9344, 0.9401, 0.9548, 0.9914, 0.9999, 0.9999,  &
0.9076, 0.9076, 0.9076, 0.9076, 0.9150, 0.9284, 0.9548, 0.9914, 0.9970 /
data ((cldnuctab( 7,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9755, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9824, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9548, 0.9590, 0.9824, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9454, 0.9503, 0.9590, 0.9843, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9150, 0.9219, 0.9284, 0.9454, 0.9843, 0.9755, 0.9994, 0.9999, 0.9999,  &
0.8636, 0.8636, 0.8636, 0.8734, 0.9076, 0.9590, 0.9999, 0.9344, 0.9970,  &
0.7942, 0.7942, 0.7942, 0.7942, 0.8070, 0.8312, 0.8998, 0.9727, 0.8312 /
data ((cldnuctab( 7,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9727, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9780, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9590, 0.9629, 0.9803, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9548, 0.9548, 0.9629, 0.9803, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9401, 0.9401, 0.9454, 0.9590, 0.9843, 0.9933, 0.9999, 0.9999, 0.9999,  &
0.9076, 0.9076, 0.9076, 0.9150, 0.9401, 0.9780, 0.9876, 0.9876, 0.9999,  &
0.8425, 0.8425, 0.8425, 0.8425, 0.8533, 0.8827, 0.9401, 0.9980, 0.8915 /
data ((cldnuctab( 7,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9727, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9664, 0.9755, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9590, 0.9664, 0.9780, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9590, 0.9590, 0.9629, 0.9780, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9503, 0.9548, 0.9548, 0.9629, 0.9803, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.9284, 0.9344, 0.9344, 0.9401, 0.9548, 0.9803, 0.9965, 0.9990, 0.9999,  &
0.8827, 0.8827, 0.8827, 0.8915, 0.8998, 0.9150, 0.9590, 0.9994, 0.9401 /
data ((cldnuctab( 7,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9727, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9755, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9697, 0.9755, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9629, 0.9664, 0.9780, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9590, 0.9590, 0.9629, 0.9664, 0.9755, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9454, 0.9454, 0.9454, 0.9503, 0.9590, 0.9780, 0.9974, 0.9999, 0.9999,  &
0.9076, 0.9076, 0.9150, 0.9150, 0.9219, 0.9344, 0.9664, 0.9990, 0.9697 /
data ((cldnuctab( 7,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.9727, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9755, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9664, 0.9697, 0.9755, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9664, 0.9664, 0.9697, 0.9780, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9629, 0.9664, 0.9697, 0.9755, 0.9970, 0.9999, 0.9999, 0.9999,  &
0.9548, 0.9548, 0.9548, 0.9590, 0.9629, 0.9780, 0.9970, 0.9999, 0.9999,  &
0.9284, 0.9284, 0.9284, 0.9284, 0.9344, 0.9454, 0.9664, 0.9980, 0.9843 /
data ((cldnuctab( 7,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.9755, 0.9941, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9727, 0.9755, 0.9954, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9727, 0.9780, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9697, 0.9727, 0.9780, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9664, 0.9664, 0.9664, 0.9697, 0.9780, 0.9954, 0.9999, 0.9999, 0.9999,  &
0.9590, 0.9590, 0.9590, 0.9629, 0.9664, 0.9780, 0.9954, 0.9999, 0.9999,  &
0.9344, 0.9344, 0.9344, 0.9344, 0.9401, 0.9503, 0.9664, 0.9960, 0.9933 /
data ((cldnuctab( 7,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.9755, 0.9914, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9727, 0.9780, 0.9933, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9727, 0.9727, 0.9780, 0.9933, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9727, 0.9727, 0.9780, 0.9941, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9697, 0.9697, 0.9727, 0.9780, 0.9941, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9629, 0.9629, 0.9629, 0.9697, 0.9780, 0.9941, 0.9999, 0.9999,  &
0.9401, 0.9401, 0.9401, 0.9401, 0.9454, 0.9503, 0.9664, 0.9941, 0.9987 /
data ((cldnuctab( 7,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9890, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9824, 0.9890, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9780, 0.9824, 0.9890, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9727, 0.9780, 0.9902, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9454, 0.9454, 0.9503, 0.9629, 0.9824, 0.9998, 0.9954, 0.9999, 0.9999,  &
0.8998, 0.8998, 0.8998, 0.9076, 0.9219, 0.9548, 0.9970, 0.9503, 0.9914,  &
0.8533, 0.8533, 0.8533, 0.8636, 0.8636, 0.8827, 0.9150, 0.9629, 0.9890 /
data ((cldnuctab( 7,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9890, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9890, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9824, 0.9843, 0.9890, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9780, 0.9780, 0.9824, 0.9902, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9664, 0.9697, 0.9755, 0.9890, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.9344, 0.9344, 0.9344, 0.9401, 0.9503, 0.9755, 0.9993, 0.9824, 0.9998,  &
0.8915, 0.8915, 0.8915, 0.8915, 0.8998, 0.9076, 0.9401, 0.9876, 0.9344 /
data ((cldnuctab( 7,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9890, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9890, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9843, 0.9890, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9803, 0.9824, 0.9843, 0.9890, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9755, 0.9755, 0.9780, 0.9803, 0.9890, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9548, 0.9548, 0.9590, 0.9590, 0.9664, 0.9824, 0.9994, 0.9954, 0.9999,  &
0.9150, 0.9150, 0.9150, 0.9219, 0.9219, 0.9344, 0.9590, 0.9948, 0.9590 /
data ((cldnuctab( 7,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9890, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9890, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9860, 0.9890, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9843, 0.9860, 0.9890, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9803, 0.9803, 0.9824, 0.9843, 0.9890, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.9664, 0.9664, 0.9697, 0.9697, 0.9755, 0.9860, 0.9990, 0.9990, 0.9999,  &
0.9344, 0.9344, 0.9401, 0.9401, 0.9401, 0.9503, 0.9664, 0.9954, 0.9824 /
data ((cldnuctab( 7,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9890, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9902, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9876, 0.9902, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9860, 0.9876, 0.9902, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9824, 0.9824, 0.9843, 0.9860, 0.9902, 0.9977, 0.9999, 0.9999, 0.9999,  &
0.9727, 0.9727, 0.9755, 0.9755, 0.9803, 0.9860, 0.9983, 0.9998, 0.9999,  &
0.9503, 0.9503, 0.9503, 0.9503, 0.9548, 0.9590, 0.9727, 0.9948, 0.9996 /
data ((cldnuctab( 7,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9902, 0.9948, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9902, 0.9948, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9890, 0.9902, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9876, 0.9890, 0.9902, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9843, 0.9860, 0.9876, 0.9902, 0.9965, 0.9999, 0.9999, 0.9999,  &
0.9780, 0.9780, 0.9780, 0.9780, 0.9824, 0.9876, 0.9970, 0.9999, 0.9999,  &
0.9548, 0.9548, 0.9548, 0.9548, 0.9590, 0.9629, 0.9727, 0.9924, 0.9999 /
data ((cldnuctab( 7,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9902, 0.9933, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9914, 0.9948, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9914, 0.9954, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9890, 0.9890, 0.9902, 0.9960, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9860, 0.9876, 0.9876, 0.9902, 0.9960, 0.9999, 0.9999, 0.9999,  &
0.9803, 0.9803, 0.9803, 0.9803, 0.9824, 0.9876, 0.9960, 0.9999, 0.9999,  &
0.9590, 0.9590, 0.9590, 0.9590, 0.9629, 0.9664, 0.9755, 0.9914, 0.9999 /
data ((cldnuctab( 7,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9933, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9933, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9890, 0.9933, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9780, 0.9803, 0.9843, 0.9924, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9548, 0.9548, 0.9590, 0.9664, 0.9824, 0.9995, 0.9941, 0.9999, 0.9999,  &
0.9219, 0.9219, 0.9219, 0.9284, 0.9401, 0.9590, 0.9933, 0.9664, 0.9902,  &
0.8915, 0.8915, 0.8915, 0.8998, 0.8998, 0.9076, 0.9284, 0.9629, 0.9843 /
data ((cldnuctab( 7,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9933, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9933, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9902, 0.9933, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9860, 0.9890, 0.9933, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9727, 0.9727, 0.9755, 0.9803, 0.9902, 0.9996, 0.9996, 0.9999, 0.9999,  &
0.9454, 0.9454, 0.9503, 0.9503, 0.9590, 0.9755, 0.9977, 0.9843, 0.9993,  &
0.9150, 0.9150, 0.9150, 0.9150, 0.9219, 0.9284, 0.9503, 0.9843, 0.9998 /
data ((cldnuctab( 7,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9933, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9933, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9914, 0.9933, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9902, 0.9933, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9824, 0.9824, 0.9843, 0.9860, 0.9924, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9664, 0.9664, 0.9664, 0.9697, 0.9727, 0.9843, 0.9987, 0.9954, 0.9999,  &
0.9344, 0.9344, 0.9344, 0.9344, 0.9401, 0.9454, 0.9629, 0.9902, 0.9999 /
data ((cldnuctab( 7,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9941, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9941, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9924, 0.9941, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9914, 0.9924, 0.9941, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9876, 0.9876, 0.9902, 0.9933, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9755, 0.9755, 0.9755, 0.9780, 0.9803, 0.9876, 0.9985, 0.9996, 0.9999,  &
0.9503, 0.9503, 0.9503, 0.9503, 0.9548, 0.9590, 0.9697, 0.9924, 0.9999 /
data ((cldnuctab( 7,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9941, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9941, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9933, 0.9941, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9924, 0.9924, 0.9941, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9902, 0.9914, 0.9933, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.9803, 0.9803, 0.9803, 0.9824, 0.9843, 0.9890, 0.9980, 0.9999, 0.9999,  &
0.9590, 0.9590, 0.9590, 0.9590, 0.9629, 0.9664, 0.9755, 0.9924, 0.9999 /
data ((cldnuctab( 7,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9948, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9948, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9948, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9933, 0.9933, 0.9941, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9902, 0.9914, 0.9924, 0.9941, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9843, 0.9843, 0.9843, 0.9860, 0.9902, 0.9974, 0.9999, 0.9999,  &
0.9629, 0.9629, 0.9629, 0.9664, 0.9664, 0.9697, 0.9780, 0.9914, 0.9999 /
data ((cldnuctab( 7,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9948, 0.9965, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9948, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9948, 0.9970, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9941, 0.9948, 0.9974, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9924, 0.9924, 0.9941, 0.9974, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9860, 0.9860, 0.9860, 0.9876, 0.9914, 0.9965, 0.9999, 0.9999,  &
0.9664, 0.9664, 0.9664, 0.9664, 0.9697, 0.9727, 0.9780, 0.9902, 0.9999 /
data ((cldnuctab( 7,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9954, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9948, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9924, 0.9954, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9824, 0.9843, 0.9860, 0.9933, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9629, 0.9629, 0.9664, 0.9727, 0.9843, 0.9989, 0.9941, 0.9999, 0.9999,  &
0.9344, 0.9344, 0.9401, 0.9401, 0.9454, 0.9629, 0.9902, 0.9999, 0.9914,  &
0.9150, 0.9150, 0.9150, 0.9150, 0.9219, 0.9284, 0.9454, 0.9664, 0.9843 /
data ((cldnuctab( 7,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9954, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9954, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9933, 0.9954, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9902, 0.9914, 0.9948, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9780, 0.9780, 0.9803, 0.9843, 0.9914, 0.9995, 0.9994, 0.9999, 0.9999,  &
0.9548, 0.9548, 0.9548, 0.9590, 0.9629, 0.9780, 0.9960, 0.9999, 0.9987,  &
0.9284, 0.9284, 0.9284, 0.9284, 0.9344, 0.9401, 0.9548, 0.9824, 0.9992 /
data ((cldnuctab( 7,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9960, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9954, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9954, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9924, 0.9933, 0.9954, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9860, 0.9876, 0.9890, 0.9941, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9697, 0.9697, 0.9727, 0.9727, 0.9780, 0.9860, 0.9980, 0.9999, 0.9999,  &
0.9454, 0.9454, 0.9454, 0.9454, 0.9503, 0.9548, 0.9664, 0.9890, 0.9999 /
data ((cldnuctab( 7,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9960, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9960, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9954, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9941, 0.9948, 0.9960, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9902, 0.9914, 0.9924, 0.9948, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9803, 0.9803, 0.9803, 0.9803, 0.9843, 0.9890, 0.9980, 0.9999, 0.9999,  &
0.9590, 0.9590, 0.9590, 0.9590, 0.9590, 0.9629, 0.9727, 0.9914, 0.9999 /
data ((cldnuctab( 7,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9965, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9965, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9954, 0.9960, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9954, 0.9960, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9924, 0.9924, 0.9933, 0.9954, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9843, 0.9843, 0.9860, 0.9876, 0.9914, 0.9977, 0.9999, 0.9999,  &
0.9664, 0.9664, 0.9664, 0.9664, 0.9664, 0.9697, 0.9780, 0.9914, 0.9999 /
data ((cldnuctab( 7,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9965, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9965, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9960, 0.9965, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9954, 0.9954, 0.9965, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9933, 0.9933, 0.9941, 0.9954, 0.9983, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9860, 0.9876, 0.9876, 0.9890, 0.9924, 0.9974, 0.9999, 0.9999,  &
0.9697, 0.9697, 0.9697, 0.9697, 0.9727, 0.9727, 0.9803, 0.9902, 0.9999 /
data ((cldnuctab( 7,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9970, 0.9977, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9970, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9965, 0.9965, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9960, 0.9960, 0.9965, 0.9980, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9941, 0.9948, 0.9960, 0.9980, 0.9999, 0.9999, 0.9999,  &
0.9876, 0.9876, 0.9890, 0.9890, 0.9902, 0.9924, 0.9970, 0.9999, 0.9999,  &
0.9727, 0.9727, 0.9727, 0.9727, 0.9727, 0.9755, 0.9803, 0.9902, 0.9998 /
data ((cldnuctab( 7,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9965, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9965, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9941, 0.9965, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9843, 0.9860, 0.9890, 0.9941, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9664, 0.9697, 0.9697, 0.9755, 0.9843, 0.9983, 0.9954, 0.9999, 0.9999,  &
0.9454, 0.9454, 0.9454, 0.9503, 0.9548, 0.9664, 0.9902, 0.9999, 0.9941,  &
0.9344, 0.9344, 0.9344, 0.9344, 0.9344, 0.9401, 0.9503, 0.9727, 0.9843 /
data ((cldnuctab( 7,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9970, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9965, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9954, 0.9965, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9914, 0.9914, 0.9933, 0.9960, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9803, 0.9824, 0.9824, 0.9860, 0.9914, 0.9992, 0.9995, 0.9999, 0.9999,  &
0.9629, 0.9629, 0.9629, 0.9629, 0.9697, 0.9780, 0.9948, 0.9999, 0.9983,  &
0.9401, 0.9401, 0.9401, 0.9454, 0.9454, 0.9503, 0.9629, 0.9824, 0.9985 /
data ((cldnuctab( 7,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9970, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9970, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9960, 0.9970, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9941, 0.9941, 0.9948, 0.9965, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9914, 0.9948, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9755, 0.9755, 0.9755, 0.9755, 0.9803, 0.9860, 0.9974, 0.9999, 0.9999,  &
0.9548, 0.9548, 0.9548, 0.9548, 0.9548, 0.9590, 0.9697, 0.9876, 0.9999 /
data ((cldnuctab( 7,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9974, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9970, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9965, 0.9970, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9954, 0.9960, 0.9970, 0.9989, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9924, 0.9924, 0.9924, 0.9933, 0.9954, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9824, 0.9824, 0.9824, 0.9843, 0.9860, 0.9902, 0.9977, 0.9999, 0.9999,  &
0.9629, 0.9629, 0.9629, 0.9629, 0.9664, 0.9697, 0.9755, 0.9902, 0.9999 /
data ((cldnuctab( 7,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9974, 0.9983, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9974, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9970, 0.9974, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9960, 0.9960, 0.9965, 0.9974, 0.9987, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9933, 0.9941, 0.9941, 0.9948, 0.9965, 0.9987, 0.9999, 0.9999, 0.9999,  &
0.9860, 0.9860, 0.9876, 0.9876, 0.9890, 0.9924, 0.9974, 0.9999, 0.9999,  &
0.9697, 0.9697, 0.9697, 0.9697, 0.9727, 0.9727, 0.9803, 0.9902, 0.9999 /
data ((cldnuctab( 7,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9977, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9977, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9974, 0.9974, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9965, 0.9965, 0.9970, 0.9974, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9948, 0.9948, 0.9948, 0.9954, 0.9965, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.9890, 0.9890, 0.9890, 0.9890, 0.9902, 0.9933, 0.9974, 0.9999, 0.9999,  &
0.9727, 0.9727, 0.9727, 0.9727, 0.9755, 0.9780, 0.9803, 0.9902, 0.9998 /
data ((cldnuctab( 7,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9977, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9977, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9974, 0.9974, 0.9977, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9970, 0.9970, 0.9970, 0.9977, 0.9985, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9954, 0.9954, 0.9954, 0.9960, 0.9970, 0.9985, 0.9999, 0.9999, 0.9999,  &
0.9902, 0.9902, 0.9902, 0.9902, 0.9914, 0.9933, 0.9970, 0.9999, 0.9999,  &
0.9755, 0.9755, 0.9755, 0.9755, 0.9780, 0.9780, 0.9824, 0.9902, 0.9996 /
data ((cldnuctab( 8,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9717, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9795, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9196, 0.9382, 0.9795, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9125, 0.9196, 0.9382, 0.9772, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.8885, 0.8885, 0.9049, 0.9324, 0.9870, 0.9817, 0.9999, 0.9999, 0.9999,  &
0.8271, 0.8271, 0.8386, 0.8601, 0.8970, 0.9746, 0.8601, 0.9486, 0.9998,  &
0.7477, 0.7477, 0.7477, 0.7622, 0.7761, 0.8151, 0.9049, 0.7477, 0.8026 /
data ((cldnuctab( 8,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9533, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9686, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9262, 0.9382, 0.9746, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9196, 0.9262, 0.9382, 0.9746, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9125, 0.9125, 0.9196, 0.9382, 0.9772, 0.9976, 0.9999, 0.9999, 0.9999,  &
0.8795, 0.8795, 0.8885, 0.8970, 0.9262, 0.9817, 0.9382, 0.9968, 0.9999,  &
0.8151, 0.8151, 0.8151, 0.8151, 0.8386, 0.8700, 0.9533, 0.8151, 0.8795 /
data ((cldnuctab( 8,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.9486, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9436, 0.9576, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9324, 0.9436, 0.9686, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9262, 0.9324, 0.9382, 0.9717, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9196, 0.9262, 0.9262, 0.9382, 0.9717, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9049, 0.9049, 0.9049, 0.9196, 0.9382, 0.9772, 0.9772, 0.9999, 0.9999,  &
0.8601, 0.8601, 0.8601, 0.8601, 0.8795, 0.9049, 0.9652, 0.9049, 0.9436 /
data ((cldnuctab( 8,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.9486, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9436, 0.9576, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9436, 0.9616, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9324, 0.9324, 0.9436, 0.9652, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9324, 0.9324, 0.9324, 0.9436, 0.9652, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.9196, 0.9196, 0.9196, 0.9262, 0.9382, 0.9686, 0.9885, 0.9999, 0.9999,  &
0.8885, 0.8885, 0.8885, 0.8885, 0.8970, 0.9196, 0.9652, 0.9817, 0.9772 /
data ((cldnuctab( 8,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.9486, 0.9952, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9486, 0.9576, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9436, 0.9486, 0.9616, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9382, 0.9486, 0.9616, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9382, 0.9382, 0.9436, 0.9616, 0.9976, 0.9999, 0.9999, 0.9999,  &
0.9262, 0.9262, 0.9324, 0.9324, 0.9436, 0.9652, 0.9938, 0.9999, 0.9999,  &
0.9049, 0.9049, 0.9049, 0.9049, 0.9125, 0.9262, 0.9616, 0.9938, 0.9910 /
data ((cldnuctab( 8,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.9533, 0.9930, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9486, 0.9576, 0.9952, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9436, 0.9486, 0.9616, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9436, 0.9436, 0.9486, 0.9616, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9436, 0.9436, 0.9486, 0.9616, 0.9958, 0.9999, 0.9999, 0.9999,  &
0.9324, 0.9324, 0.9382, 0.9382, 0.9486, 0.9616, 0.9938, 0.9999, 0.9999,  &
0.9125, 0.9125, 0.9125, 0.9125, 0.9196, 0.9324, 0.9576, 0.9946, 0.9952 /
data ((cldnuctab( 8,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.9533, 0.9898, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9533, 0.9576, 0.9930, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9486, 0.9533, 0.9616, 0.9946, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9486, 0.9486, 0.9533, 0.9616, 0.9946, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9436, 0.9436, 0.9486, 0.9486, 0.9616, 0.9938, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9382, 0.9382, 0.9436, 0.9486, 0.9616, 0.9920, 0.9999, 0.9999,  &
0.9196, 0.9196, 0.9196, 0.9196, 0.9262, 0.9382, 0.9576, 0.9930, 0.9968 /
data ((cldnuctab( 8,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9795, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9686, 0.9837, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9616, 0.9686, 0.9837, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9533, 0.9576, 0.9652, 0.9870, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9262, 0.9262, 0.9324, 0.9533, 0.9854, 0.9795, 0.9990, 0.9999, 0.9999,  &
0.8700, 0.8700, 0.8795, 0.8885, 0.9125, 0.9576, 0.9997, 0.9382, 0.9958,  &
0.8151, 0.8151, 0.8151, 0.8151, 0.8271, 0.8496, 0.9049, 0.9717, 0.8601 /
data ((cldnuctab( 8,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9795, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9817, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9652, 0.9686, 0.9817, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9616, 0.9616, 0.9686, 0.9817, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9486, 0.9486, 0.9533, 0.9652, 0.9854, 0.9946, 0.9999, 0.9999, 0.9999,  &
0.9125, 0.9125, 0.9196, 0.9262, 0.9436, 0.9772, 0.9999, 0.9870, 0.9999,  &
0.8601, 0.8601, 0.8601, 0.8601, 0.8700, 0.8885, 0.9382, 0.9963, 0.8970 /
data ((cldnuctab( 8,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9772, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9795, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9686, 0.9717, 0.9817, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9652, 0.9686, 0.9717, 0.9817, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9576, 0.9616, 0.9616, 0.9686, 0.9837, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.9382, 0.9382, 0.9436, 0.9486, 0.9576, 0.9817, 0.9990, 0.9988, 0.9999,  &
0.8970, 0.8970, 0.8970, 0.8970, 0.9049, 0.9196, 0.9576, 0.9990, 0.9436 /
data ((cldnuctab( 8,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.9772, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9746, 0.9795, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9746, 0.9817, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9686, 0.9717, 0.9717, 0.9817, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9652, 0.9652, 0.9686, 0.9717, 0.9817, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.9533, 0.9533, 0.9533, 0.9576, 0.9652, 0.9817, 0.9984, 0.9998, 0.9999,  &
0.9196, 0.9196, 0.9196, 0.9196, 0.9262, 0.9382, 0.9652, 0.9986, 0.9717 /
data ((cldnuctab( 8,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.9795, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9772, 0.9795, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9746, 0.9746, 0.9817, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9717, 0.9746, 0.9817, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9686, 0.9686, 0.9717, 0.9746, 0.9795, 0.9972, 0.9999, 0.9999, 0.9999,  &
0.9616, 0.9616, 0.9616, 0.9652, 0.9686, 0.9795, 0.9976, 0.9999, 0.9999,  &
0.9324, 0.9324, 0.9324, 0.9382, 0.9382, 0.9486, 0.9686, 0.9976, 0.9854 /
data ((cldnuctab( 8,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.9795, 0.9946, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9772, 0.9817, 0.9952, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9746, 0.9772, 0.9817, 0.9958, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9746, 0.9746, 0.9772, 0.9817, 0.9958, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9717, 0.9746, 0.9772, 0.9817, 0.9958, 0.9999, 0.9999, 0.9999,  &
0.9652, 0.9652, 0.9652, 0.9686, 0.9717, 0.9795, 0.9963, 0.9999, 0.9999,  &
0.9436, 0.9436, 0.9436, 0.9436, 0.9486, 0.9533, 0.9686, 0.9952, 0.9946 /
data ((cldnuctab( 8,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.9817, 0.9920, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9795, 0.9817, 0.9930, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9772, 0.9795, 0.9817, 0.9938, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9772, 0.9772, 0.9772, 0.9817, 0.9946, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9746, 0.9746, 0.9746, 0.9772, 0.9817, 0.9946, 0.9999, 0.9999, 0.9999,  &
0.9686, 0.9686, 0.9686, 0.9686, 0.9746, 0.9817, 0.9946, 0.9999, 0.9999,  &
0.9486, 0.9486, 0.9486, 0.9486, 0.9486, 0.9576, 0.9686, 0.9930, 0.9996 /
data ((cldnuctab( 8,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9910, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9854, 0.9910, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9817, 0.9854, 0.9910, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9746, 0.9817, 0.9910, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9486, 0.9533, 0.9533, 0.9652, 0.9837, 0.9997, 0.9952, 0.9999, 0.9999,  &
0.9125, 0.9125, 0.9125, 0.9196, 0.9324, 0.9576, 0.9958, 0.9533, 0.9910,  &
0.8795, 0.8795, 0.8795, 0.8795, 0.8795, 0.8970, 0.9262, 0.9652, 0.9870 /
data ((cldnuctab( 8,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9910, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9870, 0.9910, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9854, 0.9870, 0.9898, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9817, 0.9817, 0.9854, 0.9920, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9686, 0.9686, 0.9717, 0.9772, 0.9898, 0.9997, 0.9998, 0.9999, 0.9999,  &
0.9382, 0.9382, 0.9436, 0.9436, 0.9533, 0.9746, 0.9988, 0.9817, 0.9997,  &
0.8970, 0.8970, 0.8970, 0.9049, 0.9049, 0.9196, 0.9436, 0.9870, 0.9999 /
data ((cldnuctab( 8,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9910, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9910, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9870, 0.9885, 0.9910, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9854, 0.9854, 0.9870, 0.9910, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9795, 0.9795, 0.9795, 0.9837, 0.9910, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9616, 0.9616, 0.9616, 0.9652, 0.9717, 0.9837, 0.9992, 0.9952, 0.9999,  &
0.9262, 0.9262, 0.9262, 0.9262, 0.9324, 0.9382, 0.9616, 0.9930, 0.9686 /
data ((cldnuctab( 8,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9910, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9898, 0.9920, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9920, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9870, 0.9870, 0.9885, 0.9910, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9837, 0.9837, 0.9854, 0.9870, 0.9910, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9717, 0.9717, 0.9746, 0.9772, 0.9870, 0.9988, 0.9990, 0.9999,  &
0.9436, 0.9436, 0.9436, 0.9436, 0.9486, 0.9533, 0.9686, 0.9946, 0.9979 /
data ((cldnuctab( 8,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.9920, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9920, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9898, 0.9898, 0.9920, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9898, 0.9920, 0.9976, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9854, 0.9854, 0.9870, 0.9885, 0.9920, 0.9979, 0.9999, 0.9999, 0.9999,  &
0.9772, 0.9772, 0.9772, 0.9795, 0.9817, 0.9885, 0.9982, 0.9998, 0.9999,  &
0.9533, 0.9533, 0.9533, 0.9533, 0.9576, 0.9616, 0.9746, 0.9938, 0.9999 /
data ((cldnuctab( 8,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.9920, 0.9946, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9920, 0.9958, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9920, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9898, 0.9898, 0.9910, 0.9920, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9870, 0.9870, 0.9885, 0.9898, 0.9920, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.9795, 0.9795, 0.9817, 0.9817, 0.9837, 0.9885, 0.9972, 0.9999, 0.9999,  &
0.9616, 0.9616, 0.9616, 0.9616, 0.9616, 0.9652, 0.9746, 0.9920, 0.9999 /
data ((cldnuctab( 8,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.9930, 0.9952, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9920, 0.9930, 0.9958, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9920, 0.9930, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9920, 0.9930, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9898, 0.9910, 0.9920, 0.9963, 0.9999, 0.9999, 0.9999,  &
0.9817, 0.9817, 0.9817, 0.9837, 0.9854, 0.9898, 0.9963, 0.9999, 0.9999,  &
0.9616, 0.9652, 0.9652, 0.9652, 0.9652, 0.9686, 0.9772, 0.9910, 0.9999 /
data ((cldnuctab( 8,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9963, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9946, 0.9958, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9920, 0.9930, 0.9963, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9837, 0.9854, 0.9885, 0.9938, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9686, 0.9686, 0.9686, 0.9746, 0.9837, 0.9984, 0.9946, 0.9999, 0.9999,  &
0.9436, 0.9436, 0.9436, 0.9486, 0.9533, 0.9686, 0.9898, 0.9999, 0.9930,  &
0.9262, 0.9324, 0.9324, 0.9324, 0.9324, 0.9382, 0.9486, 0.9717, 0.9854 /
data ((cldnuctab( 8,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9963, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9958, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9938, 0.9946, 0.9963, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9930, 0.9958, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9795, 0.9817, 0.9817, 0.9854, 0.9910, 0.9992, 0.9992, 0.9999, 0.9999,  &
0.9616, 0.9616, 0.9616, 0.9652, 0.9686, 0.9795, 0.9952, 0.9999, 0.9984,  &
0.9382, 0.9382, 0.9382, 0.9436, 0.9436, 0.9486, 0.9616, 0.9837, 0.9988 /
data ((cldnuctab( 8,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9968, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9968, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9958, 0.9963, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9938, 0.9938, 0.9946, 0.9963, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9885, 0.9910, 0.9946, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9746, 0.9746, 0.9746, 0.9772, 0.9795, 0.9854, 0.9972, 0.9999, 0.9999,  &
0.9533, 0.9533, 0.9533, 0.9533, 0.9533, 0.9576, 0.9686, 0.9885, 0.9999 /
data ((cldnuctab( 8,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9968, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9968, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9963, 0.9968, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9946, 0.9952, 0.9958, 0.9968, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9920, 0.9920, 0.9920, 0.9930, 0.9958, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9817, 0.9817, 0.9817, 0.9837, 0.9854, 0.9898, 0.9979, 0.9999, 0.9999,  &
0.9616, 0.9616, 0.9616, 0.9616, 0.9652, 0.9686, 0.9746, 0.9910, 0.9999 /
data ((cldnuctab( 8,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9972, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9972, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9968, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9958, 0.9963, 0.9968, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9930, 0.9938, 0.9938, 0.9946, 0.9963, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.9854, 0.9854, 0.9870, 0.9870, 0.9885, 0.9920, 0.9976, 0.9999, 0.9999,  &
0.9686, 0.9686, 0.9686, 0.9686, 0.9717, 0.9746, 0.9795, 0.9910, 0.9999 /
data ((cldnuctab( 8,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9972, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9972, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9972, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9968, 0.9972, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9946, 0.9946, 0.9946, 0.9952, 0.9963, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9885, 0.9885, 0.9898, 0.9930, 0.9972, 0.9999, 0.9999,  &
0.9717, 0.9717, 0.9746, 0.9746, 0.9746, 0.9772, 0.9817, 0.9910, 0.9999 /
data ((cldnuctab( 8,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9976, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9976, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9976, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9976, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9952, 0.9958, 0.9968, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.9898, 0.9898, 0.9898, 0.9898, 0.9910, 0.9930, 0.9972, 0.9999, 0.9999,  &
0.9746, 0.9746, 0.9746, 0.9746, 0.9772, 0.9772, 0.9817, 0.9898, 0.9997 /
data ((cldnuctab( 8,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9976, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9979, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9946, 0.9958, 0.9976, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9910, 0.9946, 0.9995, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.9746, 0.9746, 0.9772, 0.9795, 0.9870, 0.9972, 0.9999, 0.9997, 0.9999,  &
0.9616, 0.9616, 0.9616, 0.9616, 0.9652, 0.9746, 0.9898, 0.9996, 0.9999,  &
0.9533, 0.9533, 0.9533, 0.9533, 0.9533, 0.9576, 0.9652, 0.9772, 0.9870 /
data ((cldnuctab( 8,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9982, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9976, 0.9979, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9968, 0.9979, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9938, 0.9938, 0.9952, 0.9968, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9854, 0.9854, 0.9870, 0.9885, 0.9920, 0.9988, 0.9999, 0.9999, 0.9999,  &
0.9717, 0.9717, 0.9717, 0.9717, 0.9746, 0.9817, 0.9938, 0.9999, 0.9982,  &
0.9576, 0.9576, 0.9576, 0.9576, 0.9616, 0.9652, 0.9717, 0.9854, 0.9976 /
data ((cldnuctab( 8,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9982, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9982, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9976, 0.9982, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9963, 0.9968, 0.9976, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9920, 0.9930, 0.9952, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9795, 0.9795, 0.9817, 0.9817, 0.9837, 0.9885, 0.9963, 0.9999, 0.9997,  &
0.9652, 0.9652, 0.9652, 0.9652, 0.9686, 0.9686, 0.9772, 0.9885, 0.9997 /
data ((cldnuctab( 8,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9984, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9982, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9972, 0.9976, 0.9982, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9938, 0.9946, 0.9946, 0.9952, 0.9968, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9870, 0.9870, 0.9870, 0.9870, 0.9885, 0.9920, 0.9972, 0.9999, 0.9999,  &
0.9717, 0.9717, 0.9717, 0.9717, 0.9746, 0.9746, 0.9795, 0.9898, 0.9998 /
data ((cldnuctab( 8,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9986, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9982, 0.9984, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9976, 0.9976, 0.9979, 0.9984, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9958, 0.9958, 0.9963, 0.9972, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9898, 0.9898, 0.9898, 0.9898, 0.9910, 0.9930, 0.9972, 0.9999, 0.9999,  &
0.9772, 0.9772, 0.9772, 0.9772, 0.9772, 0.9795, 0.9837, 0.9910, 0.9997 /
data ((cldnuctab( 8,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9986, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9986, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9984, 0.9986, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9982, 0.9984, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9968, 0.9976, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9910, 0.9920, 0.9920, 0.9938, 0.9972, 0.9999, 0.9999,  &
0.9795, 0.9795, 0.9795, 0.9795, 0.9795, 0.9817, 0.9854, 0.9910, 0.9995 /
data ((cldnuctab( 8,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9988, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9988, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9986, 0.9986, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9982, 0.9984, 0.9986, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9972, 0.9979, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9920, 0.9920, 0.9920, 0.9930, 0.9930, 0.9946, 0.9972, 0.9999, 0.9999,  &
0.9817, 0.9817, 0.9817, 0.9817, 0.9817, 0.9837, 0.9854, 0.9910, 0.9990 /
data ((cldnuctab( 8,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9986, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9986, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9968, 0.9979, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9920, 0.9952, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9795, 0.9817, 0.9817, 0.9837, 0.9885, 0.9968, 0.9999, 0.9996, 0.9999,  &
0.9717, 0.9717, 0.9717, 0.9717, 0.9746, 0.9795, 0.9910, 0.9992, 0.9999,  &
0.9652, 0.9652, 0.9652, 0.9652, 0.9686, 0.9686, 0.9746, 0.9817, 0.9885 /
data ((cldnuctab( 8,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9986, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9986, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9976, 0.9979, 0.9986, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9958, 0.9976, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9885, 0.9898, 0.9930, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.9772, 0.9772, 0.9772, 0.9795, 0.9817, 0.9854, 0.9938, 0.9999, 0.9990,  &
0.9686, 0.9686, 0.9686, 0.9686, 0.9717, 0.9717, 0.9772, 0.9870, 0.9972 /
data ((cldnuctab( 8,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9990, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9988, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9988, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9972, 0.9976, 0.9984, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9930, 0.9930, 0.9938, 0.9946, 0.9963, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9837, 0.9837, 0.9837, 0.9854, 0.9870, 0.9898, 0.9958, 0.9999, 0.9997,  &
0.9746, 0.9746, 0.9746, 0.9746, 0.9746, 0.9772, 0.9817, 0.9898, 0.9993 /
data ((cldnuctab( 8,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9990, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9986, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9982, 0.9986, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9958, 0.9958, 0.9963, 0.9972, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9885, 0.9885, 0.9885, 0.9898, 0.9910, 0.9930, 0.9972, 0.9999, 0.9999,  &
0.9795, 0.9795, 0.9795, 0.9795, 0.9795, 0.9817, 0.9837, 0.9910, 0.9996 /
data ((cldnuctab( 8,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9991, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9991, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9984, 0.9986, 0.9988, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9972, 0.9979, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9920, 0.9920, 0.9930, 0.9946, 0.9972, 0.9999, 0.9999,  &
0.9817, 0.9817, 0.9817, 0.9817, 0.9817, 0.9837, 0.9854, 0.9920, 0.9994 /
data ((cldnuctab( 8,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9992, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9991, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9991, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9986, 0.9988, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9972, 0.9976, 0.9982, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9930, 0.9930, 0.9930, 0.9930, 0.9938, 0.9952, 0.9976, 0.9999, 0.9999,  &
0.9837, 0.9837, 0.9837, 0.9837, 0.9837, 0.9854, 0.9870, 0.9920, 0.9990 /
data ((cldnuctab( 8,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9992, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9992, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9991, 0.9992, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9988, 0.9988, 0.9991, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9976, 0.9976, 0.9976, 0.9979, 0.9984, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9938, 0.9938, 0.9938, 0.9938, 0.9946, 0.9952, 0.9976, 0.9998, 0.9999,  &
0.9854, 0.9854, 0.9854, 0.9854, 0.9854, 0.9854, 0.9885, 0.9920, 0.9984 /
data ((cldnuctab( 8,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9990, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9990, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9972, 0.9984, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9920, 0.9920, 0.9938, 0.9958, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9837, 0.9837, 0.9854, 0.9870, 0.9898, 0.9963, 0.9999, 0.9995, 0.9999,  &
0.9772, 0.9772, 0.9772, 0.9772, 0.9795, 0.9837, 0.9920, 0.9990, 0.9999,  &
0.9717, 0.9717, 0.9746, 0.9746, 0.9746, 0.9772, 0.9795, 0.9854, 0.9910 /
data ((cldnuctab( 8,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9991, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9991, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9990, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9963, 0.9968, 0.9979, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9898, 0.9898, 0.9910, 0.9920, 0.9938, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.9817, 0.9817, 0.9817, 0.9837, 0.9837, 0.9870, 0.9946, 0.9999, 0.9999,  &
0.9772, 0.9772, 0.9772, 0.9772, 0.9772, 0.9795, 0.9817, 0.9898, 0.9968 /
data ((cldnuctab( 8,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9992, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9992, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9991, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9976, 0.9976, 0.9979, 0.9986, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9938, 0.9946, 0.9946, 0.9952, 0.9963, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9870, 0.9870, 0.9870, 0.9870, 0.9885, 0.9910, 0.9963, 0.9999, 0.9997,  &
0.9795, 0.9795, 0.9795, 0.9795, 0.9795, 0.9817, 0.9854, 0.9910, 0.9990 /
data ((cldnuctab( 8,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9993, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9992, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9991, 0.9992, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9984, 0.9986, 0.9990, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9968, 0.9976, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9910, 0.9910, 0.9910, 0.9910, 0.9920, 0.9938, 0.9972, 0.9999, 0.9999,  &
0.9817, 0.9817, 0.9837, 0.9837, 0.9837, 0.9837, 0.9870, 0.9920, 0.9992 /
data ((cldnuctab( 8,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9993, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9993, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9992, 0.9993, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9990, 0.9991, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9972, 0.9976, 0.9982, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9930, 0.9930, 0.9930, 0.9930, 0.9938, 0.9952, 0.9976, 0.9999, 0.9999,  &
0.9854, 0.9854, 0.9854, 0.9854, 0.9854, 0.9870, 0.9885, 0.9930, 0.9991 /
data ((cldnuctab( 8,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9994, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9993, 0.9994, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9991, 0.9992, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9976, 0.9979, 0.9979, 0.9979, 0.9984, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9938, 0.9938, 0.9938, 0.9938, 0.9946, 0.9958, 0.9976, 0.9998, 0.9999,  &
0.9870, 0.9870, 0.9870, 0.9870, 0.9870, 0.9870, 0.9898, 0.9930, 0.9986 /
data ((cldnuctab( 8,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9995, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9995, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9993, 0.9994, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9991, 0.9991, 0.9993, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9982, 0.9982, 0.9986, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9946, 0.9946, 0.9946, 0.9946, 0.9952, 0.9958, 0.9976, 0.9997, 0.9999,  &
0.9870, 0.9870, 0.9870, 0.9870, 0.9870, 0.9885, 0.9898, 0.9930, 0.9982 /
data ((cldnuctab( 9,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
0.9897, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9835, 0.9897, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9793, 0.9835, 0.9897, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9714, 0.9714, 0.9793, 0.9909, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9481, 0.9481, 0.9528, 0.9612, 0.9835, 0.9999, 0.9968, 0.9999, 0.9999,  &
0.9041, 0.9117, 0.9117, 0.9189, 0.9318, 0.9612, 0.9979, 0.9528, 0.9929,  &
0.8690, 0.8690, 0.8690, 0.8786, 0.8786, 0.8961, 0.9255, 0.9683, 0.9909 /
data ((cldnuctab( 9,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
0.9884, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9853, 0.9897, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9815, 0.9835, 0.9897, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9769, 0.9793, 0.9835, 0.9897, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9649, 0.9683, 0.9683, 0.9769, 0.9884, 0.9998, 0.9999, 0.9999, 0.9999,  &
0.9376, 0.9376, 0.9376, 0.9431, 0.9528, 0.9769, 0.9995, 0.9835, 0.9999,  &
0.8961, 0.8961, 0.8961, 0.8961, 0.9041, 0.9189, 0.9431, 0.9909, 0.9318 /
data ((cldnuctab( 9,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
0.9884, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9897, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9835, 0.9853, 0.9897, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9815, 0.9835, 0.9853, 0.9897, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9743, 0.9769, 0.9769, 0.9815, 0.9897, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9572, 0.9572, 0.9572, 0.9612, 0.9683, 0.9835, 0.9995, 0.9968, 0.9999,  &
0.9189, 0.9255, 0.9255, 0.9255, 0.9255, 0.9376, 0.9612, 0.9958, 0.9572 /
data ((cldnuctab( 9,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
0.9897, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9897, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9853, 0.9869, 0.9897, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9835, 0.9853, 0.9869, 0.9897, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9815, 0.9815, 0.9815, 0.9853, 0.9897, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.9683, 0.9683, 0.9683, 0.9714, 0.9769, 0.9869, 0.9991, 0.9993, 0.9999,  &
0.9431, 0.9431, 0.9431, 0.9431, 0.9431, 0.9528, 0.9683, 0.9963, 0.9769 /
data ((cldnuctab( 9,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
0.9897, 0.9968, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9884, 0.9897, 0.9972, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9884, 0.9897, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9853, 0.9869, 0.9869, 0.9897, 0.9975, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9835, 0.9835, 0.9853, 0.9869, 0.9897, 0.9976, 0.9999, 0.9999, 0.9999,  &
0.9743, 0.9743, 0.9743, 0.9769, 0.9793, 0.9869, 0.9982, 0.9997, 0.9999,  &
0.9528, 0.9528, 0.9528, 0.9528, 0.9528, 0.9612, 0.9743, 0.9952, 0.9958 /
data ((cldnuctab( 9,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
0.9909, 0.9945, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9897, 0.9909, 0.9952, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9884, 0.9884, 0.9909, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9884, 0.9884, 0.9909, 0.9963, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9853, 0.9853, 0.9853, 0.9869, 0.9909, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.9769, 0.9769, 0.9793, 0.9793, 0.9815, 0.9869, 0.9972, 0.9999, 0.9999,  &
0.9572, 0.9572, 0.9572, 0.9572, 0.9612, 0.9649, 0.9743, 0.9929, 0.9999 /
data ((cldnuctab( 9,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
0.9909, 0.9937, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9897, 0.9909, 0.9952, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9897, 0.9897, 0.9909, 0.9958, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9884, 0.9884, 0.9897, 0.9909, 0.9958, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9869, 0.9869, 0.9884, 0.9909, 0.9958, 0.9999, 0.9999, 0.9999,  &
0.9793, 0.9793, 0.9793, 0.9815, 0.9835, 0.9884, 0.9963, 0.9999, 0.9999,  &
0.9612, 0.9612, 0.9612, 0.9612, 0.9649, 0.9683, 0.9743, 0.9919, 0.9999 /
data ((cldnuctab( 9,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
0.9952, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9929, 0.9952, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9909, 0.9919, 0.9952, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9815, 0.9835, 0.9869, 0.9937, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9649, 0.9649, 0.9683, 0.9714, 0.9835, 0.9990, 0.9937, 0.9999, 0.9999,  &
0.9376, 0.9376, 0.9431, 0.9431, 0.9528, 0.9649, 0.9919, 0.9999, 0.9909,  &
0.9255, 0.9255, 0.9255, 0.9255, 0.9255, 0.9318, 0.9481, 0.9714, 0.9853 /
data ((cldnuctab( 9,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
0.9958, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9937, 0.9958, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9929, 0.9937, 0.9952, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9897, 0.9897, 0.9919, 0.9952, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9793, 0.9793, 0.9815, 0.9835, 0.9909, 0.9995, 0.9994, 0.9999, 0.9999,  &
0.9572, 0.9572, 0.9572, 0.9612, 0.9649, 0.9769, 0.9968, 0.9909, 0.9990,  &
0.9318, 0.9318, 0.9318, 0.9376, 0.9376, 0.9431, 0.9572, 0.9835, 0.9994 /
data ((cldnuctab( 9,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
0.9958, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9945, 0.9958, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9937, 0.9945, 0.9958, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9919, 0.9929, 0.9937, 0.9958, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9869, 0.9884, 0.9897, 0.9937, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9714, 0.9714, 0.9714, 0.9743, 0.9769, 0.9853, 0.9979, 0.9990, 0.9999,  &
0.9481, 0.9481, 0.9481, 0.9481, 0.9528, 0.9572, 0.9683, 0.9897, 0.9999 /
data ((cldnuctab( 9,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
0.9963, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9963, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9945, 0.9952, 0.9958, 0.9986, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9937, 0.9937, 0.9945, 0.9958, 0.9988, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9897, 0.9909, 0.9909, 0.9919, 0.9952, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9793, 0.9815, 0.9815, 0.9815, 0.9835, 0.9897, 0.9982, 0.9999, 0.9999,  &
0.9612, 0.9612, 0.9612, 0.9612, 0.9612, 0.9649, 0.9743, 0.9919, 0.9999 /
data ((cldnuctab( 9,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
0.9963, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9963, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9958, 0.9963, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9945, 0.9945, 0.9952, 0.9963, 0.9984, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9919, 0.9919, 0.9929, 0.9937, 0.9952, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.9853, 0.9853, 0.9853, 0.9853, 0.9869, 0.9909, 0.9979, 0.9999, 0.9999,  &
0.9683, 0.9683, 0.9683, 0.9683, 0.9683, 0.9714, 0.9793, 0.9919, 0.9999 /
data ((cldnuctab( 9,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
0.9968, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9968, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9958, 0.9963, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9958, 0.9963, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9929, 0.9937, 0.9937, 0.9945, 0.9958, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9869, 0.9869, 0.9884, 0.9897, 0.9919, 0.9972, 0.9999, 0.9999,  &
0.9714, 0.9714, 0.9714, 0.9714, 0.9714, 0.9743, 0.9793, 0.9909, 0.9999 /
data ((cldnuctab( 9,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
0.9968, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9968, 0.9979, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9968, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9958, 0.9963, 0.9968, 0.9982, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9937, 0.9937, 0.9945, 0.9952, 0.9958, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.9884, 0.9884, 0.9884, 0.9884, 0.9897, 0.9929, 0.9972, 0.9999, 0.9999,  &
0.9743, 0.9743, 0.9743, 0.9743, 0.9743, 0.9769, 0.9815, 0.9909, 0.9999 /
data ((cldnuctab( 9,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
0.9982, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9975, 0.9982, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9963, 0.9975, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9897, 0.9897, 0.9919, 0.9952, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9769, 0.9793, 0.9793, 0.9815, 0.9869, 0.9972, 0.9999, 0.9997, 0.9999,  &
0.9649, 0.9683, 0.9683, 0.9683, 0.9714, 0.9769, 0.9909, 0.9995, 0.9999,  &
0.9612, 0.9612, 0.9612, 0.9612, 0.9612, 0.9649, 0.9714, 0.9815, 0.9884 /
data ((cldnuctab( 9,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
0.9984, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9984, 0.9994, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9975, 0.9982, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9945, 0.9945, 0.9952, 0.9972, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9869, 0.9884, 0.9897, 0.9929, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.9743, 0.9743, 0.9743, 0.9769, 0.9793, 0.9835, 0.9945, 0.9999, 0.9984,  &
0.9649, 0.9649, 0.9649, 0.9649, 0.9649, 0.9683, 0.9743, 0.9869, 0.9976 /
data ((cldnuctab( 9,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
0.9986, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9984, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9968, 0.9972, 0.9982, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9919, 0.9919, 0.9929, 0.9937, 0.9958, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9815, 0.9815, 0.9835, 0.9835, 0.9853, 0.9897, 0.9963, 0.9999, 0.9997,  &
0.9714, 0.9714, 0.9714, 0.9714, 0.9714, 0.9743, 0.9793, 0.9897, 0.9996 /
data ((cldnuctab( 9,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
0.9986, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9986, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9986, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9976, 0.9975, 0.9979, 0.9984, 0.9993, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9945, 0.9952, 0.9952, 0.9958, 0.9972, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9884, 0.9884, 0.9884, 0.9897, 0.9919, 0.9972, 0.9999, 0.9999,  &
0.9743, 0.9769, 0.9769, 0.9769, 0.9769, 0.9793, 0.9815, 0.9909, 0.9998 /
data ((cldnuctab( 9,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
0.9988, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9988, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9986, 0.9988, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9982, 0.9986, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9968, 0.9975, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9909, 0.9909, 0.9909, 0.9909, 0.9919, 0.9937, 0.9975, 0.9999, 0.9999,  &
0.9793, 0.9793, 0.9793, 0.9793, 0.9793, 0.9815, 0.9853, 0.9919, 0.9997 /
data ((cldnuctab( 9,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
0.9990, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9990, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9986, 0.9988, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9982, 0.9984, 0.9988, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9972, 0.9979, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9919, 0.9919, 0.9919, 0.9919, 0.9929, 0.9945, 0.9976, 0.9999, 0.9999,  &
0.9815, 0.9815, 0.9815, 0.9815, 0.9815, 0.9835, 0.9853, 0.9919, 0.9993 /
data ((cldnuctab( 9,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
0.9990, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9990, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9990, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9984, 0.9986, 0.9988, 0.9992, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9972, 0.9975, 0.9982, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9929, 0.9929, 0.9929, 0.9929, 0.9937, 0.9952, 0.9976, 0.9999, 0.9999,  &
0.9835, 0.9835, 0.9835, 0.9835, 0.9835, 0.9853, 0.9869, 0.9919, 0.9988 /
data ((cldnuctab( 9,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9993, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9975, 0.9979, 0.9986, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9937, 0.9945, 0.9952, 0.9963, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9884, 0.9884, 0.9884, 0.9897, 0.9919, 0.9968, 0.9999, 0.9999, 0.9999,  &
0.9835, 0.9853, 0.9853, 0.9853, 0.9869, 0.9884, 0.9937, 0.9988, 0.9999,  &
0.9815, 0.9815, 0.9815, 0.9835, 0.9835, 0.9835, 0.9869, 0.9897, 0.9929 /
data ((cldnuctab( 9,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9992, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9972, 0.9972, 0.9982, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9929, 0.9929, 0.9929, 0.9937, 0.9952, 0.9982, 0.9999, 0.9999, 0.9999,  &
0.9869, 0.9869, 0.9869, 0.9884, 0.9884, 0.9909, 0.9952, 0.9997, 0.9999,  &
0.9815, 0.9835, 0.9835, 0.9835, 0.9853, 0.9853, 0.9869, 0.9919, 0.9972 /
data ((cldnuctab( 9,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9992, 0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9986, 0.9990, 0.9996, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9958, 0.9958, 0.9963, 0.9972, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9909, 0.9909, 0.9909, 0.9909, 0.9919, 0.9929, 0.9963, 0.9999, 0.9999,  &
0.9853, 0.9853, 0.9853, 0.9853, 0.9869, 0.9869, 0.9884, 0.9929, 0.9988 /
data ((cldnuctab( 9,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9990, 0.9990, 0.9992, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9972, 0.9975, 0.9982, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9929, 0.9929, 0.9929, 0.9929, 0.9937, 0.9952, 0.9972, 0.9999, 0.9999,  &
0.9884, 0.9884, 0.9884, 0.9884, 0.9884, 0.9884, 0.9909, 0.9937, 0.9990 /
data ((cldnuctab( 9,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9991, 0.9992, 0.9994, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9979, 0.9982, 0.9986, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9945, 0.9945, 0.9945, 0.9945, 0.9952, 0.9958, 0.9976, 0.9998, 0.9999,  &
0.9897, 0.9897, 0.9897, 0.9897, 0.9897, 0.9897, 0.9909, 0.9937, 0.9988 /
data ((cldnuctab( 9,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
0.9997, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9993, 0.9993, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9984, 0.9984, 0.9988, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9952, 0.9952, 0.9958, 0.9963, 0.9979, 0.9997, 0.9999,  &
0.9897, 0.9897, 0.9897, 0.9897, 0.9909, 0.9909, 0.9919, 0.9945, 0.9984 /
data ((cldnuctab( 9,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
0.9997, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9997, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9994, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9984, 0.9986, 0.9986, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9958, 0.9958, 0.9958, 0.9963, 0.9968, 0.9979, 0.9996, 0.9999,  &
0.9909, 0.9909, 0.9909, 0.9909, 0.9909, 0.9909, 0.9919, 0.9945, 0.9982 /
data ((cldnuctab( 9,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9986, 0.9990, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9958, 0.9963, 0.9972, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9929, 0.9929, 0.9929, 0.9937, 0.9945, 0.9972, 0.9998, 0.9999, 0.9999,  &
0.9909, 0.9909, 0.9909, 0.9909, 0.9919, 0.9929, 0.9958, 0.9988, 0.9997,  &
0.9897, 0.9897, 0.9897, 0.9897, 0.9909, 0.9909, 0.9919, 0.9937, 0.9958 /
data ((cldnuctab( 9,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9992, 0.9995, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9982, 0.9986, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9952, 0.9958, 0.9963, 0.9984, 0.9999, 0.9999, 0.9999,  &
0.9919, 0.9919, 0.9919, 0.9929, 0.9929, 0.9937, 0.9963, 0.9996, 0.9999,  &
0.9897, 0.9897, 0.9897, 0.9909, 0.9909, 0.9909, 0.9919, 0.9945, 0.9979 /
data ((cldnuctab( 9,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9990, 0.9992, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9972, 0.9979, 0.9990, 0.9999, 0.9999, 0.9999,  &
0.9937, 0.9937, 0.9937, 0.9937, 0.9945, 0.9952, 0.9972, 0.9997, 0.9999,  &
0.9919, 0.9919, 0.9919, 0.9919, 0.9919, 0.9919, 0.9929, 0.9952, 0.9988 /
data ((cldnuctab( 9,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9992, 0.9993, 0.9995, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9979, 0.9982, 0.9986, 0.9992, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9952, 0.9952, 0.9958, 0.9963, 0.9979, 0.9997, 0.9999,  &
0.9919, 0.9919, 0.9929, 0.9929, 0.9929, 0.9929, 0.9937, 0.9958, 0.9988 /
data ((cldnuctab( 9,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9994, 0.9995, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9984, 0.9986, 0.9986, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9963, 0.9963, 0.9968, 0.9982, 0.9997, 0.9999,  &
0.9929, 0.9929, 0.9929, 0.9929, 0.9937, 0.9937, 0.9945, 0.9958, 0.9986 /
data ((cldnuctab( 9,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9988, 0.9990, 0.9991, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9968, 0.9968, 0.9972, 0.9982, 0.9996, 0.9999,  &
0.9937, 0.9937, 0.9937, 0.9937, 0.9937, 0.9937, 0.9945, 0.9958, 0.9984 /
data ((cldnuctab( 9,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9990, 0.9990, 0.9992, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9972, 0.9972, 0.9975, 0.9982, 0.9995, 0.9999,  &
0.9937, 0.9937, 0.9937, 0.9937, 0.9937, 0.9945, 0.9945, 0.9958, 0.9982 /
data ((cldnuctab( 9,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9988, 0.9991, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9972, 0.9972, 0.9979, 0.9990, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9952, 0.9958, 0.9963, 0.9979, 0.9998, 0.9999, 0.9999,  &
0.9937, 0.9937, 0.9937, 0.9937, 0.9945, 0.9952, 0.9968, 0.9990, 0.9997,  &
0.9937, 0.9937, 0.9937, 0.9937, 0.9937, 0.9937, 0.9945, 0.9958, 0.9968 /
data ((cldnuctab( 9,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9994, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9984, 0.9984, 0.9988, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9968, 0.9972, 0.9986, 0.9999, 0.9999, 0.9999,  &
0.9945, 0.9945, 0.9945, 0.9945, 0.9952, 0.9958, 0.9972, 0.9995, 0.9999,  &
0.9937, 0.9937, 0.9937, 0.9937, 0.9937, 0.9945, 0.9952, 0.9963, 0.9982 /
data ((cldnuctab( 9,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9991, 0.9992, 0.9993, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9975, 0.9975, 0.9976, 0.9979, 0.9982, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9958, 0.9958, 0.9958, 0.9958, 0.9958, 0.9968, 0.9979, 0.9996, 0.9999,  &
0.9937, 0.9937, 0.9945, 0.9945, 0.9945, 0.9945, 0.9952, 0.9968, 0.9988 /
data ((cldnuctab( 9,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9994, 0.9994, 0.9995, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9984, 0.9984, 0.9984, 0.9986, 0.9988, 0.9993, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9968, 0.9968, 0.9972, 0.9982, 0.9996, 0.9999,  &
0.9945, 0.9945, 0.9952, 0.9952, 0.9952, 0.9952, 0.9958, 0.9968, 0.9990 /
data ((cldnuctab( 9,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9988, 0.9988, 0.9988, 0.9990, 0.9991, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9972, 0.9972, 0.9972, 0.9975, 0.9984, 0.9996, 0.9999,  &
0.9952, 0.9952, 0.9952, 0.9952, 0.9952, 0.9958, 0.9958, 0.9968, 0.9988 /
data ((cldnuctab( 9,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9991, 0.9991, 0.9992, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9975, 0.9975, 0.9975, 0.9975, 0.9975, 0.9979, 0.9986, 0.9995, 0.9999,  &
0.9958, 0.9958, 0.9958, 0.9958, 0.9958, 0.9958, 0.9963, 0.9972, 0.9986 /
data ((cldnuctab( 9,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9991, 0.9991, 0.9992, 0.9992, 0.9993, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.9975, 0.9976, 0.9975, 0.9979, 0.9979, 0.9982, 0.9986, 0.9995, 0.9999,  &
0.9958, 0.9958, 0.9958, 0.9958, 0.9958, 0.9958, 0.9963, 0.9972, 0.9984 /
data ((cldnuctab( 9,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9996, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9991, 0.9993, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9975, 0.9975, 0.9979, 0.9982, 0.9991, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9968, 0.9972, 0.9982, 0.9997, 0.9999, 0.9999,  &
0.9952, 0.9952, 0.9958, 0.9958, 0.9958, 0.9963, 0.9975, 0.9991, 0.9997,  &
0.9952, 0.9952, 0.9952, 0.9952, 0.9958, 0.9958, 0.9963, 0.9968, 0.9976 /
data ((cldnuctab( 9,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9996, 0.9996, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9986, 0.9988, 0.9990, 0.9995, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9972, 0.9975, 0.9979, 0.9988, 0.9998, 0.9999, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9963, 0.9963, 0.9968, 0.9979, 0.9995, 0.9999,  &
0.9952, 0.9952, 0.9952, 0.9952, 0.9958, 0.9958, 0.9963, 0.9972, 0.9986 /
data ((cldnuctab( 9,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9992, 0.9993, 0.9995, 0.9997, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9982, 0.9982, 0.9982, 0.9986, 0.9991, 0.9999, 0.9999, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9968, 0.9972, 0.9975, 0.9982, 0.9996, 0.9999,  &
0.9958, 0.9958, 0.9958, 0.9958, 0.9958, 0.9963, 0.9968, 0.9976, 0.9990 /
data ((cldnuctab( 9,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9995, 0.9996, 0.9996, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9986, 0.9986, 0.9988, 0.9988, 0.9990, 0.9994, 0.9999, 0.9999, 0.9999,  &
0.9972, 0.9972, 0.9972, 0.9975, 0.9975, 0.9979, 0.9986, 0.9996, 0.9999,  &
0.9958, 0.9958, 0.9963, 0.9963, 0.9963, 0.9963, 0.9968, 0.9976, 0.9991 /
data ((cldnuctab( 9,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9990, 0.9990, 0.9991, 0.9991, 0.9992, 0.9995, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9979, 0.9979, 0.9979, 0.9982, 0.9986, 0.9996, 0.9999,  &
0.9963, 0.9963, 0.9963, 0.9968, 0.9968, 0.9968, 0.9972, 0.9976, 0.9990 /
data ((cldnuctab( 9,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9992, 0.9992, 0.9992, 0.9992, 0.9993, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.9979, 0.9979, 0.9979, 0.9982, 0.9982, 0.9984, 0.9988, 0.9995, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9968, 0.9968, 0.9968, 0.9972, 0.9976, 0.9988 /
data ((cldnuctab( 9,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9997, 0.9997, 0.9998, 0.9998, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999,  &
0.9993, 0.9993, 0.9993, 0.9993, 0.9994, 0.9996, 0.9999, 0.9999, 0.9999,  &
0.9982, 0.9982, 0.9982, 0.9982, 0.9982, 0.9984, 0.9988, 0.9995, 0.9999,  &
0.9968, 0.9968, 0.9968, 0.9968, 0.9968, 0.9972, 0.9972, 0.9979, 0.9988 /

data ((supersat( 1,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0144, 1.0214, 1.0331, 1.0538, 1.0937, 1.1818, 1.4300, 2.7273, 4.9985,  &
1.0119, 1.0176, 1.0268, 1.0426, 1.0716, 1.1301, 1.2705, 1.7361, 4.0450,  &
1.0096, 1.0148, 1.0222, 1.0348, 1.0569, 1.0991, 1.1902, 1.4340, 2.5713,  &
1.0087, 1.0124, 1.0189, 1.0291, 1.0466, 1.0787, 1.1433, 1.2955, 1.7809,  &
1.0073, 1.0107, 1.0161, 1.0247, 1.0391, 1.0644, 1.1129, 1.2178, 1.4984,  &
1.0055, 1.0092, 1.0138, 1.0213, 1.0333, 1.0539, 1.0918, 1.1688, 1.3530,  &
1.0055, 1.0085, 1.0124, 1.0186, 1.0287, 1.0458, 1.0761, 1.1352, 1.2654 /
data ((supersat( 1,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0115, 1.0169, 1.0258, 1.0409, 1.0693, 1.1283, 1.2770, 1.8166, 3.7290,  &
1.0096, 1.0137, 1.0208, 1.0324, 1.0529, 1.0928, 1.1814, 1.4287, 2.6081,  &
1.0075, 1.0114, 1.0170, 1.0262, 1.0421, 1.0710, 1.1300, 1.2719, 1.7351,  &
1.0068, 1.0098, 1.0142, 1.0219, 1.0344, 1.0565, 1.0991, 1.1917, 1.4393,  &
1.0056, 1.0079, 1.0123, 1.0186, 1.0288, 1.0464, 1.0788, 1.1444, 1.3001,  &
1.0040, 1.0072, 1.0105, 1.0160, 1.0243, 1.0388, 1.0645, 1.1138, 1.2213,  &
1.0040, 1.0065, 1.0093, 1.0138, 1.0209, 1.0330, 1.0539, 1.0923, 1.1712 /
data ((supersat( 1,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0096, 1.0138, 1.0208, 1.0325, 1.0537, 1.0963, 1.1961, 1.4967, 2.7489,  &
1.0079, 1.0111, 1.0166, 1.0256, 1.0410, 1.0699, 1.1308, 1.2850, 1.8269,  &
1.0063, 1.0092, 1.0136, 1.0206, 1.0323, 1.0533, 1.0944, 1.1865, 1.4432,  &
1.0055, 1.0079, 1.0113, 1.0169, 1.0263, 1.0423, 1.0721, 1.1334, 1.2817,  &
1.0047, 1.0062, 1.0094, 1.0143, 1.0219, 1.0346, 1.0574, 1.1014, 1.1983,  &
1.0035, 1.0057, 1.0084, 1.0119, 1.0186, 1.0289, 1.0471, 1.0805, 1.1491,  &
1.0028, 1.0051, 1.0070, 1.0107, 1.0160, 1.0247, 1.0395, 1.0658, 1.1172 /
data ((supersat( 1,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0082, 1.0117, 1.0174, 1.0268, 1.0436, 1.0763, 1.1494, 1.3489, 2.1009,  &
1.0066, 1.0093, 1.0138, 1.0209, 1.0330, 1.0552, 1.1003, 1.2077, 1.5283,  &
1.0055, 1.0077, 1.0113, 1.0166, 1.0258, 1.0418, 1.0723, 1.1374, 1.3037,  &
1.0043, 1.0065, 1.0093, 1.0137, 1.0209, 1.0330, 1.0549, 1.0984, 1.1974,  &
1.0040, 1.0053, 1.0076, 1.0115, 1.0171, 1.0268, 1.0435, 1.0749, 1.1403,  &
1.0033, 1.0044, 1.0067, 1.0097, 1.0145, 1.0223, 1.0355, 1.0594, 1.1062,  &
1.0023, 1.0042, 1.0056, 1.0083, 1.0124, 1.0190, 1.0298, 1.0486, 1.0840 /
data ((supersat( 1,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0071, 1.0102, 1.0150, 1.0229, 1.0367, 1.0631, 1.1205, 1.2685, 1.7439,  &
1.0057, 1.0082, 1.0118, 1.0177, 1.0276, 1.0454, 1.0810, 1.1623, 1.3862,  &
1.0048, 1.0067, 1.0096, 1.0140, 1.0215, 1.0342, 1.0580, 1.1074, 1.2275,  &
1.0038, 1.0054, 1.0077, 1.0115, 1.0171, 1.0267, 1.0437, 1.0766, 1.1485,  &
1.0031, 1.0047, 1.0065, 1.0095, 1.0141, 1.0214, 1.0343, 1.0578, 1.1054,  &
1.0029, 1.0035, 1.0055, 1.0079, 1.0118, 1.0177, 1.0279, 1.0457, 1.0795,  &
1.0025, 1.0032, 1.0048, 1.0068, 1.0100, 1.0150, 1.0233, 1.0373, 1.0628 /
data ((supersat( 1,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0062, 1.0090, 1.0132, 1.0200, 1.0317, 1.0540, 1.1015, 1.2196, 1.5688,  &
1.0052, 1.0073, 1.0104, 1.0154, 1.0238, 1.0388, 1.0681, 1.1337, 1.3062,  &
1.0041, 1.0059, 1.0082, 1.0121, 1.0184, 1.0289, 1.0485, 1.0883, 1.1819,  &
1.0036, 1.0047, 1.0067, 1.0098, 1.0145, 1.0224, 1.0362, 1.0624, 1.1184,  &
1.0027, 1.0041, 1.0057, 1.0081, 1.0118, 1.0179, 1.0281, 1.0467, 1.0833,  &
1.0021, 1.0034, 1.0044, 1.0066, 1.0099, 1.0147, 1.0227, 1.0366, 1.0624,  &
1.0021, 1.0025, 1.0041, 1.0058, 1.0084, 1.0124, 1.0188, 1.0296, 1.0491 /
data ((supersat( 1,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0057, 1.0081, 1.0117, 1.0177, 1.0281, 1.0473, 1.0879, 1.1867, 1.4664,  &
1.0046, 1.0065, 1.0093, 1.0136, 1.0210, 1.0339, 1.0589, 1.1140, 1.2553,  &
1.0037, 1.0051, 1.0074, 1.0107, 1.0161, 1.0252, 1.0418, 1.0751, 1.1522,  &
1.0031, 1.0043, 1.0061, 1.0086, 1.0127, 1.0193, 1.0310, 1.0528, 1.0986,  &
1.0027, 1.0033, 1.0050, 1.0070, 1.0103, 1.0154, 1.0239, 1.0391, 1.0688,  &
1.0021, 1.0031, 1.0041, 1.0058, 1.0085, 1.0125, 1.0191, 1.0304, 1.0511,  &
1.0015, 1.0026, 1.0032, 1.0050, 1.0071, 1.0104, 1.0157, 1.0244, 1.0399 /
data ((supersat( 1,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0121, 1.0186, 1.0296, 1.0492, 1.0880, 1.1755, 1.4246, 2.7227, 4.9962,  &
1.0100, 1.0153, 1.0239, 1.0387, 1.0666, 1.1242, 1.2644, 1.7310, 4.0395,  &
1.0086, 1.0126, 1.0195, 1.0316, 1.0526, 1.0937, 1.1841, 1.4283, 2.5653,  &
1.0073, 1.0110, 1.0163, 1.0262, 1.0429, 1.0739, 1.1375, 1.2893, 1.7748,  &
1.0055, 1.0091, 1.0143, 1.0224, 1.0359, 1.0601, 1.1075, 1.2116, 1.4919,  &
1.0055, 1.0084, 1.0124, 1.0192, 1.0302, 1.0500, 1.0868, 1.1627, 1.3462,  &
1.0051, 1.0068, 1.0107, 1.0163, 1.0261, 1.0422, 1.0715, 1.1292, 1.2583 /
data ((supersat( 1,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0097, 1.0146, 1.0227, 1.0369, 1.0641, 1.1224, 1.2716, 1.8131, 3.7257,  &
1.0078, 1.0120, 1.0183, 1.0290, 1.0486, 1.0875, 1.1756, 1.4239, 2.6034,  &
1.0068, 1.0100, 1.0150, 1.0235, 1.0384, 1.0663, 1.1245, 1.2663, 1.7305,  &
1.0056, 1.0081, 1.0127, 1.0195, 1.0312, 1.0524, 1.0940, 1.1860, 1.4341,  &
1.0041, 1.0075, 1.0106, 1.0165, 1.0260, 1.0428, 1.0741, 1.1390, 1.2944,  &
1.0040, 1.0063, 1.0094, 1.0140, 1.0222, 1.0356, 1.0603, 1.1086, 1.2154,  &
1.0039, 1.0048, 1.0075, 1.0123, 1.0190, 1.0302, 1.0501, 1.0875, 1.1653 /
data ((supersat( 1,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0080, 1.0118, 1.0181, 1.0289, 1.0491, 1.0908, 1.1908, 1.4931, 2.7455,  &
1.0064, 1.0096, 1.0144, 1.0226, 1.0371, 1.0650, 1.1253, 1.2803, 1.8237,  &
1.0055, 1.0080, 1.0116, 1.0182, 1.0291, 1.0492, 1.0893, 1.1812, 1.4389,  &
1.0046, 1.0063, 1.0098, 1.0149, 1.0236, 1.0388, 1.0676, 1.1282, 1.2768,  &
1.0033, 1.0056, 1.0084, 1.0126, 1.0196, 1.0316, 1.0534, 1.0966, 1.1930,  &
1.0027, 1.0050, 1.0071, 1.0109, 1.0167, 1.0263, 1.0436, 1.0761, 1.1439,  &
1.0027, 1.0038, 1.0059, 1.0089, 1.0143, 1.0224, 1.0364, 1.0617, 1.1121 /
data ((supersat( 1,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0066, 1.0099, 1.0150, 1.0236, 1.0394, 1.0712, 1.1442, 1.3452, 2.0989,  &
1.0055, 1.0080, 1.0117, 1.0182, 1.0295, 1.0507, 1.0951, 1.2029, 1.5253,  &
1.0043, 1.0065, 1.0094, 1.0145, 1.0230, 1.0381, 1.0676, 1.1323, 1.2995,  &
1.0039, 1.0053, 1.0079, 1.0119, 1.0185, 1.0299, 1.0509, 1.0936, 1.1926,  &
1.0031, 1.0044, 1.0067, 1.0097, 1.0152, 1.0242, 1.0401, 1.0705, 1.1354,  &
1.0021, 1.0041, 1.0056, 1.0085, 1.0127, 1.0200, 1.0325, 1.0556, 1.1015,  &
1.0016, 1.0034, 1.0045, 1.0071, 1.0110, 1.0171, 1.0272, 1.0452, 1.0796 /
data ((supersat( 1,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0058, 1.0086, 1.0128, 1.0199, 1.0329, 1.0584, 1.1156, 1.2649, 1.7422,  &
1.0048, 1.0069, 1.0100, 1.0153, 1.0245, 1.0414, 1.0761, 1.1577, 1.3832,  &
1.0038, 1.0054, 1.0080, 1.0120, 1.0188, 1.0308, 1.0537, 1.1026, 1.2234,  &
1.0031, 1.0046, 1.0066, 1.0098, 1.0150, 1.0239, 1.0400, 1.0721, 1.1439,  &
1.0028, 1.0034, 1.0055, 1.0080, 1.0123, 1.0191, 1.0313, 1.0539, 1.1007,  &
1.0023, 1.0031, 1.0048, 1.0069, 1.0103, 1.0159, 1.0253, 1.0423, 1.0753,  &
1.0016, 1.0029, 1.0035, 1.0057, 1.0085, 1.0132, 1.0210, 1.0343, 1.0590 /
data ((supersat( 1,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0052, 1.0075, 1.0112, 1.0173, 1.0283, 1.0497, 1.0968, 1.2160, 1.5671,  &
1.0041, 1.0060, 1.0087, 1.0132, 1.0209, 1.0350, 1.0636, 1.1292, 1.3032,  &
1.0035, 1.0048, 1.0070, 1.0103, 1.0160, 1.0258, 1.0445, 1.0837, 1.1779,  &
1.0026, 1.0040, 1.0058, 1.0083, 1.0126, 1.0198, 1.0328, 1.0582, 1.1139,  &
1.0021, 1.0033, 1.0044, 1.0067, 1.0102, 1.0158, 1.0254, 1.0431, 1.0790,  &
1.0020, 1.0023, 1.0041, 1.0058, 1.0085, 1.0128, 1.0204, 1.0335, 1.0586,  &
1.0019, 1.0021, 1.0034, 1.0044, 1.0070, 1.0108, 1.0168, 1.0270, 1.0457 /
data ((supersat( 1,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0047, 1.0067, 1.0099, 1.0153, 1.0248, 1.0433, 1.0834, 1.1831, 1.4647,  &
1.0037, 1.0053, 1.0078, 1.0116, 1.0183, 1.0304, 1.0547, 1.1098, 1.2524,  &
1.0030, 1.0044, 1.0062, 1.0091, 1.0139, 1.0223, 1.0380, 1.0708, 1.1483,  &
1.0026, 1.0033, 1.0050, 1.0072, 1.0109, 1.0170, 1.0278, 1.0489, 1.0943,  &
1.0020, 1.0030, 1.0041, 1.0059, 1.0087, 1.0134, 1.0213, 1.0358, 1.0648,  &
1.0013, 1.0025, 1.0032, 1.0050, 1.0071, 1.0108, 1.0169, 1.0276, 1.0475,  &
1.0011, 1.0018, 1.0030, 1.0041, 1.0061, 1.0090, 1.0139, 1.0221, 1.0368 /
data ((supersat( 1,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0106, 1.0163, 1.0265, 1.0451, 1.0827, 1.1699, 1.4200, 2.7183, 4.9936,  &
1.0087, 1.0133, 1.0214, 1.0352, 1.0621, 1.1188, 1.2590, 1.7266, 4.0341,  &
1.0074, 1.0114, 1.0177, 1.0286, 1.0487, 1.0888, 1.1786, 1.4231, 2.5595,  &
1.0055, 1.0092, 1.0150, 1.0237, 1.0395, 1.0695, 1.1322, 1.2837, 1.7689,  &
1.0054, 1.0085, 1.0126, 1.0198, 1.0328, 1.0562, 1.1025, 1.2058, 1.4856,  &
1.0050, 1.0069, 1.0110, 1.0170, 1.0277, 1.0464, 1.0820, 1.1568, 1.3396,  &
1.0042, 1.0056, 1.0091, 1.0149, 1.0233, 1.0389, 1.0670, 1.1235, 1.2515 /
data ((supersat( 1,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0082, 1.0126, 1.0200, 1.0334, 1.0595, 1.1171, 1.2669, 1.8101, 3.7229,  &
1.0068, 1.0102, 1.0160, 1.0261, 1.0447, 1.0826, 1.1705, 1.4197, 2.5997,  &
1.0056, 1.0085, 1.0132, 1.0211, 1.0351, 1.0620, 1.1195, 1.2615, 1.7264,  &
1.0041, 1.0072, 1.0107, 1.0174, 1.0284, 1.0487, 1.0894, 1.1809, 1.4293,  &
1.0040, 1.0064, 1.0096, 1.0147, 1.0236, 1.0396, 1.0700, 1.1339, 1.2892,  &
1.0038, 1.0048, 1.0075, 1.0128, 1.0199, 1.0328, 1.0564, 1.1038, 1.2099,  &
1.0033, 1.0040, 1.0071, 1.0106, 1.0169, 1.0277, 1.0466, 1.0829, 1.1597 /
data ((supersat( 1,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0067, 1.0101, 1.0157, 1.0258, 1.0451, 1.0859, 1.1862, 1.4900, 2.7430,  &
1.0055, 1.0081, 1.0126, 1.0201, 1.0336, 1.0606, 1.1205, 1.2762, 1.8210,  &
1.0046, 1.0066, 1.0103, 1.0161, 1.0263, 1.0454, 1.0848, 1.1765, 1.4352,  &
1.0032, 1.0056, 1.0085, 1.0133, 1.0213, 1.0356, 1.0635, 1.1235, 1.2724,  &
1.0028, 1.0050, 1.0073, 1.0112, 1.0175, 1.0289, 1.0499, 1.0922, 1.1883,  &
1.0027, 1.0037, 1.0058, 1.0092, 1.0146, 1.0241, 1.0404, 1.0720, 1.1391,  &
1.0026, 1.0028, 1.0055, 1.0084, 1.0127, 1.0201, 1.0335, 1.0580, 1.1074 /
data ((supersat( 1,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0057, 1.0084, 1.0129, 1.0208, 1.0357, 1.0667, 1.1398, 1.3422, 2.0970,  &
1.0043, 1.0067, 1.0102, 1.0160, 1.0265, 1.0468, 1.0906, 1.1990, 1.5226,  &
1.0039, 1.0055, 1.0083, 1.0128, 1.0205, 1.0348, 1.0634, 1.1279, 1.2961,  &
1.0031, 1.0044, 1.0068, 1.0104, 1.0165, 1.0271, 1.0473, 1.0893, 1.1884,  &
1.0020, 1.0040, 1.0057, 1.0088, 1.0136, 1.0219, 1.0370, 1.0666, 1.1310,  &
1.0016, 1.0033, 1.0044, 1.0072, 1.0115, 1.0181, 1.0299, 1.0521, 1.0973,  &
1.0016, 1.0023, 1.0043, 1.0065, 1.0097, 1.0151, 1.0248, 1.0420, 1.0756 /
data ((supersat( 1,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0049, 1.0071, 1.0109, 1.0174, 1.0295, 1.0543, 1.1113, 1.2619, 1.7406,  &
1.0038, 1.0055, 1.0086, 1.0133, 1.0217, 1.0378, 1.0719, 1.1538, 1.3807,  &
1.0031, 1.0047, 1.0069, 1.0104, 1.0166, 1.0278, 1.0499, 1.0984, 1.2200,  &
1.0028, 1.0034, 1.0055, 1.0084, 1.0132, 1.0215, 1.0368, 1.0682, 1.1399,  &
1.0022, 1.0031, 1.0048, 1.0071, 1.0107, 1.0171, 1.0286, 1.0504, 1.0967,  &
1.0014, 1.0029, 1.0035, 1.0057, 1.0091, 1.0142, 1.0230, 1.0392, 1.0715,  &
1.0009, 1.0024, 1.0032, 1.0052, 1.0078, 1.0120, 1.0191, 1.0317, 1.0556 /
data ((supersat( 1,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0041, 1.0061, 1.0095, 1.0150, 1.0252, 1.0458, 1.0927, 1.2131, 1.5657,  &
1.0035, 1.0049, 1.0074, 1.0114, 1.0184, 1.0317, 1.0596, 1.1254, 1.3009,  &
1.0026, 1.0040, 1.0059, 1.0089, 1.0139, 1.0231, 1.0409, 1.0797, 1.1746,  &
1.0021, 1.0033, 1.0046, 1.0071, 1.0110, 1.0176, 1.0299, 1.0546, 1.1101,  &
1.0020, 1.0023, 1.0040, 1.0060, 1.0088, 1.0140, 1.0230, 1.0399, 1.0752,  &
1.0018, 1.0021, 1.0033, 1.0046, 1.0074, 1.0115, 1.0184, 1.0308, 1.0551,  &
1.0014, 1.0020, 1.0023, 1.0042, 1.0063, 1.0096, 1.0150, 1.0247, 1.0426 /
data ((supersat( 1,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0038, 1.0056, 1.0083, 1.0132, 1.0220, 1.0397, 1.0796, 1.1805, 1.4633,  &
1.0030, 1.0045, 1.0065, 1.0099, 1.0160, 1.0273, 1.0510, 1.1062, 1.2502,  &
1.0026, 1.0033, 1.0050, 1.0078, 1.0120, 1.0198, 1.0348, 1.0671, 1.1451,  &
1.0019, 1.0030, 1.0042, 1.0062, 1.0094, 1.0150, 1.0251, 1.0454, 1.0907,  &
1.0012, 1.0024, 1.0032, 1.0050, 1.0075, 1.0118, 1.0191, 1.0329, 1.0612,  &
1.0011, 1.0017, 1.0030, 1.0042, 1.0063, 1.0096, 1.0152, 1.0251, 1.0444,  &
1.0011, 1.0011, 1.0025, 1.0033, 1.0052, 1.0080, 1.0124, 1.0200, 1.0341 /
data ((supersat( 1,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0089, 1.0145, 1.0239, 1.0416, 1.0784, 1.1654, 1.4163, 2.7147, 4.9917,  &
1.0077, 1.0119, 1.0190, 1.0324, 1.0583, 1.1143, 1.2548, 1.7231, 4.0297,  &
1.0056, 1.0096, 1.0157, 1.0260, 1.0454, 1.0847, 1.1741, 1.4187, 2.5547,  &
1.0054, 1.0086, 1.0130, 1.0217, 1.0366, 1.0657, 1.1276, 1.2790, 1.7640,  &
1.0050, 1.0072, 1.0115, 1.0183, 1.0302, 1.0526, 1.0981, 1.2008, 1.4800,  &
1.0041, 1.0055, 1.0091, 1.0155, 1.0254, 1.0430, 1.0778, 1.1517, 1.3338,  &
1.0030, 1.0052, 1.0084, 1.0127, 1.0213, 1.0357, 1.0628, 1.1182, 1.2452 /
data ((supersat( 1,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0070, 1.0110, 1.0178, 1.0304, 1.0557, 1.1129, 1.2634, 1.8079, 3.7206,  &
1.0059, 1.0091, 1.0142, 1.0237, 1.0414, 1.0786, 1.1664, 1.4165, 2.5963,  &
1.0041, 1.0073, 1.0118, 1.0190, 1.0324, 1.0585, 1.1154, 1.2576, 1.7232,  &
1.0040, 1.0065, 1.0100, 1.0158, 1.0261, 1.0456, 1.0855, 1.1767, 1.4253,  &
1.0038, 1.0050, 1.0081, 1.0133, 1.0217, 1.0368, 1.0663, 1.1297, 1.2848,  &
1.0032, 1.0040, 1.0071, 1.0109, 1.0182, 1.0304, 1.0531, 1.0996, 1.2052,  &
1.0025, 1.0039, 1.0063, 1.0097, 1.0154, 1.0253, 1.0434, 1.0788, 1.1548 /
data ((supersat( 1,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0055, 1.0085, 1.0138, 1.0232, 1.0416, 1.0820, 1.1827, 1.4878, 2.7410,  &
1.0047, 1.0071, 1.0109, 1.0180, 1.0308, 1.0570, 1.1167, 1.2731, 1.8189,  &
1.0034, 1.0057, 1.0087, 1.0142, 1.0239, 1.0423, 1.0811, 1.1729, 1.4323,  &
1.0028, 1.0051, 1.0076, 1.0116, 1.0193, 1.0330, 1.0601, 1.1197, 1.2689,  &
1.0027, 1.0038, 1.0058, 1.0100, 1.0160, 1.0267, 1.0468, 1.0885, 1.1844,  &
1.0026, 1.0028, 1.0055, 1.0085, 1.0135, 1.0220, 1.0377, 1.0685, 1.1350,  &
1.0023, 1.0027, 1.0048, 1.0072, 1.0113, 1.0185, 1.0309, 1.0547, 1.1033 /
data ((supersat( 1,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0044, 1.0070, 1.0111, 1.0185, 1.0327, 1.0630, 1.1364, 1.3400, 2.0955,  &
1.0039, 1.0058, 1.0088, 1.0141, 1.0240, 1.0435, 1.0870, 1.1960, 1.5210,  &
1.0031, 1.0044, 1.0069, 1.0113, 1.0184, 1.0320, 1.0600, 1.1244, 1.2934,  &
1.0020, 1.0040, 1.0060, 1.0092, 1.0147, 1.0248, 1.0443, 1.0858, 1.1852,  &
1.0016, 1.0033, 1.0045, 1.0074, 1.0121, 1.0199, 1.0344, 1.0633, 1.1275,  &
1.0016, 1.0022, 1.0043, 1.0066, 1.0100, 1.0165, 1.0277, 1.0491, 1.0937,  &
1.0016, 1.0016, 1.0038, 1.0054, 1.0088, 1.0139, 1.0227, 1.0393, 1.0722 /
data ((supersat( 1,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0040, 1.0060, 1.0093, 1.0153, 1.0267, 1.0509, 1.1081, 1.2599, 1.7397,  &
1.0031, 1.0049, 1.0073, 1.0116, 1.0194, 1.0348, 1.0685, 1.1509, 1.3790,  &
1.0028, 1.0037, 1.0056, 1.0092, 1.0148, 1.0254, 1.0467, 1.0951, 1.2175,  &
1.0022, 1.0031, 1.0049, 1.0075, 1.0118, 1.0195, 1.0341, 1.0649, 1.1368,  &
1.0014, 1.0029, 1.0037, 1.0058, 1.0097, 1.0155, 1.0263, 1.0475, 1.0934,  &
1.0008, 1.0023, 1.0032, 1.0053, 1.0079, 1.0126, 1.0211, 1.0366, 1.0683,  &
1.0006, 1.0016, 1.0030, 1.0044, 1.0068, 1.0104, 1.0172, 1.0294, 1.0526 /
data ((supersat( 1,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0036, 1.0053, 1.0080, 1.0131, 1.0227, 1.0427, 1.0896, 1.2112, 1.5647,  &
1.0027, 1.0041, 1.0062, 1.0098, 1.0163, 1.0290, 1.0564, 1.1227, 1.2992,  &
1.0021, 1.0034, 1.0050, 1.0077, 1.0123, 1.0208, 1.0381, 1.0766, 1.1722,  &
1.0020, 1.0023, 1.0041, 1.0062, 1.0097, 1.0158, 1.0275, 1.0516, 1.1072,  &
1.0017, 1.0021, 1.0034, 1.0050, 1.0079, 1.0125, 1.0209, 1.0373, 1.0722,  &
1.0013, 1.0020, 1.0023, 1.0043, 1.0065, 1.0103, 1.0166, 1.0285, 1.0523,  &
1.0009, 1.0018, 1.0021, 1.0037, 1.0055, 1.0085, 1.0137, 1.0227, 1.0400 /
data ((supersat( 1,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0030, 1.0046, 1.0072, 1.0115, 1.0197, 1.0368, 1.0767, 1.1785, 1.4624,  &
1.0026, 1.0036, 1.0055, 1.0086, 1.0141, 1.0248, 1.0480, 1.1035, 1.2486,  &
1.0019, 1.0030, 1.0044, 1.0066, 1.0106, 1.0177, 1.0321, 1.0641, 1.1428,  &
1.0012, 1.0024, 1.0032, 1.0051, 1.0083, 1.0133, 1.0229, 1.0427, 1.0879,  &
1.0011, 1.0017, 1.0030, 1.0044, 1.0067, 1.0104, 1.0173, 1.0305, 1.0584,  &
1.0011, 1.0011, 1.0025, 1.0033, 1.0053, 1.0085, 1.0137, 1.0231, 1.0418,  &
1.0011, 1.0011, 1.0017, 1.0031, 1.0047, 1.0070, 1.0110, 1.0183, 1.0318 /
data ((supersat( 1,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0085, 1.0136, 1.0225, 1.0398, 1.0764, 1.1634, 1.4148, 2.7133, 4.9904,  &
1.0069, 1.0112, 1.0182, 1.0310, 1.0564, 1.1122, 1.2529, 1.7216, 4.0275,  &
1.0055, 1.0090, 1.0150, 1.0250, 1.0438, 1.0826, 1.1719, 1.4167, 2.5523,  &
1.0052, 1.0081, 1.0124, 1.0206, 1.0352, 1.0638, 1.1254, 1.2767, 1.7616,  &
1.0046, 1.0062, 1.0106, 1.0172, 1.0289, 1.0509, 1.0959, 1.1984, 1.4773,  &
1.0035, 1.0054, 1.0088, 1.0146, 1.0240, 1.0415, 1.0755, 1.1491, 1.3307,  &
1.0025, 1.0049, 1.0077, 1.0120, 1.0199, 1.0341, 1.0607, 1.1155, 1.2419 /
data ((supersat( 1,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0066, 1.0100, 1.0167, 1.0289, 1.0539, 1.1109, 1.2619, 1.8070, 3.7195,  &
1.0051, 1.0082, 1.0132, 1.0224, 1.0398, 1.0767, 1.1646, 1.4151, 2.5951,  &
1.0040, 1.0070, 1.0107, 1.0180, 1.0309, 1.0567, 1.1134, 1.2559, 1.7217,  &
1.0039, 1.0059, 1.0093, 1.0149, 1.0249, 1.0441, 1.0836, 1.1747, 1.4234,  &
1.0035, 1.0041, 1.0074, 1.0126, 1.0205, 1.0353, 1.0645, 1.1276, 1.2827,  &
1.0028, 1.0040, 1.0068, 1.0104, 1.0170, 1.0288, 1.0514, 1.0974, 1.2028,  &
1.0020, 1.0037, 1.0056, 1.0090, 1.0143, 1.0240, 1.0417, 1.0766, 1.1522 /
data ((supersat( 1,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0052, 1.0080, 1.0129, 1.0220, 1.0400, 1.0802, 1.1812, 1.4871, 2.7404,  &
1.0042, 1.0063, 1.0103, 1.0169, 1.0294, 1.0553, 1.1149, 1.2718, 1.8182,  &
1.0028, 1.0054, 1.0083, 1.0135, 1.0228, 1.0408, 1.0793, 1.1713, 1.4312,  &
1.0027, 1.0046, 1.0069, 1.0111, 1.0184, 1.0317, 1.0585, 1.1179, 1.2673,  &
1.0026, 1.0031, 1.0057, 1.0090, 1.0151, 1.0254, 1.0453, 1.0867, 1.1826,  &
1.0024, 1.0027, 1.0052, 1.0080, 1.0127, 1.0210, 1.0362, 1.0667, 1.1331,  &
1.0019, 1.0027, 1.0042, 1.0064, 1.0107, 1.0173, 1.0297, 1.0529, 1.1012 /
data ((supersat( 1,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0042, 1.0065, 1.0104, 1.0174, 1.0312, 1.0613, 1.1349, 1.3392, 2.0949,  &
1.0035, 1.0051, 1.0082, 1.0133, 1.0227, 1.0420, 1.0853, 1.1947, 1.5202,  &
1.0025, 1.0043, 1.0066, 1.0106, 1.0175, 1.0307, 1.0584, 1.1229, 1.2922,  &
1.0016, 1.0037, 1.0054, 1.0087, 1.0140, 1.0236, 1.0428, 1.0842, 1.1838,  &
1.0016, 1.0028, 1.0044, 1.0070, 1.0115, 1.0190, 1.0331, 1.0618, 1.1258,  &
1.0016, 1.0017, 1.0041, 1.0062, 1.0095, 1.0157, 1.0265, 1.0476, 1.0920,  &
1.0016, 1.0016, 1.0034, 1.0047, 1.0080, 1.0130, 1.0217, 1.0379, 1.0704 /
data ((supersat( 1,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0034, 1.0053, 1.0087, 1.0144, 1.0254, 1.0493, 1.1067, 1.2590, 1.7392,  &
1.0030, 1.0044, 1.0068, 1.0109, 1.0183, 1.0334, 1.0669, 1.1497, 1.3784,  &
1.0025, 1.0032, 1.0054, 1.0085, 1.0139, 1.0241, 1.0453, 1.0937, 1.2165,  &
1.0017, 1.0030, 1.0045, 1.0070, 1.0110, 1.0184, 1.0328, 1.0634, 1.1354,  &
1.0010, 1.0026, 1.0032, 1.0056, 1.0090, 1.0146, 1.0251, 1.0461, 1.0919,  &
1.0006, 1.0020, 1.0031, 1.0049, 1.0076, 1.0121, 1.0201, 1.0354, 1.0668,  &
1.0006, 1.0013, 1.0028, 1.0037, 1.0061, 1.0100, 1.0165, 1.0281, 1.0511 /
data ((supersat( 1,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0032, 1.0047, 1.0074, 1.0122, 1.0214, 1.0412, 1.0883, 1.2103, 1.5644,  &
1.0022, 1.0038, 1.0058, 1.0092, 1.0153, 1.0277, 1.0549, 1.1215, 1.2986,  &
1.0020, 1.0029, 1.0043, 1.0071, 1.0115, 1.0198, 1.0367, 1.0752, 1.1712,  &
1.0018, 1.0021, 1.0038, 1.0058, 1.0090, 1.0149, 1.0263, 1.0502, 1.1059,  &
1.0015, 1.0021, 1.0029, 1.0044, 1.0073, 1.0118, 1.0199, 1.0360, 1.0708,  &
1.0010, 1.0019, 1.0021, 1.0040, 1.0061, 1.0097, 1.0158, 1.0274, 1.0509,  &
1.0007, 1.0016, 1.0021, 1.0033, 1.0049, 1.0080, 1.0128, 1.0218, 1.0387 /
data ((supersat( 1,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0028, 1.0043, 1.0065, 1.0107, 1.0185, 1.0355, 1.0755, 1.1778, 1.4620,  &
1.0022, 1.0031, 1.0049, 1.0079, 1.0132, 1.0236, 1.0467, 1.1024, 1.2480,  &
1.0015, 1.0027, 1.0040, 1.0062, 1.0098, 1.0167, 1.0308, 1.0628, 1.1419,  &
1.0011, 1.0021, 1.0031, 1.0049, 1.0077, 1.0125, 1.0218, 1.0414, 1.0867,  &
1.0011, 1.0013, 1.0028, 1.0039, 1.0062, 1.0098, 1.0164, 1.0293, 1.0571,  &
1.0011, 1.0011, 1.0021, 1.0032, 1.0051, 1.0080, 1.0129, 1.0221, 1.0405,  &
1.0010, 1.0011, 1.0014, 1.0029, 1.0043, 1.0066, 1.0105, 1.0175, 1.0306 /
data ((supersat( 1,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0082, 1.0128, 1.0216, 1.0388, 1.0751, 1.1622, 1.4139, 2.7122, 4.9898,  &
1.0063, 1.0107, 1.0175, 1.0301, 1.0552, 1.1109, 1.2517, 1.7206, 4.0260,  &
1.0054, 1.0088, 1.0145, 1.0242, 1.0427, 1.0813, 1.1706, 1.4155, 2.5508,  &
1.0050, 1.0076, 1.0121, 1.0197, 1.0343, 1.0626, 1.1241, 1.2753, 1.7601,  &
1.0042, 1.0055, 1.0099, 1.0163, 1.0281, 1.0497, 1.0944, 1.1968, 1.4755,  &
1.0031, 1.0052, 1.0086, 1.0139, 1.0230, 1.0403, 1.0741, 1.1474, 1.3285,  &
1.0023, 1.0047, 1.0072, 1.0115, 1.0189, 1.0328, 1.0591, 1.1136, 1.2396 /
data ((supersat( 1,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0063, 1.0097, 1.0159, 1.0280, 1.0527, 1.1098, 1.2611, 1.8065, 3.7189,  &
1.0046, 1.0076, 1.0128, 1.0216, 1.0388, 1.0755, 1.1635, 1.4143, 2.5942,  &
1.0040, 1.0068, 1.0103, 1.0174, 1.0301, 1.0556, 1.1123, 1.2549, 1.7209,  &
1.0038, 1.0054, 1.0088, 1.0142, 1.0242, 1.0430, 1.0824, 1.1735, 1.4223,  &
1.0033, 1.0040, 1.0072, 1.0120, 1.0197, 1.0343, 1.0633, 1.1263, 1.2813,  &
1.0024, 1.0039, 1.0065, 1.0101, 1.0164, 1.0281, 1.0502, 1.0961, 1.2013,  &
1.0017, 1.0035, 1.0051, 1.0084, 1.0134, 1.0231, 1.0404, 1.0752, 1.1505 /
data ((supersat( 1,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0050, 1.0077, 1.0124, 1.0211, 1.0389, 1.0791, 1.1804, 1.4865, 2.7396,  &
1.0037, 1.0057, 1.0098, 1.0161, 1.0285, 1.0543, 1.1139, 1.2711, 1.8176,  &
1.0028, 1.0052, 1.0081, 1.0130, 1.0220, 1.0399, 1.0782, 1.1704, 1.4305,  &
1.0027, 1.0041, 1.0063, 1.0107, 1.0177, 1.0308, 1.0574, 1.1168, 1.2663,  &
1.0026, 1.0028, 1.0056, 1.0087, 1.0143, 1.0247, 1.0443, 1.0856, 1.1815,  &
1.0022, 1.0027, 1.0049, 1.0076, 1.0120, 1.0202, 1.0353, 1.0656, 1.1318,  &
1.0017, 1.0026, 1.0038, 1.0058, 1.0102, 1.0167, 1.0287, 1.0517, 1.0999 /
data ((supersat( 1,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0040, 1.0062, 1.0099, 1.0167, 1.0302, 1.0603, 1.1341, 1.3388, 2.0944,  &
1.0032, 1.0046, 1.0077, 1.0127, 1.0219, 1.0410, 1.0844, 1.1940, 1.5198,  &
1.0022, 1.0041, 1.0064, 1.0100, 1.0168, 1.0298, 1.0574, 1.1220, 1.2916,  &
1.0016, 1.0034, 1.0049, 1.0082, 1.0135, 1.0230, 1.0419, 1.0832, 1.1829,  &
1.0016, 1.0024, 1.0043, 1.0068, 1.0111, 1.0184, 1.0323, 1.0607, 1.1248,  &
1.0016, 1.0016, 1.0039, 1.0058, 1.0092, 1.0149, 1.0258, 1.0466, 1.0909,  &
1.0015, 1.0016, 1.0030, 1.0044, 1.0075, 1.0123, 1.0210, 1.0369, 1.0692 /
data ((supersat( 1,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0031, 1.0051, 1.0082, 1.0137, 1.0245, 1.0483, 1.1059, 1.2585, 1.7391,  &
1.0028, 1.0041, 1.0064, 1.0103, 1.0176, 1.0325, 1.0660, 1.1490, 1.3780,  &
1.0022, 1.0031, 1.0052, 1.0079, 1.0134, 1.0234, 1.0444, 1.0928, 1.2159,  &
1.0015, 1.0029, 1.0041, 1.0065, 1.0105, 1.0178, 1.0320, 1.0625, 1.1347,  &
1.0008, 1.0024, 1.0032, 1.0054, 1.0085, 1.0142, 1.0245, 1.0452, 1.0910,  &
1.0006, 1.0017, 1.0030, 1.0046, 1.0072, 1.0116, 1.0194, 1.0345, 1.0658,  &
1.0006, 1.0011, 1.0027, 1.0033, 1.0056, 1.0096, 1.0159, 1.0274, 1.0501 /
data ((supersat( 1,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0029, 1.0043, 1.0070, 1.0116, 1.0206, 1.0403, 1.0875, 1.2099, 1.5641,  &
1.0021, 1.0036, 1.0055, 1.0087, 1.0147, 1.0269, 1.0541, 1.1209, 1.2983,  &
1.0020, 1.0026, 1.0042, 1.0067, 1.0110, 1.0191, 1.0359, 1.0744, 1.1707,  &
1.0017, 1.0021, 1.0036, 1.0055, 1.0085, 1.0143, 1.0255, 1.0493, 1.1051,  &
1.0013, 1.0020, 1.0026, 1.0043, 1.0069, 1.0113, 1.0193, 1.0352, 1.0699,  &
1.0008, 1.0018, 1.0021, 1.0038, 1.0059, 1.0092, 1.0153, 1.0267, 1.0500,  &
1.0006, 1.0015, 1.0020, 1.0030, 1.0045, 1.0077, 1.0124, 1.0210, 1.0379 /
data ((supersat( 1,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0027, 1.0039, 1.0061, 1.0101, 1.0179, 1.0346, 1.0747, 1.1773, 1.4619,  &
1.0020, 1.0030, 1.0047, 1.0075, 1.0126, 1.0229, 1.0458, 1.1018, 1.2477,  &
1.0013, 1.0025, 1.0036, 1.0058, 1.0094, 1.0161, 1.0301, 1.0620, 1.1413,  &
1.0011, 1.0018, 1.0030, 1.0047, 1.0072, 1.0120, 1.0211, 1.0406, 1.0860,  &
1.0011, 1.0011, 1.0026, 1.0035, 1.0058, 1.0094, 1.0158, 1.0285, 1.0563,  &
1.0010, 1.0011, 1.0018, 1.0031, 1.0049, 1.0075, 1.0124, 1.0214, 1.0398,  &
1.0010, 1.0011, 1.0012, 1.0028, 1.0039, 1.0063, 1.0101, 1.0169, 1.0299 /
data ((supersat( 1,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0079, 1.0122, 1.0211, 1.0380, 1.0742, 1.1614, 1.4133, 2.7115, 4.9893,  &
1.0057, 1.0102, 1.0170, 1.0294, 1.0544, 1.1100, 1.2510, 1.7200, 4.0248,  &
1.0053, 1.0086, 1.0140, 1.0236, 1.0419, 1.0804, 1.1697, 1.4147, 2.5497,  &
1.0048, 1.0072, 1.0118, 1.0191, 1.0335, 1.0617, 1.1231, 1.2743, 1.7589,  &
1.0039, 1.0054, 1.0093, 1.0158, 1.0274, 1.0488, 1.0934, 1.1957, 1.4742,  &
1.0027, 1.0051, 1.0083, 1.0133, 1.0223, 1.0394, 1.0730, 1.1461, 1.3270,  &
1.0020, 1.0044, 1.0068, 1.0111, 1.0183, 1.0319, 1.0580, 1.1122, 1.2379 /
data ((supersat( 1,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0060, 1.0094, 1.0155, 1.0273, 1.0519, 1.1090, 1.2605, 1.8061, 3.7184,  &
1.0041, 1.0072, 1.0125, 1.0211, 1.0381, 1.0747, 1.1628, 1.4138, 2.5935,  &
1.0040, 1.0065, 1.0101, 1.0168, 1.0295, 1.0548, 1.1115, 1.2541, 1.7202,  &
1.0036, 1.0050, 1.0084, 1.0136, 1.0236, 1.0423, 1.0815, 1.1727, 1.4215,  &
1.0030, 1.0040, 1.0071, 1.0115, 1.0193, 1.0337, 1.0625, 1.1254, 1.2803,  &
1.0022, 1.0038, 1.0062, 1.0098, 1.0160, 1.0275, 1.0493, 1.0951, 1.2002,  &
1.0016, 1.0034, 1.0047, 1.0079, 1.0131, 1.0223, 1.0397, 1.0741, 1.1493 /
data ((supersat( 1,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0047, 1.0074, 1.0119, 1.0205, 1.0382, 1.0783, 1.1799, 1.4862, 2.7394,  &
1.0033, 1.0057, 1.0094, 1.0157, 1.0279, 1.0535, 1.1132, 1.2706, 1.8173,  &
1.0028, 1.0050, 1.0078, 1.0126, 1.0214, 1.0392, 1.0775, 1.1697, 1.4300,  &
1.0027, 1.0038, 1.0059, 1.0104, 1.0171, 1.0302, 1.0567, 1.1161, 1.2657,  &
1.0025, 1.0027, 1.0055, 1.0085, 1.0140, 1.0242, 1.0436, 1.0848, 1.1807,  &
1.0021, 1.0027, 1.0047, 1.0073, 1.0115, 1.0196, 1.0347, 1.0647, 1.1309,  &
1.0016, 1.0025, 1.0035, 1.0056, 1.0098, 1.0163, 1.0280, 1.0509, 1.0989 /
data ((supersat( 1,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0039, 1.0060, 1.0094, 1.0162, 1.0296, 1.0596, 1.1336, 1.3384, 2.0942,  &
1.0030, 1.0044, 1.0073, 1.0123, 1.0214, 1.0403, 1.0837, 1.1936, 1.5196,  &
1.0018, 1.0040, 1.0061, 1.0095, 1.0163, 1.0292, 1.0568, 1.1214, 1.2912,  &
1.0016, 1.0032, 1.0045, 1.0079, 1.0131, 1.0225, 1.0412, 1.0825, 1.1824,  &
1.0016, 1.0021, 1.0042, 1.0067, 1.0107, 1.0179, 1.0317, 1.0600, 1.1242,  &
1.0016, 1.0016, 1.0037, 1.0055, 1.0089, 1.0145, 1.0252, 1.0459, 1.0901,  &
1.0014, 1.0016, 1.0028, 1.0043, 1.0070, 1.0119, 1.0205, 1.0362, 1.0684 /
data ((supersat( 1,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0030, 1.0050, 1.0078, 1.0132, 1.0239, 1.0477, 1.1054, 1.2583, 1.7388,  &
1.0027, 1.0037, 1.0060, 1.0099, 1.0171, 1.0319, 1.0654, 1.1486, 1.3778,  &
1.0020, 1.0031, 1.0050, 1.0077, 1.0130, 1.0229, 1.0437, 1.0923, 1.2155,  &
1.0012, 1.0028, 1.0038, 1.0062, 1.0101, 1.0174, 1.0314, 1.0619, 1.1341,  &
1.0007, 1.0022, 1.0032, 1.0053, 1.0081, 1.0138, 1.0239, 1.0446, 1.0903,  &
1.0006, 1.0014, 1.0030, 1.0043, 1.0070, 1.0112, 1.0189, 1.0339, 1.0651,  &
1.0006, 1.0010, 1.0025, 1.0032, 1.0055, 1.0093, 1.0154, 1.0268, 1.0494 /
data ((supersat( 1,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0026, 1.0041, 1.0067, 1.0111, 1.0201, 1.0397, 1.0871, 1.2096, 1.5640,  &
1.0021, 1.0034, 1.0052, 1.0083, 1.0142, 1.0263, 1.0535, 1.1204, 1.2980,  &
1.0019, 1.0023, 1.0041, 1.0063, 1.0106, 1.0186, 1.0353, 1.0738, 1.1703,  &
1.0016, 1.0021, 1.0034, 1.0052, 1.0083, 1.0139, 1.0250, 1.0487, 1.1047,  &
1.0011, 1.0020, 1.0023, 1.0042, 1.0065, 1.0109, 1.0188, 1.0346, 1.0694,  &
1.0007, 1.0017, 1.0021, 1.0037, 1.0056, 1.0088, 1.0148, 1.0261, 1.0494,  &
1.0005, 1.0013, 1.0020, 1.0028, 1.0043, 1.0073, 1.0121, 1.0205, 1.0373 /
data ((supersat( 1,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0025, 1.0037, 1.0059, 1.0097, 1.0174, 1.0341, 1.0743, 1.1771, 1.4618,  &
1.0018, 1.0029, 1.0045, 1.0072, 1.0122, 1.0224, 1.0453, 1.1014, 1.2475,  &
1.0011, 1.0024, 1.0033, 1.0055, 1.0090, 1.0157, 1.0295, 1.0615, 1.1410,  &
1.0011, 1.0016, 1.0030, 1.0045, 1.0069, 1.0116, 1.0207, 1.0400, 1.0856,  &
1.0011, 1.0011, 1.0024, 1.0032, 1.0055, 1.0090, 1.0154, 1.0280, 1.0558,  &
1.0010, 1.0011, 1.0016, 1.0030, 1.0047, 1.0072, 1.0121, 1.0209, 1.0392,  &
1.0009, 1.0011, 1.0011, 1.0026, 1.0036, 1.0060, 1.0098, 1.0164, 1.0293 /
data ((supersat( 2,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0088, 1.0144, 1.0236, 1.0409, 1.0772, 1.1637, 1.4149, 2.7106, 4.9892,  &
1.0077, 1.0118, 1.0189, 1.0318, 1.0574, 1.1129, 1.2531, 1.7215, 4.0259,  &
1.0055, 1.0095, 1.0157, 1.0258, 1.0448, 1.0835, 1.1725, 1.4172, 2.5508,  &
1.0054, 1.0086, 1.0128, 1.0215, 1.0361, 1.0649, 1.1263, 1.2773, 1.7625,  &
1.0050, 1.0071, 1.0113, 1.0182, 1.0298, 1.0521, 1.0970, 1.1993, 1.4787,  &
1.0041, 1.0054, 1.0091, 1.0154, 1.0252, 1.0427, 1.0769, 1.1504, 1.3322,  &
1.0030, 1.0052, 1.0084, 1.0125, 1.0212, 1.0354, 1.0623, 1.1171, 1.2437 /
data ((supersat( 2,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0069, 1.0108, 1.0176, 1.0299, 1.0548, 1.1114, 1.2620, 1.8062, 3.7179,  &
1.0058, 1.0090, 1.0141, 1.0233, 1.0408, 1.0775, 1.1649, 1.4154, 2.5938,  &
1.0040, 1.0072, 1.0116, 1.0189, 1.0319, 1.0577, 1.1141, 1.2562, 1.7218,  &
1.0040, 1.0065, 1.0099, 1.0157, 1.0257, 1.0451, 1.0845, 1.1753, 1.4241,  &
1.0038, 1.0050, 1.0080, 1.0132, 1.0215, 1.0364, 1.0656, 1.1285, 1.2834,  &
1.0033, 1.0040, 1.0071, 1.0108, 1.0180, 1.0300, 1.0526, 1.0986, 1.2039,  &
1.0025, 1.0039, 1.0063, 1.0097, 1.0153, 1.0251, 1.0430, 1.0780, 1.1536 /
data ((supersat( 2,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0055, 1.0084, 1.0136, 1.0228, 1.0409, 1.0808, 1.1813, 1.4869, 2.7389,  &
1.0047, 1.0070, 1.0109, 1.0178, 1.0304, 1.0562, 1.1154, 1.2719, 1.8176,  &
1.0034, 1.0057, 1.0086, 1.0140, 1.0237, 1.0417, 1.0800, 1.1717, 1.4315,  &
1.0028, 1.0050, 1.0076, 1.0115, 1.0191, 1.0325, 1.0594, 1.1186, 1.2677,  &
1.0027, 1.0038, 1.0058, 1.0099, 1.0159, 1.0264, 1.0462, 1.0875, 1.1832,  &
1.0026, 1.0028, 1.0055, 1.0085, 1.0134, 1.0219, 1.0373, 1.0678, 1.1340,  &
1.0023, 1.0027, 1.0048, 1.0072, 1.0113, 1.0183, 1.0307, 1.0542, 1.1024 /
data ((supersat( 2,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0043, 1.0069, 1.0110, 1.0182, 1.0321, 1.0620, 1.1352, 1.3393, 2.0938,  &
1.0039, 1.0057, 1.0088, 1.0139, 1.0236, 1.0429, 1.0859, 1.1949, 1.5202,  &
1.0031, 1.0044, 1.0069, 1.0112, 1.0183, 1.0316, 1.0592, 1.1233, 1.2925,  &
1.0020, 1.0040, 1.0060, 1.0092, 1.0145, 1.0245, 1.0437, 1.0849, 1.1841,  &
1.0016, 1.0033, 1.0045, 1.0073, 1.0120, 1.0197, 1.0340, 1.0626, 1.1265,  &
1.0016, 1.0022, 1.0043, 1.0066, 1.0099, 1.0164, 1.0274, 1.0485, 1.0929,  &
1.0016, 1.0016, 1.0038, 1.0054, 1.0087, 1.0138, 1.0225, 1.0390, 1.0715 /
data ((supersat( 2,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0040, 1.0060, 1.0093, 1.0151, 1.0263, 1.0500, 1.1070, 1.2591, 1.7385,  &
1.0031, 1.0048, 1.0073, 1.0115, 1.0192, 1.0343, 1.0676, 1.1499, 1.3785,  &
1.0028, 1.0036, 1.0056, 1.0091, 1.0146, 1.0250, 1.0461, 1.0942, 1.2167,  &
1.0022, 1.0031, 1.0049, 1.0074, 1.0117, 1.0192, 1.0337, 1.0642, 1.1358,  &
1.0014, 1.0029, 1.0037, 1.0058, 1.0096, 1.0154, 1.0260, 1.0470, 1.0926,  &
1.0008, 1.0023, 1.0032, 1.0053, 1.0079, 1.0126, 1.0209, 1.0363, 1.0676,  &
1.0006, 1.0016, 1.0030, 1.0043, 1.0068, 1.0104, 1.0171, 1.0291, 1.0521 /
data ((supersat( 2,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0036, 1.0053, 1.0079, 1.0129, 1.0223, 1.0420, 1.0887, 1.2104, 1.5640,  &
1.0027, 1.0041, 1.0061, 1.0097, 1.0161, 1.0285, 1.0556, 1.1217, 1.2987,  &
1.0021, 1.0034, 1.0049, 1.0077, 1.0122, 1.0206, 1.0375, 1.0757, 1.1714,  &
1.0020, 1.0024, 1.0041, 1.0062, 1.0096, 1.0157, 1.0271, 1.0509, 1.1063,  &
1.0017, 1.0021, 1.0034, 1.0049, 1.0079, 1.0124, 1.0207, 1.0368, 1.0715,  &
1.0013, 1.0020, 1.0023, 1.0043, 1.0064, 1.0102, 1.0165, 1.0282, 1.0518,  &
1.0009, 1.0018, 1.0021, 1.0037, 1.0055, 1.0085, 1.0136, 1.0226, 1.0397 /
data ((supersat( 2,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0030, 1.0046, 1.0071, 1.0113, 1.0194, 1.0362, 1.0759, 1.1778, 1.4619,  &
1.0026, 1.0035, 1.0054, 1.0085, 1.0139, 1.0245, 1.0473, 1.1027, 1.2481,  &
1.0019, 1.0030, 1.0044, 1.0066, 1.0104, 1.0175, 1.0317, 1.0634, 1.1421,  &
1.0012, 1.0024, 1.0032, 1.0051, 1.0082, 1.0132, 1.0226, 1.0421, 1.0872,  &
1.0011, 1.0017, 1.0030, 1.0044, 1.0066, 1.0104, 1.0171, 1.0301, 1.0578,  &
1.0011, 1.0011, 1.0025, 1.0032, 1.0053, 1.0085, 1.0136, 1.0229, 1.0414,  &
1.0011, 1.0011, 1.0018, 1.0031, 1.0047, 1.0070, 1.0110, 1.0182, 1.0315 /
data ((supersat( 2,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0081, 1.0127, 1.0215, 1.0385, 1.0746, 1.1615, 1.4134, 2.7094, 4.9882,  &
1.0062, 1.0106, 1.0174, 1.0299, 1.0549, 1.1104, 1.2511, 1.7197, 4.0229,  &
1.0054, 1.0088, 1.0144, 1.0241, 1.0425, 1.0809, 1.1700, 1.4151, 2.5481,  &
1.0050, 1.0076, 1.0120, 1.0196, 1.0341, 1.0623, 1.1235, 1.2747, 1.7593,  &
1.0042, 1.0055, 1.0098, 1.0162, 1.0279, 1.0494, 1.0940, 1.1962, 1.4753,  &
1.0031, 1.0052, 1.0085, 1.0138, 1.0229, 1.0401, 1.0738, 1.1469, 1.3282,  &
1.0022, 1.0047, 1.0072, 1.0115, 1.0188, 1.0327, 1.0589, 1.1132, 1.2391 /
data ((supersat( 2,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0062, 1.0097, 1.0158, 1.0278, 1.0523, 1.1092, 1.2606, 1.8052, 3.7167,  &
1.0045, 1.0075, 1.0128, 1.0215, 1.0386, 1.0751, 1.1630, 1.4139, 2.5918,  &
1.0040, 1.0067, 1.0103, 1.0173, 1.0299, 1.0553, 1.1118, 1.2544, 1.7201,  &
1.0038, 1.0054, 1.0088, 1.0141, 1.0241, 1.0428, 1.0820, 1.1730, 1.4220,  &
1.0033, 1.0040, 1.0072, 1.0120, 1.0196, 1.0342, 1.0630, 1.1259, 1.2809,  &
1.0025, 1.0039, 1.0065, 1.0100, 1.0164, 1.0280, 1.0500, 1.0957, 1.2008,  &
1.0018, 1.0036, 1.0051, 1.0084, 1.0134, 1.0230, 1.0403, 1.0749, 1.1501 /
data ((supersat( 2,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0049, 1.0076, 1.0123, 1.0210, 1.0386, 1.0786, 1.1799, 1.4863, 2.7380,  &
1.0037, 1.0057, 1.0098, 1.0161, 1.0283, 1.0539, 1.1134, 1.2707, 1.8165,  &
1.0028, 1.0052, 1.0080, 1.0130, 1.0219, 1.0396, 1.0778, 1.1699, 1.4302,  &
1.0027, 1.0041, 1.0063, 1.0107, 1.0176, 1.0307, 1.0571, 1.1164, 1.2660,  &
1.0026, 1.0027, 1.0056, 1.0086, 1.0143, 1.0246, 1.0441, 1.0852, 1.1810,  &
1.0022, 1.0027, 1.0049, 1.0076, 1.0119, 1.0201, 1.0352, 1.0653, 1.1314,  &
1.0017, 1.0026, 1.0038, 1.0058, 1.0102, 1.0166, 1.0286, 1.0516, 1.0995 /
data ((supersat( 2,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0040, 1.0062, 1.0098, 1.0166, 1.0300, 1.0599, 1.1337, 1.3386, 2.0929,  &
1.0032, 1.0046, 1.0077, 1.0127, 1.0218, 1.0407, 1.0840, 1.1937, 1.5194,  &
1.0022, 1.0041, 1.0064, 1.0099, 1.0167, 1.0296, 1.0571, 1.1216, 1.2913,  &
1.0016, 1.0034, 1.0048, 1.0082, 1.0134, 1.0229, 1.0417, 1.0829, 1.1826,  &
1.0016, 1.0024, 1.0043, 1.0068, 1.0110, 1.0183, 1.0321, 1.0605, 1.1245,  &
1.0016, 1.0016, 1.0039, 1.0057, 1.0092, 1.0149, 1.0257, 1.0464, 1.0906,  &
1.0015, 1.0016, 1.0031, 1.0044, 1.0074, 1.0122, 1.0210, 1.0368, 1.0690 /
data ((supersat( 2,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0031, 1.0051, 1.0082, 1.0136, 1.0244, 1.0480, 1.1055, 1.2583, 1.7380,  &
1.0028, 1.0040, 1.0064, 1.0103, 1.0175, 1.0323, 1.0657, 1.1487, 1.3778,  &
1.0022, 1.0031, 1.0052, 1.0079, 1.0133, 1.0232, 1.0441, 1.0925, 1.2156,  &
1.0015, 1.0029, 1.0041, 1.0065, 1.0104, 1.0177, 1.0318, 1.0622, 1.1343,  &
1.0008, 1.0024, 1.0032, 1.0054, 1.0085, 1.0141, 1.0243, 1.0450, 1.0907,  &
1.0006, 1.0016, 1.0030, 1.0046, 1.0072, 1.0116, 1.0193, 1.0344, 1.0656,  &
1.0006, 1.0011, 1.0027, 1.0033, 1.0056, 1.0096, 1.0158, 1.0273, 1.0499 /
data ((supersat( 2,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0029, 1.0043, 1.0070, 1.0115, 1.0205, 1.0401, 1.0872, 1.2097, 1.5636,  &
1.0021, 1.0036, 1.0054, 1.0086, 1.0146, 1.0267, 1.0538, 1.1205, 1.2981,  &
1.0019, 1.0026, 1.0042, 1.0066, 1.0110, 1.0189, 1.0356, 1.0741, 1.1704,  &
1.0017, 1.0021, 1.0036, 1.0054, 1.0084, 1.0143, 1.0254, 1.0491, 1.1048,  &
1.0013, 1.0020, 1.0025, 1.0043, 1.0068, 1.0113, 1.0192, 1.0350, 1.0697,  &
1.0008, 1.0018, 1.0021, 1.0038, 1.0059, 1.0091, 1.0152, 1.0266, 1.0498,  &
1.0006, 1.0015, 1.0020, 1.0030, 1.0045, 1.0077, 1.0124, 1.0210, 1.0377 /
data ((supersat( 2,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0027, 1.0039, 1.0061, 1.0101, 1.0177, 1.0345, 1.0744, 1.1771, 1.4615,  &
1.0020, 1.0030, 1.0047, 1.0075, 1.0125, 1.0227, 1.0456, 1.1015, 1.2475,  &
1.0012, 1.0025, 1.0036, 1.0058, 1.0093, 1.0160, 1.0299, 1.0618, 1.1411,  &
1.0011, 1.0018, 1.0030, 1.0047, 1.0072, 1.0119, 1.0210, 1.0404, 1.0857,  &
1.0011, 1.0011, 1.0026, 1.0035, 1.0058, 1.0093, 1.0157, 1.0284, 1.0561,  &
1.0011, 1.0011, 1.0018, 1.0031, 1.0049, 1.0075, 1.0124, 1.0213, 1.0396,  &
1.0010, 1.0011, 1.0012, 1.0027, 1.0039, 1.0063, 1.0101, 1.0168, 1.0298 /
data ((supersat( 2,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0071, 1.0117, 1.0201, 1.0365, 1.0725, 1.1598, 1.4122, 2.7076, 4.9868,  &
1.0054, 1.0091, 1.0157, 1.0280, 1.0527, 1.1083, 1.2495, 1.7181, 4.0203,  &
1.0051, 1.0081, 1.0128, 1.0222, 1.0404, 1.0786, 1.1679, 1.4132, 2.5450,  &
1.0044, 1.0063, 1.0110, 1.0183, 1.0320, 1.0599, 1.1211, 1.2724, 1.7561,  &
1.0032, 1.0053, 1.0087, 1.0151, 1.0258, 1.0471, 1.0913, 1.1934, 1.4718,  &
1.0023, 1.0047, 1.0076, 1.0121, 1.0212, 1.0377, 1.0708, 1.1435, 1.3242,  &
1.0018, 1.0038, 1.0058, 1.0101, 1.0172, 1.0302, 1.0557, 1.1093, 1.2343 /
data ((supersat( 2,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0052, 1.0087, 1.0146, 1.0260, 1.0504, 1.1075, 1.2595, 1.8043, 3.7158,  &
1.0040, 1.0070, 1.0117, 1.0200, 1.0367, 1.0732, 1.1614, 1.4128, 2.5904,  &
1.0038, 1.0059, 1.0096, 1.0159, 1.0282, 1.0533, 1.1099, 1.2529, 1.7184,  &
1.0033, 1.0041, 1.0074, 1.0130, 1.0223, 1.0409, 1.0799, 1.1711, 1.4202,  &
1.0025, 1.0039, 1.0067, 1.0104, 1.0184, 1.0324, 1.0608, 1.1235, 1.2785,  &
1.0018, 1.0036, 1.0055, 1.0091, 1.0151, 1.0261, 1.0477, 1.0930, 1.1980,  &
1.0014, 1.0030, 1.0040, 1.0069, 1.0123, 1.0212, 1.0379, 1.0719, 1.1467 /
data ((supersat( 2,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0042, 1.0067, 1.0109, 1.0195, 1.0369, 1.0769, 1.1788, 1.4853, 2.7372,  &
1.0028, 1.0054, 1.0085, 1.0149, 1.0267, 1.0521, 1.1119, 1.2697, 1.8156,  &
1.0027, 1.0045, 1.0072, 1.0117, 1.0205, 1.0378, 1.0760, 1.1685, 1.4290,  &
1.0026, 1.0030, 1.0057, 1.0096, 1.0163, 1.0290, 1.0553, 1.1147, 1.2645,  &
1.0022, 1.0027, 1.0051, 1.0081, 1.0134, 1.0231, 1.0422, 1.0831, 1.1791,  &
1.0017, 1.0026, 1.0040, 1.0065, 1.0109, 1.0187, 1.0333, 1.0631, 1.1290,  &
1.0013, 1.0023, 1.0029, 1.0053, 1.0088, 1.0153, 1.0267, 1.0492, 1.0968 /
data ((supersat( 2,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0035, 1.0054, 1.0087, 1.0151, 1.0283, 1.0583, 1.1326, 1.3379, 2.0924,  &
1.0024, 1.0042, 1.0067, 1.0114, 1.0203, 1.0390, 1.0825, 1.1927, 1.5187,  &
1.0016, 1.0036, 1.0055, 1.0090, 1.0155, 1.0281, 1.0555, 1.1202, 1.2905,  &
1.0016, 1.0026, 1.0044, 1.0070, 1.0121, 1.0213, 1.0400, 1.0812, 1.1812,  &
1.0016, 1.0016, 1.0040, 1.0062, 1.0098, 1.0169, 1.0304, 1.0587, 1.1228,  &
1.0015, 1.0016, 1.0032, 1.0047, 1.0083, 1.0138, 1.0240, 1.0445, 1.0885,  &
1.0013, 1.0015, 1.0023, 1.0041, 1.0067, 1.0113, 1.0192, 1.0349, 1.0667 /
data ((supersat( 2,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0029, 1.0045, 1.0072, 1.0124, 1.0228, 1.0464, 1.1045, 1.2578, 1.7376,  &
1.0024, 1.0032, 1.0054, 1.0092, 1.0162, 1.0307, 1.0642, 1.1478, 1.3772,  &
1.0016, 1.0029, 1.0045, 1.0073, 1.0121, 1.0218, 1.0425, 1.0912, 1.2148,  &
1.0009, 1.0025, 1.0032, 1.0056, 1.0096, 1.0164, 1.0303, 1.0607, 1.1332,  &
1.0006, 1.0018, 1.0031, 1.0049, 1.0077, 1.0130, 1.0229, 1.0433, 1.0891,  &
1.0006, 1.0011, 1.0027, 1.0037, 1.0063, 1.0104, 1.0181, 1.0327, 1.0638,  &
1.0006, 1.0009, 1.0021, 1.0030, 1.0052, 1.0086, 1.0144, 1.0256, 1.0480 /
data ((supersat( 2,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0021, 1.0038, 1.0060, 1.0104, 1.0190, 1.0385, 1.0861, 1.2092, 1.5632,  &
1.0019, 1.0029, 1.0046, 1.0077, 1.0133, 1.0252, 1.0524, 1.1197, 1.2977,  &
1.0017, 1.0021, 1.0038, 1.0060, 1.0099, 1.0176, 1.0342, 1.0728, 1.1697,  &
1.0013, 1.0020, 1.0029, 1.0045, 1.0078, 1.0132, 1.0240, 1.0476, 1.1037,  &
1.0009, 1.0018, 1.0021, 1.0040, 1.0062, 1.0103, 1.0179, 1.0335, 1.0682,  &
1.0006, 1.0015, 1.0020, 1.0032, 1.0051, 1.0083, 1.0141, 1.0251, 1.0482,  &
1.0005, 1.0011, 1.0018, 1.0023, 1.0041, 1.0066, 1.0113, 1.0196, 1.0360 /
data ((supersat( 2,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0022, 1.0032, 1.0053, 1.0090, 1.0164, 1.0330, 1.0734, 1.1767, 1.4612,  &
1.0014, 1.0027, 1.0041, 1.0065, 1.0114, 1.0213, 1.0443, 1.1007, 1.2471,  &
1.0011, 1.0020, 1.0031, 1.0050, 1.0083, 1.0148, 1.0285, 1.0606, 1.1404,  &
1.0011, 1.0012, 1.0027, 1.0040, 1.0065, 1.0109, 1.0197, 1.0390, 1.0847,  &
1.0010, 1.0011, 1.0020, 1.0032, 1.0051, 1.0085, 1.0146, 1.0270, 1.0548,  &
1.0010, 1.0011, 1.0013, 1.0028, 1.0043, 1.0068, 1.0114, 1.0201, 1.0381,  &
1.0008, 1.0010, 1.0011, 1.0023, 1.0031, 1.0054, 1.0090, 1.0156, 1.0282 /
data ((supersat( 2,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0059, 1.0108, 1.0186, 1.0349, 1.0709, 1.1586, 1.4111, 2.7062, 4.9856,  &
1.0052, 1.0086, 1.0148, 1.0266, 1.0510, 1.1067, 1.2482, 1.7167, 4.0174,  &
1.0046, 1.0072, 1.0119, 1.0210, 1.0387, 1.0768, 1.1662, 1.4114, 2.5421,  &
1.0035, 1.0053, 1.0097, 1.0170, 1.0304, 1.0579, 1.1190, 1.2702, 1.7529,  &
1.0024, 1.0049, 1.0081, 1.0138, 1.0243, 1.0449, 1.0889, 1.1907, 1.4680,  &
1.0018, 1.0040, 1.0064, 1.0110, 1.0194, 1.0354, 1.0681, 1.1403, 1.3200,  &
1.0016, 1.0030, 1.0046, 1.0084, 1.0151, 1.0276, 1.0526, 1.1055, 1.2294 /
data ((supersat( 2,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0041, 1.0076, 1.0134, 1.0247, 1.0489, 1.1063, 1.2587, 1.8037, 3.7146,  &
1.0039, 1.0065, 1.0104, 1.0186, 1.0352, 1.0717, 1.1603, 1.4118, 2.5889,  &
1.0035, 1.0049, 1.0087, 1.0149, 1.0267, 1.0517, 1.1084, 1.2516, 1.7170,  &
1.0027, 1.0040, 1.0070, 1.0121, 1.0211, 1.0392, 1.0781, 1.1694, 1.4182,  &
1.0019, 1.0036, 1.0060, 1.0098, 1.0169, 1.0306, 1.0588, 1.1215, 1.2763,  &
1.0014, 1.0031, 1.0044, 1.0079, 1.0136, 1.0243, 1.0455, 1.0906, 1.1952,  &
1.0012, 1.0023, 1.0034, 1.0062, 1.0109, 1.0193, 1.0356, 1.0691, 1.1433 /
data ((supersat( 2,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0033, 1.0056, 1.0101, 1.0182, 1.0354, 1.0758, 1.1781, 1.4847, 2.7361,  &
1.0027, 1.0049, 1.0080, 1.0137, 1.0253, 1.0507, 1.1109, 1.2690, 1.8149,  &
1.0026, 1.0036, 1.0062, 1.0108, 1.0192, 1.0364, 1.0747, 1.1675, 1.4280,  &
1.0023, 1.0027, 1.0054, 1.0085, 1.0152, 1.0276, 1.0537, 1.1133, 1.2633,  &
1.0018, 1.0026, 1.0044, 1.0073, 1.0123, 1.0216, 1.0406, 1.0815, 1.1775,  &
1.0013, 1.0023, 1.0032, 1.0055, 1.0100, 1.0173, 1.0316, 1.0611, 1.1270,  &
1.0011, 1.0019, 1.0024, 1.0047, 1.0078, 1.0137, 1.0249, 1.0470, 1.0943 /
data ((supersat( 2,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0028, 1.0044, 1.0080, 1.0141, 1.0270, 1.0571, 1.1319, 1.3374, 2.0920,  &
1.0017, 1.0039, 1.0062, 1.0106, 1.0191, 1.0377, 1.0815, 1.1921, 1.5182,  &
1.0016, 1.0030, 1.0046, 1.0083, 1.0144, 1.0268, 1.0542, 1.1193, 1.2898,  &
1.0016, 1.0019, 1.0041, 1.0067, 1.0113, 1.0202, 1.0386, 1.0800, 1.1802,  &
1.0015, 1.0016, 1.0035, 1.0054, 1.0091, 1.0159, 1.0291, 1.0572, 1.1214,  &
1.0013, 1.0015, 1.0026, 1.0042, 1.0072, 1.0127, 1.0227, 1.0429, 1.0868,  &
1.0010, 1.0013, 1.0018, 1.0036, 1.0060, 1.0102, 1.0179, 1.0330, 1.0647 /
data ((supersat( 2,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0025, 1.0038, 1.0065, 1.0113, 1.0216, 1.0453, 1.1038, 1.2575, 1.7374,  &
1.0018, 1.0030, 1.0050, 1.0084, 1.0150, 1.0295, 1.0633, 1.1472, 1.3767,  &
1.0011, 1.0026, 1.0038, 1.0066, 1.0112, 1.0206, 1.0413, 1.0903, 1.2143,  &
1.0006, 1.0019, 1.0031, 1.0053, 1.0088, 1.0154, 1.0290, 1.0595, 1.1323,  &
1.0006, 1.0012, 1.0028, 1.0042, 1.0071, 1.0120, 1.0217, 1.0420, 1.0879,  &
1.0006, 1.0009, 1.0022, 1.0031, 1.0054, 1.0096, 1.0168, 1.0313, 1.0623,  &
1.0005, 1.0008, 1.0017, 1.0028, 1.0046, 1.0075, 1.0134, 1.0241, 1.0462 /
data ((supersat( 2,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0020, 1.0034, 1.0055, 1.0094, 1.0179, 1.0375, 1.0855, 1.2089, 1.5629,  &
1.0018, 1.0022, 1.0041, 1.0070, 1.0124, 1.0240, 1.0514, 1.1191, 1.2973,  &
1.0014, 1.0020, 1.0033, 1.0054, 1.0091, 1.0165, 1.0330, 1.0720, 1.1692,  &
1.0009, 1.0019, 1.0022, 1.0042, 1.0070, 1.0122, 1.0228, 1.0465, 1.1030,  &
1.0006, 1.0015, 1.0020, 1.0035, 1.0057, 1.0095, 1.0169, 1.0323, 1.0672,  &
1.0005, 1.0011, 1.0019, 1.0026, 1.0042, 1.0076, 1.0131, 1.0238, 1.0469,  &
1.0005, 1.0009, 1.0015, 1.0019, 1.0037, 1.0060, 1.0102, 1.0183, 1.0345 /
data ((supersat( 2,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0017, 1.0029, 1.0046, 1.0081, 1.0154, 1.0320, 1.0728, 1.1764, 1.4610,  &
1.0011, 1.0023, 1.0035, 1.0060, 1.0105, 1.0203, 1.0434, 1.1002, 1.2468,  &
1.0011, 1.0014, 1.0029, 1.0046, 1.0077, 1.0138, 1.0275, 1.0598, 1.1400,  &
1.0010, 1.0011, 1.0023, 1.0033, 1.0059, 1.0100, 1.0187, 1.0380, 1.0840,  &
1.0009, 1.0011, 1.0015, 1.0029, 1.0047, 1.0078, 1.0136, 1.0259, 1.0538,  &
1.0008, 1.0010, 1.0011, 1.0024, 1.0036, 1.0062, 1.0104, 1.0189, 1.0369,  &
1.0006, 1.0009, 1.0010, 1.0018, 1.0029, 1.0048, 1.0082, 1.0145, 1.0269 /
data ((supersat( 2,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0054, 1.0102, 1.0179, 1.0342, 1.0701, 1.1580, 1.4107, 2.7056, 4.9849,  &
1.0050, 1.0083, 1.0143, 1.0258, 1.0502, 1.1060, 1.2476, 1.7159, 4.0157,  &
1.0042, 1.0066, 1.0115, 1.0203, 1.0378, 1.0759, 1.1654, 1.4104, 2.5402,  &
1.0030, 1.0052, 1.0088, 1.0161, 1.0295, 1.0569, 1.1179, 1.2690, 1.7510,  &
1.0021, 1.0045, 1.0076, 1.0130, 1.0233, 1.0438, 1.0876, 1.1892, 1.4658,  &
1.0017, 1.0035, 1.0057, 1.0103, 1.0182, 1.0340, 1.0665, 1.1384, 1.3174,  &
1.0014, 1.0025, 1.0040, 1.0075, 1.0139, 1.0262, 1.0508, 1.1032, 1.2263 /
data ((supersat( 2,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0040, 1.0071, 1.0127, 1.0240, 1.0482, 1.1058, 1.2583, 1.8034, 3.7142,  &
1.0037, 1.0061, 1.0100, 1.0181, 1.0344, 1.0710, 1.1598, 1.4113, 2.5881,  &
1.0032, 1.0043, 1.0081, 1.0143, 1.0261, 1.0509, 1.1077, 1.2510, 1.7161,  &
1.0023, 1.0038, 1.0067, 1.0115, 1.0204, 1.0383, 1.0772, 1.1686, 1.4171,  &
1.0016, 1.0034, 1.0055, 1.0093, 1.0160, 1.0298, 1.0578, 1.1204, 1.2750,  &
1.0013, 1.0027, 1.0039, 1.0071, 1.0127, 1.0234, 1.0443, 1.0892, 1.1936,  &
1.0011, 1.0020, 1.0030, 1.0056, 1.0100, 1.0181, 1.0343, 1.0674, 1.1413 /
data ((supersat( 2,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0028, 1.0055, 1.0097, 1.0175, 1.0348, 1.0753, 1.1778, 1.4845, 2.7361,  &
1.0026, 1.0046, 1.0076, 1.0132, 1.0247, 1.0501, 1.1104, 1.2686, 1.8146,  &
1.0025, 1.0031, 1.0057, 1.0104, 1.0185, 1.0357, 1.0741, 1.1670, 1.4275,  &
1.0020, 1.0027, 1.0051, 1.0083, 1.0146, 1.0269, 1.0530, 1.1126, 1.2626,  &
1.0015, 1.0025, 1.0040, 1.0068, 1.0116, 1.0209, 1.0397, 1.0806, 1.1766,  &
1.0011, 1.0021, 1.0028, 1.0052, 1.0094, 1.0165, 1.0307, 1.0600, 1.1258,  &
1.0010, 1.0016, 1.0022, 1.0043, 1.0073, 1.0129, 1.0238, 1.0458, 1.0929 /
data ((supersat( 2,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0025, 1.0042, 1.0075, 1.0135, 1.0264, 1.0566, 1.1316, 1.3372, 2.0921,  &
1.0016, 1.0036, 1.0059, 1.0101, 1.0186, 1.0372, 1.0810, 1.1918, 1.5178,  &
1.0016, 1.0026, 1.0043, 1.0079, 1.0138, 1.0262, 1.0536, 1.1189, 1.2894,  &
1.0015, 1.0016, 1.0039, 1.0064, 1.0109, 1.0196, 1.0379, 1.0794, 1.1798,  &
1.0014, 1.0016, 1.0031, 1.0049, 1.0087, 1.0153, 1.0284, 1.0564, 1.1207,  &
1.0011, 1.0014, 1.0022, 1.0040, 1.0067, 1.0120, 1.0219, 1.0420, 1.0859,  &
1.0009, 1.0012, 1.0016, 1.0033, 1.0055, 1.0095, 1.0171, 1.0321, 1.0635 /
data ((supersat( 2,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0023, 1.0034, 1.0061, 1.0108, 1.0210, 1.0449, 1.1035, 1.2572, 1.7373,  &
1.0015, 1.0029, 1.0048, 1.0079, 1.0145, 1.0289, 1.0629, 1.1470, 1.3766,  &
1.0008, 1.0024, 1.0033, 1.0061, 1.0108, 1.0201, 1.0408, 1.0899, 1.2140,  &
1.0006, 1.0016, 1.0030, 1.0050, 1.0083, 1.0149, 1.0285, 1.0590, 1.1319,  &
1.0006, 1.0011, 1.0026, 1.0038, 1.0067, 1.0115, 1.0211, 1.0413, 1.0874,  &
1.0005, 1.0008, 1.0020, 1.0030, 1.0052, 1.0092, 1.0161, 1.0305, 1.0615,  &
1.0005, 1.0008, 1.0015, 1.0025, 1.0042, 1.0071, 1.0127, 1.0233, 1.0453 /
data ((supersat( 2,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0019, 1.0031, 1.0051, 1.0090, 1.0174, 1.0371, 1.0853, 1.2088, 1.5629,  &
1.0016, 1.0021, 1.0039, 1.0066, 1.0119, 1.0235, 1.0511, 1.1190, 1.2971,  &
1.0012, 1.0020, 1.0030, 1.0050, 1.0087, 1.0161, 1.0326, 1.0717, 1.1690,  &
1.0007, 1.0017, 1.0021, 1.0040, 1.0066, 1.0117, 1.0223, 1.0461, 1.1026,  &
1.0005, 1.0013, 1.0020, 1.0032, 1.0053, 1.0091, 1.0164, 1.0317, 1.0667,  &
1.0005, 1.0010, 1.0017, 1.0023, 1.0041, 1.0072, 1.0125, 1.0232, 1.0462,  &
1.0005, 1.0008, 1.0014, 1.0018, 1.0034, 1.0056, 1.0097, 1.0176, 1.0337 /
data ((supersat( 2,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0014, 1.0027, 1.0044, 1.0077, 1.0149, 1.0316, 1.0726, 1.1763, 1.4610,  &
1.0011, 1.0020, 1.0031, 1.0056, 1.0101, 1.0198, 1.0430, 1.1000, 1.2467,  &
1.0011, 1.0012, 1.0027, 1.0043, 1.0073, 1.0134, 1.0270, 1.0595, 1.1398,  &
1.0010, 1.0011, 1.0020, 1.0031, 1.0055, 1.0097, 1.0182, 1.0375, 1.0837,  &
1.0008, 1.0011, 1.0013, 1.0028, 1.0044, 1.0074, 1.0132, 1.0254, 1.0533,  &
1.0007, 1.0009, 1.0010, 1.0022, 1.0032, 1.0058, 1.0100, 1.0184, 1.0363,  &
1.0005, 1.0008, 1.0009, 1.0016, 1.0027, 1.0045, 1.0078, 1.0138, 1.0263 /
data ((supersat( 2,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0053, 1.0098, 1.0176, 1.0337, 1.0697, 1.1577, 1.4104, 2.7050, 4.9843,  &
1.0049, 1.0081, 1.0139, 1.0253, 1.0497, 1.1055, 1.2472, 1.7154, 4.0143,  &
1.0039, 1.0061, 1.0112, 1.0198, 1.0372, 1.0754, 1.1649, 1.4097, 2.5389,  &
1.0027, 1.0050, 1.0086, 1.0155, 1.0289, 1.0562, 1.1172, 1.2682, 1.7497,  &
1.0019, 1.0043, 1.0072, 1.0123, 1.0227, 1.0430, 1.0867, 1.1881, 1.4642,  &
1.0016, 1.0032, 1.0053, 1.0097, 1.0175, 1.0331, 1.0654, 1.1371, 1.3154,  &
1.0013, 1.0022, 1.0036, 1.0068, 1.0131, 1.0252, 1.0495, 1.1016, 1.2240 /
data ((supersat( 2,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0039, 1.0070, 1.0125, 1.0235, 1.0478, 1.1055, 1.2581, 1.8031, 3.7137,  &
1.0036, 1.0058, 1.0098, 1.0177, 1.0340, 1.0706, 1.1595, 1.4110, 2.5875,  &
1.0030, 1.0040, 1.0077, 1.0138, 1.0256, 1.0505, 1.1073, 1.2505, 1.7156,  &
1.0021, 1.0037, 1.0065, 1.0110, 1.0199, 1.0378, 1.0767, 1.1680, 1.4163,  &
1.0015, 1.0032, 1.0051, 1.0090, 1.0156, 1.0292, 1.0572, 1.1196, 1.2741,  &
1.0012, 1.0025, 1.0035, 1.0066, 1.0123, 1.0228, 1.0435, 1.0883, 1.1924,  &
1.0010, 1.0018, 1.0027, 1.0052, 1.0093, 1.0174, 1.0333, 1.0663, 1.1399 /
data ((supersat( 2,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0027, 1.0054, 1.0094, 1.0172, 1.0344, 1.0750, 1.1776, 1.4845, 2.7358,  &
1.0026, 1.0043, 1.0074, 1.0129, 1.0243, 1.0497, 1.1101, 1.2684, 1.8142,  &
1.0024, 1.0028, 1.0056, 1.0101, 1.0182, 1.0353, 1.0737, 1.1667, 1.4271,  &
1.0019, 1.0026, 1.0049, 1.0080, 1.0142, 1.0264, 1.0525, 1.1122, 1.2621,  &
1.0014, 1.0024, 1.0037, 1.0064, 1.0111, 1.0205, 1.0392, 1.0800, 1.1760,  &
1.0011, 1.0019, 1.0025, 1.0050, 1.0089, 1.0159, 1.0300, 1.0593, 1.1250,  &
1.0009, 1.0014, 1.0020, 1.0039, 1.0069, 1.0124, 1.0231, 1.0449, 1.0918 /
data ((supersat( 2,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0022, 1.0041, 1.0072, 1.0131, 1.0261, 1.0564, 1.1315, 1.3371, 2.0919,  &
1.0016, 1.0035, 1.0057, 1.0098, 1.0182, 1.0368, 1.0808, 1.1917, 1.5178,  &
1.0016, 1.0023, 1.0043, 1.0076, 1.0135, 1.0258, 1.0533, 1.1186, 1.2891,  &
1.0015, 1.0016, 1.0038, 1.0062, 1.0106, 1.0192, 1.0375, 1.0790, 1.1794,  &
1.0013, 1.0015, 1.0029, 1.0046, 1.0084, 1.0149, 1.0279, 1.0559, 1.1203,  &
1.0010, 1.0013, 1.0020, 1.0038, 1.0065, 1.0115, 1.0214, 1.0414, 1.0853,  &
1.0007, 1.0010, 1.0015, 1.0030, 1.0052, 1.0089, 1.0165, 1.0314, 1.0627 /
data ((supersat( 2,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0021, 1.0031, 1.0058, 1.0105, 1.0207, 1.0446, 1.1034, 1.2571, 1.7372,  &
1.0013, 1.0028, 1.0045, 1.0076, 1.0142, 1.0286, 1.0626, 1.1469, 1.3764,  &
1.0007, 1.0022, 1.0032, 1.0058, 1.0105, 1.0197, 1.0405, 1.0897, 1.2138,  &
1.0006, 1.0014, 1.0029, 1.0048, 1.0080, 1.0146, 1.0281, 1.0587, 1.1316,  &
1.0006, 1.0010, 1.0024, 1.0035, 1.0064, 1.0112, 1.0207, 1.0409, 1.0870,  &
1.0005, 1.0008, 1.0018, 1.0028, 1.0050, 1.0088, 1.0158, 1.0301, 1.0610,  &
1.0004, 1.0007, 1.0014, 1.0023, 1.0039, 1.0068, 1.0122, 1.0227, 1.0446 /
data ((supersat( 2,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0019, 1.0029, 1.0049, 1.0087, 1.0171, 1.0368, 1.0851, 1.2086, 1.5629,  &
1.0015, 1.0021, 1.0038, 1.0063, 1.0116, 1.0232, 1.0509, 1.1188, 1.2970,  &
1.0010, 1.0019, 1.0028, 1.0048, 1.0084, 1.0158, 1.0323, 1.0715, 1.1689,  &
1.0007, 1.0016, 1.0020, 1.0039, 1.0063, 1.0115, 1.0220, 1.0458, 1.1024,  &
1.0005, 1.0012, 1.0019, 1.0030, 1.0051, 1.0088, 1.0160, 1.0314, 1.0664,  &
1.0005, 1.0009, 1.0016, 1.0021, 1.0039, 1.0068, 1.0121, 1.0228, 1.0458,  &
1.0004, 1.0007, 1.0012, 1.0017, 1.0031, 1.0053, 1.0093, 1.0171, 1.0332 /
data ((supersat( 2,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0012, 1.0026, 1.0042, 1.0075, 1.0146, 1.0314, 1.0725, 1.1762, 1.4608,  &
1.0011, 1.0018, 1.0030, 1.0054, 1.0098, 1.0196, 1.0428, 1.0999, 1.2466,  &
1.0010, 1.0011, 1.0026, 1.0041, 1.0070, 1.0131, 1.0267, 1.0593, 1.1397,  &
1.0009, 1.0011, 1.0018, 1.0031, 1.0052, 1.0094, 1.0179, 1.0373, 1.0835,  &
1.0008, 1.0010, 1.0011, 1.0026, 1.0042, 1.0071, 1.0129, 1.0251, 1.0531,  &
1.0006, 1.0009, 1.0010, 1.0020, 1.0030, 1.0055, 1.0097, 1.0180, 1.0360,  &
1.0005, 1.0007, 1.0008, 1.0015, 1.0025, 1.0043, 1.0075, 1.0134, 1.0258 /
data ((supersat( 2,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0053, 1.0094, 1.0173, 1.0334, 1.0694, 1.1575, 1.4101, 2.7045, 4.9836,  &
1.0047, 1.0078, 1.0136, 1.0249, 1.0494, 1.1052, 1.2469, 1.7150, 4.0132,  &
1.0037, 1.0058, 1.0109, 1.0194, 1.0368, 1.0749, 1.1645, 1.4091, 2.5377,  &
1.0025, 1.0049, 1.0084, 1.0151, 1.0284, 1.0556, 1.1167, 1.2675, 1.7485,  &
1.0018, 1.0040, 1.0069, 1.0119, 1.0221, 1.0424, 1.0860, 1.1873, 1.4628,  &
1.0015, 1.0029, 1.0049, 1.0093, 1.0170, 1.0325, 1.0646, 1.1361, 1.3138,  &
1.0012, 1.0019, 1.0033, 1.0063, 1.0125, 1.0244, 1.0484, 1.1003, 1.2221 /
data ((supersat( 2,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0039, 1.0069, 1.0123, 1.0232, 1.0475, 1.1053, 1.2579, 1.8030, 3.7133,  &
1.0035, 1.0056, 1.0096, 1.0174, 1.0337, 1.0704, 1.1593, 1.4108, 2.5871,  &
1.0028, 1.0039, 1.0074, 1.0135, 1.0253, 1.0501, 1.1070, 1.2502, 1.7151,  &
1.0019, 1.0036, 1.0063, 1.0107, 1.0196, 1.0374, 1.0763, 1.1676, 1.4158,  &
1.0014, 1.0030, 1.0048, 1.0087, 1.0153, 1.0287, 1.0566, 1.1191, 1.2733,  &
1.0012, 1.0023, 1.0034, 1.0063, 1.0119, 1.0222, 1.0430, 1.0876, 1.1915,  &
1.0010, 1.0016, 1.0025, 1.0049, 1.0088, 1.0168, 1.0326, 1.0654, 1.1388 /
data ((supersat( 2,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0027, 1.0052, 1.0091, 1.0170, 1.0342, 1.0748, 1.1775, 1.4842, 2.7358,  &
1.0026, 1.0041, 1.0072, 1.0127, 1.0241, 1.0495, 1.1100, 1.2682, 1.8141,  &
1.0023, 1.0027, 1.0055, 1.0099, 1.0179, 1.0350, 1.0735, 1.1664, 1.4269,  &
1.0017, 1.0026, 1.0047, 1.0079, 1.0138, 1.0260, 1.0522, 1.1118, 1.2617,  &
1.0013, 1.0023, 1.0034, 1.0061, 1.0108, 1.0201, 1.0387, 1.0796, 1.1755,  &
1.0010, 1.0018, 1.0024, 1.0049, 1.0085, 1.0156, 1.0296, 1.0588, 1.1244,  &
1.0008, 1.0013, 1.0018, 1.0037, 1.0066, 1.0120, 1.0226, 1.0442, 1.0910 /
data ((supersat( 2,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0020, 1.0041, 1.0069, 1.0129, 1.0258, 1.0562, 1.1314, 1.3370, 2.0916,  &
1.0016, 1.0033, 1.0055, 1.0095, 1.0180, 1.0366, 1.0806, 1.1916, 1.5176,  &
1.0016, 1.0022, 1.0042, 1.0073, 1.0133, 1.0256, 1.0531, 1.1185, 1.2890,  &
1.0014, 1.0016, 1.0036, 1.0060, 1.0103, 1.0189, 1.0373, 1.0788, 1.1792,  &
1.0012, 1.0015, 1.0027, 1.0043, 1.0082, 1.0146, 1.0275, 1.0556, 1.1199,  &
1.0009, 1.0013, 1.0019, 1.0037, 1.0063, 1.0112, 1.0210, 1.0409, 1.0848,  &
1.0007, 1.0009, 1.0015, 1.0028, 1.0049, 1.0085, 1.0161, 1.0309, 1.0621 /
data ((supersat( 2,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0020, 1.0031, 1.0056, 1.0103, 1.0205, 1.0444, 1.1033, 1.2570, 1.7372,  &
1.0012, 1.0027, 1.0044, 1.0074, 1.0140, 1.0284, 1.0625, 1.1468, 1.3763,  &
1.0007, 1.0021, 1.0031, 1.0056, 1.0103, 1.0195, 1.0403, 1.0896, 1.2137,  &
1.0006, 1.0013, 1.0028, 1.0047, 1.0077, 1.0143, 1.0278, 1.0584, 1.1315,  &
1.0005, 1.0009, 1.0023, 1.0033, 1.0062, 1.0110, 1.0204, 1.0406, 1.0867,  &
1.0005, 1.0008, 1.0017, 1.0028, 1.0049, 1.0086, 1.0155, 1.0297, 1.0607,  &
1.0004, 1.0007, 1.0013, 1.0022, 1.0037, 1.0065, 1.0118, 1.0223, 1.0442 /
data ((supersat( 2,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0018, 1.0027, 1.0047, 1.0086, 1.0169, 1.0367, 1.0850, 1.2086, 1.5628,  &
1.0014, 1.0020, 1.0037, 1.0061, 1.0114, 1.0230, 1.0507, 1.1188, 1.2969,  &
1.0009, 1.0019, 1.0026, 1.0046, 1.0082, 1.0156, 1.0321, 1.0713, 1.1688,  &
1.0006, 1.0015, 1.0020, 1.0038, 1.0061, 1.0113, 1.0217, 1.0456, 1.1023,  &
1.0005, 1.0011, 1.0018, 1.0029, 1.0049, 1.0085, 1.0157, 1.0311, 1.0661,  &
1.0005, 1.0008, 1.0015, 1.0019, 1.0038, 1.0066, 1.0118, 1.0225, 1.0455,  &
1.0004, 1.0007, 1.0011, 1.0016, 1.0030, 1.0051, 1.0091, 1.0168, 1.0328 /
data ((supersat( 2,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0011, 1.0025, 1.0041, 1.0073, 1.0144, 1.0312, 1.0724, 1.1761, 1.4609,  &
1.0011, 1.0017, 1.0030, 1.0052, 1.0096, 1.0194, 1.0427, 1.0999, 1.2465,  &
1.0010, 1.0011, 1.0024, 1.0040, 1.0068, 1.0129, 1.0265, 1.0592, 1.1397,  &
1.0009, 1.0011, 1.0016, 1.0030, 1.0050, 1.0092, 1.0177, 1.0371, 1.0834,  &
1.0007, 1.0010, 1.0011, 1.0025, 1.0041, 1.0069, 1.0127, 1.0249, 1.0529,  &
1.0006, 1.0008, 1.0010, 1.0019, 1.0029, 1.0053, 1.0095, 1.0178, 1.0357,  &
1.0004, 1.0006, 1.0007, 1.0014, 1.0024, 1.0041, 1.0072, 1.0131, 1.0254 /
data ((supersat( 3,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0059, 1.0107, 1.0184, 1.0347, 1.0706, 1.1583, 1.4112, 2.7063, 4.9854,  &
1.0052, 1.0086, 1.0147, 1.0264, 1.0508, 1.1064, 1.2480, 1.7166, 4.0173,  &
1.0046, 1.0071, 1.0119, 1.0209, 1.0385, 1.0765, 1.1660, 1.4113, 2.5418,  &
1.0035, 1.0053, 1.0096, 1.0169, 1.0303, 1.0577, 1.1187, 1.2700, 1.7530,  &
1.0024, 1.0049, 1.0081, 1.0137, 1.0242, 1.0447, 1.0886, 1.1905, 1.4682,  &
1.0018, 1.0040, 1.0064, 1.0110, 1.0193, 1.0352, 1.0679, 1.1401, 1.3199,  &
1.0016, 1.0030, 1.0046, 1.0084, 1.0151, 1.0275, 1.0524, 1.1053, 1.2293 /
data ((supersat( 3,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0041, 1.0076, 1.0133, 1.0245, 1.0486, 1.1061, 1.2585, 1.8036, 3.7144,  &
1.0039, 1.0065, 1.0103, 1.0185, 1.0350, 1.0715, 1.1601, 1.4118, 2.5887,  &
1.0034, 1.0049, 1.0086, 1.0148, 1.0266, 1.0515, 1.1082, 1.2514, 1.7169,  &
1.0027, 1.0039, 1.0070, 1.0121, 1.0210, 1.0390, 1.0779, 1.1692, 1.4183,  &
1.0019, 1.0036, 1.0060, 1.0098, 1.0168, 1.0305, 1.0586, 1.1213, 1.2761,  &
1.0014, 1.0030, 1.0044, 1.0078, 1.0135, 1.0242, 1.0453, 1.0904, 1.1951,  &
1.0012, 1.0023, 1.0033, 1.0061, 1.0108, 1.0192, 1.0355, 1.0689, 1.1432 /
data ((supersat( 3,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0032, 1.0056, 1.0101, 1.0180, 1.0352, 1.0755, 1.1780, 1.4848, 2.7362,  &
1.0027, 1.0049, 1.0079, 1.0136, 1.0252, 1.0505, 1.1107, 1.2689, 1.8148,  &
1.0026, 1.0036, 1.0061, 1.0108, 1.0191, 1.0362, 1.0745, 1.1673, 1.4281,  &
1.0023, 1.0027, 1.0054, 1.0085, 1.0152, 1.0275, 1.0535, 1.1131, 1.2631,  &
1.0018, 1.0026, 1.0044, 1.0073, 1.0122, 1.0215, 1.0404, 1.0813, 1.1773,  &
1.0013, 1.0023, 1.0032, 1.0054, 1.0100, 1.0172, 1.0315, 1.0609, 1.1268,  &
1.0011, 1.0019, 1.0024, 1.0047, 1.0078, 1.0136, 1.0248, 1.0468, 1.0941 /
data ((supersat( 3,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0028, 1.0044, 1.0079, 1.0140, 1.0268, 1.0569, 1.1318, 1.3375, 2.0920,  &
1.0017, 1.0039, 1.0062, 1.0105, 1.0190, 1.0375, 1.0813, 1.1920, 1.5182,  &
1.0016, 1.0030, 1.0046, 1.0083, 1.0143, 1.0266, 1.0540, 1.1192, 1.2897,  &
1.0016, 1.0019, 1.0041, 1.0066, 1.0113, 1.0201, 1.0385, 1.0798, 1.1801,  &
1.0015, 1.0016, 1.0035, 1.0054, 1.0091, 1.0158, 1.0290, 1.0570, 1.1213,  &
1.0013, 1.0015, 1.0025, 1.0042, 1.0072, 1.0126, 1.0226, 1.0427, 1.0867,  &
1.0010, 1.0013, 1.0018, 1.0036, 1.0060, 1.0101, 1.0179, 1.0329, 1.0645 /
data ((supersat( 3,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0025, 1.0038, 1.0065, 1.0112, 1.0214, 1.0451, 1.1036, 1.2574, 1.7373,  &
1.0018, 1.0030, 1.0050, 1.0084, 1.0149, 1.0293, 1.0631, 1.1472, 1.3769,  &
1.0010, 1.0026, 1.0038, 1.0065, 1.0112, 1.0205, 1.0412, 1.0902, 1.2142,  &
1.0006, 1.0019, 1.0031, 1.0052, 1.0088, 1.0153, 1.0289, 1.0593, 1.1322,  &
1.0006, 1.0012, 1.0028, 1.0042, 1.0071, 1.0119, 1.0216, 1.0418, 1.0878,  &
1.0006, 1.0009, 1.0022, 1.0031, 1.0054, 1.0096, 1.0168, 1.0312, 1.0622,  &
1.0005, 1.0008, 1.0017, 1.0027, 1.0046, 1.0075, 1.0133, 1.0241, 1.0461 /
data ((supersat( 3,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0020, 1.0034, 1.0054, 1.0094, 1.0178, 1.0373, 1.0854, 1.2088, 1.5630,  &
1.0018, 1.0022, 1.0041, 1.0069, 1.0123, 1.0239, 1.0513, 1.1191, 1.2973,  &
1.0014, 1.0020, 1.0033, 1.0054, 1.0091, 1.0165, 1.0329, 1.0719, 1.1691,  &
1.0009, 1.0018, 1.0022, 1.0042, 1.0070, 1.0121, 1.0227, 1.0464, 1.1029,  &
1.0006, 1.0015, 1.0020, 1.0035, 1.0057, 1.0095, 1.0168, 1.0322, 1.0670,  &
1.0005, 1.0011, 1.0019, 1.0026, 1.0042, 1.0076, 1.0130, 1.0238, 1.0467,  &
1.0005, 1.0009, 1.0015, 1.0019, 1.0037, 1.0059, 1.0101, 1.0182, 1.0344 /
data ((supersat( 3,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0029, 1.0046, 1.0081, 1.0153, 1.0319, 1.0727, 1.1763, 1.4610,  &
1.0011, 1.0023, 1.0034, 1.0059, 1.0104, 1.0202, 1.0432, 1.1001, 1.2468,  &
1.0011, 1.0014, 1.0029, 1.0046, 1.0076, 1.0138, 1.0273, 1.0597, 1.1399,  &
1.0011, 1.0011, 1.0022, 1.0033, 1.0059, 1.0100, 1.0186, 1.0379, 1.0839,  &
1.0009, 1.0011, 1.0015, 1.0029, 1.0047, 1.0078, 1.0136, 1.0258, 1.0537,  &
1.0008, 1.0010, 1.0011, 1.0024, 1.0036, 1.0062, 1.0104, 1.0188, 1.0368,  &
1.0006, 1.0009, 1.0009, 1.0018, 1.0029, 1.0048, 1.0082, 1.0144, 1.0269 /
data ((supersat( 3,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0053, 1.0097, 1.0175, 1.0336, 1.0696, 1.1576, 1.4105, 2.7052, 4.9840,  &
1.0049, 1.0080, 1.0138, 1.0253, 1.0497, 1.1055, 1.2471, 1.7154, 4.0143,  &
1.0039, 1.0061, 1.0111, 1.0197, 1.0372, 1.0753, 1.1648, 1.4099, 2.5390,  &
1.0027, 1.0050, 1.0086, 1.0155, 1.0288, 1.0561, 1.1172, 1.2682, 1.7498,  &
1.0019, 1.0043, 1.0072, 1.0123, 1.0226, 1.0430, 1.0866, 1.1881, 1.4646,  &
1.0016, 1.0032, 1.0052, 1.0097, 1.0174, 1.0331, 1.0653, 1.1371, 1.3156,  &
1.0013, 1.0022, 1.0036, 1.0068, 1.0130, 1.0252, 1.0495, 1.1016, 1.2241 /
data ((supersat( 3,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0039, 1.0070, 1.0125, 1.0235, 1.0477, 1.1055, 1.2581, 1.8031, 3.7136,  &
1.0036, 1.0058, 1.0098, 1.0177, 1.0339, 1.0706, 1.1594, 1.4111, 2.5875,  &
1.0030, 1.0040, 1.0077, 1.0138, 1.0255, 1.0504, 1.1072, 1.2505, 1.7156,  &
1.0021, 1.0037, 1.0065, 1.0110, 1.0199, 1.0377, 1.0766, 1.1680, 1.4167,  &
1.0015, 1.0032, 1.0051, 1.0090, 1.0156, 1.0291, 1.0571, 1.1196, 1.2741,  &
1.0012, 1.0025, 1.0035, 1.0066, 1.0122, 1.0227, 1.0435, 1.0883, 1.1925,  &
1.0010, 1.0018, 1.0027, 1.0052, 1.0093, 1.0173, 1.0333, 1.0663, 1.1399 /
data ((supersat( 3,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0027, 1.0053, 1.0094, 1.0172, 1.0344, 1.0749, 1.1776, 1.4845, 2.7359,  &
1.0026, 1.0043, 1.0074, 1.0129, 1.0243, 1.0497, 1.1101, 1.2685, 1.8144,  &
1.0024, 1.0028, 1.0056, 1.0101, 1.0182, 1.0352, 1.0737, 1.1666, 1.4273,  &
1.0019, 1.0026, 1.0049, 1.0080, 1.0141, 1.0263, 1.0525, 1.1121, 1.2621,  &
1.0014, 1.0024, 1.0036, 1.0064, 1.0111, 1.0205, 1.0391, 1.0800, 1.1759,  &
1.0011, 1.0019, 1.0025, 1.0050, 1.0089, 1.0159, 1.0300, 1.0593, 1.1250,  &
1.0009, 1.0014, 1.0020, 1.0039, 1.0069, 1.0124, 1.0230, 1.0449, 1.0918 /
data ((supersat( 3,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0022, 1.0041, 1.0072, 1.0131, 1.0260, 1.0563, 1.1314, 1.3373, 2.0919,  &
1.0016, 1.0034, 1.0056, 1.0097, 1.0182, 1.0368, 1.0808, 1.1917, 1.5178,  &
1.0015, 1.0023, 1.0043, 1.0075, 1.0134, 1.0258, 1.0532, 1.1186, 1.2892,  &
1.0015, 1.0016, 1.0038, 1.0062, 1.0105, 1.0192, 1.0375, 1.0790, 1.1794,  &
1.0013, 1.0015, 1.0029, 1.0046, 1.0084, 1.0148, 1.0278, 1.0559, 1.1202,  &
1.0010, 1.0014, 1.0020, 1.0038, 1.0065, 1.0115, 1.0213, 1.0413, 1.0853,  &
1.0008, 1.0010, 1.0015, 1.0030, 1.0051, 1.0089, 1.0165, 1.0314, 1.0627 /
data ((supersat( 3,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0021, 1.0031, 1.0058, 1.0105, 1.0206, 1.0445, 1.1033, 1.2572, 1.7372,  &
1.0013, 1.0028, 1.0045, 1.0076, 1.0142, 1.0286, 1.0626, 1.1468, 1.3766,  &
1.0007, 1.0022, 1.0032, 1.0058, 1.0105, 1.0197, 1.0404, 1.0897, 1.2139,  &
1.0005, 1.0015, 1.0029, 1.0048, 1.0080, 1.0145, 1.0281, 1.0586, 1.1316,  &
1.0006, 1.0010, 1.0024, 1.0035, 1.0064, 1.0112, 1.0207, 1.0409, 1.0870,  &
1.0005, 1.0008, 1.0018, 1.0028, 1.0050, 1.0088, 1.0158, 1.0300, 1.0610,  &
1.0004, 1.0007, 1.0013, 1.0023, 1.0039, 1.0068, 1.0122, 1.0227, 1.0446 /
data ((supersat( 3,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0019, 1.0028, 1.0049, 1.0087, 1.0171, 1.0368, 1.0851, 1.2087, 1.5629,  &
1.0015, 1.0020, 1.0038, 1.0062, 1.0116, 1.0232, 1.0508, 1.1188, 1.2972,  &
1.0010, 1.0019, 1.0028, 1.0048, 1.0084, 1.0157, 1.0322, 1.0714, 1.1689,  &
1.0007, 1.0016, 1.0020, 1.0039, 1.0063, 1.0114, 1.0219, 1.0457, 1.1024,  &
1.0005, 1.0012, 1.0019, 1.0030, 1.0051, 1.0087, 1.0160, 1.0313, 1.0663,  &
1.0005, 1.0009, 1.0016, 1.0021, 1.0039, 1.0068, 1.0121, 1.0227, 1.0457,  &
1.0004, 1.0007, 1.0012, 1.0017, 1.0031, 1.0053, 1.0093, 1.0171, 1.0332 /
data ((supersat( 3,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0012, 1.0026, 1.0042, 1.0074, 1.0145, 1.0313, 1.0724, 1.1762, 1.4609,  &
1.0011, 1.0018, 1.0030, 1.0054, 1.0098, 1.0195, 1.0428, 1.0999, 1.2467,  &
1.0010, 1.0011, 1.0026, 1.0041, 1.0070, 1.0131, 1.0267, 1.0593, 1.1397,  &
1.0009, 1.0011, 1.0018, 1.0031, 1.0052, 1.0094, 1.0179, 1.0372, 1.0835,  &
1.0008, 1.0010, 1.0011, 1.0026, 1.0042, 1.0071, 1.0129, 1.0251, 1.0530,  &
1.0006, 1.0009, 1.0010, 1.0020, 1.0030, 1.0055, 1.0097, 1.0180, 1.0359,  &
1.0005, 1.0007, 1.0008, 1.0015, 1.0025, 1.0043, 1.0075, 1.0134, 1.0258 /
data ((supersat( 3,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0051, 1.0088, 1.0168, 1.0327, 1.0689, 1.1570, 1.4098, 2.7037, 4.9823,  &
1.0044, 1.0074, 1.0129, 1.0242, 1.0487, 1.1046, 1.2462, 1.7142, 4.0108,  &
1.0032, 1.0052, 1.0103, 1.0186, 1.0360, 1.0741, 1.1636, 1.4082, 2.5354,  &
1.0022, 1.0046, 1.0080, 1.0145, 1.0274, 1.0547, 1.1155, 1.2661, 1.7461,  &
1.0016, 1.0035, 1.0062, 1.0110, 1.0210, 1.0412, 1.0846, 1.1855, 1.4601,  &
1.0013, 1.0024, 1.0042, 1.0083, 1.0159, 1.0310, 1.0628, 1.1338, 1.3106,  &
1.0009, 1.0014, 1.0027, 1.0054, 1.0112, 1.0227, 1.0462, 1.0974, 1.2180 /
data ((supersat( 3,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0038, 1.0066, 1.0118, 1.0226, 1.0470, 1.1050, 1.2577, 1.8026, 3.7126,  &
1.0033, 1.0051, 1.0092, 1.0169, 1.0331, 1.0698, 1.1588, 1.4103, 2.5861,  &
1.0024, 1.0038, 1.0070, 1.0128, 1.0246, 1.0495, 1.1063, 1.2496, 1.7142,  &
1.0016, 1.0034, 1.0059, 1.0100, 1.0188, 1.0366, 1.0754, 1.1667, 1.4147,  &
1.0013, 1.0027, 1.0042, 1.0080, 1.0146, 1.0278, 1.0556, 1.1179, 1.2719,  &
1.0010, 1.0019, 1.0030, 1.0058, 1.0111, 1.0211, 1.0417, 1.0861, 1.1896,  &
1.0007, 1.0012, 1.0021, 1.0041, 1.0078, 1.0156, 1.0310, 1.0635, 1.1363 /
data ((supersat( 3,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0027, 1.0050, 1.0086, 1.0165, 1.0337, 1.0745, 1.1773, 1.4841, 2.7349,  &
1.0025, 1.0037, 1.0067, 1.0122, 1.0236, 1.0490, 1.1096, 1.2680, 1.8138,  &
1.0020, 1.0027, 1.0053, 1.0094, 1.0174, 1.0344, 1.0730, 1.1660, 1.4264,  &
1.0015, 1.0025, 1.0043, 1.0075, 1.0133, 1.0254, 1.0515, 1.1112, 1.2611,  &
1.0011, 1.0020, 1.0030, 1.0055, 1.0103, 1.0194, 1.0379, 1.0787, 1.1745,  &
1.0009, 1.0015, 1.0021, 1.0044, 1.0078, 1.0148, 1.0285, 1.0577, 1.1231,  &
1.0006, 1.0009, 1.0016, 1.0031, 1.0058, 1.0111, 1.0214, 1.0428, 1.0893 /
data ((supersat( 3,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0016, 1.0039, 1.0065, 1.0125, 1.0254, 1.0559, 1.1312, 1.3369, 2.0915,  &
1.0016, 1.0030, 1.0051, 1.0090, 1.0175, 1.0362, 1.0803, 1.1914, 1.5174,  &
1.0015, 1.0018, 1.0040, 1.0068, 1.0128, 1.0251, 1.0526, 1.1181, 1.2888,  &
1.0013, 1.0015, 1.0033, 1.0056, 1.0098, 1.0183, 1.0367, 1.0783, 1.1787,  &
1.0010, 1.0014, 1.0023, 1.0040, 1.0077, 1.0139, 1.0268, 1.0549, 1.1192,  &
1.0008, 1.0011, 1.0017, 1.0033, 1.0059, 1.0107, 1.0201, 1.0401, 1.0839,  &
1.0005, 1.0007, 1.0013, 1.0024, 1.0043, 1.0079, 1.0151, 1.0298, 1.0609 /
data ((supersat( 3,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0017, 1.0030, 1.0052, 1.0099, 1.0201, 1.0442, 1.1031, 1.2571, 1.7371,  &
1.0009, 1.0025, 1.0041, 1.0071, 1.0136, 1.0280, 1.0622, 1.1466, 1.3763,  &
1.0006, 1.0018, 1.0030, 1.0053, 1.0098, 1.0190, 1.0399, 1.0893, 1.2135,  &
1.0006, 1.0011, 1.0026, 1.0043, 1.0074, 1.0138, 1.0273, 1.0580, 1.1311,  &
1.0005, 1.0009, 1.0020, 1.0030, 1.0057, 1.0105, 1.0198, 1.0401, 1.0862,  &
1.0004, 1.0007, 1.0015, 1.0025, 1.0045, 1.0080, 1.0148, 1.0290, 1.0599,  &
1.0004, 1.0006, 1.0011, 1.0018, 1.0032, 1.0060, 1.0110, 1.0214, 1.0432 /
data ((supersat( 3,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0017, 1.0023, 1.0044, 1.0082, 1.0165, 1.0364, 1.0849, 1.2086, 1.5627,  &
1.0012, 1.0020, 1.0034, 1.0058, 1.0110, 1.0227, 1.0505, 1.1186, 1.2969,  &
1.0008, 1.0017, 1.0023, 1.0042, 1.0078, 1.0152, 1.0317, 1.0711, 1.1686,  &
1.0005, 1.0013, 1.0019, 1.0035, 1.0059, 1.0109, 1.0213, 1.0452, 1.1020,  &
1.0005, 1.0009, 1.0017, 1.0025, 1.0045, 1.0080, 1.0152, 1.0306, 1.0657,  &
1.0004, 1.0007, 1.0013, 1.0018, 1.0035, 1.0061, 1.0113, 1.0219, 1.0448,  &
1.0004, 1.0006, 1.0009, 1.0013, 1.0026, 1.0046, 1.0085, 1.0161, 1.0319 /
data ((supersat( 3,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0011, 1.0023, 1.0038, 1.0070, 1.0140, 1.0310, 1.0722, 1.1761, 1.4609,  &
1.0011, 1.0014, 1.0029, 1.0048, 1.0092, 1.0190, 1.0425, 1.0997, 1.2466,  &
1.0010, 1.0011, 1.0022, 1.0036, 1.0064, 1.0125, 1.0262, 1.0590, 1.1395,  &
1.0008, 1.0010, 1.0014, 1.0029, 1.0048, 1.0089, 1.0173, 1.0368, 1.0832,  &
1.0006, 1.0009, 1.0010, 1.0023, 1.0037, 1.0065, 1.0122, 1.0244, 1.0525,  &
1.0005, 1.0007, 1.0008, 1.0016, 1.0027, 1.0049, 1.0090, 1.0172, 1.0351,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0021, 1.0037, 1.0067, 1.0125, 1.0247 /
data ((supersat( 3,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0049, 1.0084, 1.0161, 1.0320, 1.0683, 1.1565, 1.4091, 2.7022, 4.9802,  &
1.0039, 1.0067, 1.0121, 1.0234, 1.0479, 1.1038, 1.2454, 1.7127, 4.0067,  &
1.0026, 1.0049, 1.0094, 1.0176, 1.0350, 1.0730, 1.1624, 1.4064, 2.5312,  &
1.0018, 1.0040, 1.0073, 1.0136, 1.0262, 1.0533, 1.1139, 1.2639, 1.7417,  &
1.0014, 1.0028, 1.0052, 1.0100, 1.0196, 1.0394, 1.0824, 1.1826, 1.4551,  &
1.0009, 1.0016, 1.0033, 1.0068, 1.0141, 1.0288, 1.0600, 1.1301, 1.3046,  &
1.0006, 1.0009, 1.0018, 1.0040, 1.0091, 1.0199, 1.0427, 1.0927, 1.2107 /
data ((supersat( 3,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0036, 1.0062, 1.0113, 1.0221, 1.0465, 1.1046, 1.2573, 1.8021, 3.7113,  &
1.0028, 1.0044, 1.0087, 1.0162, 1.0325, 1.0692, 1.1583, 1.4096, 2.5845,  &
1.0019, 1.0036, 1.0066, 1.0122, 1.0237, 1.0486, 1.1055, 1.2486, 1.7125,  &
1.0014, 1.0030, 1.0052, 1.0093, 1.0178, 1.0356, 1.0743, 1.1653, 1.4126,  &
1.0011, 1.0021, 1.0035, 1.0070, 1.0135, 1.0264, 1.0541, 1.1161, 1.2693,  &
1.0008, 1.0013, 1.0024, 1.0049, 1.0099, 1.0194, 1.0397, 1.0837, 1.1863,  &
1.0005, 1.0008, 1.0014, 1.0030, 1.0064, 1.0137, 1.0286, 1.0605, 1.1321 /
data ((supersat( 3,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0026, 1.0046, 1.0080, 1.0159, 1.0333, 1.0742, 1.1770, 1.4838, 2.7346,  &
1.0022, 1.0031, 1.0061, 1.0116, 1.0230, 1.0485, 1.1092, 1.2676, 1.8133,  &
1.0017, 1.0026, 1.0049, 1.0087, 1.0168, 1.0338, 1.0723, 1.1654, 1.4255,  &
1.0012, 1.0022, 1.0037, 1.0068, 1.0126, 1.0246, 1.0507, 1.1103, 1.2599,  &
1.0009, 1.0017, 1.0025, 1.0049, 1.0096, 1.0183, 1.0368, 1.0775, 1.1730,  &
1.0006, 1.0011, 1.0017, 1.0037, 1.0069, 1.0136, 1.0271, 1.0560, 1.1210,  &
1.0004, 1.0007, 1.0012, 1.0023, 1.0047, 1.0096, 1.0197, 1.0407, 1.0866 /
data ((supersat( 3,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0016, 1.0036, 1.0062, 1.0120, 1.0250, 1.0556, 1.1310, 1.3367, 2.0912,  &
1.0015, 1.0025, 1.0045, 1.0086, 1.0169, 1.0358, 1.0800, 1.1911, 1.5171,  &
1.0014, 1.0015, 1.0038, 1.0064, 1.0123, 1.0245, 1.0521, 1.1177, 1.2882,  &
1.0011, 1.0014, 1.0028, 1.0050, 1.0091, 1.0176, 1.0360, 1.0776, 1.1780,  &
1.0008, 1.0012, 1.0019, 1.0037, 1.0069, 1.0131, 1.0260, 1.0540, 1.1182,  &
1.0005, 1.0007, 1.0014, 1.0028, 1.0051, 1.0098, 1.0191, 1.0388, 1.0824,  &
1.0004, 1.0005, 1.0009, 1.0017, 1.0034, 1.0068, 1.0138, 1.0281, 1.0589 /
data ((supersat( 3,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0013, 1.0028, 1.0049, 1.0095, 1.0197, 1.0439, 1.1030, 1.2569, 1.7370,  &
1.0007, 1.0022, 1.0036, 1.0068, 1.0131, 1.0276, 1.0619, 1.1464, 1.3760,  &
1.0006, 1.0014, 1.0029, 1.0050, 1.0092, 1.0185, 1.0395, 1.0890, 1.2132,  &
1.0005, 1.0009, 1.0023, 1.0038, 1.0070, 1.0132, 1.0268, 1.0575, 1.1306,  &
1.0004, 1.0008, 1.0017, 1.0027, 1.0050, 1.0097, 1.0190, 1.0393, 1.0854,  &
1.0004, 1.0007, 1.0012, 1.0021, 1.0039, 1.0071, 1.0139, 1.0280, 1.0588,  &
1.0003, 1.0005, 1.0007, 1.0013, 1.0026, 1.0051, 1.0100, 1.0201, 1.0416 /
data ((supersat( 3,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0015, 1.0020, 1.0039, 1.0078, 1.0161, 1.0362, 1.0848, 1.2084, 1.5626,  &
1.0009, 1.0019, 1.0031, 1.0055, 1.0106, 1.0223, 1.0503, 1.1185, 1.2967,  &
1.0006, 1.0015, 1.0020, 1.0040, 1.0074, 1.0147, 1.0314, 1.0709, 1.1684,  &
1.0005, 1.0011, 1.0018, 1.0031, 1.0055, 1.0103, 1.0208, 1.0448, 1.1016,  &
1.0004, 1.0008, 1.0014, 1.0021, 1.0039, 1.0075, 1.0146, 1.0300, 1.0651,  &
1.0004, 1.0006, 1.0010, 1.0015, 1.0030, 1.0054, 1.0106, 1.0210, 1.0440,  &
1.0003, 1.0004, 1.0006, 1.0011, 1.0020, 1.0039, 1.0075, 1.0150, 1.0307 /
data ((supersat( 3,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0011, 1.0019, 1.0035, 1.0066, 1.0137, 1.0307, 1.0721, 1.1760, 1.4607,  &
1.0010, 1.0011, 1.0026, 1.0045, 1.0088, 1.0187, 1.0423, 1.0996, 1.2464,  &
1.0008, 1.0010, 1.0019, 1.0032, 1.0061, 1.0121, 1.0259, 1.0588, 1.1393,  &
1.0006, 1.0009, 1.0012, 1.0026, 1.0045, 1.0084, 1.0168, 1.0364, 1.0829,  &
1.0005, 1.0007, 1.0009, 1.0019, 1.0033, 1.0061, 1.0117, 1.0239, 1.0520,  &
1.0003, 1.0005, 1.0007, 1.0013, 1.0024, 1.0043, 1.0084, 1.0165, 1.0344,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0016, 1.0031, 1.0059, 1.0116, 1.0237 /
data ((supersat( 3,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0046, 1.0082, 1.0157, 1.0316, 1.0680, 1.1562, 1.4087, 2.7013, 4.9788,  &
1.0035, 1.0063, 1.0116, 1.0230, 1.0474, 1.1034, 1.2448, 1.7118, 4.0038,  &
1.0023, 1.0047, 1.0089, 1.0172, 1.0345, 1.0724, 1.1616, 1.4051, 2.5283,  &
1.0016, 1.0036, 1.0068, 1.0130, 1.0255, 1.0524, 1.1129, 1.2623, 1.7388,  &
1.0012, 1.0024, 1.0046, 1.0093, 1.0187, 1.0383, 1.0810, 1.1807, 1.4517,  &
1.0007, 1.0013, 1.0027, 1.0060, 1.0130, 1.0274, 1.0583, 1.1276, 1.3004,  &
1.0004, 1.0007, 1.0013, 1.0031, 1.0078, 1.0181, 1.0405, 1.0895, 1.2057 /
data ((supersat( 3,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0034, 1.0060, 1.0110, 1.0218, 1.0463, 1.1044, 1.2570, 1.8018, 3.7105,  &
1.0026, 1.0041, 1.0083, 1.0158, 1.0321, 1.0689, 1.1579, 1.4091, 2.5834,  &
1.0017, 1.0035, 1.0063, 1.0119, 1.0233, 1.0482, 1.1050, 1.2479, 1.7114,  &
1.0012, 1.0027, 1.0048, 1.0089, 1.0173, 1.0350, 1.0737, 1.1645, 1.4112,  &
1.0010, 1.0018, 1.0031, 1.0064, 1.0129, 1.0256, 1.0532, 1.1149, 1.2675,  &
1.0006, 1.0010, 1.0020, 1.0043, 1.0091, 1.0185, 1.0385, 1.0822, 1.1841,  &
1.0004, 1.0006, 1.0011, 1.0024, 1.0055, 1.0125, 1.0271, 1.0585, 1.1293 /
data ((supersat( 3,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0025, 1.0044, 1.0078, 1.0157, 1.0331, 1.0740, 1.1769, 1.4836, 2.7343,  &
1.0021, 1.0028, 1.0058, 1.0113, 1.0227, 1.0483, 1.1090, 1.2673, 1.8127,  &
1.0015, 1.0025, 1.0047, 1.0084, 1.0164, 1.0334, 1.0720, 1.1650, 1.4250,  &
1.0011, 1.0020, 1.0034, 1.0065, 1.0122, 1.0242, 1.0502, 1.1097, 1.2591,  &
1.0008, 1.0014, 1.0022, 1.0046, 1.0091, 1.0177, 1.0362, 1.0767, 1.1720,  &
1.0005, 1.0008, 1.0015, 1.0032, 1.0063, 1.0129, 1.0263, 1.0550, 1.1197,  &
1.0003, 1.0005, 1.0009, 1.0018, 1.0040, 1.0087, 1.0185, 1.0393, 1.0848 /
data ((supersat( 3,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0016, 1.0034, 1.0060, 1.0118, 1.0248, 1.0555, 1.1309, 1.3366, 2.0910,  &
1.0015, 1.0022, 1.0042, 1.0084, 1.0167, 1.0356, 1.0799, 1.1909, 1.5169,  &
1.0013, 1.0015, 1.0036, 1.0062, 1.0120, 1.0242, 1.0519, 1.1174, 1.2878,  &
1.0010, 1.0013, 1.0026, 1.0047, 1.0087, 1.0172, 1.0356, 1.0772, 1.1775,  &
1.0007, 1.0010, 1.0017, 1.0034, 1.0065, 1.0126, 1.0255, 1.0534, 1.1175,  &
1.0004, 1.0007, 1.0012, 1.0024, 1.0047, 1.0092, 1.0184, 1.0381, 1.0815,  &
1.0003, 1.0004, 1.0007, 1.0013, 1.0029, 1.0062, 1.0130, 1.0271, 1.0577 /
data ((supersat( 3,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0011, 1.0027, 1.0048, 1.0093, 1.0195, 1.0438, 1.1029, 1.2567, 1.7368,  &
1.0006, 1.0020, 1.0033, 1.0066, 1.0129, 1.0275, 1.0618, 1.1463, 1.3759,  &
1.0006, 1.0013, 1.0027, 1.0048, 1.0090, 1.0183, 1.0393, 1.0888, 1.2129,  &
1.0005, 1.0009, 1.0021, 1.0035, 1.0067, 1.0129, 1.0264, 1.0572, 1.1303,  &
1.0004, 1.0007, 1.0015, 1.0025, 1.0048, 1.0093, 1.0186, 1.0389, 1.0850,  &
1.0004, 1.0006, 1.0010, 1.0018, 1.0035, 1.0067, 1.0134, 1.0274, 1.0581,  &
1.0002, 1.0004, 1.0006, 1.0011, 1.0022, 1.0045, 1.0093, 1.0193, 1.0407 /
data ((supersat( 3,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0013, 1.0020, 1.0038, 1.0076, 1.0160, 1.0361, 1.0847, 1.2083, 1.5626,  &
1.0008, 1.0018, 1.0029, 1.0053, 1.0104, 1.0222, 1.0502, 1.1184, 1.2966,  &
1.0005, 1.0014, 1.0020, 1.0038, 1.0072, 1.0145, 1.0312, 1.0707, 1.1682,  &
1.0005, 1.0010, 1.0017, 1.0029, 1.0053, 1.0101, 1.0205, 1.0446, 1.1014,  &
1.0004, 1.0007, 1.0013, 1.0019, 1.0037, 1.0072, 1.0142, 1.0296, 1.0648,  &
1.0003, 1.0005, 1.0008, 1.0013, 1.0027, 1.0051, 1.0101, 1.0205, 1.0434,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0017, 1.0034, 1.0070, 1.0143, 1.0300 /
data ((supersat( 3,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0010, 1.0018, 1.0033, 1.0064, 1.0136, 1.0307, 1.0721, 1.1759, 1.4607,  &
1.0009, 1.0011, 1.0025, 1.0044, 1.0087, 1.0186, 1.0422, 1.0996, 1.2463,  &
1.0008, 1.0010, 1.0017, 1.0030, 1.0059, 1.0119, 1.0258, 1.0587, 1.1392,  &
1.0006, 1.0008, 1.0011, 1.0025, 1.0043, 1.0081, 1.0166, 1.0362, 1.0827,  &
1.0004, 1.0006, 1.0008, 1.0018, 1.0030, 1.0058, 1.0114, 1.0236, 1.0517,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0021, 1.0040, 1.0080, 1.0161, 1.0340,  &
1.0002, 1.0003, 1.0004, 1.0007, 1.0013, 1.0027, 1.0054, 1.0111, 1.0230 /
data ((supersat( 3,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0045, 1.0080, 1.0155, 1.0314, 1.0677, 1.1560, 1.4084, 2.7006, 4.9779,  &
1.0033, 1.0060, 1.0113, 1.0227, 1.0471, 1.1031, 1.2444, 1.7111, 4.0015,  &
1.0022, 1.0045, 1.0085, 1.0168, 1.0341, 1.0720, 1.1610, 1.4042, 2.5261,  &
1.0015, 1.0033, 1.0064, 1.0125, 1.0250, 1.0518, 1.1121, 1.2611, 1.7365,  &
1.0010, 1.0021, 1.0042, 1.0088, 1.0181, 1.0375, 1.0800, 1.1792, 1.4491,  &
1.0006, 1.0011, 1.0023, 1.0054, 1.0122, 1.0263, 1.0569, 1.1257, 1.2972,  &
1.0004, 1.0006, 1.0011, 1.0025, 1.0068, 1.0169, 1.0388, 1.0871, 1.2018 /
data ((supersat( 3,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0033, 1.0058, 1.0108, 1.0216, 1.0461, 1.1042, 1.2568, 1.8016, 3.7099,  &
1.0024, 1.0038, 1.0081, 1.0156, 1.0319, 1.0687, 1.1577, 1.4088, 2.5825,  &
1.0016, 1.0033, 1.0061, 1.0116, 1.0229, 1.0479, 1.1047, 1.2474, 1.7106,  &
1.0012, 1.0025, 1.0045, 1.0086, 1.0170, 1.0345, 1.0732, 1.1639, 1.4102,  &
1.0008, 1.0016, 1.0029, 1.0061, 1.0124, 1.0251, 1.0525, 1.1141, 1.2661,  &
1.0005, 1.0009, 1.0018, 1.0039, 1.0085, 1.0178, 1.0376, 1.0811, 1.1824,  &
1.0003, 1.0005, 1.0009, 1.0020, 1.0049, 1.0117, 1.0260, 1.0570, 1.1271 /
data ((supersat( 3,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0024, 1.0042, 1.0077, 1.0155, 1.0329, 1.0739, 1.1768, 1.4835, 2.7339,  &
1.0020, 1.0026, 1.0056, 1.0111, 1.0225, 1.0481, 1.1088, 1.2671, 1.8125,  &
1.0014, 1.0024, 1.0045, 1.0081, 1.0162, 1.0332, 1.0718, 1.1647, 1.4246,  &
1.0010, 1.0019, 1.0032, 1.0062, 1.0119, 1.0238, 1.0498, 1.1093, 1.2586,  &
1.0007, 1.0012, 1.0021, 1.0044, 1.0087, 1.0173, 1.0357, 1.0761, 1.1712,  &
1.0004, 1.0007, 1.0014, 1.0029, 1.0059, 1.0124, 1.0256, 1.0542, 1.1186,  &
1.0003, 1.0004, 1.0007, 1.0015, 1.0035, 1.0081, 1.0177, 1.0383, 1.0834 /
data ((supersat( 3,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0016, 1.0033, 1.0059, 1.0117, 1.0247, 1.0554, 1.1309, 1.3365, 2.0909,  &
1.0014, 1.0021, 1.0041, 1.0082, 1.0165, 1.0354, 1.0798, 1.1908, 1.5167,  &
1.0012, 1.0015, 1.0034, 1.0061, 1.0118, 1.0240, 1.0517, 1.1173, 1.2876,  &
1.0009, 1.0013, 1.0024, 1.0044, 1.0085, 1.0170, 1.0354, 1.0769, 1.1772,  &
1.0006, 1.0009, 1.0016, 1.0032, 1.0062, 1.0123, 1.0251, 1.0530, 1.1170,  &
1.0004, 1.0006, 1.0011, 1.0022, 1.0044, 1.0088, 1.0180, 1.0375, 1.0808,  &
1.0002, 1.0004, 1.0006, 1.0012, 1.0026, 1.0057, 1.0124, 1.0263, 1.0567 /
data ((supersat( 3,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0010, 1.0026, 1.0047, 1.0091, 1.0194, 1.0437, 1.1028, 1.2567, 1.7368,  &
1.0006, 1.0018, 1.0032, 1.0064, 1.0128, 1.0274, 1.0617, 1.1462, 1.3758,  &
1.0005, 1.0012, 1.0026, 1.0047, 1.0089, 1.0181, 1.0392, 1.0887, 1.2128,  &
1.0004, 1.0008, 1.0020, 1.0034, 1.0065, 1.0127, 1.0262, 1.0570, 1.1301,  &
1.0004, 1.0007, 1.0014, 1.0024, 1.0046, 1.0091, 1.0183, 1.0386, 1.0846,  &
1.0003, 1.0005, 1.0009, 1.0016, 1.0033, 1.0063, 1.0130, 1.0269, 1.0576,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0019, 1.0042, 1.0088, 1.0187, 1.0400 /
data ((supersat( 3,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0012, 1.0020, 1.0038, 1.0075, 1.0159, 1.0360, 1.0847, 1.2083, 1.5626,  &
1.0008, 1.0017, 1.0027, 1.0052, 1.0102, 1.0221, 1.0501, 1.1183, 1.2965,  &
1.0005, 1.0013, 1.0019, 1.0037, 1.0071, 1.0143, 1.0311, 1.0706, 1.1681,  &
1.0005, 1.0009, 1.0016, 1.0028, 1.0051, 1.0099, 1.0204, 1.0444, 1.1013,  &
1.0004, 1.0006, 1.0011, 1.0018, 1.0035, 1.0070, 1.0140, 1.0294, 1.0645,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0025, 1.0049, 1.0098, 1.0202, 1.0430,  &
1.0002, 1.0003, 1.0004, 1.0007, 1.0014, 1.0031, 1.0066, 1.0138, 1.0294 /
data ((supersat( 3,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0010, 1.0017, 1.0031, 1.0063, 1.0135, 1.0306, 1.0721, 1.1759, 1.4606,  &
1.0009, 1.0011, 1.0024, 1.0043, 1.0086, 1.0185, 1.0421, 1.0995, 1.2462,  &
1.0007, 1.0010, 1.0016, 1.0029, 1.0058, 1.0118, 1.0257, 1.0586, 1.1392,  &
1.0005, 1.0008, 1.0010, 1.0023, 1.0042, 1.0080, 1.0165, 1.0361, 1.0826,  &
1.0003, 1.0005, 1.0008, 1.0016, 1.0029, 1.0056, 1.0111, 1.0234, 1.0515,  &
1.0002, 1.0004, 1.0006, 1.0011, 1.0019, 1.0038, 1.0077, 1.0158, 1.0337,  &
1.0002, 1.0002, 1.0004, 1.0006, 1.0012, 1.0024, 1.0051, 1.0107, 1.0226 /
data ((supersat( 3,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0044, 1.0079, 1.0153, 1.0312, 1.0676, 1.1558, 1.4081, 2.7000, 4.9771,  &
1.0032, 1.0058, 1.0112, 1.0225, 1.0469, 1.1028, 1.2440, 1.7105, 3.9998,  &
1.0021, 1.0044, 1.0082, 1.0166, 1.0338, 1.0716, 1.1606, 1.4035, 2.5241,  &
1.0014, 1.0031, 1.0061, 1.0122, 1.0246, 1.0513, 1.1115, 1.2602, 1.7346,  &
1.0009, 1.0018, 1.0039, 1.0084, 1.0175, 1.0368, 1.0792, 1.1780, 1.4468,  &
1.0005, 1.0009, 1.0020, 1.0049, 1.0115, 1.0255, 1.0558, 1.1241, 1.2945,  &
1.0003, 1.0005, 1.0009, 1.0021, 1.0061, 1.0159, 1.0374, 1.0851, 1.1986 /
data ((supersat( 3,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0032, 1.0057, 1.0107, 1.0215, 1.0460, 1.1041, 1.2567, 1.8013, 3.7094,  &
1.0023, 1.0037, 1.0079, 1.0154, 1.0317, 1.0685, 1.1575, 1.4085, 2.5819,  &
1.0015, 1.0032, 1.0060, 1.0114, 1.0227, 1.0476, 1.1044, 1.2470, 1.7099,  &
1.0011, 1.0023, 1.0043, 1.0084, 1.0167, 1.0342, 1.0728, 1.1633, 1.4093,  &
1.0007, 1.0014, 1.0027, 1.0058, 1.0120, 1.0246, 1.0519, 1.1134, 1.2650,  &
1.0004, 1.0008, 1.0016, 1.0035, 1.0080, 1.0173, 1.0369, 1.0801, 1.1810,  &
1.0003, 1.0004, 1.0008, 1.0017, 1.0044, 1.0109, 1.0251, 1.0558, 1.1253 /
data ((supersat( 3,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0024, 1.0041, 1.0076, 1.0154, 1.0329, 1.0738, 1.1767, 1.4834, 2.7337,  &
1.0019, 1.0026, 1.0054, 1.0110, 1.0224, 1.0480, 1.1087, 1.2669, 1.8123,  &
1.0013, 1.0023, 1.0044, 1.0079, 1.0160, 1.0330, 1.0716, 1.1645, 1.4243,  &
1.0009, 1.0018, 1.0030, 1.0060, 1.0117, 1.0236, 1.0496, 1.1090, 1.2581,  &
1.0006, 1.0011, 1.0020, 1.0041, 1.0085, 1.0169, 1.0353, 1.0757, 1.1705,  &
1.0004, 1.0006, 1.0012, 1.0026, 1.0056, 1.0120, 1.0251, 1.0536, 1.1178,  &
1.0002, 1.0004, 1.0006, 1.0013, 1.0031, 1.0076, 1.0171, 1.0375, 1.0823 /
data ((supersat( 3,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0015, 1.0032, 1.0058, 1.0116, 1.0246, 1.0553, 1.1308, 1.3364, 2.0909,  &
1.0014, 1.0020, 1.0041, 1.0081, 1.0164, 1.0353, 1.0797, 1.1907, 1.5166,  &
1.0011, 1.0014, 1.0033, 1.0060, 1.0116, 1.0239, 1.0516, 1.1171, 1.2874,  &
1.0008, 1.0012, 1.0023, 1.0043, 1.0083, 1.0168, 1.0352, 1.0767, 1.1769,  &
1.0005, 1.0008, 1.0015, 1.0031, 1.0059, 1.0121, 1.0248, 1.0527, 1.1166,  &
1.0003, 1.0005, 1.0010, 1.0020, 1.0041, 1.0085, 1.0176, 1.0370, 1.0802,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0023, 1.0053, 1.0119, 1.0257, 1.0559 /
data ((supersat( 3,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0010, 1.0026, 1.0046, 1.0091, 1.0194, 1.0437, 1.1028, 1.2566, 1.7367,  &
1.0006, 1.0018, 1.0031, 1.0063, 1.0127, 1.0273, 1.0617, 1.1462, 1.3757,  &
1.0005, 1.0011, 1.0026, 1.0046, 1.0088, 1.0180, 1.0390, 1.0886, 1.2127,  &
1.0004, 1.0008, 1.0019, 1.0032, 1.0064, 1.0125, 1.0261, 1.0568, 1.1299,  &
1.0004, 1.0007, 1.0013, 1.0023, 1.0045, 1.0088, 1.0181, 1.0383, 1.0843,  &
1.0003, 1.0004, 1.0008, 1.0014, 1.0031, 1.0061, 1.0127, 1.0266, 1.0572,  &
1.0002, 1.0003, 1.0004, 1.0008, 1.0017, 1.0039, 1.0085, 1.0183, 1.0394 /
data ((supersat( 3,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0012, 1.0019, 1.0037, 1.0074, 1.0158, 1.0360, 1.0847, 1.2082, 1.5625,  &
1.0007, 1.0016, 1.0026, 1.0051, 1.0102, 1.0220, 1.0501, 1.1183, 1.2965,  &
1.0005, 1.0012, 1.0019, 1.0037, 1.0070, 1.0142, 1.0310, 1.0706, 1.1680,  &
1.0004, 1.0008, 1.0015, 1.0027, 1.0050, 1.0097, 1.0202, 1.0443, 1.1011,  &
1.0004, 1.0006, 1.0010, 1.0017, 1.0034, 1.0069, 1.0138, 1.0292, 1.0643,  &
1.0002, 1.0004, 1.0006, 1.0011, 1.0023, 1.0046, 1.0096, 1.0199, 1.0427,  &
1.0002, 1.0002, 1.0004, 1.0006, 1.0013, 1.0029, 1.0063, 1.0135, 1.0290 /
data ((supersat( 3,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0010, 1.0016, 1.0031, 1.0062, 1.0134, 1.0306, 1.0720, 1.1759, 1.4606,  &
1.0009, 1.0010, 1.0023, 1.0042, 1.0085, 1.0184, 1.0421, 1.0995, 1.2462,  &
1.0007, 1.0009, 1.0015, 1.0029, 1.0057, 1.0117, 1.0256, 1.0585, 1.1391,  &
1.0005, 1.0007, 1.0010, 1.0023, 1.0041, 1.0078, 1.0164, 1.0360, 1.0825,  &
1.0003, 1.0004, 1.0007, 1.0015, 1.0027, 1.0055, 1.0110, 1.0232, 1.0514,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0018, 1.0036, 1.0075, 1.0155, 1.0334,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0022, 1.0048, 1.0104, 1.0222 /
data ((supersat( 4,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0049, 1.0084, 1.0160, 1.0319, 1.0682, 1.1565, 1.4091, 2.7024, 4.9806,  &
1.0038, 1.0067, 1.0120, 1.0234, 1.0478, 1.1038, 1.2453, 1.7128, 4.0072,  &
1.0026, 1.0049, 1.0094, 1.0176, 1.0350, 1.0730, 1.1624, 1.4064, 2.5316,  &
1.0018, 1.0040, 1.0073, 1.0135, 1.0262, 1.0533, 1.1140, 1.2639, 1.7421,  &
1.0014, 1.0028, 1.0052, 1.0100, 1.0196, 1.0394, 1.0825, 1.1828, 1.4556,  &
1.0009, 1.0016, 1.0033, 1.0069, 1.0141, 1.0289, 1.0602, 1.1304, 1.3050,  &
1.0006, 1.0009, 1.0018, 1.0040, 1.0091, 1.0200, 1.0429, 1.0931, 1.2114 /
data ((supersat( 4,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0036, 1.0062, 1.0113, 1.0220, 1.0465, 1.1046, 1.2572, 1.8021, 3.7115,  &
1.0028, 1.0044, 1.0086, 1.0162, 1.0324, 1.0692, 1.1583, 1.4096, 2.5846,  &
1.0019, 1.0036, 1.0066, 1.0122, 1.0237, 1.0486, 1.1055, 1.2486, 1.7126,  &
1.0014, 1.0030, 1.0052, 1.0093, 1.0178, 1.0355, 1.0743, 1.1654, 1.4127,  &
1.0011, 1.0021, 1.0035, 1.0070, 1.0135, 1.0264, 1.0541, 1.1162, 1.2693,  &
1.0008, 1.0013, 1.0024, 1.0049, 1.0099, 1.0195, 1.0398, 1.0838, 1.1866,  &
1.0005, 1.0008, 1.0014, 1.0030, 1.0064, 1.0138, 1.0287, 1.0607, 1.1324 /
data ((supersat( 4,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0026, 1.0046, 1.0080, 1.0159, 1.0333, 1.0742, 1.1770, 1.4838, 2.7347,  &
1.0022, 1.0031, 1.0061, 1.0116, 1.0229, 1.0485, 1.1092, 1.2675, 1.8132,  &
1.0017, 1.0026, 1.0049, 1.0087, 1.0167, 1.0337, 1.0723, 1.1654, 1.4255,  &
1.0012, 1.0022, 1.0037, 1.0068, 1.0126, 1.0246, 1.0507, 1.1103, 1.2599,  &
1.0009, 1.0017, 1.0025, 1.0049, 1.0096, 1.0183, 1.0368, 1.0775, 1.1731,  &
1.0006, 1.0011, 1.0017, 1.0037, 1.0069, 1.0136, 1.0271, 1.0561, 1.1211,  &
1.0004, 1.0007, 1.0012, 1.0023, 1.0047, 1.0096, 1.0197, 1.0407, 1.0868 /
data ((supersat( 4,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0016, 1.0036, 1.0062, 1.0120, 1.0250, 1.0556, 1.1310, 1.3367, 2.0912,  &
1.0015, 1.0025, 1.0045, 1.0086, 1.0169, 1.0357, 1.0800, 1.1910, 1.5171,  &
1.0014, 1.0016, 1.0038, 1.0064, 1.0123, 1.0245, 1.0521, 1.1177, 1.2882,  &
1.0011, 1.0014, 1.0028, 1.0050, 1.0091, 1.0176, 1.0360, 1.0776, 1.1780,  &
1.0008, 1.0012, 1.0019, 1.0037, 1.0069, 1.0131, 1.0260, 1.0540, 1.1182,  &
1.0005, 1.0007, 1.0014, 1.0028, 1.0051, 1.0098, 1.0191, 1.0388, 1.0825,  &
1.0004, 1.0005, 1.0009, 1.0017, 1.0034, 1.0069, 1.0138, 1.0282, 1.0590 /
data ((supersat( 4,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0013, 1.0028, 1.0049, 1.0095, 1.0197, 1.0439, 1.1030, 1.2568, 1.7368,  &
1.0007, 1.0022, 1.0036, 1.0067, 1.0131, 1.0276, 1.0619, 1.1464, 1.3760,  &
1.0006, 1.0014, 1.0029, 1.0050, 1.0092, 1.0185, 1.0395, 1.0890, 1.2131,  &
1.0005, 1.0009, 1.0023, 1.0038, 1.0070, 1.0131, 1.0267, 1.0575, 1.1306,  &
1.0004, 1.0008, 1.0017, 1.0027, 1.0050, 1.0097, 1.0190, 1.0393, 1.0854,  &
1.0004, 1.0007, 1.0012, 1.0021, 1.0039, 1.0071, 1.0139, 1.0280, 1.0588,  &
1.0003, 1.0005, 1.0007, 1.0013, 1.0026, 1.0051, 1.0100, 1.0201, 1.0417 /
data ((supersat( 4,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0014, 1.0020, 1.0039, 1.0078, 1.0161, 1.0362, 1.0848, 1.2084, 1.5626,  &
1.0009, 1.0018, 1.0030, 1.0055, 1.0105, 1.0223, 1.0503, 1.1185, 1.2967,  &
1.0006, 1.0015, 1.0020, 1.0040, 1.0074, 1.0147, 1.0313, 1.0709, 1.1683,  &
1.0005, 1.0011, 1.0018, 1.0031, 1.0055, 1.0103, 1.0208, 1.0448, 1.1016,  &
1.0004, 1.0008, 1.0014, 1.0021, 1.0039, 1.0075, 1.0146, 1.0300, 1.0651,  &
1.0004, 1.0006, 1.0010, 1.0015, 1.0030, 1.0054, 1.0106, 1.0210, 1.0440,  &
1.0003, 1.0004, 1.0006, 1.0011, 1.0020, 1.0039, 1.0075, 1.0150, 1.0307 /
data ((supersat( 4,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0011, 1.0019, 1.0034, 1.0066, 1.0137, 1.0307, 1.0721, 1.1759, 1.4607,  &
1.0010, 1.0011, 1.0026, 1.0045, 1.0088, 1.0187, 1.0423, 1.0996, 1.2463,  &
1.0008, 1.0010, 1.0019, 1.0032, 1.0061, 1.0121, 1.0259, 1.0588, 1.1393,  &
1.0006, 1.0009, 1.0012, 1.0026, 1.0045, 1.0084, 1.0168, 1.0364, 1.0829,  &
1.0005, 1.0007, 1.0009, 1.0019, 1.0033, 1.0061, 1.0117, 1.0239, 1.0520,  &
1.0003, 1.0005, 1.0007, 1.0013, 1.0024, 1.0043, 1.0084, 1.0165, 1.0344,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0016, 1.0031, 1.0059, 1.0116, 1.0237 /
data ((supersat( 4,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0045, 1.0080, 1.0155, 1.0314, 1.0677, 1.1560, 1.4084, 2.7007, 4.9781,  &
1.0033, 1.0060, 1.0113, 1.0227, 1.0471, 1.1031, 1.2443, 1.7112, 4.0020,  &
1.0022, 1.0045, 1.0085, 1.0168, 1.0341, 1.0720, 1.1611, 1.4044, 2.5264,  &
1.0015, 1.0033, 1.0064, 1.0125, 1.0250, 1.0519, 1.1122, 1.2612, 1.7368,  &
1.0010, 1.0021, 1.0042, 1.0088, 1.0181, 1.0375, 1.0801, 1.1794, 1.4495,  &
1.0006, 1.0011, 1.0023, 1.0054, 1.0122, 1.0264, 1.0570, 1.1260, 1.2977,  &
1.0004, 1.0006, 1.0011, 1.0025, 1.0069, 1.0170, 1.0390, 1.0874, 1.2023 /
data ((supersat( 4,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0033, 1.0058, 1.0108, 1.0216, 1.0461, 1.1042, 1.2568, 1.8015, 3.7099,  &
1.0024, 1.0038, 1.0081, 1.0156, 1.0319, 1.0687, 1.1577, 1.4088, 2.5828,  &
1.0016, 1.0033, 1.0061, 1.0116, 1.0229, 1.0479, 1.1047, 1.2474, 1.7107,  &
1.0012, 1.0025, 1.0045, 1.0086, 1.0170, 1.0345, 1.0732, 1.1639, 1.4103,  &
1.0008, 1.0016, 1.0029, 1.0061, 1.0124, 1.0251, 1.0525, 1.1142, 1.2663,  &
1.0005, 1.0009, 1.0018, 1.0039, 1.0085, 1.0179, 1.0377, 1.0812, 1.1826,  &
1.0003, 1.0005, 1.0009, 1.0020, 1.0049, 1.0117, 1.0261, 1.0572, 1.1274 /
data ((supersat( 4,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0024, 1.0042, 1.0077, 1.0155, 1.0329, 1.0739, 1.1768, 1.4835, 2.7340,  &
1.0020, 1.0026, 1.0056, 1.0111, 1.0225, 1.0481, 1.1088, 1.2670, 1.8125,  &
1.0014, 1.0024, 1.0045, 1.0081, 1.0162, 1.0332, 1.0718, 1.1647, 1.4246,  &
1.0010, 1.0019, 1.0032, 1.0062, 1.0119, 1.0238, 1.0498, 1.1094, 1.2586,  &
1.0007, 1.0012, 1.0021, 1.0044, 1.0088, 1.0173, 1.0357, 1.0762, 1.1712,  &
1.0004, 1.0007, 1.0014, 1.0029, 1.0059, 1.0124, 1.0257, 1.0543, 1.1188,  &
1.0003, 1.0004, 1.0007, 1.0015, 1.0035, 1.0081, 1.0178, 1.0384, 1.0836 /
data ((supersat( 4,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0016, 1.0033, 1.0059, 1.0117, 1.0247, 1.0554, 1.1308, 1.3365, 2.0910,  &
1.0014, 1.0021, 1.0041, 1.0082, 1.0165, 1.0354, 1.0797, 1.1907, 1.5167,  &
1.0012, 1.0015, 1.0034, 1.0061, 1.0118, 1.0240, 1.0517, 1.1173, 1.2876,  &
1.0009, 1.0013, 1.0024, 1.0044, 1.0085, 1.0170, 1.0354, 1.0769, 1.1772,  &
1.0006, 1.0009, 1.0016, 1.0032, 1.0062, 1.0123, 1.0251, 1.0530, 1.1171,  &
1.0004, 1.0006, 1.0011, 1.0022, 1.0044, 1.0088, 1.0180, 1.0375, 1.0809,  &
1.0002, 1.0004, 1.0006, 1.0012, 1.0026, 1.0057, 1.0124, 1.0264, 1.0568 /
data ((supersat( 4,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0010, 1.0026, 1.0047, 1.0091, 1.0194, 1.0437, 1.1029, 1.2567, 1.7367,  &
1.0006, 1.0019, 1.0032, 1.0064, 1.0127, 1.0274, 1.0617, 1.1462, 1.3758,  &
1.0005, 1.0012, 1.0026, 1.0047, 1.0089, 1.0181, 1.0392, 1.0887, 1.2128,  &
1.0004, 1.0008, 1.0020, 1.0034, 1.0065, 1.0127, 1.0262, 1.0570, 1.1301,  &
1.0004, 1.0007, 1.0014, 1.0024, 1.0046, 1.0091, 1.0183, 1.0386, 1.0846,  &
1.0003, 1.0005, 1.0009, 1.0016, 1.0033, 1.0063, 1.0130, 1.0269, 1.0576,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0019, 1.0042, 1.0089, 1.0188, 1.0401 /
data ((supersat( 4,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0012, 1.0020, 1.0038, 1.0075, 1.0159, 1.0360, 1.0847, 1.2083, 1.5626,  &
1.0007, 1.0017, 1.0027, 1.0052, 1.0102, 1.0221, 1.0501, 1.1183, 1.2965,  &
1.0005, 1.0013, 1.0019, 1.0037, 1.0071, 1.0143, 1.0311, 1.0706, 1.1681,  &
1.0005, 1.0009, 1.0016, 1.0028, 1.0051, 1.0099, 1.0204, 1.0444, 1.1013,  &
1.0004, 1.0006, 1.0011, 1.0018, 1.0035, 1.0070, 1.0140, 1.0294, 1.0645,  &
1.0003, 1.0004, 1.0007, 1.0012, 1.0025, 1.0049, 1.0098, 1.0202, 1.0431,  &
1.0002, 1.0003, 1.0004, 1.0007, 1.0014, 1.0031, 1.0066, 1.0139, 1.0294 /
data ((supersat( 4,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0010, 1.0017, 1.0032, 1.0063, 1.0135, 1.0306, 1.0721, 1.1759, 1.4606,  &
1.0009, 1.0011, 1.0024, 1.0043, 1.0086, 1.0185, 1.0421, 1.0995, 1.2462,  &
1.0007, 1.0010, 1.0016, 1.0029, 1.0058, 1.0118, 1.0257, 1.0586, 1.1391,  &
1.0005, 1.0008, 1.0010, 1.0023, 1.0042, 1.0080, 1.0165, 1.0361, 1.0826,  &
1.0003, 1.0005, 1.0008, 1.0016, 1.0029, 1.0056, 1.0111, 1.0234, 1.0516,  &
1.0002, 1.0004, 1.0006, 1.0011, 1.0019, 1.0038, 1.0077, 1.0158, 1.0337,  &
1.0002, 1.0002, 1.0004, 1.0006, 1.0012, 1.0024, 1.0051, 1.0107, 1.0226 /
data ((supersat( 4,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0041, 1.0076, 1.0149, 1.0309, 1.0673, 1.1554, 1.4076, 2.6987, 4.9749,  &
1.0028, 1.0054, 1.0108, 1.0221, 1.0464, 1.1023, 1.2432, 1.7092, 3.9956,  &
1.0018, 1.0040, 1.0077, 1.0160, 1.0331, 1.0708, 1.1595, 1.4019, 2.5200,  &
1.0012, 1.0026, 1.0055, 1.0114, 1.0237, 1.0503, 1.1101, 1.2581, 1.7303,  &
1.0007, 1.0013, 1.0032, 1.0075, 1.0164, 1.0354, 1.0774, 1.1752, 1.4420,  &
1.0004, 1.0007, 1.0014, 1.0039, 1.0101, 1.0237, 1.0535, 1.1207, 1.2887,  &
1.0003, 1.0004, 1.0007, 1.0014, 1.0046, 1.0137, 1.0343, 1.0807, 1.1913 /
data ((supersat( 4,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0030, 1.0054, 1.0104, 1.0212, 1.0458, 1.1039, 1.2564, 1.8009, 3.7082,  &
1.0021, 1.0036, 1.0076, 1.0150, 1.0314, 1.0682, 1.1571, 1.4079, 2.5804,  &
1.0014, 1.0029, 1.0056, 1.0110, 1.0223, 1.0471, 1.1038, 1.2462, 1.7084,  &
1.0010, 1.0020, 1.0038, 1.0079, 1.0161, 1.0334, 1.0719, 1.1621, 1.4074,  &
1.0006, 1.0010, 1.0023, 1.0051, 1.0112, 1.0237, 1.0508, 1.1118, 1.2626,  &
1.0003, 1.0006, 1.0011, 1.0028, 1.0071, 1.0161, 1.0354, 1.0781, 1.1778,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0033, 1.0094, 1.0231, 1.0531, 1.1213 /
data ((supersat( 4,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0022, 1.0039, 1.0074, 1.0152, 1.0327, 1.0737, 1.1765, 1.4832, 2.7331,  &
1.0017, 1.0025, 1.0052, 1.0107, 1.0221, 1.0478, 1.1084, 1.2666, 1.8117,  &
1.0011, 1.0021, 1.0041, 1.0076, 1.0156, 1.0326, 1.0712, 1.1639, 1.4235,  &
1.0008, 1.0015, 1.0027, 1.0056, 1.0112, 1.0231, 1.0490, 1.1083, 1.2570,  &
1.0005, 1.0008, 1.0017, 1.0037, 1.0079, 1.0163, 1.0345, 1.0747, 1.1691,  &
1.0003, 1.0005, 1.0009, 1.0021, 1.0049, 1.0111, 1.0241, 1.0522, 1.1159,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0024, 1.0065, 1.0157, 1.0357, 1.0798 /
data ((supersat( 4,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0015, 1.0030, 1.0057, 1.0114, 1.0245, 1.0552, 1.1307, 1.3363, 2.0905,  &
1.0013, 1.0018, 1.0039, 1.0079, 1.0162, 1.0351, 1.0795, 1.1904, 1.5162,  &
1.0010, 1.0014, 1.0031, 1.0057, 1.0113, 1.0236, 1.0513, 1.1168, 1.2870,  &
1.0006, 1.0010, 1.0020, 1.0039, 1.0080, 1.0164, 1.0347, 1.0762, 1.1762,  &
1.0004, 1.0007, 1.0013, 1.0027, 1.0055, 1.0116, 1.0242, 1.0520, 1.1157,  &
1.0002, 1.0004, 1.0007, 1.0015, 1.0036, 1.0078, 1.0168, 1.0361, 1.0790,  &
1.0002, 1.0002, 1.0004, 1.0007, 1.0017, 1.0045, 1.0108, 1.0244, 1.0543 /
data ((supersat( 4,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0009, 1.0024, 1.0044, 1.0089, 1.0192, 1.0436, 1.1027, 1.2566, 1.7365,  &
1.0006, 1.0016, 1.0029, 1.0061, 1.0125, 1.0271, 1.0616, 1.1460, 1.3755,  &
1.0005, 1.0010, 1.0024, 1.0044, 1.0085, 1.0178, 1.0388, 1.0884, 1.2124,  &
1.0004, 1.0008, 1.0017, 1.0030, 1.0061, 1.0122, 1.0257, 1.0565, 1.1295,  &
1.0003, 1.0006, 1.0011, 1.0020, 1.0041, 1.0084, 1.0176, 1.0378, 1.0837,  &
1.0002, 1.0003, 1.0006, 1.0012, 1.0026, 1.0056, 1.0120, 1.0258, 1.0563,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0013, 1.0032, 1.0076, 1.0173, 1.0382 /
data ((supersat( 4,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0010, 1.0019, 1.0036, 1.0072, 1.0157, 1.0359, 1.0846, 1.2082, 1.5624,  &
1.0006, 1.0015, 1.0024, 1.0049, 1.0100, 1.0219, 1.0500, 1.1182, 1.2963,  &
1.0005, 1.0011, 1.0018, 1.0035, 1.0068, 1.0140, 1.0308, 1.0704, 1.1678,  &
1.0004, 1.0007, 1.0013, 1.0024, 1.0048, 1.0095, 1.0200, 1.0440, 1.1008,  &
1.0003, 1.0005, 1.0008, 1.0015, 1.0031, 1.0065, 1.0134, 1.0288, 1.0639,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0020, 1.0042, 1.0090, 1.0193, 1.0421,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0023, 1.0056, 1.0126, 1.0280 /
data ((supersat( 4,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0010, 1.0014, 1.0029, 1.0061, 1.0133, 1.0305, 1.0720, 1.1758, 1.4606,  &
1.0008, 1.0010, 1.0022, 1.0041, 1.0083, 1.0183, 1.0420, 1.0994, 1.2461,  &
1.0006, 1.0009, 1.0014, 1.0028, 1.0056, 1.0115, 1.0255, 1.0584, 1.1389,  &
1.0004, 1.0006, 1.0009, 1.0021, 1.0039, 1.0076, 1.0161, 1.0358, 1.0823,  &
1.0002, 1.0004, 1.0007, 1.0013, 1.0025, 1.0052, 1.0106, 1.0229, 1.0511,  &
1.0002, 1.0003, 1.0004, 1.0007, 1.0015, 1.0033, 1.0070, 1.0150, 1.0329,  &
1.0001, 1.0002, 1.0003, 1.0004, 1.0008, 1.0018, 1.0043, 1.0097, 1.0214 /
data ((supersat( 4,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0038, 1.0072, 1.0144, 1.0304, 1.0667, 1.1548, 1.4067, 2.6962, 4.9709,  &
1.0024, 1.0048, 1.0103, 1.0214, 1.0456, 1.1013, 1.2419, 1.7069, 3.9877,  &
1.0015, 1.0034, 1.0070, 1.0151, 1.0320, 1.0695, 1.1577, 1.3989, 2.5123,  &
1.0008, 1.0019, 1.0046, 1.0102, 1.0223, 1.0485, 1.1076, 1.2542, 1.7223,  &
1.0004, 1.0008, 1.0022, 1.0060, 1.0146, 1.0331, 1.0741, 1.1702, 1.4327,  &
1.0003, 1.0004, 1.0008, 1.0024, 1.0079, 1.0207, 1.0492, 1.1142, 1.2776,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0025, 1.0102, 1.0292, 1.0727, 1.1779 /
data ((supersat( 4,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0027, 1.0050, 1.0100, 1.0209, 1.0454, 1.1035, 1.2559, 1.8001, 3.7059,  &
1.0018, 1.0034, 1.0071, 1.0145, 1.0309, 1.0676, 1.1563, 1.4068, 2.5776,  &
1.0011, 1.0025, 1.0051, 1.0104, 1.0215, 1.0463, 1.1027, 1.2447, 1.7056,  &
1.0007, 1.0015, 1.0032, 1.0071, 1.0151, 1.0323, 1.0704, 1.1600, 1.4039,  &
1.0004, 1.0007, 1.0017, 1.0042, 1.0099, 1.0222, 1.0488, 1.1090, 1.2581,  &
1.0002, 1.0004, 1.0007, 1.0018, 1.0055, 1.0140, 1.0328, 1.0743, 1.1720,  &
1.0002, 1.0002, 1.0004, 1.0007, 1.0019, 1.0070, 1.0197, 1.0483, 1.1139 /
data ((supersat( 4,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0020, 1.0036, 1.0072, 1.0149, 1.0324, 1.0734, 1.1762, 1.4828, 2.7320,  &
1.0014, 1.0024, 1.0050, 1.0103, 1.0217, 1.0474, 1.1080, 1.2660, 1.8107,  &
1.0009, 1.0018, 1.0037, 1.0072, 1.0150, 1.0320, 1.0705, 1.1631, 1.4222,  &
1.0005, 1.0011, 1.0023, 1.0049, 1.0105, 1.0222, 1.0480, 1.1070, 1.2552,  &
1.0003, 1.0006, 1.0013, 1.0029, 1.0069, 1.0152, 1.0331, 1.0729, 1.1666,  &
1.0002, 1.0003, 1.0006, 1.0014, 1.0038, 1.0096, 1.0222, 1.0498, 1.1124,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0014, 1.0047, 1.0133, 1.0325, 1.0753 /
data ((supersat( 4,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0014, 1.0027, 1.0054, 1.0112, 1.0243, 1.0551, 1.1305, 1.3361, 2.0902,  &
1.0011, 1.0016, 1.0037, 1.0076, 1.0159, 1.0349, 1.0792, 1.1901, 1.5158,  &
1.0008, 1.0012, 1.0027, 1.0054, 1.0109, 1.0231, 1.0508, 1.1162, 1.2862,  &
1.0004, 1.0008, 1.0017, 1.0035, 1.0075, 1.0158, 1.0340, 1.0754, 1.1751,  &
1.0003, 1.0005, 1.0010, 1.0021, 1.0048, 1.0107, 1.0232, 1.0508, 1.1141,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0027, 1.0067, 1.0154, 1.0344, 1.0768,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0032, 1.0091, 1.0222, 1.0512 /
data ((supersat( 4,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0007, 1.0022, 1.0042, 1.0087, 1.0191, 1.0435, 1.1026, 1.2564, 1.7363,  &
1.0005, 1.0014, 1.0028, 1.0059, 1.0122, 1.0269, 1.0614, 1.1458, 1.3752,  &
1.0004, 1.0009, 1.0021, 1.0041, 1.0082, 1.0174, 1.0385, 1.0880, 1.2119,  &
1.0004, 1.0006, 1.0014, 1.0026, 1.0056, 1.0117, 1.0252, 1.0559, 1.1288,  &
1.0002, 1.0004, 1.0007, 1.0016, 1.0036, 1.0077, 1.0169, 1.0369, 1.0826,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0019, 1.0047, 1.0110, 1.0246, 1.0547,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0022, 1.0062, 1.0156, 1.0360 /
data ((supersat( 4,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0009, 1.0018, 1.0034, 1.0071, 1.0156, 1.0358, 1.0845, 1.2081, 1.5623,  &
1.0006, 1.0013, 1.0022, 1.0047, 1.0098, 1.0217, 1.0498, 1.1180, 1.2962,  &
1.0004, 1.0009, 1.0016, 1.0032, 1.0065, 1.0138, 1.0306, 1.0701, 1.1675,  &
1.0003, 1.0006, 1.0011, 1.0021, 1.0044, 1.0091, 1.0196, 1.0436, 1.1004,  &
1.0002, 1.0003, 1.0006, 1.0013, 1.0027, 1.0059, 1.0128, 1.0281, 1.0631,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0014, 1.0035, 1.0082, 1.0183, 1.0409,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0016, 1.0045, 1.0113, 1.0263 /
data ((supersat( 4,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0009, 1.0013, 1.0028, 1.0060, 1.0132, 1.0305, 1.0719, 1.1757, 1.4605,  &
1.0007, 1.0009, 1.0020, 1.0039, 1.0082, 1.0182, 1.0419, 1.0993, 1.2460,  &
1.0005, 1.0007, 1.0012, 1.0026, 1.0053, 1.0113, 1.0253, 1.0582, 1.1387,  &
1.0003, 1.0004, 1.0008, 1.0018, 1.0035, 1.0073, 1.0158, 1.0355, 1.0819,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0022, 1.0047, 1.0101, 1.0224, 1.0505,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0027, 1.0063, 1.0142, 1.0320,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0012, 1.0034, 1.0085, 1.0201 /
data ((supersat( 4,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0035, 1.0070, 1.0142, 1.0301, 1.0664, 1.1543, 1.4061, 2.6945, 4.9683,  &
1.0022, 1.0045, 1.0099, 1.0210, 1.0452, 1.1007, 1.2410, 1.7052, 3.9821,  &
1.0013, 1.0030, 1.0066, 1.0146, 1.0314, 1.0686, 1.1565, 1.3968, 2.5068,  &
1.0006, 1.0015, 1.0040, 1.0095, 1.0214, 1.0473, 1.1060, 1.2515, 1.7167,  &
1.0003, 1.0006, 1.0016, 1.0051, 1.0134, 1.0315, 1.0719, 1.1668, 1.4263,  &
1.0002, 1.0003, 1.0006, 1.0017, 1.0065, 1.0187, 1.0464, 1.1099, 1.2699,  &
1.0002, 1.0003, 1.0004, 1.0007, 1.0017, 1.0080, 1.0258, 1.0673, 1.1688 /
data ((supersat( 4,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0025, 1.0048, 1.0098, 1.0207, 1.0452, 1.1033, 1.2556, 1.7996, 3.7044,  &
1.0016, 1.0032, 1.0068, 1.0142, 1.0305, 1.0672, 1.1558, 1.4061, 2.5756,  &
1.0010, 1.0022, 1.0048, 1.0100, 1.0211, 1.0457, 1.1020, 1.2436, 1.7037,  &
1.0005, 1.0011, 1.0028, 1.0066, 1.0145, 1.0315, 1.0695, 1.1586, 1.4015,  &
1.0003, 1.0005, 1.0013, 1.0036, 1.0091, 1.0211, 1.0475, 1.1070, 1.2549,  &
1.0002, 1.0003, 1.0005, 1.0013, 1.0045, 1.0127, 1.0310, 1.0718, 1.1680,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0013, 1.0055, 1.0175, 1.0451, 1.1089 /
data ((supersat( 4,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0019, 1.0034, 1.0070, 1.0148, 1.0323, 1.0733, 1.1760, 1.4825, 2.7313,  &
1.0013, 1.0022, 1.0048, 1.0101, 1.0215, 1.0471, 1.1077, 1.2656, 1.8101,  &
1.0008, 1.0016, 1.0034, 1.0069, 1.0147, 1.0317, 1.0701, 1.1625, 1.4212,  &
1.0004, 1.0008, 1.0020, 1.0046, 1.0100, 1.0217, 1.0474, 1.1062, 1.2539,  &
1.0002, 1.0004, 1.0010, 1.0025, 1.0063, 1.0145, 1.0322, 1.0717, 1.1648,  &
1.0002, 1.0002, 1.0004, 1.0010, 1.0031, 1.0087, 1.0210, 1.0482, 1.1101,  &
1.0001, 1.0002, 1.0003, 1.0004, 1.0010, 1.0037, 1.0118, 1.0304, 1.0723 /
data ((supersat( 4,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0013, 1.0026, 1.0053, 1.0110, 1.0242, 1.0550, 1.1303, 1.3359, 2.0899,  &
1.0010, 1.0015, 1.0036, 1.0075, 1.0157, 1.0347, 1.0790, 1.1898, 1.5154,  &
1.0006, 1.0010, 1.0025, 1.0051, 1.0106, 1.0229, 1.0505, 1.1159, 1.2857,  &
1.0004, 1.0007, 1.0015, 1.0032, 1.0071, 1.0154, 1.0336, 1.0749, 1.1744,  &
1.0002, 1.0004, 1.0007, 1.0018, 1.0044, 1.0102, 1.0226, 1.0500, 1.1130,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0022, 1.0060, 1.0145, 1.0333, 1.0752,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0025, 1.0079, 1.0207, 1.0492 /
data ((supersat( 4,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0007, 1.0021, 1.0041, 1.0086, 1.0190, 1.0434, 1.1025, 1.2563, 1.7362,  &
1.0005, 1.0013, 1.0027, 1.0057, 1.0121, 1.0268, 1.0612, 1.1456, 1.3750,  &
1.0004, 1.0008, 1.0020, 1.0039, 1.0080, 1.0172, 1.0383, 1.0877, 1.2116,  &
1.0003, 1.0006, 1.0012, 1.0024, 1.0054, 1.0114, 1.0249, 1.0556, 1.1283,  &
1.0002, 1.0003, 1.0006, 1.0014, 1.0032, 1.0073, 1.0164, 1.0364, 1.0819,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0016, 1.0042, 1.0103, 1.0237, 1.0537,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0017, 1.0054, 1.0144, 1.0345 /
data ((supersat( 4,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0008, 1.0017, 1.0033, 1.0070, 1.0155, 1.0358, 1.0844, 1.2080, 1.5622,  &
1.0005, 1.0012, 1.0021, 1.0046, 1.0097, 1.0216, 1.0497, 1.1179, 1.2960,  &
1.0004, 1.0008, 1.0015, 1.0031, 1.0063, 1.0136, 1.0304, 1.0700, 1.1673,  &
1.0003, 1.0005, 1.0009, 1.0019, 1.0042, 1.0088, 1.0193, 1.0433, 1.1000,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0024, 1.0056, 1.0124, 1.0277, 1.0626,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0012, 1.0031, 1.0076, 1.0177, 1.0401,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0012, 1.0038, 1.0104, 1.0252 /
data ((supersat( 4,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0008, 1.0012, 1.0027, 1.0059, 1.0132, 1.0304, 1.0719, 1.1757, 1.4604,  &
1.0006, 1.0009, 1.0019, 1.0038, 1.0081, 1.0181, 1.0418, 1.0992, 1.2459,  &
1.0004, 1.0006, 1.0011, 1.0024, 1.0052, 1.0112, 1.0251, 1.0581, 1.1386,  &
1.0002, 1.0004, 1.0007, 1.0016, 1.0034, 1.0071, 1.0156, 1.0353, 1.0817,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0020, 1.0044, 1.0098, 1.0220, 1.0501,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0009, 1.0024, 1.0059, 1.0137, 1.0314,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0009, 1.0028, 1.0078, 1.0192 /
data ((supersat( 4,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0034, 1.0068, 1.0140, 1.0299, 1.0662, 1.1540, 1.4056, 2.6932, 4.9662,  &
1.0021, 1.0043, 1.0097, 1.0207, 1.0448, 1.1002, 1.2404, 1.7039, 3.9777,  &
1.0012, 1.0027, 1.0062, 1.0141, 1.0308, 1.0680, 1.1555, 1.3952, 2.5024,  &
1.0005, 1.0013, 1.0036, 1.0089, 1.0207, 1.0464, 1.1047, 1.2494, 1.7123,  &
1.0003, 1.0005, 1.0013, 1.0044, 1.0125, 1.0303, 1.0702, 1.1641, 1.4213,  &
1.0002, 1.0003, 1.0005, 1.0013, 1.0055, 1.0172, 1.0442, 1.1064, 1.2639,  &
1.0001, 1.0002, 1.0004, 1.0007, 1.0014, 1.0065, 1.0233, 1.0634, 1.1618 /
data ((supersat( 4,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0024, 1.0047, 1.0097, 1.0205, 1.0451, 1.1031, 1.2554, 1.7992, 3.7031,  &
1.0015, 1.0031, 1.0066, 1.0140, 1.0303, 1.0670, 1.1555, 1.4055, 2.5740,  &
1.0009, 1.0020, 1.0045, 1.0097, 1.0208, 1.0453, 1.1015, 1.2428, 1.7021,  &
1.0004, 1.0010, 1.0026, 1.0062, 1.0140, 1.0309, 1.0687, 1.1575, 1.3996,  &
1.0002, 1.0004, 1.0010, 1.0032, 1.0085, 1.0204, 1.0464, 1.1056, 1.2525,  &
1.0002, 1.0002, 1.0004, 1.0010, 1.0038, 1.0117, 1.0296, 1.0698, 1.1649,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0045, 1.0159, 1.0427, 1.1050 /
data ((supersat( 4,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0018, 1.0033, 1.0069, 1.0147, 1.0322, 1.0732, 1.1759, 1.4823, 2.7307,  &
1.0012, 1.0022, 1.0047, 1.0099, 1.0213, 1.0469, 1.1075, 1.2653, 1.8095,  &
1.0007, 1.0015, 1.0032, 1.0067, 1.0145, 1.0314, 1.0697, 1.1620, 1.4205,  &
1.0004, 1.0007, 1.0018, 1.0043, 1.0097, 1.0213, 1.0469, 1.1055, 1.2529,  &
1.0002, 1.0004, 1.0008, 1.0022, 1.0059, 1.0139, 1.0315, 1.0708, 1.1634,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0027, 1.0080, 1.0201, 1.0470, 1.1082,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0030, 1.0107, 1.0288, 1.0699 /
data ((supersat( 4,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0013, 1.0025, 1.0052, 1.0110, 1.0241, 1.0549, 1.1303, 1.3358, 2.0897,  &
1.0009, 1.0014, 1.0035, 1.0073, 1.0156, 1.0346, 1.0789, 1.1897, 1.5152,  &
1.0005, 1.0009, 1.0024, 1.0050, 1.0105, 1.0227, 1.0503, 1.1156, 1.2853,  &
1.0003, 1.0006, 1.0014, 1.0030, 1.0069, 1.0151, 1.0333, 1.0744, 1.1738,  &
1.0002, 1.0003, 1.0006, 1.0016, 1.0041, 1.0098, 1.0221, 1.0494, 1.1122,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0018, 1.0055, 1.0139, 1.0324, 1.0741,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0020, 1.0071, 1.0196, 1.0476 /
data ((supersat( 4,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0007, 1.0021, 1.0041, 1.0085, 1.0190, 1.0434, 1.1025, 1.2563, 1.7361,  &
1.0005, 1.0013, 1.0026, 1.0056, 1.0120, 1.0267, 1.0611, 1.1455, 1.3749,  &
1.0004, 1.0008, 1.0019, 1.0038, 1.0079, 1.0171, 1.0381, 1.0875, 1.2114,  &
1.0003, 1.0005, 1.0011, 1.0023, 1.0052, 1.0112, 1.0246, 1.0553, 1.1279,  &
1.0002, 1.0003, 1.0005, 1.0012, 1.0029, 1.0070, 1.0160, 1.0359, 1.0813,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0013, 1.0038, 1.0098, 1.0231, 1.0529,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0013, 1.0048, 1.0136, 1.0334 /
data ((supersat( 4,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0008, 1.0017, 1.0033, 1.0069, 1.0155, 1.0357, 1.0844, 1.2080, 1.5622,  &
1.0005, 1.0012, 1.0020, 1.0045, 1.0096, 1.0216, 1.0496, 1.1178, 1.2959,  &
1.0004, 1.0007, 1.0014, 1.0030, 1.0062, 1.0135, 1.0303, 1.0698, 1.1672,  &
1.0002, 1.0004, 1.0008, 1.0018, 1.0040, 1.0086, 1.0191, 1.0431, 1.0998,  &
1.0001, 1.0002, 1.0004, 1.0009, 1.0022, 1.0053, 1.0121, 1.0273, 1.0622,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0028, 1.0072, 1.0172, 1.0395,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0033, 1.0097, 1.0244 /
data ((supersat( 4,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0008, 1.0012, 1.0026, 1.0058, 1.0131, 1.0304, 1.0718, 1.1756, 1.4604,  &
1.0006, 1.0008, 1.0018, 1.0037, 1.0080, 1.0181, 1.0418, 1.0991, 1.2458,  &
1.0003, 1.0005, 1.0011, 1.0023, 1.0051, 1.0111, 1.0250, 1.0580, 1.1385,  &
1.0002, 1.0003, 1.0007, 1.0015, 1.0032, 1.0069, 1.0154, 1.0351, 1.0815,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0018, 1.0042, 1.0096, 1.0218, 1.0498,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0021, 1.0056, 1.0133, 1.0309,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0024, 1.0072, 1.0185 /
data ((supersat( 4,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0032, 1.0066, 1.0138, 1.0297, 1.0660, 1.1538, 1.4052, 2.6920, 4.9643,  &
1.0020, 1.0041, 1.0095, 1.0204, 1.0445, 1.0998, 1.2398, 1.7028, 3.9740,  &
1.0010, 1.0025, 1.0059, 1.0138, 1.0304, 1.0674, 1.1547, 1.3938, 2.4988,  &
1.0004, 1.0010, 1.0032, 1.0085, 1.0201, 1.0456, 1.1036, 1.2477, 1.7086,  &
1.0002, 1.0004, 1.0011, 1.0039, 1.0117, 1.0293, 1.0687, 1.1618, 1.4170,  &
1.0002, 1.0003, 1.0005, 1.0011, 1.0047, 1.0160, 1.0424, 1.1036, 1.2589,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0012, 1.0053, 1.0213, 1.0601, 1.1560 /
data ((supersat( 4,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0023, 1.0046, 1.0095, 1.0204, 1.0449, 1.1029, 1.2552, 1.7988, 3.7021,  &
1.0014, 1.0029, 1.0065, 1.0138, 1.0301, 1.0667, 1.1552, 1.4050, 2.5728,  &
1.0008, 1.0019, 1.0043, 1.0094, 1.0205, 1.0450, 1.1010, 1.2422, 1.7008,  &
1.0004, 1.0008, 1.0023, 1.0059, 1.0136, 1.0304, 1.0681, 1.1566, 1.3980,  &
1.0002, 1.0004, 1.0009, 1.0028, 1.0080, 1.0197, 1.0456, 1.1043, 1.2504,  &
1.0001, 1.0002, 1.0004, 1.0009, 1.0033, 1.0109, 1.0285, 1.0682, 1.1622,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0009, 1.0037, 1.0146, 1.0407, 1.1017 /
data ((supersat( 4,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0018, 1.0032, 1.0068, 1.0146, 1.0321, 1.0731, 1.1758, 1.4822, 2.7303,  &
1.0011, 1.0021, 1.0046, 1.0098, 1.0212, 1.0468, 1.1073, 1.2650, 1.8090,  &
1.0006, 1.0013, 1.0031, 1.0065, 1.0143, 1.0312, 1.0694, 1.1617, 1.4199,  &
1.0003, 1.0007, 1.0017, 1.0041, 1.0094, 1.0210, 1.0465, 1.1049, 1.2521,  &
1.0002, 1.0003, 1.0007, 1.0020, 1.0055, 1.0135, 1.0310, 1.0700, 1.1623,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0023, 1.0074, 1.0193, 1.0459, 1.1067,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0025, 1.0098, 1.0275, 1.0679 /
data ((supersat( 4,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0013, 1.0025, 1.0051, 1.0109, 1.0241, 1.0548, 1.1302, 1.3357, 2.0895,  &
1.0009, 1.0014, 1.0034, 1.0072, 1.0155, 1.0345, 1.0787, 1.1895, 1.5149,  &
1.0005, 1.0009, 1.0023, 1.0048, 1.0103, 1.0225, 1.0501, 1.1153, 1.2850,  &
1.0003, 1.0005, 1.0013, 1.0029, 1.0067, 1.0149, 1.0330, 1.0741, 1.1733,  &
1.0002, 1.0003, 1.0005, 1.0014, 1.0039, 1.0094, 1.0217, 1.0489, 1.1115,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0016, 1.0050, 1.0133, 1.0317, 1.0730,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0016, 1.0065, 1.0187, 1.0463 /
data ((supersat( 4,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0007, 1.0020, 1.0040, 1.0085, 1.0189, 1.0433, 1.1024, 1.2562, 1.7360,  &
1.0005, 1.0012, 1.0025, 1.0056, 1.0119, 1.0266, 1.0610, 1.1454, 1.3748,  &
1.0004, 1.0008, 1.0018, 1.0037, 1.0077, 1.0170, 1.0380, 1.0874, 1.2112,  &
1.0002, 1.0004, 1.0010, 1.0022, 1.0050, 1.0110, 1.0244, 1.0550, 1.1276,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0028, 1.0068, 1.0157, 1.0356, 1.0809,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0011, 1.0035, 1.0094, 1.0226, 1.0522,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0011, 1.0043, 1.0129, 1.0325 /
data ((supersat( 4,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0007, 1.0016, 1.0032, 1.0069, 1.0155, 1.0357, 1.0844, 1.2079, 1.5621,  &
1.0005, 1.0011, 1.0020, 1.0044, 1.0096, 1.0215, 1.0496, 1.1177, 1.2959,  &
1.0003, 1.0007, 1.0013, 1.0029, 1.0061, 1.0134, 1.0302, 1.0697, 1.1670,  &
1.0002, 1.0004, 1.0007, 1.0017, 1.0039, 1.0085, 1.0189, 1.0429, 1.0995,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0021, 1.0051, 1.0119, 1.0271, 1.0618,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0025, 1.0069, 1.0168, 1.0390,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0029, 1.0092, 1.0236 /
data ((supersat( 4,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0008, 1.0011, 1.0026, 1.0058, 1.0131, 1.0303, 1.0718, 1.1756, 1.4603,  &
1.0005, 1.0008, 1.0018, 1.0037, 1.0080, 1.0180, 1.0417, 1.0991, 1.2457,  &
1.0003, 1.0005, 1.0010, 1.0023, 1.0050, 1.0110, 1.0250, 1.0579, 1.1384,  &
1.0002, 1.0003, 1.0006, 1.0014, 1.0031, 1.0068, 1.0153, 1.0350, 1.0813,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0017, 1.0040, 1.0094, 1.0215, 1.0495,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0019, 1.0053, 1.0130, 1.0305,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0021, 1.0068, 1.0180 /
data ((supersat( 5,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0038, 1.0072, 1.0144, 1.0304, 1.0668, 1.1548, 1.4068, 2.6966, 4.9717,  &
1.0024, 1.0048, 1.0103, 1.0214, 1.0457, 1.1014, 1.2421, 1.7072, 3.9889,  &
1.0015, 1.0034, 1.0070, 1.0151, 1.0321, 1.0696, 1.1579, 1.3993, 2.5135,  &
1.0008, 1.0019, 1.0046, 1.0103, 1.0224, 1.0486, 1.1079, 1.2547, 1.7235,  &
1.0004, 1.0008, 1.0022, 1.0061, 1.0147, 1.0333, 1.0745, 1.1709, 1.4341,  &
1.0003, 1.0004, 1.0008, 1.0025, 1.0080, 1.0210, 1.0497, 1.1150, 1.2792,  &
1.0002, 1.0003, 1.0005, 1.0009, 1.0026, 1.0104, 1.0297, 1.0737, 1.1798 /
data ((supersat( 5,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0027, 1.0050, 1.0100, 1.0209, 1.0454, 1.1035, 1.2560, 1.8002, 3.7063,  &
1.0018, 1.0034, 1.0071, 1.0145, 1.0309, 1.0676, 1.1564, 1.4069, 2.5780,  &
1.0011, 1.0025, 1.0051, 1.0104, 1.0216, 1.0463, 1.1028, 1.2448, 1.7060,  &
1.0007, 1.0015, 1.0032, 1.0071, 1.0151, 1.0323, 1.0706, 1.1603, 1.4045,  &
1.0004, 1.0007, 1.0017, 1.0042, 1.0099, 1.0223, 1.0490, 1.1093, 1.2587,  &
1.0002, 1.0004, 1.0007, 1.0018, 1.0055, 1.0142, 1.0330, 1.0748, 1.1728,  &
1.0002, 1.0002, 1.0004, 1.0007, 1.0019, 1.0071, 1.0200, 1.0488, 1.1149 /
data ((supersat( 5,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0020, 1.0036, 1.0072, 1.0149, 1.0324, 1.0734, 1.1762, 1.4828, 2.7321,  &
1.0014, 1.0024, 1.0050, 1.0103, 1.0217, 1.0474, 1.1080, 1.2660, 1.8108,  &
1.0009, 1.0018, 1.0037, 1.0072, 1.0151, 1.0321, 1.0705, 1.1632, 1.4224,  &
1.0005, 1.0011, 1.0023, 1.0049, 1.0105, 1.0223, 1.0481, 1.1071, 1.2554,  &
1.0003, 1.0006, 1.0013, 1.0029, 1.0070, 1.0152, 1.0332, 1.0731, 1.1669,  &
1.0002, 1.0003, 1.0006, 1.0014, 1.0038, 1.0097, 1.0224, 1.0501, 1.1129,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0014, 1.0048, 1.0135, 1.0328, 1.0759 /
data ((supersat( 5,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0014, 1.0027, 1.0054, 1.0112, 1.0243, 1.0551, 1.1305, 1.3361, 2.0902,  &
1.0011, 1.0016, 1.0037, 1.0076, 1.0159, 1.0349, 1.0792, 1.1901, 1.5158,  &
1.0008, 1.0012, 1.0027, 1.0054, 1.0109, 1.0232, 1.0508, 1.1163, 1.2863,  &
1.0004, 1.0008, 1.0017, 1.0035, 1.0075, 1.0158, 1.0341, 1.0755, 1.1753,  &
1.0003, 1.0005, 1.0010, 1.0021, 1.0048, 1.0107, 1.0233, 1.0509, 1.1143,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0027, 1.0067, 1.0155, 1.0345, 1.0770,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0010, 1.0033, 1.0092, 1.0224, 1.0516 /
data ((supersat( 5,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0007, 1.0022, 1.0042, 1.0087, 1.0191, 1.0435, 1.1026, 1.2564, 1.7364,  &
1.0005, 1.0014, 1.0028, 1.0059, 1.0122, 1.0269, 1.0614, 1.1458, 1.3753,  &
1.0004, 1.0009, 1.0021, 1.0041, 1.0082, 1.0174, 1.0385, 1.0880, 1.2120,  &
1.0004, 1.0006, 1.0014, 1.0026, 1.0056, 1.0117, 1.0252, 1.0560, 1.1288,  &
1.0002, 1.0004, 1.0007, 1.0016, 1.0036, 1.0077, 1.0169, 1.0370, 1.0828,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0019, 1.0048, 1.0110, 1.0247, 1.0549,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0022, 1.0063, 1.0157, 1.0362 /
data ((supersat( 5,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0009, 1.0018, 1.0034, 1.0071, 1.0156, 1.0358, 1.0845, 1.2081, 1.5623,  &
1.0006, 1.0013, 1.0022, 1.0047, 1.0098, 1.0217, 1.0498, 1.1180, 1.2962,  &
1.0004, 1.0009, 1.0016, 1.0032, 1.0065, 1.0138, 1.0306, 1.0702, 1.1675,  &
1.0003, 1.0006, 1.0011, 1.0021, 1.0044, 1.0091, 1.0196, 1.0436, 1.1004,  &
1.0002, 1.0003, 1.0006, 1.0013, 1.0027, 1.0060, 1.0128, 1.0282, 1.0632,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0015, 1.0035, 1.0082, 1.0184, 1.0410,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0016, 1.0045, 1.0114, 1.0265 /
data ((supersat( 5,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0009, 1.0013, 1.0028, 1.0060, 1.0132, 1.0305, 1.0719, 1.1757, 1.4605,  &
1.0007, 1.0009, 1.0020, 1.0039, 1.0082, 1.0182, 1.0419, 1.0993, 1.2460,  &
1.0005, 1.0007, 1.0012, 1.0026, 1.0053, 1.0113, 1.0253, 1.0582, 1.1387,  &
1.0003, 1.0004, 1.0008, 1.0018, 1.0035, 1.0073, 1.0158, 1.0355, 1.0820,  &
1.0002, 1.0003, 1.0005, 1.0010, 1.0022, 1.0047, 1.0102, 1.0224, 1.0505,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0027, 1.0064, 1.0143, 1.0321,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0012, 1.0034, 1.0086, 1.0202 /
data ((supersat( 5,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0034, 1.0068, 1.0140, 1.0299, 1.0662, 1.1541, 1.4057, 2.6935, 4.9668,  &
1.0021, 1.0043, 1.0097, 1.0207, 1.0448, 1.1003, 1.2405, 1.7042, 3.9786,  &
1.0012, 1.0027, 1.0062, 1.0142, 1.0309, 1.0680, 1.1557, 1.3955, 2.5034,  &
1.0005, 1.0013, 1.0036, 1.0090, 1.0207, 1.0465, 1.1049, 1.2498, 1.7132,  &
1.0003, 1.0005, 1.0013, 1.0044, 1.0125, 1.0305, 1.0704, 1.1646, 1.4223,  &
1.0002, 1.0003, 1.0005, 1.0013, 1.0055, 1.0174, 1.0445, 1.1070, 1.2651,  &
1.0001, 1.0002, 1.0004, 1.0007, 1.0014, 1.0066, 1.0237, 1.0641, 1.1631 /
data ((supersat( 5,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0024, 1.0047, 1.0097, 1.0205, 1.0451, 1.1031, 1.2554, 1.7992, 3.7034,  &
1.0015, 1.0031, 1.0066, 1.0140, 1.0303, 1.0670, 1.1555, 1.4056, 2.5744,  &
1.0009, 1.0020, 1.0045, 1.0097, 1.0208, 1.0454, 1.1016, 1.2430, 1.7024,  &
1.0004, 1.0010, 1.0026, 1.0062, 1.0140, 1.0310, 1.0688, 1.1577, 1.4000,  &
1.0002, 1.0004, 1.0010, 1.0032, 1.0085, 1.0204, 1.0466, 1.1058, 1.2530,  &
1.0002, 1.0002, 1.0004, 1.0010, 1.0039, 1.0118, 1.0298, 1.0701, 1.1655,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0011, 1.0045, 1.0161, 1.0430, 1.1057 /
data ((supersat( 5,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0018, 1.0033, 1.0069, 1.0147, 1.0322, 1.0732, 1.1759, 1.4824, 2.7308,  &
1.0012, 1.0021, 1.0047, 1.0099, 1.0213, 1.0470, 1.1075, 1.2653, 1.8096,  &
1.0007, 1.0015, 1.0032, 1.0067, 1.0145, 1.0314, 1.0698, 1.1621, 1.4207,  &
1.0004, 1.0007, 1.0019, 1.0043, 1.0097, 1.0213, 1.0469, 1.1056, 1.2531,  &
1.0002, 1.0004, 1.0008, 1.0022, 1.0059, 1.0140, 1.0316, 1.0709, 1.1637,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0027, 1.0080, 1.0202, 1.0472, 1.1086,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0008, 1.0030, 1.0108, 1.0290, 1.0703 /
data ((supersat( 5,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0013, 1.0025, 1.0052, 1.0110, 1.0241, 1.0549, 1.1303, 1.3358, 2.0897,  &
1.0010, 1.0014, 1.0035, 1.0073, 1.0156, 1.0346, 1.0789, 1.1897, 1.5152,  &
1.0005, 1.0009, 1.0024, 1.0050, 1.0105, 1.0227, 1.0503, 1.1156, 1.2854,  &
1.0003, 1.0006, 1.0014, 1.0030, 1.0069, 1.0151, 1.0333, 1.0745, 1.1739,  &
1.0002, 1.0003, 1.0006, 1.0016, 1.0041, 1.0098, 1.0221, 1.0495, 1.1123,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0018, 1.0055, 1.0139, 1.0325, 1.0743,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0020, 1.0072, 1.0197, 1.0479 /
data ((supersat( 5,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0007, 1.0021, 1.0041, 1.0085, 1.0190, 1.0434, 1.1025, 1.2563, 1.7361,  &
1.0005, 1.0013, 1.0026, 1.0056, 1.0120, 1.0267, 1.0611, 1.1455, 1.3749,  &
1.0004, 1.0008, 1.0019, 1.0038, 1.0079, 1.0171, 1.0381, 1.0876, 1.2114,  &
1.0003, 1.0005, 1.0011, 1.0023, 1.0052, 1.0112, 1.0247, 1.0553, 1.1280,  &
1.0002, 1.0003, 1.0005, 1.0012, 1.0029, 1.0070, 1.0160, 1.0360, 1.0814,  &
1.0001, 1.0002, 1.0003, 1.0005, 1.0013, 1.0039, 1.0098, 1.0232, 1.0530,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0013, 1.0049, 1.0137, 1.0336 /
data ((supersat( 5,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0008, 1.0017, 1.0033, 1.0069, 1.0155, 1.0357, 1.0844, 1.2080, 1.5622,  &
1.0005, 1.0012, 1.0020, 1.0045, 1.0096, 1.0216, 1.0496, 1.1178, 1.2960,  &
1.0004, 1.0007, 1.0014, 1.0030, 1.0062, 1.0135, 1.0303, 1.0698, 1.1672,  &
1.0002, 1.0004, 1.0008, 1.0018, 1.0040, 1.0086, 1.0191, 1.0431, 1.0998,  &
1.0001, 1.0002, 1.0004, 1.0009, 1.0022, 1.0053, 1.0121, 1.0274, 1.0622,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0028, 1.0072, 1.0172, 1.0396,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0010, 1.0034, 1.0098, 1.0245 /
data ((supersat( 5,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0008, 1.0012, 1.0026, 1.0058, 1.0131, 1.0304, 1.0718, 1.1756, 1.4604,  &
1.0006, 1.0008, 1.0018, 1.0037, 1.0080, 1.0181, 1.0418, 1.0991, 1.2458,  &
1.0003, 1.0005, 1.0011, 1.0023, 1.0051, 1.0111, 1.0251, 1.0580, 1.1385,  &
1.0002, 1.0003, 1.0007, 1.0015, 1.0032, 1.0069, 1.0155, 1.0351, 1.0815,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0018, 1.0042, 1.0096, 1.0218, 1.0498,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0021, 1.0056, 1.0134, 1.0310,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0024, 1.0073, 1.0186 /
data ((supersat( 5,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0030, 1.0063, 1.0135, 1.0294, 1.0655, 1.1532, 1.4043, 2.6895, 4.9601,  &
1.0017, 1.0038, 1.0090, 1.0199, 1.0438, 1.0990, 1.2385, 1.7004, 3.9657,  &
1.0007, 1.0020, 1.0053, 1.0130, 1.0295, 1.0662, 1.1530, 1.3908, 2.4908,  &
1.0003, 1.0007, 1.0025, 1.0075, 1.0188, 1.0439, 1.1012, 1.2438, 1.7004,  &
1.0002, 1.0003, 1.0007, 1.0029, 1.0101, 1.0271, 1.0656, 1.1568, 1.4077,  &
1.0001, 1.0002, 1.0004, 1.0008, 1.0031, 1.0135, 1.0385, 1.0974, 1.2479,  &
1.0000, 1.0000, 1.0002, 1.0004, 1.0011, 1.0033, 1.0173, 1.0532, 1.1436 /
data ((supersat( 5,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0021, 1.0044, 1.0093, 1.0202, 1.0446, 1.1026, 1.2547, 1.7980, 3.6998,  &
1.0013, 1.0027, 1.0062, 1.0135, 1.0297, 1.0662, 1.1545, 1.4040, 2.5698,  &
1.0006, 1.0015, 1.0039, 1.0089, 1.0199, 1.0442, 1.1000, 1.2407, 1.6980,  &
1.0003, 1.0006, 1.0018, 1.0052, 1.0128, 1.0294, 1.0666, 1.1545, 1.3944,  &
1.0002, 1.0003, 1.0006, 1.0021, 1.0069, 1.0183, 1.0437, 1.1015, 1.2459,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0022, 1.0092, 1.0261, 1.0646, 1.1565,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0007, 1.0023, 1.0119, 1.0364, 1.0948 /
data ((supersat( 5,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0016, 1.0031, 1.0067, 1.0144, 1.0319, 1.0728, 1.1755, 1.4818, 2.7291,  &
1.0010, 1.0019, 1.0043, 1.0095, 1.0209, 1.0465, 1.1069, 1.2645, 1.8080,  &
1.0005, 1.0010, 1.0028, 1.0061, 1.0138, 1.0307, 1.0688, 1.1608, 1.4186,  &
1.0002, 1.0005, 1.0013, 1.0036, 1.0088, 1.0202, 1.0456, 1.1037, 1.2502,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0048, 1.0125, 1.0297, 1.0683, 1.1598,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0016, 1.0062, 1.0177, 1.0437, 1.1033,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0005, 1.0016, 1.0079, 1.0247, 1.0636 /
data ((supersat( 5,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0012, 1.0023, 1.0050, 1.0108, 1.0239, 1.0547, 1.1300, 1.3355, 2.0890,  &
1.0007, 1.0013, 1.0032, 1.0070, 1.0153, 1.0342, 1.0785, 1.1892, 1.5144,  &
1.0004, 1.0008, 1.0020, 1.0045, 1.0100, 1.0222, 1.0497, 1.1148, 1.2842,  &
1.0002, 1.0004, 1.0010, 1.0026, 1.0062, 1.0144, 1.0324, 1.0733, 1.1722,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0033, 1.0087, 1.0208, 1.0477, 1.1099,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0011, 1.0041, 1.0121, 1.0301, 1.0709,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0004, 1.0011, 1.0051, 1.0167, 1.0435 /
data ((supersat( 5,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0006, 1.0019, 1.0039, 1.0084, 1.0188, 1.0432, 1.1023, 1.2561, 1.7358,  &
1.0005, 1.0011, 1.0024, 1.0054, 1.0118, 1.0265, 1.0609, 1.1452, 1.3745,  &
1.0003, 1.0007, 1.0016, 1.0034, 1.0075, 1.0167, 1.0377, 1.0871, 1.2107,  &
1.0002, 1.0003, 1.0007, 1.0019, 1.0046, 1.0106, 1.0240, 1.0545, 1.1269,  &
1.0001, 1.0002, 1.0003, 1.0008, 1.0024, 1.0062, 1.0150, 1.0347, 1.0798,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0028, 1.0085, 1.0214, 1.0507,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0003, 1.0008, 1.0033, 1.0114, 1.0304 /
data ((supersat( 5,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0015, 1.0031, 1.0068, 1.0154, 1.0356, 1.0843, 1.2078, 1.5620,  &
1.0005, 1.0010, 1.0019, 1.0043, 1.0094, 1.0214, 1.0494, 1.1176, 1.2957,  &
1.0003, 1.0006, 1.0011, 1.0027, 1.0059, 1.0132, 1.0300, 1.0695, 1.1667,  &
1.0002, 1.0003, 1.0006, 1.0015, 1.0036, 1.0082, 1.0186, 1.0425, 1.0991,  &
1.0001, 1.0002, 1.0003, 1.0006, 1.0018, 1.0046, 1.0113, 1.0264, 1.0611,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0020, 1.0061, 1.0159, 1.0379,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0022, 1.0080, 1.0221 /
data ((supersat( 5,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0011, 1.0025, 1.0057, 1.0130, 1.0303, 1.0717, 1.1755, 1.4603,  &
1.0004, 1.0007, 1.0017, 1.0036, 1.0078, 1.0179, 1.0416, 1.0990, 1.2456,  &
1.0002, 1.0004, 1.0010, 1.0021, 1.0048, 1.0108, 1.0248, 1.0577, 1.1381,  &
1.0001, 1.0002, 1.0005, 1.0012, 1.0028, 1.0065, 1.0150, 1.0346, 1.0810,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0013, 1.0036, 1.0089, 1.0210, 1.0489,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0015, 1.0046, 1.0122, 1.0296,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0015, 1.0059, 1.0167 /
data ((supersat( 5,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0026, 1.0058, 1.0129, 1.0287, 1.0647, 1.1521, 1.4025, 2.6846, 4.9519,  &
1.0013, 1.0033, 1.0082, 1.0189, 1.0426, 1.0974, 1.2361, 1.6957, 3.9492,  &
1.0004, 1.0014, 1.0044, 1.0117, 1.0278, 1.0639, 1.1496, 1.3849, 2.4750,  &
1.0002, 1.0004, 1.0015, 1.0058, 1.0166, 1.0409, 1.0967, 1.2363, 1.6843,  &
1.0002, 1.0003, 1.0005, 1.0015, 1.0075, 1.0233, 1.0598, 1.1474, 1.3896,  &
1.0000, 1.0001, 1.0003, 1.0006, 1.0016, 1.0093, 1.0318, 1.0861, 1.2272,  &
0.9995, 0.9996, 0.9997, 1.0000, 1.0007, 1.0022, 1.0110, 1.0416, 1.1216 /
data ((supersat( 5,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0019, 1.0040, 1.0089, 1.0197, 1.0441, 1.1020, 1.2538, 1.7965, 3.6951,  &
1.0010, 1.0022, 1.0056, 1.0128, 1.0289, 1.0653, 1.1532, 1.4019, 2.5641,  &
1.0004, 1.0011, 1.0031, 1.0080, 1.0188, 1.0428, 1.0982, 1.2378, 1.6923,  &
1.0002, 1.0004, 1.0011, 1.0040, 1.0113, 1.0275, 1.0640, 1.1506, 1.3874,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0051, 1.0158, 1.0402, 1.0963, 1.2371,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0012, 1.0064, 1.0218, 1.0580, 1.1456,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0014, 1.0075, 1.0291, 1.0822 /
data ((supersat( 5,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0014, 1.0029, 1.0064, 1.0141, 1.0316, 1.0725, 1.1750, 1.4810, 2.7271,  &
1.0007, 1.0015, 1.0039, 1.0091, 1.0204, 1.0459, 1.1061, 1.2634, 1.8061,  &
1.0003, 1.0008, 1.0023, 1.0055, 1.0131, 1.0298, 1.0677, 1.1592, 1.4159,  &
1.0002, 1.0003, 1.0008, 1.0028, 1.0078, 1.0190, 1.0439, 1.1015, 1.2466,  &
1.0001, 1.0002, 1.0003, 1.0008, 1.0035, 1.0108, 1.0274, 1.0651, 1.1549,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0042, 1.0148, 1.0395, 1.0969,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0009, 1.0048, 1.0198, 1.0558 /
data ((supersat( 5,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0010, 1.0022, 1.0048, 1.0105, 1.0237, 1.0544, 1.1297, 1.3351, 2.0882,  &
1.0005, 1.0012, 1.0029, 1.0067, 1.0149, 1.0338, 1.0780, 1.1886, 1.5135,  &
1.0003, 1.0006, 1.0017, 1.0041, 1.0095, 1.0215, 1.0490, 1.1139, 1.2828,  &
1.0001, 1.0003, 1.0006, 1.0020, 1.0054, 1.0134, 1.0312, 1.0718, 1.1701,  &
1.0001, 1.0001, 1.0003, 1.0006, 1.0024, 1.0074, 1.0192, 1.0456, 1.1069,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0006, 1.0027, 1.0100, 1.0273, 1.0668,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0003, 1.0007, 1.0030, 1.0132, 1.0383 /
data ((supersat( 5,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0006, 1.0017, 1.0037, 1.0082, 1.0186, 1.0430, 1.1021, 1.2558, 1.7354,  &
1.0004, 1.0010, 1.0022, 1.0051, 1.0115, 1.0262, 1.0605, 1.1448, 1.3739,  &
1.0002, 1.0005, 1.0012, 1.0031, 1.0071, 1.0162, 1.0372, 1.0864, 1.2099,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0040, 1.0099, 1.0232, 1.0535, 1.1256,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0017, 1.0053, 1.0138, 1.0332, 1.0778,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0018, 1.0069, 1.0194, 1.0478,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0019, 1.0088, 1.0268 /
data ((supersat( 5,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0006, 1.0014, 1.0030, 1.0067, 1.0153, 1.0355, 1.0841, 1.2077, 1.5617,  &
1.0004, 1.0008, 1.0017, 1.0041, 1.0092, 1.0212, 1.0492, 1.1173, 1.2953,  &
1.0002, 1.0004, 1.0009, 1.0024, 1.0056, 1.0128, 1.0296, 1.0690, 1.1662,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0031, 1.0076, 1.0179, 1.0418, 1.0981,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0012, 1.0039, 1.0104, 1.0253, 1.0596,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0049, 1.0142, 1.0358,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0060, 1.0193 /
data ((supersat( 5,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0006, 1.0010, 1.0024, 1.0056, 1.0129, 1.0302, 1.0716, 1.1754, 1.4601,  &
1.0003, 1.0006, 1.0015, 1.0034, 1.0077, 1.0177, 1.0414, 1.0988, 1.2453,  &
1.0002, 1.0003, 1.0008, 1.0019, 1.0045, 1.0105, 1.0245, 1.0574, 1.1377,  &
1.0001, 1.0002, 1.0003, 1.0009, 1.0024, 1.0061, 1.0145, 1.0341, 1.0803,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0030, 1.0082, 1.0201, 1.0478,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0037, 1.0109, 1.0280,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0043, 1.0145 /
data ((supersat( 5,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0023, 1.0055, 1.0125, 1.0283, 1.0641, 1.1513, 1.4013, 2.6811, 4.9461,  &
1.0009, 1.0030, 1.0077, 1.0183, 1.0418, 1.0963, 1.2344, 1.6924, 3.9376,  &
1.0003, 1.0010, 1.0038, 1.0108, 1.0267, 1.0624, 1.1473, 1.3808, 2.4638,  &
1.0002, 1.0003, 1.0010, 1.0048, 1.0151, 1.0388, 1.0936, 1.2311, 1.6731,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0059, 1.0208, 1.0559, 1.1409, 1.3770,  &
0.9999, 1.0000, 1.0001, 1.0005, 1.0013, 1.0069, 1.0275, 1.0788, 1.2133,  &
0.9991, 0.9992, 0.9993, 0.9996, 1.0003, 1.0018, 1.0077, 1.0348, 1.1078 /
data ((supersat( 5,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0017, 1.0038, 1.0087, 1.0194, 1.0438, 1.1016, 1.2533, 1.7955, 3.6918,  &
1.0007, 1.0020, 1.0053, 1.0124, 1.0284, 1.0646, 1.1523, 1.4004, 2.5599,  &
1.0003, 1.0008, 1.0026, 1.0074, 1.0181, 1.0419, 1.0969, 1.2358, 1.6883,  &
1.0002, 1.0003, 1.0008, 1.0034, 1.0103, 1.0262, 1.0622, 1.1479, 1.3825,  &
1.0001, 1.0002, 1.0003, 1.0008, 1.0040, 1.0142, 1.0378, 1.0927, 1.2310,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0009, 1.0047, 1.0190, 1.0536, 1.1382,  &
0.9997, 0.9997, 0.9998, 1.0000, 1.0004, 1.0012, 1.0052, 1.0246, 1.0741 /
data ((supersat( 5,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0013, 1.0027, 1.0062, 1.0139, 1.0314, 1.0722, 1.1747, 1.4805, 2.7256,  &
1.0006, 1.0014, 1.0037, 1.0088, 1.0200, 1.0455, 1.1056, 1.2626, 1.8046,  &
1.0002, 1.0006, 1.0019, 1.0051, 1.0126, 1.0292, 1.0669, 1.1581, 1.4141,  &
1.0001, 1.0002, 1.0006, 1.0023, 1.0071, 1.0181, 1.0428, 1.0999, 1.2441,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0027, 1.0097, 1.0259, 1.0630, 1.1515,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0006, 1.0031, 1.0129, 1.0367, 1.0926,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0008, 1.0033, 1.0167, 1.0508 /
data ((supersat( 5,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0009, 1.0021, 1.0047, 1.0104, 1.0235, 1.0543, 1.1295, 1.3348, 2.0876,  &
1.0004, 1.0011, 1.0027, 1.0065, 1.0147, 1.0336, 1.0777, 1.1881, 1.5127,  &
1.0002, 1.0005, 1.0014, 1.0037, 1.0091, 1.0211, 1.0484, 1.1132, 1.2818,  &
1.0001, 1.0002, 1.0005, 1.0016, 1.0050, 1.0128, 1.0305, 1.0708, 1.1687,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0018, 1.0066, 1.0181, 1.0442, 1.1048,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0020, 1.0087, 1.0254, 1.0640,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0006, 1.0020, 1.0111, 1.0349 /
data ((supersat( 5,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0006, 1.0017, 1.0036, 1.0081, 1.0185, 1.0429, 1.1020, 1.2556, 1.7351,  &
1.0004, 1.0009, 1.0020, 1.0050, 1.0113, 1.0260, 1.0603, 1.1445, 1.3735,  &
1.0002, 1.0004, 1.0010, 1.0028, 1.0068, 1.0159, 1.0368, 1.0860, 1.2093,  &
1.0001, 1.0002, 1.0004, 1.0012, 1.0036, 1.0094, 1.0226, 1.0528, 1.1246,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0047, 1.0130, 1.0322, 1.0764,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0059, 1.0180, 1.0459,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0013, 1.0072, 1.0243 /
data ((supersat( 5,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0006, 1.0013, 1.0029, 1.0066, 1.0152, 1.0354, 1.0840, 1.2076, 1.5616,  &
1.0003, 1.0007, 1.0017, 1.0040, 1.0091, 1.0210, 1.0490, 1.1171, 1.2950,  &
1.0001, 1.0003, 1.0008, 1.0021, 1.0053, 1.0126, 1.0293, 1.0687, 1.1657,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0027, 1.0072, 1.0175, 1.0413, 1.0975,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0009, 1.0034, 1.0098, 1.0245, 1.0586,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0009, 1.0041, 1.0132, 1.0343,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0003, 1.0009, 1.0048, 1.0175 /
data ((supersat( 5,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0005, 1.0010, 1.0023, 1.0056, 1.0129, 1.0301, 1.0716, 1.1753, 1.4600,  &
1.0003, 1.0005, 1.0014, 1.0033, 1.0075, 1.0176, 1.0413, 1.0986, 1.2452,  &
1.0001, 1.0003, 1.0007, 1.0017, 1.0043, 1.0103, 1.0243, 1.0571, 1.1374,  &
1.0001, 1.0001, 1.0003, 1.0007, 1.0022, 1.0058, 1.0142, 1.0337, 1.0798,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0007, 1.0026, 1.0076, 1.0195, 1.0470,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0003, 1.0007, 1.0030, 1.0101, 1.0268,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0007, 1.0033, 1.0130 /
data ((supersat( 5,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0021, 1.0053, 1.0123, 1.0279, 1.0637, 1.1507, 1.4003, 2.6783, 4.9413,  &
1.0008, 1.0027, 1.0073, 1.0178, 1.0412, 1.0954, 1.2330, 1.6897, 3.9282,  &
1.0003, 1.0008, 1.0033, 1.0102, 1.0258, 1.0612, 1.1454, 1.3775, 2.4549,  &
1.0002, 1.0003, 1.0008, 1.0041, 1.0140, 1.0372, 1.0911, 1.2269, 1.6642,  &
1.0001, 1.0002, 1.0004, 1.0009, 1.0047, 1.0189, 1.0529, 1.1359, 1.3672,  &
0.9997, 0.9998, 1.0000, 1.0004, 1.0012, 1.0052, 1.0245, 1.0732, 1.2026,  &
0.9988, 0.9988, 0.9989, 0.9992, 0.9999, 1.0015, 1.0056, 1.0301, 1.0979 /
data ((supersat( 5,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0016, 1.0037, 1.0085, 1.0192, 1.0435, 1.1012, 1.2528, 1.7946, 3.6892,  &
1.0006, 1.0019, 1.0051, 1.0121, 1.0280, 1.0641, 1.1516, 1.3993, 2.5567,  &
1.0002, 1.0006, 1.0023, 1.0070, 1.0175, 1.0412, 1.0959, 1.2342, 1.6851,  &
1.0001, 1.0002, 1.0006, 1.0028, 1.0096, 1.0252, 1.0608, 1.1457, 1.3786,  &
1.0001, 1.0002, 1.0003, 1.0007, 1.0033, 1.0129, 1.0360, 1.0899, 1.2261,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0008, 1.0036, 1.0170, 1.0503, 1.1324,  &
0.9995, 0.9995, 0.9996, 0.9998, 1.0002, 1.0011, 1.0038, 1.0214, 1.0681 /
data ((supersat( 5,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0012, 1.0026, 1.0061, 1.0138, 1.0312, 1.0720, 1.1745, 1.4801, 2.7243,  &
1.0005, 1.0013, 1.0035, 1.0086, 1.0198, 1.0451, 1.1052, 1.2620, 1.8035,  &
1.0002, 1.0005, 1.0017, 1.0049, 1.0122, 1.0287, 1.0663, 1.1572, 1.4126,  &
1.0001, 1.0002, 1.0005, 1.0020, 1.0066, 1.0174, 1.0419, 1.0986, 1.2421,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0022, 1.0088, 1.0247, 1.0612, 1.1488,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0006, 1.0023, 1.0115, 1.0346, 1.0891,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0007, 1.0024, 1.0145, 1.0470 /
data ((supersat( 5,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0008, 1.0020, 1.0046, 1.0103, 1.0234, 1.0541, 1.1294, 1.3346, 2.0871,  &
1.0004, 1.0010, 1.0026, 1.0063, 1.0145, 1.0333, 1.0774, 1.1878, 1.5122,  &
1.0002, 1.0004, 1.0012, 1.0035, 1.0088, 1.0208, 1.0480, 1.1127, 1.2810,  &
1.0001, 1.0002, 1.0004, 1.0014, 1.0046, 1.0123, 1.0299, 1.0700, 1.1675,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0015, 1.0060, 1.0173, 1.0430, 1.1032,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0015, 1.0077, 1.0239, 1.0618,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0002, 1.0005, 1.0016, 1.0095, 1.0323 /
data ((supersat( 5,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0006, 1.0016, 1.0035, 1.0080, 1.0184, 1.0428, 1.1019, 1.2555, 1.7349,  &
1.0003, 1.0008, 1.0019, 1.0048, 1.0112, 1.0258, 1.0601, 1.1443, 1.3732,  &
1.0001, 1.0003, 1.0009, 1.0026, 1.0066, 1.0157, 1.0365, 1.0856, 1.2088,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0033, 1.0090, 1.0222, 1.0522, 1.1239,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0042, 1.0124, 1.0314, 1.0753,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0051, 1.0169, 1.0444,  &
0.9999, 1.0000, 1.0000, 1.0000, 1.0002, 1.0004, 1.0011, 1.0061, 1.0225 /
data ((supersat( 5,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0006, 1.0012, 1.0028, 1.0065, 1.0151, 1.0353, 1.0840, 1.2075, 1.5614,  &
1.0003, 1.0006, 1.0016, 1.0039, 1.0089, 1.0209, 1.0489, 1.1170, 1.2948,  &
1.0001, 1.0003, 1.0007, 1.0020, 1.0051, 1.0124, 1.0291, 1.0684, 1.1654,  &
1.0001, 1.0001, 1.0003, 1.0008, 1.0025, 1.0069, 1.0172, 1.0409, 1.0970,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0030, 1.0093, 1.0239, 1.0578,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0036, 1.0124, 1.0332,  &
1.0000, 1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0008, 1.0040, 1.0161 /
data ((supersat( 5,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0004, 1.0009, 1.0023, 1.0055, 1.0128, 1.0300, 1.0715, 1.1753, 1.4599,  &
1.0002, 1.0005, 1.0013, 1.0032, 1.0074, 1.0175, 1.0412, 1.0985, 1.2450,  &
1.0001, 1.0002, 1.0006, 1.0016, 1.0042, 1.0102, 1.0241, 1.0569, 1.1372,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0020, 1.0055, 1.0139, 1.0333, 1.0794,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0023, 1.0072, 1.0190, 1.0464,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0026, 1.0094, 1.0260,  &
1.0000, 1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0027, 1.0119 /
data ((supersat( 5,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0020, 1.0051, 1.0120, 1.0276, 1.0634, 1.1502, 1.3995, 2.6759, 4.9372,  &
1.0007, 1.0024, 1.0069, 1.0174, 1.0407, 1.0947, 1.2319, 1.6875, 3.9201,  &
1.0002, 1.0007, 1.0029, 1.0096, 1.0251, 1.0601, 1.1439, 1.3748, 2.4473,  &
1.0002, 1.0003, 1.0007, 1.0034, 1.0131, 1.0359, 1.0890, 1.2234, 1.6567,  &
1.0000, 1.0001, 1.0004, 1.0008, 1.0039, 1.0174, 1.0504, 1.1317, 1.3590,  &
0.9996, 0.9997, 0.9998, 1.0002, 1.0011, 1.0041, 1.0221, 1.0688, 1.1940,  &
0.9984, 0.9985, 0.9986, 0.9989, 0.9995, 1.0012, 1.0052, 1.0265, 1.0902 /
data ((supersat( 5,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0014, 1.0036, 1.0083, 1.0190, 1.0433, 1.1009, 1.2524, 1.7938, 3.6869,  &
1.0005, 1.0017, 1.0049, 1.0119, 1.0277, 1.0637, 1.1510, 1.3983, 2.5539,  &
1.0002, 1.0005, 1.0021, 1.0066, 1.0171, 1.0406, 1.0950, 1.2329, 1.6824,  &
1.0001, 1.0002, 1.0005, 1.0024, 1.0090, 1.0244, 1.0597, 1.1439, 1.3753,  &
1.0001, 1.0001, 1.0003, 1.0006, 1.0027, 1.0119, 1.0345, 1.0876, 1.2221,  &
0.9999, 0.9999, 1.0000, 1.0003, 1.0008, 1.0028, 1.0154, 1.0476, 1.1277,  &
0.9993, 0.9994, 0.9994, 0.9996, 1.0000, 1.0009, 1.0030, 1.0190, 1.0634 /
data ((supersat( 5,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0011, 1.0025, 1.0059, 1.0136, 1.0310, 1.0718, 1.1742, 1.4798, 2.7233,  &
1.0004, 1.0013, 1.0033, 1.0084, 1.0196, 1.0449, 1.1049, 1.2615, 1.8026,  &
1.0002, 1.0004, 1.0015, 1.0046, 1.0119, 1.0283, 1.0658, 1.1565, 1.4113,  &
1.0001, 1.0002, 1.0004, 1.0017, 1.0062, 1.0169, 1.0412, 1.0975, 1.2403,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0018, 1.0081, 1.0238, 1.0598, 1.1465,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0019, 1.0104, 1.0328, 1.0863,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0001, 1.0007, 1.0020, 1.0128, 1.0439 /
data ((supersat( 5,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0007, 1.0019, 1.0045, 1.0102, 1.0233, 1.0540, 1.1292, 1.3344, 2.0867,  &
1.0003, 1.0010, 1.0024, 1.0062, 1.0144, 1.0332, 1.0772, 1.1875, 1.5117,  &
1.0002, 1.0003, 1.0011, 1.0033, 1.0086, 1.0205, 1.0477, 1.1122, 1.2803,  &
1.0001, 1.0002, 1.0003, 1.0012, 1.0043, 1.0119, 1.0293, 1.0693, 1.1665,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0012, 1.0055, 1.0166, 1.0421, 1.1018,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0013, 1.0069, 1.0227, 1.0600,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0013, 1.0083, 1.0303 /
data ((supersat( 5,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0006, 1.0015, 1.0035, 1.0080, 1.0184, 1.0428, 1.1018, 1.2554, 1.7347,  &
1.0003, 1.0008, 1.0019, 1.0047, 1.0111, 1.0257, 1.0600, 1.1441, 1.3729,  &
1.0001, 1.0003, 1.0008, 1.0024, 1.0064, 1.0155, 1.0363, 1.0853, 1.2083,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0031, 1.0088, 1.0218, 1.0517, 1.1232,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0009, 1.0038, 1.0119, 1.0307, 1.0744,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0009, 1.0046, 1.0160, 1.0431,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0009, 1.0052, 1.0210 /
data ((supersat( 5,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0005, 1.0012, 1.0028, 1.0065, 1.0151, 1.0353, 1.0839, 1.2074, 1.5613,  &
1.0002, 1.0006, 1.0015, 1.0038, 1.0089, 1.0208, 1.0488, 1.1168, 1.2946,  &
1.0001, 1.0002, 1.0006, 1.0019, 1.0050, 1.0122, 1.0289, 1.0682, 1.1651,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0023, 1.0067, 1.0169, 1.0405, 1.0965,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0007, 1.0028, 1.0089, 1.0234, 1.0571,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0007, 1.0031, 1.0117, 1.0323,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0001, 1.0003, 1.0007, 1.0033, 1.0150 /
data ((supersat( 5,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0004, 1.0009, 1.0023, 1.0055, 1.0128, 1.0300, 1.0714, 1.1752, 1.4598,  &
1.0002, 1.0005, 1.0013, 1.0031, 1.0074, 1.0174, 1.0411, 1.0984, 1.2449,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0040, 1.0100, 1.0239, 1.0567, 1.1369,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0018, 1.0053, 1.0137, 1.0331, 1.0790,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0021, 1.0069, 1.0186, 1.0459,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0022, 1.0088, 1.0252,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0023, 1.0110 /
data ((supersat( 6,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0024, 1.0056, 1.0126, 1.0284, 1.0643, 1.1516, 1.4019, 2.6827, 4.9489,  &
1.0010, 1.0030, 1.0078, 1.0185, 1.0421, 1.0967, 1.2351, 1.6939, 3.9431,  &
1.0004, 1.0011, 1.0039, 1.0111, 1.0270, 1.0630, 1.1483, 1.3827, 2.4691,  &
1.0002, 1.0004, 1.0011, 1.0050, 1.0156, 1.0396, 1.0948, 1.2334, 1.6783,  &
1.0001, 1.0002, 1.0004, 1.0011, 1.0063, 1.0216, 1.0574, 1.1436, 1.3826,  &
0.9999, 1.0000, 1.0002, 1.0005, 1.0013, 1.0076, 1.0290, 1.0816, 1.2192,  &
0.9992, 0.9992, 0.9994, 0.9997, 1.0003, 1.0019, 1.0087, 1.0372, 1.1131 /
data ((supersat( 6,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0039, 1.0087, 1.0195, 1.0439, 1.1017, 1.2535, 1.7959, 3.6934,  &
1.0008, 1.0020, 1.0054, 1.0125, 1.0286, 1.0649, 1.1527, 1.4011, 2.5619,  &
1.0003, 1.0008, 1.0027, 1.0076, 1.0183, 1.0422, 1.0974, 1.2367, 1.6902,  &
1.0002, 1.0003, 1.0008, 1.0035, 1.0106, 1.0266, 1.0629, 1.1491, 1.3848,  &
1.0001, 1.0002, 1.0003, 1.0009, 1.0043, 1.0147, 1.0387, 1.0942, 1.2337,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0009, 1.0051, 1.0200, 1.0553, 1.1413,  &
0.9997, 0.9998, 0.9998, 1.0000, 1.0004, 1.0013, 1.0058, 1.0261, 1.0772 /
data ((supersat( 6,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0013, 1.0027, 1.0062, 1.0140, 1.0314, 1.0723, 1.1748, 1.4807, 2.7263,  &
1.0006, 1.0014, 1.0037, 1.0089, 1.0201, 1.0456, 1.1058, 1.2630, 1.8053,  &
1.0002, 1.0006, 1.0020, 1.0052, 1.0127, 1.0294, 1.0672, 1.1586, 1.4149,  &
1.0001, 1.0002, 1.0006, 1.0024, 1.0073, 1.0184, 1.0432, 1.1005, 1.2452,  &
1.0001, 1.0001, 1.0003, 1.0006, 1.0029, 1.0100, 1.0264, 1.0639, 1.1530,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0007, 1.0033, 1.0135, 1.0377, 1.0944,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0008, 1.0036, 1.0178, 1.0527 /
data ((supersat( 6,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0009, 1.0021, 1.0047, 1.0104, 1.0236, 1.0543, 1.1296, 1.3349, 2.0879,  &
1.0004, 1.0011, 1.0027, 1.0065, 1.0147, 1.0336, 1.0778, 1.1883, 1.5131,  &
1.0002, 1.0005, 1.0014, 1.0038, 1.0092, 1.0212, 1.0486, 1.1135, 1.2823,  &
1.0001, 1.0002, 1.0005, 1.0017, 1.0051, 1.0130, 1.0307, 1.0712, 1.1694,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0020, 1.0068, 1.0185, 1.0447, 1.1058,  &
1.0001, 1.0001, 1.0001, 1.0002, 1.0005, 1.0021, 1.0091, 1.0261, 1.0652,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0006, 1.0022, 1.0118, 1.0362 /
data ((supersat( 6,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0017, 1.0036, 1.0081, 1.0186, 1.0430, 1.1020, 1.2557, 1.7353,  &
1.0004, 1.0009, 1.0020, 1.0050, 1.0114, 1.0260, 1.0604, 1.1446, 1.3737,  &
1.0002, 1.0004, 1.0010, 1.0028, 1.0068, 1.0160, 1.0369, 1.0862, 1.2096,  &
1.0001, 1.0002, 1.0004, 1.0012, 1.0037, 1.0095, 1.0228, 1.0531, 1.1251,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0013, 1.0048, 1.0133, 1.0326, 1.0771,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0014, 1.0062, 1.0185, 1.0467,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0014, 1.0077, 1.0253 /
data ((supersat( 6,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0013, 1.0029, 1.0066, 1.0152, 1.0354, 1.0841, 1.2076, 1.5617,  &
1.0003, 1.0007, 1.0017, 1.0040, 1.0091, 1.0210, 1.0491, 1.1172, 1.2952,  &
1.0002, 1.0003, 1.0008, 1.0022, 1.0054, 1.0127, 1.0294, 1.0688, 1.1659,  &
1.0001, 1.0002, 1.0003, 1.0009, 1.0028, 1.0073, 1.0177, 1.0415, 1.0978,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0035, 1.0100, 1.0248, 1.0591,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0003, 1.0010, 1.0043, 1.0135, 1.0350,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0003, 1.0010, 1.0052, 1.0182 /
data ((supersat( 6,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0010, 1.0023, 1.0056, 1.0129, 1.0301, 1.0716, 1.1754, 1.4600,  &
1.0003, 1.0005, 1.0014, 1.0033, 1.0076, 1.0176, 1.0413, 1.0987, 1.2453,  &
1.0001, 1.0003, 1.0007, 1.0018, 1.0044, 1.0104, 1.0243, 1.0572, 1.1376,  &
1.0001, 1.0001, 1.0003, 1.0007, 1.0022, 1.0059, 1.0143, 1.0338, 1.0800,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0007, 1.0027, 1.0078, 1.0197, 1.0474,  &
1.0000, 1.0001, 1.0001, 1.0001, 1.0003, 1.0007, 1.0032, 1.0103, 1.0273,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0036, 1.0136 /
data ((supersat( 6,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0019, 1.0050, 1.0119, 1.0275, 1.0632, 1.1501, 1.3993, 2.6752, 4.9359,  &
1.0006, 1.0023, 1.0068, 1.0172, 1.0405, 1.0944, 1.2316, 1.6869, 3.9181,  &
1.0002, 1.0006, 1.0027, 1.0094, 1.0248, 1.0598, 1.1434, 1.3740, 2.4454,  &
1.0002, 1.0003, 1.0006, 1.0032, 1.0127, 1.0354, 1.0884, 1.2224, 1.6547,  &
1.0000, 1.0001, 1.0003, 1.0008, 1.0035, 1.0168, 1.0496, 1.1304, 1.3567,  &
0.9995, 0.9996, 0.9998, 1.0001, 1.0010, 1.0037, 1.0212, 1.0674, 1.1914,  &
0.9982, 0.9982, 0.9983, 0.9986, 0.9993, 1.0010, 1.0050, 1.0254, 1.0878 /
data ((supersat( 6,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0014, 1.0035, 1.0083, 1.0189, 1.0432, 1.1008, 1.2523, 1.7937, 3.6863,  &
1.0005, 1.0017, 1.0047, 1.0117, 1.0276, 1.0636, 1.1508, 1.3980, 2.5531,  &
1.0002, 1.0005, 1.0020, 1.0064, 1.0168, 1.0404, 1.0947, 1.2325, 1.6817,  &
1.0001, 1.0002, 1.0005, 1.0023, 1.0087, 1.0241, 1.0593, 1.1434, 1.3744,  &
1.0001, 1.0001, 1.0003, 1.0005, 1.0024, 1.0115, 1.0340, 1.0868, 1.2210,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0025, 1.0148, 1.0467, 1.1263,  &
0.9992, 0.9992, 0.9993, 0.9995, 0.9999, 1.0008, 1.0031, 1.0181, 1.0619 /
data ((supersat( 6,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0010, 1.0025, 1.0059, 1.0136, 1.0310, 1.0718, 1.1742, 1.4797, 2.7231,  &
1.0004, 1.0012, 1.0033, 1.0083, 1.0195, 1.0448, 1.1048, 1.2614, 1.8023,  &
1.0002, 1.0004, 1.0014, 1.0045, 1.0118, 1.0281, 1.0656, 1.1563, 1.4110,  &
1.0001, 1.0002, 1.0004, 1.0016, 1.0059, 1.0167, 1.0409, 1.0972, 1.2399,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0016, 1.0078, 1.0234, 1.0594, 1.1459,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0017, 1.0100, 1.0322, 1.0855,  &
0.9996, 0.9997, 0.9997, 0.9998, 1.0001, 1.0006, 1.0018, 1.0122, 1.0430 /
data ((supersat( 6,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0007, 1.0019, 1.0044, 1.0102, 1.0233, 1.0540, 1.1292, 1.3343, 2.0866,  &
1.0003, 1.0009, 1.0024, 1.0061, 1.0143, 1.0331, 1.0771, 1.1874, 1.5116,  &
1.0001, 1.0003, 1.0010, 1.0032, 1.0085, 1.0204, 1.0476, 1.1121, 1.2801,  &
1.0001, 1.0001, 1.0003, 1.0011, 1.0042, 1.0117, 1.0292, 1.0691, 1.1662,  &
1.0001, 1.0001, 1.0002, 1.0003, 1.0011, 1.0053, 1.0163, 1.0418, 1.1014,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0011, 1.0065, 1.0223, 1.0594,  &
0.9998, 0.9998, 0.9999, 0.9999, 1.0001, 1.0004, 1.0012, 1.0078, 1.0296 /
data ((supersat( 6,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0015, 1.0034, 1.0079, 1.0183, 1.0427, 1.1017, 1.2553, 1.7347,  &
1.0003, 1.0007, 1.0018, 1.0047, 1.0110, 1.0256, 1.0599, 1.1441, 1.3728,  &
1.0001, 1.0003, 1.0008, 1.0023, 1.0063, 1.0154, 1.0362, 1.0852, 1.2082,  &
1.0001, 1.0001, 1.0003, 1.0008, 1.0030, 1.0086, 1.0217, 1.0516, 1.1230,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0037, 1.0117, 1.0305, 1.0741,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0008, 1.0043, 1.0157, 1.0427,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0009, 1.0049, 1.0206 /
data ((supersat( 6,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0011, 1.0028, 1.0065, 1.0150, 1.0352, 1.0839, 1.2073, 1.5613,  &
1.0002, 1.0005, 1.0015, 1.0037, 1.0088, 1.0207, 1.0488, 1.1168, 1.2946,  &
1.0001, 1.0002, 1.0006, 1.0018, 1.0049, 1.0122, 1.0288, 1.0681, 1.1650,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0022, 1.0066, 1.0168, 1.0404, 1.0964,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0026, 1.0087, 1.0232, 1.0570,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0006, 1.0029, 1.0114, 1.0320,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0002, 1.0006, 1.0031, 1.0146 /
data ((supersat( 6,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0004, 1.0009, 1.0022, 1.0054, 1.0127, 1.0300, 1.0714, 1.1752, 1.4598,  &
1.0002, 1.0005, 1.0012, 1.0030, 1.0073, 1.0174, 1.0411, 1.0983, 1.2448,  &
1.0001, 1.0002, 1.0005, 1.0015, 1.0040, 1.0100, 1.0239, 1.0567, 1.1369,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0017, 1.0052, 1.0136, 1.0330, 1.0790,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0020, 1.0068, 1.0184, 1.0458,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0021, 1.0086, 1.0250,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0000, 1.0002, 1.0005, 1.0021, 1.0107 /
data ((supersat( 6,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0013, 1.0042, 1.0111, 1.0264, 1.0618, 1.1481, 1.3960, 2.6656, 4.9199,  &
1.0004, 1.0015, 1.0056, 1.0157, 1.0385, 1.0916, 1.2271, 1.6779, 3.8861,  &
1.0002, 1.0004, 1.0016, 1.0074, 1.0221, 1.0559, 1.1373, 1.3631, 2.4153,  &
1.0001, 1.0002, 1.0005, 1.0016, 1.0095, 1.0306, 1.0807, 1.2091, 1.6255,  &
0.9997, 0.9998, 1.0001, 1.0006, 1.0017, 1.0118, 1.0410, 1.1150, 1.3257,  &
0.9988, 0.9989, 0.9990, 0.9994, 1.0004, 1.0027, 1.0138, 1.0526, 1.1608,  &
0.9967, 0.9968, 0.9969, 0.9971, 0.9978, 0.9994, 1.0035, 1.0154, 1.0641 /
data ((supersat( 6,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0010, 1.0030, 1.0077, 1.0183, 1.0424, 1.0998, 1.2507, 1.7907, 3.6772,  &
1.0003, 1.0011, 1.0040, 1.0108, 1.0263, 1.0619, 1.1485, 1.3941, 2.5419,  &
1.0001, 1.0003, 1.0012, 1.0052, 1.0151, 1.0380, 1.0914, 1.2271, 1.6710,  &
1.0001, 1.0002, 1.0003, 1.0012, 1.0066, 1.0210, 1.0548, 1.1363, 1.3615,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0013, 1.0082, 1.0286, 1.0781, 1.2055,  &
0.9995, 0.9995, 0.9996, 0.9999, 1.0004, 1.0017, 1.0097, 1.0374, 1.1092,  &
0.9983, 0.9983, 0.9984, 0.9985, 0.9989, 1.0000, 1.0023, 1.0109, 1.0466 /
data ((supersat( 6,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0022, 1.0055, 1.0131, 1.0304, 1.0711, 1.1733, 1.4783, 2.7188,  &
1.0002, 1.0008, 1.0028, 1.0077, 1.0187, 1.0438, 1.1034, 1.2594, 1.7984,  &
1.0001, 1.0002, 1.0009, 1.0036, 1.0106, 1.0266, 1.0636, 1.1533, 1.4059,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0045, 1.0146, 1.0381, 1.0931, 1.2331,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0009, 1.0055, 1.0198, 1.0540, 1.1372,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0004, 1.0011, 1.0064, 1.0261, 1.0752,  &
0.9991, 0.9991, 0.9991, 0.9993, 0.9995, 1.0001, 1.0015, 1.0071, 1.0329 /
data ((supersat( 6,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0005, 1.0017, 1.0041, 1.0098, 1.0229, 1.0536, 1.1287, 1.3336, 2.0849,  &
1.0002, 1.0006, 1.0021, 1.0056, 1.0137, 1.0324, 1.0763, 1.1862, 1.5096,  &
1.0001, 1.0002, 1.0006, 1.0026, 1.0076, 1.0193, 1.0462, 1.1103, 1.2773,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0031, 1.0103, 1.0272, 1.0665, 1.1623,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0007, 1.0036, 1.0138, 1.0382, 1.0960,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0007, 1.0040, 1.0181, 1.0527,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 1.0001, 1.0010, 1.0042, 1.0227 /
data ((supersat( 6,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0005, 1.0013, 1.0032, 1.0077, 1.0181, 1.0424, 1.1014, 1.2549, 1.7339,  &
1.0002, 1.0005, 1.0016, 1.0043, 1.0106, 1.0251, 1.0593, 1.1433, 1.3717,  &
1.0001, 1.0002, 1.0005, 1.0019, 1.0057, 1.0146, 1.0353, 1.0840, 1.2065,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0022, 1.0075, 1.0202, 1.0498, 1.1205,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0024, 1.0098, 1.0279, 1.0705,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0002, 1.0005, 1.0025, 1.0126, 1.0380,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9998, 1.0001, 1.0007, 1.0026, 1.0155 /
data ((supersat( 6,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0004, 1.0009, 1.0025, 1.0063, 1.0148, 1.0350, 1.0836, 1.2070, 1.5608,  &
1.0001, 1.0004, 1.0012, 1.0034, 1.0085, 1.0203, 1.0483, 1.1163, 1.2939,  &
1.0001, 1.0001, 1.0004, 1.0015, 1.0044, 1.0115, 1.0281, 1.0673, 1.1639,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0016, 1.0057, 1.0157, 1.0390, 1.0946,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0017, 1.0072, 1.0213, 1.0543,  &
0.9999, 1.0000, 1.0000, 1.0000, 1.0002, 1.0004, 1.0017, 1.0090, 1.0285,  &
0.9997, 0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0005, 1.0018, 1.0108 /
data ((supersat( 6,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0021, 1.0053, 1.0125, 1.0298, 1.0712, 1.1749, 1.4594,  &
1.0001, 1.0003, 1.0010, 1.0028, 1.0070, 1.0171, 1.0407, 1.0979, 1.2443,  &
1.0001, 1.0001, 1.0003, 1.0011, 1.0036, 1.0095, 1.0233, 1.0560, 1.1360,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0012, 1.0045, 1.0126, 1.0319, 1.0776,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0012, 1.0056, 1.0169, 1.0437,  &
1.0000, 1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0013, 1.0067, 1.0222,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9998, 1.0000, 1.0004, 1.0013, 1.0077 /
data ((supersat( 6,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0008, 1.0034, 1.0100, 1.0251, 1.0601, 1.1456, 1.3918, 2.6531, 4.8987,  &
1.0002, 1.0009, 1.0044, 1.0139, 1.0360, 1.0880, 1.2214, 1.6664, 3.8449,  &
1.0001, 1.0003, 1.0009, 1.0053, 1.0189, 1.0512, 1.1299, 1.3494, 2.3771,  &
0.9999, 1.0000, 1.0003, 1.0010, 1.0062, 1.0251, 1.0716, 1.1928, 1.5895,  &
0.9992, 0.9993, 0.9996, 1.0002, 1.0015, 1.0070, 1.0319, 1.0977, 1.2896,  &
0.9976, 0.9977, 0.9979, 0.9983, 0.9993, 1.0017, 1.0075, 1.0384, 1.1289,  &
0.9949, 0.9950, 0.9950, 0.9953, 0.9959, 0.9974, 1.0011, 1.0117, 1.0439 /
data ((supersat( 6,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0007, 1.0025, 1.0070, 1.0174, 1.0414, 1.0984, 1.2486, 1.7869, 3.6653,  &
1.0002, 1.0007, 1.0031, 1.0096, 1.0248, 1.0599, 1.1455, 1.3890, 2.5273,  &
1.0001, 1.0002, 1.0007, 1.0037, 1.0131, 1.0352, 1.0873, 1.2204, 1.6573,  &
1.0000, 1.0001, 1.0003, 1.0007, 1.0043, 1.0176, 1.0495, 1.1276, 1.3455,  &
0.9997, 0.9998, 0.9999, 1.0002, 1.0010, 1.0048, 1.0227, 1.0680, 1.1870,  &
0.9988, 0.9989, 0.9990, 0.9992, 0.9998, 1.0012, 1.0051, 1.0280, 1.0905,  &
0.9969, 0.9969, 0.9970, 0.9971, 0.9975, 0.9985, 1.0010, 1.0074, 1.0327 /
data ((supersat( 6,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0005, 1.0018, 1.0050, 1.0126, 1.0298, 1.0703, 1.1722, 1.4764, 2.7133,  &
1.0002, 1.0005, 1.0022, 1.0068, 1.0176, 1.0425, 1.1017, 1.2567, 1.7934,  &
1.0001, 1.0002, 1.0005, 1.0026, 1.0092, 1.0248, 1.0611, 1.1496, 1.3994,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0030, 1.0122, 1.0347, 1.0880, 1.2247,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0032, 1.0158, 1.0476, 1.1266,  &
0.9994, 0.9994, 0.9995, 0.9997, 1.0000, 1.0008, 1.0033, 1.0197, 1.0636,  &
0.9982, 0.9982, 0.9982, 0.9983, 0.9986, 0.9992, 1.0007, 1.0045, 1.0233 /
data ((supersat( 6,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0004, 1.0014, 1.0037, 1.0094, 1.0224, 1.0530, 1.1280, 1.3325, 2.0827,  &
1.0001, 1.0004, 1.0016, 1.0050, 1.0130, 1.0315, 1.0752, 1.1847, 1.5070,  &
1.0001, 1.0001, 1.0004, 1.0019, 1.0066, 1.0180, 1.0446, 1.1080, 1.2737,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0020, 1.0086, 1.0249, 1.0632, 1.1572,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0004, 1.0021, 1.0110, 1.0340, 1.0894,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0001, 1.0006, 1.0021, 1.0135, 1.0450,  &
0.9988, 0.9988, 0.9988, 0.9989, 0.9991, 0.9995, 1.0005, 1.0027, 1.0159 /
data ((supersat( 6,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0010, 1.0029, 1.0074, 1.0177, 1.0420, 1.1009, 1.2542, 1.7328,  &
1.0001, 1.0003, 1.0012, 1.0038, 1.0100, 1.0245, 1.0586, 1.1423, 1.3701,  &
1.0001, 1.0001, 1.0003, 1.0014, 1.0049, 1.0137, 1.0341, 1.0824, 1.2042,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0014, 1.0062, 1.0185, 1.0475, 1.1172,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0014, 1.0077, 1.0249, 1.0660,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0001, 1.0004, 1.0015, 1.0092, 1.0326,  &
0.9991, 0.9991, 0.9991, 0.9992, 0.9993, 0.9996, 1.0003, 1.0018, 1.0106 /
data ((supersat( 6,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0023, 1.0060, 1.0145, 1.0347, 1.0833, 1.2066, 1.5601,  &
1.0001, 1.0003, 1.0009, 1.0030, 1.0080, 1.0199, 1.0477, 1.1155, 1.2928,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0038, 1.0108, 1.0272, 1.0661, 1.1623,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0010, 1.0047, 1.0143, 1.0373, 1.0922,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0010, 1.0056, 1.0189, 1.0510,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0011, 1.0064, 1.0244,  &
0.9993, 0.9993, 0.9993, 0.9993, 0.9994, 0.9996, 1.0001, 1.0012, 1.0070 /
data ((supersat( 6,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0020, 1.0051, 1.0123, 1.0295, 1.0709, 1.1746, 1.4589,  &
1.0001, 1.0002, 1.0008, 1.0025, 1.0067, 1.0166, 1.0402, 1.0974, 1.2435,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0030, 1.0088, 1.0225, 1.0551, 1.1348,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0036, 1.0115, 1.0305, 1.0757,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0042, 1.0149, 1.0411,  &
0.9998, 0.9998, 0.9999, 0.9999, 1.0000, 1.0002, 1.0008, 1.0046, 1.0189,  &
0.9993, 0.9993, 0.9993, 0.9994, 0.9995, 0.9996, 1.0001, 1.0009, 1.0048 /
data ((supersat( 6,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0006, 1.0029, 1.0093, 1.0242, 1.0589, 1.1438, 1.3887, 2.6440, 4.8833,  &
1.0002, 1.0006, 1.0035, 1.0126, 1.0343, 1.0856, 1.2173, 1.6582, 3.8153,  &
1.0001, 1.0003, 1.0007, 1.0040, 1.0169, 1.0480, 1.1247, 1.3398, 2.3499,  &
0.9997, 0.9999, 1.0002, 1.0009, 1.0044, 1.0217, 1.0657, 1.1819, 1.5649,  &
0.9988, 0.9989, 0.9991, 0.9997, 1.0011, 1.0046, 1.0266, 1.0870, 1.2662,  &
0.9968, 0.9968, 0.9970, 0.9974, 0.9984, 1.0008, 1.0070, 1.0308, 1.1106,  &
0.9939, 0.9939, 0.9940, 0.9942, 0.9947, 0.9961, 0.9996, 1.0092, 1.0341 /
data ((supersat( 6,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0005, 1.0021, 1.0066, 1.0168, 1.0407, 1.0974, 1.2472, 1.7841, 3.6567,  &
1.0002, 1.0005, 1.0025, 1.0088, 1.0238, 1.0585, 1.1434, 1.3854, 2.5168,  &
1.0001, 1.0002, 1.0005, 1.0029, 1.0118, 1.0333, 1.0844, 1.2157, 1.6476,  &
0.9999, 1.0000, 1.0002, 1.0006, 1.0031, 1.0153, 1.0459, 1.1217, 1.3343,  &
0.9995, 0.9995, 0.9997, 1.0000, 1.0008, 1.0032, 1.0191, 1.0615, 1.1747,  &
0.9983, 0.9983, 0.9984, 0.9987, 0.9993, 1.0007, 1.0044, 1.0227, 1.0793,  &
0.9959, 0.9959, 0.9960, 0.9961, 0.9965, 0.9975, 0.9999, 1.0061, 1.0256 /
data ((supersat( 6,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0004, 1.0015, 1.0047, 1.0122, 1.0293, 1.0697, 1.1714, 1.4751, 2.7093,  &
1.0001, 1.0004, 1.0018, 1.0063, 1.0169, 1.0416, 1.1005, 1.2548, 1.7897,  &
1.0001, 1.0001, 1.0004, 1.0020, 1.0083, 1.0236, 1.0593, 1.1469, 1.3947,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0021, 1.0107, 1.0324, 1.0845, 1.2187,  &
0.9998, 0.9998, 0.9999, 1.0001, 1.0006, 1.0022, 1.0134, 1.0435, 1.1195,  &
0.9991, 0.9991, 0.9992, 0.9993, 0.9997, 1.0006, 1.0027, 1.0160, 1.0564,  &
0.9974, 0.9974, 0.9974, 0.9975, 0.9978, 0.9985, 1.0000, 1.0038, 1.0181 /
data ((supersat( 6,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0011, 1.0035, 1.0091, 1.0221, 1.0526, 1.1275, 1.3318, 2.0811,  &
1.0001, 1.0003, 1.0013, 1.0046, 1.0125, 1.0309, 1.0744, 1.1836, 1.5051,  &
1.0001, 1.0001, 1.0003, 1.0014, 1.0059, 1.0171, 1.0434, 1.1063, 1.2711,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0015, 1.0075, 1.0233, 1.0609, 1.1537,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0015, 1.0092, 1.0311, 1.0848,  &
0.9994, 0.9995, 0.9995, 0.9996, 0.9999, 1.0004, 1.0017, 1.0108, 1.0402,  &
0.9983, 0.9983, 0.9983, 0.9984, 0.9985, 0.9990, 1.0000, 1.0023, 1.0122 /
data ((supersat( 6,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0027, 1.0072, 1.0175, 1.0417, 1.1006, 1.2538, 1.7319,  &
1.0001, 1.0002, 1.0010, 1.0035, 1.0096, 1.0241, 1.0580, 1.1416, 1.3690,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0044, 1.0130, 1.0332, 1.0813, 1.2026,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0010, 1.0054, 1.0174, 1.0459, 1.1148,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0011, 1.0064, 1.0229, 1.0629,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0003, 1.0012, 1.0072, 1.0292,  &
0.9987, 0.9987, 0.9987, 0.9987, 0.9989, 0.9992, 0.9999, 1.0015, 1.0079 /
data ((supersat( 6,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0022, 1.0058, 1.0144, 1.0345, 1.0830, 1.2062, 1.5595,  &
1.0001, 1.0002, 1.0008, 1.0028, 1.0077, 1.0195, 1.0473, 1.1150, 1.2921,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0034, 1.0102, 1.0265, 1.0653, 1.1611,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0040, 1.0134, 1.0361, 1.0905,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0045, 1.0173, 1.0487,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 1.0002, 1.0009, 1.0049, 1.0218,  &
0.9989, 0.9989, 0.9989, 0.9989, 0.9990, 0.9993, 0.9998, 1.0010, 1.0051 /
data ((supersat( 6,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0018, 1.0049, 1.0121, 1.0293, 1.0707, 1.1743, 1.4585,  &
1.0001, 1.0002, 1.0006, 1.0023, 1.0064, 1.0163, 1.0399, 1.0969, 1.2430,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0027, 1.0084, 1.0220, 1.0544, 1.1339,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0031, 1.0108, 1.0295, 1.0744,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0033, 1.0137, 1.0393,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 1.0001, 1.0007, 1.0035, 1.0168,  &
0.9990, 0.9990, 0.9990, 0.9990, 0.9991, 0.9993, 0.9997, 1.0007, 1.0035 /
data ((supersat( 6,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0005, 1.0026, 1.0088, 1.0235, 1.0579, 1.1424, 1.3863, 2.6366, 4.8706,  &
1.0002, 1.0005, 1.0029, 1.0117, 1.0330, 1.0836, 1.2141, 1.6516, 3.7914,  &
1.0000, 1.0002, 1.0006, 1.0032, 1.0153, 1.0456, 1.1206, 1.3322, 2.3281,  &
0.9996, 0.9997, 1.0001, 1.0008, 1.0033, 1.0192, 1.0613, 1.1736, 1.5457,  &
0.9984, 0.9985, 0.9987, 0.9994, 1.0008, 1.0043, 1.0229, 1.0793, 1.2488,  &
0.9960, 0.9961, 0.9962, 0.9966, 0.9976, 1.0000, 1.0061, 1.0259, 1.0982,  &
0.9932, 0.9932, 0.9933, 0.9935, 0.9940, 0.9952, 0.9984, 1.0074, 1.0355 /
data ((supersat( 6,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0004, 1.0019, 1.0062, 1.0164, 1.0401, 1.0966, 1.2460, 1.7819, 3.6496,  &
1.0001, 1.0004, 1.0021, 1.0082, 1.0229, 1.0574, 1.1417, 1.3824, 2.5082,  &
1.0001, 1.0002, 1.0004, 1.0023, 1.0108, 1.0318, 1.0821, 1.2119, 1.6397,  &
0.9999, 0.9999, 1.0001, 1.0006, 1.0024, 1.0137, 1.0432, 1.1171, 1.3255,  &
0.9993, 0.9993, 0.9995, 0.9998, 1.0007, 1.0025, 1.0166, 1.0568, 1.1654,  &
0.9978, 0.9978, 0.9979, 0.9982, 0.9988, 1.0003, 1.0039, 1.0191, 1.0714,  &
0.9952, 0.9952, 0.9952, 0.9954, 0.9957, 0.9967, 0.9990, 1.0050, 1.0211 /
data ((supersat( 6,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0003, 1.0013, 1.0045, 1.0119, 1.0289, 1.0692, 1.1707, 1.4740, 2.7061,  &
1.0001, 1.0003, 1.0015, 1.0058, 1.0164, 1.0409, 1.0995, 1.2533, 1.7867,  &
1.0001, 1.0001, 1.0003, 1.0016, 1.0076, 1.0226, 1.0579, 1.1448, 1.3909,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0016, 1.0095, 1.0306, 1.0817, 1.2140,  &
0.9996, 0.9997, 0.9998, 1.0000, 1.0005, 1.0017, 1.0116, 1.0404, 1.1140,  &
0.9988, 0.9988, 0.9988, 0.9990, 0.9994, 1.0003, 1.0025, 1.0134, 1.0513,  &
0.9968, 0.9968, 0.9968, 0.9969, 0.9972, 0.9978, 0.9994, 1.0032, 1.0149 /
data ((supersat( 6,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0003, 1.0010, 1.0033, 1.0089, 1.0218, 1.0523, 1.1271, 1.3312, 2.0797,  &
1.0001, 1.0003, 1.0011, 1.0043, 1.0121, 1.0304, 1.0737, 1.1827, 1.5036,  &
1.0001, 1.0001, 1.0003, 1.0012, 1.0054, 1.0165, 1.0425, 1.1050, 1.2690,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0012, 1.0067, 1.0221, 1.0591, 1.1508,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0004, 1.0012, 1.0079, 1.0290, 1.0813,  &
0.9992, 0.9992, 0.9993, 0.9994, 0.9997, 1.0002, 1.0016, 1.0090, 1.0367,  &
0.9978, 0.9978, 0.9978, 0.9979, 0.9980, 0.9985, 0.9995, 1.0020, 1.0098 /
data ((supersat( 6,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0026, 1.0070, 1.0172, 1.0415, 1.1003, 1.2534, 1.7313,  &
1.0001, 1.0002, 1.0008, 1.0033, 1.0093, 1.0237, 1.0576, 1.1410, 1.3681,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0040, 1.0124, 1.0325, 1.0804, 1.2012,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0009, 1.0047, 1.0165, 1.0446, 1.1129,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0003, 1.0009, 1.0054, 1.0213, 1.0605,  &
0.9994, 0.9994, 0.9995, 0.9996, 0.9997, 1.0002, 1.0011, 1.0059, 1.0267,  &
0.9983, 0.9983, 0.9983, 0.9983, 0.9985, 0.9988, 0.9995, 1.0012, 1.0062 /
data ((supersat( 6,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0021, 1.0057, 1.0142, 1.0343, 1.0828, 1.2060, 1.5591,  &
1.0001, 1.0002, 1.0007, 1.0026, 1.0075, 1.0192, 1.0470, 1.1146, 1.2914,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0031, 1.0098, 1.0260, 1.0646, 1.1602,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0035, 1.0127, 1.0351, 1.0891,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0038, 1.0161, 1.0469,  &
0.9995, 0.9995, 0.9996, 0.9996, 0.9998, 1.0001, 1.0008, 1.0039, 1.0199,  &
0.9985, 0.9985, 0.9985, 0.9986, 0.9987, 0.9989, 0.9995, 1.0007, 1.0041 /
data ((supersat( 6,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0017, 1.0048, 1.0120, 1.0292, 1.0705, 1.1741, 1.4582,  &
1.0001, 1.0001, 1.0005, 1.0021, 1.0062, 1.0161, 1.0396, 1.0966, 1.2425,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0024, 1.0080, 1.0216, 1.0539, 1.1332,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0027, 1.0102, 1.0287, 1.0733,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0028, 1.0127, 1.0378,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9998, 1.0000, 1.0006, 1.0028, 1.0153,  &
0.9986, 0.9986, 0.9986, 0.9987, 0.9988, 0.9990, 0.9994, 1.0005, 1.0030 /
data ((supersat( 6,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0004, 1.0022, 1.0083, 1.0229, 1.0571, 1.1412, 1.3842, 2.6302, 4.8600,  &
1.0002, 1.0004, 1.0025, 1.0110, 1.0319, 1.0819, 1.2114, 1.6460, 3.7709,  &
1.0000, 1.0002, 1.0006, 1.0026, 1.0141, 1.0436, 1.1173, 1.3258, 2.3096,  &
0.9994, 0.9996, 0.9999, 1.0007, 1.0027, 1.0173, 1.0577, 1.1667, 1.5297,  &
0.9980, 0.9981, 0.9984, 0.9990, 1.0005, 1.0040, 1.0202, 1.0734, 1.2350,  &
0.9955, 0.9955, 0.9957, 0.9960, 0.9970, 0.9993, 1.0053, 1.0224, 1.0890,  &
0.9927, 0.9928, 0.9928, 0.9930, 0.9934, 0.9946, 0.9976, 1.0059, 1.0321 /
data ((supersat( 6,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0003, 1.0017, 1.0059, 1.0160, 1.0396, 1.0960, 1.2449, 1.7799, 3.6436,  &
1.0001, 1.0004, 1.0018, 1.0077, 1.0223, 1.0564, 1.1403, 1.3799, 2.5009,  &
1.0000, 1.0002, 1.0004, 1.0019, 1.0099, 1.0306, 1.0802, 1.2087, 1.6330,  &
0.9998, 0.9999, 1.0001, 1.0005, 1.0019, 1.0123, 1.0410, 1.1133, 1.3181,  &
0.9991, 0.9991, 0.9993, 0.9997, 1.0005, 1.0025, 1.0147, 1.0530, 1.1579,  &
0.9973, 0.9974, 0.9975, 0.9977, 0.9984, 0.9999, 1.0035, 1.0166, 1.0654,  &
0.9946, 0.9946, 0.9946, 0.9948, 0.9951, 0.9960, 0.9983, 1.0041, 1.0215 /
data ((supersat( 6,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0043, 1.0116, 1.0286, 1.0688, 1.1701, 1.4730, 2.7032,  &
1.0001, 1.0003, 1.0013, 1.0055, 1.0159, 1.0403, 1.0986, 1.2520, 1.7841,  &
1.0001, 1.0001, 1.0003, 1.0014, 1.0070, 1.0218, 1.0567, 1.1430, 1.3877,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0014, 1.0086, 1.0292, 1.0794, 1.2100,  &
0.9995, 0.9996, 0.9997, 0.9999, 1.0004, 1.0016, 1.0102, 1.0380, 1.1095,  &
0.9985, 0.9985, 0.9985, 0.9987, 0.9991, 1.0001, 1.0023, 1.0115, 1.0473,  &
0.9962, 0.9962, 0.9963, 0.9964, 0.9966, 0.9973, 0.9988, 1.0027, 1.0125 /
data ((supersat( 6,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0032, 1.0087, 1.0216, 1.0520, 1.1267, 1.3307, 2.0785,  &
1.0001, 1.0002, 1.0010, 1.0040, 1.0118, 1.0300, 1.0732, 1.1819, 1.5022,  &
1.0000, 1.0001, 1.0002, 1.0010, 1.0050, 1.0159, 1.0417, 1.1038, 1.2672,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0010, 1.0060, 1.0211, 1.0576, 1.1484,  &
0.9997, 0.9998, 0.9998, 1.0000, 1.0003, 1.0011, 1.0069, 1.0273, 1.0785,  &
0.9990, 0.9990, 0.9991, 0.9992, 0.9995, 1.0001, 1.0015, 1.0076, 1.0340,  &
0.9973, 0.9973, 0.9973, 0.9974, 0.9976, 0.9980, 0.9991, 1.0016, 1.0081 /
data ((supersat( 6,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0025, 1.0068, 1.0171, 1.0413, 1.1000, 1.2530, 1.7307,  &
1.0001, 1.0002, 1.0007, 1.0031, 1.0091, 1.0234, 1.0572, 1.1404, 1.3673,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0037, 1.0120, 1.0320, 1.0796, 1.2001,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0042, 1.0157, 1.0435, 1.1113,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0047, 1.0200, 1.0585,  &
0.9993, 0.9993, 0.9993, 0.9994, 0.9996, 1.0000, 1.0010, 1.0049, 1.0247,  &
0.9979, 0.9979, 0.9979, 0.9980, 0.9981, 0.9984, 0.9992, 1.0009, 1.0052 /
data ((supersat( 6,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0020, 1.0056, 1.0141, 1.0341, 1.0826, 1.2057, 1.5587,  &
1.0001, 1.0002, 1.0006, 1.0024, 1.0073, 1.0190, 1.0467, 1.1142, 1.2909,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0028, 1.0095, 1.0256, 1.0640, 1.1594,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0031, 1.0121, 1.0343, 1.0880,  &
0.9998, 0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0032, 1.0152, 1.0454,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9996, 1.0000, 1.0007, 1.0033, 1.0183,  &
0.9982, 0.9982, 0.9982, 0.9982, 0.9983, 0.9986, 0.9992, 1.0005, 1.0036 /
data ((supersat( 6,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0016, 1.0047, 1.0119, 1.0291, 1.0704, 1.1739, 1.4579,  &
1.0001, 1.0001, 1.0005, 1.0019, 1.0060, 1.0159, 1.0394, 1.0963, 1.2421,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0022, 1.0077, 1.0212, 1.0534, 1.1326,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0005, 1.0024, 1.0097, 1.0280, 1.0724,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0024, 1.0119, 1.0366,  &
0.9994, 0.9994, 0.9995, 0.9995, 0.9997, 0.9999, 1.0005, 1.0024, 1.0140,  &
0.9983, 0.9983, 0.9983, 0.9984, 0.9984, 0.9987, 0.9992, 1.0002, 1.0026 /
data ((supersat( 7,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0017, 1.0048, 1.0117, 1.0273, 1.0630, 1.1498, 1.3989, 2.6742, 4.9346,  &
1.0005, 1.0021, 1.0065, 1.0169, 1.0401, 1.0940, 1.2310, 1.6858, 3.9145,  &
1.0002, 1.0005, 1.0025, 1.0090, 1.0243, 1.0592, 1.1426, 1.3727, 2.4420,  &
1.0001, 1.0003, 1.0006, 1.0028, 1.0122, 1.0346, 1.0873, 1.2207, 1.6512,  &
0.9999, 1.0001, 1.0003, 1.0007, 1.0030, 1.0159, 1.0483, 1.1282, 1.3527,  &
0.9994, 0.9994, 0.9996, 1.0000, 1.0009, 1.0031, 1.0199, 1.0650, 1.1869,  &
0.9979, 0.9979, 0.9980, 0.9983, 0.9990, 1.0007, 1.0048, 1.0235, 1.0837 /
data ((supersat( 7,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0013, 1.0034, 1.0081, 1.0188, 1.0431, 1.1007, 1.2521, 1.7933, 3.6853,  &
1.0004, 1.0015, 1.0046, 1.0116, 1.0274, 1.0633, 1.1505, 1.3975, 2.5519,  &
1.0002, 1.0004, 1.0018, 1.0062, 1.0165, 1.0400, 1.0943, 1.2318, 1.6805,  &
1.0001, 1.0002, 1.0004, 1.0020, 1.0083, 1.0236, 1.0586, 1.1424, 1.3729,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0021, 1.0109, 1.0331, 1.0856, 1.2190,  &
0.9998, 0.9998, 0.9999, 1.0002, 1.0007, 1.0022, 1.0139, 1.0453, 1.1238,  &
0.9990, 0.9990, 0.9991, 0.9993, 0.9997, 1.0007, 1.0029, 1.0168, 1.0594 /
data ((supersat( 7,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0009, 1.0024, 1.0058, 1.0135, 1.0309, 1.0717, 1.1741, 1.4795, 2.7226,  &
1.0003, 1.0011, 1.0032, 1.0082, 1.0193, 1.0446, 1.1046, 1.2611, 1.8019,  &
1.0001, 1.0003, 1.0013, 1.0043, 1.0116, 1.0279, 1.0653, 1.1559, 1.4104,  &
1.0001, 1.0002, 1.0004, 1.0014, 1.0057, 1.0163, 1.0405, 1.0967, 1.2391,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0014, 1.0074, 1.0228, 1.0586, 1.1448,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0005, 1.0015, 1.0093, 1.0313, 1.0841,  &
0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0005, 1.0018, 1.0113, 1.0413 /
data ((supersat( 7,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0018, 1.0044, 1.0101, 1.0232, 1.0539, 1.1291, 1.3342, 2.0864,  &
1.0003, 1.0009, 1.0023, 1.0060, 1.0142, 1.0330, 1.0770, 1.1873, 1.5114,  &
1.0001, 1.0003, 1.0009, 1.0030, 1.0083, 1.0202, 1.0474, 1.1118, 1.2798,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0040, 1.0115, 1.0289, 1.0688, 1.1658,  &
1.0001, 1.0001, 1.0001, 1.0003, 1.0010, 1.0049, 1.0159, 1.0413, 1.1007,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0003, 1.0010, 1.0061, 1.0216, 1.0585,  &
0.9997, 0.9998, 0.9998, 0.9999, 1.0000, 1.0004, 1.0012, 1.0071, 1.0285 /
data ((supersat( 7,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0014, 1.0034, 1.0079, 1.0183, 1.0427, 1.1017, 1.2553, 1.7346,  &
1.0002, 1.0007, 1.0018, 1.0046, 1.0109, 1.0255, 1.0598, 1.1440, 1.3727,  &
1.0001, 1.0002, 1.0007, 1.0023, 1.0062, 1.0153, 1.0361, 1.0851, 1.2081,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0028, 1.0084, 1.0214, 1.0514, 1.1228,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0007, 1.0034, 1.0114, 1.0301, 1.0737,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0007, 1.0039, 1.0152, 1.0421,  &
0.9998, 0.9998, 0.9999, 0.9999, 1.0000, 1.0003, 1.0008, 1.0043, 1.0198 /
data ((supersat( 7,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0011, 1.0027, 1.0064, 1.0150, 1.0352, 1.0838, 1.2073, 1.5612,  &
1.0002, 1.0005, 1.0014, 1.0036, 1.0087, 1.0207, 1.0487, 1.1167, 1.2945,  &
1.0001, 1.0002, 1.0005, 1.0018, 1.0048, 1.0120, 1.0287, 1.0680, 1.1649,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0021, 1.0064, 1.0166, 1.0402, 1.0962,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0005, 1.0024, 1.0085, 1.0230, 1.0567,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0026, 1.0110, 1.0315,  &
0.9999, 0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0027, 1.0140 /
data ((supersat( 7,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0022, 1.0054, 1.0127, 1.0299, 1.0714, 1.1752, 1.4597,  &
1.0002, 1.0004, 1.0012, 1.0030, 1.0073, 1.0173, 1.0410, 1.0983, 1.2448,  &
1.0001, 1.0002, 1.0004, 1.0014, 1.0039, 1.0099, 1.0238, 1.0566, 1.1368,  &
1.0001, 1.0001, 1.0002, 1.0004, 1.0016, 1.0051, 1.0134, 1.0328, 1.0788,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0004, 1.0018, 1.0065, 1.0182, 1.0455,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0018, 1.0083, 1.0246,  &
0.9999, 0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0019, 1.0103 /
data ((supersat( 7,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0012, 1.0040, 1.0109, 1.0262, 1.0615, 1.1477, 1.3953, 2.6636, 4.9169,  &
1.0003, 1.0013, 1.0054, 1.0153, 1.0380, 1.0910, 1.2261, 1.6761, 3.8797,  &
1.0002, 1.0003, 1.0014, 1.0070, 1.0215, 1.0551, 1.1361, 1.3608, 2.4094,  &
1.0000, 1.0002, 1.0005, 1.0014, 1.0089, 1.0295, 1.0791, 1.2063, 1.6196,  &
0.9996, 0.9997, 1.0000, 1.0005, 1.0017, 1.0108, 1.0392, 1.1119, 1.3195,  &
0.9986, 0.9986, 0.9988, 0.9992, 1.0002, 1.0025, 1.0125, 1.0498, 1.1548,  &
0.9963, 0.9963, 0.9964, 0.9967, 0.9973, 0.9990, 1.0030, 1.0137, 1.0599 /
data ((supersat( 7,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0009, 1.0029, 1.0076, 1.0181, 1.0422, 1.0995, 1.2503, 1.7901, 3.6753,  &
1.0003, 1.0010, 1.0038, 1.0106, 1.0260, 1.0616, 1.1480, 1.3933, 2.5397,  &
1.0001, 1.0003, 1.0010, 1.0049, 1.0147, 1.0375, 1.0907, 1.2260, 1.6689,  &
1.0001, 1.0002, 1.0003, 1.0010, 1.0061, 1.0204, 1.0538, 1.1348, 1.3589,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0011, 1.0074, 1.0275, 1.0763, 1.2024,  &
0.9994, 0.9994, 0.9995, 0.9998, 1.0003, 1.0016, 1.0087, 1.0356, 1.1058,  &
0.9980, 0.9980, 0.9981, 0.9982, 0.9986, 0.9997, 1.0021, 1.0096, 1.0438 /
data ((supersat( 7,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0007, 1.0021, 1.0054, 1.0130, 1.0303, 1.0710, 1.1731, 1.4780, 2.7180,  &
1.0002, 1.0007, 1.0027, 1.0075, 1.0185, 1.0435, 1.1031, 1.2590, 1.7977,  &
1.0001, 1.0002, 1.0008, 1.0034, 1.0103, 1.0263, 1.0632, 1.1527, 1.4049,  &
1.0001, 1.0001, 1.0002, 1.0008, 1.0042, 1.0141, 1.0375, 1.0922, 1.2318,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0008, 1.0050, 1.0191, 1.0529, 1.1354,  &
0.9997, 0.9997, 0.9998, 1.0000, 1.0003, 1.0010, 1.0056, 1.0249, 1.0731,  &
0.9989, 0.9989, 0.9990, 0.9991, 0.9993, 0.9999, 1.0014, 1.0062, 1.0310 /
data ((supersat( 7,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0016, 1.0040, 1.0097, 1.0228, 1.0535, 1.1285, 1.3334, 2.0846,  &
1.0002, 1.0006, 1.0020, 1.0054, 1.0136, 1.0322, 1.0761, 1.1860, 1.5092,  &
1.0001, 1.0002, 1.0006, 1.0024, 1.0074, 1.0191, 1.0460, 1.1099, 1.2768,  &
1.0001, 1.0001, 1.0002, 1.0006, 1.0029, 1.0100, 1.0268, 1.0659, 1.1615,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0032, 1.0133, 1.0374, 1.0949,  &
0.9998, 0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0035, 1.0172, 1.0514,  &
0.9993, 0.9993, 0.9994, 0.9994, 0.9996, 1.0000, 1.0009, 1.0037, 1.0213 /
data ((supersat( 7,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0004, 1.0012, 1.0031, 1.0076, 1.0180, 1.0423, 1.1013, 1.2548, 1.7337,  &
1.0002, 1.0004, 1.0015, 1.0042, 1.0105, 1.0250, 1.0592, 1.1431, 1.3715,  &
1.0001, 1.0002, 1.0004, 1.0018, 1.0055, 1.0144, 1.0350, 1.0838, 1.2062,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0020, 1.0073, 1.0199, 1.0494, 1.1200,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0021, 1.0094, 1.0274, 1.0697,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0022, 1.0119, 1.0371,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0006, 1.0023, 1.0146 /
data ((supersat( 7,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0025, 1.0062, 1.0148, 1.0349, 1.0836, 1.2069, 1.5607,  &
1.0001, 1.0004, 1.0012, 1.0033, 1.0084, 1.0203, 1.0482, 1.1161, 1.2937,  &
1.0001, 1.0001, 1.0004, 1.0013, 1.0043, 1.0114, 1.0280, 1.0671, 1.1636,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0015, 1.0055, 1.0154, 1.0388, 1.0942,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0004, 1.0015, 1.0069, 1.0208, 1.0538,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0001, 1.0004, 1.0015, 1.0085, 1.0278,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9998, 1.0000, 1.0004, 1.0016, 1.0100 /
data ((supersat( 7,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0021, 1.0052, 1.0125, 1.0297, 1.0712, 1.1749, 1.4593,  &
1.0001, 1.0003, 1.0009, 1.0027, 1.0070, 1.0170, 1.0406, 1.0978, 1.2442,  &
1.0001, 1.0001, 1.0003, 1.0011, 1.0035, 1.0093, 1.0231, 1.0559, 1.1359,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0011, 1.0043, 1.0124, 1.0316, 1.0773,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0011, 1.0053, 1.0165, 1.0433,  &
0.9999, 0.9999, 1.0000, 1.0000, 1.0001, 1.0003, 1.0011, 1.0062, 1.0216,  &
0.9996, 0.9996, 0.9997, 0.9997, 0.9998, 0.9999, 1.0003, 1.0012, 1.0071 /
data ((supersat( 7,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0007, 1.0032, 1.0098, 1.0248, 1.0597, 1.1450, 1.3907, 2.6501, 4.8938,  &
1.0002, 1.0007, 1.0040, 1.0134, 1.0354, 1.0872, 1.2200, 1.6636, 3.8350,  &
1.0001, 1.0003, 1.0008, 1.0048, 1.0182, 1.0501, 1.1280, 1.3461, 2.3680,  &
0.9998, 1.0000, 1.0003, 1.0010, 1.0055, 1.0238, 1.0695, 1.1890, 1.5811,  &
0.9991, 0.9992, 0.9994, 1.0000, 1.0013, 1.0060, 1.0299, 1.0939, 1.2813,  &
0.9973, 0.9973, 0.9975, 0.9979, 0.9989, 1.0013, 1.0076, 1.0355, 1.1222,  &
0.9945, 0.9945, 0.9946, 0.9948, 0.9954, 0.9968, 1.0005, 1.0108, 1.0401 /
data ((supersat( 7,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0006, 1.0023, 1.0068, 1.0172, 1.0411, 1.0980, 1.2481, 1.7860, 3.6625,  &
1.0002, 1.0006, 1.0029, 1.0093, 1.0244, 1.0594, 1.1448, 1.3878, 2.5239,  &
1.0001, 1.0002, 1.0006, 1.0034, 1.0126, 1.0345, 1.0863, 1.2188, 1.6540,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0038, 1.0167, 1.0482, 1.1256, 1.3417,  &
0.9996, 0.9997, 0.9998, 1.0002, 1.0009, 1.0041, 1.0214, 1.0657, 1.1827,  &
0.9986, 0.9987, 0.9988, 0.9990, 0.9996, 1.0010, 1.0044, 1.0260, 1.0865,  &
0.9965, 0.9965, 0.9966, 0.9967, 0.9971, 0.9981, 1.0006, 1.0069, 1.0300 /
data ((supersat( 7,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0004, 1.0017, 1.0049, 1.0124, 1.0296, 1.0701, 1.1719, 1.4760, 2.7121,  &
1.0001, 1.0005, 1.0020, 1.0066, 1.0174, 1.0422, 1.1013, 1.2561, 1.7922,  &
1.0001, 1.0002, 1.0005, 1.0024, 1.0088, 1.0243, 1.0605, 1.1487, 1.3978,  &
1.0000, 1.0001, 1.0002, 1.0005, 1.0026, 1.0117, 1.0339, 1.0868, 1.2226,  &
0.9998, 0.9999, 1.0000, 1.0002, 1.0006, 1.0027, 1.0149, 1.0462, 1.1241,  &
0.9993, 0.9993, 0.9994, 0.9995, 0.9999, 1.0008, 1.0029, 1.0183, 1.0610,  &
0.9979, 0.9979, 0.9979, 0.9980, 0.9983, 0.9989, 1.0005, 1.0043, 1.0213 /
data ((supersat( 7,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0004, 1.0013, 1.0036, 1.0093, 1.0223, 1.0529, 1.1278, 1.3323, 2.0822,  &
1.0001, 1.0004, 1.0015, 1.0048, 1.0128, 1.0313, 1.0749, 1.1843, 1.5064,  &
1.0001, 1.0001, 1.0004, 1.0017, 1.0063, 1.0177, 1.0442, 1.1074, 1.2729,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0018, 1.0082, 1.0243, 1.0624, 1.1560,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0004, 1.0018, 1.0103, 1.0329, 1.0878,  &
0.9996, 0.9996, 0.9996, 0.9997, 1.0000, 1.0005, 1.0019, 1.0125, 1.0433,  &
0.9986, 0.9986, 0.9986, 0.9987, 0.9989, 0.9993, 1.0003, 1.0026, 1.0145 /
data ((supersat( 7,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0028, 1.0073, 1.0176, 1.0419, 1.1008, 1.2541, 1.7325,  &
1.0001, 1.0003, 1.0011, 1.0037, 1.0099, 1.0243, 1.0584, 1.1420, 1.3698,  &
1.0001, 1.0001, 1.0003, 1.0012, 1.0047, 1.0134, 1.0338, 1.0821, 1.2037,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0012, 1.0059, 1.0181, 1.0469, 1.1164,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0012, 1.0072, 1.0242, 1.0649,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0004, 1.0013, 1.0085, 1.0314,  &
0.9989, 0.9989, 0.9990, 0.9990, 0.9991, 0.9995, 1.0001, 1.0017, 1.0095 /
data ((supersat( 7,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0023, 1.0059, 1.0145, 1.0346, 1.0832, 1.2065, 1.5599,  &
1.0001, 1.0002, 1.0009, 1.0029, 1.0079, 1.0197, 1.0476, 1.1154, 1.2926,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0036, 1.0106, 1.0270, 1.0658, 1.1619,  &
1.0000, 1.0001, 1.0001, 1.0002, 1.0009, 1.0044, 1.0140, 1.0369, 1.0916,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0003, 1.0009, 1.0052, 1.0184, 1.0502,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0010, 1.0058, 1.0235,  &
0.9991, 0.9991, 0.9991, 0.9992, 0.9993, 0.9995, 1.0000, 1.0011, 1.0062 /
data ((supersat( 7,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0019, 1.0050, 1.0123, 1.0295, 1.0709, 1.1745, 1.4588,  &
1.0001, 1.0002, 1.0007, 1.0024, 1.0066, 1.0165, 1.0401, 1.0972, 1.2434,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0029, 1.0086, 1.0223, 1.0549, 1.1345,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0034, 1.0113, 1.0301, 1.0753,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0039, 1.0145, 1.0405,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0041, 1.0182,  &
0.9992, 0.9992, 0.9992, 0.9992, 0.9993, 0.9995, 0.9999, 1.0008, 1.0042 /
data ((supersat( 7,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0004, 1.0023, 1.0085, 1.0231, 1.0573, 1.1415, 1.3848, 2.6322, 4.8636,  &
1.0002, 1.0005, 1.0026, 1.0112, 1.0322, 1.0824, 1.2122, 1.6477, 3.7773,  &
1.0000, 1.0002, 1.0006, 1.0027, 1.0144, 1.0442, 1.1183, 1.3277, 2.3154,  &
0.9995, 0.9996, 1.0000, 1.0008, 1.0028, 1.0178, 1.0588, 1.1688, 1.5346,  &
0.9981, 0.9982, 0.9985, 0.9991, 1.0005, 1.0041, 1.0209, 1.0751, 1.2391,  &
0.9956, 0.9957, 0.9958, 0.9962, 0.9971, 0.9995, 1.0055, 1.0234, 1.0916,  &
0.9928, 0.9929, 0.9929, 0.9931, 0.9936, 0.9948, 0.9978, 1.0063, 1.0331 /
data ((supersat( 7,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0004, 1.0017, 1.0060, 1.0161, 1.0397, 1.0962, 1.2453, 1.7805, 3.6455,  &
1.0001, 1.0004, 1.0019, 1.0078, 1.0225, 1.0567, 1.1407, 1.3807, 2.5032,  &
1.0000, 1.0002, 1.0004, 1.0020, 1.0102, 1.0309, 1.0808, 1.2096, 1.6351,  &
0.9998, 0.9999, 1.0001, 1.0005, 1.0020, 1.0127, 1.0416, 1.1144, 1.3203,  &
0.9991, 0.9992, 0.9993, 0.9997, 1.0005, 1.0026, 1.0152, 1.0541, 1.1602,  &
0.9974, 0.9975, 0.9976, 0.9978, 0.9985, 1.0000, 1.0037, 1.0173, 1.0672,  &
0.9947, 0.9947, 0.9948, 0.9949, 0.9953, 0.9962, 0.9985, 1.0044, 1.0189 /
data ((supersat( 7,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0013, 1.0043, 1.0117, 1.0287, 1.0690, 1.1703, 1.4733, 2.7041,  &
1.0001, 1.0003, 1.0014, 1.0056, 1.0161, 1.0405, 1.0989, 1.2524, 1.7849,  &
1.0001, 1.0001, 1.0003, 1.0014, 1.0072, 1.0220, 1.0571, 1.1435, 1.3887,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0014, 1.0089, 1.0296, 1.0801, 1.2112,  &
0.9996, 0.9996, 0.9997, 0.9999, 1.0004, 1.0016, 1.0106, 1.0387, 1.1109,  &
0.9985, 0.9986, 0.9986, 0.9988, 0.9992, 1.0001, 1.0023, 1.0121, 1.0485,  &
0.9964, 0.9964, 0.9964, 0.9965, 0.9968, 0.9974, 0.9990, 1.0028, 1.0132 /
data ((supersat( 7,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0032, 1.0087, 1.0217, 1.0521, 1.1268, 1.3308, 2.0789,  &
1.0001, 1.0002, 1.0010, 1.0041, 1.0119, 1.0301, 1.0734, 1.1821, 1.5026,  &
1.0000, 1.0001, 1.0002, 1.0010, 1.0051, 1.0161, 1.0419, 1.1042, 1.2677,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0010, 1.0062, 1.0214, 1.0581, 1.1491,  &
0.9997, 0.9998, 0.9998, 1.0000, 1.0003, 1.0011, 1.0072, 1.0278, 1.0793,  &
0.9991, 0.9991, 0.9991, 0.9992, 0.9995, 1.0001, 1.0015, 1.0080, 1.0348,  &
0.9974, 0.9974, 0.9974, 0.9975, 0.9977, 0.9981, 0.9992, 1.0017, 1.0086 /
data ((supersat( 7,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0025, 1.0069, 1.0171, 1.0414, 1.1001, 1.2531, 1.7309,  &
1.0001, 1.0002, 1.0008, 1.0031, 1.0091, 1.0235, 1.0573, 1.1406, 1.3675,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0038, 1.0121, 1.0321, 1.0799, 1.2004,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0044, 1.0159, 1.0439, 1.1118,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0008, 1.0049, 1.0204, 1.0591,  &
0.9993, 0.9993, 0.9994, 0.9994, 0.9996, 1.0001, 1.0010, 1.0052, 1.0253,  &
0.9980, 0.9980, 0.9980, 0.9980, 0.9982, 0.9985, 0.9993, 1.0010, 1.0054 /
data ((supersat( 7,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0020, 1.0056, 1.0141, 1.0342, 1.0827, 1.2058, 1.5588,  &
1.0001, 1.0002, 1.0006, 1.0024, 1.0073, 1.0190, 1.0468, 1.1143, 1.2910,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0029, 1.0096, 1.0257, 1.0642, 1.1596,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0032, 1.0123, 1.0346, 1.0883,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0002, 1.0006, 1.0034, 1.0154, 1.0459,  &
0.9994, 0.9994, 0.9995, 0.9995, 0.9997, 1.0000, 1.0007, 1.0035, 1.0188,  &
0.9983, 0.9983, 0.9983, 0.9983, 0.9984, 0.9987, 0.9993, 1.0005, 1.0037 /
data ((supersat( 7,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0017, 1.0047, 1.0119, 1.0291, 1.0704, 1.1740, 1.4580,  &
1.0001, 1.0001, 1.0005, 1.0020, 1.0061, 1.0159, 1.0394, 1.0964, 1.2422,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0023, 1.0078, 1.0213, 1.0536, 1.1328,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0005, 1.0024, 1.0098, 1.0282, 1.0727,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0025, 1.0121, 1.0370,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 1.0000, 1.0005, 1.0025, 1.0144,  &
0.9984, 0.9984, 0.9984, 0.9984, 0.9985, 0.9987, 0.9992, 1.0003, 1.0027 /
data ((supersat( 7,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0018, 1.0076, 1.0219, 1.0557, 1.1391, 1.3805, 2.6192, 4.8416,  &
1.0002, 1.0004, 1.0018, 1.0097, 1.0301, 1.0792, 1.2067, 1.6364, 3.7359,  &
0.9999, 1.0001, 1.0005, 1.0019, 1.0121, 1.0403, 1.1117, 1.3150, 2.2780,  &
0.9991, 0.9993, 0.9996, 1.0005, 1.0025, 1.0144, 1.0521, 1.1556, 1.5035,  &
0.9973, 0.9974, 0.9977, 0.9983, 0.9998, 1.0035, 1.0162, 1.0643, 1.2133,  &
0.9946, 0.9946, 0.9947, 0.9951, 0.9960, 0.9982, 1.0039, 1.0176, 1.0757,  &
0.9921, 0.9921, 0.9921, 0.9923, 0.9927, 0.9937, 0.9963, 1.0038, 1.0269 /
data ((supersat( 7,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0003, 1.0013, 1.0053, 1.0154, 1.0388, 1.0948, 1.2432, 1.7765, 3.6331,  &
1.0001, 1.0003, 1.0014, 1.0069, 1.0211, 1.0548, 1.1378, 1.3756, 2.4882,  &
1.0000, 1.0001, 1.0004, 1.0014, 1.0086, 1.0285, 1.0770, 1.2033, 1.6217,  &
0.9996, 0.9997, 0.9999, 1.0004, 1.0015, 1.0103, 1.0375, 1.1070, 1.3058,  &
0.9986, 0.9987, 0.9989, 0.9993, 1.0002, 1.0023, 1.0118, 1.0471, 1.1458,  &
0.9965, 0.9966, 0.9967, 0.9969, 0.9975, 0.9991, 1.0028, 1.0129, 1.0565,  &
0.9937, 0.9937, 0.9938, 0.9939, 0.9942, 0.9950, 0.9971, 1.0026, 1.0187 /
data ((supersat( 7,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0010, 1.0039, 1.0111, 1.0281, 1.0681, 1.1691, 1.4714, 2.6982,  &
1.0001, 1.0002, 1.0010, 1.0049, 1.0151, 1.0393, 1.0972, 1.2497, 1.7796,  &
1.0000, 1.0001, 1.0003, 1.0010, 1.0060, 1.0204, 1.0548, 1.1399, 1.3822,  &
0.9998, 0.9999, 1.0000, 1.0003, 1.0011, 1.0072, 1.0268, 1.0756, 1.2033,  &
0.9993, 0.9993, 0.9994, 0.9997, 1.0002, 1.0015, 1.0081, 1.0341, 1.1023,  &
0.9979, 0.9979, 0.9980, 0.9981, 0.9986, 0.9995, 1.0018, 1.0088, 1.0412,  &
0.9953, 0.9954, 0.9954, 0.9955, 0.9957, 0.9963, 0.9979, 1.0016, 1.0120 /
data ((supersat( 7,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0029, 1.0084, 1.0212, 1.0516, 1.1261, 1.3298, 2.0764,  &
1.0001, 1.0002, 1.0008, 1.0036, 1.0112, 1.0293, 1.0723, 1.1805, 1.4998,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0043, 1.0149, 1.0404, 1.1019, 1.2640,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0008, 1.0049, 1.0195, 1.0551, 1.1443,  &
0.9996, 0.9996, 0.9997, 0.9998, 1.0002, 1.0010, 1.0054, 1.0246, 1.0738,  &
0.9986, 0.9986, 0.9987, 0.9988, 0.9991, 0.9997, 1.0012, 1.0057, 1.0297,  &
0.9965, 0.9965, 0.9966, 0.9966, 0.9968, 0.9972, 0.9983, 1.0008, 1.0073 /
data ((supersat( 7,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0023, 1.0066, 1.0168, 1.0410, 1.0996, 1.2524, 1.7296,  &
1.0001, 1.0002, 1.0006, 1.0027, 1.0086, 1.0228, 1.0565, 1.1395, 1.3658,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0031, 1.0113, 1.0310, 1.0783, 1.1980,  &
0.9999, 1.0000, 1.0000, 1.0002, 1.0006, 1.0034, 1.0145, 1.0417, 1.1086,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0001, 1.0007, 1.0036, 1.0180, 1.0552,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9993, 0.9998, 1.0008, 1.0037, 1.0216,  &
0.9972, 0.9972, 0.9972, 0.9973, 0.9974, 0.9977, 0.9985, 1.0003, 1.0046 /
data ((supersat( 7,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0018, 1.0053, 1.0138, 1.0339, 1.0823, 1.2053, 1.5580,  &
1.0001, 1.0001, 1.0005, 1.0021, 1.0069, 1.0185, 1.0462, 1.1135, 1.2899,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0024, 1.0088, 1.0248, 1.0630, 1.1579,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0005, 1.0025, 1.0111, 1.0329, 1.0860,  &
0.9997, 0.9998, 0.9998, 0.9999, 1.0001, 1.0005, 1.0025, 1.0136, 1.0429,  &
0.9991, 0.9991, 0.9991, 0.9992, 0.9994, 0.9997, 1.0005, 1.0026, 1.0160,  &
0.9976, 0.9976, 0.9976, 0.9976, 0.9977, 0.9980, 0.9986, 1.0000, 1.0031 /
data ((supersat( 7,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0015, 1.0045, 1.0117, 1.0288, 1.0701, 1.1736, 1.4574,  &
1.0000, 1.0001, 1.0004, 1.0017, 1.0057, 1.0155, 1.0389, 1.0958, 1.2413,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0019, 1.0072, 1.0205, 1.0526, 1.1315,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0004, 1.0019, 1.0088, 1.0269, 1.0709,  &
0.9998, 0.9998, 0.9998, 0.9999, 1.0001, 1.0004, 1.0019, 1.0105, 1.0347,  &
0.9992, 0.9992, 0.9992, 0.9993, 0.9994, 0.9997, 1.0004, 1.0020, 1.0121,  &
0.9977, 0.9977, 0.9977, 0.9978, 0.9979, 0.9981, 0.9986, 0.9997, 1.0022 /
data ((supersat( 7,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0003, 1.0014, 1.0069, 1.0210, 1.0544, 1.1371, 1.3771, 2.6086, 4.8237,  &
1.0001, 1.0004, 1.0014, 1.0087, 1.0285, 1.0766, 1.2024, 1.6272, 3.7025,  &
0.9997, 1.0000, 1.0004, 1.0015, 1.0104, 1.0374, 1.1066, 1.3051, 2.2483,  &
0.9988, 0.9989, 0.9993, 1.0002, 1.0023, 1.0120, 1.0473, 1.1458, 1.4796,  &
0.9967, 0.9968, 0.9970, 0.9977, 0.9992, 1.0028, 1.0132, 1.0569, 1.1949,  &
0.9938, 0.9939, 0.9940, 0.9943, 0.9952, 0.9973, 1.0027, 1.0187, 1.0654,  &
0.9916, 0.9917, 0.9917, 0.9918, 0.9922, 0.9931, 0.9954, 1.0021, 1.0228 /
data ((supersat( 7,iw,iconc,2, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0011, 1.0049, 1.0148, 1.0380, 1.0937, 1.2415, 1.7733, 3.6230,  &
1.0001, 1.0002, 1.0011, 1.0062, 1.0201, 1.0533, 1.1355, 1.3715, 2.4759,  &
0.9999, 1.0001, 1.0003, 1.0011, 1.0074, 1.0267, 1.0741, 1.1982, 1.6110,  &
0.9995, 0.9996, 0.9998, 1.0003, 1.0015, 1.0086, 1.0344, 1.1014, 1.2945,  &
0.9982, 0.9983, 0.9984, 0.9989, 0.9998, 1.0020, 1.0095, 1.0422, 1.1353,  &
0.9958, 0.9959, 0.9960, 0.9962, 0.9968, 0.9983, 1.0020, 1.0121, 1.0494,  &
0.9930, 0.9931, 0.9931, 0.9932, 0.9935, 0.9943, 0.9962, 1.0013, 1.0162 /
data ((supersat( 7,iw,iconc,3, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0008, 1.0036, 1.0107, 1.0276, 1.0675, 1.1682, 1.4698, 2.6934,  &
1.0001, 1.0002, 1.0008, 1.0044, 1.0144, 1.0383, 1.0958, 1.2475, 1.7753,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0052, 1.0192, 1.0530, 1.1370, 1.3769,  &
0.9997, 0.9998, 1.0000, 1.0003, 1.0010, 1.0060, 1.0248, 1.0721, 1.1971,  &
0.9990, 0.9991, 0.9992, 0.9994, 1.0000, 1.0013, 1.0065, 1.0307, 1.0959,  &
0.9973, 0.9974, 0.9974, 0.9976, 0.9980, 0.9990, 1.0014, 1.0076, 1.0363,  &
0.9946, 0.9946, 0.9946, 0.9947, 0.9950, 0.9956, 0.9970, 1.0006, 1.0106 /
data ((supersat( 7,iw,iconc,4, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0027, 1.0081, 1.0209, 1.0511, 1.1255, 1.3288, 2.0744,  &
1.0001, 1.0002, 1.0006, 1.0032, 1.0107, 1.0287, 1.0714, 1.1792, 1.4975,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0037, 1.0140, 1.0391, 1.1001, 1.2610,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0007, 1.0041, 1.0180, 1.0528, 1.1405,  &
0.9994, 0.9994, 0.9995, 0.9997, 1.0001, 1.0009, 1.0042, 1.0222, 1.0696,  &
0.9982, 0.9982, 0.9983, 0.9984, 0.9987, 0.9993, 1.0009, 1.0046, 1.0262,  &
0.9958, 0.9958, 0.9959, 0.9959, 0.9961, 0.9965, 0.9976, 1.0001, 1.0065 /
data ((supersat( 7,iw,iconc,5, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0021, 1.0063, 1.0165, 1.0406, 1.0992, 1.2518, 1.7286,  &
1.0001, 1.0001, 1.0005, 1.0024, 1.0083, 1.0224, 1.0559, 1.1386, 1.3644,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0027, 1.0106, 1.0301, 1.0770, 1.1961,  &
0.9999, 0.9999, 1.0000, 1.0002, 1.0005, 1.0028, 1.0133, 1.0401, 1.1060,  &
0.9996, 0.9996, 0.9996, 0.9998, 1.0000, 1.0006, 1.0029, 1.0163, 1.0522,  &
0.9986, 0.9986, 0.9987, 0.9987, 0.9990, 0.9995, 1.0005, 1.0031, 1.0190,  &
0.9966, 0.9966, 0.9966, 0.9966, 0.9968, 0.9971, 0.9979, 0.9997, 1.0040 /
data ((supersat( 7,iw,iconc,6, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0017, 1.0051, 1.0136, 1.0336, 1.0820, 1.2049, 1.5573,  &
1.0000, 1.0001, 1.0004, 1.0019, 1.0066, 1.0181, 1.0457, 1.1129, 1.2889,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0020, 1.0083, 1.0241, 1.0621, 1.1565,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0021, 1.0102, 1.0316, 1.0841,  &
0.9996, 0.9997, 0.9997, 0.9998, 1.0000, 1.0005, 1.0021, 1.0122, 1.0407,  &
0.9988, 0.9988, 0.9989, 0.9989, 0.9991, 0.9995, 1.0003, 1.0023, 1.0139,  &
0.9970, 0.9970, 0.9970, 0.9970, 0.9971, 0.9974, 0.9980, 0.9994, 1.0026 /
data ((supersat( 7,iw,iconc,7, 6),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0014, 1.0043, 1.0115, 1.0286, 1.0699, 1.1732, 1.4569,  &
1.0000, 1.0001, 1.0003, 1.0015, 1.0054, 1.0152, 1.0385, 1.0953, 1.2406,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0016, 1.0067, 1.0199, 1.0518, 1.1304,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0003, 1.0016, 1.0081, 1.0259, 1.0694,  &
0.9997, 0.9997, 0.9997, 0.9998, 1.0000, 1.0004, 1.0016, 1.0094, 1.0329,  &
0.9989, 0.9989, 0.9989, 0.9990, 0.9992, 0.9995, 1.0002, 1.0017, 1.0105,  &
0.9972, 0.9972, 0.9972, 0.9972, 0.9973, 0.9975, 0.9980, 0.9992, 1.0018 /
data ((supersat( 7,iw,iconc,1, 7),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0064, 1.0203, 1.0533, 1.1354, 1.3741, 2.5993, 4.8082,  &
1.0001, 1.0003, 1.0012, 1.0078, 1.0271, 1.0744, 1.1987, 1.6194, 3.6740,  &
0.9996, 0.9999, 1.0004, 1.0015, 1.0092, 1.0351, 1.1025, 1.2968, 2.2231,  &
0.9985, 0.9986, 0.9990, 0.9999, 1.0021, 1.0102, 1.0436, 1.1379, 1.4603,  &
0.9961, 0.9962, 0.9965, 0.9971, 0.9986, 1.0023, 1.0110, 1.0515, 1.1808,  &
0.9933, 0.9933, 0.9935, 0.9938, 0.9946, 0.9965, 1.0017, 1.0168, 1.0582,  &
0.9913, 0.9913, 0.9914, 0.9915, 0.9918, 0.9927, 0.9948, 1.0008, 1.0197 /
data ((supersat( 7,iw,iconc,2, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0046, 1.0143, 1.0373, 1.0928, 1.2400, 1.7705, 3.6142,  &
1.0001, 1.0002, 1.0009, 1.0056, 1.0192, 1.0520, 1.1336, 1.3680, 2.4654,  &
0.9999, 1.0000, 1.0003, 1.0010, 1.0065, 1.0252, 1.0717, 1.1940, 1.6019,  &
0.9993, 0.9994, 0.9996, 1.0002, 1.0014, 1.0073, 1.0319, 1.0968, 1.2852,  &
0.9978, 0.9979, 0.9981, 0.9985, 0.9994, 1.0017, 1.0079, 1.0385, 1.1271,  &
0.9953, 0.9953, 0.9954, 0.9956, 0.9962, 0.9977, 1.0013, 1.0112, 1.0442,  &
0.9926, 0.9926, 0.9926, 0.9927, 0.9930, 0.9937, 0.9955, 1.0003, 1.0142 /
data ((supersat( 7,iw,iconc,3, 7),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0033, 1.0104, 1.0271, 1.0669, 1.1674, 1.4684, 2.6892,  &
1.0001, 1.0002, 1.0007, 1.0040, 1.0139, 1.0375, 1.0947, 1.2457, 1.7715,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0046, 1.0182, 1.0514, 1.1346, 1.3724,  &
0.9997, 0.9997, 0.9999, 1.0002, 1.0009, 1.0050, 1.0231, 1.0693, 1.1919,  &
0.9988, 0.9988, 0.9989, 0.9992, 0.9998, 1.0012, 1.0053, 1.0282, 1.0907,  &
0.9969, 0.9969, 0.9969, 0.9971, 0.9975, 0.9985, 1.0009, 1.0071, 1.0326,  &
0.9940, 0.9940, 0.9941, 0.9942, 0.9944, 0.9950, 0.9964, 0.9998, 1.0094 /
data ((supersat( 7,iw,iconc,4, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0025, 1.0078, 1.0206, 1.0507, 1.1250, 1.3280, 2.0726,  &
1.0001, 1.0001, 1.0005, 1.0029, 1.0103, 1.0281, 1.0706, 1.1781, 1.4956,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0033, 1.0133, 1.0381, 1.0985, 1.2584,  &
0.9998, 0.9998, 0.9999, 1.0002, 1.0006, 1.0034, 1.0168, 1.0509, 1.1373,  &
0.9992, 0.9993, 0.9993, 0.9995, 0.9999, 1.0008, 1.0036, 1.0204, 1.0662,  &
0.9978, 0.9978, 0.9979, 0.9980, 0.9983, 0.9990, 1.0006, 1.0045, 1.0236,  &
0.9953, 0.9953, 0.9953, 0.9953, 0.9955, 0.9959, 0.9970, 0.9995, 1.0058 /
data ((supersat( 7,iw,iconc,5, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0019, 1.0061, 1.0163, 1.0404, 1.0989, 1.2513, 1.7277,  &
1.0001, 1.0001, 1.0004, 1.0022, 1.0079, 1.0219, 1.0553, 1.1379, 1.3632,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0024, 1.0100, 1.0293, 1.0759, 1.1944,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0024, 1.0124, 1.0387, 1.1038,  &
0.9994, 0.9995, 0.9995, 0.9996, 0.9999, 1.0005, 1.0025, 1.0149, 1.0498,  &
0.9983, 0.9983, 0.9984, 0.9984, 0.9987, 0.9992, 1.0003, 1.0029, 1.0170,  &
0.9960, 0.9960, 0.9960, 0.9961, 0.9962, 0.9965, 0.9973, 0.9992, 1.0035 /
data ((supersat( 7,iw,iconc,6, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0015, 1.0050, 1.0134, 1.0334, 1.0817, 1.2045, 1.5567,  &
1.0000, 1.0001, 1.0003, 1.0017, 1.0063, 1.0178, 1.0452, 1.1123, 1.2881,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0018, 1.0079, 1.0235, 1.0612, 1.1553,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0018, 1.0095, 1.0306, 1.0824,  &
0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 1.0004, 1.0018, 1.0111, 1.0389,  &
0.9985, 0.9986, 0.9986, 0.9987, 0.9988, 0.9992, 1.0001, 1.0021, 1.0124,  &
0.9964, 0.9965, 0.9965, 0.9965, 0.9966, 0.9969, 0.9975, 0.9989, 1.0022 /
data ((supersat( 7,iw,iconc,7, 7),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0013, 1.0042, 1.0113, 1.0284, 1.0697, 1.1730, 1.4565,  &
1.0000, 1.0001, 1.0003, 1.0014, 1.0052, 1.0149, 1.0382, 1.0948, 1.2399,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0014, 1.0063, 1.0194, 1.0512, 1.1294,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0014, 1.0075, 1.0250, 1.0681,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0003, 1.0014, 1.0085, 1.0314,  &
0.9987, 0.9987, 0.9987, 0.9988, 0.9989, 0.9992, 1.0000, 1.0016, 1.0092,  &
0.9967, 0.9967, 0.9967, 0.9967, 0.9968, 0.9970, 0.9976, 0.9988, 1.0014 /
data ((supersat( 8,iw,iconc,1, 1),iw=1,9),iconc=1,7)/    &
1.0011, 1.0038, 1.0107, 1.0260, 1.0613, 1.1474, 1.3948, 2.6623, 4.9141,  &
1.0003, 1.0012, 1.0051, 1.0150, 1.0376, 1.0905, 1.2255, 1.6748, 3.8750,  &
1.0002, 1.0003, 1.0012, 1.0066, 1.0210, 1.0544, 1.1351, 1.3592, 2.4052,  &
1.0000, 1.0001, 1.0004, 1.0012, 1.0083, 1.0286, 1.0778, 1.2042, 1.6154,  &
0.9995, 0.9996, 0.9999, 1.0004, 1.0017, 1.0099, 1.0378, 1.1094, 1.3147,  &
0.9983, 0.9984, 0.9985, 0.9989, 0.9999, 1.0023, 1.0113, 1.0474, 1.1499,  &
0.9959, 0.9959, 0.9960, 0.9962, 0.9969, 0.9985, 1.0026, 1.0123, 1.0563 /
data ((supersat( 8,iw,iconc,2, 1),iw=1,9),iconc=1,7)/    &
1.0008, 1.0028, 1.0074, 1.0179, 1.0420, 1.0993, 1.2501, 1.7897, 3.6741,  &
1.0002, 1.0009, 1.0036, 1.0103, 1.0258, 1.0613, 1.1476, 1.3927, 2.5382,  &
1.0001, 1.0003, 1.0009, 1.0046, 1.0144, 1.0371, 1.0902, 1.2252, 1.6673,  &
1.0001, 1.0001, 1.0003, 1.0009, 1.0057, 1.0198, 1.0531, 1.1337, 1.3570,  &
0.9998, 0.9999, 1.0001, 1.0004, 1.0010, 1.0068, 1.0265, 1.0748, 1.1999,  &
0.9992, 0.9993, 0.9994, 0.9996, 1.0002, 1.0015, 1.0078, 1.0341, 1.1030,  &
0.9977, 0.9977, 0.9977, 0.9979, 0.9983, 0.9994, 1.0018, 1.0086, 1.0415 /
data ((supersat( 8,iw,iconc,3, 1),iw=1,9),iconc=1,7)/    &
1.0006, 1.0020, 1.0052, 1.0129, 1.0302, 1.0709, 1.1730, 1.4778, 2.7174,  &
1.0002, 1.0007, 1.0026, 1.0073, 1.0183, 1.0434, 1.1029, 1.2586, 1.7972,  &
1.0001, 1.0002, 1.0007, 1.0032, 1.0101, 1.0260, 1.0628, 1.1523, 1.4042,  &
1.0001, 1.0001, 1.0002, 1.0007, 1.0038, 1.0137, 1.0370, 1.0916, 1.2308,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0007, 1.0045, 1.0184, 1.0520, 1.1340,  &
0.9996, 0.9997, 0.9997, 0.9999, 1.0002, 1.0010, 1.0050, 1.0238, 1.0714,  &
0.9987, 0.9987, 0.9987, 0.9988, 0.9991, 0.9998, 1.0012, 1.0054, 1.0294 /
data ((supersat( 8,iw,iconc,4, 1),iw=1,9),iconc=1,7)/    &
1.0005, 1.0015, 1.0040, 1.0096, 1.0227, 1.0534, 1.1285, 1.3333, 2.0844,  &
1.0002, 1.0005, 1.0019, 1.0053, 1.0135, 1.0321, 1.0759, 1.1858, 1.5090,  &
1.0001, 1.0002, 1.0005, 1.0023, 1.0072, 1.0189, 1.0457, 1.1096, 1.2764,  &
1.0001, 1.0001, 1.0002, 1.0005, 1.0026, 1.0097, 1.0265, 1.0655, 1.1609,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0029, 1.0128, 1.0368, 1.0941,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0002, 1.0007, 1.0031, 1.0164, 1.0503,  &
0.9992, 0.9992, 0.9992, 0.9993, 0.9995, 0.9999, 1.0008, 1.0032, 1.0202 /
data ((supersat( 8,iw,iconc,5, 1),iw=1,9),iconc=1,7)/    &
1.0004, 1.0012, 1.0031, 1.0076, 1.0179, 1.0423, 1.1012, 1.2547, 1.7336,  &
1.0001, 1.0004, 1.0014, 1.0041, 1.0104, 1.0249, 1.0591, 1.1430, 1.3713,  &
1.0001, 1.0001, 1.0004, 1.0016, 1.0054, 1.0143, 1.0349, 1.0836, 1.2060,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0018, 1.0070, 1.0197, 1.0491, 1.1196,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0004, 1.0019, 1.0090, 1.0270, 1.0692,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0019, 1.0114, 1.0364,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9996, 0.9999, 1.0005, 1.0021, 1.0138 /
data ((supersat( 8,iw,iconc,6, 1),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0024, 1.0062, 1.0147, 1.0349, 1.0835, 1.2069, 1.5606,  &
1.0001, 1.0003, 1.0011, 1.0032, 1.0083, 1.0202, 1.0481, 1.1161, 1.2936,  &
1.0001, 1.0001, 1.0003, 1.0012, 1.0042, 1.0112, 1.0278, 1.0670, 1.1635,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0053, 1.0152, 1.0385, 1.0940,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0013, 1.0066, 1.0205, 1.0534,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0014, 1.0080, 1.0272,  &
0.9995, 0.9995, 0.9995, 0.9996, 0.9997, 0.9999, 1.0003, 1.0014, 1.0094 /
data ((supersat( 8,iw,iconc,7, 1),iw=1,9),iconc=1,7)/    &
1.0003, 1.0008, 1.0021, 1.0052, 1.0125, 1.0297, 1.0711, 1.1748, 1.4593,  &
1.0001, 1.0003, 1.0009, 1.0026, 1.0069, 1.0169, 1.0406, 1.0978, 1.2441,  &
1.0001, 1.0001, 1.0003, 1.0010, 1.0034, 1.0092, 1.0230, 1.0558, 1.1358,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0010, 1.0041, 1.0123, 1.0315, 1.0771,  &
1.0000, 1.0000, 1.0001, 1.0001, 1.0003, 1.0010, 1.0050, 1.0162, 1.0430,  &
0.9999, 0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0010, 1.0059, 1.0212,  &
0.9996, 0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0002, 1.0011, 1.0066 /
data ((supersat( 8,iw,iconc,1, 2),iw=1,9),iconc=1,7)/    &
1.0007, 1.0031, 1.0095, 1.0245, 1.0593, 1.1444, 1.3898, 2.6474, 4.8888,  &
1.0002, 1.0007, 1.0037, 1.0130, 1.0348, 1.0864, 1.2188, 1.6613, 3.8262,  &
1.0001, 1.0003, 1.0007, 1.0043, 1.0175, 1.0490, 1.1264, 1.3432, 2.3601,  &
0.9998, 0.9999, 1.0002, 1.0010, 1.0048, 1.0227, 1.0676, 1.1857, 1.5737,  &
0.9989, 0.9990, 0.9992, 0.9998, 1.0012, 1.0052, 1.0281, 1.0905, 1.2741,  &
0.9969, 0.9970, 0.9971, 0.9975, 0.9985, 1.0010, 1.0072, 1.0330, 1.1164,  &
0.9941, 0.9941, 0.9942, 0.9944, 0.9949, 0.9963, 0.9999, 1.0099, 1.0369 /
data ((supersat( 8,iw,iconc,2, 2),iw=1,9),iconc=1,7)/    &
1.0005, 1.0022, 1.0067, 1.0170, 1.0409, 1.0977, 1.2477, 1.7852, 3.6599,  &
1.0002, 1.0005, 1.0026, 1.0090, 1.0241, 1.0590, 1.1442, 1.3867, 2.5209,  &
1.0001, 1.0002, 1.0005, 1.0031, 1.0121, 1.0339, 1.0854, 1.2174, 1.6512,  &
0.9999, 1.0000, 1.0002, 1.0006, 1.0034, 1.0160, 1.0470, 1.1237, 1.3383,  &
0.9995, 0.9996, 0.9997, 1.0001, 1.0009, 1.0035, 1.0202, 1.0636, 1.1789,  &
0.9984, 0.9984, 0.9985, 0.9988, 0.9994, 1.0008, 1.0045, 1.0243, 1.0829,  &
0.9961, 0.9961, 0.9961, 0.9963, 0.9967, 0.9977, 1.0001, 1.0065, 1.0277 /
data ((supersat( 8,iw,iconc,3, 2),iw=1,9),iconc=1,7)/    &
1.0004, 1.0016, 1.0047, 1.0123, 1.0294, 1.0699, 1.1716, 1.4756, 2.7109,  &
1.0001, 1.0004, 1.0019, 1.0064, 1.0171, 1.0419, 1.1009, 1.2555, 1.7912,  &
1.0001, 1.0001, 1.0004, 1.0021, 1.0085, 1.0239, 1.0599, 1.1479, 1.3965,  &
1.0000, 1.0001, 1.0002, 1.0004, 1.0023, 1.0111, 1.0331, 1.0857, 1.2209,  &
0.9998, 0.9998, 0.9999, 1.0001, 1.0006, 1.0023, 1.0141, 1.0449, 1.1219,  &
0.9991, 0.9992, 0.9992, 0.9994, 0.9998, 1.0006, 1.0026, 1.0171, 1.0587,  &
0.9975, 0.9975, 0.9976, 0.9977, 0.9980, 0.9986, 1.0002, 1.0040, 1.0197 /
data ((supersat( 8,iw,iconc,4, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0035, 1.0092, 1.0222, 1.0527, 1.1276, 1.3321, 2.0817,  &
1.0001, 1.0003, 1.0014, 1.0047, 1.0127, 1.0311, 1.0746, 1.1840, 1.5059,  &
1.0001, 1.0001, 1.0003, 1.0015, 1.0061, 1.0174, 1.0438, 1.1069, 1.2721,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0016, 1.0078, 1.0238, 1.0617, 1.1550,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0016, 1.0097, 1.0320, 1.0864,  &
0.9995, 0.9995, 0.9995, 0.9997, 0.9999, 1.0004, 1.0017, 1.0116, 1.0418,  &
0.9984, 0.9984, 0.9984, 0.9985, 0.9986, 0.9991, 1.0001, 1.0024, 1.0133 /
data ((supersat( 8,iw,iconc,5, 2),iw=1,9),iconc=1,7)/    &
1.0003, 1.0009, 1.0027, 1.0072, 1.0175, 1.0418, 1.1007, 1.2539, 1.7323,  &
1.0001, 1.0003, 1.0010, 1.0036, 1.0097, 1.0242, 1.0582, 1.1418, 1.3695,  &
1.0001, 1.0001, 1.0003, 1.0011, 1.0045, 1.0132, 1.0335, 1.0817, 1.2033,  &
1.0000, 1.0001, 1.0001, 1.0003, 1.0011, 1.0056, 1.0177, 1.0464, 1.1157,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0011, 1.0067, 1.0235, 1.0640,  &
0.9996, 0.9996, 0.9997, 0.9998, 0.9999, 1.0003, 1.0012, 1.0078, 1.0303,  &
0.9988, 0.9988, 0.9988, 0.9988, 0.9990, 0.9993, 1.0000, 1.0015, 1.0086 /
data ((supersat( 8,iw,iconc,6, 2),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0022, 1.0059, 1.0144, 1.0345, 1.0831, 1.2064, 1.5598,  &
1.0001, 1.0002, 1.0008, 1.0028, 1.0078, 1.0196, 1.0474, 1.1152, 1.2924,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0035, 1.0104, 1.0267, 1.0656, 1.1616,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0042, 1.0137, 1.0365, 1.0912,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0002, 1.0008, 1.0048, 1.0178, 1.0495,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 1.0002, 1.0009, 1.0053, 1.0227,  &
0.9989, 0.9989, 0.9990, 0.9990, 0.9991, 0.9993, 0.9999, 1.0010, 1.0056 /
data ((supersat( 8,iw,iconc,7, 2),iw=1,9),iconc=1,7)/    &
1.0002, 1.0006, 1.0019, 1.0049, 1.0122, 1.0294, 1.0708, 1.1744, 1.4587,  &
1.0001, 1.0002, 1.0006, 1.0023, 1.0065, 1.0164, 1.0400, 1.0971, 1.2432,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0028, 1.0085, 1.0221, 1.0547, 1.1343,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0006, 1.0032, 1.0110, 1.0298, 1.0750,  &
0.9999, 1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0035, 1.0141, 1.0399,  &
0.9997, 0.9997, 0.9997, 0.9998, 0.9999, 1.0002, 1.0007, 1.0037, 1.0175,  &
0.9990, 0.9990, 0.9990, 0.9991, 0.9992, 0.9994, 0.9998, 1.0007, 1.0038 /
data ((supersat( 8,iw,iconc,1, 3),iw=1,9),iconc=1,7)/    &
1.0004, 1.0021, 1.0081, 1.0227, 1.0568, 1.1407, 1.3834, 2.6280, 4.8561,  &
1.0002, 1.0004, 1.0023, 1.0107, 1.0315, 1.0813, 1.2104, 1.6440, 3.7637,  &
0.9999, 1.0001, 1.0006, 1.0023, 1.0136, 1.0428, 1.1160, 1.3235, 2.3031,  &
0.9993, 0.9995, 0.9998, 1.0007, 1.0025, 1.0166, 1.0564, 1.1642, 1.5241,  &
0.9978, 0.9979, 0.9982, 0.9988, 1.0003, 1.0039, 1.0192, 1.0712, 1.2301,  &
0.9952, 0.9952, 0.9954, 0.9957, 0.9967, 0.9990, 1.0049, 1.0212, 1.0857,  &
0.9925, 0.9925, 0.9926, 0.9927, 0.9932, 0.9943, 0.9972, 1.0054, 1.0308 /
data ((supersat( 8,iw,iconc,2, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0016, 1.0057, 1.0158, 1.0394, 1.0957, 1.2446, 1.7792, 3.6414,  &
1.0001, 1.0003, 1.0017, 1.0075, 1.0220, 1.0560, 1.1398, 1.3790, 2.4983,  &
1.0000, 1.0001, 1.0004, 1.0017, 1.0096, 1.0301, 1.0795, 1.2075, 1.6307,  &
0.9997, 0.9998, 1.0000, 1.0005, 1.0018, 1.0118, 1.0402, 1.1119, 1.3155,  &
0.9989, 0.9990, 0.9992, 0.9995, 1.0004, 1.0025, 1.0139, 1.0516, 1.1552,  &
0.9971, 0.9971, 0.9972, 0.9975, 0.9981, 0.9996, 1.0033, 1.0156, 1.0633,  &
0.9943, 0.9943, 0.9943, 0.9945, 0.9948, 0.9957, 0.9979, 1.0037, 1.0208 /
data ((supersat( 8,iw,iconc,3, 3),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0042, 1.0115, 1.0285, 1.0687, 1.1699, 1.4727, 2.7022,  &
1.0001, 1.0003, 1.0012, 1.0053, 1.0157, 1.0401, 1.0983, 1.2515, 1.7832,  &
1.0000, 1.0001, 1.0003, 1.0012, 1.0067, 1.0214, 1.0563, 1.1423, 1.3866,  &
0.9999, 1.0000, 1.0001, 1.0004, 1.0013, 1.0082, 1.0286, 1.0786, 1.2086,  &
0.9995, 0.9995, 0.9996, 0.9998, 1.0004, 1.0016, 1.0097, 1.0371, 1.1079,  &
0.9983, 0.9983, 0.9984, 0.9985, 0.9990, 0.9999, 1.0022, 1.0108, 1.0459,  &
0.9960, 0.9960, 0.9960, 0.9961, 0.9963, 0.9970, 0.9985, 1.0024, 1.0117 /
data ((supersat( 8,iw,iconc,4, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0031, 1.0086, 1.0215, 1.0519, 1.1266, 1.3305, 2.0781,  &
1.0001, 1.0002, 1.0009, 1.0039, 1.0117, 1.0298, 1.0730, 1.1816, 1.5018,  &
1.0000, 1.0001, 1.0002, 1.0009, 1.0048, 1.0156, 1.0414, 1.1034, 1.2665,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0009, 1.0057, 1.0207, 1.0571, 1.1475,  &
0.9997, 0.9997, 0.9998, 0.9999, 1.0003, 1.0010, 1.0065, 1.0267, 1.0775,  &
0.9989, 0.9989, 0.9990, 0.9991, 0.9993, 1.0000, 1.0014, 1.0071, 1.0330,  &
0.9971, 0.9971, 0.9971, 0.9972, 0.9973, 0.9978, 0.9989, 1.0014, 1.0076 /
data ((supersat( 8,iw,iconc,5, 3),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0024, 1.0068, 1.0170, 1.0412, 1.0999, 1.2529, 1.7305,  &
1.0001, 1.0002, 1.0007, 1.0030, 1.0089, 1.0232, 1.0570, 1.1402, 1.3670,  &
1.0000, 1.0001, 1.0002, 1.0007, 1.0035, 1.0118, 1.0318, 1.0794, 1.1997,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0007, 1.0040, 1.0154, 1.0431, 1.1108,  &
0.9998, 0.9998, 0.9998, 1.0000, 1.0002, 1.0007, 1.0044, 1.0196, 1.0578,  &
0.9992, 0.9992, 0.9992, 0.9993, 0.9995, 0.9999, 1.0009, 1.0045, 1.0239,  &
0.9977, 0.9977, 0.9977, 0.9977, 0.9979, 0.9982, 0.9990, 1.0007, 1.0050 /
data ((supersat( 8,iw,iconc,6, 3),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0019, 1.0055, 1.0140, 1.0341, 1.0825, 1.2056, 1.5586,  &
1.0001, 1.0001, 1.0005, 1.0023, 1.0072, 1.0189, 1.0466, 1.1141, 1.2907,  &
1.0000, 1.0001, 1.0001, 1.0005, 1.0027, 1.0093, 1.0254, 1.0638, 1.1591,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0005, 1.0029, 1.0119, 1.0340, 1.0876,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0001, 1.0006, 1.0030, 1.0148, 1.0449,  &
0.9993, 0.9993, 0.9993, 0.9994, 0.9996, 0.9999, 1.0006, 1.0031, 1.0178,  &
0.9980, 0.9980, 0.9980, 0.9980, 0.9981, 0.9984, 0.9990, 1.0003, 1.0034 /
data ((supersat( 8,iw,iconc,7, 3),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0016, 1.0046, 1.0118, 1.0290, 1.0703, 1.1738, 1.4578,  &
1.0001, 1.0001, 1.0004, 1.0019, 1.0059, 1.0158, 1.0393, 1.0962, 1.2419,  &
1.0000, 1.0001, 1.0001, 1.0004, 1.0021, 1.0076, 1.0210, 1.0532, 1.1324,  &
1.0000, 1.0000, 1.0000, 1.0001, 1.0004, 1.0022, 1.0095, 1.0278, 1.0721,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0001, 1.0005, 1.0022, 1.0115, 1.0362,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9996, 0.9999, 1.0005, 1.0023, 1.0136,  &
0.9981, 0.9981, 0.9982, 0.9982, 0.9983, 0.9985, 0.9990, 1.0001, 1.0025 /
data ((supersat( 8,iw,iconc,1, 4),iw=1,9),iconc=1,7)/    &
1.0003, 1.0012, 1.0065, 1.0205, 1.0536, 1.1360, 1.3751, 2.6023, 4.8128,  &
1.0001, 1.0004, 1.0013, 1.0080, 1.0275, 1.0751, 1.1999, 1.6219, 3.6831,  &
0.9997, 0.9999, 1.0004, 1.0016, 1.0095, 1.0358, 1.1038, 1.2994, 2.2311,  &
0.9985, 0.9987, 0.9991, 1.0000, 1.0022, 1.0107, 1.0447, 1.1404, 1.4663,  &
0.9963, 0.9964, 0.9966, 0.9973, 0.9988, 1.0024, 1.0116, 1.0531, 1.1851,  &
0.9934, 0.9935, 0.9936, 0.9939, 0.9947, 0.9967, 1.0020, 1.0173, 1.0603,  &
0.9913, 0.9914, 0.9915, 0.9916, 0.9919, 0.9928, 0.9949, 1.0012, 1.0206 /
data ((supersat( 8,iw,iconc,2, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0010, 1.0047, 1.0145, 1.0375, 1.0931, 1.2405, 1.7714, 3.6170,  &
1.0001, 1.0002, 1.0010, 1.0057, 1.0195, 1.0524, 1.1342, 1.3691, 2.4688,  &
0.9999, 1.0000, 1.0003, 1.0010, 1.0068, 1.0257, 1.0725, 1.1953, 1.6048,  &
0.9993, 0.9994, 0.9997, 1.0002, 1.0014, 1.0077, 1.0326, 1.0982, 1.2881,  &
0.9979, 0.9980, 0.9982, 0.9986, 0.9995, 1.0018, 1.0083, 1.0396, 1.1296,  &
0.9954, 0.9954, 0.9955, 0.9958, 0.9964, 0.9979, 1.0015, 1.0115, 1.0457,  &
0.9927, 0.9927, 0.9927, 0.9928, 0.9931, 0.9939, 0.9957, 1.0005, 1.0148 /
data ((supersat( 8,iw,iconc,3, 4),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0034, 1.0105, 1.0273, 1.0671, 1.1676, 1.4689, 2.6906,  &
1.0001, 1.0002, 1.0007, 1.0041, 1.0140, 1.0378, 1.0950, 1.2463, 1.7728,  &
1.0000, 1.0001, 1.0002, 1.0008, 1.0048, 1.0185, 1.0519, 1.1353, 1.3739,  &
0.9997, 0.9997, 0.9999, 1.0002, 1.0009, 1.0053, 1.0236, 1.0702, 1.1936,  &
0.9989, 0.9989, 0.9990, 0.9993, 0.9999, 1.0012, 1.0056, 1.0289, 1.0923,  &
0.9970, 0.9970, 0.9971, 0.9972, 0.9976, 0.9987, 1.0010, 1.0072, 1.0337,  &
0.9942, 0.9942, 0.9942, 0.9943, 0.9945, 0.9951, 0.9965, 1.0001, 1.0097 /
data ((supersat( 8,iw,iconc,4, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0006, 1.0026, 1.0079, 1.0207, 1.0509, 1.1252, 1.3283, 2.0732,  &
1.0001, 1.0001, 1.0006, 1.0030, 1.0104, 1.0283, 1.0709, 1.1785, 1.4962,  &
1.0000, 1.0001, 1.0002, 1.0006, 1.0034, 1.0135, 1.0384, 1.0990, 1.2593,  &
0.9998, 0.9999, 1.0000, 1.0002, 1.0006, 1.0036, 1.0171, 1.0515, 1.1383,  &
0.9993, 0.9993, 0.9994, 0.9996, 1.0000, 1.0008, 1.0037, 1.0209, 1.0672,  &
0.9979, 0.9979, 0.9980, 0.9981, 0.9984, 0.9991, 1.0006, 1.0045, 1.0244,  &
0.9954, 0.9954, 0.9954, 0.9955, 0.9957, 0.9961, 0.9971, 0.9996, 1.0060 /
data ((supersat( 8,iw,iconc,5, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0020, 1.0062, 1.0164, 1.0404, 1.0990, 1.2515, 1.7280,  &
1.0001, 1.0001, 1.0004, 1.0023, 1.0080, 1.0221, 1.0555, 1.1381, 1.3636,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0024, 1.0102, 1.0296, 1.0763, 1.1950,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0005, 1.0025, 1.0127, 1.0391, 1.1045,  &
0.9995, 0.9995, 0.9995, 0.9997, 1.0000, 1.0006, 1.0026, 1.0153, 1.0506,  &
0.9984, 0.9984, 0.9984, 0.9985, 0.9987, 0.9992, 1.0004, 1.0030, 1.0176,  &
0.9962, 0.9962, 0.9962, 0.9962, 0.9964, 0.9967, 0.9975, 0.9993, 1.0036 /
data ((supersat( 8,iw,iconc,6, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0016, 1.0050, 1.0134, 1.0335, 1.0818, 1.2046, 1.5570,  &
1.0000, 1.0001, 1.0004, 1.0017, 1.0064, 1.0179, 1.0454, 1.1125, 1.2884,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0018, 1.0080, 1.0237, 1.0615, 1.1557,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0004, 1.0018, 1.0097, 1.0309, 1.0830,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0004, 1.0019, 1.0114, 1.0394,  &
0.9986, 0.9986, 0.9987, 0.9987, 0.9989, 0.9993, 1.0002, 1.0021, 1.0129,  &
0.9966, 0.9966, 0.9966, 0.9966, 0.9967, 0.9970, 0.9976, 0.9991, 1.0023 /
data ((supersat( 8,iw,iconc,7, 4),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0013, 1.0042, 1.0114, 1.0285, 1.0697, 1.1731, 1.4566,  &
1.0000, 1.0001, 1.0003, 1.0014, 1.0053, 1.0150, 1.0383, 1.0949, 1.2401,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0014, 1.0064, 1.0196, 1.0514, 1.1298,  &
0.9999, 0.9999, 1.0000, 1.0001, 1.0003, 1.0014, 1.0077, 1.0253, 1.0685,  &
0.9996, 0.9996, 0.9996, 0.9997, 0.9999, 1.0003, 1.0015, 1.0088, 1.0319,  &
0.9987, 0.9987, 0.9988, 0.9988, 0.9990, 0.9993, 1.0000, 1.0016, 1.0096,  &
0.9968, 0.9968, 0.9968, 0.9968, 0.9969, 0.9971, 0.9977, 0.9989, 1.0015 /
data ((supersat( 8,iw,iconc,1, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0009, 1.0055, 1.0190, 1.0515, 1.1326, 1.3691, 2.5835, 4.7815,  &
1.0000, 1.0003, 1.0010, 1.0064, 1.0249, 1.0709, 1.1925, 1.6063, 3.6256,  &
0.9994, 0.9996, 1.0002, 1.0014, 1.0072, 1.0315, 1.0958, 1.2832, 2.1808,  &
0.9979, 0.9980, 0.9985, 0.9994, 1.0017, 1.0077, 1.0380, 1.1257, 1.4292,  &
0.9953, 0.9953, 0.9956, 0.9962, 0.9977, 1.0012, 1.0110, 1.0436, 1.1597,  &
0.9926, 0.9926, 0.9927, 0.9930, 0.9937, 0.9955, 1.0001, 1.0139, 1.0587,  &
0.9910, 0.9910, 0.9910, 0.9911, 0.9914, 0.9921, 0.9939, 0.9991, 1.0154 /
data ((supersat( 8,iw,iconc,2, 5),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0040, 1.0135, 1.0362, 1.0912, 1.2375, 1.7656, 3.5991,  &
1.0001, 1.0002, 1.0007, 1.0046, 1.0178, 1.0499, 1.1302, 1.3620, 2.4474,  &
0.9998, 0.9999, 1.0002, 1.0009, 1.0051, 1.0228, 1.0677, 1.1869, 1.5866,  &
0.9990, 0.9991, 0.9993, 0.9999, 1.0012, 1.0055, 1.0281, 1.0895, 1.2700,  &
0.9972, 0.9972, 0.9974, 0.9978, 0.9988, 1.0011, 1.0071, 1.0329, 1.1144,  &
0.9944, 0.9944, 0.9945, 0.9947, 0.9953, 0.9967, 1.0001, 1.0095, 1.0369,  &
0.9920, 0.9920, 0.9920, 0.9921, 0.9923, 0.9930, 0.9945, 0.9988, 1.0112 /
data ((supersat( 8,iw,iconc,3, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0005, 1.0029, 1.0098, 1.0264, 1.0659, 1.1660, 1.4660, 2.6820,  &
1.0001, 1.0002, 1.0006, 1.0033, 1.0129, 1.0362, 1.0927, 1.2425, 1.7651,  &
0.9999, 1.0000, 1.0002, 1.0006, 1.0036, 1.0165, 1.0489, 1.1305, 1.3648,  &
0.9995, 0.9995, 0.9997, 1.0000, 1.0008, 1.0038, 1.0205, 1.0647, 1.1834,  &
0.9983, 0.9984, 0.9985, 0.9987, 0.9994, 1.0008, 1.0045, 1.0242, 1.0827,  &
0.9960, 0.9960, 0.9961, 0.9963, 0.9967, 0.9977, 1.0001, 1.0062, 1.0273,  &
0.9932, 0.9932, 0.9933, 0.9933, 0.9935, 0.9941, 0.9953, 0.9986, 1.0074 /
data ((supersat( 8,iw,iconc,4, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0004, 1.0022, 1.0074, 1.0201, 1.0501, 1.1241, 1.3267, 2.0695,  &
1.0001, 1.0001, 1.0004, 1.0024, 1.0096, 1.0271, 1.0693, 1.1762, 1.4922,  &
1.0000, 1.0000, 1.0001, 1.0005, 1.0026, 1.0121, 1.0364, 1.0959, 1.2540,  &
0.9997, 0.9997, 0.9998, 1.0001, 1.0006, 1.0026, 1.0149, 1.0478, 1.1320,  &
0.9989, 0.9989, 0.9990, 0.9992, 0.9996, 1.0006, 1.0028, 1.0175, 1.0608,  &
0.9971, 0.9971, 0.9972, 0.9973, 0.9976, 0.9983, 1.0000, 1.0039, 1.0197,  &
0.9944, 0.9944, 0.9944, 0.9944, 0.9946, 0.9950, 0.9960, 0.9984, 1.0045 /
data ((supersat( 8,iw,iconc,5, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0017, 1.0058, 1.0159, 1.0399, 1.0982, 1.2504, 1.7261,  &
1.0000, 1.0001, 1.0003, 1.0018, 1.0074, 1.0212, 1.0544, 1.1366, 1.3611,  &
1.0000, 1.0000, 1.0001, 1.0004, 1.0019, 1.0091, 1.0281, 1.0741, 1.1916,  &
0.9998, 0.9998, 0.9999, 1.0001, 1.0004, 1.0019, 1.0110, 1.0365, 1.1002,  &
0.9992, 0.9992, 0.9993, 0.9994, 0.9997, 1.0004, 1.0020, 1.0127, 1.0459,  &
0.9977, 0.9977, 0.9978, 0.9979, 0.9981, 0.9986, 0.9998, 1.0025, 1.0141,  &
0.9952, 0.9952, 0.9952, 0.9952, 0.9953, 0.9956, 0.9964, 0.9982, 1.0025 /
data ((supersat( 8,iw,iconc,6, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0003, 1.0013, 1.0047, 1.0131, 1.0330, 1.0812, 1.2038, 1.5557,  &
1.0000, 1.0001, 1.0003, 1.0014, 1.0059, 1.0172, 1.0445, 1.1113, 1.2866,  &
1.0000, 1.0000, 1.0001, 1.0003, 1.0014, 1.0071, 1.0225, 1.0599, 1.1533,  &
0.9998, 0.9998, 0.9999, 1.0000, 1.0003, 1.0014, 1.0083, 1.0288, 1.0798,  &
0.9993, 0.9993, 0.9994, 0.9995, 0.9997, 1.0003, 1.0015, 1.0094, 1.0359,  &
0.9980, 0.9980, 0.9981, 0.9981, 0.9983, 0.9987, 0.9997, 1.0017, 1.0101,  &
0.9956, 0.9956, 0.9956, 0.9956, 0.9957, 0.9960, 0.9966, 0.9981, 1.0014 /
data ((supersat( 8,iw,iconc,7, 5),iw=1,9),iconc=1,7)/    &
1.0001, 1.0002, 1.0011, 1.0039, 1.0110, 1.0281, 1.0693, 1.1724, 1.4557,  &
1.0000, 1.0001, 1.0002, 1.0011, 1.0048, 1.0144, 1.0376, 1.0940, 1.2388,  &
1.0000, 1.0000, 1.0001, 1.0002, 1.0011, 1.0057, 1.0186, 1.0500, 1.1278,  &
0.9998, 0.9999, 0.9999, 1.0000, 1.0003, 1.0011, 1.0065, 1.0236, 1.0659,  &
0.9994, 0.9994, 0.9994, 0.9995, 0.9997, 1.0002, 1.0012, 1.0071, 1.0290,  &
0.9982, 0.9982, 0.9982, 0.9983, 0.9984, 0.9988, 0.9996, 1.0013, 1.0074,  &
0.9958, 0.9958, 0.9959, 0.9959, 0.9960, 0.9962, 0.9967, 0.9979, 1.0007 /
data ((supersat( 8,iw,iconc,1, 6),iw=1,9),iconc=1,7)/    &
1.0002, 1.0007, 1.0047, 1.0178, 1.0498, 1.1299, 1.3642, 2.5682, 4.7558,  &
0.9999, 1.0002, 1.0009, 1.0053, 1.0229, 1.0677, 1.1868, 1.5937, 3.5793,  &
0.9991, 0.9994,