/* (c) 2022 Open Source Geospatial Foundation - all rights reserved
 * This code is licensed under the GPL 2.0 license, available at the root
 * application directory.
 * Copyright © 2019 World Wide Web Consortium, (Massachusetts Institute of Technology, 
 * European Research Consortium for Informatics and Mathematics, Keio    
 * University, Beihang). All Rights Reserved. This work is distributed under the 
 * W3C® Software License [1] in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR 
 * A PARTICULAR PURPOSE.
 * [1] http://www.w3.org/Consortium/Legal/copyright-software
 * 
 */
!function(){"use strict";function t(t){return new o(t)}function e(t,e){return new i(t,e)}var o=L.GridLayer.extend({initialize:function(t){this.zoomBounds=this._getZoomBounds(t.tileContainer,t.maxZoomBound),L.extend(t,this.zoomBounds),L.setOptions(this,t),this._groups=this._groupTiles(this.options.tileContainer.getElementsByTagName("map-tile"))},onAdd:function(){this._bounds=this._getLayerBounds(this._groups,this._map.options.projection),this.layerBounds=this._bounds[Object.keys(this._bounds)[0]];for(var t of Object.keys(this._bounds))this.layerBounds.extend(this._bounds[t].min),this.layerBounds.extend(this._bounds[t].max);L.GridLayer.prototype.onAdd.call(this,this._map),this._handleMoveEnd()},getEvents:function(){let t=L.GridLayer.prototype.getEvents.call(this,this._map);return this._parentOnMoveEnd=t.moveend,t.moveend=this._handleMoveEnd,t.move=()=>{},t},_handleMoveEnd:function(t){var e=this._map.getZoom();let o=e;o=o>this.options.maxNativeZoom?this.options.maxNativeZoom:o,o=o<this.options.minNativeZoom?this.options.minNativeZoom:o,this.isVisible=e<=this.zoomBounds.maxZoom&&e>=this.zoomBounds.minZoom&&this._bounds[o]&&this._bounds[o].overlaps(M.pixelToPCRSBounds(this._map.getPixelBounds(),this._map.getZoom(),this._map.options.projection)),this.isVisible&&this._parentOnMoveEnd()},_isValidTile(t){return this._groups[this._tileCoordsToKey(t)]},createTile:function(t){let o=this._groups[this._tileCoordsToKey(t)]||[],i=document.createElement("map-tile"),n=this.getTileSize();i.setAttribute("col",t.x),i.setAttribute("row",t.y),i.setAttribute("zoom",t.z);for(let e=0;e<o.length;e++){let t=document.createElement("img");t.width=n.x,t.height=n.y,t.alt="",t.setAttribute("role","presentation"),t.src=o[e].src,i.appendChild(t)}return i},_getLayerBounds:function(t,e){let o={},i=M[e].options.crs.tile.bounds.max.x;for(var n in t){let t=n.split(":"),e={};e.x=+t[0]*i,e.y=+t[1]*i,e.z=+t[2],t[2]in o?(o[t[2]].extend(L.point(e.x,e.y)),o[t[2]].extend(L.point(e.x+i,e.y+i))):o[t[2]]=L.bounds(L.point(e.x,e.y),L.point(e.x+i,e.y+i))}for(var a in o){var s=+a;o[a]=M.pixelToPCRSBounds(o[a],s,e)}return o},_getZoomBounds:function(t,e){if(!t)return null;let o=M.metaContentToObject(t.getElementsByTagName("map-tiles")[0].getAttribute("zoom")),i={},n=t.getElementsByTagName("map-tile");i.nativeZoom=+o.value||0,i.maxNativeZoom=0,i.minNativeZoom=e;for(let e=0;e<n.length;e++){let t=+n[e].getAttribute("zoom");n[e].getAttribute("zoom")||(t=i.nativeZoom),i.minNativeZoom=Math.min(i.minNativeZoom,t),i.maxNativeZoom=Math.max(i.maxNativeZoom,t)}return i.minZoom=i.minNativeZoom-2<=0?0:i.minNativeZoom-2,i.maxZoom=e,o.min&&(i.minZoom=+o.min<i.minNativeZoom-2?i.minNativeZoom-2:+o.min),o.max&&(i.maxZoom=+o.max),i},_groupTiles:function(o){let i={};for(let e=0;e<o.length;e++){let t={};t.row=+o[e].getAttribute("row"),t.col=+o[e].getAttribute("col"),t.zoom=+o[e].getAttribute("zoom")||this.options.nativeZoom,t.src=o[e].getAttribute("src");var n=t.col+":"+t.row+":"+t.zoom;n in i?i[n].push(t):i[n]=[t]}return i}}),i=L.Control.Layers.extend({options:{autoZIndex:!1,sortLayers:!0,sortFunction:function(t,e){return t.options.zIndex<e.options.zIndex?-1:t.options.zIndex>e.options.zIndex?1:0}},initialize:function(t,e){for(var o in L.setOptions(this,e),this._layerControlInputs=[],this._layers=[],this._lastZIndex=0,this._handlingClick=!1,t)this._addLayer(t[o],o,!0)},onAdd:function(){return this._initLayout(),this._map.on("validate",this._validateInput,this),L.DomEvent.on(this.options.mapEl,"layerchange",this._validateInput,this),L.DomEvent.on(this._container,"keydown",this._focusFirstLayer,this._container),this._update(),this._layers.length<1&&!this._map._showControls?this._container.setAttribute("hidden",""):this._map._showControls=!0,this._container},onRemove:function(t){t.off("validate",this._validateInput,this),L.DomEvent.off(this._container,"keydown",this._focusFirstLayer,this._container);for(var e=0;e<this._layers.length;e++)this._layers[e].layer.off("add remove",this._onLayerChange,this),this._layers[e].layer.off("extentload",this._validateInput,this)},addOrUpdateOverlay:function(t,e){for(var o=!1,i=0;i<this._layers.length;i++)if(this._layers[i].layer===t){o=!0,this._layers[i].name=e;break}return o||this.addOverlay(t,e),0<this._layers.length&&(this._container.removeAttribute("hidden"),this._map._showControls=!0),this._map?this._update():this},removeLayer:function(t){L.Control.Layers.prototype.removeLayer.call(this,t),0===this._layers.length&&this._container.setAttribute("hidden","")},_validateInput:function(t){for(let i=0;i<this._layers.length;i++)if(this._layers[i].input.labels[0]){let t=this._layers[i].input.labels[0].getElementsByTagName("span"),e=this._layers[i].input.labels[0].getElementsByTagName("input");if(e[0].checked=this._layers[i].layer._layerEl.checked,this._layers[i].layer._layerEl.disabled&&this._layers[i].layer._layerEl.checked?(e[0].closest("fieldset").disabled=!0,t[0].style.fontStyle="italic"):(e[0].closest("fieldset").disabled=!1,t[0].style.fontStyle="normal"),this._layers[i].layer._extent&&this._layers[i].layer._extent._mapExtents)for(let o=0;o<this._layers[i].layer._extent._mapExtents.length;o++){let t=this._layers[i].layer._extent._mapExtents[o].extentAnatomy,e=t.getElementsByClassName("mapml-layer-item-name")[0];this._layers[i].layer._extent._mapExtents[o].disabled&&this._layers[i].layer._extent._mapExtents[o].checked?(e.style.fontStyle="italic",t.disabled=!0):(e.style.fontStyle="normal",t.disabled=!1)}}},_focusFirstLayer:function(t){var e;"Enter"!==t.key||"leaflet-control-layers leaflet-control leaflet-control-layers-expanded"==this.className||(e=this.children[1].children[2].children[0].children[0].children[0].children[0])&&setTimeout(()=>e.focus(),0)},_withinZoomBounds:function(t,e){return e.min<=t&&t<=e.max},_addItem:function(t){var e=t.layer.getLayerUserControlsHTML();return t.input=e.querySelector("input"),this._layerControlInputs.push(t.input),t.input.layerId=L.stamp(t.layer),L.DomEvent.on(t.input,"click",this._onInputClick,this),t.layer.on("extentload",this._validateInput,this),this._overlaysList.appendChild(e),e},collapse:function(t){return"SELECT"===t.target.tagName||t.relatedTarget&&t.relatedTarget.parentElement&&("mapml-contextmenu mapml-layer-menu"===t.relatedTarget.className||"mapml-contextmenu mapml-layer-menu"===t.relatedTarget.parentElement.className)||this._map&&"block"===this._map.contextMenu._layerMenu.style.display||L.DomUtil.removeClass(this._container,"leaflet-control-layers-expanded"),this}});const P="OSMTILE",d="TILEMATRIX",w="mapmltemplatedtileplaceholder";function n(t,e){return new h(t,e)}function a(t,e){return new _(t,e)}function s(t,e){return new y(t,e)}function r(t,e){return new g(t,e)}function l(t,e){return new f(t,e)}function m(t,e,o,i,n,a){return new x(t,e,o,i,n,a)}function p(t,e,o){return t||e?new b(t,e,o):null}function u(){return new v}function c(t){return new rt(t)}var h=L.FeatureGroup.extend({initialize:function(t,e){var o;L.setOptions(this,e),this.options.static&&(this._container=L.DomUtil.create("div","leaflet-layer",this.options.pane),L.DomUtil.addClass(this._container,"leaflet-pane mapml-vector-container"),L.setOptions(this.options.renderer,{pane:this._container})),this._layers={},this.options.query&&(this._mapmlFeatures=t.features||t,this.isVisible=!0,o=this._getNativeVariables(t),this.options.nativeZoom=o.zoom,this.options.nativeCS=o.cs),t&&!this.options.query&&(o=this._getNativeVariables(t),!t.querySelector("map-extent")&&t.querySelector("map-feature")&&this.options.static&&(this._features={},this._staticFeature=!0,this.isVisible=!0,this.zoomBounds=this._getZoomBounds(t,o.zoom),this.layerBounds=this._getLayerBounds(t),L.extend(this.options,this.zoomBounds)),this.addData(t,o.cs,o.zoom),this._staticFeature&&(this._resetFeatures(this._clampZoom(this.options._leafletLayer._map.getZoom())),this.options._leafletLayer._map._addZoomLimit(this)))},onAdd:function(t){L.FeatureGroup.prototype.onAdd.call(this,t),this._mapmlFeatures&&t.on("featurepagination",this.showPaginationFeature,this)},onRemove:function(t){this._mapmlFeatures&&(t.off("featurepagination",this.showPaginationFeature,this),delete this._mapmlFeatures,L.DomUtil.remove(this._container)),L.FeatureGroup.prototype.onRemove.call(this,t),this._map.featureIndex.cleanIndex()},getEvents:function(){return this._staticFeature?{moveend:this._handleMoveEnd,zoomend:this._handleZoomEnd}:{}},showPaginationFeature:function(e){if(this.options.query&&this._mapmlFeatures[e.i]){let t=this._mapmlFeatures[e.i];this.clearLayers(),this.addData(t,this.options.nativeCS,this.options.nativeZoom),e.popup._navigationBar.querySelector("p").innerText=e.i+1+"/"+this.options._leafletLayer._totalFeatureCount,e.popup._content.querySelector("iframe").setAttribute("sandbox","allow-same-origin allow-forms"),e.popup._content.querySelector("iframe").srcdoc=t.querySelector("map-properties").innerHTML}},_getNativeVariables:function(t){return{zoom:t.querySelector&&t.querySelector("map-meta[name=zoom]")&&+M.metaContentToObject(t.querySelector("map-meta[name=zoom]").getAttribute("content")).value||0,cs:t.querySelector&&t.querySelector("map-meta[name=cs]")&&M.metaContentToObject(t.querySelector("map-meta[name=cs]").getAttribute("content")).content||"PCRS"}},_handleMoveEnd:function(){var t=this._map.getZoom(),e=t<=this.zoomBounds.maxZoom&&t>=this.zoomBounds.minZoom;this.isVisible=e&&this._layers&&this.layerBounds&&this.layerBounds.overlaps(M.pixelToPCRSBounds(this._map.getPixelBounds(),t,this._map.options.projection)),this._removeCSS()},_handleZoomEnd:function(t){var e=this._map.getZoom();e>this.zoomBounds.maxZoom||e<this.zoomBounds.minZoom?this.clearLayers():(e=this._clampZoom(e),this._resetFeatures(e))},_getLayerBounds:function(t){if(!t)return null;let o=d,i=t.querySelector("map-meta[name=projection]")&&M.metaContentToObject(t.querySelector("map-meta[name=projection]").getAttribute("content")).content.toUpperCase()||P;try{var n=t.querySelector("map-meta[name=extent]")&&M.metaContentToObject(t.querySelector("map-meta[name=extent]").getAttribute("content")),a=n.zoom||0;let e=Object.keys(n);for(let t=0;t<e.length;t++)if(!e[t].includes("zoom")){o=M.axisToCS(e[t].split("-")[2]);break}var s=M.csToAxes(o);return M.boundsToPCRSBounds(L.bounds(L.point(+n["top-left-"+s[0]],+n["top-left-"+s[1]]),L.point(+n["bottom-right-"+s[0]],+n["bottom-right-"+s[1]])),a,i,o)}catch(t){return M.boundsToPCRSBounds(M[i].options.crs.tilematrix.bounds(0),0,i,o)}},_resetFeatures:function(e){if(this.clearLayers(),this._map&&this._map.featureIndex.cleanIndex(),this._features&&this._features[e])for(let t=0;t<this._features[e].length;t++)this.addLayer(this._features[e][t])},_clampZoom:function(t){return t>this.zoomBounds.maxZoom||t<this.zoomBounds.minZoom?t:void 0!==this.zoomBounds.minNativeZoom&&t<this.zoomBounds.minNativeZoom?this.zoomBounds.minNativeZoom:void 0!==this.zoomBounds.maxNativeZoom&&this.zoomBounds.maxNativeZoom<t?this.zoomBounds.maxNativeZoom:t},_setZoomTransform:function(t,e){var o=this._map.getZoomScale(this._map.getZoom(),e),t=t.multiplyBy(o).subtract(this._map._getNewPixelOrigin(t,this._map.getZoom())).round();any3d?L.setTransform(this._layers[e],t,o):L.setPosition(this._layers[e],t)},_getZoomBounds:function(t,o){if(!t)return null;let i=100,n=0,a=t.getElementsByTagName("map-feature"),e,s;for(let e=0;e<a.length;e++){let t=+a[e].getAttribute("zoom");a[e].getAttribute("zoom")||(t=o),n=Math.max(n,t),i=Math.min(i,t)}try{s=M.metaContentToObject(t.querySelector("map-meta[name=projection]").getAttribute("content")).content,e=M.metaContentToObject(t.querySelector("map-meta[name=zoom]").getAttribute("content"))}catch(t){return{minZoom:0,maxZoom:M[s||P].options.resolutions.length-1,minNativeZoom:i,maxNativeZoom:n}}return{minZoom:+e.min,maxZoom:+e.max,minNativeZoom:i,maxNativeZoom:n}},addData:function(i,n,a){var t,e,o,s=i.nodeType===Node.DOCUMENT_NODE||"LAYER-"===i.nodeName?i.getElementsByTagName("map-feature"):null;if((i.nodeType===Node.DOCUMENT_NODE?i.querySelector("map-link[rel=stylesheet],map-style"):null)&&(r=i.querySelector("map-base")&&i.querySelector("map-base").hasAttribute("href")?new URL(i.querySelector("map-base").getAttribute("href")).href:i.URL,M.parseStylesheetAsHTML(i,r,this._container)),s){for(t=0,e=s.length;t<e;t++)(o=s[t]).getElementsByTagName("map-geometry").length&&o.getElementsByTagName("map-coordinates").length&&this.addData(o,n,a);return this}var r=this.options;if(!r.filter||r.filter(i)){i.classList.length&&(r.className=i.classList.value);let t=i.getAttribute("zoom")||a,e=i.querySelector("map-featurecaption");e=e?e.innerHTML:"Feature",i.querySelector("map-properties")&&(r.properties=document.createElement("div"),r.properties.classList.add("mapml-popup-content"),r.properties.insertAdjacentHTML("afterbegin",i.querySelector("map-properties").innerHTML));let o=this.geometryToLayer(i,r,n,+t,e);if(o){if(!o.options.color&&i.hasAttribute("class")&&(o.options.className=i.getAttribute("class")),o.defaultOptions=o.options,this.resetStyle(o),r.onEachFeature&&o.bindTooltip(e,{interactive:!0,sticky:!0}),!this._staticFeature)return this.addLayer(o);i=i.getAttribute("zoom")||a;i in this._features?this._features[i].push(o):this._features[i]=[o]}}},resetStyle:function(t){var e=this.options.style;e&&(L.Util.extend(t.options,t.defaultOptions),this._setLayerStyle(t,e))},setStyle:function(e){this.eachLayer(function(t){this._setLayerStyle(t,e)},this)},_setLayerStyle:function(t,e){"function"==typeof e&&(e=e(t.feature)),t.setStyle&&t.setStyle(e)},_removeCSS:function(){var e=this._container.querySelectorAll("link[rel=stylesheet],style");for(let t=0;t<e.length;t++)this._container.removeChild(e[t])},geometryToLayer:function(o,i,t,n,a){let s="MAP-FEATURE"===o.tagName.toUpperCase()?o.getElementsByTagName("map-geometry")[0]:o,r=s?.getAttribute("cs")||t,l=[],m=L.SVG.create("g"),p=Object.assign({},i);if(s){for(var u of s.querySelectorAll("map-polygon, map-linestring, map-multilinestring, map-point, map-multipoint"))l.push(M.feature(u,Object.assign(p,{nativeCS:r,nativeZoom:n,projection:this.options.projection,featureID:o.id,group:m,wrappers:this._getGeometryParents(u.parentElement),featureLayer:this,_leafletLayer:this.options._leafletLayer})));let t={group:m,featureID:o.id,accessibleTitle:a,onEachFeature:i.onEachFeature,properties:i.properties,_leafletLayer:this.options._leafletLayer},e=s.querySelector("map-multipolygon")||s.querySelector("map-geometrycollection");return e&&(t.wrappers=this._getGeometryParents(e.parentElement)),M.featureGroup(l,t)}},_getGeometryParents:function(t,e=[]){return t&&"MAP-GEOMETRY"!==t.tagName.toUpperCase()?"MAP-MULTIPOLYGON"===t.tagName.toUpperCase()||"MAP-GEOMETRYCOLLECTION"===t.tagName.toUpperCase()?this._getGeometryParents(t.parentElement,e):this._getGeometryParents(t.parentElement,e.concat([t])):e}}),_=L.TileLayer.extend({initialize:function(t,e){var o=M.extractInputBounds(t);this.zoomBounds=o.zoomBounds,this.extentBounds=o.bounds,this.isVisible=!0,L.extend(e,this.zoomBounds),e.tms=t.tms,delete e.opacity,L.setOptions(this,e),this._setUpTileTemplateVars(t),t.tile.subdomains&&L.setOptions(this,L.extend(this.options,{subdomains:t.tile.subdomains})),this._template=t,this._initContainer(),L.TileLayer.prototype.initialize.call(this,t.template,L.extend(e,{pane:this._container}))},onAdd:function(){this._map._addZoomLimit(this),L.TileLayer.prototype.onAdd.call(this,this._map),this._handleMoveEnd()},getEvents:function(){let t=L.TileLayer.prototype.getEvents.call(this,this._map);return this._parentOnMoveEnd=t.moveend,t.moveend=this._handleMoveEnd,t},_initContainer:function(){this._container||(this._container=L.DomUtil.create("div","leaflet-layer",this.options.pane),L.DomUtil.addClass(this._container,"mapml-templated-tile-container"),this._updateZIndex())},_handleMoveEnd:function(t){var e=this._map.getZoom(),o=M.pixelToPCRSBounds(this._map.getPixelBounds(),e,this._map.options.projection);this.isVisible=e<=this.options.maxZoom&&e>=this.options.minZoom&&this.extentBounds.overlaps(o),this.isVisible&&this._parentOnMoveEnd()},createTile:function(e){let o=document.createElement("DIV"),i=this.getTileSize();if(L.DomUtil.addClass(o,"mapml-tile-group"),L.DomUtil.addClass(o,"leaflet-tile"),this._template.linkEl.dispatchEvent(new CustomEvent("tileloadstart",{detail:{x:e.x,y:e.y,zoom:e.z,appendTile:t=>{o.appendChild(t)}}})),this._template.type.startsWith("image/")){let t=L.TileLayer.prototype.createTile.call(this,e,function(){});t.width=i.x,t.height=i.y,o.appendChild(t)}else this._url.includes(w)||this._fetchTile(e,o);return o},_mapmlTileReady:function(t){L.DomUtil.addClass(t,"leaflet-tile-loaded")},getPane:function(){return this.options.pane},_fetchTile:function(e,o){fetch(this.getTileUrl(e),{redirect:"follow"}).then(function(t){return 200<=t.status&&t.status<300?Promise.resolve(t):(console.log("Looks like there was a problem. Status Code: "+t.status),Promise.reject(t))}).then(function(t){return t.text()}).then(t=>{return(new DOMParser).parseFromString(t,"application/xml")}).then(t=>{this._createFeatures(t,e,o),this._mapmlTileReady(o)}).catch(t=>{console.log("Error Creating Tile")})},_createFeatures:function(t,e,o){var i;t.querySelector("map-link[rel=stylesheet],map-style")&&(i=t.querySelector("map-base")&&t.querySelector("map-base").hasAttribute("href")?new URL(t.querySelector("map-base").getAttribute("href")).href:t.URL,M.parseStylesheetAsHTML(t,i,o));let n=L.SVG.create("svg"),a=L.SVG.create("g"),s=this._map.options.crs.options.crs.tile.bounds.max.x,r=e.x*s,l=e.y*s;var m,p=M.mapMlFeatures(t,{projection:this._map.options.projection,static:!1,interactive:!1});for(m in p._layers)for(var u in p._layers[m]._layers){let t=p._layers[m]._layers[u];M.FeatureRenderer.prototype._initPath(t,!1),t._project(this._map,L.point([r,l]),e.z),M.FeatureRenderer.prototype._addPath(t,a,!1),M.FeatureRenderer.prototype._updateFeature(t)}n.setAttribute("width",s.toString()),n.setAttribute("height",s.toString()),n.appendChild(a),o.appendChild(n)},getTileUrl:function(t){if(t.z>=this._template.tilematrix.bounds.length||!this._template.tilematrix.bounds[t.z].contains(t))return"";var e,o={};for(e in o[this._template.tilematrix.col.name]=t.x,o[this._template.tilematrix.row.name]=t.y,o[this._template.zoom.name]=this._getZoomForUrl(),o[this._template.pcrs.easting.left]=this._tileMatrixToPCRSPosition(t,"top-left").x,o[this._template.pcrs.easting.right]=this._tileMatrixToPCRSPosition(t,"top-right").x,o[this._template.pcrs.northing.top]=this._tileMatrixToPCRSPosition(t,"top-left").y,o[this._template.pcrs.northing.bottom]=this._tileMatrixToPCRSPosition(t,"bottom-left").y,o[this._template.tile.server]=this._getSubdomain(t),this._template.tile)["row","col","zoom","left","right","top","bottom"].indexOf(e)<0&&(o[e]=this._template.tile[e]);return this._map&&!this._map.options.crs.infinite&&(t=this._globalTileRange.max.y-t.y,this.options.tms&&(o[this._template.tilematrix.row.name]=t)),o.r=this.options.detectRetina&&L.Browser.retina&&0<this.options.maxZoom?"@2x":"",L.Util.template(this._url,o)},_tileMatrixToPCRSPosition:function(t,e){var o=this._map.options.crs,i=this.getTileSize(),n=t.scaleBy(i),a=n.add(i),i=n.add(Math.floor(i/2)),s=o.transformation.untransform(n,o.scale(t.z)),r=o.transformation.untransform(a,o.scale(t.z)),l=o.transformation.untransform(i,o.scale(t.z)),m=null;switch(e){case"top-left":m=s;break;case"bottom-left":m=new L.Point(s.x,r.y);break;case"center-left":m=new L.Point(s.x,l.y);break;case"top-right":m=new L.Point(r.x,s.y);break;case"bottom-right":m=r;break;case"center-right":m=new L.Point(r.x,l.y);break;case"top-center":m=new L.Point(l.x,s.y);break;case"bottom-center":m=new L.Point(l.x,r.y);break;case"center":m=l}return m},_setUpTileTemplateVars:function(t){t.tile={};for(var e,o,i,n,a,s=t.values,r=this.options.crs.options,l=0;l<t.values.length;l++){var m=s[l].getAttribute("type"),p=s[l].getAttribute("units"),u=s[l].getAttribute("axis"),c=s[l].getAttribute("name"),h=s[l].getAttribute("position"),d="hidden"===m&&s[l].hasAttribute("shard"),_="map-select"===s[l].tagName.toLowerCase(),y=s[l].getAttribute("value"),g=s[l].getAttribute("min"),f=s[l].getAttribute("max");if("location"===m&&"tilematrix"===p)switch(u){case"column":a={name:c,min:r.crs.tilematrix.horizontal.min,max:r.crs.tilematrix.horizontal.max(r.resolutions.length-1)},isNaN(Number.parseFloat(g))||(a.min=Number.parseFloat(g)),isNaN(Number.parseFloat(f))||(a.max=Number.parseFloat(f));break;case"row":n={name:c,min:r.crs.tilematrix.vertical.min,max:r.crs.tilematrix.vertical.max(r.resolutions.length-1)},isNaN(Number.parseFloat(g))||(n.min=Number.parseFloat(g)),isNaN(Number.parseFloat(f))||(n.max=Number.parseFloat(f));break;case"longitude":case"easting":o=o||{min:r.crs.pcrs.horizontal.min,max:r.crs.pcrs.horizontal.max},isNaN(Number.parseFloat(g))||(o.min=Number.parseFloat(g)),isNaN(Number.parseFloat(f))||(o.max=Number.parseFloat(f)),h&&(h.match(/.*?-left/i)?o.left=c:h.match(/.*?-right/i)&&(o.right=c));break;case"latitude":case"northing":i=i||{min:r.crs.pcrs.vertical.min,max:r.crs.pcrs.vertical.max},isNaN(Number.parseFloat(g))||(i.min=Number.parseFloat(g)),isNaN(Number.parseFloat(f))||(i.max=Number.parseFloat(f)),h&&(h.match(/top-.*?/i)?i.top=c:h.match(/bottom-.*?/i)&&(i.bottom=c))}else if(m&&"zoom"===m.toLowerCase())e={name:c,min:0,max:r.resolutions.length,value:r.resolutions.length},!isNaN(Number.parseInt(y,10))&&Number.parseInt(y,10)>=e.min&&Number.parseInt(y,10)<=e.max?e.value=Number.parseInt(y,10):e.value=e.max,!isNaN(Number.parseInt(g,10))&&Number.parseInt(g,10)>=e.min&&Number.parseInt(g,10)<=e.max&&(e.min=Number.parseInt(g,10)),!isNaN(Number.parseInt(f,10))&&Number.parseInt(f,10)>=e.min&&Number.parseInt(f,10)<=e.max&&(e.max=Number.parseInt(f,10)),t.zoom=e;else if(d)t.tile.server=c,t.tile.subdomains=s[l].servers.slice();else if(_){const k=s[l].htmlselect;t.tile[c]=function(){return k.value}}else{const I=s[l];t.tile[c]=function(){return I.getAttribute("value")}}}function x(t,e){return b.transform(t,E(e)).divideBy(v).floor()}var b=this.options.crs.transformation,v=this.options.crs.options.crs.tile.bounds.max.x,E=L.bind(this.options.crs.scale,this.options.crs);o&&i?(t.pcrs={},t.pcrs.bounds=L.bounds([o.min,i.min],[o.max,i.max]),t.pcrs.easting=o,t.pcrs.northing=i):a&&n&&!isNaN(e.value)?(t.pcrs||(t.pcrs={},t.pcrs.easting="",t.pcrs.northing=""),t.pcrs.bounds=M.boundsToPCRSBounds(L.bounds(L.point([a.min,n.min]),L.point([a.max,n.max])),e.value,this.options.crs,M.axisToCS("column")),t.tilematrix={},t.tilematrix.col=a,t.tilematrix.row=n):console.log("Unable to determine bounds for tile template: "+t.template),t.tilematrix||(t.tilematrix={},t.tilematrix.col={},t.tilematrix.row={}),t.tilematrix.bounds=[];for(var A=t.pcrs.bounds,C=t.zoom?t.zoom.min:0,T=t.zoom?t.zoom.max:r.resolutions.length,S=0;S<=T;S++)t.tilematrix.bounds[S]=C<=S?L.bounds(x(A.min,S),x(A.max,S)):L.bounds(L.point([-1,-1]),L.point([-1,-1]))},_clampZoom:function(t){var e=L.GridLayer.prototype._clampZoom.call(this,t);return this._template.step>this.zoomBounds.maxNativeZoom&&(this._template.step=this.zoomBounds.maxNativeZoom),t!==e?t=e:t%this._template.step!=0&&(t=Math.floor(t/this._template.step)*this._template.step),t}}),y=L.Layer.extend({initialize:function(t,e){this._templates=t,L.setOptions(this,e),this._container=L.DomUtil.create("div","leaflet-layer",e.pane),this._container.style.opacity=this.options.opacity,L.DomUtil.addClass(this._container,"mapml-templatedlayer-container");for(var o,i=0;i<t.length;i++)"tile"===t[i].rel?(this.setZIndex(e.extentZIndex),this._templates[i].layer=M.templatedTileLayer(t[i],L.Util.extend(e,{errorTileUrl:"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",zIndex:e.extentZIndex,pane:this._container}))):"image"===t[i].rel?(this.setZIndex(e.extentZIndex),this._templates[i].layer=M.templatedImageLayer(t[i],L.Util.extend(e,{zIndex:e.extentZIndex,pane:this._container}))):"features"===t[i].rel?(this.setZIndex(e.extentZIndex),this._templates[i].layer=M.templatedFeaturesLayer(t[i],L.Util.extend(e,{zIndex:e.extentZIndex,pane:this._container}))):"query"===t[i].rel&&(this.hasSetBoundsHandler=!0,this._queries||(this._queries=[]),o=M.extractInputBounds(t[i]),t[i].extentBounds=o.bounds,t[i].zoomBounds=o.zoomBounds,this._queries.push(L.extend(t[i],this._setupQueryVars(t[i]))))},getEvents:function(){return{zoomstart:this._onZoomStart}},redraw:function(){this.closePopup();for(var t=0;t<this._templates.length;t++)"tile"!==this._templates[t].rel&&"image"!==this._templates[t].rel&&"features"!==this._templates[t].rel||this._templates[t].layer.redraw()},_onZoomStart:function(){this.closePopup()},_setupQueryVars:function(t){for(var e={query:{}},o=t.values,i=0;i<t.values.length;i++){var n=o[i].getAttribute("type"),a=o[i].getAttribute("units"),s=o[i].getAttribute("axis"),r=o[i].getAttribute("name"),l=o[i].getAttribute("position"),m=o[i].getAttribute("rel"),p="map-select"===o[i].tagName.toLowerCase();if("width"===n)e.query.width=r;else if("height"===n)e.query.height=r;else if("location"===n)switch(s){case"x":case"y":case"column":case"row":e.query[s]=r;break;case"longitude":case"easting":l?l.match(/.*?-left/i)?"pixel"===m?e.query.pixelleft=r:"tile"===m?e.query.tileleft=r:e.query.mapleft=r:l.match(/.*?-right/i)&&("pixel"===m?e.query.pixelright=r:"tile"===m?e.query.tileright=r:e.query.mapright=r):e.query[s]=r;break;case"latitude":case"northing":l?l.match(/top-.*?/i)?"pixel"===m?e.query.pixeltop=r:"tile"===m?e.query.tiletop=r:e.query.maptop=r:l.match(/bottom-.*?/i)&&("pixel"===m?e.query.pixelbottom=r:"tile"===m?e.query.tilebottom=r:e.query.mapbottom=r):e.query[s]=r;break;case"i":"tile"===a?e.query.tilei=r:e.query.mapi=r;break;case"j":"tile"===a?e.query.tilej=r:e.query.mapj=r}else if("zoom"===n)e.query.zoom=r;else if(p){const u=o[i].htmlselect;e.query[r]=function(){return u.value}}else{const c=o[i];e.query[r]=function(){return c.getAttribute("value")}}}return e.query.title=t.title,e},reset:function(t,e){if(t&&this._map){var o=this._map&&this._map.hasLayer(this),i=this._templates;delete this._queries,this._map.off("click",null,this),this._templates=t;for(var n=0;n<t.length;n++)"tile"===t[n].rel?this._templates[n].layer=M.templatedTileLayer(t[n],L.Util.extend(this.options,{errorTileUrl:"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",zIndex:e,pane:this._container})):"image"===t[n].rel?this._templates[n].layer=M.templatedImageLayer(t[n],L.Util.extend(this.options,{zIndex:e,pane:this._container})):"features"===t[n].rel?this._templates[n].layer=M.templatedFeaturesLayer(t[n],L.Util.extend(this.options,{zIndex:e,pane:this._container})):"query"===t[n].rel&&(this._queries||(this._queries=[]),this._queries.push(L.extend(t[n],this._setupQueryVars(t[n])))),o&&this.onAdd(this._map);for(n=0;n<i.length;n++)this._map.hasLayer(i[n].layer)&&this._map.removeLayer(i[n].layer)}},onAdd:function(t){for(var e=0;e<this._templates.length;e++)"query"!==this._templates[e].rel&&t.addLayer(this._templates[e].layer)},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},_updateZIndex:function(){this._container&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},onRemove:function(t){L.DomUtil.remove(this._container);for(var e=0;e<this._templates.length;e++)"query"!==this._templates[e].rel&&t.removeLayer(this._templates[e].layer)},_previousFeature:function(t){0<=this._count+-1&&(this._count--,this._map.fire("featurepagination",{i:this._count,popup:this}))},_nextFeature:function(t){this._count+1<this._source._totalFeatureCount&&(this._count++,this._map.fire("featurepagination",{i:this._count,popup:this}))},changeOpacity:function(t){this._container.style.opacity=t}}),g=L.Layer.extend({initialize:function(t,e){var o=M.extractInputBounds(t);this.zoomBounds=o.zoomBounds,this.extentBounds=o.bounds,this.isVisible=!0,this._template=t,this._container=L.DomUtil.create("div","leaflet-layer",e.pane),L.extend(e,this.zoomBounds),L.DomUtil.addClass(this._container,"mapml-features-container"),delete e.opacity,L.setOptions(this,L.extend(e,this._setUpFeaturesTemplateVars(t)))},getEvents:function(){return{moveend:this._onMoveEnd}},onAdd:function(){this._map._addZoomLimit(this);var t=this.options.opacity||1,e=this._container,o=this._map;this._features||(this._features=M.mapMlFeatures(null,{renderer:M.featureRenderer(),pane:e,opacity:t,projection:o.options.projection,static:!0,onEachFeature:function(t,e){var o=document.createElement("div");o.classList.add("mapml-popup-content"),o.insertAdjacentHTML("afterbegin",t.innerHTML),e.bindPopup(o,{autoClose:!1,minWidth:108})}})),o.fire("moveend")},redraw:function(){this._onMoveEnd()},_removeCSS:function(){var o=this._container.querySelectorAll("link[rel=stylesheet],style");for(let e=0;e<o.length;e++){let t=o[e].parentNode;t.removeChild(o[e])}},_onMoveEnd:function(){var t=this._map.options.mapEl._history,e=t[t.length-1],o=t[t.length-2]??e,i=this._template.step,t=this._map.getZoom();let n=t;if("1"!==i&&(t+1)%i==0&&e.zoom===o.zoom-1||e.zoom===o.zoom||Math.floor(t/i)*i!=Math.floor(o.zoom/i)*i)n=Math.floor(t/i)*i;else if(t%this._template.step!=0)return;var a,s,r,l,m,p,u,o=this._map.getPixelBounds(this._map.getCenter(),n),i=this._getfeaturesUrl(n,o);i!==this._url&&(o=M.pixelToPCRSBounds(this._map.getPixelBounds(),t,this._map.options.projection),this.isVisible=t<=this.zoomBounds.maxZoom&&t>=this.zoomBounds.minZoom&&this.extentBounds.overlaps(o),this._features.clearLayers(),this._removeCSS(),this.isVisible||n!==t?(s=new Headers({Accept:"text/mapml;q=0.9,application/geo+json;q=0.8"}),r=new DOMParser,l=this._features,m=this._map,u=function(o,i){return fetch(o,{redirect:"follow",headers:s}).then(function(t){return t.text()}).then(function(t){a=r.parseFromString(t,"application/xml");var e=new URL(a.querySelector("map-base")?a.querySelector("map-base").getAttribute("href"):o).href;o=(o=a.querySelector("map-link[rel=next]")?a.querySelector("map-link[rel=next]").getAttribute("href"):null)?new URL(o,e).href:null;t=a.querySelector("map-meta[name=zoom]")&&+M.metaContentToObject(a.querySelector("map-meta[name=zoom]").getAttribute("content")).value||0,e=a.querySelector("map-meta[name=cs]")&&M.metaContentToObject(a.querySelector("map-meta[name=cs]").getAttribute("content")).content||"GCRS";if(l.addData(a,e,t),o&&--i)return u(o,i)})},(p=this)._url=i,u(i,10).then(function(){m.addLayer(l),m.fire("templatedfeatureslayeradd"),M.TemplatedFeaturesLayer.prototype._updateTabIndex(p)}).catch(function(t){console.log(t)})):this._url="")},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},_updateTabIndex:function(t){var o,i=t||this;for(o in i._features._layers){let e=i._features._layers[o];if(e._path&&("M0 0"!==e._path.getAttribute("d")?e._path.setAttribute("tabindex",0):e._path.removeAttribute("tabindex"),0===e._path.childElementCount)){let t=document.createElement("title");t.innerText="Feature",e._path.appendChild(t)}}},_updateZIndex:function(){this._container&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},onRemove:function(){this._map.removeLayer(this._features)},_getfeaturesUrl:function(t,e){void 0===t&&(t=this._map.getZoom()),void 0===e&&(e=this._map.getPixelBounds());var o,i={};for(o in this.options.feature.zoom&&(i[this.options.feature.zoom]=t),this.options.feature.width&&(i[this.options.feature.width]=this._map.getSize().x),this.options.feature.height&&(i[this.options.feature.height]=this._map.getSize().y),this.options.feature.bottom&&(i[this.options.feature.bottom]=this._TCRSToPCRS(e.max,t).y),this.options.feature.left&&(i[this.options.feature.left]=this._TCRSToPCRS(e.min,t).x),this.options.feature.top&&(i[this.options.feature.top]=this._TCRSToPCRS(e.min,t).y),this.options.feature.right&&(i[this.options.feature.right]=this._TCRSToPCRS(e.max,t).x),this.options.feature)["width","height","left","right","top","bottom","zoom"].indexOf(o)<0&&(i[o]=this.options.feature[o]);return L.Util.template(this._template.template,i)},_TCRSToPCRS:function(t,e){var o=this._map.options.crs;return o.transformation.untransform(t,o.scale(e))},_setUpFeaturesTemplateVars:function(t){var e={feature:{}},o=t.values;e.feature.hidden=[];for(var i=0;i<o.length;i++){var n=o[i].getAttribute("type"),a=o[i].getAttribute("units"),s=o[i].getAttribute("axis"),r=o[i].getAttribute("name"),l=o[i].getAttribute("position"),m=(o[i].getAttribute("value"),"map-select"===o[i].tagName.toLowerCase());if("width"===n)e.feature.width=r;else if("height"===n)e.feature.height=r;else if("zoom"===n)e.feature.zoom=r;else if("location"!==n||"pcrs"!==a&&"gcrs"!==a)if(m){const p=o[i].htmlselect;e.feature[r]=function(){return p.value}}else{const u=o[i];e.feature[r]=function(){return u.getAttribute("value")}}else switch(s){case"x":case"longitude":case"easting":l&&(l.match(/.*?-left/i)?e.feature.left=r:l.match(/.*?-right/i)&&(e.feature.right=r));break;case"y":case"latitude":case"northing":l&&(l.match(/top-.*?/i)?e.feature.top=r:l.match(/bottom-.*?/i)&&(e.feature.bottom=r))}}return e}}),f=L.Layer.extend({initialize:function(t,e){this._template=t,this._container=L.DomUtil.create("div","leaflet-layer",e.pane),L.DomUtil.addClass(this._container,"mapml-image-container");var o=M.extractInputBounds(t);this.zoomBounds=o.zoomBounds,this.extentBounds=o.bounds,this.isVisible=!0,delete e.opacity,L.extend(e,this.zoomBounds),L.setOptions(this,L.extend(e,this._setUpExtentTemplateVars(t)))},getEvents:function(){return{moveend:this._onMoveEnd}},onAdd:function(){this._map._addZoomLimit(this),this.setZIndex(this.options.zIndex),this._onAdd()},redraw:function(){this._onMoveEnd()},_clearLayer:function(){var e=this._container.querySelectorAll("img");for(let t=0;t<e.length;t++)this._container.removeChild(e[t])},_addImage:function(t,e,o){let i=this._map,n=this._imageOverlay;t=this.getImageUrl(t,e),e=i.getSize();this._imageOverlay=M.imageOverlay(t,o,e,0,this._container),this._imageOverlay._step=this._template.step,this._imageOverlay.addTo(i),n&&(this._imageOverlay._overlayToRemove=n._url,this._imageOverlay.on("load error",function(){i.removeLayer(n)}))},_scaleImage:function(o,i){let n=this;setTimeout(function(){var t=n._template.step,e=Math.floor(i/t)*t,t=n._map.getZoomScale(i,e),e=o.min.multiplyBy(t).subtract(n._map._getNewPixelOrigin(n._map.getCenter(),i)).round();L.DomUtil.setTransform(n._imageOverlay._image,e,t)})},_onAdd:function(){var t=this._map.getZoom();let e=t;var o=this._template.step;t%o!=0&&(e=Math.floor(t/o)*o);o=this._map.getPixelBounds(this._map.getCenter(),e);this._addImage(o,e,L.point(0,0)),this._pixelOrigins={},this._pixelOrigins[e]=o.min,t!==e&&this._scaleImage(o,t)},_onMoveEnd:function(t){var e=this._map.getZoom(),o=this._map.options.mapEl._history,i=o[o.length-1];let n=o[o.length-2];n=n||i;var a,s=this._template.step,o=Math.floor(e/s)*s;let r=this._map.getPixelBounds(this._map.getCenter(),o);"1"!==s&&(e+1)%s==0&&i.zoom===n.zoom-1?(this._addImage(r,o,L.point(0,0)),this._scaleImage(r,e)):t&&e%s!=0?(this._imageOverlay._overlayToRemove=this._imageOverlay._url,i.zoom!==n.zoom?(o!=Math.floor(n.zoom/s)*s&&(this._addImage(r,o,L.point(0,0)),this._pixelOrigins[o]=r.min),this._scaleImage(r,e)):(a=this._pixelOrigins[o],a=r.min.subtract(a),this.getImageUrl(r,o)!==this._imageOverlay._url&&(this._addImage(r,o,a),this._scaleImage(r,e)))):(o=M.pixelToPCRSBounds(this._map.getPixelBounds(),e,this._map.options.projection),this.isVisible=e<=this.zoomBounds.maxZoom&&e>=this.zoomBounds.minZoom&&this.extentBounds.overlaps(o),this.isVisible?(o=(a=this._map).getPixelBounds().min.subtract(a.getPixelOrigin()),this._addImage(a.getPixelBounds(),e,o),this._pixelOrigins[e]=a.getPixelOrigin()):this._clearLayer())},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},_updateZIndex:function(){this._container&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},onRemove:function(t){this._clearLayer(),t._removeZoomLimit(this),this._container=null},getImageUrl:function(t,e){var o,i={};for(o in i[this.options.extent.width]=this._map.getSize().x,i[this.options.extent.height]=this._map.getSize().y,i[this.options.extent.bottom]=this._TCRSToPCRS(t.max,e).y,i[this.options.extent.left]=this._TCRSToPCRS(t.min,e).x,i[this.options.extent.top]=this._TCRSToPCRS(t.min,e).y,i[this.options.extent.right]=this._TCRSToPCRS(t.max,e).x,this.options.extent)["width","height","left","right","top","bottom"].indexOf(o)<0&&(i[o]=this.options.extent[o]);return L.Util.template(this._template.template,i)},_TCRSToPCRS:function(t,e){var o=this._map.options.crs;return o.transformation.untransform(t,o.scale(e))},_setUpExtentTemplateVars:function(t){for(var e={extent:{}},o=t.values,i=0;i<t.values.length;i++){var n=o[i].getAttribute("type"),a=o[i].getAttribute("units"),s=o[i].getAttribute("axis"),r=o[i].getAttribute("name"),l=o[i].getAttribute("position"),m="map-select"===o[i].tagName.toLowerCase();if("width"===n)e.extent.width=r;else if("height"===n)e.extent.height=r;else if("location"!==n||"pcrs"!==a&&"gcrs"!==a)if(m){const p=o[i].htmlselect;e.extent[r]=function(){return p.value}}else{const u=o[i];e.extent[r]=function(){return u.getAttribute("value")}}else switch(s){case"longitude":case"easting":l&&(l.match(/.*?-left/i)?e.extent.left=r:l.match(/.*?-right/i)&&(e.extent.right=r));break;case"latitude":case"northing":l&&(l.match(/top-.*?/i)?e.extent.top=r:l.match(/bottom-.*?/i)&&(e.extent.bottom=r))}}return e}}),x=L.ImageOverlay.extend({initialize:function(t,e,o,i,n,a){this._container=n,this._url=t,this._location=e,this._size=L.point(o),this._angle=i,L.setOptions(this,a)},getEvents:function(){var t={viewreset:this._reset};return this._zoomAnimated&&this._step<=1&&(t.zoomanim=this._animateZoom),t},onAdd:function(){this.on({load:this._onImageLoad}),this._image||this._initImage(),this.options.interactive&&(L.DomUtil.addClass(this._image,"leaflet-interactive"),this.addInteractiveTarget(this._image)),this._container.appendChild(this._image),this._reset()},onRemove:function(){L.DomUtil.remove(this._image),this.options.interactive&&this.removeInteractiveTarget(this._image)},_onImageLoad:function(){this._image&&(this._image.loaded=+new Date,this._updateOpacity())},_animateZoom:function(t){var e=this._map.getZoomScale(t.zoom),t=this._map.getPixelOrigin().add(this._location).multiplyBy(e).subtract(this._map._getNewPixelOrigin(t.center,t.zoom)).round();L.Browser.any3d?L.DomUtil.setTransform(this._image,t,e):L.DomUtil.setPosition(this._image,t)},_reset:function(t){var e=this._image,o=this._location,i=this._size;t&&1<this._step&&(void 0===this._overlayToRemove||this._url===this._overlayToRemove)||(L.DomUtil.setPosition(e,o),e.style.width=i.x+"px",e.style.height=i.y+"px")},_updateOpacity:function(){var t,e,o;this._map&&(o=+new Date,t=!1,e=this._image,o=Math.min(1,(o-e.loaded)/200),L.DomUtil.setOpacity(e,o),(t=o<1?!0:t)&&(L.Util.cancelAnimFrame(this._fadeFrame),this._fadeFrame=L.Util.requestAnimFrame(this._updateOpacity,this)),L.DomUtil.addClass(e,"leaflet-image-loaded"))}}),b=L.Layer.extend({options:{maxNext:10,zIndex:0,maxZoom:25},initialize:function(t,e,o){var i;t&&(this._href=t),e&&(i=!!(this._layerEl=e).querySelector("map-feature,map-tile,map-extent"),!t&&i&&(this._content=e)),L.setOptions(this,o),this._container=L.DomUtil.create("div","leaflet-layer"),L.DomUtil.addClass(this._container,"mapml-layer"),this._imageContainer=L.DomUtil.create("div","leaflet-layer",this._container),L.DomUtil.addClass(this._imageContainer,"mapml-image-container"),this._mapmlTileContainer=L.DomUtil.create("div","mapml-tile-container",this._container),!i&&e&&e.hasAttribute("label")&&(this._title=e.getAttribute("label")),this._initialize(i?e:null),this.on("attached",this._validateExtent,this),this.validProjection=!0,this._mapmlLayerItem={}},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},_updateZIndex:function(){this._container&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},_removeExtents:function(e){if(this._extent._mapExtents)for(let t=0;t<this._extent._mapExtents.length;t++)this._extent._mapExtents[t].templatedLayer&&e.removeLayer(this._extent._mapExtents[t].templatedLayer);this._extent._queries&&delete this._extent._queries},_changeOpacity:function(t){t&&t.target&&0<=t.target.value&&t.target.value<=1&&this.changeOpacity(t.target.value)},changeOpacity:function(t){this._container.style.opacity=t,this.opacityEl&&(this.opacityEl.value=t)},_changeExtentOpacity:function(t){t&&t.target&&0<=t.target.value&&t.target.value<=1&&(this.templatedLayer.changeOpacity(t.target.value),this._templateVars.opacity=t.target.value)},_changeExtent:function(t,e){t.target.checked?(e.checked=!0,this._layerEl.checked&&(e.templatedLayer=M.templatedLayer(e._templateVars,{pane:this._container,opacity:e._templateVars.opacity,_leafletLayer:this,crs:e.crs,extentZIndex:e.extentZIndex}).addTo(this._map),e.templatedLayer.setZIndex(),this._setLayerElExtent())):(L.DomEvent.stopPropagation(t),e.checked=!1,this._layerEl.checked&&this._map.removeLayer(e.templatedLayer),this._setLayerElExtent())},onAdd:function(e){if(!this._extent&&!this._extent_mapExtents||this._validProjection(e)){this._map=e,this._content?(this._mapmlvectors||(this._mapmlvectors=M.mapMlFeatures(this._content,{renderer:M.featureRenderer(),pane:this._container,opacity:this.options.opacity,projection:e.options.projection,_leafletLayer:this,static:!0,onEachFeature:function(t,e){var o;t&&((o=document.createElement("div")).classList.add("mapml-popup-content"),o.insertAdjacentHTML("afterbegin",t.innerHTML),e.bindPopup(o,{autoClose:!1,minWidth:165}))}})),this._setLayerElExtent(),e.addLayer(this._mapmlvectors)):this.once("extentload",function(){this._validProjection(e)?(this._mapmlvectors||(this._mapmlvectors=M.mapMlFeatures(this._content,{renderer:M.featureRenderer(),pane:this._container,opacity:this.options.opacity,projection:e.options.projection,_leafletLayer:this,static:!0,onEachFeature:function(t,e){var o;t&&((o=document.createElement("div")).classList.add("mapml-popup-content"),o.insertAdjacentHTML("afterbegin",t.innerHTML),e.bindPopup(o,{autoClose:!1,minWidth:165}))}}).addTo(e)),this._setLayerElExtent()):this.validProjection=!1},this),this._imageLayer||(this._imageLayer=L.layerGroup()),e.addLayer(this._imageLayer),(!this._staticTileLayer||null===this._staticTileLayer._container)&&0<this._mapmlTileContainer.getElementsByTagName("map-tiles").length&&(this._staticTileLayer=M.mapMLStaticTileLayer({pane:this._container,_leafletLayer:this,className:"mapml-static-tile-layer",tileContainer:this._mapmlTileContainer,maxZoomBound:e.options.crs.options.resolutions.length-1,tileSize:e.options.crs.options.crs.tile.bounds.max.x}),e.addLayer(this._staticTileLayer),this._setLayerElExtent());const t=function(){if(this._extent&&this._extent._mapExtents){for(let t=0;t<this._extent._mapExtents.length;t++)this._extent._mapExtents[t]._templateVars&&this._extent._mapExtents[t].checked&&(this._extent._mapExtents[t].extentZIndex||(this._extent._mapExtents[t].extentZIndex=t),this._templatedLayer=M.templatedLayer(this._extent._mapExtents[t]._templateVars,{pane:this._container,opacity:this._extent._mapExtents[t]._templateVars.opacity,_leafletLayer:this,crs:this._extent.crs,extentZIndex:this._extent._mapExtents[t].extentZIndex}).addTo(e),this._extent._mapExtents[t].templatedLayer=this._templatedLayer,this._templatedLayer._queries&&(this._extent._queries||(this._extent._queries=[]),this._extent._queries=this._extent._queries.concat(this._templatedLayer._queries)));this._setLayerElExtent()}}.bind(this);this._extent&&this._extent._mapExtents&&this._extent._mapExtents[0]._templateVars?t():this.once("extentload",function(){this._validProjection(e)?t():this.validProjection=!1},this),this.setZIndex(this.options.zIndex),this.getPane().appendChild(this._container),setTimeout(()=>{e.fire("checkdisabled")},0),e.on("popupopen",this._attachSkipButtons,this)}else this.validProjection=!1},_validProjection:function(e){let o=!1;if(this._extent&&this._extent._mapExtents)for(let t=0;t<this._extent._mapExtents.length;t++)if(this._extent._mapExtents[t]._templateVars)for(var i of this._extent._mapExtents[t]._templateVars)if(!i.projectionMatch&&i.projection!==e.options.projection){o=!0;break}return!(o||this.getProjection()!==e.options.projection.toUpperCase())},_setLayerElExtent:function(){let i,n,a,s,r,e={minZoom:0,maxZoom:0,maxNativeZoom:0,minNativeZoom:0};["_staticTileLayer","_imageLayer","_mapmlvectors","_templatedLayer"].forEach(t=>{if(this[t])if("_templatedLayer"===t){for(let e=0;e<this._extent._mapExtents.length;e++)for(let t=0;t<this._extent._mapExtents[e]._templateVars.length;t++){var o=M.extractInputBounds(this._extent._mapExtents[e]._templateVars[t]);this._extent._mapExtents[e]._templateVars[t].tempExtentBounds=o.bounds,this._extent._mapExtents[e]._templateVars[t].extentZoomBounds=o.zoomBounds}for(let e=0;e<this._extent._mapExtents.length;e++)if(this._extent._mapExtents[e].checked)for(let t=0;t<this._extent._mapExtents[e]._templateVars.length;t++)r=i?(i.extend(this._extent._mapExtents[e]._templateVars[t].tempExtentBounds.min),i.extend(this._extent._mapExtents[e]._templateVars[t].tempExtentBounds.max),n=Math.max(n,this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.maxZoom),a=Math.min(a,this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.minZoom),s=Math.max(s,this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.maxNativeZoom),Math.min(r,this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.minNativeZoom)):(i=this._extent._mapExtents[e]._templateVars[t].tempExtentBounds,n=this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.maxZoom,a=this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.minZoom,s=this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.maxNativeZoom,this._extent._mapExtents[e]._templateVars[t].extentZoomBounds.minNativeZoom);e.minZoom=a,e.maxZoom=n,e.minNativeZoom=r,e.maxNativeZoom=s,this._extent.zoomBounds=e,this._extent.layerBounds=i;for(let t=0;t<this._extent._mapExtents.length;t++)this._extent._mapExtents[t].templatedLayer.layerBounds=i,this._extent._mapExtents[t].templatedLayer.zoomBounds=e}else this[t].layerBounds&&(i?(i.extend(this[t].layerBounds.min),i.extend(this[t].layerBounds.max)):(i=this[t].layerBounds,e=this[t].zoomBounds))}),i&&(this._layerEl.extent=Object.assign(M.convertAndFormatPCRS(i,this._map),{zoom:e}))},addTo:function(t){return t.addLayer(this),this},getEvents:function(){return{zoomanim:this._onZoomAnim}},redraw:function(){if(this._extent._mapExtents)for(let t=0;t<this._extent._mapExtents.length;t++)this._extent._mapExtents[t].templatedLayer&&this._extent._mapExtents[t].templatedLayer.redraw()},_onZoomAnim:function(t){var t=t.zoom,e=this._extent&&this._extent._mapExtents?this._extent._mapExtents[0].querySelector("map-input[type=zoom]"):null,o=e&&e.hasAttribute("min")?parseInt(e.getAttribute("min")):this._map.getMinZoom(),i=e&&e.hasAttribute("max")?parseInt(e.getAttribute("max")):this._map.getMaxZoom();if(e)for(let t=1;t<this._extent._mapExtents.length;t++)(e=this._extent._mapExtents[t].querySelector("map-input[type=zoom]"))&&e.hasAttribute("min")&&(o=Math.min(parseInt(e.getAttribute("min")),o)),e&&e.hasAttribute("max")&&(i=Math.max(parseInt(e.getAttribute("max")),i));t<o&&this._extent.zoomout||i<t&&this._extent.zoomin;o<=t&&t<=i||(this._extent.zoomin&&i<t?(this._href=this._extent.zoomin,this._layerEl.src=this._extent.zoomin,this.href=this._extent.zoomin,this._layerEl.src=this._extent.zoomin):this._extent.zoomout&&t<o&&(this._href=this._extent.zoomout,this.href=this._extent.zoomout,this._layerEl.src=this._extent.zoomout)),this._templatedLayer},onRemove:function(t){L.DomUtil.remove(this._container),this._staticTileLayer&&t.removeLayer(this._staticTileLayer),this._mapmlvectors&&t.removeLayer(this._mapmlvectors),this._imageLayer&&t.removeLayer(this._imageLayer),this._extent&&this._extent._mapExtents&&this._removeExtents(t),t.fire("checkdisabled"),t.off("popupopen",this._attachSkipButtons)},getAttribution:function(){return this.options.attribution},getLayerExtentHTML:function(t,o){var i=L.DomUtil.create("fieldset","mapml-layer-extent"),e=L.DomUtil.create("div","mapml-layer-item-properties",i),n=L.DomUtil.create("div","mapml-layer-item-settings",i),a=L.DomUtil.create("label","mapml-layer-item-toggle",e),s=L.DomUtil.create("input"),r=L.SVG.create("svg"),l=L.SVG.create("path"),m=L.SVG.create("path"),p=L.DomUtil.create("span"),u=L.DomUtil.create("div","mapml-layer-item-controls",e),c=L.DomUtil.create("details","mapml-layer-item-opacity",n),e=L.DomUtil.create("summary","",c),h=this._layerEl.parentNode,d=this._layerEl,c=L.DomUtil.create("input","",c);n.hidden=!0,i.setAttribute("aria-grabbed","false"),t||(i.setAttribute("hidden",""),this._extent._mapExtents[o].hidden=!0),r.setAttribute("viewBox","0 0 24 24"),r.setAttribute("height","22"),r.setAttribute("width","22"),l.setAttribute("d","M0 0h24v24H0z"),l.setAttribute("fill","none"),m.setAttribute("d","M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"),r.appendChild(l),r.appendChild(m);let _=L.DomUtil.create("button","mapml-layer-item-remove-control",u);_.type="button",_.title="Remove Sub Layer",_.innerHTML="<span aria-hidden='true'>&#10005;</span>",_.classList.add("mapml-button"),L.DomEvent.on(_,"click",L.DomEvent.stop),L.DomEvent.on(_,"click",t=>{let e=!0;t.target.checked=!1,this._extent._mapExtents[o].removed=!0,this._extent._mapExtents[o].checked=!1,this._layerEl.checked&&this._changeExtent(t,this._extent._mapExtents[o]),this._extent._mapExtents[o].extentAnatomy.parentNode.removeChild(this._extent._mapExtents[o].extentAnatomy);for(let t=0;t<this._extent._mapExtents.length;t++)this._extent._mapExtents[t].removed||(e=!1);e&&this._layerItemSettingsHTML.removeChild(this._extentGroupAnatomy)},this);let y=L.DomUtil.create("button","mapml-layer-item-settings-control",u);y.type="button",y.title="Extent Settings",y.setAttribute("aria-expanded",!1),y.classList.add("mapml-button"),L.DomEvent.on(y,"click",t=>{!0===n.hidden?(y.setAttribute("aria-expanded",!0),n.hidden=!1):(y.setAttribute("aria-expanded",!1),n.hidden=!0)},this),p.setAttribute("aria-hidden",!0),a.appendChild(s),y.appendChild(p),p.appendChild(r),e.innerText="Opacity",e.id="mapml-layer-item-opacity-"+L.stamp(e),c.setAttribute("type","range"),c.setAttribute("min","0"),c.setAttribute("max","1.0"),c.setAttribute("value",this._extent._mapExtents[o]._templateVars.opacity||"1.0"),c.setAttribute("step","0.1"),c.setAttribute("aria-labelledby","mapml-layer-item-opacity-"+L.stamp(e)),this._extent._mapExtents[o]._templateVars.opacity=this._extent._mapExtents[o]._templateVars.opacity||"1.0",L.DomEvent.on(c,"change",this._changeExtentOpacity,this._extent._mapExtents[o]);a=L.DomUtil.create("span","mapml-layer-item-name",a);return s.defaultChecked=!!this._extent._mapExtents[o],this._extent._mapExtents[o].checked=s.defaultChecked,s.type="checkbox",a.innerHTML=t,L.DomEvent.on(s,"change",t=>{this._changeExtent(t,this._extent._mapExtents[o])}),a.id="mapml-extent-item-name-{"+L.stamp(a)+"}",i.setAttribute("aria-labelledby",a.id),a.extent=this._extent._mapExtents[o],i.onmousedown=e=>{if("input"!==e.target.tagName.toLowerCase()&&"select"!==e.target.tagName.toLowerCase()){e.preventDefault(),e.stopPropagation();let r=i,l=i.parentNode,t=!1,m=e.clientY;document.body.onmousemove=a=>{a.preventDefault();var s=a.clientY-m;if(t=5<Math.abs(s)||t,!(l&&!t||l&&l.childElementCount<=1||l.getBoundingClientRect().top>r.getBoundingClientRect().bottom||l.getBoundingClientRect().bottom<r.getBoundingClientRect().top)){l.classList.add("mapml-draggable"),r.style.transform="translateY("+s+"px)",r.style.pointerEvents="none";let t=a.clientX,e=a.clientY,o=("MAPML-VIEWER"===h.tagName?h:h.querySelector(".mapml-web-map")).shadowRoot,i=o.elementFromPoint(t,e),n=i&&i.closest("fieldset")?i.closest("fieldset"):r;n=Math.abs(s)<=n.offsetHeight?r:n,r.setAttribute("aria-grabbed","true"),r.setAttribute("aria-dropeffect","move"),n&&l===n.parentNode&&(n=n!==r.nextSibling?n:n.nextSibling,r!==n&&(m=a.clientY,r.style.transform=null),l.insertBefore(r,n))}},document.body.onmouseup=()=>{r.setAttribute("aria-grabbed","false"),r.removeAttribute("aria-dropeffect"),r.style.pointerEvents=null,r.style.transform=null;let t=l.children,e=0;for(var o of t){let t=o.querySelector("span").extent;t.setAttribute("data-moving",""),d.insertAdjacentElement("beforeend",t),t.removeAttribute("data-moving"),t.extentZIndex=e,t.templatedLayer.setZIndex(e),e++}l.classList.remove("mapml-draggable"),document.body.onmousemove=document.body.onmouseup=null}}},i},getLayerUserControlsHTML:function(){var o=L.DomUtil.create("fieldset","mapml-layer-item"),t=L.DomUtil.create("input"),e=L.DomUtil.create("span","mapml-layer-item-name"),i=L.DomUtil.create("span"),n=L.DomUtil.create("div","mapml-layer-item-properties",o),a=L.DomUtil.create("div","mapml-layer-item-settings",o),s=L.DomUtil.create("label","mapml-layer-item-toggle",n),r=L.DomUtil.create("div","mapml-layer-item-controls",n),l=L.DomUtil.create("details","mapml-layer-item-opacity mapml-control-layers",a),m=L.DomUtil.create("input"),p=L.DomUtil.create("summary"),u=L.SVG.create("svg"),c=L.SVG.create("path"),n=L.SVG.create("path"),h=L.DomUtil.create("fieldset","mapml-layer-grouped-extents"),d=this._layerEl.parentNode;this.opacityEl=m,this._mapmlLayerItem=o,u.setAttribute("viewBox","0 0 24 24"),u.setAttribute("height","22"),u.setAttribute("width","22"),c.setAttribute("d","M0 0h24v24H0z"),c.setAttribute("fill","none"),n.setAttribute("d","M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"),u.appendChild(c),u.appendChild(n),a.hidden=!0,i.setAttribute("aria-hidden",!0);let _=L.DomUtil.create("button","mapml-layer-item-remove-control",r);_.type="button",_.title="Remove Layer",_.innerHTML="<span aria-hidden='true'>&#10005;</span>",_.classList.add("mapml-button"),L.DomEvent.on(_,"click",L.DomEvent.stop),L.DomEvent.on(_,"click",t=>{let e=0,o,i;if(i=("MAPML-VIEWER"===d.tagName?d:d.querySelector(".mapml-web-map")).shadowRoot,t.target.closest("fieldset").nextElementSibling&&!t.target.closest("fieldset").nextElementSibling.disbaled)for(o=t.target.closest("fieldset").previousElementSibling;o;)e+=2,o=o.previousElementSibling;else o="link";d.removeChild(t.target.closest("fieldset").querySelector("span").layer._layerEl),o=o?i.querySelector(".leaflet-control-attribution").firstElementChild:o=i.querySelectorAll("input")[e],o.focus()},this);let y=L.DomUtil.create("button","mapml-layer-item-settings-control",r);if(y.type="button",y.title="Layer Settings",y.setAttribute("aria-expanded",!1),y.classList.add("mapml-button"),L.DomEvent.on(y,"click",t=>{!0===a.hidden?(y.setAttribute("aria-expanded",!0),a.hidden=!1):(y.setAttribute("aria-expanded",!1),a.hidden=!0)},this),t.defaultChecked=!!this._map,t.type="checkbox",(e.layer=this)._legendUrl?((r=document.createElement("a")).text=" "+this._title,r.href=this._legendUrl,r.target="_blank",r.draggable=!1,e.appendChild(r)):e.innerHTML=this._title,e.id="mapml-layer-item-name-{"+L.stamp(e)+"}",p.innerText="Opacity",p.id="mapml-layer-item-opacity-"+L.stamp(p),l.appendChild(p),l.appendChild(m),m.setAttribute("type","range"),m.setAttribute("min","0"),m.setAttribute("max","1.0"),m.setAttribute("value",this._container.style.opacity||"1.0"),m.setAttribute("step","0.1"),m.setAttribute("aria-labelledby",p.id),m.value=this._container.style.opacity||"1.0",o.setAttribute("aria-grabbed","false"),o.setAttribute("aria-labelledby",e.id),o.onmousedown=e=>{if("input"!==e.target.tagName.toLowerCase()&&"select"!==e.target.tagName.toLowerCase()){e.preventDefault();let r=o,l=o.parentNode,t=!1,m=e.clientY;document.body.onmousemove=a=>{a.preventDefault();var s=a.clientY-m;if(t=5<Math.abs(s)||t,!(l&&!t||l&&l.childElementCount<=1||l.getBoundingClientRect().top>r.getBoundingClientRect().bottom||l.getBoundingClientRect().bottom<r.getBoundingClientRect().top)){l.classList.add("mapml-draggable"),r.style.transform="translateY("+s+"px)",r.style.pointerEvents="none";let t=a.clientX,e=a.clientY,o=("MAPML-VIEWER"===d.tagName?d:d.querySelector(".mapml-web-map")).shadowRoot,i=o.elementFromPoint(t,e),n=i&&i.closest("fieldset")?i.closest("fieldset"):r;n=Math.abs(s)<=n.offsetHeight?r:n,r.setAttribute("aria-grabbed","true"),r.setAttribute("aria-dropeffect","move"),n&&l===n.parentNode&&(n=n!==r.nextSibling?n:n.nextSibling,r!==n&&(m=a.clientY,r.style.transform=null),l.insertBefore(r,n))}},document.body.onmouseup=()=>{r.setAttribute("aria-grabbed","false"),r.removeAttribute("aria-dropeffect"),r.style.pointerEvents=null,r.style.transform=null;let t=l.children,e=1;for(var o of t){let t=o.querySelector("span").layer._layerEl;t.setAttribute("data-moving",""),d.insertAdjacentElement("beforeend",t),t.removeAttribute("data-moving"),t._layer.setZIndex(e),e++}l.classList.remove("mapml-draggable"),document.body.onmousemove=document.body.onmouseup=null}}},L.DomEvent.on(m,"change",this._changeOpacity,this),s.appendChild(t),s.appendChild(e),y.appendChild(i),i.appendChild(u),this._styles&&a.appendChild(this._styles),this._userInputs){var g=document.createDocumentFragment(),f=this._extent._templateVars;if(f)for(var x=0;x<f.length;x++)for(var b=f[x],v=0;v<b.values.length;v++){var E,M,A=b.values[v],C="#"+A.getAttribute("id");"map-select"!==A.tagName.toLowerCase()||g.querySelector(C)||(E=L.DomUtil.create("details","mapml-layer-item-time mapml-control-layers",g),M=L.DomUtil.create("summary"),(C=L.DomUtil.create("label")).innerText=A.getAttribute("name"),C.setAttribute("for",A.getAttribute("id")),M.appendChild(C),E.appendChild(M),E.appendChild(A.htmlselect))}a.appendChild(g)}if(this._extent&&this._extent._mapExtents){var T=!0;this._layerItemSettingsHTML=a,(this._extentGroupAnatomy=h).setAttribute("aria-label","Sublayers");for(let t=0;t<this._extent._mapExtents.length;t++)h.appendChild(this._extent._mapExtents[t].extentAnatomy),this._extent._mapExtents[t].hidden||(T=!1);T||a.appendChild(h)}return this._mapmlLayerItem},_initialize:function(t){var z,e,o,i;function E(e,i,n,t,o,a){var s=[],r=e.querySelectorAll("map-link[rel=tile],map-link[rel=image],map-link[rel=features],map-link[rel=query]"),l=new RegExp("(?:{)(.*?)(?:})","g"),m=e.querySelector('map-input[type="zoom" i]'),p=!1,u={zoom:0};if(i){let t=M.metaContentToObject(i.getAttribute("content")),e;u.zoom=t.zoom||u.zoom;let o=Object.keys(t);for(let t=0;t<o.length;t++)if(!o[t].includes("zoom")){e=M.axisToCS(o[t].split("-")[2]);break}i=M.csToAxes(e);u.bounds=M.boundsToPCRSBounds(L.bounds(L.point(+t["top-left-"+i[0]],+t["top-left-"+i[1]]),L.point(+t["bottom-right-"+i[0]],+t["bottom-right-"+i[1]])),u.zoom,n,e)}else u.bounds=M[n].options.crs.pcrs.bounds;for(var c=0;c<r.length;c++){var h=r[c];if(!(_=h.getAttribute("tref"))){var d,_=w;for(d of t.querySelectorAll("map-input"))_+=`{${d.getAttribute("name")}}`}for(var y=h.hasAttribute("title")?h.getAttribute("title"):"Query this layer",g=_.match(l),f=h.hasAttribute("rel")&&"tile"!==h.getAttribute("rel").toLowerCase()?h.getAttribute("rel").toLowerCase():"tile",x=h.hasAttribute("type")?h.getAttribute("type").toLowerCase():"image/*",b=[],v=h&&h.hasAttribute("tms"),E=t.querySelector("map-meta[name=zoom]")?M.metaContentToObject(t.querySelector("map-meta[name=zoom]").getAttribute("content")):void 0;null!==(A=l.exec(_));){var A,C=A[1],T=e.querySelector("map-input[name="+C+"],map-select[name="+C+"]");if(!T){console.log("input with name="+C+" not found for template variable of same name");break}if(T.hasAttribute("type")&&"location"===T.getAttribute("type")&&!T.hasAttribute("min")&&T.hasAttribute("axis")&&!["i","j"].includes(T.getAttribute("axis").toLowerCase())&&(m.setAttribute("value",u.zoom),A=T.getAttribute("axis"),C=M.convertPCRSBounds(u.bounds,u.zoom,n,M.axisToCS(A)),T.setAttribute("min",C.min[M.axisToXY(A)]),T.setAttribute("max",C.max[M.axisToXY(A)])),b.push(T),p=p||T.hasAttribute("type")&&"zoom"===T.getAttribute("type").toLowerCase(),T.hasAttribute("shard")){var S=T.getAttribute("list");T.servers=[];var k=e.querySelectorAll("map-datalist#"+S+" > map-option");0===k.length&&T.hasAttribute("value")&&(k=T.getAttribute("value").split(""));for(var I=0;I<k.length;I++)k[I].getAttribute?T.servers.push(k[I].getAttribute("value")):T.servers.push(k[I])}else"map-select"===T.tagName.toLowerCase()&&((S=document.createElement("div")).insertAdjacentHTML("afterbegin",T.outerHTML),T.htmlselect=S.querySelector("map-select"),T.htmlselect=function(e){var o=document.createElement("select"),i=e.getAttributeNames();for(let t=0;t<i.length;t++)o.setAttribute(i[t],e.getAttribute(i[t]));var n=e.children;for(let e=0;e<n.length;e++){var a=document.createElement("option"),s=n[e].getAttributeNames();for(let t=0;t<s.length;t++)a.setAttribute(s[t],n[e].getAttribute(s[t]));a.innerHTML=n[e].innerHTML,o.appendChild(a)}return o}(T.htmlselect),L.DomEvent.on(T.htmlselect,"change",z.redraw,z),z._userInputs||(z._userInputs=[]),z._userInputs.push(T.htmlselect))}if(_&&g.length===b.length||_===w){"query"===f&&(z.queryable=!0),!p&&m&&b.push(m);let t=m?m.getAttribute("step"):1;t&&"0"!==t&&!isNaN(t)||(t=1),s.push({template:decodeURI(new URL(_,o)),linkEl:h,title:y,rel:f,type:x,values:b,zoomBounds:E,extentPCRSFallback:{bounds:u.bounds},projectionMatch:a,projection:e.getAttribute("units")||P,tms:v,step:t})}}return s}function n(t){var e=this.responseXML||t;if(e.querySelector&&e.querySelector("map-feature")&&(z._content=e),!this.responseXML&&this.responseText&&(e=(new DOMParser).parseFromString(this.responseText,"text/xml")),this.readyState===this.DONE&&e.querySelector&&!e.querySelector("parsererror")){var o,i=e.querySelectorAll("map-extent");if(i.length||(m=e.querySelector("map-meta[name=projection]")),1<=i.length)for(let t=0;t<i.length&&(n=(o="map-extent"===i[t].tagName.toLowerCase()&&i[t].hasAttribute("units")?i[t].getAttribute("units"):o)&&o===z.options.mapprojection);t++);else m&&"map-meta"===m.tagName.toLowerCase()&&m.hasAttribute("content")&&(n=(o=M.metaContentToObject(m.getAttribute("content")).content)&&o===z.options.mapprojection);var n,a,s=e.querySelector("map-meta[name=extent]"),r=!n&&e.querySelector("map-head map-link[rel=alternate][projection="+z.options.mapprojection+"]"),l=new URL(e.querySelector("map-base")?e.querySelector("map-base").getAttribute("href"):e.baseURI||this.responseURL,this.responseURL).href;if(!n&&r&&r.hasAttribute("href"))return void z.fire("changeprojection",{href:new URL(r.getAttribute("href"),l).href},!1);if(!n&&z._map&&1===z._map.options.mapEl.querySelectorAll("layer-").length)return void(z._map.options.mapEl.projection=o);if(m)z._extent=m;else{z._extent={},n&&(z._extent.crs=M[o]),z._extent._mapExtents=[],z._extent._templateVars=[];for(let t=0;t<i.length;t++)i[t].querySelector("map-link[rel=tile],map-link[rel=image],map-link[rel=features],map-link[rel=query]")&&i[t].hasAttribute("units")&&(z._extent._mapExtents.push(i[t]),n=n||r,a=E.call(z,i[t],s,o,e,l,n),z._extent._mapExtents[t]._templateVars=a,z._extent._templateVars=z._extent._templateVars.concat(a))}z._parseLicenseAndLegend(e,z,o);var t=e.querySelector("map-link[rel=zoomin]"),m=e.querySelector("map-link[rel=zoomout]");if(delete z._extent.zoomin,delete z._extent.zoomout,t&&(z._extent.zoomin=new URL(t.getAttribute("href"),l).href),m&&(z._extent.zoomout=new URL(m.getAttribute("href"),l).href),z._extent._mapExtents)for(let t=0;t<z._extent._mapExtents.length;t++)z._extent._mapExtents[t].templatedLayer&&z._extent._mapExtents[t].templatedLayer.reset(z._extent._mapExtents[t]._templateVars,z._extent._mapExtents[t].extentZIndex);if(e.querySelector("map-tile")){var p=document.createElement("map-tiles"),u=e.querySelector("map-meta[name=zoom][content]")||e.querySelector("map-input[type=zoom][value]");p.setAttribute("zoom",u&&u.getAttribute("content")||u&&u.getAttribute("value")||"0");for(var c=e.getElementsByTagName("map-tile"),h=0;h<c.length;h++)p.appendChild(document.importNode(c[h],!0));z._mapmlTileContainer.appendChild(p)}if(M.parseStylesheetAsHTML(e,l,z._container),z._extent._mapExtents)for(let t=0;t<z._extent._mapExtents.length;t++){var d=z._extent._mapExtents[t].getAttribute("label"),d=z.getLayerExtentHTML(d,t);z._extent._mapExtents[t].extentAnatomy=d}var _=e.querySelectorAll('map-link[rel=style],map-link[rel="self style"],map-link[rel="style self"]');if(1<_.length){var y=document.createElement("details"),u=document.createElement("summary");u.innerText="Style",y.appendChild(u);for(var g=function(t){z.fire("changestyle",{src:t.target.getAttribute("data-href")},!1)},f=0;f<_.length;f++){var x=document.createElement("div"),b=x.appendChild(document.createElement("input"));b.setAttribute("type","radio"),b.setAttribute("id","rad-"+L.stamp(b)),b.setAttribute("name","styles-"+this._title),b.setAttribute("value",_[f].getAttribute("title")),b.setAttribute("data-href",new URL(_[f].getAttribute("href"),l).href);var v=x.appendChild(document.createElement("label"));v.setAttribute("for","rad-"+L.stamp(b)),v.innerText=_[f].getAttribute("title"),"style self"!==_[f].getAttribute("rel")&&"self style"!==_[f].getAttribute("rel")||(b.checked=!0),y.appendChild(x),L.DomUtil.addClass(y,"mapml-layer-item-style mapml-control-layers"),L.DomEvent.on(b,"click",g,z)}z._styles=y}e.querySelector("map-title")?z._title=e.querySelector("map-title").textContent.trim():e instanceof Element&&e.hasAttribute("label")&&(z._title=e.getAttribute("label").trim()),z._map&&(z._validateExtent(),z._map.hasLayer(z)&&z._map.attributionControl.addAttribution(z.getAttribution()))}else z.error=!0;z.fire("extentload",z,!1),z._layerEl.dispatchEvent(new CustomEvent("extentload",{detail:z}))}(this._href||t)&&((z=this)._href?(e=new XMLHttpRequest,o=this._href,i=n,e.onreadystatechange=function(){this.readyState===this.DONE&&(400!==this.status&&404!==this.status&&500!==this.status&&406!==this.status||(z.error=!0,z.fire("extentload",z,!0),e.abort()))},e.onload=i,e.onerror=function(){z.error=!0,z.fire("extentload",z,!0)},e.open("GET",o),e.setRequestHeader("Accept",M.mime),e.overrideMimeType("text/xml"),e.send()):t&&n.call(this,t))},_validateExtent:function(){if(this._extent&&this._map){var e,o=this._extent._mapExtents||[this._extent];for(let t=0;t<o.length;t++){if(!o[t].querySelector)return;o[t].querySelector('[type=zoom][min=""], [type=zoom][max=""]')&&((e=o[t].querySelector("[type=zoom]")).setAttribute("min",this._map.getMinZoom()),e.setAttribute("max",this._map.getMaxZoom())),(e=o[t].hasAttribute("units")?o[t].getAttribute("units"):null)&&M[e]?this._extent._mapExtents?this._extent._mapExtents[t].crs=M[e]:this._extent.crs=M[e]:this._extent._mapExtents?this._extent._mapExtents[t].crs=M.OSMTILE:this._extent.crs=M.OSMTILE}}},getProjection:function(){if(this._extent){let t=this._extent._mapExtents?this._extent._mapExtents[0]:this._extent;if(!t)return P;switch(t.tagName.toUpperCase()){case"MAP-EXTENT":if(t.hasAttribute("units"))return t.getAttribute("units").toUpperCase();break;case"MAP-INPUT":if(t.hasAttribute("value"))return t.getAttribute("value").toUpperCase();break;case"MAP-META":if(t.hasAttribute("content"))return M.metaContentToObject(t.getAttribute("content")).content.toUpperCase();break;default:return P}return P}},_parseLicenseAndLegend:function(t,e){var o,i=t.querySelector("map-link[rel=license]");i&&(o=i.getAttribute("title"),o='<a href="'+i.getAttribute("href")+'" title="'+o+'">'+o+"</a>"),L.setOptions(e,{attribution:o});t=t.querySelector("map-link[rel=legend]");t&&(e._legendUrl=t.getAttribute("href"))},getQueryTemplates:function(o){if(this._extent&&this._extent._queries){var i=[];if(this._layerEl.checked&&!this._layerEl.hidden&&this._mapmlLayerItem){var e=this._mapmlLayerItem.querySelectorAll(".mapml-layer-item-name");for(let t=0;t<e.length;t++)if(e[t].extent||1===this._extent._mapExtents.length){var n=e[t].extent||this._extent._mapExtents[0];for(let t=0;t<n._templateVars.length;t++)if(n.checked){var a=n._templateVars[t];for(let e=0;e<this._extent._queries.length;e++){let t=this._extent._queries[e];a===t&&t.extentBounds.contains(o)&&i.push(t)}}}return i}}},_attachSkipButtons:function(t){let n=t.popup,a=t.target,e,s,o=n._container.getElementsByClassName("mapml-popup-content")[0];n._container.setAttribute("role","dialog"),o.setAttribute("tabindex","-1"),o.setAttribute("role","document"),n._count=0,n._source._eventParents?(e=n._source._eventParents[Object.keys(n._source._eventParents)[0]],s=n._source.group):e=n._source._templatedLayer,n._container.querySelector('nav[class="mapml-focus-buttons"]')&&(L.DomUtil.remove(n._container.querySelector('nav[class="mapml-focus-buttons"]')),L.DomUtil.remove(n._container.querySelector("hr")));var i=L.DomUtil.create("nav","mapml-focus-buttons");let r=L.DomUtil.create("button","mapml-popup-button",i);r.type="button",r.title="Focus Map",r.innerHTML="<span aria-hidden='true'>|&#10094;</span>",L.DomEvent.on(r,"click",t=>{L.DomEvent.stop(t),a.featureIndex._sortIndex(),a.closePopup(),a._container.focus()},n);let l=L.DomUtil.create("button","mapml-popup-button",i);l.type="button",l.title="Previous Feature",l.innerHTML="<span aria-hidden='true'>&#10094;</span>",L.DomEvent.on(l,"click",e._previousFeature,n);let m=L.DomUtil.create("p","mapml-feature-count",i),p=this._totalFeatureCount||1;m.innerText=n._count+1+"/"+p;let u=L.DomUtil.create("button","mapml-popup-button",i);u.type="button",u.title="Next Feature",u.innerHTML="<span aria-hidden='true'>&#10095;</span>",L.DomEvent.on(u,"click",e._nextFeature,n);let c=L.DomUtil.create("button","mapml-popup-button",i);c.type="button",c.title="Focus Controls",c.innerHTML="<span aria-hidden='true'>&#10095;|</span>",L.DomEvent.on(c,"click",t=>{a.featureIndex._sortIndex(),a.featureIndex.currentIndex=a.featureIndex.inBoundFeatures.length-1,a.featureIndex.inBoundFeatures[0].path.setAttribute("tabindex",-1),a.featureIndex.inBoundFeatures[a.featureIndex.currentIndex].path.setAttribute("tabindex",0),L.DomEvent.stop(t),a.closePopup(),a._controlContainer.querySelector("A").focus()},n);t=L.DomUtil.create("hr");function h(t){let e=t.originalEvent.path||t.originalEvent.composedPath();var o=9===t.originalEvent.keyCode,i=t.originalEvent.shiftKey;(e[0].classList.contains("leaflet-popup-close-button")&&o&&!i||27===t.originalEvent.keyCode||("Focus Map"===e[0].title||e[0].classList.contains("mapml-popup-content"))&&o&&i)&&setTimeout(()=>{L.DomEvent.stop(t),a.closePopup(n),s.focus()},0)}function d(t){let e=t.originalEvent.path||t.originalEvent.composedPath();var o=9===t.originalEvent.keyCode,i=t.originalEvent.shiftKey;13===t.originalEvent.keyCode&&e[0].classList.contains("leaflet-popup-close-button")||27===t.originalEvent.keyCode?(L.DomEvent.stopPropagation(t),a.closePopup(n),a._container.focus(),27!==t.originalEvent.keyCode&&(a._popupClosed=!0)):o&&e[0].classList.contains("leaflet-popup-close-button")?a.closePopup(n):("Focus Map"===e[0].title||e[0].classList.contains("mapml-popup-content"))&&o&&i&&(a.closePopup(n),setTimeout(()=>{L.DomEvent.stop(t),a._container.focus()},0))}n._navigationBar=i,n._content.appendChild(t),n._content.appendChild(i),o.focus(),s&&!M.options.featureIndexOverlayOption?(s.setAttribute("aria-expanded","true"),a.on("keydown",h)):a.on("keydown",d),a.on("popupclose",function t(e){e.popup===n&&(a.off("keydown",h),a.off("keydown",d),a.off("popupclose",t),s&&s.setAttribute("aria-expanded","false"))})}}),v=L.Layer.extend({onAdd:function(t){var e=t.getSize();(400<e.x||300<e.y)&&(this._container=L.DomUtil.create("table","mapml-debug",t._container),this._panel=A({className:"mapml-debug-panel",pane:this._container}),t.addLayer(this._panel)),this._grid=T({className:"mapml-debug-grid",pane:t._panes.mapPane,zIndex:400,tileSize:t.options.crs.options.crs.tile.bounds.max.x}),t.addLayer(this._grid),this._vectors=k({className:"mapml-debug-vectors",pane:t._panes.mapPane,toolPane:this._container}),t.addLayer(this._vectors)},onRemove:function(t){t.removeLayer(this._grid),t.removeLayer(this._vectors),this._panel&&(t.removeLayer(this._panel),L.DomUtil.remove(this._container))}}),E=L.Layer.extend({initialize:function(t){L.setOptions(this,t)},onAdd:function(t){this._title=L.DomUtil.create("caption","mapml-debug-banner",this.options.pane),this._title.innerHTML="Debug mode",t.debug={},t.debug._infoContainer=this._debugContainer=L.DomUtil.create("tbody","mapml-debug-panel",this.options.pane);var e=t.debug._infoContainer;t.debug._tileCoord=L.DomUtil.create("tr","mapml-debug-coordinates",e),t.debug._tileMatrixCoord=L.DomUtil.create("tr","mapml-debug-coordinates",e),t.debug._mapCoord=L.DomUtil.create("tr","mapml-debug-coordinates",e),t.debug._tcrsCoord=L.DomUtil.create("tr","mapml-debug-coordinates",e),t.debug._pcrsCoord=L.DomUtil.create("tr","mapml-debug-coordinates",e),t.debug._gcrsCoord=L.DomUtil.create("tr","mapml-debug-coordinates",e),this._map.on("mousemove",this._updateCoords)},onRemove:function(){L.DomUtil.remove(this._title),this._debugContainer&&(L.DomUtil.remove(this._debugContainer),this._map.off("mousemove",this._updateCoords))},_updateCoords:function(r){if(!this.contextMenu._visible){let t=this.options.mapEl,e=t._map.project(r.latlng),o=t._map.options.crs.scale(+t.zoom),i=t._map.options.crs.transformation.untransform(e,o),n=t._map.options.crs.options.crs.tile.bounds.max.x,a=e.x%n,s=e.y%n;a<0&&(a+=n),s<0&&(s+=n),this.debug._tileCoord.innerHTML=`
      <th scope="row">tile: </th>
      <td>i: ${Math.trunc(a)}, </td>
      <td>j: ${Math.trunc(s)}</td>
      `,this.debug._mapCoord.innerHTML=`
      <th scope="row">map: </th>
      <td>i: ${Math.trunc(r.containerPoint.x)}, </td>
      <td>j: ${Math.trunc(r.containerPoint.y)}</td>
      `,this.debug._gcrsCoord.innerHTML=`
      <th scope="row">gcrs: </th>
      <td>lon: ${r.latlng.lng.toFixed(6)}, </td>
      <td>lat: ${r.latlng.lat.toFixed(6)}</td>
      `,this.debug._tcrsCoord.innerHTML=`
      <th scope="row">tcrs: </th>
      <td>x: ${Math.trunc(e.x)}, </td>
      <td>y: ${Math.trunc(e.y)}</td>
      `,this.debug._tileMatrixCoord.innerHTML=`
      <th scope="row">tilematrix: </th>
      <td>column: ${Math.trunc(e.x/n)}, </td>
      <td>row: ${Math.trunc(e.y/n)}</td>
      `,this.debug._pcrsCoord.innerHTML=`
      <th scope="row">pcrs: </th>
      <td>easting: ${i.x.toFixed(2)}, </td>
      <td>northing: ${i.y.toFixed(2)}</td>
      `}}}),A=function(t){return new E(t)},C=L.GridLayer.extend({initialize:function(t){L.setOptions(this,t),L.GridLayer.prototype.initialize.call(this,this._map)},createTile:function(t){let e=L.DomUtil.create("div","mapml-debug-tile");return e.setAttribute("col",t.x),e.setAttribute("row",t.y),e.setAttribute("zoom",t.z),e.innerHTML=["col: "+t.x,"row: "+t.y,"zoom: "+t.z].join(", "),e.style.outline="1px dashed red",e}}),T=function(t){return new C(t)},S=L.LayerGroup.extend({initialize:function(t){L.setOptions(this,t),L.LayerGroup.prototype.initialize.call(this,this._map,t)},onAdd:function(t){t.on("overlayremove",this._mapLayerUpdate,this),t.on("overlayadd",this._mapLayerUpdate,this);var e=t.options.crs.transformation.transform(L.point(0,0),t.options.crs.scale(0));this._centerVector=L.circle(t.options.crs.pointToLatLng(e,0),{radius:250}),this._centerVector.bindTooltip("Projection Center"),this._addBounds(t)},onRemove:function(t){this.clearLayers()},_addBounds:function(t){let e=Object.keys(t._layers),o=t._layers,i=["#FF5733","#8DFF33","#3397FF","#E433FF","#F3FF33"],n=0;this.addLayer(this._centerVector);for(var a of e)if(o[a].layerBounds||o[a].extentBounds){let t;t=o[a].layerBounds?[o[a].layerBounds.min,L.point(o[a].layerBounds.max.x,o[a].layerBounds.min.y),o[a].layerBounds.max,L.point(o[a].layerBounds.min.x,o[a].layerBounds.max.y)]:[o[a].extentBounds.min,L.point(o[a].extentBounds.max.x,o[a].extentBounds.min.y),o[a].extentBounds.max,L.point(o[a].extentBounds.min.x,o[a].extentBounds.max.y)];let e=z(t,{color:i[n%i.length],weight:2,opacity:1,fillOpacity:.01,fill:!0});o[a].options._leafletLayer&&e.bindTooltip(o[a].options._leafletLayer._title,{sticky:!0}),this.addLayer(e),n++}t.totalLayerBounds&&(t=[t.totalLayerBounds.min,L.point(t.totalLayerBounds.max.x,t.totalLayerBounds.min.y),t.totalLayerBounds.max,L.point(t.totalLayerBounds.min.x,t.totalLayerBounds.max.y)],t=z(t,{color:"#808080",weight:5,opacity:.5,fill:!1}),this.addLayer(t))},_mapLayerUpdate:function(t){this.clearLayers(),this._addBounds(t.target)}}),k=function(t){return new S(t)},I=L.Path.extend({options:{className:"mapml-debug-extent"},initialize:function(t,e){this._locations=t,L.setOptions(this,e)},_project:function(){this._rings=[];let e=this._map.options.crs.scale(this._map.getZoom()),o=this._map;for(let t=0;t<this._locations.length;t++){var i=o.options.crs.transformation.transform(this._locations[t],e);this._rings.push(L.point(i.x,i.y)._subtract(o.getPixelOrigin()))}this._parts=[this._rings]},_update:function(){this._map&&this._renderer._updatePoly(this,!0)}}),z=function(t,e){return new I(t,e)},B=L.Handler.extend({addHooks:function(){L.setOptions(this,{mapEl:this._map.options.mapEl}),L.DomEvent.on(this._map,"click",this._queryTopLayer,this),L.DomEvent.on(this._map,"keypress",this._queryTopLayerAtMapCenter,this)},removeHooks:function(){L.DomEvent.off(this._map,"click",this._queryTopLayer,this),L.DomEvent.on(this._map,"keypress",this._queryTopLayerAtMapCenter,this)},_getTopQueryableLayer:function(){for(var t=this.options.mapEl.layers,e=t.length-1;0<=e;e--){var o=t[e]._layer;if(t[e].checked&&o.queryable)return o}},_queryTopLayerAtMapCenter:function(t){setTimeout(()=>{!this._map.isFocused||this._map._popupClosed||" "!==t.originalEvent.key&&13!=+t.originalEvent.keyCode?delete this._map._popupClosed:this._map.fire("click",{latlng:this._map.getCenter(),layerPoint:this._map.latLngToLayerPoint(this._map.getCenter()),containerPoint:this._map.latLngToContainerPoint(this._map.getCenter())})},0)},_queryTopLayer:function(t){var e=this._getTopQueryableLayer();e&&(e._mapmlFeatures&&delete e._mapmlFeatures,this._query(t,e))},_query(a,s){function e(t){return l.transformation.untransform(t,l.scale(n))}function o(t){return l.unproject(l.transformation.untransform(t,l.scale(n)),n)}function i(t,e,i){const n=new DOMParser;fetch(L.Util.template(t.template,e),{redirect:"follow"}).then(e=>{if(200<=e.status&&e.status<300)return e.text().then(t=>({contenttype:e.headers.get("Content-Type"),text:t}));throw new Error(e.status)}).then(o=>{if(s._mapmlFeatures||(s._mapmlFeatures=[]),o.contenttype.startsWith("text/mapml")){let t=n.parseFromString(o.text,"application/xml"),e=Array.prototype.slice.call(t.querySelectorAll("map-feature"));e.length&&(s._mapmlFeatures=s._mapmlFeatures.concat(e))}else{var t="<map-geometry cs='gcrs'>"+a.latlng.lng+" "+a.latlng.lat+"</map-geometry>",t=n.parseFromString("<map-feature><map-properties>"+o.text+"</map-properties>"+t+"</map-feature>","text/html").querySelector("map-feature");s._mapmlFeatures.push(t)}if(i)return function(t,e){let o=M.mapMlFeatures(t,{renderer:M.featureRenderer(),pane:p,projection:r.options.projection,_leafletLayer:s,query:!0,static:!0});o.addTo(r);let i=L.DomUtil.create("div","mapml-popup-content"),n=L.DomUtil.create("iframe");n.style="border: none",n.srcdoc=t[0].querySelector("map-feature map-properties").innerHTML,n.setAttribute("sandbox","allow-same-origin allow-forms"),i.appendChild(n),s._totalFeatureCount=t.length,s.bindPopup(i,u).openPopup(e),s.on("popupclose",function(){r.removeLayer(o)}),o.showPaginationFeature({i:0,popup:s._popup})}(s._mapmlFeatures,a.latlng)}).catch(t=>{console.log("Looks like there was a problem. Status: "+t.message)})}var n=a.target.getZoom(),r=this._map,l=s._extent.crs,m=r.options.crs.options.crs.tile.bounds.max.x,p=s._container,u={autoClose:!1,autoPan:!0,maxHeight:.5*r.getSize().y-50},c=l.latLngToPoint(a.latlng,n),h=c.divideBy(m).floor(),d=new L.Bounds(c.divideBy(m).floor().multiplyBy(m),c.divideBy(m).ceil().multiplyBy(m)),t=this._map.project(a.latlng),_=this._map.options.crs.scale(this._map.getZoom()),y=this._map.options.crs.transformation.untransform(t,_),g=s.getQueryTemplates(y);for(let t=0;t<g.length;t++){var f,x={},b=g[t];for(f in x[b.query.tilei]=c.x.toFixed()-h.x*m,x[b.query.tilej]=c.y.toFixed()-h.y*m,x[b.query.mapi]=r.getSize().divideBy(2).x.toFixed(),x[b.query.mapj]=r.getSize().divideBy(2).y.toFixed(),x[b.query.pixelleft]=l.pointToLatLng(c,n).lng,x[b.query.pixeltop]=l.pointToLatLng(c,n).lat,x[b.query.pixelright]=l.pointToLatLng(c.add([1,1]),n).lng,x[b.query.pixelbottom]=l.pointToLatLng(c.add([1,1]),n).lat,x[b.query.column]=h.x,x[b.query.row]=h.y,x[b.query.x]=c.x.toFixed(),x[b.query.y]=c.y.toFixed(),x[b.query.easting]=e(c).x,x[b.query.northing]=e(c).y,x[b.query.longitude]=o(c).lng,x[b.query.latitude]=o(c).lat,x[b.query.zoom]=n,x[b.query.width]=r.getSize().x,x[b.query.height]=r.getSize().y,x[b.query.mapbottom]=e(c.add(r.getSize().divideBy(2))).y,x[b.query.mapleft]=e(c.subtract(r.getSize().divideBy(2))).x,x[b.query.maptop]=e(c.subtract(r.getSize().divideBy(2))).y,x[b.query.mapright]=e(c.add(r.getSize().divideBy(2))).x,x[b.query.tilebottom]=e(d.max).y,x[b.query.tileleft]=e(d.min).x,x[b.query.tiletop]=e(d.min).y,x[b.query.tileright]=e(d.max).x,b.query)["mapi","mapj","tilei","tilej","row","col","x","y","easting","northing","longitude","latitude","width","height","zoom","mapleft","mapright",",maptop","mapbottom","tileleft","tileright","tiletop","tilebottom","pixeltop","pixelbottom","pixelleft","pixelright"].indexOf(f)<0&&(x[f]=b.query[f]);b.extentBounds.contains(y)&&i(b,x,t===g.length-1)}}}),F=L.Handler.extend({_touchstart:L.Browser.msPointer?"MSPointerDown":L.Browser.pointer?"pointerdown":"touchstart",initialize:function(t){L.Handler.prototype.initialize.call(this,t),this._items=[{text:M.options.locale.cmBack+" (<kbd>B</kbd>)",callback:this._goBack},{text:M.options.locale.cmForward+" (<kbd>F</kbd>)",callback:this._goForward},{text:M.options.locale.cmReload+" (<kbd>R</kbd>)",callback:this._reload},{spacer:"-"},{text:M.options.locale.cmToggleControls+" (<kbd>T</kbd>)",callback:this._toggleControls},{text:M.options.locale.cmCopyCoords+" (<kbd>C</kbd>)<span></span>",callback:this._copyCoords,hideOnSelect:!1,popup:!0,submenu:[{text:"tile",callback:this._copyTile},{text:"tilematrix",callback:this._copyTileMatrix},{spacer:"-"},{text:"map",callback:this._copyMap},{spacer:"-"},{text:"tcrs",callback:this._copyTCRS},{text:"pcrs",callback:this._copyPCRS},{text:"gcrs",callback:this._copyGCRS},{spacer:"-"},{text:M.options.locale.cmCopyAll,callback:this._copyAllCoords}]},{text:M.options.locale.cmToggleDebug+" (<kbd>D</kbd>)",callback:this._toggleDebug},{text:M.options.locale.cmCopyMapML+" (<kbd>M</kbd>)",callback:this._copyMapML},{text:M.options.locale.cmPasteLayer+" (<kbd>P</kbd>)",callback:this._pasteLayer},{text:M.options.locale.cmViewSource+" (<kbd>V</kbd>)",callback:this._viewSource}],this._layerItems=[{text:M.options.locale.lmZoomToLayer+" (<kbd>Z</kbd>)",callback:this._zoomToLayer},{text:M.options.locale.lmCopyExtent+" (<kbd>C</kbd>)",callback:this._copyLayerExtent},{text:M.options.locale.lmCopyLayer+" (<kbd>L</kbd>)",callback:this._copyLayer}],this._mapMenuVisible=!1,this._keyboardEvent=!1,this._container=L.DomUtil.create("div","mapml-contextmenu",t._container),this._container.setAttribute("hidden","");for(let t=0;t<6;t++)this._items[t].el=this._createItem(this._container,this._items[t]);this._coordMenu=L.DomUtil.create("div","mapml-contextmenu mapml-submenu",this._container),this._coordMenu.id="mapml-copy-submenu",this._coordMenu.setAttribute("hidden",""),this._clickEvent=null;for(let t=0;t<this._items[5].submenu.length;t++)this._createItem(this._coordMenu,this._items[5].submenu[t],t);this._items[6].el=this._createItem(this._container,this._items[6]),this._items[7].el=this._createItem(this._container,this._items[7]),this._items[8].el=this._createItem(this._container,this._items[8]),this._items[9].el=this._createItem(this._container,this._items[9]),this._layerMenu=L.DomUtil.create("div","mapml-contextmenu mapml-layer-menu",t._container),this._layerMenu.setAttribute("hidden","");for(let t=0;t<this._layerItems.length;t++)this._createItem(this._layerMenu,this._layerItems[t]);L.DomEvent.on(this._container,"click",L.DomEvent.stop).on(this._container,"mousedown",L.DomEvent.stop).on(this._container,"dblclick",L.DomEvent.stop).on(this._container,"contextmenu",L.DomEvent.stop).on(this._layerMenu,"click",L.DomEvent.stop).on(this._layerMenu,"mousedown",L.DomEvent.stop).on(this._layerMenu,"dblclick",L.DomEvent.stop).on(this._layerMenu,"contextmenu",L.DomEvent.stop)},addHooks:function(){var t=this._map.getContainer();L.DomEvent.on(t,"mouseleave",this._hide,this).on(document,"keydown",this._onKeyDown,this),L.Browser.touch&&L.DomEvent.on(document,this._touchstart,this._hide,this),this._map.on({contextmenu:this._show,mousedown:this._hide,zoomstart:this._hide},this)},removeHooks:function(){var t=this._map.getContainer();L.DomEvent.off(t,"mouseleave",this._hide,this).off(document,"keydown",this._onKeyDown,this),L.Browser.touch&&L.DomEvent.off(document,this._touchstart,this._hide,this),this._map.off({contextmenu:this._show,mousedown:this._hide,zoomstart:this._hide},this)},_copyLayerExtent:function(t){let e=(t instanceof KeyboardEvent?this._map:this).contextMenu,o=e._layerClicked.layer._layerEl,i=o.extent.topLeft.pcrs,n=o.extent.bottomRight.pcrs;t=`<map-meta name="extent" content="top-left-easting=${i.horizontal}, top-left-northing=${i.vertical}, bottom-right-easting=${n.horizontal}, bottom-right-northing=${n.vertical}"></map-meta>`;e._copyData(t)},_zoomToLayer:function(t){let e=(t instanceof KeyboardEvent?this._map:this).contextMenu;e._layerClicked.layer._layerEl.focus()},_copyLayer:function(t){let e=(t instanceof KeyboardEvent?this._map:this).contextMenu,o=e._layerClicked.layer._layerEl;e._copyData(o.outerHTML)},_goForward:function(t){let e=(t instanceof KeyboardEvent?this._map:this).options.mapEl;e.forward()},_goBack:function(t){let e=(t instanceof KeyboardEvent?this._map:this).options.mapEl;e.back()},_reload:function(t){let e=(t instanceof KeyboardEvent?this._map:this).options.mapEl;e.reload()},_toggleControls:function(t){let e=(t instanceof KeyboardEvent?this._map:this).options.mapEl;e._toggleControls()},_copyMapML:function(t){let e=(t instanceof KeyboardEvent?this._map:this).contextMenu,o=(t instanceof KeyboardEvent?this._map:this).options.mapEl;e._copyData(o.outerHTML.replace(/<div class="mapml-web-map">.*?<\/div>|<style>\[is="web-map"].*?<\/style>|<style>mapml-viewer.*?<\/style>/gm,""))},_pasteLayer:function(t){(t instanceof KeyboardEvent?this._map:this).contextMenu;let e=(t instanceof KeyboardEvent?this._map:this).options.mapEl;navigator.clipboard.readText().then(t=>{if("<layer-"===(t=t.replace(/(<!--.*?-->)|(<!--[\S\s]+?-->)|(<!--[\S\s]*?$)/g,"").trim()).slice(0,7)&&"</layer->"===t.slice(-9))e.insertAdjacentHTML("beforeend",t);else try{e.geojson2mapml(JSON.parse(t))}catch{console.log("Invalid Paste!")}})},_viewSource:function(t){let e=(t instanceof KeyboardEvent?this._map:this).options.mapEl;e.viewSource()},_toggleDebug:function(t){let e=(t instanceof KeyboardEvent?this._map:this).options.mapEl;e.toggleDebug()},_copyCoords:function(t){let e=this.contextMenu||this;e._showCoordMenu(t)},_copyData:function(t){const e=document.createElement("textarea");e.value=t,document.body.appendChild(e),e.select(),document.execCommand("copy"),document.body.removeChild(e)},_copyGCRS:function(t){let e=this.options.mapEl,o=this.contextMenu._clickEvent;this.contextMenu._copyData(`z:${e.zoom}, lon :${o.latlng.lng.toFixed(6)}, lat:`+o.latlng.lat.toFixed(6))},_copyTCRS:function(t){let e=this.options.mapEl,o=this.contextMenu._clickEvent,i=e._map.project(o.latlng);this.contextMenu._copyData(`z:${e.zoom}, x:${i.x}, y:`+i.y)},_copyTileMatrix:function(t){let e=this.options.mapEl,o=this.contextMenu._clickEvent,i=e._map.project(o.latlng),n=e._map.options.crs.options.crs.tile.bounds.max.x;this.contextMenu._copyData(`z:${e.zoom}, column:${Math.trunc(i.x/n)}, row:`+Math.trunc(i.y/n))},_copyPCRS:function(t){let e=this.options.mapEl,o=this.contextMenu._clickEvent,i=e._map.project(o.latlng),n=e._map.options.crs.scale(+e.zoom),a=e._map.options.crs.transformation.untransform(i,n);this.contextMenu._copyData(`z:${e.zoom}, easting:${a.x.toFixed(2)}, northing:`+a.y.toFixed(2))},_copyTile:function(t){let e=this.options.mapEl,o=this.contextMenu._clickEvent,i=e._map.options.crs.project(o.latlng),n=e._map.options.crs.options.crs.tile.bounds.max.x,a=i.x%n,s=i.y%n;a<0&&(a+=n),s<0&&(s+=n),this.contextMenu._copyData(`z:${e.zoom}, i:${Math.trunc(a)}, j:`+Math.trunc(s))},_copyMap:function(t){var e=this.options.mapEl,o=this.contextMenu._clickEvent;this.contextMenu._copyData(`z:${e.zoom}, i:${Math.trunc(o.containerPoint.x)}, j:`+Math.trunc(o.containerPoint.y))},_copyAllCoords:function(t){let e=this.options.mapEl,o=this.contextMenu._clickEvent,i=e._map.project(o.latlng),n=e._map.options.crs.options.crs.tile.bounds.max.x,a=i.x%n,s=i.y%n,r=e._map.options.crs.scale(+e.zoom),l=e._map.options.crs.transformation.untransform(i,r);var m=`z:${e.zoom}
`;m+=`tile: i:${Math.trunc(a)}, j:${Math.trunc(s)}
`,m+=`tilematrix: column:${Math.trunc(i.x/n)}, row:${Math.trunc(i.y/n)}
`,m+=`map: i:${Math.trunc(o.containerPoint.x)}, j:${Math.trunc(o.containerPoint.y)}
`,m+=`tcrs: x:${Math.trunc(i.x)}, y:${Math.trunc(i.y)}
`,m+=`pcrs: easting:${l.x.toFixed(2)}, northing:${l.y.toFixed(2)}
`,m+=`gcrs: lon :${o.latlng.lng.toFixed(6)}, lat:`+o.latlng.lat.toFixed(6),this.contextMenu._copyData(m)},_createItem:function(t,e,o){if(e.spacer)return this._createSeparator(t,o);t=this._insertElementAt("button","mapml-contextmenu-item",t,o),o=this._createEventHandler(t,e.callback,e.context,e.hideOnSelect);return t.innerHTML=""+e.text,t.setAttribute("type","button"),t.classList.add("mapml-button"),e.popup&&(t.setAttribute("aria-haspopup","true"),t.setAttribute("aria-expanded","false"),t.setAttribute("aria-controls","mapml-copy-submenu")),L.DomEvent.on(t,"mouseover",this._onItemMouseOver,this).on(t,"mouseout",this._onItemMouseOut,this).on(t,"mousedown",L.DomEvent.stopPropagation).on(t,"click",o),L.Browser.touch&&L.DomEvent.on(t,this._touchstart,L.DomEvent.stopPropagation),L.Browser.pointer||L.DomEvent.on(t,"click",this._onItemMouseOut,this),{id:L.Util.stamp(t),el:t,callback:o}},_createSeparator:function(t,e){e=this._insertElementAt("div","mapml-contextmenu-separator",t,e);return{id:L.Util.stamp(e),el:e}},_createEventHandler:function(r,l,m,p){let u=this;return p=void 0===p||p,function(t){let e=u._map,o=u._showLocation.containerPoint,i=e.containerPointToLayerPoint(o),n=e.layerPointToLatLng(i),a=u._showLocation.relatedTarget,s={containerPoint:o,layerPoint:i,latlng:n,relatedTarget:a};p&&u._hide(),l&&l.call(m||e,s),u._map.fire("contextmenu.select",{contextmenu:u,el:r})}},_insertElementAt:function(t,e,o,i){let n,a=document.createElement(t);return a.className=e,void 0!==i&&(n=o.children[i]),n?o.insertBefore(a,n):o.appendChild(a),a},_show:function(t){this._mapMenuVisible&&this._hide();let e=(this._clickEvent=t).originalEvent.target;if(e.closest("fieldset")){if(e=e.closest("fieldset"),e=("mapml-layer-extent"===e.className?e.closest("fieldset").parentNode.parentNode.parentNode:e).querySelector("span"),!e.layer.validProjection)return;this._layerClicked=e,this._showAtPoint(t.containerPoint,t,this._layerMenu)}else(e.classList.contains("leaflet-container")||e.classList.contains("mapml-debug-extent")||"path"===e.tagName)&&(this._layerClicked=void 0,this._showAtPoint(t.containerPoint,t,this._container));0!==t.originalEvent.button&&-1!==t.originalEvent.button||(this._keyboardEvent=!0,this._layerClicked?(t=document.activeElement,this._elementInFocus=t.shadowRoot.activeElement,this._layerMenuTabs=1,this._layerMenu.firstChild.focus()):this._container.firstChild.focus())},_showAtPoint:function(t,e,o){var i;this._items.length&&(i=L.extend(e||{},{contextmenu:this}),this._showLocation={containerPoint:t},e&&e.relatedTarget&&(this._showLocation.relatedTarget=e.relatedTarget),this._setPosition(t,o),this._mapMenuVisible||(o.removeAttribute("hidden"),this._mapMenuVisible=!0),this._map.fire("contextmenu.show",i))},_hide:function(){this._mapMenuVisible&&(this._mapMenuVisible=!1,this._container.setAttribute("hidden",""),this._coordMenu.setAttribute("hidden",""),this._layerMenu.setAttribute("hidden",""),this._map.fire("contextmenu.hide",{contextmenu:this}),setTimeout(()=>this._map._container.focus(),0))},_setPosition:function(t,e){var o,i=this._map.getSize(),n=this._getElementSize(e);this._map.options.contextmenuAnchor&&(o=L.point(this._map.options.contextmenuAnchor),t=t.add(o)),(e._leaflet_pos=t).x+n.x>i.x?(e.style.left="auto",e.style.right=Math.min(Math.max(i.x-t.x,0),i.x-n.x-1)+"px"):(e.style.left=Math.max(t.x,0)+"px",e.style.right="auto"),t.y+n.y>i.y?(e.style.top="auto",e.style.bottom=Math.min(Math.max(i.y-t.y,0),i.y-n.y-1)+"px"):(e.style.top=Math.max(t.y,0)+"px",e.style.bottom="auto")},_getElementSize:function(t){let e=this._size;return e&&!this._sizeChanged||(e={},t.style.left="-999999px",t.style.right="auto",e.x=t.offsetWidth,e.y=t.offsetHeight,t.style.left="auto",this._sizeChanged=!1),e},_focusOnLayerControl:function(){this._mapMenuVisible=!1,delete this._layerMenuTabs,this._layerMenu.setAttribute("hidden",""),(this._elementInFocus||this._layerClicked.parentElement.firstChild).focus(),delete this._elementInFocus},_onKeyDown:function(t){if(this._mapMenuVisible){var e=t.keyCode,o=t.path||t.composedPath();switch(13===e&&t.preventDefault(),!this._layerMenuTabs||9!==e&&27!==e?16===e||9===e||!this._layerClicked&&67===e||o[0].innerText===M.options.locale.cmCopyCoords+" (C)"||this._hide():(t.shiftKey?--this._layerMenuTabs:this._layerMenuTabs+=1,0!==this._layerMenuTabs&&4!==this._layerMenuTabs&&27!==e||(L.DomEvent.stop(t),this._focusOnLayerControl())),e){case 13:case 32:this._map._container.parentNode.activeElement.parentNode.classList.contains("mapml-contextmenu")&&this._map._container.parentNode.activeElement.click();break;case 66:this._goBack(t);break;case 67:this._layerClicked?this._copyLayerExtent(t):this._copyCoords({latlng:this._map.getCenter()});break;case 68:this._toggleDebug(t);break;case 77:this._copyMapML(t);break;case 70:this._goForward(t);break;case 76:this._layerClicked&&this._copyLayer(t);break;case 80:this._pasteLayer(t);break;case 82:this._reload(t);break;case 84:this._toggleControls(t);break;case 86:this._viewSource(t);break;case 90:this._layerClicked&&this._zoomToLayer(t)}}},_showCoordMenu:function(t){let e=this._map.getSize(),o=this._clickEvent,i=this._coordMenu,n=this._items[5].el.el;n.setAttribute("aria-expanded","true"),i.removeAttribute("hidden"),o.containerPoint.x+160+80>e.x?(i.style.left="auto",i.style.right="160px"):(i.style.left="160px",i.style.right="auto"),o.containerPoint.y+160>e.y?(i.style.top="auto",i.style.bottom="20px"):(i.style.top="100px",i.style.bottom="auto"),this._keyboardEvent&&i.firstChild.focus()},_hideCoordMenu:function(t){if(!t.srcElement.parentElement.classList.contains("mapml-submenu")&&t.srcElement.innerText!==M.options.locale.cmCopyCoords+" (C)"){let t=this._coordMenu,e=this._items[5].el.el;e.setAttribute("aria-expanded","false"),t.setAttribute("hidden","")}},_onItemMouseOver:function(t){L.DomUtil.addClass(t.target||t.srcElement,"over"),t.srcElement.innerText===M.options.locale.cmCopyCoords+" (C)"&&this._showCoordMenu(t)},_onItemMouseOut:function(t){L.DomUtil.removeClass(t.target||t.srcElement,"over"),this._hideCoordMenu(t)}}),N=function(e,o){if(!e||!o)return{};let i=[],n=[],a=[],s=[],r=o.options.crs.options.crs.tile.bounds.max.y;for(let t=0;t<o.options.crs.options.resolutions.length;t++){var l=o.options.crs.scale(t),m=o.options.crs.transformation.transform(e.min,l),l=o.options.crs.transformation.transform(e.max,l);i.push({horizontal:m.x,vertical:l.y}),n.push({horizontal:l.x,vertical:m.y}),a.push({horizontal:i[t].horizontal/r,vertical:i[t].vertical/r}),s.push({horizontal:n[t].horizontal/r,vertical:n[t].vertical/r})}var t=o.options.crs.unproject(e.min),p=o.options.crs.unproject(e.max);let u={horizontal:t.lng,vertical:p.lat},c={horizontal:p.lng,vertical:t.lat},h={horizontal:e.min.x,vertical:e.max.y},d={horizontal:e.max.x,vertical:e.min.y};return{topLeft:{tcrs:i,tilematrix:a,gcrs:u,pcrs:h},bottomRight:{tcrs:n,tilematrix:s,gcrs:c,pcrs:d},projection:o.options.projection}},D=function(p){if(p){let e=p.values,t=p.projection||P,o=0,i=d,n=this[t].options.crs.tilematrix.bounds(0),a=this[t].options.resolutions.length-1,s=0,r=a,l=!1,m=0;for(let t=0;t<e.length;t++)switch(e[t].getAttribute("type")){case"zoom":s=+(e[t].hasAttribute("min")&&!isNaN(+e[t].getAttribute("min"))?e[t].getAttribute("min"):0),r=+(e[t].hasAttribute("max")&&!isNaN(+e[t].getAttribute("max"))?e[t].getAttribute("max"):a),o=+e[t].getAttribute("value");break;case"location":if(!e[t].getAttribute("max")||!e[t].getAttribute("min"))continue;var u=+e[t].getAttribute("max"),c=+e[t].getAttribute("min");switch(e[t].getAttribute("axis").toLowerCase()){case"x":case"longitude":case"column":case"easting":i=M.axisToCS(e[t].getAttribute("axis").toLowerCase()),n.min.x=c,n.max.x=u,m++;break;case"y":case"latitude":case"row":case"northing":i=M.axisToCS(e[t].getAttribute("axis").toLowerCase()),n.min.y=c,n.max.y=u,m++}}2<=m&&(l=!0);var h={minZoom:p.zoomBounds?.min&&!isNaN(+p.zoomBounds.min)?+p.zoomBounds.min:0,maxZoom:p.zoomBounds?.max&&!isNaN(+p.zoomBounds.max)?+p.zoomBounds.max:a,minNativeZoom:s,maxNativeZoom:r};return n=!l&&p.extentPCRSFallback&&p.extentPCRSFallback.bounds?p.extentPCRSFallback.bounds:l?this.boundsToPCRSBounds(n,o,t,i):this[t].options.crs.pcrs.bounds,{zoomBounds:h,bounds:n}}},q=function(t){try{switch(t.toLowerCase()){case"row":case"column":return"TILEMATRIX";case"i":case"j":return["MAP","TILE"];case"x":case"y":return"TCRS";case"latitude":case"longitude":return"GCRS";case"northing":case"easting":return"PCRS";default:return d}}catch(t){return}},O=function(t){try{switch(t.toLowerCase()){case"tilematrix":return["column","row"];case"map":case"tile":return["i","j"];case"tcrs":return["x","y"];case"gcrs":return["longitude","latitude"];case"pcrs":return["easting","northing"]}}catch(t){return}},R=function(t){try{switch(t.toLowerCase()){case"i":case"column":case"longitude":case"x":case"easting":return"x";case"row":case"j":case"latitude":case"y":case"northing":return"y";default:return}}catch(t){return}},U=function(t,e,o,i){if(t&&(e||0===e)&&Number.isFinite(+e)&&o&&i)switch(o="string"==typeof o?M[o]:o,i.toUpperCase()){case"PCRS":return t;case"TCRS":case"TILEMATRIX":var n=o.transformation.transform(t.min,o.scale(+e)),a=o.transformation.transform(t.max,o.scale(+e));if("TCRS"===i.toUpperCase())return L.bounds(n,a);var s=o.options.crs.tile.bounds.max.x;return L.bounds(L.point(n.x/s,n.y/s),L.point(a.x/s,a.y/s));case"GCRS":a=o.unproject(t.min),s=o.unproject(t.max);return L.bounds(L.point(a.lng,a.lat),L.point(s.lng,s.lat));default:return}},Z=function(t,e,o,i){if(t&&(e||0===e)&&Number.isFinite(+e)&&i&&o){var n=(o="string"==typeof o?M[o]:o).options.crs.tile.bounds.max.x;switch(i.toUpperCase()){case"TILEMATRIX":return M.pixelToPCRSPoint(L.point(t.x*n,t.y*n),e,o);case"PCRS":return t;case"TCRS":return M.pixelToPCRSPoint(t,e,o);case"GCRS":return o.project(L.latLng(t.y,t.x));default:return}}},j=function(t,e,o){if(t&&(e||0===e)&&Number.isFinite(+e)&&o)return(o="string"==typeof o?M[o]:o).transformation.untransform(t,o.scale(e))},H=function(t,e,o,i){if(t&&t.max&&t.min&&(e||0===e)&&Number.isFinite(+e)&&o&&i)return o="string"==typeof o?M[o]:o,L.bounds(M.pointToPCRSPoint(t.min,e,o,i),M.pointToPCRSPoint(t.max,e,o,i))},G=function(t,e,o){if(t&&t.max&&t.min&&(e||0===e)&&Number.isFinite(+e)&&o)return o="string"==typeof o?M[o]:o,L.bounds(M.pixelToPCRSPoint(t.min,e,o),M.pixelToPCRSPoint(t.max,e,o))},V=function(t){if(!t||t instanceof Object)return{};let e=t.split(/\s+/).join(""),o={},i=e.split(",");for(let t=0;t<i.length;t++){var n=i[t].split("=");2===n.length&&(o[n[0]]=n[1])}return""!==o&&1===i[0].split("=").length&&(o.content=i[0]),o},$=function(t){for(var e=1,o=[],i=t.split(",");e<i.length;e+=2)o.push([parseInt(i[e-1]),parseInt(i[e])]);return o},W=function(t,e,o){if(o instanceof Element&&t&&t.querySelector("map-link[rel=stylesheet],map-style")){if(e instanceof Element)e=e.getAttribute("href")?e.getAttribute("href"):document.URL;else if(!e||""===e||e instanceof Object)return;for(var i,n,a=[],s=t.querySelectorAll("map-link[rel=stylesheet],map-style"),r=0;r<s.length;r++)"MAP-LINK"===s[r].nodeName.toUpperCase()?(i=s[r].hasAttribute("href")?new URL(s[r].getAttribute("href"),e).href:null)&&(o.querySelector("link[href='"+i+"']")||((n=document.createElement("link")).setAttribute("href",i),n.setAttribute("rel","stylesheet"),a.push(n))):((n=document.createElement("style")).textContent=s[r].textContent,a.push(n));for(var l=a.length-1;0<=l;l--)o.insertAdjacentElement("afterbegin",a[l])}},K=function(t,e,o){var i=[];t.split(/\s+/gim).forEach(M.parseNumber,i),this.push(i)},Y=function(t,e,o){this.push(parseFloat(t))},Q=function(i,t){let n,o=!1,a,s=t._map,r;if("text/html"===i.type&&"_blank"!==i.target)i.target="_top";else if("text/html"!==i.type&&i.url.includes("#")){let t=i.url.split("#"),e=t[1].split(",");n={z:e[0]||0,lng:e[1]||0,lat:e[2]||0},o=!t[0],["/",".","#"].includes(i.url[0])&&(i.target="_self")}if(o)n&&!i.inPlace&&o&&(t._map.options.mapEl.zoomTo(+n.lat,+n.lng,+n.z),r&&(a.opacity=r));else{let o=!1;switch(a=document.createElement("layer-"),a.setAttribute("src",i.url),a.setAttribute("checked",""),i.target){case"_blank":"text/html"===i.type?window.open(i.url):(s.options.mapEl.appendChild(a),o=!0);break;case"_parent":for(var e of s.options.mapEl.querySelectorAll("layer-"))e._layer!==t&&s.options.mapEl.removeChild(e);s.options.mapEl.appendChild(a),s.options.mapEl.removeChild(t._layerEl),o=!0;break;case"_top":window.location.href=i.url;break;default:r=t._layerEl.opacity,t._layerEl.insertAdjacentElement("beforebegin",a),s.options.mapEl.removeChild(t._layerEl),o=!0}!i.inPlace&&o&&L.DomEvent.on(a,"extentload",function t(e){o&&["_parent","_self"].includes(i.target)&&1===a.parentElement.querySelectorAll("layer-").length&&(a.parentElement.projection=a._layer.getProjection()),a.extent&&(n?a.parentElement.zoomTo(+n.lat,+n.lng,+n.z):a.focus(),L.DomEvent.off(a,"extentload",t)),r&&(a.opacity=r),s.getContainer().focus()})}},X=function(t){var e=t._map.project(t._map.getCenter()),t=t._map.options.crs.options.crs.tile.bounds.max.y;return[Math.trunc(e.x/t),Math.trunc(e.y/t)]},J=function(i){let t=document.createElement("table"),e=t.createTHead(),o=e.insertRow(),n=document.createElement("th"),a=document.createElement("th");n.appendChild(document.createTextNode("Property name")),a.appendChild(document.createTextNode("Property value")),n.setAttribute("role","columnheader"),a.setAttribute("role","columnheader"),n.setAttribute("scope","col"),a.setAttribute("scope","col"),o.appendChild(n),o.appendChild(a);let s=t.createTBody();for(var r in i)if(i.hasOwnProperty(r)){let t=s.insertRow(),e=document.createElement("th"),o=document.createElement("td");e.appendChild(document.createTextNode(r)),o.appendChild(document.createTextNode(i[r])),e.setAttribute("scope","row"),o.setAttribute("itemprop",r),t.appendChild(e),t.appendChild(o)}return t},tt=function(t,e,o){return t==={}||(t[0]=Math.min(e,t[0]),t[1]=Math.min(o,t[1]),t[2]=Math.max(e,t[2]),t[3]=Math.max(o,t[3])),t},et=function(m,p={},u=null,c={}){p=Object.assign({},{label:null,projection:"OSMTILE",caption:null,properties:null,geometryFunction:null},p);var h=(m="string"==typeof m?JSON.parse(m):m).type.toUpperCase();let d="",t=!1,e=new DOMParser;null===u&&(m.bbox||(t=!0),a="<layer- label='' checked><map-meta name='projection' content='"+p.projection+"'></map-meta><map-meta name='cs' content='gcrs'></map-meta></layer->",u=e.parseFromString(a,"text/html"),null!==p.label?u.querySelector("layer-").setAttribute("label",p.label):m.name?u.querySelector("layer-").setAttribute("label",m.name):m.title?u.querySelector("layer-").setAttribute("label",m.title):u.querySelector("layer-").setAttribute("label",M.options.locale.dfLayer));let _="<map-point></map-point>";_=e.parseFromString("<map-point></map-point>","text/html");let y="<map-multipoint><map-coordinates></map-coordinates></map-multipoint>";y=e.parseFromString("<map-multipoint><map-coordinates></map-coordinates></map-multipoint>","text/html");let g="<map-linestring><map-coordinates></map-coordinates></map-linestring>";g=e.parseFromString("<map-linestring><map-coordinates></map-coordinates></map-linestring>","text/html");let f="<map-multilinestring></map-multilinestring>";f=e.parseFromString("<map-multilinestring></map-multilinestring>","text/html");let x="<map-polygon></map-polygon>";x=e.parseFromString("<map-polygon></map-polygon>","text/html");let b="<map-multipolygon></map-multipolygon>";b=e.parseFromString("<map-multipolygon></map-multipolygon>","text/html");let L="<map-geometrycollection></map-geometrycollection>";L=e.parseFromString("<map-geometrycollection></map-geometrycollection>","text/html");let n="<map-feature><map-featurecaption></map-featurecaption><map-geometry></map-geometry><map-properties></map-properties></map-feature>";n=e.parseFromString("<map-feature><map-featurecaption></map-featurecaption><map-geometry></map-geometry><map-properties></map-properties></map-feature>","text/html");let v="<map-coordinates></map-coordinates>";if(v=e.parseFromString("<map-coordinates></map-coordinates>","text/html"),"FEATURECOLLECTION"===h){m.bbox?u.querySelector("layer-").insertAdjacentHTML("afterbegin","<map-meta name='extent' content='top-left-longitude="+m.bbox[0]+", top-left-latitude="+m.bbox[1]+", bottom-right-longitude="+m.bbox[2]+",bottom-right-latitude="+m.bbox[3]+"'></map-meta>"):c=[1/0,1/0,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];var o=m.features;for(let t=0;t<o.length;t++)M.geojson2mapml(o[t],p,u,c)}else if("FEATURE"===h){let t=n.cloneNode(!0),e=t.querySelector("map-feature"),o=u.querySelector("layer-").getAttribute("label");"function"==typeof p.caption?o=p.caption(m):"string"==typeof p.caption?(o=m.properties[p.caption],void 0===o&&(o=p.caption)):m.id&&(o=m.id),e.querySelector("map-featurecaption").innerHTML=o;let i;"function"==typeof p.properties?(i=p.properties(m),i instanceof Element||(i=!1,console.error("options.properties function returns a string instead of an HTMLElement."))):i="string"==typeof p.properties?(e.querySelector("map-properties").insertAdjacentHTML("beforeend",p.properties),!1):p.properties instanceof HTMLElement?p.properties:M.properties2Table(m.properties),i&&e.querySelector("map-properties").appendChild(i);var a=M.geojson2mapml(m.geometry,p,u,c);"function"==typeof p.geometryFunction?e.querySelector("map-geometry").appendChild(p.geometryFunction(a,m)):e.querySelector("map-geometry").appendChild(a),u.querySelector("layer-").appendChild(e)}else if(["POINT","LINESTRING","POLYGON","MULTIPOINT","MULTILINESTRING","MULTIPOLYGON","GEOMETRYCOLLECTION"].includes(h))switch(h){case"POINT":c=M.updateExtent(c,m.coordinates[0],m.coordinates[1]),d=m.coordinates[0]+" "+m.coordinates[1];let t=_.cloneNode(!0);t=t.querySelector("map-point");let e=v.cloneNode(!0);return e=e.querySelector("map-coordinates"),e.innerHTML=d,t.appendChild(e),t;case"LINESTRING":let o=g.cloneNode(!0),i=o.querySelector("map-coordinates");d="";for(let t=0;t<m.coordinates.length;t++)c=M.updateExtent(c,m.coordinates[t][0],m.coordinates[t][1]),d=d+m.coordinates[t][0]+" "+m.coordinates[t][1]+" ";return i.innerHTML=d,o.querySelector("map-linestring");case"POLYGON":let n=x.cloneNode(!0);n=n.querySelector("map-polygon");for(let o=0;o<m.coordinates.length;o++){let e="",t=v.cloneNode(!0);t=t.querySelector("map-coordinates");for(let t=0;t<m.coordinates[o].length;t++)c=M.updateExtent(c,m.coordinates[o][t][0],m.coordinates[o][t][1]),e=e+m.coordinates[o][t][0]+" "+m.coordinates[o][t][1]+" ";t.innerHTML=e,n.appendChild(t)}return n;case"MULTIPOINT":d="";let a=y.cloneNode(!0);a=a.querySelector("map-multipoint");for(let t=0;t<m.coordinates.length;t++)c=M.updateExtent(c,m.coordinates[t][0],m.coordinates[t][1]),d=d+m.coordinates[t][0]+" "+m.coordinates[t][1]+" ";return a.querySelector("map-coordinates").innerHTML=d,a;case"MULTILINESTRING":let s=f.cloneNode(!0);s=s.querySelector("map-multilinestring");for(let o=0;o<m.coordinates.length;o++){let e="",t=v.cloneNode(!0);t=t.querySelector("map-coordinates");for(let t=0;t<m.coordinates[o].length;t++)c=M.updateExtent(c,m.coordinates[o][t][0],m.coordinates[o][t][1]),e=e+m.coordinates[o][t][0]+" "+m.coordinates[o][t][1]+" ";t.innerHTML=e,s.appendChild(t)}return s;case"MULTIPOLYGON":let r=b.cloneNode(!0);r=r.querySelector("map-multiPolygon");for(let n=0;n<m.coordinates.length;n++){let i=x.cloneNode(!0);i=i.querySelector("map-polygon");for(let o=0;o<m.coordinates[n].length;o++){let e="",t=v.cloneNode(!0);t=t.querySelector("map-coordinates");for(let t=0;t<m.coordinates[n][o].length;t++)c=M.updateExtent(c,m.coordinates[n][o][t][0],m.coordinates[n][o][t][1]),e=e+m.coordinates[n][o][t][0]+" "+m.coordinates[n][o][t][1]+" ";t.innerHTML=e,i.appendChild(t)}r.appendChild(i)}return r;case"GEOMETRYCOLLECTION":let l=L.cloneNode(!0);l=l.querySelector("map-geometrycollection");for(let t=0;t<m.geometries.length;t++){var E=M.geojson2mapml(m.geometries[t],p,u,c);l.appendChild(E)}return l}return t&&u.querySelector("layer-").insertAdjacentHTML("afterbegin","<map-meta name='extent' content='top-left-longitude="+c[0]+", top-left-latitude="+c[1]+", bottom-right-longitude="+c[2]+",bottom-right-latitude="+c[3]+"'></map-meta>"),u.querySelector("layer-")},ot=function(e){let o=[];e=e.filter(t=>!/[^\d.-]/g.test(t)).filter(t=>t);for(let t=0;t<e.length;t+=2)o.push(e.slice(t,t+2).map(Number));return o},it=function(t){null!==t.querySelector("thead")&&t.querySelector("thead").remove();let e={};return t.querySelectorAll("tr").forEach(t=>{t=t.querySelectorAll("th, td");e[t[0].innerHTML]=t[1].innerHTML}),e},nt=function(t,n,a,s){let r=t.nodeName,l={},m;switch(r.toUpperCase()){case"MAP-POINT":var p;l.type="Point",s?(p=proj4.transform(n,a,t.querySelector("map-coordinates").innerHTML.split(/ [<>\ ]/g).map(Number)),l.coordinates=[p.x,p.y]):l.coordinates=t.querySelector("map-coordinates").innerHTML.split(/[<>\ ]/g).map(Number);break;case"MAP-LINESTRING":l.type="LineString",m=t.querySelector("map-coordinates").innerHTML.split(/[<>\ ]/g),m=M.breakArray(m),s&&(m=M.pcrsToGcrs(m,n,a)),l.coordinates=m;break;case"MAP-POLYGON":l.type="Polygon",l.coordinates=[];let e=0;t.querySelectorAll("map-coordinates").forEach(t=>{t=t.innerHTML.split(/[<>\ ]/g),t=M.breakArray(t),s&&(t=M.pcrsToGcrs(t,n,a)),l.coordinates[e]=t,e++});break;case"MAP-MULTIPOINT":l.type="MultiPoint",m=M.breakArray(t.querySelector("map-coordinates").innerHTML.split(/[<>\ ]/g)),s&&(m=M.pcrsToGcrs(m,n,a)),l.coordinates=m;break;case"MAP-MULTILINESTRING":l.type="MultiLineString",l.coordinates=[];let o=0;t.querySelectorAll("map-coordinates").forEach(t=>{t=t.innerHTML.split(/[<>\ ]/g),t=M.breakArray(t),s&&(t=M.pcrsToGcrs(t,n,a)),l.coordinates[o]=t,o++});break;case"MAP-MULTIPOLYGON":l.type="MultiPolygon",l.coordinates=[];let i=0;t.querySelectorAll("map-polygon").forEach(t=>{let e=0;l.coordinates.push([]),t.querySelectorAll("map-coordinates").forEach(t=>{t=t.innerHTML.split(/[<>\ ]/g),t=M.breakArray(t),s&&(t=M.pcrsToGcrs(t,n,a)),l.coordinates[i].push([]),l.coordinates[i][e]=t,e++}),i++})}return l},at=function(e,o,i){let n=[];for(let t=0;t<e.length;t++){var a=[(a=proj4.transform(o,i,e[t])).x,a.y];n.push(a)}return n},st=function(t,n={}){n=Object.assign({},{propertyFunction:null,transform:!0},n);let a={type:"FeatureCollection"};a.title=t.getAttribute("label"),a.features=[];let s=null,r=null;n.transform&&(s=new proj4.Proj(t.parentElement._map.options.crs.code),r=new proj4.Proj("EPSG:4326"),"EPSG:3857"!==t.parentElement._map.options.crs.code&&"EPSG:4326"!==t.parentElement._map.options.crs.code||(n.transform=!1));let e=t.querySelectorAll("map-meta");e.forEach(e=>{if("extent"===e.getAttribute("name")){let t=e.getAttribute("content"),o=t.split(","),i={};for(let e=0;e<o.length;e++){let t=o[e].split("=");t[0]=t[0].trim(),t[1]=parseFloat(t[1]),i[t[0]]=t[1]}a.bbox=[i["top-left-longitude"],i["top-left-latitude"],i["bottom-right-longitude"],i["bottom-right-latitude"]]}});let o=t.querySelectorAll("map-feature"),l=0;return o.forEach(t=>{var e;a.features[l]={type:"Feature"},a.features[l].geometry={},a.features[l].properties={},"function"==typeof n.propertyFunction?(e=n.propertyFunction(t.querySelector("map-properties")),a.features[l].properties=e):null!==t.querySelector("map-properties").querySelector("table")?(e=M.table2properties(t.querySelector("map-properties").querySelector("table")),a.features[l].properties=e):a.features[l].properties={prop0:t.querySelector("map-properties").innerHTML.replace(/(<([^>]+)>)/gi,"")};let o=t.querySelector("map-geometry"),i=o.children[0].nodeName;"MAP-GEOMETRYCOLLECTION"!==i.toUpperCase()?a.features[l].geometry=M.geometry2geojson(o.children[0],s,r,n.transform):(a.features[l].geometry.type="GeometryCollection",a.features[l].geometry.geometries=[],t=o.querySelector("map-geometrycollection").children,Array.from(t).forEach(t=>{t=M.geometry2geojson(t,s,r,n.transform),a.features[l].geometry.geometries.push(t)})),l++}),a},rt=L.Control.extend({options:{position:"topleft"},onAdd:function(t){var e=L.DomUtil.create("div","mapml-reload-button leaflet-bar");let o=L.DomUtil.create("button","mapml-reload-button",e);return o.innerHTML="<span aria-hidden='true'>&#x021BA</span>",o.title=M.options.locale.cmReload,o.setAttribute("type","button"),o.classList.add("mapml-button"),o.setAttribute("aria-label","Reload"),L.DomEvent.disableClickPropagation(o),L.DomEvent.on(o,"click",L.DomEvent.stop),L.DomEvent.on(o,"click",this._goReload,this),this._reloadButton=o,this._updateDisabled(),t.on("moveend",this._updateDisabled,this),e},onRemove:function(t){t.off("moveend",this._updateDisabled,this)},disable:function(){return this._disabled=!0,this._updateDisabled(),this},enable:function(){return this._disabled=!1,this._updateDisabled(),this},_goReload:function(t){!this._disabled&&1<this._map.options.mapEl._history.length&&this._map.options.mapEl.reload()},_updateDisabled:function(){setTimeout(()=>{L.DomUtil.removeClass(this._reloadButton,"leaflet-disabled"),this._reloadButton.setAttribute("aria-disabled","false"),this._map&&(this._disabled||this._map.options.mapEl._history.length<=1)&&(L.DomUtil.addClass(this._reloadButton,"leaflet-disabled"),this._reloadButton.setAttribute("aria-disabled","true"))},0)}}),lt=L.Control.extend({options:{position:"topleft",title:{false:"View fullscreen",true:"Exit fullscreen"}},onAdd:function(t){var e=L.DomUtil.create("div","leaflet-control-fullscreen leaflet-bar leaflet-control");return this.link=L.DomUtil.create("a","leaflet-control-fullscreen-button leaflet-bar-part",e),this.link.href="#",this.link.setAttribute("role","button"),this._map=t,this._map.on("fullscreenchange",this._toggleTitle,this),this._toggleTitle(),L.DomEvent.on(this.link,"click",this._click,this),e},onRemove:function(t){t.off("fullscreenchange",this._toggleTitle,this)},_click:function(t){L.DomEvent.stopPropagation(t),L.DomEvent.preventDefault(t),this._map.toggleFullscreen(this.options)},_toggleTitle:function(){this.link.title=this.options.title[this._map.isFullscreen()]}});L.Map.include({isFullscreen:function(){return this._isFullscreen||!1},toggleFullscreen:function(t){var e=this.getContainer().getRootNode().host,e="DIV"===e.nodeName?e.parentElement:e;this.isFullscreen()?t&&t.pseudoFullscreen?this._disablePseudoFullscreen(e):document.exitFullscreen?document.exitFullscreen():document.mozCancelFullScreen?document.mozCancelFullScreen():document.webkitCancelFullScreen?document.webkitCancelFullScreen():document.msExitFullscreen?document.msExitFullscreen():this._disablePseudoFullscreen(e):t&&t.pseudoFullscreen?this._enablePseudoFullscreen(e):e.requestFullscreen?e.requestFullscreen():e.mozRequestFullScreen?e.mozRequestFullScreen():e.webkitRequestFullscreen?e.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):e.msRequestFullscreen?e.msRequestFullscreen():this._enablePseudoFullscreen(e)},_enablePseudoFullscreen:function(t){L.DomUtil.addClass(t,"leaflet-pseudo-fullscreen"),this._setFullscreen(!0),this.fire("fullscreenchange")},_disablePseudoFullscreen:function(t){L.DomUtil.removeClass(t,"leaflet-pseudo-fullscreen"),this._setFullscreen(!1),this.fire("fullscreenchange")},_setFullscreen:function(t){this._isFullscreen=t;var e=this.getContainer().getRootNode().host;t?L.DomUtil.addClass(e,"mapml-fullscreen-on"):L.DomUtil.removeClass(e,"mapml-fullscreen-on"),this.invalidateSize()},_onFullscreenChange:function(t){var e=document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement,o=this.getContainer().getRootNode().host,o="DIV"===o.nodeName?o.parentElement:o;e!==o||this._isFullscreen?e!==o&&this._isFullscreen&&(this._setFullscreen(!1),this.fire("fullscreenchange")):(this._setFullscreen(!0),this.fire("fullscreenchange"))}}),L.Map.mergeOptions({fullscreenControl:!1}),L.Map.addInitHook(function(){var t,e;this.options.fullscreenControl&&(this.fullscreenControl=new lt(this.options.fullscreenControl),this.addControl(this.fullscreenControl)),"onfullscreenchange"in document?t="fullscreenchange":"onmozfullscreenchange"in document?t="mozfullscreenchange":"onwebkitfullscreenchange"in document?t="webkitfullscreenchange":"onmsfullscreenchange"in document&&(t="MSFullscreenChange"),t&&(e=L.bind(this._onFullscreenChange,this),this.whenReady(function(){L.DomEvent.on(document,t,e)}),this.on("unload",function(){L.DomEvent.off(document,t,e)}))});function mt(t){return new lt(t)}function pt(t){t._attributionControl=t._map.attributionControl.setPrefix(`<button onclick="this.closest('.leaflet-container').querySelector('.shortcuts-dialog').showModal()" class="shortcuts-button mapml-button">${M.options.locale.kbdShortcuts}</button> | <a href="https://www.w3.org/community/maps4html/" title="W3C Maps for HTML Community Group">Maps4HTML</a> | <img src="data:image/svg+xml;base64,PHN2ZyBhcmlhLWhpZGRlbj0idHJ1ZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iMTIiIGhlaWdodD0iOCI+PHBhdGggZmlsbD0iIzRDN0JFMSIgZD0iTTAgMGgxMnY0SDB6Ii8+PHBhdGggZmlsbD0iI0ZGRDUwMCIgZD0iTTAgNGgxMnYzSDB6Ii8+PHBhdGggZmlsbD0iI0UwQkMwMCIgZD0iTTAgN2gxMnYxSDB6Ii8+PC9zdmc+" style="padding-right: 0.3em;" alt="Slava Ukraini"> <a href="https://leafletjs.com" title="A JS library for interactive maps">Leaflet</a>`);let e=document.createElement("dialog");e.setAttribute("class","shortcuts-dialog"),e.setAttribute("autofocus",""),e.onclick=function(t){t.stopPropagation()},e.innerHTML=`<b>${M.options.locale.kbdShortcuts} </b><button aria-label="Close" onclick='this.parentElement.close()'>X</button>`+`<ul><b>${M.options.locale.kbdMovement}</b><li><kbd>&#8593</kbd> ${M.options.locale.kbdPanUp}</li><li><kbd>&#8595</kbd> ${M.options.locale.kbdPanDown}</li><li><kbd>&#8592</kbd> ${M.options.locale.kbdPanLeft}</li><li><kbd>&#8594</kbd> ${M.options.locale.kbdPanRight}</li><li><kbd>+</kbd> ${M.options.locale.btnZoomIn}</li><li><kbd>-</kbd> ${M.options.locale.btnZoomOut}</li><li><kbd>shift</kbd> + <kbd>&#8592/&#8593/&#8594/&#8595</kbd> 3x ${M.options.locale.kbdPanIncrement}</li><li><kbd>ctrl</kbd> + <kbd>&#8592/&#8593/&#8594/&#8595</kbd> 0.2x ${M.options.locale.kbdPanIncrement}</li><li><kbd>shift</kbd> + <kbd>+/-</kbd> ${M.options.locale.kbdZoom}</li></ul>`+`<ul><b>${M.options.locale.kbdFeature}</b><li><kbd>&#8592/&#8593</kbd> ${M.options.locale.kbdPrevFeature}</li><li><kbd>&#8594/&#8595</kbd> ${M.options.locale.kbdNextFeature}</li></ul>`,t._container.appendChild(e),t._attributionControl.getContainer().setAttribute("role","group"),t._attributionControl.getContainer().setAttribute("aria-label","Map data attribution")}function ut(t){return new _t(t)}function ct(t,e){return new yt(t,e)}function ht(t){return new gt(t)}function dt(t,e){return new ft(t,e)}var _t=L.Layer.extend({onAdd:function(t){this._container=L.DomUtil.create("div","mapml-crosshair",t._container),this._container.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" viewBox="0 0 100 100"><g stroke="#fff" stroke-linecap="round" stroke-linejoin="round"><circle cx="50.028" cy="50.219" r="3.923" stroke-width="2" color="currentColor" overflow="visible"/><path stroke-width="3" d="M4.973 54.424h31.768a4.204 4.204 0 1 0 0-8.409H4.973A4.203 4.203 0 0 0 .77 50.22a4.203 4.203 0 0 0 4.204 4.205z" color="currentColor" overflow="visible"/><path stroke-width="3" d="M54.232 5.165a4.204 4.204 0 1 0-8.408 0v31.767a4.204 4.204 0 1 0 8.408 0V5.165z"/><path stroke-width="3" d="M99.288 50.22a4.204 4.204 0 0 0-4.204-4.205H63.317a4.204 4.204 0 1 0 0 8.409h31.767a4.205 4.205 0 0 0 4.204-4.205zM45.823 95.274a4.204 4.204 0 1 0 8.409 0V63.506a4.204 4.204 0 1 0-8.409 0v31.768z" color="currentColor" overflow="visible"/></g></svg>',t.isFocused=!1,this._isQueryable=!1,t.on("layerchange layeradd layerremove overlayremove",this._toggleEvents,this),t.on("popupopen",this._isMapFocused,this),L.DomEvent.on(t._container,"keydown keyup mousedown",this._isMapFocused,this),this._addOrRemoveCrosshair()},onRemove:function(t){t.off("layerchange layeradd layerremove overlayremove",this._toggleEvents),t.off("popupopen",this._isMapFocused),L.DomEvent.off(t._container,"keydown keyup mousedown",this._isMapFocused)},_toggleEvents:function(){this._hasQueryableLayer()?this._map.on("viewreset move moveend",this._addOrRemoveCrosshair,this):this._map.off("viewreset move moveend",this._addOrRemoveCrosshair,this),this._addOrRemoveCrosshair()},_addOrRemoveCrosshair:function(t){this._hasQueryableLayer()?this._container.removeAttribute("hidden"):this._container.setAttribute("hidden","")},_addOrRemoveMapOutline:function(t){var e=this._map._container;this._map.isFocused&&!this._outline?this._outline=L.DomUtil.create("div","mapml-outline",e):!this._map.isFocused&&this._outline&&(L.DomUtil.remove(this._outline),delete this._outline)},_hasQueryableLayer:function(){var t=this._map.options.mapEl.layers;if(this._map.isFocused)for(var e of t)if(e.checked&&e._layer.queryable)return!0;return!1},_isMapFocused:function(t){var e;this._map._container.parentNode.activeElement?((e=this._map._container.parentNode.activeElement.classList.contains("leaflet-container"))&&["keydown"].includes(t.type)&&t.shiftKey&&9===t.keyCode?this._map.isFocused=!1:this._map.isFocused=e&&["keyup","keydown"].includes(t.type),this._map.isFocused&&this._map.fire("mapkeyboardfocused"),this._addOrRemoveMapOutline(),this._addOrRemoveCrosshair()):this._map.isFocused=!1}}),yt=L.Path.extend({initialize:function(t,e){this.type=t.tagName.toUpperCase(),"MAP-POINT"!==this.type&&"MAP-MULTIPOINT"!==this.type||(e.fillOpacity=1),0<e.wrappers.length&&(e=Object.assign(this._convertWrappers(e.wrappers),e)),L.setOptions(this,e),this.group=this.options.group,this.options.interactive=this.options.link||this.options.properties&&this.options.onEachFeature,this._parts=[],this._markup=t,this.options.zoom=t.getAttribute("zoom")||this.options.nativeZoom,this._convertMarkup(),(t.querySelector("map-span")||t.querySelector("map-a"))&&this._generateOutlinePoints(),this.isClosed=this._isClosed()},attachLinkHandler:function(i,n,a){let s,o=document.createElement("div"),r=document.createElement("p"),l=!1;o.classList.add("mapml-link-preview"),o.appendChild(r),i.classList.add("map-a"),n.visited&&i.classList.add("map-a-visited"),L.DomEvent.on(i,"mousedown",t=>s={x:t.clientX,y:t.clientY},this),L.DomEvent.on(i,"mouseup",o=>{if(0===o.button){let t=!0,e=this.options._leafletLayer._layerEl.nextElementSibling;for(;e&&t;)e.tagName&&"LAYER-"===e.tagName.toUpperCase()&&(t=!(e.checked&&e._layer.queryable)),e=e.nextElementSibling;t&&s&&(L.DomEvent.stop(o),Math.sqrt(Math.pow(s.x-o.clientX,2)+Math.pow(s.y-o.clientY,2))<=5&&(n.visited=!0,i.setAttribute("stroke","#6c00a2"),i.classList.add("map-a-visited"),M.handleLink(n,a)))}},this),L.DomEvent.on(i,"keypress",t=>{L.DomEvent.stop(t),13!==t.keyCode&&32!==t.keyCode||(n.visited=!0,i.setAttribute("stroke","#6c00a2"),i.classList.add("map-a-visited"),M.handleLink(n,a))},this),L.DomEvent.on(i,"mouseenter keyup",t=>{if(t.target===t.currentTarget){l=!0;let t=document.createElement("a"),e=this._map.getContainer().clientWidth;for(t.href=n.url,r.innerHTML=t.href,this._map.getContainer().appendChild(o);r.clientWidth>e/2;)r.innerHTML=r.innerHTML.substring(0,r.innerHTML.length-5)+"...";setTimeout(()=>{l&&(r.innerHTML=t.href)},1e3)}},this),L.DomEvent.on(i,"mouseout keydown mousedown",t=>{t.target===t.currentTarget&&o.parentElement&&(l=!1,this._map.getContainer().removeChild(o))},this),L.DomEvent.on(a._map.getContainer(),"mouseout mouseenter click",t=>{o.parentElement&&(l=!1,this._map.getContainer().removeChild(o))},this)},_project:function(t,e=void 0,o=void 0){let i=t||this._map,n=e||i.getPixelOrigin(),a=void 0===o?i.getZoom():o;for(var s of this._parts){s.pixelRings=this._convertRing(s.rings,i,n,a);for(var r of s.subrings)r.pixelSubrings=this._convertRing([r],i,n,a)}if(this._outline){this.pixelOutline=[];for(var l of this._outline)this.pixelOutline=this.pixelOutline.concat(this._convertRing(l,i,n,a))}},_convertRing:function(t,e,o,i){let n=e.options.crs.scale(i),a=[];for(var s of t){let t=[];for(var r of s.points){r=e.options.crs.transformation.transform(r,n);t.push(L.point(r.x,r.y)._subtract(o).round())}a.push(t)}return a},_update:function(){this._map&&this._renderer._updateFeature(this)},_convertWrappers:function(o){if(o&&0!==o.length){let t="",e={};for(var i of o)if("MAP-A"!==i.tagName.toUpperCase()&&i.className)t+=i.className+" ";else if(!e.link&&i.getAttribute("href")){let t={};t.url=i.getAttribute("href"),i.hasAttribute("target")&&(t.target=i.getAttribute("target")),i.hasAttribute("type")&&(t.type=i.getAttribute("type")),i.hasAttribute("inplace")&&(t.inPlace=!0),e.link=t}return e.className=(t+" "+this.options.className).trim(),e}},_convertMarkup:function(){if(this._markup){var i,e=this._markup.attributes;this.featureAttributes={},this.options.link&&"MAP-A"===this._markup.parentElement.tagName.toUpperCase()&&"MAP-GEOMETRY"!==this._markup.parentElement.parentElement.tagName.toUpperCase()&&(this.featureAttributes.tabindex="0");for(let t=0;t<e.length;t++)this.featureAttributes[e[t].name]=e[t].value;let o=!0;for(i of this._markup.querySelectorAll("map-coordinates")){let t=[],e=[];if(this._coordinateToArrays(i,t,e,this.options.className),o||"MAP-POLYGON"!==this.type)if("MAP-MULTIPOINT"===this.type)for(var n of t[0].points.concat(e))this._parts.push({rings:[{points:[n]}],subrings:[],cls:(`${n.cls||""} `+(this.options.className||"")).trim()});else this._parts.push({rings:t,subrings:e,cls:(`${this.featureAttributes.class||""} `+(this.options.className||"")).trim()});else this._parts[0].rings.push(t[0]),0<e.length&&(this._parts[0].subrings=this._parts[0].subrings.concat(e));o=!1}}},_generateOutlinePoints:function(){if("MAP-MULTIPOINT"!==this.type&&"MAP-POINT"!==this.type&&"MAP-LINESTRING"!==this.type&&"MAP-MULTILINESTRING"!==this.type){this._outline=[];for(var t of this._markup.querySelectorAll("map-coordinates")){let o=t.childNodes,i=0,n=document.createElement("div");o.length;for(let t=0;t<o.length;t++)0===o[t].textContent.trim().length&&o[t].remove();for(var a of o){var s,r=[];if(!a.tagName){let t="",e=((i-1)%o.length+o.length)%o.length;o[e].tagName&&(s=o[e].textContent.trim().split(/\s+/),t+=`${s[s.length-2]} ${s[s.length-1]} `),t+=a.textContent,e=((i+1)%o.length+o.length)%o.length,o[e].tagName&&(a=o[e].textContent.trim().split(/\s+/),t+=`${a[0]} ${a[1]} `),n.innerHTML=t,this._coordinateToArrays(n,r,[],!0,this.featureAttributes.class||this.options.className),this._outline.push(r)}i++}}}},_coordinateToArrays:function(i,t,n,e=!0,a=void 0,s=[]){for(var o of i.children)this._coordinateToArrays(o,t,n,!1,o.getAttribute("class"),s.concat([o]));let r=i.textContent.replace(/(<([^>]+)>)/gi,""),l=r.match(/(\S+\s+\S+)/gim),m=[],p;for(var u of l){var c=[];u.split(/\s+/gim).forEach(M.parseNumber,c);c=M.pointToPCRSPoint(L.point(c),this.options.zoom,this.options.projection,this.options.nativeCS);m.push(c),p=p?p.extend(c):L.bounds(c,c)}if(this._bounds?(this._bounds.extend(p.min),this._bounds.extend(p.max)):this._bounds=p,e)t.push({points:m});else{let e={},o=i.attributes,t=this._convertWrappers(s);t.link&&(e.tabindex="0");for(let t=0;t<o.length;t++)"class"!==o[t].name&&(e[o[t].name]=o[t].value);n.unshift({points:m,center:p.getCenter(),cls:(`${a||""} `+(t.className||"")).trim(),attr:e,link:t.link,linkTarget:t.linkTarget,linkType:t.linkType})}},_isClosed:function(){switch(this.type){case"MAP-POLYGON":case"MAP-MULTIPOLYGON":case"MAP-POINT":case"MAP-MULTIPOINT":return!0;default:return!1}},getCenter:function(){return this._bounds?this._map.options.crs.unproject(this._bounds.getCenter()):null},getPCRSCenter:function(){return this._bounds.getCenter()}}),gt=L.SVG.extend({_initContainer:function(){L.SVG.prototype._initContainer.call(this),this._container.setAttribute("role","none presentation")},_initPath:function(e,t=!0){if(e._outline){let t=L.SVG.create("path");e.options.className&&L.DomUtil.addClass(t,e.featureAttributes.class||e.options.className),L.DomUtil.addClass(t,"mapml-feature-outline"),t.style.fill="none",e.outlinePath=t}for(var o of e._parts){if(o.rings&&(this._createPath(o,e.options.className,e.featureAttributes["aria-label"],e.options.interactive,e.featureAttributes),e.outlinePath&&(o.path.style.stroke="none")),o.subrings)for(var i of o.subrings)this._createPath(i,e.options.className,i.attr["aria-label"],void 0!==i.link,i.attr);this._updateStyle(e)}t&&(t=L.stamp(e),this._layers[t]=e)},_createPath:function(t,e,o,i=!1,n=void 0){let a=L.SVG.create("path");if(t.path=a,n)for(var[s,r]of Object.entries(n))"id"!==s&&"tabindex"!==s&&a.setAttribute(s,r);else o&&a.setAttribute("aria-label",o);(t.cls||e)&&L.DomUtil.addClass(a,t.cls||e),i&&L.DomUtil.addClass(a,"leaflet-interactive")},_addPath:function(t,e=void 0,o=!0){this._rootGroup||e||this._initContainer();let i=e||this._rootGroup,n=!1;o&&t.addInteractiveTarget(t.group);for(var a of t._parts){a.path&&t.group.appendChild(a.path),o&&(t.options.link&&t.attachLinkHandler(a.path,t.options.link,t.options._leafletLayer),t.addInteractiveTarget(a.path)),!n&&t.pixelOutline&&(t.group.appendChild(t.outlinePath),n=!0);for(var s of a.subrings)s.path&&(s.link&&(t.attachLinkHandler(s.path,s.link,t.options._leafletLayer),t.addInteractiveTarget(s.path)),t.group.appendChild(s.path))}i.appendChild(t.group)},_removePath:function(t){for(var e of t._parts){e.path&&(t.removeInteractiveTarget(e.path),L.DomUtil.remove(e.path));for(var o of e.subrings)o.path&&L.DomUtil.remove(o.path)}t.outlinePath&&L.DomUtil.remove(t.outlinePath),t.removeInteractiveTarget(t.group),L.DomUtil.remove(t.group),delete this._layers[L.stamp(t)]},_updateFeature:function(t){t.pixelOutline&&this._setPath(t.outlinePath,this.geometryToPath(t.pixelOutline,!1));for(var e of t._parts){this._setPath(e.path,this.geometryToPath(e.pixelRings,t.isClosed));for(var o of e.subrings)this._setPath(o.path,this.geometryToPath(o.pixelSubrings,!1))}},_pointToMarker:function(t){return`M${t.x} ${t.y} L${t.x-12.5} ${t.y-30} C${t.x-12.5} ${t.y-50}, ${t.x+12.5} ${t.y-50}, ${t.x+12.5} ${t.y-30} L${t.x} ${t.y}z`},_updateStyle:function(t){this._updatePathStyle(t.outlinePath,t,!1,!0);for(var e of t._parts){e.path&&this._updatePathStyle(e.path,t,!0);for(var o of e.subrings)o.path&&this._updatePathStyle(o.path,t)}},_updatePathStyle:function(t,e,o=!1,i=!1){var n,a;t&&e&&(n=e.options,a=e.isClosed,n.stroke&&(!a||i)||o&&!e.outlinePath?(t.setAttribute("stroke",n.color),t.setAttribute("stroke-opacity",n.opacity),t.setAttribute("stroke-width",n.weight),t.setAttribute("stroke-linecap",n.lineCap),t.setAttribute("stroke-linejoin",n.lineJoin),n.dashArray?t.setAttribute("stroke-dasharray",n.dashArray):t.removeAttribute("stroke-dasharray"),n.dashOffset?t.setAttribute("stroke-dashoffset",n.dashOffset):t.removeAttribute("stroke-dashoffset"),n.link&&(t.setAttribute("stroke",n.link.visited?"#6c00a2":"#0000EE"),t.setAttribute("stroke-opacity","1"),t.setAttribute("stroke-width","1px"),t.setAttribute("stroke-dasharray","none"))):t.setAttribute("stroke","none"),a&&!i?n.fill?t.setAttribute("fill",n.color):(t.setAttribute("fill",n.fillColor||n.color),t.setAttribute("fill-opacity",n.fillOpacity),t.setAttribute("fill-rule",n.fillRule||"evenodd")):t.setAttribute("fill","none"))},_setPath:function(t,e){t.setAttribute("d",e)},geometryToPath:function(t,e){let o="",i,n,a,s,r,l;for(i=0,a=t.length;i<a;i++){if(1===(r=t[i]).length)return this._pointToMarker(r[0]);for(n=0,s=r.length;n<s;n++)l=r[n],o+=(n?"L":"M")+l.x+" "+l.y;o+=e?"z":""}return o||"M0 0"}}),ft=L.FeatureGroup.extend({initialize:function(t,e){e.wrappers&&0<e.wrappers.length&&(e=Object.assign(M.Feature.prototype._convertWrappers(e.wrappers),e)),L.LayerGroup.prototype.initialize.call(this,t,e),(this.options.onEachFeature&&this.options.properties||this.options.link)&&(L.DomUtil.addClass(this.options.group,"leaflet-interactive"),L.DomEvent.on(this.options.group,"keyup keydown mousedown",this._handleFocus,this),e=t[Object.keys(t)[0]],1===t.length&&e.options.link&&(this.options.link=e.options.link),this.options.link?(M.Feature.prototype.attachLinkHandler.call(this,this.options.group,this.options.link,this.options._leafletLayer),this.options.group.setAttribute("role","link")):(this.options.group.setAttribute("aria-expanded","false"),this.options.group.setAttribute("role","button"),this.options.onEachFeature(this.options.properties,this),this.off("click",this._openPopup))),this.options.group.setAttribute("aria-label",this.options.accessibleTitle),this.options.featureID&&this.options.group.setAttribute("data-fid",this.options.featureID)},onAdd:function(t){L.LayerGroup.prototype.onAdd.call(this,t),this.updateInteraction()},updateInteraction:function(){let e=this._map||this.options._leafletLayer._map;for(var o in(this.options.onEachFeature&&this.options.properties||this.options.link)&&e.featureIndex.addToIndex(this,this.getPCRSCenter(),this.options.group),this._layers){let t=this._layers[o];for(var i of t._parts){t.featureAttributes&&t.featureAttributes.tabindex&&e.featureIndex.addToIndex(t,t.getPCRSCenter(),i.path);for(var n of i.subrings)n.attr&&n.attr.tabindex&&e.featureIndex.addToIndex(t,n.center,n.path)}}},_handleFocus:function(t){if([9,16,27,37,38,39,40].includes(t.keyCode)&&"keydown"===t.type){var e=this._map.featureIndex.currentIndex;if(37===t.keyCode||38===t.keyCode)L.DomEvent.stop(t),this._map.featureIndex.inBoundFeatures[e].path.setAttribute("tabindex",-1),0===e?(this._map.featureIndex.inBoundFeatures[this._map.featureIndex.inBoundFeatures.length-1].path.focus(),this._map.featureIndex.currentIndex=this._map.featureIndex.inBoundFeatures.length-1):(this._map.featureIndex.inBoundFeatures[e-1].path.focus(),this._map.featureIndex.currentIndex--);else if(39===t.keyCode||40===t.keyCode)L.DomEvent.stop(t),this._map.featureIndex.inBoundFeatures[e].path.setAttribute("tabindex",-1),e===this._map.featureIndex.inBoundFeatures.length-1?(this._map.featureIndex.inBoundFeatures[0].path.focus(),this._map.featureIndex.currentIndex=0):(this._map.featureIndex.inBoundFeatures[e+1].path.focus(),this._map.featureIndex.currentIndex++);else if(27===t.keyCode){if("g"!==(this._map.options.mapEl.shadowRoot||this._map.options.mapEl.querySelector(".mapml-web-map").shadowRoot).activeElement.nodeName)return;this._map._container.focus()}else if(9===t.keyCode){let t=this;setTimeout(function(){t._map.featureIndex.inBoundFeatures[0].path.setAttribute("tabindex",0)},0)}}else[9,16,13,27,37,38,39,40,49,50,51,52,53,54,55].includes(t.keyCode)||(this._map.featureIndex.currentIndex=0,this._map.featureIndex.inBoundFeatures[0].path.focus());"G"===t.target.tagName.toUpperCase()&&([9,13,16,37,38,39,40,49,50,51,52,53,54,55].includes(t.keyCode)&&"keyup"===t.type?this.openTooltip():13===t.keyCode||32===t.keyCode?(this.closeTooltip(),!this.options.link&&this.options.onEachFeature&&(L.DomEvent.stop(t),this.openPopup())):this.closeTooltip())},addLayer:function(t){!t.options.link&&t.options.interactive&&this.options.onEachFeature(this.options.properties,t),L.FeatureGroup.prototype.addLayer.call(this,t)},_previousFeature:function(t){L.DomEvent.stop(t),this._map.featureIndex.currentIndex=Math.max(this._map.featureIndex.currentIndex-1,0);let e=this._map.featureIndex.inBoundFeatures[this._map.featureIndex.currentIndex];e.path.focus(),this._map.closePopup()},_nextFeature:function(t){L.DomEvent.stop(t),this._map.featureIndex.currentIndex=Math.min(this._map.featureIndex.currentIndex+1,this._map.featureIndex.inBoundFeatures.length-1);let e=this._map.featureIndex.inBoundFeatures[this._map.featureIndex.currentIndex];e.path.focus(),this._map.closePopup()},getPCRSCenter:function(){let e;for(var o in this._layers){let t=this._layers[o];e?e.extend(t.getPCRSCenter()):e=L.bounds(t.getPCRSCenter(),t.getPCRSCenter())}return e.getCenter()}}),xt=L.Handler.extend({addHooks:function(){this._map.on({layeradd:this.totalBounds,layerremove:this.totalBounds}),this._map.options.mapEl.addEventListener("moveend",this.announceBounds),this._map.dragging._draggable.addEventListener("dragstart",this.dragged),this._map.options.mapEl.addEventListener("mapfocused",this.focusAnnouncement)},removeHooks:function(){this._map.off({layeradd:this.totalBounds,layerremove:this.totalBounds}),this._map.options.mapEl.removeEventListener("moveend",this.announceBounds),this._map.dragging._draggable.removeEventListener("dragstart",this.dragged),this._map.options.mapEl.removeEventListener("mapfocused",this.focusAnnouncement)},focusAnnouncement:function(){let n=this;setTimeout(function(){let t=(n.querySelector(".mapml-web-map")?n.querySelector(".mapml-web-map"):n).shadowRoot.querySelector(".leaflet-container");var e=n._map.getZoom(),o=M.gcrsToTileMatrix(n);let i=M.options.locale.amZoom+" "+e+" "+M.options.locale.amColumn+" "+o[0]+" "+M.options.locale.amRow+" "+o[1];e===n._map._layersMaxZoom?i=M.options.locale.amMaxZoom+" "+i:e===n._map._layersMinZoom&&(i=M.options.locale.amMinZoom+" "+i),t.setAttribute("aria-roledescription","region "+i),setTimeout(function(){t.removeAttribute("aria-roledescription")},2e3)},0)},announceBounds:function(){if(!(0<this._traversalCall)){var o=this._map.getZoom(),i=M.pixelToPCRSBounds(this._map.getPixelBounds(),o,this._map.options.projection);let t=!0;this._map.totalLayerBounds&&(t=o<=this._map._layersMaxZoom&&o>=this._map._layersMinZoom&&this._map.totalLayerBounds.overlaps(i));let e=(this.querySelector(".mapml-web-map")?this.querySelector(".mapml-web-map"):this).shadowRoot.querySelector(".mapml-screen-reader-output");var n,i=M.gcrsToTileMatrix(this),i=M.options.locale.amZoom+" "+o+" "+M.options.locale.amColumn+" "+i[0]+" "+M.options.locale.amRow+" "+i[1];t?(n=(this._history[this._historyIndex-1]?this._history[this._historyIndex-1]:this._history[this._historyIndex]).zoom,o===this._map._layersMaxZoom&&o!==n?e.innerText=M.options.locale.amMaxZoom+" "+i:o===this._map._layersMinZoom&&o!==n?e.innerText=M.options.locale.amMinZoom+" "+i:e.innerText=i):(n=this._history[this._historyIndex],i=this._history[this._historyIndex-1],this.back(),this._history.pop(),n.zoom!==i.zoom?e.innerText=M.options.locale.amZoomedOut:this._map.dragging._draggable.wasDragged?e.innerText=M.options.locale.amDraggedOut:n.x>i.x?e.innerText=M.options.locale.amEastBound:n.x<i.x?e.innerText=M.options.locale.amWestBound:n.y<i.y?e.innerText=M.options.locale.amNorthBound:n.y>i.y&&(e.innerText=M.options.locale.amSouthBound)),this._map.dragging._draggable.wasDragged=!1}},totalBounds:function(){let t=Object.keys(this._layers),o=L.bounds();t.forEach(t=>{var e;this._layers[t].layerBounds&&(o||(e=this._layers[t].layerBounds.getCenter(),o=L.bounds(e,e)),o.extend(this._layers[t].layerBounds.min),o.extend(this._layers[t].layerBounds.max))}),this.totalLayerBounds=o},dragged:function(){this.wasDragged=!0}}),bt=L.Handler.extend({initialize:function(t){L.Handler.prototype.initialize.call(this,t),this.inBoundFeatures=[],this.outBoundFeatures=[],this.currentIndex=0,this._mapPCRSBounds=M.pixelToPCRSBounds(t.getPixelBounds(),t.getZoom(),t.options.projection)},addHooks:function(){this._map.on("mapkeyboardfocused",this._updateMapBounds,this),this._map.on("mapkeyboardfocused",this._sortIndex,this)},removeHooks:function(){this._map.off("mapkeyboardfocused",this._updateMapBounds),this._map.off("mapkeyboardfocused",this._sortIndex)},addToIndex:function(t,e,o){var i=this._mapPCRSBounds.getCenter(),i=Math.sqrt(Math.pow(e.x-i.x,2)+Math.pow(e.y-i.y,2));let n=this._mapPCRSBounds.contains(e)?this.inBoundFeatures:this.outBoundFeatures;i={path:o,layer:t,center:e,dist:i};o.setAttribute("tabindex",-1),n.push(i);for(let t=n.length-1;0<t&&n[t].dist<n[t-1].dist;t--){var a=n[t];n[t]=n[t-1],n[t-1]=a}this._mapPCRSBounds.contains(e)?this.inBoundFeatures=n:this.outBoundFeatures=n},cleanIndex:function(){this.currentIndex=0,this.inBoundFeatures=this.inBoundFeatures.filter(t=>{var e=this._mapPCRSBounds.contains(t.center);return t.path.setAttribute("tabindex",-1),t.layer._map&&!e&&this.outBoundFeatures.push(t),t.layer._map&&e}),this.outBoundFeatures=this.outBoundFeatures.filter(t=>{var e=this._mapPCRSBounds.contains(t.center);return t.path.setAttribute("tabindex",-1),t.layer._map&&e&&this.inBoundFeatures.push(t),t.layer._map&&!e})},_sortIndex:function(){if(this.cleanIndex(),0!==this.inBoundFeatures.length){let n=this._mapPCRSBounds.getCenter();this.inBoundFeatures.sort(function(t,e){var o=t.center,i=e.center;return t.dist=Math.sqrt(Math.pow(o.x-n.x,2)+Math.pow(o.y-n.y,2)),e.dist=Math.sqrt(Math.pow(i.x-n.x,2)+Math.pow(i.y-n.y,2)),t.dist-e.dist}),this.inBoundFeatures[0].path.setAttribute("tabindex",0)}},_updateMapBounds:function(t){this._mapPCRSBounds=M.pixelToPCRSBounds(this._map.getPixelBounds(),this._map.getZoom(),this._map.options.projection)}}),Lt={featureIndexOverlayOption:!1,announceMovement:!1,locale:{cmBack:"Back",cmForward:"Forward",cmReload:"Reload",cmToggleControls:"Toggle Controls",cmCopyCoords:"Copy Coordinates",cmToggleDebug:"Toggle Debug Mode",cmCopyMapML:"Copy MapML",cmPasteLayer:"Paste",cmViewSource:"View Map Source",cmCopyAll:"All",lmZoomToLayer:"Zoom To Layer",lmCopyExtent:"Copy Extent",lmCopyLayer:"Copy Layer",lcOpacity:"Opacity",btnZoomIn:"Zoom in",btnZoomOut:"Zoom out",btnFullScreen:"View fullscreen",amZoom:"zoom level",amColumn:"column",amRow:"row",amMaxZoom:"At maximum zoom level, zoom in disabled",amMinZoom:"At minimum zoom level, zoom out disabled",amZoomedOut:"Zoomed out of bounds, returning to",amDraggedOut:"Dragged out of bounds, returning to",amEastBound:"Reached east bound, panning east disabled",amWestBound:"Reached west bound, panning west disabled",amNorthBound:"Reached north bound, panning north disabled",amSouthBound:"Reached south bound, panning south disabled",kbdShortcuts:"Keyboard shortcuts",kbdMovement:"Movement keys",kbdFeature:"Feature navigation keys",kbdPanUp:"Pan up",kbdPanDown:"Pan down",kbdPanLeft:"Pan left",kbdPanRight:"Pan right",kbdPanIncrement:"pan increment",kbdZoom:"Zoom in/out 3 levels",kbdPrevFeature:"Previous feature",kbdNextFeature:"Next feature",dfLayer:"Layer"}};L.Map.Keyboard.include({_onKeyDown:function(t){if(!t.altKey&&!t.metaKey){var e,o=t.keyCode,i=this._map;if(o in this._panKeys)i._panAnim&&i._panAnim._inProgress||(e=this._panKeys[o],t.shiftKey&&(e=L.point(e).multiplyBy(3)),t.ctrlKey&&(e=L.point(e).divideBy(5)),i.panBy(e),i.options.maxBounds&&i.panInsideBounds(i.options.maxBounds));else if(o in this._zoomKeys)(o in{187:187,107:107,61:61,171:171}&&i._layersMaxZoom!==i.getZoom()||o in{189:189,109:109,54:54,173:173}&&i._layersMinZoom!==i.getZoom())&&i.setZoom(i.getZoom()+(t.shiftKey?3:1)*this._zoomKeys[o]);else{if(27!==o||!i._popup||!i._popup.options.closeOnEscapeKey)return;i.closePopup()}L.DomEvent.stop(t)}}});function vt(t){return new At(t)}var Et,Mt,At=L.Layer.extend({onAdd:function(t){this._container=L.DomUtil.create("div","mapml-feature-index-box",t._container),this._container.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" viewBox="0 0 100 100"><path fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M0 0h100v100H0z" color="#000" overflow="visible"/></svg>',this._output=L.DomUtil.create("output","mapml-feature-index",t._container),this._output.setAttribute("role","status"),this._output.setAttribute("aria-live","polite"),this._output.setAttribute("aria-atomic","true"),this._body=L.DomUtil.create("span","mapml-feature-index-content",this._output),this._body.index=0,this._output.initialFocus=!1,t.on("layerchange layeradd layerremove overlayremove",this._toggleEvents,this),t.on("moveend focus templatedfeatureslayeradd",this._checkOverlap,this),t.on("keydown",this._onKeyDown,this),this._addOrRemoveFeatureIndex()},_calculateReticleBounds:function(){let t=this._map.getPixelBounds();var e=t.getCenter(),o=Math.abs(t.min.x-t.max.x)/this._map.options.mapEl.width,i=Math.abs(t.min.y-t.max.y)/this._map.options.mapEl.height;let n=getComputedStyle(this._container).width.replace(/[^\d.]/g,"");"%"===getComputedStyle(this._container).width.slice(-1)&&(n=n*this._map.options.mapEl.width/100);var a=o*n/2,o=i*n/2,i=L.point(e.x-a,e.y+o),o=L.point(e.x+a,e.y-o),o=L.bounds(i,o);return M.pixelToPCRSBounds(o,this._map.getZoom(),this._map.options.projection)},_checkOverlap:function(t){if("focus"===t.type&&(this._output.initialFocus=!0),this._output.initialFocus)if(this._output.popupClosed)this._output.popupClosed=!1;else{this._map.fire("mapkeyboardfocused");let n=this._calculateReticleBounds(),a=this._map.featureIndex.inBoundFeatures,s=1,t=Object.keys(a),r=this._body;r.innerHTML="",r.index=0,r.allFeatures=[],t.forEach(t=>{let e=a[t].layer;var o=a[t].layer._layers;let i=L.bounds();if(o){let t=Object.keys(o);t.forEach(t=>{i=i||L.bounds(e._layers[t]._bounds.min,e._layers[t]._bounds.max),i.extend(e._layers[t]._bounds.min),i.extend(e._layers[t]._bounds.max)})}else e._bounds&&(i=L.bounds(e._bounds.min,e._bounds.max));n.overlaps(i)&&(t=a[t].path.getAttribute("aria-label"),s<8&&r.appendChild(this._updateOutput(t,s,s)),s%7!=0&&1!==s||r.allFeatures.push([]),r.allFeatures[Math.floor((s-1)/7)].push({label:t,index:s,layer:e}),r.allFeatures[1]&&1===r.allFeatures[1].length&&r.appendChild(this._updateOutput("More results",0,9)),s+=1)}),this._addToggleKeys()}},_updateOutput:function(t,e,o){let i=document.createElement("span");return i.setAttribute("data-index",e),i.innerHTML=`<kbd>${o}</kbd>`+" "+t+"<span>, </span>",i},_addToggleKeys:function(){let e=this._body.allFeatures;for(let t=0;t<e.length;t++){if(0===e[t].length)return;e[t-1]&&e[t].push({label:"Previous results"}),e[t+1]&&0<e[t+1].length&&e[t].push({label:"More results"})}},_onKeyDown:function(e){var t=this._body,o=e.originalEvent.keyCode;if(49<=o&&o<=55){if(t.allFeatures[t.index]){e=t.allFeatures[t.index][o-49];if(e){let t=e.layer;t&&(this._map.featureIndex.currentIndex=e.index-1,t._popup?(this._map.closePopup(),t.openPopup()):t.options.group.focus())}}}else 56===o?this._newContent(t,-1):57===o&&this._newContent(t,1)},_newContent:function(o,t){var e=o.firstChild.getAttribute("data-index"),i=o.allFeatures[Math.floor((e-1)/7+t)];if(i&&0<i.length){o.innerHTML="",o.index+=t;for(let e=0;e<i.length;e++){var n=i[e],a=n.index||0;let t=e+1;"More results"===n.label&&(t=9),"Previous results"===n.label&&(t=8),o.appendChild(this._updateOutput(n.label,a,t))}}},_toggleEvents:function(){this._map.on("viewreset move moveend focus blur popupclose",this._addOrRemoveFeatureIndex,this)},_addOrRemoveFeatureIndex:function(t){var e=this._body.allFeatures?this._body.allFeatures.length:0;if(this._output.initialFocus){if(this._output.hasAttribute("aria-hidden")){let t=this;setTimeout(function(){t._output.removeAttribute("aria-hidden")},100)}}else this._output.setAttribute("aria-hidden","true");t&&"popupclose"===t.type?(this._output.setAttribute("aria-hidden","true"),this._output.popupClosed=!0):t&&"focus"===t.type?(this._container.removeAttribute("hidden"),0!==e&&this._output.classList.remove("mapml-screen-reader-output")):t&&t.originalEvent&&"pointermove"===t.originalEvent.type?(this._container.setAttribute("hidden",""),this._output.classList.add("mapml-screen-reader-output")):t&&t.target._popup?this._container.setAttribute("hidden",""):t&&"blur"===t.type?(this._container.setAttribute("hidden",""),this._output.classList.add("mapml-screen-reader-output"),this._output.initialFocus=!1,this._addOrRemoveFeatureIndex()):this._map.isFocused&&t?(this._container.removeAttribute("hidden"),0!==e?this._output.classList.remove("mapml-screen-reader-output"):this._output.classList.add("mapml-screen-reader-output")):(this._container.setAttribute("hidden",""),this._output.classList.add("mapml-screen-reader-output"))}});Et=window,Mt={},Et.M=Mt,function(){Mt.detectImagePath=function(t){var e=L.DomUtil.create("div","leaflet-default-icon-path",t),o=L.DomUtil.getStyle(e,"background-image")||L.DomUtil.getStyle(e,"backgroundImage");return t.removeChild(e),o=null===o||0!==o.indexOf("url")?"":o.replace(/^url\(["']?/,"").replace(/marker-icon\.png["']?\)$/,"")},Mt.mime="text/mapml";var t=Et.document.head.querySelector("map-options");Mt.options=Lt,t&&(Mt.options=Object.assign(Mt.options,JSON.parse(t.innerHTML))),Mt.WGS84=new L.Proj.CRS("EPSG:4326","+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ",{origin:[-180,90],bounds:L.bounds([[-180,-90],[180,90]]),resolutions:[.703125,.3515625,.17578125,.087890625,.0439453125,.02197265625,.010986328125,.0054931640625,.00274658203125,.001373291015625,.0006866455078125,.0003433227539062,.0001716613769531,858306884766e-16,429153442383e-16,214576721191e-16,107288360596e-16,53644180298e-16,26822090149e-16,13411045074e-16,6.705522537e-7,3.352761269e-7],crs:{tcrs:{horizontal:{name:"x",min:0,max:t=>(Mt.WGS84.options.bounds.getSize().x/Mt.WGS84.options.resolutions[t]).toFixed()},vertical:{name:"y",min:0,max:t=>(Mt.WGS84.options.bounds.getSize().y/Mt.WGS84.options.resolutions[t]).toFixed()},bounds:t=>L.bounds([Mt.WGS84.options.crs.tcrs.horizontal.min,Mt.WGS84.options.crs.tcrs.vertical.min],[Mt.WGS84.options.crs.tcrs.horizontal.max(t),Mt.WGS84.options.crs.tcrs.vertical.max(t)])},pcrs:{horizontal:{name:"longitude",get min(){return Mt.WGS84.options.crs.gcrs.horizontal.min},get max(){return Mt.WGS84.options.crs.gcrs.horizontal.max}},vertical:{name:"latitude",get min(){return Mt.WGS84.options.crs.gcrs.vertical.min},get max(){return Mt.WGS84.options.crs.gcrs.vertical.max}},get bounds(){return Mt.WGS84.options.bounds}},gcrs:{horizontal:{name:"longitude",min:-180,max:180},vertical:{name:"latitude",min:-90,max:90},get bounds(){return L.latLngBounds([Mt.WGS84.options.crs.gcrs.vertical.min,Mt.WGS84.options.crs.gcrs.horizontal.min],[Mt.WGS84.options.crs.gcrs.vertical.max,Mt.WGS84.options.crs.gcrs.horizontal.max])}},map:{horizontal:{name:"i",min:0,max:t=>t.getSize().x},vertical:{name:"j",min:0,max:t=>t.getSize().y},bounds:t=>L.bounds(L.point([0,0]),t.getSize())},tile:{horizontal:{name:"i",min:0,max:256},vertical:{name:"j",min:0,max:256},get bounds(){return L.bounds([Mt.WGS84.options.crs.tile.horizontal.min,Mt.WGS84.options.crs.tile.vertical.min],[Mt.WGS84.options.crs.tile.horizontal.max,Mt.WGS84.options.crs.tile.vertical.max])}},tilematrix:{horizontal:{name:"column",min:0,max:t=>(Mt.WGS84.options.crs.tcrs.horizontal.max(t)/Mt.WGS84.options.crs.tile.bounds.getSize().x).toFixed()},vertical:{name:"row",min:0,max:t=>(Mt.WGS84.options.crs.tcrs.vertical.max(t)/Mt.WGS84.options.crs.tile.bounds.getSize().y).toFixed()},bounds:t=>L.bounds([Mt.WGS84.options.crs.tilematrix.horizontal.min,Mt.WGS84.options.crs.tilematrix.vertical.min],[Mt.WGS84.options.crs.tilematrix.horizontal.max(t),Mt.WGS84.options.crs.tilematrix.vertical.max(t)])}}}),Mt.CBMTILE=new L.Proj.CRS("EPSG:3978","+proj=lcc +lat_1=49 +lat_2=77 +lat_0=49 +lon_0=-95 +x_0=0 +y_0=0 +ellps=GRS80 +datum=NAD83 +units=m +no_defs",{origin:[-34655800,3931e4],bounds:L.bounds([[-34655800,-39e6],[1e7,3931e4]]),resolutions:[38364.660062653464,22489.62831258996,13229.193125052918,7937.5158750317505,4630.2175937685215,2645.8386250105837,1587.5031750063501,926.0435187537042,529.1677250021168,317.50063500127004,185.20870375074085,111.12522225044451,66.1459656252646,38.36466006265346,22.48962831258996,13.229193125052918,7.9375158750317505,4.6302175937685215,2.6458386250105836,1.5875031750063502,.9260435187537043,.5291677250021167,.31750063500127,.18520870375074083,.11112522225044451,.06614596562526459],crs:{tcrs:{horizontal:{name:"x",min:0,max:t=>(Mt.CBMTILE.options.bounds.getSize().x/Mt.CBMTILE.options.resolutions[t]).toFixed()},vertical:{name:"y",min:0,max:t=>(Mt.CBMTILE.options.bounds.getSize().y/Mt.CBMTILE.options.resolutions[t]).toFixed()},bounds:t=>L.bounds([Mt.CBMTILE.options.crs.tcrs.horizontal.min,Mt.CBMTILE.options.crs.tcrs.vertical.min],[Mt.CBMTILE.options.crs.tcrs.horizontal.max(t),Mt.CBMTILE.options.crs.tcrs.vertical.max(t)])},pcrs:{horizontal:{name:"easting",get min(){return Mt.CBMTILE.options.bounds.min.x},get max(){return Mt.CBMTILE.options.bounds.max.x}},vertical:{name:"northing",get min(){return Mt.CBMTILE.options.bounds.min.y},get max(){return Mt.CBMTILE.options.bounds.max.y}},get bounds(){return Mt.CBMTILE.options.bounds}},gcrs:{horizontal:{name:"longitude",min:-141.01,max:-47.74},vertical:{name:"latitude",min:40.04,max:86.46},get bounds(){return L.latLngBounds([Mt.CBMTILE.options.crs.gcrs.vertical.min,Mt.CBMTILE.options.crs.gcrs.horizontal.min],[Mt.CBMTILE.options.crs.gcrs.vertical.max,Mt.CBMTILE.options.crs.gcrs.horizontal.max])}},map:{horizontal:{name:"i",min:0,max:t=>t.getSize().x},vertical:{name:"j",min:0,max:t=>t.getSize().y},bounds:t=>L.bounds(L.point([0,0]),t.getSize())},tile:{horizontal:{name:"i",min:0,max:256},vertical:{name:"j",min:0,max:256},get bounds(){return L.bounds([Mt.CBMTILE.options.crs.tile.horizontal.min,Mt.CBMTILE.options.crs.tile.vertical.min],[Mt.CBMTILE.options.crs.tile.horizontal.max,Mt.CBMTILE.options.crs.tile.vertical.max])}},tilematrix:{horizontal:{name:"column",min:0,max:t=>(Mt.CBMTILE.options.crs.tcrs.horizontal.max(t)/Mt.CBMTILE.options.crs.tile.bounds.getSize().x).toFixed()},vertical:{name:"row",min:0,max:t=>(Mt.CBMTILE.options.crs.tcrs.vertical.max(t)/Mt.CBMTILE.options.crs.tile.bounds.getSize().y).toFixed()},bounds:t=>L.bounds([0,0],[Mt.CBMTILE.options.crs.tilematrix.horizontal.max(t),Mt.CBMTILE.options.crs.tilematrix.vertical.max(t)])}}}),Mt.APSTILE=new L.Proj.CRS("EPSG:5936","+proj=stere +lat_0=90 +lat_ts=50 +lon_0=-150 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs",{origin:[-28567784.109255,32567784.109255],bounds:L.bounds([[-28567784.109254867,-28567784.109254755],[32567784.109255023,32567784.10925506]]),resolutions:[238810.813354,119405.406677,59702.7033384999,29851.3516692501,14925.675834625,7462.83791731252,3731.41895865639,1865.70947932806,932.854739664032,466.427369832148,233.213684916074,116.606842458037,58.3034212288862,29.1517106145754,14.5758553072877,7.28792765351156,3.64396382688807,1.82198191331174,.910990956788164,.45549547826179],crs:{tcrs:{horizontal:{name:"x",min:0,max:t=>(Mt.APSTILE.options.bounds.getSize().x/Mt.APSTILE.options.resolutions[t]).toFixed()},vertical:{name:"y",min:0,max:t=>(Mt.APSTILE.options.bounds.getSize().y/Mt.APSTILE.options.resolutions[t]).toFixed()},bounds:t=>L.bounds([Mt.APSTILE.options.crs.tcrs.horizontal.min,Mt.APSTILE.options.crs.tcrs.vertical.min],[Mt.APSTILE.options.crs.tcrs.horizontal.max(t),Mt.APSTILE.options.crs.tcrs.vertical.max(t)])},pcrs:{horizontal:{name:"easting",get min(){return Mt.APSTILE.options.bounds.min.x},get max(){return Mt.APSTILE.options.bounds.max.x}},vertical:{name:"northing",get min(){return Mt.APSTILE.options.bounds.min.y},get max(){return Mt.APSTILE.options.bounds.max.y}},get bounds(){return Mt.APSTILE.options.bounds}},gcrs:{horizontal:{name:"longitude",min:-180,max:180},vertical:{name:"latitude",min:60,max:90},get bounds(){return L.latLngBounds([Mt.APSTILE.options.crs.gcrs.vertical.min,Mt.APSTILE.options.crs.gcrs.horizontal.min],[Mt.APSTILE.options.crs.gcrs.vertical.max,Mt.APSTILE.options.crs.gcrs.horizontal.max])}},map:{horizontal:{name:"i",min:0,max:t=>t.getSize().x},vertical:{name:"j",min:0,max:t=>t.getSize().y},bounds:t=>L.bounds(L.point([0,0]),t.getSize())},tile:{horizontal:{name:"i",min:0,max:256},vertical:{name:"j",min:0,max:256},get bounds(){return L.bounds([Mt.APSTILE.options.crs.tile.horizontal.min,Mt.APSTILE.options.crs.tile.vertical.min],[Mt.APSTILE.options.crs.tile.horizontal.max,Mt.APSTILE.options.crs.tile.vertical.max])}},tilematrix:{horizontal:{name:"column",min:0,max:t=>(Mt.APSTILE.options.crs.tcrs.horizontal.max(t)/Mt.APSTILE.options.crs.tile.bounds.getSize().x).toFixed()},vertical:{name:"row",min:0,max:t=>(Mt.APSTILE.options.crs.tcrs.vertical.max(t)/Mt.APSTILE.options.crs.tile.bounds.getSize().y).toFixed()},bounds:t=>L.bounds([0,0],[Mt.APSTILE.options.crs.tilematrix.horizontal.max(t),Mt.APSTILE.options.crs.tilematrix.vertical.max(t)])}}}),Mt.OSMTILE=L.CRS.EPSG3857,L.setOptions(Mt.OSMTILE,{origin:[-20037508.342787,20037508.342787],bounds:L.bounds([[-20037508.342787,-20037508.342787],[20037508.342787,20037508.342787]]),resolutions:[156543.0339,78271.51695,39135.758475,19567.8792375,9783.93961875,4891.969809375,2445.9849046875,1222.9924523438,611.49622617188,305.74811308594,152.87405654297,76.437028271484,38.218514135742,19.109257067871,9.5546285339355,4.7773142669678,2.3886571334839,1.1943285667419,.59716428337097,.29858214168549,.14929107084274,.074645535421371,.03732276771068573,.018661383855342866,.009330691927671433],crs:{tcrs:{horizontal:{name:"x",min:0,max:t=>(Mt.OSMTILE.options.bounds.getSize().x/Mt.OSMTILE.options.resolutions[t]).toFixed()},vertical:{name:"y",min:0,max:t=>(Mt.OSMTILE.options.bounds.getSize().y/Mt.OSMTILE.options.resolutions[t]).toFixed()},bounds:t=>L.bounds([Mt.OSMTILE.options.crs.tcrs.horizontal.min,Mt.OSMTILE.options.crs.tcrs.vertical.min],[Mt.OSMTILE.options.crs.tcrs.horizontal.max(t),Mt.OSMTILE.options.crs.tcrs.vertical.max(t)])},pcrs:{horizontal:{name:"easting",get min(){return Mt.OSMTILE.options.bounds.min.x},get max(){return Mt.OSMTILE.options.bounds.max.x}},vertical:{name:"northing",get min(){return Mt.OSMTILE.options.bounds.min.y},get max(){return Mt.OSMTILE.options.bounds.max.y}},get bounds(){return Mt.OSMTILE.options.bounds}},gcrs:{horizontal:{name:"longitude",get min(){return Mt.OSMTILE.unproject(Mt.OSMTILE.options.bounds.min).lng},get max(){return Mt.OSMTILE.unproject(Mt.OSMTILE.options.bounds.max).lng}},vertical:{name:"latitude",get min(){return Mt.OSMTILE.unproject(Mt.OSMTILE.options.bounds.min).lat},get max(){return Mt.OSMTILE.unproject(Mt.OSMTILE.options.bounds.max).lat}},get bounds(){return L.latLngBounds([Mt.OSMTILE.options.crs.gcrs.vertical.min,Mt.OSMTILE.options.crs.gcrs.horizontal.min],[Mt.OSMTILE.options.crs.gcrs.vertical.max,Mt.OSMTILE.options.crs.gcrs.horizontal.max])}},map:{horizontal:{name:"i",min:0,max:t=>t.getSize().x},vertical:{name:"j",min:0,max:t=>t.getSize().y},bounds:t=>L.bounds(L.point([0,0]),t.getSize())},tile:{horizontal:{name:"i",min:0,max:256},vertical:{name:"j",min:0,max:256},get bounds(){return L.bounds([Mt.OSMTILE.options.crs.tile.horizontal.min,Mt.OSMTILE.options.crs.tile.vertical.min],[Mt.OSMTILE.options.crs.tile.horizontal.max,Mt.OSMTILE.options.crs.tile.vertical.max])}},tilematrix:{horizontal:{name:"column",min:0,max:t=>(Mt.OSMTILE.options.crs.tcrs.horizontal.max(t)/Mt.OSMTILE.options.crs.tile.bounds.getSize().x).toFixed()},vertical:{name:"row",min:0,max:t=>(Mt.OSMTILE.options.crs.tcrs.vertical.max(t)/Mt.OSMTILE.options.crs.tile.bounds.getSize().y).toFixed()},bounds:t=>L.bounds([0,0],[Mt.OSMTILE.options.crs.tilematrix.horizontal.max(t),Mt.OSMTILE.options.crs.tilematrix.vertical.max(t)])}}})}(),Mt.handleLink=Q,Mt.convertPCRSBounds=U,Mt.axisToXY=R,Mt.csToAxes=O,Mt.convertAndFormatPCRS=N,Mt.axisToCS=q,Mt.parseNumber=Y,Mt.extractInputBounds=D,Mt.splitCoordinate=K,Mt.boundsToPCRSBounds=H,Mt.pixelToPCRSBounds=G,Mt.metaContentToObject=V,Mt.coordsToArray=$,Mt.parseStylesheetAsHTML=W,Mt.pointToPCRSPoint=Z,Mt.pixelToPCRSPoint=j,Mt.gcrsToTileMatrix=X,Mt.properties2Table=J,Mt.updateExtent=tt,Mt.geojson2mapml=et,Mt.breakArray=ot,Mt.table2properties=it,Mt.geometry2geojson=nt,Mt.pcrsToGcrs=at,Mt.mapml2geojson=st,Mt.QueryHandler=B,Mt.ContextMenu=F,Mt.AnnounceMovement=xt,Mt.FeatureIndex=bt,L.Map.addInitHook("addHandler","query",Mt.QueryHandler),L.Map.addInitHook("addHandler","contextMenu",Mt.ContextMenu),L.Map.addInitHook("addHandler","announceMovement",Mt.AnnounceMovement),L.Map.addInitHook("addHandler","featureIndex",Mt.FeatureIndex),Mt.MapMLLayer=b,Mt.mapMLLayer=p,Mt.ImageOverlay=x,Mt.imageOverlay=m,Mt.TemplatedImageLayer=f,Mt.templatedImageLayer=l,Mt.TemplatedFeaturesLayer=g,Mt.templatedFeaturesLayer=r,Mt.TemplatedLayer=y,Mt.templatedLayer=s,Mt.TemplatedTileLayer=_,Mt.templatedTileLayer=a,Mt.MapMLFeatures=h,Mt.mapMlFeatures=n,Mt.MapMLLayerControl=i,Mt.mapMlLayerControl=e,Mt.ReloadButton=rt,Mt.reloadButton=c,Mt.FullscreenButton=lt,Mt.fullscreenButton=mt,Mt.attributionControl=pt,Mt.MapMLStaticTileLayer=o,Mt.mapMLStaticTileLayer=t,Mt.DebugOverlay=v,Mt.debugOverlay=u,Mt.Crosshair=_t,Mt.crosshair=ut,Mt.FeatureIndexOverlay=At,Mt.featureIndexOverlay=vt,Mt.Feature=yt,Mt.feature=ct,Mt.FeatureRenderer=gt,Mt.featureRenderer=ht,Mt.FeatureGroup=ft,Mt.featureGroup=dt}();
//# sourceMappingURL=mapml.js.map