/* @preserve
/* (c) 2022 Open Source Geospatial Foundation - all rights reserved
 * This code is licensed under the GPL 2.0 license, available at the root
 * application directory.
 * Leaflet 1.7.1, a JS library for interactive maps. http://leafletjs.com
 * (c) 2010-2019 Vladimir Agafonkin, (c) 2010-2011 CloudMade All rights reserved.
 * proj4 Copyright (c) 2014, Mike Adair, Richard Greenwood, Didier Richard, Stephen Irons, Olivier Terral and Calvin Metcalf
 * proj4leaflet Copyright (c) 2012, Kartena AB
Redistribution and use in source and binary forms, with or without modification, are
permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.

   2. Redistributions in binary form must reproduce the above copyright notice, this list
      of conditions and the following disclaimer in the documentation and/or other materials
      provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(t,i){"object"==typeof exports&&"undefined"!=typeof module?i(exports):"function"==typeof define&&define.amd?define(["exports"],i):i(t.L={})}(window,function(t){"use strict";function h(t){for(var i,e,s=1,n=arguments.length;s<n;s++)for(i in e=arguments[s])t[i]=e[i];return t}var o=Object.create||function(t){return i.prototype=t,new i};function i(){}function d(t,i){var e=Array.prototype.slice;if(t.bind)return t.bind.apply(t,e.call(arguments,1));var s=e.call(arguments,2);return function(){return t.apply(i,s.length?s.concat(e.call(arguments)):arguments)}}var e=0;function m(t){return t._leaflet_id=t._leaflet_id||++e,t._leaflet_id}function s(t,i,e){var s,n,o=function(){s=!1,n&&(a.apply(e,n),n=!1)},a=function(){s?n=arguments:(t.apply(e,arguments),setTimeout(o,i),s=!0)};return a}function n(t,i,e){var s=i[1],n=i[0],i=s-n;return t===s&&e?t:((t-n)%i+i)%i+n}function r(){return!1}function a(t,i){i=Math.pow(10,void 0===i?6:i);return Math.round(t*i)/i}function l(t){return t.trim?t.trim():t.replace(/^\s+|\s+$/g,"")}function u(t){return l(t).split(/\s+/)}function c(t,i){for(var e in Object.prototype.hasOwnProperty.call(t,"options")||(t.options=t.options?o(t.options):{}),i)t.options[e]=i[e];return t.options}function _(t,i,e){var s,n=[];for(s in t)n.push(encodeURIComponent(e?s.toUpperCase():s)+"="+encodeURIComponent(t[s]));return(i&&-1!==i.indexOf("?")?"&":"?")+n.join("&")}var p=/\{ *([\w_-]+) *\}/g;function f(t,e){return t.replace(p,function(t,i){i=e[i];if(void 0===i)throw new Error("No value provided for variable "+t);return i="function"==typeof i?i(e):i})}var g=Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)};function y(t,i){for(var e=0;e<t.length;e++)if(t[e]===i)return e;return-1}var v="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=";function M(t){return window["webkit"+t]||window["moz"+t]||window["ms"+t]}var x=0;function b(t){var i=+new Date,e=Math.max(0,16-(i-x));return x=i+e,window.setTimeout(t,e)}var w=window.requestAnimationFrame||M("RequestAnimationFrame")||b,P=window.cancelAnimationFrame||M("CancelAnimationFrame")||M("CancelRequestAnimationFrame")||function(t){window.clearTimeout(t)};function T(t,i,e){if(!e||w!==b)return w.call(window,d(t,i));t.call(i)}function C(t){t&&P.call(window,t)}var S={extend:h,create:o,bind:d,lastId:e,stamp:m,throttle:s,wrapNum:n,falseFn:r,formatNum:a,trim:l,splitWords:u,setOptions:c,getParamString:_,template:f,isArray:g,indexOf:y,emptyImageUrl:v,requestFn:w,cancelFn:P,requestAnimFrame:T,cancelAnimFrame:C};function E(){}E.extend=function(t){function i(){this.initialize&&this.initialize.apply(this,arguments),this.callInitHooks()}var e,s=i.__super__=this.prototype,n=o(s);for(e in(n.constructor=i).prototype=n,this)Object.prototype.hasOwnProperty.call(this,e)&&"prototype"!==e&&"__super__"!==e&&(i[e]=this[e]);return t.statics&&(h(i,t.statics),delete t.statics),t.includes&&(function(t){if("undefined"!=typeof L&&L&&L.Mixin){t=g(t)?t:[t];for(var i=0;i<t.length;i++)t[i]===L.Mixin.Events&&console.warn("Deprecated include of L.Mixin.Events: this property will be removed in future releases, please inherit from L.Evented instead.",(new Error).stack)}}(t.includes),h.apply(null,[n].concat(t.includes)),delete t.includes),n.options&&(t.options=h(o(n.options),t.options)),h(n,t),n._initHooks=[],n.callInitHooks=function(){if(!this._initHooksCalled){s.callInitHooks&&s.callInitHooks.call(this),this._initHooksCalled=!0;for(var t=0,i=n._initHooks.length;t<i;t++)n._initHooks[t].call(this)}},i},E.include=function(t){return h(this.prototype,t),this},E.mergeOptions=function(t){return h(this.prototype.options,t),this},E.addInitHook=function(t){var i=Array.prototype.slice.call(arguments,1),e="function"==typeof t?t:function(){this[t].apply(this,i)};return this.prototype._initHooks=this.prototype._initHooks||[],this.prototype._initHooks.push(e),this};var z={on:function(t,i,e){if("object"==typeof t)for(var s in t)this._on(s,t[s],i);else for(var n=0,o=(t=u(t)).length;n<o;n++)this._on(t[n],i,e);return this},off:function(t,i,e){if(t)if("object"==typeof t)for(var s in t)this._off(s,t[s],i);else for(var n=0,o=(t=u(t)).length;n<o;n++)this._off(t[n],i,e);else delete this._events;return this},_on:function(t,i,e){this._events=this._events||{};var s=this._events[t];s||(this._events[t]=s=[]);for(var t={fn:i,ctx:e=e===this?void 0:e},n=s,o=0,a=n.length;o<a;o++)if(n[o].fn===i&&n[o].ctx===e)return;n.push(t)},_off:function(t,i,e){var s,n,o;if(this._events&&(s=this._events[t]))if(i){if(e===this&&(e=void 0),s)for(n=0,o=s.length;n<o;n++){var a=s[n];if(a.ctx===e&&a.fn===i)return a.fn=r,this._firingCount&&(this._events[t]=s=s.slice()),void s.splice(n,1)}}else{for(n=0,o=s.length;n<o;n++)s[n].fn=r;delete this._events[t]}},fire:function(t,i,e){if(!this.listens(t,e))return this;var s=h({},i,{type:t,target:this,sourceTarget:i&&i.sourceTarget||this});if(this._events){var n=this._events[t];if(n){this._firingCount=this._firingCount+1||1;for(var o=0,a=n.length;o<a;o++){var r=n[o];r.fn.call(r.ctx||this,s)}this._firingCount--}}return e&&this._propagateEvent(s),this},listens:function(t,i){var e=this._events&&this._events[t];if(e&&e.length)return!0;if(i)for(var s in this._eventParents)if(this._eventParents[s].listens(t,i))return!0;return!1},once:function(t,i,e){if("object"==typeof t){for(var s in t)this.once(s,t[s],i);return this}var n=d(function(){this.off(t,i,e).off(t,n,e)},this);return this.on(t,i,e).on(t,n,e)},addEventParent:function(t){return this._eventParents=this._eventParents||{},this._eventParents[m(t)]=t,this},removeEventParent:function(t){return this._eventParents&&delete this._eventParents[m(t)],this},_propagateEvent:function(t){for(var i in this._eventParents)this._eventParents[i].fire(t.type,h({layer:t.target,propagatedFrom:t.target},t),!0)}};z.addEventListener=z.on,z.removeEventListener=z.clearAllEventListeners=z.off,z.addOneTimeEventListener=z.once,z.fireEvent=z.fire,z.hasEventListeners=z.listens;var A=E.extend(z);function k(t,i,e){this.x=e?Math.round(t):t,this.y=e?Math.round(i):i}var I=Math.trunc||function(t){return 0<t?Math.floor(t):Math.ceil(t)};function O(t,i,e){return t instanceof k?t:g(t)?new k(t[0],t[1]):null==t?t:"object"==typeof t&&"x"in t&&"y"in t?new k(t.x,t.y):new k(t,i,e)}function N(t,i){if(t)for(var e=i?[t,i]:t,s=0,n=e.length;s<n;s++)this.extend(e[s])}function B(t,i){return!t||t instanceof N?t:new N(t,i)}function Z(t,i){if(t)for(var e=i?[t,i]:t,s=0,n=e.length;s<n;s++)this.extend(e[s])}function R(t,i){return t instanceof Z?t:new Z(t,i)}function j(t,i,e){if(isNaN(t)||isNaN(i))throw new Error("Invalid LatLng object: ("+t+", "+i+")");this.lat=+t,this.lng=+i,void 0!==e&&(this.alt=+e)}function D(t,i,e){return t instanceof j?t:g(t)&&"object"!=typeof t[0]?3===t.length?new j(t[0],t[1],t[2]):2===t.length?new j(t[0],t[1]):null:null==t?t:"object"==typeof t&&"lat"in t?new j(t.lat,"lng"in t?t.lng:t.lon,t.alt):void 0===i?null:new j(t,i,e)}k.prototype={clone:function(){return new k(this.x,this.y)},add:function(t){return this.clone()._add(O(t))},_add:function(t){return this.x+=t.x,this.y+=t.y,this},subtract:function(t){return this.clone()._subtract(O(t))},_subtract:function(t){return this.x-=t.x,this.y-=t.y,this},divideBy:function(t){return this.clone()._divideBy(t)},_divideBy:function(t){return this.x/=t,this.y/=t,this},multiplyBy:function(t){return this.clone()._multiplyBy(t)},_multiplyBy:function(t){return this.x*=t,this.y*=t,this},scaleBy:function(t){return new k(this.x*t.x,this.y*t.y)},unscaleBy:function(t){return new k(this.x/t.x,this.y/t.y)},round:function(){return this.clone()._round()},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},floor:function(){return this.clone()._floor()},_floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.clone()._ceil()},_ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},trunc:function(){return this.clone()._trunc()},_trunc:function(){return this.x=I(this.x),this.y=I(this.y),this},distanceTo:function(t){var i=(t=O(t)).x-this.x,t=t.y-this.y;return Math.sqrt(i*i+t*t)},equals:function(t){return(t=O(t)).x===this.x&&t.y===this.y},contains:function(t){return t=O(t),Math.abs(t.x)<=Math.abs(this.x)&&Math.abs(t.y)<=Math.abs(this.y)},toString:function(){return"Point("+a(this.x)+", "+a(this.y)+")"}},N.prototype={extend:function(t){return t=O(t),this.min||this.max?(this.min.x=Math.min(t.x,this.min.x),this.max.x=Math.max(t.x,this.max.x),this.min.y=Math.min(t.y,this.min.y),this.max.y=Math.max(t.y,this.max.y)):(this.min=t.clone(),this.max=t.clone()),this},getCenter:function(t){return new k((this.min.x+this.max.x)/2,(this.min.y+this.max.y)/2,t)},getBottomLeft:function(){return new k(this.min.x,this.max.y)},getTopRight:function(){return new k(this.max.x,this.min.y)},getTopLeft:function(){return this.min},getBottomRight:function(){return this.max},getSize:function(){return this.max.subtract(this.min)},contains:function(t){var i,e;return(t=("number"==typeof t[0]||t instanceof k?O:B)(t))instanceof N?(i=t.min,e=t.max):i=e=t,i.x>=this.min.x&&e.x<=this.max.x&&i.y>=this.min.y&&e.y<=this.max.y},intersects:function(t){t=B(t);var i=this.min,e=this.max,s=t.min,n=t.max,t=n.x>=i.x&&s.x<=e.x,e=n.y>=i.y&&s.y<=e.y;return t&&e},overlaps:function(t){t=B(t);var i=this.min,e=this.max,s=t.min,n=t.max,t=n.x>i.x&&s.x<e.x,e=n.y>i.y&&s.y<e.y;return t&&e},isValid:function(){return!(!this.min||!this.max)}},Z.prototype={extend:function(t){var i,e,s=this._southWest,n=this._northEast;if(t instanceof j)e=i=t;else{if(!(t instanceof Z))return t?this.extend(D(t)||R(t)):this;if(i=t._southWest,e=t._northEast,!i||!e)return this}return s||n?(s.lat=Math.min(i.lat,s.lat),s.lng=Math.min(i.lng,s.lng),n.lat=Math.max(e.lat,n.lat),n.lng=Math.max(e.lng,n.lng)):(this._southWest=new j(i.lat,i.lng),this._northEast=new j(e.lat,e.lng)),this},pad:function(t){var i=this._southWest,e=this._northEast,s=Math.abs(i.lat-e.lat)*t,t=Math.abs(i.lng-e.lng)*t;return new Z(new j(i.lat-s,i.lng-t),new j(e.lat+s,e.lng+t))},getCenter:function(){return new j((this._southWest.lat+this._northEast.lat)/2,(this._southWest.lng+this._northEast.lng)/2)},getSouthWest:function(){return this._southWest},getNorthEast:function(){return this._northEast},getNorthWest:function(){return new j(this.getNorth(),this.getWest())},getSouthEast:function(){return new j(this.getSouth(),this.getEast())},getWest:function(){return this._southWest.lng},getSouth:function(){return this._southWest.lat},getEast:function(){return this._northEast.lng},getNorth:function(){return this._northEast.lat},contains:function(t){t=("number"==typeof t[0]||t instanceof j||"lat"in t?D:R)(t);var i,e,s=this._southWest,n=this._northEast;return t instanceof Z?(i=t.getSouthWest(),e=t.getNorthEast()):i=e=t,i.lat>=s.lat&&e.lat<=n.lat&&i.lng>=s.lng&&e.lng<=n.lng},intersects:function(t){t=R(t);var i=this._southWest,e=this._northEast,s=t.getSouthWest(),n=t.getNorthEast(),t=n.lat>=i.lat&&s.lat<=e.lat,e=n.lng>=i.lng&&s.lng<=e.lng;return t&&e},overlaps:function(t){t=R(t);var i=this._southWest,e=this._northEast,s=t.getSouthWest(),n=t.getNorthEast(),t=n.lat>i.lat&&s.lat<e.lat,e=n.lng>i.lng&&s.lng<e.lng;return t&&e},toBBoxString:function(){return[this.getWest(),this.getSouth(),this.getEast(),this.getNorth()].join(",")},equals:function(t,i){return!!t&&(t=R(t),this._southWest.equals(t.getSouthWest(),i)&&this._northEast.equals(t.getNorthEast(),i))},isValid:function(){return!(!this._southWest||!this._northEast)}};var q={latLngToPoint:function(t,i){t=this.projection.project(t),i=this.scale(i);return this.transformation._transform(t,i)},pointToLatLng:function(t,i){i=this.scale(i),i=this.transformation.untransform(t,i);return this.projection.unproject(i)},project:function(t){return this.projection.project(t)},unproject:function(t){return this.projection.unproject(t)},scale:function(t){return 256*Math.pow(2,t)},zoom:function(t){return Math.log(t/256)/Math.LN2},getProjectedBounds:function(t){if(this.infinite)return null;var i=this.projection.bounds,t=this.scale(t);return new N(this.transformation.transform(i.min,t),this.transformation.transform(i.max,t))},infinite:!(j.prototype={equals:function(t,i){return!!t&&(t=D(t),Math.max(Math.abs(this.lat-t.lat),Math.abs(this.lng-t.lng))<=(void 0===i?1e-9:i))},toString:function(t){return"LatLng("+a(this.lat,t)+", "+a(this.lng,t)+")"},distanceTo:function(t){return G.distance(this,D(t))},wrap:function(){return G.wrapLatLng(this)},toBounds:function(t){var i=180*t/40075017,t=i/Math.cos(Math.PI/180*this.lat);return R([this.lat-i,this.lng-t],[this.lat+i,this.lng+t])},clone:function(){return new j(this.lat,this.lng,this.alt)}}),wrapLatLng:function(t){var i=this.wrapLng?n(t.lng,this.wrapLng,!0):t.lng;return new j(this.wrapLat?n(t.lat,this.wrapLat,!0):t.lat,i,t.alt)},wrapLatLngBounds:function(t){var i=t.getCenter(),e=this.wrapLatLng(i),s=i.lat-e.lat,i=i.lng-e.lng;if(0==s&&0==i)return t;e=t.getSouthWest(),t=t.getNorthEast();return new Z(new j(e.lat-s,e.lng-i),new j(t.lat-s,t.lng-i))}},G=h({},q,{wrapLng:[-180,180],R:6371e3,distance:function(t,i){var e=Math.PI/180,s=t.lat*e,n=i.lat*e,o=Math.sin((i.lat-t.lat)*e/2),e=Math.sin((i.lng-t.lng)*e/2),e=o*o+Math.cos(s)*Math.cos(n)*e*e,e=2*Math.atan2(Math.sqrt(e),Math.sqrt(1-e));return this.R*e}}),W=6378137,U={R:W,MAX_LATITUDE:85.0511287798,project:function(t){var i=Math.PI/180,e=this.MAX_LATITUDE,e=Math.max(Math.min(e,t.lat),-e),e=Math.sin(e*i);return new k(this.R*t.lng*i,this.R*Math.log((1+e)/(1-e))/2)},unproject:function(t){var i=180/Math.PI;return new j((2*Math.atan(Math.exp(t.y/this.R))-Math.PI/2)*i,t.x*i/this.R)},bounds:new N([-(gt=W*Math.PI),-gt],[gt,gt])};function F(t,i,e,s){if(g(t))return this._a=t[0],this._b=t[1],this._c=t[2],void(this._d=t[3]);this._a=t,this._b=i,this._c=e,this._d=s}function H(t,i,e,s){return new F(t,i,e,s)}F.prototype={transform:function(t,i){return this._transform(t.clone(),i)},_transform:function(t,i){return t.x=(i=i||1)*(this._a*t.x+this._b),t.y=i*(this._c*t.y+this._d),t},untransform:function(t,i){return new k((t.x/(i=i||1)-this._b)/this._a,(t.y/i-this._d)/this._c)}};var V=h({},G,{code:"EPSG:3857",projection:U,transformation:H(yt=.5/(Math.PI*U.R),.5,-yt,.5)}),K=h({},V,{code:"EPSG:900913"});function X(t){return document.createElementNS("http://www.w3.org/2000/svg",t)}function J(t,i){for(var e,s,n,o,a="",r=0,h=t.length;r<h;r++){for(e=0,s=(n=t[r]).length;e<s;e++)a+=(e?"L":"M")+(o=n[e]).x+" "+o.y;a+=i?Lt?"z":"x":""}return a||"M0 0"}var Q=document.documentElement.style,Y="ActiveXObject"in window,$=Y&&!document.addEventListener,tt="msLaunchUri"in navigator&&!("documentMode"in document),it=Ct("webkit"),et=Ct("android"),st=Ct("android 2")||Ct("android 3"),nt=parseInt(/WebKit\/([0-9]+)|$/.exec(navigator.userAgent)[1],10),ot=et&&Ct("Google")&&nt<537&&!("AudioNode"in window),at=!!window.opera,rt=!tt&&Ct("chrome"),ht=Ct("gecko")&&!it&&!at&&!Y,lt=!rt&&Ct("safari"),ut=Ct("phantom"),ct="OTransition"in Q,dt=0===navigator.platform.indexOf("Win"),_t=Y&&"transition"in Q,pt="WebKitCSSMatrix"in window&&"m11"in new window.WebKitCSSMatrix&&!st,mt="MozPerspective"in Q,ft=!window.L_DISABLE_3D&&(_t||pt||mt)&&!ct&&!ut,W="undefined"!=typeof orientation||Ct("mobile"),gt=W&&it,yt=W&&pt,nt=!window.PointerEvent&&window.MSPointerEvent,vt=!(!window.PointerEvent&&!nt),Mt=!window.L_NO_TOUCH&&(vt||"ontouchstart"in window||window.DocumentTouch&&document instanceof window.DocumentTouch),xt=W&&at,Q=W&&ht,bt=1<(window.devicePixelRatio||window.screen.deviceXDPI/window.screen.logicalXDPI),wt=function(){var t=!1;try{var i=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("testPassiveEventSupport",r,i),window.removeEventListener("testPassiveEventSupport",r,i)}catch(t){}return t}(),Pt=!!document.createElement("canvas").getContext,Lt=!(!document.createElementNS||!X("svg").createSVGRect),Tt=!Lt&&function(){try{var t=document.createElement("div");t.innerHTML='<v:shape adj="1"/>';var i=t.firstChild;return i.style.behavior="url(#default#VML)",i&&"object"==typeof i.adj}catch(t){return!1}}();function Ct(t){return 0<=navigator.userAgent.toLowerCase().indexOf(t)}var ut={ie:Y,ielt9:$,edge:tt,webkit:it,android:et,android23:st,androidStock:ot,opera:at,chrome:rt,gecko:ht,safari:lt,phantom:ut,opera12:ct,win:dt,ie3d:_t,webkit3d:pt,gecko3d:mt,any3d:ft,mobile:W,mobileWebkit:gt,mobileWebkit3d:yt,msPointer:nt,pointer:vt,touch:Mt,mobileOpera:xt,mobileGecko:Q,retina:bt,passiveEvents:wt,canvas:Pt,svg:Lt,vml:Tt},St=nt?"MSPointerDown":"pointerdown",Et=nt?"MSPointerMove":"pointermove",zt=nt?"MSPointerUp":"pointerup",At=nt?"MSPointerCancel":"pointercancel",kt={},It=!1;function Ot(t,i,e,s){function n(t){Rt(t,o)}var o,a,r,h,l,u;function c(t){t.pointerType===(t.MSPOINTER_TYPE_MOUSE||"mouse")&&0===t.buttons||Rt(t,a)}return"touchstart"===i?(r=t,h=e,l=s,u=d(function(t){t.MSPOINTER_TYPE_TOUCH&&t.pointerType===t.MSPOINTER_TYPE_TOUCH&&zi(t),Rt(t,h)}),r["_leaflet_touchstart"+l]=u,r.addEventListener(St,u,!1),It||(document.addEventListener(St,Nt,!0),document.addEventListener(Et,Bt,!0),document.addEventListener(zt,Zt,!0),document.addEventListener(At,Zt,!0),It=!0)):"touchmove"===i?(a=e,(u=t)["_leaflet_touchmove"+s]=c,u.addEventListener(Et,c,!1)):"touchend"===i&&(o=e,(t=t)["_leaflet_touchend"+s]=n,t.addEventListener(zt,n,!1),t.addEventListener(At,n,!1)),this}function Nt(t){kt[t.pointerId]=t}function Bt(t){kt[t.pointerId]&&(kt[t.pointerId]=t)}function Zt(t){delete kt[t.pointerId]}function Rt(t,i){for(var e in t.touches=[],kt)t.touches.push(kt[e]);t.changedTouches=[t],i(t)}var jt=nt?"MSPointerDown":vt?"pointerdown":"touchstart",Dt=nt?"MSPointerUp":vt?"pointerup":"touchend",qt="_leaflet_";var Gt,Wt,Ut,Ft,Ht,Vt,Kt=ui(["transform","webkitTransform","OTransform","MozTransform","msTransform"]),Xt=ui(["webkitTransition","transition","OTransition","MozTransition","msTransition"]),Jt="webkitTransition"===Xt||"OTransition"===Xt?Xt+"End":"transitionend";function Qt(t){return"string"==typeof t?document.getElementById(t):t}function Yt(t,i){var e=t.style[i]||t.currentStyle&&t.currentStyle[i];return"auto"===(e=(!e||"auto"===e)&&document.defaultView?(t=document.defaultView.getComputedStyle(t,null))?t[i]:null:e)?null:e}function $t(t,i,e){t=document.createElement(t);return t.className=i||"",e&&e.appendChild(t),t}function ti(t){var i=t.parentNode;i&&i.removeChild(t)}function ii(t){for(;t.firstChild;)t.removeChild(t.firstChild)}function ei(t){var i=t.parentNode;i&&i.lastChild!==t&&i.appendChild(t)}function si(t){var i=t.parentNode;i&&i.firstChild!==t&&i.insertBefore(t,i.firstChild)}function ni(t,i){if(void 0!==t.classList)return t.classList.contains(i);t=hi(t);return 0<t.length&&new RegExp("(^|\\s)"+i+"(\\s|$)").test(t)}function oi(t,i){var e;if(void 0!==t.classList)for(var s=u(i),n=0,o=s.length;n<o;n++)t.classList.add(s[n]);else ni(t,i)||ri(t,((e=hi(t))?e+" ":"")+i)}function ai(t,i){void 0!==t.classList?t.classList.remove(i):ri(t,l((" "+hi(t)+" ").replace(" "+i+" "," ")))}function ri(t,i){void 0===t.className.baseVal?t.className=i:t.className.baseVal=i}function hi(t){return void 0===(t=t.correspondingElement?t.correspondingElement:t).className.baseVal?t.className:t.className.baseVal}function li(t,i){"opacity"in t.style?t.style.opacity=i:"filter"in t.style&&function(t,i){var e=!1,s="DXImageTransform.Microsoft.Alpha";try{e=t.filters.item(s)}catch(t){if(1===i)return}i=Math.round(100*i),e?(e.Enabled=100!==i,e.Opacity=i):t.style.filter+=" progid:"+s+"(opacity="+i+")"}(t,i)}function ui(t){for(var i=document.documentElement.style,e=0;e<t.length;e++)if(t[e]in i)return t[e];return!1}function ci(t,i,e){i=i||new k(0,0);t.style[Kt]=(_t?"translate("+i.x+"px,"+i.y+"px)":"translate3d("+i.x+"px,"+i.y+"px,0)")+(e?" scale("+e+")":"")}function di(t,i){t._leaflet_pos=i,ft?ci(t,i):(t.style.left=i.x+"px",t.style.top=i.y+"px")}function _i(t){return t._leaflet_pos||new k(0,0)}function pi(){Mi(window,"dragstart",zi)}function mi(){bi(window,"dragstart",zi)}function fi(t){for(;-1===t.tabIndex;)t=t.parentNode;t.style&&(gi(),Vt=(Ht=t).style.outline,t.style.outline="none",Mi(window,"keydown",gi))}function gi(){Ht&&(Ht.style.outline=Vt,Vt=Ht=void 0,bi(window,"keydown",gi))}function yi(t){for(;!((t=t.parentNode).offsetWidth&&t.offsetHeight||t===document.body););return t}function vi(t){var i=t.getBoundingClientRect();return{x:i.width/t.offsetWidth||1,y:i.height/t.offsetHeight||1,boundingClientRect:i}}Ft="onselectstart"in document?(Ut=function(){Mi(window,"selectstart",zi)},function(){bi(window,"selectstart",zi)}):(Wt=ui(["userSelect","WebkitUserSelect","OUserSelect","MozUserSelect","msUserSelect"]),Ut=function(){var t;Wt&&(t=document.documentElement.style,Gt=t[Wt],t[Wt]="none")},function(){Wt&&(document.documentElement.style[Wt]=Gt,Gt=void 0)});ct={TRANSFORM:Kt,TRANSITION:Xt,TRANSITION_END:Jt,get:Qt,getStyle:Yt,create:$t,remove:ti,empty:ii,toFront:ei,toBack:si,hasClass:ni,addClass:oi,removeClass:ai,setClass:ri,getClass:hi,setOpacity:li,testProp:ui,setTransform:ci,setPosition:di,getPosition:_i,disableTextSelection:Ut,enableTextSelection:Ft,disableImageDrag:pi,enableImageDrag:mi,preventOutline:fi,restoreOutline:gi,getSizedParentNode:yi,getScale:vi};function Mi(t,i,e,s){if("object"==typeof i)for(var n in i)Li(t,n,i[n],e);else for(var o=0,a=(i=u(i)).length;o<a;o++)Li(t,i[o],e,s);return this}var xi="_leaflet_events";function bi(t,i,e,s){if("object"==typeof i)for(var n in i)Ti(t,n,i[n],e);else if(i)for(var o=0,a=(i=u(i)).length;o<a;o++)Ti(t,i[o],e,s);else{for(var r in t[xi])Ti(t,r,t[xi][r]);delete t[xi]}return this}function wi(){return vt&&(!tt&&!lt)}var Pi={mouseenter:"mouseover",mouseleave:"mouseout",wheel:!("onwheel"in window)&&"mousewheel"};function Li(i,t,e,s){var n=t+m(e)+(s?"_"+m(s):"");if(i[xi]&&i[xi][n])return this;var o,a,r,h,l,u,c=function(t){return e.call(s||i,t||window.event)},d=c;function _(t){if(vt){if(!t.isPrimary)return;if("mouse"===t.pointerType)return}else if(1<t.touches.length)return;var i=Date.now(),e=i-(h||i);l=t.touches?t.touches[0]:t,u=0<e&&e<=250,h=i}function p(t){if(u&&!l.cancelBubble){if(vt){if("mouse"===t.pointerType)return;var i,e,s={};for(e in l)i=l[e],s[e]=i&&i.bind?i.bind(l):i;l=s}l.type="dblclick",l.button=0,a(l),h=null}}vt&&0===t.indexOf("touch")?Ot(i,t,c,n):Mt&&"dblclick"===t&&!wi()?(a=c,u=!1,(o=i)[qt+jt+(r=n)]=_,o[qt+Dt+r]=p,o[qt+"dblclick"+r]=a,o.addEventListener(jt,_,!!wt&&{passive:!1}),o.addEventListener(Dt,p,!!wt&&{passive:!1}),o.addEventListener("dblclick",a,!1)):"addEventListener"in i?"touchstart"===t||"touchmove"===t||"wheel"===t||"mousewheel"===t?i.addEventListener(Pi[t]||t,c,!!wt&&{passive:!1}):"mouseenter"===t||"mouseleave"===t?i.addEventListener(Pi[t],c=function(t){t=t||window.event,Ri(i,t)&&d(t)},!1):i.addEventListener(t,d,!1):"attachEvent"in i&&i.attachEvent("on"+t,c),i[xi]=i[xi]||{},i[xi][n]=c}function Ti(t,i,e,s){var n,o,a,r=i+m(e)+(s?"_"+m(s):""),e=t[xi]&&t[xi][r];if(!e)return this;vt&&0===i.indexOf("touch")?(a=(n=t)["_leaflet_"+(o=i)+(a=r)],"touchstart"===o?n.removeEventListener(St,a,!1):"touchmove"===o?n.removeEventListener(Et,a,!1):"touchend"===o&&(n.removeEventListener(zt,a,!1),n.removeEventListener(At,a,!1))):Mt&&"dblclick"===i&&!wi()?(n=(s=t)[qt+jt+(o=r)],a=s[qt+Dt+r],o=s[qt+"dblclick"+r],s.removeEventListener(jt,n,!!wt&&{passive:!1}),s.removeEventListener(Dt,a,!!wt&&{passive:!1}),s.removeEventListener("dblclick",o,!1)):"removeEventListener"in t?t.removeEventListener(Pi[i]||i,e,!1):"detachEvent"in t&&t.detachEvent("on"+i,e),t[xi][r]=null}function Ci(t){return t.stopPropagation?t.stopPropagation():t.originalEvent?t.originalEvent._stopped=!0:t.cancelBubble=!0,Zi(t),this}function Si(t){return Li(t,"wheel",Ci),this}function Ei(t){return Mi(t,"mousedown touchstart dblclick",Ci),Li(t,"click",Bi),this}function zi(t){return t.preventDefault?t.preventDefault():t.returnValue=!1,this}function Ai(t){return zi(t),Ci(t),this}function ki(t,i){if(!i)return new k(t.clientX,t.clientY);var e=vi(i),s=e.boundingClientRect;return new k((t.clientX-s.left)/e.x-i.clientLeft,(t.clientY-s.top)/e.y-i.clientTop)}var Ii=dt&&rt?2*window.devicePixelRatio:ht?window.devicePixelRatio:1;function Oi(t){return tt?t.wheelDeltaY/2:t.deltaY&&0===t.deltaMode?-t.deltaY/Ii:t.deltaY&&1===t.deltaMode?20*-t.deltaY:t.deltaY&&2===t.deltaMode?60*-t.deltaY:t.deltaX||t.deltaZ?0:t.wheelDelta?(t.wheelDeltaY||t.wheelDelta)/2:t.detail&&Math.abs(t.detail)<32765?20*-t.detail:t.detail?t.detail/-32765*60:0}var Ni={};function Bi(t){Ni[t.type]=!0}function Zi(t){var i=Ni[t.type];return Ni[t.type]=!1,i}function Ri(t,i){var e=i.relatedTarget;if(!e)return!0;try{for(;e&&e!==t;)e=e.parentNode}catch(t){return!1}return e!==t}var pt={on:Mi,off:bi,stopPropagation:Ci,disableScrollPropagation:Si,disableClickPropagation:Ei,preventDefault:zi,stop:Ai,getMousePosition:ki,getWheelDelta:Oi,fakeStop:Bi,skipped:Zi,isExternalTarget:Ri,addListener:Mi,removeListener:bi},ji=A.extend({run:function(t,i,e,s){this.stop(),this._el=t,this._inProgress=!0,this._duration=e||.25,this._easeOutPower=1/Math.max(s||.5,.2),this._startPos=_i(t),this._offset=i.subtract(this._startPos),this._startTime=+new Date,this.fire("start"),this._animate()},stop:function(){this._inProgress&&(this._step(!0),this._complete())},_animate:function(){this._animId=T(this._animate,this),this._step()},_step:function(t){var i=+new Date-this._startTime,e=1e3*this._duration;i<e?this._runFrame(this._easeOut(i/e),t):(this._runFrame(1),this._complete())},_runFrame:function(t,i){t=this._startPos.add(this._offset.multiplyBy(t));i&&t._round(),di(this._el,t),this.fire("step")},_complete:function(){C(this._animId),this._inProgress=!1,this.fire("end")},_easeOut:function(t){return 1-Math.pow(1-t,this._easeOutPower)}}),Di=A.extend({options:{crs:V,center:void 0,zoom:void 0,minZoom:void 0,maxZoom:void 0,layers:[],maxBounds:void 0,renderer:void 0,zoomAnimation:!0,zoomAnimationThreshold:4,fadeAnimation:!0,markerZoomAnimation:!0,transform3DLimit:8388608,zoomSnap:1,zoomDelta:1,trackResize:!0},initialize:function(t,i){i=c(this,i),this._handlers=[],this._layers={},this._zoomBoundLayers={},this._sizeChanged=!0,this._initContainer(t),this._initLayout(),this._onResize=d(this._onResize,this),this._initEvents(),i.maxBounds&&this.setMaxBounds(i.maxBounds),void 0!==i.zoom&&(this._zoom=this._limitZoom(i.zoom)),i.center&&void 0!==i.zoom&&this.setView(D(i.center),i.zoom,{reset:!0}),this.callInitHooks(),this._zoomAnimated=Xt&&ft&&!xt&&this.options.zoomAnimation,this._zoomAnimated&&(this._createAnimProxy(),Mi(this._proxy,Jt,this._catchTransitionEnd,this)),this._addLayers(this.options.layers)},setView:function(t,i,e){if((i=void 0===i?this._zoom:this._limitZoom(i),t=this._limitCenter(D(t),i,this.options.maxBounds),e=e||{},this._stop(),this._loaded&&!e.reset&&!0!==e)&&(void 0!==e.animate&&(e.zoom=h({animate:e.animate},e.zoom),e.pan=h({animate:e.animate,duration:e.duration},e.pan)),this._zoom!==i?this._tryAnimatedZoom&&this._tryAnimatedZoom(t,i,e.zoom):this._tryAnimatedPan(t,e.pan)))return clearTimeout(this._sizeTimer),this;return this._resetView(t,i),this},setZoom:function(t,i){return this._loaded?this.setView(this.getCenter(),t,{zoom:i}):(this._zoom=t,this)},zoomIn:function(t,i){return t=t||(ft?this.options.zoomDelta:1),this.setZoom(this._zoom+t,i)},zoomOut:function(t,i){return t=t||(ft?this.options.zoomDelta:1),this.setZoom(this._zoom-t,i)},setZoomAround:function(t,i,e){var s=this.getZoomScale(i),n=this.getSize().divideBy(2),s=(t instanceof k?t:this.latLngToContainerPoint(t)).subtract(n).multiplyBy(1-1/s),s=this.containerPointToLatLng(n.add(s));return this.setView(s,i,{zoom:e})},_getBoundsCenterZoom:function(t,i){i=i||{},t=t.getBounds?t.getBounds():R(t);var e=O(i.paddingTopLeft||i.padding||[0,0]),s=O(i.paddingBottomRight||i.padding||[0,0]),n=this.getBoundsZoom(t,!1,e.add(s));if((n="number"==typeof i.maxZoom?Math.min(i.maxZoom,n):n)===1/0)return{center:t.getCenter(),zoom:n};s=s.subtract(e).divideBy(2),e=this.project(t.getSouthWest(),n),t=this.project(t.getNorthEast(),n);return{center:this.unproject(e.add(t).divideBy(2).add(s),n),zoom:n}},fitBounds:function(t,i){if(!(t=R(t)).isValid())throw new Error("Bounds are not valid.");t=this._getBoundsCenterZoom(t,i);return this.setView(t.center,t.zoom,i)},fitWorld:function(t){return this.fitBounds([[-90,-180],[90,180]],t)},panTo:function(t,i){return this.setView(t,this._zoom,{pan:i})},panBy:function(t,i){return i=i||{},(t=O(t).round()).x||t.y?(!0===i.animate||this.getSize().contains(t)?(this._panAnim||(this._panAnim=new ji,this._panAnim.on({step:this._onPanTransitionStep,end:this._onPanTransitionEnd},this)),i.noMoveStart||this.fire("movestart"),!1!==i.animate?(oi(this._mapPane,"leaflet-pan-anim"),e=this._getMapPanePos().subtract(t).round(),this._panAnim.run(this._mapPane,e,i.duration||.25,i.easeLinearity)):(this._rawPanBy(t),this.fire("move").fire("moveend"))):this._resetView(this.unproject(this.project(this.getCenter()).add(t)),this.getZoom()),this):this.fire("moveend");var e},flyTo:function(s,n,t){if(!1===(t=t||{}).animate||!ft)return this.setView(s,n,t);this._stop();var o=this.project(this.getCenter()),a=this.project(s),i=this.getSize(),r=this._zoom;s=D(s),n=void 0===n?r:n;var h=Math.max(i.x,i.y),e=h*this.getZoomScale(r,n),l=a.distanceTo(o)||1,u=1.42,c=u*u;function d(t){t=(e*e-h*h+(t?-1:1)*c*c*l*l)/(2*(t?e:h)*c*l),t=Math.sqrt(t*t+1)-t;return t<1e-9?-18:Math.log(t)}function _(t){return(Math.exp(t)-Math.exp(-t))/2}function p(t){return(Math.exp(t)+Math.exp(-t))/2}var m=d(0);function f(t){return h*(p(m)*(_(t=m+u*t)/p(t))-_(m))/c}var g=Date.now(),y=(d(1)-m)/u,v=t.duration?1e3*t.duration:1e3*y*.8;return this._moveStart(!0,t.noMoveStart),function t(){var i=(Date.now()-g)/v,e=(1-Math.pow(1-i,1.5))*y;i<=1?(this._flyToFrame=T(t,this),this._move(this.unproject(o.add(a.subtract(o).multiplyBy(f(e)/l)),r),this.getScaleZoom(h/(h*(p(m)/p(m+u*e))),r),{flyTo:!0})):this._move(s,n)._moveEnd(!0)}.call(this),this},flyToBounds:function(t,i){t=this._getBoundsCenterZoom(t,i);return this.flyTo(t.center,t.zoom,i)},setMaxBounds:function(t){return(t=R(t)).isValid()?(this.options.maxBounds&&this.off("moveend",this._panInsideMaxBounds),this.options.maxBounds=t,this._loaded&&this._panInsideMaxBounds(),this.on("moveend",this._panInsideMaxBounds)):(this.options.maxBounds=null,this.off("moveend",this._panInsideMaxBounds))},setMinZoom:function(t){var i=this.options.minZoom;return this.options.minZoom=t,this._loaded&&i!==t&&(this.fire("zoomlevelschange"),this.getZoom()<this.options.minZoom)?this.setZoom(t):this},setMaxZoom:function(t){var i=this.options.maxZoom;return this.options.maxZoom=t,this._loaded&&i!==t&&(this.fire("zoomlevelschange"),this.getZoom()>this.options.maxZoom)?this.setZoom(t):this},panInsideBounds:function(t,i){this._enforcingBounds=!0;var e=this.getCenter(),t=this._limitCenter(e,this._zoom,R(t));return e.equals(t)||this.panTo(t,i),this._enforcingBounds=!1,this},panInside:function(t,i){var e=O((i=i||{}).paddingTopLeft||i.padding||[0,0]),s=O(i.paddingBottomRight||i.padding||[0,0]),n=this.getCenter(),o=this.project(n),a=this.project(t),r=this.getPixelBounds(),h=r.getSize().divideBy(2),n=B([r.min.add(e),r.max.subtract(s)]);return n.contains(a)||(this._enforcingBounds=!0,t=o.subtract(a),r=O(a.x+t.x,a.y+t.y),(a.x<n.min.x||a.x>n.max.x)&&(r.x=o.x-t.x,0<t.x?r.x+=h.x-e.x:r.x-=h.x-s.x),(a.y<n.min.y||a.y>n.max.y)&&(r.y=o.y-t.y,0<t.y?r.y+=h.y-e.y:r.y-=h.y-s.y),this.panTo(this.unproject(r),i),this._enforcingBounds=!1),this},invalidateSize:function(t){if(!this._loaded)return this;t=h({animate:!1,pan:!0},!0===t?{animate:!0}:t);var i=this.getSize();this._sizeChanged=!0,this._lastCenter=null;var e=this.getSize(),s=i.divideBy(2).round(),n=e.divideBy(2).round(),n=s.subtract(n);return n.x||n.y?(t.animate&&t.pan?this.panBy(n):(t.pan&&this._rawPanBy(n),this.fire("move"),t.debounceMoveend?(clearTimeout(this._sizeTimer),this._sizeTimer=setTimeout(d(this.fire,this,"moveend"),200)):this.fire("moveend")),this.fire("resize",{oldSize:i,newSize:e})):this},stop:function(){return this.setZoom(this._limitZoom(this._zoom)),this.options.zoomSnap||this.fire("viewreset"),this._stop()},locate:function(t){if(t=this._locateOptions=h({timeout:1e4,watch:!1},t),!("geolocation"in navigator))return this._handleGeolocationError({code:0,message:"Geolocation not supported."}),this;var i=d(this._handleGeolocationResponse,this),e=d(this._handleGeolocationError,this);return t.watch?this._locationWatchId=navigator.geolocation.watchPosition(i,e,t):navigator.geolocation.getCurrentPosition(i,e,t),this},stopLocate:function(){return navigator.geolocation&&navigator.geolocation.clearWatch&&navigator.geolocation.clearWatch(this._locationWatchId),this._locateOptions&&(this._locateOptions.setView=!1),this},_handleGeolocationError:function(t){var i=t.code,t=t.message||(1===i?"permission denied":2===i?"position unavailable":"timeout");this._locateOptions.setView&&!this._loaded&&this.fitWorld(),this.fire("locationerror",{code:i,message:"Geolocation error: "+t+"."})},_handleGeolocationResponse:function(t){var i,e=new j(t.coords.latitude,t.coords.longitude),s=e.toBounds(2*t.coords.accuracy),n=this._locateOptions;n.setView&&(i=this.getBoundsZoom(s),this.setView(e,n.maxZoom?Math.min(i,n.maxZoom):i));var o,a={latlng:e,bounds:s,timestamp:t.timestamp};for(o in t.coords)"number"==typeof t.coords[o]&&(a[o]=t.coords[o]);this.fire("locationfound",a)},addHandler:function(t,i){if(!i)return this;i=this[t]=new i(this);return this._handlers.push(i),this.options[t]&&i.enable(),this},remove:function(){if(this._initEvents(!0),this.off("moveend",this._panInsideMaxBounds),this._containerId!==this._container._leaflet_id)throw new Error("Map container is being reused by another instance");try{delete this._container._leaflet_id,delete this._containerId}catch(t){this._container._leaflet_id=void 0,this._containerId=void 0}for(var t in void 0!==this._locationWatchId&&this.stopLocate(),this._stop(),ti(this._mapPane),this._clearControlPos&&this._clearControlPos(),this._resizeRequest&&(C(this._resizeRequest),this._resizeRequest=null),this._clearHandlers(),this._loaded&&this.fire("unload"),this._layers)this._layers[t].remove();for(t in this._panes)ti(this._panes[t]);return this._layers=[],this._panes=[],delete this._mapPane,delete this._renderer,this},createPane:function(t,i){i=$t("div","leaflet-pane"+(t?" leaflet-"+t.replace("Pane","")+"-pane":""),i||this._mapPane);return t&&(this._panes[t]=i),i},getCenter:function(){return this._checkIfLoaded(),this._lastCenter&&!this._moved()?this._lastCenter:this.layerPointToLatLng(this._getCenterLayerPoint())},getZoom:function(){return this._zoom},getBounds:function(){var t=this.getPixelBounds();return new Z(this.unproject(t.getBottomLeft()),this.unproject(t.getTopRight()))},getMinZoom:function(){return void 0===this.options.minZoom?this._layersMinZoom||0:this.options.minZoom},getMaxZoom:function(){return void 0===this.options.maxZoom?void 0===this._layersMaxZoom?1/0:this._layersMaxZoom:this.options.maxZoom},getBoundsZoom:function(t,i,e){t=R(t),e=O(e||[0,0]);var s=this.getZoom()||0,n=this.getMinZoom(),o=this.getMaxZoom(),a=t.getNorthWest(),r=t.getSouthEast(),t=this.getSize().subtract(e),e=B(this.project(r,s),this.project(a,s)).getSize(),r=ft?this.options.zoomSnap:1,a=t.x/e.x,e=t.y/e.y,e=i?Math.max(a,e):Math.min(a,e),s=this.getScaleZoom(e,s);return r&&(s=Math.round(s/(r/100))*(r/100),s=i?Math.ceil(s/r)*r:Math.floor(s/r)*r),Math.max(n,Math.min(o,s))},getSize:function(){return this._size&&!this._sizeChanged||(this._size=new k(this._container.clientWidth||0,this._container.clientHeight||0),this._sizeChanged=!1),this._size.clone()},getPixelBounds:function(t,i){i=this._getTopLeftPoint(t,i);return new N(i,i.add(this.getSize()))},getPixelOrigin:function(){return this._checkIfLoaded(),this._pixelOrigin},getPixelWorldBounds:function(t){return this.options.crs.getProjectedBounds(void 0===t?this.getZoom():t)},getPane:function(t){return"string"==typeof t?this._panes[t]:t},getPanes:function(){return this._panes},getContainer:function(){return this._container},getZoomScale:function(t,i){var e=this.options.crs;return i=void 0===i?this._zoom:i,e.scale(t)/e.scale(i)},getScaleZoom:function(t,i){var e=this.options.crs;i=void 0===i?this._zoom:i;i=e.zoom(t*e.scale(i));return isNaN(i)?1/0:i},project:function(t,i){return i=void 0===i?this._zoom:i,this.options.crs.latLngToPoint(D(t),i)},unproject:function(t,i){return i=void 0===i?this._zoom:i,this.options.crs.pointToLatLng(O(t),i)},layerPointToLatLng:function(t){t=O(t).add(this.getPixelOrigin());return this.unproject(t)},latLngToLayerPoint:function(t){return this.project(D(t))._round()._subtract(this.getPixelOrigin())},wrapLatLng:function(t){return this.options.crs.wrapLatLng(D(t))},wrapLatLngBounds:function(t){return this.options.crs.wrapLatLngBounds(R(t))},distance:function(t,i){return this.options.crs.distance(D(t),D(i))},containerPointToLayerPoint:function(t){return O(t).subtract(this._getMapPanePos())},layerPointToContainerPoint:function(t){return O(t).add(this._getMapPanePos())},containerPointToLatLng:function(t){t=this.containerPointToLayerPoint(O(t));return this.layerPointToLatLng(t)},latLngToContainerPoint:function(t){return this.layerPointToContainerPoint(this.latLngToLayerPoint(D(t)))},mouseEventToContainerPoint:function(t){return ki(t,this._container)},mouseEventToLayerPoint:function(t){return this.containerPointToLayerPoint(this.mouseEventToContainerPoint(t))},mouseEventToLatLng:function(t){return this.layerPointToLatLng(this.mouseEventToLayerPoint(t))},_initContainer:function(t){t=this._container=Qt(t);if(!t)throw new Error("Map container not found.");if(t._leaflet_id)throw new Error("Map container is already initialized.");Mi(t,"scroll",this._onScroll,this),this._containerId=m(t)},_initLayout:function(){var t=this._container;this._fadeAnimated=this.options.fadeAnimation&&ft,oi(t,"leaflet-container"+(Mt?" leaflet-touch":"")+(bt?" leaflet-retina":"")+($?" leaflet-oldie":"")+(lt?" leaflet-safari":"")+(this._fadeAnimated?" leaflet-fade-anim":""));var i=Yt(t,"position");"absolute"!==i&&"relative"!==i&&"fixed"!==i&&(t.style.position="relative"),this._initPanes(),this._initControlPos&&this._initControlPos()},_initPanes:function(){var t=this._panes={};this._paneRenderers={},this._mapPane=this.createPane("mapPane",this._container),di(this._mapPane,new k(0,0)),this.createPane("tilePane"),this.createPane("shadowPane"),this.createPane("overlayPane"),this.createPane("markerPane"),this.createPane("tooltipPane"),this.createPane("popupPane"),this.options.markerZoomAnimation||(oi(t.markerPane,"leaflet-zoom-hide"),oi(t.shadowPane,"leaflet-zoom-hide"))},_resetView:function(t,i){di(this._mapPane,new k(0,0));var e=!this._loaded;this._loaded=!0,i=this._limitZoom(i),this.fire("viewprereset");var s=this._zoom!==i;this._moveStart(s,!1)._move(t,i)._moveEnd(s),this.fire("viewreset"),e&&this.fire("load")},_moveStart:function(t,i){return t&&this.fire("zoomstart"),i||this.fire("movestart"),this},_move:function(t,i,e){void 0===i&&(i=this._zoom);var s=this._zoom!==i;return this._zoom=i,this._lastCenter=t,this._pixelOrigin=this._getNewPixelOrigin(t),(s||e&&e.pinch)&&this.fire("zoom",e),this.fire("move",e)},_moveEnd:function(t){return t&&this.fire("zoomend"),this.fire("moveend")},_stop:function(){return C(this._flyToFrame),this._panAnim&&this._panAnim.stop(),this},_rawPanBy:function(t){di(this._mapPane,this._getMapPanePos().subtract(t))},_getZoomSpan:function(){return this.getMaxZoom()-this.getMinZoom()},_panInsideMaxBounds:function(){this._enforcingBounds||this.panInsideBounds(this.options.maxBounds)},_checkIfLoaded:function(){if(!this._loaded)throw new Error("Set map center and zoom first.")},_initEvents:function(t){this._targets={};var i=t?bi:Mi;i((this._targets[m(this._container)]=this)._container,"click dblclick mousedown mouseup mouseover mouseout mousemove contextmenu keypress keydown keyup",this._handleDOMEvent,this),this.options.trackResize&&i(window,"resize",this._onResize,this),ft&&this.options.transform3DLimit&&(t?this.off:this.on).call(this,"moveend",this._onMoveEnd)},_onResize:function(){C(this._resizeRequest),this._resizeRequest=T(function(){this.invalidateSize({debounceMoveend:!0})},this)},_onScroll:function(){this._container.scrollTop=0,this._container.scrollLeft=0},_onMoveEnd:function(){var t=this._getMapPanePos();Math.max(Math.abs(t.x),Math.abs(t.y))>=this.options.transform3DLimit&&this._resetView(this.getCenter(),this.getZoom())},_findEventTargets:function(t,i){for(var e,s=[],n="mouseout"===i||"mouseover"===i,o=t.target||t.srcElement,a=!1;o;){if((e=this._targets[m(o)])&&("click"===i||"preclick"===i)&&!t._simulated&&this._draggableMoved(e)){a=!0;break}if(e&&e.listens(i,!0)){if(n&&!Ri(o,t))break;if(s.push(e),n)break}if(o===this._container)break;o=o.parentNode}return s=!(s.length||a||n)&&Ri(o,t)?[this]:s},_handleDOMEvent:function(t){var i;this._loaded&&!Zi(t)&&("mousedown"!==(i=t.type)&&"keypress"!==i&&"keyup"!==i&&"keydown"!==i||fi(t.target||t.srcElement),this._fireDOMEvent(t,i))},_mouseEvents:["click","dblclick","mouseover","mouseout","contextmenu"],_fireDOMEvent:function(t,i,e){if("click"===t.type&&((n=h({},t)).type="preclick",this._fireDOMEvent(n,n.type,e)),!t._stopped&&(e=(e||[]).concat(this._findEventTargets(t,i))).length){var s=e[0];"contextmenu"===i&&s.listens(i,!0)&&zi(t);var n,o={originalEvent:t};"keypress"!==t.type&&"keydown"!==t.type&&"keyup"!==t.type&&(n=s.getLatLng&&(!s._radius||s._radius<=10),o.containerPoint=n?this.latLngToContainerPoint(s.getLatLng()):this.mouseEventToContainerPoint(t),o.layerPoint=this.containerPointToLayerPoint(o.containerPoint),o.latlng=n?s.getLatLng():this.layerPointToLatLng(o.layerPoint));for(var a=0;a<e.length;a++)if(e[a].fire(i,o,!0),o.originalEvent._stopped||!1===e[a].options.bubblingMouseEvents&&-1!==y(this._mouseEvents,i))return}},_draggableMoved:function(t){return(t=t.dragging&&t.dragging.enabled()?t:this).dragging&&t.dragging.moved()||this.boxZoom&&this.boxZoom.moved()},_clearHandlers:function(){for(var t=0,i=this._handlers.length;t<i;t++)this._handlers[t].disable()},whenReady:function(t,i){return this._loaded?t.call(i||this,{target:this}):this.on("load",t,i),this},_getMapPanePos:function(){return _i(this._mapPane)||new k(0,0)},_moved:function(){var t=this._getMapPanePos();return t&&!t.equals([0,0])},_getTopLeftPoint:function(t,i){return(t&&void 0!==i?this._getNewPixelOrigin(t,i):this.getPixelOrigin()).subtract(this._getMapPanePos())},_getNewPixelOrigin:function(t,i){var e=this.getSize()._divideBy(2);return this.project(t,i)._subtract(e)._add(this._getMapPanePos())._round()},_latLngToNewLayerPoint:function(t,i,e){e=this._getNewPixelOrigin(e,i);return this.project(t,i)._subtract(e)},_latLngBoundsToNewLayerBounds:function(t,i,e){e=this._getNewPixelOrigin(e,i);return B([this.project(t.getSouthWest(),i)._subtract(e),this.project(t.getNorthWest(),i)._subtract(e),this.project(t.getSouthEast(),i)._subtract(e),this.project(t.getNorthEast(),i)._subtract(e)])},_getCenterLayerPoint:function(){return this.containerPointToLayerPoint(this.getSize()._divideBy(2))},_getCenterOffset:function(t){return this.latLngToLayerPoint(t).subtract(this._getCenterLayerPoint())},_limitCenter:function(t,i,e){if(!e)return t;var s=this.project(t,i),n=this.getSize().divideBy(2),n=new N(s.subtract(n),s.add(n)),e=this._getBoundsOffset(n,e,i);return e.round().equals([0,0])?t:this.unproject(s.add(e),i)},_limitOffset:function(t,i){if(!i)return t;var e=this.getPixelBounds(),e=new N(e.min.add(t),e.max.add(t));return t.add(this._getBoundsOffset(e,i))},_getBoundsOffset:function(t,i,e){i=B(this.project(i.getNorthEast(),e),this.project(i.getSouthWest(),e)),e=i.min.subtract(t.min),t=i.max.subtract(t.max);return new k(this._rebound(e.x,-t.x),this._rebound(e.y,-t.y))},_rebound:function(t,i){return 0<t+i?Math.round(t-i)/2:Math.max(0,Math.ceil(t))-Math.max(0,Math.floor(i))},_limitZoom:function(t){var i=this.getMinZoom(),e=this.getMaxZoom(),s=ft?this.options.zoomSnap:1;return s&&(t=Math.round(t/s)*s),Math.max(i,Math.min(e,t))},_onPanTransitionStep:function(){this.fire("move")},_onPanTransitionEnd:function(){ai(this._mapPane,"leaflet-pan-anim"),this.fire("moveend")},_tryAnimatedPan:function(t,i){t=this._getCenterOffset(t)._trunc();return!(!0!==(i&&i.animate)&&!this.getSize().contains(t))&&(this.panBy(t,i),!0)},_createAnimProxy:function(){var t=this._proxy=$t("div","leaflet-proxy leaflet-zoom-animated");this._panes.mapPane.appendChild(t),this.on("zoomanim",function(t){var i=Kt,e=this._proxy.style[i];ci(this._proxy,this.project(t.center,t.zoom),this.getZoomScale(t.zoom,1)),e===this._proxy.style[i]&&this._animatingZoom&&this._onZoomTransitionEnd()},this),this.on("load moveend",this._animMoveEnd,this),this._on("unload",this._destroyAnimProxy,this)},_destroyAnimProxy:function(){ti(this._proxy),this.off("load moveend",this._animMoveEnd,this),delete this._proxy},_animMoveEnd:function(){var t=this.getCenter(),i=this.getZoom();ci(this._proxy,this.project(t,i),this.getZoomScale(i,1))},_catchTransitionEnd:function(t){this._animatingZoom&&0<=t.propertyName.indexOf("transform")&&this._onZoomTransitionEnd()},_nothingToAnimate:function(){return!this._container.getElementsByClassName("leaflet-zoom-animated").length},_tryAnimatedZoom:function(t,i,e){if(this._animatingZoom)return!0;if(e=e||{},!this._zoomAnimated||!1===e.animate||this._nothingToAnimate()||Math.abs(i-this._zoom)>this.options.zoomAnimationThreshold)return!1;var s=this.getZoomScale(i),s=this._getCenterOffset(t)._divideBy(1-1/s);return!(!0!==e.animate&&!this.getSize().contains(s))&&(T(function(){this._moveStart(!0,!1)._animateZoom(t,i,!0)},this),!0)},_animateZoom:function(t,i,e,s){this._mapPane&&(e&&(this._animatingZoom=!0,this._animateToCenter=t,this._animateToZoom=i,oi(this._mapPane,"leaflet-zoom-anim")),this.fire("zoomanim",{center:t,zoom:i,noUpdate:s}),setTimeout(d(this._onZoomTransitionEnd,this),250))},_onZoomTransitionEnd:function(){this._animatingZoom&&(this._mapPane&&ai(this._mapPane,"leaflet-zoom-anim"),this._animatingZoom=!1,this._move(this._animateToCenter,this._animateToZoom),T(function(){this._moveEnd(!0)},this))}});function qi(t){return new Gi(t)}var Gi=E.extend({options:{position:"topright"},initialize:function(t){c(this,t)},getPosition:function(){return this.options.position},setPosition:function(t){var i=this._map;return i&&i.removeControl(this),this.options.position=t,i&&i.addControl(this),this},getContainer:function(){return this._container},addTo:function(t){this.remove(),this._map=t;var i=this._container=this.onAdd(t),e=this.getPosition(),t=t._controlCorners[e];return oi(i,"leaflet-control"),-1!==e.indexOf("bottom")?t.insertBefore(i,t.firstChild):t.appendChild(i),this._map.on("unload",this.remove,this),this},remove:function(){return this._map&&(ti(this._container),this.onRemove&&this.onRemove(this._map),this._map.off("unload",this.remove,this),this._map=null),this},_refocusOnMap:function(t){this._map&&t&&0<t.screenX&&0<t.screenY&&this._map.getContainer().focus()}});Di.include({addControl:function(t){return t.addTo(this),this},removeControl:function(t){return t.remove(),this},_initControlPos:function(){var e=this._controlCorners={},s="leaflet-",n=this._controlContainer=$t("div",s+"control-container",this._container);function t(t,i){e[t+i]=$t("div",s+t+" "+s+i,n)}t("top","left"),t("top","right"),t("bottom","left"),t("bottom","right")},_clearControlPos:function(){for(var t in this._controlCorners)ti(this._controlCorners[t]);ti(this._controlContainer),delete this._controlCorners,delete this._controlContainer}});var Wi=Gi.extend({options:{collapsed:!0,position:"topright",autoZIndex:!0,hideSingleBase:!1,sortLayers:!1,sortFunction:function(t,i,e,s){return e<s?-1:s<e?1:0}},initialize:function(t,i,e){for(var s in c(this,e),this._layerControlInputs=[],this._layers=[],this._lastZIndex=0,this._handlingClick=!1,t)this._addLayer(t[s],s);for(s in i)this._addLayer(i[s],s,!0)},onAdd:function(t){this._initLayout(),this._update(),(this._map=t).on("zoomend",this._checkDisabledLayers,this);for(var i=0;i<this._layers.length;i++)this._layers[i].layer.on("add remove",this._onLayerChange,this);return this._container},addTo:function(t){return Gi.prototype.addTo.call(this,t),this._expandIfNotCollapsed()},onRemove:function(){this._map.off("zoomend",this._checkDisabledLayers,this);for(var t=0;t<this._layers.length;t++)this._layers[t].layer.off("add remove",this._onLayerChange,this)},addBaseLayer:function(t,i){return this._addLayer(t,i),this._map?this._update():this},addOverlay:function(t,i){return this._addLayer(t,i,!0),this._map?this._update():this},removeLayer:function(t){t.off("add remove",this._onLayerChange,this);t=this._getLayer(m(t));return t&&this._layers.splice(this._layers.indexOf(t),1),this._map?this._update():this},expand:function(){oi(this._container,"leaflet-control-layers-expanded"),this._section.style.height=null;var t=this._map.getSize().y-(this._container.offsetTop+50);return t<this._section.clientHeight?(oi(this._section,"leaflet-control-layers-scrollbar"),this._section.style.height=t+"px"):ai(this._section,"leaflet-control-layers-scrollbar"),this._checkDisabledLayers(),this},collapse:function(){return ai(this._container,"leaflet-control-layers-expanded"),this},_initLayout:function(){var t="leaflet-control-layers",i=this._container=$t("div",t),e=this.options.collapsed;i.setAttribute("aria-haspopup",!0),Ei(i),Si(i);var s=this._section=$t("section",t+"-list");e&&(this._map.on("click",this.collapse,this),et||Mi(i,{mouseenter:this.expand,mouseleave:this.collapse},this));var n=this._layersLink=$t("a",t+"-toggle",i);n.href="#",n.title="Layers",Mt?(Mi(n,"click",Ai),Mi(n,"click",this.expand,this)):Mi(n,"focus",this.expand,this),e||this.expand(),this._baseLayersList=$t("div",t+"-base",s),this._separator=$t("div",t+"-separator",s),this._overlaysList=$t("div",t+"-overlays",s),i.appendChild(s)},_getLayer:function(t){for(var i=0;i<this._layers.length;i++)if(this._layers[i]&&m(this._layers[i].layer)===t)return this._layers[i]},_addLayer:function(t,i,e){this._map&&t.on("add remove",this._onLayerChange,this),this._layers.push({layer:t,name:i,overlay:e}),this.options.sortLayers&&this._layers.sort(d(function(t,i){return this.options.sortFunction(t.layer,i.layer,t.name,i.name)},this)),this.options.autoZIndex&&t.setZIndex&&(this._lastZIndex++,t.setZIndex(this._lastZIndex)),this._expandIfNotCollapsed()},_update:function(){if(!this._container)return this;ii(this._baseLayersList),ii(this._overlaysList),this._layerControlInputs=[];for(var t,i,e,s=0,n=0;n<this._layers.length;n++)e=this._layers[n],this._addItem(e),i=i||e.overlay,t=t||!e.overlay,s+=e.overlay?0:1;return this.options.hideSingleBase&&(this._baseLayersList.style.display=(t=t&&1<s)?"":"none"),this._separator.style.display=i&&t?"":"none",this},_onLayerChange:function(t){this._handlingClick||this._update();var i=this._getLayer(m(t.target)),t=i.overlay?"add"===t.type?"overlayadd":"overlayremove":"add"===t.type?"baselayerchange":null;t&&this._map.fire(t,i)},_createRadioElement:function(t,i){t='<input type="radio" class="leaflet-control-layers-selector" name="'+t+'"'+(i?' checked="checked"':"")+"/>",i=document.createElement("div");return i.innerHTML=t,i.firstChild},_addItem:function(t){var i,e=document.createElement("label"),s=this._map.hasLayer(t.layer);t.overlay?((i=document.createElement("input")).type="checkbox",i.className="leaflet-control-layers-selector",i.defaultChecked=s):i=this._createRadioElement("leaflet-base-layers_"+m(this),s),this._layerControlInputs.push(i),i.layerId=m(t.layer),Mi(i,"click",this._onInputClick,this);var n=document.createElement("span");n.innerHTML=" "+t.name;s=document.createElement("div");return e.appendChild(s),s.appendChild(i),s.appendChild(n),(t.overlay?this._overlaysList:this._baseLayersList).appendChild(e),this._checkDisabledLayers(),e},_onInputClick:function(){var t,i,e=this._layerControlInputs,s=[],n=[];this._handlingClick=!0;for(var o=e.length-1;0<=o;o--)t=e[o],i=this._getLayer(t.layerId).layer,t.checked?s.push(i):t.checked||n.push(i);for(o=0;o<n.length;o++)this._map.hasLayer(n[o])&&this._map.removeLayer(n[o]);for(o=0;o<s.length;o++)this._map.hasLayer(s[o])||this._map.addLayer(s[o]);this._handlingClick=!1,this._refocusOnMap()},_checkDisabledLayers:function(){for(var t,i,e=this._layerControlInputs,s=this._map.getZoom(),n=e.length-1;0<=n;n--)t=e[n],i=this._getLayer(t.layerId).layer,t.disabled=void 0!==i.options.minZoom&&s<i.options.minZoom||void 0!==i.options.maxZoom&&s>i.options.maxZoom},_expandIfNotCollapsed:function(){return this._map&&!this.options.collapsed&&this.expand(),this},_expand:function(){return this.expand()},_collapse:function(){return this.collapse()}}),Ui=Gi.extend({options:{position:"topleft",zoomInText:"+",zoomInTitle:"Zoom in",zoomOutText:"&#x2212;",zoomOutTitle:"Zoom out"},onAdd:function(t){var i="leaflet-control-zoom",e=$t("div",i+" leaflet-bar"),s=this.options;return this._zoomInButton=this._createButton(s.zoomInText,s.zoomInTitle,i+"-in",e,this._zoomIn),this._zoomOutButton=this._createButton(s.zoomOutText,s.zoomOutTitle,i+"-out",e,this._zoomOut),this._updateDisabled(),t.on("zoomend zoomlevelschange",this._updateDisabled,this),e},onRemove:function(t){t.off("zoomend zoomlevelschange",this._updateDisabled,this)},disable:function(){return this._disabled=!0,this._updateDisabled(),this},enable:function(){return this._disabled=!1,this._updateDisabled(),this},_zoomIn:function(t){!this._disabled&&this._map._zoom<this._map.getMaxZoom()&&this._map.zoomIn(this._map.options.zoomDelta*(t.shiftKey?3:1))},_zoomOut:function(t){!this._disabled&&this._map._zoom>this._map.getMinZoom()&&this._map.zoomOut(this._map.options.zoomDelta*(t.shiftKey?3:1))},_createButton:function(t,i,e,s,n){s=$t("a",e,s);return s.innerHTML=t,s.href="#",s.title=i,s.setAttribute("role","button"),s.setAttribute("aria-label",i),Ei(s),Mi(s,"click",Ai),Mi(s,"click",n,this),Mi(s,"click",this._refocusOnMap,this),s},_updateDisabled:function(){var t=this._map,i="leaflet-disabled";ai(this._zoomInButton,i),ai(this._zoomOutButton,i),!this._disabled&&t._zoom!==t.getMinZoom()||oi(this._zoomOutButton,i),!this._disabled&&t._zoom!==t.getMaxZoom()||oi(this._zoomInButton,i)}});Di.mergeOptions({zoomControl:!0}),Di.addInitHook(function(){this.options.zoomControl&&(this.zoomControl=new Ui,this.addControl(this.zoomControl))});var Fi=Gi.extend({options:{position:"bottomleft",maxWidth:100,metric:!0,imperial:!0},onAdd:function(t){var i="leaflet-control-scale",e=$t("div",i),s=this.options;return this._addScales(s,i+"-line",e),t.on(s.updateWhenIdle?"moveend":"move",this._update,this),t.whenReady(this._update,this),e},onRemove:function(t){t.off(this.options.updateWhenIdle?"moveend":"move",this._update,this)},_addScales:function(t,i,e){t.metric&&(this._mScale=$t("div",i,e)),t.imperial&&(this._iScale=$t("div",i,e))},_update:function(){var t=this._map,i=t.getSize().y/2,i=t.distance(t.containerPointToLatLng([0,i]),t.containerPointToLatLng([this.options.maxWidth,i]));this._updateScales(i)},_updateScales:function(t){this.options.metric&&t&&this._updateMetric(t),this.options.imperial&&t&&this._updateImperial(t)},_updateMetric:function(t){var i=this._getRoundNum(t);this._updateScale(this._mScale,i<1e3?i+" m":i/1e3+" km",i/t)},_updateImperial:function(t){var i,e=3.2808399*t;5280<e?(t=this._getRoundNum(i=e/5280),this._updateScale(this._iScale,t+" mi",t/i)):(i=this._getRoundNum(e),this._updateScale(this._iScale,i+" ft",i/e))},_updateScale:function(t,i,e){t.style.width=Math.round(this.options.maxWidth*e)+"px",t.innerHTML=i},_getRoundNum:function(t){var i=Math.pow(10,(Math.floor(t)+"").length-1),t=t/i;return i*(t=10<=t?10:5<=t?5:3<=t?3:2<=t?2:1)}}),Hi=Gi.extend({options:{position:"bottomright",prefix:'<a href="https://leafletjs.com" title="A JS library for interactive maps">Leaflet</a>'},initialize:function(t){c(this,t),this._attributions={}},onAdd:function(t){for(var i in(t.attributionControl=this)._container=$t("div","leaflet-control-attribution"),Ei(this._container),t._layers)t._layers[i].getAttribution&&this.addAttribution(t._layers[i].getAttribution());return this._update(),this._container},setPrefix:function(t){return this.options.prefix=t,this._update(),this},addAttribution:function(t){return t&&(this._attributions[t]||(this._attributions[t]=0),this._attributions[t]++,this._update()),this},removeAttribution:function(t){return t&&this._attributions[t]&&(this._attributions[t]--,this._update()),this},_update:function(){if(this._map){var t,i=[];for(t in this._attributions)this._attributions[t]&&i.push(t);var e=[];this.options.prefix&&e.push(this.options.prefix),i.length&&e.push(i.join(", ")),this._container.innerHTML=e.join(" | ")}}});Di.mergeOptions({attributionControl:!0}),Di.addInitHook(function(){this.options.attributionControl&&(new Hi).addTo(this)});Gi.Layers=Wi,Gi.Zoom=Ui,Gi.Scale=Fi,Gi.Attribution=Hi,qi.layers=function(t,i,e){return new Wi(t,i,e)},qi.zoom=function(t){return new Ui(t)},qi.scale=function(t){return new Fi(t)},qi.attribution=function(t){return new Hi(t)};mt=E.extend({initialize:function(t){this._map=t},enable:function(){return this._enabled||(this._enabled=!0,this.addHooks()),this},disable:function(){return this._enabled&&(this._enabled=!1,this.removeHooks()),this},enabled:function(){return!!this._enabled}});mt.addTo=function(t,i){return t.addHandler(i,this),this};var Vi,gt={Events:z},Ki=Mt?"touchstart mousedown":"mousedown",Xi={mousedown:"mouseup",touchstart:"touchend",pointerdown:"touchend",MSPointerDown:"touchend"},Ji={mousedown:"mousemove",touchstart:"touchmove",pointerdown:"touchmove",MSPointerDown:"touchmove"},Qi=A.extend({options:{clickTolerance:3},initialize:function(t,i,e,s){c(this,s),this._element=t,this._dragStartTarget=i||t,this._preventOutline=e},enable:function(){this._enabled||(Mi(this._dragStartTarget,Ki,this._onDown,this),this._enabled=!0)},disable:function(){this._enabled&&(Qi._dragging===this&&this.finishDrag(),bi(this._dragStartTarget,Ki,this._onDown,this),this._enabled=!1,this._moved=!1)},_onDown:function(t){var i,e;!t._simulated&&this._enabled&&(this._moved=!1,ni(this._element,"leaflet-zoom-anim")||Qi._dragging||t.shiftKey||1!==t.which&&1!==t.button&&!t.touches||((Qi._dragging=this)._preventOutline&&fi(this._element),pi(),Ut(),this._moving||(this.fire("down"),i=t.touches?t.touches[0]:t,e=yi(this._element),this._startPoint=new k(i.clientX,i.clientY),this._parentScale=vi(e),Mi(document,Ji[t.type],this._onMove,this),Mi(document,Xi[t.type],this._onUp,this))))},_onMove:function(t){var i;!t._simulated&&this._enabled&&(t.touches&&1<t.touches.length?this._moved=!0:((i=new k((i=t.touches&&1===t.touches.length?t.touches[0]:t).clientX,i.clientY)._subtract(this._startPoint)).x||i.y)&&(Math.abs(i.x)+Math.abs(i.y)<this.options.clickTolerance||(i.x/=this._parentScale.x,i.y/=this._parentScale.y,zi(t),this._moved||(this.fire("dragstart"),this._moved=!0,this._startPos=_i(this._element).subtract(i),oi(document.body,"leaflet-dragging"),this._lastTarget=t.target||t.srcElement,window.SVGElementInstance&&this._lastTarget instanceof window.SVGElementInstance&&(this._lastTarget=this._lastTarget.correspondingUseElement),oi(this._lastTarget,"leaflet-drag-target")),this._newPos=this._startPos.add(i),this._moving=!0,C(this._animRequest),this._lastEvent=t,this._animRequest=T(this._updatePosition,this,!0))))},_updatePosition:function(){var t={originalEvent:this._lastEvent};this.fire("predrag",t),di(this._element,this._newPos),this.fire("drag",t)},_onUp:function(t){!t._simulated&&this._enabled&&this.finishDrag()},finishDrag:function(){for(var t in ai(document.body,"leaflet-dragging"),this._lastTarget&&(ai(this._lastTarget,"leaflet-drag-target"),this._lastTarget=null),Ji)bi(document,Ji[t],this._onMove,this),bi(document,Xi[t],this._onUp,this);mi(),Ft(),this._moved&&this._moving&&(C(this._animRequest),this.fire("dragend",{distance:this._newPos.distanceTo(this._startPos)})),this._moving=!1,Qi._dragging=!1}});function Yi(t,i){if(!i||!t.length)return t.slice();i*=i;return t=function(t,i){var e=t.length,s=new(typeof Uint8Array!=void 0+""?Uint8Array:Array)(e);s[0]=s[e-1]=1,function t(i,e,s,n,o){var a,r,h,l=0;for(r=n+1;r<=o-1;r++)h=se(i[r],i[n],i[o],!0),l<h&&(a=r,l=h);s<l&&(e[a]=1,t(i,e,s,n,a),t(i,e,s,a,o))}(t,s,i,0,e-1);var n,o=[];for(n=0;n<e;n++)s[n]&&o.push(t[n]);return o}(t=function(t,i){for(var e=[t[0]],s=1,n=0,o=t.length;s<o;s++)(function(t,i){var e=i.x-t.x,t=i.y-t.y;return e*e+t*t})(t[s],t[n])>i&&(e.push(t[s]),n=s);n<o-1&&e.push(t[o-1]);return e}(t,i),i)}function $i(t,i,e){return Math.sqrt(se(t,i,e,!0))}function te(t,i,e,s,n){var o,a,r,h=s?Vi:ee(t,e),l=ee(i,e);for(Vi=l;;){if(!(h|l))return[t,i];if(h&l)return!1;r=ee(a=ie(t,i,o=h||l,e,n),e),o===h?(t=a,h=r):(i=a,l=r)}}function ie(t,i,e,s,n){var o,a,r=i.x-t.x,h=i.y-t.y,i=s.min,s=s.max;return 8&e?(o=t.x+r*(s.y-t.y)/h,a=s.y):4&e?(o=t.x+r*(i.y-t.y)/h,a=i.y):2&e?(o=s.x,a=t.y+h*(s.x-t.x)/r):1&e&&(o=i.x,a=t.y+h*(i.x-t.x)/r),new k(o,a,n)}function ee(t,i){var e=0;return t.x<i.min.x?e|=1:t.x>i.max.x&&(e|=2),t.y<i.min.y?e|=4:t.y>i.max.y&&(e|=8),e}function se(t,i,e,s){var n=i.x,o=i.y,a=e.x-n,r=e.y-o,i=a*a+r*r;return 0<i&&(1<(i=((t.x-n)*a+(t.y-o)*r)/i)?(n=e.x,o=e.y):0<i&&(n+=a*i,o+=r*i)),a=t.x-n,r=t.y-o,s?a*a+r*r:new k(n,o)}function ne(t){return!g(t[0])||"object"!=typeof t[0][0]&&void 0!==t[0][0]}function oe(t){return console.warn("Deprecated use of _flat, please use L.LineUtil.isFlat instead."),ne(t)}yt={simplify:Yi,pointToSegmentDistance:$i,closestPointOnSegment:function(t,i,e){return se(t,i,e)},clipSegment:te,_getEdgeIntersection:ie,_getBitCode:ee,_sqClosestPointOnSegment:se,isFlat:ne,_flat:oe};function ae(t,i,e){for(var s,n,o,a,r,h,l,u=[1,4,2,8],c=0,d=t.length;c<d;c++)t[c]._code=ee(t[c],i);for(o=0;o<4;o++){for(h=u[o],s=[],c=0,n=(d=t.length)-1;c<d;n=c++)a=t[c],r=t[n],a._code&h?r._code&h||((l=ie(r,a,h,i,e))._code=ee(l,i),s.push(l)):(r._code&h&&((l=ie(r,a,h,i,e))._code=ee(l,i),s.push(l)),s.push(a));t=s}return t}var Q={clipPolygon:ae},nt={project:function(t){return new k(t.lng,t.lat)},unproject:function(t){return new j(t.y,t.x)},bounds:new N([-180,-90],[180,90])},dt={R:6378137,R_MINOR:6356752.314245179,bounds:new N([-20037508.34279,-15496570.73972],[20037508.34279,18764656.23138]),project:function(t){var i=Math.PI/180,e=this.R,s=t.lat*i,n=this.R_MINOR/e,o=Math.sqrt(1-n*n),n=o*Math.sin(s),o=Math.tan(Math.PI/4-s/2)/Math.pow((1-n)/(1+n),o/2),s=-e*Math.log(Math.max(o,1e-10));return new k(t.lng*i*e,s)},unproject:function(t){for(var i,e=180/Math.PI,s=this.R,n=this.R_MINOR/s,o=Math.sqrt(1-n*n),a=Math.exp(-t.y/s),r=Math.PI/2-2*Math.atan(a),h=0,l=.1;h<15&&1e-7<Math.abs(l);h++)i=o*Math.sin(r),i=Math.pow((1-i)/(1+i),o/2),r+=l=Math.PI/2-2*Math.atan(a*i)-r;return new j(r*e,t.x*e/s)}},rt={LonLat:nt,Mercator:dt,SphericalMercator:U},z=h({},G,{code:"EPSG:3395",projection:dt,transformation:H(ht=.5/(Math.PI*dt.R),.5,-ht,.5)}),re=h({},G,{code:"EPSG:4326",projection:nt,transformation:H(1/180,1,-1/180,.5)}),U=h({},q,{projection:nt,transformation:H(1,0,-1,0),scale:function(t){return Math.pow(2,t)},zoom:function(t){return Math.log(t)/Math.LN2},distance:function(t,i){var e=i.lng-t.lng,t=i.lat-t.lat;return Math.sqrt(e*e+t*t)},infinite:!0});q.Earth=G,q.EPSG3395=z,q.EPSG3857=V,q.EPSG900913=K,q.EPSG4326=re,q.Simple=U;var he=A.extend({options:{pane:"overlayPane",attribution:null,bubblingMouseEvents:!0},addTo:function(t){return t.addLayer(this),this},remove:function(){return this.removeFrom(this._map||this._mapToAdd)},removeFrom:function(t){return t&&t.removeLayer(this),this},getPane:function(t){return this._map.getPane(t?this.options[t]||t:this.options.pane)},addInteractiveTarget:function(t){return this._map._targets[m(t)]=this},removeInteractiveTarget:function(t){return delete this._map._targets[m(t)],this},getAttribution:function(){return this.options.attribution},_layerAdd:function(t){var i,e=t.target;e.hasLayer(this)&&(this._map=e,this._zoomAnimated=e._zoomAnimated,this.getEvents&&(i=this.getEvents(),e.on(i,this),this.once("remove",function(){e.off(i,this)},this)),this.onAdd(e),this.getAttribution&&e.attributionControl&&e.attributionControl.addAttribution(this.getAttribution()),this.fire("add"),e.fire("layeradd",{layer:this}))}});Di.include({addLayer:function(t){if(!t._layerAdd)throw new Error("The provided object is not a Layer.");var i=m(t);return this._layers[i]||((this._layers[i]=t)._mapToAdd=this,t.beforeAdd&&t.beforeAdd(this),this.whenReady(t._layerAdd,t)),this},removeLayer:function(t){var i=m(t);return this._layers[i]&&(this._loaded&&t.onRemove(this),t.getAttribution&&this.attributionControl&&this.attributionControl.removeAttribution(t.getAttribution()),delete this._layers[i],this._loaded&&(this.fire("layerremove",{layer:t}),t.fire("remove")),t._map=t._mapToAdd=null),this},hasLayer:function(t){return!!t&&m(t)in this._layers},eachLayer:function(t,i){for(var e in this._layers)t.call(i,this._layers[e]);return this},_addLayers:function(t){for(var i=0,e=(t=t?g(t)?t:[t]:[]).length;i<e;i++)this.addLayer(t[i])},_addZoomLimit:function(t){!isNaN(t.options.maxZoom)&&isNaN(t.options.minZoom)||(this._zoomBoundLayers[m(t)]=t,this._updateZoomLevels())},_removeZoomLimit:function(t){t=m(t);this._zoomBoundLayers[t]&&(delete this._zoomBoundLayers[t],this._updateZoomLevels())},_updateZoomLevels:function(){var t,i=1/0,e=-1/0,s=this._getZoomSpan();for(t in this._zoomBoundLayers)var n=this._zoomBoundLayers[t].options,i=void 0===n.minZoom?i:Math.min(i,n.minZoom),e=void 0===n.maxZoom?e:Math.max(e,n.maxZoom);this._layersMaxZoom=e===-1/0?void 0:e,this._layersMinZoom=i===1/0?void 0:i,s!==this._getZoomSpan()&&this.fire("zoomlevelschange"),void 0===this.options.maxZoom&&this._layersMaxZoom&&this.getZoom()>this._layersMaxZoom&&this.setZoom(this._layersMaxZoom),void 0===this.options.minZoom&&this._layersMinZoom&&this.getZoom()<this._layersMinZoom&&this.setZoom(this._layersMinZoom)}});var le=he.extend({initialize:function(t,i){var e,s;if(c(this,i),this._layers={},t)for(e=0,s=t.length;e<s;e++)this.addLayer(t[e])},addLayer:function(t){var i=this.getLayerId(t);return this._layers[i]=t,this._map&&this._map.addLayer(t),this},removeLayer:function(t){t=t in this._layers?t:this.getLayerId(t);return this._map&&this._layers[t]&&this._map.removeLayer(this._layers[t]),delete this._layers[t],this},hasLayer:function(t){return!!t&&("number"==typeof t?t:this.getLayerId(t))in this._layers},clearLayers:function(){return this.eachLayer(this.removeLayer,this)},invoke:function(t){var i,e,s=Array.prototype.slice.call(arguments,1);for(i in this._layers)(e=this._layers[i])[t]&&e[t].apply(e,s);return this},onAdd:function(t){this.eachLayer(t.addLayer,t)},onRemove:function(t){this.eachLayer(t.removeLayer,t)},eachLayer:function(t,i){for(var e in this._layers)t.call(i,this._layers[e]);return this},getLayer:function(t){return this._layers[t]},getLayers:function(){var t=[];return this.eachLayer(t.push,t),t},setZIndex:function(t){return this.invoke("setZIndex",t)},getLayerId:m}),ue=le.extend({addLayer:function(t){return this.hasLayer(t)?this:(t.addEventParent(this),le.prototype.addLayer.call(this,t),this.fire("layeradd",{layer:t}))},removeLayer:function(t){return this.hasLayer(t)?((t=t in this._layers?this._layers[t]:t).removeEventParent(this),le.prototype.removeLayer.call(this,t),this.fire("layerremove",{layer:t})):this},setStyle:function(t){return this.invoke("setStyle",t)},bringToFront:function(){return this.invoke("bringToFront")},bringToBack:function(){return this.invoke("bringToBack")},getBounds:function(){var t,i=new Z;for(t in this._layers){var e=this._layers[t];i.extend(e.getBounds?e.getBounds():e.getLatLng())}return i}}),ce=E.extend({options:{popupAnchor:[0,0],tooltipAnchor:[0,0]},initialize:function(t){c(this,t)},createIcon:function(t){return this._createIcon("icon",t)},createShadow:function(t){return this._createIcon("shadow",t)},_createIcon:function(t,i){var e=this._getIconUrl(t);if(!e){if("icon"===t)throw new Error("iconUrl not set in Icon options (see the docs).");return null}i=this._createImg(e,i&&"IMG"===i.tagName?i:null);return this._setIconStyles(i,t),i},_setIconStyles:function(t,i){var e=this.options,s=e[i+"Size"],n=O(s="number"==typeof s?[s,s]:s),s=O("shadow"===i&&e.shadowAnchor||e.iconAnchor||n&&n.divideBy(2,!0));t.className="leaflet-marker-"+i+" "+(e.className||""),s&&(t.style.marginLeft=-s.x+"px",t.style.marginTop=-s.y+"px"),n&&(t.style.width=n.x+"px",t.style.height=n.y+"px")},_createImg:function(t,i){return(i=i||document.createElement("img")).src=t,i},_getIconUrl:function(t){return bt&&this.options[t+"RetinaUrl"]||this.options[t+"Url"]}});var de=ce.extend({options:{iconUrl:"marker-icon.png",iconRetinaUrl:"marker-icon-2x.png",shadowUrl:"marker-shadow.png",iconSize:[25,41],iconAnchor:[12,41],popupAnchor:[1,-34],tooltipAnchor:[16,-28],shadowSize:[41,41]},_getIconUrl:function(t){return de.imagePath||(de.imagePath=this._detectIconPath()),(this.options.imagePath||de.imagePath)+ce.prototype._getIconUrl.call(this,t)},_detectIconPath:function(){var t=$t("div","leaflet-default-icon-path",document.body),i=Yt(t,"background-image")||Yt(t,"backgroundImage");return document.body.removeChild(t),i=null===i||0!==i.indexOf("url")?"":i.replace(/^url\(["']?/,"").replace(/marker-icon\.png["']?\)$/,"")}}),_e=mt.extend({initialize:function(t){this._marker=t},addHooks:function(){var t=this._marker._icon;this._draggable||(this._draggable=new Qi(t,t,!0)),this._draggable.on({dragstart:this._onDragStart,predrag:this._onPreDrag,drag:this._onDrag,dragend:this._onDragEnd},this).enable(),oi(t,"leaflet-marker-draggable")},removeHooks:function(){this._draggable.off({dragstart:this._onDragStart,predrag:this._onPreDrag,drag:this._onDrag,dragend:this._onDragEnd},this).disable(),this._marker._icon&&ai(this._marker._icon,"leaflet-marker-draggable")},moved:function(){return this._draggable&&this._draggable._moved},_adjustPan:function(t){var i=this._marker,e=i._map,s=this._marker.options.autoPanSpeed,n=this._marker.options.autoPanPadding,o=_i(i._icon),a=e.getPixelBounds(),r=e.getPixelOrigin(),n=B(a.min._subtract(r).add(n),a.max._subtract(r).subtract(n));n.contains(o)||(s=O((Math.max(n.max.x,o.x)-n.max.x)/(a.max.x-n.max.x)-(Math.min(n.min.x,o.x)-n.min.x)/(a.min.x-n.min.x),(Math.max(n.max.y,o.y)-n.max.y)/(a.max.y-n.max.y)-(Math.min(n.min.y,o.y)-n.min.y)/(a.min.y-n.min.y)).multiplyBy(s),e.panBy(s,{animate:!1}),this._draggable._newPos._add(s),this._draggable._startPos._add(s),di(i._icon,this._draggable._newPos),this._onDrag(t),this._panRequest=T(this._adjustPan.bind(this,t)))},_onDragStart:function(){this._oldLatLng=this._marker.getLatLng(),this._marker.closePopup&&this._marker.closePopup(),this._marker.fire("movestart").fire("dragstart")},_onPreDrag:function(t){this._marker.options.autoPan&&(C(this._panRequest),this._panRequest=T(this._adjustPan.bind(this,t)))},_onDrag:function(t){var i=this._marker,e=i._shadow,s=_i(i._icon),n=i._map.layerPointToLatLng(s);e&&di(e,s),i._latlng=n,t.latlng=n,t.oldLatLng=this._oldLatLng,i.fire("move",t).fire("drag",t)},_onDragEnd:function(t){C(this._panRequest),delete this._oldLatLng,this._marker.fire("moveend").fire("dragend",t)}}),pe=he.extend({options:{icon:new de,interactive:!0,keyboard:!0,title:"",alt:"",zIndexOffset:0,opacity:1,riseOnHover:!1,riseOffset:250,pane:"markerPane",shadowPane:"shadowPane",bubblingMouseEvents:!1,draggable:!1,autoPan:!1,autoPanPadding:[50,50],autoPanSpeed:10},initialize:function(t,i){c(this,i),this._latlng=D(t)},onAdd:function(t){this._zoomAnimated=this._zoomAnimated&&t.options.markerZoomAnimation,this._zoomAnimated&&t.on("zoomanim",this._animateZoom,this),this._initIcon(),this.update()},onRemove:function(t){this.dragging&&this.dragging.enabled()&&(this.options.draggable=!0,this.dragging.removeHooks()),delete this.dragging,this._zoomAnimated&&t.off("zoomanim",this._animateZoom,this),this._removeIcon(),this._removeShadow()},getEvents:function(){return{zoom:this.update,viewreset:this.update}},getLatLng:function(){return this._latlng},setLatLng:function(t){var i=this._latlng;return this._latlng=D(t),this.update(),this.fire("move",{oldLatLng:i,latlng:this._latlng})},setZIndexOffset:function(t){return this.options.zIndexOffset=t,this.update()},getIcon:function(){return this.options.icon},setIcon:function(t){return this.options.icon=t,this._map&&(this._initIcon(),this.update()),this._popup&&this.bindPopup(this._popup,this._popup.options),this},getElement:function(){return this._icon},update:function(){var t;return this._icon&&this._map&&(t=this._map.latLngToLayerPoint(this._latlng).round(),this._setPos(t)),this},_initIcon:function(){var t=this.options,i="leaflet-zoom-"+(this._zoomAnimated?"animated":"hide"),e=t.icon.createIcon(this._icon),s=!1;e!==this._icon&&(this._icon&&this._removeIcon(),s=!0,t.title&&(e.title=t.title),"IMG"===e.tagName&&(e.alt=t.alt||"")),oi(e,i),t.keyboard&&(e.tabIndex="0"),this._icon=e,t.riseOnHover&&this.on({mouseover:this._bringToFront,mouseout:this._resetZIndex});var n=t.icon.createShadow(this._shadow),e=!1;n!==this._shadow&&(this._removeShadow(),e=!0),n&&(oi(n,i),n.alt=""),this._shadow=n,t.opacity<1&&this._updateOpacity(),s&&this.getPane().appendChild(this._icon),this._initInteraction(),n&&e&&this.getPane(t.shadowPane).appendChild(this._shadow)},_removeIcon:function(){this.options.riseOnHover&&this.off({mouseover:this._bringToFront,mouseout:this._resetZIndex}),ti(this._icon),this.removeInteractiveTarget(this._icon),this._icon=null},_removeShadow:function(){this._shadow&&ti(this._shadow),this._shadow=null},_setPos:function(t){this._icon&&di(this._icon,t),this._shadow&&di(this._shadow,t),this._zIndex=t.y+this.options.zIndexOffset,this._resetZIndex()},_updateZIndex:function(t){this._icon&&(this._icon.style.zIndex=this._zIndex+t)},_animateZoom:function(t){t=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center).round();this._setPos(t)},_initInteraction:function(){var t;this.options.interactive&&(oi(this._icon,"leaflet-interactive"),this.addInteractiveTarget(this._icon),_e&&(t=this.options.draggable,this.dragging&&(t=this.dragging.enabled(),this.dragging.disable()),this.dragging=new _e(this),t&&this.dragging.enable()))},setOpacity:function(t){return this.options.opacity=t,this._map&&this._updateOpacity(),this},_updateOpacity:function(){var t=this.options.opacity;this._icon&&li(this._icon,t),this._shadow&&li(this._shadow,t)},_bringToFront:function(){this._updateZIndex(this.options.riseOffset)},_resetZIndex:function(){this._updateZIndex(0)},_getPopupAnchor:function(){return this.options.icon.options.popupAnchor},_getTooltipAnchor:function(){return this.options.icon.options.tooltipAnchor}});var me=he.extend({options:{stroke:!0,color:"#3388ff",weight:3,opacity:1,lineCap:"round",lineJoin:"round",dashArray:null,dashOffset:null,fill:!1,fillColor:null,fillOpacity:.2,fillRule:"evenodd",interactive:!0,bubblingMouseEvents:!0},beforeAdd:function(t){this._renderer=t.getRenderer(this)},onAdd:function(){this._renderer._initPath(this),this._reset(),this._renderer._addPath(this)},onRemove:function(){this._renderer._removePath(this)},redraw:function(){return this._map&&this._renderer._updatePath(this),this},setStyle:function(t){return c(this,t),this._renderer&&(this._renderer._updateStyle(this),this.options.stroke&&t&&Object.prototype.hasOwnProperty.call(t,"weight")&&this._updateBounds()),this},bringToFront:function(){return this._renderer&&this._renderer._bringToFront(this),this},bringToBack:function(){return this._renderer&&this._renderer._bringToBack(this),this},getElement:function(){return this._path},_reset:function(){this._project(),this._update()},_clickTolerance:function(){return(this.options.stroke?this.options.weight/2:0)+this._renderer.options.tolerance}}),fe=me.extend({options:{fill:!0,radius:10},initialize:function(t,i){c(this,i),this._latlng=D(t),this._radius=this.options.radius},setLatLng:function(t){var i=this._latlng;return this._latlng=D(t),this.redraw(),this.fire("move",{oldLatLng:i,latlng:this._latlng})},getLatLng:function(){return this._latlng},setRadius:function(t){return this.options.radius=this._radius=t,this.redraw()},getRadius:function(){return this._radius},setStyle:function(t){var i=t&&t.radius||this._radius;return me.prototype.setStyle.call(this,t),this.setRadius(i),this},_project:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._updateBounds()},_updateBounds:function(){var t=this._radius,i=this._radiusY||t,e=this._clickTolerance(),e=[t+e,i+e];this._pxBounds=new N(this._point.subtract(e),this._point.add(e))},_update:function(){this._map&&this._updatePath()},_updatePath:function(){this._renderer._updateCircle(this)},_empty:function(){return this._radius&&!this._renderer._bounds.intersects(this._pxBounds)},_containsPoint:function(t){return t.distanceTo(this._point)<=this._radius+this._clickTolerance()}});var ge=fe.extend({initialize:function(t,i,e){if(c(this,i="number"==typeof i?h({},e,{radius:i}):i),this._latlng=D(t),isNaN(this.options.radius))throw new Error("Circle radius cannot be NaN");this._mRadius=this.options.radius},setRadius:function(t){return this._mRadius=t,this.redraw()},getRadius:function(){return this._mRadius},getBounds:function(){var t=[this._radius,this._radiusY||this._radius];return new Z(this._map.layerPointToLatLng(this._point.subtract(t)),this._map.layerPointToLatLng(this._point.add(t)))},setStyle:me.prototype.setStyle,_project:function(){var t,i,e,s,n,o=this._latlng.lng,a=this._latlng.lat,r=this._map,h=r.options.crs;h.distance===G.distance?(n=Math.PI/180,t=this._mRadius/G.R/n,i=r.project([a+t,o]),s=r.project([a-t,o]),e=i.add(s).divideBy(2),s=r.unproject(e).lat,n=Math.acos((Math.cos(t*n)-Math.sin(a*n)*Math.sin(s*n))/(Math.cos(a*n)*Math.cos(s*n)))/n,!isNaN(n)&&0!==n||(n=t/Math.cos(Math.PI/180*a)),this._point=e.subtract(r.getPixelOrigin()),this._radius=isNaN(n)?0:e.x-r.project([s,o-n]).x,this._radiusY=e.y-i.y):(h=h.unproject(h.project(this._latlng).subtract([this._mRadius,0])),this._point=r.latLngToLayerPoint(this._latlng),this._radius=this._point.x-r.latLngToLayerPoint(h).x),this._updateBounds()}});var ye=me.extend({options:{smoothFactor:1,noClip:!1},initialize:function(t,i){c(this,i),this._setLatLngs(t)},getLatLngs:function(){return this._latlngs},setLatLngs:function(t){return this._setLatLngs(t),this.redraw()},isEmpty:function(){return!this._latlngs.length},closestLayerPoint:function(t){for(var i=1/0,e=null,s=se,n=0,o=this._parts.length;n<o;n++)for(var a=this._parts[n],r=1,h=a.length;r<h;r++){var l,u,c=s(t,l=a[r-1],u=a[r],!0);c<i&&(i=c,e=s(t,l,u))}return e&&(e.distance=Math.sqrt(i)),e},getCenter:function(){if(!this._map)throw new Error("Must add layer to map before using getCenter()");var t,i,e,s,n,o,a=this._rings[0],r=a.length;if(!r)return null;for(i=t=0;t<r-1;t++)i+=a[t].distanceTo(a[t+1])/2;if(0===i)return this._map.layerPointToLatLng(a[0]);for(e=t=0;t<r-1;t++)if(s=a[t],n=a[t+1],i<(e+=o=s.distanceTo(n)))return this._map.layerPointToLatLng([n.x-(o=(e-i)/o)*(n.x-s.x),n.y-o*(n.y-s.y)])},getBounds:function(){return this._bounds},addLatLng:function(t,i){return i=i||this._defaultShape(),t=D(t),i.push(t),this._bounds.extend(t),this.redraw()},_setLatLngs:function(t){this._bounds=new Z,this._latlngs=this._convertLatLngs(t)},_defaultShape:function(){return ne(this._latlngs)?this._latlngs:this._latlngs[0]},_convertLatLngs:function(t){for(var i=[],e=ne(t),s=0,n=t.length;s<n;s++)e?(i[s]=D(t[s]),this._bounds.extend(i[s])):i[s]=this._convertLatLngs(t[s]);return i},_project:function(){var t=new N;this._rings=[],this._projectLatlngs(this._latlngs,this._rings,t),this._bounds.isValid()&&t.isValid()&&(this._rawPxBounds=t,this._updateBounds())},_updateBounds:function(){var t=this._clickTolerance(),t=new k(t,t);this._pxBounds=new N([this._rawPxBounds.min.subtract(t),this._rawPxBounds.max.add(t)])},_projectLatlngs:function(t,i,e){var s,n,o=t[0]instanceof j,a=t.length;if(o){for(n=[],s=0;s<a;s++)n[s]=this._map.latLngToLayerPoint(t[s]),e.extend(n[s]);i.push(n)}else for(s=0;s<a;s++)this._projectLatlngs(t[s],i,e)},_clipPoints:function(){var t=this._renderer._bounds;if(this._parts=[],this._pxBounds&&this._pxBounds.intersects(t))if(this.options.noClip)this._parts=this._rings;else for(var i,e,s,n,o=this._parts,a=0,r=0,h=this._rings.length;a<h;a++)for(i=0,e=(n=this._rings[a]).length;i<e-1;i++)(s=te(n[i],n[i+1],t,i,!0))&&(o[r]=o[r]||[],o[r].push(s[0]),s[1]===n[i+1]&&i!==e-2||(o[r].push(s[1]),r++))},_simplifyPoints:function(){for(var t=this._parts,i=this.options.smoothFactor,e=0,s=t.length;e<s;e++)t[e]=Yi(t[e],i)},_update:function(){this._map&&(this._clipPoints(),this._simplifyPoints(),this._updatePath())},_updatePath:function(){this._renderer._updatePoly(this)},_containsPoint:function(t,i){var e,s,n,o,a,r,h=this._clickTolerance();if(!this._pxBounds||!this._pxBounds.contains(t))return!1;for(e=0,o=this._parts.length;e<o;e++)for(s=0,n=(a=(r=this._parts[e]).length)-1;s<a;n=s++)if((i||0!==s)&&$i(t,r[n],r[s])<=h)return!0;return!1}});ye._flat=oe;var ve=ye.extend({options:{fill:!0},isEmpty:function(){return!this._latlngs.length||!this._latlngs[0].length},getCenter:function(){if(!this._map)throw new Error("Must add layer to map before using getCenter()");var t,i,e,s,n,o,a,r,h,l=this._rings[0],u=l.length;if(!u)return null;for(t=o=a=r=0,i=u-1;t<u;i=t++)e=l[t],s=l[i],n=e.y*s.x-s.y*e.x,a+=(e.x+s.x)*n,r+=(e.y+s.y)*n,o+=3*n;return h=0===o?l[0]:[a/o,r/o],this._map.layerPointToLatLng(h)},_convertLatLngs:function(t){var i=ye.prototype._convertLatLngs.call(this,t),t=i.length;return 2<=t&&i[0]instanceof j&&i[0].equals(i[t-1])&&i.pop(),i},_setLatLngs:function(t){ye.prototype._setLatLngs.call(this,t),ne(this._latlngs)&&(this._latlngs=[this._latlngs])},_defaultShape:function(){return(ne(this._latlngs[0])?this._latlngs:this._latlngs[0])[0]},_clipPoints:function(){var t=this._renderer._bounds,i=this.options.weight,i=new k(i,i),t=new N(t.min.subtract(i),t.max.add(i));if(this._parts=[],this._pxBounds&&this._pxBounds.intersects(t))if(this.options.noClip)this._parts=this._rings;else for(var e,s=0,n=this._rings.length;s<n;s++)(e=ae(this._rings[s],t,!0)).length&&this._parts.push(e)},_updatePath:function(){this._renderer._updatePoly(this,!0)},_containsPoint:function(t){var i,e,s,n,o,a,r,h,l=!1;if(!this._pxBounds||!this._pxBounds.contains(t))return!1;for(n=0,r=this._parts.length;n<r;n++)for(o=0,a=(h=(i=this._parts[n]).length)-1;o<h;a=o++)e=i[o],s=i[a],e.y>t.y!=s.y>t.y&&t.x<(s.x-e.x)*(t.y-e.y)/(s.y-e.y)+e.x&&(l=!l);return l||ye.prototype._containsPoint.call(this,t,!0)}});var Me=ue.extend({initialize:function(t,i){c(this,i),this._layers={},t&&this.addData(t)},addData:function(t){var i,e,s,n=g(t)?t:t.features;if(n){for(i=0,e=n.length;i<e;i++)((s=n[i]).geometries||s.geometry||s.features||s.coordinates)&&this.addData(s);return this}var o=this.options;if(o.filter&&!o.filter(t))return this;var a=xe(t,o);return a?(a.feature=Se(t),a.defaultOptions=a.options,this.resetStyle(a),o.onEachFeature&&o.onEachFeature(t,a),this.addLayer(a)):this},resetStyle:function(t){return void 0===t?this.eachLayer(this.resetStyle,this):(t.options=h({},t.defaultOptions),this._setLayerStyle(t,this.options.style),this)},setStyle:function(i){return this.eachLayer(function(t){this._setLayerStyle(t,i)},this)},_setLayerStyle:function(t,i){t.setStyle&&("function"==typeof i&&(i=i(t.feature)),t.setStyle(i))}});function xe(t,i){var e,s,n,o,a="Feature"===t.type?t.geometry:t,r=a?a.coordinates:null,h=[],l=i&&i.pointToLayer,u=i&&i.coordsToLatLng||we;if(!r&&!a)return null;switch(a.type){case"Point":return be(l,t,e=u(r),i);case"MultiPoint":for(n=0,o=r.length;n<o;n++)e=u(r[n]),h.push(be(l,t,e,i));return new ue(h);case"LineString":case"MultiLineString":return s=Pe(r,"LineString"===a.type?0:1,u),new ye(s,i);case"Polygon":case"MultiPolygon":return s=Pe(r,"Polygon"===a.type?1:2,u),new ve(s,i);case"GeometryCollection":for(n=0,o=a.geometries.length;n<o;n++){var c=xe({geometry:a.geometries[n],type:"Feature",properties:t.properties},i);c&&h.push(c)}return new ue(h);default:throw new Error("Invalid GeoJSON object.")}}function be(t,i,e,s){return t?t(i,e):new pe(e,s&&s.markersInheritOptions&&s)}function we(t){return new j(t[1],t[0],t[2])}function Pe(t,i,e){for(var s,n=[],o=0,a=t.length;o<a;o++)s=i?Pe(t[o],i-1,e):(e||we)(t[o]),n.push(s);return n}function Le(t,i){return i="number"==typeof i?i:6,void 0!==t.alt?[a(t.lng,i),a(t.lat,i),a(t.alt,i)]:[a(t.lng,i),a(t.lat,i)]}function Te(t,i,e,s){for(var n=[],o=0,a=t.length;o<a;o++)n.push(i?Te(t[o],i-1,e,s):Le(t[o],s));return!i&&e&&n.push(n[0]),n}function Ce(t,i){return t.feature?h({},t.feature,{geometry:i}):Se(i)}function Se(t){return"Feature"===t.type||"FeatureCollection"===t.type?t:{type:"Feature",properties:{},geometry:t}}dt={toGeoJSON:function(t){return Ce(this,{type:"Point",coordinates:Le(this.getLatLng(),t)})}};function Ee(t,i){return new Me(t,i)}pe.include(dt),ge.include(dt),fe.include(dt),ye.include({toGeoJSON:function(t){var i=!ne(this._latlngs);return Ce(this,{type:(i?"Multi":"")+"LineString",coordinates:Te(this._latlngs,i?1:0,!1,t)})}}),ve.include({toGeoJSON:function(t){var i=!ne(this._latlngs),e=i&&!ne(this._latlngs[0]),t=Te(this._latlngs,e?2:i?1:0,!0,t);return Ce(this,{type:(e?"Multi":"")+"Polygon",coordinates:t=!i?[t]:t})}}),le.include({toMultiPoint:function(i){var e=[];return this.eachLayer(function(t){e.push(t.toGeoJSON(i).geometry.coordinates)}),Ce(this,{type:"MultiPoint",coordinates:e})},toGeoJSON:function(i){var t=this.feature&&this.feature.geometry&&this.feature.geometry.type;if("MultiPoint"===t)return this.toMultiPoint(i);var e="GeometryCollection"===t,s=[];return this.eachLayer(function(t){t.toGeoJSON&&(t=t.toGeoJSON(i),e?s.push(t.geometry):"FeatureCollection"===(t=Se(t)).type?s.push.apply(s,t.features):s.push(t))}),e?Ce(this,{geometries:s,type:"GeometryCollection"}):{type:"FeatureCollection",features:s}}});var ht=Ee,ze=he.extend({options:{opacity:1,alt:"",interactive:!1,crossOrigin:!1,errorOverlayUrl:"",zIndex:1,className:""},initialize:function(t,i,e){this._url=t,this._bounds=R(i),c(this,e)},onAdd:function(){this._image||(this._initImage(),this.options.opacity<1&&this._updateOpacity()),this.options.interactive&&(oi(this._image,"leaflet-interactive"),this.addInteractiveTarget(this._image)),this.getPane().appendChild(this._image),this._reset()},onRemove:function(){ti(this._image),this.options.interactive&&this.removeInteractiveTarget(this._image)},setOpacity:function(t){return this.options.opacity=t,this._image&&this._updateOpacity(),this},setStyle:function(t){return t.opacity&&this.setOpacity(t.opacity),this},bringToFront:function(){return this._map&&ei(this._image),this},bringToBack:function(){return this._map&&si(this._image),this},setUrl:function(t){return this._url=t,this._image&&(this._image.src=t),this},setBounds:function(t){return this._bounds=R(t),this._map&&this._reset(),this},getEvents:function(){var t={zoom:this._reset,viewreset:this._reset};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},getBounds:function(){return this._bounds},getElement:function(){return this._image},_initImage:function(){var t="IMG"===this._url.tagName,i=this._image=t?this._url:$t("img");oi(i,"leaflet-image-layer"),this._zoomAnimated&&oi(i,"leaflet-zoom-animated"),this.options.className&&oi(i,this.options.className),i.onselectstart=r,i.onmousemove=r,i.onload=d(this.fire,this,"load"),i.onerror=d(this._overlayOnError,this,"error"),!this.options.crossOrigin&&""!==this.options.crossOrigin||(i.crossOrigin=!0===this.options.crossOrigin?"":this.options.crossOrigin),this.options.zIndex&&this._updateZIndex(),t?this._url=i.src:(i.src=this._url,i.alt=this.options.alt)},_animateZoom:function(t){var i=this._map.getZoomScale(t.zoom),t=this._map._latLngBoundsToNewLayerBounds(this._bounds,t.zoom,t.center).min;ci(this._image,t,i)},_reset:function(){var t=this._image,i=new N(this._map.latLngToLayerPoint(this._bounds.getNorthWest()),this._map.latLngToLayerPoint(this._bounds.getSouthEast())),e=i.getSize();di(t,i.min),t.style.width=e.x+"px",t.style.height=e.y+"px"},_updateOpacity:function(){li(this._image,this.options.opacity)},_updateZIndex:function(){this._image&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._image.style.zIndex=this.options.zIndex)},_overlayOnError:function(){this.fire("error");var t=this.options.errorOverlayUrl;t&&this._url!==t&&(this._url=t,this._image.src=t)}}),Ae=ze.extend({options:{autoplay:!0,loop:!0,keepAspectRatio:!0,muted:!1},_initImage:function(){var t="VIDEO"===this._url.tagName,i=this._image=t?this._url:$t("video");if(oi(i,"leaflet-image-layer"),this._zoomAnimated&&oi(i,"leaflet-zoom-animated"),this.options.className&&oi(i,this.options.className),i.onselectstart=r,i.onmousemove=r,i.onloadeddata=d(this.fire,this,"load"),t){for(var e=i.getElementsByTagName("source"),s=[],n=0;n<e.length;n++)s.push(e[n].src);this._url=0<e.length?s:[i.src]}else{g(this._url)||(this._url=[this._url]),!this.options.keepAspectRatio&&Object.prototype.hasOwnProperty.call(i.style,"objectFit")&&(i.style.objectFit="fill"),i.autoplay=!!this.options.autoplay,i.loop=!!this.options.loop,i.muted=!!this.options.muted;for(var o=0;o<this._url.length;o++){var a=$t("source");a.src=this._url[o],i.appendChild(a)}}}});var ke=ze.extend({_initImage:function(){var t=this._image=this._url;oi(t,"leaflet-image-layer"),this._zoomAnimated&&oi(t,"leaflet-zoom-animated"),this.options.className&&oi(t,this.options.className),t.onselectstart=r,t.onmousemove=r}});var Ie=he.extend({options:{offset:[0,7],className:"",pane:"popupPane"},initialize:function(t,i){c(this,t),this._source=i},onAdd:function(t){this._zoomAnimated=t._zoomAnimated,this._container||this._initLayout(),t._fadeAnimated&&li(this._container,0),clearTimeout(this._removeTimeout),this.getPane().appendChild(this._container),this.update(),t._fadeAnimated&&li(this._container,1),this.bringToFront()},onRemove:function(t){t._fadeAnimated?(li(this._container,0),this._removeTimeout=setTimeout(d(ti,void 0,this._container),200)):ti(this._container)},getLatLng:function(){return this._latlng},setLatLng:function(t){return this._latlng=D(t),this._map&&(this._updatePosition(),this._adjustPan()),this},getContent:function(){return this._content},setContent:function(t){return this._content=t,this.update(),this},getElement:function(){return this._container},update:function(){this._map&&(this._container.style.visibility="hidden",this._updateContent(),this._updateLayout(),this._updatePosition(),this._container.style.visibility="",this._adjustPan())},getEvents:function(){var t={zoom:this._updatePosition,viewreset:this._updatePosition};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},isOpen:function(){return!!this._map&&this._map.hasLayer(this)},bringToFront:function(){return this._map&&ei(this._container),this},bringToBack:function(){return this._map&&si(this._container),this},_prepareOpen:function(t,i,e){if(i instanceof he||(e=i,i=t),i instanceof ue)for(var s in t._layers){i=t._layers[s];break}if(!e)if(i.getCenter)e=i.getCenter();else{if(!i.getLatLng)throw new Error("Unable to get source layer LatLng.");e=i.getLatLng()}return this._source=i,this.update(),e},_updateContent:function(){if(this._content){var t=this._contentNode,i="function"==typeof this._content?this._content(this._source||this):this._content;if("string"==typeof i)t.innerHTML=i;else{for(;t.hasChildNodes();)t.removeChild(t.firstChild);t.appendChild(i)}this.fire("contentupdate")}},_updatePosition:function(){var t,i,e;this._map&&(t=this._map.latLngToLayerPoint(this._latlng),e=O(this.options.offset),i=this._getAnchor(),this._zoomAnimated?di(this._container,t.add(i)):e=e.add(t).add(i),i=this._containerBottom=-e.y,e=this._containerLeft=-Math.round(this._containerWidth/2)+e.x,this._container.style.bottom=i+"px",this._container.style.left=e+"px")},_getAnchor:function(){return[0,0]}}),Oe=Ie.extend({options:{maxWidth:300,minWidth:50,maxHeight:null,autoPan:!0,autoPanPaddingTopLeft:null,autoPanPaddingBottomRight:null,autoPanPadding:[5,5],keepInView:!1,closeButton:!0,autoClose:!0,closeOnEscapeKey:!0,className:""},openOn:function(t){return t.openPopup(this),this},onAdd:function(t){Ie.prototype.onAdd.call(this,t),t.fire("popupopen",{popup:this}),this._source&&(this._source.fire("popupopen",{popup:this},!0),this._source instanceof me||this._source.on("preclick",Ci))},onRemove:function(t){Ie.prototype.onRemove.call(this,t),t.fire("popupclose",{popup:this}),this._source&&(this._source.fire("popupclose",{popup:this},!0),this._source instanceof me||this._source.off("preclick",Ci))},getEvents:function(){var t=Ie.prototype.getEvents.call(this);return(void 0!==this.options.closeOnClick?this.options.closeOnClick:this._map.options.closePopupOnClick)&&(t.preclick=this._close),this.options.keepInView&&(t.moveend=this._adjustPan),t},_close:function(){this._map&&this._map.closePopup(this)},_initLayout:function(){var t="leaflet-popup",i=this._container=$t("div",t+" "+(this.options.className||"")+" leaflet-zoom-animated"),e=this._wrapper=$t("div",t+"-content-wrapper",i);this._contentNode=$t("div",t+"-content",e),Ei(i),Si(this._contentNode),Mi(i,"contextmenu",Ci),this._tipContainer=$t("div",t+"-tip-container",i),this._tip=$t("div",t+"-tip",this._tipContainer),this.options.closeButton&&((i=this._closeButton=$t("a",t+"-close-button",i)).href="#close",i.innerHTML="&#215;",Mi(i,"click",this._onCloseButtonClick,this))},_updateLayout:function(){var t=this._contentNode,i=t.style;i.width="",i.whiteSpace="nowrap";var e=t.offsetWidth,e=Math.min(e,this.options.maxWidth);e=Math.max(e,this.options.minWidth),i.width=e+1+"px",i.whiteSpace="",i.height="";var s=t.offsetHeight,n=this.options.maxHeight,e="leaflet-popup-scrolled";n&&n<s?(i.height=n+"px",oi(t,e)):ai(t,e),this._containerWidth=this._container.offsetWidth},_animateZoom:function(t){var i=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center),t=this._getAnchor();di(this._container,i.add(t))},_adjustPan:function(){var t,i,e,s,n,o,a,r;this.options.autoPan&&(this._map._panAnim&&this._map._panAnim.stop(),t=this._map,n=parseInt(Yt(this._container,"marginBottom"),10)||0,i=this._container.offsetHeight+n,r=this._containerWidth,(o=new k(this._containerLeft,-i-this._containerBottom))._add(_i(this._container)),e=t.layerPointToContainerPoint(o),a=O(this.options.autoPanPadding),s=O(this.options.autoPanPaddingTopLeft||a),n=O(this.options.autoPanPaddingBottomRight||a),o=t.getSize(),a=0,e.x+r+n.x>o.x&&(a=e.x+r-o.x+n.x),e.x-a-s.x<(r=0)&&(a=e.x-s.x),e.y+i+n.y>o.y&&(r=e.y+i-o.y+n.y),e.y-r-s.y<0&&(r=e.y-s.y),(a||r)&&t.fire("autopanstart").panBy([a,r]))},_onCloseButtonClick:function(t){this._close(),Ai(t)},_getAnchor:function(){return O(this._source&&this._source._getPopupAnchor?this._source._getPopupAnchor():[0,0])}});Di.mergeOptions({closePopupOnClick:!0}),Di.include({openPopup:function(t,i,e){return t instanceof Oe||(t=new Oe(e).setContent(t)),i&&t.setLatLng(i),this.hasLayer(t)?this:(this._popup&&this._popup.options.autoClose&&this.closePopup(),this._popup=t,this.addLayer(t))},closePopup:function(t){return t&&t!==this._popup||(t=this._popup,this._popup=null),t&&this.removeLayer(t),this}}),he.include({bindPopup:function(t,i){return t instanceof Oe?(c(t,i),(this._popup=t)._source=this):(this._popup&&!i||(this._popup=new Oe(i,this)),this._popup.setContent(t)),this._popupHandlersAdded||(this.on({click:this._openPopup,keypress:this._onKeyPress,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!0),this},unbindPopup:function(){return this._popup&&(this.off({click:this._openPopup,keypress:this._onKeyPress,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!1,this._popup=null),this},openPopup:function(t,i){return this._popup&&this._map&&(i=this._popup._prepareOpen(this,t,i),this._map.openPopup(this._popup,i)),this},closePopup:function(){return this._popup&&this._popup._close(),this},togglePopup:function(t){return this._popup&&(this._popup._map?this.closePopup():this.openPopup(t)),this},isPopupOpen:function(){return!!this._popup&&this._popup.isOpen()},setPopupContent:function(t){return this._popup&&this._popup.setContent(t),this},getPopup:function(){return this._popup},_openPopup:function(t){var i=t.layer||t.target;this._popup&&this._map&&(Ai(t),i instanceof me?this.openPopup(t.layer||t.target,t.latlng):this._map.hasLayer(this._popup)&&this._popup._source===i?this.closePopup():this.openPopup(i,t.latlng))},_movePopup:function(t){this._popup.setLatLng(t.latlng)},_onKeyPress:function(t){13===t.originalEvent.keyCode&&this._openPopup(t)}});var Ne=Ie.extend({options:{pane:"tooltipPane",offset:[0,0],direction:"auto",permanent:!1,sticky:!1,interactive:!1,opacity:.9},onAdd:function(t){Ie.prototype.onAdd.call(this,t),this.setOpacity(this.options.opacity),t.fire("tooltipopen",{tooltip:this}),this._source&&this._source.fire("tooltipopen",{tooltip:this},!0)},onRemove:function(t){Ie.prototype.onRemove.call(this,t),t.fire("tooltipclose",{tooltip:this}),this._source&&this._source.fire("tooltipclose",{tooltip:this},!0)},getEvents:function(){var t=Ie.prototype.getEvents.call(this);return Mt&&!this.options.permanent&&(t.preclick=this._close),t},_close:function(){this._map&&this._map.closeTooltip(this)},_initLayout:function(){var t="leaflet-tooltip "+(this.options.className||"")+" leaflet-zoom-"+(this._zoomAnimated?"animated":"hide");this._contentNode=this._container=$t("div",t)},_updateLayout:function(){},_adjustPan:function(){},_setPosition:function(t){var i,e=this._map,s=this._container,n=e.latLngToContainerPoint(e.getCenter()),o=e.layerPointToContainerPoint(t),a=this.options.direction,r=s.offsetWidth,h=s.offsetHeight,l=O(this.options.offset),e=this._getAnchor(),h="top"===a?(i=r/2,h):"bottom"===a?(i=r/2,0):(i="center"===a?r/2:"right"===a?0:"left"===a?r:o.x<n.x?(a="right",0):(a="left",r+2*(l.x+e.x)),h/2);t=t.subtract(O(i,h,!0)).add(l).add(e),ai(s,"leaflet-tooltip-right"),ai(s,"leaflet-tooltip-left"),ai(s,"leaflet-tooltip-top"),ai(s,"leaflet-tooltip-bottom"),oi(s,"leaflet-tooltip-"+a),di(s,t)},_updatePosition:function(){var t=this._map.latLngToLayerPoint(this._latlng);this._setPosition(t)},setOpacity:function(t){this.options.opacity=t,this._container&&li(this._container,t)},_animateZoom:function(t){t=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center);this._setPosition(t)},_getAnchor:function(){return O(this._source&&this._source._getTooltipAnchor&&!this.options.sticky?this._source._getTooltipAnchor():[0,0])}});Di.include({openTooltip:function(t,i,e){return t instanceof Ne||(t=new Ne(e).setContent(t)),i&&t.setLatLng(i),this.hasLayer(t)?this:this.addLayer(t)},closeTooltip:function(t){return t&&this.removeLayer(t),this}}),he.include({bindTooltip:function(t,i){return t instanceof Ne?(c(t,i),(this._tooltip=t)._source=this):(this._tooltip&&!i||(this._tooltip=new Ne(i,this)),this._tooltip.setContent(t)),this._initTooltipInteractions(),this._tooltip.options.permanent&&this._map&&this._map.hasLayer(this)&&this.openTooltip(),this},unbindTooltip:function(){return this._tooltip&&(this._initTooltipInteractions(!0),this.closeTooltip(),this._tooltip=null),this},_initTooltipInteractions:function(t){var i,e;!t&&this._tooltipHandlersAdded||(i=t?"off":"on",e={remove:this.closeTooltip,move:this._moveTooltip},this._tooltip.options.permanent?e.add=this._openTooltip:(e.mouseover=this._openTooltip,e.mouseout=this.closeTooltip,this._tooltip.options.sticky&&(e.mousemove=this._moveTooltip),Mt&&(e.click=this._openTooltip)),this[i](e),this._tooltipHandlersAdded=!t)},openTooltip:function(t,i){return this._tooltip&&this._map&&(i=this._tooltip._prepareOpen(this,t,i),this._map.openTooltip(this._tooltip,i),this._tooltip.options.interactive&&this._tooltip._container&&(oi(this._tooltip._container,"leaflet-clickable"),this.addInteractiveTarget(this._tooltip._container))),this},closeTooltip:function(){return this._tooltip&&(this._tooltip._close(),this._tooltip.options.interactive&&this._tooltip._container&&(ai(this._tooltip._container,"leaflet-clickable"),this.removeInteractiveTarget(this._tooltip._container))),this},toggleTooltip:function(t){return this._tooltip&&(this._tooltip._map?this.closeTooltip():this.openTooltip(t)),this},isTooltipOpen:function(){return this._tooltip.isOpen()},setTooltipContent:function(t){return this._tooltip&&this._tooltip.setContent(t),this},getTooltip:function(){return this._tooltip},_openTooltip:function(t){var i=t.layer||t.target;this._tooltip&&this._map&&this.openTooltip(i,this._tooltip.options.sticky?t.latlng:void 0)},_moveTooltip:function(t){var i=t.latlng;this._tooltip.options.sticky&&t.originalEvent&&(t=this._map.mouseEventToContainerPoint(t.originalEvent),t=this._map.containerPointToLayerPoint(t),i=this._map.layerPointToLatLng(t)),this._tooltip.setLatLng(i)}});var Be=ce.extend({options:{iconSize:[12,12],html:!1,bgPos:null,className:"leaflet-div-icon"},createIcon:function(t){var i=t&&"DIV"===t.tagName?t:document.createElement("div"),t=this.options;return t.html instanceof Element?(ii(i),i.appendChild(t.html)):i.innerHTML=!1!==t.html?t.html:"",t.bgPos&&(t=O(t.bgPos),i.style.backgroundPosition=-t.x+"px "+-t.y+"px"),this._setIconStyles(i,"icon"),i},createShadow:function(){return null}});ce.Default=de;var Ze=he.extend({options:{tileSize:256,opacity:1,updateWhenIdle:W,updateWhenZooming:!0,updateInterval:200,zIndex:1,bounds:null,minZoom:0,maxZoom:void 0,maxNativeZoom:void 0,minNativeZoom:void 0,noWrap:!1,pane:"tilePane",className:"",keepBuffer:2},initialize:function(t){c(this,t)},onAdd:function(){this._initContainer(),this._levels={},this._tiles={},this._resetView(),this._update()},beforeAdd:function(t){t._addZoomLimit(this)},onRemove:function(t){this._removeAllTiles(),ti(this._container),t._removeZoomLimit(this),this._container=null,this._tileZoom=void 0},bringToFront:function(){return this._map&&(ei(this._container),this._setAutoZIndex(Math.max)),this},bringToBack:function(){return this._map&&(si(this._container),this._setAutoZIndex(Math.min)),this},getContainer:function(){return this._container},setOpacity:function(t){return this.options.opacity=t,this._updateOpacity(),this},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},isLoading:function(){return this._loading},redraw:function(){return this._map&&(this._removeAllTiles(),this._update()),this},getEvents:function(){var t={viewprereset:this._invalidateAll,viewreset:this._resetView,zoom:this._resetView,moveend:this._onMoveEnd};return this.options.updateWhenIdle||(this._onMove||(this._onMove=s(this._onMoveEnd,this.options.updateInterval,this)),t.move=this._onMove),this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},createTile:function(){return document.createElement("div")},getTileSize:function(){var t=this.options.tileSize;return t instanceof k?t:new k(t,t)},_updateZIndex:function(){this._container&&void 0!==this.options.zIndex&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},_setAutoZIndex:function(t){for(var i,e=this.getPane().children,s=-t(-1/0,1/0),n=0,o=e.length;n<o;n++)i=e[n].style.zIndex,e[n]!==this._container&&i&&(s=t(s,+i));isFinite(s)&&(this.options.zIndex=s+t(-1,1),this._updateZIndex())},_updateOpacity:function(){if(this._map&&!$){li(this._container,this.options.opacity);var t,i=+new Date,e=!1,s=!1;for(t in this._tiles){var n,o=this._tiles[t];o.current&&o.loaded&&(n=Math.min(1,(i-o.loaded)/200),li(o.el,n),n<1?e=!0:(o.active?s=!0:this._onOpaqueTile(o),o.active=!0))}s&&!this._noPrune&&this._pruneTiles(),e&&(C(this._fadeFrame),this._fadeFrame=T(this._updateOpacity,this))}},_onOpaqueTile:r,_initContainer:function(){this._container||(this._container=$t("div","leaflet-layer "+(this.options.className||"")),this._updateZIndex(),this.options.opacity<1&&this._updateOpacity(),this.getPane().appendChild(this._container))},_updateLevels:function(){var t=this._tileZoom,i=this.options.maxZoom;if(void 0!==t){for(var e in this._levels)e=Number(e),this._levels[e].el.children.length||e===t?(this._levels[e].el.style.zIndex=i-Math.abs(t-e),this._onUpdateLevel(e)):(ti(this._levels[e].el),this._removeTilesAtZoom(e),this._onRemoveLevel(e),delete this._levels[e]);var s=this._levels[t],n=this._map;return s||((s=this._levels[t]={}).el=$t("div","leaflet-tile-container leaflet-zoom-animated",this._container),s.el.style.zIndex=i,s.origin=n.project(n.unproject(n.getPixelOrigin()),t).round(),s.zoom=t,this._setZoomTransform(s,n.getCenter(),n.getZoom()),r(s.el.offsetWidth),this._onCreateLevel(s)),this._level=s}},_onUpdateLevel:r,_onRemoveLevel:r,_onCreateLevel:r,_pruneTiles:function(){if(this._map){var t,i,e,s=this._map.getZoom();if(s>this.options.maxZoom||s<this.options.minZoom)this._removeAllTiles();else{for(t in this._tiles)(e=this._tiles[t]).retain=e.current;for(t in this._tiles)(e=this._tiles[t]).current&&!e.active&&(i=e.coords,this._retainParent(i.x,i.y,i.z,i.z-5)||this._retainChildren(i.x,i.y,i.z,i.z+2));for(t in this._tiles)this._tiles[t].retain||this._removeTile(t)}}},_removeTilesAtZoom:function(t){for(var i in this._tiles)this._tiles[i].coords.z===t&&this._removeTile(i)},_removeAllTiles:function(){for(var t in this._tiles)this._removeTile(t)},_invalidateAll:function(){for(var t in this._levels)ti(this._levels[t].el),this._onRemoveLevel(Number(t)),delete this._levels[t];this._removeAllTiles(),this._tileZoom=void 0},_retainParent:function(t,i,e,s){var n=Math.floor(t/2),t=Math.floor(i/2),i=e-1,e=new k(+n,+t);e.z=+i;e=this._tileCoordsToKey(e),e=this._tiles[e];return e&&e.active?e.retain=!0:(e&&e.loaded&&(e.retain=!0),s<i&&this._retainParent(n,t,i,s))},_retainChildren:function(t,i,e,s){for(var n=2*t;n<2*t+2;n++)for(var o=2*i;o<2*i+2;o++){var a=new k(n,o);a.z=e+1;a=this._tileCoordsToKey(a),a=this._tiles[a];a&&a.active?a.retain=!0:(a&&a.loaded&&(a.retain=!0),e+1<s&&this._retainChildren(n,o,e+1,s))}},_resetView:function(t){t=t&&(t.pinch||t.flyTo);this._setView(this._map.getCenter(),this._map.getZoom(),t,t)},_animateZoom:function(t){this._setView(t.center,t.zoom,!0,t.noUpdate)},_clampZoom:function(t){var i=this.options;return void 0!==i.minNativeZoom&&t<i.minNativeZoom?i.minNativeZoom:void 0!==i.maxNativeZoom&&i.maxNativeZoom<t?i.maxNativeZoom:t},_setView:function(t,i,e,s){var n=Math.round(i),n=void 0!==this.options.maxZoom&&n>this.options.maxZoom||void 0!==this.options.minZoom&&n<this.options.minZoom?void 0:this._clampZoom(n),o=this.options.updateWhenZooming&&n!==this._tileZoom;s&&!o||(this._tileZoom=n,this._abortLoading&&this._abortLoading(),this._updateLevels(),this._resetGrid(),void 0!==n&&this._update(t),e||this._pruneTiles(),this._noPrune=!!e),this._setZoomTransforms(t,i)},_setZoomTransforms:function(t,i){for(var e in this._levels)this._setZoomTransform(this._levels[e],t,i)},_setZoomTransform:function(t,i,e){var s=this._map.getZoomScale(e,t.zoom),e=t.origin.multiplyBy(s).subtract(this._map._getNewPixelOrigin(i,e)).round();ft?ci(t.el,e,s):di(t.el,e)},_resetGrid:function(){var t=this._map,i=t.options.crs,e=this._tileSize=this.getTileSize(),s=this._tileZoom,n=this._map.getPixelWorldBounds(this._tileZoom);n&&(this._globalTileRange=this._pxBoundsToTileRange(n)),this._wrapX=i.wrapLng&&!this.options.noWrap&&[Math.floor(t.project([0,i.wrapLng[0]],s).x/e.x),Math.ceil(t.project([0,i.wrapLng[1]],s).x/e.y)],this._wrapY=i.wrapLat&&!this.options.noWrap&&[Math.floor(t.project([i.wrapLat[0],0],s).y/e.x),Math.ceil(t.project([i.wrapLat[1],0],s).y/e.y)]},_onMoveEnd:function(){this._map&&!this._map._animatingZoom&&this._update()},_getTiledPixelBounds:function(t){var i=this._map,e=i._animatingZoom?Math.max(i._animateToZoom,i.getZoom()):i.getZoom(),e=i.getZoomScale(e,this._tileZoom),t=i.project(t,this._tileZoom).floor(),e=i.getSize().divideBy(2*e);return new N(t.subtract(e),t.add(e))},_update:function(t){var i=this._map;if(i){var e=this._clampZoom(i.getZoom());if(void 0===t&&(t=i.getCenter()),void 0!==this._tileZoom){var s,i=this._getTiledPixelBounds(t),n=this._pxBoundsToTileRange(i),o=n.getCenter(),a=[],i=this.options.keepBuffer,r=new N(n.getBottomLeft().subtract([i,-i]),n.getTopRight().add([i,-i]));if(!(isFinite(n.min.x)&&isFinite(n.min.y)&&isFinite(n.max.x)&&isFinite(n.max.y)))throw new Error("Attempted to load an infinite number of tiles");for(s in this._tiles){var h=this._tiles[s].coords;h.z===this._tileZoom&&r.contains(new k(h.x,h.y))||(this._tiles[s].current=!1)}if(1<Math.abs(e-this._tileZoom))this._setView(t,e);else{for(var l=n.min.y;l<=n.max.y;l++)for(var u=n.min.x;u<=n.max.x;u++){var c,d=new k(u,l);d.z=this._tileZoom,this._isValidTile(d)&&((c=this._tiles[this._tileCoordsToKey(d)])?c.current=!0:a.push(d))}if(a.sort(function(t,i){return t.distanceTo(o)-i.distanceTo(o)}),0!==a.length){this._loading||(this._loading=!0,this.fire("loading"));for(var _=document.createDocumentFragment(),u=0;u<a.length;u++)this._addTile(a[u],_);this._level.el.appendChild(_)}}}}},_isValidTile:function(t){var i=this._map.options.crs;if(!i.infinite){var e=this._globalTileRange;if(!i.wrapLng&&(t.x<e.min.x||t.x>e.max.x)||!i.wrapLat&&(t.y<e.min.y||t.y>e.max.y))return!1}if(!this.options.bounds)return!0;t=this._tileCoordsToBounds(t);return R(this.options.bounds).overlaps(t)},_keyToBounds:function(t){return this._tileCoordsToBounds(this._keyToTileCoords(t))},_tileCoordsToNwSe:function(t){var i=this._map,e=this.getTileSize(),s=t.scaleBy(e),e=s.add(e);return[i.unproject(s,t.z),i.unproject(e,t.z)]},_tileCoordsToBounds:function(t){t=this._tileCoordsToNwSe(t),t=new Z(t[0],t[1]);return t=!this.options.noWrap?this._map.wrapLatLngBounds(t):t},_tileCoordsToKey:function(t){return t.x+":"+t.y+":"+t.z},_keyToTileCoords:function(t){var i=t.split(":"),t=new k(+i[0],+i[1]);return t.z=+i[2],t},_removeTile:function(t){var i=this._tiles[t];i&&(ti(i.el),delete this._tiles[t],this.fire("tileunload",{tile:i.el,coords:this._keyToTileCoords(t)}))},_initTile:function(t){oi(t,"leaflet-tile");var i=this.getTileSize();t.style.width=i.x+"px",t.style.height=i.y+"px",t.onselectstart=r,t.onmousemove=r,$&&this.options.opacity<1&&li(t,this.options.opacity),et&&!st&&(t.style.WebkitBackfaceVisibility="hidden")},_addTile:function(t,i){var e=this._getTilePos(t),s=this._tileCoordsToKey(t),n=this.createTile(this._wrapCoords(t),d(this._tileReady,this,t));this._initTile(n),this.createTile.length<2&&T(d(this._tileReady,this,t,null,n)),di(n,e),this._tiles[s]={el:n,coords:t,current:!0},i.appendChild(n),this.fire("tileloadstart",{tile:n,coords:t})},_tileReady:function(t,i,e){i&&this.fire("tileerror",{error:i,tile:e,coords:t});var s=this._tileCoordsToKey(t);(e=this._tiles[s])&&(e.loaded=+new Date,this._map._fadeAnimated?(li(e.el,0),C(this._fadeFrame),this._fadeFrame=T(this._updateOpacity,this)):(e.active=!0,this._pruneTiles()),i||(oi(e.el,"leaflet-tile-loaded"),this.fire("tileload",{tile:e.el,coords:t})),this._noTilesToLoad()&&(this._loading=!1,this.fire("load"),$||!this._map._fadeAnimated?T(this._pruneTiles,this):setTimeout(d(this._pruneTiles,this),250)))},_getTilePos:function(t){return t.scaleBy(this.getTileSize()).subtract(this._level.origin)},_wrapCoords:function(t){var i=new k(this._wrapX?n(t.x,this._wrapX):t.x,this._wrapY?n(t.y,this._wrapY):t.y);return i.z=t.z,i},_pxBoundsToTileRange:function(t){var i=this.getTileSize();return new N(t.min.unscaleBy(i).floor(),t.max.unscaleBy(i).ceil().subtract([1,1]))},_noTilesToLoad:function(){for(var t in this._tiles)if(!this._tiles[t].loaded)return!1;return!0}});var Re=Ze.extend({options:{minZoom:0,maxZoom:18,subdomains:"abc",errorTileUrl:"",zoomOffset:0,tms:!1,zoomReverse:!1,detectRetina:!1,crossOrigin:!1},initialize:function(t,i){this._url=t,(i=c(this,i)).detectRetina&&bt&&0<i.maxZoom&&(i.tileSize=Math.floor(i.tileSize/2),i.zoomReverse?(i.zoomOffset--,i.minZoom++):(i.zoomOffset++,i.maxZoom--),i.minZoom=Math.max(0,i.minZoom)),"string"==typeof i.subdomains&&(i.subdomains=i.subdomains.split("")),et||this.on("tileunload",this._onTileRemove)},setUrl:function(t,i){return this._url===t&&void 0===i&&(i=!0),this._url=t,i||this.redraw(),this},createTile:function(t,i){var e=document.createElement("img");return Mi(e,"load",d(this._tileOnLoad,this,i,e)),Mi(e,"error",d(this._tileOnError,this,i,e)),!this.options.crossOrigin&&""!==this.options.crossOrigin||(e.crossOrigin=!0===this.options.crossOrigin?"":this.options.crossOrigin),e.alt="",e.setAttribute("role","presentation"),e.src=this.getTileUrl(t),e},getTileUrl:function(t){var i={r:bt?"@2x":"",s:this._getSubdomain(t),x:t.x,y:t.y,z:this._getZoomForUrl()};return this._map&&!this._map.options.crs.infinite&&(t=this._globalTileRange.max.y-t.y,this.options.tms&&(i.y=t),i["-y"]=t),f(this._url,h(i,this.options))},_tileOnLoad:function(t,i){$?setTimeout(d(t,this,null,i),0):t(null,i)},_tileOnError:function(t,i,e){var s=this.options.errorTileUrl;s&&i.getAttribute("src")!==s&&(i.src=s),t(e,i)},_onTileRemove:function(t){t.tile.onload=null},_getZoomForUrl:function(){var t=this._tileZoom,i=this.options.maxZoom;return(t=this.options.zoomReverse?i-t:t)+this.options.zoomOffset},_getSubdomain:function(t){t=Math.abs(t.x+t.y)%this.options.subdomains.length;return this.options.subdomains[t]},_abortLoading:function(){var t,i;for(t in this._tiles)this._tiles[t].coords.z!==this._tileZoom&&((i=this._tiles[t].el).onload=r,i.onerror=r,i.complete||(i.src=v,ti(i),delete this._tiles[t]))},_removeTile:function(t){var i=this._tiles[t];if(i)return ot||i.el.setAttribute("src",v),Ze.prototype._removeTile.call(this,t)},_tileReady:function(t,i,e){if(this._map&&(!e||e.getAttribute("src")!==v))return Ze.prototype._tileReady.call(this,t,i,e)}});function je(t,i){return new Re(t,i)}var De=Re.extend({defaultWmsParams:{service:"WMS",request:"GetMap",layers:"",styles:"",format:"image/jpeg",transparent:!1,version:"1.1.1"},options:{crs:null,uppercase:!1},initialize:function(t,i){this._url=t;var e,s=h({},this.defaultWmsParams);for(e in i)e in this.options||(s[e]=i[e]);var n=(i=c(this,i)).detectRetina&&bt?2:1,t=this.getTileSize();s.width=t.x*n,s.height=t.y*n,this.wmsParams=s},onAdd:function(t){this._crs=this.options.crs||t.options.crs,this._wmsVersion=parseFloat(this.wmsParams.version);var i=1.3<=this._wmsVersion?"crs":"srs";this.wmsParams[i]=this._crs.code,Re.prototype.onAdd.call(this,t)},getTileUrl:function(t){var i=this._tileCoordsToNwSe(t),e=this._crs,e=B(e.project(i[0]),e.project(i[1])),i=e.min,e=e.max,e=(1.3<=this._wmsVersion&&this._crs===re?[i.y,i.x,e.y,e.x]:[i.x,i.y,e.x,e.y]).join(","),t=Re.prototype.getTileUrl.call(this,t);return t+_(this.wmsParams,t,this.options.uppercase)+(this.options.uppercase?"&BBOX=":"&bbox=")+e},setParams:function(t,i){return h(this.wmsParams,t),i||this.redraw(),this}});Re.WMS=De,je.wms=function(t,i){return new De(t,i)};var qe=he.extend({options:{padding:.1,tolerance:0},initialize:function(t){c(this,t),m(this),this._layers=this._layers||{}},onAdd:function(){this._container||(this._initContainer(),this._zoomAnimated&&oi(this._container,"leaflet-zoom-animated")),this.getPane().appendChild(this._container),this._update(),this.on("update",this._updatePaths,this)},onRemove:function(){this.off("update",this._updatePaths,this),this._destroyContainer()},getEvents:function(){var t={viewreset:this._reset,zoom:this._onZoom,moveend:this._update,zoomend:this._onZoomEnd};return this._zoomAnimated&&(t.zoomanim=this._onAnimZoom),t},_onAnimZoom:function(t){this._updateTransform(t.center,t.zoom)},_onZoom:function(){this._updateTransform(this._map.getCenter(),this._map.getZoom())},_updateTransform:function(t,i){var e=this._map.getZoomScale(i,this._zoom),s=_i(this._container),n=this._map.getSize().multiplyBy(.5+this.options.padding),o=this._map.project(this._center,i),o=this._map.project(t,i).subtract(o),o=n.multiplyBy(-e).add(s).add(n).subtract(o);ft?ci(this._container,o,e):di(this._container,o)},_reset:function(){for(var t in this._update(),this._updateTransform(this._center,this._zoom),this._layers)this._layers[t]._reset()},_onZoomEnd:function(){for(var t in this._layers)this._layers[t]._project()},_updatePaths:function(){for(var t in this._layers)this._layers[t]._update()},_update:function(){var t=this.options.padding,i=this._map.getSize(),e=this._map.containerPointToLayerPoint(i.multiplyBy(-t)).round();this._bounds=new N(e,e.add(i.multiplyBy(1+2*t)).round()),this._center=this._map.getCenter(),this._zoom=this._map.getZoom()}}),Ge=qe.extend({getEvents:function(){var t=qe.prototype.getEvents.call(this);return t.viewprereset=this._onViewPreReset,t},_onViewPreReset:function(){this._postponeUpdatePaths=!0},onAdd:function(){qe.prototype.onAdd.call(this),this._draw()},_initContainer:function(){var t=this._container=document.createElement("canvas");Mi(t,"mousemove",this._onMouseMove,this),Mi(t,"click dblclick mousedown mouseup contextmenu",this._onClick,this),Mi(t,"mouseout",this._handleMouseOut,this),this._ctx=t.getContext("2d")},_destroyContainer:function(){C(this._redrawRequest),delete this._ctx,ti(this._container),bi(this._container),delete this._container},_updatePaths:function(){if(!this._postponeUpdatePaths){for(var t in this._redrawBounds=null,this._layers)this._layers[t]._update();this._redraw()}},_update:function(){var t,i,e,s;this._map._animatingZoom&&this._bounds||(qe.prototype._update.call(this),t=this._bounds,i=this._container,e=t.getSize(),s=bt?2:1,di(i,t.min),i.width=s*e.x,i.height=s*e.y,i.style.width=e.x+"px",i.style.height=e.y+"px",bt&&this._ctx.scale(2,2),this._ctx.translate(-t.min.x,-t.min.y),this.fire("update"))},_reset:function(){qe.prototype._reset.call(this),this._postponeUpdatePaths&&(this._postponeUpdatePaths=!1,this._updatePaths())},_initPath:function(t){this._updateDashArray(t);t=(this._layers[m(t)]=t)._order={layer:t,prev:this._drawLast,next:null};this._drawLast&&(this._drawLast.next=t),this._drawLast=t,this._drawFirst=this._drawFirst||this._drawLast},_addPath:function(t){this._requestRedraw(t)},_removePath:function(t){var i=t._order,e=i.next,i=i.prev;e?e.prev=i:this._drawLast=i,i?i.next=e:this._drawFirst=e,delete t._order,delete this._layers[m(t)],this._requestRedraw(t)},_updatePath:function(t){this._extendRedrawBounds(t),t._project(),t._update(),this._requestRedraw(t)},_updateStyle:function(t){this._updateDashArray(t),this._requestRedraw(t)},_updateDashArray:function(t){if("string"==typeof t.options.dashArray){for(var i,e=t.options.dashArray.split(/[, ]+/),s=[],n=0;n<e.length;n++){if(i=Number(e[n]),isNaN(i))return;s.push(i)}t.options._dashArray=s}else t.options._dashArray=t.options.dashArray},_requestRedraw:function(t){this._map&&(this._extendRedrawBounds(t),this._redrawRequest=this._redrawRequest||T(this._redraw,this))},_extendRedrawBounds:function(t){var i;t._pxBounds&&(i=(t.options.weight||0)+1,this._redrawBounds=this._redrawBounds||new N,this._redrawBounds.extend(t._pxBounds.min.subtract([i,i])),this._redrawBounds.extend(t._pxBounds.max.add([i,i])))},_redraw:function(){this._redrawRequest=null,this._redrawBounds&&(this._redrawBounds.min._floor(),this._redrawBounds.max._ceil()),this._clear(),this._draw(),this._redrawBounds=null},_clear:function(){var t,i=this._redrawBounds;i?(t=i.getSize(),this._ctx.clearRect(i.min.x,i.min.y,t.x,t.y)):(this._ctx.save(),this._ctx.setTransform(1,0,0,1,0,0),this._ctx.clearRect(0,0,this._container.width,this._container.height),this._ctx.restore())},_draw:function(){var t,i,e=this._redrawBounds;this._ctx.save(),e&&(i=e.getSize(),this._ctx.beginPath(),this._ctx.rect(e.min.x,e.min.y,i.x,i.y),this._ctx.clip()),this._drawing=!0;for(var s=this._drawFirst;s;s=s.next)t=s.layer,(!e||t._pxBounds&&t._pxBounds.intersects(e))&&t._updatePath();this._drawing=!1,this._ctx.restore()},_updatePoly:function(t,i){if(this._drawing){var e,s,n,o,a=t._parts,r=a.length,h=this._ctx;if(r){for(h.beginPath(),e=0;e<r;e++){for(s=0,n=a[e].length;s<n;s++)o=a[e][s],h[s?"lineTo":"moveTo"](o.x,o.y);i&&h.closePath()}this._fillStroke(h,t)}}},_updateCircle:function(t){var i,e,s,n;this._drawing&&!t._empty()&&(i=t._point,e=this._ctx,s=Math.max(Math.round(t._radius),1),1!=(n=(Math.max(Math.round(t._radiusY),1)||s)/s)&&(e.save(),e.scale(1,n)),e.beginPath(),e.arc(i.x,i.y/n,s,0,2*Math.PI,!1),1!=n&&e.restore(),this._fillStroke(e,t))},_fillStroke:function(t,i){var e=i.options;e.fill&&(t.globalAlpha=e.fillOpacity,t.fillStyle=e.fillColor||e.color,t.fill(e.fillRule||"evenodd")),e.stroke&&0!==e.weight&&(t.setLineDash&&t.setLineDash(i.options&&i.options._dashArray||[]),t.globalAlpha=e.opacity,t.lineWidth=e.weight,t.strokeStyle=e.color,t.lineCap=e.lineCap,t.lineJoin=e.lineJoin,t.stroke())},_onClick:function(t){for(var i,e,s=this._map.mouseEventToLayerPoint(t),n=this._drawFirst;n;n=n.next)(i=n.layer).options.interactive&&i._containsPoint(s)&&(("click"===t.type||"preclick"!==t.type)&&this._map._draggableMoved(i)||(e=i));e&&(Bi(t),this._fireEvent([e],t))},_onMouseMove:function(t){var i;!this._map||this._map.dragging.moving()||this._map._animatingZoom||(i=this._map.mouseEventToLayerPoint(t),this._handleMouseHover(t,i))},_handleMouseOut:function(t){var i=this._hoveredLayer;i&&(ai(this._container,"leaflet-interactive"),this._fireEvent([i],t,"mouseout"),this._hoveredLayer=null,this._mouseHoverThrottled=!1)},_handleMouseHover:function(t,i){if(!this._mouseHoverThrottled){for(var e,s,n=this._drawFirst;n;n=n.next)(e=n.layer).options.interactive&&e._containsPoint(i)&&(s=e);s!==this._hoveredLayer&&(this._handleMouseOut(t),s&&(oi(this._container,"leaflet-interactive"),this._fireEvent([s],t,"mouseover"),this._hoveredLayer=s)),this._hoveredLayer&&this._fireEvent([this._hoveredLayer],t),this._mouseHoverThrottled=!0,setTimeout(d(function(){this._mouseHoverThrottled=!1},this),32)}},_fireEvent:function(t,i,e){this._map._fireDOMEvent(i,e||i.type,t)},_bringToFront:function(t){var i,e,s=t._order;s&&(i=s.next,e=s.prev,i&&((i.prev=e)?e.next=i:i&&(this._drawFirst=i),s.prev=this._drawLast,(this._drawLast.next=s).next=null,this._drawLast=s,this._requestRedraw(t)))},_bringToBack:function(t){var i,e,s=t._order;s&&(i=s.next,(e=s.prev)&&((e.next=i)?i.prev=e:e&&(this._drawLast=e),s.prev=null,s.next=this._drawFirst,this._drawFirst.prev=s,this._drawFirst=s,this._requestRedraw(t)))}});function We(t){return Pt?new Ge(t):null}var Ue=function(){try{return document.namespaces.add("lvml","urn:schemas-microsoft-com:vml"),function(t){return document.createElement("<lvml:"+t+' class="lvml">')}}catch(t){return function(t){return document.createElement("<"+t+' xmlns="urn:schemas-microsoft.com:vml" class="lvml">')}}}(),nt={_initContainer:function(){this._container=$t("div","leaflet-vml-container")},_update:function(){this._map._animatingZoom||(qe.prototype._update.call(this),this.fire("update"))},_initPath:function(t){var i=t._container=Ue("shape");oi(i,"leaflet-vml-shape "+(this.options.className||"")),i.coordsize="1 1",t._path=Ue("path"),i.appendChild(t._path),this._updateStyle(t),this._layers[m(t)]=t},_addPath:function(t){var i=t._container;this._container.appendChild(i),t.options.interactive&&t.addInteractiveTarget(i)},_removePath:function(t){var i=t._container;ti(i),t.removeInteractiveTarget(i),delete this._layers[m(t)]},_updateStyle:function(t){var i=t._stroke,e=t._fill,s=t.options,n=t._container;n.stroked=!!s.stroke,n.filled=!!s.fill,s.stroke?(i=i||(t._stroke=Ue("stroke")),n.appendChild(i),i.weight=s.weight+"px",i.color=s.color,i.opacity=s.opacity,s.dashArray?i.dashStyle=g(s.dashArray)?s.dashArray.join(" "):s.dashArray.replace(/( *, *)/g," "):i.dashStyle="",i.endcap=s.lineCap.replace("butt","flat"),i.joinstyle=s.lineJoin):i&&(n.removeChild(i),t._stroke=null),s.fill?(e=e||(t._fill=Ue("fill")),n.appendChild(e),e.color=s.fillColor||s.color,e.opacity=s.fillOpacity):e&&(n.removeChild(e),t._fill=null)},_updateCircle:function(t){var i=t._point.round(),e=Math.round(t._radius),s=Math.round(t._radiusY||e);this._setPath(t,t._empty()?"M0 0":"AL "+i.x+","+i.y+" "+e+","+s+" 0,23592600")},_setPath:function(t,i){t._path.v=i},_bringToFront:function(t){ei(t._container)},_bringToBack:function(t){si(t._container)}},Fe=Tt?Ue:X,He=qe.extend({getEvents:function(){var t=qe.prototype.getEvents.call(this);return t.zoomstart=this._onZoomStart,t},_initContainer:function(){this._container=Fe("svg"),this._container.setAttribute("pointer-events","none"),this._rootGroup=Fe("g"),this._container.appendChild(this._rootGroup)},_destroyContainer:function(){ti(this._container),bi(this._container),delete this._container,delete this._rootGroup,delete this._svgSize},_onZoomStart:function(){this._update()},_update:function(){var t,i,e;this._map._animatingZoom&&this._bounds||(qe.prototype._update.call(this),i=(t=this._bounds).getSize(),e=this._container,this._svgSize&&this._svgSize.equals(i)||(this._svgSize=i,e.setAttribute("width",i.x),e.setAttribute("height",i.y)),di(e,t.min),e.setAttribute("viewBox",[t.min.x,t.min.y,i.x,i.y].join(" ")),this.fire("update"))},_initPath:function(t){var i=t._path=Fe("path");t.options.className&&oi(i,t.options.className),t.options.interactive&&oi(i,"leaflet-interactive"),this._updateStyle(t),this._layers[m(t)]=t},_addPath:function(t){this._rootGroup||this._initContainer(),this._rootGroup.appendChild(t._path),t.addInteractiveTarget(t._path)},_removePath:function(t){ti(t._path),t.removeInteractiveTarget(t._path),delete this._layers[m(t)]},_updatePath:function(t){t._project(),t._update()},_updateStyle:function(t){var i=t._path,t=t.options;i&&(t.stroke?(i.setAttribute("stroke",t.color),i.setAttribute("stroke-opacity",t.opacity),i.setAttribute("stroke-width",t.weight),i.setAttribute("stroke-linecap",t.lineCap),i.setAttribute("stroke-linejoin",t.lineJoin),t.dashArray?i.setAttribute("stroke-dasharray",t.dashArray):i.removeAttribute("stroke-dasharray"),t.dashOffset?i.setAttribute("stroke-dashoffset",t.dashOffset):i.removeAttribute("stroke-dashoffset")):i.setAttribute("stroke","none"),t.fill?(i.setAttribute("fill",t.fillColor||t.color),i.setAttribute("fill-opacity",t.fillOpacity),i.setAttribute("fill-rule",t.fillRule||"evenodd")):i.setAttribute("fill","none"))},_updatePoly:function(t,i){this._setPath(t,J(t._parts,i))},_updateCircle:function(t){var i=t._point,e=Math.max(Math.round(t._radius),1),s="a"+e+","+(Math.max(Math.round(t._radiusY),1)||e)+" 0 1,0 ",e=t._empty()?"M0 0":"M"+(i.x-e)+","+i.y+s+2*e+",0 "+s+2*-e+",0 ";this._setPath(t,e)},_setPath:function(t,i){t._path.setAttribute("d",i)},_bringToFront:function(t){ei(t._path)},_bringToBack:function(t){si(t._path)}});function Ve(t){return Lt||Tt?new He(t):null}Tt&&He.include(nt),Di.include({getRenderer:function(t){t=(t=t.options.renderer||this._getPaneRenderer(t.options.pane)||this.options.renderer||this._renderer)||(this._renderer=this._createRenderer());return this.hasLayer(t)||this.addLayer(t),t},_getPaneRenderer:function(t){if("overlayPane"===t||void 0===t)return!1;var i=this._paneRenderers[t];return void 0===i&&(i=this._createRenderer({pane:t}),this._paneRenderers[t]=i),i},_createRenderer:function(t){return this.options.preferCanvas&&We(t)||Ve(t)}});var Ke=ve.extend({initialize:function(t,i){ve.prototype.initialize.call(this,this._boundsToLatLngs(t),i)},setBounds:function(t){return this.setLatLngs(this._boundsToLatLngs(t))},_boundsToLatLngs:function(t){return[(t=R(t)).getSouthWest(),t.getNorthWest(),t.getNorthEast(),t.getSouthEast()]}});He.create=Fe,He.pointsToPath=J,Me.geometryToLayer=xe,Me.coordsToLatLng=we,Me.coordsToLatLngs=Pe,Me.latLngToCoords=Le,Me.latLngsToCoords=Te,Me.getFeature=Ce,Me.asFeature=Se,Di.mergeOptions({boxZoom:!0});z=mt.extend({initialize:function(t){this._map=t,this._container=t._container,this._pane=t._panes.overlayPane,this._resetStateTimeout=0,t.on("unload",this._destroy,this)},addHooks:function(){Mi(this._container,"mousedown",this._onMouseDown,this)},removeHooks:function(){bi(this._container,"mousedown",this._onMouseDown,this)},moved:function(){return this._moved},_destroy:function(){ti(this._pane),delete this._pane},_resetState:function(){this._resetStateTimeout=0,this._moved=!1},_clearDeferredResetState:function(){0!==this._resetStateTimeout&&(clearTimeout(this._resetStateTimeout),this._resetStateTimeout=0)},_onMouseDown:function(t){if(!t.shiftKey||1!==t.which&&1!==t.button)return!1;this._clearDeferredResetState(),this._resetState(),Ut(),pi(),this._startPoint=this._map.mouseEventToContainerPoint(t),Mi(document,{contextmenu:Ai,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseMove:function(t){this._moved||(this._moved=!0,this._box=$t("div","leaflet-zoom-box",this._container),oi(this._container,"leaflet-crosshair"),this._map.fire("boxzoomstart")),this._point=this._map.mouseEventToContainerPoint(t);var i=new N(this._point,this._startPoint),t=i.getSize();di(this._box,i.min),this._box.style.width=t.x+"px",this._box.style.height=t.y+"px"},_finish:function(){this._moved&&(ti(this._box),ai(this._container,"leaflet-crosshair")),Ft(),mi(),bi(document,{contextmenu:Ai,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseUp:function(t){1!==t.which&&1!==t.button||(this._finish(),this._moved&&(this._clearDeferredResetState(),this._resetStateTimeout=setTimeout(d(this._resetState,this),0),t=new Z(this._map.containerPointToLatLng(this._startPoint),this._map.containerPointToLatLng(this._point)),this._map.fitBounds(t).fire("boxzoomend",{boxZoomBounds:t})))},_onKeyDown:function(t){27===t.keyCode&&this._finish()}});Di.addInitHook("addHandler","boxZoom",z),Di.mergeOptions({doubleClickZoom:!0});V=mt.extend({addHooks:function(){this._map.on("dblclick",this._onDoubleClick,this)},removeHooks:function(){this._map.off("dblclick",this._onDoubleClick,this)},_onDoubleClick:function(t){var i=this._map,e=i.getZoom(),s=i.options.zoomDelta,s=t.originalEvent.shiftKey?e-s:e+s;"center"===i.options.doubleClickZoom?i.setZoom(s):i.setZoomAround(t.containerPoint,s)}});Di.addInitHook("addHandler","doubleClickZoom",V),Di.mergeOptions({dragging:!0,inertia:!st,inertiaDeceleration:3400,inertiaMaxSpeed:1/0,easeLinearity:.2,worldCopyJump:!1,maxBoundsViscosity:0});K=mt.extend({addHooks:function(){var t;this._draggable||(t=this._map,this._draggable=new Qi(t._mapPane,t._container),this._draggable.on({dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this),this._draggable.on("predrag",this._onPreDragLimit,this),t.options.worldCopyJump&&(this._draggable.on("predrag",this._onPreDragWrap,this),t.on("zoomend",this._onZoomEnd,this),t.whenReady(this._onZoomEnd,this))),oi(this._map._container,"leaflet-grab leaflet-touch-drag"),this._draggable.enable(),this._positions=[],this._times=[]},removeHooks:function(){ai(this._map._container,"leaflet-grab"),ai(this._map._container,"leaflet-touch-drag"),this._draggable.disable()},moved:function(){return this._draggable&&this._draggable._moved},moving:function(){return this._draggable&&this._draggable._moving},_onDragStart:function(){var t,i=this._map;i._stop(),this._map.options.maxBounds&&this._map.options.maxBoundsViscosity?(t=R(this._map.options.maxBounds),this._offsetLimit=B(this._map.latLngToContainerPoint(t.getNorthWest()).multiplyBy(-1),this._map.latLngToContainerPoint(t.getSouthEast()).multiplyBy(-1).add(this._map.getSize())),this._viscosity=Math.min(1,Math.max(0,this._map.options.maxBoundsViscosity))):this._offsetLimit=null,i.fire("movestart").fire("dragstart"),i.options.inertia&&(this._positions=[],this._times=[])},_onDrag:function(t){var i,e;this._map.options.inertia&&(i=this._lastTime=+new Date,e=this._lastPos=this._draggable._absPos||this._draggable._newPos,this._positions.push(e),this._times.push(i),this._prunePositions(i)),this._map.fire("move",t).fire("drag",t)},_prunePositions:function(t){for(;1<this._positions.length&&50<t-this._times[0];)this._positions.shift(),this._times.shift()},_onZoomEnd:function(){var t=this._map.getSize().divideBy(2),i=this._map.latLngToLayerPoint([0,0]);this._initialWorldOffset=i.subtract(t).x,this._worldWidth=this._map.getPixelWorldBounds().getSize().x},_viscousLimit:function(t,i){return t-(t-i)*this._viscosity},_onPreDragLimit:function(){var t,i;this._viscosity&&this._offsetLimit&&(t=this._draggable._newPos.subtract(this._draggable._startPos),i=this._offsetLimit,t.x<i.min.x&&(t.x=this._viscousLimit(t.x,i.min.x)),t.y<i.min.y&&(t.y=this._viscousLimit(t.y,i.min.y)),t.x>i.max.x&&(t.x=this._viscousLimit(t.x,i.max.x)),t.y>i.max.y&&(t.y=this._viscousLimit(t.y,i.max.y)),this._draggable._newPos=this._draggable._startPos.add(t))},_onPreDragWrap:function(){var t=this._worldWidth,i=Math.round(t/2),e=this._initialWorldOffset,s=this._draggable._newPos.x,n=(s-i+e)%t+i-e,i=(s+i+e)%t-i-e,i=Math.abs(n+e)<Math.abs(i+e)?n:i;this._draggable._absPos=this._draggable._newPos.clone(),this._draggable._newPos.x=i},_onDragEnd:function(t){var i,e,s,n,o=this._map,a=o.options,r=!a.inertia||this._times.length<2;o.fire("dragend",t),r?o.fire("moveend"):(this._prunePositions(+new Date),e=this._lastPos.subtract(this._positions[0]),t=(this._lastTime-this._times[0])/1e3,i=a.easeLinearity,e=(r=e.multiplyBy(i/t)).distanceTo([0,0]),t=Math.min(a.inertiaMaxSpeed,e),e=r.multiplyBy(t/e),s=t/(a.inertiaDeceleration*i),(n=e.multiplyBy(-s/2).round()).x||n.y?(n=o._limitOffset(n,o.options.maxBounds),T(function(){o.panBy(n,{duration:s,easeLinearity:i,noMoveStart:!0,animate:!0})})):o.fire("moveend"))}});Di.addInitHook("addHandler","dragging",K),Di.mergeOptions({keyboard:!0,keyboardPanDelta:80});U=mt.extend({keyCodes:{left:[37],right:[39],down:[40],up:[38],zoomIn:[187,107,61,171],zoomOut:[189,109,54,173]},initialize:function(t){this._map=t,this._setPanDelta(t.options.keyboardPanDelta),this._setZoomDelta(t.options.zoomDelta)},addHooks:function(){var t=this._map._container;t.tabIndex<=0&&(t.tabIndex="0"),Mi(t,{focus:this._onFocus,blur:this._onBlur,mousedown:this._onMouseDown},this),this._map.on({focus:this._addHooks,blur:this._removeHooks},this)},removeHooks:function(){this._removeHooks(),bi(this._map._container,{focus:this._onFocus,blur:this._onBlur,mousedown:this._onMouseDown},this),this._map.off({focus:this._addHooks,blur:this._removeHooks},this)},_onMouseDown:function(){var t,i,e;this._focused||(t=document.body,e=document.documentElement,i=t.scrollTop||e.scrollTop,e=t.scrollLeft||e.scrollLeft,this._map._container.focus(),window.scrollTo(e,i))},_onFocus:function(){this._focused=!0,this._map.fire("focus")},_onBlur:function(){this._focused=!1,this._map.fire("blur")},_setPanDelta:function(t){for(var i=this._panKeys={},e=this.keyCodes,s=0,n=e.left.length;s<n;s++)i[e.left[s]]=[-1*t,0];for(s=0,n=e.right.length;s<n;s++)i[e.right[s]]=[t,0];for(s=0,n=e.down.length;s<n;s++)i[e.down[s]]=[0,t];for(s=0,n=e.up.length;s<n;s++)i[e.up[s]]=[0,-1*t]},_setZoomDelta:function(t){for(var i=this._zoomKeys={},e=this.keyCodes,s=0,n=e.zoomIn.length;s<n;s++)i[e.zoomIn[s]]=t;for(s=0,n=e.zoomOut.length;s<n;s++)i[e.zoomOut[s]]=-t},_addHooks:function(){Mi(document,"keydown",this._onKeyDown,this)},_removeHooks:function(){bi(document,"keydown",this._onKeyDown,this)},_onKeyDown:function(t){if(!(t.altKey||t.ctrlKey||t.metaKey)){var i,e=t.keyCode,s=this._map;if(e in this._panKeys)s._panAnim&&s._panAnim._inProgress||(i=this._panKeys[e],t.shiftKey&&(i=O(i).multiplyBy(3)),s.panBy(i),s.options.maxBounds&&s.panInsideBounds(s.options.maxBounds));else if(e in this._zoomKeys)s.setZoom(s.getZoom()+(t.shiftKey?3:1)*this._zoomKeys[e]);else{if(27!==e||!s._popup||!s._popup.options.closeOnEscapeKey)return;s.closePopup()}Ai(t)}}});Di.addInitHook("addHandler","keyboard",U),Di.mergeOptions({scrollWheelZoom:!0,wheelDebounceTime:40,wheelPxPerZoomLevel:60});dt=mt.extend({addHooks:function(){Mi(this._map._container,"wheel",this._onWheelScroll,this),this._delta=0},removeHooks:function(){bi(this._map._container,"wheel",this._onWheelScroll,this)},_onWheelScroll:function(t){var i=Oi(t),e=this._map.options.wheelDebounceTime;this._delta+=i,this._lastMousePos=this._map.mouseEventToContainerPoint(t),this._startTime||(this._startTime=+new Date);e=Math.max(e-(+new Date-this._startTime),0);clearTimeout(this._timer),this._timer=setTimeout(d(this._performZoom,this),e),Ai(t)},_performZoom:function(){var t=this._map,i=t.getZoom(),e=this._map.options.zoomSnap||0;t._stop();var s=this._delta/(4*this._map.options.wheelPxPerZoomLevel),s=4*Math.log(2/(1+Math.exp(-Math.abs(s))))/Math.LN2,s=e?Math.ceil(s/e)*e:s,s=t._limitZoom(i+(0<this._delta?s:-s))-i;this._delta=0,this._startTime=null,s&&("center"===t.options.scrollWheelZoom?t.setZoom(i+s):t.setZoomAround(this._lastMousePos,i+s))}});Di.addInitHook("addHandler","scrollWheelZoom",dt),Di.mergeOptions({tap:!0,tapTolerance:15});W=mt.extend({addHooks:function(){Mi(this._map._container,"touchstart",this._onDown,this)},removeHooks:function(){bi(this._map._container,"touchstart",this._onDown,this)},_onDown:function(t){if(t.touches){if(zi(t),this._fireClick=!0,1<t.touches.length)return this._fireClick=!1,void clearTimeout(this._holdTimeout);var i=t.touches[0],t=i.target;this._startPos=this._newPos=new k(i.clientX,i.clientY),t.tagName&&"a"===t.tagName.toLowerCase()&&oi(t,"leaflet-active"),this._holdTimeout=setTimeout(d(function(){this._isTapValid()&&(this._fireClick=!1,this._onUp(),this._simulateEvent("contextmenu",i))},this),1e3),this._simulateEvent("mousedown",i),Mi(document,{touchmove:this._onMove,touchend:this._onUp},this)}},_onUp:function(t){var i;clearTimeout(this._holdTimeout),bi(document,{touchmove:this._onMove,touchend:this._onUp},this),this._fireClick&&t&&t.changedTouches&&((t=(i=t.changedTouches[0]).target)&&t.tagName&&"a"===t.tagName.toLowerCase()&&ai(t,"leaflet-active"),this._simulateEvent("mouseup",i),this._isTapValid()&&this._simulateEvent("click",i))},_isTapValid:function(){return this._newPos.distanceTo(this._startPos)<=this._map.options.tapTolerance},_onMove:function(t){t=t.touches[0];this._newPos=new k(t.clientX,t.clientY),this._simulateEvent("mousemove",t)},_simulateEvent:function(t,i){var e=document.createEvent("MouseEvents");e._simulated=!0,i.target._simulatedClick=!0,e.initMouseEvent(t,!0,!0,window,1,i.screenX,i.screenY,i.clientX,i.clientY,!1,!1,!1,!1,0,null),i.target.dispatchEvent(e)}});!Mt||vt&&!lt||Di.addInitHook("addHandler","tap",W),Di.mergeOptions({touchZoom:Mt&&!st,bounceAtZoomLimits:!0});nt=mt.extend({addHooks:function(){oi(this._map._container,"leaflet-touch-zoom"),Mi(this._map._container,"touchstart",this._onTouchStart,this)},removeHooks:function(){ai(this._map._container,"leaflet-touch-zoom"),bi(this._map._container,"touchstart",this._onTouchStart,this)},_onTouchStart:function(t){var i,e,s=this._map;!t.touches||2!==t.touches.length||s._animatingZoom||this._zooming||(i=s.mouseEventToContainerPoint(t.touches[0]),e=s.mouseEventToContainerPoint(t.touches[1]),this._centerPoint=s.getSize()._divideBy(2),this._startLatLng=s.containerPointToLatLng(this._centerPoint),"center"!==s.options.touchZoom&&(this._pinchStartLatLng=s.containerPointToLatLng(i.add(e)._divideBy(2))),this._startDist=i.distanceTo(e),this._startZoom=s.getZoom(),this._moved=!1,this._zooming=!0,s._stop(),Mi(document,"touchmove",this._onTouchMove,this),Mi(document,"touchend",this._onTouchEnd,this),zi(t))},_onTouchMove:function(t){if(t.touches&&2===t.touches.length&&this._zooming){var i=this._map,e=i.mouseEventToContainerPoint(t.touches[0]),s=i.mouseEventToContainerPoint(t.touches[1]),n=e.distanceTo(s)/this._startDist;if(this._zoom=i.getScaleZoom(n,this._startZoom),!i.options.bounceAtZoomLimits&&(this._zoom<i.getMinZoom()&&n<1||this._zoom>i.getMaxZoom()&&1<n)&&(this._zoom=i._limitZoom(this._zoom)),"center"===i.options.touchZoom){if(this._center=this._startLatLng,1==n)return}else{s=e._add(s)._divideBy(2)._subtract(this._centerPoint);if(1==n&&0===s.x&&0===s.y)return;this._center=i.unproject(i.project(this._pinchStartLatLng,this._zoom).subtract(s),this._zoom)}this._moved||(i._moveStart(!0,!1),this._moved=!0),C(this._animRequest);i=d(i._move,i,this._center,this._zoom,{pinch:!0,round:!1});this._animRequest=T(i,this,!0),zi(t)}},_onTouchEnd:function(){this._moved&&this._zooming?(this._zooming=!1,C(this._animRequest),bi(document,"touchmove",this._onTouchMove,this),bi(document,"touchend",this._onTouchEnd,this),this._map.options.zoomAnimation?this._map._animateZoom(this._center,this._map._limitZoom(this._zoom),!0,this._map.options.zoomSnap):this._map._resetView(this._center,this._map._limitZoom(this._zoom))):this._zooming=!1}});Di.addInitHook("addHandler","touchZoom",nt),Di.BoxZoom=z,Di.DoubleClickZoom=V,Di.Drag=K,Di.Keyboard=U,Di.ScrollWheelZoom=dt,Di.Tap=W,Di.TouchZoom=nt,t.version="1.7.1",t.Control=Gi,t.control=qi,t.Browser=ut,t.Evented=A,t.Mixin=gt,t.Util=S,t.Class=E,t.Handler=mt,t.extend=h,t.bind=d,t.stamp=m,t.setOptions=c,t.DomEvent=pt,t.DomUtil=ct,t.PosAnimation=ji,t.Draggable=Qi,t.LineUtil=yt,t.PolyUtil=Q,t.Point=k,t.point=O,t.Bounds=N,t.bounds=B,t.Transformation=F,t.transformation=H,t.Projection=rt,t.LatLng=j,t.latLng=D,t.LatLngBounds=Z,t.latLngBounds=R,t.CRS=q,t.GeoJSON=Me,t.geoJSON=Ee,t.geoJson=ht,t.Layer=he,t.LayerGroup=le,t.layerGroup=function(t,i){return new le(t,i)},t.FeatureGroup=ue,t.featureGroup=function(t,i){return new ue(t,i)},t.ImageOverlay=ze,t.imageOverlay=function(t,i,e){return new ze(t,i,e)},t.VideoOverlay=Ae,t.videoOverlay=function(t,i,e){return new Ae(t,i,e)},t.SVGOverlay=ke,t.svgOverlay=function(t,i,e){return new ke(t,i,e)},t.DivOverlay=Ie,t.Popup=Oe,t.popup=function(t,i){return new Oe(t,i)},t.Tooltip=Ne,t.tooltip=function(t,i){return new Ne(t,i)},t.Icon=ce,t.icon=function(t){return new ce(t)},t.DivIcon=Be,t.divIcon=function(t){return new Be(t)},t.Marker=pe,t.marker=function(t,i){return new pe(t,i)},t.TileLayer=Re,t.tileLayer=je,t.GridLayer=Ze,t.gridLayer=function(t){return new Ze(t)},t.SVG=He,t.svg=Ve,t.Renderer=qe,t.Canvas=Ge,t.canvas=We,t.Path=me,t.CircleMarker=fe,t.circleMarker=function(t,i){return new fe(t,i)},t.Circle=ge,t.circle=function(t,i,e){return new ge(t,i,e)},t.Polyline=ye,t.polyline=function(t,i){return new ye(t,i)},t.Polygon=ve,t.polygon=function(t,i){return new ve(t,i)},t.Rectangle=Ke,t.rectangle=function(t,i){return new Ke(t,i)},t.Map=Di,t.map=function(t,i){return new Di(t,i)};var Xe=window.L;t.noConflict=function(){return window.L=Xe,this},window.L=t}),function(t,i){"object"==typeof exports&&"undefined"!=typeof module?module.exports=i():"function"==typeof define&&define.amd?define(i):t.proj4=i()}(window,function(){"use strict";var _=1,p=2,m=4,f=5,w=484813681109536e-20,g=Math.PI/2,y=.16666666666666666,v=.04722222222222222,M=.022156084656084655,x=1e-10,r=.017453292519943295,o=57.29577951308232,b=Math.PI/4,e=2*Math.PI,u=3.14159265359,h={greenwich:0,lisbon:-9.131906111111,paris:2.337229166667,bogota:-74.080916666667,madrid:-3.687938888889,rome:12.452333333333,bern:7.439583333333,jakarta:106.807719444444,ferro:-17.666666666667,brussels:4.367975,stockholm:18.058277777778,athens:23.7163375,oslo:10.722916666667},l={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}},a=/[\s_\-\/\(\)]/g;function P(t,i){if(t[i])return t[i];for(var e,s=Object.keys(t),n=i.toLowerCase().replace(a,""),o=-1;++o<s.length;)if((e=s[o]).toLowerCase().replace(a,"")===n)return t[e]}var n=function(t){var i,e,s,n={},o=t.split("+").map(function(t){return t.trim()}).filter(function(t){return t}).reduce(function(t,i){i=i.split("=");return i.push(!0),t[i[0].toLowerCase()]=i[1],t},{}),a={proj:"projName",datum:"datumCode",rf:function(t){n.rf=parseFloat(t)},lat_0:function(t){n.lat0=t*r},lat_1:function(t){n.lat1=t*r},lat_2:function(t){n.lat2=t*r},lat_ts:function(t){n.lat_ts=t*r},lon_0:function(t){n.long0=t*r},lon_1:function(t){n.long1=t*r},lon_2:function(t){n.long2=t*r},alpha:function(t){n.alpha=parseFloat(t)*r},lonc:function(t){n.longc=t*r},x_0:function(t){n.x0=parseFloat(t)},y_0:function(t){n.y0=parseFloat(t)},k_0:function(t){n.k0=parseFloat(t)},k:function(t){n.k0=parseFloat(t)},a:function(t){n.a=parseFloat(t)},b:function(t){n.b=parseFloat(t)},r_a:function(){n.R_A=!0},zone:function(t){n.zone=parseInt(t,10)},south:function(){n.utmSouth=!0},towgs84:function(t){n.datum_params=t.split(",").map(function(t){return parseFloat(t)})},to_meter:function(t){n.to_meter=parseFloat(t)},units:function(t){n.units=t;t=P(l,t);t&&(n.to_meter=t.to_meter)},from_greenwich:function(t){n.from_greenwich=t*r},pm:function(t){var i=P(h,t);n.from_greenwich=(i||parseFloat(t))*r},nadgrids:function(t){"@null"===t?n.datumCode="none":n.nadgrids=t},axis:function(t){var i="ewnsud";3===t.length&&-1!==i.indexOf(t.substr(0,1))&&-1!==i.indexOf(t.substr(1,1))&&-1!==i.indexOf(t.substr(2,1))&&(n.axis=t)}};for(i in o)e=o[i],i in a?"function"==typeof(s=a[i])?s(e):n[s]=e:n[i]=e;return"string"==typeof n.datumCode&&"WGS84"!==n.datumCode&&(n.datumCode=n.datumCode.toLowerCase()),n},i=/\s/,s=/[A-Za-z]/,c=/[A-Za-z84]/,d=/[,\]]/,L=/[\d\.E\-\+]/;function T(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}function C(t,i,e){Array.isArray(i)&&(e.unshift(i),i=null);e=e.reduce(function(t,i){return S(i,t),t},i?{}:t);i&&(t[i]=e)}function S(t,i){if(Array.isArray(t)){var e,s=t.shift();if("PARAMETER"===s&&(s=t.shift()),1===t.length)return Array.isArray(t[0])?(i[s]={},void S(t[0],i[s])):void(i[s]=t[0]);if(t.length)if("TOWGS84"!==s){if("AXIS"===s)return s in i||(i[s]=[]),void i[s].push(t);switch(Array.isArray(s)||(i[s]={}),s){case"UNIT":case"PRIMEM":case"VERT_DATUM":return i[s]={name:t[0].toLowerCase(),convert:t[1]},void(3===t.length&&S(t[2],i[s]));case"SPHEROID":case"ELLIPSOID":return i[s]={name:t[0],a:t[1],rf:t[2]},void(4===t.length&&S(t[3],i[s]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return t[0]=["name",t[0]],void C(i,s,t);default:for(e=-1;++e<t.length;)if(!Array.isArray(t[e]))return S(t,i[s]);return C(i,s,t)}}else i[s]=t;else i[s]=!0}else i[t]=!0}T.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;i.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},T.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(d.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},T.prototype.afterItem=function(t){if(","===t)return null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1);"]"===t&&(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),this.currentObject||(this.state=-1))},T.prototype.number=function(t){if(!L.test(t)){if(d.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},T.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},T.prototype.keyword=function(t){if(c.test(t))this.word+=t;else{if("["===t){var i=[];return i.push(this.word),this.level++,null===this.root?this.root=i:this.currentObject.push(i),this.stack.push(this.currentObject),this.currentObject=i,void(this.state=1)}if(!d.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},T.prototype.neutral=function(t){if(s.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(L.test(t))return this.word=t,void(this.state=3);if(!d.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},T.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)};function E(t){return.017453292519943295*t}function z(n){if("GEOGCS"===n.type?n.projName="longlat":"LOCAL_CS"===n.type?(n.projName="identity",n.local=!0):"object"==typeof n.PROJECTION?n.projName=Object.keys(n.PROJECTION)[0]:n.projName=n.PROJECTION,n.AXIS){for(var t="",i=0,e=n.AXIS.length;i<e;++i){var s=n.AXIS[i][0].toLowerCase();-1!==s.indexOf("north")?t+="n":-1!==s.indexOf("south")?t+="s":-1!==s.indexOf("east")?t+="e":-1!==s.indexOf("west")&&(t+="w")}2===t.length&&(t+="u"),3===t.length&&(n.axis=t)}n.UNIT&&(n.units=n.UNIT.name.toLowerCase(),"metre"===n.units&&(n.units="meter"),n.UNIT.convert&&("GEOGCS"===n.type?n.DATUM&&n.DATUM.SPHEROID&&(n.to_meter=n.UNIT.convert*n.DATUM.SPHEROID.a):n.to_meter=n.UNIT.convert));var o=n.GEOGCS;function a(t){return t*(n.to_meter||1)}(o="GEOGCS"===n.type?n:o)&&(o.DATUM?n.datumCode=o.DATUM.name.toLowerCase():n.datumCode=o.name.toLowerCase(),"d_"===n.datumCode.slice(0,2)&&(n.datumCode=n.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==n.datumCode&&"new_zealand_1949"!==n.datumCode||(n.datumCode="nzgd49"),"wgs_1984"!==n.datumCode&&"world_geodetic_system_1984"!==n.datumCode||("Mercator_Auxiliary_Sphere"===n.PROJECTION&&(n.sphere=!0),n.datumCode="wgs84"),"_ferro"===n.datumCode.slice(-6)&&(n.datumCode=n.datumCode.slice(0,-6)),"_jakarta"===n.datumCode.slice(-8)&&(n.datumCode=n.datumCode.slice(0,-8)),~n.datumCode.indexOf("belge")&&(n.datumCode="rnb72"),o.DATUM&&o.DATUM.SPHEROID&&(n.ellps=o.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===n.ellps.toLowerCase().slice(0,13)&&(n.ellps="intl"),n.a=o.DATUM.SPHEROID.a,n.rf=parseFloat(o.DATUM.SPHEROID.rf,10)),o.DATUM&&o.DATUM.TOWGS84&&(n.datum_params=o.DATUM.TOWGS84),~n.datumCode.indexOf("osgb_1936")&&(n.datumCode="osgb36"),~n.datumCode.indexOf("osni_1952")&&(n.datumCode="osni52"),(~n.datumCode.indexOf("tm65")||~n.datumCode.indexOf("geodetic_datum_of_1965"))&&(n.datumCode="ire65"),"ch1903+"===n.datumCode&&(n.datumCode="ch1903"),~n.datumCode.indexOf("israel")&&(n.datumCode="isr93")),n.b&&!isFinite(n.b)&&(n.b=n.a);[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",E],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",E],["x0","false_easting",a],["y0","false_northing",a],["long0","central_meridian",E],["lat0","latitude_of_origin",E],["lat0","standard_parallel_1",E],["lat1","standard_parallel_1",E],["lat2","standard_parallel_2",E],["azimuth","Azimuth"],["alpha","azimuth",E],["srsCode","name"]].forEach(function(t){var i,e,s;i=n,s=(e=t)[0],t=e[1],!(s in i)&&t in i&&(i[s]=i[t],3===e.length&&(i[s]=e[2](i[s])))}),n.long0||!n.longc||"Albers_Conic_Equal_Area"!==n.projName&&"Lambert_Azimuthal_Equal_Area"!==n.projName||(n.long0=n.longc),n.lat_ts||!n.lat1||"Stereographic_South_Pole"!==n.projName&&"Polar Stereographic (variant B)"!==n.projName||(n.lat0=E(0<n.lat1?90:-90),n.lat_ts=n.lat1)}var A=function(t){var i=new T(t).output(),e=i.shift(),t=i.shift();i.unshift(["name",t]),i.unshift(["type",e]);e={};return S(i,e),z(e),e};function k(t){var i=this;if(2===arguments.length){var e=arguments[1];"string"==typeof e?"+"===e.charAt(0)?k[t]=n(arguments[1]):k[t]=A(arguments[1]):k[t]=e}else if(1===arguments.length){if(Array.isArray(t))return t.map(function(t){Array.isArray(t)?k.apply(i,t):k(t)});if("string"==typeof t){if(t in k)return k[t]}else"EPSG"in t?k["EPSG:"+t.EPSG]=t:"ESRI"in t?k["ESRI:"+t.ESRI]=t:"IAU2000"in t?k["IAU2000:"+t.IAU2000]=t:console.log(t)}}(Yi=k)("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),Yi("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),Yi("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),Yi.WGS84=Yi["EPSG:4326"],Yi["EPSG:3785"]=Yi["EPSG:3857"],Yi.GOOGLE=Yi["EPSG:3857"],Yi["EPSG:900913"]=Yi["EPSG:3857"],Yi["EPSG:102113"]=Yi["EPSG:3857"];var I=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var O=["3857","900913","3785","102113"];function N(t){if("string"!=typeof t)return t;if(t in k)return k[t];if(s=t,I.some(function(t){return-1<s.indexOf(t)})){var i=A(t);if(function(t){if(t=P(t,"authority")){t=P(t,"epsg");return t&&-1<O.indexOf(t)}}(i))return k["EPSG:3857"];var e=function(t){if(t=P(t,"extension"))return P(t,"proj4")}(i);return e?n(e):i}return"+"===t[0]?n(t):void 0;var s}function B(t,i){var e,s;if(t=t||{},!i)return t;for(s in i)void 0!==(e=i[s])&&(t[s]=e);return t}function Z(t,i,e){return i*=t,e/Math.sqrt(1-i*i)}function R(t,i,e){return e*=t,e=Math.pow((1-e)/(1+e),.5*t),Math.tan(.5*(g-i))/e}function j(t,i){for(var e,s=.5*t,n=g-2*Math.atan(i),o=0;o<=15;o++)if(e=t*Math.sin(n),n+=e=g-2*Math.atan(i*Math.pow((1-e)/(1+e),s))-n,Math.abs(e)<=1e-10)return n;return-9999}var D=function(t){return t<0?-1:1},q=function(t){return Math.abs(t)<=u?t:t-D(t)*e};function t(t){return t}var G=[{init:function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=Z(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},forward:function(t){var i,e,s=t.x,n=t.y;return 90<n*o&&n*o<-90&&180<s*o&&s*o<-180||Math.abs(Math.abs(n)-g)<=x?null:(e=this.sphere?(i=this.x0+this.a*this.k0*q(s-this.long0),this.y0+this.a*this.k0*Math.log(Math.tan(b+.5*n))):(e=Math.sin(n),e=R(this.e,n,e),i=this.x0+this.a*this.k0*q(s-this.long0),this.y0-this.a*this.k0*Math.log(e)),t.x=i,t.y=e,t)},inverse:function(t){var i=t.x-this.x0,e=t.y-this.y0;if(this.sphere)s=g-2*Math.atan(Math.exp(-e/(this.a*this.k0)));else{var s,e=Math.exp(-e/(this.a*this.k0));if(-9999===(s=j(this.e,e)))return null}return i=q(this.long0+i/(this.a*this.k0)),t.x=i,t.y=s,t},names:["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},{init:function(){},forward:t,inverse:t,names:["longlat","identity"]}],W={},U=[];function F(t,i){var e=U.length;return t.names?((U[e]=t).names.forEach(function(t){W[t.toLowerCase()]=e}),this):(console.log(i),!0)}var H={start:function(){G.forEach(F)},add:F,get:function(t){return!!t&&(t=t.toLowerCase(),void 0!==W[t]&&U[W[t]]?U[W[t]]:void 0)}},V={MERIT:{a:6378137,rf:298.257,ellipseName:"MERIT 1983"},SGS85:{a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},GRS80:{a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},IAU76:{a:6378140,rf:298.257,ellipseName:"IAU 1976"},airy:{a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},APL4:{a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},NWL9D:{a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},mod_airy:{a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},andrae:{a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},aust_SA:{a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},GRS67:{a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},bessel:{a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},bess_nam:{a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},clrk66:{a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},clrk80:{a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},clrk58:{a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},CPM:{a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},delmbr:{a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},engelis:{a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},evrst30:{a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},evrst48:{a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},evrst56:{a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},evrst69:{a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},evrstSS:{a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},fschr60:{a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},fschr60m:{a:6378155,rf:298.3,ellipseName:"Fischer 1960"},fschr68:{a:6378150,rf:298.3,ellipseName:"Fischer 1968"},helmert:{a:6378200,rf:298.3,ellipseName:"Helmert 1906"},hough:{a:6378270,rf:297,ellipseName:"Hough"},intl:{a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},kaula:{a:6378163,rf:298.24,ellipseName:"Kaula 1961"},lerch:{a:6378139,rf:298.257,ellipseName:"Lerch 1979"},mprts:{a:6397300,rf:191,ellipseName:"Maupertius 1738"},new_intl:{a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},plessis:{a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},krass:{a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},SEasia:{a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},walbeck:{a:6376896,b:6355834.8467,ellipseName:"Walbeck"},WGS60:{a:6378165,rf:298.3,ellipseName:"WGS 60"},WGS66:{a:6378145,rf:298.25,ellipseName:"WGS 66"},WGS7:{a:6378135,rf:298.26,ellipseName:"WGS 72"}},K=V.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"};V.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"};var X={};function J(t,i){if(!(this instanceof J))return new J(t);i=i||function(t){if(t)throw t};var e,s,n,o,a,r,h,l,u,c,d=N(t);"object"==typeof d&&(e=J.projections.get(d.projName))?(!d.datumCode||"none"===d.datumCode||(h=P(X,d.datumCode))&&(d.datum_params=h.towgs84?h.towgs84.split(","):null,d.ellps=h.ellipse,d.datumName=h.datumName||d.datumCode),d.k0=d.k0||1,d.axis=d.axis||"enu",d.ellps=d.ellps||"wgs84",l=d.a,u=d.b,r=d.rf,o=d.ellps,n=d.sphere,l||(l=(o=(o=P(V,o))||K).a,u=o.b,r=o.rf),r&&!u&&(u=(1-1/r)*l),(0===r||Math.abs(l-u)<x)&&(n=!0,u=l),a=(s={a:l,b:u,rf:r,sphere:n}).a,h=s.b,o=d.R_A,r=((l=a*a)-(u=h*h))/l,h=0,o?(l=(a*=1-r*(y+r*(v+r*M)))*a,r=0):h=Math.sqrt(r),n={es:r,e:h,ep2:(l-u)/u},c=d.datum||(o=d.datumCode,a=d.datum_params,r=s.a,h=s.b,l=n.es,u=n.ep2,(c={}).datum_type=void 0===o||"none"===o?f:m,a&&(c.datum_params=a.map(parseFloat),0===c.datum_params[0]&&0===c.datum_params[1]&&0===c.datum_params[2]||(c.datum_type=_),3<c.datum_params.length&&(0===c.datum_params[3]&&0===c.datum_params[4]&&0===c.datum_params[5]&&0===c.datum_params[6]||(c.datum_type=p,c.datum_params[3]*=w,c.datum_params[4]*=w,c.datum_params[5]*=w,c.datum_params[6]=c.datum_params[6]/1e6+1))),c.a=r,c.b=h,c.es=l,c.ep2=u,c),B(this,d),B(this,e),this.a=s.a,this.b=s.b,this.rf=s.rf,this.sphere=s.sphere,this.es=n.es,this.e=n.e,this.ep2=n.ep2,this.datum=c,this.init(),i(null,this)):i(t)}function Q(t,i,e){var s=t.x,n=t.y,o=t.z||0;if(n<-g&&-1.001*g<n)n=-g;else if(g<n&&n<1.001*g)n=g;else{if(n<-g)return{x:-1/0,y:-1/0,z:t.z};if(g<n)return{x:1/0,y:1/0,z:t.z}}return s>Math.PI&&(s-=2*Math.PI),t=Math.sin(n),n=Math.cos(n),{x:((e=e/Math.sqrt(1-i*(t*t)))+o)*n*Math.cos(s),y:(e+o)*n*Math.sin(s),z:(e*(1-i)+o)*t}}function Y(t,i,e,s){var n,o,a,r,h,l,u,c,d,_,p,m=1e-12,f=t.x,g=t.y,y=t.z||0,v=Math.sqrt(f*f+g*g),M=Math.sqrt(f*f+g*g+y*y);if(v/e<m){if(_=0,M/e<m)return p=-s,{x:t.x,y:t.y,z:t.z}}else _=Math.atan2(g,f);for(n=y/M,r=(o=v/M)*(1-i)*(a=1/Math.sqrt(1-i*(2-i)*o*o)),h=n*a,d=0;d++,c=i*(c=e/Math.sqrt(1-i*h*h))/(c+(p=v*r+y*h-c*(1-i*h*h))),c=(u=n*(a=1/Math.sqrt(1-c*(2-c)*o*o)))*r-(l=o*(1-c)*a)*h,r=l,h=u,1e-24<c*c&&d<30;);return{x:_,y:Math.atan(u/Math.abs(l)),z:p}}function $(t){return t===_||t===p}X.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},X.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},X.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},X.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},X.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},X.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},X.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},X.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},X.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},X.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},X.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},X.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},X.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},X.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},X.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},X.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},X.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"},(J.projections=H).start();function tt(t,i,e){return n=i,((s=t).datum_type!==n.datum_type||s.a!==n.a||5e-11<Math.abs(s.es-n.es)||(s.datum_type===_?s.datum_params[0]!==n.datum_params[0]||s.datum_params[1]!==n.datum_params[1]||s.datum_params[2]!==n.datum_params[2]:s.datum_type===p&&(s.datum_params[0]!==n.datum_params[0]||s.datum_params[1]!==n.datum_params[1]||s.datum_params[2]!==n.datum_params[2]||s.datum_params[3]!==n.datum_params[3]||s.datum_params[4]!==n.datum_params[4]||s.datum_params[5]!==n.datum_params[5]||s.datum_params[6]!==n.datum_params[6])))&&t.datum_type!==f&&i.datum_type!==f&&(t.es!==i.es||t.a!==i.a||$(t.datum_type)||$(i.datum_type))?(e=Q(e,t.es,t.a),$(t.datum_type)&&(e=function(t,i,e){if(i===_)return{x:t.x+e[0],y:t.y+e[1],z:t.z+e[2]};if(i===p){var s=e[0],n=e[1],o=e[2],a=e[3],r=e[4],i=e[5],e=e[6];return{x:e*(t.x-i*t.y+r*t.z)+s,y:e*(i*t.x+t.y-a*t.z)+n,z:e*(-r*t.x+a*t.y+t.z)+o}}}(e,t.datum_type,t.datum_params)),Y(e=$(i.datum_type)?function(t,i,e){if(i===_)return{x:t.x-e[0],y:t.y-e[1],z:t.z-e[2]};if(i===p){var s=e[0],n=e[1],o=e[2],a=e[3],r=e[4],i=e[5],e=e[6],s=(t.x-s)/e,n=(t.y-n)/e,e=(t.z-o)/e;return{x:s+i*n-r*e,y:-i*s+n+a*e,z:r*s-a*n+e}}}(e,i.datum_type,i.datum_params):e,i.es,i.a,i.b)):e;var s,n}function it(t,i,e){for(var s,n,o=e.x,a=e.y,r=e.z||0,h={},l=0;l<3;l++)if(!i||2!==l||void 0!==e.z)switch(n=0===l?(s=o,-1!=="ew".indexOf(t.axis[l])?"x":"y"):1===l?(s=a,-1!=="ns".indexOf(t.axis[l])?"y":"x"):(s=r,"z"),t.axis[l]){case"e":case"w":case"n":case"s":h[n]=s;break;case"u":void 0!==e[n]&&(h.z=s);break;case"d":void 0!==e[n]&&(h.z=-s);break;default:return null}return h}function et(t){var i={x:t[0],y:t[1]};return 2<t.length&&(i.z=t[2]),3<t.length&&(i.m=t[3]),i}function st(t){nt(t.x),nt(t.y)}function nt(t){if("function"==typeof Number.isFinite){if(Number.isFinite(t))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof t||t!=t||!isFinite(t))throw new TypeError("coordinates must be finite numbers")}function ot(t,i,e){var s,n;if(Array.isArray(e)&&(e=et(e)),st(e),t.datum&&i.datum&&(n=i,((s=t).datum.datum_type===_||s.datum.datum_type===p)&&"WGS84"!==n.datumCode||(n.datum.datum_type===_||n.datum.datum_type===p)&&"WGS84"!==s.datumCode)&&(e=ot(t,s=new J("WGS84"),e),t=s),"enu"!==t.axis&&(e=it(t,!1,e)),"longlat"===t.projName)e={x:e.x*r,y:e.y*r,z:e.z||0};else if(t.to_meter&&(e={x:e.x*t.to_meter,y:e.y*t.to_meter,z:e.z||0}),!(e=t.inverse(e)))return;return t.from_greenwich&&(e.x+=t.from_greenwich),e=tt(t.datum,i.datum,e),i.from_greenwich&&(e={x:e.x-i.from_greenwich,y:e.y,z:e.z||0}),"longlat"===i.projName?e={x:e.x*o,y:e.y*o,z:e.z||0}:(e=i.forward(e),i.to_meter&&(e={x:e.x/i.to_meter,y:e.y/i.to_meter,z:e.z||0})),"enu"!==i.axis?it(i,!0,e):e}var at=J("WGS84");function rt(i,e,s){var n,t;return Array.isArray(s)?(t=ot(i,e,s)||{x:NaN,y:NaN},2<s.length?void 0!==i.name&&"geocent"===i.name||void 0!==e.name&&"geocent"===e.name?("number"==typeof t.z?[t.x,t.y,t.z]:[t.x,t.y,s[2]]).concat(s.splice(3)):[t.x,t.y].concat(s.splice(2)):[t.x,t.y]):(n=ot(i,e,s),2===(t=Object.keys(s)).length||t.forEach(function(t){if(void 0!==i.name&&"geocent"===i.name||void 0!==e.name&&"geocent"===e.name){if("x"===t||"y"===t||"z"===t)return}else if("x"===t||"y"===t)return;n[t]=s[t]}),n)}function ht(t){return t instanceof J?t:t.oProj||J(t)}function lt(i,e,t){i=ht(i);var s=!1;return void 0===e?(e=i,i=at,s=!0):void 0===e.x&&!Array.isArray(e)||(t=e,e=i,i=at,s=!0),e=ht(e),t?rt(i,e,t):(t={forward:function(t){return rt(i,e,t)},inverse:function(t){return rt(e,i,t)}},s&&(t.oProj=e),t)}var ut=6,ct="AJSAJS",dt="AFAFAF",_t=65,pt=73,mt=79,ft=86,gt=90,yt={forward:vt,inverse:function(t){t=wt(Lt(t.toUpperCase()));if(t.lat&&t.lon)return[t.lon,t.lat,t.lon,t.lat];return[t.left,t.bottom,t.right,t.top]},toPoint:Mt};function vt(t,i){return i=i||5,e=function(t){var i,e,s,n,o=t.lat,a=t.lon,r=.00669438,h=xt(o),l=xt(a);n=Math.floor((a+180)/6)+1,180===a&&(n=60);56<=o&&o<64&&3<=a&&a<12&&(n=32);72<=o&&o<84&&(0<=a&&a<9?n=31:9<=a&&a<21?n=33:21<=a&&a<33?n=35:33<=a&&a<42&&(n=37));s=xt(6*(n-1)-180+3),i=r/(1-r),e=6378137/Math.sqrt(1-r*Math.sin(h)*Math.sin(h)),t=Math.tan(h)*Math.tan(h),a=i*Math.cos(h)*Math.cos(h),l=Math.cos(h)*(l-s),s=6378137*(.9983242984503243*h-.002514607064228144*Math.sin(2*h)+2639046602129982e-21*Math.sin(4*h)-35*r*r*r/3072*Math.sin(6*h));r=.9996*e*(l+(1-t+a)*l*l*l/6+(5-18*t+t*t+72*a-58*i)*l*l*l*l*l/120)+5e5,l=.9996*(s+e*Math.tan(h)*(l*l/2+(5-t+9*a+4*a*a)*l*l*l*l/24+(61-58*t+t*t+600*a-330*i)*l*l*l*l*l*l/720));o<0&&(l+=1e7);return{northing:Math.round(l),easting:Math.round(r),zoneNumber:n,zoneLetter:function(t){var i="Z";t<=84&&72<=t?i="X":t<72&&64<=t?i="W":t<64&&56<=t?i="V":t<56&&48<=t?i="U":t<48&&40<=t?i="T":t<40&&32<=t?i="S":t<32&&24<=t?i="R":t<24&&16<=t?i="Q":t<16&&8<=t?i="P":t<8&&0<=t?i="N":t<0&&-8<=t?i="M":t<-8&&-16<=t?i="L":t<-16&&-24<=t?i="K":t<-24&&-32<=t?i="J":t<-32&&-40<=t?i="H":t<-40&&-48<=t?i="G":t<-48&&-56<=t?i="F":t<-56&&-64<=t?i="E":t<-64&&-72<=t?i="D":t<-72&&-80<=t&&(i="C");return i}(o)}}({lat:t[1],lon:t[0]}),s=i,t="00000"+e.easting,i="00000"+e.northing,e.zoneNumber+e.zoneLetter+function(t,i,e){e=Pt(e),t=Math.floor(t/1e5),i=Math.floor(i/1e5)%20;return function(t,i,e){var s=e-1,n=ct.charCodeAt(s),e=dt.charCodeAt(s),s=n+t-1,t=e+i,i=!1;gt<s&&(s=s-gt+_t-1,i=!0);(s===pt||n<pt&&pt<s||(pt<s||n<pt)&&i)&&s++;(s===mt||n<mt&&mt<s||(mt<s||n<mt)&&i)&&++s===pt&&s++;gt<s&&(s=s-gt+_t-1);i=ft<t&&(t=t-ft+_t-1,!0);(t===pt||e<pt&&pt<t||(pt<t||e<pt)&&i)&&t++;(t===mt||e<mt&&mt<t||(mt<t||e<mt)&&i)&&++t===pt&&t++;ft<t&&(t=t-ft+_t-1);return String.fromCharCode(s)+String.fromCharCode(t)}(t,i,e)}(e.easting,e.northing,e.zoneNumber)+t.substr(t.length-5,s)+i.substr(i.length-5,s);var e,s}function Mt(t){t=wt(Lt(t.toUpperCase()));return t.lat&&t.lon?[t.lon,t.lat]:[(t.left+t.right)/2,(t.top+t.bottom)/2]}function xt(t){return t*(Math.PI/180)}function bt(t){return t/Math.PI*180}function wt(t){var i=t.northing,e=t.easting,s=t.zoneLetter,n=t.zoneNumber;if(n<0||60<n)return null;var o=6378137,a=.00669438,r=(1-Math.sqrt(1-a))/(1+Math.sqrt(1-a)),h=e-5e5,l=i;s<"N"&&(l-=1e7);var e=6*(n-1)-180+3,i=a/(1-a),n=(s=l/.9996/6367449.145945056)+(3*r/2-27*r*r*r/32)*Math.sin(2*s)+(21*r*r/16-55*r*r*r*r/32)*Math.sin(4*s)+151*r*r*r/96*Math.sin(6*s),l=o/Math.sqrt(1-a*Math.sin(n)*Math.sin(n)),r=Math.tan(n)*Math.tan(n),s=i*Math.cos(n)*Math.cos(n),a=o*(1-a)/Math.pow(1-a*Math.sin(n)*Math.sin(n),1.5),h=h/(.9996*l),a=bt(a=n-l*Math.tan(n)/a*(h*h/2-(5+3*r+10*s-4*s*s-9*i)*h*h*h*h/24+(61+90*r+298*s+45*r*r-252*i-3*s*s)*h*h*h*h*h*h/720)),n=e+bt(n=(h-(1+2*r+s)*h*h*h/6+(5-2*s+28*r-3*s*s+8*i+24*r*r)*h*h*h*h*h/120)/Math.cos(n));return t.accuracy?{top:(t=wt({northing:t.northing+t.accuracy,easting:t.easting+t.accuracy,zoneLetter:t.zoneLetter,zoneNumber:t.zoneNumber})).lat,right:t.lon,bottom:a,left:n}:{lat:a,lon:n}}function Pt(t){t%=ut;return t=0===t?ut:t}function Lt(t){if(t&&0===t.length)throw"MGRSPoint coverting from nothing";for(var i,e=t.length,s=null,n="",o=0;!/[A-Z]/.test(i=t.charAt(o));){if(2<=o)throw"MGRSPoint bad conversion from: "+t;n+=i,o++}var a=parseInt(n,10);if(0===o||e<o+3)throw"MGRSPoint bad conversion from: "+t;var r=t.charAt(o++);if(r<="A"||"B"===r||"Y"===r||"Z"<=r||"I"===r||"O"===r)throw"MGRSPoint zone letter "+r+" not handled: "+t;for(var s=t.substring(o,o+=2),h=Pt(a),l=function(t,i){var e=ct.charCodeAt(i-1),s=1e5,n=!1;for(;e!==t.charCodeAt(0);){if(++e===pt&&e++,e===mt&&e++,gt<e){if(n)throw"Bad character: "+t;e=_t,n=!0}s+=1e5}return s}(s.charAt(0),h),u=function(t,i){if("V"<t)throw"MGRSPoint given invalid Northing "+t;var e=dt.charCodeAt(i-1),s=0,n=!1;for(;e!==t.charCodeAt(0);){if(++e===pt&&e++,e===mt&&e++,ft<e){if(n)throw"Bad character: "+t;e=_t,n=!0}s+=1e5}return s}(s.charAt(1),h);u<function(t){var i;switch(t){case"C":i=11e5;break;case"D":i=2e6;break;case"E":i=28e5;break;case"F":i=37e5;break;case"G":i=46e5;break;case"H":i=55e5;break;case"J":i=64e5;break;case"K":i=73e5;break;case"L":i=82e5;break;case"M":i=91e5;break;case"N":i=0;break;case"P":i=8e5;break;case"Q":i=17e5;break;case"R":i=26e5;break;case"S":i=35e5;break;case"T":i=44e5;break;case"U":i=53e5;break;case"V":i=62e5;break;case"W":i=7e6;break;case"X":i=79e5;break;default:i=-1}{if(0<=i)return i;throw"Invalid zone letter: "+t}}(r);)u+=2e6;var c=e-o;if(c%2!=0)throw"MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters"+t;var d,s=c/2,h=0,e=0;return 0<s&&(d=1e5/Math.pow(10,s),c=t.substring(o,o+s),h=parseFloat(c)*d,s=t.substring(o+s),e=parseFloat(s)*d),{easting:h+l,northing:e+u,zoneLetter:r,zoneNumber:a,accuracy:d}}function Tt(t,i,e){if(!(this instanceof Tt))return new Tt(t,i,e);var s;Array.isArray(t)?(this.x=t[0],this.y=t[1],this.z=t[2]||0):"object"==typeof t?(this.x=t.x,this.y=t.y,this.z=t.z||0):"string"==typeof t&&void 0===i?(s=t.split(","),this.x=parseFloat(s[0],10),this.y=parseFloat(s[1],10),this.z=parseFloat(s[2],10)||0):(this.x=t,this.y=i,this.z=e||0),console.warn("proj4.Point will be removed in version 3, use proj4.toPoint")}Tt.fromMGRS=function(t){return new Tt(Mt(t))},Tt.prototype.toMGRS=function(t){return vt([this.x,this.y],t)};function Ct(t){var i=[];i[0]=Et-t*(zt+t*(At+t*(kt+t*It))),i[1]=t*(Ot-t*(At+t*(kt+t*It)));var e=t*t;return i[2]=e*(Nt-t*(Bt+t*Zt)),i[3]=(e*=t)*(Rt-t*jt),i[4]=e*t*Dt,i}function St(t,i,e){for(var s=1/(1-i),n=t,o=Gt;o;--o){var a=Math.sin(n),r=1-i*a*a;if(n-=r=(qt(n,a,Math.cos(n),e)-t)*(r*Math.sqrt(r))*s,Math.abs(r)<x)return n}return n}var Et=1,zt=.25,At=.046875,kt=.01953125,It=.01068115234375,Ot=.75,Nt=.46875,Bt=.013020833333333334,Zt=.007120768229166667,Rt=.3645833333333333,jt=.005696614583333333,Dt=.3076171875,qt=function(t,i,e,s){return s[0]*t-(e*=i)*(s[1]+(i*=i)*(s[2]+i*(s[3]+i*s[4])))},Gt=20;function Wt(t,i){for(var e,s=2*Math.cos(2*i),n=t.length-1,o=t[n],a=0;0<=--n;)e=s*o-a+t[n],a=o,o=e;return i+e*Math.sin(2*i)}function Ut(t,i,e){for(var s,n,o=Math.sin(i),a=Math.cos(i),i=Ht(e),e=Xt(e),r=2*a*e,h=-2*o*i,l=t.length-1,u=t[l],c=0,d=0,_=0;0<=--l;)s=d,n=c,u=r*(d=u)-s-h*(c=_)+t[l],_=h*d-n+r*c;return[(r=o*e)*u-(h=a*i)*_,r*_+h*u]}var Ft={init:function(){this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.es&&(this.en=Ct(this.es),this.ml0=qt(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))},forward:function(t){var i=t.x,e=t.y,s=q(i-this.long0),n=Math.sin(e),o=Math.cos(e);if(this.es){var a=o*s,r=Math.pow(a,2),h=this.ep2*Math.pow(o,2),l=Math.pow(h,2),i=Math.abs(o)>x?Math.tan(e):0,u=Math.pow(i,2),c=Math.pow(u,2),d=1-this.es*Math.pow(n,2);a/=Math.sqrt(d);i=qt(e,n,o,this.en),d=this.a*(this.k0*a*(1+r/6*(1-u+h+r/20*(5-18*u+c+14*h-58*u*h+r/42*(61+179*c-c*u-479*u)))))+this.x0,c=this.a*(this.k0*(i-this.ml0+n*s*a/2*(1+r/12*(5-u+9*h+4*l+r/30*(61+c-58*u+270*h-330*u*h+r/56*(1385+543*c-c*u-3111*u))))))+this.y0}else{u=o*Math.sin(s);if(Math.abs(Math.abs(u)-1)<x)return 93;if(d=.5*this.a*this.k0*Math.log((1+u)/(1-u))+this.x0,c=o*Math.cos(s)/Math.sqrt(1-Math.pow(u,2)),1<=(u=Math.abs(c))){if(x<u-1)return 93;c=0}else c=Math.acos(c);c=this.a*this.k0*((c=e<0?-c:c)-this.lat0)+this.y0}return t.x=d,t.y=c,t},inverse:function(t){var i,e,s,n,o,a,r,h,l,u=(t.x-this.x0)*(1/this.a),c=(t.y-this.y0)*(1/this.a),d=this.es?(h=this.ml0+c/this.k0,i=St(h,this.es,this.en),Math.abs(i)<g?(a=Math.sin(i),e=Math.cos(i),r=Math.abs(e)>x?Math.tan(i):0,s=this.ep2*Math.pow(e,2),l=Math.pow(s,2),n=Math.pow(r,2),o=Math.pow(n,2),h=1-this.es*Math.pow(a,2),a=u*Math.sqrt(h)/this.k0,l=i-(h*=r)*(r=Math.pow(a,2))/(1-this.es)*.5*(1-r/12*(5+3*n-9*s*n+s-4*l-r/30*(61+90*n-252*s*n+45*o+46*s-r/56*(1385+3633*n+4095*o+1574*o*n)))),q(this.long0+a*(1-r/6*(1+2*n+s-r/20*(5+28*n+24*o+8*s*n+6*s-r/42*(61+662*n+1320*o+720*o*n))))/e)):(l=g*D(c),0)):(u=.5*((d=Math.exp(u/this.k0))-1/d),d=this.lat0+c/this.k0,d=Math.cos(d),h=Math.sqrt((1-Math.pow(d,2))/(1+Math.pow(u,2))),l=Math.asin(h),c<0&&(l=-l),0==u&&0===d?0:q(Math.atan2(u,d)+this.long0));return t.x=d,t.y=l,t},names:["Transverse_Mercator","Transverse Mercator","tmerc"]},Ht=function(t){var t=Math.exp(t);return t=(t-1/t)/2},Vt=function(t,i){t=Math.abs(t),i=Math.abs(i);var e=Math.max(t,i),i=Math.min(t,i)/(e||1);return e*Math.sqrt(1+Math.pow(i,2))},Kt=function(t){var i=1+t,e=i-1;return 0==e?t:t*Math.log(i)/e},Xt=function(t){var t=Math.exp(t);return t=(t+1/t)/2};var Jt={init:function(){if(void 0===this.es||this.es<=0)throw new Error("incorrect elliptical usage");this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.cgb=[],this.cbg=[],this.utg=[],this.gtu=[];var t=(i=this.es/(1+Math.sqrt(1-this.es)))/(2-i),i=t;this.cgb[0]=t*(2+t*(-2/3+t*(t*(116/45+t*(26/45+-2854/675*t))-2))),this.cbg[0]=t*(t*(2/3+t*(4/3+t*(-82/45+t*(32/45+4642/4725*t))))-2),this.cgb[1]=(i*=t)*(7/3+t*(t*(-227/45+t*(2704/315+2323/945*t))-1.6)),this.cbg[1]=i*(5/3+t*(-16/15+t*(-13/9+t*(904/315+-1522/945*t)))),this.cgb[2]=(i*=t)*(56/15+t*(-136/35+t*(-1262/105+73814/2835*t))),this.cbg[2]=i*(-26/15+t*(34/21+t*(1.6+-12686/2835*t))),this.cgb[3]=(i*=t)*(4279/630+t*(-332/35+-399572/14175*t)),this.cbg[3]=i*(1237/630+t*(-24832/14175*t-2.4)),this.cgb[4]=(i*=t)*(4174/315+-144838/6237*t),this.cbg[4]=i*(-734/315+109598/31185*t),this.cgb[5]=601676/22275*(i*=t),this.cbg[5]=444337/155925*i,i=Math.pow(t,2),this.Qn=this.k0/(1+t)*(1+i*(.25+i*(1/64+i/256))),this.utg[0]=t*(t*(2/3+t*(-37/96+t*(1/360+t*(81/512+-96199/604800*t))))-.5),this.gtu[0]=t*(.5+t*(-2/3+t*(5/16+t*(41/180+t*(-127/288+7891/37800*t))))),this.utg[1]=i*(-1/48+t*(-1/15+t*(437/1440+t*(-46/105+1118711/3870720*t)))),this.gtu[1]=i*(13/48+t*(t*(557/1440+t*(281/630+-1983433/1935360*t))-.6)),this.utg[2]=(i*=t)*(-17/480+t*(37/840+t*(209/4480+-5569/90720*t))),this.gtu[2]=i*(61/240+t*(-103/140+t*(15061/26880+167603/181440*t))),this.utg[3]=(i*=t)*(-4397/161280+t*(11/504+830251/7257600*t)),this.gtu[3]=i*(49561/161280+t*(-179/168+6601661/7257600*t)),this.utg[4]=(i*=t)*(-4583/161280+108847/3991680*t),this.gtu[4]=i*(34729/80640+-3418889/1995840*t),this.utg[5]=-.03233083094085698*(i*=t),this.gtu[5]=.6650675310896665*i,i=Wt(this.cbg,this.lat0),this.Zb=-this.Qn*(i+function(t,i){for(var e,s=2*Math.cos(i),n=t.length-1,o=t[n],a=0;0<=--n;)e=s*o-a+t[n],a=o,o=e;return Math.sin(i)*e}(this.gtu,2*i))},forward:function(t){var i=q(t.x-this.long0),e=t.y,e=Wt(this.cbg,e),s=Math.sin(e),n=Math.cos(e),o=Math.sin(i),a=Math.cos(i);e=Math.atan2(s,a*n),i=Math.atan2(o*n,Vt(s,n*a)),n=Math.tan(i),a=Math.abs(n),a=Kt(a*(1+a/(Vt(1,a)+1)));var r,a=Ut(this.gtu,2*e,2*(i=n<0?-a:a));return e+=a[0],i+=a[1],e=Math.abs(i)<=2.623395162778?(r=this.a*(this.Qn*i)+this.x0,this.a*(this.Qn*e+this.Zb)+this.y0):r=1/0,t.x=r,t.y=e,t},inverse:function(t){var i,e,s,n,o=(t.x-this.x0)*(1/this.a),a=(t.y-this.y0)*(1/this.a);return a=(a-this.Zb)/this.Qn,o/=this.Qn,a=Math.abs(o)<=2.623395162778?(a+=(n=Ut(this.utg,2*a,2*o))[0],o+=n[1],o=Math.atan(Ht(o)),i=Math.sin(a),e=Math.cos(a),s=Math.sin(o),n=Math.cos(o),a=Math.atan2(i*n,Vt(s,n*e)),o=Math.atan2(s,n*e),e=q(o+this.long0),Wt(this.cgb,a)):e=1/0,t.x=e,t.y=a,t},names:["Extended_Transverse_Mercator","Extended Transverse Mercator","etmerc"]};function Qt(t,i){return Math.pow((1-t)/(1+t),i)}var Yt={init:function(){var t=function(t,i){if(void 0===t){if((t=Math.floor(30*(q(i)+Math.PI)/Math.PI)+1)<0)return 0;if(60<t)return 60}return t}(this.zone,this.long0);if(void 0===t)throw new Error("unknown utm zone");this.lat0=0,this.long0=(6*Math.abs(t)-183)*r,this.x0=5e5,this.y0=this.utmSouth?1e7:0,this.k0=.9996,Jt.init.apply(this),this.forward=Jt.forward,this.inverse=Jt.inverse},names:["Universal Transverse Mercator System","utm"],dependsOn:"etmerc"};var $t={init:function(){var t=Math.sin(this.lat0),i=Math.cos(this.lat0);i*=i,this.rc=Math.sqrt(1-this.es)/(1-this.es*t*t),this.C=Math.sqrt(1+this.es*i*i/(1-this.es)),this.phic0=Math.asin(t/this.C),this.ratexp=.5*this.C*this.e,this.K=Math.tan(.5*this.phic0+b)/(Math.pow(Math.tan(.5*this.lat0+b),this.C)*Qt(this.e*t,this.ratexp))},forward:function(t){var i=t.x,e=t.y;return t.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*e+b),this.C)*Qt(this.e*Math.sin(e),this.ratexp))-g,t.x=this.C*i,t},inverse:function(t){for(var i=t.x/this.C,e=t.y,s=Math.pow(Math.tan(.5*e+b)/this.K,1/this.C),n=20;0<n&&(e=2*Math.atan(s*Qt(this.e*Math.sin(t.y),-.5*this.e))-g,!(Math.abs(e-t.y)<1e-14));--n)t.y=e;return n?(t.x=i,t.y=e,t):null},names:["gauss"]};var ti={init:function(){$t.init.apply(this),this.rc&&(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative"))},forward:function(t){var i,e,s,n;return t.x=q(t.x-this.long0),$t.forward.apply(this,[t]),i=Math.sin(t.y),e=Math.cos(t.y),s=Math.cos(t.x),n=this.k0*this.R2/(1+this.sinc0*i+this.cosc0*e*s),t.x=n*e*Math.sin(t.x),t.y=n*(this.cosc0*i-this.sinc0*e*s),t.x=this.a*t.x+this.x0,t.y=this.a*t.y+this.y0,t},inverse:function(t){var i,e,s,n;return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,n=(i=Math.sqrt(t.x*t.x+t.y*t.y))?(s=2*Math.atan2(i,this.R2),n=Math.sin(s),e=Math.cos(s),s=Math.asin(e*this.sinc0+t.y*n*this.cosc0/i),Math.atan2(t.x*n,i*this.cosc0*e-t.y*this.sinc0*n)):(s=this.phic0,0),t.x=n,t.y=s,$t.inverse.apply(this,[t]),t.x=q(t.x+this.long0),t},names:["Stereographic_North_Pole","Oblique_Stereographic","Polar_Stereographic","sterea","Oblique Stereographic Alternative","Double_Stereographic"]};var ii={init:function(){this.coslat0=Math.cos(this.lat0),this.sinlat0=Math.sin(this.lat0),this.sphere?1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=x&&(this.k0=.5*(1+D(this.lat0)*Math.sin(this.lat_ts))):(Math.abs(this.coslat0)<=x&&(0<this.lat0?this.con=1:this.con=-1),this.cons=Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)),1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=x&&(this.k0=.5*this.cons*Z(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts))/R(this.e,this.con*this.lat_ts,this.con*Math.sin(this.lat_ts))),this.ms1=Z(this.e,this.sinlat0,this.coslat0),this.X0=2*Math.atan(this.ssfn_(this.lat0,this.sinlat0,this.e))-g,this.cosX0=Math.cos(this.X0),this.sinX0=Math.sin(this.X0))},forward:function(t){var i,e,s=t.x,n=t.y,o=Math.sin(n),a=Math.cos(n),r=q(s-this.long0);return Math.abs(Math.abs(s-this.long0)-Math.PI)<=x&&Math.abs(n+this.lat0)<=x?(t.x=NaN,t.y=NaN,t):this.sphere?(i=2*this.k0/(1+this.sinlat0*o+this.coslat0*a*Math.cos(r)),t.x=this.a*i*a*Math.sin(r)+this.x0,t.y=this.a*i*(this.coslat0*o-this.sinlat0*a*Math.cos(r))+this.y0,t):(e=2*Math.atan(this.ssfn_(n,o,this.e))-g,a=Math.cos(e),e=Math.sin(e),Math.abs(this.coslat0)<=x?(o=R(this.e,n*this.con,this.con*o),o=2*this.a*this.k0*o/this.cons,t.x=this.x0+o*Math.sin(s-this.long0),t.y=this.y0-this.con*o*Math.cos(s-this.long0)):(Math.abs(this.sinlat0)<x?(i=2*this.a*this.k0/(1+a*Math.cos(r)),t.y=i*e):(i=2*this.a*this.k0*this.ms1/(this.cosX0*(1+this.sinX0*e+this.cosX0*a*Math.cos(r))),t.y=i*(this.cosX0*e-this.sinX0*a*Math.cos(r))+this.y0),t.x=i*a*Math.sin(r)+this.x0),t)},inverse:function(t){var i,e;t.x-=this.x0,t.y-=this.y0;var s=Math.sqrt(t.x*t.x+t.y*t.y);if(this.sphere){var n=2*Math.atan(s/(2*this.a*this.k0)),o=this.long0,a=this.lat0;return s<=x?(t.x=o,t.y=a,t):(a=Math.asin(Math.cos(n)*this.sinlat0+t.y*Math.sin(n)*this.coslat0/s),o=Math.abs(this.coslat0)<x?0<this.lat0?q(this.long0+Math.atan2(t.x,-1*t.y)):q(this.long0+Math.atan2(t.x,t.y)):q(this.long0+Math.atan2(t.x*Math.sin(n),s*this.coslat0*Math.cos(n)-t.y*this.sinlat0*Math.sin(n))),t.x=o,t.y=a,t)}if(Math.abs(this.coslat0)<=x){if(s<=x)return a=this.lat0,o=this.long0,t.x=o,t.y=a,t;t.x*=this.con,t.y*=this.con,i=s*this.cons/(2*this.a*this.k0),a=this.con*j(this.e,i),o=this.con*q(this.con*this.long0+Math.atan2(t.x,-1*t.y))}else i=2*Math.atan(s*this.cosX0/(2*this.a*this.k0*this.ms1)),o=this.long0,s<=x?e=this.X0:(e=Math.asin(Math.cos(i)*this.sinX0+t.y*Math.sin(i)*this.cosX0/s),o=q(this.long0+Math.atan2(t.x*Math.sin(i),s*this.cosX0*Math.cos(i)-t.y*this.sinX0*Math.sin(i)))),a=-1*j(this.e,Math.tan(.5*(g+e)));return t.x=o,t.y=a,t},names:["stere","Stereographic_South_Pole","Polar Stereographic (variant B)"],ssfn_:function(t,i,e){return i*=e,Math.tan(.5*(g+t))*Math.pow((1-i)/(1+i),.5*e)}};var ei={init:function(){var t=this.lat0;this.lambda0=this.long0;var i=Math.sin(t),e=this.a,s=2*(n=1/this.rf)-Math.pow(n,2),n=this.e=Math.sqrt(s);this.R=this.k0*e*Math.sqrt(1-s)/(1-s*Math.pow(i,2)),this.alpha=Math.sqrt(1+s/(1-s)*Math.pow(Math.cos(t),4)),this.b0=Math.asin(i/this.alpha),s=Math.log(Math.tan(Math.PI/4+this.b0/2)),t=Math.log(Math.tan(Math.PI/4+t/2)),i=Math.log((1+n*i)/(1-n*i)),this.K=s-this.alpha*t+this.alpha*n/2*i},forward:function(t){var i=Math.log(Math.tan(Math.PI/4-t.y/2)),e=this.e/2*Math.log((1+this.e*Math.sin(t.y))/(1-this.e*Math.sin(t.y))),s=-this.alpha*(i+e)+this.K,i=2*(Math.atan(Math.exp(s))-Math.PI/4),e=this.alpha*(t.x-this.lambda0),s=Math.atan(Math.sin(e)/(Math.sin(this.b0)*Math.tan(i)+Math.cos(this.b0)*Math.cos(e))),e=Math.asin(Math.cos(this.b0)*Math.sin(i)-Math.sin(this.b0)*Math.cos(i)*Math.cos(e));return t.y=this.R/2*Math.log((1+Math.sin(e))/(1-Math.sin(e)))+this.y0,t.x=this.R*s+this.x0,t},inverse:function(t){for(var i,e=t.x-this.x0,s=t.y-this.y0,e=e/this.R,s=2*(Math.atan(Math.exp(s/this.R))-Math.PI/4),n=Math.asin(Math.cos(this.b0)*Math.sin(s)+Math.sin(this.b0)*Math.cos(s)*Math.cos(e)),s=Math.atan(Math.sin(e)/(Math.cos(this.b0)*Math.cos(e)-Math.sin(this.b0)*Math.tan(s))),s=this.lambda0+s/this.alpha,o=n,a=-1e3,r=0;1e-7<Math.abs(o-a);){if(20<++r)return;i=1/this.alpha*(Math.log(Math.tan(Math.PI/4+n/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(o))/2)),a=o,o=2*Math.atan(Math.exp(i))-Math.PI/2}return t.x=s,t.y=o,t},names:["somerc"]};var si={init:function(){this.no_off=this.no_off||!1,this.no_rot=this.no_rot||!1,isNaN(this.k0)&&(this.k0=1);var t=Math.sin(this.lat0),i=Math.cos(this.lat0),e=this.e*t;this.bl=Math.sqrt(1+this.es/(1-this.es)*Math.pow(i,4)),this.al=this.a*this.bl*this.k0*Math.sqrt(1-this.es)/(1-e*e);var s,n,o=R(this.e,this.lat0,t),a=this.bl/i*Math.sqrt((1-this.es)/(1-e*e));a*a<1&&(a=1),isNaN(this.longc)?(n=R(this.e,this.lat1,Math.sin(this.lat1)),t=R(this.e,this.lat2,Math.sin(this.lat2)),0<=this.lat0?this.el=(a+Math.sqrt(a*a-1))*Math.pow(o,this.bl):this.el=(a-Math.sqrt(a*a-1))*Math.pow(o,this.bl),i=Math.pow(n,this.bl),e=Math.pow(t,this.bl),n=.5*((s=this.el/i)-1/s),t=(this.el*this.el-e*i)/(this.el*this.el+e*i),e=(e-i)/(e+i),i=q(this.long1-this.long2),this.long0=.5*(this.long1+this.long2)-Math.atan(t*Math.tan(.5*this.bl*i)/e)/this.bl,this.long0=q(this.long0),e=q(this.long1-this.long0),this.gamma0=Math.atan(Math.sin(this.bl*e)/n),this.alpha=Math.asin(a*Math.sin(this.gamma0))):(s=0<=this.lat0?a+Math.sqrt(a*a-1):a-Math.sqrt(a*a-1),this.el=s*Math.pow(o,this.bl),n=.5*(s-1/s),this.gamma0=Math.asin(Math.sin(this.alpha)/a),this.long0=this.longc-Math.asin(n*Math.tan(this.gamma0))/this.bl),this.no_off?this.uc=0:0<=this.lat0?this.uc=this.al/this.bl*Math.atan2(Math.sqrt(a*a-1),Math.cos(this.alpha)):this.uc=-1*this.al/this.bl*Math.atan2(Math.sqrt(a*a-1),Math.cos(this.alpha))},forward:function(t){var i,e,s=t.x,n=t.y,o=q(s-this.long0);return o=Math.abs(Math.abs(n)-g)<=x?(i=0<n?-1:1,e=this.al/this.bl*Math.log(Math.tan(b+i*this.gamma0*.5)),-1*i*g*this.al/this.bl):(s=R(this.e,n,Math.sin(n)),n=.5*((i=this.el/Math.pow(s,this.bl))-1/i),s=.5*(i+1/i),i=Math.sin(this.bl*o),s=(n*Math.sin(this.gamma0)-i*Math.cos(this.gamma0))/s,e=Math.abs(Math.abs(s)-1)<=x?Number.POSITIVE_INFINITY:.5*this.al*Math.log((1-s)/(1+s))/this.bl,Math.abs(Math.cos(this.bl*o))<=x?this.al*this.bl*o:this.al*Math.atan2(n*Math.cos(this.gamma0)+i*Math.sin(this.gamma0),Math.cos(this.bl*o))/this.bl),this.no_rot?(t.x=this.x0+o,t.y=this.y0+e):(o-=this.uc,t.x=this.x0+e*Math.cos(this.alpha)+o*Math.sin(this.alpha),t.y=this.y0+o*Math.cos(this.alpha)-e*Math.sin(this.alpha)),t},inverse:function(t){var i;this.no_rot?(n=t.y-this.y0,i=t.x-this.x0):(n=(t.x-this.x0)*Math.cos(this.alpha)-(t.y-this.y0)*Math.sin(this.alpha),i=(t.y-this.y0)*Math.cos(this.alpha)+(t.x-this.x0)*Math.sin(this.alpha),i+=this.uc);var e=.5*((o=Math.exp(-1*this.bl*n/this.al))-1/o),s=.5*(o+1/o),n=Math.sin(this.bl*i/this.al),o=(n*Math.cos(this.gamma0)+e*Math.sin(this.gamma0))/s,s=Math.pow(this.el/Math.sqrt((1+o)/(1-o)),1/this.bl);return Math.abs(o-1)<x?(t.x=this.long0,t.y=g):Math.abs(1+o)<x?(t.x=this.long0,t.y=-1*g):(t.y=j(this.e,s),t.x=q(this.long0-Math.atan2(e*Math.cos(this.gamma0)-n*Math.sin(this.gamma0),Math.cos(this.bl*i/this.al))/this.bl)),t},names:["Hotine_Oblique_Mercator","Hotine Oblique Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin","Hotine_Oblique_Mercator_Azimuth_Center","omerc"]};var ni={init:function(){var t,i,e,s,n,o;this.lat2||(this.lat2=this.lat1),this.k0||(this.k0=1),this.x0=this.x0||0,this.y0=this.y0||0,Math.abs(this.lat1+this.lat2)<x||(n=this.b/this.a,this.e=Math.sqrt(1-n*n),t=Math.sin(this.lat1),s=Math.cos(this.lat1),i=Z(this.e,t,s),e=R(this.e,this.lat1,t),o=Math.sin(this.lat2),n=Math.cos(this.lat2),s=Z(this.e,o,n),n=R(this.e,this.lat2,o),o=R(this.e,this.lat0,Math.sin(this.lat0)),Math.abs(this.lat1-this.lat2)>x?this.ns=Math.log(i/s)/Math.log(e/n):this.ns=t,isNaN(this.ns)&&(this.ns=t),this.f0=i/(this.ns*Math.pow(e,this.ns)),this.rh=this.a*this.f0*Math.pow(o,this.ns),this.title||(this.title="Lambert Conformal Conic"))},forward:function(t){var i=t.x,e=t.y;Math.abs(2*Math.abs(e)-Math.PI)<=x&&(e=D(e)*(g-2*x));var s,n=Math.abs(Math.abs(e)-g);if(x<n)s=R(this.e,e,Math.sin(e)),s=this.a*this.f0*Math.pow(s,this.ns);else{if(e*this.ns<=0)return null;s=0}return i=this.ns*q(i-this.long0),t.x=this.k0*(s*Math.sin(i))+this.x0,t.y=this.k0*(this.rh-s*Math.cos(i))+this.y0,t},inverse:function(t){var i,e,s=(t.x-this.x0)/this.k0,n=this.rh-(t.y-this.y0)/this.k0,o=0<this.ns?(i=Math.sqrt(s*s+n*n),1):(i=-Math.sqrt(s*s+n*n),-1),a=0;if(0!==i&&(a=Math.atan2(o*s,o*n)),0!==i||0<this.ns){if(o=1/this.ns,e=Math.pow(i/(this.a*this.f0),o),-9999===(e=j(this.e,e)))return null}else e=-g;return a=q(a/this.ns+this.long0),t.x=a,t.y=e,t},names:["Lambert Tangential Conformal Conic Projection","Lambert_Conformal_Conic","Lambert_Conformal_Conic_2SP","lcc"]};function oi(t,i,e,s,n){return t*n-i*Math.sin(2*n)+e*Math.sin(4*n)-s*Math.sin(6*n)}function ai(t){return 1-.25*t*(1+t/16*(3+1.25*t))}function ri(t){return.375*t*(1+.25*t*(1+.46875*t))}function hi(t){return.05859375*t*t*(1+.75*t)}function li(t){return t*t*t*(35/3072)}function ui(t,i,e){return e*=i,t/Math.sqrt(1-e*e)}function ci(t){return Math.abs(t)<g?t:t-D(t)*Math.PI}function di(t,i,e,s,n){for(var o,a=t/i,r=0;r<15;r++)if(a+=o=(t-(i*a-e*Math.sin(2*a)+s*Math.sin(4*a)-n*Math.sin(6*a)))/(i-2*e*Math.cos(2*a)+4*s*Math.cos(4*a)-6*n*Math.cos(6*a)),Math.abs(o)<=1e-10)return a;return NaN}var _i={init:function(){this.a=6377397.155,this.es=.006674372230614,this.e=Math.sqrt(this.es),this.lat0||(this.lat0=.863937979737193),this.long0||(this.long0=.4334234309119251),this.k0||(this.k0=.9999),this.s45=.785398163397448,this.s90=2*this.s45,this.fi0=this.lat0,this.e2=this.es,this.e=Math.sqrt(this.e2),this.alfa=Math.sqrt(1+this.e2*Math.pow(Math.cos(this.fi0),4)/(1-this.e2)),this.uq=1.04216856380474,this.u0=Math.asin(Math.sin(this.fi0)/this.alfa),this.g=Math.pow((1+this.e*Math.sin(this.fi0))/(1-this.e*Math.sin(this.fi0)),this.alfa*this.e/2),this.k=Math.tan(this.u0/2+this.s45)/Math.pow(Math.tan(this.fi0/2+this.s45),this.alfa)*this.g,this.k1=this.k0,this.n0=this.a*Math.sqrt(1-this.e2)/(1-this.e2*Math.pow(Math.sin(this.fi0),2)),this.s0=1.37008346281555,this.n=Math.sin(this.s0),this.ro0=this.k1*this.n0/Math.tan(this.s0),this.ad=this.s90-this.uq},forward:function(t){var i=t.x,e=t.y,s=q(i-this.long0),i=Math.pow((1+this.e*Math.sin(e))/(1-this.e*Math.sin(e)),this.alfa*this.e/2),e=2*(Math.atan(this.k*Math.pow(Math.tan(e/2+this.s45),this.alfa)/i)-this.s45),i=-s*this.alfa,s=Math.asin(Math.cos(this.ad)*Math.sin(e)+Math.sin(this.ad)*Math.cos(e)*Math.cos(i)),i=Math.asin(Math.cos(e)*Math.sin(i)/Math.cos(s)),i=this.n*i,s=this.ro0*Math.pow(Math.tan(this.s0/2+this.s45),this.n)/Math.pow(Math.tan(s/2+this.s45),this.n);return t.y=s*Math.cos(i),t.x=s*Math.sin(i),this.czech||(t.y*=-1,t.x*=-1),t},inverse:function(t){var i,e,s=t.x;t.x=t.y,t.y=s,this.czech||(t.y*=-1,t.x*=-1),e=Math.sqrt(t.x*t.x+t.y*t.y),s=Math.atan2(t.y,t.x)/Math.sin(this.s0),e=2*(Math.atan(Math.pow(this.ro0/e,1/this.n)*Math.tan(this.s0/2+this.s45))-this.s45),i=Math.asin(Math.cos(this.ad)*Math.sin(e)-Math.sin(this.ad)*Math.cos(e)*Math.cos(s)),s=Math.asin(Math.cos(e)*Math.sin(s)/Math.cos(i)),t.x=this.long0-s/this.alfa;for(var n=i,o=0,a=0;t.y=2*(Math.atan(Math.pow(this.k,-1/this.alfa)*Math.pow(Math.tan(i/2+this.s45),1/this.alfa)*Math.pow((1+this.e*Math.sin(n))/(1-this.e*Math.sin(n)),this.e/2))-this.s45),Math.abs(n-t.y)<1e-10&&(o=1),n=t.y,a+=1,0===o&&a<15;);return 15<=a?null:t},names:["Krovak","krovak"]};function pi(t,i){var e;return 1e-7<t?(1-t*t)*(i/(1-(e=t*i)*e)-.5/t*Math.log((1-e)/(1+e))):2*i}var mi={init:function(){this.sphere||(this.e0=ai(this.es),this.e1=ri(this.es),this.e2=hi(this.es),this.e3=li(this.es),this.ml0=this.a*oi(this.e0,this.e1,this.e2,this.e3,this.lat0))},forward:function(t){var i,e,s,n,o,a,r=t.x,h=t.y,r=q(r-this.long0);return a=this.sphere?(o=this.a*Math.asin(Math.cos(h)*Math.sin(r)),this.a*(Math.atan2(Math.tan(h),Math.cos(r))-this.lat0)):(i=Math.sin(h),e=Math.cos(h),s=ui(this.a,this.e,i),n=Math.tan(h)*Math.tan(h),o=s*(r=r*Math.cos(h))*(1-(a=r*r)*n*(1/6-(8-n+8*(r=this.es*e*e/(1-this.es)))*a/120)),this.a*oi(this.e0,this.e1,this.e2,this.e3,h)-this.ml0+s*i/e*a*(.5+(5-n+6*r)*a/24)),t.x=o+this.x0,t.y=a+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var i=t.x/this.a,e=t.y/this.a;if(this.sphere)var s=e+this.lat0,n=Math.asin(Math.sin(s)*Math.cos(i)),o=Math.atan2(Math.tan(i),Math.cos(s));else{var a=this.ml0/this.a+e,r=di(a,this.e0,this.e1,this.e2,this.e3);if(Math.abs(Math.abs(r)-g)<=x)return t.x=this.long0,t.y=g,e<0&&(t.y*=-1),t;var h=ui(this.a,this.e,Math.sin(r)),s=h*h*h/this.a/this.a*(1-this.es),a=Math.pow(Math.tan(r),2),e=i*this.a/h,i=e*e;n=r-h*Math.tan(r)/s*e*e*(.5-(1+3*a)*e*e/24),o=e*(1-i*(a/3+(1+3*a)*a*i/15))/Math.cos(r)}return t.x=q(o+this.long0),t.y=ci(n),t},names:["Cassini","Cassini_Soldner","cass"]};var fi=.3333333333333333,gi=.17222222222222222,yi=.10257936507936508,vi=.06388888888888888,Mi=.0664021164021164,xi=.016415012942191543;function bi(t){return 1<Math.abs(t)&&(t=1<t?1:-1),Math.asin(t)}var wi={init:function(){var t,i,e,s=Math.abs(this.lat0);if(Math.abs(s-g)<x?this.mode=this.lat0<0?this.S_POLE:this.N_POLE:Math.abs(s)<x?this.mode=this.EQUIT:this.mode=this.OBLIQ,0<this.es)switch(this.qp=pi(this.e,1),this.mmf=.5/(1-this.es),this.apa=(i=this.es,(e=[])[0]=i*fi,s=i*i,e[0]+=s*gi,e[1]=s*vi,s*=i,e[0]+=s*yi,e[1]+=s*Mi,e[2]=s*xi,e),this.mode){case this.N_POLE:case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp),this.dd=1/this.rq,this.xmf=1,this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),t=Math.sin(this.lat0),this.sinb1=pi(this.e,t)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*t*t)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd}else this.mode===this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))},forward:function(t){var i,e,s,n,o,a,r,h,l,u,c=t.x,d=t.y,c=q(c-this.long0);if(this.sphere){if(o=Math.sin(d),u=Math.cos(d),s=Math.cos(c),this.mode===this.OBLIQ||this.mode===this.EQUIT){if((e=this.mode===this.EQUIT?1+u*s:1+this.sinph0*o+this.cosph0*u*s)<=x)return null;i=(e=Math.sqrt(2/e))*u*Math.sin(c),e*=this.mode===this.EQUIT?o:this.cosph0*o-this.sinph0*u*s}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(s=-s),Math.abs(d+this.lat0)<x)return null;e=b-.5*d,i=(e=2*(this.mode===this.S_POLE?Math.cos(e):Math.sin(e)))*Math.sin(c),e*=s}}else{switch(l=h=r=0,s=Math.cos(c),n=Math.sin(c),o=Math.sin(d),a=pi(this.e,o),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(r=a/this.qp,h=Math.sqrt(1-r*r)),this.mode){case this.OBLIQ:l=1+this.sinb1*r+this.cosb1*h*s;break;case this.EQUIT:l=1+h*s;break;case this.N_POLE:l=g+d,a=this.qp-a;break;case this.S_POLE:l=d-g,a=this.qp+a}if(Math.abs(l)<x)return null;switch(this.mode){case this.OBLIQ:case this.EQUIT:l=Math.sqrt(2/l),e=this.mode===this.OBLIQ?this.ymf*l*(this.cosb1*r-this.sinb1*h*s):(l=Math.sqrt(2/(1+h*s)))*r*this.ymf,i=this.xmf*l*h*n;break;case this.N_POLE:case this.S_POLE:0<=a?(i=(l=Math.sqrt(a))*n,e=s*(this.mode===this.S_POLE?l:-l)):i=e=0}}return t.x=this.a*i+this.x0,t.y=this.a*e+this.y0,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var i,e,s,n,o,a,r=t.x/this.a,h=t.y/this.a;if(this.sphere){var l,u=0,c=0,d=Math.sqrt(r*r+h*h);if(1<(l=.5*d))return null;switch(l=2*Math.asin(l),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(c=Math.sin(l),u=Math.cos(l)),this.mode){case this.EQUIT:l=Math.abs(d)<=x?0:Math.asin(h*c/d),r*=c,h=u*d;break;case this.OBLIQ:l=Math.abs(d)<=x?this.lat0:Math.asin(u*this.sinph0+h*c*this.cosph0/d),r*=c*this.cosph0,h=(u-Math.sin(l)*this.sinph0)*d;break;case this.N_POLE:h=-h,l=g-l;break;case this.S_POLE:l-=g}i=0!==h||this.mode!==this.EQUIT&&this.mode!==this.OBLIQ?Math.atan2(r,h):0}else{if(a=0,this.mode===this.OBLIQ||this.mode===this.EQUIT){if(r/=this.dd,h*=this.dd,(s=Math.sqrt(r*r+h*h))<x)return t.x=this.long0,t.y=this.lat0,t;e=2*Math.asin(.5*s/this.rq),n=Math.cos(e),r*=e=Math.sin(e),h=this.mode===this.OBLIQ?(a=n*this.sinb1+h*e*this.cosb1/s,o=this.qp*a,s*this.cosb1*n-h*this.sinb1*e):(o=this.qp*(a=h*e/s),s*n)}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(!(o=r*r+(h=this.mode===this.N_POLE?-h:h)*h))return t.x=this.long0,t.y=this.lat0,t;a=1-o/this.qp,this.mode===this.S_POLE&&(a=-a)}i=Math.atan2(r,h),n=Math.asin(a),o=this.apa,a=n+n,l=n+o[0]*Math.sin(a)+o[1]*Math.sin(a+a)+o[2]*Math.sin(a+a+a)}return t.x=q(this.long0+i),t.y=l,t},names:["Lambert Azimuthal Equal Area","Lambert_Azimuthal_Equal_Area","laea"],S_POLE:1,N_POLE:2,EQUIT:3,OBLIQ:4};var Pi={init:function(){Math.abs(this.lat1+this.lat2)<x||(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.t1=this.sin_po,this.con=this.sin_po,this.ms1=Z(this.e3,this.sin_po,this.cos_po),this.qs1=pi(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=this.sin_po,this.ms2=Z(this.e3,this.sin_po,this.cos_po),this.qs2=pi(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=pi(this.e3,this.sin_po,this.cos_po),Math.abs(this.lat1-this.lat2)>x?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0)},forward:function(t){var i=t.x,e=t.y;this.sin_phi=Math.sin(e),this.cos_phi=Math.cos(e);var s=pi(this.e3,this.sin_phi,this.cos_phi),e=this.a*Math.sqrt(this.c-this.ns0*s)/this.ns0,s=this.ns0*q(i-this.long0),i=e*Math.sin(s)+this.x0,s=this.rh-e*Math.cos(s)+this.y0;return t.x=i,t.y=s,t},inverse:function(t){var i,e,s,n;return t.x-=this.x0,t.y=this.rh-t.y+this.y0,e=0<=this.ns0?(i=Math.sqrt(t.x*t.x+t.y*t.y),1):(i=-Math.sqrt(t.x*t.x+t.y*t.y),-1),(s=0)!==i&&(s=Math.atan2(e*t.x,e*t.y)),e=i*this.ns0/this.a,n=this.sphere?Math.asin((this.c-e*e)/(2*this.ns0)):(n=(this.c-e*e)/this.ns0,this.phi1z(this.e3,n)),s=q(s/this.ns0+this.long0),t.x=s,t.y=n,t},names:["Albers_Conic_Equal_Area","Albers","aea"],phi1z:function(t,i){var e,s,n,o=bi(.5*i);if(t<x)return o;for(var a=t*t,r=1;r<=25;r++)if(o+=n=.5*(s=1-(n=t*(e=Math.sin(o)))*n)*s/Math.cos(o)*(i/(1-a)-e/s+.5/t*Math.log((1-n)/(1+n))),Math.abs(n)<=1e-7)return o;return null}};var Li={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0),this.infinity_dist=1e3*this.a,this.rc=1},forward:function(t){var i,e=t.x,s=t.y,n=q(e-this.long0),o=Math.sin(s),a=Math.cos(s),e=Math.cos(n),e=0<(s=this.sin_p14*o+this.cos_p14*a*e)||Math.abs(s)<=x?(i=this.x0+ +this.a*a*Math.sin(n)/s,this.y0+ +this.a*(this.cos_p14*o-this.sin_p14*a*e)/s):(i=this.x0+this.infinity_dist*a*Math.sin(n),this.y0+this.infinity_dist*(this.cos_p14*o-this.sin_p14*a*e));return t.x=i,t.y=e,t},inverse:function(t){var i,e,s,n;return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,t.x/=this.k0,t.y/=this.k0,s=(i=Math.sqrt(t.x*t.x+t.y*t.y))?(n=Math.atan2(i,this.rc),s=Math.sin(n),e=Math.cos(n),n=bi(e*this.sin_p14+t.y*s*this.cos_p14/i),s=Math.atan2(t.x*s,i*this.cos_p14*e-t.y*this.sin_p14*s),q(this.long0+s)):(n=this.phic0,0),t.x=s,t.y=n,t},names:["gnom"]};var Ti={init:function(){this.sphere||(this.k0=Z(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))},forward:function(t){var i,e,s=t.x,n=t.y,s=q(s-this.long0);return e=this.sphere?(i=this.x0+this.a*s*Math.cos(this.lat_ts),this.y0+this.a*Math.sin(n)/Math.cos(this.lat_ts)):(e=pi(this.e,Math.sin(n)),i=this.x0+this.a*this.k0*s,this.y0+this.a*e*.5/this.k0),t.x=i,t.y=e,t},inverse:function(t){var i,e;return t.x-=this.x0,t.y-=this.y0,this.sphere?(i=q(this.long0+t.x/this.a/Math.cos(this.lat_ts)),e=Math.asin(t.y/this.a*Math.cos(this.lat_ts))):(e=function(t,i){var e=1-(1-t*t)/(2*t)*Math.log((1-t)/(1+t));if(Math.abs(Math.abs(i)-e)<1e-6)return i<0?-1*g:g;for(var s,n,o,a=Math.asin(.5*i),r=0;r<30;r++)if(s=Math.sin(a),n=Math.cos(a),o=t*s,a+=o=Math.pow(1-o*o,2)/(2*n)*(i/(1-t*t)-s/(1-o*o)+.5/t*Math.log((1-o)/(1+o))),Math.abs(o)<=1e-10)return a;return NaN}(this.e,2*t.y*this.k0/this.a),i=q(this.long0+t.x/(this.a*this.k0))),t.x=i,t.y=e,t},names:["cea"]};var Ci={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Equidistant Cylindrical (Plate Carre)",this.rc=Math.cos(this.lat_ts)},forward:function(t){var i=t.x,e=t.y,i=q(i-this.long0),e=ci(e-this.lat0);return t.x=this.x0+this.a*i*this.rc,t.y=this.y0+this.a*e,t},inverse:function(t){var i=t.x,e=t.y;return t.x=q(this.long0+(i-this.x0)/(this.a*this.rc)),t.y=ci(this.lat0+(e-this.y0)/this.a),t},names:["Equirectangular","Equidistant_Cylindrical","eqc"]};var Si={init:function(){this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=ai(this.es),this.e1=ri(this.es),this.e2=hi(this.es),this.e3=li(this.es),this.ml0=this.a*oi(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(t){var i,e=t.x,s=t.y,n=q(e-this.long0),e=n*Math.sin(s);return e=this.sphere?Math.abs(s)<=x?(i=this.a*n,-1*this.a*this.lat0):(i=this.a*Math.sin(e)/Math.tan(s),this.a*(ci(s-this.lat0)+(1-Math.cos(e))/Math.tan(s))):Math.abs(s)<=x?(i=this.a*n,-1*this.ml0):(i=(n=ui(this.a,this.e,Math.sin(s))/Math.tan(s))*Math.sin(e),this.a*oi(this.e0,this.e1,this.e2,this.e3,s)-this.ml0+n*(1-Math.cos(e))),t.x=i+this.x0,t.y=e+this.y0,t},inverse:function(t){var i,e,s,n,o,a,r=t.x-this.x0,h=t.y-this.y0;if(this.sphere)if(Math.abs(h+this.a*this.lat0)<=x)i=q(r/this.a+this.long0),e=0;else{for(var l,u=this.lat0+h/this.a,c=r*r/this.a/this.a+u*u,d=u,_=20;_;--_)if(d+=s=-1*(u*(d*(l=Math.tan(d))+1)-d-.5*(d*d+c)*l)/((d-u)/l-1),Math.abs(s)<=x){e=d;break}i=q(this.long0+Math.asin(r*Math.tan(d)/this.a)/Math.sin(e))}else if(Math.abs(h+this.ml0)<=x)e=0,i=q(this.long0+r/this.a);else{for(u=(this.ml0+h)/this.a,c=r*r/this.a/this.a+u*u,d=u,_=20;_;--_)if(a=this.e*Math.sin(d),n=Math.sqrt(1-a*a)*Math.tan(d),o=this.a*oi(this.e0,this.e1,this.e2,this.e3,d),a=this.e0-2*this.e1*Math.cos(2*d)+4*this.e2*Math.cos(4*d)-6*this.e3*Math.cos(6*d),d-=s=(u*(n*(o=o/this.a)+1)-o-.5*n*(o*o+c))/(this.es*Math.sin(2*d)*(o*o+c-2*u*o)/(4*n)+(u-o)*(n*a-2/Math.sin(2*d))-a),Math.abs(s)<=x){e=d;break}n=Math.sqrt(1-this.es*Math.pow(Math.sin(e),2))*Math.tan(e),i=q(this.long0+Math.asin(r*n/this.a)/Math.sin(e))}return t.x=i,t.y=e,t},names:["Polyconic","poly"]};var Ei={init:function(){this.A=[],this.A[1]=.6399175073,this.A[2]=-.1358797613,this.A[3]=.063294409,this.A[4]=-.02526853,this.A[5]=.0117879,this.A[6]=-.0055161,this.A[7]=.0026906,this.A[8]=-.001333,this.A[9]=67e-5,this.A[10]=-34e-5,this.B_re=[],this.B_im=[],this.B_re[1]=.7557853228,this.B_im[1]=0,this.B_re[2]=.249204646,this.B_im[2]=.003371507,this.B_re[3]=-.001541739,this.B_im[3]=.04105856,this.B_re[4]=-.10162907,this.B_im[4]=.01727609,this.B_re[5]=-.26623489,this.B_im[5]=-.36249218,this.B_re[6]=-.6870983,this.B_im[6]=-1.1651967,this.C_re=[],this.C_im=[],this.C_re[1]=1.3231270439,this.C_im[1]=0,this.C_re[2]=-.577245789,this.C_im[2]=-.007809598,this.C_re[3]=.508307513,this.C_im[3]=-.112208952,this.C_re[4]=-.15094762,this.C_im[4]=.18200602,this.C_re[5]=1.01418179,this.C_im[5]=1.64497696,this.C_re[6]=1.9660549,this.C_im[6]=2.5127645,this.D=[],this.D[1]=1.5627014243,this.D[2]=.5185406398,this.D[3]=-.03333098,this.D[4]=-.1052906,this.D[5]=-.0368594,this.D[6]=.007317,this.D[7]=.0122,this.D[8]=.00394,this.D[9]=-.0013},forward:function(t){for(var i=t.x,e=t.y-this.lat0,i=i-this.long0,s=e/w*1e-5,i=i,n=1,o=0,a=1;a<=10;a++)o+=this.A[a]*(n*=s);var r,h=o,l=i,u=1,c=0,d=0,_=0;for(a=1;a<=6;a++)r=c*h+u*l,d=d+this.B_re[a]*(u=u*h-c*l)-this.B_im[a]*(c=r),_=_+this.B_im[a]*u+this.B_re[a]*c;return t.x=_*this.a+this.x0,t.y=d*this.a+this.y0,t},inverse:function(t){var i,e=t.x,s=t.y,e=e-this.x0,n=(s-this.y0)/this.a,o=e/this.a,a=1,r=0,h=0,l=0;for(f=1;f<=6;f++)i=r*n+a*o,h=h+this.C_re[f]*(a=a*n-r*o)-this.C_im[f]*(r=i),l=l+this.C_im[f]*a+this.C_re[f]*r;for(var u=0;u<this.iterations;u++){for(var c,d=h,_=l,p=n,m=o,f=2;f<=6;f++)c=_*h+d*l,d=d*h-_*l,_=c,p+=(f-1)*(this.B_re[f]*d-this.B_im[f]*_),m+=(f-1)*(this.B_im[f]*d+this.B_re[f]*_);var d=1,_=0,g=this.B_re[1],y=this.B_im[1];for(f=2;f<=6;f++)c=_*h+d*l,d=d*h-_*l,_=c,g+=f*(this.B_re[f]*d-this.B_im[f]*_),y+=f*(this.B_im[f]*d+this.B_re[f]*_);var v=g*g+y*y,h=(p*g+m*y)/v,l=(m*g-p*y)/v}var M=h,s=l,x=1,b=0;for(f=1;f<=9;f++)b+=this.D[f]*(x*=M);return e=this.lat0+b*w*1e5,s=this.long0+s,t.x=s,t.y=e,t},names:["New_Zealand_Map_Grid","nzmg"]};var zi={init:function(){},forward:function(t){var i=t.x,e=t.y,i=q(i-this.long0),i=this.x0+this.a*i,e=this.y0+this.a*Math.log(Math.tan(Math.PI/4+e/2.5))*1.25;return t.x=i,t.y=e,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0;var i=q(this.long0+t.x/this.a),e=2.5*(Math.atan(Math.exp(.8*t.y/this.a))-Math.PI/4);return t.x=i,t.y=e,t},names:["Miller_Cylindrical","mill"]};var Ai={init:function(){this.sphere?(this.n=1,this.m=0,this.es=0,this.C_y=Math.sqrt((this.m+1)/this.n),this.C_x=this.C_y/(this.m+1)):this.en=Ct(this.es)},forward:function(t){var i=t.x,e=t.y,i=q(i-this.long0);if(this.sphere){if(this.m)for(var s=this.n*Math.sin(e),n=20;n;--n){var o=(this.m*e+Math.sin(e)-s)/(this.m+Math.cos(e));if(e-=o,Math.abs(o)<x)break}else e=1!==this.n?Math.asin(this.n*Math.sin(e)):e;l=this.a*this.C_x*i*(this.m+Math.cos(e)),h=this.a*this.C_y*e}else var a=Math.sin(e),r=Math.cos(e),h=this.a*qt(e,a,r,this.en),l=this.a*i*r/Math.sqrt(1-this.es*a*a);return t.x=l,t.y=h,t},inverse:function(t){var i,e,s,n;return t.x-=this.x0,s=t.x/this.a,t.y-=this.y0,i=t.y/this.a,this.sphere?(i/=this.C_y,s/=this.C_x*(this.m+Math.cos(i)),this.m?i=bi((this.m*i+Math.sin(i))/this.n):1!==this.n&&(i=bi(Math.sin(i)/this.n)),s=q(s+this.long0),i=ci(i)):(i=St(t.y/this.a,this.es,this.en),(n=Math.abs(i))<g?(n=Math.sin(i),e=this.long0+t.x*Math.sqrt(1-this.es*n*n)/(this.a*Math.cos(i)),s=q(e)):n-x<g&&(s=this.long0)),t.x=s,t.y=i,t},names:["Sinusoidal","sinu"]};var ki={init:function(){},forward:function(t){for(var i=t.x,e=t.y,i=q(i-this.long0),s=e,n=Math.PI*Math.sin(e);;){var o=-(s+Math.sin(s)-n)/(1+Math.cos(s));if(s+=o,Math.abs(o)<x)break}return s/=2,Math.PI/2-Math.abs(e)<x&&(i=0),e=.900316316158*this.a*i*Math.cos(s)+this.x0,i=1.4142135623731*this.a*Math.sin(s)+this.y0,t.x=e,t.y=i,t},inverse:function(t){t.x-=this.x0,t.y-=this.y0,s=t.y/(1.4142135623731*this.a),.999999999999<Math.abs(s)&&(s=.999999999999);var i=Math.asin(s),e=q(this.long0+t.x/(.900316316158*this.a*Math.cos(i)));(e=e<-Math.PI?-Math.PI:e)>Math.PI&&(e=Math.PI),s=(2*i+Math.sin(2*i))/Math.PI,1<Math.abs(s)&&(s=1);var s=Math.asin(s);return t.x=e,t.y=s,t},names:["Mollweide","moll"]};var Ii={init:function(){Math.abs(this.lat1+this.lat2)<x||(this.lat2=this.lat2||this.lat1,this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=ai(this.es),this.e1=ri(this.es),this.e2=hi(this.es),this.e3=li(this.es),this.sinphi=Math.sin(this.lat1),this.cosphi=Math.cos(this.lat1),this.ms1=Z(this.e,this.sinphi,this.cosphi),this.ml1=oi(this.e0,this.e1,this.e2,this.e3,this.lat1),Math.abs(this.lat1-this.lat2)<x?this.ns=this.sinphi:(this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=Z(this.e,this.sinphi,this.cosphi),this.ml2=oi(this.e0,this.e1,this.e2,this.e3,this.lat2),this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)),this.g=this.ml1+this.ms1/this.ns,this.ml0=oi(this.e0,this.e1,this.e2,this.e3,this.lat0),this.rh=this.a*(this.g-this.ml0))},forward:function(t){var i=t.x,e=t.y;e=this.sphere?this.a*(this.g-e):(s=oi(this.e0,this.e1,this.e2,this.e3,e),this.a*(this.g-s));var s=this.ns*q(i-this.long0),i=this.x0+e*Math.sin(s),s=this.y0+this.rh-e*Math.cos(s);return t.x=i,t.y=s,t},inverse:function(t){t.x-=this.x0,t.y=this.rh-t.y+this.y0;var i=0<=this.ns?(s=Math.sqrt(t.x*t.x+t.y*t.y),1):(s=-Math.sqrt(t.x*t.x+t.y*t.y),-1),e=0;if(0!==s&&(e=Math.atan2(i*t.x,i*t.y)),this.sphere)return o=q(this.long0+e/this.ns),n=ci(this.g-s/this.a),t.x=o,t.y=n,t;var s=this.g-s/this.a,n=di(s,this.e0,this.e1,this.e2,this.e3),o=q(this.long0+e/this.ns);return t.x=o,t.y=n,t},names:["Equidistant_Conic","eqdc"]};var Oi={init:function(){this.R=this.a},forward:function(t){var i=t.x,e=t.y,s=q(i-this.long0);Math.abs(e)<=x&&(l=this.x0+this.R*s,u=this.y0);var n=bi(2*Math.abs(e/Math.PI));(Math.abs(s)<=x||Math.abs(Math.abs(e)-g)<=x)&&(l=this.x0,u=0<=e?this.y0+Math.PI*this.R*Math.tan(.5*n):this.y0+Math.PI*this.R*-Math.tan(.5*n));var o=.5*Math.abs(Math.PI/s-s/Math.PI),a=o*o,r=Math.sin(n),h=Math.cos(n),h=(n=(i=h/(r+h-1))*(2/r-1))*n,r=Math.PI*this.R*(o*(i-h)+Math.sqrt(a*(i-h)*(i-h)-(h+a)*(i*i-h)))/(h+a),l=this.x0+(r=s<0?-r:r),i=a+i,r=Math.PI*this.R*(n*i-o*Math.sqrt((h+a)*(1+a)-i*i))/(h+a),u=0<=e?this.y0+r:this.y0-r;return t.x=l,t.y=u,t},inverse:function(t){var i,e,s,n,o,a,r;return t.x-=this.x0,t.y-=this.y0,r=Math.PI*this.R,s=(i=t.x/r)*i+(e=t.y/r)*e,r=3*(e*e/(o=-2*(a=-Math.abs(e)*(1+s))+1+2*e*e+s*s)+(2*(n=a-2*e*e+i*i)*n*n/o/o/o-9*a*n/o/o)/27)/(a=(a-n*n/3/o)/o)/(a=2*Math.sqrt(-a/3)),1<Math.abs(r)&&(r=0<=r?1:-1),r=Math.acos(r)/3,o=0<=t.y?(-a*Math.cos(r+Math.PI/3)-n/3/o)*Math.PI:-(-a*Math.cos(r+Math.PI/3)-n/3/o)*Math.PI,i=Math.abs(i)<x?this.long0:q(this.long0+Math.PI*(s-1+Math.sqrt(1+2*(i*i-e*e)+s*s))/2/i),t.x=i,t.y=o,t},names:["Van_der_Grinten_I","VanDerGrinten","vandg"]};var Ni={init:function(){this.sin_p12=Math.sin(this.lat0),this.cos_p12=Math.cos(this.lat0)},forward:function(t){var i,e,s,n,o,a,r=t.x,h=t.y,l=Math.sin(t.y),u=Math.cos(t.y),c=q(r-this.long0);return this.sphere?Math.abs(this.sin_p12-1)<=x?(t.x=this.x0+this.a*(g-h)*Math.sin(c),t.y=this.y0-this.a*(g-h)*Math.cos(c)):Math.abs(this.sin_p12+1)<=x?(t.x=this.x0+this.a*(g+h)*Math.sin(c),t.y=this.y0+this.a*(g+h)*Math.cos(c)):(o=this.sin_p12*l+this.cos_p12*u*Math.cos(c),n=(s=Math.acos(o))?s/Math.sin(s):1,t.x=this.x0+this.a*n*u*Math.sin(c),t.y=this.y0+this.a*n*(this.cos_p12*l-this.sin_p12*u*Math.cos(c))):(i=ai(this.es),r=ri(this.es),o=hi(this.es),n=li(this.es),Math.abs(this.sin_p12-1)<=x?(e=this.a*oi(i,r,o,n,g),a=this.a*oi(i,r,o,n,h),t.x=this.x0+(e-a)*Math.sin(c),t.y=this.y0-(e-a)*Math.cos(c)):Math.abs(this.sin_p12+1)<=x?(e=this.a*oi(i,r,o,n,g),a=this.a*oi(i,r,o,n,h),t.x=this.x0+(e+a)*Math.sin(c),t.y=this.y0+(e+a)*Math.cos(c)):(h=l/u,e=ui(this.a,this.e,this.sin_p12),a=ui(this.a,this.e,l),l=Math.atan((1-this.es)*h+this.es*e*this.sin_p12/(a*u)),a=0===(h=Math.atan2(Math.sin(c),this.cos_p12*Math.tan(l)-this.sin_p12*Math.cos(c)))?Math.asin(this.cos_p12*Math.sin(l)-this.sin_p12*Math.cos(l)):Math.abs(Math.abs(h)-Math.PI)<=x?-Math.asin(this.cos_p12*Math.sin(l)-this.sin_p12*Math.cos(l)):Math.asin(Math.sin(c)*Math.cos(l)/Math.sin(h)),u=this.e*this.sin_p12/Math.sqrt(1-this.es),c=this.e*this.cos_p12*Math.cos(h)/Math.sqrt(1-this.es),t.x=this.x0+(s=e*a*(1-(l=a*a)*(e=c*c)*(1-e)/6+(l=l*a)/8*(c=u*c)*(1-2*e)+(l=l*a)/120*(e*(4-7*e)-3*u*u*(1-7*e))-l*a/48*c))*Math.sin(h),t.y=this.y0+s*Math.cos(h))),t},inverse:function(t){var i,e,s,n,o,a,r,h;return t.x-=this.x0,t.y-=this.y0,this.sphere?(i=Math.sqrt(t.x*t.x+t.y*t.y))>2*g*this.a?void 0:(r=i/this.a,h=Math.sin(r),a=Math.cos(r),e=this.long0,Math.abs(i)<=x?s=this.lat0:(s=bi(a*this.sin_p12+t.y*h*this.cos_p12/i),o=Math.abs(this.lat0)-g,e=Math.abs(o)<=x?0<=this.lat0?q(this.long0+Math.atan2(t.x,-t.y)):q(this.long0-Math.atan2(-t.x,t.y)):q(this.long0+Math.atan2(t.x*h,i*this.cos_p12*a-t.y*this.sin_p12*h))),t.x=e,t.y=s,t):(r=ai(this.es),o=ri(this.es),a=hi(this.es),h=li(this.es),Math.abs(this.sin_p12-1)<=x?(n=this.a*oi(r,o,a,h,g),i=Math.sqrt(t.x*t.x+t.y*t.y),s=di((n-i)/this.a,r,o,a,h),e=q(this.long0+Math.atan2(t.x,-1*t.y))):Math.abs(this.sin_p12+1)<=x?(n=this.a*oi(r,o,a,h,g),i=Math.sqrt(t.x*t.x+t.y*t.y),s=di((i-n)/this.a,r,o,a,h),e=q(this.long0+Math.atan2(t.x,t.y))):(i=Math.sqrt(t.x*t.x+t.y*t.y),n=Math.atan2(t.x,t.y),r=ui(this.a,this.e,this.sin_p12),o=Math.cos(n),h=-(a=this.e*this.cos_p12*o)*a/(1-this.es),a=3*this.es*(1-h)*this.sin_p12*this.cos_p12*o/(1-this.es),r=1-h*(h=(r=i/r)-h*(1+h)*Math.pow(r,3)/6-a*(1+3*h)*Math.pow(r,4)/24)*h/2-r*h*h*h/6,o=Math.asin(this.sin_p12*Math.cos(h)+this.cos_p12*Math.sin(h)*o),e=q(this.long0+Math.asin(Math.sin(n)*Math.sin(h)/Math.cos(o))),h=Math.sin(o),s=Math.atan2((h-this.es*r*this.sin_p12)*Math.tan(o),h*(1-this.es))),t.x=e,t.y=s,t)},names:["Azimuthal_Equidistant","aeqd"]};var Bi={init:function(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0)},forward:function(t){var i,e,s=t.x,n=t.y,o=q(s-this.long0),a=Math.sin(n),r=Math.cos(n),s=Math.cos(o);return(0<(n=this.sin_p14*a+this.cos_p14*r*s)||Math.abs(n)<=x)&&(i=+this.a*r*Math.sin(o),e=this.y0+ +this.a*(this.cos_p14*a-this.sin_p14*r*s)),t.x=i,t.y=e,t},inverse:function(t){var i,e,s,n,o,a;return t.x-=this.x0,t.y-=this.y0,i=Math.sqrt(t.x*t.x+t.y*t.y),n=bi(i/this.a),e=Math.sin(n),s=Math.cos(n),o=this.long0,Math.abs(i)<=x?(a=this.lat0,t.x=o,t.y=a,t):(a=bi(s*this.sin_p14+t.y*e*this.cos_p14/i),n=Math.abs(this.lat0)-g,o=Math.abs(n)<=x?0<=this.lat0?q(this.long0+Math.atan2(t.x,-t.y)):q(this.long0-Math.atan2(-t.x,t.y)):q(this.long0+Math.atan2(t.x*e,i*this.cos_p14*s-t.y*this.sin_p14*e)),t.x=o,t.y=a,t)},names:["ortho"]},Zi=1,Ri=2,ji=3,Di=4,qi=5,Gi=6,Wi={AREA_0:1,AREA_1:2,AREA_2:3,AREA_3:4};function Ui(t,i,e,s){var n;return t<x?(s.value=Wi.AREA_0,n=0):(n=Math.atan2(i,e),Math.abs(n)<=b?s.value=Wi.AREA_0:b<n&&n<=g+b?(s.value=Wi.AREA_1,n-=g):g+b<n||n<=-(g+b)?(s.value=Wi.AREA_2,n=0<=n?n-u:n+u):(s.value=Wi.AREA_3,n+=g)),n}function Fi(t,i){i=t+i;return i<-u?i+=e:+u<i&&(i-=e),i}function Hi(t,i){return t[0]+i*(t[1]+i*(t[2]+i*t[3]))}var Vi={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Quadrilateralized Spherical Cube",this.lat0>=g-b/2?this.face=qi:this.lat0<=-(g-b/2)?this.face=Gi:Math.abs(this.long0)<=b?this.face=Zi:Math.abs(this.long0)<=g+b?this.face=0<this.long0?Ri:Di:this.face=ji,0!==this.es&&(this.one_minus_f=1-(this.a-this.b)/this.a,this.one_minus_f_squared=this.one_minus_f*this.one_minus_f)},forward:function(t){var i,e,s,n,o,a,r,h={x:0,y:0},l={value:0};return t.x-=this.long0,r=0!==this.es?Math.atan(this.one_minus_f_squared*Math.tan(t.y)):t.y,i=t.x,this.face===qi?(e=g-r,s=b<=i&&i<=g+b?(l.value=Wi.AREA_0,i-g):g+b<i||i<=-(g+b)?(l.value=Wi.AREA_1,0<i?i-u:i+u):-(g+b)<i&&i<=-b?(l.value=Wi.AREA_2,i+g):(l.value=Wi.AREA_3,i)):this.face===Gi?(e=g+r,s=b<=i&&i<=g+b?(l.value=Wi.AREA_0,-i+g):i<b&&-b<=i?(l.value=Wi.AREA_1,-i):i<-b&&-(g+b)<=i?(l.value=Wi.AREA_2,-i-g):(l.value=Wi.AREA_3,0<i?-i+u:-i-u)):(this.face===Ri?i=Fi(i,+g):this.face===ji?i=Fi(i,+u):this.face===Di&&(i=Fi(i,-g)),o=Math.sin(r),a=Math.cos(r),r=Math.sin(i),n=a*Math.cos(i),r=a*r,o=o,this.face===Zi?s=Ui(e=Math.acos(n),o,r,l):this.face===Ri?s=Ui(e=Math.acos(r),o,-n,l):this.face===ji?s=Ui(e=Math.acos(-n),o,-r,l):this.face===Di?s=Ui(e=Math.acos(-r),o,n,l):(e=s=0,l.value=Wi.AREA_0)),n=Math.atan(12/u*(s+Math.acos(Math.sin(s)*Math.cos(b))-g)),s=Math.sqrt((1-Math.cos(e))/(Math.cos(n)*Math.cos(n))/(1-Math.cos(Math.atan(1/Math.cos(s))))),l.value===Wi.AREA_1?n+=g:l.value===Wi.AREA_2?n+=u:l.value===Wi.AREA_3&&(n+=1.5*u),h.x=s*Math.cos(n),h.y=s*Math.sin(n),h.x=h.x*this.a+this.x0,h.y=h.y*this.a+this.y0,t.x=h.x,t.y=h.y,t},inverse:function(t){var i,e,s,n,o,a,r,h={lam:0,phi:0},l={value:0};return t.x=(t.x-this.x0)/this.a,t.y=(t.y-this.y0)/this.a,e=Math.atan(Math.sqrt(t.x*t.x+t.y*t.y)),i=Math.atan2(t.y,t.x),0<=t.x&&t.x>=Math.abs(t.y)?l.value=Wi.AREA_0:0<=t.y&&t.y>=Math.abs(t.x)?(l.value=Wi.AREA_1,i-=g):t.x<0&&-t.x>=Math.abs(t.y)?(l.value=Wi.AREA_2,i=i<0?i+u:i-u):(l.value=Wi.AREA_3,i+=g),n=u/12*Math.tan(i),o=Math.sin(n)/(Math.cos(n)-1/Math.sqrt(2)),o=Math.atan(o),(e=1-(i=Math.cos(i))*i*(e=Math.tan(e))*e*(1-Math.cos(Math.atan(1/Math.cos(o)))))<-1?e=-1:1<e&&(e=1),this.face===qi?(s=Math.acos(e),h.phi=g-s,l.value===Wi.AREA_0?h.lam=o+g:l.value===Wi.AREA_1?h.lam=o<0?o+u:o-u:l.value===Wi.AREA_2?h.lam=o-g:h.lam=o):this.face===Gi?(s=Math.acos(e),h.phi=s-g,l.value===Wi.AREA_0?h.lam=-o+g:l.value===Wi.AREA_1?h.lam=-o:l.value===Wi.AREA_2?h.lam=-o-g:h.lam=o<0?-o-u:-o+u):(o=1<=(n=(r=e)*r)?0:Math.sqrt(1-n)*Math.sin(o),a=1<=(n+=o*o)?0:Math.sqrt(1-n),l.value===Wi.AREA_1?(n=a,a=-o,o=n):l.value===Wi.AREA_2?(a=-a,o=-o):l.value===Wi.AREA_3&&(n=a,a=o,o=-n),this.face===Ri?(n=r,r=-a,a=n):this.face===ji?(r=-r,a=-a):this.face===Di&&(n=r,r=a,a=-n),h.phi=Math.acos(-o)-g,h.lam=Math.atan2(a,r),this.face===Ri?h.lam=Fi(h.lam,-g):this.face===ji?h.lam=Fi(h.lam,-u):this.face===Di&&(h.lam=Fi(h.lam,+g))),0!==this.es&&(a=h.phi<0?1:0,r=Math.tan(h.phi),r=this.b/Math.sqrt(r*r+this.one_minus_f_squared),h.phi=Math.atan(Math.sqrt(this.a*this.a-r*r)/(this.one_minus_f*r)),a&&(h.phi=-h.phi)),h.lam+=this.long0,t.x=h.lam,t.y=h.phi,t},names:["Quadrilateralized Spherical Cube","Quadrilateralized_Spherical_Cube","qsc"]},Ki=[[1,22199e-21,-715515e-10,31103e-10],[.9986,-482243e-9,-24897e-9,-13309e-10],[.9954,-83103e-8,-448605e-10,-9.86701e-7],[.99,-.00135364,-59661e-9,36777e-10],[.9822,-.00167442,-449547e-11,-572411e-11],[.973,-.00214868,-903571e-10,1.8736e-8],[.96,-.00305085,-900761e-10,164917e-11],[.9427,-.00382792,-653386e-10,-26154e-10],[.9216,-.00467746,-10457e-8,481243e-11],[.8962,-.00536223,-323831e-10,-543432e-11],[.8679,-.00609363,-113898e-9,332484e-11],[.835,-.00698325,-640253e-10,9.34959e-7],[.7986,-.00755338,-500009e-10,9.35324e-7],[.7597,-.00798324,-35971e-9,-227626e-11],[.7186,-.00851367,-701149e-10,-86303e-10],[.6732,-.00986209,-199569e-9,191974e-10],[.6213,-.010418,883923e-10,624051e-11],[.5722,-.00906601,182e-6,624051e-11],[.5322,-.00677797,275608e-9,624051e-11]],Xi=[[-520417e-23,.0124,121431e-23,-845284e-16],[.062,.0124,-1.26793e-9,4.22642e-10],[.124,.0124,5.07171e-9,-1.60604e-9],[.186,.0123999,-1.90189e-8,6.00152e-9],[.248,.0124002,7.10039e-8,-2.24e-8],[.31,.0123992,-2.64997e-7,8.35986e-8],[.372,.0124029,9.88983e-7,-3.11994e-7],[.434,.0123893,-369093e-11,-4.35621e-7],[.4958,.0123198,-102252e-10,-3.45523e-7],[.5571,.0121916,-154081e-10,-5.82288e-7],[.6176,.0119938,-241424e-10,-5.25327e-7],[.6769,.011713,-320223e-10,-5.16405e-7],[.7346,.0113541,-397684e-10,-6.09052e-7],[.7903,.0109107,-489042e-10,-104739e-11],[.8435,.0103431,-64615e-9,-1.40374e-9],[.8936,.00969686,-64636e-9,-8547e-9],[.9394,.00840947,-192841e-9,-42106e-10],[.9761,.00616527,-256e-6,-42106e-10],[1,.00328947,-319159e-9,-42106e-10]],Ji=o/5,Qi=1/Ji;var Yi={init:function(){this.x0=this.x0||0,this.y0=this.y0||0,this.long0=this.long0||0,this.es=0,this.title=this.title||"Robinson"},forward:function(t){var i=q(t.x-this.long0),e=Math.abs(t.y),s=Math.floor(e*Ji);return s<0?s=0:18<=s&&(s=17),e={x:Hi(Ki[s],e=o*(e-Qi*s))*i,y:Hi(Xi[s],e)},t.y<0&&(e.y=-e.y),e.x=e.x*this.a*.8487+this.x0,e.y=e.y*this.a*1.3523+this.y0,e},inverse:function(t){var i={x:(t.x-this.x0)/(.8487*this.a),y:Math.abs(t.y-this.y0)/(1.3523*this.a)};if(1<=i.y)i.x/=Ki[18][0],i.y=t.y<0?-g:g;else{var e=Math.floor(18*i.y);for(e<0?e=0:18<=e&&(e=17);;)if(Xi[e][0]>i.y)--e;else{if(!(Xi[e+1][0]<=i.y))break;++e}var s=Xi[e],n=function(t,i,e,s){for(var n=i;s;--s){var o=t(n);if(n-=o,Math.abs(o)<e)break}return n}(function(t){return(Hi(s,t)-i.y)/(s[1]+t*(2*s[2]+3*t*s[3]))},n=5*(i.y-s[0])/(Xi[e+1][0]-s[0]),x,100);i.x/=Hi(Ki[e],n),i.y=(5*e+n)*r,t.y<0&&(i.y=-i.y)}return i.x=q(i.x+this.long0),i},names:["Robinson","robin"]};H={init:function(){this.name="geocent"},forward:function(t){return Q(t,this.es,this.a)},inverse:function(t){return Y(t,this.es,this.a,this.b)},names:["Geocentric","geocentric","geocent","Geocent"]};return lt.defaultDatum="WGS84",lt.Proj=J,lt.WGS84=new lt.Proj("WGS84"),lt.Point=Tt,lt.toPoint=et,lt.defs=k,lt.transform=ot,lt.mgrs=yt,lt.version="2.6.2",(yt=lt).Proj.projections.add(Ft),yt.Proj.projections.add(Jt),yt.Proj.projections.add(Yt),yt.Proj.projections.add(ti),yt.Proj.projections.add(ii),yt.Proj.projections.add(ei),yt.Proj.projections.add(si),yt.Proj.projections.add(ni),yt.Proj.projections.add(_i),yt.Proj.projections.add(mi),yt.Proj.projections.add(wi),yt.Proj.projections.add(Pi),yt.Proj.projections.add(Li),yt.Proj.projections.add(Ti),yt.Proj.projections.add(Ci),yt.Proj.projections.add(Si),yt.Proj.projections.add(Ei),yt.Proj.projections.add(zi),yt.Proj.projections.add(Ai),yt.Proj.projections.add(ki),yt.Proj.projections.add(Ii),yt.Proj.projections.add(Oi),yt.Proj.projections.add(Ni),yt.Proj.projections.add(Bi),yt.Proj.projections.add(Vi),yt.Proj.projections.add(Yi),yt.Proj.projections.add(H),lt}),function(t){var i,e;if("function"==typeof define&&define.amd)define(["leaflet","proj4"],t);else if("undefined"!=typeof process&&-1!==process.release.name.search(/node|io.js/))i=require("leaflet"),e=require("proj4"),module.exports=t(i,e);else{if(void 0===window.L||void 0===window.proj4)throw"Leaflet and proj4 must be loaded first";t(window.L,window.proj4)}}(function(a,e){return e.__esModule&&e.default&&(e=e.default),a.Proj={},a.Proj._isProj4Obj=function(t){return void 0!==t.inverse&&void 0!==t.forward},a.Proj.Projection=a.Class.extend({initialize:function(t,i,e){var s=a.Proj._isProj4Obj(t);this._proj=s?t:this._projFromCodeDef(t,i),this.bounds=s?i:e},project:function(t){t=this._proj.forward([t.lng,t.lat]);return new a.Point(t[0],t[1])},unproject:function(t,i){t=this._proj.inverse([t.x,t.y]);return new a.LatLng(t[1]||0,t[0]||0,i)},_projFromCodeDef:function(t,i){if(i)e.defs(t,i);else if(void 0===e.defs[t]){i=t.split(":");if(3<i.length&&(t=i[i.length-3]+":"+i[i.length-1]),void 0===e.defs[t])throw"No projection definition for code "+t}return e(t)}}),a.Proj.CRS=a.Class.extend({includes:a.CRS,options:{transformation:new a.Transformation(1,0,-1,0)},initialize:function(t,i,e){var s,n;if(a.Proj._isProj4Obj(t)?(s=t.srsCode,this.projection=new a.Proj.Projection(t,(n=i||{}).bounds)):this.projection=new a.Proj.Projection(s=t,i,(n=e||{}).bounds),a.Util.setOptions(this,n),this.code=s,this.transformation=this.options.transformation,this.options.origin&&(this.transformation=new a.Transformation(1,-this.options.origin[0],-1,this.options.origin[1])),this.options.scales)this._scales=this.options.scales;else if(this.options.resolutions){this._scales=[];for(var o=this.options.resolutions.length-1;0<=o;o--)this.options.resolutions[o]&&(this._scales[o]=1/this.options.resolutions[o])}this.infinite=!this.options.bounds},scale:function(t){var i,e=Math.floor(t);return t===e?this._scales[t]:(i=this._scales[e])+(this._scales[e+1]-i)*(t-e)},zoom:function(t){var i,e=this._closestElement(this._scales,t),s=this._scales.indexOf(e);return t===e?s:void 0===e?-1/0:void 0===(i=this._scales[s+1])?1/0:(t-e)/(i-e)+s},distance:a.CRS.Earth.distance,R:a.CRS.Earth.R,_closestElement:function(t,i){for(var e,s=t.length;s--;)t[s]<=i&&(void 0===e||e<t[s])&&(e=t[s]);return e}}),a.Proj.GeoJSON=a.GeoJSON.extend({initialize:function(t,i){this._callLevel=0,a.GeoJSON.prototype.initialize.call(this,t,i)},addData:function(t){var i;t&&(t.crs&&"name"===t.crs.type?i=new a.Proj.CRS(t.crs.properties.name):t.crs&&t.crs.type&&(i=new a.Proj.CRS(t.crs.type+":"+t.crs.properties.code)),void 0!==i&&(this.options.coordsToLatLng=function(t){t=a.point(t[0],t[1]);return i.projection.unproject(t)})),this._callLevel++;try{a.GeoJSON.prototype.addData.call(this,t)}finally{this._callLevel--,0===this._callLevel&&delete this.options.coordsToLatLng}}}),a.Proj.geoJson=function(t,i){return new a.Proj.GeoJSON(t,i)},a.Proj.ImageOverlay=a.ImageOverlay.extend({initialize:function(t,i,e){a.ImageOverlay.prototype.initialize.call(this,t,null,e),this._projectedBounds=i},_animateZoom:function(t){var i=this._map.getZoomScale(t.zoom),e=a.point(this._projectedBounds.min.x,this._projectedBounds.max.y),t=this._projectedToNewLayerPoint(e,t.zoom,t.center);a.DomUtil.setTransform(this._image,t,i)},_reset:function(){var t=this._map.getZoom(),i=this._map.getPixelOrigin(),t=a.bounds(this._transform(this._projectedBounds.min,t)._subtract(i),this._transform(this._projectedBounds.max,t)._subtract(i)),i=t.getSize();a.DomUtil.setPosition(this._image,t.min),this._image.style.width=i.x+"px",this._image.style.height=i.y+"px"},_projectedToNewLayerPoint:function(t,i,e){var s=this._map.getSize()._divideBy(2),s=this._map.project(e,i)._subtract(s)._round().add(this._map._getMapPanePos());return this._transform(t,i)._subtract(s)},_transform:function(t,i){var e=this._map.options.crs,s=e.transformation,i=e.scale(i);return s.transform(t,i)}}),a.Proj.imageOverlay=function(t,i,e){return new a.Proj.ImageOverlay(t,i,e)},a.Proj});
//# sourceMappingURL=leaflet.js.map