--
-- Create the database for the in memory tests
--
Drop schema IF EXISTS gw_beleid;
CREATE SCHEMA gw_beleid;


CREATE TABLE gw_beleid.codetable_country (
    code character varying  NOT NULL,
    country character varying NOT NULL
);
ALTER TABLE gw_beleid.codetable_country
    ADD CONSTRAINT codetable_country_pkey PRIMARY KEY (code);

CREATE TABLE gw_beleid.grondwaterlichamen_new (
    dataengine_id integer NOT NULL,
    gwl character varying (2058),
    CONSTRAINT unique_on_gwl UNIQUE (gwl)
);

ALTER TABLE  gw_beleid.grondwaterlichamen_new
    ADD CONSTRAINT gw_beleid.grondwaterlichamen_new_pkey PRIMARY KEY (dataengine_id);

CREATE INDEX multipleColumns ON gw_beleid.grondwaterlichamen_new (dataengine_id, gwl);


CREATE VIEW gw_beleid.vw_grondwaterlichamen AS
 SELECT gw_beleid.grondwaterlichamen_new.dataengine_id,
    gw_beleid.grondwaterlichamen_new.gwl,
    country
   FROM gw_beleid.grondwaterlichamen_new
   LEFT JOIN gw_beleid.codetable_country ON( gw_beleid.codetable_country.code = 'BE')
  WHERE (gw_beleid.grondwaterlichamen_new.gwl like 'BL%');


CREATE VIEW gw_beleid.vw_grondwaterlichamen_generated_id AS
  SELECT gw_beleid.grondwaterlichamen_new.dataengine_id as generated_id,
    gw_beleid.grondwaterlichamen_new.gwl,
    country
  FROM gw_beleid.grondwaterlichamen_new
  LEFT JOIN gw_beleid.codetable_country ON( gw_beleid.codetable_country.code = 'X')
  WHERE (gw_beleid.grondwaterlichamen_new.gwl like 'BL%');




--
-- Data for Name: grondwaterlichamen_new;
--

INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (1, '                                             <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                      <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (2, '                                             <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                      <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (4, '                                             <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                    <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter        <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (5, '                                             <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                    <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter      <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (6, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                              <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (3, '                                             <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                      <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen    <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (93, '                                           <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen    <BR> KPS_0120_GWL_2 Duin- en kreekgebieden in de Oost-Vlaamse Polders, Freatisch  <BR> KPS_0160_GWL_2 verzilt Quartair en Oligoceen van Oost-Vlaamse Polders, Freatisch          <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (7, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                              <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen    <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (8, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                              <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen  <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (10, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                            <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter        <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (11, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (88, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (9, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                              <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen<BR> SS_1300_GWL_1 Kolenkalk, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (12, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                            <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter      <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (13, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                            <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter  <BR> SS_1300_GWL_1 Kolenkalk, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (14, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                                <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (15, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                                <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen    <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (16, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                                <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen  <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (17, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                                <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen<BR> SS_1300_GWL_1 Kolenkalk, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (18, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                              <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter        <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (40, '     <BR> BLKS_0400_GWL_2M Oligoceen Aquifersysteem, Gespannen                <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen                                    <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (19, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                              <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter      <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (21, '                         <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                  <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch<BR> MS_0200_GWL_1 Kempens Aquifersysteem, Freatisch, Plaatselijk Semi-Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (22, '                           <BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (89, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch          <BR> CVS_0400_GWL_1 Oligoceen Aquifersysteem, Lokaal Freatisch  <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (20, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                              <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter  <BR> SS_1300_GWL_1 Kolenkalk, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (95, '                                         <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch    <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen  <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch  <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (119, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen<BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (23, '                     <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch  <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (24, '                 <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                      <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (25, '                 <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (30, '           <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                              <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (31, '           <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (26, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch                                                        <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (27, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (28, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch                                                          <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (29, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch  <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (38, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen        <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                              <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (39, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen        <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen        <BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (32, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                              <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (33, '                         <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (34, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                      <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (35, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (36, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch    <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch                                                                <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (37, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch    <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (106, '                                         <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch    <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen      <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (41, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch            <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                              <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (42, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch            <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (43, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch          <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (44, '                       <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (45, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch          <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (46, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (47, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch    <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (132, '                                               <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen  <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch                <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (48, ' <BR>BLKS_0400_GWL_1M Oligoceen Aquifersysteem, Freatisch                    <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen                                    <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (49, ' <BR>BLKS_0400_GWL_1M Oligoceen Aquifersysteem, Freatisch                <BR> BLKS_1100_GWL_1M Krijt Aquifersysteem, Freatisch                                        <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (50, 'BLKS_0160_GWL_1M Quartaire Maas- en Rijnafzettingen, Freatisch    <BR> BLKS_0400_GWL_2M Oligoceen Aquifersysteem, Gespannen                <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (51, 'BLKS_0160_GWL_1M Quartaire Maas- en Rijnafzettingen, Freatisch    <BR> BLKS_0400_GWL_2M Oligoceen Aquifersysteem, Gespannen            <BR> BLKS_1100_GWL_1M Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (52, 'BLKS_0160_GWL_1M Quartaire Maas- en Rijnafzettingen, Freatisch<BR>BLKS_0400_GWL_1M Oligoceen Aquifersysteem, Freatisch                    <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (53, 'BLKS_0160_GWL_1M Quartaire Maas- en Rijnafzettingen, Freatisch<BR>BLKS_0400_GWL_1M Oligoceen Aquifersysteem, Freatisch                <BR> BLKS_1100_GWL_1M Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (56, '                                                                     <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (57, '                                                                   <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter        <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (58, '                                                             <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch  <BR> MS_0200_GWL_2 Kempens Aquifersysteem in de Centrale Slenk, Freatisch, Plaatselijk Semi-Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (59, '                                                             <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch<BR> MS_0200_GWL_1 Kempens Aquifersysteem, Freatisch, Plaatselijk Semi-Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (60, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch                              <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (61, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                                  <BR> SS_1300_GWL_1 Kolenkalk, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (54, '                                                                         <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (62, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                              <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (63, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch                  <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (64, '                             <BR> CKS_0200_GWL_2 Noordelijke Zanden van de Kempen, Freatisch, Plaatselijk Semi-Freatisch<BR> CKS_0220_GWL_1 Complex van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (65, '                         <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (66, '                   <BR> BLKS_1100_GWL_1M Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (67, '                         <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (55, '                     <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (77, '                 <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (68, '                     <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch                                                          <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (69, '                     <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch  <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (70, '                   <BR> BLKS_1100_GWL_1M Krijt Aquifersysteem, Freatisch                                        <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (78, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch                                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (79, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch                                                              <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (90, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen        <BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch          <BR> CVS_0400_GWL_1 Oligoceen Aquifersysteem, Lokaal Freatisch  <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (91, ' <BR>BLKS_0400_GWL_1M Oligoceen Aquifersysteem, Freatisch                <BR> BLKS_1100_GWL_1M Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (92, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch      <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen  <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch  <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (71, '                 <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                              <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (72, '                 <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                      <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (73, '                 <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (74, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch                                                                <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (75, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (76, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (80, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch              <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (81, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (82, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch    <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (83, '     <BR> BLKS_0400_GWL_2M Oligoceen Aquifersysteem, Gespannen                <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (84, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch                <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (85, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch            <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (86, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch          <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (87, ' <BR>BLKS_0400_GWL_1M Oligoceen Aquifersysteem, Freatisch                    <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (94, '                                           <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen  <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch  <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (96, '                                       <BR> CVS_0400_GWL_1 Oligoceen Aquifersysteem, Lokaal Freatisch  <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen          <BR> KPS_0160_GWL_3 verzilt Quartair, Plioceen en Mioceen van Scheldepolders, Freatisch        <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (97, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch<BR> CVS_0400_GWL_1 Oligoceen Aquifersysteem, Lokaal Freatisch  <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (98, '                           <BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch          <BR> CVS_0400_GWL_1 Oligoceen Aquifersysteem, Lokaal Freatisch  <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (99, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch                                                    <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (100, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch      <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen<BR> BLKS_0600_GWL_3 Brusseliaan venster: contact met Diestiaan, Freatisch  <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen      <BR> CKS_0250_GWL_1 Diestiaangeul: contact Brusseliaan, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (101, '                                               <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen  <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch  <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (102, 'BLKS_0160_GWL_1M Quartaire Maas- en Rijnafzettingen, Freatisch                      <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (103, '                                           <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen        <BR> KPS_0160_GWL_2 verzilt Quartair en Oligoceen van Oost-Vlaamse Polders, Freatisch          <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (104, '                                           <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen      <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (105, '                                           <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen  <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch                <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (107, '                                       <BR> CVS_0400_GWL_1 Oligoceen Aquifersysteem, Lokaal Freatisch  <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (108, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch    <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (109, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch    <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (110, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch  <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch    <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (111, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch  <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch    <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (127, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch    <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (112, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch  <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch  <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                      <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (113, 'BLKS_0160_GWL_1M Quartaire Maas- en Rijnafzettingen, Freatisch                  <BR> BLKS_1100_GWL_1M Krijt Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (114, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch      <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (115, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch      <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (116, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (117, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                <BR> KPS_0160_GWL_3 verzilt Quartair, Plioceen en Mioceen van Scheldepolders, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (118, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (128, '                                                       <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch          <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter<BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (129, '                                                   <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch  <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (130, '                                                   <BR> KPS_0120_GWL_1 Duin- en kreekgebieden in het kustgebied, Freatisch  <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch          <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter        <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (131, '                                               <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen      <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (120, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch          <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch  <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (123, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch      <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (121, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch        <BR> BLKS_0600_GWL_3 Brusseliaan venster: contact met Diestiaan, Freatisch  <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen      <BR> CKS_0250_GWL_1 Diestiaangeul: contact Brusseliaan, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (124, '                                                                                 <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (125, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (122, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch      <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (126, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                              <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (133, '                                           <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (134, '                                         <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch      <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (135, '                                                                         <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (140, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch          <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen  <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (136, '                                         <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch    <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (137, '                                         <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch    <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (138, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch          <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (139, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch          <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (141, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch        <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (145, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch          <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (146, '                                                                 <BR> MS_0200_GWL_2 Kempens Aquifersysteem in de Centrale Slenk, Freatisch, Plaatselijk Semi-Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (147, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch          <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (148, '                                   <BR> CVS_0100_GWL_1 Dun Quartair dek boven op Paleogeen klei, Freatisch          <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen    <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (149, '                           <BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch          <BR> CVS_0400_GWL_1 Oligoceen Aquifersysteem, Lokaal Freatisch  <BR> CVS_0600_GWL_2 Ledo-Paniseliaan Aquifersysteem, Gespannen  <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (142, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch        <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (143, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch      <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                      <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (144, '                                     <BR> CVS_0160_GWL_1 Pleistoceen afzettingen, Freatisch      <BR> CVS_0800_GWL_1 Ieperiaan Aquifer, Freatisch                      <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (150, '               <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch  <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (151, '             <BR> BLKS_0600_GWL_3 Brusseliaan venster: contact met Diestiaan, Freatisch  <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen      <BR> CKS_0250_GWL_1 Diestiaangeul: contact Brusseliaan, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (158, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch    <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (152, '           <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (153, '           <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (154, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                      <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (155, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (156, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                              <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (157, '                                                             <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (159, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen        <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (160, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen        <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (161, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen      <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (162, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                        <BR> KPS_0160_GWL_3 verzilt Quartair, Plioceen en Mioceen van Scheldepolders, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (177, ' <BR>BLKS_0400_GWL_1M Oligoceen Aquifersysteem, Freatisch                    <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen                                    <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch<BR> MS_0200_GWL_1 Kempens Aquifersysteem, Freatisch, Plaatselijk Semi-Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (163, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen  <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen        <BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (164, '       <BR> BLKS_0400_GWL_2S Oligoceen Aquifersysteem, Gespannen<BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (165, '     <BR> BLKS_0400_GWL_2M Oligoceen Aquifersysteem, Gespannen                <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen                                    <BR> MS_0100_GWL_1 Quartaire Aquifersystemen, Freatisch<BR> MS_0200_GWL_1 Kempens Aquifersysteem, Freatisch, Plaatselijk Semi-Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (166, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch            <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (167, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch            <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen<BR> CKS_0200_GWL_1 Centrale zanden van de Kempen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (178, 'BLKS_0160_GWL_1M Quartaire Maas- en Rijnafzettingen, Freatisch    <BR> BLKS_0400_GWL_2M Oligoceen Aquifersysteem, Gespannen                <BR> BLKS_1100_GWL_2M Krijt Aquifersysteem, Gespannen<BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (168, '                                                           <BR> KPS_0160_GWL_3 verzilt Quartair, Plioceen en Mioceen van Scheldepolders, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (169, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch          <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen                                                      <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (170, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch          <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch                                                          <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (171, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch          <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch    <BR> BLKS_1100_GWL_1S Krijt Aquifersysteem, Freatisch  <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (172, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch      <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                              <BR> BLKS_0160_GWL_1S Pleistoceen Rivierafzettingen, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (179, '                                                       <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (180, '                                                       <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch            <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (181, '                                                       <BR> KPS_0160_GWL_1 verzilt Quartair en Eoceen van het kustgebied, Freatisch          <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter        <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (173, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch      <BR> BLKS_0600_GWL_2 Brusseliaan Aquifer, Gespannen    <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (174, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen                                                      <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (175, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch      <BR> BLKS_1000_GWL_2S Landeniaan Aquifersysteem, Gespannen      <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (176, '   <BR> BLKS_0400_GWL_1S Oligoceen Aquifersysteem, Freatisch    <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch    <BR> BLKS_1000_GWL_1S Landeniaan Aquifersysteem, Freatisch        <BR> BLKS_1100_GWL_2S Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (182, '                                                 <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen        <BR> SS_1300_GWL_5 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (183, '                                                 <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (184, '                                                 <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen    <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (185, '                                                 <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                  <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen  <BR> SS_1300_GWL_2 Sokkel + Krijt Aquifersysteem, Lokaal freatisch, voedingsgebied');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (186, '                                                 <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter        <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (187, '                                                 <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter      <BR> SS_1300_GWL_3 Sokkel + Krijt Aquifersysteem, Gespannen, Depressietrechter');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (188, '                                                 <BR> CVS_0800_GWL_3 Ieperiaan Aquifer Heuvelstreken, Lokaal Gespannen                <BR> SS_1000_GWL_1 Paleoceen Aquifersysteem, Gespannen, Depressietrechter  <BR> SS_1300_GWL_1 Kolenkalk, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (189, '                                               <BR> CVS_0800_GWL_2 Ieperiaan Aquifer, Gespannen                    <BR> SS_1000_GWL_2 Paleoceen Aquifersysteem, Gespannen      <BR> SS_1300_GWL_4 Sokkel + Krijt Aquifersysteem, Gespannen');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (190, '                                         <BR> CVS_0600_GWL_1 Ledo-Paniseliaan Aquifersysteem, Freatisch');
INSERT INTO gw_beleid.grondwaterlichamen_new VALUES (191, '         <BR> BLKS_0600_GWL_1 Brusseliaan Aquifer, Freatisch');

--
-- Data for Name: codetable_country;
--
INSERT INTO  gw_beleid.codetable_country VALUES ('BE', 'BELGIUM');