CREATE TABLE OBJECT (OID int(11) NOT NULL AUTO_INCREMENT, TYPE_ID int(11) NOT NULL, ID varchar(255) NOT NULL, BLOB text NOT NULL, PRIMARY KEY (OID), UNIQUE INDEX (OID), INDEX (TYPE_ID), UNIQUE INDEX (ID));
CREATE TABLE OBJECT_PROPERTY (OID int(11) NOT NULL, PROPERTY_TYPE int(11) NOT NULL, ID varchar(255) NOT NULL, RELATED_OID int(11), RELATED_PROPERTY_TYPE int(11), COLINDEX int(11) NOT NULL, VALUE varchar(1023), PRIMARY KEY (OID, PROPERTY_TYPE, COLINDEX), INDEX (OID), INDEX (PROPERTY_TYPE), INDEX (ID), INDEX (RELATED_OID), INDEX (RELATED_PROPERTY_TYPE), INDEX (COLINDEX), INDEX (VALUE));
CREATE TABLE TYPE (OID int(11) NOT NULL AUTO_INCREMENT, TYPENAME varchar(255) NOT NULL, PRIMARY KEY (OID), UNIQUE INDEX (OID), UNIQUE INDEX (TYPENAME));
CREATE TABLE PROPERTY_TYPE (OID int(11) NOT NULL AUTO_INCREMENT, TARGET_PROPERTY int(11), TYPE_ID int(11) NOT NULL, NAME varchar(255) NOT NULL, COLLECTION tinyint(1) NOT NULL, TEXT tinyint(1) NOT NULL, PRIMARY KEY (OID), UNIQUE INDEX (OID), INDEX (TARGET_PROPERTY), INDEX (TYPE_ID), INDEX (NAME), INDEX (COLLECTION));
CREATE TABLE DEFAULT_OBJECT (DEF_KEY varchar(255) NOT NULL, ID varchar(255) NOT NULL, UNIQUE INDEX (DEF_KEY), INDEX (ID));
ALTER TABLE OBJECT_PROPERTY ADD INDEX FK_OBJECT_PROPERTY (OID), ADD CONSTRAINT FK_OBJECT_PROPERTY FOREIGN KEY (OID) REFERENCES OBJECT (OID) ON DELETE Cascade;
ALTER TABLE PROPERTY_TYPE ADD INDEX FK_TYPE_PROPERTY_TYPE (TYPE_ID), ADD CONSTRAINT FK_TYPE_PROPERTY_TYPE FOREIGN KEY (TYPE_ID) REFERENCES TYPE (OID);
ALTER TABLE OBJECT ADD INDEX FK_OBJECT_TYPE (TYPE_ID), ADD CONSTRAINT FK_OBJECT_TYPE FOREIGN KEY (TYPE_ID) REFERENCES TYPE (OID);
ALTER TABLE PROPERTY_TYPE ADD INDEX FK_PROPERTY_TYPE_TARGET_PROPERTY (TARGET_PROPERTY), ADD CONSTRAINT FK_PROPERTY_TYPE_TARGET_PROPERTY FOREIGN KEY (TARGET_PROPERTY) REFERENCES PROPERTY_TYPE (OID);
ALTER TABLE OBJECT_PROPERTY ADD INDEX FK_OBJECT_PROPERTY_PROPERTY_TYPE (PROPERTY_TYPE), ADD CONSTRAINT FK_OBJECT_PROPERTY_PROPERTY_TYPE FOREIGN KEY (PROPERTY_TYPE) REFERENCES PROPERTY_TYPE (OID);
