# Security Policy

## Supported Versions

Each GeoServer release is supported with bug fixes for a year, with releases made approximately every two months.

| Version     | Supported          | Available               |
| ----------- | ------------------ |------------------------ |
| stable      | :white_check_mark: | six months              |
| maintenance | :white_check_mark: | twelve months           |
| archived    | :x:                |                         |

This approach provides ample time for upgrading ensuring you are always working with a supported GeoServer release.

If your organisation is making use of a GeoServer version that is no longer in use by the community all is not lost.
You can volunteer on the developer list to make additional releases, or engage with one of our [Commercial Support](http://geoserver.org/support/) providers.

## Reporting a Vulnerability

If you encounter a security vulnerability in GeoServer please take care to report in a responsible fashion:

* Keep exploit details out of mailing list and issue tracker (send details to geoserver-security@lists.osgeo.org)
* Be prepared to work with Project Steering Committee (PSC) members on a solution
* Keep in mind PSC members are volunteers and an extensive fix may require fundraising / resources

Please send a mail directly to geoserver-security@lists.osgeo.org (moderated list with no possibility to subscribe, please just send directly to the address, the mail will be evaluated and eventually posted) and provide information about the security issue you might have found there.

For more information see [Community Support](http://geoserver.org/comm/).
