<img src="/doc/en/themes/geoserver/static/GeoServer_500.png" width="353">

[![Gitter](https://badges.gitter.im/geoserver/geoserver.svg)](https://gitter.im/geoserver/geoserver?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![DOI](https://zenodo.org/badge/2751199.svg)](https://zenodo.org/badge/latestdoi/2751199)

[GeoServer](https://geoserver.org) is an open source software server written in Java that 
allows users to share and edit geospatial data. Designed for interoperability, it publishes data from 
any major spatial data source using open standards.

Being a community-driven project, GeoServer is developed, tested, and supported by a diverse group of 
individuals and organizations from around the world.

GeoServer is the reference implementation of the Open Geospatial Consortium (OGC) 
Web Feature Service (WFS) and Web Coverage Service (WCS) standards, as well as a high performance 
certified compliant Web Map Service (WMS), compliant Catalog Service for the Web (CSW)
and implementing Web Processing Service (WPS). 
GeoServer forms a core component of the Geospatial Web.

## License

GeoServer licensed under the [GPL](https://docs.geoserver.org/latest/en/user/introduction/license.html).

## Using

Please refer to the [user guide](https://docs.geoserver.org/latest/en/user/) for information
on how to install and use GeoServer.

## Building

GeoServer uses [Apache Maven](https://maven.apache.org/) for a build system. To 
build the application run maven from the ```src``` directory.

    mvn clean install

See the [developer guide](https://docs.geoserver.org/latest/en/developer/) 
for more details.

## Bugs

GeoServer uses [JIRA](https://osgeo-org.atlassian.net/projects/GEOS), hosted by 
[Atlassian](https://www.atlassian.com/), for issue tracking.

## Mailing Lists

The [mailing list page](https://geoserver.org/comm/) on the GeoServer web site provides
access to the various mailing list, as well as some indication of the [code of conduct](https://geoserver.org/comm/userlist-guidelines.html) when posting to the lists

## Contributing

Please read [the contribution guidelines](https://github.com/geoserver/geoserver/blob/main/CONTRIBUTING.md) before contributing pull requests to the GeoServer project.

## More Information

Visit the [website](https://geoserver.org/) or read the [docs](https://docs.geoserver.org/). 

