// airspy-fmradion
// Software decoder for FM broadcast radio with Airspy
//
// Copyright (C) 2019-2022 Kenji Rikitake, JJ1BDX
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#include "FilterParameters.h"
#include "SoftFM.h"

// Values of vectors

const IQSampleCoeff FilterParameters::delay_3taps_only_iq = {0.0, 1.0, 0.0};

const SampleCoeff FilterParameters::jj1bdx_48khz_fmaudio = {
    1.0101538343156901e-07, 4.394677230260367e-08,   -3.867158920421356e-07,
    4.550052394054024e-07,  4.2243654992168073e-07,  -1.856700371603661e-06,
    1.7934350372596484e-06, 1.581254861883408e-06,   -6.2784747656576516e-06,
    5.931773638356052e-06,  3.982344028958351e-06,   -1.7231590082734962e-05,
    1.7065223192421945e-05, 7.382174740440623e-06,   -4.0682996129477794e-05,
    4.358600141367943e-05,  9.195040741247982e-06,   -8.515627693862435e-05,
    0.00010040324103675794, 1.5981992887546445e-06,  -0.00016078215760171103,
    0.00021129524742604535, -3.2773013221760905e-05, -0.0002764935315405614,
    0.00041047891049814496, -0.00012630646790063595, -0.0004347458475390368,
    0.0007423262560244399,  -0.00033236137157121513, -0.0006235223291951401,
    0.00125816987219327,    -0.00073059156112438,    -0.0008059395274708236,
    0.002009548506148357,   -0.001430554048668224,   -0.0009082607253514219,
    0.003038070993085482,   -0.002573250100039745,   -0.000807083857179171,
    0.00436318072483048,    -0.004332187299585962,   -0.00031511214188372877,
    0.005970194984670549,   -0.006919561383197073,   0.0008393142144861044,
    0.007801688326274638,   -0.010611734486741495,   0.003054970449284701,
    0.009755248438222308,   -0.01583021907267296,    0.006971293162796619,
    0.011689683862289075,   -0.023386678731854738,   0.013816714320254317,
    0.01344001113410461,    -0.03531376594813095,    0.026709264037950382,
    0.014839390885081113,   -0.05870991929335667,    0.05790659491111103,
    0.01574420285787947,    -0.14413657831559104,    0.2668229209259829,
    0.6827239283565725,     0.2668229209259829,      -0.14413657831559104,
    0.01574420285787947,    0.05790659491111103,     -0.05870991929335667,
    0.014839390885081113,   0.026709264037950382,    -0.03531376594813095,
    0.01344001113410461,    0.013816714320254317,    -0.023386678731854738,
    0.011689683862289075,   0.006971293162796619,    -0.01583021907267296,
    0.009755248438222308,   0.003054970449284701,    -0.010611734486741495,
    0.007801688326274638,   0.0008393142144861044,   -0.006919561383197073,
    0.005970194984670549,   -0.00031511214188372877, -0.004332187299585962,
    0.00436318072483048,    -0.000807083857179171,   -0.002573250100039745,
    0.003038070993085482,   -0.0009082607253514219,  -0.001430554048668224,
    0.002009548506148357,   -0.0008059395274708236,  -0.00073059156112438,
    0.00125816987219327,    -0.0006235223291951401,  -0.00033236137157121513,
    0.0007423262560244399,  -0.0004347458475390368,  -0.00012630646790063595,
    0.00041047891049814496, -0.0002764935315405614,  -3.2773013221760905e-05,
    0.00021129524742604535, -0.00016078215760171103, 1.5981992887546445e-06,
    0.00010040324103675794, -8.515627693862435e-05,  9.195040741247982e-06,
    4.358600141367943e-05,  -4.0682996129477794e-05, 7.382174740440623e-06,
    1.7065223192421945e-05, -1.7231590082734962e-05, 3.982344028958351e-06,
    5.931773638356052e-06,  -6.2784747656576516e-06, 1.581254861883408e-06,
    1.7934350372596484e-06, -1.856700371603661e-06,  4.2243654992168073e-07,
    4.550052394054024e-07,  -3.867158920421356e-07,  4.394677230260367e-08,
    1.0101538343156901e-07};

const SampleCoeff FilterParameters::jj1bdx_48khz_nbfmaudio = {
    -3.355733484947834e-05,  -7.802975900213948e-05, -0.0001088033745367685,
    -5.1983076727079734e-05, 0.0001458225812785223,  0.00043006106776603657,
    0.000587711212664608,    0.00033538760971973437, -0.0004361083617537936,
    -0.001404226730911879,   -0.001808965085783337,  -0.0008812533123951267,
    0.001434264064024477,    0.003978647384533122,   0.004703108903700671,
    0.001978025301338509,    -0.003770986847306831,  -0.009375229813282187,
    -0.010227646795609394,   -0.003390384029262643,  0.0092727115942519,
    0.020454302218439243,    0.020755791981803676,   0.004993445912123781,
    -0.022138766451065498,   -0.04528968094791093,   -0.04454269951936403,
    -0.006183058588989406,   0.0676280641789018,     0.15641894478307666,
    0.2288071733317274,      0.2566799540794777,     0.2288071733317274,
    0.15641894478307666,     0.0676280641789018,     -0.006183058588989406,
    -0.04454269951936403,    -0.04528968094791093,   -0.022138766451065498,
    0.004993445912123781,    0.020755791981803676,   0.020454302218439243,
    0.0092727115942519,      -0.003390384029262643,  -0.010227646795609394,
    -0.009375229813282187,   -0.003770986847306831,  0.001978025301338509,
    0.004703108903700671,    0.003978647384533122,   0.001434264064024477,
    -0.0008812533123951267,  -0.001808965085783337,  -0.001404226730911879,
    -0.0004361083617537936,  0.00033538760971973437, 0.000587711212664608,
    0.00043006106776603657,  0.0001458225812785223,  -5.1983076727079734e-05,
    -0.0001088033745367685,  -7.802975900213948e-05, -3.355733484947834e-05};

const SampleCoeff FilterParameters::delay_3taps_only_audio = {0.0, 1.0, 0.0};

const IQSampleCoeff FilterParameters::jj1bdx_ssb_12khz_1500hz = {
    4.2547621905829055e-07,  1.056929531799967e-06,   1.2297836640428945e-06,
    7.909114086578279e-07,   -1.047560885434776e-07,  -1.0416432595702957e-06,
    -1.5394960057161327e-06, -1.304678186520535e-06,  -4.029743001385334e-07,
    7.484034085964797e-07,   1.5794589105953791e-06,  1.6607616681654392e-06,
    9.359514957161952e-07,   -2.3774028804915774e-07, -1.2715661046165692e-06,
    -1.6566639686141032e-06, -1.2344906076155648e-06, -2.7346584811512565e-07,
    6.93833855758449e-07,    1.180071086602009e-06,   1.0172719805750403e-06,
    4.307779375210798e-07,   -1.3310669301850608e-07, -3.1833478269701574e-07,
    -1.07243809440102e-07,   1.671103477024573e-07,   7.174503064178665e-08,
    -5.637793808413017e-07,  -1.423259804054557e-06,  -1.8108107355287353e-06,
    -1.0835696448121778e-06, 8.247634360671723e-07,   3.139089206829523e-06,
    4.489815539193552e-06,   3.6403409847945865e-06,  3.396729775416199e-07,
    -4.219964242844868e-06,  -7.73017677083788e-06,   -7.86557674062869e-06,
    -3.6642889339628535e-06, 3.5776868835916525e-06,  1.0535235251244873e-05,
    1.3307618290228947e-05,  9.501666935248982e-06,   -1.2784838914547826e-07,
    -1.149552545723833e-05,  -1.8825418084346447e-05, -1.7512509409444065e-05,
    -6.820615840785129e-06,  9.097468418904933e-06,   2.267589359157344e-05,
    2.6473967045254715e-05,  1.7152295827925725e-05,  -2.199566004153638e-06,
    -2.2853295792733192e-05, -3.432343612000141e-05,  -2.9648236062568017e-05,
    -9.427578910081663e-06,  1.766051225693219e-05,   3.851702408945322e-05,
    4.195762269162192e-05,   2.4663932797525596e-05,  -6.402688243543739e-06,
    -3.670209717624513e-05,  -5.095606591001307e-05,  -4.090057485739755e-05,
    -9.991290519973651e-06,  2.7594545583760855e-05,  5.3520770389969655e-05,
    5.4366560994367985e-05,  2.8664342492595955e-05,  -1.183963311549988e-05,
    -4.762350974410707e-05,  -6.0998411527403634e-05, -4.50767043222849e-05,
    -7.444370041173968e-06,  3.349865935411324e-05,   5.777857345542756e-05,
    5.39430657423872e-05,    2.4752310485215476e-05,  -1.4526039009933873e-05,
    -4.4289300095758934e-05, -5.083471096201149e-05,  -3.313856964116376e-05,
    -2.5784077607974514e-06, 2.4063807455807152e-05,  3.420112853975405e-05,
    2.6073283749653232e-05,  8.61040461923762e-06,    -5.221288738324139e-06,
    -7.344911520543341e-06,  -7.904317091874019e-11,  6.073907295484263e-06,
    -1.0434212635595017e-07, -2.0275265557134332e-05, -4.28969240139682e-05,
    -4.843773246415658e-05,  -2.213902031654454e-05,  3.307284970388013e-05,
    9.244741285117557e-05,   0.00011905219133741154,  8.429594102050675e-05,
    -1.1215282543845464e-05, -0.00012961546489631025, -0.00020860536213344232,
    -0.00019225960723700462, -6.543708129529607e-05,  0.00012775678235690935,
    0.00029566240384183614,  0.0003404543877014361,   0.00021159934663547068,
    -5.6487902811213866e-05, -0.0003467276180130603,  -0.0005077350202995447,
    -0.0004298381490045301,  -0.00011185496535664682, 0.0003194252590576738,
    0.0006555424527223744,   0.0007041443292491061,   0.0003938171533554444,
    -0.00016912336277963703, -0.0007295269379294825,  -0.0009954025219282491,
    -0.0007857724750152975,  -0.0001413674497395574,  0.0006654080391698579,
    0.00124037890291564,     0.001255998019660055,    0.000630160868001231,
    -0.00039912534561236876, -0.00135551259889522,    -0.001739871185177905,
    -0.001284558395247969,   -0.00011954726917935563, 0.001246109668626071,
    0.002140005875949859,    0.00205147279032549,     0.0009116264727200779,
    -0.0008205907919265257,  -0.002332542392590109,   -0.002832299004501847,
    -0.001954152196778232,   8.402854657025576e-06,   0.002179832686109811,
    0.003484046681019315,    0.003168654171053333,    0.001220705814718346,
    -0.001548564359469987,   -0.003827571765803436,   -0.004415165933063979,
    -0.00283888112671226,    0.000331158585397275,    0.003662343342294051,
    0.00549311524250598,     0.004746586213390664,    0.001532693759241575,
    -0.002785477805511625,   -0.00614868849364738,    -0.00676509138131453,
    -0.004037998355321513,   0.001010826310658077,    0.006085609071915563,
    0.008634808991410428,    0.007103447369248098,    0.001818549600330381,
    -0.004971977243371239,   -0.010015291347448366,   -0.0105701638900615,
    -0.005835464330732391,   0.002427275805270018,    0.010474331627924069,
    0.014211555274150281,    0.011193338158157201,    0.0020489096987513,
    -0.009431196968572864,   -0.0177538776964483,     -0.018210821081441123,
    -0.009322847406529321,   0.0059393830513708,      0.020905288020969363,
    0.02784278937211172,     0.021521367480718475,    0.002198548943026853,
    -0.0233895957416361,     -0.04373362660208311,    -0.04655705796930097,
    -0.023708242150621558,   0.024979932840257853,    0.09051463707110843,
    0.15693679390003606,     0.20626687294655013,     0.22447265608248146,
    0.20626687294655013,     0.15693679390003606,     0.09051463707110843,
    0.024979932840257853,    -0.023708242150621558,   -0.04655705796930097,
    -0.04373362660208311,    -0.0233895957416361,     0.002198548943026853,
    0.021521367480718475,    0.02784278937211172,     0.020905288020969363,
    0.0059393830513708,      -0.009322847406529321,   -0.018210821081441123,
    -0.0177538776964483,     -0.009431196968572864,   0.0020489096987513,
    0.011193338158157201,    0.014211555274150281,    0.010474331627924069,
    0.002427275805270018,    -0.005835464330732391,   -0.0105701638900615,
    -0.010015291347448366,   -0.004971977243371239,   0.001818549600330381,
    0.007103447369248098,    0.008634808991410428,    0.006085609071915563,
    0.001010826310658077,    -0.004037998355321513,   -0.00676509138131453,
    -0.00614868849364738,    -0.002785477805511625,   0.001532693759241575,
    0.004746586213390664,    0.00549311524250598,     0.003662343342294051,
    0.000331158585397275,    -0.00283888112671226,    -0.004415165933063979,
    -0.003827571765803436,   -0.001548564359469987,   0.001220705814718346,
    0.003168654171053333,    0.003484046681019315,    0.002179832686109811,
    8.402854657025576e-06,   -0.001954152196778232,   -0.002832299004501847,
    -0.002332542392590109,   -0.0008205907919265257,  0.0009116264727200779,
    0.00205147279032549,     0.002140005875949859,    0.001246109668626071,
    -0.00011954726917935563, -0.001284558395247969,   -0.001739871185177905,
    -0.00135551259889522,    -0.00039912534561236876, 0.000630160868001231,
    0.001255998019660055,    0.00124037890291564,     0.0006654080391698579,
    -0.0001413674497395574,  -0.0007857724750152975,  -0.0009954025219282491,
    -0.0007295269379294825,  -0.00016912336277963703, 0.0003938171533554444,
    0.0007041443292491061,   0.0006555424527223744,   0.0003194252590576738,
    -0.00011185496535664682, -0.0004298381490045301,  -0.0005077350202995447,
    -0.0003467276180130603,  -5.6487902811213866e-05, 0.00021159934663547068,
    0.0003404543877014361,   0.00029566240384183614,  0.00012775678235690935,
    -6.543708129529607e-05,  -0.00019225960723700462, -0.00020860536213344232,
    -0.00012961546489631025, -1.1215282543845464e-05, 8.429594102050675e-05,
    0.00011905219133741154,  9.244741285117557e-05,   3.307284970388013e-05,
    -2.213902031654454e-05,  -4.843773246415658e-05,  -4.28969240139682e-05,
    -2.0275265557134332e-05, -1.0434212635595017e-07, 6.073907295484263e-06,
    -7.904317091874019e-11,  -7.344911520543341e-06,  -5.221288738324139e-06,
    8.61040461923762e-06,    2.6073283749653232e-05,  3.420112853975405e-05,
    2.4063807455807152e-05,  -2.5784077607974514e-06, -3.313856964116376e-05,
    -5.083471096201149e-05,  -4.4289300095758934e-05, -1.4526039009933873e-05,
    2.4752310485215476e-05,  5.39430657423872e-05,    5.777857345542756e-05,
    3.349865935411324e-05,   -7.444370041173968e-06,  -4.50767043222849e-05,
    -6.0998411527403634e-05, -4.762350974410707e-05,  -1.183963311549988e-05,
    2.8664342492595955e-05,  5.4366560994367985e-05,  5.3520770389969655e-05,
    2.7594545583760855e-05,  -9.991290519973651e-06,  -4.090057485739755e-05,
    -5.095606591001307e-05,  -3.670209717624513e-05,  -6.402688243543739e-06,
    2.4663932797525596e-05,  4.195762269162192e-05,   3.851702408945322e-05,
    1.766051225693219e-05,   -9.427578910081663e-06,  -2.9648236062568017e-05,
    -3.432343612000141e-05,  -2.2853295792733192e-05, -2.199566004153638e-06,
    1.7152295827925725e-05,  2.6473967045254715e-05,  2.267589359157344e-05,
    9.097468418904933e-06,   -6.820615840785129e-06,  -1.7512509409444065e-05,
    -1.8825418084346447e-05, -1.149552545723833e-05,  -1.2784838914547826e-07,
    9.501666935248982e-06,   1.3307618290228947e-05,  1.0535235251244873e-05,
    3.5776868835916525e-06,  -3.6642889339628535e-06, -7.86557674062869e-06,
    -7.73017677083788e-06,   -4.219964242844868e-06,  3.396729775416199e-07,
    3.6403409847945865e-06,  4.489815539193552e-06,   3.139089206829523e-06,
    8.247634360671723e-07,   -1.0835696448121778e-06, -1.8108107355287353e-06,
    -1.423259804054557e-06,  -5.637793808413017e-07,  7.174503064178665e-08,
    1.671103477024573e-07,   -1.07243809440102e-07,   -3.1833478269701574e-07,
    -1.3310669301850608e-07, 4.307779375210798e-07,   1.0172719805750403e-06,
    1.180071086602009e-06,   6.93833855758449e-07,    -2.7346584811512565e-07,
    -1.2344906076155648e-06, -1.6566639686141032e-06, -1.2715661046165692e-06,
    -2.3774028804915774e-07, 9.359514957161952e-07,   1.6607616681654392e-06,
    1.5794589105953791e-06,  7.484034085964797e-07,   -4.029743001385334e-07,
    -1.304678186520535e-06,  -1.5394960057161327e-06, -1.0416432595702957e-06,
    -1.047560885434776e-07,  7.909114086578279e-07,   1.2297836640428945e-06,
    1.056929531799967e-06,   4.2547621905829055e-07,
};
const IQSampleCoeff FilterParameters::jj1bdx_am_48khz_narrow = {
    1.0733252454078762e-06,  1.1850710582464755e-06,  1.0795917050509872e-06,
    6.680266474451356e-07,   -1.1483994090604456e-07, -1.2902018702267198e-06,
    -2.81623846121205e-06,   -4.5741202082198554e-06, -6.362732948042674e-06,
    -7.905373240961229e-06,  -8.870571595013051e-06,  -8.907508763610574e-06,
    -7.694335419666139e-06,  -4.995316704921293e-06,  -7.204121956516945e-07,
    5.0209684210692555e-06,  1.188135334293442e-05,   1.926098507930709e-05,
    2.632579943221675e-05,   3.206256580192389e-05,   3.5371989770634556e-05,
    3.5195449107763685e-05,  3.0665461942635624e-05,  2.1264660313211453e-05,
    6.97374524326707e-06,    -1.1613587342489047e-05, -3.3230762718393935e-05,
    -5.595255894272177e-05,  -7.729650587147542e-05,  -9.441564730999897e-05,
    -0.0001043758375396436,  -0.00010449861612992377, -9.273886275005421e-05,
    -6.805645647660092e-05,  -3.0734647616127785e-05, 1.7403798665162165e-05,
    7.292740108925049e-05,   0.0001309078981397285,   0.00018523101798219584,
    0.00022910241913686485,  0.0002557208106832978,   0.00025906551384469005,
    0.00023472353902483607,  0.00018066472184016216,  9.786543948186687e-05,
    -9.31586700287633e-06,   -0.0001330934823425633,  -0.0002625950786391531,
    -0.000384606843541242,   -0.0004846972431710153,  -0.0005486459358485326,
    -0.0005640586573530344,  -0.0005220107915314061,  -0.0004185372882990475,
    -0.0002557792274337963,  -4.261079954924366e-05,  0.00020539410289292955,
    0.00046674042322056866,  0.0007155474815419535,   0.000923769988933109,
    0.001063947272600214,    0.00111224484095961,     0.001051490673116856,
    0.0008738726853241513,   0.0005829607527209901,   0.00019475057891004812,
    -0.00026250195984931987, -0.0007497823290761434,  -0.001220150178667263,
    -0.001622753898595345,   -0.001907732379590394,   -0.002031580673692091,
    -0.001962459330979603,   -0.001684876051343878,   -0.001203173239542903,
    -0.0005433213146487112,  0.00024735571130848915,  0.001102716341621847,
    0.001942574912237195,    0.002679449770163298,    0.003226790039443198,
    0.00350797985288374,     0.003465267507061325,    0.003067689907869129,
    0.002317074851232268,    0.001251312011958126,    -5.571457791119183e-05,
    -0.001497856826718978,   -0.002944077922100312,   -0.004249083853808319,
    -0.005266457386754881,   -0.005863219698898019,   -0.005934503759098679,
    -0.005416893078984233,   -0.004298981685020867,   -0.002627856281118731,
    -0.0005104863113570743,  0.001890585464321562,    0.004367361005722873,
    0.006681875095681069,    0.008586067536960828,    0.009844559165355708,
    0.010258461338057223,    0.009688106938842044,    0.008072530344182706,
    0.005443661333828626,    0.001933532766952924,    -0.002226685672370183,
    -0.006716362754136612,   -0.011143585045977112,   -0.015070871345464278,
    -0.01804673399918296,    -0.019640792192533642,   -0.019479708342793927,
    -0.01728100435168847,    -0.012881848153464343,   -0.006260189568191374,
    0.002453848226484302,    0.012977687644386187,    0.02488762181226399,
    0.037641300908217525,    0.05061000408909813,     0.0631184822309337,
    0.0744894841676609,      0.08408963488148351,     0.09137316063375613,
    0.09592007240589968,     0.09746581891172171,     0.09592007240589968,
    0.09137316063375613,     0.08408963488148351,     0.0744894841676609,
    0.0631184822309337,      0.05061000408909813,     0.037641300908217525,
    0.02488762181226399,     0.012977687644386187,    0.002453848226484302,
    -0.006260189568191374,   -0.012881848153464343,   -0.01728100435168847,
    -0.019479708342793927,   -0.019640792192533642,   -0.01804673399918296,
    -0.015070871345464278,   -0.011143585045977112,   -0.006716362754136612,
    -0.002226685672370183,   0.001933532766952924,    0.005443661333828626,
    0.008072530344182706,    0.009688106938842044,    0.010258461338057223,
    0.009844559165355708,    0.008586067536960828,    0.006681875095681069,
    0.004367361005722873,    0.001890585464321562,    -0.0005104863113570743,
    -0.002627856281118731,   -0.004298981685020867,   -0.005416893078984233,
    -0.005934503759098679,   -0.005863219698898019,   -0.005266457386754881,
    -0.004249083853808319,   -0.002944077922100312,   -0.001497856826718978,
    -5.571457791119183e-05,  0.001251312011958126,    0.002317074851232268,
    0.003067689907869129,    0.003465267507061325,    0.00350797985288374,
    0.003226790039443198,    0.002679449770163298,    0.001942574912237195,
    0.001102716341621847,    0.00024735571130848915,  -0.0005433213146487112,
    -0.001203173239542903,   -0.001684876051343878,   -0.001962459330979603,
    -0.002031580673692091,   -0.001907732379590394,   -0.001622753898595345,
    -0.001220150178667263,   -0.0007497823290761434,  -0.00026250195984931987,
    0.00019475057891004812,  0.0005829607527209901,   0.0008738726853241513,
    0.001051490673116856,    0.00111224484095961,     0.001063947272600214,
    0.000923769988933109,    0.0007155474815419535,   0.00046674042322056866,
    0.00020539410289292955,  -4.261079954924366e-05,  -0.0002557792274337963,
    -0.0004185372882990475,  -0.0005220107915314061,  -0.0005640586573530344,
    -0.0005486459358485326,  -0.0004846972431710153,  -0.000384606843541242,
    -0.0002625950786391531,  -0.0001330934823425633,  -9.31586700287633e-06,
    9.786543948186687e-05,   0.00018066472184016216,  0.00023472353902483607,
    0.00025906551384469005,  0.0002557208106832978,   0.00022910241913686485,
    0.00018523101798219584,  0.0001309078981397285,   7.292740108925049e-05,
    1.7403798665162165e-05,  -3.0734647616127785e-05, -6.805645647660092e-05,
    -9.273886275005421e-05,  -0.00010449861612992377, -0.0001043758375396436,
    -9.441564730999897e-05,  -7.729650587147542e-05,  -5.595255894272177e-05,
    -3.3230762718393935e-05, -1.1613587342489047e-05, 6.97374524326707e-06,
    2.1264660313211453e-05,  3.0665461942635624e-05,  3.5195449107763685e-05,
    3.5371989770634556e-05,  3.206256580192389e-05,   2.632579943221675e-05,
    1.926098507930709e-05,   1.188135334293442e-05,   5.0209684210692555e-06,
    -7.204121956516945e-07,  -4.995316704921293e-06,  -7.694335419666139e-06,
    -8.907508763610574e-06,  -8.870571595013051e-06,  -7.905373240961229e-06,
    -6.362732948042674e-06,  -4.5741202082198554e-06, -2.81623846121205e-06,
    -1.2902018702267198e-06, -1.1483994090604456e-07, 6.680266474451356e-07,
    1.0795917050509872e-06,  1.1850710582464755e-06,  1.0733252454078762e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_am_48khz_medium = {
    1.038136393033702e-06,   8.794112605191627e-07,   2.1065931473477533e-07,
    -9.705664611583984e-07,  -2.448301029208209e-06,  -3.7834822059414996e-06,
    -4.396882831906802e-06,  -3.737785624911898e-06,  -1.503121710693995e-06,
    2.158325165567165e-06,   6.536807892898041e-06,   1.0417513961320616e-05,
    1.2333010303775552e-05,  1.0983389832097483e-05,  5.728365839896614e-06,
    -2.9962061243516055e-06, -1.3499728394169158e-05, -2.3021991247234863e-05,
    -2.8319518003772845e-05, -2.656749480042126e-05,  -1.636637774015797e-05,
    1.4442825441835153e-06,  2.3472678363806346e-05,  4.418355721977541e-05,
    5.707285788621728e-05,   5.642043245079505e-05,   3.920941373835889e-05,
    6.657518807387653e-06,   -3.5195163063504944e-05, -7.622572030141905e-05,
    -0.00010435331541412922, -0.00010869730134751495, -8.303162325408658e-05,
    -2.8561988083100298e-05, 4.4935448578946486e-05,  0.00012027071962629182,
    0.000176389990346907,    0.00019372513576845993,  0.00016010827077154018,
    7.56266715626336e-05,    -4.5185215484873e-05,    -0.00017492291402939464,
    -0.0002788574631879509,  -0.0003235300188572928,  -0.00028643918081691346,
    -0.00016422595962590697, 2.3229004120487477e-05,  0.0002346232663959632,
    0.00041538901730687414,  0.0005108684474922163,   0.0004815563349876092,
    0.00031642306226581704,  4.0278202951029195e-05,  -0.00028777758941685215,
    -0.0005856820625238926,  -0.0007677650894397356,  -0.00076786747651607,
    -0.0005603141077270511,  -0.00017261256640289558, 0.0003147808341515447,
    0.0007833138754331861,   0.001103659283545839,    0.001169611920235356,
    0.000930083671657954,    0.000410152623417385,    -0.0002860077803849679,
    -0.0009934071932862247,  -0.001523367719626008,   -0.001711686521010686,
    -0.001466042312975538,   -0.0007996455625085011,  0.00015965982086101787,
    0.001190216945769907,    0.002025158173399049,    0.002418855791803885,
    0.002215312244433842,    0.001400254520692141,    0.00012105645425837645,
    -0.001334469790181176,   -0.00259927611324711,    -0.003316253746655596,
    -0.00323454313242195,    -0.00228798477582559,    -0.0006328300889623854,
    0.001369704448700325,    0.003227254791030399,    0.004432821467513995,
    0.004597520948774678,    0.00356607285104646,     0.001482648307117336,
    -0.001215477688175858,   -0.003882262635555514,   -0.00581104885823946,
    -0.006414140209110614,   -0.005389895128389029,   -0.002832276564073134,
    0.0007516950219411215,   0.004530605271539903,    0.007531269095788078,
    0.008877583930113092,    0.008029570801202585,    0.004960891017700145,
    0.00022272040731143112,  -0.005134322766074253,   -0.009775213436272221,
    -0.012392328295586971,   -0.012045382820156755,   -0.008446862085388774,
    -0.002115526376038364,   0.005654635896028094,    0.013022687375292724,
    0.017992296786629062,    0.018890023264909864,    0.01482578018278799,
    0.006025301070445223,    -0.006055833468581161,   -0.018884768101639984,
    -0.02926217503987198,    -0.0339242548599949,     -0.030221401755408307,
    -0.01673407740958937,    0.006309088913560339,    0.03691165083054279,
    0.07153097324151325,     0.1056143873513247,      0.1343566405825648,
    0.15353659492402572,     0.16027099469297174,     0.15353659492402572,
    0.1343566405825648,      0.1056143873513247,      0.07153097324151325,
    0.03691165083054279,     0.006309088913560339,    -0.01673407740958937,
    -0.030221401755408307,   -0.0339242548599949,     -0.02926217503987198,
    -0.018884768101639984,   -0.006055833468581161,   0.006025301070445223,
    0.01482578018278799,     0.018890023264909864,    0.017992296786629062,
    0.013022687375292724,    0.005654635896028094,    -0.002115526376038364,
    -0.008446862085388774,   -0.012045382820156755,   -0.012392328295586971,
    -0.009775213436272221,   -0.005134322766074253,   0.00022272040731143112,
    0.004960891017700145,    0.008029570801202585,    0.008877583930113092,
    0.007531269095788078,    0.004530605271539903,    0.0007516950219411215,
    -0.002832276564073134,   -0.005389895128389029,   -0.006414140209110614,
    -0.00581104885823946,    -0.003882262635555514,   -0.001215477688175858,
    0.001482648307117336,    0.00356607285104646,     0.004597520948774678,
    0.004432821467513995,    0.003227254791030399,    0.001369704448700325,
    -0.0006328300889623854,  -0.00228798477582559,    -0.00323454313242195,
    -0.003316253746655596,   -0.00259927611324711,    -0.001334469790181176,
    0.00012105645425837645,  0.001400254520692141,    0.002215312244433842,
    0.002418855791803885,    0.002025158173399049,    0.001190216945769907,
    0.00015965982086101787,  -0.0007996455625085011,  -0.001466042312975538,
    -0.001711686521010686,   -0.001523367719626008,   -0.0009934071932862247,
    -0.0002860077803849679,  0.000410152623417385,    0.000930083671657954,
    0.001169611920235356,    0.001103659283545839,    0.0007833138754331861,
    0.0003147808341515447,   -0.00017261256640289558, -0.0005603141077270511,
    -0.00076786747651607,    -0.0007677650894397356,  -0.0005856820625238926,
    -0.00028777758941685215, 4.0278202951029195e-05,  0.00031642306226581704,
    0.0004815563349876092,   0.0005108684474922163,   0.00041538901730687414,
    0.0002346232663959632,   2.3229004120487477e-05,  -0.00016422595962590697,
    -0.00028643918081691346, -0.0003235300188572928,  -0.0002788574631879509,
    -0.00017492291402939464, -4.5185215484873e-05,    7.56266715626336e-05,
    0.00016010827077154018,  0.00019372513576845993,  0.000176389990346907,
    0.00012027071962629182,  4.4935448578946486e-05,  -2.8561988083100298e-05,
    -8.303162325408658e-05,  -0.00010869730134751495, -0.00010435331541412922,
    -7.622572030141905e-05,  -3.5195163063504944e-05, 6.657518807387653e-06,
    3.920941373835889e-05,   5.642043245079505e-05,   5.707285788621728e-05,
    4.418355721977541e-05,   2.3472678363806346e-05,  1.4442825441835153e-06,
    -1.636637774015797e-05,  -2.656749480042126e-05,  -2.8319518003772845e-05,
    -2.3021991247234863e-05, -1.3499728394169158e-05, -2.9962061243516055e-06,
    5.728365839896614e-06,   1.0983389832097483e-05,  1.2333010303775552e-05,
    1.0417513961320616e-05,  6.536807892898041e-06,   2.158325165567165e-06,
    -1.503121710693995e-06,  -3.737785624911898e-06,  -4.396882831906802e-06,
    -3.7834822059414996e-06, -2.448301029208209e-06,  -9.705664611583984e-07,
    2.1065931473477533e-07,  8.794112605191627e-07,   1.038136393033702e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_am_48khz_default = {
    2.1607500524414242e-06,  3.648186224356099e-06,   3.4458224128778633e-06,
    7.32243094779288e-07,    -3.897404018842063e-06,  -8.229696641128388e-06,
    -9.28524951141529e-06,   -5.019084550926317e-06,  3.9798895701857915e-06,
    1.3913814324145088e-05,  1.9067277269410335e-05,  1.4731632802104159e-05,
    4.207706302800592e-07,   -1.8535470194431412e-05, -3.24677624278529e-05,
    -3.187452975617821e-05,  -1.3068633362840313e-05, 1.810625950598723e-05,
    4.7185391437232965e-05,  5.724046639376387e-05,   3.7970468841745955e-05,
    -6.846939476828497e-06,  -5.8215383991846096e-05, -8.917018568679948e-05,
    -7.813982493356587e-05,  -2.2161212626365377e-05, 5.753960167527779e-05,
    0.0001223120704997693,   0.0001338996700706151,   7.55678316339507e-05,
    -3.4549373928362514e-05, -0.00014674742836233196, -0.0002009764975216331,
    -0.00015760119222311505, -2.254537693580155e-05,  0.00014790953995734047,
    0.00026880724841783977,  0.00026739272402098794,  0.00012422173486204805,
    -0.00010769649208012375, -0.000319601245955453,   -0.00039622477490214693,
    -0.0002762013198348951,  7.038045904731264e-06,   0.0003287264812513672,
    0.0005253416514399959,   0.0004754805100259905,   0.00017007389112178899,
    -0.0002668881545460216,  -0.0006250679741819706,  -0.000706529766875959,
    -0.00043141450803485954, 0.0001043252327833881,   0.0006559430065449602,
    0.000938558771809452,    0.0007708974421711239,   0.00018311302226105934,
    -0.0005723764604907817,  -0.001124803320314178,   -0.001163480146946765,
    -0.0006065814794836496,  0.0003289651443825341,   0.001204660462830053,
    0.001561773578059665,    0.001156536527852159,    0.00011087525079300024,
    -0.001109165882439915,   -0.001895504402268842,   -0.001796021504967041,
    -0.0007648315705343181,  0.0007698011359911288,   0.002074716433669463,
    0.002456357178408999,    0.001621488231568698,    -0.0001300131126010411,
    -0.001997102917869672,   -0.003036495285473908,   -0.002631580172529995,
    -0.0008417623851739508,  0.001559189377620872,    0.003406833203790789,
    0.003702256374435917,    0.002139218908219556,    -0.0006703413278896614,
    -0.003417543649620603,   -0.004695497012803909,   -0.003707226374384622,
    -0.0007321132323194208,  0.002910498106389902,    0.005430980168928636,
    0.005434296016560735,    0.002668838580506597,    -0.001732707838725774,
    -0.005692330906505094,   -0.007149055875790528,   -0.005107875006155807,
    -0.00025217313918838343, 0.005233570847864411,    0.00861954665732045,
    0.007959569760689405,    0.003159724506582352,    -0.003778912478491389,
    -0.009550689660902544,   -0.011078544311067135,   -0.007097484823281476,
    0.001001069046517549,    0.009567537740895391,    0.014273235231507836,
    0.012215147324632789,    0.003558905664803106,    -0.00815015917504094,
    -0.017322412416431877,   -0.018851330830367517,   -0.01074503991066582,
    0.004406893307656548,    0.01999694875505355,     0.02800281873897705,
    0.022685780114853147,    0.003819819593988851,    -0.022084188251343236,
    -0.043372296414092,      -0.047320015389505504,   -0.02523759761434157,
    0.023411707918403954,    0.08965726525250088,     0.15720234527992327,
    0.2075309252030192,      0.22613279373924522,     0.2075309252030192,
    0.15720234527992327,     0.08965726525250088,     0.023411707918403954,
    -0.02523759761434157,    -0.047320015389505504,   -0.043372296414092,
    -0.022084188251343236,   0.003819819593988851,    0.022685780114853147,
    0.02800281873897705,     0.01999694875505355,     0.004406893307656548,
    -0.01074503991066582,    -0.018851330830367517,   -0.017322412416431877,
    -0.00815015917504094,    0.003558905664803106,    0.012215147324632789,
    0.014273235231507836,    0.009567537740895391,    0.001001069046517549,
    -0.007097484823281476,   -0.011078544311067135,   -0.009550689660902544,
    -0.003778912478491389,   0.003159724506582352,    0.007959569760689405,
    0.00861954665732045,     0.005233570847864411,    -0.00025217313918838343,
    -0.005107875006155807,   -0.007149055875790528,   -0.005692330906505094,
    -0.001732707838725774,   0.002668838580506597,    0.005434296016560735,
    0.005430980168928636,    0.002910498106389902,    -0.0007321132323194208,
    -0.003707226374384622,   -0.004695497012803909,   -0.003417543649620603,
    -0.0006703413278896614,  0.002139218908219556,    0.003702256374435917,
    0.003406833203790789,    0.001559189377620872,    -0.0008417623851739508,
    -0.002631580172529995,   -0.003036495285473908,   -0.001997102917869672,
    -0.0001300131126010411,  0.001621488231568698,    0.002456357178408999,
    0.002074716433669463,    0.0007698011359911288,   -0.0007648315705343181,
    -0.001796021504967041,   -0.001895504402268842,   -0.001109165882439915,
    0.00011087525079300024,  0.001156536527852159,    0.001561773578059665,
    0.001204660462830053,    0.0003289651443825341,   -0.0006065814794836496,
    -0.001163480146946765,   -0.001124803320314178,   -0.0005723764604907817,
    0.00018311302226105934,  0.0007708974421711239,   0.000938558771809452,
    0.0006559430065449602,   0.0001043252327833881,   -0.00043141450803485954,
    -0.000706529766875959,   -0.0006250679741819706,  -0.0002668881545460216,
    0.00017007389112178899,  0.0004754805100259905,   0.0005253416514399959,
    0.0003287264812513672,   7.038045904731264e-06,   -0.0002762013198348951,
    -0.00039622477490214693, -0.000319601245955453,   -0.00010769649208012375,
    0.00012422173486204805,  0.00026739272402098794,  0.00026880724841783977,
    0.00014790953995734047,  -2.254537693580155e-05,  -0.00015760119222311505,
    -0.0002009764975216331,  -0.00014674742836233196, -3.4549373928362514e-05,
    7.55678316339507e-05,    0.0001338996700706151,   0.0001223120704997693,
    5.753960167527779e-05,   -2.2161212626365377e-05, -7.813982493356587e-05,
    -8.917018568679948e-05,  -5.8215383991846096e-05, -6.846939476828497e-06,
    3.7970468841745955e-05,  5.724046639376387e-05,   4.7185391437232965e-05,
    1.810625950598723e-05,   -1.3068633362840313e-05, -3.187452975617821e-05,
    -3.24677624278529e-05,   -1.8535470194431412e-05, 4.207706302800592e-07,
    1.4731632802104159e-05,  1.9067277269410335e-05,  1.3913814324145088e-05,
    3.9798895701857915e-06,  -5.019084550926317e-06,  -9.28524951141529e-06,
    -8.229696641128388e-06,  -3.897404018842063e-06,  7.32243094779288e-07,
    3.4458224128778633e-06,  3.648186224356099e-06,   2.1607500524414242e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_am_48khz_wide = {
    -3.5071727919435936e-06, -1.577553144627151e-05,  -2.1482669387178596e-05,
    -1.3169046796734133e-05, 1.5068906681551206e-05,  4.2395923591187914e-05,
    3.567390330339738e-05,   -1.820255108429127e-05,  -8.168254569669846e-05,
    -8.372880449603284e-05,  1.117111329857678e-05,   0.00014053242230182764,
    0.00016971050975244013,  1.807531414640963e-05,   -0.00022044925757432564,
    -0.00031024519276445344, -8.801434573466284e-05,  0.00031900971599470047,
    0.000524517345667232,    0.0002247609230907611,   -0.0004274094683264592,
    -0.0008327132554746915,  -0.00046286053937524,    0.0005279132324523084,
    0.00125389612842499,     0.0008456031238470485,   -0.0005912323200525235,
    -0.001803471708301287,   -0.001424959839319189,   0.0005740009321289628,
    0.002490459826237241,    0.002261466175080441,    -0.00041604426383236586,
    -0.003314849884479907,   -0.003424710962184576,   3.709896609511708e-05,
    0.004265423007048223,    0.004995710870510345,    0.0006682662712434276,
    -0.005318732546172992,   -0.00707423314867501,    -0.001840909141848907,
    0.006438965444853757,    0.009796061485420355,    0.003679114926854312,
    -0.007579344008017787,   -0.013372943055015494,   -0.006489310926429928,
    0.008685166859028346,    0.018189069168062386,    0.010814059265151655,
    -0.009697471243640584,   -0.02505771581715689,    -0.01779779029025321,
    0.01055824271193626,     0.036057897777166864,    0.03050525660740487,
    -0.01121529481046665,    -0.0583757370714541,     -0.06118460178075966,
    0.011627287887033638,    0.14268964985804442,     0.2692897306204814,
    0.3215656616561925,      0.2692897306204814,      0.14268964985804442,
    0.011627287887033638,    -0.06118460178075966,    -0.0583757370714541,
    -0.01121529481046665,    0.03050525660740487,     0.036057897777166864,
    0.01055824271193626,     -0.01779779029025321,    -0.02505771581715689,
    -0.009697471243640584,   0.010814059265151655,    0.018189069168062386,
    0.008685166859028346,    -0.006489310926429928,   -0.013372943055015494,
    -0.007579344008017787,   0.003679114926854312,    0.009796061485420355,
    0.006438965444853757,    -0.001840909141848907,   -0.00707423314867501,
    -0.005318732546172992,   0.0006682662712434276,   0.004995710870510345,
    0.004265423007048223,    3.709896609511708e-05,   -0.003424710962184576,
    -0.003314849884479907,   -0.00041604426383236586, 0.002261466175080441,
    0.002490459826237241,    0.0005740009321289628,   -0.001424959839319189,
    -0.001803471708301287,   -0.0005912323200525235,  0.0008456031238470485,
    0.00125389612842499,     0.0005279132324523084,   -0.00046286053937524,
    -0.0008327132554746915,  -0.0004274094683264592,  0.0002247609230907611,
    0.000524517345667232,    0.00031900971599470047,  -8.801434573466284e-05,
    -0.00031024519276445344, -0.00022044925757432564, 1.807531414640963e-05,
    0.00016971050975244013,  0.00014053242230182764,  1.117111329857678e-05,
    -8.372880449603284e-05,  -8.168254569669846e-05,  -1.820255108429127e-05,
    3.567390330339738e-05,   4.2395923591187914e-05,  1.5068906681551206e-05,
    -1.3169046796734133e-05, -2.1482669387178596e-05, -1.577553144627151e-05,
    -3.5071727919435936e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_cw_12khz_500hz = {
    -1.745769653350998e-06,  -2.4034662633105478e-06, -3.166934203658225e-06,
    -4.036345850649966e-06,  -5.009442377889394e-06,  -6.0812585622646156e-06,
    -7.2438702732705265e-06, -8.48617198544756e-06,   -9.793691784394125e-06,
    -1.114845133932145e-05,  -1.252887817898863e-05,  -1.3909777324394355e-05,
    -1.5262368894140848e-05, -1.6554397702534487e-05, -1.7750320114364213e-05,
    -1.8811572504746745e-05, -1.9696924601177392e-05, -2.0362919764729012e-05,
    -2.0764402908064574e-05, -2.085513526258133e-05,  -2.058849361172826e-05,
    -1.9918249921543453e-05, -1.8799425544888607e-05, -1.7189212377609156e-05,
    -1.5047951530329137e-05, -1.2340158278412126e-05, -9.035580296245507e-06,
    -5.110274503340198e-06,  -5.476862826632407e-07,  4.66028658950476e-06,
    1.0512264203778865e-05,  1.69964088965275e-05,    2.4089524456642393e-05,
    3.175625137329453e-05,   3.994837953659179e-05,   4.86042996719123e-05,
    5.7648614306228974e-05,  6.699192821388864e-05,   7.653083705777508e-05,
    8.61481313225701e-05,    9.571323062865125e-05,   0.00010508286112282704,
    0.00011410198587679971,  0.00012260499510371542,  0.00013041715955187857,
    0.0001373563466838177,   0.0001432349952361844,   0.00014786233952561315,
    0.00015104687046794607,  0.00015259901576909486,  0.00015233401718631914,
    0.00015007497821443587,  0.00014565605109171224,  0.0001389257277171186,
    0.000129750194998363,    0.00011801671138374931,  0.00010363695794530912,
    8.655031444948227e-05,   6.672700844603661e-05,   4.417108359340198e-05,
    1.8923132281830246e-05,  -8.937262828660507e-06,  -3.928943342134521e-05,
    -7.196993023263242e-05,  -0.00010677127984999794, -0.00014344124277902481,
    -0.00018168261828420198, -0.00022115363696737636, -0.00026146897665670494,
    -0.00030220143096462823, -0.0003428842528759275,  -0.00038301418799970244,
    -0.00042205520372859526, -0.0004594429115740672,  -0.0004945896704795916,
    -0.0005268903490574219,  -0.0005557287145629949,  -0.000580484406137462,
    -0.0006005404395450796,  -0.000615291180446799,   -0.0006241507133282184,
    -0.0006265615236863537,  -0.0006220034021243002,  -0.0006100024707542485,
    -0.0005901402249133395,  -0.000562062476794965,   -0.0005254880823247048,
    -0.00048021732859099004, -0.00042613985649035284, -0.0003632419920674062,
    -0.0002916133604071936,  -0.00021145265794207901, -0.00012307246271842798,
    -2.6902967561489355e-05, 7.650547180939795e-05,   0.00018648107284052715,
    0.0003022307350067436,   0.00042284159799228094,  0.0005472841120554019,
    0.0006744166683631933,   0.0008029918207000059,   0.000931664112416238,
    0.001058999503963729,    0.001183486377049586,    0.001303548071539328,
    0.001417556890975493,    0.001523849492185863,    0.001620743554182833,
    0.001706555601657092,    0.001779619839104261,    0.001838307833253546,
    0.001881048864252577,    0.001906350750256716,    0.001912820935920393,
    0.001899187623026619,    0.001864320711337323,    0.001807252309902153,
    0.001727196573705161,    0.001623568617811333,    0.001496002261224762,
    0.001344366355584063,    0.001168779459663087,    0.0009696226294472819,
    0.0007475501053139361,   0.0005034976925179967,   0.0002386886486973177,
    -4.536308765129458e-05,  -0.0003468524709609601,  -0.0006636858426810502,
    -0.0009934864363194834,  -0.001333602954806406,   -0.001681121250614273,
    -0.002032879106810877,   -0.002385484083968787,   -0.002735334363961301,
    -0.003078642487512679,   -0.003411461848323157,   -0.003729715773049778,
    -0.004029228983788775,   -0.004305761208369794,   -0.00455504267412657,
    -0.004772811193232186,   -0.004954850522543639,   -0.005097029658534142,
    -0.005195342708621676,   -0.0052459489643185,     -0.005245212789386214,
    -0.005189742927804109,   -0.005076430832025161,   -0.004902487611840258,
    -0.004665479208288793,   -0.004363359405485047,   -0.003994500305970252,
    -0.003557719912193628,   -0.003052306477867537,   -0.002478039318076868,
    -0.001835205795947606,   -0.001124614236144511,   -0.0003476025511772799,
    0.0004939575948873479,   0.001397661219559087,    0.002360575142880309,
    0.003379247842224281,    0.004449724040778997,    0.005567563982652421,
    0.006727867300395598,    0.007925301333879328,    0.009154133713390838,
    0.010408268975049722,    0.011681288933679312,    0.012966496497597364,
    0.014256962571875753,    0.015545575661902853,    0.016825093757973444,
    0.018088198054502132,    0.019327548034637973,    0.020535837432835987,
    0.02170585057455279,     0.022830518583861405,    0.023902974946555196,
    0.02491660991830529,     0.025865123274662994,    0.02674257491211869,
    0.027543432826935114,    0.02826261802091052,     0.028895545910379388,
    0.02943816384635607,     0.029886984389453242,    0.030239114022692967,
    0.030492277028167567,    0.030644834299249947,    0.030695796908219566,
    0.030644834299249947,    0.030492277028167567,    0.030239114022692967,
    0.029886984389453242,    0.02943816384635607,     0.028895545910379388,
    0.02826261802091052,     0.027543432826935114,    0.02674257491211869,
    0.025865123274662994,    0.02491660991830529,     0.023902974946555196,
    0.022830518583861405,    0.02170585057455279,     0.020535837432835987,
    0.019327548034637973,    0.018088198054502132,    0.016825093757973444,
    0.015545575661902853,    0.014256962571875753,    0.012966496497597364,
    0.011681288933679312,    0.010408268975049722,    0.009154133713390838,
    0.007925301333879328,    0.006727867300395598,    0.005567563982652421,
    0.004449724040778997,    0.003379247842224281,    0.002360575142880309,
    0.001397661219559087,    0.0004939575948873479,   -0.0003476025511772799,
    -0.001124614236144511,   -0.001835205795947606,   -0.002478039318076868,
    -0.003052306477867537,   -0.003557719912193628,   -0.003994500305970252,
    -0.004363359405485047,   -0.004665479208288793,   -0.004902487611840258,
    -0.005076430832025161,   -0.005189742927804109,   -0.005245212789386214,
    -0.0052459489643185,     -0.005195342708621676,   -0.005097029658534142,
    -0.004954850522543639,   -0.004772811193232186,   -0.00455504267412657,
    -0.004305761208369794,   -0.004029228983788775,   -0.003729715773049778,
    -0.003411461848323157,   -0.003078642487512679,   -0.002735334363961301,
    -0.002385484083968787,   -0.002032879106810877,   -0.001681121250614273,
    -0.001333602954806406,   -0.0009934864363194834,  -0.0006636858426810502,
    -0.0003468524709609601,  -4.536308765129458e-05,  0.0002386886486973177,
    0.0005034976925179967,   0.0007475501053139361,   0.0009696226294472819,
    0.001168779459663087,    0.001344366355584063,    0.001496002261224762,
    0.001623568617811333,    0.001727196573705161,    0.001807252309902153,
    0.001864320711337323,    0.001899187623026619,    0.001912820935920393,
    0.001906350750256716,    0.001881048864252577,    0.001838307833253546,
    0.001779619839104261,    0.001706555601657092,    0.001620743554182833,
    0.001523849492185863,    0.001417556890975493,    0.001303548071539328,
    0.001183486377049586,    0.001058999503963729,    0.000931664112416238,
    0.0008029918207000059,   0.0006744166683631933,   0.0005472841120554019,
    0.00042284159799228094,  0.0003022307350067436,   0.00018648107284052715,
    7.650547180939795e-05,   -2.6902967561489355e-05, -0.00012307246271842798,
    -0.00021145265794207901, -0.0002916133604071936,  -0.0003632419920674062,
    -0.00042613985649035284, -0.00048021732859099004, -0.0005254880823247048,
    -0.000562062476794965,   -0.0005901402249133395,  -0.0006100024707542485,
    -0.0006220034021243002,  -0.0006265615236863537,  -0.0006241507133282184,
    -0.000615291180446799,   -0.0006005404395450796,  -0.000580484406137462,
    -0.0005557287145629949,  -0.0005268903490574219,  -0.0004945896704795916,
    -0.0004594429115740672,  -0.00042205520372859526, -0.00038301418799970244,
    -0.0003428842528759275,  -0.00030220143096462823, -0.00026146897665670494,
    -0.00022115363696737636, -0.00018168261828420198, -0.00014344124277902481,
    -0.00010677127984999794, -7.196993023263242e-05,  -3.928943342134521e-05,
    -8.937262828660507e-06,  1.8923132281830246e-05,  4.417108359340198e-05,
    6.672700844603661e-05,   8.655031444948227e-05,   0.00010363695794530912,
    0.00011801671138374931,  0.000129750194998363,    0.0001389257277171186,
    0.00014565605109171224,  0.00015007497821443587,  0.00015233401718631914,
    0.00015259901576909486,  0.00015104687046794607,  0.00014786233952561315,
    0.0001432349952361844,   0.0001373563466838177,   0.00013041715955187857,
    0.00012260499510371542,  0.00011410198587679971,  0.00010508286112282704,
    9.571323062865125e-05,   8.61481313225701e-05,    7.653083705777508e-05,
    6.699192821388864e-05,   5.7648614306228974e-05,  4.86042996719123e-05,
    3.994837953659179e-05,   3.175625137329453e-05,   2.4089524456642393e-05,
    1.69964088965275e-05,    1.0512264203778865e-05,  4.66028658950476e-06,
    -5.476862826632407e-07,  -5.110274503340198e-06,  -9.035580296245507e-06,
    -1.2340158278412126e-05, -1.5047951530329137e-05, -1.7189212377609156e-05,
    -1.8799425544888607e-05, -1.9918249921543453e-05, -2.058849361172826e-05,
    -2.085513526258133e-05,  -2.0764402908064574e-05, -2.0362919764729012e-05,
    -1.9696924601177392e-05, -1.8811572504746745e-05, -1.7750320114364213e-05,
    -1.6554397702534487e-05, -1.5262368894140848e-05, -1.3909777324394355e-05,
    -1.252887817898863e-05,  -1.114845133932145e-05,  -9.793691784394125e-06,
    -8.48617198544756e-06,   -7.2438702732705265e-06, -6.0812585622646156e-06,
    -5.009442377889394e-06,  -4.036345850649966e-06,  -3.166934203658225e-06,
    -2.4034662633105478e-06, -1.745769653350998e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_nbfm_48khz_default = {
    1.9277719817615837e-06,  -4.5107282407341555e-06, -1.5319078023527347e-05,
    -2.0079375668947412e-05, -4.351527449440411e-06,  2.5923031942455566e-05,
    3.6882874639014647e-05,  -2.3112073751160472e-07, -6.033137102320248e-05,
    -6.814639664215184e-05,  1.803244292430151e-05,   0.00012458568297962698,
    0.00010879106351307719,  -6.7829723012333e-05,    -0.00023205491981197207,
    -0.0001476621136977937,  0.00017661392949706666,  0.0003927433132049522,
    0.00015947836863912525,  -0.00037956550005911055, -0.000606260511438185,
    -0.00010001647555582935, 0.0007154886138201649,   0.0008524057058138115,
    -9.633597573626291e-05,  -0.001217739647475765,   -0.00108076528532407,
    0.0005146663229144471,   0.001900721207214824,    0.001201646030709959,
    -0.001251812815516515,   -0.00274318538138377,    -0.001080688923265213,
    0.002402373257443985,    0.003670501480992899,    0.0005390133030144432,
    -0.004039621876103981,   -0.004538448651328712,   0.0006411286306441234,
    0.006194397113670877,    0.005120170950232804,    -0.002708336881423586,
    -0.008835911545056961,   -0.005093488503290364,   0.005941494089373106,
    0.011860051691680347,    0.00401810250340998,     -0.010677033850319512,
    -0.015088406472779056,   -0.001266895816780304,   0.017418374895381672,
    0.018281588587042267,    -0.004196350369412497,   -0.027193019429939493,
    -0.02116530777011954,    0.014618284088550022,    0.04287538763508758,
    0.02346620101433979,     -0.03726902555403264,    -0.07646930747816408,
    -0.024951561444899475,   0.12281092886081257,     0.2871613755795918,
    0.35879837994055896,     0.2871613755795918,      0.12281092886081257,
    -0.024951561444899475,   -0.07646930747816408,    -0.03726902555403264,
    0.02346620101433979,     0.04287538763508758,     0.014618284088550022,
    -0.02116530777011954,    -0.027193019429939493,   -0.004196350369412497,
    0.018281588587042267,    0.017418374895381672,    -0.001266895816780304,
    -0.015088406472779056,   -0.010677033850319512,   0.00401810250340998,
    0.011860051691680347,    0.005941494089373106,    -0.005093488503290364,
    -0.008835911545056961,   -0.002708336881423586,   0.005120170950232804,
    0.006194397113670877,    0.0006411286306441234,   -0.004538448651328712,
    -0.004039621876103981,   0.0005390133030144432,   0.003670501480992899,
    0.002402373257443985,    -0.001080688923265213,   -0.00274318538138377,
    -0.001251812815516515,   0.001201646030709959,    0.001900721207214824,
    0.0005146663229144471,   -0.00108076528532407,    -0.001217739647475765,
    -9.633597573626291e-05,  0.0008524057058138115,   0.0007154886138201649,
    -0.00010001647555582935, -0.000606260511438185,   -0.00037956550005911055,
    0.00015947836863912525,  0.0003927433132049522,   0.00017661392949706666,
    -0.0001476621136977937,  -0.00023205491981197207, -6.7829723012333e-05,
    0.00010879106351307719,  0.00012458568297962698,  1.803244292430151e-05,
    -6.814639664215184e-05,  -6.033137102320248e-05,  -2.3112073751160472e-07,
    3.6882874639014647e-05,  2.5923031942455566e-05,  -4.351527449440411e-06,
    -2.0079375668947412e-05, -1.5319078023527347e-05, -4.5107282407341555e-06,
    1.9277719817615837e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_nbfm_48khz_narrow = {
    5.393482570306968e-06,   1.564679563765125e-05,  2.293663776932332e-05,
    2.8866269677385187e-05,  2.054779405391215e-05,  -2.288110385773534e-06,
    -3.923298587346396e-05,  -7.53088079866658e-05,  -9.093540732765729e-05,
    -6.519660686181518e-05,  8.301252471678069e-06,  0.00011316774534789771,
    0.0002069862327906659,   0.00023469900696317754, 0.00015298712334627885,
    -4.0380581093818134e-05, -0.0002891616038728193, -0.0004860164673271111,
    -0.0005108544105945928,  -0.0002895917221199088, 0.00015084828874388604,
    0.0006624097906042551,   0.001012581710668425,   0.0009767145456032887,
    0.00045477701516239837,  -0.0004406758969903951, -0.001379089181305225,
    -0.001915319690868248,   -0.001679237423409411,  -0.0005789774069940651,
    0.001080737714325994,    0.002646094534284217,   0.003345421236173618,
    0.0026347836708863,      0.0005155028088177845,  -0.002338282080082132,
    -0.004747581643115024,   -0.005477142272858606,  -0.003810411863881471,
    -2.8144838762984714e-06, 0.004628836802018469,   0.008099192436861264,
    0.008543682062972605,    0.005114329121156527,   -0.00141461789926839,
    -0.008669854161797394,   -0.013443874493752915,  -0.01299594686171194,
    -0.006401890152498525,   0.004645632759308542,   0.016047748146366572,
    0.022619742512552526,    0.02015630989560078,    0.007499035098230087,
    -0.012255206008048936,   -0.03204205901963064,   -0.04273510295886218,
    -0.03616319997841993,    -0.008238637300808512,  0.03895689531166456,
    0.09699980886495528,     0.15310048153355837,    0.19369383055082456,
    0.2084998599046358,      0.19369383055082456,    0.15310048153355837,
    0.09699980886495528,     0.03895689531166456,    -0.008238637300808512,
    -0.03616319997841993,    -0.04273510295886218,   -0.03204205901963064,
    -0.012255206008048936,   0.007499035098230087,   0.02015630989560078,
    0.022619742512552526,    0.016047748146366572,   0.004645632759308542,
    -0.006401890152498525,   -0.01299594686171194,   -0.013443874493752915,
    -0.008669854161797394,   -0.00141461789926839,   0.005114329121156527,
    0.008543682062972605,    0.008099192436861264,   0.004628836802018469,
    -2.8144838762984714e-06, -0.003810411863881471,  -0.005477142272858606,
    -0.004747581643115024,   -0.002338282080082132,  0.0005155028088177845,
    0.0026347836708863,      0.003345421236173618,   0.002646094534284217,
    0.001080737714325994,    -0.0005789774069940651, -0.001679237423409411,
    -0.001915319690868248,   -0.001379089181305225,  -0.0004406758969903951,
    0.00045477701516239837,  0.0009767145456032887,  0.001012581710668425,
    0.0006624097906042551,   0.00015084828874388604, -0.0002895917221199088,
    -0.0005108544105945928,  -0.0004860164673271111, -0.0002891616038728193,
    -4.0380581093818134e-05, 0.00015298712334627885, 0.00023469900696317754,
    0.0002069862327906659,   0.00011316774534789771, 8.301252471678069e-06,
    -6.519660686181518e-05,  -9.093540732765729e-05, -7.53088079866658e-05,
    -3.923298587346396e-05,  -2.288110385773534e-06, 2.054779405391215e-05,
    2.8866269677385187e-05,  2.293663776932332e-05,  1.564679563765125e-05,
    5.393482570306968e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_nbfm_48khz_medium = {
    -5.530449779781351e-06,  -2.5308375578385043e-06, 7.928169170296357e-06,
    2.5598305815871566e-05,  3.79099455387038e-05,    2.735883453991548e-05,
    -1.2693658078157597e-05, -6.320023025979524e-05,  -8.2545087857802e-05,
    -3.511357005363849e-05,  6.990994666632786e-05,   0.00016368473316314368,
    0.00015395011461005447,  1.5008491054882366e-06,  -0.0002186912463633938,
    -0.00033715440011670815, -0.00020640162240860628, 0.00015551671294544315,
    0.0005169581745579796,   0.0005608496103026962,   0.00013685020819644944,
    -0.000547091841457904,   -0.0009867385572179877,  -0.0007263031253204085,
    0.00022905974346602279,  0.001275615522548726,    0.0015526470194967,
    0.0006066342994292424,   -0.001105742167469761,   -0.002355344519661275,
    -0.001975050914950891,   0.0001381954290962202,   0.002664193332392948,
    0.003610487761004575,    0.001813318894527532,    -0.001893941155176974,
    -0.004903579415149639,   -0.004584305570651741,   -0.0004496256530693049,
    0.004962514632275058,    0.007510039261738947,    0.004494148808545888,
    -0.002822961903508798,   -0.009404336908799054,   -0.00974121160509993,
    -0.002230346916434444,   0.008703070047624011,    0.014914397586889176,
    0.010328374609769774,    -0.003720011904109407,   -0.017946010680164208,
    -0.020798575707174933,   -0.007184764644683504,   0.01594853216585926,
    0.032173090096190606,    0.02608800011763807,     -0.004375116025081597,
    -0.042464858093809094,   -0.05920604187423584,    -0.029775082253241745,
    0.049653373289790186,    0.15543447682612616,     0.24568765170027457,
    0.2810985731771908,      0.24568765170027457,     0.15543447682612616,
    0.049653373289790186,    -0.029775082253241745,   -0.05920604187423584,
    -0.042464858093809094,   -0.004375116025081597,   0.02608800011763807,
    0.032173090096190606,    0.01594853216585926,     -0.007184764644683504,
    -0.020798575707174933,   -0.017946010680164208,   -0.003720011904109407,
    0.010328374609769774,    0.014914397586889176,    0.008703070047624011,
    -0.002230346916434444,   -0.00974121160509993,    -0.009404336908799054,
    -0.002822961903508798,   0.004494148808545888,    0.007510039261738947,
    0.004962514632275058,    -0.0004496256530693049,  -0.004584305570651741,
    -0.004903579415149639,   -0.001893941155176974,   0.001813318894527532,
    0.003610487761004575,    0.002664193332392948,    0.0001381954290962202,
    -0.001975050914950891,   -0.002355344519661275,   -0.001105742167469761,
    0.0006066342994292424,   0.0015526470194967,      0.001275615522548726,
    0.00022905974346602279,  -0.0007263031253204085,  -0.0009867385572179877,
    -0.000547091841457904,   0.00013685020819644944,  0.0005608496103026962,
    0.0005169581745579796,   0.00015551671294544315,  -0.00020640162240860628,
    -0.00033715440011670815, -0.0002186912463633938,  1.5008491054882366e-06,
    0.00015395011461005447,  0.00016368473316314368,  6.990994666632786e-05,
    -3.511357005363849e-05,  -8.2545087857802e-05,    -6.320023025979524e-05,
    -1.2693658078157597e-05, 2.735883453991548e-05,   3.79099455387038e-05,
    2.5598305815871566e-05,  7.928169170296357e-06,   -2.5308375578385043e-06,
    -5.530449779781351e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_nbfm_48khz_wide = {
    -2.8505079859283148e-06, -9.246392908856991e-06,  5.093666089078658e-06,
    8.124564118862033e-07,   -1.023599385221021e-05,  1.8665570152801428e-05,
    -1.7851401534002604e-05, 1.5693724534384633e-06,  2.7418405874545582e-05,
    -5.406188950645124e-05,  5.6006240577849375e-05,  -1.7203265117780473e-05,
    -5.6214349650968587e-05, 0.0001290278263873756,   -0.00014855021488258162,
    7.472319873473335e-05,   8.527088033900611e-05,   -0.0002609004993332876,
    0.00034015621436808425,  -0.0002293374575005453,  -7.586276249789563e-05,
    0.000452579575165833,    -0.0006843492202750441,  0.000569203257670746,
    -5.63342491654526e-05,   -0.0006690161608651822,  0.001225037581100181,
    -0.001211619211318302,   0.00045638338190016144,  0.0008075079896502532,
    -0.001964437045486201,   0.002283934495932697,    -0.001335106916802693,
    -0.0006679938302300356,  0.002820657231079662,    -0.003888529710456769,
    0.002959993534298529,    -7.063911277331358e-05,  -0.003581763944390904,
    0.006058347127625346,    -0.005637520235938367,   0.001870972677871826,
    0.003858771470456602,    -0.00871590515444449,    0.009712626538535728,
    -0.005387456253554891,   -0.003017041046923811,   0.01165350354779992,
    -0.01565955071638862,    0.01166601994978358,     -2.087072300984741e-05,
    -0.014546777614216149,   0.024508651404141633,    -0.022982749374920595,
    0.007614515094583276,    0.017007823537382713,    -0.039882584956105124,
    0.047322726708676315,    -0.028624650134087465,   -0.01866489951244347,
    0.08631176955585884,     -0.15717053825432362,    0.21078945285094786,
    0.769249842897209,       0.21078945285094786,     -0.15717053825432362,
    0.08631176955585884,     -0.01866489951244347,    -0.028624650134087465,
    0.047322726708676315,    -0.039882584956105124,   0.017007823537382713,
    0.007614515094583276,    -0.022982749374920595,   0.024508651404141633,
    -0.014546777614216149,   -2.087072300984741e-05,  0.01166601994978358,
    -0.01565955071638862,    0.01165350354779992,     -0.003017041046923811,
    -0.005387456253554891,   0.009712626538535728,    -0.00871590515444449,
    0.003858771470456602,    0.001870972677871826,    -0.005637520235938367,
    0.006058347127625346,    -0.003581763944390904,   -7.063911277331358e-05,
    0.002959993534298529,    -0.003888529710456769,   0.002820657231079662,
    -0.0006679938302300356,  -0.001335106916802693,   0.002283934495932697,
    -0.001964437045486201,   0.0008075079896502532,   0.00045638338190016144,
    -0.001211619211318302,   0.001225037581100181,    -0.0006690161608651822,
    -5.63342491654526e-05,   0.000569203257670746,    -0.0006843492202750441,
    0.000452579575165833,    -7.586276249789563e-05,  -0.0002293374575005453,
    0.00034015621436808425,  -0.0002609004993332876,  8.527088033900611e-05,
    7.472319873473335e-05,   -0.00014855021488258162, 0.0001290278263873756,
    -5.6214349650968587e-05, -1.7203265117780473e-05, 5.6006240577849375e-05,
    -5.406188950645124e-05,  2.7418405874545582e-05,  1.5693724534384633e-06,
    -1.7851401534002604e-05, 1.8665570152801428e-05,  -1.023599385221021e-05,
    8.124564118862033e-07,   5.093666089078658e-06,   -9.246392908856991e-06,
    -2.8505079859283148e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_fm_384kHz_narrow = {
    -5.4522697572868805e-06, 6.4788793358186455e-06,  2.2674517413417863e-06,
    -1.2965208375061879e-05, 1.0085791343150014e-05,  8.729488964051954e-06,
    -2.292915559971716e-05,  1.073397135597764e-05,   1.9288024976974782e-05,
    -3.1343413913554576e-05, 5.985931042072199e-06,   2.9545842863513663e-05,
    -3.148055919345385e-05,  -2.5449977359881725e-06, 2.830197910657774e-05,
    -1.6835865886738335e-05, -3.958820225120119e-06,  -2.650744933183905e-06,
    1.2416533610413833e-05,  2.71091958581626e-05,    -8.444037973237976e-05,
    3.9856739132931346e-05,  0.0001328477193564217,   -0.00023121985150726713,
    2.223459817776781e-05,   0.00036855436388448303,  -0.0004345029913169957,
    -0.00011841271231694514, 0.0007902185097917927,   -0.0006439997532870016,
    -0.000495408122870916,   0.001432664459556811,    -0.0007493586940922776,
    -0.001246969223242424,   0.002280269178281429,    -0.000568257492539657,
    -0.002513131147789242,   0.003234881095105395,    0.0001548340070736291,
    -0.004402297760992246,   0.004086525672052217,    0.001739022993156708,
    -0.006953762838812431,   0.004489778498309858,    0.004554418297936785,
    -0.010105626292886312,   0.003939005788525524,    0.009029614250063591,
    -0.013678283213724168,   0.001710007148005008,    0.015737152466079818,
    -0.017381352847317434,   -0.003342135503420641,   0.025730279770037525,
    -0.020846757294463173,   -0.01355826662810172,    0.04185477592883185,
    -0.023683884857123822,   -0.03626331831651475,    0.07603387809168995,
    -0.02554631459230131,    -0.12211906253362707,    0.28733829494178403,
    0.640471191284656,       0.28733829494178403,     -0.12211906253362707,
    -0.02554631459230131,    0.07603387809168995,     -0.03626331831651475,
    -0.023683884857123822,   0.04185477592883185,     -0.01355826662810172,
    -0.020846757294463173,   0.025730279770037525,    -0.003342135503420641,
    -0.017381352847317434,   0.015737152466079818,    0.001710007148005008,
    -0.013678283213724168,   0.009029614250063591,    0.003939005788525524,
    -0.010105626292886312,   0.004554418297936785,    0.004489778498309858,
    -0.006953762838812431,   0.001739022993156708,    0.004086525672052217,
    -0.004402297760992246,   0.0001548340070736291,   0.003234881095105395,
    -0.002513131147789242,   -0.000568257492539657,   0.002280269178281429,
    -0.001246969223242424,   -0.0007493586940922776,  0.001432664459556811,
    -0.000495408122870916,   -0.0006439997532870016,  0.0007902185097917927,
    -0.00011841271231694514, -0.0004345029913169957,  0.00036855436388448303,
    2.223459817776781e-05,   -0.00023121985150726713, 0.0001328477193564217,
    3.9856739132931346e-05,  -8.444037973237976e-05,  2.71091958581626e-05,
    1.2416533610413833e-05,  -2.650744933183905e-06,  -3.958820225120119e-06,
    -1.6835865886738335e-05, 2.830197910657774e-05,   -2.5449977359881725e-06,
    -3.148055919345385e-05,  2.9545842863513663e-05,  5.985931042072199e-06,
    -3.1343413913554576e-05, 1.9288024976974782e-05,  1.073397135597764e-05,
    -2.292915559971716e-05,  8.729488964051954e-06,   1.0085791343150014e-05,
    -1.2965208375061879e-05, 2.2674517413417863e-06,  6.4788793358186455e-06,
    -5.4522697572868805e-06,
};

const IQSampleCoeff FilterParameters::jj1bdx_fm_384kHz_medium = {
    2.8328482949954486e-06,  6.141881597013998e-07,   -6.244962813071538e-06,
    1.2336076254373857e-05,  -1.6067759124212123e-05, 1.458200706745993e-05,
    -6.4621656818942864e-06, -7.03882915097524e-06,   2.1776404908936834e-05,
    -3.1935227835568505e-05, 3.246662077973992e-05,   -2.177510123508774e-05,
    3.2596655621763757e-06,  1.546222810914484e-05,   -2.5873241836440103e-05,
    2.3275312131591376e-05,  -1.0609360807480892e-05, -1.1637337580462239e-06,
    -2.4477080851946023e-06, 3.0961716346882166e-05,  -7.986393590500023e-05,
    0.000126077408601507,    -0.00013247811475077434, 6.2774664779133e-05,
    9.698962117501437e-05,   -0.0003190053063615446,  0.0005273265022631839,
    -0.0006131604245404801,  0.0004729545818667055,   -5.983170297091911e-05,
    -0.0005707743663529218,  0.001244432034790122,    -0.001697843859036205,
    0.00165868865836569,     -0.0009571979525031253,  -0.0003678186172674884,
    0.00201476594856467,     -0.00345515656683351,    0.004071775891941385,
    -0.003373167707934465,   0.001220884451021449,    0.002015872483619562,
    -0.005457219427811576,   0.007901589183068857,    -0.00818414438315869,
    0.00561323081393209,     -0.0003436977141801438,  -0.006462633716048877,
    0.01279525117878761,     -0.01628777488742466,    0.014948562058360829,
    -0.007932998400013394,   -0.003888259218001231,   0.0177863210306901,
    -0.02957664542516207,    0.034533299399329934,    -0.028617620877754078,
    0.009703012928972445,    0.021558005081470023,    -0.0615093986981978,
    0.10403403248774067,     -0.14177735670160516,    0.16776904128221753,
    0.8229663084721561,      0.16776904128221753,     -0.14177735670160516,
    0.10403403248774067,     -0.0615093986981978,     0.021558005081470023,
    0.009703012928972445,    -0.028617620877754078,   0.034533299399329934,
    -0.02957664542516207,    0.0177863210306901,      -0.003888259218001231,
    -0.007932998400013394,   0.014948562058360829,    -0.01628777488742466,
    0.01279525117878761,     -0.006462633716048877,   -0.0003436977141801438,
    0.00561323081393209,     -0.00818414438315869,    0.007901589183068857,
    -0.005457219427811576,   0.002015872483619562,    0.001220884451021449,
    -0.003373167707934465,   0.004071775891941385,    -0.00345515656683351,
    0.00201476594856467,     -0.0003678186172674884,  -0.0009571979525031253,
    0.00165868865836569,     -0.001697843859036205,   0.001244432034790122,
    -0.0005707743663529218,  -5.983170297091911e-05,  0.0004729545818667055,
    -0.0006131604245404801,  0.0005273265022631839,   -0.0003190053063615446,
    9.698962117501437e-05,   6.2774664779133e-05,     -0.00013247811475077434,
    0.000126077408601507,    -7.986393590500023e-05,  3.0961716346882166e-05,
    -2.4477080851946023e-06, -1.1637337580462239e-06, -1.0609360807480892e-05,
    2.3275312131591376e-05,  -2.5873241836440103e-05, 1.546222810914484e-05,
    3.2596655621763757e-06,  -2.177510123508774e-05,  3.246662077973992e-05,
    -3.1935227835568505e-05, 2.1776404908936834e-05,  -7.03882915097524e-06,
    -6.4621656818942864e-06, 1.458200706745993e-05,   -1.6067759124212123e-05,
    1.2336076254373857e-05,  -6.244962813071538e-06,  6.141881597013998e-07,
    2.8328482949954486e-06,
};

// End of FilterParameters.cpp
