# Build Static Env Data

This workflow generates static environmental fields that can later be used to enhance various types of "biological" data for fitting SDMs. 

## Pipeline overview

![static-env](./images/static-env.drawio.svg)

The pipeline is defined in [`dvc.yaml`](../../dvc.yaml) for running locally with DVC using a [Docker container](./Dockerfile) built by the the `static-env` service as defined in [`docker-compose.yaml`](../../docker-compose.yaml) with `data/` mapped as `/data/`.

## Elements of Pipeline

This pipeline currently contains two distinct calculations of static environmental grids: 

- Distance to ports
- Distance to seamounts

Both of these use the same underlying distance calculation code implemented in `R` and only the input points representing the desired features change between stages.

### PORTS

This stage calculates a grid representing distance to the nearest port. These currently only include ports on the east coast of the U.S.

#### Script

See `./distance_from_points.r` in the general FaCeT R code directory for instructions on the function this pipeline calls to do the work.

#### Step

This step runs for a single input file containing coordinates for the relevant ports to be measured.

##### DVC

For DVC the ports data is in `data/ports/US_longline_ports_geocoded.csv`, and outputs the netCDF grid to `data/ports/US_longline_ports_distance.nc`. The script is called within via Docker-Compose (`docker-compose run static_env ./R/point_distance.r /data/ports/US_longline_ports_geocoded.csv --x_min -100 --x_max -30 --y_min 0 --y_max 50 --res 0.25 /data/ports/US_longline_ports_distance.nc`) where the arguments following `--` together define the desired spatial bounds and resolution of the output grid. 

### SEAMOUNTS

This step is identical to the ports step above except that it takes in a `.shp` file from `data/seamounts/Seamounts.shp` and outputs the gridded netCDF to `data/seamounts/seamounts_distance.nc`. The input seamounts dataset is global so we trim it significantly to improve computation time.

This is the end of the `static_env` workflow. The output grids are used in various `xxx_enhance` stages throughout the pipeline.