#!/usr/bin/env Rscript

## we need some custom functions we've written so have to figure out how to load those in rocker
files.sources <- list.files('/home/facet/R/functions/', full.names = TRUE)
invisible(sapply(files.sources, source))

library(argparser, quietly=TRUE)
suppressMessages(library(dplyr, quietly=TRUE))
suppressMessages(library(data.table, quietly=TRUE))
library(logger, quietly=TRUE)

# Build up our command line argument parser
p <- arg_parser("QC marker tag data and write to CSV")
p <- add_argument(p, "input_xls", help="path to XLS file output from iccat_download pipeline")
p <- add_argument(p, "bathy_file", help="Gridded global bathymetry file as netcdf")
p <- add_argument(p, "output_csv", help="path to output processed species-specific marker tag data (as csv)")
p <- add_argument(p, "--output_qc", help="path to output qc file to")

# parse the arguments
args <- parse_args(p)
for (i in 1:length(args)){
  log_info(paste0('Args include ', names(args)[i],': ', args[[i]]))
}

res_list <- qc_iccat(args$input_xls, args$bathy_file)
log_info('Resulting QC data looks like {res_list$ctag[1,]}')

## write to CSV
data.table::fwrite(res_list$ctag, file = args$output_csv, sep=',', col.names = TRUE, row.names = FALSE)
log_info('File written to {args$output_csv}')

## write to QC, if specified
if ('output_qc' %in% names(args)){
  if (!is.na(args$output_qc)){
    data.table::fwrite(res_list$qc, file = args$output_qc, col.names = TRUE, row.names = FALSE)
    log_info('QC written to {args$output_qc}')
  }
} 

