#!/usr/bin/env Rscript

files.sources <- list.files('/home/facet/R/functions/', full.names = TRUE)
invisible(sapply(files.sources, source))

library(argparser, quietly=TRUE)
suppressMessages(library(dplyr, quietly=TRUE))
library(logger, quietly=TRUE)

# Build up our command line argument parser
p <- arg_parser("Get marker tag files from ICCAT and unrar")

p <- add_argument(p, "input_file", help="Path to a text file containing the desired species code")
p <- add_argument(p, "output_file", help="Path to output file that results from unzipped (un-rar) file")

# parse the arguments
args <- parse_args(p)
for (i in 1:length(args)){
  log_info(paste0('Args include ', names(args)[i],': ', args[[i]]))
}

## download iccat, unrar and output temp file
unrar_temp <- get_iccat(args$input_file)

## copy the temp file to the desired output dir
file.copy(unrar_temp, args$output_file)
log_info('Data downloaded and unrar extracted to {args$output_file}')


