#!/usr/bin/env Rscript

## we need some custom functions we've written so have to figure out how to load those in rocker
#files.sources <- list.files('/home/facet/R/', full.names = TRUE)
#sapply(files.sources, source)

library(argparser, quietly=TRUE)
library(dplyr, quietly=TRUE)
library(data.table, quietly=TRUE)

# Build up our command line argument parser
p <- arg_parser("Combine ICCAT species into one CSV")
p <- add_argument(p, "species_csv_dir", help="dir containing processed species-specific marker tag data as csv, output from iccat_qc")
p <- add_argument(p, "combine_csv_dir", help="dir to output combined, processed ICCAT data to")

# parse the arguments
args <- parse_args(p)
print(args)

## identify input file
species_in <- list.files(args$species_csv_dir, full.names = TRUE)
species_in <- species_in[grep('csv', species_in)]

## combine the list elements
ctag <- lapply(species_in, FUN=function(x){
  data.table::fread(x, sep = ',' , header = TRUE)
}) %>% do.call(rbind, .)

## output full dataset to csv
out_name <- paste0(args$combine_csv_dir, '/iccat_combine.csv')
if (!file.exists(out_name)){
  data.table::fwrite(ctag, file = out_name, sep=',', col.names = TRUE, row.names = FALSE, append = TRUE)
} else{
  data.table::fwrite(ctag, file = out_name, sep=',', col.names = FALSE, row.names = FALSE, append = TRUE)
}
