# HYCOM environmental data

This workflow gets data from the HYbrid Coordinate Ocean Model (HYCOM; hycom.org) and also calculates some derived environmental variables. These data are used to enhance data on species presence/absence that is used, in a species distribution modeling framework, to build quantitative relationships between species presence and environmental characteristics as well as predicting habitat suitability. We use HYCOM here because it is a relatively high-resolution (0.08 deg), daily (although can be multi-hourly), data-assimilating, global modeling framework.

![`hycom`](./hycom.drawio.svg)

## Fetch HYCOM NetCDFs

We use a python script to get most of the HYCOM environmental data.

### Script

See `python_tools` directory for details on `get_hycom.py`.

### Pipelines

We have 5 different variables we want to download for HYCOM, so we have a seperate pipeline for each.

- `salinity` @ depth of 0 - `hycom_salinity.pipeline.json`
- `surf_el` - `hycom_surf_el.pipeline.json`
- `water_temp` @ depth of 0 aka SST - `hycom_sst.pipeline.json`
- `water_u` @ depth of 0 - `hycom_water_u.pipeline.json`
- `water_v` @ depth of 0 - `hycom_water_v.pipeline.json`

The pipelines take in the ticks from the `daily_cron` pipeline (or `pseudo_daily_cron` for testing) to specify when data should be downloaded for. 

## Calculate derived variables

The above python scripts are used for getting HYCOM data, but often we need to calculate derived environmental metrics from these data. We do those calculations in `R`.

### Pipelines

We have 4 different derived calculations to conduct, so we have a seperate pipeline for each.

- `calc_sst_sd` calculates SD of input SST grid - `calc_sst_sd.pipeline.json`
- `calc_surf_el_sd` calculates SD of input surf_el (SSH) grid - `calc_surf_el_sd.pipeline.json`
- `calc_hycom_eke` uses `water_u` and `water_v` (u, v currents from HYCOM) to calculate Eddy Kinetic Energy (EKE) - `calc_hycom_eke.pipeline.json`
- `calc_hycom_3d` downloads additional HYCOM data (salinity) and calculates isothermal layer depth (ILD) and buoyancy frequency (n2) - `calc_hycom_3d.pipeline.json`

The `calc_hycom_3d` pipeline takes in the ticks from the `daily_cron` pipeline (or `pseudo_daily_cron` for testing) to specify when data should be downloaded for. The other pipelines take in `glob/*` of their respective HYCOM data products which are also based on `daily_cron` ticks.