#!/usr/bin/env Rscript

## we need some custom functions we've written so have to figure out how to load those in rocker
#files.sources <- list.files('/home/facet/R/', full.names = TRUE)
#sapply(files.sources, source)

library(argparser, quietly=TRUE)
#library(tidyverse, quietly=TRUE)
library(raster, quietly=TRUE)
library(stringr, quietly=TRUE)

# Build up our command line argument parser
p <- arg_parser("Calculate eddy kinetic energy (eke) from input water_u and v velocities (as NetCDF)")
p <- add_argument(p, "in_dir_u", help="path to NetCDF containing source water_u data")
p <- add_argument(p, "in_dir_v", help="path to NetCDF containing source water_v data")
p <- add_argument(p, "out_dir", help="path to output resulting NetCDF")

# parse the arguments
args <- parse_args(p)
print(args)

## identify input file
u_files <- list.files(args$in_dir_u, full.names = TRUE, recursive = TRUE)
u_files <- u_files[grep('nc', u_files)]
print(u_files)

v_files <- list.files(args$in_dir_v, full.names = TRUE, recursive = TRUE)
v_files <- v_files[grep('nc', v_files)]
print(v_files)

names_in <- list.files(args$in_dir_u, full.names = FALSE, recursive = TRUE)
names_in <- names_in[grep('nc', names_in)]
  
for (i in 1:length(u_files)){
  
  ## read in data, here raster only reads surface which is desired behavior
  water_u <- raster::raster(u_files[i])
  water_v <- raster::raster(v_files[i])
  
  ## eddy kinetic energy
  eke <- (water_u[[1]] ^ 2 + water_v[[1]] ^ 2) / 2
  
  ## build output name
  out_name <- substr(names_in[i], 1,
                     stringr::str_locate_all(names_in[i], '.nc')[[1]][1] - 1)
  if (nrow(stringr::str_locate_all(out_name, '/')[[1]]) != 0){
    out_dir <- paste0(args$out_dir, '/',
                      substr(out_name, 1,
                             stringr::str_locate_all(out_name, '/')[[1]][1]))
  }
  
  if (!dir.exists(out_dir)) dir.create(out_dir, recursive = TRUE)
  
  out_name <- substr(out_name, stringr::str_locate_all(out_name, '/')[[1]][1] + 1,
                     stringr::str_locate_all(out_name, '/')[[1]][1] + 10)
  
  out_name <- paste0(out_dir, '/', out_name, '_eke.nc')
  print(out_name)
  
  ## write to CSV
  writeRaster(eke, file = out_name, format='CDF', overwrite=TRUE)
  print(paste0('File written to ', out_name, '.'))
  
}