#!/usr/bin/env Rscript

## we need some custom functions we've written so have to figure out how to load those in rocker
#files.sources <- list.files('/home/rstudio/R/functions/', full.names = TRUE)
#invisible(sapply(files.sources, source))

library(argparser, quietly=TRUE)
suppressMessages(library(dplyr, quietly=TRUE))
suppressMessages(library(data.table, quietly=TRUE))
library(logger, quietly=TRUE)

# Build up our command line argument parser
p <- arg_parser("Build 2d track from eTUFF")
p <- add_argument(p, "input_etuff", help="path to etuff file containing standardized etag data")
p <- add_argument(p, "--overwrite", default = FALSE, help="logical, indicating whether to overwrite an existing output file if it exists. Default is FALSE.")
p <- add_argument(p, "output_csv", help="path to output processed etag track data (as csv)")

# parse the arguments
args <- parse_args(p)
for (i in 1:length(args)){
  logger::log_info(paste0('Args include ', names(args)[i],': ', args[[i]]))
}

args$overwrite <- as.logical(args$overwrite)

if (file.exists(args$output_csv) & !args$overwrite){
  logger::log_warn(paste0('Output file already exists and optional input argument overwrite == FALSE. If you want to overwrite the existing file, set overwrite == TRUE.'))
  
} else{
  devtools::load_all('./R/tags2etuff/')
  
  track <- interp_track(args$input_etuff, what_tz = 'UTC')
  
  logger::log_info('Resulting track data looks like {track[1,]}')
  
  ## make output directory, if necessary
  out_dir <- substr(args$output_csv, 1, max(unlist(stringr::str_locate_all(args$output_csv, '/'))))
  if (!dir.exists(out_dir)) dir.create(out_dir)
  
  ## write to CSV
  data.table::fwrite(track, file = args$output_csv, sep=',', col.names = TRUE, row.names = FALSE)
  logger::log_info('File written to {args$output_csv}')
  
}
