## Get CMEMS grids for enhancing and predicting
library(raster); library(rgdal)

bathy <- raster::raster('./data/bathy/global_bathy_0.01.nc')
bathy <- raster::rotate(bathy)
rugosity <- raster::raster('./data/enhance/bathy_rugosity.nc', varname = 'rugosity')
rugosity <- raster::rotate(rugosity)
atl <- rgdal::readOGR(dsn='./data/shapefiles/',layer='atlantic') ## prevents great lakes and others that bathymetry mask doesn't catch

tVec <- seq.POSIXt(as.POSIXct('1993-01-01'), as.POSIXct('2019-12-31'), by='day')
times <- list()
t0 <- Sys.time()
for (i in 1275:1461){
#for (i in 1275:length(tVec)){
  t1 <- Sys.time()
  #base_url <- 'https://nrt.cmems-du.eu/motu-web/Motu'
  base_url <- 'https://my.cmems-du.eu/motu-web/Motu'
  
  temp_service_id <- 'GLOBAL_MULTIYEAR_PHY_001_030-TDS'
  #temp_service_id <- 'GLOBAL_REANALYSIS_PHY_001_031-TDS'

  temp_product_id <- 'cmems_mod_glo_phy_my_0.083_P1D-m'
  #temp_product_id <- 'global-reanalysis-phy-001-031-grepv2-mnstd-daily'
  
  vars <- c('thetao', 'so', 'uo', 'vo','zos','mlotst')#,'bottomT')
  #vars <- c('thetao_mean', 'so_mean', 'uo_mean', 'vo_mean','zos_mean','mlotst_mean')#,'bottomT')
  
  xl <- c(-100, -5); yl <- c(10, 55)

  write_dir <- paste0('~/work/EnvData/glorys_daily/', lubridate::year(tVec[i]), '/')
  out_name <- paste0(write_dir, temp_product_id, '_', format(as.Date(tVec[i]), '%Y-%m-%d'), '.nc')
  raster_out <- paste0(write_dir, temp_product_id, '_', format(as.Date(tVec[i]), '%Y-%m-%d'), '.grd')
  
  if (!dir.exists(write_dir)) dir.create(write_dir, recursive=TRUE)
  if (file.exists(raster_out)) next

  ## Get the data using motu
  if (!file.exists(out_name)){
    dstatus <- try(system(paste0('python3 -m motuclient --motu ', base_url,
                               ' --service-id ', temp_service_id,
                               ' --product-id ', temp_product_id,
                               ' --longitude-min ', xl[1], ' --longitude-max ', xl[2],
                               ' --latitude-min ', yl[1], ' --latitude-max ', yl[2],
                               ' --date-min ', format(as.Date(tVec[i]), '%Y-%m-%d', tz='UTC'), ' --date-max ', format(as.Date(tVec[i]), '%Y-%m-%d'), 
                               ' --depth-min 0 --depth-max 1', 
                               ' --variable ', vars[1],
                               ' --variable ', vars[2],
                               ' --variable ', vars[3],
                               ' --variable ', vars[4],
                               ' --variable ', vars[5],
                               ' --variable ', vars[6],
                               #' --variable ', vars[7],
                               ' --out-dir ', write_dir,
                               ' --out-name ', out_name,
                               ' --user cbraun1 --pwd "ygXZ69fR"')), TRUE)
  } else{
    dstatus <- NA
  }
  
  if (file.exists(out_name) & class(dstatus) != 'try-error'){
    logger::log_info(paste0('Download complete for ', tVec[i]))
  } else{
    logger::log_warn(paste0('Download failed for ', tVec[i], '. Skipping.'))
    next
  }
t2 <- Sys.time()
  ## iterate through vars and manipulate/write out as needed
  for (tt in 1:length(vars)){
    if (tt == 1){
      r <- raster::raster(out_name, varname=vars[tt])
    } else{
      r <- raster::stack(r, raster::raster(out_name, varname=vars[tt]))
    }
  } 
  # r is now a stack of the following variables:
  #> names(r)
  #[1] "Temperature"                        
  #[2] "Salinity"                            
  #[3]"Eastward.velocity"                  
  #[4] "Northward.velocity"                  
  #[5] "Sea.surface.height"                  
  #[6] "Density.ocean.mixed.layer.thickness"
  names(r) <- c('sst','sss','u','v','ssh','mld')
  ## calc derived vars
  ## eddy kinetic energy
  log_eke <- log((r$u ^ 2 + r$v ^ 2) / 2)
  names(log_eke) <- 'log_eke'
  
  ## 3 x 3 moving window SD calc on SST, SSH, SSS
  sst_sd <- raster::focal(r$sst, w = matrix(1, nrow = 3, ncol = 3), fun = function(x) stats::sd(x, na.rm = T))
  ssh_sd <- raster::focal(r$ssh, w = matrix(1, nrow = 3, ncol = 3), fun = function(x) stats::sd(x, na.rm = T))
  sss_sd <- raster::focal(r$sss, w = matrix(1, nrow = 3, ncol = 3), fun = function(x) stats::sd(x, na.rm = T))

  # drop u and v from original raster
  r <- r[[c('sst','sss','ssh','mld')]]
  
  # get bathy and rugosity
  if (!exists('bathy_r')){
    bathy_r <- raster::resample(bathy, log_eke)
    rug_r <- raster::resample(rugosity, log_eke)
    rm(bathy); rm(rugosity)
  }
  
  r <- raster::stack(r, log_eke, sst_sd, ssh_sd, sss_sd, bathy_r, rug_r)
  names(r) <- c('sst','sss','ssh','mld', 'log_eke','sst_sd','ssh_sd','sss_sd','bathy','rugosity')
  r <- raster::mask(r, atl)
  
  #writeRaster(r, filename=raster_out, format='CDF', overwrite=T)
  writeRaster(r, filename=raster_out, format='raster', overwrite=T)
  logger::log_info(paste0('Raster operations complete and written to ', raster_out))
  
  file.remove(out_name)
  rm(r); rm(ssh_sd); rm(sss_sd); rm(sst_sd); rm(log_eke)
t3 <- Sys.time()
times[[i]] <- c(t1, t2, t3)
print(i)
}
t4 <- Sys.time()

(t4-t0) / 5
lapply(times, FUN=function(x) x[2] - x[1])

write.table(paste0('#!/bin/sh'),file='try_bash2.txt', quote=F, col.names = F, row.names = F, sep='/t')

for (i in 3405:4000){
#for (i in 109:length(tVec)){
 write.table(
    paste0('C:/python27/lib/site-packages/motuclient.py --motu https://my.cmems-du.eu/motu-web/Motu --service-id GLOBAL_MULTIYEAR_PHY_001_030-TDS --product-id cmems_mod_glo_phy_my_0.083_P1D-m --longitude-min -100 --longitude-max -5 --latitude-min 10 --latitude-max 55 --date-min ',
         as.Date(tVec[i]),
         ' --date-max ',
         as.Date(tVec[i]),
         ' --depth-min 0 --depth-max 1 --variable thetao --variable so --variable uo --variable vo --variable zos --variable mlotst --out-dir \'C:/Users/Simon Thorrold/work/EnvData/\' --out-name cmems_mod_glo_phy_my_0.083_P1D-m_',
         as.Date(tVec[i]),
         '.nc --user cbraun1 --pwd ygXZ69fR'),
    file='try_bash2.txt', append=TRUE,
    quote=F, col.names = F, row.names = F, sep='/t')
  
}


x_coord <- make180(c(276.8538678081323,  315.189817585748, 303.4270830384663, 255))
y_coord <- c(9.08222226498919, 33.73466788028341, 51.59039987151572, 25)
xym <- cbind(x_coord, y_coord)
p = Polygon(xym)
ps = Polygons(list(p),1)
sps = SpatialPolygons(list(ps))
plot(r, xlim=c(-120,-40), ylim=c(10,53))
world(add=T)
plot(sps, add=T)



tVec <- seq.POSIXt(as.POSIXct('1993-01-01'), as.POSIXct('2019-12-31'), by='day')
write.table(paste0('#!/bin/sh'),file='try_bash2013_2014.txt', quote=F, col.names = F, row.names = F, sep='/t')
which(as.Date(tVec) == as.Date('2013-06-25'))
which(as.Date(tVec) == as.Date('2014-12-31'))
for (i in 7481:8035){
  #for (i in 109:length(tVec)){
  write.table(
    paste0('C:/python27/lib/site-packages/motuclient.py --motu https://my.cmems-du.eu/motu-web/Motu --service-id GLOBAL_MULTIYEAR_PHY_001_030-TDS --product-id cmems_mod_glo_phy_my_0.083_P1D-m --longitude-min -100 --longitude-max -5 --latitude-min 10 --latitude-max 55 --date-min ',
           as.Date(tVec[i]),
           ' --date-max ',
           as.Date(tVec[i]),
           ' --depth-min 0 --depth-max 1 --variable thetao --variable so --variable uo --variable vo --variable zos --variable mlotst --out-dir \'C:/Users/Simon Thorrold/work/EnvData/\' --out-name cmems_mod_glo_phy_my_0.083_P1D-m_',
           as.Date(tVec[i]),
           '.nc --user cbraun1 --pwd ygXZ69fR'),
    file='try_bash2013_2014.txt', append=TRUE,
    quote=F, col.names = F, row.names = F, sep='/t')
  
}
