#' predict from brt and calc auc
#' @param model
#' @param valdata
#' @return model AUC score
#' @source https://github.com/elhazen/EcoCast-SciAdv/

validate.brt <- function(model, valdata) {
  preds <-
    gbm::predict.gbm(model,
                valdata,
                n.trees = model$gbm.call$best.trees,
                type = 'response')
  #auc <- roc(valdata$presabs, preds)  ##using auc as validation statistic
  auc <- pROC::auc(valdata$presabs, preds)
  return(auc)
}
