#' rasterRescale
#' @param r is raster to be re-scaled
#' @return is re-scaled raster

rasterRescale <- function(r) {
  r.min = cellStats(r, "min")
  r.max = cellStats(r, "max")
  r.scale <- ((r - r.min) / (r.max - r.min) - 0.5) * 2
  return(r.scale) #(r-rmin)/(rmax-rmin)
}