plotROC <- function(truth, predicted, ...){
  pred <- ROCR::prediction(as.vector(abs(predicted)), as.vector(truth))    
  roc <- ROCR::performance(pred,"tpr","fpr")
  auc <- ROCR::performance(pred,"auc")
  plot(roc, ...)
  abline(a=0, b= 1)
  print(auc@y.values)
}
