#' @param sp_file
#' 
#' 
 
get_iccat <- function(sp_file){
  sp_code <- read.table(sp_file, sep='\t', header = F, stringsAsFactors = F)
  tfile <- tempfile(fileext = ".rar")
  download.file(paste0('https://www.iccat.int/Data/Tag/_tag', sp_code, '.7z'), tfile)
  
  ## find the filename in the rar archive then extract it
  #unrar_name <- system(paste0('unrar lb ', tfile), intern=TRUE)
  tdir <- tempdir()

  ## extract rar file to tempdir
  unrar_name <- system(paste0('unar ', tfile, ' -o ', tdir, '/'), intern=TRUE)
  unrar_name <- substr(unrar_name[2], 
                       stringr::str_locate_all(unrar_name[2], '_')[[1]][1], ## nchar of first underscore
                       stringr::str_locate_all(unrar_name[2], '.xlsx')[[1]][2]) ## nchar of .xlsx extension
  unrar_name <- paste0(tdir, '/', unrar_name)
  
  print(paste('Output', unrar_name))
  return(unrar_name)
}