#' extract the spatial standard devaition of depth to species records
#' @param inpts
#' @param rastIn
#' @return xxx

getZsd <- function(inpts, rastIn) {
  rastIn <- raster(rastIn)
  inpts2 <- inpts
  inpts2$lon[inpts2$lon <= -180] <- -180
  coordinates(inpts2) <- c('lon', 'lat')
  proj4string(inpts2) <- CRS("+proj=longlat +ellps=WGS84")
  zsd <-
    extract(
      rastIn,
      inpts2@coords,
      method = 'simple',
      na.rm = F,
      cellnumbers = F
    )
  EOVout <- cbind(inpts, zsd)
  EOVout$zsd[EOVout$lon <= -180] <- NA
  rm(inpts2, inpts)
  return(EOVout)
}
