#' extract depth in raster to species records
#' @param inpts
#' @param rastIn is input raster from which to perform the extraction from
#' @return

getZ <- function(inpts, rastIn) {
  rastIn <- raster(rastIn)
  inpts2 <- inpts
  inpts2$lon[inpts2$lon <= -180] <- -180
  coordinates(inpts2) <- c('lon', 'lat')
  proj4string(inpts2) <- CRS("+proj=longlat +ellps=WGS84")
  
  z <-
    extract(
      rastIn,
      cbind(inpts2$lon, inpts2$lat),
      method = 'simple',
      na.rm = F,
      cellnumbers = F
    )
  
  EOVout <- cbind(inpts, z)
  EOVout$z[EOVout$lon <= -180] <- NA
  rm(inpts2, inpts)
  return(EOVout)
}