#' get dates with data in a list of netcdfs
#' @param inpts
#' @param ncIn
#' @return xxx

getDateRange <- function(inpts, ncIn) {
  parsedt <- vector(mode = 'character', length(ncIn))
  for (j in 1:length(ncIn)) {
    if (varname == 'sla') {
      nc <- ncIn[j]
      parsename <- unlist(strsplit(nc, '_'))
      dtname <- substr(parsename[7], 1, 8)
      parsedt[j] <-
        as.character(strptime(dtname, format = '%Y%m%d', tz = 'UTC'))
    } else {
      nc <- ncIn[j]
      parsename <- unlist(strsplit(nc, '_'))
      parsedt[j] <- substr(parsename[abs(length(parsename))], 1, 10)
    }
  }
  startD <- format(as.POSIXct(min(inpts$dt), tz = 'UTC'), '%Y-%m-%d')
  print(paste('Ptsfile start', startD))
  endD <- format(as.POSIXct(max(inpts$dt), tz = 'UTC'), '%Y-%m-%d')
  print(paste('Ptsfile end', endD))
  if (varname == 'sla') {
    startfile <-
      which(abs(as.Date(parsedt) - as.Date(startD)) == min(abs(as.Date(parsedt) -
                                                                 as.Date(startD))))[1]
    endfile <-
      which(abs(as.Date(endD) - as.Date(parsedt)) == min(abs(as.Date(endD) -
                                                               as.Date(parsedt))))[1]
  } else {
    startfile <-
      which(abs(as.Date(parsedt) - as.Date(startD)) == min(abs(as.Date(parsedt) -
                                                                 as.Date(startD))))[1] - 1
    endfile <-
      which(abs(as.Date(endD) - as.Date(parsedt)) == min(abs(as.Date(endD) -
                                                               as.Date(parsedt))))[1]
  }
  dtIn <- ncIn[startfile:endfile]
  return(dtIn)
}
