#' define fit and evaluate functions
#' @param x
#' @param gbm.x
#' @param gbm.y
#' @param tree.com
#' @param bag.frac
#' @param lr
#' @return
#' @source https://github.com/elhazen/EcoCast-SciAdv

fit.brt <- function(x, gbm.x, gbm.y, tree.com, bag.frac, lr) {
  
  y <- gbm.step(
    x,
    gbm.x = gbm.x,
    gbm.y = gbm.y,
    family = "bernoulli",
    tree.complexity = tree.com,
    learning.rate = lr,
    bag.fraction = bag.frac
  )
  
  y$gbm.call$dataframe <- x
  return(y)
}