#' @param plocs is dataframe of actual track and contains cols id, lon, lat, date (POSIX)
#' @param bdf is binary bathy raster used to keep sims off land
#' @param reps is integer, how many simulation reps are desired
#' @param min_locs is integer, minimum number of locations in the actual data that are required for sims to take place
#' 

createCRW <- function(plocs, bdf, reps = NULL, min_locs = 10){
  
  cat("building simulations...\n")

  locs.all <- split(plocs, plocs$id)
  
  # parameterize the sims
  if (is.null(reps)) reps <- 30
  
  # binary bathy layer, 1 is water NA is land
  r <- raster::raster(bdf)
  
  for (tt in 1:length(locs.all)){
    x <- locs.all[[tt]]
    
    if (any(x$lon < 0) & raster::extent(r)@xmax > 181){
      lon2 <- make360(x$lon)
      x$bdf <- raster::extract(r, cbind(lon2, x$lat))
      x <- dplyr::filter(x, bdf == 1) # get rid of points on land
      
    } else{
      x$bdf <- raster::extract(r, cbind(x$lon, x$lat))
      x <- dplyr::filter(x, bdf == 1) # get rid of points on land
    }
    
    
    if (nrow(x) > min_locs){
      
      # build trajectories to base sims on
      tr1 <- adehabitatLT::as.ltraj(cbind(x$lon, x$lat), date=x$date, id=as.factor(x$id),
                                    proj4string = sp::CRS("+proj=longlat +datum=WGS84 +ellps=WGS84 +towgs84=0,0,0"))
      
      
      crw <- adehabitatLT::NMs.randomCRW(na.omit(tr1), rangles=TRUE, rdist=TRUE,
                                         #treatment.func = myfunc,
                                         #treatment.par = map,
                                         constraint.func = consfun,
                                         constraint.par = bdf, nrep = reps)
      # simulate
      #tmp <- adehabitatLT::testNM(crw)
      tmp <- try(R.utils::withTimeout(adehabitatLT::testNM(crw), timeout = 100, onTimeout = "error"), TRUE)
      
      if (class(tmp) == 'try-error') {
        logger::log_warn(paste0('Sims for ', x$id[1], ' failed gracefully. It is being skipped.'))
        next
      }
      
      for (i in 1:length(tmp)){
        id.i <- names(tmp)[i]
        for (b in 1:length(tmp[[i]])){
          tmp.b <- tmp[[i]][[b]]
          names(tmp.b) <- c('lon','lat','date')
          tmp.b$id <- id.i
          tmp.b$id.iter <- paste(id.i, '.', b, sep='')
          tmp.b$instrument_name <- x$instrument_name[1]
          #tmp.b$date <- as.Date(tmp.b$date)
          #tmp.b$bathy <- raster::extract(bathy, cbind(tmp.b$lon, tmp.b$lat))
          #tmp.b <- tmp.b[which(!is.na(tmp.b$bathy)),]
          
          if (b == 1){
            tmp_out <- tmp.b
          } else {
            if(!exists('tmp_out')){
              tmp_out <- tmp.b
            } else{
              tmp_out <- rbind(tmp_out, tmp.b)
            }
          }
        } # end b loop
      } # end i loop
      tmp_out
    }
    
    if (!exists('tmp_out')){
      next
    } else if (!exists('tmp_out_rbind')){
      tmp_out_rbind <- tmp_out
    } else{
      tmp_out_rbind <- rbind(tmp_out_rbind, tmp_out)
    }
  }
  
  if (exists('tmp_out_rbind')){
    tmp_out <- tmp_out_rbind
  } else{
    tmp_out <- NULL
  }
  
  return(tmp_out)
  
}