consfun <- function(x, par){
  ## first convert x to the class SpatialPointsDataFrame
  coordinates(x) <- x[,1:2]

  if (!identicalCRS(x, par)){
    proj4string(x) <- CRS("+proj=longlat +ellps=WGS84")
    proj4string(par) <- CRS("+proj=longlat +ellps=WGS84") 
  }
  ## then use the function over from the package sp
  ## to check whether all points in x are located inside
  ## the study area
  ov <- over(x, geometry(par))
  return(all(!is.na(ov)))
}
