#' rasterRescale (-1 to r.max) 
#' this is for when swordfish = 0, we still rescale the min value to -1 to fit within app.R color range 
#' @param r is raster to rescale
#' @return re-scaled raster
#' 
#' @seealso http://stackoverflow.com/questions/12959371/how-to-scale-numbers-values

alt_rasterRescale <- function(r) {
  r.min = cellStats(r, "min")
  r.max = cellStats(r, "max")
  r.scale <- -1 + (r.max--1) * (r - r.min) / (r.max - r.min)
  return(r.scale)
}