
#' PlotEcoCast
#' @param r
#' @param get_date
#' @param wd is working directory
#' @param leg is logical. Do you want a legend?
#' @param scalbar is logical. Do you want a scale bar?
#' @param rescal
#' @param risk
#' @param spp
#' @param version
#' @param contourval
#' @param addLCA is logical. Do you want PLCA plotted?
#' @param addtext
#' @param type
#' @return ecocast plot written out as .png

PlotEcoCast <-
  function(r,
           get_date,
           wd = getwd(),
           leg = TRUE,
           scalbar = FALSE,
           rescal = FALSE,
           risk = risk,
           spp = namesrisk,
           version = "_V1",
           contourval = NA,
           addLCA = FALSE,
           addtext = TRUE,
           type = "ecocast") {
    
  ####### produce png
  png(paste(wd,"/EcoCast_",paste(risk,collapse="_"),'_',get_date,version,'.png',sep=''),width=960,height=1100,units='px',pointsize=20)
  par(mar=c(3,3,.5,.5),las=1,font=2)
  
  if (rescal){
    r<-rasterRescale(r)
  } 
  if (rescal==F && version=="_mean"){
    r=alt_rasterRescale(r)
  }
  
  if (version=="_se") {
    zlimits<-c(-0.1,0.1)
    col=SeCols(255)}
  
  if(type=="ecocast" && version=="_mean") {
    zlimits=c(-1,1)
    col=EcoCols(255)}
  
  if(type=="bycast" && version=="_mean") {
    zlimits=c(-1,0)
    col=ByCols(255)}
  
  if (leg) {
    image.plot(r,col=col,xlim=c(-130,-115),ylim=c(30,47),zlim=zlimits)
  } else {
    image(r,col=col,xlim=c(-130,-115),ylim=c(30,47),zlim=zlimits) ## PRESABS
  }
  if(scalbar) scalebar(110,type="bar", divs=2,below="kilometers")
  if(!is.na(contourval)) {
    SP <- rasterToPolygons(clump(clipLand(r)<(contourval)), dissolve=TRUE)
    plot(SP, add=TRUE)
  }
  if(addLCA) {
    pl <- rbind(c(-121,36.3064), c(-123.583,34.45), c(-129,34.45), c(-129,45), c(-121,45))
    pl <- SpatialPolygons(list(Polygons(list(Polygon(pl)), 1)))
    projection(pl) <- projstring
    plot(pl, border="dark grey", add=TRUE, lty=3, lwd=4)
  }
  
  
  
  map('worldHires',add=TRUE,col=grey(0.7),fill=TRUE)
  if (addtext) {
    text(-122,46,format(get_date,format="%b %d %Y"),adj=c(0,0),cex=2) 
    text(-122,45,"Species weightings",adj=c(0,0),cex=1)
    #text(-122,45,paste(namesrisk[1],' weighting = ',risk[1],sep=''),adj=c(0,0),cex=.75)
    text(-122,44.5,paste(namesrisk[2],' weighting = ',risk[2],sep=''),adj=c(0,0),cex=.75)
    text(-122,44,paste(namesrisk[3],' weighting = ',risk[3],sep=''),adj=c(0,0),cex=.75)
    text(-122,43.5,paste(namesrisk[4],' weighting = ',risk[4],sep=''),adj=c(0,0),cex=.75)
    text(-122,43,paste(namesrisk[5],' weighting = ',risk[5],sep=''),adj=c(0,0),cex=.75)
    
    text(-122,42.5,"Environmental data",adj=c(0,0),cex=1)
    text(-122,42,variables_eco[1],adj=c(0,0),cex=.75)
    text(-122,41.5,variables_eco[2],adj=c(0,0),cex=.75)
    text(-122,41,variables_eco[3],adj=c(0,0),cex=.75)
    text(-122,40.5,variables_eco[4],adj=c(0,0),cex=.75)
    text(-122,40,variables_eco[5],adj=c(0,0),cex=.75)
    text(-122,39.5,variables_eco[6],adj=c(0,0),cex=.75)
    
  }
  
  box()
  dev.off()
  
  ####### produce raster
  writeRaster(r, filename=paste(wd,'/EcoCast_',paste(risk,collapse="_"),"_",get_date,version,'.grd',sep=''),overwrite=TRUE) 
}
