#' EcoCast_readraster
#' @param CIobj
#' @param yr
#' @param griddir
#' @param calctype
#' @return 

EcoCast_readraster<-function(CIobj,yr="2012",griddir,calctype="m"){
  CIdir<-unlist(strsplit(CIobj,"_"))[2]
  
  assign(paste(CIdir,"dir",sep=""),paste(griddir,CIdir,"/predCIs/",sep=''))
  varname<-paste(CIdir,"dir",sep="")
  
  allfiles<-list.files(get(varname), glob2rx('*.grd'), full.names=T)
  if (calctype=="m") {
    assign(paste("files",yr,"m",sep=''),allfiles[grep(yr,allfiles)][grep("_mean",allfiles[grep(yr,allfiles)])])
    assign(paste(CIdir[i],yr,"_m_r",sep=''),lapply(get(paste("files",yr,"m",sep='')), FUN = raster))
    return(get(paste(CIdir[i],yr,"_m_r",sep='')))
  }
  if (calctype=="se") {
    assign(paste("files",yr,"se",sep=''),allfiles[grep(yr,allfiles)][grep("_se",allfiles[grep(yr,allfiles)])])
    assign(paste(CIdir[i],yr,"_se_r",sep=''),lapply(get(paste("files",yr,"se",sep='')), FUN = raster))
    return(get(paste(CIdir[i],yr,"_se_r",sep='')))
  }
  if (calctype=="highCI") {
    assign(paste("files",yr,"hiCI",sep=''),allfiles[grep(yr,allfiles)][grep("_highCI",allfiles[grep(yr,allfiles)])])
    assign(paste(CIdir[i],yr,"_hiCI_r",sep=''),lapply(get(paste("files",yr,"hiCI",sep='')), FUN = raster))
    return(get(paste(CIdir[i],yr,"_hiCI_r",sep='')))
  }
  if (calctype=="lowCI") {
    assign(paste("files",yr,"loCI",sep=''),allfiles[grep(yr,allfiles)][grep("_lowCI",allfiles[grep(yr,allfiles)])])
    assign(paste(CIdir[i],yr,"_loCI_r",sep=''),lapply(get(paste("files",yr,"loCI",sep='')), FUN = raster))
    return(get(paste(CIdir[i],yr,"_loCI_r",sep='')))
  }
}
