% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truediscoveryrate.R
\name{truediscoveryrate}
\alias{truediscoveryrate}
\title{Calculate true discovery rate of a sample}
\usage{
truediscoveryrate(eta, chi, rho, M, R = NULL, assumption = "mtml")
}
\arguments{
\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{chi}{scalar or vector giving the specificity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen (default=NULL)}

\item{assumption}{a character vector indicating which assumptions about transmission and linkage criteria. Default = \code{'mtml'}. Accepted arguments are:
\enumerate{
\item \code{'stsl'} for the single-transmission single-linkage assumption (\code{\link[=prob_trans_stsl]{prob_trans_stsl()}}).
\item \code{'mtsl'} for the multiple-transmission single-linkage assumption (\code{\link[=prob_trans_mtsl]{prob_trans_mtsl()}}).
\item \code{'mtml'} for the multiple-transmission multiple-linkage assumption (\code{\link[=prob_trans_mtml]{prob_trans_mtml()}}).
}}
}
\value{
scalar or vector giving the true discovery rate
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function calculates the true discovery rate (proportion of true transmission pairs) in a sample given the sensitivity \eqn{\eta}
and specificity \eqn{\chi} of the linkage criteria, and sample size \eqn{M}. Assumptions about transmission and linkage (single or multiple)
can be specified.
}
\examples{
# The simplest case: single-transmission, single-linkage, and perfect sensitivity
truediscoveryrate(eta=1, chi=0.9, rho=0.5, M=100, assumption='stsl')

# Multiple-transmission and imperfect sensitivity
truediscoveryrate(eta=0.99, chi=0.9, rho=1, M=50, R=1, assumption='mtsl')

# Small outbreak, larger sampling proportion
truediscoveryrate(eta=0.99, chi=0.95, rho=1, M=50, R=1, assumption='mtml')

# Large outbreak, small sampling proportion
truediscoveryrate(eta=0.99, chi=0.95, rho=0.5, M=1000, R=1, assumption='mtml')

}
\seealso{
Other discovery_rate: 
\code{\link{falsediscoveryrate}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{discovery_rate}
