% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_prob_transmit_mtml.R
\name{translink_prob_transmit_mtml}
\alias{translink_prob_transmit_mtml}
\title{Calculate probability of transmission assuming multiple-transmission and multiple-linkage}
\usage{
translink_prob_transmit_mtml(sensitivity, specificity, rho, M, R)
}
\arguments{
\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{specificity}{scalar or vector giving the specificity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}
}
\value{
scalar or vector giving the probability of transmission between two cases given linkage by phylogenetic criteria
}
\description{
This function calculates the probability that two cases are linked by direct transmission
given that they have been linked by phylogenetic criteria. The multiple-transmission and multiple-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is, on average, the infector of \code{R} cases in the population (\eqn{N})
\item Each case \eqn{i} is allowed to be linked by the linkage criteria to multiple cases \eqn{j} in the sampled population (\eqn{M}).
\item Linkage events are independent of one another (i.e, linkage of case \eqn{i} to case \eqn{j} has no bearing on linkage of case \eqn{i} to any other sample).
}
}
\examples{
# Perfect sensitivity and specificity
translink_prob_transmit_mtml(sensitivity=1, specificity=1, rho=0.5, M=100, R=1)

translink_prob_transmit_mtml(sensitivity=0.99, specificity=0.9, rho=1, M=50, R=1)

translink_prob_transmit_mtml(sensitivity=0.99, specificity=0.9, rho=0.5, M=100, R=1)

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtml}()},
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs_stsl}()},
\code{\link{translink_expected_links_obs}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_mtsl}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_expected_links_true}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_prob_transmit}()},
\code{\link{translink_samplesize}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{transmission linkage functions}
