% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obs_pairs_mtsl.R
\name{obs_pairs_mtsl}
\alias{obs_pairs_mtsl}
\title{Expected number of observed pairs assuming multiple-transmission and single-linkage}
\usage{
obs_pairs_mtsl(chi, eta, rho, M, R)
}
\arguments{
\item{chi}{scalar or vector giving the specificity of the linkage criteria}

\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}
}
\value{
scalar or vector giving the expected number of linked pairs observed in the sample
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function calculates the expected number of pairs observed in a sample of size \code{M}.
The multiple-transmission and single-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is, on average, the infector of \code{R} cases in the population (\eqn{N})
\item Each case \eqn{i} is allowed to be linked by the linkage criteria to only one other case \eqn{j} in the sampled population (\eqn{M}).
}
}
\examples{
# Perfect sensitivity and specificity
obs_pairs_mtsl(eta=1, chi=1, rho=0.5, M=100, R=1)

obs_pairs_mtsl(eta=0.99, chi=0.9, rho=1, M=50, R=1)

obs_pairs_mtsl(eta=0.99, chi=0.9, rho=0.5, M=100, R=1)

}
\seealso{
Other obs_pairs: 
\code{\link{exp_links}()},
\code{\link{obs_pairs_mtml}()},
\code{\link{obs_pairs_stsl}()}
}
\author{
John Giles, Shirlee Wohl and Justin Lessler
}
\concept{obs_pairs}
