import style from '../ItkVtkViewer.module.css'

import createPointSetColorChooser from './createPointSetColorChooser'
import createPointSetOpacitySlider from './createPointSetOpacitySlider'
import createPointSetColorBySelector from './createPointSetColorBySelector'
import createPointSetSizeSlider from './createPointSetSizeSlider'
import createPointSetColorRangeInput from './createPointSetColorRangeInput'

function createPointSetColorWidget(store, pointSetsUIGroup) {
  const colorByRow = document.createElement('div')
  colorByRow.setAttribute('class', style.uiRow)
  colorByRow.className += ` ${store.id}-collapsible`
  createPointSetColorBySelector(store, colorByRow)
  pointSetsUIGroup.appendChild(colorByRow)

  const pointSetColorRow = document.createElement('div')
  pointSetColorRow.setAttribute('class', style.uiRow)
  pointSetColorRow.className += ` ${store.id}-collapsible`

  createPointSetColorChooser(store, pointSetColorRow)

  createPointSetOpacitySlider(store, pointSetColorRow)
  pointSetsUIGroup.appendChild(pointSetColorRow)

  const colorRangeInputRow = document.createElement('div')
  colorRangeInputRow.setAttribute('class', style.uiRow)
  createPointSetColorRangeInput(store, colorRangeInputRow)
  colorRangeInputRow.className += ` ${store.id}-collapsible`
  pointSetsUIGroup.appendChild(colorRangeInputRow)

  const pointSetSizeRow = document.createElement('div')
  pointSetSizeRow.setAttribute('class', style.uiRow)
  pointSetSizeRow.className += ` ${store.id}-collapsible`
  createPointSetSizeSlider(store, pointSetSizeRow)
  pointSetsUIGroup.appendChild(pointSetSizeRow)

  if (store.mainUI.collapsed) {
    colorByRow.style.display = 'none'
    colorRangeInputRow.style.display = 'none'
    pointSetSizeRow.style.display = 'none'
  }
}

export default createPointSetColorWidget
