close; clear;clc;

load('Results/FLAT/knn_strict2022/positive_distancem_cityblock_k001/results_rep001.mat')
r1a = results;
load('Results/LAB/knn_strict2022/positive_distancem_cityblock_k001/results_rep001.mat')
r2a = results;
load('Results/FLAT/knn_strict2022/positive_distancem_cityblock_k100/results_rep001.mat')
r1b = results;
load('Results/LAB/knn_strict2022/positive_distancem_cityblock_k100/results_rep001.mat')
r2b = results;

close all;
figure; hold on;

color1 = [0    0.4470    0.7410];
color2 = [0.8500    0.3250    0.0980];

h=cdfplot(r1a.error(:,2))
set(h,'LineWidth',1.5) 
set(h,'LineStyle',':') 
set(h,'Color',color1) 

h=cdfplot(r1b.error(:,2))
set(h,'LineWidth',1.5);
set(h,'Color',color1) 
%color1 = h.Color;

h=cdfplot(r2a.error(:,2))
set(h,'LineWidth',1.5) 
set(h,'LineStyle',':') 
set(h,'Color',color2) 

h=cdfplot(r2b.error(:,2))
set(h,'LineWidth',1.5)
set(h,'Color',color2) 
%color2 = h.Color;


legend({'$\mathsf{FLAT \hspace{1em} } k=1$',...
    '$\mathsf{FLAT \hspace{1em} } k=100$',...
    '$\mathsf{LAB \hspace{1em} } k=1$',...
    '$\mathsf{LAB \hspace{1em} } k=100$',...
    },'Interpreter','latex')

xlabel('Positioning error (m)')

daspect([1 1/14 1])

exportgraphics(gcf,'CDF_K100.pdf');