clc; clear;
close all;

load('../Datasets/Datasets_MAT/FLAT.mat');

minRSS = min([database.trainingMacs(:);database.testMacs(:)])-1;
database.trainingMacsOrig = database.trainingMacs;
database.trainingMacs(database.trainingMacs>0) = minRSS;
database.testMacs(database.testMacs>0) = minRSS;

X  = database.trainingLabels(:,1:2);
Y1 = database.trainingMacs;
%gprMdl = fitrgp(X,Y1,'KernelFunction','squaredexponential','OptimizeHyperparameters','auto','HyperparameterOptimizationOptions',struct('AcquisitionFunctionName','expected-improvement-plus'));
%save('model_FLAT','gprMdl');
load('model_FLAT','gprMdl');
ypred = predict(gprMdl,X);
% so I don't write indexes below
x_data = X(:,1);
y_data = X(:,2);
% Getting the 2d grid
Num_Points = 200;
X_Lin = 0:0.1:5.1;
Y_Lin = 0:0.1:9.1;

[X,Y] = meshgrid(X_Lin,Y_Lin);
% Interpolating the surface from ypred
f = scatteredInterpolant(x_data, y_data, ypred);
Z = f(X,Y);
surf(X,Y,Z);
% plotting the observed points
hold on;
h = plot3(x_data,y_data, Y1,'.r','DisplayName','Observations');

close all;
figure;
Z(end,1) = -40;
Z(end,2) = -90;
h = pcolor(X,Y,Z);
set(h, 'EdgeColor', 'none');
daspect([1 1 1]);
colorbar
colormap jet

x_points = [];
y_points = [];
r_points = [];
m_points = [];
v_points = [];
p_points = [];
idx = zeros(size(x_data,1),1);
pt = 0;
for i = 1:size(idx,1)
    if ~idx(i)
        pt = pt+1;
        idx(i) = pt;
        for j = (i+1):size(idx,1)
            if distance_euclidean([x_data(i),y_data(i)],[x_data(j),y_data(j)]) < 0.01
                idx(j) = pt;
            end
        end
        x_points = [x_points;x_data(i)];
        y_points = [y_points;y_data(i)];

        rss = database.trainingMacsOrig(idx == pt);
        r_points = [r_points;mean(rss(rss<0))];
        v_points = [v_points;std(rss(rss<0))];
        m_points = [m_points;sum(rss>0)];
        p_points = [p_points;size(rss,1)];
        
    end
end

hold on;
scatter(x_points,y_points,100,r_points,'filled','MarkerEdgeColor',[0.2 .2 .2])
for i = 1:size(x_points,1)
%text(x_points(i),y_points(i),sprintf('%3.2f\n%3.2f\n%3.2f%',r_points(i),v_points(i),m_points(i)/p_points(1)*100))
text(x_points(i)+0.17,y_points(i),sprintf('STD:%3.2f\n%%MD:%3.2f%',v_points(i),m_points(i)/p_points(1)*100),'FontSize',5)
end
xlim([0 5])
ylim([0 9])
exportgraphics(gcf,'FLAT_GP_RADIOMAP.pdf');


close all;

fprintf('FLAT & %4d & %6.2f$\\pm$%5.2f$ & %5.2f%%',size(p_points,1),mean(p_points),std(p_points),sum(m_points)/sum(p_points)*100);

clear; 
load('../Datasets/Datasets_MAT/FLAT.mat');
minRSS = min([database.trainingMacs(:);database.testMacs(:)])-1;
database.testMacsOrig = database.testMacs;
database.testMacs(database.trainingMacs>0) = minRSS;

X  = database.testLabels(:,1:2);
Y1 = database.testMacs;
x_data = X(:,1);
y_data = X(:,2);
x_points = [];
y_points = [];
r_points = [];
m_points = [];
v_points = [];
p_points = [];
idx = zeros(size(x_data,1),1);
pt = 0;
for i = 1:size(idx,1)
    if ~idx(i)
        pt = pt+1;
        idx(i) = pt;
        for j = (i+1):size(idx,1)
            if distance_euclidean([x_data(i),y_data(i)],[x_data(j),y_data(j)]) < 0.01
                idx(j) = pt;
            end
        end
        x_points = [x_points;x_data(i)];
        y_points = [y_points;y_data(i)];

        rss = database.testMacsOrig(idx == pt);
        r_points = [r_points;mean(rss(rss<0))];
        v_points = [v_points;std(rss(rss<0))];
        m_points = [m_points;sum(rss>0)];
        p_points = [p_points;size(rss,1)];
        
    end
end

fprintf('%4d & %6.2f$\\pm$%5.2f$ & %5.2f%%',size(p_points,1),mean(p_points),std(p_points),sum(m_points)/sum(p_points)*100);