# Written by D. Ibarra, Jan. 2021 
# Analysis of Tibet Data for Extended Figure 8
library(IsoplotR)
setwd("C:/Users/Dan Ibarra/Desktop/Coauthor Papers/NG_final/Ibarra_etal_Code")
getwd()

par(mfrow=c(1,2))

# Function for curve Intersect
curve_intersect <- function(curve1, curve2, empirical=TRUE, domain=NULL) {
  if (!empirical & missing(domain)) {
    stop("'domain' must be provided with non-empirical curves")
  }
  
  if (!empirical & (length(domain) != 2 | !is.numeric(domain))) {
    stop("'domain' must be a two-value numeric vector, like c(0, 10)")
  }
  
  if (empirical) {
    # Approximate the functional form of both curves
    curve1_f <- approxfun(curve1$x, curve1$y, rule = 2)
    curve2_f <- approxfun(curve2$x, curve2$y, rule = 2)
    
    # Calculate the intersection of curve 1 and curve 2 along the x-axis
    point_x <- uniroot(function(x) curve1_f(x) - curve2_f(x),
                       c(min(curve1$x), max(curve1$x)))$root
    
    # Find where point_x is in curve 2
    point_y <- curve2_f(point_x)
  } else {
    # Calculate the intersection of curve 1 and curve 2 along the x-axis
    # within the given domain
    point_x <- uniroot(function(x) curve1(x) - curve2(x), domain)$root
    
    # Find where point_x is in curve 2
    point_y <- curve2(point_x)
  }
  
  return(list(x = point_x, y = point_y))
}

# Meteoric water ranges
SLOPE.ARRAY = seq(0.525,0.5305,0.00005)
INT.ARRAY = seq(0.005,0.061,0.0005)

d18O.sens = matrix(NA,nrow=length(SLOPE.ARRAY),ncol=length(INT.ARRAY))
plot(NA,NA)

# bit loop of calculations
for(i in 1:length(SLOPE.ARRAY)){
  for(j in 1:length(INT.ARRAY)){
    
  lambda = SLOPE.ARRAY[i]
  gamma = INT.ARRAY[j]
  d18O.prime = seq(-70,-8,0.05)
  d17O.prime = lambda*d18O.prime+gamma
  cap17O.prime = d17O.prime - 0.528*d18O.prime
  
  d17O = 1000*(exp(d17O.prime/1000)-1)
  d18O = 1000*(exp(d18O.prime /1000)-1)
  cap17O.curved = d17O - (0.528*d18O)
  
  
Temp = 273.15+240
d18O.alpha = exp((((4.2*10^6)/(Temp^2))-((3.3*1000)/Temp))/1000)
d18O.Si =  d18O.alpha*(d18O+1000)-1000
d17O.alpha = exp(((((4.2*10^6)/(Temp^2))-((3.3*1000)/Temp))*((-1.85/Temp) + 0.5305))/1000)
d17O.Si = d17O.alpha*(d17O+1000)-1000
cap17O.curved.Si = d17O.Si - (0.528*d18O.Si)
#lines(d18O.Si,cap17O.curved.Si)

d18O.Si.lin = 1000*log(d18O.Si/1000+1)
cap17O.lin.Si = (1000*log(d17O.Si/1000+1)) - (0.528*(1000*log(d18O.Si/1000+1)))


# Read in data
Data = read.csv('TibetData 3.csv')
Data$D17Oprime
d18O.points = Data$d18O
D17O.points = Data$d17O-0.528*Data$d18O
#points(d18O.points,D17O.points ,bg="orange",pch=21,cex=1.5)


water = read.csv("Waters.csv")
water.d18O = 1000*(-1+exp(water$d18Oprime/1000))
water.d17Oprime = water$d18Oprime*0.528+water$D17O
water.d17O = 1000*(-1+exp(water.d17Oprime/1000))
water.D17O.points = water.d17O-0.528*water.d18O


All.data.regress = cbind(Data$d18O,rep(0.14,length(d18O.points)),Data$D17Oprime,Data$D17Oprime_SE,rep(0,length(Data$D17Oprime_SE)))
All.york = york(All.data.regress)


all.d18O.reg = seq(-30,20,0.05)
all.cap17O.reg = all.d18O.reg*All.york$b[1] + All.york$a[1]
all.d17O.reg = all.cap17O.reg+all.d18O.reg *0.528

all.cap17O.reg1 = all.d18O.reg*(All.york$b[1]-2*All.york$b[2]) + (All.york$a[1]+2*All.york$a[2])
all.d17O.reg1 = all.cap17O.reg1+all.d18O.reg *0.528
all.cap17O.reg2 = all.d18O.reg*(All.york$b[1]+2*All.york$b[2]) + (All.york$a[1]-2*All.york$a[2])
all.d17O.reg2 = all.cap17O.reg2+all.d18O.reg *0.528
all.cap17O.reg3 = all.d18O.reg*(All.york$b[1]+2*All.york$b[2]) + (All.york$a[1]+2*All.york$a[2])
all.d17O.reg3 = all.cap17O.reg3+all.d18O.reg *0.528
all.cap17O.reg4 = all.d18O.reg*(All.york$b[1]-2*All.york$b[2]) + (All.york$a[1]-2*All.york$a[2])
all.d17O.reg4 = all.cap17O.reg4+all.d18O.reg *0.528



Meteoric = curve_intersect(data.frame(x=all.d18O.reg,y=all.cap17O.reg),data.frame(x=d18O.Si,y=cap17O.curved.Si),domain=c(-30,-10))
points(Meteoric$x,Meteoric$y,pch=23,cex=1.5,bg="grey")
Meteoric

Siend.d18Oprime = 1000*log(Meteoric$x/1000 + 1)
Siend.d17O = Meteoric$y+0.528*Meteoric$x
Siend.d17Oprime = 1000*log(Siend.d17O/1000 + 1)
Siend.D17Oprime = Siend.d17Oprime - 0.528*Siend.d18Oprime



Meteoric.d18O = (Meteoric$x + 1000)/d18O.alpha-1000
Meteoric.d17O = ((Meteoric$y + Meteoric$x *0.528) + 1000)/d17O.alpha-1000
Meteoric.D17O = Meteoric.d17O - 0.528*Meteoric.d18O
Meteoric.d18O; Meteoric.D17O



WaterSiend.d18Oprime = 1000*log(Meteoric.d18O/1000 + 1)
WaterSiend.d17O = Meteoric.D17O+0.528*Meteoric.d18O
WaterSiend.d17Oprime = 1000*log(WaterSiend.d17O/1000 + 1)
WaterSiend.D17Oprime = WaterSiend.d17Oprime - 0.528*WaterSiend.d18Oprime



d18O.reg.prime = 1000*log(all.d18O.reg/1000 + 1)
d17O.reg.prime = 1000*log(all.d17O.reg/1000 + 1)
cap.pri.17O.reg = d17O.reg.prime - 0.528*d18O.reg.prime


all.cap17O.prime.reg1 = 1000*log(all.d17O.reg1/1000+1) - 0.528*d18O.reg.prime
all.cap17O.prime.reg2 = 1000*log(all.d17O.reg2/1000+1) - 0.528*d18O.reg.prime
all.cap17O.prime.reg3 = 1000*log(all.d17O.reg3/1000+1) - 0.528*d18O.reg.prime
all.cap17O.prime.reg4 = 1000*log(all.d17O.reg4/1000+1) - 0.528*d18O.reg.prime


Meteoric.d18O
Meteoric.D17O
d18O.sens[i,j]=Meteoric.d18O
# 2 sigma error
Meteoric = curve_intersect(data.frame(x=all.d18O.reg,y=all.cap17O.reg1),data.frame(x=d18O.Si,y=cap17O.curved.Si),domain=c(-30,-10))

Meteoric.d18O.1 = (Meteoric$x + 1000)/d18O.alpha-1000
Meteoric.d17O.1 = ((Meteoric$y + Meteoric$x *0.528) + 1000)/d17O.alpha-1000
Meteoric.D17O.1 = Meteoric.d17O - 0.528*Meteoric.d18O
Meteoric.d18O.1; Meteoric.D17O.1


Meteoric = curve_intersect(data.frame(x=all.d18O.reg,y=all.cap17O.reg2),data.frame(x=d18O.Si,y=cap17O.curved.Si),domain=c(-30,-10))

Meteoric.d18O.2 = (Meteoric$x + 1000)/d18O.alpha-1000
Meteoric.d17O.2 = ((Meteoric$y + Meteoric$x *0.528) + 1000)/d17O.alpha-1000
Meteoric.D17O.2 = Meteoric.d17O - 0.528*Meteoric.d18O
Meteoric.d18O.2; Meteoric.D17O.2

}}

par(mfrow=c(1,2))

# Panel A
contour(x=SLOPE.ARRAY,y=INT.ARRAY,z=d18O.sens,las=1,xlab="Slope (L)",ylab="Intercept (Y)",lwd=1,method="edge",
        main="Contour = Paleo-Meteoric Water d18O (%)")
lines(c(0.5282,0.5282),c(0.0365+0.0052,0.0365-0.0052),lwd=2)
lines(c(0.5282+0.0003,0.5282-0.0003),c(0.0365,0.0365),lwd=2)
points(0.5282,0.0365,pch=24,cex=1.5,bg="blue")

points(0.5268,0.015,pch=21,cex=1.25,bg="grey")
points(0.528,0.037,pch=21,cex=1.25,bg="grey")
points(0.528,0.032,pch=21,cex=1.25,bg="grey")
points(0.528546,0.041336,pch=23,bg="lightblue",cex=2)

points(c(0.529526,0.527283,0.529758,0.527408),c(0.055116,0.024445,0.060014,0.020843),pch=22,bg="lightblue",cex=2)

# Panel B
d18O.sens.corr = d18O.sens+2-0.5+5.8
elev.d18O.sens = -0.0129*d18O.sens.corr^4-1.121*d18O.sens.corr^3-38.213*d18O.sens.corr^2-715.22*d18O.sens.corr
contour(x=SLOPE.ARRAY,y=INT.ARRAY,z=elev.d18O.sens,las=1,xlab="Slope (L)",ylab="Intercept (Y)",lwd=1,method="edge",
        main="Contour = Elevation (m)")

lines(c(0.5282,0.5282),c(0.0365+0.0052,0.0365-0.0052),lwd=2)
lines(c(0.5282+0.0003,0.5282-0.0003),c(0.0365,0.0365),lwd=2)
points(0.5282,0.0365,pch=24,cex=1.5,bg="blue")

points(0.5268,0.015,pch=21,cex=1.25,bg="grey")
points(0.528,0.037,pch=21,cex=1.25,bg="grey")
points(0.528,0.032,pch=21,cex=1.25,bg="grey")

points(0.528546,0.041336,pch=23,bg="lightblue",cex=2)

points(c(0.529526,0.527283,0.529758,0.527408),c(0.055116,0.024445,0.060014,0.020843),pch=22,bg="lightblue",cex=2)


