# Written by D. Ibarra, Jan. 2021 
# Analysis of Tibet Data for Extended Figure 7
library(IsoplotR)
setwd("C:/Users/Dan Ibarra/Desktop/Coauthor Papers/NG_final/Ibarra_etal_Code")
getwd()

par(mfrow=c(1,2))

# Function for curve Intersect
curve_intersect <- function(curve1, curve2, empirical=TRUE, domain=NULL) {
  if (!empirical & missing(domain)) {
    stop("'domain' must be provided with non-empirical curves")
  }
  
  if (!empirical & (length(domain) != 2 | !is.numeric(domain))) {
    stop("'domain' must be a two-value numeric vector, like c(0, 10)")
  }
  
  if (empirical) {
    # Approximate the functional form of both curves
    curve1_f <- approxfun(curve1$x, curve1$y, rule = 2)
    curve2_f <- approxfun(curve2$x, curve2$y, rule = 2)
    
    # Calculate the intersection of curve 1 and curve 2 along the x-axis
    point_x <- uniroot(function(x) curve1_f(x) - curve2_f(x),
                       c(min(curve1$x), max(curve1$x)))$root
    
    # Find where point_x is in curve 2
    point_y <- curve2_f(point_x)
  } else {
    # Calculate the intersection of curve 1 and curve 2 along the x-axis
    # within the given domain
    point_x <- uniroot(function(x) curve1(x) - curve2(x), domain)$root
    
    # Find where point_x is in curve 2
    point_y <- curve2(point_x)
  }
  
  return(list(x = point_x, y = point_y))
}


# Meteoric water array
lambda = 0.5282287
gamma = 0.0364796
d18O.prime = seq(-70,-8,0.05)
d17O.prime = lambda*d18O.prime+gamma
cap17O.prime = d17O.prime - 0.528*d18O.prime

d17O = 1000*(exp(d17O.prime/1000)-1)
d18O = 1000*(exp(d18O.prime /1000)-1)
cap17O.curved = d17O - (0.528*d18O)

TEMP.ARRAY = seq(120,450,10)
d18O.sens = rep(NA,length(TEMP.ARRAY))
d18O.sens.high = rep(NA,length(TEMP.ARRAY))
d18O.sens.low = rep(NA,length(TEMP.ARRAY))

for(i in 1:length(TEMP.ARRAY)){
  
Temp = 273.15+TEMP.ARRAY[i]
d18O.alpha = exp((((4.2*10^6)/(Temp^2))-((3.3*1000)/Temp))/1000)
d18O.Si =  d18O.alpha*(d18O+1000)-1000
d17O.alpha = exp(((((4.2*10^6)/(Temp^2))-((3.3*1000)/Temp))*((-1.85/Temp) + 0.5305))/1000)
d17O.Si = d17O.alpha*(d17O+1000)-1000
cap17O.curved.Si = d17O.Si - (0.528*d18O.Si)

d18O.Si.lin = 1000*log(d18O.Si/1000+1)
cap17O.lin.Si = (1000*log(d17O.Si/1000+1)) - (0.528*(1000*log(d18O.Si/1000+1)))


# Read in data
Data = read.csv('TibetData 3.csv')
Data$D17Oprime
d18O.points = Data$d18O
D17O.points = Data$d17O-0.528*Data$d18O

water = read.csv("Waters.csv")
water.d18O = 1000*(-1+exp(water$d18Oprime/1000))
water.d17Oprime = water$d18Oprime*0.528+water$D17O
water.d17O = 1000*(-1+exp(water.d17Oprime/1000))
water.D17O.points = water.d17O-0.528*water.d18O

# Do Regression as in Figure 2 and Create Arrays for First Plot
All.data.regress = cbind(Data$d18O,rep(0.14,length(d18O.points)),Data$D17Oprime,Data$D17Oprime_SE,rep(0,length(Data$D17Oprime_SE)))
All.york = york(All.data.regress)
abline(a=All.york$a,b=All.york$b,lwd=2)
abline(a=All.york$a+2*All.york$a[2],b=All.york$b-2*All.york$b[2])
abline(a=All.york$a-2*All.york$a[2],b=All.york$b+2*All.york$b[2])
abline(a=All.york$a+2*All.york$a[2],b=All.york$b+2*All.york$b[2])
abline(a=All.york$a-2*All.york$a[2],b=All.york$b-2*All.york$b[2])

all.d18O.reg = seq(-30,20,0.05)
all.cap17O.reg = all.d18O.reg*All.york$b[1] + All.york$a[1]
all.d17O.reg = all.cap17O.reg+all.d18O.reg *0.528

all.cap17O.reg1 = all.d18O.reg*(All.york$b[1]-2*All.york$b[2]) + (All.york$a[1]+2*All.york$a[2])
all.d17O.reg1 = all.cap17O.reg1+all.d18O.reg *0.528
all.cap17O.reg2 = all.d18O.reg*(All.york$b[1]+2*All.york$b[2]) + (All.york$a[1]-2*All.york$a[2])
all.d17O.reg2 = all.cap17O.reg2+all.d18O.reg *0.528
all.cap17O.reg3 = all.d18O.reg*(All.york$b[1]+2*All.york$b[2]) + (All.york$a[1]+2*All.york$a[2])
all.d17O.reg3 = all.cap17O.reg3+all.d18O.reg *0.528
all.cap17O.reg4 = all.d18O.reg*(All.york$b[1]-2*All.york$b[2]) + (All.york$a[1]-2*All.york$a[2])
all.d17O.reg4 = all.cap17O.reg4+all.d18O.reg *0.528

Meteoric = curve_intersect(data.frame(x=all.d18O.reg,y=all.cap17O.reg),data.frame(x=d18O.Si,y=cap17O.curved.Si),domain=c(-30,-10))

Siend.d18Oprime = 1000*log(Meteoric$x/1000 + 1)
Siend.d17O = Meteoric$y+0.528*Meteoric$x
Siend.d17Oprime = 1000*log(Siend.d17O/1000 + 1)
Siend.D17Oprime = Siend.d17Oprime - 0.528*Siend.d18Oprime

Meteoric.d18O = (Meteoric$x + 1000)/d18O.alpha-1000
Meteoric.d17O = ((Meteoric$y + Meteoric$x *0.528) + 1000)/d17O.alpha-1000
Meteoric.D17O = Meteoric.d17O - 0.528*Meteoric.d18O

WaterSiend.d18Oprime = 1000*log(Meteoric.d18O/1000 + 1)
WaterSiend.d17O = Meteoric.D17O+0.528*Meteoric.d18O
WaterSiend.d17Oprime = 1000*log(WaterSiend.d17O/1000 + 1)
WaterSiend.D17Oprime = WaterSiend.d17Oprime - 0.528*WaterSiend.d18Oprime

d18O.reg.prime = 1000*log(all.d18O.reg/1000 + 1)
d17O.reg.prime = 1000*log(all.d17O.reg/1000 + 1)
cap.pri.17O.reg = d17O.reg.prime - 0.528*d18O.reg.prime

all.cap17O.prime.reg1 = 1000*log(all.d17O.reg1/1000+1) - 0.528*d18O.reg.prime
all.cap17O.prime.reg2 = 1000*log(all.d17O.reg2/1000+1) - 0.528*d18O.reg.prime
all.cap17O.prime.reg3 = 1000*log(all.d17O.reg3/1000+1) - 0.528*d18O.reg.prime
all.cap17O.prime.reg4 = 1000*log(all.d17O.reg4/1000+1) - 0.528*d18O.reg.prime

lines(c(Meteoric.d18O,Meteoric$x),c(Meteoric.D17O,Meteoric$y),lwd=2)
d18O.sens[i]=Meteoric.d18O

# 2 sigma error
Meteoric = curve_intersect(data.frame(x=all.d18O.reg,y=all.cap17O.reg1),data.frame(x=d18O.Si,y=cap17O.curved.Si),domain=c(-30,-10))

Meteoric.d18O.1 = (Meteoric$x + 1000)/d18O.alpha-1000
Meteoric.d17O.1 = ((Meteoric$y + Meteoric$x *0.528) + 1000)/d17O.alpha-1000
Meteoric.D17O.1 = Meteoric.d17O - 0.528*Meteoric.d18O
Meteoric.d18O.1; Meteoric.D17O.1
d18O.sens.high[i]=Meteoric.d18O.1

Meteoric = curve_intersect(data.frame(x=all.d18O.reg,y=all.cap17O.reg2),data.frame(x=d18O.Si,y=cap17O.curved.Si),domain=c(-30,-10))

Meteoric.d18O.2 = (Meteoric$x + 1000)/d18O.alpha-1000
Meteoric.d17O.2 = ((Meteoric$y + Meteoric$x *0.528) + 1000)/d17O.alpha-1000
Meteoric.D17O.2 = Meteoric.d17O - 0.528*Meteoric.d18O
Meteoric.d18O.2; Meteoric.D17O.2
d18O.sens.low[i]=Meteoric.d18O.2

# points(Meteoric.d18O,Meteoric.D17O,pch=3,cex=1.5,col="blue")
}

# Panel A
plot(TEMP.ARRAY, d18O.sens,type="l",lwd=2,xlim=c(120,450),ylim=c(-22,-7),las=1,xlab="Temperature (oC)",ylab="d18OMW (% VSMOW)")
lines(TEMP.ARRAY,d18O.sens.high,lty=2,lwd=1.5)
lines(TEMP.ARRAY,d18O.sens.low,lty=2,lwd=1.5)
points(TEMP.ARRAY[13],d18O.sens[13],pch=24,bg="blue",cex=2.5)
abline(v=240)
abline(v=c(240+35,240-35),lty=2,col="grey")

abline(v=210)
abline(v=c(210+31,210-31),lty=2,col="grey")
abline(v=c(148,290),col="tan")


# Create Arrays for Second Plot

shored18O = seq(-10,-2,0.1)
meteoricraw = -14.3
meteoriccorr = -14.3+2-0.7
meanelev = rep(NA,length(shored18O))
sigmaplus = rep(NA,length(shored18O))
sigmaminus = rep(NA,length(shored18O))

for(i in 1:length(shored18O)){
capd18O = meteoriccorr-shored18O[i]
meanelev[i] = -0.0129*capd18O^4-1.121*capd18O^3-38.213*capd18O^2-715.22*capd18O
sigmaplus[i] = 0.015*(capd18O^4)+0.738*(capd18O^3)+9.031*(capd18O^2)-47.186*capd18O
sigmaminus[i] = -0.0126*(capd18O^4)-0.58*(capd18O^3)-5.262*(capd18O^2)+89.212*capd18O
}

# Panel B
plot(shored18O,meanelev,type="l",las=1,xlab="Sea Level d18OMW",lwd=2,ylim=c(2000,5500))
lines(shored18O,meanelev+sigmaplus,lwd=1.5,lty=2)
lines(shored18O,meanelev+sigmaminus,lwd=1.5,lty=2)
points(shored18O[43],meanelev[43],pch=24,bg="blue",cex=2.5)

abline(v=-5.8)
abline(v=c(-5.8+2,-5.8-2),lty=2,col="grey")
abline(v=-3.6,col="tan")
