# Written by D. Ibarra, Jan. 2021 
# Analysis of Tibet Data for Extended Figure 3
library(IsoplotR)
setwd("C:/Users/Dan Ibarra/Desktop/Coauthor Papers/NG_final/Ibarra_etal_Code")
getwd()

water.comp = read.csv("Tibet_comp.csv")
highlight = water.comp[which(water.comp$study != 2),]

water.comp=water.comp[which(water.comp$lat<31),]


# Panel A - Meteoric Water Relationships
par(mfrow=c(3,3),mai=c(0.7,0.7,0.1,0.1))
plot(water.comp$d18O,water.comp$dD,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(-25,-5),ylim=c(-180,0),
     xlab="d18O",ylab="dD",las=1)

abline(a=10,b=8)

fit1 = lm(water.comp$dD~water.comp$d18O)

abline(a=coef(fit1)[1],b=coef(fit1)[2],lwd=2,lty=2,col="darkblue")
points(highlight$d18O,highlight$dD,pch=23,bg="lightblue",cex=1.5)

plot(water.comp$d18O,water.comp$d.excess,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(-25,-5),ylim=c(-10,25),
     xlab="d18O",ylab="d-excess",las=1)
abline(h=10)

points(highlight$D17O,highlight$d.excess,pch=23,bg="lightblue",cex=1.5)


prime18 = 1000*log(highlight$d18O[-(15:17)]/1000+1)
prime17 = highlight$D17O[-(15:17)]+0.528*prime18
 
plot(prime18,prime17,pch=23,bg="lightblue",cex=1.5,lwd=0.4,xlim=c(-28,-10),ylim=c(-14,-5),
           xlab="d'18O",ylab="d'17O",las=1)

fit17 = lm(prime17~prime18)
abline(a=0.015,b=0.5268)
abline(a=coef(fit17)[1],b=coef(fit17)[2],lwd=2,lty=2,col="darkblue")
summary(fit17)
points(prime18,prime17,pch=23,bg="lightblue",cex=1.5)



# Panel B - d18O
plot(water.comp$d18O,water.comp$..Elev,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(-25,-5),
     xlab="d18O",ylab="Elevation (m)",las=1)
points(highlight$d18O,highlight$..Elev,pch=23,bg="lightblue",cex=1.5)

plot(water.comp$d18O,water.comp$lat,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(-25,-5),ylim=c(26,33),
     xlab="d18O",ylab="Latitude",las=1)
points(highlight$d18O,highlight$lat,pch=23,bg="lightblue",cex=1.5)

plot(water.comp$d18O,water.comp$lon,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(-25,-5),ylim=c(75,110),
     xlab="d18O",ylab="Longitude",las=1)
points(highlight$d18O,highlight$lon,pch=23,bg="lightblue",cex=1.5)


# Panel C - D'17O
plot(water.comp$D17O,water.comp$..Elev,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(0.0,0.05),
     xlab="D'17O",ylab="Elevation (m)",las=1)
points(highlight$D17O,highlight$..Elev,pch=23,bg="lightblue",cex=1.5)

plot(water.comp$D17O,water.comp$lat,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(0.0,0.05),ylim=c(26,33),
     xlab="D'17O",ylab="Latitude",las=1)
points(highlight$D17O,highlight$lat,pch=23,bg="lightblue",cex=1.5)

plot(water.comp$D17O,water.comp$lon,cex=0.5,bg="lightblue",pch=21,lwd=0.4,xlim=c(0.0,0.05),ylim=c(75,110),
     xlab="D'17O",ylab="Longitude",las=1)
points(highlight$D17O,highlight$lon,pch=23,bg="lightblue",cex=1.5)

