function Sparicotyle_model(PAR,E)

%create figure
f12=figure('color','w','Position',[50 50 1100 700]);


% data
H=E.H;                                                                     % fish population
T_data=E.T;                                                                % water temperature (°C)
V=E.V;                                                                     % cage volume [m^3]
A=E.A;                                                                     % max number of adult parasites
J=E.J;                                                                     % max number of juvenile parasites



for cage=1:E.n_cage  %for loop on the number of cages

    %assign parametrs accounting for the parameters that changes across
    %cages
    mu_F_20=   PAR(E.index_start(1)+E.multiplePAR(1)*(cage-1));
    mu_F_par_20=PAR(E.index_start(2)+E.multiplePAR(2)*(cage-1));
    mu_a=      PAR(E.index_start(3)+E.multiplePAR(3)*(cage-1));
    mu_j=      PAR(E.index_start(4)+E.multiplePAR(4)*(cage-1));
    rho=       PAR(E.index_start(5)+E.multiplePAR(5)*(cage-1));
    f=         PAR(E.index_start(6)+E.multiplePAR(6)*(cage-1));
    theta_xi=  PAR(E.index_start(7)+E.multiplePAR(7)*(cage-1));
    xi20=      PAR(E.index_start(8)+E.multiplePAR(8)*(cage-1));
    mu_M=      PAR(E.index_start(9)+E.multiplePAR(9)*(cage-1));
    theta_r=   PAR(E.index_start(10)+E.multiplePAR(10)*(cage-1));
    r20=       PAR(E.index_start(11)+E.multiplePAR(11)*(cage-1));
    theta_beta=PAR(E.index_start(12)+E.multiplePAR(12)*(cage-1));
    beta20=    PAR(E.index_start(13)+E.multiplePAR(13)*(cage-1));
    theta=     PAR(E.index_start(14)+E.multiplePAR(14)*(cage-1));
    M0=        PAR(E.index_start(15)+E.multiplePAR(15)*(cage-1));


    %--------------------------------------------------------------------------
    % RUN DETERMINISTIC MODEL
    %--------------------------------------------------------------------------

    y0=[H zeros(1,J*A-1) 0 M0];                                            % initial conditions

    Neq_mat=J*A;                                                           % n. equations

    T_data=E.T(:,cage);                                                    % select temperature data of the cage 
    T_data=[T_data; T_data(end)];                                          % add value at the end to use interp1_fast function
    time_interp=[E.sample_time ;E.sample_time(end)+1];                     % time vector for interpolation function

    [t,y]=ode15s(@eqs,E.sample_time,y0);

    % RE_ARRANGE Results %
    x_i=y(:,1:J*A);                                                        % fish compartments
    F=reshape(x_i',J,A,[]);                                                % rows=Juveniles, col=adults, over time

    % sum over juveniles
    x_a= squeeze(sum(F,1))';

    %compute percentile of multinomial via MonteCarlo
    n_real=10000;                                                          %number of realizations
    median_n_t_a=zeros(length(E.sample_time),E.A);
    q025_n_t_a=zeros(length(E.sample_time),E.A);
    q975_n_t_a=zeros(length(E.sample_time),E.A);
    median_mean_abundance_t=zeros(length(E.sample_time),1);
    q025_mean_abundance_t=zeros(length(E.sample_time),1);
    q975_mean_abundance_t=zeros(length(E.sample_time),1);

    median_mean_intensity_t=zeros(length(E.sample_time),1);
    q025_mean_intensity_t=zeros(length(E.sample_time),1);
    q975_mean_intensity_t=zeros(length(E.sample_time),1);


    for kk=1:length(E.sample_time)
        prob=abs(x_a(kk,:))/sum(abs(x_a(kk,:)));
        pd = makedist('Multinomial','Probabilities',prob);
        rn=random(pd,n_real,E.sample_sz);
        mean_abundance=sum(rn-1,2)/E.sample_sz;
        mean_intensity=sum(rn-1,2)./sum(rn>1,2);

        median_mean_abundance_t(kk)=quantile(mean_abundance,0.5);
        q025_mean_abundance_t(kk)=quantile(mean_abundance,0.025);
        q975_mean_abundance_t(kk)=quantile(mean_abundance,0.975);

        if kk>1
            median_mean_intensity_t(kk)=quantile(mean_intensity,0.5);
            q025_mean_intensity_t(kk)=quantile(mean_intensity,0.025);
            q975_mean_intensity_t(kk)=quantile(mean_intensity,0.975);
        end

        for aa=1:E.A
            PP=sum(rn==aa,2);
            median_n_t_a(kk,aa)=quantile(PP,0.5);
            q025_n_t_a(kk,aa)=quantile(PP,0.025);
            q975_n_t_a(kk,aa)=quantile(PP,0.975);
        end
    end

    %cut the first element where intensity is not defined
    median_mean_intensity_t(1)=[];
    q025_mean_intensity_t(1)=[];
    q975_mean_intensity_t(1)=[];


    % PLOT DISTRIBUTION
    figure('Name',['Cage ' num2str(cage)],'color','w','Position',[50 50 1200 550])
    t_plot=datetime(E.sample_time,'ConvertFrom','datenum');
    for kk=1:length(t_plot)
        subplot(2,5,kk)
        patch([0:E.A-1 fliplr([0:E.A-1])],[q025_n_t_a(kk,:)./30*100 fliplr(q975_n_t_a(kk,:)./30*100)],[0.8 0.8 0.8],'EdgeColor','n') %[0.9 0.9 0.9]
        hold on
        plot(0:E.A-1,E.paras(:,kk,cage)*E.sample_sz./30*100,'o','markersize',4,'color','r','MarkerFaceColor','w','linewidth',2);
        plot(0:E.A-1,median_n_t_a(kk,:)./30*100,'color','black','linewidth',1)
        xlim([0 12])
        ylim([0 100])
        set(gca, 'fontsize',12)
        title(datestr(E.sample_time(kk)),'fontsize',12,'FontWeight','normal')
        box off
    end
    han=axes(gcf,'visible','off');
    han.XLabel.Visible='on';
    han.YLabel.Visible='on';
    ylabel(han,'Frequency in sample [%]');
    xlabel(han,'Parasite Abundance');
    set(gca, 'fontsize',12)


    mean_nfishes_model=sum(x_a,2);
    std_nfish=mean(std(E.nfishes,0,2));
    gauss_n_fish=zeros(length(E.sample_time),3);
    for kk=1:length(E.sample_time)
        gauss_n_fish(kk,:)=norminv([0.025 0.5 0.975],mean_nfishes_model(kk),std_nfish);
    end

    figure(f12)
    subplot(4,6,cage);
    patch([E.sample_time' fliplr(E.sample_time')],[gauss_n_fish(:,1)'./E.H fliplr(gauss_n_fish(:,3)'./E.H)],[0.8 0.8 0.8],'EdgeColor','n');
    hold on
    plot(E.sample_time,gauss_n_fish(:,2)./E.H,'-','color','black','linewidth',0.6)
    plot(E.sample_time,E.nfishes(:,cage)./E.nfishes(1,cage),'o','markersize',4,'color','r','MarkerFaceColor','w','linewidth',2);
    xlim([E.sample_time(1) E.sample_time(end)])
    set(gca,'fontsize',10,'ylim',[0.9 1])
    box off
    title(['Cage ' num2str(cage)],'fontsize',12,'FontWeight','normal')
    if cage==1
        datetick('x','mmm','keeplimits','keepticks')
        ylabel('Survival','fontsize',12)
    else
        set(gca,'Yticklabels',{})
    end
    set(gca,'Xticklabels',{})

    subplot(4,6,6+cage);
    patch([E.sample_time' fliplr(E.sample_time')],[1-q025_n_t_a(:,1)'./30 fliplr(1-q975_n_t_a(:,1)'./30)],[0.8 0.8 0.8],'EdgeColor','n')
    hold on
    plot(E.sample_time,1-median_n_t_a(:,1)./30,'-','color','black','linewidth',1)
    plot(E.sample_time,1-E.paras(1,:,cage),'o','markersize',4,'color','r','MarkerFaceColor','w','linewidth',2);
    datetick('x','mmm','keeplimits','keepticks')
    set(gca, 'fontsize',10,'ylim',[0 1])
    box off
    if cage==1
        ylabel('Prevalence','fontsize',12)
    else
        set(gca,'Yticklabels',{})
    end
    set(gca,'Xticklabels',{})

    subplot(4,6,12+cage);
    patch([E.sample_time' fliplr(E.sample_time')],[q025_mean_abundance_t' fliplr(q975_mean_abundance_t')],[0.8 0.8 0.8],'EdgeColor','n')
    hold on
    plot(E.sample_time,median_mean_abundance_t,'-','color','black','linewidth',1)
    plot(E.sample_time, sum(E.paras(:,:,cage).*((0:E.A-1)')) ,'o','markersize',4,'color','r','MarkerFaceColor','w','linewidth',2);
    set(gca, 'fontsize',10,'ylim',[0 7])
    box off
    if cage==1
        ylabel('Mean abundance','fontsize',12)
    else
        set(gca,'Yticklabels',{})
    end
    set(gca,'Xticklabels',{})


    subplot(4,6,18+cage);
    patch([E.sample_time(2:end)' fliplr(E.sample_time(2:end)')],[q025_mean_intensity_t' fliplr(q975_mean_intensity_t')],[0.8 0.8 0.8],'EdgeColor','n')
    hold on
    plot(E.sample_time(2:end),median_mean_intensity_t,'-','color','black','linewidth',1)
    plot(E.sample_time(2:end), sum(E.paras(2:end,2:end,cage).*((1:E.A-1)'))./ sum(E.paras(2:end,2:end,cage)) ,'o','markersize',4,'color','r','MarkerFaceColor','w','linewidth',2);
    datetick('x','mmm','keeplimits','keepticks')
    set(gca, 'fontsize',10,'ylim',[0 7])
    box off
    if cage==1
        ylabel('Mean intensity','fontsize',12)
    else
        set(gca,'Yticklabels',{})
    end
end


    function dy=eqs(t,y)

        T=interp1_fast(time_interp,T_data,t);                              % interpolate temperature

        function yi=interp1_fast(x,y,xi)
            %function that linearly interpolates 

            %INPUT PARAMETERS
            %x:.........x data points
            %y:.........y data points
            %xi:....... x value at which the function evaluate the corresponding yi
            %value through linear interpolation

            %OUTPUT
            %yi:........y value

            index=find(x<=xi,1,'last');
            yi=y(index)+(y(index+1)-y(index))*(xi-x(index))/(x(index+1)-x(index));
        end

        % temperature-dependet parameters
        mu_F=mu_F_20*theta^(T-20);
        mu_F_par=mu_F_par_20*theta^(T-20);
        beta=beta20*theta_beta^(T-20);
        xi=xi20*theta_xi^(T-20);
        r=r20*theta_r^(T-20);

        %
        X=y(1:Neq_mat);                                                    % fish compartments
        L=y(Neq_mat+1);                                                    % eggs compartment
        M=y(Neq_mat+2);                                                    % oncomiracidia compartment

        X=reshape(X,J,A);                                                  % fish matrix (J rows,A columns)
        % initialize dX
        dX=zeros(J,A);

        %-------------------------
        % FISH COMPARTMENT
        %-------------------------
        % Corners
        dX(1,1)= 1*mu_a*X(1,2)+1*mu_j*X(2,1)-((beta).*M/V+mu_F)*X(1,1);
        dX(J,1)=(beta).*M*X(J-1,1)/V+ 1*mu_a*X(J,2)-((J-1)*mu_j+(J-1)*r+mu_F)*X(J,1);
        dX(1,A)=1*r*X(2,A-1)+ 1*mu_j*X(2,A)-((A-1)*mu_a+(beta).*M/V+mu_F+(A-1)*mu_F_par)*X(1,A);
        dX(J,A)=(beta).*M*X(J-1,A)/V-((A-1)*mu_a+(J-1)*mu_j+mu_F+(A-1)*mu_F_par)*X(J,A);

        % Edges
        for col=2:A-1
            a=col-1;                                                       % number of adults
            alpha=a*mu_F_par;
            % first row
            dX(1,col)=1*r*X(2,col-1)+(a+1)*mu_a*X(1,col+1)+1*mu_j*X(2,col)-(a*mu_a+mu_F+(beta).*M/V+alpha)*X(1,col);
            % last row
            dX(J,col)=(beta).*M*X(J-1,col)/V+(a+1)*mu_a*X(J,col+1)-((J-1)*mu_j+a*mu_a+(J-1)*r+mu_F+alpha)*X(J,col);
        end

        for row=2:J-1
            j=row-1;                                                       % number of juveniles

            %first column
            dX(row,1)=(beta).*M*X(row-1,1)/V+1*mu_a*X(row,2)+(j+1)*mu_j*X(row+1,1)-(j*mu_j+j*r+mu_F+(beta).*M/V)*X(row,1);
            % last column
            alpha=(A-1)*mu_F_par;
            dX(row,A)=(j+1)*r*X(row+1,A-1)+(beta).*M*X(row-1,A)/V+(j+1)*mu_j*X(row+1,A)-(j*mu_j+(A-1)*mu_a+mu_F+(beta).*M/V+alpha)*X(row,A);
        end

        % central matrix: general equation
        for row=2:J-1
            for col=2:A-1
                j=row-1;                                                   % n. juveniles
                a=col-1;                                                   % n. adults
                alpha=a*mu_F_par;

                dX(row,col)=(j+1)*r*X(row+1,col-1)+(beta).*M*X(row-1,col)/V+(a+1)*mu_a*X(row,col+1)+(j+1)*mu_j*X(row+1,col)-(j*mu_j+a*mu_a+j*r+mu_F+alpha+(beta).*M/V)*X(row,col);
            end
        end

        % From matrix to vector
        dX=dX(:);

        %-------------------------
        % PARASITE COMPARTMENTS
        %-------------------------
        dE=rho*f*(1:A-1)*(sum(X(:,2:end)))'-xi*L;                          % eggs
        dM=xi*L-beta.*M*(sum(X(1:end-1,:),'all'))/V-mu_M*M;                % oncomiracidia

        % merge
        dy=[dX;dE;dM];
    end
end