clear all
close all

% This code run the analysis presented in 

% "A stratified compartmental model for the transmission of Sparicotyle chrysophrii (Platyhelminthes: Monogenea) in gilthead seabream (Sparus aurata) fish farms" 
% by Stella et al., Royal Society Open Science, 2023. doi:https://doi.org/10.1098/rsos.221377

% The code has been tested on Matlab R2019b

%--------------------------------------------------------------------------
%DATA
%--------------------------------------------------------------------------
E.n_cage=6;                                                                % total number of cages
E.sample_sz=30;                                                            % sample size (number of fish sampled)

% LOAD DATA FILE
% NTA_data.mat includes:
% 'fr' matrix: contains the number of parasites in each fish of the sample (30 rows),
%              at each sampling time (9 columns),
%              for each cage (third matrix dimension).
% 'table_stat30': contains 6 tables with other variables sampled in all 6 cages
%                 
paras_data=load('NTA_data.mat');

%----- Read parasite distribution data ('fr' matrix)
E.paras=paras_data.fr;                                                     % Parasites frequencies in the selected cage
E.yi=E.paras*E.sample_sz;                                                  % N. fishes with i parasites

%----- Read Other variables ('table_stat30')
paras_var_all=paras_data.table_stat30;

E.sample_time=datenum(paras_var_all{1,1}.Time);                            % Sample dates

%Reorganize dataset
E.T=nan(length(E.sample_time),E.n_cage);                                   % Temperature
E.nfishes=nan(length(E.sample_time),E.n_cage);                             % Number of fish in the cage

for k=1:E.n_cage
    E.T(:,k)=paras_var_all{k}.Temperature;
    E.nfishes(:,k)=paras_var_all{k}.(8);                                          % N. fishes in the cage
end

%--------------------------------------------------------------------------
% MODEL PARAMETERS
%--------------------------------------------------------------------------

% set parameters

E.H=10000;                                                                 % population
E.A=28;                                                                    % max number of adult parasites
E.J=12;                                                                    % max number of juvenile parasites
E.V=225;                                                                   % cage volume [m^3]
                                                                


E.n_PAR=15;                                                                % number of parameters
E.multiplePAR=false(E.n_PAR,1);                                            %if true the parameter is different for the different cages

%Parameters (see Table 1 of the paper for description)
E.multiplePAR(1)=1;      E.PAR_names{1}='\mu_{F_{20}}';     
E.multiplePAR(2)=0;      E.PAR_names{2}='\mu_{F''_{20}}'; 
E.multiplePAR(3)=0;      E.PAR_names{3}='\mu_a';    
E.multiplePAR(4)=0;      E.PAR_names{4}='\mu_j';     
E.multiplePAR(5)=0;      E.PAR_names{5}='\rho';     
E.multiplePAR(6)=0;      E.PAR_names{6}='f';         
E.multiplePAR(7)=0;      E.PAR_names{7}='\theta_{\xi}';     
E.multiplePAR(8)=0;      E.PAR_names{8}='\xi_{20}';     
E.multiplePAR(9)=0;      E.PAR_names{9}='\mu_M';    
E.multiplePAR(10)=0;     E.PAR_names{10}='\theta_r';      
E.multiplePAR(11)=0;     E.PAR_names{11}='r_{20}';     
E.multiplePAR(12)=0;     E.PAR_names{12}='\theta_{\beta}';  
E.multiplePAR(13)=1;     E.PAR_names{13}='\beta_{20}';  
E.multiplePAR(14)=0;     E.PAR_names{14}='\theta_{\mu_F}'; 
E.multiplePAR(15)=1;     E.PAR_names{15}='M_0'; 


                                                       
E.index_start=zeros(E.n_PAR,1);                                            % At which position in the PAR vector the i-th parameter starts (accounting for the multiple parametrs across cages)

j=0;
for i=1:E.n_PAR
    if E.multiplePAR(i)
        E.index_start(i)=j+1;
        for k=1:E.n_cage
            j=j+1;
            E.PAR_names_all{j}='';                                         % Names of all parameters (accounting also for parameters that vary across cages)
            E.PAR_names_all{j}=[E.PAR_names{i},num2str(k)];
        end
    else
        j=j+1;
        E.index_start(i)=j;
        E.PAR_names_all{j}=E.PAR_names{i};
    end
end

%load best parameters set
load best_par

%run model
Sparicotyle_model(best_par,E);

