suppressPackageStartupMessages({library(ggplot2)
  library(tidyr)
  library(plyr)
  library(dplyr)
  library(GenomicRanges)
})

args <- (commandArgs(trailingOnly = TRUE))

for (i in seq_len(length(args))) {
  eval(parse(text = args[[i]]))
}

# input_txt="output/bulkDNAseq_BGI/F20FTSAPHT0350_MUSyfqR/chr_cos/99/99_chr9_dp5.tsv"
# chr="chr9"
# sample_name=99
# bin_size=10000

print(input_txt)
print(chr)
print(sample_name)
print(out_snp_density_png)
print(out_bin_png)
print(bined_dp_tsv)
print(bin_size)
bin_size <- as.numeric(bin_size)

chr_gt <- readr::read_tsv(file = input_txt,
                          col_names = c("Pos","DP","AD","GT"))

head(chr_gt)
# chr_gt <- chr_gt %>% mutate(ALT_count = as.numeric(strsplit(AD[1],",")[[1]][1]),
#                   tol_count = as.numeric(strsplit(AD[1],",")[[1]][2]),
#                   AF = ALT_count/tol_count)
chr_gt$ALT_count <- as.numeric(sapply(strsplit(chr_gt$AD,","),`[[`,1))
#chr_gt$tot_count <- as.numeric(sapply(strsplit(chr_gt$AD,","),`[[`,2))
dna_mm10_seqinfo <- read.table(file = "references/wasp/data/dna-mm10/chrom_info/chromInfo.txt",
                               stringsAsFactors = F)
dna_mm10_seqinfo <- dna_mm10_seqinfo[dna_mm10_seqinfo$V1==chr,]
## create Granges object for chromosomes
seq_length <- dna_mm10_seqinfo$V2
names(seq_length) <- dna_mm10_seqinfo$V1
dna_mm10_gr <- GRanges(
  seqnames = Rle(c(dna_mm10_seqinfo$V1)),
  ranges = IRanges(1, end = dna_mm10_seqinfo$V2, names = c(dna_mm10_seqinfo$V1)),
  seqlengths = seq_length
  
)

dna_mm10_gr

snp_gr <- GRanges(seqnames = Rle(chr),
                  ranges = IRanges(start =chr_gt$Pos ,width = 1),
                  ALT_count = chr_gt$ALT_count,
                  tot_count = chr_gt$DP,
                  GT = chr_gt$GT,
                  seqinfo = seqinfo(dna_mm10_gr),
                  seqlengths = seqlengths(dna_mm10_gr))

snp_gr_rle_alt <- mcolAsRleList(snp_gr,"ALT_count")
snp_gr_rle_tot <- mcolAsRleList(snp_gr,"tot_count")

ALT_count_cov <- coverage(snp_gr,weight = "ALT_count" )
tot_count_cov <- coverage(snp_gr,weight = "tot_count" )

bindAsGRanges(ALT_count_cov)
bindAsGRanges(tot_count_cov)


tiles <- tileGenome(seqlengths(dna_mm10_gr),tilewidth = bin_size)

binned_dna_mm10_gr <- unlist(tiles)
binned_dna_mm10_gr

snp_counts <- countOverlaps(binned_dna_mm10_gr,snp_gr)
hist(snp_counts)

mcols(binned_dna_mm10_gr)$counts <- snp_counts


#dna_mm10_gap <- mm10_gap
band_mm10 <- data.frame(Chrom = seqnames(binned_dna_mm10_gr),
                        Start =start(binned_dna_mm10_gr),
                        End = end(binned_dna_mm10_gr),
                        snp_counts = binned_dna_mm10_gr$counts )
## only chrs



#chromPlot(dna_mm10_gap,annot1 = band_mm10,bands = band_mm10)
pp_df <- band_mm10[band_mm10$Chrom %in% paste0("chr",c(1:19,"X","Y")),] 
ggplot(data = pp_df)+
  geom_line(mapping = aes(y = snp_counts,x = Start))+
  facet_wrap(.~Chrom,scale="free",ncol = 1)+theme_classic()
#out_snp_density_png
ggsave(file = out_snp_density_png, width = 16, height = 4, dpi = 72)

############################



## bined AF
###########################

kk_alt <- binnedAverage(binned_dna_mm10_gr,ALT_count_cov,"ALT_count")

kk_tot <- binnedAverage(binned_dna_mm10_gr,tot_count_cov,"tot_count")

kk_tot$ALT_count <- kk_alt$ALT_count
kk_tot$BindAF <- kk_tot$ALT_count/kk_tot$tot_count

kk_tot[kk_tot$tot_count>0,]
plot


#dna_mm10_gap <- mm10_gap
plot_kk <- data.frame(Chrom = seqnames(kk_tot),
                        Start =start(kk_tot),
                        End = end(kk_tot),
                        AF = kk_tot$BindAF,
                      DP = kk_tot$tot_count*bin_size)
head(plot_kk)
ggplot(data = plot_kk)+
  geom_point(mapping = aes(y = DP,x = Start))+theme_classic()


#out_dp_png
ggsave(file = out_bin_png, width = 16, height = 4, dpi = 72)


write.table(x = plot_kk ,file = bined_dp_tsv,
            quote = F,row.names = F,col.names = T)
# write.table(x = all_cell_het_ratio_wc_sp,file = "output/outputR/WC-Sp_noisy-cells.txt",
#             quote = F,row.names = F,col.names = T)





