
suppressPackageStartupMessages({library(ggplot2)
  library(tidyr)
  library(plyr)
  library(dplyr)})

args <- (commandArgs(trailingOnly = TRUE))

for (i in seq_len(length(args))) {
  eval(parse(text = args[[i]]))
}

print(input_txt)
print(chr)
print(sample_name)

print(co_out)
print(extend_l)
print(out_dir)
# out_dir = "output/bulkDNAseq_BGI/F20FTSAPHT0350_MUSyfqR/chr_cos/co_only/99/"
extend_l <- as.numeric(extend_l)

plotCOregion <- function(sid = "154",chr = "chr1",co_pos = 173692788,
                         co_prev = 173692708,
                         extend = 10000,co_df ){
  # file_name <- paste0("output/bulkDNAseq_BGI/F20FTSAPHT0350_MUSyfqR/chr_cos/",
  #                     sid,"/",sid,"_",chr,"_dp5_vi.tsv")
  # co_df <- readr::read_table2(file = file_name,col_names = T,
  #                             col_types = c("ddccdccd"))
  head(co_df)
   co_df %>% filter(Pos >= (co_prev - extend) & Pos <=(co_pos + extend)) %>%         
    ggplot()+  geom_point(mapping = aes(x= Pos, y =  ALT_ratio,
                                        color = state))+
     ggrepel::geom_text_repel(mapping = 
                                aes(label = AD,
                                    x = Pos, 
                                    y =  ALT_ratio))+
     theme_classic()
  
}

#input_txt = "output/bulkDNAseq_BGI/F20FTSAPHT0350_MUSyfqR/chr_cos/99/99_chr9_dp5_vi.tsv"

chr_gt <- readr::read_table2(file = input_txt,col_names = T,
                          col_types = c("ddccdccd"))

head(chr_gt)


out_co <- chr_gt %>% mutate(CO = (lag(state) != state),
                            Prev = lag(Pos)) %>% filter(CO) 
for(a_pos in out_co$Pos){
  plotCOregion(sid=sid,chr = chr,co_pos = a_pos,
               extend = extend_l,
               co_prev = out_co$Prev[out_co$Pos==a_pos],
               co_df = chr_gt)
  ggsave(file = paste0(out_dir,chr,"_","Pos_",a_pos,".png"),
         width = 14,height = 4,dpi=72)
}

write.table(x = data.frame(c("Run finished")) ,file = co_out,
            quote = F,row.names = F,col.names = T)
# write.table(x = all_cell_het_ratio_wc_sp,file = "output/outputR/WC-Sp_noisy-cells.txt",
#             quote = F,row.names = F,col.names = T)
